/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/deploy/v1/cloud_deploy.proto

package com.google.cloud.deploy.v1;

public interface RepairRolloutRuleOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.deploy.v1.RepairRolloutRule)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Required. ID of the rule. This id must be unique in the `Automation`
   * resource to which this rule belongs. The format is `[a-z][a-z0-9&#92;-]{0,62}`.
   * </pre>
   *
   * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The id.
   */
  java.lang.String getId();
  /**
   *
   *
   * <pre>
   * Required. ID of the rule. This id must be unique in the `Automation`
   * resource to which this rule belongs. The format is `[a-z][a-z0-9&#92;-]{0,62}`.
   * </pre>
   *
   * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for id.
   */
  com.google.protobuf.ByteString getIdBytes();

  /**
   *
   *
   * <pre>
   * Optional. Phases within which jobs are subject to automatic repair actions
   * on failure. Proceeds only after phase name matched any one in the list, or
   * for all phases if unspecified. This value must consist of lower-case
   * letters, numbers, and hyphens, start with a letter and end with a letter or
   * a number, and have a max length of 63 characters. In other words, it must
   * match the following regex: `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
   * </pre>
   *
   * <code>repeated string source_phases = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return A list containing the sourcePhases.
   */
  java.util.List<java.lang.String> getSourcePhasesList();
  /**
   *
   *
   * <pre>
   * Optional. Phases within which jobs are subject to automatic repair actions
   * on failure. Proceeds only after phase name matched any one in the list, or
   * for all phases if unspecified. This value must consist of lower-case
   * letters, numbers, and hyphens, start with a letter and end with a letter or
   * a number, and have a max length of 63 characters. In other words, it must
   * match the following regex: `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
   * </pre>
   *
   * <code>repeated string source_phases = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The count of sourcePhases.
   */
  int getSourcePhasesCount();
  /**
   *
   *
   * <pre>
   * Optional. Phases within which jobs are subject to automatic repair actions
   * on failure. Proceeds only after phase name matched any one in the list, or
   * for all phases if unspecified. This value must consist of lower-case
   * letters, numbers, and hyphens, start with a letter and end with a letter or
   * a number, and have a max length of 63 characters. In other words, it must
   * match the following regex: `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
   * </pre>
   *
   * <code>repeated string source_phases = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the element to return.
   * @return The sourcePhases at the given index.
   */
  java.lang.String getSourcePhases(int index);
  /**
   *
   *
   * <pre>
   * Optional. Phases within which jobs are subject to automatic repair actions
   * on failure. Proceeds only after phase name matched any one in the list, or
   * for all phases if unspecified. This value must consist of lower-case
   * letters, numbers, and hyphens, start with a letter and end with a letter or
   * a number, and have a max length of 63 characters. In other words, it must
   * match the following regex: `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
   * </pre>
   *
   * <code>repeated string source_phases = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the sourcePhases at the given index.
   */
  com.google.protobuf.ByteString getSourcePhasesBytes(int index);

  /**
   *
   *
   * <pre>
   * Optional. Jobs to repair. Proceeds only after job name matched any one in
   * the list, or for all jobs if unspecified or empty. The phase that includes
   * the job must match the phase ID specified in `source_phase`. This value
   * must consist of lower-case letters, numbers, and hyphens, start with a
   * letter and end with a letter or a number, and have a max length of 63
   * characters. In other words, it must match the following regex:
   * `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
   * </pre>
   *
   * <code>repeated string jobs = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return A list containing the jobs.
   */
  java.util.List<java.lang.String> getJobsList();
  /**
   *
   *
   * <pre>
   * Optional. Jobs to repair. Proceeds only after job name matched any one in
   * the list, or for all jobs if unspecified or empty. The phase that includes
   * the job must match the phase ID specified in `source_phase`. This value
   * must consist of lower-case letters, numbers, and hyphens, start with a
   * letter and end with a letter or a number, and have a max length of 63
   * characters. In other words, it must match the following regex:
   * `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
   * </pre>
   *
   * <code>repeated string jobs = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The count of jobs.
   */
  int getJobsCount();
  /**
   *
   *
   * <pre>
   * Optional. Jobs to repair. Proceeds only after job name matched any one in
   * the list, or for all jobs if unspecified or empty. The phase that includes
   * the job must match the phase ID specified in `source_phase`. This value
   * must consist of lower-case letters, numbers, and hyphens, start with a
   * letter and end with a letter or a number, and have a max length of 63
   * characters. In other words, it must match the following regex:
   * `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
   * </pre>
   *
   * <code>repeated string jobs = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the element to return.
   * @return The jobs at the given index.
   */
  java.lang.String getJobs(int index);
  /**
   *
   *
   * <pre>
   * Optional. Jobs to repair. Proceeds only after job name matched any one in
   * the list, or for all jobs if unspecified or empty. The phase that includes
   * the job must match the phase ID specified in `source_phase`. This value
   * must consist of lower-case letters, numbers, and hyphens, start with a
   * letter and end with a letter or a number, and have a max length of 63
   * characters. In other words, it must match the following regex:
   * `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
   * </pre>
   *
   * <code>repeated string jobs = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the jobs at the given index.
   */
  com.google.protobuf.ByteString getJobsBytes(int index);

  /**
   *
   *
   * <pre>
   * Required. Defines the types of automatic repair actions for failed jobs.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.RepairMode repair_modes = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  java.util.List<com.google.cloud.deploy.v1.RepairMode> getRepairModesList();
  /**
   *
   *
   * <pre>
   * Required. Defines the types of automatic repair actions for failed jobs.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.RepairMode repair_modes = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  com.google.cloud.deploy.v1.RepairMode getRepairModes(int index);
  /**
   *
   *
   * <pre>
   * Required. Defines the types of automatic repair actions for failed jobs.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.RepairMode repair_modes = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  int getRepairModesCount();
  /**
   *
   *
   * <pre>
   * Required. Defines the types of automatic repair actions for failed jobs.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.RepairMode repair_modes = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  java.util.List<? extends com.google.cloud.deploy.v1.RepairModeOrBuilder>
      getRepairModesOrBuilderList();
  /**
   *
   *
   * <pre>
   * Required. Defines the types of automatic repair actions for failed jobs.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.RepairMode repair_modes = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  com.google.cloud.deploy.v1.RepairModeOrBuilder getRepairModesOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * Output only. Information around the state of the 'Automation' rule.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.AutomationRuleCondition condition = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the condition field is set.
   */
  boolean hasCondition();
  /**
   *
   *
   * <pre>
   * Output only. Information around the state of the 'Automation' rule.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.AutomationRuleCondition condition = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The condition.
   */
  com.google.cloud.deploy.v1.AutomationRuleCondition getCondition();
  /**
   *
   *
   * <pre>
   * Output only. Information around the state of the 'Automation' rule.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.AutomationRuleCondition condition = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.cloud.deploy.v1.AutomationRuleConditionOrBuilder getConditionOrBuilder();
}
