/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/deploy/v1/cloud_deploy.proto

package com.google.cloud.deploy.v1;

/**
 *
 *
 * <pre>
 * RetryAttempt represents an action of retrying the failed Cloud Deploy job.
 * </pre>
 *
 * Protobuf type {@code google.cloud.deploy.v1.RetryAttempt}
 */
public final class RetryAttempt extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.deploy.v1.RetryAttempt)
    RetryAttemptOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RetryAttempt.newBuilder() to construct.
  private RetryAttempt(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RetryAttempt() {
    state_ = 0;
    stateDesc_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RetryAttempt();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.deploy.v1.CloudDeployProto
        .internal_static_google_cloud_deploy_v1_RetryAttempt_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.deploy.v1.CloudDeployProto
        .internal_static_google_cloud_deploy_v1_RetryAttempt_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.deploy.v1.RetryAttempt.class,
            com.google.cloud.deploy.v1.RetryAttempt.Builder.class);
  }

  public static final int ATTEMPT_FIELD_NUMBER = 1;
  private long attempt_ = 0L;
  /**
   *
   *
   * <pre>
   * Output only. The index of this retry attempt.
   * </pre>
   *
   * <code>int64 attempt = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The attempt.
   */
  @java.lang.Override
  public long getAttempt() {
    return attempt_;
  }

  public static final int WAIT_FIELD_NUMBER = 2;
  private com.google.protobuf.Duration wait_;
  /**
   *
   *
   * <pre>
   * Output only. How long the operation will be paused.
   * </pre>
   *
   * <code>.google.protobuf.Duration wait = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return Whether the wait field is set.
   */
  @java.lang.Override
  public boolean hasWait() {
    return wait_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. How long the operation will be paused.
   * </pre>
   *
   * <code>.google.protobuf.Duration wait = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The wait.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getWait() {
    return wait_ == null ? com.google.protobuf.Duration.getDefaultInstance() : wait_;
  }
  /**
   *
   *
   * <pre>
   * Output only. How long the operation will be paused.
   * </pre>
   *
   * <code>.google.protobuf.Duration wait = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getWaitOrBuilder() {
    return wait_ == null ? com.google.protobuf.Duration.getDefaultInstance() : wait_;
  }

  public static final int STATE_FIELD_NUMBER = 5;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. Valid state of this retry action.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.RepairState state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Valid state of this retry action.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.RepairState state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.RepairState getState() {
    com.google.cloud.deploy.v1.RepairState result =
        com.google.cloud.deploy.v1.RepairState.forNumber(state_);
    return result == null ? com.google.cloud.deploy.v1.RepairState.UNRECOGNIZED : result;
  }

  public static final int STATE_DESC_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object stateDesc_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Description of the state of the Retry.
   * </pre>
   *
   * <code>string state_desc = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The stateDesc.
   */
  @java.lang.Override
  public java.lang.String getStateDesc() {
    java.lang.Object ref = stateDesc_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      stateDesc_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Description of the state of the Retry.
   * </pre>
   *
   * <code>string state_desc = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for stateDesc.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStateDescBytes() {
    java.lang.Object ref = stateDesc_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      stateDesc_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (attempt_ != 0L) {
      output.writeInt64(1, attempt_);
    }
    if (wait_ != null) {
      output.writeMessage(2, getWait());
    }
    if (state_ != com.google.cloud.deploy.v1.RepairState.REPAIR_STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(5, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(stateDesc_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, stateDesc_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (attempt_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(1, attempt_);
    }
    if (wait_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getWait());
    }
    if (state_ != com.google.cloud.deploy.v1.RepairState.REPAIR_STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(stateDesc_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, stateDesc_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.deploy.v1.RetryAttempt)) {
      return super.equals(obj);
    }
    com.google.cloud.deploy.v1.RetryAttempt other = (com.google.cloud.deploy.v1.RetryAttempt) obj;

    if (getAttempt() != other.getAttempt()) return false;
    if (hasWait() != other.hasWait()) return false;
    if (hasWait()) {
      if (!getWait().equals(other.getWait())) return false;
    }
    if (state_ != other.state_) return false;
    if (!getStateDesc().equals(other.getStateDesc())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ATTEMPT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getAttempt());
    if (hasWait()) {
      hash = (37 * hash) + WAIT_FIELD_NUMBER;
      hash = (53 * hash) + getWait().hashCode();
    }
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (37 * hash) + STATE_DESC_FIELD_NUMBER;
    hash = (53 * hash) + getStateDesc().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.deploy.v1.RetryAttempt parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.RetryAttempt parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.RetryAttempt parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.RetryAttempt parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.RetryAttempt parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.RetryAttempt parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.RetryAttempt parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.RetryAttempt parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.RetryAttempt parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.RetryAttempt parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.RetryAttempt parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.RetryAttempt parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.deploy.v1.RetryAttempt prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * RetryAttempt represents an action of retrying the failed Cloud Deploy job.
   * </pre>
   *
   * Protobuf type {@code google.cloud.deploy.v1.RetryAttempt}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.deploy.v1.RetryAttempt)
      com.google.cloud.deploy.v1.RetryAttemptOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_RetryAttempt_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_RetryAttempt_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.deploy.v1.RetryAttempt.class,
              com.google.cloud.deploy.v1.RetryAttempt.Builder.class);
    }

    // Construct using com.google.cloud.deploy.v1.RetryAttempt.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      attempt_ = 0L;
      wait_ = null;
      if (waitBuilder_ != null) {
        waitBuilder_.dispose();
        waitBuilder_ = null;
      }
      state_ = 0;
      stateDesc_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_RetryAttempt_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.RetryAttempt getDefaultInstanceForType() {
      return com.google.cloud.deploy.v1.RetryAttempt.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.RetryAttempt build() {
      com.google.cloud.deploy.v1.RetryAttempt result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.RetryAttempt buildPartial() {
      com.google.cloud.deploy.v1.RetryAttempt result =
          new com.google.cloud.deploy.v1.RetryAttempt(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.deploy.v1.RetryAttempt result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.attempt_ = attempt_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.wait_ = waitBuilder_ == null ? wait_ : waitBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.stateDesc_ = stateDesc_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.deploy.v1.RetryAttempt) {
        return mergeFrom((com.google.cloud.deploy.v1.RetryAttempt) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.deploy.v1.RetryAttempt other) {
      if (other == com.google.cloud.deploy.v1.RetryAttempt.getDefaultInstance()) return this;
      if (other.getAttempt() != 0L) {
        setAttempt(other.getAttempt());
      }
      if (other.hasWait()) {
        mergeWait(other.getWait());
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (!other.getStateDesc().isEmpty()) {
        stateDesc_ = other.stateDesc_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                attempt_ = input.readInt64();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 18:
              {
                input.readMessage(getWaitFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 40:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 40
            case 50:
              {
                stateDesc_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private long attempt_;
    /**
     *
     *
     * <pre>
     * Output only. The index of this retry attempt.
     * </pre>
     *
     * <code>int64 attempt = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The attempt.
     */
    @java.lang.Override
    public long getAttempt() {
      return attempt_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The index of this retry attempt.
     * </pre>
     *
     * <code>int64 attempt = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The attempt to set.
     * @return This builder for chaining.
     */
    public Builder setAttempt(long value) {

      attempt_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The index of this retry attempt.
     * </pre>
     *
     * <code>int64 attempt = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAttempt() {
      bitField0_ = (bitField0_ & ~0x00000001);
      attempt_ = 0L;
      onChanged();
      return this;
    }

    private com.google.protobuf.Duration wait_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        waitBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. How long the operation will be paused.
     * </pre>
     *
     * <code>.google.protobuf.Duration wait = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return Whether the wait field is set.
     */
    public boolean hasWait() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. How long the operation will be paused.
     * </pre>
     *
     * <code>.google.protobuf.Duration wait = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The wait.
     */
    public com.google.protobuf.Duration getWait() {
      if (waitBuilder_ == null) {
        return wait_ == null ? com.google.protobuf.Duration.getDefaultInstance() : wait_;
      } else {
        return waitBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. How long the operation will be paused.
     * </pre>
     *
     * <code>.google.protobuf.Duration wait = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setWait(com.google.protobuf.Duration value) {
      if (waitBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        wait_ = value;
      } else {
        waitBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. How long the operation will be paused.
     * </pre>
     *
     * <code>.google.protobuf.Duration wait = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setWait(com.google.protobuf.Duration.Builder builderForValue) {
      if (waitBuilder_ == null) {
        wait_ = builderForValue.build();
      } else {
        waitBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. How long the operation will be paused.
     * </pre>
     *
     * <code>.google.protobuf.Duration wait = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder mergeWait(com.google.protobuf.Duration value) {
      if (waitBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && wait_ != null
            && wait_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getWaitBuilder().mergeFrom(value);
        } else {
          wait_ = value;
        }
      } else {
        waitBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. How long the operation will be paused.
     * </pre>
     *
     * <code>.google.protobuf.Duration wait = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder clearWait() {
      bitField0_ = (bitField0_ & ~0x00000002);
      wait_ = null;
      if (waitBuilder_ != null) {
        waitBuilder_.dispose();
        waitBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. How long the operation will be paused.
     * </pre>
     *
     * <code>.google.protobuf.Duration wait = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.protobuf.Duration.Builder getWaitBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getWaitFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. How long the operation will be paused.
     * </pre>
     *
     * <code>.google.protobuf.Duration wait = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.protobuf.DurationOrBuilder getWaitOrBuilder() {
      if (waitBuilder_ != null) {
        return waitBuilder_.getMessageOrBuilder();
      } else {
        return wait_ == null ? com.google.protobuf.Duration.getDefaultInstance() : wait_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. How long the operation will be paused.
     * </pre>
     *
     * <code>.google.protobuf.Duration wait = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getWaitFieldBuilder() {
      if (waitBuilder_ == null) {
        waitBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getWait(), getParentForChildren(), isClean());
        wait_ = null;
      }
      return waitBuilder_;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. Valid state of this retry action.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.RepairState state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Valid state of this retry action.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.RepairState state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Valid state of this retry action.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.RepairState state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.RepairState getState() {
      com.google.cloud.deploy.v1.RepairState result =
          com.google.cloud.deploy.v1.RepairState.forNumber(state_);
      return result == null ? com.google.cloud.deploy.v1.RepairState.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. Valid state of this retry action.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.RepairState state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.deploy.v1.RepairState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Valid state of this retry action.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.RepairState state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000004);
      state_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object stateDesc_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Description of the state of the Retry.
     * </pre>
     *
     * <code>string state_desc = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The stateDesc.
     */
    public java.lang.String getStateDesc() {
      java.lang.Object ref = stateDesc_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        stateDesc_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Description of the state of the Retry.
     * </pre>
     *
     * <code>string state_desc = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for stateDesc.
     */
    public com.google.protobuf.ByteString getStateDescBytes() {
      java.lang.Object ref = stateDesc_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        stateDesc_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Description of the state of the Retry.
     * </pre>
     *
     * <code>string state_desc = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The stateDesc to set.
     * @return This builder for chaining.
     */
    public Builder setStateDesc(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      stateDesc_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Description of the state of the Retry.
     * </pre>
     *
     * <code>string state_desc = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStateDesc() {
      stateDesc_ = getDefaultInstance().getStateDesc();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Description of the state of the Retry.
     * </pre>
     *
     * <code>string state_desc = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for stateDesc to set.
     * @return This builder for chaining.
     */
    public Builder setStateDescBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      stateDesc_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.deploy.v1.RetryAttempt)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.deploy.v1.RetryAttempt)
  private static final com.google.cloud.deploy.v1.RetryAttempt DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.deploy.v1.RetryAttempt();
  }

  public static com.google.cloud.deploy.v1.RetryAttempt getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RetryAttempt> PARSER =
      new com.google.protobuf.AbstractParser<RetryAttempt>() {
        @java.lang.Override
        public RetryAttempt parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RetryAttempt> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RetryAttempt> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.deploy.v1.RetryAttempt getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
