/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/deploy/v1/cloud_deploy.proto

package com.google.cloud.deploy.v1;

/**
 *
 *
 * <pre>
 * A `Rollout` resource in the Cloud Deploy API.
 *
 * A `Rollout` contains information around a specific deployment to a `Target`.
 * </pre>
 *
 * Protobuf type {@code google.cloud.deploy.v1.Rollout}
 */
public final class Rollout extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.deploy.v1.Rollout)
    RolloutOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Rollout.newBuilder() to construct.
  private Rollout(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Rollout() {
    name_ = "";
    uid_ = "";
    description_ = "";
    targetId_ = "";
    approvalState_ = 0;
    state_ = 0;
    failureReason_ = "";
    deployingBuild_ = "";
    etag_ = "";
    deployFailureCause_ = 0;
    phases_ = java.util.Collections.emptyList();
    controllerRollout_ = "";
    rollbackOfRollout_ = "";
    rolledBackByRollouts_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Rollout();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.deploy.v1.CloudDeployProto
        .internal_static_google_cloud_deploy_v1_Rollout_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 4:
        return internalGetAnnotations();
      case 5:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.deploy.v1.CloudDeployProto
        .internal_static_google_cloud_deploy_v1_Rollout_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.deploy.v1.Rollout.class,
            com.google.cloud.deploy.v1.Rollout.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Valid approval states of a `Rollout`.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.deploy.v1.Rollout.ApprovalState}
   */
  public enum ApprovalState implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The `Rollout` has an unspecified approval state.
     * </pre>
     *
     * <code>APPROVAL_STATE_UNSPECIFIED = 0;</code>
     */
    APPROVAL_STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The `Rollout` requires approval.
     * </pre>
     *
     * <code>NEEDS_APPROVAL = 1;</code>
     */
    NEEDS_APPROVAL(1),
    /**
     *
     *
     * <pre>
     * The `Rollout` does not require approval.
     * </pre>
     *
     * <code>DOES_NOT_NEED_APPROVAL = 2;</code>
     */
    DOES_NOT_NEED_APPROVAL(2),
    /**
     *
     *
     * <pre>
     * The `Rollout` has been approved.
     * </pre>
     *
     * <code>APPROVED = 3;</code>
     */
    APPROVED(3),
    /**
     *
     *
     * <pre>
     * The `Rollout` has been rejected.
     * </pre>
     *
     * <code>REJECTED = 4;</code>
     */
    REJECTED(4),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The `Rollout` has an unspecified approval state.
     * </pre>
     *
     * <code>APPROVAL_STATE_UNSPECIFIED = 0;</code>
     */
    public static final int APPROVAL_STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The `Rollout` requires approval.
     * </pre>
     *
     * <code>NEEDS_APPROVAL = 1;</code>
     */
    public static final int NEEDS_APPROVAL_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The `Rollout` does not require approval.
     * </pre>
     *
     * <code>DOES_NOT_NEED_APPROVAL = 2;</code>
     */
    public static final int DOES_NOT_NEED_APPROVAL_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The `Rollout` has been approved.
     * </pre>
     *
     * <code>APPROVED = 3;</code>
     */
    public static final int APPROVED_VALUE = 3;
    /**
     *
     *
     * <pre>
     * The `Rollout` has been rejected.
     * </pre>
     *
     * <code>REJECTED = 4;</code>
     */
    public static final int REJECTED_VALUE = 4;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ApprovalState valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ApprovalState forNumber(int value) {
      switch (value) {
        case 0:
          return APPROVAL_STATE_UNSPECIFIED;
        case 1:
          return NEEDS_APPROVAL;
        case 2:
          return DOES_NOT_NEED_APPROVAL;
        case 3:
          return APPROVED;
        case 4:
          return REJECTED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ApprovalState> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ApprovalState> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<ApprovalState>() {
          public ApprovalState findValueByNumber(int number) {
            return ApprovalState.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.deploy.v1.Rollout.getDescriptor().getEnumTypes().get(0);
    }

    private static final ApprovalState[] VALUES = values();

    public static ApprovalState valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ApprovalState(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.deploy.v1.Rollout.ApprovalState)
  }

  /**
   *
   *
   * <pre>
   * Valid states of a `Rollout`.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.deploy.v1.Rollout.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The `Rollout` has an unspecified state.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The `Rollout` has completed successfully.
     * </pre>
     *
     * <code>SUCCEEDED = 1;</code>
     */
    SUCCEEDED(1),
    /**
     *
     *
     * <pre>
     * The `Rollout` has failed.
     * </pre>
     *
     * <code>FAILED = 2;</code>
     */
    FAILED(2),
    /**
     *
     *
     * <pre>
     * The `Rollout` is being deployed.
     * </pre>
     *
     * <code>IN_PROGRESS = 3;</code>
     */
    IN_PROGRESS(3),
    /**
     *
     *
     * <pre>
     * The `Rollout` needs approval.
     * </pre>
     *
     * <code>PENDING_APPROVAL = 4;</code>
     */
    PENDING_APPROVAL(4),
    /**
     *
     *
     * <pre>
     * An approver rejected the `Rollout`.
     * </pre>
     *
     * <code>APPROVAL_REJECTED = 5;</code>
     */
    APPROVAL_REJECTED(5),
    /**
     *
     *
     * <pre>
     * The `Rollout` is waiting for an earlier Rollout(s) to complete on this
     * `Target`.
     * </pre>
     *
     * <code>PENDING = 6;</code>
     */
    PENDING(6),
    /**
     *
     *
     * <pre>
     * The `Rollout` is waiting for the `Release` to be fully rendered.
     * </pre>
     *
     * <code>PENDING_RELEASE = 7;</code>
     */
    PENDING_RELEASE(7),
    /**
     *
     *
     * <pre>
     * The `Rollout` is in the process of being cancelled.
     * </pre>
     *
     * <code>CANCELLING = 8;</code>
     */
    CANCELLING(8),
    /**
     *
     *
     * <pre>
     * The `Rollout` has been cancelled.
     * </pre>
     *
     * <code>CANCELLED = 9;</code>
     */
    CANCELLED(9),
    /**
     *
     *
     * <pre>
     * The `Rollout` is halted.
     * </pre>
     *
     * <code>HALTED = 10;</code>
     */
    HALTED(10),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The `Rollout` has an unspecified state.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The `Rollout` has completed successfully.
     * </pre>
     *
     * <code>SUCCEEDED = 1;</code>
     */
    public static final int SUCCEEDED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The `Rollout` has failed.
     * </pre>
     *
     * <code>FAILED = 2;</code>
     */
    public static final int FAILED_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The `Rollout` is being deployed.
     * </pre>
     *
     * <code>IN_PROGRESS = 3;</code>
     */
    public static final int IN_PROGRESS_VALUE = 3;
    /**
     *
     *
     * <pre>
     * The `Rollout` needs approval.
     * </pre>
     *
     * <code>PENDING_APPROVAL = 4;</code>
     */
    public static final int PENDING_APPROVAL_VALUE = 4;
    /**
     *
     *
     * <pre>
     * An approver rejected the `Rollout`.
     * </pre>
     *
     * <code>APPROVAL_REJECTED = 5;</code>
     */
    public static final int APPROVAL_REJECTED_VALUE = 5;
    /**
     *
     *
     * <pre>
     * The `Rollout` is waiting for an earlier Rollout(s) to complete on this
     * `Target`.
     * </pre>
     *
     * <code>PENDING = 6;</code>
     */
    public static final int PENDING_VALUE = 6;
    /**
     *
     *
     * <pre>
     * The `Rollout` is waiting for the `Release` to be fully rendered.
     * </pre>
     *
     * <code>PENDING_RELEASE = 7;</code>
     */
    public static final int PENDING_RELEASE_VALUE = 7;
    /**
     *
     *
     * <pre>
     * The `Rollout` is in the process of being cancelled.
     * </pre>
     *
     * <code>CANCELLING = 8;</code>
     */
    public static final int CANCELLING_VALUE = 8;
    /**
     *
     *
     * <pre>
     * The `Rollout` has been cancelled.
     * </pre>
     *
     * <code>CANCELLED = 9;</code>
     */
    public static final int CANCELLED_VALUE = 9;
    /**
     *
     *
     * <pre>
     * The `Rollout` is halted.
     * </pre>
     *
     * <code>HALTED = 10;</code>
     */
    public static final int HALTED_VALUE = 10;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return SUCCEEDED;
        case 2:
          return FAILED;
        case 3:
          return IN_PROGRESS;
        case 4:
          return PENDING_APPROVAL;
        case 5:
          return APPROVAL_REJECTED;
        case 6:
          return PENDING;
        case 7:
          return PENDING_RELEASE;
        case 8:
          return CANCELLING;
        case 9:
          return CANCELLED;
        case 10:
          return HALTED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.deploy.v1.Rollout.getDescriptor().getEnumTypes().get(1);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.deploy.v1.Rollout.State)
  }

  /**
   *
   *
   * <pre>
   * Well-known rollout failures.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.deploy.v1.Rollout.FailureCause}
   */
  public enum FailureCause implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * No reason for failure is specified.
     * </pre>
     *
     * <code>FAILURE_CAUSE_UNSPECIFIED = 0;</code>
     */
    FAILURE_CAUSE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Cloud Build is not available, either because it is not enabled or because
     * Cloud Deploy has insufficient permissions. See [required
     * permission](https://cloud.google.com/deploy/docs/cloud-deploy-service-account#required_permissions).
     * </pre>
     *
     * <code>CLOUD_BUILD_UNAVAILABLE = 1;</code>
     */
    CLOUD_BUILD_UNAVAILABLE(1),
    /**
     *
     *
     * <pre>
     * The deploy operation did not complete successfully; check Cloud Build
     * logs.
     * </pre>
     *
     * <code>EXECUTION_FAILED = 2;</code>
     */
    EXECUTION_FAILED(2),
    /**
     *
     *
     * <pre>
     * Deployment did not complete within the alloted time.
     * </pre>
     *
     * <code>DEADLINE_EXCEEDED = 3;</code>
     */
    DEADLINE_EXCEEDED(3),
    /**
     *
     *
     * <pre>
     * Release is in a failed state.
     * </pre>
     *
     * <code>RELEASE_FAILED = 4;</code>
     */
    RELEASE_FAILED(4),
    /**
     *
     *
     * <pre>
     * Release is abandoned.
     * </pre>
     *
     * <code>RELEASE_ABANDONED = 5;</code>
     */
    RELEASE_ABANDONED(5),
    /**
     *
     *
     * <pre>
     * No skaffold verify configuration was found.
     * </pre>
     *
     * <code>VERIFICATION_CONFIG_NOT_FOUND = 6;</code>
     */
    VERIFICATION_CONFIG_NOT_FOUND(6),
    /**
     *
     *
     * <pre>
     * Cloud Build failed to fulfill Cloud Deploy's request. See failure_message
     * for additional details.
     * </pre>
     *
     * <code>CLOUD_BUILD_REQUEST_FAILED = 7;</code>
     */
    CLOUD_BUILD_REQUEST_FAILED(7),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * No reason for failure is specified.
     * </pre>
     *
     * <code>FAILURE_CAUSE_UNSPECIFIED = 0;</code>
     */
    public static final int FAILURE_CAUSE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Cloud Build is not available, either because it is not enabled or because
     * Cloud Deploy has insufficient permissions. See [required
     * permission](https://cloud.google.com/deploy/docs/cloud-deploy-service-account#required_permissions).
     * </pre>
     *
     * <code>CLOUD_BUILD_UNAVAILABLE = 1;</code>
     */
    public static final int CLOUD_BUILD_UNAVAILABLE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The deploy operation did not complete successfully; check Cloud Build
     * logs.
     * </pre>
     *
     * <code>EXECUTION_FAILED = 2;</code>
     */
    public static final int EXECUTION_FAILED_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Deployment did not complete within the alloted time.
     * </pre>
     *
     * <code>DEADLINE_EXCEEDED = 3;</code>
     */
    public static final int DEADLINE_EXCEEDED_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Release is in a failed state.
     * </pre>
     *
     * <code>RELEASE_FAILED = 4;</code>
     */
    public static final int RELEASE_FAILED_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Release is abandoned.
     * </pre>
     *
     * <code>RELEASE_ABANDONED = 5;</code>
     */
    public static final int RELEASE_ABANDONED_VALUE = 5;
    /**
     *
     *
     * <pre>
     * No skaffold verify configuration was found.
     * </pre>
     *
     * <code>VERIFICATION_CONFIG_NOT_FOUND = 6;</code>
     */
    public static final int VERIFICATION_CONFIG_NOT_FOUND_VALUE = 6;
    /**
     *
     *
     * <pre>
     * Cloud Build failed to fulfill Cloud Deploy's request. See failure_message
     * for additional details.
     * </pre>
     *
     * <code>CLOUD_BUILD_REQUEST_FAILED = 7;</code>
     */
    public static final int CLOUD_BUILD_REQUEST_FAILED_VALUE = 7;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static FailureCause valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static FailureCause forNumber(int value) {
      switch (value) {
        case 0:
          return FAILURE_CAUSE_UNSPECIFIED;
        case 1:
          return CLOUD_BUILD_UNAVAILABLE;
        case 2:
          return EXECUTION_FAILED;
        case 3:
          return DEADLINE_EXCEEDED;
        case 4:
          return RELEASE_FAILED;
        case 5:
          return RELEASE_ABANDONED;
        case 6:
          return VERIFICATION_CONFIG_NOT_FOUND;
        case 7:
          return CLOUD_BUILD_REQUEST_FAILED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<FailureCause> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<FailureCause> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<FailureCause>() {
          public FailureCause findValueByNumber(int number) {
            return FailureCause.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.deploy.v1.Rollout.getDescriptor().getEnumTypes().get(2);
    }

    private static final FailureCause[] VALUES = values();

    public static FailureCause valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private FailureCause(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.deploy.v1.Rollout.FailureCause)
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Optional. Name of the `Rollout`. Format is
   * `projects/{project}/locations/{location}/deliveryPipelines/{deliveryPipeline}/releases/{release}/rollouts/[a-z][a-z0-9&#92;-]{0,62}`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Name of the `Rollout`. Format is
   * `projects/{project}/locations/{location}/deliveryPipelines/{deliveryPipeline}/releases/{release}/rollouts/[a-z][a-z0-9&#92;-]{0,62}`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int UID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object uid_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Unique identifier of the `Rollout`.
   * </pre>
   *
   * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The uid.
   */
  @java.lang.Override
  public java.lang.String getUid() {
    java.lang.Object ref = uid_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      uid_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Unique identifier of the `Rollout`.
   * </pre>
   *
   * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for uid.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUidBytes() {
    java.lang.Object ref = uid_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      uid_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * Description of the `Rollout` for user purposes. Max length is 255
   * characters.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Description of the `Rollout` for user purposes. Max length is 255
   * characters.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ANNOTATIONS_FIELD_NUMBER = 4;

  private static final class AnnotationsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.deploy.v1.CloudDeployProto
                .internal_static_google_cloud_deploy_v1_Rollout_AnnotationsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> annotations_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetAnnotations() {
    if (annotations_ == null) {
      return com.google.protobuf.MapField.emptyMapField(AnnotationsDefaultEntryHolder.defaultEntry);
    }
    return annotations_;
  }

  public int getAnnotationsCount() {
    return internalGetAnnotations().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * User annotations. These attributes can only be set and used by the
   * user, and not by Cloud Deploy. See https://google.aip.dev/128#annotations
   * for more details such as format and size limitations.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 4;</code>
   */
  @java.lang.Override
  public boolean containsAnnotations(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetAnnotations().getMap().containsKey(key);
  }
  /** Use {@link #getAnnotationsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getAnnotations() {
    return getAnnotationsMap();
  }
  /**
   *
   *
   * <pre>
   * User annotations. These attributes can only be set and used by the
   * user, and not by Cloud Deploy. See https://google.aip.dev/128#annotations
   * for more details such as format and size limitations.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 4;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getAnnotationsMap() {
    return internalGetAnnotations().getMap();
  }
  /**
   *
   *
   * <pre>
   * User annotations. These attributes can only be set and used by the
   * user, and not by Cloud Deploy. See https://google.aip.dev/128#annotations
   * for more details such as format and size limitations.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 4;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getAnnotationsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * User annotations. These attributes can only be set and used by the
   * user, and not by Cloud Deploy. See https://google.aip.dev/128#annotations
   * for more details such as format and size limitations.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 4;</code>
   */
  @java.lang.Override
  public java.lang.String getAnnotationsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int LABELS_FIELD_NUMBER = 5;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.deploy.v1.CloudDeployProto
                .internal_static_google_cloud_deploy_v1_Rollout_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Labels are attributes that can be set and used by both the
   * user and by Cloud Deploy. Labels must meet the following constraints:
   *
   * * Keys and values can contain only lowercase letters, numeric characters,
   * underscores, and dashes.
   * * All characters must use UTF-8 encoding, and international characters are
   * allowed.
   * * Keys must start with a lowercase letter or international character.
   * * Each resource is limited to a maximum of 64 labels.
   *
   * Both keys and values are additionally constrained to be &lt;= 128 bytes.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Labels are attributes that can be set and used by both the
   * user and by Cloud Deploy. Labels must meet the following constraints:
   *
   * * Keys and values can contain only lowercase letters, numeric characters,
   * underscores, and dashes.
   * * All characters must use UTF-8 encoding, and international characters are
   * allowed.
   * * Keys must start with a lowercase letter or international character.
   * * Each resource is limited to a maximum of 64 labels.
   *
   * Both keys and values are additionally constrained to be &lt;= 128 bytes.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Labels are attributes that can be set and used by both the
   * user and by Cloud Deploy. Labels must meet the following constraints:
   *
   * * Keys and values can contain only lowercase letters, numeric characters,
   * underscores, and dashes.
   * * All characters must use UTF-8 encoding, and international characters are
   * allowed.
   * * Keys must start with a lowercase letter or international character.
   * * Each resource is limited to a maximum of 64 labels.
   *
   * Both keys and values are additionally constrained to be &lt;= 128 bytes.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Labels are attributes that can be set and used by both the
   * user and by Cloud Deploy. Labels must meet the following constraints:
   *
   * * Keys and values can contain only lowercase letters, numeric characters,
   * underscores, and dashes.
   * * All characters must use UTF-8 encoding, and international characters are
   * allowed.
   * * Keys must start with a lowercase letter or international character.
   * * Each resource is limited to a maximum of 64 labels.
   *
   * Both keys and values are additionally constrained to be &lt;= 128 bytes.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 6;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Time at which the `Rollout` was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time at which the `Rollout` was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time at which the `Rollout` was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int APPROVE_TIME_FIELD_NUMBER = 7;
  private com.google.protobuf.Timestamp approveTime_;
  /**
   *
   *
   * <pre>
   * Output only. Time at which the `Rollout` was approved.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp approve_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the approveTime field is set.
   */
  @java.lang.Override
  public boolean hasApproveTime() {
    return approveTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time at which the `Rollout` was approved.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp approve_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The approveTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getApproveTime() {
    return approveTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : approveTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time at which the `Rollout` was approved.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp approve_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getApproveTimeOrBuilder() {
    return approveTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : approveTime_;
  }

  public static final int ENQUEUE_TIME_FIELD_NUMBER = 8;
  private com.google.protobuf.Timestamp enqueueTime_;
  /**
   *
   *
   * <pre>
   * Output only. Time at which the `Rollout` was enqueued.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp enqueue_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the enqueueTime field is set.
   */
  @java.lang.Override
  public boolean hasEnqueueTime() {
    return enqueueTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time at which the `Rollout` was enqueued.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp enqueue_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enqueueTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getEnqueueTime() {
    return enqueueTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : enqueueTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time at which the `Rollout` was enqueued.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp enqueue_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getEnqueueTimeOrBuilder() {
    return enqueueTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : enqueueTime_;
  }

  public static final int DEPLOY_START_TIME_FIELD_NUMBER = 9;
  private com.google.protobuf.Timestamp deployStartTime_;
  /**
   *
   *
   * <pre>
   * Output only. Time at which the `Rollout` started deploying.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp deploy_start_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the deployStartTime field is set.
   */
  @java.lang.Override
  public boolean hasDeployStartTime() {
    return deployStartTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time at which the `Rollout` started deploying.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp deploy_start_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The deployStartTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getDeployStartTime() {
    return deployStartTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : deployStartTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time at which the `Rollout` started deploying.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp deploy_start_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getDeployStartTimeOrBuilder() {
    return deployStartTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : deployStartTime_;
  }

  public static final int DEPLOY_END_TIME_FIELD_NUMBER = 10;
  private com.google.protobuf.Timestamp deployEndTime_;
  /**
   *
   *
   * <pre>
   * Output only. Time at which the `Rollout` finished deploying.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp deploy_end_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the deployEndTime field is set.
   */
  @java.lang.Override
  public boolean hasDeployEndTime() {
    return deployEndTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time at which the `Rollout` finished deploying.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp deploy_end_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The deployEndTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getDeployEndTime() {
    return deployEndTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : deployEndTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time at which the `Rollout` finished deploying.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp deploy_end_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getDeployEndTimeOrBuilder() {
    return deployEndTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : deployEndTime_;
  }

  public static final int TARGET_ID_FIELD_NUMBER = 18;

  @SuppressWarnings("serial")
  private volatile java.lang.Object targetId_ = "";
  /**
   *
   *
   * <pre>
   * Required. The ID of Target to which this `Rollout` is deploying.
   * </pre>
   *
   * <code>string target_id = 18 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The targetId.
   */
  @java.lang.Override
  public java.lang.String getTargetId() {
    java.lang.Object ref = targetId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      targetId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The ID of Target to which this `Rollout` is deploying.
   * </pre>
   *
   * <code>string target_id = 18 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for targetId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTargetIdBytes() {
    java.lang.Object ref = targetId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      targetId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int APPROVAL_STATE_FIELD_NUMBER = 12;
  private int approvalState_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. Approval state of the `Rollout`.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.Rollout.ApprovalState approval_state = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for approvalState.
   */
  @java.lang.Override
  public int getApprovalStateValue() {
    return approvalState_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Approval state of the `Rollout`.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.Rollout.ApprovalState approval_state = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The approvalState.
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.Rollout.ApprovalState getApprovalState() {
    com.google.cloud.deploy.v1.Rollout.ApprovalState result =
        com.google.cloud.deploy.v1.Rollout.ApprovalState.forNumber(approvalState_);
    return result == null ? com.google.cloud.deploy.v1.Rollout.ApprovalState.UNRECOGNIZED : result;
  }

  public static final int STATE_FIELD_NUMBER = 13;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. Current state of the `Rollout`.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.Rollout.State state = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Current state of the `Rollout`.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.Rollout.State state = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.Rollout.State getState() {
    com.google.cloud.deploy.v1.Rollout.State result =
        com.google.cloud.deploy.v1.Rollout.State.forNumber(state_);
    return result == null ? com.google.cloud.deploy.v1.Rollout.State.UNRECOGNIZED : result;
  }

  public static final int FAILURE_REASON_FIELD_NUMBER = 14;

  @SuppressWarnings("serial")
  private volatile java.lang.Object failureReason_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Additional information about the rollout failure, if
   * available.
   * </pre>
   *
   * <code>string failure_reason = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The failureReason.
   */
  @java.lang.Override
  public java.lang.String getFailureReason() {
    java.lang.Object ref = failureReason_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      failureReason_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Additional information about the rollout failure, if
   * available.
   * </pre>
   *
   * <code>string failure_reason = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for failureReason.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFailureReasonBytes() {
    java.lang.Object ref = failureReason_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      failureReason_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DEPLOYING_BUILD_FIELD_NUMBER = 17;

  @SuppressWarnings("serial")
  private volatile java.lang.Object deployingBuild_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the Cloud Build `Build` object that is
   * used to deploy the Rollout. Format is
   * `projects/{project}/locations/{location}/builds/{build}`.
   * </pre>
   *
   * <code>
   * string deploying_build = 17 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The deployingBuild.
   */
  @java.lang.Override
  public java.lang.String getDeployingBuild() {
    java.lang.Object ref = deployingBuild_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      deployingBuild_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the Cloud Build `Build` object that is
   * used to deploy the Rollout. Format is
   * `projects/{project}/locations/{location}/builds/{build}`.
   * </pre>
   *
   * <code>
   * string deploying_build = 17 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for deployingBuild.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDeployingBuildBytes() {
    java.lang.Object ref = deployingBuild_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      deployingBuild_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ETAG_FIELD_NUMBER = 16;

  @SuppressWarnings("serial")
  private volatile java.lang.Object etag_ = "";
  /**
   *
   *
   * <pre>
   * This checksum is computed by the server based on the value of other
   * fields, and may be sent on update and delete requests to ensure the
   * client has an up-to-date value before proceeding.
   * </pre>
   *
   * <code>string etag = 16;</code>
   *
   * @return The etag.
   */
  @java.lang.Override
  public java.lang.String getEtag() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      etag_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * This checksum is computed by the server based on the value of other
   * fields, and may be sent on update and delete requests to ensure the
   * client has an up-to-date value before proceeding.
   * </pre>
   *
   * <code>string etag = 16;</code>
   *
   * @return The bytes for etag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEtagBytes() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      etag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DEPLOY_FAILURE_CAUSE_FIELD_NUMBER = 19;
  private int deployFailureCause_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The reason this rollout failed. This will always be
   * unspecified while the rollout is in progress.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.Rollout.FailureCause deploy_failure_cause = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for deployFailureCause.
   */
  @java.lang.Override
  public int getDeployFailureCauseValue() {
    return deployFailureCause_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The reason this rollout failed. This will always be
   * unspecified while the rollout is in progress.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.Rollout.FailureCause deploy_failure_cause = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The deployFailureCause.
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.Rollout.FailureCause getDeployFailureCause() {
    com.google.cloud.deploy.v1.Rollout.FailureCause result =
        com.google.cloud.deploy.v1.Rollout.FailureCause.forNumber(deployFailureCause_);
    return result == null ? com.google.cloud.deploy.v1.Rollout.FailureCause.UNRECOGNIZED : result;
  }

  public static final int PHASES_FIELD_NUMBER = 23;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.deploy.v1.Phase> phases_;
  /**
   *
   *
   * <pre>
   * Output only. The phases that represent the workflows of this `Rollout`.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.Phase phases = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.deploy.v1.Phase> getPhasesList() {
    return phases_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The phases that represent the workflows of this `Rollout`.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.Phase phases = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.deploy.v1.PhaseOrBuilder>
      getPhasesOrBuilderList() {
    return phases_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The phases that represent the workflows of this `Rollout`.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.Phase phases = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getPhasesCount() {
    return phases_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. The phases that represent the workflows of this `Rollout`.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.Phase phases = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.Phase getPhases(int index) {
    return phases_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. The phases that represent the workflows of this `Rollout`.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.Phase phases = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.PhaseOrBuilder getPhasesOrBuilder(int index) {
    return phases_.get(index);
  }

  public static final int METADATA_FIELD_NUMBER = 24;
  private com.google.cloud.deploy.v1.Metadata metadata_;
  /**
   *
   *
   * <pre>
   * Output only. Metadata contains information about the rollout.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.Metadata metadata = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the metadata field is set.
   */
  @java.lang.Override
  public boolean hasMetadata() {
    return metadata_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Metadata contains information about the rollout.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.Metadata metadata = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The metadata.
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.Metadata getMetadata() {
    return metadata_ == null ? com.google.cloud.deploy.v1.Metadata.getDefaultInstance() : metadata_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Metadata contains information about the rollout.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.Metadata metadata = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.MetadataOrBuilder getMetadataOrBuilder() {
    return metadata_ == null ? com.google.cloud.deploy.v1.Metadata.getDefaultInstance() : metadata_;
  }

  public static final int CONTROLLER_ROLLOUT_FIELD_NUMBER = 25;

  @SuppressWarnings("serial")
  private volatile java.lang.Object controllerRollout_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Name of the `ControllerRollout`. Format is
   * `projects/{project}/locations/{location}/deliveryPipelines/{deliveryPipeline}/releases/{release}/rollouts/[a-z][a-z0-9&#92;-]{0,62}`.
   * </pre>
   *
   * <code>string controller_rollout = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The controllerRollout.
   */
  @java.lang.Override
  public java.lang.String getControllerRollout() {
    java.lang.Object ref = controllerRollout_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      controllerRollout_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Name of the `ControllerRollout`. Format is
   * `projects/{project}/locations/{location}/deliveryPipelines/{deliveryPipeline}/releases/{release}/rollouts/[a-z][a-z0-9&#92;-]{0,62}`.
   * </pre>
   *
   * <code>string controller_rollout = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for controllerRollout.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getControllerRolloutBytes() {
    java.lang.Object ref = controllerRollout_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      controllerRollout_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ROLLBACK_OF_ROLLOUT_FIELD_NUMBER = 26;

  @SuppressWarnings("serial")
  private volatile java.lang.Object rollbackOfRollout_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Name of the `Rollout` that is rolled back by this `Rollout`.
   * Empty if this `Rollout` wasn't created as a rollback.
   * </pre>
   *
   * <code>string rollback_of_rollout = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The rollbackOfRollout.
   */
  @java.lang.Override
  public java.lang.String getRollbackOfRollout() {
    java.lang.Object ref = rollbackOfRollout_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      rollbackOfRollout_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Name of the `Rollout` that is rolled back by this `Rollout`.
   * Empty if this `Rollout` wasn't created as a rollback.
   * </pre>
   *
   * <code>string rollback_of_rollout = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for rollbackOfRollout.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRollbackOfRolloutBytes() {
    java.lang.Object ref = rollbackOfRollout_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      rollbackOfRollout_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ROLLED_BACK_BY_ROLLOUTS_FIELD_NUMBER = 27;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList rolledBackByRollouts_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Output only. Names of `Rollouts` that rolled back this `Rollout`.
   * </pre>
   *
   * <code>
   * repeated string rolled_back_by_rollouts = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return A list containing the rolledBackByRollouts.
   */
  public com.google.protobuf.ProtocolStringList getRolledBackByRolloutsList() {
    return rolledBackByRollouts_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Names of `Rollouts` that rolled back this `Rollout`.
   * </pre>
   *
   * <code>
   * repeated string rolled_back_by_rollouts = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The count of rolledBackByRollouts.
   */
  public int getRolledBackByRolloutsCount() {
    return rolledBackByRollouts_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Names of `Rollouts` that rolled back this `Rollout`.
   * </pre>
   *
   * <code>
   * repeated string rolled_back_by_rollouts = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The rolledBackByRollouts at the given index.
   */
  public java.lang.String getRolledBackByRollouts(int index) {
    return rolledBackByRollouts_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. Names of `Rollouts` that rolled back this `Rollout`.
   * </pre>
   *
   * <code>
   * repeated string rolled_back_by_rollouts = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the rolledBackByRollouts at the given index.
   */
  public com.google.protobuf.ByteString getRolledBackByRolloutsBytes(int index) {
    return rolledBackByRollouts_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uid_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, uid_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, description_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetAnnotations(), AnnotationsDefaultEntryHolder.defaultEntry, 4);
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 5);
    if (createTime_ != null) {
      output.writeMessage(6, getCreateTime());
    }
    if (approveTime_ != null) {
      output.writeMessage(7, getApproveTime());
    }
    if (enqueueTime_ != null) {
      output.writeMessage(8, getEnqueueTime());
    }
    if (deployStartTime_ != null) {
      output.writeMessage(9, getDeployStartTime());
    }
    if (deployEndTime_ != null) {
      output.writeMessage(10, getDeployEndTime());
    }
    if (approvalState_
        != com.google.cloud.deploy.v1.Rollout.ApprovalState.APPROVAL_STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(12, approvalState_);
    }
    if (state_ != com.google.cloud.deploy.v1.Rollout.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(13, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(failureReason_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 14, failureReason_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 16, etag_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(deployingBuild_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 17, deployingBuild_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(targetId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 18, targetId_);
    }
    if (deployFailureCause_
        != com.google.cloud.deploy.v1.Rollout.FailureCause.FAILURE_CAUSE_UNSPECIFIED.getNumber()) {
      output.writeEnum(19, deployFailureCause_);
    }
    for (int i = 0; i < phases_.size(); i++) {
      output.writeMessage(23, phases_.get(i));
    }
    if (metadata_ != null) {
      output.writeMessage(24, getMetadata());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(controllerRollout_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 25, controllerRollout_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(rollbackOfRollout_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 26, rollbackOfRollout_);
    }
    for (int i = 0; i < rolledBackByRollouts_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 27, rolledBackByRollouts_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uid_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, uid_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, description_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetAnnotations().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> annotations__ =
          AnnotationsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, annotations__);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, labels__);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getCreateTime());
    }
    if (approveTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getApproveTime());
    }
    if (enqueueTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getEnqueueTime());
    }
    if (deployStartTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getDeployStartTime());
    }
    if (deployEndTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getDeployEndTime());
    }
    if (approvalState_
        != com.google.cloud.deploy.v1.Rollout.ApprovalState.APPROVAL_STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(12, approvalState_);
    }
    if (state_ != com.google.cloud.deploy.v1.Rollout.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(13, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(failureReason_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(14, failureReason_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(16, etag_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(deployingBuild_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(17, deployingBuild_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(targetId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(18, targetId_);
    }
    if (deployFailureCause_
        != com.google.cloud.deploy.v1.Rollout.FailureCause.FAILURE_CAUSE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(19, deployFailureCause_);
    }
    for (int i = 0; i < phases_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(23, phases_.get(i));
    }
    if (metadata_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(24, getMetadata());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(controllerRollout_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(25, controllerRollout_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(rollbackOfRollout_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(26, rollbackOfRollout_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < rolledBackByRollouts_.size(); i++) {
        dataSize += computeStringSizeNoTag(rolledBackByRollouts_.getRaw(i));
      }
      size += dataSize;
      size += 2 * getRolledBackByRolloutsList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.deploy.v1.Rollout)) {
      return super.equals(obj);
    }
    com.google.cloud.deploy.v1.Rollout other = (com.google.cloud.deploy.v1.Rollout) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getUid().equals(other.getUid())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (!internalGetAnnotations().equals(other.internalGetAnnotations())) return false;
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasApproveTime() != other.hasApproveTime()) return false;
    if (hasApproveTime()) {
      if (!getApproveTime().equals(other.getApproveTime())) return false;
    }
    if (hasEnqueueTime() != other.hasEnqueueTime()) return false;
    if (hasEnqueueTime()) {
      if (!getEnqueueTime().equals(other.getEnqueueTime())) return false;
    }
    if (hasDeployStartTime() != other.hasDeployStartTime()) return false;
    if (hasDeployStartTime()) {
      if (!getDeployStartTime().equals(other.getDeployStartTime())) return false;
    }
    if (hasDeployEndTime() != other.hasDeployEndTime()) return false;
    if (hasDeployEndTime()) {
      if (!getDeployEndTime().equals(other.getDeployEndTime())) return false;
    }
    if (!getTargetId().equals(other.getTargetId())) return false;
    if (approvalState_ != other.approvalState_) return false;
    if (state_ != other.state_) return false;
    if (!getFailureReason().equals(other.getFailureReason())) return false;
    if (!getDeployingBuild().equals(other.getDeployingBuild())) return false;
    if (!getEtag().equals(other.getEtag())) return false;
    if (deployFailureCause_ != other.deployFailureCause_) return false;
    if (!getPhasesList().equals(other.getPhasesList())) return false;
    if (hasMetadata() != other.hasMetadata()) return false;
    if (hasMetadata()) {
      if (!getMetadata().equals(other.getMetadata())) return false;
    }
    if (!getControllerRollout().equals(other.getControllerRollout())) return false;
    if (!getRollbackOfRollout().equals(other.getRollbackOfRollout())) return false;
    if (!getRolledBackByRolloutsList().equals(other.getRolledBackByRolloutsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + UID_FIELD_NUMBER;
    hash = (53 * hash) + getUid().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    if (!internalGetAnnotations().getMap().isEmpty()) {
      hash = (37 * hash) + ANNOTATIONS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetAnnotations().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasApproveTime()) {
      hash = (37 * hash) + APPROVE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getApproveTime().hashCode();
    }
    if (hasEnqueueTime()) {
      hash = (37 * hash) + ENQUEUE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getEnqueueTime().hashCode();
    }
    if (hasDeployStartTime()) {
      hash = (37 * hash) + DEPLOY_START_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getDeployStartTime().hashCode();
    }
    if (hasDeployEndTime()) {
      hash = (37 * hash) + DEPLOY_END_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getDeployEndTime().hashCode();
    }
    hash = (37 * hash) + TARGET_ID_FIELD_NUMBER;
    hash = (53 * hash) + getTargetId().hashCode();
    hash = (37 * hash) + APPROVAL_STATE_FIELD_NUMBER;
    hash = (53 * hash) + approvalState_;
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (37 * hash) + FAILURE_REASON_FIELD_NUMBER;
    hash = (53 * hash) + getFailureReason().hashCode();
    hash = (37 * hash) + DEPLOYING_BUILD_FIELD_NUMBER;
    hash = (53 * hash) + getDeployingBuild().hashCode();
    hash = (37 * hash) + ETAG_FIELD_NUMBER;
    hash = (53 * hash) + getEtag().hashCode();
    hash = (37 * hash) + DEPLOY_FAILURE_CAUSE_FIELD_NUMBER;
    hash = (53 * hash) + deployFailureCause_;
    if (getPhasesCount() > 0) {
      hash = (37 * hash) + PHASES_FIELD_NUMBER;
      hash = (53 * hash) + getPhasesList().hashCode();
    }
    if (hasMetadata()) {
      hash = (37 * hash) + METADATA_FIELD_NUMBER;
      hash = (53 * hash) + getMetadata().hashCode();
    }
    hash = (37 * hash) + CONTROLLER_ROLLOUT_FIELD_NUMBER;
    hash = (53 * hash) + getControllerRollout().hashCode();
    hash = (37 * hash) + ROLLBACK_OF_ROLLOUT_FIELD_NUMBER;
    hash = (53 * hash) + getRollbackOfRollout().hashCode();
    if (getRolledBackByRolloutsCount() > 0) {
      hash = (37 * hash) + ROLLED_BACK_BY_ROLLOUTS_FIELD_NUMBER;
      hash = (53 * hash) + getRolledBackByRolloutsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.deploy.v1.Rollout parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.Rollout parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.Rollout parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.Rollout parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.Rollout parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.Rollout parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.Rollout parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.Rollout parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.Rollout parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.Rollout parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.Rollout parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.Rollout parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.deploy.v1.Rollout prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A `Rollout` resource in the Cloud Deploy API.
   *
   * A `Rollout` contains information around a specific deployment to a `Target`.
   * </pre>
   *
   * Protobuf type {@code google.cloud.deploy.v1.Rollout}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.deploy.v1.Rollout)
      com.google.cloud.deploy.v1.RolloutOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_Rollout_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 4:
          return internalGetAnnotations();
        case 5:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 4:
          return internalGetMutableAnnotations();
        case 5:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_Rollout_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.deploy.v1.Rollout.class,
              com.google.cloud.deploy.v1.Rollout.Builder.class);
    }

    // Construct using com.google.cloud.deploy.v1.Rollout.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      uid_ = "";
      description_ = "";
      internalGetMutableAnnotations().clear();
      internalGetMutableLabels().clear();
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      approveTime_ = null;
      if (approveTimeBuilder_ != null) {
        approveTimeBuilder_.dispose();
        approveTimeBuilder_ = null;
      }
      enqueueTime_ = null;
      if (enqueueTimeBuilder_ != null) {
        enqueueTimeBuilder_.dispose();
        enqueueTimeBuilder_ = null;
      }
      deployStartTime_ = null;
      if (deployStartTimeBuilder_ != null) {
        deployStartTimeBuilder_.dispose();
        deployStartTimeBuilder_ = null;
      }
      deployEndTime_ = null;
      if (deployEndTimeBuilder_ != null) {
        deployEndTimeBuilder_.dispose();
        deployEndTimeBuilder_ = null;
      }
      targetId_ = "";
      approvalState_ = 0;
      state_ = 0;
      failureReason_ = "";
      deployingBuild_ = "";
      etag_ = "";
      deployFailureCause_ = 0;
      if (phasesBuilder_ == null) {
        phases_ = java.util.Collections.emptyList();
      } else {
        phases_ = null;
        phasesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00020000);
      metadata_ = null;
      if (metadataBuilder_ != null) {
        metadataBuilder_.dispose();
        metadataBuilder_ = null;
      }
      controllerRollout_ = "";
      rollbackOfRollout_ = "";
      rolledBackByRollouts_ = com.google.protobuf.LazyStringArrayList.emptyList();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_Rollout_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.Rollout getDefaultInstanceForType() {
      return com.google.cloud.deploy.v1.Rollout.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.Rollout build() {
      com.google.cloud.deploy.v1.Rollout result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.Rollout buildPartial() {
      com.google.cloud.deploy.v1.Rollout result = new com.google.cloud.deploy.v1.Rollout(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.deploy.v1.Rollout result) {
      if (phasesBuilder_ == null) {
        if (((bitField0_ & 0x00020000) != 0)) {
          phases_ = java.util.Collections.unmodifiableList(phases_);
          bitField0_ = (bitField0_ & ~0x00020000);
        }
        result.phases_ = phases_;
      } else {
        result.phases_ = phasesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.deploy.v1.Rollout result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.uid_ = uid_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.annotations_ = internalGetAnnotations();
        result.annotations_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.approveTime_ =
            approveTimeBuilder_ == null ? approveTime_ : approveTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.enqueueTime_ =
            enqueueTimeBuilder_ == null ? enqueueTime_ : enqueueTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.deployStartTime_ =
            deployStartTimeBuilder_ == null ? deployStartTime_ : deployStartTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.deployEndTime_ =
            deployEndTimeBuilder_ == null ? deployEndTime_ : deployEndTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.targetId_ = targetId_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.approvalState_ = approvalState_;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.failureReason_ = failureReason_;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.deployingBuild_ = deployingBuild_;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.etag_ = etag_;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.deployFailureCause_ = deployFailureCause_;
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        result.metadata_ = metadataBuilder_ == null ? metadata_ : metadataBuilder_.build();
      }
      if (((from_bitField0_ & 0x00080000) != 0)) {
        result.controllerRollout_ = controllerRollout_;
      }
      if (((from_bitField0_ & 0x00100000) != 0)) {
        result.rollbackOfRollout_ = rollbackOfRollout_;
      }
      if (((from_bitField0_ & 0x00200000) != 0)) {
        rolledBackByRollouts_.makeImmutable();
        result.rolledBackByRollouts_ = rolledBackByRollouts_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.deploy.v1.Rollout) {
        return mergeFrom((com.google.cloud.deploy.v1.Rollout) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.deploy.v1.Rollout other) {
      if (other == com.google.cloud.deploy.v1.Rollout.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getUid().isEmpty()) {
        uid_ = other.uid_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      internalGetMutableAnnotations().mergeFrom(other.internalGetAnnotations());
      bitField0_ |= 0x00000008;
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000010;
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasApproveTime()) {
        mergeApproveTime(other.getApproveTime());
      }
      if (other.hasEnqueueTime()) {
        mergeEnqueueTime(other.getEnqueueTime());
      }
      if (other.hasDeployStartTime()) {
        mergeDeployStartTime(other.getDeployStartTime());
      }
      if (other.hasDeployEndTime()) {
        mergeDeployEndTime(other.getDeployEndTime());
      }
      if (!other.getTargetId().isEmpty()) {
        targetId_ = other.targetId_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      if (other.approvalState_ != 0) {
        setApprovalStateValue(other.getApprovalStateValue());
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (!other.getFailureReason().isEmpty()) {
        failureReason_ = other.failureReason_;
        bitField0_ |= 0x00002000;
        onChanged();
      }
      if (!other.getDeployingBuild().isEmpty()) {
        deployingBuild_ = other.deployingBuild_;
        bitField0_ |= 0x00004000;
        onChanged();
      }
      if (!other.getEtag().isEmpty()) {
        etag_ = other.etag_;
        bitField0_ |= 0x00008000;
        onChanged();
      }
      if (other.deployFailureCause_ != 0) {
        setDeployFailureCauseValue(other.getDeployFailureCauseValue());
      }
      if (phasesBuilder_ == null) {
        if (!other.phases_.isEmpty()) {
          if (phases_.isEmpty()) {
            phases_ = other.phases_;
            bitField0_ = (bitField0_ & ~0x00020000);
          } else {
            ensurePhasesIsMutable();
            phases_.addAll(other.phases_);
          }
          onChanged();
        }
      } else {
        if (!other.phases_.isEmpty()) {
          if (phasesBuilder_.isEmpty()) {
            phasesBuilder_.dispose();
            phasesBuilder_ = null;
            phases_ = other.phases_;
            bitField0_ = (bitField0_ & ~0x00020000);
            phasesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getPhasesFieldBuilder()
                    : null;
          } else {
            phasesBuilder_.addAllMessages(other.phases_);
          }
        }
      }
      if (other.hasMetadata()) {
        mergeMetadata(other.getMetadata());
      }
      if (!other.getControllerRollout().isEmpty()) {
        controllerRollout_ = other.controllerRollout_;
        bitField0_ |= 0x00080000;
        onChanged();
      }
      if (!other.getRollbackOfRollout().isEmpty()) {
        rollbackOfRollout_ = other.rollbackOfRollout_;
        bitField0_ |= 0x00100000;
        onChanged();
      }
      if (!other.rolledBackByRollouts_.isEmpty()) {
        if (rolledBackByRollouts_.isEmpty()) {
          rolledBackByRollouts_ = other.rolledBackByRollouts_;
          bitField0_ |= 0x00200000;
        } else {
          ensureRolledBackByRolloutsIsMutable();
          rolledBackByRollouts_.addAll(other.rolledBackByRollouts_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                uid_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> annotations__ =
                    input.readMessage(
                        AnnotationsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableAnnotations()
                    .getMutableMap()
                    .put(annotations__.getKey(), annotations__.getValue());
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getApproveTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getEnqueueTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(getDeployStartTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 74
            case 82:
              {
                input.readMessage(getDeployEndTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 82
            case 96:
              {
                approvalState_ = input.readEnum();
                bitField0_ |= 0x00000800;
                break;
              } // case 96
            case 104:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00001000;
                break;
              } // case 104
            case 114:
              {
                failureReason_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00002000;
                break;
              } // case 114
            case 130:
              {
                etag_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00008000;
                break;
              } // case 130
            case 138:
              {
                deployingBuild_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00004000;
                break;
              } // case 138
            case 146:
              {
                targetId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case 146
            case 152:
              {
                deployFailureCause_ = input.readEnum();
                bitField0_ |= 0x00010000;
                break;
              } // case 152
            case 186:
              {
                com.google.cloud.deploy.v1.Phase m =
                    input.readMessage(com.google.cloud.deploy.v1.Phase.parser(), extensionRegistry);
                if (phasesBuilder_ == null) {
                  ensurePhasesIsMutable();
                  phases_.add(m);
                } else {
                  phasesBuilder_.addMessage(m);
                }
                break;
              } // case 186
            case 194:
              {
                input.readMessage(getMetadataFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00040000;
                break;
              } // case 194
            case 202:
              {
                controllerRollout_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00080000;
                break;
              } // case 202
            case 210:
              {
                rollbackOfRollout_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00100000;
                break;
              } // case 210
            case 218:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureRolledBackByRolloutsIsMutable();
                rolledBackByRollouts_.add(s);
                break;
              } // case 218
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Name of the `Rollout`. Format is
     * `projects/{project}/locations/{location}/deliveryPipelines/{deliveryPipeline}/releases/{release}/rollouts/[a-z][a-z0-9&#92;-]{0,62}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Name of the `Rollout`. Format is
     * `projects/{project}/locations/{location}/deliveryPipelines/{deliveryPipeline}/releases/{release}/rollouts/[a-z][a-z0-9&#92;-]{0,62}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Name of the `Rollout`. Format is
     * `projects/{project}/locations/{location}/deliveryPipelines/{deliveryPipeline}/releases/{release}/rollouts/[a-z][a-z0-9&#92;-]{0,62}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Name of the `Rollout`. Format is
     * `projects/{project}/locations/{location}/deliveryPipelines/{deliveryPipeline}/releases/{release}/rollouts/[a-z][a-z0-9&#92;-]{0,62}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Name of the `Rollout`. Format is
     * `projects/{project}/locations/{location}/deliveryPipelines/{deliveryPipeline}/releases/{release}/rollouts/[a-z][a-z0-9&#92;-]{0,62}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object uid_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier of the `Rollout`.
     * </pre>
     *
     * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The uid.
     */
    public java.lang.String getUid() {
      java.lang.Object ref = uid_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uid_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier of the `Rollout`.
     * </pre>
     *
     * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for uid.
     */
    public com.google.protobuf.ByteString getUidBytes() {
      java.lang.Object ref = uid_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        uid_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier of the `Rollout`.
     * </pre>
     *
     * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The uid to set.
     * @return This builder for chaining.
     */
    public Builder setUid(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      uid_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier of the `Rollout`.
     * </pre>
     *
     * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUid() {
      uid_ = getDefaultInstance().getUid();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier of the `Rollout`.
     * </pre>
     *
     * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for uid to set.
     * @return This builder for chaining.
     */
    public Builder setUidBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      uid_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Description of the `Rollout` for user purposes. Max length is 255
     * characters.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Description of the `Rollout` for user purposes. Max length is 255
     * characters.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Description of the `Rollout` for user purposes. Max length is 255
     * characters.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Description of the `Rollout` for user purposes. Max length is 255
     * characters.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Description of the `Rollout` for user purposes. Max length is 255
     * characters.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> annotations_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetAnnotations() {
      if (annotations_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            AnnotationsDefaultEntryHolder.defaultEntry);
      }
      return annotations_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableAnnotations() {
      if (annotations_ == null) {
        annotations_ =
            com.google.protobuf.MapField.newMapField(AnnotationsDefaultEntryHolder.defaultEntry);
      }
      if (!annotations_.isMutable()) {
        annotations_ = annotations_.copy();
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return annotations_;
    }

    public int getAnnotationsCount() {
      return internalGetAnnotations().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * User annotations. These attributes can only be set and used by the
     * user, and not by Cloud Deploy. See https://google.aip.dev/128#annotations
     * for more details such as format and size limitations.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 4;</code>
     */
    @java.lang.Override
    public boolean containsAnnotations(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetAnnotations().getMap().containsKey(key);
    }
    /** Use {@link #getAnnotationsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getAnnotations() {
      return getAnnotationsMap();
    }
    /**
     *
     *
     * <pre>
     * User annotations. These attributes can only be set and used by the
     * user, and not by Cloud Deploy. See https://google.aip.dev/128#annotations
     * for more details such as format and size limitations.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 4;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getAnnotationsMap() {
      return internalGetAnnotations().getMap();
    }
    /**
     *
     *
     * <pre>
     * User annotations. These attributes can only be set and used by the
     * user, and not by Cloud Deploy. See https://google.aip.dev/128#annotations
     * for more details such as format and size limitations.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 4;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getAnnotationsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * User annotations. These attributes can only be set and used by the
     * user, and not by Cloud Deploy. See https://google.aip.dev/128#annotations
     * for more details such as format and size limitations.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 4;</code>
     */
    @java.lang.Override
    public java.lang.String getAnnotationsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearAnnotations() {
      bitField0_ = (bitField0_ & ~0x00000008);
      internalGetMutableAnnotations().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User annotations. These attributes can only be set and used by the
     * user, and not by Cloud Deploy. See https://google.aip.dev/128#annotations
     * for more details such as format and size limitations.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 4;</code>
     */
    public Builder removeAnnotations(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableAnnotations().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableAnnotations() {
      bitField0_ |= 0x00000008;
      return internalGetMutableAnnotations().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * User annotations. These attributes can only be set and used by the
     * user, and not by Cloud Deploy. See https://google.aip.dev/128#annotations
     * for more details such as format and size limitations.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 4;</code>
     */
    public Builder putAnnotations(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableAnnotations().getMutableMap().put(key, value);
      bitField0_ |= 0x00000008;
      return this;
    }
    /**
     *
     *
     * <pre>
     * User annotations. These attributes can only be set and used by the
     * user, and not by Cloud Deploy. See https://google.aip.dev/128#annotations
     * for more details such as format and size limitations.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 4;</code>
     */
    public Builder putAllAnnotations(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableAnnotations().getMutableMap().putAll(values);
      bitField0_ |= 0x00000008;
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Labels are attributes that can be set and used by both the
     * user and by Cloud Deploy. Labels must meet the following constraints:
     *
     * * Keys and values can contain only lowercase letters, numeric characters,
     * underscores, and dashes.
     * * All characters must use UTF-8 encoding, and international characters are
     * allowed.
     * * Keys must start with a lowercase letter or international character.
     * * Each resource is limited to a maximum of 64 labels.
     *
     * Both keys and values are additionally constrained to be &lt;= 128 bytes.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Labels are attributes that can be set and used by both the
     * user and by Cloud Deploy. Labels must meet the following constraints:
     *
     * * Keys and values can contain only lowercase letters, numeric characters,
     * underscores, and dashes.
     * * All characters must use UTF-8 encoding, and international characters are
     * allowed.
     * * Keys must start with a lowercase letter or international character.
     * * Each resource is limited to a maximum of 64 labels.
     *
     * Both keys and values are additionally constrained to be &lt;= 128 bytes.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Labels are attributes that can be set and used by both the
     * user and by Cloud Deploy. Labels must meet the following constraints:
     *
     * * Keys and values can contain only lowercase letters, numeric characters,
     * underscores, and dashes.
     * * All characters must use UTF-8 encoding, and international characters are
     * allowed.
     * * Keys must start with a lowercase letter or international character.
     * * Each resource is limited to a maximum of 64 labels.
     *
     * Both keys and values are additionally constrained to be &lt;= 128 bytes.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Labels are attributes that can be set and used by both the
     * user and by Cloud Deploy. Labels must meet the following constraints:
     *
     * * Keys and values can contain only lowercase letters, numeric characters,
     * underscores, and dashes.
     * * All characters must use UTF-8 encoding, and international characters are
     * allowed.
     * * Keys must start with a lowercase letter or international character.
     * * Each resource is limited to a maximum of 64 labels.
     *
     * Both keys and values are additionally constrained to be &lt;= 128 bytes.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000010);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels are attributes that can be set and used by both the
     * user and by Cloud Deploy. Labels must meet the following constraints:
     *
     * * Keys and values can contain only lowercase letters, numeric characters,
     * underscores, and dashes.
     * * All characters must use UTF-8 encoding, and international characters are
     * allowed.
     * * Keys must start with a lowercase letter or international character.
     * * Each resource is limited to a maximum of 64 labels.
     *
     * Both keys and values are additionally constrained to be &lt;= 128 bytes.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000010;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Labels are attributes that can be set and used by both the
     * user and by Cloud Deploy. Labels must meet the following constraints:
     *
     * * Keys and values can contain only lowercase letters, numeric characters,
     * underscores, and dashes.
     * * All characters must use UTF-8 encoding, and international characters are
     * allowed.
     * * Keys must start with a lowercase letter or international character.
     * * Each resource is limited to a maximum of 64 labels.
     *
     * Both keys and values are additionally constrained to be &lt;= 128 bytes.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000010;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels are attributes that can be set and used by both the
     * user and by Cloud Deploy. Labels must meet the following constraints:
     *
     * * Keys and values can contain only lowercase letters, numeric characters,
     * underscores, and dashes.
     * * All characters must use UTF-8 encoding, and international characters are
     * allowed.
     * * Keys must start with a lowercase letter or international character.
     * * Each resource is limited to a maximum of 64 labels.
     *
     * Both keys and values are additionally constrained to be &lt;= 128 bytes.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000010;
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `Rollout` was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `Rollout` was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `Rollout` was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `Rollout` was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `Rollout` was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `Rollout` was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000020);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `Rollout` was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `Rollout` was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `Rollout` was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp approveTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        approveTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `Rollout` was approved.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp approve_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the approveTime field is set.
     */
    public boolean hasApproveTime() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `Rollout` was approved.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp approve_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The approveTime.
     */
    public com.google.protobuf.Timestamp getApproveTime() {
      if (approveTimeBuilder_ == null) {
        return approveTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : approveTime_;
      } else {
        return approveTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `Rollout` was approved.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp approve_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setApproveTime(com.google.protobuf.Timestamp value) {
      if (approveTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        approveTime_ = value;
      } else {
        approveTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `Rollout` was approved.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp approve_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setApproveTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (approveTimeBuilder_ == null) {
        approveTime_ = builderForValue.build();
      } else {
        approveTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `Rollout` was approved.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp approve_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeApproveTime(com.google.protobuf.Timestamp value) {
      if (approveTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && approveTime_ != null
            && approveTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getApproveTimeBuilder().mergeFrom(value);
        } else {
          approveTime_ = value;
        }
      } else {
        approveTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `Rollout` was approved.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp approve_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearApproveTime() {
      bitField0_ = (bitField0_ & ~0x00000040);
      approveTime_ = null;
      if (approveTimeBuilder_ != null) {
        approveTimeBuilder_.dispose();
        approveTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `Rollout` was approved.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp approve_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getApproveTimeBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getApproveTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `Rollout` was approved.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp approve_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getApproveTimeOrBuilder() {
      if (approveTimeBuilder_ != null) {
        return approveTimeBuilder_.getMessageOrBuilder();
      } else {
        return approveTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : approveTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `Rollout` was approved.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp approve_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getApproveTimeFieldBuilder() {
      if (approveTimeBuilder_ == null) {
        approveTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getApproveTime(), getParentForChildren(), isClean());
        approveTime_ = null;
      }
      return approveTimeBuilder_;
    }

    private com.google.protobuf.Timestamp enqueueTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        enqueueTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `Rollout` was enqueued.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp enqueue_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the enqueueTime field is set.
     */
    public boolean hasEnqueueTime() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `Rollout` was enqueued.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp enqueue_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enqueueTime.
     */
    public com.google.protobuf.Timestamp getEnqueueTime() {
      if (enqueueTimeBuilder_ == null) {
        return enqueueTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : enqueueTime_;
      } else {
        return enqueueTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `Rollout` was enqueued.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp enqueue_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEnqueueTime(com.google.protobuf.Timestamp value) {
      if (enqueueTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        enqueueTime_ = value;
      } else {
        enqueueTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `Rollout` was enqueued.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp enqueue_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEnqueueTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (enqueueTimeBuilder_ == null) {
        enqueueTime_ = builderForValue.build();
      } else {
        enqueueTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `Rollout` was enqueued.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp enqueue_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeEnqueueTime(com.google.protobuf.Timestamp value) {
      if (enqueueTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && enqueueTime_ != null
            && enqueueTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getEnqueueTimeBuilder().mergeFrom(value);
        } else {
          enqueueTime_ = value;
        }
      } else {
        enqueueTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `Rollout` was enqueued.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp enqueue_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearEnqueueTime() {
      bitField0_ = (bitField0_ & ~0x00000080);
      enqueueTime_ = null;
      if (enqueueTimeBuilder_ != null) {
        enqueueTimeBuilder_.dispose();
        enqueueTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `Rollout` was enqueued.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp enqueue_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getEnqueueTimeBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getEnqueueTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `Rollout` was enqueued.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp enqueue_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getEnqueueTimeOrBuilder() {
      if (enqueueTimeBuilder_ != null) {
        return enqueueTimeBuilder_.getMessageOrBuilder();
      } else {
        return enqueueTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : enqueueTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `Rollout` was enqueued.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp enqueue_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getEnqueueTimeFieldBuilder() {
      if (enqueueTimeBuilder_ == null) {
        enqueueTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getEnqueueTime(), getParentForChildren(), isClean());
        enqueueTime_ = null;
      }
      return enqueueTimeBuilder_;
    }

    private com.google.protobuf.Timestamp deployStartTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        deployStartTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `Rollout` started deploying.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp deploy_start_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the deployStartTime field is set.
     */
    public boolean hasDeployStartTime() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `Rollout` started deploying.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp deploy_start_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The deployStartTime.
     */
    public com.google.protobuf.Timestamp getDeployStartTime() {
      if (deployStartTimeBuilder_ == null) {
        return deployStartTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : deployStartTime_;
      } else {
        return deployStartTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `Rollout` started deploying.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp deploy_start_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDeployStartTime(com.google.protobuf.Timestamp value) {
      if (deployStartTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        deployStartTime_ = value;
      } else {
        deployStartTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `Rollout` started deploying.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp deploy_start_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDeployStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (deployStartTimeBuilder_ == null) {
        deployStartTime_ = builderForValue.build();
      } else {
        deployStartTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `Rollout` started deploying.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp deploy_start_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeDeployStartTime(com.google.protobuf.Timestamp value) {
      if (deployStartTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && deployStartTime_ != null
            && deployStartTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getDeployStartTimeBuilder().mergeFrom(value);
        } else {
          deployStartTime_ = value;
        }
      } else {
        deployStartTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `Rollout` started deploying.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp deploy_start_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearDeployStartTime() {
      bitField0_ = (bitField0_ & ~0x00000100);
      deployStartTime_ = null;
      if (deployStartTimeBuilder_ != null) {
        deployStartTimeBuilder_.dispose();
        deployStartTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `Rollout` started deploying.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp deploy_start_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getDeployStartTimeBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getDeployStartTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `Rollout` started deploying.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp deploy_start_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getDeployStartTimeOrBuilder() {
      if (deployStartTimeBuilder_ != null) {
        return deployStartTimeBuilder_.getMessageOrBuilder();
      } else {
        return deployStartTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : deployStartTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `Rollout` started deploying.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp deploy_start_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getDeployStartTimeFieldBuilder() {
      if (deployStartTimeBuilder_ == null) {
        deployStartTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getDeployStartTime(), getParentForChildren(), isClean());
        deployStartTime_ = null;
      }
      return deployStartTimeBuilder_;
    }

    private com.google.protobuf.Timestamp deployEndTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        deployEndTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `Rollout` finished deploying.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp deploy_end_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the deployEndTime field is set.
     */
    public boolean hasDeployEndTime() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `Rollout` finished deploying.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp deploy_end_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The deployEndTime.
     */
    public com.google.protobuf.Timestamp getDeployEndTime() {
      if (deployEndTimeBuilder_ == null) {
        return deployEndTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : deployEndTime_;
      } else {
        return deployEndTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `Rollout` finished deploying.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp deploy_end_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDeployEndTime(com.google.protobuf.Timestamp value) {
      if (deployEndTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        deployEndTime_ = value;
      } else {
        deployEndTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `Rollout` finished deploying.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp deploy_end_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDeployEndTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (deployEndTimeBuilder_ == null) {
        deployEndTime_ = builderForValue.build();
      } else {
        deployEndTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `Rollout` finished deploying.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp deploy_end_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeDeployEndTime(com.google.protobuf.Timestamp value) {
      if (deployEndTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && deployEndTime_ != null
            && deployEndTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getDeployEndTimeBuilder().mergeFrom(value);
        } else {
          deployEndTime_ = value;
        }
      } else {
        deployEndTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `Rollout` finished deploying.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp deploy_end_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearDeployEndTime() {
      bitField0_ = (bitField0_ & ~0x00000200);
      deployEndTime_ = null;
      if (deployEndTimeBuilder_ != null) {
        deployEndTimeBuilder_.dispose();
        deployEndTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `Rollout` finished deploying.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp deploy_end_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getDeployEndTimeBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getDeployEndTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `Rollout` finished deploying.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp deploy_end_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getDeployEndTimeOrBuilder() {
      if (deployEndTimeBuilder_ != null) {
        return deployEndTimeBuilder_.getMessageOrBuilder();
      } else {
        return deployEndTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : deployEndTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `Rollout` finished deploying.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp deploy_end_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getDeployEndTimeFieldBuilder() {
      if (deployEndTimeBuilder_ == null) {
        deployEndTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getDeployEndTime(), getParentForChildren(), isClean());
        deployEndTime_ = null;
      }
      return deployEndTimeBuilder_;
    }

    private java.lang.Object targetId_ = "";
    /**
     *
     *
     * <pre>
     * Required. The ID of Target to which this `Rollout` is deploying.
     * </pre>
     *
     * <code>string target_id = 18 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The targetId.
     */
    public java.lang.String getTargetId() {
      java.lang.Object ref = targetId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        targetId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The ID of Target to which this `Rollout` is deploying.
     * </pre>
     *
     * <code>string target_id = 18 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for targetId.
     */
    public com.google.protobuf.ByteString getTargetIdBytes() {
      java.lang.Object ref = targetId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        targetId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The ID of Target to which this `Rollout` is deploying.
     * </pre>
     *
     * <code>string target_id = 18 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The targetId to set.
     * @return This builder for chaining.
     */
    public Builder setTargetId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      targetId_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The ID of Target to which this `Rollout` is deploying.
     * </pre>
     *
     * <code>string target_id = 18 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTargetId() {
      targetId_ = getDefaultInstance().getTargetId();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The ID of Target to which this `Rollout` is deploying.
     * </pre>
     *
     * <code>string target_id = 18 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for targetId to set.
     * @return This builder for chaining.
     */
    public Builder setTargetIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      targetId_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    private int approvalState_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. Approval state of the `Rollout`.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Rollout.ApprovalState approval_state = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for approvalState.
     */
    @java.lang.Override
    public int getApprovalStateValue() {
      return approvalState_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Approval state of the `Rollout`.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Rollout.ApprovalState approval_state = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for approvalState to set.
     * @return This builder for chaining.
     */
    public Builder setApprovalStateValue(int value) {
      approvalState_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Approval state of the `Rollout`.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Rollout.ApprovalState approval_state = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The approvalState.
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.Rollout.ApprovalState getApprovalState() {
      com.google.cloud.deploy.v1.Rollout.ApprovalState result =
          com.google.cloud.deploy.v1.Rollout.ApprovalState.forNumber(approvalState_);
      return result == null
          ? com.google.cloud.deploy.v1.Rollout.ApprovalState.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. Approval state of the `Rollout`.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Rollout.ApprovalState approval_state = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The approvalState to set.
     * @return This builder for chaining.
     */
    public Builder setApprovalState(com.google.cloud.deploy.v1.Rollout.ApprovalState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000800;
      approvalState_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Approval state of the `Rollout`.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Rollout.ApprovalState approval_state = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearApprovalState() {
      bitField0_ = (bitField0_ & ~0x00000800);
      approvalState_ = 0;
      onChanged();
      return this;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. Current state of the `Rollout`.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Rollout.State state = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Current state of the `Rollout`.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Rollout.State state = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Current state of the `Rollout`.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Rollout.State state = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.Rollout.State getState() {
      com.google.cloud.deploy.v1.Rollout.State result =
          com.google.cloud.deploy.v1.Rollout.State.forNumber(state_);
      return result == null ? com.google.cloud.deploy.v1.Rollout.State.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. Current state of the `Rollout`.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Rollout.State state = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.deploy.v1.Rollout.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00001000;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Current state of the `Rollout`.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Rollout.State state = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00001000);
      state_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object failureReason_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Additional information about the rollout failure, if
     * available.
     * </pre>
     *
     * <code>string failure_reason = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The failureReason.
     */
    public java.lang.String getFailureReason() {
      java.lang.Object ref = failureReason_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        failureReason_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information about the rollout failure, if
     * available.
     * </pre>
     *
     * <code>string failure_reason = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for failureReason.
     */
    public com.google.protobuf.ByteString getFailureReasonBytes() {
      java.lang.Object ref = failureReason_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        failureReason_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information about the rollout failure, if
     * available.
     * </pre>
     *
     * <code>string failure_reason = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The failureReason to set.
     * @return This builder for chaining.
     */
    public Builder setFailureReason(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      failureReason_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information about the rollout failure, if
     * available.
     * </pre>
     *
     * <code>string failure_reason = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFailureReason() {
      failureReason_ = getDefaultInstance().getFailureReason();
      bitField0_ = (bitField0_ & ~0x00002000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information about the rollout failure, if
     * available.
     * </pre>
     *
     * <code>string failure_reason = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for failureReason to set.
     * @return This builder for chaining.
     */
    public Builder setFailureReasonBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      failureReason_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    private java.lang.Object deployingBuild_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the Cloud Build `Build` object that is
     * used to deploy the Rollout. Format is
     * `projects/{project}/locations/{location}/builds/{build}`.
     * </pre>
     *
     * <code>
     * string deploying_build = 17 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The deployingBuild.
     */
    public java.lang.String getDeployingBuild() {
      java.lang.Object ref = deployingBuild_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        deployingBuild_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the Cloud Build `Build` object that is
     * used to deploy the Rollout. Format is
     * `projects/{project}/locations/{location}/builds/{build}`.
     * </pre>
     *
     * <code>
     * string deploying_build = 17 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for deployingBuild.
     */
    public com.google.protobuf.ByteString getDeployingBuildBytes() {
      java.lang.Object ref = deployingBuild_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        deployingBuild_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the Cloud Build `Build` object that is
     * used to deploy the Rollout. Format is
     * `projects/{project}/locations/{location}/builds/{build}`.
     * </pre>
     *
     * <code>
     * string deploying_build = 17 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The deployingBuild to set.
     * @return This builder for chaining.
     */
    public Builder setDeployingBuild(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      deployingBuild_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the Cloud Build `Build` object that is
     * used to deploy the Rollout. Format is
     * `projects/{project}/locations/{location}/builds/{build}`.
     * </pre>
     *
     * <code>
     * string deploying_build = 17 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDeployingBuild() {
      deployingBuild_ = getDefaultInstance().getDeployingBuild();
      bitField0_ = (bitField0_ & ~0x00004000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the Cloud Build `Build` object that is
     * used to deploy the Rollout. Format is
     * `projects/{project}/locations/{location}/builds/{build}`.
     * </pre>
     *
     * <code>
     * string deploying_build = 17 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for deployingBuild to set.
     * @return This builder for chaining.
     */
    public Builder setDeployingBuildBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      deployingBuild_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    private java.lang.Object etag_ = "";
    /**
     *
     *
     * <pre>
     * This checksum is computed by the server based on the value of other
     * fields, and may be sent on update and delete requests to ensure the
     * client has an up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 16;</code>
     *
     * @return The etag.
     */
    public java.lang.String getEtag() {
      java.lang.Object ref = etag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        etag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * This checksum is computed by the server based on the value of other
     * fields, and may be sent on update and delete requests to ensure the
     * client has an up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 16;</code>
     *
     * @return The bytes for etag.
     */
    public com.google.protobuf.ByteString getEtagBytes() {
      java.lang.Object ref = etag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        etag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * This checksum is computed by the server based on the value of other
     * fields, and may be sent on update and delete requests to ensure the
     * client has an up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 16;</code>
     *
     * @param value The etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      etag_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This checksum is computed by the server based on the value of other
     * fields, and may be sent on update and delete requests to ensure the
     * client has an up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 16;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEtag() {
      etag_ = getDefaultInstance().getEtag();
      bitField0_ = (bitField0_ & ~0x00008000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This checksum is computed by the server based on the value of other
     * fields, and may be sent on update and delete requests to ensure the
     * client has an up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 16;</code>
     *
     * @param value The bytes for etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      etag_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    private int deployFailureCause_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The reason this rollout failed. This will always be
     * unspecified while the rollout is in progress.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Rollout.FailureCause deploy_failure_cause = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for deployFailureCause.
     */
    @java.lang.Override
    public int getDeployFailureCauseValue() {
      return deployFailureCause_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The reason this rollout failed. This will always be
     * unspecified while the rollout is in progress.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Rollout.FailureCause deploy_failure_cause = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for deployFailureCause to set.
     * @return This builder for chaining.
     */
    public Builder setDeployFailureCauseValue(int value) {
      deployFailureCause_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The reason this rollout failed. This will always be
     * unspecified while the rollout is in progress.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Rollout.FailureCause deploy_failure_cause = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The deployFailureCause.
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.Rollout.FailureCause getDeployFailureCause() {
      com.google.cloud.deploy.v1.Rollout.FailureCause result =
          com.google.cloud.deploy.v1.Rollout.FailureCause.forNumber(deployFailureCause_);
      return result == null ? com.google.cloud.deploy.v1.Rollout.FailureCause.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The reason this rollout failed. This will always be
     * unspecified while the rollout is in progress.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Rollout.FailureCause deploy_failure_cause = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The deployFailureCause to set.
     * @return This builder for chaining.
     */
    public Builder setDeployFailureCause(com.google.cloud.deploy.v1.Rollout.FailureCause value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00010000;
      deployFailureCause_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The reason this rollout failed. This will always be
     * unspecified while the rollout is in progress.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Rollout.FailureCause deploy_failure_cause = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDeployFailureCause() {
      bitField0_ = (bitField0_ & ~0x00010000);
      deployFailureCause_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.deploy.v1.Phase> phases_ =
        java.util.Collections.emptyList();

    private void ensurePhasesIsMutable() {
      if (!((bitField0_ & 0x00020000) != 0)) {
        phases_ = new java.util.ArrayList<com.google.cloud.deploy.v1.Phase>(phases_);
        bitField0_ |= 0x00020000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.deploy.v1.Phase,
            com.google.cloud.deploy.v1.Phase.Builder,
            com.google.cloud.deploy.v1.PhaseOrBuilder>
        phasesBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The phases that represent the workflows of this `Rollout`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.Phase phases = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.deploy.v1.Phase> getPhasesList() {
      if (phasesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(phases_);
      } else {
        return phasesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The phases that represent the workflows of this `Rollout`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.Phase phases = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getPhasesCount() {
      if (phasesBuilder_ == null) {
        return phases_.size();
      } else {
        return phasesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The phases that represent the workflows of this `Rollout`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.Phase phases = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.deploy.v1.Phase getPhases(int index) {
      if (phasesBuilder_ == null) {
        return phases_.get(index);
      } else {
        return phasesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The phases that represent the workflows of this `Rollout`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.Phase phases = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setPhases(int index, com.google.cloud.deploy.v1.Phase value) {
      if (phasesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePhasesIsMutable();
        phases_.set(index, value);
        onChanged();
      } else {
        phasesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The phases that represent the workflows of this `Rollout`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.Phase phases = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setPhases(int index, com.google.cloud.deploy.v1.Phase.Builder builderForValue) {
      if (phasesBuilder_ == null) {
        ensurePhasesIsMutable();
        phases_.set(index, builderForValue.build());
        onChanged();
      } else {
        phasesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The phases that represent the workflows of this `Rollout`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.Phase phases = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addPhases(com.google.cloud.deploy.v1.Phase value) {
      if (phasesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePhasesIsMutable();
        phases_.add(value);
        onChanged();
      } else {
        phasesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The phases that represent the workflows of this `Rollout`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.Phase phases = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addPhases(int index, com.google.cloud.deploy.v1.Phase value) {
      if (phasesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePhasesIsMutable();
        phases_.add(index, value);
        onChanged();
      } else {
        phasesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The phases that represent the workflows of this `Rollout`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.Phase phases = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addPhases(com.google.cloud.deploy.v1.Phase.Builder builderForValue) {
      if (phasesBuilder_ == null) {
        ensurePhasesIsMutable();
        phases_.add(builderForValue.build());
        onChanged();
      } else {
        phasesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The phases that represent the workflows of this `Rollout`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.Phase phases = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addPhases(int index, com.google.cloud.deploy.v1.Phase.Builder builderForValue) {
      if (phasesBuilder_ == null) {
        ensurePhasesIsMutable();
        phases_.add(index, builderForValue.build());
        onChanged();
      } else {
        phasesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The phases that represent the workflows of this `Rollout`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.Phase phases = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllPhases(
        java.lang.Iterable<? extends com.google.cloud.deploy.v1.Phase> values) {
      if (phasesBuilder_ == null) {
        ensurePhasesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, phases_);
        onChanged();
      } else {
        phasesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The phases that represent the workflows of this `Rollout`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.Phase phases = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearPhases() {
      if (phasesBuilder_ == null) {
        phases_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00020000);
        onChanged();
      } else {
        phasesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The phases that represent the workflows of this `Rollout`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.Phase phases = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removePhases(int index) {
      if (phasesBuilder_ == null) {
        ensurePhasesIsMutable();
        phases_.remove(index);
        onChanged();
      } else {
        phasesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The phases that represent the workflows of this `Rollout`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.Phase phases = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.deploy.v1.Phase.Builder getPhasesBuilder(int index) {
      return getPhasesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The phases that represent the workflows of this `Rollout`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.Phase phases = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.deploy.v1.PhaseOrBuilder getPhasesOrBuilder(int index) {
      if (phasesBuilder_ == null) {
        return phases_.get(index);
      } else {
        return phasesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The phases that represent the workflows of this `Rollout`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.Phase phases = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.deploy.v1.PhaseOrBuilder>
        getPhasesOrBuilderList() {
      if (phasesBuilder_ != null) {
        return phasesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(phases_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The phases that represent the workflows of this `Rollout`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.Phase phases = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.deploy.v1.Phase.Builder addPhasesBuilder() {
      return getPhasesFieldBuilder()
          .addBuilder(com.google.cloud.deploy.v1.Phase.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. The phases that represent the workflows of this `Rollout`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.Phase phases = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.deploy.v1.Phase.Builder addPhasesBuilder(int index) {
      return getPhasesFieldBuilder()
          .addBuilder(index, com.google.cloud.deploy.v1.Phase.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. The phases that represent the workflows of this `Rollout`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.Phase phases = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.deploy.v1.Phase.Builder> getPhasesBuilderList() {
      return getPhasesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.deploy.v1.Phase,
            com.google.cloud.deploy.v1.Phase.Builder,
            com.google.cloud.deploy.v1.PhaseOrBuilder>
        getPhasesFieldBuilder() {
      if (phasesBuilder_ == null) {
        phasesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.deploy.v1.Phase,
                com.google.cloud.deploy.v1.Phase.Builder,
                com.google.cloud.deploy.v1.PhaseOrBuilder>(
                phases_, ((bitField0_ & 0x00020000) != 0), getParentForChildren(), isClean());
        phases_ = null;
      }
      return phasesBuilder_;
    }

    private com.google.cloud.deploy.v1.Metadata metadata_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.Metadata,
            com.google.cloud.deploy.v1.Metadata.Builder,
            com.google.cloud.deploy.v1.MetadataOrBuilder>
        metadataBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Metadata contains information about the rollout.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Metadata metadata = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the metadata field is set.
     */
    public boolean hasMetadata() {
      return ((bitField0_ & 0x00040000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Metadata contains information about the rollout.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Metadata metadata = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The metadata.
     */
    public com.google.cloud.deploy.v1.Metadata getMetadata() {
      if (metadataBuilder_ == null) {
        return metadata_ == null
            ? com.google.cloud.deploy.v1.Metadata.getDefaultInstance()
            : metadata_;
      } else {
        return metadataBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Metadata contains information about the rollout.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Metadata metadata = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setMetadata(com.google.cloud.deploy.v1.Metadata value) {
      if (metadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metadata_ = value;
      } else {
        metadataBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Metadata contains information about the rollout.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Metadata metadata = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setMetadata(com.google.cloud.deploy.v1.Metadata.Builder builderForValue) {
      if (metadataBuilder_ == null) {
        metadata_ = builderForValue.build();
      } else {
        metadataBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Metadata contains information about the rollout.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Metadata metadata = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeMetadata(com.google.cloud.deploy.v1.Metadata value) {
      if (metadataBuilder_ == null) {
        if (((bitField0_ & 0x00040000) != 0)
            && metadata_ != null
            && metadata_ != com.google.cloud.deploy.v1.Metadata.getDefaultInstance()) {
          getMetadataBuilder().mergeFrom(value);
        } else {
          metadata_ = value;
        }
      } else {
        metadataBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Metadata contains information about the rollout.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Metadata metadata = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearMetadata() {
      bitField0_ = (bitField0_ & ~0x00040000);
      metadata_ = null;
      if (metadataBuilder_ != null) {
        metadataBuilder_.dispose();
        metadataBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Metadata contains information about the rollout.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Metadata metadata = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.deploy.v1.Metadata.Builder getMetadataBuilder() {
      bitField0_ |= 0x00040000;
      onChanged();
      return getMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Metadata contains information about the rollout.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Metadata metadata = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.deploy.v1.MetadataOrBuilder getMetadataOrBuilder() {
      if (metadataBuilder_ != null) {
        return metadataBuilder_.getMessageOrBuilder();
      } else {
        return metadata_ == null
            ? com.google.cloud.deploy.v1.Metadata.getDefaultInstance()
            : metadata_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Metadata contains information about the rollout.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Metadata metadata = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.Metadata,
            com.google.cloud.deploy.v1.Metadata.Builder,
            com.google.cloud.deploy.v1.MetadataOrBuilder>
        getMetadataFieldBuilder() {
      if (metadataBuilder_ == null) {
        metadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.deploy.v1.Metadata,
                com.google.cloud.deploy.v1.Metadata.Builder,
                com.google.cloud.deploy.v1.MetadataOrBuilder>(
                getMetadata(), getParentForChildren(), isClean());
        metadata_ = null;
      }
      return metadataBuilder_;
    }

    private java.lang.Object controllerRollout_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Name of the `ControllerRollout`. Format is
     * `projects/{project}/locations/{location}/deliveryPipelines/{deliveryPipeline}/releases/{release}/rollouts/[a-z][a-z0-9&#92;-]{0,62}`.
     * </pre>
     *
     * <code>string controller_rollout = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The controllerRollout.
     */
    public java.lang.String getControllerRollout() {
      java.lang.Object ref = controllerRollout_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        controllerRollout_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the `ControllerRollout`. Format is
     * `projects/{project}/locations/{location}/deliveryPipelines/{deliveryPipeline}/releases/{release}/rollouts/[a-z][a-z0-9&#92;-]{0,62}`.
     * </pre>
     *
     * <code>string controller_rollout = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for controllerRollout.
     */
    public com.google.protobuf.ByteString getControllerRolloutBytes() {
      java.lang.Object ref = controllerRollout_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        controllerRollout_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the `ControllerRollout`. Format is
     * `projects/{project}/locations/{location}/deliveryPipelines/{deliveryPipeline}/releases/{release}/rollouts/[a-z][a-z0-9&#92;-]{0,62}`.
     * </pre>
     *
     * <code>string controller_rollout = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The controllerRollout to set.
     * @return This builder for chaining.
     */
    public Builder setControllerRollout(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      controllerRollout_ = value;
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the `ControllerRollout`. Format is
     * `projects/{project}/locations/{location}/deliveryPipelines/{deliveryPipeline}/releases/{release}/rollouts/[a-z][a-z0-9&#92;-]{0,62}`.
     * </pre>
     *
     * <code>string controller_rollout = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearControllerRollout() {
      controllerRollout_ = getDefaultInstance().getControllerRollout();
      bitField0_ = (bitField0_ & ~0x00080000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the `ControllerRollout`. Format is
     * `projects/{project}/locations/{location}/deliveryPipelines/{deliveryPipeline}/releases/{release}/rollouts/[a-z][a-z0-9&#92;-]{0,62}`.
     * </pre>
     *
     * <code>string controller_rollout = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for controllerRollout to set.
     * @return This builder for chaining.
     */
    public Builder setControllerRolloutBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      controllerRollout_ = value;
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }

    private java.lang.Object rollbackOfRollout_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Name of the `Rollout` that is rolled back by this `Rollout`.
     * Empty if this `Rollout` wasn't created as a rollback.
     * </pre>
     *
     * <code>string rollback_of_rollout = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The rollbackOfRollout.
     */
    public java.lang.String getRollbackOfRollout() {
      java.lang.Object ref = rollbackOfRollout_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        rollbackOfRollout_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the `Rollout` that is rolled back by this `Rollout`.
     * Empty if this `Rollout` wasn't created as a rollback.
     * </pre>
     *
     * <code>string rollback_of_rollout = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for rollbackOfRollout.
     */
    public com.google.protobuf.ByteString getRollbackOfRolloutBytes() {
      java.lang.Object ref = rollbackOfRollout_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        rollbackOfRollout_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the `Rollout` that is rolled back by this `Rollout`.
     * Empty if this `Rollout` wasn't created as a rollback.
     * </pre>
     *
     * <code>string rollback_of_rollout = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The rollbackOfRollout to set.
     * @return This builder for chaining.
     */
    public Builder setRollbackOfRollout(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      rollbackOfRollout_ = value;
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the `Rollout` that is rolled back by this `Rollout`.
     * Empty if this `Rollout` wasn't created as a rollback.
     * </pre>
     *
     * <code>string rollback_of_rollout = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRollbackOfRollout() {
      rollbackOfRollout_ = getDefaultInstance().getRollbackOfRollout();
      bitField0_ = (bitField0_ & ~0x00100000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the `Rollout` that is rolled back by this `Rollout`.
     * Empty if this `Rollout` wasn't created as a rollback.
     * </pre>
     *
     * <code>string rollback_of_rollout = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for rollbackOfRollout to set.
     * @return This builder for chaining.
     */
    public Builder setRollbackOfRolloutBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      rollbackOfRollout_ = value;
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList rolledBackByRollouts_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureRolledBackByRolloutsIsMutable() {
      if (!rolledBackByRollouts_.isModifiable()) {
        rolledBackByRollouts_ = new com.google.protobuf.LazyStringArrayList(rolledBackByRollouts_);
      }
      bitField0_ |= 0x00200000;
    }
    /**
     *
     *
     * <pre>
     * Output only. Names of `Rollouts` that rolled back this `Rollout`.
     * </pre>
     *
     * <code>
     * repeated string rolled_back_by_rollouts = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return A list containing the rolledBackByRollouts.
     */
    public com.google.protobuf.ProtocolStringList getRolledBackByRolloutsList() {
      rolledBackByRollouts_.makeImmutable();
      return rolledBackByRollouts_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Names of `Rollouts` that rolled back this `Rollout`.
     * </pre>
     *
     * <code>
     * repeated string rolled_back_by_rollouts = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The count of rolledBackByRollouts.
     */
    public int getRolledBackByRolloutsCount() {
      return rolledBackByRollouts_.size();
    }
    /**
     *
     *
     * <pre>
     * Output only. Names of `Rollouts` that rolled back this `Rollout`.
     * </pre>
     *
     * <code>
     * repeated string rolled_back_by_rollouts = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The rolledBackByRollouts at the given index.
     */
    public java.lang.String getRolledBackByRollouts(int index) {
      return rolledBackByRollouts_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. Names of `Rollouts` that rolled back this `Rollout`.
     * </pre>
     *
     * <code>
     * repeated string rolled_back_by_rollouts = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the rolledBackByRollouts at the given index.
     */
    public com.google.protobuf.ByteString getRolledBackByRolloutsBytes(int index) {
      return rolledBackByRollouts_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. Names of `Rollouts` that rolled back this `Rollout`.
     * </pre>
     *
     * <code>
     * repeated string rolled_back_by_rollouts = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The rolledBackByRollouts to set.
     * @return This builder for chaining.
     */
    public Builder setRolledBackByRollouts(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureRolledBackByRolloutsIsMutable();
      rolledBackByRollouts_.set(index, value);
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Names of `Rollouts` that rolled back this `Rollout`.
     * </pre>
     *
     * <code>
     * repeated string rolled_back_by_rollouts = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The rolledBackByRollouts to add.
     * @return This builder for chaining.
     */
    public Builder addRolledBackByRollouts(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureRolledBackByRolloutsIsMutable();
      rolledBackByRollouts_.add(value);
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Names of `Rollouts` that rolled back this `Rollout`.
     * </pre>
     *
     * <code>
     * repeated string rolled_back_by_rollouts = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param values The rolledBackByRollouts to add.
     * @return This builder for chaining.
     */
    public Builder addAllRolledBackByRollouts(java.lang.Iterable<java.lang.String> values) {
      ensureRolledBackByRolloutsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, rolledBackByRollouts_);
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Names of `Rollouts` that rolled back this `Rollout`.
     * </pre>
     *
     * <code>
     * repeated string rolled_back_by_rollouts = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRolledBackByRollouts() {
      rolledBackByRollouts_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00200000);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Names of `Rollouts` that rolled back this `Rollout`.
     * </pre>
     *
     * <code>
     * repeated string rolled_back_by_rollouts = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The bytes of the rolledBackByRollouts to add.
     * @return This builder for chaining.
     */
    public Builder addRolledBackByRolloutsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureRolledBackByRolloutsIsMutable();
      rolledBackByRollouts_.add(value);
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.deploy.v1.Rollout)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.deploy.v1.Rollout)
  private static final com.google.cloud.deploy.v1.Rollout DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.deploy.v1.Rollout();
  }

  public static com.google.cloud.deploy.v1.Rollout getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Rollout> PARSER =
      new com.google.protobuf.AbstractParser<Rollout>() {
        @java.lang.Override
        public Rollout parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Rollout> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Rollout> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.deploy.v1.Rollout getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
