/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/deploy/v1/cloud_deploy.proto

package com.google.cloud.deploy.v1;

public interface RolloutOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.deploy.v1.Rollout)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Optional. Name of the `Rollout`. Format is
   * `projects/{project}/locations/{location}/deliveryPipelines/{deliveryPipeline}/releases/{release}/rollouts/[a-z][a-z0-9&#92;-]{0,62}`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The name.
   */
  java.lang.String getName();
  /**
   *
   *
   * <pre>
   * Optional. Name of the `Rollout`. Format is
   * `projects/{project}/locations/{location}/deliveryPipelines/{deliveryPipeline}/releases/{release}/rollouts/[a-z][a-z0-9&#92;-]{0,62}`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * Output only. Unique identifier of the `Rollout`.
   * </pre>
   *
   * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The uid.
   */
  java.lang.String getUid();
  /**
   *
   *
   * <pre>
   * Output only. Unique identifier of the `Rollout`.
   * </pre>
   *
   * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for uid.
   */
  com.google.protobuf.ByteString getUidBytes();

  /**
   *
   *
   * <pre>
   * Description of the `Rollout` for user purposes. Max length is 255
   * characters.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The description.
   */
  java.lang.String getDescription();
  /**
   *
   *
   * <pre>
   * Description of the `Rollout` for user purposes. Max length is 255
   * characters.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The bytes for description.
   */
  com.google.protobuf.ByteString getDescriptionBytes();

  /**
   *
   *
   * <pre>
   * User annotations. These attributes can only be set and used by the
   * user, and not by Cloud Deploy. See https://google.aip.dev/128#annotations
   * for more details such as format and size limitations.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 4;</code>
   */
  int getAnnotationsCount();
  /**
   *
   *
   * <pre>
   * User annotations. These attributes can only be set and used by the
   * user, and not by Cloud Deploy. See https://google.aip.dev/128#annotations
   * for more details such as format and size limitations.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 4;</code>
   */
  boolean containsAnnotations(java.lang.String key);
  /** Use {@link #getAnnotationsMap()} instead. */
  @java.lang.Deprecated
  java.util.Map<java.lang.String, java.lang.String> getAnnotations();
  /**
   *
   *
   * <pre>
   * User annotations. These attributes can only be set and used by the
   * user, and not by Cloud Deploy. See https://google.aip.dev/128#annotations
   * for more details such as format and size limitations.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 4;</code>
   */
  java.util.Map<java.lang.String, java.lang.String> getAnnotationsMap();
  /**
   *
   *
   * <pre>
   * User annotations. These attributes can only be set and used by the
   * user, and not by Cloud Deploy. See https://google.aip.dev/128#annotations
   * for more details such as format and size limitations.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 4;</code>
   */
  /* nullable */
  java.lang.String getAnnotationsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue);
  /**
   *
   *
   * <pre>
   * User annotations. These attributes can only be set and used by the
   * user, and not by Cloud Deploy. See https://google.aip.dev/128#annotations
   * for more details such as format and size limitations.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 4;</code>
   */
  java.lang.String getAnnotationsOrThrow(java.lang.String key);

  /**
   *
   *
   * <pre>
   * Labels are attributes that can be set and used by both the
   * user and by Cloud Deploy. Labels must meet the following constraints:
   *
   * * Keys and values can contain only lowercase letters, numeric characters,
   * underscores, and dashes.
   * * All characters must use UTF-8 encoding, and international characters are
   * allowed.
   * * Keys must start with a lowercase letter or international character.
   * * Each resource is limited to a maximum of 64 labels.
   *
   * Both keys and values are additionally constrained to be &lt;= 128 bytes.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5;</code>
   */
  int getLabelsCount();
  /**
   *
   *
   * <pre>
   * Labels are attributes that can be set and used by both the
   * user and by Cloud Deploy. Labels must meet the following constraints:
   *
   * * Keys and values can contain only lowercase letters, numeric characters,
   * underscores, and dashes.
   * * All characters must use UTF-8 encoding, and international characters are
   * allowed.
   * * Keys must start with a lowercase letter or international character.
   * * Each resource is limited to a maximum of 64 labels.
   *
   * Both keys and values are additionally constrained to be &lt;= 128 bytes.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5;</code>
   */
  boolean containsLabels(java.lang.String key);
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Deprecated
  java.util.Map<java.lang.String, java.lang.String> getLabels();
  /**
   *
   *
   * <pre>
   * Labels are attributes that can be set and used by both the
   * user and by Cloud Deploy. Labels must meet the following constraints:
   *
   * * Keys and values can contain only lowercase letters, numeric characters,
   * underscores, and dashes.
   * * All characters must use UTF-8 encoding, and international characters are
   * allowed.
   * * Keys must start with a lowercase letter or international character.
   * * Each resource is limited to a maximum of 64 labels.
   *
   * Both keys and values are additionally constrained to be &lt;= 128 bytes.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5;</code>
   */
  java.util.Map<java.lang.String, java.lang.String> getLabelsMap();
  /**
   *
   *
   * <pre>
   * Labels are attributes that can be set and used by both the
   * user and by Cloud Deploy. Labels must meet the following constraints:
   *
   * * Keys and values can contain only lowercase letters, numeric characters,
   * underscores, and dashes.
   * * All characters must use UTF-8 encoding, and international characters are
   * allowed.
   * * Keys must start with a lowercase letter or international character.
   * * Each resource is limited to a maximum of 64 labels.
   *
   * Both keys and values are additionally constrained to be &lt;= 128 bytes.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5;</code>
   */
  /* nullable */
  java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue);
  /**
   *
   *
   * <pre>
   * Labels are attributes that can be set and used by both the
   * user and by Cloud Deploy. Labels must meet the following constraints:
   *
   * * Keys and values can contain only lowercase letters, numeric characters,
   * underscores, and dashes.
   * * All characters must use UTF-8 encoding, and international characters are
   * allowed.
   * * Keys must start with a lowercase letter or international character.
   * * Each resource is limited to a maximum of 64 labels.
   *
   * Both keys and values are additionally constrained to be &lt;= 128 bytes.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5;</code>
   */
  java.lang.String getLabelsOrThrow(java.lang.String key);

  /**
   *
   *
   * <pre>
   * Output only. Time at which the `Rollout` was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  boolean hasCreateTime();
  /**
   *
   *
   * <pre>
   * Output only. Time at which the `Rollout` was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  com.google.protobuf.Timestamp getCreateTime();
  /**
   *
   *
   * <pre>
   * Output only. Time at which the `Rollout` was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. Time at which the `Rollout` was approved.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp approve_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the approveTime field is set.
   */
  boolean hasApproveTime();
  /**
   *
   *
   * <pre>
   * Output only. Time at which the `Rollout` was approved.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp approve_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The approveTime.
   */
  com.google.protobuf.Timestamp getApproveTime();
  /**
   *
   *
   * <pre>
   * Output only. Time at which the `Rollout` was approved.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp approve_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getApproveTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. Time at which the `Rollout` was enqueued.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp enqueue_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the enqueueTime field is set.
   */
  boolean hasEnqueueTime();
  /**
   *
   *
   * <pre>
   * Output only. Time at which the `Rollout` was enqueued.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp enqueue_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enqueueTime.
   */
  com.google.protobuf.Timestamp getEnqueueTime();
  /**
   *
   *
   * <pre>
   * Output only. Time at which the `Rollout` was enqueued.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp enqueue_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getEnqueueTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. Time at which the `Rollout` started deploying.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp deploy_start_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the deployStartTime field is set.
   */
  boolean hasDeployStartTime();
  /**
   *
   *
   * <pre>
   * Output only. Time at which the `Rollout` started deploying.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp deploy_start_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The deployStartTime.
   */
  com.google.protobuf.Timestamp getDeployStartTime();
  /**
   *
   *
   * <pre>
   * Output only. Time at which the `Rollout` started deploying.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp deploy_start_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getDeployStartTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. Time at which the `Rollout` finished deploying.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp deploy_end_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the deployEndTime field is set.
   */
  boolean hasDeployEndTime();
  /**
   *
   *
   * <pre>
   * Output only. Time at which the `Rollout` finished deploying.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp deploy_end_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The deployEndTime.
   */
  com.google.protobuf.Timestamp getDeployEndTime();
  /**
   *
   *
   * <pre>
   * Output only. Time at which the `Rollout` finished deploying.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp deploy_end_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getDeployEndTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Required. The ID of Target to which this `Rollout` is deploying.
   * </pre>
   *
   * <code>string target_id = 18 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The targetId.
   */
  java.lang.String getTargetId();
  /**
   *
   *
   * <pre>
   * Required. The ID of Target to which this `Rollout` is deploying.
   * </pre>
   *
   * <code>string target_id = 18 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for targetId.
   */
  com.google.protobuf.ByteString getTargetIdBytes();

  /**
   *
   *
   * <pre>
   * Output only. Approval state of the `Rollout`.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.Rollout.ApprovalState approval_state = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for approvalState.
   */
  int getApprovalStateValue();
  /**
   *
   *
   * <pre>
   * Output only. Approval state of the `Rollout`.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.Rollout.ApprovalState approval_state = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The approvalState.
   */
  com.google.cloud.deploy.v1.Rollout.ApprovalState getApprovalState();

  /**
   *
   *
   * <pre>
   * Output only. Current state of the `Rollout`.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.Rollout.State state = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  int getStateValue();
  /**
   *
   *
   * <pre>
   * Output only. Current state of the `Rollout`.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.Rollout.State state = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  com.google.cloud.deploy.v1.Rollout.State getState();

  /**
   *
   *
   * <pre>
   * Output only. Additional information about the rollout failure, if
   * available.
   * </pre>
   *
   * <code>string failure_reason = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The failureReason.
   */
  java.lang.String getFailureReason();
  /**
   *
   *
   * <pre>
   * Output only. Additional information about the rollout failure, if
   * available.
   * </pre>
   *
   * <code>string failure_reason = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for failureReason.
   */
  com.google.protobuf.ByteString getFailureReasonBytes();

  /**
   *
   *
   * <pre>
   * Output only. The resource name of the Cloud Build `Build` object that is
   * used to deploy the Rollout. Format is
   * `projects/{project}/locations/{location}/builds/{build}`.
   * </pre>
   *
   * <code>
   * string deploying_build = 17 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The deployingBuild.
   */
  java.lang.String getDeployingBuild();
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the Cloud Build `Build` object that is
   * used to deploy the Rollout. Format is
   * `projects/{project}/locations/{location}/builds/{build}`.
   * </pre>
   *
   * <code>
   * string deploying_build = 17 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for deployingBuild.
   */
  com.google.protobuf.ByteString getDeployingBuildBytes();

  /**
   *
   *
   * <pre>
   * This checksum is computed by the server based on the value of other
   * fields, and may be sent on update and delete requests to ensure the
   * client has an up-to-date value before proceeding.
   * </pre>
   *
   * <code>string etag = 16;</code>
   *
   * @return The etag.
   */
  java.lang.String getEtag();
  /**
   *
   *
   * <pre>
   * This checksum is computed by the server based on the value of other
   * fields, and may be sent on update and delete requests to ensure the
   * client has an up-to-date value before proceeding.
   * </pre>
   *
   * <code>string etag = 16;</code>
   *
   * @return The bytes for etag.
   */
  com.google.protobuf.ByteString getEtagBytes();

  /**
   *
   *
   * <pre>
   * Output only. The reason this rollout failed. This will always be
   * unspecified while the rollout is in progress.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.Rollout.FailureCause deploy_failure_cause = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for deployFailureCause.
   */
  int getDeployFailureCauseValue();
  /**
   *
   *
   * <pre>
   * Output only. The reason this rollout failed. This will always be
   * unspecified while the rollout is in progress.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.Rollout.FailureCause deploy_failure_cause = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The deployFailureCause.
   */
  com.google.cloud.deploy.v1.Rollout.FailureCause getDeployFailureCause();

  /**
   *
   *
   * <pre>
   * Output only. The phases that represent the workflows of this `Rollout`.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.Phase phases = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  java.util.List<com.google.cloud.deploy.v1.Phase> getPhasesList();
  /**
   *
   *
   * <pre>
   * Output only. The phases that represent the workflows of this `Rollout`.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.Phase phases = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.cloud.deploy.v1.Phase getPhases(int index);
  /**
   *
   *
   * <pre>
   * Output only. The phases that represent the workflows of this `Rollout`.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.Phase phases = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  int getPhasesCount();
  /**
   *
   *
   * <pre>
   * Output only. The phases that represent the workflows of this `Rollout`.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.Phase phases = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  java.util.List<? extends com.google.cloud.deploy.v1.PhaseOrBuilder> getPhasesOrBuilderList();
  /**
   *
   *
   * <pre>
   * Output only. The phases that represent the workflows of this `Rollout`.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.Phase phases = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.cloud.deploy.v1.PhaseOrBuilder getPhasesOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * Output only. Metadata contains information about the rollout.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.Metadata metadata = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the metadata field is set.
   */
  boolean hasMetadata();
  /**
   *
   *
   * <pre>
   * Output only. Metadata contains information about the rollout.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.Metadata metadata = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The metadata.
   */
  com.google.cloud.deploy.v1.Metadata getMetadata();
  /**
   *
   *
   * <pre>
   * Output only. Metadata contains information about the rollout.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.Metadata metadata = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.cloud.deploy.v1.MetadataOrBuilder getMetadataOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. Name of the `ControllerRollout`. Format is
   * `projects/{project}/locations/{location}/deliveryPipelines/{deliveryPipeline}/releases/{release}/rollouts/[a-z][a-z0-9&#92;-]{0,62}`.
   * </pre>
   *
   * <code>string controller_rollout = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The controllerRollout.
   */
  java.lang.String getControllerRollout();
  /**
   *
   *
   * <pre>
   * Output only. Name of the `ControllerRollout`. Format is
   * `projects/{project}/locations/{location}/deliveryPipelines/{deliveryPipeline}/releases/{release}/rollouts/[a-z][a-z0-9&#92;-]{0,62}`.
   * </pre>
   *
   * <code>string controller_rollout = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for controllerRollout.
   */
  com.google.protobuf.ByteString getControllerRolloutBytes();

  /**
   *
   *
   * <pre>
   * Output only. Name of the `Rollout` that is rolled back by this `Rollout`.
   * Empty if this `Rollout` wasn't created as a rollback.
   * </pre>
   *
   * <code>string rollback_of_rollout = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The rollbackOfRollout.
   */
  java.lang.String getRollbackOfRollout();
  /**
   *
   *
   * <pre>
   * Output only. Name of the `Rollout` that is rolled back by this `Rollout`.
   * Empty if this `Rollout` wasn't created as a rollback.
   * </pre>
   *
   * <code>string rollback_of_rollout = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for rollbackOfRollout.
   */
  com.google.protobuf.ByteString getRollbackOfRolloutBytes();

  /**
   *
   *
   * <pre>
   * Output only. Names of `Rollouts` that rolled back this `Rollout`.
   * </pre>
   *
   * <code>
   * repeated string rolled_back_by_rollouts = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return A list containing the rolledBackByRollouts.
   */
  java.util.List<java.lang.String> getRolledBackByRolloutsList();
  /**
   *
   *
   * <pre>
   * Output only. Names of `Rollouts` that rolled back this `Rollout`.
   * </pre>
   *
   * <code>
   * repeated string rolled_back_by_rollouts = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The count of rolledBackByRollouts.
   */
  int getRolledBackByRolloutsCount();
  /**
   *
   *
   * <pre>
   * Output only. Names of `Rollouts` that rolled back this `Rollout`.
   * </pre>
   *
   * <code>
   * repeated string rolled_back_by_rollouts = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The rolledBackByRollouts at the given index.
   */
  java.lang.String getRolledBackByRollouts(int index);
  /**
   *
   *
   * <pre>
   * Output only. Names of `Rollouts` that rolled back this `Rollout`.
   * </pre>
   *
   * <code>
   * repeated string rolled_back_by_rollouts = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the rolledBackByRollouts at the given index.
   */
  com.google.protobuf.ByteString getRolledBackByRolloutsBytes(int index);
}
