/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/deploy/v1/cloud_deploy.proto

package com.google.cloud.deploy.v1;

/**
 *
 *
 * <pre>
 * Stage specifies a location to which to deploy.
 * </pre>
 *
 * Protobuf type {@code google.cloud.deploy.v1.Stage}
 */
public final class Stage extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.deploy.v1.Stage)
    StageOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Stage.newBuilder() to construct.
  private Stage(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Stage() {
    targetId_ = "";
    profiles_ = com.google.protobuf.LazyStringArrayList.emptyList();
    deployParameters_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Stage();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.deploy.v1.CloudDeployProto
        .internal_static_google_cloud_deploy_v1_Stage_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.deploy.v1.CloudDeployProto
        .internal_static_google_cloud_deploy_v1_Stage_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.deploy.v1.Stage.class, com.google.cloud.deploy.v1.Stage.Builder.class);
  }

  public static final int TARGET_ID_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object targetId_ = "";
  /**
   *
   *
   * <pre>
   * The target_id to which this stage points. This field refers exclusively to
   * the last segment of a target name. For example, this field would just be
   * `my-target` (rather than
   * `projects/project/locations/location/targets/my-target`). The location of
   * the `Target` is inferred to be the same as the location of the
   * `DeliveryPipeline` that contains this `Stage`.
   * </pre>
   *
   * <code>string target_id = 1;</code>
   *
   * @return The targetId.
   */
  @java.lang.Override
  public java.lang.String getTargetId() {
    java.lang.Object ref = targetId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      targetId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The target_id to which this stage points. This field refers exclusively to
   * the last segment of a target name. For example, this field would just be
   * `my-target` (rather than
   * `projects/project/locations/location/targets/my-target`). The location of
   * the `Target` is inferred to be the same as the location of the
   * `DeliveryPipeline` that contains this `Stage`.
   * </pre>
   *
   * <code>string target_id = 1;</code>
   *
   * @return The bytes for targetId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTargetIdBytes() {
    java.lang.Object ref = targetId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      targetId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PROFILES_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList profiles_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Skaffold profiles to use when rendering the manifest for this stage's
   * `Target`.
   * </pre>
   *
   * <code>repeated string profiles = 2;</code>
   *
   * @return A list containing the profiles.
   */
  public com.google.protobuf.ProtocolStringList getProfilesList() {
    return profiles_;
  }
  /**
   *
   *
   * <pre>
   * Skaffold profiles to use when rendering the manifest for this stage's
   * `Target`.
   * </pre>
   *
   * <code>repeated string profiles = 2;</code>
   *
   * @return The count of profiles.
   */
  public int getProfilesCount() {
    return profiles_.size();
  }
  /**
   *
   *
   * <pre>
   * Skaffold profiles to use when rendering the manifest for this stage's
   * `Target`.
   * </pre>
   *
   * <code>repeated string profiles = 2;</code>
   *
   * @param index The index of the element to return.
   * @return The profiles at the given index.
   */
  public java.lang.String getProfiles(int index) {
    return profiles_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Skaffold profiles to use when rendering the manifest for this stage's
   * `Target`.
   * </pre>
   *
   * <code>repeated string profiles = 2;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the profiles at the given index.
   */
  public com.google.protobuf.ByteString getProfilesBytes(int index) {
    return profiles_.getByteString(index);
  }

  public static final int STRATEGY_FIELD_NUMBER = 5;
  private com.google.cloud.deploy.v1.Strategy strategy_;
  /**
   *
   *
   * <pre>
   * Optional. The strategy to use for a `Rollout` to this stage.
   * </pre>
   *
   * <code>.google.cloud.deploy.v1.Strategy strategy = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the strategy field is set.
   */
  @java.lang.Override
  public boolean hasStrategy() {
    return strategy_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. The strategy to use for a `Rollout` to this stage.
   * </pre>
   *
   * <code>.google.cloud.deploy.v1.Strategy strategy = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The strategy.
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.Strategy getStrategy() {
    return strategy_ == null ? com.google.cloud.deploy.v1.Strategy.getDefaultInstance() : strategy_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The strategy to use for a `Rollout` to this stage.
   * </pre>
   *
   * <code>.google.cloud.deploy.v1.Strategy strategy = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.StrategyOrBuilder getStrategyOrBuilder() {
    return strategy_ == null ? com.google.cloud.deploy.v1.Strategy.getDefaultInstance() : strategy_;
  }

  public static final int DEPLOY_PARAMETERS_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.deploy.v1.DeployParameters> deployParameters_;
  /**
   *
   *
   * <pre>
   * Optional. The deploy parameters to use for the target in this stage.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.DeployParameters deploy_parameters = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.deploy.v1.DeployParameters> getDeployParametersList() {
    return deployParameters_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The deploy parameters to use for the target in this stage.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.DeployParameters deploy_parameters = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.deploy.v1.DeployParametersOrBuilder>
      getDeployParametersOrBuilderList() {
    return deployParameters_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The deploy parameters to use for the target in this stage.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.DeployParameters deploy_parameters = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getDeployParametersCount() {
    return deployParameters_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. The deploy parameters to use for the target in this stage.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.DeployParameters deploy_parameters = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.DeployParameters getDeployParameters(int index) {
    return deployParameters_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. The deploy parameters to use for the target in this stage.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.DeployParameters deploy_parameters = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.DeployParametersOrBuilder getDeployParametersOrBuilder(
      int index) {
    return deployParameters_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(targetId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, targetId_);
    }
    for (int i = 0; i < profiles_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, profiles_.getRaw(i));
    }
    if (strategy_ != null) {
      output.writeMessage(5, getStrategy());
    }
    for (int i = 0; i < deployParameters_.size(); i++) {
      output.writeMessage(6, deployParameters_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(targetId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, targetId_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < profiles_.size(); i++) {
        dataSize += computeStringSizeNoTag(profiles_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getProfilesList().size();
    }
    if (strategy_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getStrategy());
    }
    for (int i = 0; i < deployParameters_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, deployParameters_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.deploy.v1.Stage)) {
      return super.equals(obj);
    }
    com.google.cloud.deploy.v1.Stage other = (com.google.cloud.deploy.v1.Stage) obj;

    if (!getTargetId().equals(other.getTargetId())) return false;
    if (!getProfilesList().equals(other.getProfilesList())) return false;
    if (hasStrategy() != other.hasStrategy()) return false;
    if (hasStrategy()) {
      if (!getStrategy().equals(other.getStrategy())) return false;
    }
    if (!getDeployParametersList().equals(other.getDeployParametersList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TARGET_ID_FIELD_NUMBER;
    hash = (53 * hash) + getTargetId().hashCode();
    if (getProfilesCount() > 0) {
      hash = (37 * hash) + PROFILES_FIELD_NUMBER;
      hash = (53 * hash) + getProfilesList().hashCode();
    }
    if (hasStrategy()) {
      hash = (37 * hash) + STRATEGY_FIELD_NUMBER;
      hash = (53 * hash) + getStrategy().hashCode();
    }
    if (getDeployParametersCount() > 0) {
      hash = (37 * hash) + DEPLOY_PARAMETERS_FIELD_NUMBER;
      hash = (53 * hash) + getDeployParametersList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.deploy.v1.Stage parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.Stage parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.Stage parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.Stage parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.Stage parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.Stage parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.Stage parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.Stage parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.Stage parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.Stage parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.Stage parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.Stage parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.deploy.v1.Stage prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Stage specifies a location to which to deploy.
   * </pre>
   *
   * Protobuf type {@code google.cloud.deploy.v1.Stage}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.deploy.v1.Stage)
      com.google.cloud.deploy.v1.StageOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_Stage_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_Stage_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.deploy.v1.Stage.class,
              com.google.cloud.deploy.v1.Stage.Builder.class);
    }

    // Construct using com.google.cloud.deploy.v1.Stage.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      targetId_ = "";
      profiles_ = com.google.protobuf.LazyStringArrayList.emptyList();
      strategy_ = null;
      if (strategyBuilder_ != null) {
        strategyBuilder_.dispose();
        strategyBuilder_ = null;
      }
      if (deployParametersBuilder_ == null) {
        deployParameters_ = java.util.Collections.emptyList();
      } else {
        deployParameters_ = null;
        deployParametersBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_Stage_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.Stage getDefaultInstanceForType() {
      return com.google.cloud.deploy.v1.Stage.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.Stage build() {
      com.google.cloud.deploy.v1.Stage result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.Stage buildPartial() {
      com.google.cloud.deploy.v1.Stage result = new com.google.cloud.deploy.v1.Stage(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.deploy.v1.Stage result) {
      if (deployParametersBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          deployParameters_ = java.util.Collections.unmodifiableList(deployParameters_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.deployParameters_ = deployParameters_;
      } else {
        result.deployParameters_ = deployParametersBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.deploy.v1.Stage result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.targetId_ = targetId_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        profiles_.makeImmutable();
        result.profiles_ = profiles_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.strategy_ = strategyBuilder_ == null ? strategy_ : strategyBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.deploy.v1.Stage) {
        return mergeFrom((com.google.cloud.deploy.v1.Stage) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.deploy.v1.Stage other) {
      if (other == com.google.cloud.deploy.v1.Stage.getDefaultInstance()) return this;
      if (!other.getTargetId().isEmpty()) {
        targetId_ = other.targetId_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.profiles_.isEmpty()) {
        if (profiles_.isEmpty()) {
          profiles_ = other.profiles_;
          bitField0_ |= 0x00000002;
        } else {
          ensureProfilesIsMutable();
          profiles_.addAll(other.profiles_);
        }
        onChanged();
      }
      if (other.hasStrategy()) {
        mergeStrategy(other.getStrategy());
      }
      if (deployParametersBuilder_ == null) {
        if (!other.deployParameters_.isEmpty()) {
          if (deployParameters_.isEmpty()) {
            deployParameters_ = other.deployParameters_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureDeployParametersIsMutable();
            deployParameters_.addAll(other.deployParameters_);
          }
          onChanged();
        }
      } else {
        if (!other.deployParameters_.isEmpty()) {
          if (deployParametersBuilder_.isEmpty()) {
            deployParametersBuilder_.dispose();
            deployParametersBuilder_ = null;
            deployParameters_ = other.deployParameters_;
            bitField0_ = (bitField0_ & ~0x00000008);
            deployParametersBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getDeployParametersFieldBuilder()
                    : null;
          } else {
            deployParametersBuilder_.addAllMessages(other.deployParameters_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                targetId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureProfilesIsMutable();
                profiles_.add(s);
                break;
              } // case 18
            case 42:
              {
                input.readMessage(getStrategyFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 42
            case 50:
              {
                com.google.cloud.deploy.v1.DeployParameters m =
                    input.readMessage(
                        com.google.cloud.deploy.v1.DeployParameters.parser(), extensionRegistry);
                if (deployParametersBuilder_ == null) {
                  ensureDeployParametersIsMutable();
                  deployParameters_.add(m);
                } else {
                  deployParametersBuilder_.addMessage(m);
                }
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object targetId_ = "";
    /**
     *
     *
     * <pre>
     * The target_id to which this stage points. This field refers exclusively to
     * the last segment of a target name. For example, this field would just be
     * `my-target` (rather than
     * `projects/project/locations/location/targets/my-target`). The location of
     * the `Target` is inferred to be the same as the location of the
     * `DeliveryPipeline` that contains this `Stage`.
     * </pre>
     *
     * <code>string target_id = 1;</code>
     *
     * @return The targetId.
     */
    public java.lang.String getTargetId() {
      java.lang.Object ref = targetId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        targetId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The target_id to which this stage points. This field refers exclusively to
     * the last segment of a target name. For example, this field would just be
     * `my-target` (rather than
     * `projects/project/locations/location/targets/my-target`). The location of
     * the `Target` is inferred to be the same as the location of the
     * `DeliveryPipeline` that contains this `Stage`.
     * </pre>
     *
     * <code>string target_id = 1;</code>
     *
     * @return The bytes for targetId.
     */
    public com.google.protobuf.ByteString getTargetIdBytes() {
      java.lang.Object ref = targetId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        targetId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The target_id to which this stage points. This field refers exclusively to
     * the last segment of a target name. For example, this field would just be
     * `my-target` (rather than
     * `projects/project/locations/location/targets/my-target`). The location of
     * the `Target` is inferred to be the same as the location of the
     * `DeliveryPipeline` that contains this `Stage`.
     * </pre>
     *
     * <code>string target_id = 1;</code>
     *
     * @param value The targetId to set.
     * @return This builder for chaining.
     */
    public Builder setTargetId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      targetId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The target_id to which this stage points. This field refers exclusively to
     * the last segment of a target name. For example, this field would just be
     * `my-target` (rather than
     * `projects/project/locations/location/targets/my-target`). The location of
     * the `Target` is inferred to be the same as the location of the
     * `DeliveryPipeline` that contains this `Stage`.
     * </pre>
     *
     * <code>string target_id = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTargetId() {
      targetId_ = getDefaultInstance().getTargetId();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The target_id to which this stage points. This field refers exclusively to
     * the last segment of a target name. For example, this field would just be
     * `my-target` (rather than
     * `projects/project/locations/location/targets/my-target`). The location of
     * the `Target` is inferred to be the same as the location of the
     * `DeliveryPipeline` that contains this `Stage`.
     * </pre>
     *
     * <code>string target_id = 1;</code>
     *
     * @param value The bytes for targetId to set.
     * @return This builder for chaining.
     */
    public Builder setTargetIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      targetId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList profiles_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureProfilesIsMutable() {
      if (!profiles_.isModifiable()) {
        profiles_ = new com.google.protobuf.LazyStringArrayList(profiles_);
      }
      bitField0_ |= 0x00000002;
    }
    /**
     *
     *
     * <pre>
     * Skaffold profiles to use when rendering the manifest for this stage's
     * `Target`.
     * </pre>
     *
     * <code>repeated string profiles = 2;</code>
     *
     * @return A list containing the profiles.
     */
    public com.google.protobuf.ProtocolStringList getProfilesList() {
      profiles_.makeImmutable();
      return profiles_;
    }
    /**
     *
     *
     * <pre>
     * Skaffold profiles to use when rendering the manifest for this stage's
     * `Target`.
     * </pre>
     *
     * <code>repeated string profiles = 2;</code>
     *
     * @return The count of profiles.
     */
    public int getProfilesCount() {
      return profiles_.size();
    }
    /**
     *
     *
     * <pre>
     * Skaffold profiles to use when rendering the manifest for this stage's
     * `Target`.
     * </pre>
     *
     * <code>repeated string profiles = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The profiles at the given index.
     */
    public java.lang.String getProfiles(int index) {
      return profiles_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Skaffold profiles to use when rendering the manifest for this stage's
     * `Target`.
     * </pre>
     *
     * <code>repeated string profiles = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the profiles at the given index.
     */
    public com.google.protobuf.ByteString getProfilesBytes(int index) {
      return profiles_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Skaffold profiles to use when rendering the manifest for this stage's
     * `Target`.
     * </pre>
     *
     * <code>repeated string profiles = 2;</code>
     *
     * @param index The index to set the value at.
     * @param value The profiles to set.
     * @return This builder for chaining.
     */
    public Builder setProfiles(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureProfilesIsMutable();
      profiles_.set(index, value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Skaffold profiles to use when rendering the manifest for this stage's
     * `Target`.
     * </pre>
     *
     * <code>repeated string profiles = 2;</code>
     *
     * @param value The profiles to add.
     * @return This builder for chaining.
     */
    public Builder addProfiles(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureProfilesIsMutable();
      profiles_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Skaffold profiles to use when rendering the manifest for this stage's
     * `Target`.
     * </pre>
     *
     * <code>repeated string profiles = 2;</code>
     *
     * @param values The profiles to add.
     * @return This builder for chaining.
     */
    public Builder addAllProfiles(java.lang.Iterable<java.lang.String> values) {
      ensureProfilesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, profiles_);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Skaffold profiles to use when rendering the manifest for this stage's
     * `Target`.
     * </pre>
     *
     * <code>repeated string profiles = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProfiles() {
      profiles_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Skaffold profiles to use when rendering the manifest for this stage's
     * `Target`.
     * </pre>
     *
     * <code>repeated string profiles = 2;</code>
     *
     * @param value The bytes of the profiles to add.
     * @return This builder for chaining.
     */
    public Builder addProfilesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureProfilesIsMutable();
      profiles_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.cloud.deploy.v1.Strategy strategy_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.Strategy,
            com.google.cloud.deploy.v1.Strategy.Builder,
            com.google.cloud.deploy.v1.StrategyOrBuilder>
        strategyBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The strategy to use for a `Rollout` to this stage.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Strategy strategy = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the strategy field is set.
     */
    public boolean hasStrategy() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The strategy to use for a `Rollout` to this stage.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Strategy strategy = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The strategy.
     */
    public com.google.cloud.deploy.v1.Strategy getStrategy() {
      if (strategyBuilder_ == null) {
        return strategy_ == null
            ? com.google.cloud.deploy.v1.Strategy.getDefaultInstance()
            : strategy_;
      } else {
        return strategyBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The strategy to use for a `Rollout` to this stage.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Strategy strategy = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setStrategy(com.google.cloud.deploy.v1.Strategy value) {
      if (strategyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        strategy_ = value;
      } else {
        strategyBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The strategy to use for a `Rollout` to this stage.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Strategy strategy = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setStrategy(com.google.cloud.deploy.v1.Strategy.Builder builderForValue) {
      if (strategyBuilder_ == null) {
        strategy_ = builderForValue.build();
      } else {
        strategyBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The strategy to use for a `Rollout` to this stage.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Strategy strategy = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeStrategy(com.google.cloud.deploy.v1.Strategy value) {
      if (strategyBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && strategy_ != null
            && strategy_ != com.google.cloud.deploy.v1.Strategy.getDefaultInstance()) {
          getStrategyBuilder().mergeFrom(value);
        } else {
          strategy_ = value;
        }
      } else {
        strategyBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The strategy to use for a `Rollout` to this stage.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Strategy strategy = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearStrategy() {
      bitField0_ = (bitField0_ & ~0x00000004);
      strategy_ = null;
      if (strategyBuilder_ != null) {
        strategyBuilder_.dispose();
        strategyBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The strategy to use for a `Rollout` to this stage.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Strategy strategy = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.deploy.v1.Strategy.Builder getStrategyBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getStrategyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The strategy to use for a `Rollout` to this stage.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Strategy strategy = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.deploy.v1.StrategyOrBuilder getStrategyOrBuilder() {
      if (strategyBuilder_ != null) {
        return strategyBuilder_.getMessageOrBuilder();
      } else {
        return strategy_ == null
            ? com.google.cloud.deploy.v1.Strategy.getDefaultInstance()
            : strategy_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The strategy to use for a `Rollout` to this stage.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Strategy strategy = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.Strategy,
            com.google.cloud.deploy.v1.Strategy.Builder,
            com.google.cloud.deploy.v1.StrategyOrBuilder>
        getStrategyFieldBuilder() {
      if (strategyBuilder_ == null) {
        strategyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.deploy.v1.Strategy,
                com.google.cloud.deploy.v1.Strategy.Builder,
                com.google.cloud.deploy.v1.StrategyOrBuilder>(
                getStrategy(), getParentForChildren(), isClean());
        strategy_ = null;
      }
      return strategyBuilder_;
    }

    private java.util.List<com.google.cloud.deploy.v1.DeployParameters> deployParameters_ =
        java.util.Collections.emptyList();

    private void ensureDeployParametersIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        deployParameters_ =
            new java.util.ArrayList<com.google.cloud.deploy.v1.DeployParameters>(deployParameters_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.deploy.v1.DeployParameters,
            com.google.cloud.deploy.v1.DeployParameters.Builder,
            com.google.cloud.deploy.v1.DeployParametersOrBuilder>
        deployParametersBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. The deploy parameters to use for the target in this stage.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.DeployParameters deploy_parameters = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.deploy.v1.DeployParameters> getDeployParametersList() {
      if (deployParametersBuilder_ == null) {
        return java.util.Collections.unmodifiableList(deployParameters_);
      } else {
        return deployParametersBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The deploy parameters to use for the target in this stage.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.DeployParameters deploy_parameters = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getDeployParametersCount() {
      if (deployParametersBuilder_ == null) {
        return deployParameters_.size();
      } else {
        return deployParametersBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The deploy parameters to use for the target in this stage.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.DeployParameters deploy_parameters = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.deploy.v1.DeployParameters getDeployParameters(int index) {
      if (deployParametersBuilder_ == null) {
        return deployParameters_.get(index);
      } else {
        return deployParametersBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The deploy parameters to use for the target in this stage.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.DeployParameters deploy_parameters = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setDeployParameters(
        int index, com.google.cloud.deploy.v1.DeployParameters value) {
      if (deployParametersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDeployParametersIsMutable();
        deployParameters_.set(index, value);
        onChanged();
      } else {
        deployParametersBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The deploy parameters to use for the target in this stage.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.DeployParameters deploy_parameters = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setDeployParameters(
        int index, com.google.cloud.deploy.v1.DeployParameters.Builder builderForValue) {
      if (deployParametersBuilder_ == null) {
        ensureDeployParametersIsMutable();
        deployParameters_.set(index, builderForValue.build());
        onChanged();
      } else {
        deployParametersBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The deploy parameters to use for the target in this stage.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.DeployParameters deploy_parameters = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addDeployParameters(com.google.cloud.deploy.v1.DeployParameters value) {
      if (deployParametersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDeployParametersIsMutable();
        deployParameters_.add(value);
        onChanged();
      } else {
        deployParametersBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The deploy parameters to use for the target in this stage.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.DeployParameters deploy_parameters = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addDeployParameters(
        int index, com.google.cloud.deploy.v1.DeployParameters value) {
      if (deployParametersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDeployParametersIsMutable();
        deployParameters_.add(index, value);
        onChanged();
      } else {
        deployParametersBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The deploy parameters to use for the target in this stage.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.DeployParameters deploy_parameters = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addDeployParameters(
        com.google.cloud.deploy.v1.DeployParameters.Builder builderForValue) {
      if (deployParametersBuilder_ == null) {
        ensureDeployParametersIsMutable();
        deployParameters_.add(builderForValue.build());
        onChanged();
      } else {
        deployParametersBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The deploy parameters to use for the target in this stage.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.DeployParameters deploy_parameters = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addDeployParameters(
        int index, com.google.cloud.deploy.v1.DeployParameters.Builder builderForValue) {
      if (deployParametersBuilder_ == null) {
        ensureDeployParametersIsMutable();
        deployParameters_.add(index, builderForValue.build());
        onChanged();
      } else {
        deployParametersBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The deploy parameters to use for the target in this stage.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.DeployParameters deploy_parameters = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllDeployParameters(
        java.lang.Iterable<? extends com.google.cloud.deploy.v1.DeployParameters> values) {
      if (deployParametersBuilder_ == null) {
        ensureDeployParametersIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, deployParameters_);
        onChanged();
      } else {
        deployParametersBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The deploy parameters to use for the target in this stage.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.DeployParameters deploy_parameters = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearDeployParameters() {
      if (deployParametersBuilder_ == null) {
        deployParameters_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        deployParametersBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The deploy parameters to use for the target in this stage.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.DeployParameters deploy_parameters = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeDeployParameters(int index) {
      if (deployParametersBuilder_ == null) {
        ensureDeployParametersIsMutable();
        deployParameters_.remove(index);
        onChanged();
      } else {
        deployParametersBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The deploy parameters to use for the target in this stage.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.DeployParameters deploy_parameters = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.deploy.v1.DeployParameters.Builder getDeployParametersBuilder(
        int index) {
      return getDeployParametersFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. The deploy parameters to use for the target in this stage.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.DeployParameters deploy_parameters = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.deploy.v1.DeployParametersOrBuilder getDeployParametersOrBuilder(
        int index) {
      if (deployParametersBuilder_ == null) {
        return deployParameters_.get(index);
      } else {
        return deployParametersBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The deploy parameters to use for the target in this stage.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.DeployParameters deploy_parameters = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.deploy.v1.DeployParametersOrBuilder>
        getDeployParametersOrBuilderList() {
      if (deployParametersBuilder_ != null) {
        return deployParametersBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(deployParameters_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The deploy parameters to use for the target in this stage.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.DeployParameters deploy_parameters = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.deploy.v1.DeployParameters.Builder addDeployParametersBuilder() {
      return getDeployParametersFieldBuilder()
          .addBuilder(com.google.cloud.deploy.v1.DeployParameters.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. The deploy parameters to use for the target in this stage.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.DeployParameters deploy_parameters = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.deploy.v1.DeployParameters.Builder addDeployParametersBuilder(
        int index) {
      return getDeployParametersFieldBuilder()
          .addBuilder(index, com.google.cloud.deploy.v1.DeployParameters.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. The deploy parameters to use for the target in this stage.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.DeployParameters deploy_parameters = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.deploy.v1.DeployParameters.Builder>
        getDeployParametersBuilderList() {
      return getDeployParametersFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.deploy.v1.DeployParameters,
            com.google.cloud.deploy.v1.DeployParameters.Builder,
            com.google.cloud.deploy.v1.DeployParametersOrBuilder>
        getDeployParametersFieldBuilder() {
      if (deployParametersBuilder_ == null) {
        deployParametersBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.deploy.v1.DeployParameters,
                com.google.cloud.deploy.v1.DeployParameters.Builder,
                com.google.cloud.deploy.v1.DeployParametersOrBuilder>(
                deployParameters_,
                ((bitField0_ & 0x00000008) != 0),
                getParentForChildren(),
                isClean());
        deployParameters_ = null;
      }
      return deployParametersBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.deploy.v1.Stage)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.deploy.v1.Stage)
  private static final com.google.cloud.deploy.v1.Stage DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.deploy.v1.Stage();
  }

  public static com.google.cloud.deploy.v1.Stage getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Stage> PARSER =
      new com.google.protobuf.AbstractParser<Stage>() {
        @java.lang.Override
        public Stage parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Stage> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Stage> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.deploy.v1.Stage getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
