/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/deploy/v1/cloud_deploy.proto

package com.google.cloud.deploy.v1;

/**
 *
 *
 * <pre>
 * The `AdvanceRollout` automation rule will automatically advance a successful
 * Rollout to the next phase.
 * </pre>
 *
 * Protobuf type {@code google.cloud.deploy.v1.AdvanceRolloutRule}
 */
public final class AdvanceRolloutRule extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.deploy.v1.AdvanceRolloutRule)
    AdvanceRolloutRuleOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AdvanceRolloutRule.newBuilder() to construct.
  private AdvanceRolloutRule(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AdvanceRolloutRule() {
    id_ = "";
    sourcePhases_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AdvanceRolloutRule();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.deploy.v1.CloudDeployProto
        .internal_static_google_cloud_deploy_v1_AdvanceRolloutRule_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.deploy.v1.CloudDeployProto
        .internal_static_google_cloud_deploy_v1_AdvanceRolloutRule_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.deploy.v1.AdvanceRolloutRule.class,
            com.google.cloud.deploy.v1.AdvanceRolloutRule.Builder.class);
  }

  public static final int ID_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object id_ = "";
  /**
   *
   *
   * <pre>
   * Required. ID of the rule. This id must be unique in the `Automation`
   * resource to which this rule belongs. The format is `[a-z][a-z0-9&#92;-]{0,62}`.
   * </pre>
   *
   * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public java.lang.String getId() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      id_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. ID of the rule. This id must be unique in the `Automation`
   * resource to which this rule belongs. The format is `[a-z][a-z0-9&#92;-]{0,62}`.
   * </pre>
   *
   * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for id.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIdBytes() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      id_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SOURCE_PHASES_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList sourcePhases_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Optional. Proceeds only after phase name matched any one in the list.
   * This value must consist of lower-case letters, numbers, and hyphens,
   * start with a letter and end with a letter or a number, and have a max
   * length of 63 characters. In other words, it must match the following
   * regex: `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
   * </pre>
   *
   * <code>repeated string source_phases = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return A list containing the sourcePhases.
   */
  public com.google.protobuf.ProtocolStringList getSourcePhasesList() {
    return sourcePhases_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Proceeds only after phase name matched any one in the list.
   * This value must consist of lower-case letters, numbers, and hyphens,
   * start with a letter and end with a letter or a number, and have a max
   * length of 63 characters. In other words, it must match the following
   * regex: `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
   * </pre>
   *
   * <code>repeated string source_phases = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The count of sourcePhases.
   */
  public int getSourcePhasesCount() {
    return sourcePhases_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Proceeds only after phase name matched any one in the list.
   * This value must consist of lower-case letters, numbers, and hyphens,
   * start with a letter and end with a letter or a number, and have a max
   * length of 63 characters. In other words, it must match the following
   * regex: `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
   * </pre>
   *
   * <code>repeated string source_phases = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the element to return.
   * @return The sourcePhases at the given index.
   */
  public java.lang.String getSourcePhases(int index) {
    return sourcePhases_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. Proceeds only after phase name matched any one in the list.
   * This value must consist of lower-case letters, numbers, and hyphens,
   * start with a letter and end with a letter or a number, and have a max
   * length of 63 characters. In other words, it must match the following
   * regex: `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
   * </pre>
   *
   * <code>repeated string source_phases = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the sourcePhases at the given index.
   */
  public com.google.protobuf.ByteString getSourcePhasesBytes(int index) {
    return sourcePhases_.getByteString(index);
  }

  public static final int WAIT_FIELD_NUMBER = 3;
  private com.google.protobuf.Duration wait_;
  /**
   *
   *
   * <pre>
   * Optional. How long to wait after a rollout is finished.
   * </pre>
   *
   * <code>.google.protobuf.Duration wait = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return Whether the wait field is set.
   */
  @java.lang.Override
  public boolean hasWait() {
    return wait_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. How long to wait after a rollout is finished.
   * </pre>
   *
   * <code>.google.protobuf.Duration wait = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The wait.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getWait() {
    return wait_ == null ? com.google.protobuf.Duration.getDefaultInstance() : wait_;
  }
  /**
   *
   *
   * <pre>
   * Optional. How long to wait after a rollout is finished.
   * </pre>
   *
   * <code>.google.protobuf.Duration wait = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getWaitOrBuilder() {
    return wait_ == null ? com.google.protobuf.Duration.getDefaultInstance() : wait_;
  }

  public static final int CONDITION_FIELD_NUMBER = 5;
  private com.google.cloud.deploy.v1.AutomationRuleCondition condition_;
  /**
   *
   *
   * <pre>
   * Output only. Information around the state of the Automation rule.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.AutomationRuleCondition condition = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the condition field is set.
   */
  @java.lang.Override
  public boolean hasCondition() {
    return condition_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Information around the state of the Automation rule.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.AutomationRuleCondition condition = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The condition.
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.AutomationRuleCondition getCondition() {
    return condition_ == null
        ? com.google.cloud.deploy.v1.AutomationRuleCondition.getDefaultInstance()
        : condition_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Information around the state of the Automation rule.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.AutomationRuleCondition condition = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.AutomationRuleConditionOrBuilder getConditionOrBuilder() {
    return condition_ == null
        ? com.google.cloud.deploy.v1.AutomationRuleCondition.getDefaultInstance()
        : condition_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, id_);
    }
    if (wait_ != null) {
      output.writeMessage(3, getWait());
    }
    if (condition_ != null) {
      output.writeMessage(5, getCondition());
    }
    for (int i = 0; i < sourcePhases_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, sourcePhases_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, id_);
    }
    if (wait_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getWait());
    }
    if (condition_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getCondition());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < sourcePhases_.size(); i++) {
        dataSize += computeStringSizeNoTag(sourcePhases_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getSourcePhasesList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.deploy.v1.AdvanceRolloutRule)) {
      return super.equals(obj);
    }
    com.google.cloud.deploy.v1.AdvanceRolloutRule other =
        (com.google.cloud.deploy.v1.AdvanceRolloutRule) obj;

    if (!getId().equals(other.getId())) return false;
    if (!getSourcePhasesList().equals(other.getSourcePhasesList())) return false;
    if (hasWait() != other.hasWait()) return false;
    if (hasWait()) {
      if (!getWait().equals(other.getWait())) return false;
    }
    if (hasCondition() != other.hasCondition()) return false;
    if (hasCondition()) {
      if (!getCondition().equals(other.getCondition())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ID_FIELD_NUMBER;
    hash = (53 * hash) + getId().hashCode();
    if (getSourcePhasesCount() > 0) {
      hash = (37 * hash) + SOURCE_PHASES_FIELD_NUMBER;
      hash = (53 * hash) + getSourcePhasesList().hashCode();
    }
    if (hasWait()) {
      hash = (37 * hash) + WAIT_FIELD_NUMBER;
      hash = (53 * hash) + getWait().hashCode();
    }
    if (hasCondition()) {
      hash = (37 * hash) + CONDITION_FIELD_NUMBER;
      hash = (53 * hash) + getCondition().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.deploy.v1.AdvanceRolloutRule parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.AdvanceRolloutRule parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.AdvanceRolloutRule parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.AdvanceRolloutRule parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.AdvanceRolloutRule parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.AdvanceRolloutRule parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.AdvanceRolloutRule parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.AdvanceRolloutRule parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.AdvanceRolloutRule parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.AdvanceRolloutRule parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.AdvanceRolloutRule parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.AdvanceRolloutRule parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.deploy.v1.AdvanceRolloutRule prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The `AdvanceRollout` automation rule will automatically advance a successful
   * Rollout to the next phase.
   * </pre>
   *
   * Protobuf type {@code google.cloud.deploy.v1.AdvanceRolloutRule}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.deploy.v1.AdvanceRolloutRule)
      com.google.cloud.deploy.v1.AdvanceRolloutRuleOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_AdvanceRolloutRule_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_AdvanceRolloutRule_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.deploy.v1.AdvanceRolloutRule.class,
              com.google.cloud.deploy.v1.AdvanceRolloutRule.Builder.class);
    }

    // Construct using com.google.cloud.deploy.v1.AdvanceRolloutRule.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      id_ = "";
      sourcePhases_ = com.google.protobuf.LazyStringArrayList.emptyList();
      wait_ = null;
      if (waitBuilder_ != null) {
        waitBuilder_.dispose();
        waitBuilder_ = null;
      }
      condition_ = null;
      if (conditionBuilder_ != null) {
        conditionBuilder_.dispose();
        conditionBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_AdvanceRolloutRule_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.AdvanceRolloutRule getDefaultInstanceForType() {
      return com.google.cloud.deploy.v1.AdvanceRolloutRule.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.AdvanceRolloutRule build() {
      com.google.cloud.deploy.v1.AdvanceRolloutRule result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.AdvanceRolloutRule buildPartial() {
      com.google.cloud.deploy.v1.AdvanceRolloutRule result =
          new com.google.cloud.deploy.v1.AdvanceRolloutRule(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.deploy.v1.AdvanceRolloutRule result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.id_ = id_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        sourcePhases_.makeImmutable();
        result.sourcePhases_ = sourcePhases_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.wait_ = waitBuilder_ == null ? wait_ : waitBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.condition_ = conditionBuilder_ == null ? condition_ : conditionBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.deploy.v1.AdvanceRolloutRule) {
        return mergeFrom((com.google.cloud.deploy.v1.AdvanceRolloutRule) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.deploy.v1.AdvanceRolloutRule other) {
      if (other == com.google.cloud.deploy.v1.AdvanceRolloutRule.getDefaultInstance()) return this;
      if (!other.getId().isEmpty()) {
        id_ = other.id_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.sourcePhases_.isEmpty()) {
        if (sourcePhases_.isEmpty()) {
          sourcePhases_ = other.sourcePhases_;
          bitField0_ |= 0x00000002;
        } else {
          ensureSourcePhasesIsMutable();
          sourcePhases_.addAll(other.sourcePhases_);
        }
        onChanged();
      }
      if (other.hasWait()) {
        mergeWait(other.getWait());
      }
      if (other.hasCondition()) {
        mergeCondition(other.getCondition());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                id_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 26:
              {
                input.readMessage(getWaitFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 42:
              {
                input.readMessage(getConditionFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 42
            case 50:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureSourcePhasesIsMutable();
                sourcePhases_.add(s);
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object id_ = "";
    /**
     *
     *
     * <pre>
     * Required. ID of the rule. This id must be unique in the `Automation`
     * resource to which this rule belongs. The format is `[a-z][a-z0-9&#92;-]{0,62}`.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The id.
     */
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. ID of the rule. This id must be unique in the `Automation`
     * resource to which this rule belongs. The format is `[a-z][a-z0-9&#92;-]{0,62}`.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for id.
     */
    public com.google.protobuf.ByteString getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. ID of the rule. This id must be unique in the `Automation`
     * resource to which this rule belongs. The format is `[a-z][a-z0-9&#92;-]{0,62}`.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      id_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. ID of the rule. This id must be unique in the `Automation`
     * resource to which this rule belongs. The format is `[a-z][a-z0-9&#92;-]{0,62}`.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {
      id_ = getDefaultInstance().getId();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. ID of the rule. This id must be unique in the `Automation`
     * resource to which this rule belongs. The format is `[a-z][a-z0-9&#92;-]{0,62}`.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for id to set.
     * @return This builder for chaining.
     */
    public Builder setIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      id_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList sourcePhases_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureSourcePhasesIsMutable() {
      if (!sourcePhases_.isModifiable()) {
        sourcePhases_ = new com.google.protobuf.LazyStringArrayList(sourcePhases_);
      }
      bitField0_ |= 0x00000002;
    }
    /**
     *
     *
     * <pre>
     * Optional. Proceeds only after phase name matched any one in the list.
     * This value must consist of lower-case letters, numbers, and hyphens,
     * start with a letter and end with a letter or a number, and have a max
     * length of 63 characters. In other words, it must match the following
     * regex: `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
     * </pre>
     *
     * <code>repeated string source_phases = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the sourcePhases.
     */
    public com.google.protobuf.ProtocolStringList getSourcePhasesList() {
      sourcePhases_.makeImmutable();
      return sourcePhases_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Proceeds only after phase name matched any one in the list.
     * This value must consist of lower-case letters, numbers, and hyphens,
     * start with a letter and end with a letter or a number, and have a max
     * length of 63 characters. In other words, it must match the following
     * regex: `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
     * </pre>
     *
     * <code>repeated string source_phases = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of sourcePhases.
     */
    public int getSourcePhasesCount() {
      return sourcePhases_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Proceeds only after phase name matched any one in the list.
     * This value must consist of lower-case letters, numbers, and hyphens,
     * start with a letter and end with a letter or a number, and have a max
     * length of 63 characters. In other words, it must match the following
     * regex: `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
     * </pre>
     *
     * <code>repeated string source_phases = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The sourcePhases at the given index.
     */
    public java.lang.String getSourcePhases(int index) {
      return sourcePhases_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Proceeds only after phase name matched any one in the list.
     * This value must consist of lower-case letters, numbers, and hyphens,
     * start with a letter and end with a letter or a number, and have a max
     * length of 63 characters. In other words, it must match the following
     * regex: `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
     * </pre>
     *
     * <code>repeated string source_phases = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the sourcePhases at the given index.
     */
    public com.google.protobuf.ByteString getSourcePhasesBytes(int index) {
      return sourcePhases_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Proceeds only after phase name matched any one in the list.
     * This value must consist of lower-case letters, numbers, and hyphens,
     * start with a letter and end with a letter or a number, and have a max
     * length of 63 characters. In other words, it must match the following
     * regex: `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
     * </pre>
     *
     * <code>repeated string source_phases = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index to set the value at.
     * @param value The sourcePhases to set.
     * @return This builder for chaining.
     */
    public Builder setSourcePhases(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSourcePhasesIsMutable();
      sourcePhases_.set(index, value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Proceeds only after phase name matched any one in the list.
     * This value must consist of lower-case letters, numbers, and hyphens,
     * start with a letter and end with a letter or a number, and have a max
     * length of 63 characters. In other words, it must match the following
     * regex: `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
     * </pre>
     *
     * <code>repeated string source_phases = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The sourcePhases to add.
     * @return This builder for chaining.
     */
    public Builder addSourcePhases(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSourcePhasesIsMutable();
      sourcePhases_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Proceeds only after phase name matched any one in the list.
     * This value must consist of lower-case letters, numbers, and hyphens,
     * start with a letter and end with a letter or a number, and have a max
     * length of 63 characters. In other words, it must match the following
     * regex: `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
     * </pre>
     *
     * <code>repeated string source_phases = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param values The sourcePhases to add.
     * @return This builder for chaining.
     */
    public Builder addAllSourcePhases(java.lang.Iterable<java.lang.String> values) {
      ensureSourcePhasesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, sourcePhases_);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Proceeds only after phase name matched any one in the list.
     * This value must consist of lower-case letters, numbers, and hyphens,
     * start with a letter and end with a letter or a number, and have a max
     * length of 63 characters. In other words, it must match the following
     * regex: `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
     * </pre>
     *
     * <code>repeated string source_phases = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSourcePhases() {
      sourcePhases_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Proceeds only after phase name matched any one in the list.
     * This value must consist of lower-case letters, numbers, and hyphens,
     * start with a letter and end with a letter or a number, and have a max
     * length of 63 characters. In other words, it must match the following
     * regex: `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
     * </pre>
     *
     * <code>repeated string source_phases = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes of the sourcePhases to add.
     * @return This builder for chaining.
     */
    public Builder addSourcePhasesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureSourcePhasesIsMutable();
      sourcePhases_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.Duration wait_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        waitBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. How long to wait after a rollout is finished.
     * </pre>
     *
     * <code>.google.protobuf.Duration wait = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return Whether the wait field is set.
     */
    public boolean hasWait() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. How long to wait after a rollout is finished.
     * </pre>
     *
     * <code>.google.protobuf.Duration wait = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The wait.
     */
    public com.google.protobuf.Duration getWait() {
      if (waitBuilder_ == null) {
        return wait_ == null ? com.google.protobuf.Duration.getDefaultInstance() : wait_;
      } else {
        return waitBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. How long to wait after a rollout is finished.
     * </pre>
     *
     * <code>.google.protobuf.Duration wait = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder setWait(com.google.protobuf.Duration value) {
      if (waitBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        wait_ = value;
      } else {
        waitBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. How long to wait after a rollout is finished.
     * </pre>
     *
     * <code>.google.protobuf.Duration wait = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder setWait(com.google.protobuf.Duration.Builder builderForValue) {
      if (waitBuilder_ == null) {
        wait_ = builderForValue.build();
      } else {
        waitBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. How long to wait after a rollout is finished.
     * </pre>
     *
     * <code>.google.protobuf.Duration wait = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder mergeWait(com.google.protobuf.Duration value) {
      if (waitBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && wait_ != null
            && wait_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getWaitBuilder().mergeFrom(value);
        } else {
          wait_ = value;
        }
      } else {
        waitBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. How long to wait after a rollout is finished.
     * </pre>
     *
     * <code>.google.protobuf.Duration wait = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder clearWait() {
      bitField0_ = (bitField0_ & ~0x00000004);
      wait_ = null;
      if (waitBuilder_ != null) {
        waitBuilder_.dispose();
        waitBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. How long to wait after a rollout is finished.
     * </pre>
     *
     * <code>.google.protobuf.Duration wait = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public com.google.protobuf.Duration.Builder getWaitBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getWaitFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. How long to wait after a rollout is finished.
     * </pre>
     *
     * <code>.google.protobuf.Duration wait = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public com.google.protobuf.DurationOrBuilder getWaitOrBuilder() {
      if (waitBuilder_ != null) {
        return waitBuilder_.getMessageOrBuilder();
      } else {
        return wait_ == null ? com.google.protobuf.Duration.getDefaultInstance() : wait_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. How long to wait after a rollout is finished.
     * </pre>
     *
     * <code>.google.protobuf.Duration wait = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getWaitFieldBuilder() {
      if (waitBuilder_ == null) {
        waitBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getWait(), getParentForChildren(), isClean());
        wait_ = null;
      }
      return waitBuilder_;
    }

    private com.google.cloud.deploy.v1.AutomationRuleCondition condition_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.AutomationRuleCondition,
            com.google.cloud.deploy.v1.AutomationRuleCondition.Builder,
            com.google.cloud.deploy.v1.AutomationRuleConditionOrBuilder>
        conditionBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Information around the state of the Automation rule.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AutomationRuleCondition condition = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the condition field is set.
     */
    public boolean hasCondition() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Information around the state of the Automation rule.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AutomationRuleCondition condition = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The condition.
     */
    public com.google.cloud.deploy.v1.AutomationRuleCondition getCondition() {
      if (conditionBuilder_ == null) {
        return condition_ == null
            ? com.google.cloud.deploy.v1.AutomationRuleCondition.getDefaultInstance()
            : condition_;
      } else {
        return conditionBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Information around the state of the Automation rule.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AutomationRuleCondition condition = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCondition(com.google.cloud.deploy.v1.AutomationRuleCondition value) {
      if (conditionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        condition_ = value;
      } else {
        conditionBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information around the state of the Automation rule.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AutomationRuleCondition condition = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCondition(
        com.google.cloud.deploy.v1.AutomationRuleCondition.Builder builderForValue) {
      if (conditionBuilder_ == null) {
        condition_ = builderForValue.build();
      } else {
        conditionBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information around the state of the Automation rule.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AutomationRuleCondition condition = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCondition(com.google.cloud.deploy.v1.AutomationRuleCondition value) {
      if (conditionBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && condition_ != null
            && condition_
                != com.google.cloud.deploy.v1.AutomationRuleCondition.getDefaultInstance()) {
          getConditionBuilder().mergeFrom(value);
        } else {
          condition_ = value;
        }
      } else {
        conditionBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information around the state of the Automation rule.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AutomationRuleCondition condition = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCondition() {
      bitField0_ = (bitField0_ & ~0x00000008);
      condition_ = null;
      if (conditionBuilder_ != null) {
        conditionBuilder_.dispose();
        conditionBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information around the state of the Automation rule.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AutomationRuleCondition condition = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.deploy.v1.AutomationRuleCondition.Builder getConditionBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getConditionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Information around the state of the Automation rule.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AutomationRuleCondition condition = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.deploy.v1.AutomationRuleConditionOrBuilder getConditionOrBuilder() {
      if (conditionBuilder_ != null) {
        return conditionBuilder_.getMessageOrBuilder();
      } else {
        return condition_ == null
            ? com.google.cloud.deploy.v1.AutomationRuleCondition.getDefaultInstance()
            : condition_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Information around the state of the Automation rule.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AutomationRuleCondition condition = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.AutomationRuleCondition,
            com.google.cloud.deploy.v1.AutomationRuleCondition.Builder,
            com.google.cloud.deploy.v1.AutomationRuleConditionOrBuilder>
        getConditionFieldBuilder() {
      if (conditionBuilder_ == null) {
        conditionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.deploy.v1.AutomationRuleCondition,
                com.google.cloud.deploy.v1.AutomationRuleCondition.Builder,
                com.google.cloud.deploy.v1.AutomationRuleConditionOrBuilder>(
                getCondition(), getParentForChildren(), isClean());
        condition_ = null;
      }
      return conditionBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.deploy.v1.AdvanceRolloutRule)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.deploy.v1.AdvanceRolloutRule)
  private static final com.google.cloud.deploy.v1.AdvanceRolloutRule DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.deploy.v1.AdvanceRolloutRule();
  }

  public static com.google.cloud.deploy.v1.AdvanceRolloutRule getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AdvanceRolloutRule> PARSER =
      new com.google.protobuf.AbstractParser<AdvanceRolloutRule>() {
        @java.lang.Override
        public AdvanceRolloutRule parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AdvanceRolloutRule> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AdvanceRolloutRule> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.deploy.v1.AdvanceRolloutRule getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
