/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/deploy/v1/cloud_deploy.proto

package com.google.cloud.deploy.v1;

/**
 *
 *
 * <pre>
 * AutomationRolloutMetadata contains Automation-related actions that
 * were performed on a rollout.
 * </pre>
 *
 * Protobuf type {@code google.cloud.deploy.v1.AutomationRolloutMetadata}
 */
public final class AutomationRolloutMetadata extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.deploy.v1.AutomationRolloutMetadata)
    AutomationRolloutMetadataOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AutomationRolloutMetadata.newBuilder() to construct.
  private AutomationRolloutMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AutomationRolloutMetadata() {
    promoteAutomationRun_ = "";
    advanceAutomationRuns_ = com.google.protobuf.LazyStringArrayList.emptyList();
    repairAutomationRuns_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AutomationRolloutMetadata();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.deploy.v1.CloudDeployProto
        .internal_static_google_cloud_deploy_v1_AutomationRolloutMetadata_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.deploy.v1.CloudDeployProto
        .internal_static_google_cloud_deploy_v1_AutomationRolloutMetadata_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.deploy.v1.AutomationRolloutMetadata.class,
            com.google.cloud.deploy.v1.AutomationRolloutMetadata.Builder.class);
  }

  public static final int PROMOTE_AUTOMATION_RUN_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object promoteAutomationRun_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The ID of the AutomationRun initiated by a promote release
   * rule.
   * </pre>
   *
   * <code>string promote_automation_run = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The promoteAutomationRun.
   */
  @java.lang.Override
  public java.lang.String getPromoteAutomationRun() {
    java.lang.Object ref = promoteAutomationRun_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      promoteAutomationRun_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The ID of the AutomationRun initiated by a promote release
   * rule.
   * </pre>
   *
   * <code>string promote_automation_run = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for promoteAutomationRun.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPromoteAutomationRunBytes() {
    java.lang.Object ref = promoteAutomationRun_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      promoteAutomationRun_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ADVANCE_AUTOMATION_RUNS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList advanceAutomationRuns_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Output only. The IDs of the AutomationRuns initiated by an advance rollout
   * rule.
   * </pre>
   *
   * <code>repeated string advance_automation_runs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return A list containing the advanceAutomationRuns.
   */
  public com.google.protobuf.ProtocolStringList getAdvanceAutomationRunsList() {
    return advanceAutomationRuns_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The IDs of the AutomationRuns initiated by an advance rollout
   * rule.
   * </pre>
   *
   * <code>repeated string advance_automation_runs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The count of advanceAutomationRuns.
   */
  public int getAdvanceAutomationRunsCount() {
    return advanceAutomationRuns_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. The IDs of the AutomationRuns initiated by an advance rollout
   * rule.
   * </pre>
   *
   * <code>repeated string advance_automation_runs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The advanceAutomationRuns at the given index.
   */
  public java.lang.String getAdvanceAutomationRuns(int index) {
    return advanceAutomationRuns_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. The IDs of the AutomationRuns initiated by an advance rollout
   * rule.
   * </pre>
   *
   * <code>repeated string advance_automation_runs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the advanceAutomationRuns at the given index.
   */
  public com.google.protobuf.ByteString getAdvanceAutomationRunsBytes(int index) {
    return advanceAutomationRuns_.getByteString(index);
  }

  public static final int REPAIR_AUTOMATION_RUNS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList repairAutomationRuns_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Output only. The IDs of the AutomationRuns initiated by a repair rollout
   * rule.
   * </pre>
   *
   * <code>repeated string repair_automation_runs = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return A list containing the repairAutomationRuns.
   */
  public com.google.protobuf.ProtocolStringList getRepairAutomationRunsList() {
    return repairAutomationRuns_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The IDs of the AutomationRuns initiated by a repair rollout
   * rule.
   * </pre>
   *
   * <code>repeated string repair_automation_runs = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The count of repairAutomationRuns.
   */
  public int getRepairAutomationRunsCount() {
    return repairAutomationRuns_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. The IDs of the AutomationRuns initiated by a repair rollout
   * rule.
   * </pre>
   *
   * <code>repeated string repair_automation_runs = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The repairAutomationRuns at the given index.
   */
  public java.lang.String getRepairAutomationRuns(int index) {
    return repairAutomationRuns_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. The IDs of the AutomationRuns initiated by a repair rollout
   * rule.
   * </pre>
   *
   * <code>repeated string repair_automation_runs = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the repairAutomationRuns at the given index.
   */
  public com.google.protobuf.ByteString getRepairAutomationRunsBytes(int index) {
    return repairAutomationRuns_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(promoteAutomationRun_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, promoteAutomationRun_);
    }
    for (int i = 0; i < advanceAutomationRuns_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 2, advanceAutomationRuns_.getRaw(i));
    }
    for (int i = 0; i < repairAutomationRuns_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 3, repairAutomationRuns_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(promoteAutomationRun_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, promoteAutomationRun_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < advanceAutomationRuns_.size(); i++) {
        dataSize += computeStringSizeNoTag(advanceAutomationRuns_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getAdvanceAutomationRunsList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < repairAutomationRuns_.size(); i++) {
        dataSize += computeStringSizeNoTag(repairAutomationRuns_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getRepairAutomationRunsList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.deploy.v1.AutomationRolloutMetadata)) {
      return super.equals(obj);
    }
    com.google.cloud.deploy.v1.AutomationRolloutMetadata other =
        (com.google.cloud.deploy.v1.AutomationRolloutMetadata) obj;

    if (!getPromoteAutomationRun().equals(other.getPromoteAutomationRun())) return false;
    if (!getAdvanceAutomationRunsList().equals(other.getAdvanceAutomationRunsList())) return false;
    if (!getRepairAutomationRunsList().equals(other.getRepairAutomationRunsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PROMOTE_AUTOMATION_RUN_FIELD_NUMBER;
    hash = (53 * hash) + getPromoteAutomationRun().hashCode();
    if (getAdvanceAutomationRunsCount() > 0) {
      hash = (37 * hash) + ADVANCE_AUTOMATION_RUNS_FIELD_NUMBER;
      hash = (53 * hash) + getAdvanceAutomationRunsList().hashCode();
    }
    if (getRepairAutomationRunsCount() > 0) {
      hash = (37 * hash) + REPAIR_AUTOMATION_RUNS_FIELD_NUMBER;
      hash = (53 * hash) + getRepairAutomationRunsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.deploy.v1.AutomationRolloutMetadata parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.AutomationRolloutMetadata parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.AutomationRolloutMetadata parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.AutomationRolloutMetadata parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.AutomationRolloutMetadata parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.AutomationRolloutMetadata parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.AutomationRolloutMetadata parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.AutomationRolloutMetadata parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.AutomationRolloutMetadata parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.AutomationRolloutMetadata parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.AutomationRolloutMetadata parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.AutomationRolloutMetadata parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.deploy.v1.AutomationRolloutMetadata prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * AutomationRolloutMetadata contains Automation-related actions that
   * were performed on a rollout.
   * </pre>
   *
   * Protobuf type {@code google.cloud.deploy.v1.AutomationRolloutMetadata}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.deploy.v1.AutomationRolloutMetadata)
      com.google.cloud.deploy.v1.AutomationRolloutMetadataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_AutomationRolloutMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_AutomationRolloutMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.deploy.v1.AutomationRolloutMetadata.class,
              com.google.cloud.deploy.v1.AutomationRolloutMetadata.Builder.class);
    }

    // Construct using com.google.cloud.deploy.v1.AutomationRolloutMetadata.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      promoteAutomationRun_ = "";
      advanceAutomationRuns_ = com.google.protobuf.LazyStringArrayList.emptyList();
      repairAutomationRuns_ = com.google.protobuf.LazyStringArrayList.emptyList();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_AutomationRolloutMetadata_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.AutomationRolloutMetadata getDefaultInstanceForType() {
      return com.google.cloud.deploy.v1.AutomationRolloutMetadata.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.AutomationRolloutMetadata build() {
      com.google.cloud.deploy.v1.AutomationRolloutMetadata result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.AutomationRolloutMetadata buildPartial() {
      com.google.cloud.deploy.v1.AutomationRolloutMetadata result =
          new com.google.cloud.deploy.v1.AutomationRolloutMetadata(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.deploy.v1.AutomationRolloutMetadata result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.promoteAutomationRun_ = promoteAutomationRun_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        advanceAutomationRuns_.makeImmutable();
        result.advanceAutomationRuns_ = advanceAutomationRuns_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        repairAutomationRuns_.makeImmutable();
        result.repairAutomationRuns_ = repairAutomationRuns_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.deploy.v1.AutomationRolloutMetadata) {
        return mergeFrom((com.google.cloud.deploy.v1.AutomationRolloutMetadata) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.deploy.v1.AutomationRolloutMetadata other) {
      if (other == com.google.cloud.deploy.v1.AutomationRolloutMetadata.getDefaultInstance())
        return this;
      if (!other.getPromoteAutomationRun().isEmpty()) {
        promoteAutomationRun_ = other.promoteAutomationRun_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.advanceAutomationRuns_.isEmpty()) {
        if (advanceAutomationRuns_.isEmpty()) {
          advanceAutomationRuns_ = other.advanceAutomationRuns_;
          bitField0_ |= 0x00000002;
        } else {
          ensureAdvanceAutomationRunsIsMutable();
          advanceAutomationRuns_.addAll(other.advanceAutomationRuns_);
        }
        onChanged();
      }
      if (!other.repairAutomationRuns_.isEmpty()) {
        if (repairAutomationRuns_.isEmpty()) {
          repairAutomationRuns_ = other.repairAutomationRuns_;
          bitField0_ |= 0x00000004;
        } else {
          ensureRepairAutomationRunsIsMutable();
          repairAutomationRuns_.addAll(other.repairAutomationRuns_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                promoteAutomationRun_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureAdvanceAutomationRunsIsMutable();
                advanceAutomationRuns_.add(s);
                break;
              } // case 18
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureRepairAutomationRunsIsMutable();
                repairAutomationRuns_.add(s);
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object promoteAutomationRun_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The ID of the AutomationRun initiated by a promote release
     * rule.
     * </pre>
     *
     * <code>string promote_automation_run = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The promoteAutomationRun.
     */
    public java.lang.String getPromoteAutomationRun() {
      java.lang.Object ref = promoteAutomationRun_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        promoteAutomationRun_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The ID of the AutomationRun initiated by a promote release
     * rule.
     * </pre>
     *
     * <code>string promote_automation_run = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for promoteAutomationRun.
     */
    public com.google.protobuf.ByteString getPromoteAutomationRunBytes() {
      java.lang.Object ref = promoteAutomationRun_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        promoteAutomationRun_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The ID of the AutomationRun initiated by a promote release
     * rule.
     * </pre>
     *
     * <code>string promote_automation_run = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The promoteAutomationRun to set.
     * @return This builder for chaining.
     */
    public Builder setPromoteAutomationRun(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      promoteAutomationRun_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The ID of the AutomationRun initiated by a promote release
     * rule.
     * </pre>
     *
     * <code>string promote_automation_run = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPromoteAutomationRun() {
      promoteAutomationRun_ = getDefaultInstance().getPromoteAutomationRun();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The ID of the AutomationRun initiated by a promote release
     * rule.
     * </pre>
     *
     * <code>string promote_automation_run = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for promoteAutomationRun to set.
     * @return This builder for chaining.
     */
    public Builder setPromoteAutomationRunBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      promoteAutomationRun_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList advanceAutomationRuns_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureAdvanceAutomationRunsIsMutable() {
      if (!advanceAutomationRuns_.isModifiable()) {
        advanceAutomationRuns_ =
            new com.google.protobuf.LazyStringArrayList(advanceAutomationRuns_);
      }
      bitField0_ |= 0x00000002;
    }
    /**
     *
     *
     * <pre>
     * Output only. The IDs of the AutomationRuns initiated by an advance rollout
     * rule.
     * </pre>
     *
     * <code>
     * repeated string advance_automation_runs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return A list containing the advanceAutomationRuns.
     */
    public com.google.protobuf.ProtocolStringList getAdvanceAutomationRunsList() {
      advanceAutomationRuns_.makeImmutable();
      return advanceAutomationRuns_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The IDs of the AutomationRuns initiated by an advance rollout
     * rule.
     * </pre>
     *
     * <code>
     * repeated string advance_automation_runs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The count of advanceAutomationRuns.
     */
    public int getAdvanceAutomationRunsCount() {
      return advanceAutomationRuns_.size();
    }
    /**
     *
     *
     * <pre>
     * Output only. The IDs of the AutomationRuns initiated by an advance rollout
     * rule.
     * </pre>
     *
     * <code>
     * repeated string advance_automation_runs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The advanceAutomationRuns at the given index.
     */
    public java.lang.String getAdvanceAutomationRuns(int index) {
      return advanceAutomationRuns_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The IDs of the AutomationRuns initiated by an advance rollout
     * rule.
     * </pre>
     *
     * <code>
     * repeated string advance_automation_runs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the advanceAutomationRuns at the given index.
     */
    public com.google.protobuf.ByteString getAdvanceAutomationRunsBytes(int index) {
      return advanceAutomationRuns_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The IDs of the AutomationRuns initiated by an advance rollout
     * rule.
     * </pre>
     *
     * <code>
     * repeated string advance_automation_runs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The advanceAutomationRuns to set.
     * @return This builder for chaining.
     */
    public Builder setAdvanceAutomationRuns(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAdvanceAutomationRunsIsMutable();
      advanceAutomationRuns_.set(index, value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The IDs of the AutomationRuns initiated by an advance rollout
     * rule.
     * </pre>
     *
     * <code>
     * repeated string advance_automation_runs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The advanceAutomationRuns to add.
     * @return This builder for chaining.
     */
    public Builder addAdvanceAutomationRuns(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAdvanceAutomationRunsIsMutable();
      advanceAutomationRuns_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The IDs of the AutomationRuns initiated by an advance rollout
     * rule.
     * </pre>
     *
     * <code>
     * repeated string advance_automation_runs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param values The advanceAutomationRuns to add.
     * @return This builder for chaining.
     */
    public Builder addAllAdvanceAutomationRuns(java.lang.Iterable<java.lang.String> values) {
      ensureAdvanceAutomationRunsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, advanceAutomationRuns_);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The IDs of the AutomationRuns initiated by an advance rollout
     * rule.
     * </pre>
     *
     * <code>
     * repeated string advance_automation_runs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAdvanceAutomationRuns() {
      advanceAutomationRuns_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The IDs of the AutomationRuns initiated by an advance rollout
     * rule.
     * </pre>
     *
     * <code>
     * repeated string advance_automation_runs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The bytes of the advanceAutomationRuns to add.
     * @return This builder for chaining.
     */
    public Builder addAdvanceAutomationRunsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureAdvanceAutomationRunsIsMutable();
      advanceAutomationRuns_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList repairAutomationRuns_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureRepairAutomationRunsIsMutable() {
      if (!repairAutomationRuns_.isModifiable()) {
        repairAutomationRuns_ = new com.google.protobuf.LazyStringArrayList(repairAutomationRuns_);
      }
      bitField0_ |= 0x00000004;
    }
    /**
     *
     *
     * <pre>
     * Output only. The IDs of the AutomationRuns initiated by a repair rollout
     * rule.
     * </pre>
     *
     * <code>
     * repeated string repair_automation_runs = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return A list containing the repairAutomationRuns.
     */
    public com.google.protobuf.ProtocolStringList getRepairAutomationRunsList() {
      repairAutomationRuns_.makeImmutable();
      return repairAutomationRuns_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The IDs of the AutomationRuns initiated by a repair rollout
     * rule.
     * </pre>
     *
     * <code>
     * repeated string repair_automation_runs = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The count of repairAutomationRuns.
     */
    public int getRepairAutomationRunsCount() {
      return repairAutomationRuns_.size();
    }
    /**
     *
     *
     * <pre>
     * Output only. The IDs of the AutomationRuns initiated by a repair rollout
     * rule.
     * </pre>
     *
     * <code>
     * repeated string repair_automation_runs = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The repairAutomationRuns at the given index.
     */
    public java.lang.String getRepairAutomationRuns(int index) {
      return repairAutomationRuns_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The IDs of the AutomationRuns initiated by a repair rollout
     * rule.
     * </pre>
     *
     * <code>
     * repeated string repair_automation_runs = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the repairAutomationRuns at the given index.
     */
    public com.google.protobuf.ByteString getRepairAutomationRunsBytes(int index) {
      return repairAutomationRuns_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The IDs of the AutomationRuns initiated by a repair rollout
     * rule.
     * </pre>
     *
     * <code>
     * repeated string repair_automation_runs = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The repairAutomationRuns to set.
     * @return This builder for chaining.
     */
    public Builder setRepairAutomationRuns(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureRepairAutomationRunsIsMutable();
      repairAutomationRuns_.set(index, value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The IDs of the AutomationRuns initiated by a repair rollout
     * rule.
     * </pre>
     *
     * <code>
     * repeated string repair_automation_runs = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The repairAutomationRuns to add.
     * @return This builder for chaining.
     */
    public Builder addRepairAutomationRuns(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureRepairAutomationRunsIsMutable();
      repairAutomationRuns_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The IDs of the AutomationRuns initiated by a repair rollout
     * rule.
     * </pre>
     *
     * <code>
     * repeated string repair_automation_runs = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param values The repairAutomationRuns to add.
     * @return This builder for chaining.
     */
    public Builder addAllRepairAutomationRuns(java.lang.Iterable<java.lang.String> values) {
      ensureRepairAutomationRunsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, repairAutomationRuns_);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The IDs of the AutomationRuns initiated by a repair rollout
     * rule.
     * </pre>
     *
     * <code>
     * repeated string repair_automation_runs = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRepairAutomationRuns() {
      repairAutomationRuns_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The IDs of the AutomationRuns initiated by a repair rollout
     * rule.
     * </pre>
     *
     * <code>
     * repeated string repair_automation_runs = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The bytes of the repairAutomationRuns to add.
     * @return This builder for chaining.
     */
    public Builder addRepairAutomationRunsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureRepairAutomationRunsIsMutable();
      repairAutomationRuns_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.deploy.v1.AutomationRolloutMetadata)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.deploy.v1.AutomationRolloutMetadata)
  private static final com.google.cloud.deploy.v1.AutomationRolloutMetadata DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.deploy.v1.AutomationRolloutMetadata();
  }

  public static com.google.cloud.deploy.v1.AutomationRolloutMetadata getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AutomationRolloutMetadata> PARSER =
      new com.google.protobuf.AbstractParser<AutomationRolloutMetadata>() {
        @java.lang.Override
        public AutomationRolloutMetadata parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AutomationRolloutMetadata> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AutomationRolloutMetadata> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.deploy.v1.AutomationRolloutMetadata getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
