/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/deploy/v1/cloud_deploy.proto

package com.google.cloud.deploy.v1;

/**
 *
 *
 * <pre>
 * `AutomationRule` defines the automation activities.
 * </pre>
 *
 * Protobuf type {@code google.cloud.deploy.v1.AutomationRule}
 */
public final class AutomationRule extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.deploy.v1.AutomationRule)
    AutomationRuleOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AutomationRule.newBuilder() to construct.
  private AutomationRule(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AutomationRule() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AutomationRule();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.deploy.v1.CloudDeployProto
        .internal_static_google_cloud_deploy_v1_AutomationRule_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.deploy.v1.CloudDeployProto
        .internal_static_google_cloud_deploy_v1_AutomationRule_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.deploy.v1.AutomationRule.class,
            com.google.cloud.deploy.v1.AutomationRule.Builder.class);
  }

  private int ruleCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object rule_;

  public enum RuleCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    PROMOTE_RELEASE_RULE(1),
    ADVANCE_ROLLOUT_RULE(2),
    REPAIR_ROLLOUT_RULE(3),
    RULE_NOT_SET(0);
    private final int value;

    private RuleCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static RuleCase valueOf(int value) {
      return forNumber(value);
    }

    public static RuleCase forNumber(int value) {
      switch (value) {
        case 1:
          return PROMOTE_RELEASE_RULE;
        case 2:
          return ADVANCE_ROLLOUT_RULE;
        case 3:
          return REPAIR_ROLLOUT_RULE;
        case 0:
          return RULE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public RuleCase getRuleCase() {
    return RuleCase.forNumber(ruleCase_);
  }

  public static final int PROMOTE_RELEASE_RULE_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * Optional. `PromoteReleaseRule` will automatically promote a release from
   * the current target to a specified target.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.PromoteReleaseRule promote_release_rule = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the promoteReleaseRule field is set.
   */
  @java.lang.Override
  public boolean hasPromoteReleaseRule() {
    return ruleCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * Optional. `PromoteReleaseRule` will automatically promote a release from
   * the current target to a specified target.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.PromoteReleaseRule promote_release_rule = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The promoteReleaseRule.
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.PromoteReleaseRule getPromoteReleaseRule() {
    if (ruleCase_ == 1) {
      return (com.google.cloud.deploy.v1.PromoteReleaseRule) rule_;
    }
    return com.google.cloud.deploy.v1.PromoteReleaseRule.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. `PromoteReleaseRule` will automatically promote a release from
   * the current target to a specified target.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.PromoteReleaseRule promote_release_rule = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.PromoteReleaseRuleOrBuilder getPromoteReleaseRuleOrBuilder() {
    if (ruleCase_ == 1) {
      return (com.google.cloud.deploy.v1.PromoteReleaseRule) rule_;
    }
    return com.google.cloud.deploy.v1.PromoteReleaseRule.getDefaultInstance();
  }

  public static final int ADVANCE_ROLLOUT_RULE_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Optional. The `AdvanceRolloutRule` will automatically advance a
   * successful Rollout.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.AdvanceRolloutRule advance_rollout_rule = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the advanceRolloutRule field is set.
   */
  @java.lang.Override
  public boolean hasAdvanceRolloutRule() {
    return ruleCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Optional. The `AdvanceRolloutRule` will automatically advance a
   * successful Rollout.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.AdvanceRolloutRule advance_rollout_rule = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The advanceRolloutRule.
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.AdvanceRolloutRule getAdvanceRolloutRule() {
    if (ruleCase_ == 2) {
      return (com.google.cloud.deploy.v1.AdvanceRolloutRule) rule_;
    }
    return com.google.cloud.deploy.v1.AdvanceRolloutRule.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. The `AdvanceRolloutRule` will automatically advance a
   * successful Rollout.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.AdvanceRolloutRule advance_rollout_rule = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.AdvanceRolloutRuleOrBuilder getAdvanceRolloutRuleOrBuilder() {
    if (ruleCase_ == 2) {
      return (com.google.cloud.deploy.v1.AdvanceRolloutRule) rule_;
    }
    return com.google.cloud.deploy.v1.AdvanceRolloutRule.getDefaultInstance();
  }

  public static final int REPAIR_ROLLOUT_RULE_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Optional. The `RepairRolloutRule` will automatically repair a failed
   * rollout.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.RepairRolloutRule repair_rollout_rule = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the repairRolloutRule field is set.
   */
  @java.lang.Override
  public boolean hasRepairRolloutRule() {
    return ruleCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Optional. The `RepairRolloutRule` will automatically repair a failed
   * rollout.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.RepairRolloutRule repair_rollout_rule = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The repairRolloutRule.
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.RepairRolloutRule getRepairRolloutRule() {
    if (ruleCase_ == 3) {
      return (com.google.cloud.deploy.v1.RepairRolloutRule) rule_;
    }
    return com.google.cloud.deploy.v1.RepairRolloutRule.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. The `RepairRolloutRule` will automatically repair a failed
   * rollout.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.RepairRolloutRule repair_rollout_rule = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.RepairRolloutRuleOrBuilder getRepairRolloutRuleOrBuilder() {
    if (ruleCase_ == 3) {
      return (com.google.cloud.deploy.v1.RepairRolloutRule) rule_;
    }
    return com.google.cloud.deploy.v1.RepairRolloutRule.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (ruleCase_ == 1) {
      output.writeMessage(1, (com.google.cloud.deploy.v1.PromoteReleaseRule) rule_);
    }
    if (ruleCase_ == 2) {
      output.writeMessage(2, (com.google.cloud.deploy.v1.AdvanceRolloutRule) rule_);
    }
    if (ruleCase_ == 3) {
      output.writeMessage(3, (com.google.cloud.deploy.v1.RepairRolloutRule) rule_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (ruleCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.cloud.deploy.v1.PromoteReleaseRule) rule_);
    }
    if (ruleCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.cloud.deploy.v1.AdvanceRolloutRule) rule_);
    }
    if (ruleCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.cloud.deploy.v1.RepairRolloutRule) rule_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.deploy.v1.AutomationRule)) {
      return super.equals(obj);
    }
    com.google.cloud.deploy.v1.AutomationRule other =
        (com.google.cloud.deploy.v1.AutomationRule) obj;

    if (!getRuleCase().equals(other.getRuleCase())) return false;
    switch (ruleCase_) {
      case 1:
        if (!getPromoteReleaseRule().equals(other.getPromoteReleaseRule())) return false;
        break;
      case 2:
        if (!getAdvanceRolloutRule().equals(other.getAdvanceRolloutRule())) return false;
        break;
      case 3:
        if (!getRepairRolloutRule().equals(other.getRepairRolloutRule())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (ruleCase_) {
      case 1:
        hash = (37 * hash) + PROMOTE_RELEASE_RULE_FIELD_NUMBER;
        hash = (53 * hash) + getPromoteReleaseRule().hashCode();
        break;
      case 2:
        hash = (37 * hash) + ADVANCE_ROLLOUT_RULE_FIELD_NUMBER;
        hash = (53 * hash) + getAdvanceRolloutRule().hashCode();
        break;
      case 3:
        hash = (37 * hash) + REPAIR_ROLLOUT_RULE_FIELD_NUMBER;
        hash = (53 * hash) + getRepairRolloutRule().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.deploy.v1.AutomationRule parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.AutomationRule parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.AutomationRule parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.AutomationRule parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.AutomationRule parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.AutomationRule parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.AutomationRule parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.AutomationRule parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.AutomationRule parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.AutomationRule parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.AutomationRule parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.AutomationRule parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.deploy.v1.AutomationRule prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * `AutomationRule` defines the automation activities.
   * </pre>
   *
   * Protobuf type {@code google.cloud.deploy.v1.AutomationRule}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.deploy.v1.AutomationRule)
      com.google.cloud.deploy.v1.AutomationRuleOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_AutomationRule_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_AutomationRule_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.deploy.v1.AutomationRule.class,
              com.google.cloud.deploy.v1.AutomationRule.Builder.class);
    }

    // Construct using com.google.cloud.deploy.v1.AutomationRule.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (promoteReleaseRuleBuilder_ != null) {
        promoteReleaseRuleBuilder_.clear();
      }
      if (advanceRolloutRuleBuilder_ != null) {
        advanceRolloutRuleBuilder_.clear();
      }
      if (repairRolloutRuleBuilder_ != null) {
        repairRolloutRuleBuilder_.clear();
      }
      ruleCase_ = 0;
      rule_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_AutomationRule_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.AutomationRule getDefaultInstanceForType() {
      return com.google.cloud.deploy.v1.AutomationRule.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.AutomationRule build() {
      com.google.cloud.deploy.v1.AutomationRule result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.AutomationRule buildPartial() {
      com.google.cloud.deploy.v1.AutomationRule result =
          new com.google.cloud.deploy.v1.AutomationRule(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.deploy.v1.AutomationRule result) {
      int from_bitField0_ = bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.deploy.v1.AutomationRule result) {
      result.ruleCase_ = ruleCase_;
      result.rule_ = this.rule_;
      if (ruleCase_ == 1 && promoteReleaseRuleBuilder_ != null) {
        result.rule_ = promoteReleaseRuleBuilder_.build();
      }
      if (ruleCase_ == 2 && advanceRolloutRuleBuilder_ != null) {
        result.rule_ = advanceRolloutRuleBuilder_.build();
      }
      if (ruleCase_ == 3 && repairRolloutRuleBuilder_ != null) {
        result.rule_ = repairRolloutRuleBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.deploy.v1.AutomationRule) {
        return mergeFrom((com.google.cloud.deploy.v1.AutomationRule) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.deploy.v1.AutomationRule other) {
      if (other == com.google.cloud.deploy.v1.AutomationRule.getDefaultInstance()) return this;
      switch (other.getRuleCase()) {
        case PROMOTE_RELEASE_RULE:
          {
            mergePromoteReleaseRule(other.getPromoteReleaseRule());
            break;
          }
        case ADVANCE_ROLLOUT_RULE:
          {
            mergeAdvanceRolloutRule(other.getAdvanceRolloutRule());
            break;
          }
        case REPAIR_ROLLOUT_RULE:
          {
            mergeRepairRolloutRule(other.getRepairRolloutRule());
            break;
          }
        case RULE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(
                    getPromoteReleaseRuleFieldBuilder().getBuilder(), extensionRegistry);
                ruleCase_ = 1;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(
                    getAdvanceRolloutRuleFieldBuilder().getBuilder(), extensionRegistry);
                ruleCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getRepairRolloutRuleFieldBuilder().getBuilder(), extensionRegistry);
                ruleCase_ = 3;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int ruleCase_ = 0;
    private java.lang.Object rule_;

    public RuleCase getRuleCase() {
      return RuleCase.forNumber(ruleCase_);
    }

    public Builder clearRule() {
      ruleCase_ = 0;
      rule_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.PromoteReleaseRule,
            com.google.cloud.deploy.v1.PromoteReleaseRule.Builder,
            com.google.cloud.deploy.v1.PromoteReleaseRuleOrBuilder>
        promoteReleaseRuleBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. `PromoteReleaseRule` will automatically promote a release from
     * the current target to a specified target.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.PromoteReleaseRule promote_release_rule = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the promoteReleaseRule field is set.
     */
    @java.lang.Override
    public boolean hasPromoteReleaseRule() {
      return ruleCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Optional. `PromoteReleaseRule` will automatically promote a release from
     * the current target to a specified target.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.PromoteReleaseRule promote_release_rule = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The promoteReleaseRule.
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.PromoteReleaseRule getPromoteReleaseRule() {
      if (promoteReleaseRuleBuilder_ == null) {
        if (ruleCase_ == 1) {
          return (com.google.cloud.deploy.v1.PromoteReleaseRule) rule_;
        }
        return com.google.cloud.deploy.v1.PromoteReleaseRule.getDefaultInstance();
      } else {
        if (ruleCase_ == 1) {
          return promoteReleaseRuleBuilder_.getMessage();
        }
        return com.google.cloud.deploy.v1.PromoteReleaseRule.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. `PromoteReleaseRule` will automatically promote a release from
     * the current target to a specified target.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.PromoteReleaseRule promote_release_rule = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPromoteReleaseRule(com.google.cloud.deploy.v1.PromoteReleaseRule value) {
      if (promoteReleaseRuleBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        rule_ = value;
        onChanged();
      } else {
        promoteReleaseRuleBuilder_.setMessage(value);
      }
      ruleCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. `PromoteReleaseRule` will automatically promote a release from
     * the current target to a specified target.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.PromoteReleaseRule promote_release_rule = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPromoteReleaseRule(
        com.google.cloud.deploy.v1.PromoteReleaseRule.Builder builderForValue) {
      if (promoteReleaseRuleBuilder_ == null) {
        rule_ = builderForValue.build();
        onChanged();
      } else {
        promoteReleaseRuleBuilder_.setMessage(builderForValue.build());
      }
      ruleCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. `PromoteReleaseRule` will automatically promote a release from
     * the current target to a specified target.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.PromoteReleaseRule promote_release_rule = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergePromoteReleaseRule(com.google.cloud.deploy.v1.PromoteReleaseRule value) {
      if (promoteReleaseRuleBuilder_ == null) {
        if (ruleCase_ == 1
            && rule_ != com.google.cloud.deploy.v1.PromoteReleaseRule.getDefaultInstance()) {
          rule_ =
              com.google.cloud.deploy.v1.PromoteReleaseRule.newBuilder(
                      (com.google.cloud.deploy.v1.PromoteReleaseRule) rule_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          rule_ = value;
        }
        onChanged();
      } else {
        if (ruleCase_ == 1) {
          promoteReleaseRuleBuilder_.mergeFrom(value);
        } else {
          promoteReleaseRuleBuilder_.setMessage(value);
        }
      }
      ruleCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. `PromoteReleaseRule` will automatically promote a release from
     * the current target to a specified target.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.PromoteReleaseRule promote_release_rule = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearPromoteReleaseRule() {
      if (promoteReleaseRuleBuilder_ == null) {
        if (ruleCase_ == 1) {
          ruleCase_ = 0;
          rule_ = null;
          onChanged();
        }
      } else {
        if (ruleCase_ == 1) {
          ruleCase_ = 0;
          rule_ = null;
        }
        promoteReleaseRuleBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. `PromoteReleaseRule` will automatically promote a release from
     * the current target to a specified target.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.PromoteReleaseRule promote_release_rule = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.deploy.v1.PromoteReleaseRule.Builder getPromoteReleaseRuleBuilder() {
      return getPromoteReleaseRuleFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. `PromoteReleaseRule` will automatically promote a release from
     * the current target to a specified target.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.PromoteReleaseRule promote_release_rule = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.PromoteReleaseRuleOrBuilder getPromoteReleaseRuleOrBuilder() {
      if ((ruleCase_ == 1) && (promoteReleaseRuleBuilder_ != null)) {
        return promoteReleaseRuleBuilder_.getMessageOrBuilder();
      } else {
        if (ruleCase_ == 1) {
          return (com.google.cloud.deploy.v1.PromoteReleaseRule) rule_;
        }
        return com.google.cloud.deploy.v1.PromoteReleaseRule.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. `PromoteReleaseRule` will automatically promote a release from
     * the current target to a specified target.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.PromoteReleaseRule promote_release_rule = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.PromoteReleaseRule,
            com.google.cloud.deploy.v1.PromoteReleaseRule.Builder,
            com.google.cloud.deploy.v1.PromoteReleaseRuleOrBuilder>
        getPromoteReleaseRuleFieldBuilder() {
      if (promoteReleaseRuleBuilder_ == null) {
        if (!(ruleCase_ == 1)) {
          rule_ = com.google.cloud.deploy.v1.PromoteReleaseRule.getDefaultInstance();
        }
        promoteReleaseRuleBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.deploy.v1.PromoteReleaseRule,
                com.google.cloud.deploy.v1.PromoteReleaseRule.Builder,
                com.google.cloud.deploy.v1.PromoteReleaseRuleOrBuilder>(
                (com.google.cloud.deploy.v1.PromoteReleaseRule) rule_,
                getParentForChildren(),
                isClean());
        rule_ = null;
      }
      ruleCase_ = 1;
      onChanged();
      return promoteReleaseRuleBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.AdvanceRolloutRule,
            com.google.cloud.deploy.v1.AdvanceRolloutRule.Builder,
            com.google.cloud.deploy.v1.AdvanceRolloutRuleOrBuilder>
        advanceRolloutRuleBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The `AdvanceRolloutRule` will automatically advance a
     * successful Rollout.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AdvanceRolloutRule advance_rollout_rule = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the advanceRolloutRule field is set.
     */
    @java.lang.Override
    public boolean hasAdvanceRolloutRule() {
      return ruleCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Optional. The `AdvanceRolloutRule` will automatically advance a
     * successful Rollout.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AdvanceRolloutRule advance_rollout_rule = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The advanceRolloutRule.
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.AdvanceRolloutRule getAdvanceRolloutRule() {
      if (advanceRolloutRuleBuilder_ == null) {
        if (ruleCase_ == 2) {
          return (com.google.cloud.deploy.v1.AdvanceRolloutRule) rule_;
        }
        return com.google.cloud.deploy.v1.AdvanceRolloutRule.getDefaultInstance();
      } else {
        if (ruleCase_ == 2) {
          return advanceRolloutRuleBuilder_.getMessage();
        }
        return com.google.cloud.deploy.v1.AdvanceRolloutRule.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The `AdvanceRolloutRule` will automatically advance a
     * successful Rollout.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AdvanceRolloutRule advance_rollout_rule = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAdvanceRolloutRule(com.google.cloud.deploy.v1.AdvanceRolloutRule value) {
      if (advanceRolloutRuleBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        rule_ = value;
        onChanged();
      } else {
        advanceRolloutRuleBuilder_.setMessage(value);
      }
      ruleCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The `AdvanceRolloutRule` will automatically advance a
     * successful Rollout.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AdvanceRolloutRule advance_rollout_rule = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAdvanceRolloutRule(
        com.google.cloud.deploy.v1.AdvanceRolloutRule.Builder builderForValue) {
      if (advanceRolloutRuleBuilder_ == null) {
        rule_ = builderForValue.build();
        onChanged();
      } else {
        advanceRolloutRuleBuilder_.setMessage(builderForValue.build());
      }
      ruleCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The `AdvanceRolloutRule` will automatically advance a
     * successful Rollout.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AdvanceRolloutRule advance_rollout_rule = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeAdvanceRolloutRule(com.google.cloud.deploy.v1.AdvanceRolloutRule value) {
      if (advanceRolloutRuleBuilder_ == null) {
        if (ruleCase_ == 2
            && rule_ != com.google.cloud.deploy.v1.AdvanceRolloutRule.getDefaultInstance()) {
          rule_ =
              com.google.cloud.deploy.v1.AdvanceRolloutRule.newBuilder(
                      (com.google.cloud.deploy.v1.AdvanceRolloutRule) rule_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          rule_ = value;
        }
        onChanged();
      } else {
        if (ruleCase_ == 2) {
          advanceRolloutRuleBuilder_.mergeFrom(value);
        } else {
          advanceRolloutRuleBuilder_.setMessage(value);
        }
      }
      ruleCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The `AdvanceRolloutRule` will automatically advance a
     * successful Rollout.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AdvanceRolloutRule advance_rollout_rule = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearAdvanceRolloutRule() {
      if (advanceRolloutRuleBuilder_ == null) {
        if (ruleCase_ == 2) {
          ruleCase_ = 0;
          rule_ = null;
          onChanged();
        }
      } else {
        if (ruleCase_ == 2) {
          ruleCase_ = 0;
          rule_ = null;
        }
        advanceRolloutRuleBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The `AdvanceRolloutRule` will automatically advance a
     * successful Rollout.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AdvanceRolloutRule advance_rollout_rule = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.deploy.v1.AdvanceRolloutRule.Builder getAdvanceRolloutRuleBuilder() {
      return getAdvanceRolloutRuleFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The `AdvanceRolloutRule` will automatically advance a
     * successful Rollout.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AdvanceRolloutRule advance_rollout_rule = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.AdvanceRolloutRuleOrBuilder getAdvanceRolloutRuleOrBuilder() {
      if ((ruleCase_ == 2) && (advanceRolloutRuleBuilder_ != null)) {
        return advanceRolloutRuleBuilder_.getMessageOrBuilder();
      } else {
        if (ruleCase_ == 2) {
          return (com.google.cloud.deploy.v1.AdvanceRolloutRule) rule_;
        }
        return com.google.cloud.deploy.v1.AdvanceRolloutRule.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The `AdvanceRolloutRule` will automatically advance a
     * successful Rollout.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AdvanceRolloutRule advance_rollout_rule = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.AdvanceRolloutRule,
            com.google.cloud.deploy.v1.AdvanceRolloutRule.Builder,
            com.google.cloud.deploy.v1.AdvanceRolloutRuleOrBuilder>
        getAdvanceRolloutRuleFieldBuilder() {
      if (advanceRolloutRuleBuilder_ == null) {
        if (!(ruleCase_ == 2)) {
          rule_ = com.google.cloud.deploy.v1.AdvanceRolloutRule.getDefaultInstance();
        }
        advanceRolloutRuleBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.deploy.v1.AdvanceRolloutRule,
                com.google.cloud.deploy.v1.AdvanceRolloutRule.Builder,
                com.google.cloud.deploy.v1.AdvanceRolloutRuleOrBuilder>(
                (com.google.cloud.deploy.v1.AdvanceRolloutRule) rule_,
                getParentForChildren(),
                isClean());
        rule_ = null;
      }
      ruleCase_ = 2;
      onChanged();
      return advanceRolloutRuleBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.RepairRolloutRule,
            com.google.cloud.deploy.v1.RepairRolloutRule.Builder,
            com.google.cloud.deploy.v1.RepairRolloutRuleOrBuilder>
        repairRolloutRuleBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The `RepairRolloutRule` will automatically repair a failed
     * rollout.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.RepairRolloutRule repair_rollout_rule = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the repairRolloutRule field is set.
     */
    @java.lang.Override
    public boolean hasRepairRolloutRule() {
      return ruleCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Optional. The `RepairRolloutRule` will automatically repair a failed
     * rollout.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.RepairRolloutRule repair_rollout_rule = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The repairRolloutRule.
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.RepairRolloutRule getRepairRolloutRule() {
      if (repairRolloutRuleBuilder_ == null) {
        if (ruleCase_ == 3) {
          return (com.google.cloud.deploy.v1.RepairRolloutRule) rule_;
        }
        return com.google.cloud.deploy.v1.RepairRolloutRule.getDefaultInstance();
      } else {
        if (ruleCase_ == 3) {
          return repairRolloutRuleBuilder_.getMessage();
        }
        return com.google.cloud.deploy.v1.RepairRolloutRule.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The `RepairRolloutRule` will automatically repair a failed
     * rollout.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.RepairRolloutRule repair_rollout_rule = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRepairRolloutRule(com.google.cloud.deploy.v1.RepairRolloutRule value) {
      if (repairRolloutRuleBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        rule_ = value;
        onChanged();
      } else {
        repairRolloutRuleBuilder_.setMessage(value);
      }
      ruleCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The `RepairRolloutRule` will automatically repair a failed
     * rollout.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.RepairRolloutRule repair_rollout_rule = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRepairRolloutRule(
        com.google.cloud.deploy.v1.RepairRolloutRule.Builder builderForValue) {
      if (repairRolloutRuleBuilder_ == null) {
        rule_ = builderForValue.build();
        onChanged();
      } else {
        repairRolloutRuleBuilder_.setMessage(builderForValue.build());
      }
      ruleCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The `RepairRolloutRule` will automatically repair a failed
     * rollout.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.RepairRolloutRule repair_rollout_rule = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeRepairRolloutRule(com.google.cloud.deploy.v1.RepairRolloutRule value) {
      if (repairRolloutRuleBuilder_ == null) {
        if (ruleCase_ == 3
            && rule_ != com.google.cloud.deploy.v1.RepairRolloutRule.getDefaultInstance()) {
          rule_ =
              com.google.cloud.deploy.v1.RepairRolloutRule.newBuilder(
                      (com.google.cloud.deploy.v1.RepairRolloutRule) rule_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          rule_ = value;
        }
        onChanged();
      } else {
        if (ruleCase_ == 3) {
          repairRolloutRuleBuilder_.mergeFrom(value);
        } else {
          repairRolloutRuleBuilder_.setMessage(value);
        }
      }
      ruleCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The `RepairRolloutRule` will automatically repair a failed
     * rollout.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.RepairRolloutRule repair_rollout_rule = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearRepairRolloutRule() {
      if (repairRolloutRuleBuilder_ == null) {
        if (ruleCase_ == 3) {
          ruleCase_ = 0;
          rule_ = null;
          onChanged();
        }
      } else {
        if (ruleCase_ == 3) {
          ruleCase_ = 0;
          rule_ = null;
        }
        repairRolloutRuleBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The `RepairRolloutRule` will automatically repair a failed
     * rollout.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.RepairRolloutRule repair_rollout_rule = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.deploy.v1.RepairRolloutRule.Builder getRepairRolloutRuleBuilder() {
      return getRepairRolloutRuleFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The `RepairRolloutRule` will automatically repair a failed
     * rollout.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.RepairRolloutRule repair_rollout_rule = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.RepairRolloutRuleOrBuilder getRepairRolloutRuleOrBuilder() {
      if ((ruleCase_ == 3) && (repairRolloutRuleBuilder_ != null)) {
        return repairRolloutRuleBuilder_.getMessageOrBuilder();
      } else {
        if (ruleCase_ == 3) {
          return (com.google.cloud.deploy.v1.RepairRolloutRule) rule_;
        }
        return com.google.cloud.deploy.v1.RepairRolloutRule.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The `RepairRolloutRule` will automatically repair a failed
     * rollout.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.RepairRolloutRule repair_rollout_rule = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.RepairRolloutRule,
            com.google.cloud.deploy.v1.RepairRolloutRule.Builder,
            com.google.cloud.deploy.v1.RepairRolloutRuleOrBuilder>
        getRepairRolloutRuleFieldBuilder() {
      if (repairRolloutRuleBuilder_ == null) {
        if (!(ruleCase_ == 3)) {
          rule_ = com.google.cloud.deploy.v1.RepairRolloutRule.getDefaultInstance();
        }
        repairRolloutRuleBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.deploy.v1.RepairRolloutRule,
                com.google.cloud.deploy.v1.RepairRolloutRule.Builder,
                com.google.cloud.deploy.v1.RepairRolloutRuleOrBuilder>(
                (com.google.cloud.deploy.v1.RepairRolloutRule) rule_,
                getParentForChildren(),
                isClean());
        rule_ = null;
      }
      ruleCase_ = 3;
      onChanged();
      return repairRolloutRuleBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.deploy.v1.AutomationRule)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.deploy.v1.AutomationRule)
  private static final com.google.cloud.deploy.v1.AutomationRule DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.deploy.v1.AutomationRule();
  }

  public static com.google.cloud.deploy.v1.AutomationRule getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AutomationRule> PARSER =
      new com.google.protobuf.AbstractParser<AutomationRule>() {
        @java.lang.Override
        public AutomationRule parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AutomationRule> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AutomationRule> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.deploy.v1.AutomationRule getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
