/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/deploy/v1/cloud_deploy.proto

package com.google.cloud.deploy.v1;

/**
 *
 *
 * <pre>
 * CloudRunConfig contains the Cloud Run runtime configuration.
 * </pre>
 *
 * Protobuf type {@code google.cloud.deploy.v1.CloudRunConfig}
 */
public final class CloudRunConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.deploy.v1.CloudRunConfig)
    CloudRunConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CloudRunConfig.newBuilder() to construct.
  private CloudRunConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CloudRunConfig() {
    canaryRevisionTags_ = com.google.protobuf.LazyStringArrayList.emptyList();
    priorRevisionTags_ = com.google.protobuf.LazyStringArrayList.emptyList();
    stableRevisionTags_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CloudRunConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.deploy.v1.CloudDeployProto
        .internal_static_google_cloud_deploy_v1_CloudRunConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.deploy.v1.CloudDeployProto
        .internal_static_google_cloud_deploy_v1_CloudRunConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.deploy.v1.CloudRunConfig.class,
            com.google.cloud.deploy.v1.CloudRunConfig.Builder.class);
  }

  public static final int AUTOMATIC_TRAFFIC_CONTROL_FIELD_NUMBER = 1;
  private boolean automaticTrafficControl_ = false;
  /**
   *
   *
   * <pre>
   * Whether Cloud Deploy should update the traffic stanza in a Cloud Run
   * Service on the user's behalf to facilitate traffic splitting. This is
   * required to be true for CanaryDeployments, but optional for
   * CustomCanaryDeployments.
   * </pre>
   *
   * <code>bool automatic_traffic_control = 1;</code>
   *
   * @return The automaticTrafficControl.
   */
  @java.lang.Override
  public boolean getAutomaticTrafficControl() {
    return automaticTrafficControl_;
  }

  public static final int CANARY_REVISION_TAGS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList canaryRevisionTags_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Optional. A list of tags that are added to the canary revision while the
   * canary phase is in progress.
   * </pre>
   *
   * <code>repeated string canary_revision_tags = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return A list containing the canaryRevisionTags.
   */
  public com.google.protobuf.ProtocolStringList getCanaryRevisionTagsList() {
    return canaryRevisionTags_;
  }
  /**
   *
   *
   * <pre>
   * Optional. A list of tags that are added to the canary revision while the
   * canary phase is in progress.
   * </pre>
   *
   * <code>repeated string canary_revision_tags = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The count of canaryRevisionTags.
   */
  public int getCanaryRevisionTagsCount() {
    return canaryRevisionTags_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. A list of tags that are added to the canary revision while the
   * canary phase is in progress.
   * </pre>
   *
   * <code>repeated string canary_revision_tags = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The canaryRevisionTags at the given index.
   */
  public java.lang.String getCanaryRevisionTags(int index) {
    return canaryRevisionTags_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. A list of tags that are added to the canary revision while the
   * canary phase is in progress.
   * </pre>
   *
   * <code>repeated string canary_revision_tags = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the canaryRevisionTags at the given index.
   */
  public com.google.protobuf.ByteString getCanaryRevisionTagsBytes(int index) {
    return canaryRevisionTags_.getByteString(index);
  }

  public static final int PRIOR_REVISION_TAGS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList priorRevisionTags_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Optional. A list of tags that are added to the prior revision while the
   * canary phase is in progress.
   * </pre>
   *
   * <code>repeated string prior_revision_tags = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return A list containing the priorRevisionTags.
   */
  public com.google.protobuf.ProtocolStringList getPriorRevisionTagsList() {
    return priorRevisionTags_;
  }
  /**
   *
   *
   * <pre>
   * Optional. A list of tags that are added to the prior revision while the
   * canary phase is in progress.
   * </pre>
   *
   * <code>repeated string prior_revision_tags = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The count of priorRevisionTags.
   */
  public int getPriorRevisionTagsCount() {
    return priorRevisionTags_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. A list of tags that are added to the prior revision while the
   * canary phase is in progress.
   * </pre>
   *
   * <code>repeated string prior_revision_tags = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the element to return.
   * @return The priorRevisionTags at the given index.
   */
  public java.lang.String getPriorRevisionTags(int index) {
    return priorRevisionTags_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. A list of tags that are added to the prior revision while the
   * canary phase is in progress.
   * </pre>
   *
   * <code>repeated string prior_revision_tags = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the priorRevisionTags at the given index.
   */
  public com.google.protobuf.ByteString getPriorRevisionTagsBytes(int index) {
    return priorRevisionTags_.getByteString(index);
  }

  public static final int STABLE_REVISION_TAGS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList stableRevisionTags_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Optional. A list of tags that are added to the final stable revision when
   * the stable phase is applied.
   * </pre>
   *
   * <code>repeated string stable_revision_tags = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return A list containing the stableRevisionTags.
   */
  public com.google.protobuf.ProtocolStringList getStableRevisionTagsList() {
    return stableRevisionTags_;
  }
  /**
   *
   *
   * <pre>
   * Optional. A list of tags that are added to the final stable revision when
   * the stable phase is applied.
   * </pre>
   *
   * <code>repeated string stable_revision_tags = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The count of stableRevisionTags.
   */
  public int getStableRevisionTagsCount() {
    return stableRevisionTags_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. A list of tags that are added to the final stable revision when
   * the stable phase is applied.
   * </pre>
   *
   * <code>repeated string stable_revision_tags = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The stableRevisionTags at the given index.
   */
  public java.lang.String getStableRevisionTags(int index) {
    return stableRevisionTags_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. A list of tags that are added to the final stable revision when
   * the stable phase is applied.
   * </pre>
   *
   * <code>repeated string stable_revision_tags = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the stableRevisionTags at the given index.
   */
  public com.google.protobuf.ByteString getStableRevisionTagsBytes(int index) {
    return stableRevisionTags_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (automaticTrafficControl_ != false) {
      output.writeBool(1, automaticTrafficControl_);
    }
    for (int i = 0; i < canaryRevisionTags_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, canaryRevisionTags_.getRaw(i));
    }
    for (int i = 0; i < priorRevisionTags_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, priorRevisionTags_.getRaw(i));
    }
    for (int i = 0; i < stableRevisionTags_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, stableRevisionTags_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (automaticTrafficControl_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, automaticTrafficControl_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < canaryRevisionTags_.size(); i++) {
        dataSize += computeStringSizeNoTag(canaryRevisionTags_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getCanaryRevisionTagsList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < priorRevisionTags_.size(); i++) {
        dataSize += computeStringSizeNoTag(priorRevisionTags_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getPriorRevisionTagsList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < stableRevisionTags_.size(); i++) {
        dataSize += computeStringSizeNoTag(stableRevisionTags_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getStableRevisionTagsList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.deploy.v1.CloudRunConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.deploy.v1.CloudRunConfig other =
        (com.google.cloud.deploy.v1.CloudRunConfig) obj;

    if (getAutomaticTrafficControl() != other.getAutomaticTrafficControl()) return false;
    if (!getCanaryRevisionTagsList().equals(other.getCanaryRevisionTagsList())) return false;
    if (!getPriorRevisionTagsList().equals(other.getPriorRevisionTagsList())) return false;
    if (!getStableRevisionTagsList().equals(other.getStableRevisionTagsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + AUTOMATIC_TRAFFIC_CONTROL_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAutomaticTrafficControl());
    if (getCanaryRevisionTagsCount() > 0) {
      hash = (37 * hash) + CANARY_REVISION_TAGS_FIELD_NUMBER;
      hash = (53 * hash) + getCanaryRevisionTagsList().hashCode();
    }
    if (getPriorRevisionTagsCount() > 0) {
      hash = (37 * hash) + PRIOR_REVISION_TAGS_FIELD_NUMBER;
      hash = (53 * hash) + getPriorRevisionTagsList().hashCode();
    }
    if (getStableRevisionTagsCount() > 0) {
      hash = (37 * hash) + STABLE_REVISION_TAGS_FIELD_NUMBER;
      hash = (53 * hash) + getStableRevisionTagsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.deploy.v1.CloudRunConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.CloudRunConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.CloudRunConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.CloudRunConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.CloudRunConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.CloudRunConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.CloudRunConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.CloudRunConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.CloudRunConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.CloudRunConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.CloudRunConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.CloudRunConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.deploy.v1.CloudRunConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * CloudRunConfig contains the Cloud Run runtime configuration.
   * </pre>
   *
   * Protobuf type {@code google.cloud.deploy.v1.CloudRunConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.deploy.v1.CloudRunConfig)
      com.google.cloud.deploy.v1.CloudRunConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_CloudRunConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_CloudRunConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.deploy.v1.CloudRunConfig.class,
              com.google.cloud.deploy.v1.CloudRunConfig.Builder.class);
    }

    // Construct using com.google.cloud.deploy.v1.CloudRunConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      automaticTrafficControl_ = false;
      canaryRevisionTags_ = com.google.protobuf.LazyStringArrayList.emptyList();
      priorRevisionTags_ = com.google.protobuf.LazyStringArrayList.emptyList();
      stableRevisionTags_ = com.google.protobuf.LazyStringArrayList.emptyList();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_CloudRunConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.CloudRunConfig getDefaultInstanceForType() {
      return com.google.cloud.deploy.v1.CloudRunConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.CloudRunConfig build() {
      com.google.cloud.deploy.v1.CloudRunConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.CloudRunConfig buildPartial() {
      com.google.cloud.deploy.v1.CloudRunConfig result =
          new com.google.cloud.deploy.v1.CloudRunConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.deploy.v1.CloudRunConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.automaticTrafficControl_ = automaticTrafficControl_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        canaryRevisionTags_.makeImmutable();
        result.canaryRevisionTags_ = canaryRevisionTags_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        priorRevisionTags_.makeImmutable();
        result.priorRevisionTags_ = priorRevisionTags_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        stableRevisionTags_.makeImmutable();
        result.stableRevisionTags_ = stableRevisionTags_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.deploy.v1.CloudRunConfig) {
        return mergeFrom((com.google.cloud.deploy.v1.CloudRunConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.deploy.v1.CloudRunConfig other) {
      if (other == com.google.cloud.deploy.v1.CloudRunConfig.getDefaultInstance()) return this;
      if (other.getAutomaticTrafficControl() != false) {
        setAutomaticTrafficControl(other.getAutomaticTrafficControl());
      }
      if (!other.canaryRevisionTags_.isEmpty()) {
        if (canaryRevisionTags_.isEmpty()) {
          canaryRevisionTags_ = other.canaryRevisionTags_;
          bitField0_ |= 0x00000002;
        } else {
          ensureCanaryRevisionTagsIsMutable();
          canaryRevisionTags_.addAll(other.canaryRevisionTags_);
        }
        onChanged();
      }
      if (!other.priorRevisionTags_.isEmpty()) {
        if (priorRevisionTags_.isEmpty()) {
          priorRevisionTags_ = other.priorRevisionTags_;
          bitField0_ |= 0x00000004;
        } else {
          ensurePriorRevisionTagsIsMutable();
          priorRevisionTags_.addAll(other.priorRevisionTags_);
        }
        onChanged();
      }
      if (!other.stableRevisionTags_.isEmpty()) {
        if (stableRevisionTags_.isEmpty()) {
          stableRevisionTags_ = other.stableRevisionTags_;
          bitField0_ |= 0x00000008;
        } else {
          ensureStableRevisionTagsIsMutable();
          stableRevisionTags_.addAll(other.stableRevisionTags_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                automaticTrafficControl_ = input.readBool();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureCanaryRevisionTagsIsMutable();
                canaryRevisionTags_.add(s);
                break;
              } // case 18
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensurePriorRevisionTagsIsMutable();
                priorRevisionTags_.add(s);
                break;
              } // case 26
            case 34:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureStableRevisionTagsIsMutable();
                stableRevisionTags_.add(s);
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private boolean automaticTrafficControl_;
    /**
     *
     *
     * <pre>
     * Whether Cloud Deploy should update the traffic stanza in a Cloud Run
     * Service on the user's behalf to facilitate traffic splitting. This is
     * required to be true for CanaryDeployments, but optional for
     * CustomCanaryDeployments.
     * </pre>
     *
     * <code>bool automatic_traffic_control = 1;</code>
     *
     * @return The automaticTrafficControl.
     */
    @java.lang.Override
    public boolean getAutomaticTrafficControl() {
      return automaticTrafficControl_;
    }
    /**
     *
     *
     * <pre>
     * Whether Cloud Deploy should update the traffic stanza in a Cloud Run
     * Service on the user's behalf to facilitate traffic splitting. This is
     * required to be true for CanaryDeployments, but optional for
     * CustomCanaryDeployments.
     * </pre>
     *
     * <code>bool automatic_traffic_control = 1;</code>
     *
     * @param value The automaticTrafficControl to set.
     * @return This builder for chaining.
     */
    public Builder setAutomaticTrafficControl(boolean value) {

      automaticTrafficControl_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether Cloud Deploy should update the traffic stanza in a Cloud Run
     * Service on the user's behalf to facilitate traffic splitting. This is
     * required to be true for CanaryDeployments, but optional for
     * CustomCanaryDeployments.
     * </pre>
     *
     * <code>bool automatic_traffic_control = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAutomaticTrafficControl() {
      bitField0_ = (bitField0_ & ~0x00000001);
      automaticTrafficControl_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList canaryRevisionTags_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureCanaryRevisionTagsIsMutable() {
      if (!canaryRevisionTags_.isModifiable()) {
        canaryRevisionTags_ = new com.google.protobuf.LazyStringArrayList(canaryRevisionTags_);
      }
      bitField0_ |= 0x00000002;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of tags that are added to the canary revision while the
     * canary phase is in progress.
     * </pre>
     *
     * <code>repeated string canary_revision_tags = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return A list containing the canaryRevisionTags.
     */
    public com.google.protobuf.ProtocolStringList getCanaryRevisionTagsList() {
      canaryRevisionTags_.makeImmutable();
      return canaryRevisionTags_;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of tags that are added to the canary revision while the
     * canary phase is in progress.
     * </pre>
     *
     * <code>repeated string canary_revision_tags = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The count of canaryRevisionTags.
     */
    public int getCanaryRevisionTagsCount() {
      return canaryRevisionTags_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of tags that are added to the canary revision while the
     * canary phase is in progress.
     * </pre>
     *
     * <code>repeated string canary_revision_tags = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The canaryRevisionTags at the given index.
     */
    public java.lang.String getCanaryRevisionTags(int index) {
      return canaryRevisionTags_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of tags that are added to the canary revision while the
     * canary phase is in progress.
     * </pre>
     *
     * <code>repeated string canary_revision_tags = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the canaryRevisionTags at the given index.
     */
    public com.google.protobuf.ByteString getCanaryRevisionTagsBytes(int index) {
      return canaryRevisionTags_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of tags that are added to the canary revision while the
     * canary phase is in progress.
     * </pre>
     *
     * <code>repeated string canary_revision_tags = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The canaryRevisionTags to set.
     * @return This builder for chaining.
     */
    public Builder setCanaryRevisionTags(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureCanaryRevisionTagsIsMutable();
      canaryRevisionTags_.set(index, value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of tags that are added to the canary revision while the
     * canary phase is in progress.
     * </pre>
     *
     * <code>repeated string canary_revision_tags = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The canaryRevisionTags to add.
     * @return This builder for chaining.
     */
    public Builder addCanaryRevisionTags(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureCanaryRevisionTagsIsMutable();
      canaryRevisionTags_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of tags that are added to the canary revision while the
     * canary phase is in progress.
     * </pre>
     *
     * <code>repeated string canary_revision_tags = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param values The canaryRevisionTags to add.
     * @return This builder for chaining.
     */
    public Builder addAllCanaryRevisionTags(java.lang.Iterable<java.lang.String> values) {
      ensureCanaryRevisionTagsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, canaryRevisionTags_);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of tags that are added to the canary revision while the
     * canary phase is in progress.
     * </pre>
     *
     * <code>repeated string canary_revision_tags = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCanaryRevisionTags() {
      canaryRevisionTags_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of tags that are added to the canary revision while the
     * canary phase is in progress.
     * </pre>
     *
     * <code>repeated string canary_revision_tags = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The bytes of the canaryRevisionTags to add.
     * @return This builder for chaining.
     */
    public Builder addCanaryRevisionTagsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureCanaryRevisionTagsIsMutable();
      canaryRevisionTags_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList priorRevisionTags_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensurePriorRevisionTagsIsMutable() {
      if (!priorRevisionTags_.isModifiable()) {
        priorRevisionTags_ = new com.google.protobuf.LazyStringArrayList(priorRevisionTags_);
      }
      bitField0_ |= 0x00000004;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of tags that are added to the prior revision while the
     * canary phase is in progress.
     * </pre>
     *
     * <code>repeated string prior_revision_tags = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return A list containing the priorRevisionTags.
     */
    public com.google.protobuf.ProtocolStringList getPriorRevisionTagsList() {
      priorRevisionTags_.makeImmutable();
      return priorRevisionTags_;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of tags that are added to the prior revision while the
     * canary phase is in progress.
     * </pre>
     *
     * <code>repeated string prior_revision_tags = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The count of priorRevisionTags.
     */
    public int getPriorRevisionTagsCount() {
      return priorRevisionTags_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of tags that are added to the prior revision while the
     * canary phase is in progress.
     * </pre>
     *
     * <code>repeated string prior_revision_tags = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The priorRevisionTags at the given index.
     */
    public java.lang.String getPriorRevisionTags(int index) {
      return priorRevisionTags_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of tags that are added to the prior revision while the
     * canary phase is in progress.
     * </pre>
     *
     * <code>repeated string prior_revision_tags = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the priorRevisionTags at the given index.
     */
    public com.google.protobuf.ByteString getPriorRevisionTagsBytes(int index) {
      return priorRevisionTags_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of tags that are added to the prior revision while the
     * canary phase is in progress.
     * </pre>
     *
     * <code>repeated string prior_revision_tags = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The priorRevisionTags to set.
     * @return This builder for chaining.
     */
    public Builder setPriorRevisionTags(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensurePriorRevisionTagsIsMutable();
      priorRevisionTags_.set(index, value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of tags that are added to the prior revision while the
     * canary phase is in progress.
     * </pre>
     *
     * <code>repeated string prior_revision_tags = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The priorRevisionTags to add.
     * @return This builder for chaining.
     */
    public Builder addPriorRevisionTags(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensurePriorRevisionTagsIsMutable();
      priorRevisionTags_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of tags that are added to the prior revision while the
     * canary phase is in progress.
     * </pre>
     *
     * <code>repeated string prior_revision_tags = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param values The priorRevisionTags to add.
     * @return This builder for chaining.
     */
    public Builder addAllPriorRevisionTags(java.lang.Iterable<java.lang.String> values) {
      ensurePriorRevisionTagsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, priorRevisionTags_);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of tags that are added to the prior revision while the
     * canary phase is in progress.
     * </pre>
     *
     * <code>repeated string prior_revision_tags = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPriorRevisionTags() {
      priorRevisionTags_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of tags that are added to the prior revision while the
     * canary phase is in progress.
     * </pre>
     *
     * <code>repeated string prior_revision_tags = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The bytes of the priorRevisionTags to add.
     * @return This builder for chaining.
     */
    public Builder addPriorRevisionTagsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensurePriorRevisionTagsIsMutable();
      priorRevisionTags_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList stableRevisionTags_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureStableRevisionTagsIsMutable() {
      if (!stableRevisionTags_.isModifiable()) {
        stableRevisionTags_ = new com.google.protobuf.LazyStringArrayList(stableRevisionTags_);
      }
      bitField0_ |= 0x00000008;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of tags that are added to the final stable revision when
     * the stable phase is applied.
     * </pre>
     *
     * <code>repeated string stable_revision_tags = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return A list containing the stableRevisionTags.
     */
    public com.google.protobuf.ProtocolStringList getStableRevisionTagsList() {
      stableRevisionTags_.makeImmutable();
      return stableRevisionTags_;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of tags that are added to the final stable revision when
     * the stable phase is applied.
     * </pre>
     *
     * <code>repeated string stable_revision_tags = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The count of stableRevisionTags.
     */
    public int getStableRevisionTagsCount() {
      return stableRevisionTags_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of tags that are added to the final stable revision when
     * the stable phase is applied.
     * </pre>
     *
     * <code>repeated string stable_revision_tags = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The stableRevisionTags at the given index.
     */
    public java.lang.String getStableRevisionTags(int index) {
      return stableRevisionTags_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of tags that are added to the final stable revision when
     * the stable phase is applied.
     * </pre>
     *
     * <code>repeated string stable_revision_tags = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the stableRevisionTags at the given index.
     */
    public com.google.protobuf.ByteString getStableRevisionTagsBytes(int index) {
      return stableRevisionTags_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of tags that are added to the final stable revision when
     * the stable phase is applied.
     * </pre>
     *
     * <code>repeated string stable_revision_tags = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The stableRevisionTags to set.
     * @return This builder for chaining.
     */
    public Builder setStableRevisionTags(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureStableRevisionTagsIsMutable();
      stableRevisionTags_.set(index, value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of tags that are added to the final stable revision when
     * the stable phase is applied.
     * </pre>
     *
     * <code>repeated string stable_revision_tags = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The stableRevisionTags to add.
     * @return This builder for chaining.
     */
    public Builder addStableRevisionTags(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureStableRevisionTagsIsMutable();
      stableRevisionTags_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of tags that are added to the final stable revision when
     * the stable phase is applied.
     * </pre>
     *
     * <code>repeated string stable_revision_tags = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param values The stableRevisionTags to add.
     * @return This builder for chaining.
     */
    public Builder addAllStableRevisionTags(java.lang.Iterable<java.lang.String> values) {
      ensureStableRevisionTagsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, stableRevisionTags_);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of tags that are added to the final stable revision when
     * the stable phase is applied.
     * </pre>
     *
     * <code>repeated string stable_revision_tags = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStableRevisionTags() {
      stableRevisionTags_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000008);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of tags that are added to the final stable revision when
     * the stable phase is applied.
     * </pre>
     *
     * <code>repeated string stable_revision_tags = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The bytes of the stableRevisionTags to add.
     * @return This builder for chaining.
     */
    public Builder addStableRevisionTagsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureStableRevisionTagsIsMutable();
      stableRevisionTags_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.deploy.v1.CloudRunConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.deploy.v1.CloudRunConfig)
  private static final com.google.cloud.deploy.v1.CloudRunConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.deploy.v1.CloudRunConfig();
  }

  public static com.google.cloud.deploy.v1.CloudRunConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CloudRunConfig> PARSER =
      new com.google.protobuf.AbstractParser<CloudRunConfig>() {
        @java.lang.Override
        public CloudRunConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CloudRunConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CloudRunConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.deploy.v1.CloudRunConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
