/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/deploy/v1/cloud_deploy.proto

package com.google.cloud.deploy.v1;

/**
 *
 *
 * <pre>
 * DeployJobRun contains information specific to a deploy `JobRun`.
 * </pre>
 *
 * Protobuf type {@code google.cloud.deploy.v1.DeployJobRun}
 */
public final class DeployJobRun extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.deploy.v1.DeployJobRun)
    DeployJobRunOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use DeployJobRun.newBuilder() to construct.
  private DeployJobRun(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DeployJobRun() {
    build_ = "";
    failureCause_ = 0;
    failureMessage_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DeployJobRun();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.deploy.v1.CloudDeployProto
        .internal_static_google_cloud_deploy_v1_DeployJobRun_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.deploy.v1.CloudDeployProto
        .internal_static_google_cloud_deploy_v1_DeployJobRun_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.deploy.v1.DeployJobRun.class,
            com.google.cloud.deploy.v1.DeployJobRun.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Well-known deploy failures.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.deploy.v1.DeployJobRun.FailureCause}
   */
  public enum FailureCause implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * No reason for failure is specified.
     * </pre>
     *
     * <code>FAILURE_CAUSE_UNSPECIFIED = 0;</code>
     */
    FAILURE_CAUSE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Cloud Build is not available, either because it is not enabled or because
     * Cloud Deploy has insufficient permissions. See [Required
     * permission](https://cloud.google.com/deploy/docs/cloud-deploy-service-account#required_permissions).
     * </pre>
     *
     * <code>CLOUD_BUILD_UNAVAILABLE = 1;</code>
     */
    CLOUD_BUILD_UNAVAILABLE(1),
    /**
     *
     *
     * <pre>
     * The deploy operation did not complete successfully; check Cloud Build
     * logs.
     * </pre>
     *
     * <code>EXECUTION_FAILED = 2;</code>
     */
    EXECUTION_FAILED(2),
    /**
     *
     *
     * <pre>
     * The deploy job run did not complete within the alloted time.
     * </pre>
     *
     * <code>DEADLINE_EXCEEDED = 3;</code>
     */
    DEADLINE_EXCEEDED(3),
    /**
     *
     *
     * <pre>
     * There were missing resources in the runtime environment required for a
     * canary deployment. Check the Cloud Build logs for more information.
     * </pre>
     *
     * <code>MISSING_RESOURCES_FOR_CANARY = 4;</code>
     */
    MISSING_RESOURCES_FOR_CANARY(4),
    /**
     *
     *
     * <pre>
     * Cloud Build failed to fulfill Cloud Deploy's request. See failure_message
     * for additional details.
     * </pre>
     *
     * <code>CLOUD_BUILD_REQUEST_FAILED = 5;</code>
     */
    CLOUD_BUILD_REQUEST_FAILED(5),
    /**
     *
     *
     * <pre>
     * The deploy operation had a feature configured that is not supported.
     * </pre>
     *
     * <code>DEPLOY_FEATURE_NOT_SUPPORTED = 6;</code>
     */
    DEPLOY_FEATURE_NOT_SUPPORTED(6),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * No reason for failure is specified.
     * </pre>
     *
     * <code>FAILURE_CAUSE_UNSPECIFIED = 0;</code>
     */
    public static final int FAILURE_CAUSE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Cloud Build is not available, either because it is not enabled or because
     * Cloud Deploy has insufficient permissions. See [Required
     * permission](https://cloud.google.com/deploy/docs/cloud-deploy-service-account#required_permissions).
     * </pre>
     *
     * <code>CLOUD_BUILD_UNAVAILABLE = 1;</code>
     */
    public static final int CLOUD_BUILD_UNAVAILABLE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The deploy operation did not complete successfully; check Cloud Build
     * logs.
     * </pre>
     *
     * <code>EXECUTION_FAILED = 2;</code>
     */
    public static final int EXECUTION_FAILED_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The deploy job run did not complete within the alloted time.
     * </pre>
     *
     * <code>DEADLINE_EXCEEDED = 3;</code>
     */
    public static final int DEADLINE_EXCEEDED_VALUE = 3;
    /**
     *
     *
     * <pre>
     * There were missing resources in the runtime environment required for a
     * canary deployment. Check the Cloud Build logs for more information.
     * </pre>
     *
     * <code>MISSING_RESOURCES_FOR_CANARY = 4;</code>
     */
    public static final int MISSING_RESOURCES_FOR_CANARY_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Cloud Build failed to fulfill Cloud Deploy's request. See failure_message
     * for additional details.
     * </pre>
     *
     * <code>CLOUD_BUILD_REQUEST_FAILED = 5;</code>
     */
    public static final int CLOUD_BUILD_REQUEST_FAILED_VALUE = 5;
    /**
     *
     *
     * <pre>
     * The deploy operation had a feature configured that is not supported.
     * </pre>
     *
     * <code>DEPLOY_FEATURE_NOT_SUPPORTED = 6;</code>
     */
    public static final int DEPLOY_FEATURE_NOT_SUPPORTED_VALUE = 6;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static FailureCause valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static FailureCause forNumber(int value) {
      switch (value) {
        case 0:
          return FAILURE_CAUSE_UNSPECIFIED;
        case 1:
          return CLOUD_BUILD_UNAVAILABLE;
        case 2:
          return EXECUTION_FAILED;
        case 3:
          return DEADLINE_EXCEEDED;
        case 4:
          return MISSING_RESOURCES_FOR_CANARY;
        case 5:
          return CLOUD_BUILD_REQUEST_FAILED;
        case 6:
          return DEPLOY_FEATURE_NOT_SUPPORTED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<FailureCause> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<FailureCause> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<FailureCause>() {
          public FailureCause findValueByNumber(int number) {
            return FailureCause.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.deploy.v1.DeployJobRun.getDescriptor().getEnumTypes().get(0);
    }

    private static final FailureCause[] VALUES = values();

    public static FailureCause valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private FailureCause(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.deploy.v1.DeployJobRun.FailureCause)
  }

  public static final int BUILD_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object build_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the Cloud Build `Build` object that is
   * used to deploy. Format is
   * `projects/{project}/locations/{location}/builds/{build}`.
   * </pre>
   *
   * <code>
   * string build = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The build.
   */
  @java.lang.Override
  public java.lang.String getBuild() {
    java.lang.Object ref = build_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      build_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the Cloud Build `Build` object that is
   * used to deploy. Format is
   * `projects/{project}/locations/{location}/builds/{build}`.
   * </pre>
   *
   * <code>
   * string build = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for build.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBuildBytes() {
    java.lang.Object ref = build_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      build_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FAILURE_CAUSE_FIELD_NUMBER = 2;
  private int failureCause_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The reason the deploy failed. This will always be unspecified
   * while the deploy is in progress or if it succeeded.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.DeployJobRun.FailureCause failure_cause = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for failureCause.
   */
  @java.lang.Override
  public int getFailureCauseValue() {
    return failureCause_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The reason the deploy failed. This will always be unspecified
   * while the deploy is in progress or if it succeeded.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.DeployJobRun.FailureCause failure_cause = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The failureCause.
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.DeployJobRun.FailureCause getFailureCause() {
    com.google.cloud.deploy.v1.DeployJobRun.FailureCause result =
        com.google.cloud.deploy.v1.DeployJobRun.FailureCause.forNumber(failureCause_);
    return result == null
        ? com.google.cloud.deploy.v1.DeployJobRun.FailureCause.UNRECOGNIZED
        : result;
  }

  public static final int FAILURE_MESSAGE_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object failureMessage_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Additional information about the deploy failure, if available.
   * </pre>
   *
   * <code>string failure_message = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The failureMessage.
   */
  @java.lang.Override
  public java.lang.String getFailureMessage() {
    java.lang.Object ref = failureMessage_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      failureMessage_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Additional information about the deploy failure, if available.
   * </pre>
   *
   * <code>string failure_message = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for failureMessage.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFailureMessageBytes() {
    java.lang.Object ref = failureMessage_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      failureMessage_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int METADATA_FIELD_NUMBER = 4;
  private com.google.cloud.deploy.v1.DeployJobRunMetadata metadata_;
  /**
   *
   *
   * <pre>
   * Output only. Metadata containing information about the deploy job run.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.DeployJobRunMetadata metadata = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the metadata field is set.
   */
  @java.lang.Override
  public boolean hasMetadata() {
    return metadata_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Metadata containing information about the deploy job run.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.DeployJobRunMetadata metadata = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The metadata.
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.DeployJobRunMetadata getMetadata() {
    return metadata_ == null
        ? com.google.cloud.deploy.v1.DeployJobRunMetadata.getDefaultInstance()
        : metadata_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Metadata containing information about the deploy job run.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.DeployJobRunMetadata metadata = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.DeployJobRunMetadataOrBuilder getMetadataOrBuilder() {
    return metadata_ == null
        ? com.google.cloud.deploy.v1.DeployJobRunMetadata.getDefaultInstance()
        : metadata_;
  }

  public static final int ARTIFACT_FIELD_NUMBER = 5;
  private com.google.cloud.deploy.v1.DeployArtifact artifact_;
  /**
   *
   *
   * <pre>
   * Output only. The artifact of a deploy job run, if available.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.DeployArtifact artifact = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the artifact field is set.
   */
  @java.lang.Override
  public boolean hasArtifact() {
    return artifact_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The artifact of a deploy job run, if available.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.DeployArtifact artifact = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The artifact.
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.DeployArtifact getArtifact() {
    return artifact_ == null
        ? com.google.cloud.deploy.v1.DeployArtifact.getDefaultInstance()
        : artifact_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The artifact of a deploy job run, if available.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.DeployArtifact artifact = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.DeployArtifactOrBuilder getArtifactOrBuilder() {
    return artifact_ == null
        ? com.google.cloud.deploy.v1.DeployArtifact.getDefaultInstance()
        : artifact_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(build_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, build_);
    }
    if (failureCause_
        != com.google.cloud.deploy.v1.DeployJobRun.FailureCause.FAILURE_CAUSE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(2, failureCause_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(failureMessage_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, failureMessage_);
    }
    if (metadata_ != null) {
      output.writeMessage(4, getMetadata());
    }
    if (artifact_ != null) {
      output.writeMessage(5, getArtifact());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(build_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, build_);
    }
    if (failureCause_
        != com.google.cloud.deploy.v1.DeployJobRun.FailureCause.FAILURE_CAUSE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, failureCause_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(failureMessage_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, failureMessage_);
    }
    if (metadata_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getMetadata());
    }
    if (artifact_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getArtifact());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.deploy.v1.DeployJobRun)) {
      return super.equals(obj);
    }
    com.google.cloud.deploy.v1.DeployJobRun other = (com.google.cloud.deploy.v1.DeployJobRun) obj;

    if (!getBuild().equals(other.getBuild())) return false;
    if (failureCause_ != other.failureCause_) return false;
    if (!getFailureMessage().equals(other.getFailureMessage())) return false;
    if (hasMetadata() != other.hasMetadata()) return false;
    if (hasMetadata()) {
      if (!getMetadata().equals(other.getMetadata())) return false;
    }
    if (hasArtifact() != other.hasArtifact()) return false;
    if (hasArtifact()) {
      if (!getArtifact().equals(other.getArtifact())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + BUILD_FIELD_NUMBER;
    hash = (53 * hash) + getBuild().hashCode();
    hash = (37 * hash) + FAILURE_CAUSE_FIELD_NUMBER;
    hash = (53 * hash) + failureCause_;
    hash = (37 * hash) + FAILURE_MESSAGE_FIELD_NUMBER;
    hash = (53 * hash) + getFailureMessage().hashCode();
    if (hasMetadata()) {
      hash = (37 * hash) + METADATA_FIELD_NUMBER;
      hash = (53 * hash) + getMetadata().hashCode();
    }
    if (hasArtifact()) {
      hash = (37 * hash) + ARTIFACT_FIELD_NUMBER;
      hash = (53 * hash) + getArtifact().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.deploy.v1.DeployJobRun parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.DeployJobRun parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.DeployJobRun parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.DeployJobRun parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.DeployJobRun parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.DeployJobRun parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.DeployJobRun parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.DeployJobRun parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.DeployJobRun parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.DeployJobRun parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.DeployJobRun parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.DeployJobRun parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.deploy.v1.DeployJobRun prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * DeployJobRun contains information specific to a deploy `JobRun`.
   * </pre>
   *
   * Protobuf type {@code google.cloud.deploy.v1.DeployJobRun}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.deploy.v1.DeployJobRun)
      com.google.cloud.deploy.v1.DeployJobRunOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_DeployJobRun_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_DeployJobRun_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.deploy.v1.DeployJobRun.class,
              com.google.cloud.deploy.v1.DeployJobRun.Builder.class);
    }

    // Construct using com.google.cloud.deploy.v1.DeployJobRun.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      build_ = "";
      failureCause_ = 0;
      failureMessage_ = "";
      metadata_ = null;
      if (metadataBuilder_ != null) {
        metadataBuilder_.dispose();
        metadataBuilder_ = null;
      }
      artifact_ = null;
      if (artifactBuilder_ != null) {
        artifactBuilder_.dispose();
        artifactBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_DeployJobRun_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.DeployJobRun getDefaultInstanceForType() {
      return com.google.cloud.deploy.v1.DeployJobRun.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.DeployJobRun build() {
      com.google.cloud.deploy.v1.DeployJobRun result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.DeployJobRun buildPartial() {
      com.google.cloud.deploy.v1.DeployJobRun result =
          new com.google.cloud.deploy.v1.DeployJobRun(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.deploy.v1.DeployJobRun result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.build_ = build_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.failureCause_ = failureCause_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.failureMessage_ = failureMessage_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.metadata_ = metadataBuilder_ == null ? metadata_ : metadataBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.artifact_ = artifactBuilder_ == null ? artifact_ : artifactBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.deploy.v1.DeployJobRun) {
        return mergeFrom((com.google.cloud.deploy.v1.DeployJobRun) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.deploy.v1.DeployJobRun other) {
      if (other == com.google.cloud.deploy.v1.DeployJobRun.getDefaultInstance()) return this;
      if (!other.getBuild().isEmpty()) {
        build_ = other.build_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.failureCause_ != 0) {
        setFailureCauseValue(other.getFailureCauseValue());
      }
      if (!other.getFailureMessage().isEmpty()) {
        failureMessage_ = other.failureMessage_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasMetadata()) {
        mergeMetadata(other.getMetadata());
      }
      if (other.hasArtifact()) {
        mergeArtifact(other.getArtifact());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                build_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                failureCause_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                failureMessage_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getMetadataFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getArtifactFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object build_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the Cloud Build `Build` object that is
     * used to deploy. Format is
     * `projects/{project}/locations/{location}/builds/{build}`.
     * </pre>
     *
     * <code>
     * string build = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The build.
     */
    public java.lang.String getBuild() {
      java.lang.Object ref = build_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        build_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the Cloud Build `Build` object that is
     * used to deploy. Format is
     * `projects/{project}/locations/{location}/builds/{build}`.
     * </pre>
     *
     * <code>
     * string build = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for build.
     */
    public com.google.protobuf.ByteString getBuildBytes() {
      java.lang.Object ref = build_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        build_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the Cloud Build `Build` object that is
     * used to deploy. Format is
     * `projects/{project}/locations/{location}/builds/{build}`.
     * </pre>
     *
     * <code>
     * string build = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The build to set.
     * @return This builder for chaining.
     */
    public Builder setBuild(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      build_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the Cloud Build `Build` object that is
     * used to deploy. Format is
     * `projects/{project}/locations/{location}/builds/{build}`.
     * </pre>
     *
     * <code>
     * string build = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBuild() {
      build_ = getDefaultInstance().getBuild();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the Cloud Build `Build` object that is
     * used to deploy. Format is
     * `projects/{project}/locations/{location}/builds/{build}`.
     * </pre>
     *
     * <code>
     * string build = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for build to set.
     * @return This builder for chaining.
     */
    public Builder setBuildBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      build_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int failureCause_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The reason the deploy failed. This will always be unspecified
     * while the deploy is in progress or if it succeeded.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.DeployJobRun.FailureCause failure_cause = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for failureCause.
     */
    @java.lang.Override
    public int getFailureCauseValue() {
      return failureCause_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The reason the deploy failed. This will always be unspecified
     * while the deploy is in progress or if it succeeded.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.DeployJobRun.FailureCause failure_cause = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for failureCause to set.
     * @return This builder for chaining.
     */
    public Builder setFailureCauseValue(int value) {
      failureCause_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The reason the deploy failed. This will always be unspecified
     * while the deploy is in progress or if it succeeded.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.DeployJobRun.FailureCause failure_cause = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The failureCause.
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.DeployJobRun.FailureCause getFailureCause() {
      com.google.cloud.deploy.v1.DeployJobRun.FailureCause result =
          com.google.cloud.deploy.v1.DeployJobRun.FailureCause.forNumber(failureCause_);
      return result == null
          ? com.google.cloud.deploy.v1.DeployJobRun.FailureCause.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The reason the deploy failed. This will always be unspecified
     * while the deploy is in progress or if it succeeded.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.DeployJobRun.FailureCause failure_cause = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The failureCause to set.
     * @return This builder for chaining.
     */
    public Builder setFailureCause(com.google.cloud.deploy.v1.DeployJobRun.FailureCause value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      failureCause_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The reason the deploy failed. This will always be unspecified
     * while the deploy is in progress or if it succeeded.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.DeployJobRun.FailureCause failure_cause = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFailureCause() {
      bitField0_ = (bitField0_ & ~0x00000002);
      failureCause_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object failureMessage_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Additional information about the deploy failure, if available.
     * </pre>
     *
     * <code>string failure_message = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The failureMessage.
     */
    public java.lang.String getFailureMessage() {
      java.lang.Object ref = failureMessage_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        failureMessage_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information about the deploy failure, if available.
     * </pre>
     *
     * <code>string failure_message = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for failureMessage.
     */
    public com.google.protobuf.ByteString getFailureMessageBytes() {
      java.lang.Object ref = failureMessage_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        failureMessage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information about the deploy failure, if available.
     * </pre>
     *
     * <code>string failure_message = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The failureMessage to set.
     * @return This builder for chaining.
     */
    public Builder setFailureMessage(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      failureMessage_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information about the deploy failure, if available.
     * </pre>
     *
     * <code>string failure_message = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFailureMessage() {
      failureMessage_ = getDefaultInstance().getFailureMessage();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information about the deploy failure, if available.
     * </pre>
     *
     * <code>string failure_message = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for failureMessage to set.
     * @return This builder for chaining.
     */
    public Builder setFailureMessageBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      failureMessage_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.cloud.deploy.v1.DeployJobRunMetadata metadata_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.DeployJobRunMetadata,
            com.google.cloud.deploy.v1.DeployJobRunMetadata.Builder,
            com.google.cloud.deploy.v1.DeployJobRunMetadataOrBuilder>
        metadataBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Metadata containing information about the deploy job run.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.DeployJobRunMetadata metadata = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the metadata field is set.
     */
    public boolean hasMetadata() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Metadata containing information about the deploy job run.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.DeployJobRunMetadata metadata = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The metadata.
     */
    public com.google.cloud.deploy.v1.DeployJobRunMetadata getMetadata() {
      if (metadataBuilder_ == null) {
        return metadata_ == null
            ? com.google.cloud.deploy.v1.DeployJobRunMetadata.getDefaultInstance()
            : metadata_;
      } else {
        return metadataBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Metadata containing information about the deploy job run.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.DeployJobRunMetadata metadata = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setMetadata(com.google.cloud.deploy.v1.DeployJobRunMetadata value) {
      if (metadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metadata_ = value;
      } else {
        metadataBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Metadata containing information about the deploy job run.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.DeployJobRunMetadata metadata = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setMetadata(
        com.google.cloud.deploy.v1.DeployJobRunMetadata.Builder builderForValue) {
      if (metadataBuilder_ == null) {
        metadata_ = builderForValue.build();
      } else {
        metadataBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Metadata containing information about the deploy job run.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.DeployJobRunMetadata metadata = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeMetadata(com.google.cloud.deploy.v1.DeployJobRunMetadata value) {
      if (metadataBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && metadata_ != null
            && metadata_ != com.google.cloud.deploy.v1.DeployJobRunMetadata.getDefaultInstance()) {
          getMetadataBuilder().mergeFrom(value);
        } else {
          metadata_ = value;
        }
      } else {
        metadataBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Metadata containing information about the deploy job run.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.DeployJobRunMetadata metadata = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearMetadata() {
      bitField0_ = (bitField0_ & ~0x00000008);
      metadata_ = null;
      if (metadataBuilder_ != null) {
        metadataBuilder_.dispose();
        metadataBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Metadata containing information about the deploy job run.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.DeployJobRunMetadata metadata = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.deploy.v1.DeployJobRunMetadata.Builder getMetadataBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Metadata containing information about the deploy job run.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.DeployJobRunMetadata metadata = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.deploy.v1.DeployJobRunMetadataOrBuilder getMetadataOrBuilder() {
      if (metadataBuilder_ != null) {
        return metadataBuilder_.getMessageOrBuilder();
      } else {
        return metadata_ == null
            ? com.google.cloud.deploy.v1.DeployJobRunMetadata.getDefaultInstance()
            : metadata_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Metadata containing information about the deploy job run.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.DeployJobRunMetadata metadata = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.DeployJobRunMetadata,
            com.google.cloud.deploy.v1.DeployJobRunMetadata.Builder,
            com.google.cloud.deploy.v1.DeployJobRunMetadataOrBuilder>
        getMetadataFieldBuilder() {
      if (metadataBuilder_ == null) {
        metadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.deploy.v1.DeployJobRunMetadata,
                com.google.cloud.deploy.v1.DeployJobRunMetadata.Builder,
                com.google.cloud.deploy.v1.DeployJobRunMetadataOrBuilder>(
                getMetadata(), getParentForChildren(), isClean());
        metadata_ = null;
      }
      return metadataBuilder_;
    }

    private com.google.cloud.deploy.v1.DeployArtifact artifact_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.DeployArtifact,
            com.google.cloud.deploy.v1.DeployArtifact.Builder,
            com.google.cloud.deploy.v1.DeployArtifactOrBuilder>
        artifactBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The artifact of a deploy job run, if available.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.DeployArtifact artifact = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the artifact field is set.
     */
    public boolean hasArtifact() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The artifact of a deploy job run, if available.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.DeployArtifact artifact = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The artifact.
     */
    public com.google.cloud.deploy.v1.DeployArtifact getArtifact() {
      if (artifactBuilder_ == null) {
        return artifact_ == null
            ? com.google.cloud.deploy.v1.DeployArtifact.getDefaultInstance()
            : artifact_;
      } else {
        return artifactBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The artifact of a deploy job run, if available.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.DeployArtifact artifact = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setArtifact(com.google.cloud.deploy.v1.DeployArtifact value) {
      if (artifactBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        artifact_ = value;
      } else {
        artifactBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The artifact of a deploy job run, if available.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.DeployArtifact artifact = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setArtifact(com.google.cloud.deploy.v1.DeployArtifact.Builder builderForValue) {
      if (artifactBuilder_ == null) {
        artifact_ = builderForValue.build();
      } else {
        artifactBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The artifact of a deploy job run, if available.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.DeployArtifact artifact = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeArtifact(com.google.cloud.deploy.v1.DeployArtifact value) {
      if (artifactBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && artifact_ != null
            && artifact_ != com.google.cloud.deploy.v1.DeployArtifact.getDefaultInstance()) {
          getArtifactBuilder().mergeFrom(value);
        } else {
          artifact_ = value;
        }
      } else {
        artifactBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The artifact of a deploy job run, if available.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.DeployArtifact artifact = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearArtifact() {
      bitField0_ = (bitField0_ & ~0x00000010);
      artifact_ = null;
      if (artifactBuilder_ != null) {
        artifactBuilder_.dispose();
        artifactBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The artifact of a deploy job run, if available.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.DeployArtifact artifact = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.deploy.v1.DeployArtifact.Builder getArtifactBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getArtifactFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The artifact of a deploy job run, if available.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.DeployArtifact artifact = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.deploy.v1.DeployArtifactOrBuilder getArtifactOrBuilder() {
      if (artifactBuilder_ != null) {
        return artifactBuilder_.getMessageOrBuilder();
      } else {
        return artifact_ == null
            ? com.google.cloud.deploy.v1.DeployArtifact.getDefaultInstance()
            : artifact_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The artifact of a deploy job run, if available.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.DeployArtifact artifact = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.DeployArtifact,
            com.google.cloud.deploy.v1.DeployArtifact.Builder,
            com.google.cloud.deploy.v1.DeployArtifactOrBuilder>
        getArtifactFieldBuilder() {
      if (artifactBuilder_ == null) {
        artifactBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.deploy.v1.DeployArtifact,
                com.google.cloud.deploy.v1.DeployArtifact.Builder,
                com.google.cloud.deploy.v1.DeployArtifactOrBuilder>(
                getArtifact(), getParentForChildren(), isClean());
        artifact_ = null;
      }
      return artifactBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.deploy.v1.DeployJobRun)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.deploy.v1.DeployJobRun)
  private static final com.google.cloud.deploy.v1.DeployJobRun DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.deploy.v1.DeployJobRun();
  }

  public static com.google.cloud.deploy.v1.DeployJobRun getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DeployJobRun> PARSER =
      new com.google.protobuf.AbstractParser<DeployJobRun>() {
        @java.lang.Override
        public DeployJobRun parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<DeployJobRun> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DeployJobRun> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.deploy.v1.DeployJobRun getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
