/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/deploy/v1/cloud_deploy.proto

package com.google.cloud.deploy.v1;

/**
 *
 *
 * <pre>
 * Job represents an operation for a `Rollout`.
 * </pre>
 *
 * Protobuf type {@code google.cloud.deploy.v1.Job}
 */
public final class Job extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.deploy.v1.Job)
    JobOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Job.newBuilder() to construct.
  private Job(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Job() {
    id_ = "";
    state_ = 0;
    skipMessage_ = "";
    jobRun_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Job();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.deploy.v1.CloudDeployProto
        .internal_static_google_cloud_deploy_v1_Job_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.deploy.v1.CloudDeployProto
        .internal_static_google_cloud_deploy_v1_Job_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.deploy.v1.Job.class, com.google.cloud.deploy.v1.Job.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Valid states of a Job.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.deploy.v1.Job.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The Job has an unspecified state.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The Job is waiting for an earlier Phase(s) or Job(s) to complete.
     * </pre>
     *
     * <code>PENDING = 1;</code>
     */
    PENDING(1),
    /**
     *
     *
     * <pre>
     * The Job is disabled.
     * </pre>
     *
     * <code>DISABLED = 2;</code>
     */
    DISABLED(2),
    /**
     *
     *
     * <pre>
     * The Job is in progress.
     * </pre>
     *
     * <code>IN_PROGRESS = 3;</code>
     */
    IN_PROGRESS(3),
    /**
     *
     *
     * <pre>
     * The Job succeeded.
     * </pre>
     *
     * <code>SUCCEEDED = 4;</code>
     */
    SUCCEEDED(4),
    /**
     *
     *
     * <pre>
     * The Job failed.
     * </pre>
     *
     * <code>FAILED = 5;</code>
     */
    FAILED(5),
    /**
     *
     *
     * <pre>
     * The Job was aborted.
     * </pre>
     *
     * <code>ABORTED = 6;</code>
     */
    ABORTED(6),
    /**
     *
     *
     * <pre>
     * The Job was skipped.
     * </pre>
     *
     * <code>SKIPPED = 7;</code>
     */
    SKIPPED(7),
    /**
     *
     *
     * <pre>
     * The Job was ignored.
     * </pre>
     *
     * <code>IGNORED = 8;</code>
     */
    IGNORED(8),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The Job has an unspecified state.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The Job is waiting for an earlier Phase(s) or Job(s) to complete.
     * </pre>
     *
     * <code>PENDING = 1;</code>
     */
    public static final int PENDING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The Job is disabled.
     * </pre>
     *
     * <code>DISABLED = 2;</code>
     */
    public static final int DISABLED_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The Job is in progress.
     * </pre>
     *
     * <code>IN_PROGRESS = 3;</code>
     */
    public static final int IN_PROGRESS_VALUE = 3;
    /**
     *
     *
     * <pre>
     * The Job succeeded.
     * </pre>
     *
     * <code>SUCCEEDED = 4;</code>
     */
    public static final int SUCCEEDED_VALUE = 4;
    /**
     *
     *
     * <pre>
     * The Job failed.
     * </pre>
     *
     * <code>FAILED = 5;</code>
     */
    public static final int FAILED_VALUE = 5;
    /**
     *
     *
     * <pre>
     * The Job was aborted.
     * </pre>
     *
     * <code>ABORTED = 6;</code>
     */
    public static final int ABORTED_VALUE = 6;
    /**
     *
     *
     * <pre>
     * The Job was skipped.
     * </pre>
     *
     * <code>SKIPPED = 7;</code>
     */
    public static final int SKIPPED_VALUE = 7;
    /**
     *
     *
     * <pre>
     * The Job was ignored.
     * </pre>
     *
     * <code>IGNORED = 8;</code>
     */
    public static final int IGNORED_VALUE = 8;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return PENDING;
        case 2:
          return DISABLED;
        case 3:
          return IN_PROGRESS;
        case 4:
          return SUCCEEDED;
        case 5:
          return FAILED;
        case 6:
          return ABORTED;
        case 7:
          return SKIPPED;
        case 8:
          return IGNORED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.deploy.v1.Job.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.deploy.v1.Job.State)
  }

  private int jobTypeCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object jobType_;

  public enum JobTypeCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    DEPLOY_JOB(4),
    VERIFY_JOB(5),
    PREDEPLOY_JOB(9),
    POSTDEPLOY_JOB(10),
    CREATE_CHILD_ROLLOUT_JOB(6),
    ADVANCE_CHILD_ROLLOUT_JOB(7),
    JOBTYPE_NOT_SET(0);
    private final int value;

    private JobTypeCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static JobTypeCase valueOf(int value) {
      return forNumber(value);
    }

    public static JobTypeCase forNumber(int value) {
      switch (value) {
        case 4:
          return DEPLOY_JOB;
        case 5:
          return VERIFY_JOB;
        case 9:
          return PREDEPLOY_JOB;
        case 10:
          return POSTDEPLOY_JOB;
        case 6:
          return CREATE_CHILD_ROLLOUT_JOB;
        case 7:
          return ADVANCE_CHILD_ROLLOUT_JOB;
        case 0:
          return JOBTYPE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public JobTypeCase getJobTypeCase() {
    return JobTypeCase.forNumber(jobTypeCase_);
  }

  public static final int ID_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object id_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The ID of the Job.
   * </pre>
   *
   * <code>string id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public java.lang.String getId() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      id_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The ID of the Job.
   * </pre>
   *
   * <code>string id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for id.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIdBytes() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      id_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATE_FIELD_NUMBER = 2;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The current state of the Job.
   * </pre>
   *
   * <code>.google.cloud.deploy.v1.Job.State state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The current state of the Job.
   * </pre>
   *
   * <code>.google.cloud.deploy.v1.Job.State state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.Job.State getState() {
    com.google.cloud.deploy.v1.Job.State result =
        com.google.cloud.deploy.v1.Job.State.forNumber(state_);
    return result == null ? com.google.cloud.deploy.v1.Job.State.UNRECOGNIZED : result;
  }

  public static final int SKIP_MESSAGE_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object skipMessage_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Additional information on why the Job was skipped, if
   * available.
   * </pre>
   *
   * <code>string skip_message = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The skipMessage.
   */
  @java.lang.Override
  public java.lang.String getSkipMessage() {
    java.lang.Object ref = skipMessage_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      skipMessage_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Additional information on why the Job was skipped, if
   * available.
   * </pre>
   *
   * <code>string skip_message = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for skipMessage.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSkipMessageBytes() {
    java.lang.Object ref = skipMessage_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      skipMessage_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int JOB_RUN_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object jobRun_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The name of the `JobRun` responsible for the most recent
   * invocation of this Job.
   * </pre>
   *
   * <code>
   * string job_run = 3 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The jobRun.
   */
  @java.lang.Override
  public java.lang.String getJobRun() {
    java.lang.Object ref = jobRun_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      jobRun_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The name of the `JobRun` responsible for the most recent
   * invocation of this Job.
   * </pre>
   *
   * <code>
   * string job_run = 3 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for jobRun.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getJobRunBytes() {
    java.lang.Object ref = jobRun_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      jobRun_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DEPLOY_JOB_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Output only. A deploy Job.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.DeployJob deploy_job = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the deployJob field is set.
   */
  @java.lang.Override
  public boolean hasDeployJob() {
    return jobTypeCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Output only. A deploy Job.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.DeployJob deploy_job = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The deployJob.
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.DeployJob getDeployJob() {
    if (jobTypeCase_ == 4) {
      return (com.google.cloud.deploy.v1.DeployJob) jobType_;
    }
    return com.google.cloud.deploy.v1.DeployJob.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Output only. A deploy Job.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.DeployJob deploy_job = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.DeployJobOrBuilder getDeployJobOrBuilder() {
    if (jobTypeCase_ == 4) {
      return (com.google.cloud.deploy.v1.DeployJob) jobType_;
    }
    return com.google.cloud.deploy.v1.DeployJob.getDefaultInstance();
  }

  public static final int VERIFY_JOB_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * Output only. A verify Job.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.VerifyJob verify_job = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the verifyJob field is set.
   */
  @java.lang.Override
  public boolean hasVerifyJob() {
    return jobTypeCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * Output only. A verify Job.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.VerifyJob verify_job = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The verifyJob.
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.VerifyJob getVerifyJob() {
    if (jobTypeCase_ == 5) {
      return (com.google.cloud.deploy.v1.VerifyJob) jobType_;
    }
    return com.google.cloud.deploy.v1.VerifyJob.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Output only. A verify Job.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.VerifyJob verify_job = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.VerifyJobOrBuilder getVerifyJobOrBuilder() {
    if (jobTypeCase_ == 5) {
      return (com.google.cloud.deploy.v1.VerifyJob) jobType_;
    }
    return com.google.cloud.deploy.v1.VerifyJob.getDefaultInstance();
  }

  public static final int PREDEPLOY_JOB_FIELD_NUMBER = 9;
  /**
   *
   *
   * <pre>
   * Output only. A predeploy Job.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.PredeployJob predeploy_job = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the predeployJob field is set.
   */
  @java.lang.Override
  public boolean hasPredeployJob() {
    return jobTypeCase_ == 9;
  }
  /**
   *
   *
   * <pre>
   * Output only. A predeploy Job.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.PredeployJob predeploy_job = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The predeployJob.
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.PredeployJob getPredeployJob() {
    if (jobTypeCase_ == 9) {
      return (com.google.cloud.deploy.v1.PredeployJob) jobType_;
    }
    return com.google.cloud.deploy.v1.PredeployJob.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Output only. A predeploy Job.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.PredeployJob predeploy_job = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.PredeployJobOrBuilder getPredeployJobOrBuilder() {
    if (jobTypeCase_ == 9) {
      return (com.google.cloud.deploy.v1.PredeployJob) jobType_;
    }
    return com.google.cloud.deploy.v1.PredeployJob.getDefaultInstance();
  }

  public static final int POSTDEPLOY_JOB_FIELD_NUMBER = 10;
  /**
   *
   *
   * <pre>
   * Output only. A postdeploy Job.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.PostdeployJob postdeploy_job = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the postdeployJob field is set.
   */
  @java.lang.Override
  public boolean hasPostdeployJob() {
    return jobTypeCase_ == 10;
  }
  /**
   *
   *
   * <pre>
   * Output only. A postdeploy Job.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.PostdeployJob postdeploy_job = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The postdeployJob.
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.PostdeployJob getPostdeployJob() {
    if (jobTypeCase_ == 10) {
      return (com.google.cloud.deploy.v1.PostdeployJob) jobType_;
    }
    return com.google.cloud.deploy.v1.PostdeployJob.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Output only. A postdeploy Job.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.PostdeployJob postdeploy_job = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.PostdeployJobOrBuilder getPostdeployJobOrBuilder() {
    if (jobTypeCase_ == 10) {
      return (com.google.cloud.deploy.v1.PostdeployJob) jobType_;
    }
    return com.google.cloud.deploy.v1.PostdeployJob.getDefaultInstance();
  }

  public static final int CREATE_CHILD_ROLLOUT_JOB_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * Output only. A createChildRollout Job.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.CreateChildRolloutJob create_child_rollout_job = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createChildRolloutJob field is set.
   */
  @java.lang.Override
  public boolean hasCreateChildRolloutJob() {
    return jobTypeCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * Output only. A createChildRollout Job.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.CreateChildRolloutJob create_child_rollout_job = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createChildRolloutJob.
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.CreateChildRolloutJob getCreateChildRolloutJob() {
    if (jobTypeCase_ == 6) {
      return (com.google.cloud.deploy.v1.CreateChildRolloutJob) jobType_;
    }
    return com.google.cloud.deploy.v1.CreateChildRolloutJob.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Output only. A createChildRollout Job.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.CreateChildRolloutJob create_child_rollout_job = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.CreateChildRolloutJobOrBuilder
      getCreateChildRolloutJobOrBuilder() {
    if (jobTypeCase_ == 6) {
      return (com.google.cloud.deploy.v1.CreateChildRolloutJob) jobType_;
    }
    return com.google.cloud.deploy.v1.CreateChildRolloutJob.getDefaultInstance();
  }

  public static final int ADVANCE_CHILD_ROLLOUT_JOB_FIELD_NUMBER = 7;
  /**
   *
   *
   * <pre>
   * Output only. An advanceChildRollout Job.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.AdvanceChildRolloutJob advance_child_rollout_job = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the advanceChildRolloutJob field is set.
   */
  @java.lang.Override
  public boolean hasAdvanceChildRolloutJob() {
    return jobTypeCase_ == 7;
  }
  /**
   *
   *
   * <pre>
   * Output only. An advanceChildRollout Job.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.AdvanceChildRolloutJob advance_child_rollout_job = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The advanceChildRolloutJob.
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.AdvanceChildRolloutJob getAdvanceChildRolloutJob() {
    if (jobTypeCase_ == 7) {
      return (com.google.cloud.deploy.v1.AdvanceChildRolloutJob) jobType_;
    }
    return com.google.cloud.deploy.v1.AdvanceChildRolloutJob.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Output only. An advanceChildRollout Job.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.AdvanceChildRolloutJob advance_child_rollout_job = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.AdvanceChildRolloutJobOrBuilder
      getAdvanceChildRolloutJobOrBuilder() {
    if (jobTypeCase_ == 7) {
      return (com.google.cloud.deploy.v1.AdvanceChildRolloutJob) jobType_;
    }
    return com.google.cloud.deploy.v1.AdvanceChildRolloutJob.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, id_);
    }
    if (state_ != com.google.cloud.deploy.v1.Job.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(2, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(jobRun_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, jobRun_);
    }
    if (jobTypeCase_ == 4) {
      output.writeMessage(4, (com.google.cloud.deploy.v1.DeployJob) jobType_);
    }
    if (jobTypeCase_ == 5) {
      output.writeMessage(5, (com.google.cloud.deploy.v1.VerifyJob) jobType_);
    }
    if (jobTypeCase_ == 6) {
      output.writeMessage(6, (com.google.cloud.deploy.v1.CreateChildRolloutJob) jobType_);
    }
    if (jobTypeCase_ == 7) {
      output.writeMessage(7, (com.google.cloud.deploy.v1.AdvanceChildRolloutJob) jobType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(skipMessage_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, skipMessage_);
    }
    if (jobTypeCase_ == 9) {
      output.writeMessage(9, (com.google.cloud.deploy.v1.PredeployJob) jobType_);
    }
    if (jobTypeCase_ == 10) {
      output.writeMessage(10, (com.google.cloud.deploy.v1.PostdeployJob) jobType_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, id_);
    }
    if (state_ != com.google.cloud.deploy.v1.Job.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(jobRun_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, jobRun_);
    }
    if (jobTypeCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.cloud.deploy.v1.DeployJob) jobType_);
    }
    if (jobTypeCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.cloud.deploy.v1.VerifyJob) jobType_);
    }
    if (jobTypeCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.cloud.deploy.v1.CreateChildRolloutJob) jobType_);
    }
    if (jobTypeCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, (com.google.cloud.deploy.v1.AdvanceChildRolloutJob) jobType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(skipMessage_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, skipMessage_);
    }
    if (jobTypeCase_ == 9) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              9, (com.google.cloud.deploy.v1.PredeployJob) jobType_);
    }
    if (jobTypeCase_ == 10) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              10, (com.google.cloud.deploy.v1.PostdeployJob) jobType_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.deploy.v1.Job)) {
      return super.equals(obj);
    }
    com.google.cloud.deploy.v1.Job other = (com.google.cloud.deploy.v1.Job) obj;

    if (!getId().equals(other.getId())) return false;
    if (state_ != other.state_) return false;
    if (!getSkipMessage().equals(other.getSkipMessage())) return false;
    if (!getJobRun().equals(other.getJobRun())) return false;
    if (!getJobTypeCase().equals(other.getJobTypeCase())) return false;
    switch (jobTypeCase_) {
      case 4:
        if (!getDeployJob().equals(other.getDeployJob())) return false;
        break;
      case 5:
        if (!getVerifyJob().equals(other.getVerifyJob())) return false;
        break;
      case 9:
        if (!getPredeployJob().equals(other.getPredeployJob())) return false;
        break;
      case 10:
        if (!getPostdeployJob().equals(other.getPostdeployJob())) return false;
        break;
      case 6:
        if (!getCreateChildRolloutJob().equals(other.getCreateChildRolloutJob())) return false;
        break;
      case 7:
        if (!getAdvanceChildRolloutJob().equals(other.getAdvanceChildRolloutJob())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ID_FIELD_NUMBER;
    hash = (53 * hash) + getId().hashCode();
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (37 * hash) + SKIP_MESSAGE_FIELD_NUMBER;
    hash = (53 * hash) + getSkipMessage().hashCode();
    hash = (37 * hash) + JOB_RUN_FIELD_NUMBER;
    hash = (53 * hash) + getJobRun().hashCode();
    switch (jobTypeCase_) {
      case 4:
        hash = (37 * hash) + DEPLOY_JOB_FIELD_NUMBER;
        hash = (53 * hash) + getDeployJob().hashCode();
        break;
      case 5:
        hash = (37 * hash) + VERIFY_JOB_FIELD_NUMBER;
        hash = (53 * hash) + getVerifyJob().hashCode();
        break;
      case 9:
        hash = (37 * hash) + PREDEPLOY_JOB_FIELD_NUMBER;
        hash = (53 * hash) + getPredeployJob().hashCode();
        break;
      case 10:
        hash = (37 * hash) + POSTDEPLOY_JOB_FIELD_NUMBER;
        hash = (53 * hash) + getPostdeployJob().hashCode();
        break;
      case 6:
        hash = (37 * hash) + CREATE_CHILD_ROLLOUT_JOB_FIELD_NUMBER;
        hash = (53 * hash) + getCreateChildRolloutJob().hashCode();
        break;
      case 7:
        hash = (37 * hash) + ADVANCE_CHILD_ROLLOUT_JOB_FIELD_NUMBER;
        hash = (53 * hash) + getAdvanceChildRolloutJob().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.deploy.v1.Job parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.Job parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.Job parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.Job parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.Job parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.Job parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.Job parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.Job parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.Job parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.Job parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.Job parseFrom(com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.Job parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.deploy.v1.Job prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Job represents an operation for a `Rollout`.
   * </pre>
   *
   * Protobuf type {@code google.cloud.deploy.v1.Job}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.deploy.v1.Job)
      com.google.cloud.deploy.v1.JobOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_Job_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_Job_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.deploy.v1.Job.class, com.google.cloud.deploy.v1.Job.Builder.class);
    }

    // Construct using com.google.cloud.deploy.v1.Job.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      id_ = "";
      state_ = 0;
      skipMessage_ = "";
      jobRun_ = "";
      if (deployJobBuilder_ != null) {
        deployJobBuilder_.clear();
      }
      if (verifyJobBuilder_ != null) {
        verifyJobBuilder_.clear();
      }
      if (predeployJobBuilder_ != null) {
        predeployJobBuilder_.clear();
      }
      if (postdeployJobBuilder_ != null) {
        postdeployJobBuilder_.clear();
      }
      if (createChildRolloutJobBuilder_ != null) {
        createChildRolloutJobBuilder_.clear();
      }
      if (advanceChildRolloutJobBuilder_ != null) {
        advanceChildRolloutJobBuilder_.clear();
      }
      jobTypeCase_ = 0;
      jobType_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_Job_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.Job getDefaultInstanceForType() {
      return com.google.cloud.deploy.v1.Job.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.Job build() {
      com.google.cloud.deploy.v1.Job result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.Job buildPartial() {
      com.google.cloud.deploy.v1.Job result = new com.google.cloud.deploy.v1.Job(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.deploy.v1.Job result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.id_ = id_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.skipMessage_ = skipMessage_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.jobRun_ = jobRun_;
      }
    }

    private void buildPartialOneofs(com.google.cloud.deploy.v1.Job result) {
      result.jobTypeCase_ = jobTypeCase_;
      result.jobType_ = this.jobType_;
      if (jobTypeCase_ == 4 && deployJobBuilder_ != null) {
        result.jobType_ = deployJobBuilder_.build();
      }
      if (jobTypeCase_ == 5 && verifyJobBuilder_ != null) {
        result.jobType_ = verifyJobBuilder_.build();
      }
      if (jobTypeCase_ == 9 && predeployJobBuilder_ != null) {
        result.jobType_ = predeployJobBuilder_.build();
      }
      if (jobTypeCase_ == 10 && postdeployJobBuilder_ != null) {
        result.jobType_ = postdeployJobBuilder_.build();
      }
      if (jobTypeCase_ == 6 && createChildRolloutJobBuilder_ != null) {
        result.jobType_ = createChildRolloutJobBuilder_.build();
      }
      if (jobTypeCase_ == 7 && advanceChildRolloutJobBuilder_ != null) {
        result.jobType_ = advanceChildRolloutJobBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.deploy.v1.Job) {
        return mergeFrom((com.google.cloud.deploy.v1.Job) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.deploy.v1.Job other) {
      if (other == com.google.cloud.deploy.v1.Job.getDefaultInstance()) return this;
      if (!other.getId().isEmpty()) {
        id_ = other.id_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (!other.getSkipMessage().isEmpty()) {
        skipMessage_ = other.skipMessage_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getJobRun().isEmpty()) {
        jobRun_ = other.jobRun_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      switch (other.getJobTypeCase()) {
        case DEPLOY_JOB:
          {
            mergeDeployJob(other.getDeployJob());
            break;
          }
        case VERIFY_JOB:
          {
            mergeVerifyJob(other.getVerifyJob());
            break;
          }
        case PREDEPLOY_JOB:
          {
            mergePredeployJob(other.getPredeployJob());
            break;
          }
        case POSTDEPLOY_JOB:
          {
            mergePostdeployJob(other.getPostdeployJob());
            break;
          }
        case CREATE_CHILD_ROLLOUT_JOB:
          {
            mergeCreateChildRolloutJob(other.getCreateChildRolloutJob());
            break;
          }
        case ADVANCE_CHILD_ROLLOUT_JOB:
          {
            mergeAdvanceChildRolloutJob(other.getAdvanceChildRolloutJob());
            break;
          }
        case JOBTYPE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                id_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                jobRun_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getDeployJobFieldBuilder().getBuilder(), extensionRegistry);
                jobTypeCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getVerifyJobFieldBuilder().getBuilder(), extensionRegistry);
                jobTypeCase_ = 5;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(
                    getCreateChildRolloutJobFieldBuilder().getBuilder(), extensionRegistry);
                jobTypeCase_ = 6;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(
                    getAdvanceChildRolloutJobFieldBuilder().getBuilder(), extensionRegistry);
                jobTypeCase_ = 7;
                break;
              } // case 58
            case 66:
              {
                skipMessage_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(getPredeployJobFieldBuilder().getBuilder(), extensionRegistry);
                jobTypeCase_ = 9;
                break;
              } // case 74
            case 82:
              {
                input.readMessage(getPostdeployJobFieldBuilder().getBuilder(), extensionRegistry);
                jobTypeCase_ = 10;
                break;
              } // case 82
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int jobTypeCase_ = 0;
    private java.lang.Object jobType_;

    public JobTypeCase getJobTypeCase() {
      return JobTypeCase.forNumber(jobTypeCase_);
    }

    public Builder clearJobType() {
      jobTypeCase_ = 0;
      jobType_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object id_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The ID of the Job.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The id.
     */
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The ID of the Job.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for id.
     */
    public com.google.protobuf.ByteString getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The ID of the Job.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      id_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The ID of the Job.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {
      id_ = getDefaultInstance().getId();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The ID of the Job.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for id to set.
     * @return This builder for chaining.
     */
    public Builder setIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      id_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The current state of the Job.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Job.State state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of the Job.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Job.State state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of the Job.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Job.State state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.Job.State getState() {
      com.google.cloud.deploy.v1.Job.State result =
          com.google.cloud.deploy.v1.Job.State.forNumber(state_);
      return result == null ? com.google.cloud.deploy.v1.Job.State.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of the Job.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Job.State state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.deploy.v1.Job.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of the Job.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Job.State state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000002);
      state_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object skipMessage_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Additional information on why the Job was skipped, if
     * available.
     * </pre>
     *
     * <code>string skip_message = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The skipMessage.
     */
    public java.lang.String getSkipMessage() {
      java.lang.Object ref = skipMessage_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        skipMessage_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information on why the Job was skipped, if
     * available.
     * </pre>
     *
     * <code>string skip_message = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for skipMessage.
     */
    public com.google.protobuf.ByteString getSkipMessageBytes() {
      java.lang.Object ref = skipMessage_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        skipMessage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information on why the Job was skipped, if
     * available.
     * </pre>
     *
     * <code>string skip_message = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The skipMessage to set.
     * @return This builder for chaining.
     */
    public Builder setSkipMessage(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      skipMessage_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information on why the Job was skipped, if
     * available.
     * </pre>
     *
     * <code>string skip_message = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSkipMessage() {
      skipMessage_ = getDefaultInstance().getSkipMessage();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information on why the Job was skipped, if
     * available.
     * </pre>
     *
     * <code>string skip_message = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for skipMessage to set.
     * @return This builder for chaining.
     */
    public Builder setSkipMessageBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      skipMessage_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object jobRun_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The name of the `JobRun` responsible for the most recent
     * invocation of this Job.
     * </pre>
     *
     * <code>
     * string job_run = 3 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The jobRun.
     */
    public java.lang.String getJobRun() {
      java.lang.Object ref = jobRun_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        jobRun_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the `JobRun` responsible for the most recent
     * invocation of this Job.
     * </pre>
     *
     * <code>
     * string job_run = 3 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for jobRun.
     */
    public com.google.protobuf.ByteString getJobRunBytes() {
      java.lang.Object ref = jobRun_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        jobRun_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the `JobRun` responsible for the most recent
     * invocation of this Job.
     * </pre>
     *
     * <code>
     * string job_run = 3 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The jobRun to set.
     * @return This builder for chaining.
     */
    public Builder setJobRun(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      jobRun_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the `JobRun` responsible for the most recent
     * invocation of this Job.
     * </pre>
     *
     * <code>
     * string job_run = 3 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearJobRun() {
      jobRun_ = getDefaultInstance().getJobRun();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the `JobRun` responsible for the most recent
     * invocation of this Job.
     * </pre>
     *
     * <code>
     * string job_run = 3 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for jobRun to set.
     * @return This builder for chaining.
     */
    public Builder setJobRunBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      jobRun_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.DeployJob,
            com.google.cloud.deploy.v1.DeployJob.Builder,
            com.google.cloud.deploy.v1.DeployJobOrBuilder>
        deployJobBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. A deploy Job.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.DeployJob deploy_job = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the deployJob field is set.
     */
    @java.lang.Override
    public boolean hasDeployJob() {
      return jobTypeCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Output only. A deploy Job.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.DeployJob deploy_job = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The deployJob.
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.DeployJob getDeployJob() {
      if (deployJobBuilder_ == null) {
        if (jobTypeCase_ == 4) {
          return (com.google.cloud.deploy.v1.DeployJob) jobType_;
        }
        return com.google.cloud.deploy.v1.DeployJob.getDefaultInstance();
      } else {
        if (jobTypeCase_ == 4) {
          return deployJobBuilder_.getMessage();
        }
        return com.google.cloud.deploy.v1.DeployJob.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A deploy Job.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.DeployJob deploy_job = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDeployJob(com.google.cloud.deploy.v1.DeployJob value) {
      if (deployJobBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        jobType_ = value;
        onChanged();
      } else {
        deployJobBuilder_.setMessage(value);
      }
      jobTypeCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A deploy Job.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.DeployJob deploy_job = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDeployJob(com.google.cloud.deploy.v1.DeployJob.Builder builderForValue) {
      if (deployJobBuilder_ == null) {
        jobType_ = builderForValue.build();
        onChanged();
      } else {
        deployJobBuilder_.setMessage(builderForValue.build());
      }
      jobTypeCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A deploy Job.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.DeployJob deploy_job = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeDeployJob(com.google.cloud.deploy.v1.DeployJob value) {
      if (deployJobBuilder_ == null) {
        if (jobTypeCase_ == 4
            && jobType_ != com.google.cloud.deploy.v1.DeployJob.getDefaultInstance()) {
          jobType_ =
              com.google.cloud.deploy.v1.DeployJob.newBuilder(
                      (com.google.cloud.deploy.v1.DeployJob) jobType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          jobType_ = value;
        }
        onChanged();
      } else {
        if (jobTypeCase_ == 4) {
          deployJobBuilder_.mergeFrom(value);
        } else {
          deployJobBuilder_.setMessage(value);
        }
      }
      jobTypeCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A deploy Job.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.DeployJob deploy_job = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearDeployJob() {
      if (deployJobBuilder_ == null) {
        if (jobTypeCase_ == 4) {
          jobTypeCase_ = 0;
          jobType_ = null;
          onChanged();
        }
      } else {
        if (jobTypeCase_ == 4) {
          jobTypeCase_ = 0;
          jobType_ = null;
        }
        deployJobBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A deploy Job.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.DeployJob deploy_job = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.deploy.v1.DeployJob.Builder getDeployJobBuilder() {
      return getDeployJobFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. A deploy Job.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.DeployJob deploy_job = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.DeployJobOrBuilder getDeployJobOrBuilder() {
      if ((jobTypeCase_ == 4) && (deployJobBuilder_ != null)) {
        return deployJobBuilder_.getMessageOrBuilder();
      } else {
        if (jobTypeCase_ == 4) {
          return (com.google.cloud.deploy.v1.DeployJob) jobType_;
        }
        return com.google.cloud.deploy.v1.DeployJob.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A deploy Job.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.DeployJob deploy_job = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.DeployJob,
            com.google.cloud.deploy.v1.DeployJob.Builder,
            com.google.cloud.deploy.v1.DeployJobOrBuilder>
        getDeployJobFieldBuilder() {
      if (deployJobBuilder_ == null) {
        if (!(jobTypeCase_ == 4)) {
          jobType_ = com.google.cloud.deploy.v1.DeployJob.getDefaultInstance();
        }
        deployJobBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.deploy.v1.DeployJob,
                com.google.cloud.deploy.v1.DeployJob.Builder,
                com.google.cloud.deploy.v1.DeployJobOrBuilder>(
                (com.google.cloud.deploy.v1.DeployJob) jobType_, getParentForChildren(), isClean());
        jobType_ = null;
      }
      jobTypeCase_ = 4;
      onChanged();
      return deployJobBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.VerifyJob,
            com.google.cloud.deploy.v1.VerifyJob.Builder,
            com.google.cloud.deploy.v1.VerifyJobOrBuilder>
        verifyJobBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. A verify Job.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.VerifyJob verify_job = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the verifyJob field is set.
     */
    @java.lang.Override
    public boolean hasVerifyJob() {
      return jobTypeCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * Output only. A verify Job.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.VerifyJob verify_job = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The verifyJob.
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.VerifyJob getVerifyJob() {
      if (verifyJobBuilder_ == null) {
        if (jobTypeCase_ == 5) {
          return (com.google.cloud.deploy.v1.VerifyJob) jobType_;
        }
        return com.google.cloud.deploy.v1.VerifyJob.getDefaultInstance();
      } else {
        if (jobTypeCase_ == 5) {
          return verifyJobBuilder_.getMessage();
        }
        return com.google.cloud.deploy.v1.VerifyJob.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A verify Job.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.VerifyJob verify_job = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setVerifyJob(com.google.cloud.deploy.v1.VerifyJob value) {
      if (verifyJobBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        jobType_ = value;
        onChanged();
      } else {
        verifyJobBuilder_.setMessage(value);
      }
      jobTypeCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A verify Job.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.VerifyJob verify_job = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setVerifyJob(com.google.cloud.deploy.v1.VerifyJob.Builder builderForValue) {
      if (verifyJobBuilder_ == null) {
        jobType_ = builderForValue.build();
        onChanged();
      } else {
        verifyJobBuilder_.setMessage(builderForValue.build());
      }
      jobTypeCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A verify Job.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.VerifyJob verify_job = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeVerifyJob(com.google.cloud.deploy.v1.VerifyJob value) {
      if (verifyJobBuilder_ == null) {
        if (jobTypeCase_ == 5
            && jobType_ != com.google.cloud.deploy.v1.VerifyJob.getDefaultInstance()) {
          jobType_ =
              com.google.cloud.deploy.v1.VerifyJob.newBuilder(
                      (com.google.cloud.deploy.v1.VerifyJob) jobType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          jobType_ = value;
        }
        onChanged();
      } else {
        if (jobTypeCase_ == 5) {
          verifyJobBuilder_.mergeFrom(value);
        } else {
          verifyJobBuilder_.setMessage(value);
        }
      }
      jobTypeCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A verify Job.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.VerifyJob verify_job = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearVerifyJob() {
      if (verifyJobBuilder_ == null) {
        if (jobTypeCase_ == 5) {
          jobTypeCase_ = 0;
          jobType_ = null;
          onChanged();
        }
      } else {
        if (jobTypeCase_ == 5) {
          jobTypeCase_ = 0;
          jobType_ = null;
        }
        verifyJobBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A verify Job.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.VerifyJob verify_job = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.deploy.v1.VerifyJob.Builder getVerifyJobBuilder() {
      return getVerifyJobFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. A verify Job.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.VerifyJob verify_job = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.VerifyJobOrBuilder getVerifyJobOrBuilder() {
      if ((jobTypeCase_ == 5) && (verifyJobBuilder_ != null)) {
        return verifyJobBuilder_.getMessageOrBuilder();
      } else {
        if (jobTypeCase_ == 5) {
          return (com.google.cloud.deploy.v1.VerifyJob) jobType_;
        }
        return com.google.cloud.deploy.v1.VerifyJob.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A verify Job.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.VerifyJob verify_job = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.VerifyJob,
            com.google.cloud.deploy.v1.VerifyJob.Builder,
            com.google.cloud.deploy.v1.VerifyJobOrBuilder>
        getVerifyJobFieldBuilder() {
      if (verifyJobBuilder_ == null) {
        if (!(jobTypeCase_ == 5)) {
          jobType_ = com.google.cloud.deploy.v1.VerifyJob.getDefaultInstance();
        }
        verifyJobBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.deploy.v1.VerifyJob,
                com.google.cloud.deploy.v1.VerifyJob.Builder,
                com.google.cloud.deploy.v1.VerifyJobOrBuilder>(
                (com.google.cloud.deploy.v1.VerifyJob) jobType_, getParentForChildren(), isClean());
        jobType_ = null;
      }
      jobTypeCase_ = 5;
      onChanged();
      return verifyJobBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.PredeployJob,
            com.google.cloud.deploy.v1.PredeployJob.Builder,
            com.google.cloud.deploy.v1.PredeployJobOrBuilder>
        predeployJobBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. A predeploy Job.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.PredeployJob predeploy_job = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the predeployJob field is set.
     */
    @java.lang.Override
    public boolean hasPredeployJob() {
      return jobTypeCase_ == 9;
    }
    /**
     *
     *
     * <pre>
     * Output only. A predeploy Job.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.PredeployJob predeploy_job = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The predeployJob.
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.PredeployJob getPredeployJob() {
      if (predeployJobBuilder_ == null) {
        if (jobTypeCase_ == 9) {
          return (com.google.cloud.deploy.v1.PredeployJob) jobType_;
        }
        return com.google.cloud.deploy.v1.PredeployJob.getDefaultInstance();
      } else {
        if (jobTypeCase_ == 9) {
          return predeployJobBuilder_.getMessage();
        }
        return com.google.cloud.deploy.v1.PredeployJob.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A predeploy Job.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.PredeployJob predeploy_job = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setPredeployJob(com.google.cloud.deploy.v1.PredeployJob value) {
      if (predeployJobBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        jobType_ = value;
        onChanged();
      } else {
        predeployJobBuilder_.setMessage(value);
      }
      jobTypeCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A predeploy Job.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.PredeployJob predeploy_job = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setPredeployJob(
        com.google.cloud.deploy.v1.PredeployJob.Builder builderForValue) {
      if (predeployJobBuilder_ == null) {
        jobType_ = builderForValue.build();
        onChanged();
      } else {
        predeployJobBuilder_.setMessage(builderForValue.build());
      }
      jobTypeCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A predeploy Job.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.PredeployJob predeploy_job = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergePredeployJob(com.google.cloud.deploy.v1.PredeployJob value) {
      if (predeployJobBuilder_ == null) {
        if (jobTypeCase_ == 9
            && jobType_ != com.google.cloud.deploy.v1.PredeployJob.getDefaultInstance()) {
          jobType_ =
              com.google.cloud.deploy.v1.PredeployJob.newBuilder(
                      (com.google.cloud.deploy.v1.PredeployJob) jobType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          jobType_ = value;
        }
        onChanged();
      } else {
        if (jobTypeCase_ == 9) {
          predeployJobBuilder_.mergeFrom(value);
        } else {
          predeployJobBuilder_.setMessage(value);
        }
      }
      jobTypeCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A predeploy Job.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.PredeployJob predeploy_job = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearPredeployJob() {
      if (predeployJobBuilder_ == null) {
        if (jobTypeCase_ == 9) {
          jobTypeCase_ = 0;
          jobType_ = null;
          onChanged();
        }
      } else {
        if (jobTypeCase_ == 9) {
          jobTypeCase_ = 0;
          jobType_ = null;
        }
        predeployJobBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A predeploy Job.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.PredeployJob predeploy_job = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.deploy.v1.PredeployJob.Builder getPredeployJobBuilder() {
      return getPredeployJobFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. A predeploy Job.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.PredeployJob predeploy_job = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.PredeployJobOrBuilder getPredeployJobOrBuilder() {
      if ((jobTypeCase_ == 9) && (predeployJobBuilder_ != null)) {
        return predeployJobBuilder_.getMessageOrBuilder();
      } else {
        if (jobTypeCase_ == 9) {
          return (com.google.cloud.deploy.v1.PredeployJob) jobType_;
        }
        return com.google.cloud.deploy.v1.PredeployJob.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A predeploy Job.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.PredeployJob predeploy_job = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.PredeployJob,
            com.google.cloud.deploy.v1.PredeployJob.Builder,
            com.google.cloud.deploy.v1.PredeployJobOrBuilder>
        getPredeployJobFieldBuilder() {
      if (predeployJobBuilder_ == null) {
        if (!(jobTypeCase_ == 9)) {
          jobType_ = com.google.cloud.deploy.v1.PredeployJob.getDefaultInstance();
        }
        predeployJobBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.deploy.v1.PredeployJob,
                com.google.cloud.deploy.v1.PredeployJob.Builder,
                com.google.cloud.deploy.v1.PredeployJobOrBuilder>(
                (com.google.cloud.deploy.v1.PredeployJob) jobType_,
                getParentForChildren(),
                isClean());
        jobType_ = null;
      }
      jobTypeCase_ = 9;
      onChanged();
      return predeployJobBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.PostdeployJob,
            com.google.cloud.deploy.v1.PostdeployJob.Builder,
            com.google.cloud.deploy.v1.PostdeployJobOrBuilder>
        postdeployJobBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. A postdeploy Job.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.PostdeployJob postdeploy_job = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the postdeployJob field is set.
     */
    @java.lang.Override
    public boolean hasPostdeployJob() {
      return jobTypeCase_ == 10;
    }
    /**
     *
     *
     * <pre>
     * Output only. A postdeploy Job.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.PostdeployJob postdeploy_job = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The postdeployJob.
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.PostdeployJob getPostdeployJob() {
      if (postdeployJobBuilder_ == null) {
        if (jobTypeCase_ == 10) {
          return (com.google.cloud.deploy.v1.PostdeployJob) jobType_;
        }
        return com.google.cloud.deploy.v1.PostdeployJob.getDefaultInstance();
      } else {
        if (jobTypeCase_ == 10) {
          return postdeployJobBuilder_.getMessage();
        }
        return com.google.cloud.deploy.v1.PostdeployJob.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A postdeploy Job.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.PostdeployJob postdeploy_job = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setPostdeployJob(com.google.cloud.deploy.v1.PostdeployJob value) {
      if (postdeployJobBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        jobType_ = value;
        onChanged();
      } else {
        postdeployJobBuilder_.setMessage(value);
      }
      jobTypeCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A postdeploy Job.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.PostdeployJob postdeploy_job = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setPostdeployJob(
        com.google.cloud.deploy.v1.PostdeployJob.Builder builderForValue) {
      if (postdeployJobBuilder_ == null) {
        jobType_ = builderForValue.build();
        onChanged();
      } else {
        postdeployJobBuilder_.setMessage(builderForValue.build());
      }
      jobTypeCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A postdeploy Job.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.PostdeployJob postdeploy_job = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergePostdeployJob(com.google.cloud.deploy.v1.PostdeployJob value) {
      if (postdeployJobBuilder_ == null) {
        if (jobTypeCase_ == 10
            && jobType_ != com.google.cloud.deploy.v1.PostdeployJob.getDefaultInstance()) {
          jobType_ =
              com.google.cloud.deploy.v1.PostdeployJob.newBuilder(
                      (com.google.cloud.deploy.v1.PostdeployJob) jobType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          jobType_ = value;
        }
        onChanged();
      } else {
        if (jobTypeCase_ == 10) {
          postdeployJobBuilder_.mergeFrom(value);
        } else {
          postdeployJobBuilder_.setMessage(value);
        }
      }
      jobTypeCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A postdeploy Job.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.PostdeployJob postdeploy_job = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearPostdeployJob() {
      if (postdeployJobBuilder_ == null) {
        if (jobTypeCase_ == 10) {
          jobTypeCase_ = 0;
          jobType_ = null;
          onChanged();
        }
      } else {
        if (jobTypeCase_ == 10) {
          jobTypeCase_ = 0;
          jobType_ = null;
        }
        postdeployJobBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A postdeploy Job.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.PostdeployJob postdeploy_job = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.deploy.v1.PostdeployJob.Builder getPostdeployJobBuilder() {
      return getPostdeployJobFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. A postdeploy Job.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.PostdeployJob postdeploy_job = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.PostdeployJobOrBuilder getPostdeployJobOrBuilder() {
      if ((jobTypeCase_ == 10) && (postdeployJobBuilder_ != null)) {
        return postdeployJobBuilder_.getMessageOrBuilder();
      } else {
        if (jobTypeCase_ == 10) {
          return (com.google.cloud.deploy.v1.PostdeployJob) jobType_;
        }
        return com.google.cloud.deploy.v1.PostdeployJob.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A postdeploy Job.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.PostdeployJob postdeploy_job = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.PostdeployJob,
            com.google.cloud.deploy.v1.PostdeployJob.Builder,
            com.google.cloud.deploy.v1.PostdeployJobOrBuilder>
        getPostdeployJobFieldBuilder() {
      if (postdeployJobBuilder_ == null) {
        if (!(jobTypeCase_ == 10)) {
          jobType_ = com.google.cloud.deploy.v1.PostdeployJob.getDefaultInstance();
        }
        postdeployJobBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.deploy.v1.PostdeployJob,
                com.google.cloud.deploy.v1.PostdeployJob.Builder,
                com.google.cloud.deploy.v1.PostdeployJobOrBuilder>(
                (com.google.cloud.deploy.v1.PostdeployJob) jobType_,
                getParentForChildren(),
                isClean());
        jobType_ = null;
      }
      jobTypeCase_ = 10;
      onChanged();
      return postdeployJobBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.CreateChildRolloutJob,
            com.google.cloud.deploy.v1.CreateChildRolloutJob.Builder,
            com.google.cloud.deploy.v1.CreateChildRolloutJobOrBuilder>
        createChildRolloutJobBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. A createChildRollout Job.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.CreateChildRolloutJob create_child_rollout_job = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createChildRolloutJob field is set.
     */
    @java.lang.Override
    public boolean hasCreateChildRolloutJob() {
      return jobTypeCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * Output only. A createChildRollout Job.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.CreateChildRolloutJob create_child_rollout_job = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createChildRolloutJob.
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.CreateChildRolloutJob getCreateChildRolloutJob() {
      if (createChildRolloutJobBuilder_ == null) {
        if (jobTypeCase_ == 6) {
          return (com.google.cloud.deploy.v1.CreateChildRolloutJob) jobType_;
        }
        return com.google.cloud.deploy.v1.CreateChildRolloutJob.getDefaultInstance();
      } else {
        if (jobTypeCase_ == 6) {
          return createChildRolloutJobBuilder_.getMessage();
        }
        return com.google.cloud.deploy.v1.CreateChildRolloutJob.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A createChildRollout Job.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.CreateChildRolloutJob create_child_rollout_job = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateChildRolloutJob(
        com.google.cloud.deploy.v1.CreateChildRolloutJob value) {
      if (createChildRolloutJobBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        jobType_ = value;
        onChanged();
      } else {
        createChildRolloutJobBuilder_.setMessage(value);
      }
      jobTypeCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A createChildRollout Job.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.CreateChildRolloutJob create_child_rollout_job = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateChildRolloutJob(
        com.google.cloud.deploy.v1.CreateChildRolloutJob.Builder builderForValue) {
      if (createChildRolloutJobBuilder_ == null) {
        jobType_ = builderForValue.build();
        onChanged();
      } else {
        createChildRolloutJobBuilder_.setMessage(builderForValue.build());
      }
      jobTypeCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A createChildRollout Job.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.CreateChildRolloutJob create_child_rollout_job = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateChildRolloutJob(
        com.google.cloud.deploy.v1.CreateChildRolloutJob value) {
      if (createChildRolloutJobBuilder_ == null) {
        if (jobTypeCase_ == 6
            && jobType_ != com.google.cloud.deploy.v1.CreateChildRolloutJob.getDefaultInstance()) {
          jobType_ =
              com.google.cloud.deploy.v1.CreateChildRolloutJob.newBuilder(
                      (com.google.cloud.deploy.v1.CreateChildRolloutJob) jobType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          jobType_ = value;
        }
        onChanged();
      } else {
        if (jobTypeCase_ == 6) {
          createChildRolloutJobBuilder_.mergeFrom(value);
        } else {
          createChildRolloutJobBuilder_.setMessage(value);
        }
      }
      jobTypeCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A createChildRollout Job.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.CreateChildRolloutJob create_child_rollout_job = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateChildRolloutJob() {
      if (createChildRolloutJobBuilder_ == null) {
        if (jobTypeCase_ == 6) {
          jobTypeCase_ = 0;
          jobType_ = null;
          onChanged();
        }
      } else {
        if (jobTypeCase_ == 6) {
          jobTypeCase_ = 0;
          jobType_ = null;
        }
        createChildRolloutJobBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A createChildRollout Job.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.CreateChildRolloutJob create_child_rollout_job = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.deploy.v1.CreateChildRolloutJob.Builder
        getCreateChildRolloutJobBuilder() {
      return getCreateChildRolloutJobFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. A createChildRollout Job.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.CreateChildRolloutJob create_child_rollout_job = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.CreateChildRolloutJobOrBuilder
        getCreateChildRolloutJobOrBuilder() {
      if ((jobTypeCase_ == 6) && (createChildRolloutJobBuilder_ != null)) {
        return createChildRolloutJobBuilder_.getMessageOrBuilder();
      } else {
        if (jobTypeCase_ == 6) {
          return (com.google.cloud.deploy.v1.CreateChildRolloutJob) jobType_;
        }
        return com.google.cloud.deploy.v1.CreateChildRolloutJob.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A createChildRollout Job.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.CreateChildRolloutJob create_child_rollout_job = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.CreateChildRolloutJob,
            com.google.cloud.deploy.v1.CreateChildRolloutJob.Builder,
            com.google.cloud.deploy.v1.CreateChildRolloutJobOrBuilder>
        getCreateChildRolloutJobFieldBuilder() {
      if (createChildRolloutJobBuilder_ == null) {
        if (!(jobTypeCase_ == 6)) {
          jobType_ = com.google.cloud.deploy.v1.CreateChildRolloutJob.getDefaultInstance();
        }
        createChildRolloutJobBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.deploy.v1.CreateChildRolloutJob,
                com.google.cloud.deploy.v1.CreateChildRolloutJob.Builder,
                com.google.cloud.deploy.v1.CreateChildRolloutJobOrBuilder>(
                (com.google.cloud.deploy.v1.CreateChildRolloutJob) jobType_,
                getParentForChildren(),
                isClean());
        jobType_ = null;
      }
      jobTypeCase_ = 6;
      onChanged();
      return createChildRolloutJobBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.AdvanceChildRolloutJob,
            com.google.cloud.deploy.v1.AdvanceChildRolloutJob.Builder,
            com.google.cloud.deploy.v1.AdvanceChildRolloutJobOrBuilder>
        advanceChildRolloutJobBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. An advanceChildRollout Job.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AdvanceChildRolloutJob advance_child_rollout_job = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the advanceChildRolloutJob field is set.
     */
    @java.lang.Override
    public boolean hasAdvanceChildRolloutJob() {
      return jobTypeCase_ == 7;
    }
    /**
     *
     *
     * <pre>
     * Output only. An advanceChildRollout Job.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AdvanceChildRolloutJob advance_child_rollout_job = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The advanceChildRolloutJob.
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.AdvanceChildRolloutJob getAdvanceChildRolloutJob() {
      if (advanceChildRolloutJobBuilder_ == null) {
        if (jobTypeCase_ == 7) {
          return (com.google.cloud.deploy.v1.AdvanceChildRolloutJob) jobType_;
        }
        return com.google.cloud.deploy.v1.AdvanceChildRolloutJob.getDefaultInstance();
      } else {
        if (jobTypeCase_ == 7) {
          return advanceChildRolloutJobBuilder_.getMessage();
        }
        return com.google.cloud.deploy.v1.AdvanceChildRolloutJob.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. An advanceChildRollout Job.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AdvanceChildRolloutJob advance_child_rollout_job = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setAdvanceChildRolloutJob(
        com.google.cloud.deploy.v1.AdvanceChildRolloutJob value) {
      if (advanceChildRolloutJobBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        jobType_ = value;
        onChanged();
      } else {
        advanceChildRolloutJobBuilder_.setMessage(value);
      }
      jobTypeCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. An advanceChildRollout Job.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AdvanceChildRolloutJob advance_child_rollout_job = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setAdvanceChildRolloutJob(
        com.google.cloud.deploy.v1.AdvanceChildRolloutJob.Builder builderForValue) {
      if (advanceChildRolloutJobBuilder_ == null) {
        jobType_ = builderForValue.build();
        onChanged();
      } else {
        advanceChildRolloutJobBuilder_.setMessage(builderForValue.build());
      }
      jobTypeCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. An advanceChildRollout Job.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AdvanceChildRolloutJob advance_child_rollout_job = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeAdvanceChildRolloutJob(
        com.google.cloud.deploy.v1.AdvanceChildRolloutJob value) {
      if (advanceChildRolloutJobBuilder_ == null) {
        if (jobTypeCase_ == 7
            && jobType_ != com.google.cloud.deploy.v1.AdvanceChildRolloutJob.getDefaultInstance()) {
          jobType_ =
              com.google.cloud.deploy.v1.AdvanceChildRolloutJob.newBuilder(
                      (com.google.cloud.deploy.v1.AdvanceChildRolloutJob) jobType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          jobType_ = value;
        }
        onChanged();
      } else {
        if (jobTypeCase_ == 7) {
          advanceChildRolloutJobBuilder_.mergeFrom(value);
        } else {
          advanceChildRolloutJobBuilder_.setMessage(value);
        }
      }
      jobTypeCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. An advanceChildRollout Job.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AdvanceChildRolloutJob advance_child_rollout_job = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearAdvanceChildRolloutJob() {
      if (advanceChildRolloutJobBuilder_ == null) {
        if (jobTypeCase_ == 7) {
          jobTypeCase_ = 0;
          jobType_ = null;
          onChanged();
        }
      } else {
        if (jobTypeCase_ == 7) {
          jobTypeCase_ = 0;
          jobType_ = null;
        }
        advanceChildRolloutJobBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. An advanceChildRollout Job.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AdvanceChildRolloutJob advance_child_rollout_job = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.deploy.v1.AdvanceChildRolloutJob.Builder
        getAdvanceChildRolloutJobBuilder() {
      return getAdvanceChildRolloutJobFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. An advanceChildRollout Job.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AdvanceChildRolloutJob advance_child_rollout_job = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.AdvanceChildRolloutJobOrBuilder
        getAdvanceChildRolloutJobOrBuilder() {
      if ((jobTypeCase_ == 7) && (advanceChildRolloutJobBuilder_ != null)) {
        return advanceChildRolloutJobBuilder_.getMessageOrBuilder();
      } else {
        if (jobTypeCase_ == 7) {
          return (com.google.cloud.deploy.v1.AdvanceChildRolloutJob) jobType_;
        }
        return com.google.cloud.deploy.v1.AdvanceChildRolloutJob.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. An advanceChildRollout Job.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AdvanceChildRolloutJob advance_child_rollout_job = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.AdvanceChildRolloutJob,
            com.google.cloud.deploy.v1.AdvanceChildRolloutJob.Builder,
            com.google.cloud.deploy.v1.AdvanceChildRolloutJobOrBuilder>
        getAdvanceChildRolloutJobFieldBuilder() {
      if (advanceChildRolloutJobBuilder_ == null) {
        if (!(jobTypeCase_ == 7)) {
          jobType_ = com.google.cloud.deploy.v1.AdvanceChildRolloutJob.getDefaultInstance();
        }
        advanceChildRolloutJobBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.deploy.v1.AdvanceChildRolloutJob,
                com.google.cloud.deploy.v1.AdvanceChildRolloutJob.Builder,
                com.google.cloud.deploy.v1.AdvanceChildRolloutJobOrBuilder>(
                (com.google.cloud.deploy.v1.AdvanceChildRolloutJob) jobType_,
                getParentForChildren(),
                isClean());
        jobType_ = null;
      }
      jobTypeCase_ = 7;
      onChanged();
      return advanceChildRolloutJobBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.deploy.v1.Job)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.deploy.v1.Job)
  private static final com.google.cloud.deploy.v1.Job DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.deploy.v1.Job();
  }

  public static com.google.cloud.deploy.v1.Job getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Job> PARSER =
      new com.google.protobuf.AbstractParser<Job>() {
        @java.lang.Override
        public Job parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Job> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Job> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.deploy.v1.Job getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
