/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/deploy/v1/cloud_deploy.proto

package com.google.cloud.deploy.v1;

/**
 *
 *
 * <pre>
 * The response object from `ListAutomationRuns`.
 * </pre>
 *
 * Protobuf type {@code google.cloud.deploy.v1.ListAutomationRunsResponse}
 */
public final class ListAutomationRunsResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.deploy.v1.ListAutomationRunsResponse)
    ListAutomationRunsResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ListAutomationRunsResponse.newBuilder() to construct.
  private ListAutomationRunsResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ListAutomationRunsResponse() {
    automationRuns_ = java.util.Collections.emptyList();
    nextPageToken_ = "";
    unreachable_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ListAutomationRunsResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.deploy.v1.CloudDeployProto
        .internal_static_google_cloud_deploy_v1_ListAutomationRunsResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.deploy.v1.CloudDeployProto
        .internal_static_google_cloud_deploy_v1_ListAutomationRunsResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.deploy.v1.ListAutomationRunsResponse.class,
            com.google.cloud.deploy.v1.ListAutomationRunsResponse.Builder.class);
  }

  public static final int AUTOMATION_RUNS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.deploy.v1.AutomationRun> automationRuns_;
  /**
   *
   *
   * <pre>
   * The `AutomationRuns` objects.
   * </pre>
   *
   * <code>repeated .google.cloud.deploy.v1.AutomationRun automation_runs = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.deploy.v1.AutomationRun> getAutomationRunsList() {
    return automationRuns_;
  }
  /**
   *
   *
   * <pre>
   * The `AutomationRuns` objects.
   * </pre>
   *
   * <code>repeated .google.cloud.deploy.v1.AutomationRun automation_runs = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.deploy.v1.AutomationRunOrBuilder>
      getAutomationRunsOrBuilderList() {
    return automationRuns_;
  }
  /**
   *
   *
   * <pre>
   * The `AutomationRuns` objects.
   * </pre>
   *
   * <code>repeated .google.cloud.deploy.v1.AutomationRun automation_runs = 1;</code>
   */
  @java.lang.Override
  public int getAutomationRunsCount() {
    return automationRuns_.size();
  }
  /**
   *
   *
   * <pre>
   * The `AutomationRuns` objects.
   * </pre>
   *
   * <code>repeated .google.cloud.deploy.v1.AutomationRun automation_runs = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.AutomationRun getAutomationRuns(int index) {
    return automationRuns_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The `AutomationRuns` objects.
   * </pre>
   *
   * <code>repeated .google.cloud.deploy.v1.AutomationRun automation_runs = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.AutomationRunOrBuilder getAutomationRunsOrBuilder(int index) {
    return automationRuns_.get(index);
  }

  public static final int NEXT_PAGE_TOKEN_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object nextPageToken_ = "";
  /**
   *
   *
   * <pre>
   * A token, which can be sent as `page_token` to retrieve the next page.
   * If this field is omitted, there are no subsequent pages.
   * </pre>
   *
   * <code>string next_page_token = 2;</code>
   *
   * @return The nextPageToken.
   */
  @java.lang.Override
  public java.lang.String getNextPageToken() {
    java.lang.Object ref = nextPageToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      nextPageToken_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A token, which can be sent as `page_token` to retrieve the next page.
   * If this field is omitted, there are no subsequent pages.
   * </pre>
   *
   * <code>string next_page_token = 2;</code>
   *
   * @return The bytes for nextPageToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNextPageTokenBytes() {
    java.lang.Object ref = nextPageToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      nextPageToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int UNREACHABLE_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList unreachable_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Locations that could not be reached.
   * </pre>
   *
   * <code>repeated string unreachable = 3;</code>
   *
   * @return A list containing the unreachable.
   */
  public com.google.protobuf.ProtocolStringList getUnreachableList() {
    return unreachable_;
  }
  /**
   *
   *
   * <pre>
   * Locations that could not be reached.
   * </pre>
   *
   * <code>repeated string unreachable = 3;</code>
   *
   * @return The count of unreachable.
   */
  public int getUnreachableCount() {
    return unreachable_.size();
  }
  /**
   *
   *
   * <pre>
   * Locations that could not be reached.
   * </pre>
   *
   * <code>repeated string unreachable = 3;</code>
   *
   * @param index The index of the element to return.
   * @return The unreachable at the given index.
   */
  public java.lang.String getUnreachable(int index) {
    return unreachable_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Locations that could not be reached.
   * </pre>
   *
   * <code>repeated string unreachable = 3;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the unreachable at the given index.
   */
  public com.google.protobuf.ByteString getUnreachableBytes(int index) {
    return unreachable_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < automationRuns_.size(); i++) {
      output.writeMessage(1, automationRuns_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, nextPageToken_);
    }
    for (int i = 0; i < unreachable_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, unreachable_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < automationRuns_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, automationRuns_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, nextPageToken_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < unreachable_.size(); i++) {
        dataSize += computeStringSizeNoTag(unreachable_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getUnreachableList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.deploy.v1.ListAutomationRunsResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.deploy.v1.ListAutomationRunsResponse other =
        (com.google.cloud.deploy.v1.ListAutomationRunsResponse) obj;

    if (!getAutomationRunsList().equals(other.getAutomationRunsList())) return false;
    if (!getNextPageToken().equals(other.getNextPageToken())) return false;
    if (!getUnreachableList().equals(other.getUnreachableList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getAutomationRunsCount() > 0) {
      hash = (37 * hash) + AUTOMATION_RUNS_FIELD_NUMBER;
      hash = (53 * hash) + getAutomationRunsList().hashCode();
    }
    hash = (37 * hash) + NEXT_PAGE_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getNextPageToken().hashCode();
    if (getUnreachableCount() > 0) {
      hash = (37 * hash) + UNREACHABLE_FIELD_NUMBER;
      hash = (53 * hash) + getUnreachableList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.deploy.v1.ListAutomationRunsResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.ListAutomationRunsResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.ListAutomationRunsResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.ListAutomationRunsResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.ListAutomationRunsResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.ListAutomationRunsResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.ListAutomationRunsResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.ListAutomationRunsResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.ListAutomationRunsResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.ListAutomationRunsResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.ListAutomationRunsResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.ListAutomationRunsResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.deploy.v1.ListAutomationRunsResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The response object from `ListAutomationRuns`.
   * </pre>
   *
   * Protobuf type {@code google.cloud.deploy.v1.ListAutomationRunsResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.deploy.v1.ListAutomationRunsResponse)
      com.google.cloud.deploy.v1.ListAutomationRunsResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_ListAutomationRunsResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_ListAutomationRunsResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.deploy.v1.ListAutomationRunsResponse.class,
              com.google.cloud.deploy.v1.ListAutomationRunsResponse.Builder.class);
    }

    // Construct using com.google.cloud.deploy.v1.ListAutomationRunsResponse.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (automationRunsBuilder_ == null) {
        automationRuns_ = java.util.Collections.emptyList();
      } else {
        automationRuns_ = null;
        automationRunsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      nextPageToken_ = "";
      unreachable_ = com.google.protobuf.LazyStringArrayList.emptyList();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_ListAutomationRunsResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.ListAutomationRunsResponse getDefaultInstanceForType() {
      return com.google.cloud.deploy.v1.ListAutomationRunsResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.ListAutomationRunsResponse build() {
      com.google.cloud.deploy.v1.ListAutomationRunsResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.ListAutomationRunsResponse buildPartial() {
      com.google.cloud.deploy.v1.ListAutomationRunsResponse result =
          new com.google.cloud.deploy.v1.ListAutomationRunsResponse(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.deploy.v1.ListAutomationRunsResponse result) {
      if (automationRunsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          automationRuns_ = java.util.Collections.unmodifiableList(automationRuns_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.automationRuns_ = automationRuns_;
      } else {
        result.automationRuns_ = automationRunsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.deploy.v1.ListAutomationRunsResponse result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.nextPageToken_ = nextPageToken_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        unreachable_.makeImmutable();
        result.unreachable_ = unreachable_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.deploy.v1.ListAutomationRunsResponse) {
        return mergeFrom((com.google.cloud.deploy.v1.ListAutomationRunsResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.deploy.v1.ListAutomationRunsResponse other) {
      if (other == com.google.cloud.deploy.v1.ListAutomationRunsResponse.getDefaultInstance())
        return this;
      if (automationRunsBuilder_ == null) {
        if (!other.automationRuns_.isEmpty()) {
          if (automationRuns_.isEmpty()) {
            automationRuns_ = other.automationRuns_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureAutomationRunsIsMutable();
            automationRuns_.addAll(other.automationRuns_);
          }
          onChanged();
        }
      } else {
        if (!other.automationRuns_.isEmpty()) {
          if (automationRunsBuilder_.isEmpty()) {
            automationRunsBuilder_.dispose();
            automationRunsBuilder_ = null;
            automationRuns_ = other.automationRuns_;
            bitField0_ = (bitField0_ & ~0x00000001);
            automationRunsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getAutomationRunsFieldBuilder()
                    : null;
          } else {
            automationRunsBuilder_.addAllMessages(other.automationRuns_);
          }
        }
      }
      if (!other.getNextPageToken().isEmpty()) {
        nextPageToken_ = other.nextPageToken_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.unreachable_.isEmpty()) {
        if (unreachable_.isEmpty()) {
          unreachable_ = other.unreachable_;
          bitField0_ |= 0x00000004;
        } else {
          ensureUnreachableIsMutable();
          unreachable_.addAll(other.unreachable_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.deploy.v1.AutomationRun m =
                    input.readMessage(
                        com.google.cloud.deploy.v1.AutomationRun.parser(), extensionRegistry);
                if (automationRunsBuilder_ == null) {
                  ensureAutomationRunsIsMutable();
                  automationRuns_.add(m);
                } else {
                  automationRunsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                nextPageToken_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureUnreachableIsMutable();
                unreachable_.add(s);
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.deploy.v1.AutomationRun> automationRuns_ =
        java.util.Collections.emptyList();

    private void ensureAutomationRunsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        automationRuns_ =
            new java.util.ArrayList<com.google.cloud.deploy.v1.AutomationRun>(automationRuns_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.deploy.v1.AutomationRun,
            com.google.cloud.deploy.v1.AutomationRun.Builder,
            com.google.cloud.deploy.v1.AutomationRunOrBuilder>
        automationRunsBuilder_;

    /**
     *
     *
     * <pre>
     * The `AutomationRuns` objects.
     * </pre>
     *
     * <code>repeated .google.cloud.deploy.v1.AutomationRun automation_runs = 1;</code>
     */
    public java.util.List<com.google.cloud.deploy.v1.AutomationRun> getAutomationRunsList() {
      if (automationRunsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(automationRuns_);
      } else {
        return automationRunsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The `AutomationRuns` objects.
     * </pre>
     *
     * <code>repeated .google.cloud.deploy.v1.AutomationRun automation_runs = 1;</code>
     */
    public int getAutomationRunsCount() {
      if (automationRunsBuilder_ == null) {
        return automationRuns_.size();
      } else {
        return automationRunsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The `AutomationRuns` objects.
     * </pre>
     *
     * <code>repeated .google.cloud.deploy.v1.AutomationRun automation_runs = 1;</code>
     */
    public com.google.cloud.deploy.v1.AutomationRun getAutomationRuns(int index) {
      if (automationRunsBuilder_ == null) {
        return automationRuns_.get(index);
      } else {
        return automationRunsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The `AutomationRuns` objects.
     * </pre>
     *
     * <code>repeated .google.cloud.deploy.v1.AutomationRun automation_runs = 1;</code>
     */
    public Builder setAutomationRuns(int index, com.google.cloud.deploy.v1.AutomationRun value) {
      if (automationRunsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAutomationRunsIsMutable();
        automationRuns_.set(index, value);
        onChanged();
      } else {
        automationRunsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The `AutomationRuns` objects.
     * </pre>
     *
     * <code>repeated .google.cloud.deploy.v1.AutomationRun automation_runs = 1;</code>
     */
    public Builder setAutomationRuns(
        int index, com.google.cloud.deploy.v1.AutomationRun.Builder builderForValue) {
      if (automationRunsBuilder_ == null) {
        ensureAutomationRunsIsMutable();
        automationRuns_.set(index, builderForValue.build());
        onChanged();
      } else {
        automationRunsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The `AutomationRuns` objects.
     * </pre>
     *
     * <code>repeated .google.cloud.deploy.v1.AutomationRun automation_runs = 1;</code>
     */
    public Builder addAutomationRuns(com.google.cloud.deploy.v1.AutomationRun value) {
      if (automationRunsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAutomationRunsIsMutable();
        automationRuns_.add(value);
        onChanged();
      } else {
        automationRunsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The `AutomationRuns` objects.
     * </pre>
     *
     * <code>repeated .google.cloud.deploy.v1.AutomationRun automation_runs = 1;</code>
     */
    public Builder addAutomationRuns(int index, com.google.cloud.deploy.v1.AutomationRun value) {
      if (automationRunsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAutomationRunsIsMutable();
        automationRuns_.add(index, value);
        onChanged();
      } else {
        automationRunsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The `AutomationRuns` objects.
     * </pre>
     *
     * <code>repeated .google.cloud.deploy.v1.AutomationRun automation_runs = 1;</code>
     */
    public Builder addAutomationRuns(
        com.google.cloud.deploy.v1.AutomationRun.Builder builderForValue) {
      if (automationRunsBuilder_ == null) {
        ensureAutomationRunsIsMutable();
        automationRuns_.add(builderForValue.build());
        onChanged();
      } else {
        automationRunsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The `AutomationRuns` objects.
     * </pre>
     *
     * <code>repeated .google.cloud.deploy.v1.AutomationRun automation_runs = 1;</code>
     */
    public Builder addAutomationRuns(
        int index, com.google.cloud.deploy.v1.AutomationRun.Builder builderForValue) {
      if (automationRunsBuilder_ == null) {
        ensureAutomationRunsIsMutable();
        automationRuns_.add(index, builderForValue.build());
        onChanged();
      } else {
        automationRunsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The `AutomationRuns` objects.
     * </pre>
     *
     * <code>repeated .google.cloud.deploy.v1.AutomationRun automation_runs = 1;</code>
     */
    public Builder addAllAutomationRuns(
        java.lang.Iterable<? extends com.google.cloud.deploy.v1.AutomationRun> values) {
      if (automationRunsBuilder_ == null) {
        ensureAutomationRunsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, automationRuns_);
        onChanged();
      } else {
        automationRunsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The `AutomationRuns` objects.
     * </pre>
     *
     * <code>repeated .google.cloud.deploy.v1.AutomationRun automation_runs = 1;</code>
     */
    public Builder clearAutomationRuns() {
      if (automationRunsBuilder_ == null) {
        automationRuns_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        automationRunsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The `AutomationRuns` objects.
     * </pre>
     *
     * <code>repeated .google.cloud.deploy.v1.AutomationRun automation_runs = 1;</code>
     */
    public Builder removeAutomationRuns(int index) {
      if (automationRunsBuilder_ == null) {
        ensureAutomationRunsIsMutable();
        automationRuns_.remove(index);
        onChanged();
      } else {
        automationRunsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The `AutomationRuns` objects.
     * </pre>
     *
     * <code>repeated .google.cloud.deploy.v1.AutomationRun automation_runs = 1;</code>
     */
    public com.google.cloud.deploy.v1.AutomationRun.Builder getAutomationRunsBuilder(int index) {
      return getAutomationRunsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The `AutomationRuns` objects.
     * </pre>
     *
     * <code>repeated .google.cloud.deploy.v1.AutomationRun automation_runs = 1;</code>
     */
    public com.google.cloud.deploy.v1.AutomationRunOrBuilder getAutomationRunsOrBuilder(int index) {
      if (automationRunsBuilder_ == null) {
        return automationRuns_.get(index);
      } else {
        return automationRunsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The `AutomationRuns` objects.
     * </pre>
     *
     * <code>repeated .google.cloud.deploy.v1.AutomationRun automation_runs = 1;</code>
     */
    public java.util.List<? extends com.google.cloud.deploy.v1.AutomationRunOrBuilder>
        getAutomationRunsOrBuilderList() {
      if (automationRunsBuilder_ != null) {
        return automationRunsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(automationRuns_);
      }
    }
    /**
     *
     *
     * <pre>
     * The `AutomationRuns` objects.
     * </pre>
     *
     * <code>repeated .google.cloud.deploy.v1.AutomationRun automation_runs = 1;</code>
     */
    public com.google.cloud.deploy.v1.AutomationRun.Builder addAutomationRunsBuilder() {
      return getAutomationRunsFieldBuilder()
          .addBuilder(com.google.cloud.deploy.v1.AutomationRun.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The `AutomationRuns` objects.
     * </pre>
     *
     * <code>repeated .google.cloud.deploy.v1.AutomationRun automation_runs = 1;</code>
     */
    public com.google.cloud.deploy.v1.AutomationRun.Builder addAutomationRunsBuilder(int index) {
      return getAutomationRunsFieldBuilder()
          .addBuilder(index, com.google.cloud.deploy.v1.AutomationRun.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The `AutomationRuns` objects.
     * </pre>
     *
     * <code>repeated .google.cloud.deploy.v1.AutomationRun automation_runs = 1;</code>
     */
    public java.util.List<com.google.cloud.deploy.v1.AutomationRun.Builder>
        getAutomationRunsBuilderList() {
      return getAutomationRunsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.deploy.v1.AutomationRun,
            com.google.cloud.deploy.v1.AutomationRun.Builder,
            com.google.cloud.deploy.v1.AutomationRunOrBuilder>
        getAutomationRunsFieldBuilder() {
      if (automationRunsBuilder_ == null) {
        automationRunsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.deploy.v1.AutomationRun,
                com.google.cloud.deploy.v1.AutomationRun.Builder,
                com.google.cloud.deploy.v1.AutomationRunOrBuilder>(
                automationRuns_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        automationRuns_ = null;
      }
      return automationRunsBuilder_;
    }

    private java.lang.Object nextPageToken_ = "";
    /**
     *
     *
     * <pre>
     * A token, which can be sent as `page_token` to retrieve the next page.
     * If this field is omitted, there are no subsequent pages.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return The nextPageToken.
     */
    public java.lang.String getNextPageToken() {
      java.lang.Object ref = nextPageToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        nextPageToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A token, which can be sent as `page_token` to retrieve the next page.
     * If this field is omitted, there are no subsequent pages.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return The bytes for nextPageToken.
     */
    public com.google.protobuf.ByteString getNextPageTokenBytes() {
      java.lang.Object ref = nextPageToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        nextPageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A token, which can be sent as `page_token` to retrieve the next page.
     * If this field is omitted, there are no subsequent pages.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @param value The nextPageToken to set.
     * @return This builder for chaining.
     */
    public Builder setNextPageToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      nextPageToken_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A token, which can be sent as `page_token` to retrieve the next page.
     * If this field is omitted, there are no subsequent pages.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNextPageToken() {
      nextPageToken_ = getDefaultInstance().getNextPageToken();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A token, which can be sent as `page_token` to retrieve the next page.
     * If this field is omitted, there are no subsequent pages.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @param value The bytes for nextPageToken to set.
     * @return This builder for chaining.
     */
    public Builder setNextPageTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      nextPageToken_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList unreachable_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureUnreachableIsMutable() {
      if (!unreachable_.isModifiable()) {
        unreachable_ = new com.google.protobuf.LazyStringArrayList(unreachable_);
      }
      bitField0_ |= 0x00000004;
    }
    /**
     *
     *
     * <pre>
     * Locations that could not be reached.
     * </pre>
     *
     * <code>repeated string unreachable = 3;</code>
     *
     * @return A list containing the unreachable.
     */
    public com.google.protobuf.ProtocolStringList getUnreachableList() {
      unreachable_.makeImmutable();
      return unreachable_;
    }
    /**
     *
     *
     * <pre>
     * Locations that could not be reached.
     * </pre>
     *
     * <code>repeated string unreachable = 3;</code>
     *
     * @return The count of unreachable.
     */
    public int getUnreachableCount() {
      return unreachable_.size();
    }
    /**
     *
     *
     * <pre>
     * Locations that could not be reached.
     * </pre>
     *
     * <code>repeated string unreachable = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The unreachable at the given index.
     */
    public java.lang.String getUnreachable(int index) {
      return unreachable_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Locations that could not be reached.
     * </pre>
     *
     * <code>repeated string unreachable = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the unreachable at the given index.
     */
    public com.google.protobuf.ByteString getUnreachableBytes(int index) {
      return unreachable_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Locations that could not be reached.
     * </pre>
     *
     * <code>repeated string unreachable = 3;</code>
     *
     * @param index The index to set the value at.
     * @param value The unreachable to set.
     * @return This builder for chaining.
     */
    public Builder setUnreachable(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureUnreachableIsMutable();
      unreachable_.set(index, value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Locations that could not be reached.
     * </pre>
     *
     * <code>repeated string unreachable = 3;</code>
     *
     * @param value The unreachable to add.
     * @return This builder for chaining.
     */
    public Builder addUnreachable(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureUnreachableIsMutable();
      unreachable_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Locations that could not be reached.
     * </pre>
     *
     * <code>repeated string unreachable = 3;</code>
     *
     * @param values The unreachable to add.
     * @return This builder for chaining.
     */
    public Builder addAllUnreachable(java.lang.Iterable<java.lang.String> values) {
      ensureUnreachableIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, unreachable_);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Locations that could not be reached.
     * </pre>
     *
     * <code>repeated string unreachable = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUnreachable() {
      unreachable_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Locations that could not be reached.
     * </pre>
     *
     * <code>repeated string unreachable = 3;</code>
     *
     * @param value The bytes of the unreachable to add.
     * @return This builder for chaining.
     */
    public Builder addUnreachableBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureUnreachableIsMutable();
      unreachable_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.deploy.v1.ListAutomationRunsResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.deploy.v1.ListAutomationRunsResponse)
  private static final com.google.cloud.deploy.v1.ListAutomationRunsResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.deploy.v1.ListAutomationRunsResponse();
  }

  public static com.google.cloud.deploy.v1.ListAutomationRunsResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ListAutomationRunsResponse> PARSER =
      new com.google.protobuf.AbstractParser<ListAutomationRunsResponse>() {
        @java.lang.Override
        public ListAutomationRunsResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ListAutomationRunsResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ListAutomationRunsResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.deploy.v1.ListAutomationRunsResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
