/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/deploy/v1/cloud_deploy.proto

package com.google.cloud.deploy.v1;

/**
 *
 *
 * <pre>
 * RepairPhase tracks the repair attempts that have been made for
 * each `RepairMode` specified in the `Automation` resource.
 * </pre>
 *
 * Protobuf type {@code google.cloud.deploy.v1.RepairPhase}
 */
public final class RepairPhase extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.deploy.v1.RepairPhase)
    RepairPhaseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RepairPhase.newBuilder() to construct.
  private RepairPhase(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RepairPhase() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RepairPhase();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.deploy.v1.CloudDeployProto
        .internal_static_google_cloud_deploy_v1_RepairPhase_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.deploy.v1.CloudDeployProto
        .internal_static_google_cloud_deploy_v1_RepairPhase_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.deploy.v1.RepairPhase.class,
            com.google.cloud.deploy.v1.RepairPhase.Builder.class);
  }

  private int repairPhaseCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object repairPhase_;

  public enum RepairPhaseCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    RETRY(1),
    ROLLBACK(2),
    REPAIRPHASE_NOT_SET(0);
    private final int value;

    private RepairPhaseCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static RepairPhaseCase valueOf(int value) {
      return forNumber(value);
    }

    public static RepairPhaseCase forNumber(int value) {
      switch (value) {
        case 1:
          return RETRY;
        case 2:
          return ROLLBACK;
        case 0:
          return REPAIRPHASE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public RepairPhaseCase getRepairPhaseCase() {
    return RepairPhaseCase.forNumber(repairPhaseCase_);
  }

  public static final int RETRY_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * Output only. Records of the retry attempts for retry repair mode.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.RetryPhase retry = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the retry field is set.
   */
  @java.lang.Override
  public boolean hasRetry() {
    return repairPhaseCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * Output only. Records of the retry attempts for retry repair mode.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.RetryPhase retry = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The retry.
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.RetryPhase getRetry() {
    if (repairPhaseCase_ == 1) {
      return (com.google.cloud.deploy.v1.RetryPhase) repairPhase_;
    }
    return com.google.cloud.deploy.v1.RetryPhase.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Output only. Records of the retry attempts for retry repair mode.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.RetryPhase retry = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.RetryPhaseOrBuilder getRetryOrBuilder() {
    if (repairPhaseCase_ == 1) {
      return (com.google.cloud.deploy.v1.RetryPhase) repairPhase_;
    }
    return com.google.cloud.deploy.v1.RetryPhase.getDefaultInstance();
  }

  public static final int ROLLBACK_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Output only. Rollback attempt for rollback repair mode .
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.RollbackAttempt rollback = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the rollback field is set.
   */
  @java.lang.Override
  public boolean hasRollback() {
    return repairPhaseCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Output only. Rollback attempt for rollback repair mode .
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.RollbackAttempt rollback = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The rollback.
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.RollbackAttempt getRollback() {
    if (repairPhaseCase_ == 2) {
      return (com.google.cloud.deploy.v1.RollbackAttempt) repairPhase_;
    }
    return com.google.cloud.deploy.v1.RollbackAttempt.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Output only. Rollback attempt for rollback repair mode .
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.RollbackAttempt rollback = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.RollbackAttemptOrBuilder getRollbackOrBuilder() {
    if (repairPhaseCase_ == 2) {
      return (com.google.cloud.deploy.v1.RollbackAttempt) repairPhase_;
    }
    return com.google.cloud.deploy.v1.RollbackAttempt.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (repairPhaseCase_ == 1) {
      output.writeMessage(1, (com.google.cloud.deploy.v1.RetryPhase) repairPhase_);
    }
    if (repairPhaseCase_ == 2) {
      output.writeMessage(2, (com.google.cloud.deploy.v1.RollbackAttempt) repairPhase_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (repairPhaseCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.cloud.deploy.v1.RetryPhase) repairPhase_);
    }
    if (repairPhaseCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.cloud.deploy.v1.RollbackAttempt) repairPhase_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.deploy.v1.RepairPhase)) {
      return super.equals(obj);
    }
    com.google.cloud.deploy.v1.RepairPhase other = (com.google.cloud.deploy.v1.RepairPhase) obj;

    if (!getRepairPhaseCase().equals(other.getRepairPhaseCase())) return false;
    switch (repairPhaseCase_) {
      case 1:
        if (!getRetry().equals(other.getRetry())) return false;
        break;
      case 2:
        if (!getRollback().equals(other.getRollback())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (repairPhaseCase_) {
      case 1:
        hash = (37 * hash) + RETRY_FIELD_NUMBER;
        hash = (53 * hash) + getRetry().hashCode();
        break;
      case 2:
        hash = (37 * hash) + ROLLBACK_FIELD_NUMBER;
        hash = (53 * hash) + getRollback().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.deploy.v1.RepairPhase parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.RepairPhase parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.RepairPhase parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.RepairPhase parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.RepairPhase parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.RepairPhase parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.RepairPhase parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.RepairPhase parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.RepairPhase parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.RepairPhase parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.RepairPhase parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.RepairPhase parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.deploy.v1.RepairPhase prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * RepairPhase tracks the repair attempts that have been made for
   * each `RepairMode` specified in the `Automation` resource.
   * </pre>
   *
   * Protobuf type {@code google.cloud.deploy.v1.RepairPhase}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.deploy.v1.RepairPhase)
      com.google.cloud.deploy.v1.RepairPhaseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_RepairPhase_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_RepairPhase_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.deploy.v1.RepairPhase.class,
              com.google.cloud.deploy.v1.RepairPhase.Builder.class);
    }

    // Construct using com.google.cloud.deploy.v1.RepairPhase.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (retryBuilder_ != null) {
        retryBuilder_.clear();
      }
      if (rollbackBuilder_ != null) {
        rollbackBuilder_.clear();
      }
      repairPhaseCase_ = 0;
      repairPhase_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_RepairPhase_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.RepairPhase getDefaultInstanceForType() {
      return com.google.cloud.deploy.v1.RepairPhase.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.RepairPhase build() {
      com.google.cloud.deploy.v1.RepairPhase result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.RepairPhase buildPartial() {
      com.google.cloud.deploy.v1.RepairPhase result =
          new com.google.cloud.deploy.v1.RepairPhase(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.deploy.v1.RepairPhase result) {
      int from_bitField0_ = bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.deploy.v1.RepairPhase result) {
      result.repairPhaseCase_ = repairPhaseCase_;
      result.repairPhase_ = this.repairPhase_;
      if (repairPhaseCase_ == 1 && retryBuilder_ != null) {
        result.repairPhase_ = retryBuilder_.build();
      }
      if (repairPhaseCase_ == 2 && rollbackBuilder_ != null) {
        result.repairPhase_ = rollbackBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.deploy.v1.RepairPhase) {
        return mergeFrom((com.google.cloud.deploy.v1.RepairPhase) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.deploy.v1.RepairPhase other) {
      if (other == com.google.cloud.deploy.v1.RepairPhase.getDefaultInstance()) return this;
      switch (other.getRepairPhaseCase()) {
        case RETRY:
          {
            mergeRetry(other.getRetry());
            break;
          }
        case ROLLBACK:
          {
            mergeRollback(other.getRollback());
            break;
          }
        case REPAIRPHASE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getRetryFieldBuilder().getBuilder(), extensionRegistry);
                repairPhaseCase_ = 1;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getRollbackFieldBuilder().getBuilder(), extensionRegistry);
                repairPhaseCase_ = 2;
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int repairPhaseCase_ = 0;
    private java.lang.Object repairPhase_;

    public RepairPhaseCase getRepairPhaseCase() {
      return RepairPhaseCase.forNumber(repairPhaseCase_);
    }

    public Builder clearRepairPhase() {
      repairPhaseCase_ = 0;
      repairPhase_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.RetryPhase,
            com.google.cloud.deploy.v1.RetryPhase.Builder,
            com.google.cloud.deploy.v1.RetryPhaseOrBuilder>
        retryBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Records of the retry attempts for retry repair mode.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.RetryPhase retry = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the retry field is set.
     */
    @java.lang.Override
    public boolean hasRetry() {
      return repairPhaseCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Output only. Records of the retry attempts for retry repair mode.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.RetryPhase retry = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The retry.
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.RetryPhase getRetry() {
      if (retryBuilder_ == null) {
        if (repairPhaseCase_ == 1) {
          return (com.google.cloud.deploy.v1.RetryPhase) repairPhase_;
        }
        return com.google.cloud.deploy.v1.RetryPhase.getDefaultInstance();
      } else {
        if (repairPhaseCase_ == 1) {
          return retryBuilder_.getMessage();
        }
        return com.google.cloud.deploy.v1.RetryPhase.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Records of the retry attempts for retry repair mode.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.RetryPhase retry = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setRetry(com.google.cloud.deploy.v1.RetryPhase value) {
      if (retryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        repairPhase_ = value;
        onChanged();
      } else {
        retryBuilder_.setMessage(value);
      }
      repairPhaseCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Records of the retry attempts for retry repair mode.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.RetryPhase retry = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setRetry(com.google.cloud.deploy.v1.RetryPhase.Builder builderForValue) {
      if (retryBuilder_ == null) {
        repairPhase_ = builderForValue.build();
        onChanged();
      } else {
        retryBuilder_.setMessage(builderForValue.build());
      }
      repairPhaseCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Records of the retry attempts for retry repair mode.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.RetryPhase retry = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeRetry(com.google.cloud.deploy.v1.RetryPhase value) {
      if (retryBuilder_ == null) {
        if (repairPhaseCase_ == 1
            && repairPhase_ != com.google.cloud.deploy.v1.RetryPhase.getDefaultInstance()) {
          repairPhase_ =
              com.google.cloud.deploy.v1.RetryPhase.newBuilder(
                      (com.google.cloud.deploy.v1.RetryPhase) repairPhase_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          repairPhase_ = value;
        }
        onChanged();
      } else {
        if (repairPhaseCase_ == 1) {
          retryBuilder_.mergeFrom(value);
        } else {
          retryBuilder_.setMessage(value);
        }
      }
      repairPhaseCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Records of the retry attempts for retry repair mode.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.RetryPhase retry = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearRetry() {
      if (retryBuilder_ == null) {
        if (repairPhaseCase_ == 1) {
          repairPhaseCase_ = 0;
          repairPhase_ = null;
          onChanged();
        }
      } else {
        if (repairPhaseCase_ == 1) {
          repairPhaseCase_ = 0;
          repairPhase_ = null;
        }
        retryBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Records of the retry attempts for retry repair mode.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.RetryPhase retry = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.deploy.v1.RetryPhase.Builder getRetryBuilder() {
      return getRetryFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Records of the retry attempts for retry repair mode.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.RetryPhase retry = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.RetryPhaseOrBuilder getRetryOrBuilder() {
      if ((repairPhaseCase_ == 1) && (retryBuilder_ != null)) {
        return retryBuilder_.getMessageOrBuilder();
      } else {
        if (repairPhaseCase_ == 1) {
          return (com.google.cloud.deploy.v1.RetryPhase) repairPhase_;
        }
        return com.google.cloud.deploy.v1.RetryPhase.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Records of the retry attempts for retry repair mode.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.RetryPhase retry = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.RetryPhase,
            com.google.cloud.deploy.v1.RetryPhase.Builder,
            com.google.cloud.deploy.v1.RetryPhaseOrBuilder>
        getRetryFieldBuilder() {
      if (retryBuilder_ == null) {
        if (!(repairPhaseCase_ == 1)) {
          repairPhase_ = com.google.cloud.deploy.v1.RetryPhase.getDefaultInstance();
        }
        retryBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.deploy.v1.RetryPhase,
                com.google.cloud.deploy.v1.RetryPhase.Builder,
                com.google.cloud.deploy.v1.RetryPhaseOrBuilder>(
                (com.google.cloud.deploy.v1.RetryPhase) repairPhase_,
                getParentForChildren(),
                isClean());
        repairPhase_ = null;
      }
      repairPhaseCase_ = 1;
      onChanged();
      return retryBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.RollbackAttempt,
            com.google.cloud.deploy.v1.RollbackAttempt.Builder,
            com.google.cloud.deploy.v1.RollbackAttemptOrBuilder>
        rollbackBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Rollback attempt for rollback repair mode .
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.RollbackAttempt rollback = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the rollback field is set.
     */
    @java.lang.Override
    public boolean hasRollback() {
      return repairPhaseCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Output only. Rollback attempt for rollback repair mode .
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.RollbackAttempt rollback = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The rollback.
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.RollbackAttempt getRollback() {
      if (rollbackBuilder_ == null) {
        if (repairPhaseCase_ == 2) {
          return (com.google.cloud.deploy.v1.RollbackAttempt) repairPhase_;
        }
        return com.google.cloud.deploy.v1.RollbackAttempt.getDefaultInstance();
      } else {
        if (repairPhaseCase_ == 2) {
          return rollbackBuilder_.getMessage();
        }
        return com.google.cloud.deploy.v1.RollbackAttempt.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Rollback attempt for rollback repair mode .
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.RollbackAttempt rollback = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setRollback(com.google.cloud.deploy.v1.RollbackAttempt value) {
      if (rollbackBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        repairPhase_ = value;
        onChanged();
      } else {
        rollbackBuilder_.setMessage(value);
      }
      repairPhaseCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Rollback attempt for rollback repair mode .
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.RollbackAttempt rollback = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setRollback(com.google.cloud.deploy.v1.RollbackAttempt.Builder builderForValue) {
      if (rollbackBuilder_ == null) {
        repairPhase_ = builderForValue.build();
        onChanged();
      } else {
        rollbackBuilder_.setMessage(builderForValue.build());
      }
      repairPhaseCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Rollback attempt for rollback repair mode .
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.RollbackAttempt rollback = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeRollback(com.google.cloud.deploy.v1.RollbackAttempt value) {
      if (rollbackBuilder_ == null) {
        if (repairPhaseCase_ == 2
            && repairPhase_ != com.google.cloud.deploy.v1.RollbackAttempt.getDefaultInstance()) {
          repairPhase_ =
              com.google.cloud.deploy.v1.RollbackAttempt.newBuilder(
                      (com.google.cloud.deploy.v1.RollbackAttempt) repairPhase_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          repairPhase_ = value;
        }
        onChanged();
      } else {
        if (repairPhaseCase_ == 2) {
          rollbackBuilder_.mergeFrom(value);
        } else {
          rollbackBuilder_.setMessage(value);
        }
      }
      repairPhaseCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Rollback attempt for rollback repair mode .
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.RollbackAttempt rollback = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearRollback() {
      if (rollbackBuilder_ == null) {
        if (repairPhaseCase_ == 2) {
          repairPhaseCase_ = 0;
          repairPhase_ = null;
          onChanged();
        }
      } else {
        if (repairPhaseCase_ == 2) {
          repairPhaseCase_ = 0;
          repairPhase_ = null;
        }
        rollbackBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Rollback attempt for rollback repair mode .
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.RollbackAttempt rollback = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.deploy.v1.RollbackAttempt.Builder getRollbackBuilder() {
      return getRollbackFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Rollback attempt for rollback repair mode .
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.RollbackAttempt rollback = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.RollbackAttemptOrBuilder getRollbackOrBuilder() {
      if ((repairPhaseCase_ == 2) && (rollbackBuilder_ != null)) {
        return rollbackBuilder_.getMessageOrBuilder();
      } else {
        if (repairPhaseCase_ == 2) {
          return (com.google.cloud.deploy.v1.RollbackAttempt) repairPhase_;
        }
        return com.google.cloud.deploy.v1.RollbackAttempt.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Rollback attempt for rollback repair mode .
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.RollbackAttempt rollback = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.RollbackAttempt,
            com.google.cloud.deploy.v1.RollbackAttempt.Builder,
            com.google.cloud.deploy.v1.RollbackAttemptOrBuilder>
        getRollbackFieldBuilder() {
      if (rollbackBuilder_ == null) {
        if (!(repairPhaseCase_ == 2)) {
          repairPhase_ = com.google.cloud.deploy.v1.RollbackAttempt.getDefaultInstance();
        }
        rollbackBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.deploy.v1.RollbackAttempt,
                com.google.cloud.deploy.v1.RollbackAttempt.Builder,
                com.google.cloud.deploy.v1.RollbackAttemptOrBuilder>(
                (com.google.cloud.deploy.v1.RollbackAttempt) repairPhase_,
                getParentForChildren(),
                isClean());
        repairPhase_ = null;
      }
      repairPhaseCase_ = 2;
      onChanged();
      return rollbackBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.deploy.v1.RepairPhase)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.deploy.v1.RepairPhase)
  private static final com.google.cloud.deploy.v1.RepairPhase DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.deploy.v1.RepairPhase();
  }

  public static com.google.cloud.deploy.v1.RepairPhase getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RepairPhase> PARSER =
      new com.google.protobuf.AbstractParser<RepairPhase>() {
        @java.lang.Override
        public RepairPhase parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RepairPhase> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RepairPhase> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.deploy.v1.RepairPhase getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
