/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/deploy/v1/cloud_deploy.proto

package com.google.cloud.deploy.v1;

/**
 *
 *
 * <pre>
 * RetryPhase contains the retry attempts and the metadata for initiating a
 * new attempt.
 * </pre>
 *
 * Protobuf type {@code google.cloud.deploy.v1.RetryPhase}
 */
public final class RetryPhase extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.deploy.v1.RetryPhase)
    RetryPhaseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RetryPhase.newBuilder() to construct.
  private RetryPhase(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RetryPhase() {
    backoffMode_ = 0;
    phaseId_ = "";
    jobId_ = "";
    attempts_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RetryPhase();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.deploy.v1.CloudDeployProto
        .internal_static_google_cloud_deploy_v1_RetryPhase_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.deploy.v1.CloudDeployProto
        .internal_static_google_cloud_deploy_v1_RetryPhase_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.deploy.v1.RetryPhase.class,
            com.google.cloud.deploy.v1.RetryPhase.Builder.class);
  }

  public static final int TOTAL_ATTEMPTS_FIELD_NUMBER = 1;
  private long totalAttempts_ = 0L;
  /**
   *
   *
   * <pre>
   * Output only. The number of attempts that have been made.
   * </pre>
   *
   * <code>int64 total_attempts = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The totalAttempts.
   */
  @java.lang.Override
  public long getTotalAttempts() {
    return totalAttempts_;
  }

  public static final int BACKOFF_MODE_FIELD_NUMBER = 2;
  private int backoffMode_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The pattern of how the wait time of the retry attempt is
   * calculated.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.BackoffMode backoff_mode = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for backoffMode.
   */
  @java.lang.Override
  public int getBackoffModeValue() {
    return backoffMode_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The pattern of how the wait time of the retry attempt is
   * calculated.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.BackoffMode backoff_mode = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The backoffMode.
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.BackoffMode getBackoffMode() {
    com.google.cloud.deploy.v1.BackoffMode result =
        com.google.cloud.deploy.v1.BackoffMode.forNumber(backoffMode_);
    return result == null ? com.google.cloud.deploy.v1.BackoffMode.UNRECOGNIZED : result;
  }

  public static final int PHASE_ID_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object phaseId_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The phase ID of the phase that includes the job being retried.
   * </pre>
   *
   * <code>string phase_id = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The phaseId.
   */
  @java.lang.Override
  public java.lang.String getPhaseId() {
    java.lang.Object ref = phaseId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      phaseId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The phase ID of the phase that includes the job being retried.
   * </pre>
   *
   * <code>string phase_id = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for phaseId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPhaseIdBytes() {
    java.lang.Object ref = phaseId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      phaseId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int JOB_ID_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object jobId_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The job ID for the Job to retry.
   * </pre>
   *
   * <code>string job_id = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The jobId.
   */
  @java.lang.Override
  public java.lang.String getJobId() {
    java.lang.Object ref = jobId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      jobId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The job ID for the Job to retry.
   * </pre>
   *
   * <code>string job_id = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for jobId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getJobIdBytes() {
    java.lang.Object ref = jobId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      jobId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ATTEMPTS_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.deploy.v1.RetryAttempt> attempts_;
  /**
   *
   *
   * <pre>
   * Output only. Detail of a retry action.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.RetryAttempt attempts = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.deploy.v1.RetryAttempt> getAttemptsList() {
    return attempts_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Detail of a retry action.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.RetryAttempt attempts = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.deploy.v1.RetryAttemptOrBuilder>
      getAttemptsOrBuilderList() {
    return attempts_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Detail of a retry action.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.RetryAttempt attempts = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getAttemptsCount() {
    return attempts_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Detail of a retry action.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.RetryAttempt attempts = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.RetryAttempt getAttempts(int index) {
    return attempts_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. Detail of a retry action.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.RetryAttempt attempts = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.RetryAttemptOrBuilder getAttemptsOrBuilder(int index) {
    return attempts_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (totalAttempts_ != 0L) {
      output.writeInt64(1, totalAttempts_);
    }
    if (backoffMode_
        != com.google.cloud.deploy.v1.BackoffMode.BACKOFF_MODE_UNSPECIFIED.getNumber()) {
      output.writeEnum(2, backoffMode_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(phaseId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, phaseId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(jobId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, jobId_);
    }
    for (int i = 0; i < attempts_.size(); i++) {
      output.writeMessage(5, attempts_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (totalAttempts_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(1, totalAttempts_);
    }
    if (backoffMode_
        != com.google.cloud.deploy.v1.BackoffMode.BACKOFF_MODE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, backoffMode_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(phaseId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, phaseId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(jobId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, jobId_);
    }
    for (int i = 0; i < attempts_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, attempts_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.deploy.v1.RetryPhase)) {
      return super.equals(obj);
    }
    com.google.cloud.deploy.v1.RetryPhase other = (com.google.cloud.deploy.v1.RetryPhase) obj;

    if (getTotalAttempts() != other.getTotalAttempts()) return false;
    if (backoffMode_ != other.backoffMode_) return false;
    if (!getPhaseId().equals(other.getPhaseId())) return false;
    if (!getJobId().equals(other.getJobId())) return false;
    if (!getAttemptsList().equals(other.getAttemptsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TOTAL_ATTEMPTS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getTotalAttempts());
    hash = (37 * hash) + BACKOFF_MODE_FIELD_NUMBER;
    hash = (53 * hash) + backoffMode_;
    hash = (37 * hash) + PHASE_ID_FIELD_NUMBER;
    hash = (53 * hash) + getPhaseId().hashCode();
    hash = (37 * hash) + JOB_ID_FIELD_NUMBER;
    hash = (53 * hash) + getJobId().hashCode();
    if (getAttemptsCount() > 0) {
      hash = (37 * hash) + ATTEMPTS_FIELD_NUMBER;
      hash = (53 * hash) + getAttemptsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.deploy.v1.RetryPhase parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.RetryPhase parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.RetryPhase parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.RetryPhase parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.RetryPhase parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.RetryPhase parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.RetryPhase parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.RetryPhase parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.RetryPhase parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.RetryPhase parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.RetryPhase parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.RetryPhase parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.deploy.v1.RetryPhase prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * RetryPhase contains the retry attempts and the metadata for initiating a
   * new attempt.
   * </pre>
   *
   * Protobuf type {@code google.cloud.deploy.v1.RetryPhase}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.deploy.v1.RetryPhase)
      com.google.cloud.deploy.v1.RetryPhaseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_RetryPhase_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_RetryPhase_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.deploy.v1.RetryPhase.class,
              com.google.cloud.deploy.v1.RetryPhase.Builder.class);
    }

    // Construct using com.google.cloud.deploy.v1.RetryPhase.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      totalAttempts_ = 0L;
      backoffMode_ = 0;
      phaseId_ = "";
      jobId_ = "";
      if (attemptsBuilder_ == null) {
        attempts_ = java.util.Collections.emptyList();
      } else {
        attempts_ = null;
        attemptsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000010);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_RetryPhase_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.RetryPhase getDefaultInstanceForType() {
      return com.google.cloud.deploy.v1.RetryPhase.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.RetryPhase build() {
      com.google.cloud.deploy.v1.RetryPhase result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.RetryPhase buildPartial() {
      com.google.cloud.deploy.v1.RetryPhase result =
          new com.google.cloud.deploy.v1.RetryPhase(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.deploy.v1.RetryPhase result) {
      if (attemptsBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)) {
          attempts_ = java.util.Collections.unmodifiableList(attempts_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.attempts_ = attempts_;
      } else {
        result.attempts_ = attemptsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.deploy.v1.RetryPhase result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.totalAttempts_ = totalAttempts_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.backoffMode_ = backoffMode_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.phaseId_ = phaseId_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.jobId_ = jobId_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.deploy.v1.RetryPhase) {
        return mergeFrom((com.google.cloud.deploy.v1.RetryPhase) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.deploy.v1.RetryPhase other) {
      if (other == com.google.cloud.deploy.v1.RetryPhase.getDefaultInstance()) return this;
      if (other.getTotalAttempts() != 0L) {
        setTotalAttempts(other.getTotalAttempts());
      }
      if (other.backoffMode_ != 0) {
        setBackoffModeValue(other.getBackoffModeValue());
      }
      if (!other.getPhaseId().isEmpty()) {
        phaseId_ = other.phaseId_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getJobId().isEmpty()) {
        jobId_ = other.jobId_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (attemptsBuilder_ == null) {
        if (!other.attempts_.isEmpty()) {
          if (attempts_.isEmpty()) {
            attempts_ = other.attempts_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureAttemptsIsMutable();
            attempts_.addAll(other.attempts_);
          }
          onChanged();
        }
      } else {
        if (!other.attempts_.isEmpty()) {
          if (attemptsBuilder_.isEmpty()) {
            attemptsBuilder_.dispose();
            attemptsBuilder_ = null;
            attempts_ = other.attempts_;
            bitField0_ = (bitField0_ & ~0x00000010);
            attemptsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getAttemptsFieldBuilder()
                    : null;
          } else {
            attemptsBuilder_.addAllMessages(other.attempts_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                totalAttempts_ = input.readInt64();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 16:
              {
                backoffMode_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                phaseId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                jobId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                com.google.cloud.deploy.v1.RetryAttempt m =
                    input.readMessage(
                        com.google.cloud.deploy.v1.RetryAttempt.parser(), extensionRegistry);
                if (attemptsBuilder_ == null) {
                  ensureAttemptsIsMutable();
                  attempts_.add(m);
                } else {
                  attemptsBuilder_.addMessage(m);
                }
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private long totalAttempts_;
    /**
     *
     *
     * <pre>
     * Output only. The number of attempts that have been made.
     * </pre>
     *
     * <code>int64 total_attempts = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The totalAttempts.
     */
    @java.lang.Override
    public long getTotalAttempts() {
      return totalAttempts_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The number of attempts that have been made.
     * </pre>
     *
     * <code>int64 total_attempts = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The totalAttempts to set.
     * @return This builder for chaining.
     */
    public Builder setTotalAttempts(long value) {

      totalAttempts_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The number of attempts that have been made.
     * </pre>
     *
     * <code>int64 total_attempts = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTotalAttempts() {
      bitField0_ = (bitField0_ & ~0x00000001);
      totalAttempts_ = 0L;
      onChanged();
      return this;
    }

    private int backoffMode_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The pattern of how the wait time of the retry attempt is
     * calculated.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.BackoffMode backoff_mode = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for backoffMode.
     */
    @java.lang.Override
    public int getBackoffModeValue() {
      return backoffMode_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The pattern of how the wait time of the retry attempt is
     * calculated.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.BackoffMode backoff_mode = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for backoffMode to set.
     * @return This builder for chaining.
     */
    public Builder setBackoffModeValue(int value) {
      backoffMode_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The pattern of how the wait time of the retry attempt is
     * calculated.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.BackoffMode backoff_mode = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The backoffMode.
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.BackoffMode getBackoffMode() {
      com.google.cloud.deploy.v1.BackoffMode result =
          com.google.cloud.deploy.v1.BackoffMode.forNumber(backoffMode_);
      return result == null ? com.google.cloud.deploy.v1.BackoffMode.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The pattern of how the wait time of the retry attempt is
     * calculated.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.BackoffMode backoff_mode = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The backoffMode to set.
     * @return This builder for chaining.
     */
    public Builder setBackoffMode(com.google.cloud.deploy.v1.BackoffMode value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      backoffMode_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The pattern of how the wait time of the retry attempt is
     * calculated.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.BackoffMode backoff_mode = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBackoffMode() {
      bitField0_ = (bitField0_ & ~0x00000002);
      backoffMode_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object phaseId_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The phase ID of the phase that includes the job being retried.
     * </pre>
     *
     * <code>string phase_id = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The phaseId.
     */
    public java.lang.String getPhaseId() {
      java.lang.Object ref = phaseId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        phaseId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The phase ID of the phase that includes the job being retried.
     * </pre>
     *
     * <code>string phase_id = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for phaseId.
     */
    public com.google.protobuf.ByteString getPhaseIdBytes() {
      java.lang.Object ref = phaseId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        phaseId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The phase ID of the phase that includes the job being retried.
     * </pre>
     *
     * <code>string phase_id = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The phaseId to set.
     * @return This builder for chaining.
     */
    public Builder setPhaseId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      phaseId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The phase ID of the phase that includes the job being retried.
     * </pre>
     *
     * <code>string phase_id = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPhaseId() {
      phaseId_ = getDefaultInstance().getPhaseId();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The phase ID of the phase that includes the job being retried.
     * </pre>
     *
     * <code>string phase_id = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for phaseId to set.
     * @return This builder for chaining.
     */
    public Builder setPhaseIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      phaseId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object jobId_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The job ID for the Job to retry.
     * </pre>
     *
     * <code>string job_id = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The jobId.
     */
    public java.lang.String getJobId() {
      java.lang.Object ref = jobId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        jobId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The job ID for the Job to retry.
     * </pre>
     *
     * <code>string job_id = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for jobId.
     */
    public com.google.protobuf.ByteString getJobIdBytes() {
      java.lang.Object ref = jobId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        jobId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The job ID for the Job to retry.
     * </pre>
     *
     * <code>string job_id = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The jobId to set.
     * @return This builder for chaining.
     */
    public Builder setJobId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      jobId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The job ID for the Job to retry.
     * </pre>
     *
     * <code>string job_id = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearJobId() {
      jobId_ = getDefaultInstance().getJobId();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The job ID for the Job to retry.
     * </pre>
     *
     * <code>string job_id = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for jobId to set.
     * @return This builder for chaining.
     */
    public Builder setJobIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      jobId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.deploy.v1.RetryAttempt> attempts_ =
        java.util.Collections.emptyList();

    private void ensureAttemptsIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        attempts_ = new java.util.ArrayList<com.google.cloud.deploy.v1.RetryAttempt>(attempts_);
        bitField0_ |= 0x00000010;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.deploy.v1.RetryAttempt,
            com.google.cloud.deploy.v1.RetryAttempt.Builder,
            com.google.cloud.deploy.v1.RetryAttemptOrBuilder>
        attemptsBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Detail of a retry action.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.RetryAttempt attempts = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.deploy.v1.RetryAttempt> getAttemptsList() {
      if (attemptsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(attempts_);
      } else {
        return attemptsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Detail of a retry action.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.RetryAttempt attempts = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getAttemptsCount() {
      if (attemptsBuilder_ == null) {
        return attempts_.size();
      } else {
        return attemptsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Detail of a retry action.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.RetryAttempt attempts = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.deploy.v1.RetryAttempt getAttempts(int index) {
      if (attemptsBuilder_ == null) {
        return attempts_.get(index);
      } else {
        return attemptsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Detail of a retry action.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.RetryAttempt attempts = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setAttempts(int index, com.google.cloud.deploy.v1.RetryAttempt value) {
      if (attemptsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAttemptsIsMutable();
        attempts_.set(index, value);
        onChanged();
      } else {
        attemptsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Detail of a retry action.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.RetryAttempt attempts = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setAttempts(
        int index, com.google.cloud.deploy.v1.RetryAttempt.Builder builderForValue) {
      if (attemptsBuilder_ == null) {
        ensureAttemptsIsMutable();
        attempts_.set(index, builderForValue.build());
        onChanged();
      } else {
        attemptsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Detail of a retry action.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.RetryAttempt attempts = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAttempts(com.google.cloud.deploy.v1.RetryAttempt value) {
      if (attemptsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAttemptsIsMutable();
        attempts_.add(value);
        onChanged();
      } else {
        attemptsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Detail of a retry action.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.RetryAttempt attempts = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAttempts(int index, com.google.cloud.deploy.v1.RetryAttempt value) {
      if (attemptsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAttemptsIsMutable();
        attempts_.add(index, value);
        onChanged();
      } else {
        attemptsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Detail of a retry action.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.RetryAttempt attempts = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAttempts(com.google.cloud.deploy.v1.RetryAttempt.Builder builderForValue) {
      if (attemptsBuilder_ == null) {
        ensureAttemptsIsMutable();
        attempts_.add(builderForValue.build());
        onChanged();
      } else {
        attemptsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Detail of a retry action.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.RetryAttempt attempts = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAttempts(
        int index, com.google.cloud.deploy.v1.RetryAttempt.Builder builderForValue) {
      if (attemptsBuilder_ == null) {
        ensureAttemptsIsMutable();
        attempts_.add(index, builderForValue.build());
        onChanged();
      } else {
        attemptsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Detail of a retry action.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.RetryAttempt attempts = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllAttempts(
        java.lang.Iterable<? extends com.google.cloud.deploy.v1.RetryAttempt> values) {
      if (attemptsBuilder_ == null) {
        ensureAttemptsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, attempts_);
        onChanged();
      } else {
        attemptsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Detail of a retry action.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.RetryAttempt attempts = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearAttempts() {
      if (attemptsBuilder_ == null) {
        attempts_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        attemptsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Detail of a retry action.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.RetryAttempt attempts = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeAttempts(int index) {
      if (attemptsBuilder_ == null) {
        ensureAttemptsIsMutable();
        attempts_.remove(index);
        onChanged();
      } else {
        attemptsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Detail of a retry action.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.RetryAttempt attempts = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.deploy.v1.RetryAttempt.Builder getAttemptsBuilder(int index) {
      return getAttemptsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. Detail of a retry action.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.RetryAttempt attempts = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.deploy.v1.RetryAttemptOrBuilder getAttemptsOrBuilder(int index) {
      if (attemptsBuilder_ == null) {
        return attempts_.get(index);
      } else {
        return attemptsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Detail of a retry action.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.RetryAttempt attempts = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.deploy.v1.RetryAttemptOrBuilder>
        getAttemptsOrBuilderList() {
      if (attemptsBuilder_ != null) {
        return attemptsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(attempts_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Detail of a retry action.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.RetryAttempt attempts = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.deploy.v1.RetryAttempt.Builder addAttemptsBuilder() {
      return getAttemptsFieldBuilder()
          .addBuilder(com.google.cloud.deploy.v1.RetryAttempt.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Detail of a retry action.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.RetryAttempt attempts = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.deploy.v1.RetryAttempt.Builder addAttemptsBuilder(int index) {
      return getAttemptsFieldBuilder()
          .addBuilder(index, com.google.cloud.deploy.v1.RetryAttempt.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Detail of a retry action.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.RetryAttempt attempts = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.deploy.v1.RetryAttempt.Builder>
        getAttemptsBuilderList() {
      return getAttemptsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.deploy.v1.RetryAttempt,
            com.google.cloud.deploy.v1.RetryAttempt.Builder,
            com.google.cloud.deploy.v1.RetryAttemptOrBuilder>
        getAttemptsFieldBuilder() {
      if (attemptsBuilder_ == null) {
        attemptsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.deploy.v1.RetryAttempt,
                com.google.cloud.deploy.v1.RetryAttempt.Builder,
                com.google.cloud.deploy.v1.RetryAttemptOrBuilder>(
                attempts_, ((bitField0_ & 0x00000010) != 0), getParentForChildren(), isClean());
        attempts_ = null;
      }
      return attemptsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.deploy.v1.RetryPhase)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.deploy.v1.RetryPhase)
  private static final com.google.cloud.deploy.v1.RetryPhase DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.deploy.v1.RetryPhase();
  }

  public static com.google.cloud.deploy.v1.RetryPhase getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RetryPhase> PARSER =
      new com.google.protobuf.AbstractParser<RetryPhase>() {
        @java.lang.Override
        public RetryPhase parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RetryPhase> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RetryPhase> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.deploy.v1.RetryPhase getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
