/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/deploy/v1/cloud_deploy.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.deploy.v1;

/**
 *
 *
 * <pre>
 * Canary represents the canary deployment strategy.
 * </pre>
 *
 * Protobuf type {@code google.cloud.deploy.v1.Canary}
 */
public final class Canary extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.deploy.v1.Canary)
    CanaryOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Canary.newBuilder() to construct.
  private Canary(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Canary() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Canary();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.deploy.v1.CloudDeployProto
        .internal_static_google_cloud_deploy_v1_Canary_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.deploy.v1.CloudDeployProto
        .internal_static_google_cloud_deploy_v1_Canary_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.deploy.v1.Canary.class,
            com.google.cloud.deploy.v1.Canary.Builder.class);
  }

  private int bitField0_;
  private int modeCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object mode_;

  public enum ModeCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    CANARY_DEPLOYMENT(2),
    CUSTOM_CANARY_DEPLOYMENT(3),
    MODE_NOT_SET(0);
    private final int value;

    private ModeCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ModeCase valueOf(int value) {
      return forNumber(value);
    }

    public static ModeCase forNumber(int value) {
      switch (value) {
        case 2:
          return CANARY_DEPLOYMENT;
        case 3:
          return CUSTOM_CANARY_DEPLOYMENT;
        case 0:
          return MODE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ModeCase getModeCase() {
    return ModeCase.forNumber(modeCase_);
  }

  public static final int RUNTIME_CONFIG_FIELD_NUMBER = 1;
  private com.google.cloud.deploy.v1.RuntimeConfig runtimeConfig_;
  /**
   *
   *
   * <pre>
   * Optional. Runtime specific configurations for the deployment strategy. The
   * runtime configuration is used to determine how Cloud Deploy will split
   * traffic to enable a progressive deployment.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.RuntimeConfig runtime_config = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the runtimeConfig field is set.
   */
  @java.lang.Override
  public boolean hasRuntimeConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Runtime specific configurations for the deployment strategy. The
   * runtime configuration is used to determine how Cloud Deploy will split
   * traffic to enable a progressive deployment.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.RuntimeConfig runtime_config = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The runtimeConfig.
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.RuntimeConfig getRuntimeConfig() {
    return runtimeConfig_ == null
        ? com.google.cloud.deploy.v1.RuntimeConfig.getDefaultInstance()
        : runtimeConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Runtime specific configurations for the deployment strategy. The
   * runtime configuration is used to determine how Cloud Deploy will split
   * traffic to enable a progressive deployment.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.RuntimeConfig runtime_config = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.RuntimeConfigOrBuilder getRuntimeConfigOrBuilder() {
    return runtimeConfig_ == null
        ? com.google.cloud.deploy.v1.RuntimeConfig.getDefaultInstance()
        : runtimeConfig_;
  }

  public static final int CANARY_DEPLOYMENT_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Configures the progressive based deployment for a Target.
   * </pre>
   *
   * <code>.google.cloud.deploy.v1.CanaryDeployment canary_deployment = 2;</code>
   *
   * @return Whether the canaryDeployment field is set.
   */
  @java.lang.Override
  public boolean hasCanaryDeployment() {
    return modeCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Configures the progressive based deployment for a Target.
   * </pre>
   *
   * <code>.google.cloud.deploy.v1.CanaryDeployment canary_deployment = 2;</code>
   *
   * @return The canaryDeployment.
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.CanaryDeployment getCanaryDeployment() {
    if (modeCase_ == 2) {
      return (com.google.cloud.deploy.v1.CanaryDeployment) mode_;
    }
    return com.google.cloud.deploy.v1.CanaryDeployment.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Configures the progressive based deployment for a Target.
   * </pre>
   *
   * <code>.google.cloud.deploy.v1.CanaryDeployment canary_deployment = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.CanaryDeploymentOrBuilder getCanaryDeploymentOrBuilder() {
    if (modeCase_ == 2) {
      return (com.google.cloud.deploy.v1.CanaryDeployment) mode_;
    }
    return com.google.cloud.deploy.v1.CanaryDeployment.getDefaultInstance();
  }

  public static final int CUSTOM_CANARY_DEPLOYMENT_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Configures the progressive based deployment for a Target, but allows
   * customizing at the phase level where a phase represents each of the
   * percentage deployments.
   * </pre>
   *
   * <code>.google.cloud.deploy.v1.CustomCanaryDeployment custom_canary_deployment = 3;</code>
   *
   * @return Whether the customCanaryDeployment field is set.
   */
  @java.lang.Override
  public boolean hasCustomCanaryDeployment() {
    return modeCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Configures the progressive based deployment for a Target, but allows
   * customizing at the phase level where a phase represents each of the
   * percentage deployments.
   * </pre>
   *
   * <code>.google.cloud.deploy.v1.CustomCanaryDeployment custom_canary_deployment = 3;</code>
   *
   * @return The customCanaryDeployment.
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.CustomCanaryDeployment getCustomCanaryDeployment() {
    if (modeCase_ == 3) {
      return (com.google.cloud.deploy.v1.CustomCanaryDeployment) mode_;
    }
    return com.google.cloud.deploy.v1.CustomCanaryDeployment.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Configures the progressive based deployment for a Target, but allows
   * customizing at the phase level where a phase represents each of the
   * percentage deployments.
   * </pre>
   *
   * <code>.google.cloud.deploy.v1.CustomCanaryDeployment custom_canary_deployment = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.CustomCanaryDeploymentOrBuilder
      getCustomCanaryDeploymentOrBuilder() {
    if (modeCase_ == 3) {
      return (com.google.cloud.deploy.v1.CustomCanaryDeployment) mode_;
    }
    return com.google.cloud.deploy.v1.CustomCanaryDeployment.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getRuntimeConfig());
    }
    if (modeCase_ == 2) {
      output.writeMessage(2, (com.google.cloud.deploy.v1.CanaryDeployment) mode_);
    }
    if (modeCase_ == 3) {
      output.writeMessage(3, (com.google.cloud.deploy.v1.CustomCanaryDeployment) mode_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getRuntimeConfig());
    }
    if (modeCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.cloud.deploy.v1.CanaryDeployment) mode_);
    }
    if (modeCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.cloud.deploy.v1.CustomCanaryDeployment) mode_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.deploy.v1.Canary)) {
      return super.equals(obj);
    }
    com.google.cloud.deploy.v1.Canary other = (com.google.cloud.deploy.v1.Canary) obj;

    if (hasRuntimeConfig() != other.hasRuntimeConfig()) return false;
    if (hasRuntimeConfig()) {
      if (!getRuntimeConfig().equals(other.getRuntimeConfig())) return false;
    }
    if (!getModeCase().equals(other.getModeCase())) return false;
    switch (modeCase_) {
      case 2:
        if (!getCanaryDeployment().equals(other.getCanaryDeployment())) return false;
        break;
      case 3:
        if (!getCustomCanaryDeployment().equals(other.getCustomCanaryDeployment())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasRuntimeConfig()) {
      hash = (37 * hash) + RUNTIME_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getRuntimeConfig().hashCode();
    }
    switch (modeCase_) {
      case 2:
        hash = (37 * hash) + CANARY_DEPLOYMENT_FIELD_NUMBER;
        hash = (53 * hash) + getCanaryDeployment().hashCode();
        break;
      case 3:
        hash = (37 * hash) + CUSTOM_CANARY_DEPLOYMENT_FIELD_NUMBER;
        hash = (53 * hash) + getCustomCanaryDeployment().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.deploy.v1.Canary parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.Canary parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.Canary parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.Canary parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.Canary parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.Canary parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.Canary parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.Canary parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.Canary parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.Canary parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.Canary parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.Canary parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.deploy.v1.Canary prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Canary represents the canary deployment strategy.
   * </pre>
   *
   * Protobuf type {@code google.cloud.deploy.v1.Canary}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.deploy.v1.Canary)
      com.google.cloud.deploy.v1.CanaryOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_Canary_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_Canary_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.deploy.v1.Canary.class,
              com.google.cloud.deploy.v1.Canary.Builder.class);
    }

    // Construct using com.google.cloud.deploy.v1.Canary.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getRuntimeConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      runtimeConfig_ = null;
      if (runtimeConfigBuilder_ != null) {
        runtimeConfigBuilder_.dispose();
        runtimeConfigBuilder_ = null;
      }
      if (canaryDeploymentBuilder_ != null) {
        canaryDeploymentBuilder_.clear();
      }
      if (customCanaryDeploymentBuilder_ != null) {
        customCanaryDeploymentBuilder_.clear();
      }
      modeCase_ = 0;
      mode_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_Canary_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.Canary getDefaultInstanceForType() {
      return com.google.cloud.deploy.v1.Canary.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.Canary build() {
      com.google.cloud.deploy.v1.Canary result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.Canary buildPartial() {
      com.google.cloud.deploy.v1.Canary result = new com.google.cloud.deploy.v1.Canary(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.deploy.v1.Canary result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.runtimeConfig_ =
            runtimeConfigBuilder_ == null ? runtimeConfig_ : runtimeConfigBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.deploy.v1.Canary result) {
      result.modeCase_ = modeCase_;
      result.mode_ = this.mode_;
      if (modeCase_ == 2 && canaryDeploymentBuilder_ != null) {
        result.mode_ = canaryDeploymentBuilder_.build();
      }
      if (modeCase_ == 3 && customCanaryDeploymentBuilder_ != null) {
        result.mode_ = customCanaryDeploymentBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.deploy.v1.Canary) {
        return mergeFrom((com.google.cloud.deploy.v1.Canary) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.deploy.v1.Canary other) {
      if (other == com.google.cloud.deploy.v1.Canary.getDefaultInstance()) return this;
      if (other.hasRuntimeConfig()) {
        mergeRuntimeConfig(other.getRuntimeConfig());
      }
      switch (other.getModeCase()) {
        case CANARY_DEPLOYMENT:
          {
            mergeCanaryDeployment(other.getCanaryDeployment());
            break;
          }
        case CUSTOM_CANARY_DEPLOYMENT:
          {
            mergeCustomCanaryDeployment(other.getCustomCanaryDeployment());
            break;
          }
        case MODE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getRuntimeConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(
                    getCanaryDeploymentFieldBuilder().getBuilder(), extensionRegistry);
                modeCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getCustomCanaryDeploymentFieldBuilder().getBuilder(), extensionRegistry);
                modeCase_ = 3;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int modeCase_ = 0;
    private java.lang.Object mode_;

    public ModeCase getModeCase() {
      return ModeCase.forNumber(modeCase_);
    }

    public Builder clearMode() {
      modeCase_ = 0;
      mode_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.cloud.deploy.v1.RuntimeConfig runtimeConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.RuntimeConfig,
            com.google.cloud.deploy.v1.RuntimeConfig.Builder,
            com.google.cloud.deploy.v1.RuntimeConfigOrBuilder>
        runtimeConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Runtime specific configurations for the deployment strategy. The
     * runtime configuration is used to determine how Cloud Deploy will split
     * traffic to enable a progressive deployment.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.RuntimeConfig runtime_config = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the runtimeConfig field is set.
     */
    public boolean hasRuntimeConfig() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Runtime specific configurations for the deployment strategy. The
     * runtime configuration is used to determine how Cloud Deploy will split
     * traffic to enable a progressive deployment.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.RuntimeConfig runtime_config = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The runtimeConfig.
     */
    public com.google.cloud.deploy.v1.RuntimeConfig getRuntimeConfig() {
      if (runtimeConfigBuilder_ == null) {
        return runtimeConfig_ == null
            ? com.google.cloud.deploy.v1.RuntimeConfig.getDefaultInstance()
            : runtimeConfig_;
      } else {
        return runtimeConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Runtime specific configurations for the deployment strategy. The
     * runtime configuration is used to determine how Cloud Deploy will split
     * traffic to enable a progressive deployment.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.RuntimeConfig runtime_config = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRuntimeConfig(com.google.cloud.deploy.v1.RuntimeConfig value) {
      if (runtimeConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        runtimeConfig_ = value;
      } else {
        runtimeConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Runtime specific configurations for the deployment strategy. The
     * runtime configuration is used to determine how Cloud Deploy will split
     * traffic to enable a progressive deployment.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.RuntimeConfig runtime_config = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRuntimeConfig(
        com.google.cloud.deploy.v1.RuntimeConfig.Builder builderForValue) {
      if (runtimeConfigBuilder_ == null) {
        runtimeConfig_ = builderForValue.build();
      } else {
        runtimeConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Runtime specific configurations for the deployment strategy. The
     * runtime configuration is used to determine how Cloud Deploy will split
     * traffic to enable a progressive deployment.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.RuntimeConfig runtime_config = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeRuntimeConfig(com.google.cloud.deploy.v1.RuntimeConfig value) {
      if (runtimeConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && runtimeConfig_ != null
            && runtimeConfig_ != com.google.cloud.deploy.v1.RuntimeConfig.getDefaultInstance()) {
          getRuntimeConfigBuilder().mergeFrom(value);
        } else {
          runtimeConfig_ = value;
        }
      } else {
        runtimeConfigBuilder_.mergeFrom(value);
      }
      if (runtimeConfig_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Runtime specific configurations for the deployment strategy. The
     * runtime configuration is used to determine how Cloud Deploy will split
     * traffic to enable a progressive deployment.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.RuntimeConfig runtime_config = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearRuntimeConfig() {
      bitField0_ = (bitField0_ & ~0x00000001);
      runtimeConfig_ = null;
      if (runtimeConfigBuilder_ != null) {
        runtimeConfigBuilder_.dispose();
        runtimeConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Runtime specific configurations for the deployment strategy. The
     * runtime configuration is used to determine how Cloud Deploy will split
     * traffic to enable a progressive deployment.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.RuntimeConfig runtime_config = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.deploy.v1.RuntimeConfig.Builder getRuntimeConfigBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getRuntimeConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Runtime specific configurations for the deployment strategy. The
     * runtime configuration is used to determine how Cloud Deploy will split
     * traffic to enable a progressive deployment.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.RuntimeConfig runtime_config = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.deploy.v1.RuntimeConfigOrBuilder getRuntimeConfigOrBuilder() {
      if (runtimeConfigBuilder_ != null) {
        return runtimeConfigBuilder_.getMessageOrBuilder();
      } else {
        return runtimeConfig_ == null
            ? com.google.cloud.deploy.v1.RuntimeConfig.getDefaultInstance()
            : runtimeConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Runtime specific configurations for the deployment strategy. The
     * runtime configuration is used to determine how Cloud Deploy will split
     * traffic to enable a progressive deployment.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.RuntimeConfig runtime_config = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.RuntimeConfig,
            com.google.cloud.deploy.v1.RuntimeConfig.Builder,
            com.google.cloud.deploy.v1.RuntimeConfigOrBuilder>
        getRuntimeConfigFieldBuilder() {
      if (runtimeConfigBuilder_ == null) {
        runtimeConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.deploy.v1.RuntimeConfig,
                com.google.cloud.deploy.v1.RuntimeConfig.Builder,
                com.google.cloud.deploy.v1.RuntimeConfigOrBuilder>(
                getRuntimeConfig(), getParentForChildren(), isClean());
        runtimeConfig_ = null;
      }
      return runtimeConfigBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.CanaryDeployment,
            com.google.cloud.deploy.v1.CanaryDeployment.Builder,
            com.google.cloud.deploy.v1.CanaryDeploymentOrBuilder>
        canaryDeploymentBuilder_;
    /**
     *
     *
     * <pre>
     * Configures the progressive based deployment for a Target.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.CanaryDeployment canary_deployment = 2;</code>
     *
     * @return Whether the canaryDeployment field is set.
     */
    @java.lang.Override
    public boolean hasCanaryDeployment() {
      return modeCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Configures the progressive based deployment for a Target.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.CanaryDeployment canary_deployment = 2;</code>
     *
     * @return The canaryDeployment.
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.CanaryDeployment getCanaryDeployment() {
      if (canaryDeploymentBuilder_ == null) {
        if (modeCase_ == 2) {
          return (com.google.cloud.deploy.v1.CanaryDeployment) mode_;
        }
        return com.google.cloud.deploy.v1.CanaryDeployment.getDefaultInstance();
      } else {
        if (modeCase_ == 2) {
          return canaryDeploymentBuilder_.getMessage();
        }
        return com.google.cloud.deploy.v1.CanaryDeployment.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Configures the progressive based deployment for a Target.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.CanaryDeployment canary_deployment = 2;</code>
     */
    public Builder setCanaryDeployment(com.google.cloud.deploy.v1.CanaryDeployment value) {
      if (canaryDeploymentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        mode_ = value;
        onChanged();
      } else {
        canaryDeploymentBuilder_.setMessage(value);
      }
      modeCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configures the progressive based deployment for a Target.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.CanaryDeployment canary_deployment = 2;</code>
     */
    public Builder setCanaryDeployment(
        com.google.cloud.deploy.v1.CanaryDeployment.Builder builderForValue) {
      if (canaryDeploymentBuilder_ == null) {
        mode_ = builderForValue.build();
        onChanged();
      } else {
        canaryDeploymentBuilder_.setMessage(builderForValue.build());
      }
      modeCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configures the progressive based deployment for a Target.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.CanaryDeployment canary_deployment = 2;</code>
     */
    public Builder mergeCanaryDeployment(com.google.cloud.deploy.v1.CanaryDeployment value) {
      if (canaryDeploymentBuilder_ == null) {
        if (modeCase_ == 2
            && mode_ != com.google.cloud.deploy.v1.CanaryDeployment.getDefaultInstance()) {
          mode_ =
              com.google.cloud.deploy.v1.CanaryDeployment.newBuilder(
                      (com.google.cloud.deploy.v1.CanaryDeployment) mode_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          mode_ = value;
        }
        onChanged();
      } else {
        if (modeCase_ == 2) {
          canaryDeploymentBuilder_.mergeFrom(value);
        } else {
          canaryDeploymentBuilder_.setMessage(value);
        }
      }
      modeCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configures the progressive based deployment for a Target.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.CanaryDeployment canary_deployment = 2;</code>
     */
    public Builder clearCanaryDeployment() {
      if (canaryDeploymentBuilder_ == null) {
        if (modeCase_ == 2) {
          modeCase_ = 0;
          mode_ = null;
          onChanged();
        }
      } else {
        if (modeCase_ == 2) {
          modeCase_ = 0;
          mode_ = null;
        }
        canaryDeploymentBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configures the progressive based deployment for a Target.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.CanaryDeployment canary_deployment = 2;</code>
     */
    public com.google.cloud.deploy.v1.CanaryDeployment.Builder getCanaryDeploymentBuilder() {
      return getCanaryDeploymentFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configures the progressive based deployment for a Target.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.CanaryDeployment canary_deployment = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.CanaryDeploymentOrBuilder getCanaryDeploymentOrBuilder() {
      if ((modeCase_ == 2) && (canaryDeploymentBuilder_ != null)) {
        return canaryDeploymentBuilder_.getMessageOrBuilder();
      } else {
        if (modeCase_ == 2) {
          return (com.google.cloud.deploy.v1.CanaryDeployment) mode_;
        }
        return com.google.cloud.deploy.v1.CanaryDeployment.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Configures the progressive based deployment for a Target.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.CanaryDeployment canary_deployment = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.CanaryDeployment,
            com.google.cloud.deploy.v1.CanaryDeployment.Builder,
            com.google.cloud.deploy.v1.CanaryDeploymentOrBuilder>
        getCanaryDeploymentFieldBuilder() {
      if (canaryDeploymentBuilder_ == null) {
        if (!(modeCase_ == 2)) {
          mode_ = com.google.cloud.deploy.v1.CanaryDeployment.getDefaultInstance();
        }
        canaryDeploymentBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.deploy.v1.CanaryDeployment,
                com.google.cloud.deploy.v1.CanaryDeployment.Builder,
                com.google.cloud.deploy.v1.CanaryDeploymentOrBuilder>(
                (com.google.cloud.deploy.v1.CanaryDeployment) mode_,
                getParentForChildren(),
                isClean());
        mode_ = null;
      }
      modeCase_ = 2;
      onChanged();
      return canaryDeploymentBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.CustomCanaryDeployment,
            com.google.cloud.deploy.v1.CustomCanaryDeployment.Builder,
            com.google.cloud.deploy.v1.CustomCanaryDeploymentOrBuilder>
        customCanaryDeploymentBuilder_;
    /**
     *
     *
     * <pre>
     * Configures the progressive based deployment for a Target, but allows
     * customizing at the phase level where a phase represents each of the
     * percentage deployments.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.CustomCanaryDeployment custom_canary_deployment = 3;</code>
     *
     * @return Whether the customCanaryDeployment field is set.
     */
    @java.lang.Override
    public boolean hasCustomCanaryDeployment() {
      return modeCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Configures the progressive based deployment for a Target, but allows
     * customizing at the phase level where a phase represents each of the
     * percentage deployments.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.CustomCanaryDeployment custom_canary_deployment = 3;</code>
     *
     * @return The customCanaryDeployment.
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.CustomCanaryDeployment getCustomCanaryDeployment() {
      if (customCanaryDeploymentBuilder_ == null) {
        if (modeCase_ == 3) {
          return (com.google.cloud.deploy.v1.CustomCanaryDeployment) mode_;
        }
        return com.google.cloud.deploy.v1.CustomCanaryDeployment.getDefaultInstance();
      } else {
        if (modeCase_ == 3) {
          return customCanaryDeploymentBuilder_.getMessage();
        }
        return com.google.cloud.deploy.v1.CustomCanaryDeployment.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Configures the progressive based deployment for a Target, but allows
     * customizing at the phase level where a phase represents each of the
     * percentage deployments.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.CustomCanaryDeployment custom_canary_deployment = 3;</code>
     */
    public Builder setCustomCanaryDeployment(
        com.google.cloud.deploy.v1.CustomCanaryDeployment value) {
      if (customCanaryDeploymentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        mode_ = value;
        onChanged();
      } else {
        customCanaryDeploymentBuilder_.setMessage(value);
      }
      modeCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configures the progressive based deployment for a Target, but allows
     * customizing at the phase level where a phase represents each of the
     * percentage deployments.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.CustomCanaryDeployment custom_canary_deployment = 3;</code>
     */
    public Builder setCustomCanaryDeployment(
        com.google.cloud.deploy.v1.CustomCanaryDeployment.Builder builderForValue) {
      if (customCanaryDeploymentBuilder_ == null) {
        mode_ = builderForValue.build();
        onChanged();
      } else {
        customCanaryDeploymentBuilder_.setMessage(builderForValue.build());
      }
      modeCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configures the progressive based deployment for a Target, but allows
     * customizing at the phase level where a phase represents each of the
     * percentage deployments.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.CustomCanaryDeployment custom_canary_deployment = 3;</code>
     */
    public Builder mergeCustomCanaryDeployment(
        com.google.cloud.deploy.v1.CustomCanaryDeployment value) {
      if (customCanaryDeploymentBuilder_ == null) {
        if (modeCase_ == 3
            && mode_ != com.google.cloud.deploy.v1.CustomCanaryDeployment.getDefaultInstance()) {
          mode_ =
              com.google.cloud.deploy.v1.CustomCanaryDeployment.newBuilder(
                      (com.google.cloud.deploy.v1.CustomCanaryDeployment) mode_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          mode_ = value;
        }
        onChanged();
      } else {
        if (modeCase_ == 3) {
          customCanaryDeploymentBuilder_.mergeFrom(value);
        } else {
          customCanaryDeploymentBuilder_.setMessage(value);
        }
      }
      modeCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configures the progressive based deployment for a Target, but allows
     * customizing at the phase level where a phase represents each of the
     * percentage deployments.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.CustomCanaryDeployment custom_canary_deployment = 3;</code>
     */
    public Builder clearCustomCanaryDeployment() {
      if (customCanaryDeploymentBuilder_ == null) {
        if (modeCase_ == 3) {
          modeCase_ = 0;
          mode_ = null;
          onChanged();
        }
      } else {
        if (modeCase_ == 3) {
          modeCase_ = 0;
          mode_ = null;
        }
        customCanaryDeploymentBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configures the progressive based deployment for a Target, but allows
     * customizing at the phase level where a phase represents each of the
     * percentage deployments.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.CustomCanaryDeployment custom_canary_deployment = 3;</code>
     */
    public com.google.cloud.deploy.v1.CustomCanaryDeployment.Builder
        getCustomCanaryDeploymentBuilder() {
      return getCustomCanaryDeploymentFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configures the progressive based deployment for a Target, but allows
     * customizing at the phase level where a phase represents each of the
     * percentage deployments.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.CustomCanaryDeployment custom_canary_deployment = 3;</code>
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.CustomCanaryDeploymentOrBuilder
        getCustomCanaryDeploymentOrBuilder() {
      if ((modeCase_ == 3) && (customCanaryDeploymentBuilder_ != null)) {
        return customCanaryDeploymentBuilder_.getMessageOrBuilder();
      } else {
        if (modeCase_ == 3) {
          return (com.google.cloud.deploy.v1.CustomCanaryDeployment) mode_;
        }
        return com.google.cloud.deploy.v1.CustomCanaryDeployment.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Configures the progressive based deployment for a Target, but allows
     * customizing at the phase level where a phase represents each of the
     * percentage deployments.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.CustomCanaryDeployment custom_canary_deployment = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.CustomCanaryDeployment,
            com.google.cloud.deploy.v1.CustomCanaryDeployment.Builder,
            com.google.cloud.deploy.v1.CustomCanaryDeploymentOrBuilder>
        getCustomCanaryDeploymentFieldBuilder() {
      if (customCanaryDeploymentBuilder_ == null) {
        if (!(modeCase_ == 3)) {
          mode_ = com.google.cloud.deploy.v1.CustomCanaryDeployment.getDefaultInstance();
        }
        customCanaryDeploymentBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.deploy.v1.CustomCanaryDeployment,
                com.google.cloud.deploy.v1.CustomCanaryDeployment.Builder,
                com.google.cloud.deploy.v1.CustomCanaryDeploymentOrBuilder>(
                (com.google.cloud.deploy.v1.CustomCanaryDeployment) mode_,
                getParentForChildren(),
                isClean());
        mode_ = null;
      }
      modeCase_ = 3;
      onChanged();
      return customCanaryDeploymentBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.deploy.v1.Canary)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.deploy.v1.Canary)
  private static final com.google.cloud.deploy.v1.Canary DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.deploy.v1.Canary();
  }

  public static com.google.cloud.deploy.v1.Canary getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Canary> PARSER =
      new com.google.protobuf.AbstractParser<Canary>() {
        @java.lang.Override
        public Canary parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Canary> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Canary> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.deploy.v1.Canary getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
