/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/deploy/v1/cloud_deploy.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.deploy.v1;

/**
 *
 *
 * <pre>
 * CloudRunMetadata contains information from a Cloud Run deployment.
 * </pre>
 *
 * Protobuf type {@code google.cloud.deploy.v1.CloudRunMetadata}
 */
public final class CloudRunMetadata extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.deploy.v1.CloudRunMetadata)
    CloudRunMetadataOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CloudRunMetadata.newBuilder() to construct.
  private CloudRunMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CloudRunMetadata() {
    service_ = "";
    serviceUrls_ = com.google.protobuf.LazyStringArrayList.emptyList();
    revision_ = "";
    job_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CloudRunMetadata();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.deploy.v1.CloudDeployProto
        .internal_static_google_cloud_deploy_v1_CloudRunMetadata_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.deploy.v1.CloudDeployProto
        .internal_static_google_cloud_deploy_v1_CloudRunMetadata_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.deploy.v1.CloudRunMetadata.class,
            com.google.cloud.deploy.v1.CloudRunMetadata.Builder.class);
  }

  public static final int SERVICE_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object service_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The name of the Cloud Run Service that is associated with a
   * `Rollout`. Format is
   * `projects/{project}/locations/{location}/services/{service}`.
   * </pre>
   *
   * <code>
   * string service = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The service.
   */
  @java.lang.Override
  public java.lang.String getService() {
    java.lang.Object ref = service_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      service_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The name of the Cloud Run Service that is associated with a
   * `Rollout`. Format is
   * `projects/{project}/locations/{location}/services/{service}`.
   * </pre>
   *
   * <code>
   * string service = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for service.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServiceBytes() {
    java.lang.Object ref = service_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      service_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SERVICE_URLS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList serviceUrls_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Output only. The Cloud Run Service urls that are associated with a
   * `Rollout`.
   * </pre>
   *
   * <code>repeated string service_urls = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return A list containing the serviceUrls.
   */
  public com.google.protobuf.ProtocolStringList getServiceUrlsList() {
    return serviceUrls_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The Cloud Run Service urls that are associated with a
   * `Rollout`.
   * </pre>
   *
   * <code>repeated string service_urls = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The count of serviceUrls.
   */
  public int getServiceUrlsCount() {
    return serviceUrls_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. The Cloud Run Service urls that are associated with a
   * `Rollout`.
   * </pre>
   *
   * <code>repeated string service_urls = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @param index The index of the element to return.
   * @return The serviceUrls at the given index.
   */
  public java.lang.String getServiceUrls(int index) {
    return serviceUrls_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. The Cloud Run Service urls that are associated with a
   * `Rollout`.
   * </pre>
   *
   * <code>repeated string service_urls = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the serviceUrls at the given index.
   */
  public com.google.protobuf.ByteString getServiceUrlsBytes(int index) {
    return serviceUrls_.getByteString(index);
  }

  public static final int REVISION_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object revision_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The Cloud Run Revision id associated with a `Rollout`.
   * </pre>
   *
   * <code>string revision = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The revision.
   */
  @java.lang.Override
  public java.lang.String getRevision() {
    java.lang.Object ref = revision_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      revision_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The Cloud Run Revision id associated with a `Rollout`.
   * </pre>
   *
   * <code>string revision = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for revision.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRevisionBytes() {
    java.lang.Object ref = revision_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      revision_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int JOB_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object job_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The name of the Cloud Run job that is associated with a
   * `Rollout`. Format is
   * `projects/{project}/locations/{location}/jobs/{job_name}`.
   * </pre>
   *
   * <code>
   * string job = 4 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The job.
   */
  @java.lang.Override
  public java.lang.String getJob() {
    java.lang.Object ref = job_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      job_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The name of the Cloud Run job that is associated with a
   * `Rollout`. Format is
   * `projects/{project}/locations/{location}/jobs/{job_name}`.
   * </pre>
   *
   * <code>
   * string job = 4 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for job.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getJobBytes() {
    java.lang.Object ref = job_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      job_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(service_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, service_);
    }
    for (int i = 0; i < serviceUrls_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, serviceUrls_.getRaw(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(revision_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, revision_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(job_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, job_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(service_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, service_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < serviceUrls_.size(); i++) {
        dataSize += computeStringSizeNoTag(serviceUrls_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getServiceUrlsList().size();
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(revision_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, revision_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(job_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, job_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.deploy.v1.CloudRunMetadata)) {
      return super.equals(obj);
    }
    com.google.cloud.deploy.v1.CloudRunMetadata other =
        (com.google.cloud.deploy.v1.CloudRunMetadata) obj;

    if (!getService().equals(other.getService())) return false;
    if (!getServiceUrlsList().equals(other.getServiceUrlsList())) return false;
    if (!getRevision().equals(other.getRevision())) return false;
    if (!getJob().equals(other.getJob())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SERVICE_FIELD_NUMBER;
    hash = (53 * hash) + getService().hashCode();
    if (getServiceUrlsCount() > 0) {
      hash = (37 * hash) + SERVICE_URLS_FIELD_NUMBER;
      hash = (53 * hash) + getServiceUrlsList().hashCode();
    }
    hash = (37 * hash) + REVISION_FIELD_NUMBER;
    hash = (53 * hash) + getRevision().hashCode();
    hash = (37 * hash) + JOB_FIELD_NUMBER;
    hash = (53 * hash) + getJob().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.deploy.v1.CloudRunMetadata parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.CloudRunMetadata parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.CloudRunMetadata parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.CloudRunMetadata parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.CloudRunMetadata parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.CloudRunMetadata parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.CloudRunMetadata parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.CloudRunMetadata parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.CloudRunMetadata parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.CloudRunMetadata parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.CloudRunMetadata parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.CloudRunMetadata parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.deploy.v1.CloudRunMetadata prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * CloudRunMetadata contains information from a Cloud Run deployment.
   * </pre>
   *
   * Protobuf type {@code google.cloud.deploy.v1.CloudRunMetadata}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.deploy.v1.CloudRunMetadata)
      com.google.cloud.deploy.v1.CloudRunMetadataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_CloudRunMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_CloudRunMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.deploy.v1.CloudRunMetadata.class,
              com.google.cloud.deploy.v1.CloudRunMetadata.Builder.class);
    }

    // Construct using com.google.cloud.deploy.v1.CloudRunMetadata.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      service_ = "";
      serviceUrls_ = com.google.protobuf.LazyStringArrayList.emptyList();
      revision_ = "";
      job_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_CloudRunMetadata_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.CloudRunMetadata getDefaultInstanceForType() {
      return com.google.cloud.deploy.v1.CloudRunMetadata.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.CloudRunMetadata build() {
      com.google.cloud.deploy.v1.CloudRunMetadata result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.CloudRunMetadata buildPartial() {
      com.google.cloud.deploy.v1.CloudRunMetadata result =
          new com.google.cloud.deploy.v1.CloudRunMetadata(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.deploy.v1.CloudRunMetadata result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.service_ = service_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        serviceUrls_.makeImmutable();
        result.serviceUrls_ = serviceUrls_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.revision_ = revision_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.job_ = job_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.deploy.v1.CloudRunMetadata) {
        return mergeFrom((com.google.cloud.deploy.v1.CloudRunMetadata) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.deploy.v1.CloudRunMetadata other) {
      if (other == com.google.cloud.deploy.v1.CloudRunMetadata.getDefaultInstance()) return this;
      if (!other.getService().isEmpty()) {
        service_ = other.service_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.serviceUrls_.isEmpty()) {
        if (serviceUrls_.isEmpty()) {
          serviceUrls_ = other.serviceUrls_;
          bitField0_ |= 0x00000002;
        } else {
          ensureServiceUrlsIsMutable();
          serviceUrls_.addAll(other.serviceUrls_);
        }
        onChanged();
      }
      if (!other.getRevision().isEmpty()) {
        revision_ = other.revision_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getJob().isEmpty()) {
        job_ = other.job_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                service_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureServiceUrlsIsMutable();
                serviceUrls_.add(s);
                break;
              } // case 18
            case 26:
              {
                revision_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                job_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object service_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The name of the Cloud Run Service that is associated with a
     * `Rollout`. Format is
     * `projects/{project}/locations/{location}/services/{service}`.
     * </pre>
     *
     * <code>
     * string service = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The service.
     */
    public java.lang.String getService() {
      java.lang.Object ref = service_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        service_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the Cloud Run Service that is associated with a
     * `Rollout`. Format is
     * `projects/{project}/locations/{location}/services/{service}`.
     * </pre>
     *
     * <code>
     * string service = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for service.
     */
    public com.google.protobuf.ByteString getServiceBytes() {
      java.lang.Object ref = service_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        service_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the Cloud Run Service that is associated with a
     * `Rollout`. Format is
     * `projects/{project}/locations/{location}/services/{service}`.
     * </pre>
     *
     * <code>
     * string service = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The service to set.
     * @return This builder for chaining.
     */
    public Builder setService(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      service_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the Cloud Run Service that is associated with a
     * `Rollout`. Format is
     * `projects/{project}/locations/{location}/services/{service}`.
     * </pre>
     *
     * <code>
     * string service = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearService() {
      service_ = getDefaultInstance().getService();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the Cloud Run Service that is associated with a
     * `Rollout`. Format is
     * `projects/{project}/locations/{location}/services/{service}`.
     * </pre>
     *
     * <code>
     * string service = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for service to set.
     * @return This builder for chaining.
     */
    public Builder setServiceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      service_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList serviceUrls_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureServiceUrlsIsMutable() {
      if (!serviceUrls_.isModifiable()) {
        serviceUrls_ = new com.google.protobuf.LazyStringArrayList(serviceUrls_);
      }
      bitField0_ |= 0x00000002;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Cloud Run Service urls that are associated with a
     * `Rollout`.
     * </pre>
     *
     * <code>repeated string service_urls = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return A list containing the serviceUrls.
     */
    public com.google.protobuf.ProtocolStringList getServiceUrlsList() {
      serviceUrls_.makeImmutable();
      return serviceUrls_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Cloud Run Service urls that are associated with a
     * `Rollout`.
     * </pre>
     *
     * <code>repeated string service_urls = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The count of serviceUrls.
     */
    public int getServiceUrlsCount() {
      return serviceUrls_.size();
    }
    /**
     *
     *
     * <pre>
     * Output only. The Cloud Run Service urls that are associated with a
     * `Rollout`.
     * </pre>
     *
     * <code>repeated string service_urls = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param index The index of the element to return.
     * @return The serviceUrls at the given index.
     */
    public java.lang.String getServiceUrls(int index) {
      return serviceUrls_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The Cloud Run Service urls that are associated with a
     * `Rollout`.
     * </pre>
     *
     * <code>repeated string service_urls = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the serviceUrls at the given index.
     */
    public com.google.protobuf.ByteString getServiceUrlsBytes(int index) {
      return serviceUrls_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The Cloud Run Service urls that are associated with a
     * `Rollout`.
     * </pre>
     *
     * <code>repeated string service_urls = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param index The index to set the value at.
     * @param value The serviceUrls to set.
     * @return This builder for chaining.
     */
    public Builder setServiceUrls(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureServiceUrlsIsMutable();
      serviceUrls_.set(index, value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Cloud Run Service urls that are associated with a
     * `Rollout`.
     * </pre>
     *
     * <code>repeated string service_urls = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The serviceUrls to add.
     * @return This builder for chaining.
     */
    public Builder addServiceUrls(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureServiceUrlsIsMutable();
      serviceUrls_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Cloud Run Service urls that are associated with a
     * `Rollout`.
     * </pre>
     *
     * <code>repeated string service_urls = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param values The serviceUrls to add.
     * @return This builder for chaining.
     */
    public Builder addAllServiceUrls(java.lang.Iterable<java.lang.String> values) {
      ensureServiceUrlsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, serviceUrls_);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Cloud Run Service urls that are associated with a
     * `Rollout`.
     * </pre>
     *
     * <code>repeated string service_urls = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServiceUrls() {
      serviceUrls_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Cloud Run Service urls that are associated with a
     * `Rollout`.
     * </pre>
     *
     * <code>repeated string service_urls = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes of the serviceUrls to add.
     * @return This builder for chaining.
     */
    public Builder addServiceUrlsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureServiceUrlsIsMutable();
      serviceUrls_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object revision_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The Cloud Run Revision id associated with a `Rollout`.
     * </pre>
     *
     * <code>string revision = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The revision.
     */
    public java.lang.String getRevision() {
      java.lang.Object ref = revision_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        revision_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The Cloud Run Revision id associated with a `Rollout`.
     * </pre>
     *
     * <code>string revision = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for revision.
     */
    public com.google.protobuf.ByteString getRevisionBytes() {
      java.lang.Object ref = revision_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        revision_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The Cloud Run Revision id associated with a `Rollout`.
     * </pre>
     *
     * <code>string revision = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The revision to set.
     * @return This builder for chaining.
     */
    public Builder setRevision(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      revision_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Cloud Run Revision id associated with a `Rollout`.
     * </pre>
     *
     * <code>string revision = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRevision() {
      revision_ = getDefaultInstance().getRevision();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Cloud Run Revision id associated with a `Rollout`.
     * </pre>
     *
     * <code>string revision = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for revision to set.
     * @return This builder for chaining.
     */
    public Builder setRevisionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      revision_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object job_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The name of the Cloud Run job that is associated with a
     * `Rollout`. Format is
     * `projects/{project}/locations/{location}/jobs/{job_name}`.
     * </pre>
     *
     * <code>
     * string job = 4 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The job.
     */
    public java.lang.String getJob() {
      java.lang.Object ref = job_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        job_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the Cloud Run job that is associated with a
     * `Rollout`. Format is
     * `projects/{project}/locations/{location}/jobs/{job_name}`.
     * </pre>
     *
     * <code>
     * string job = 4 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for job.
     */
    public com.google.protobuf.ByteString getJobBytes() {
      java.lang.Object ref = job_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        job_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the Cloud Run job that is associated with a
     * `Rollout`. Format is
     * `projects/{project}/locations/{location}/jobs/{job_name}`.
     * </pre>
     *
     * <code>
     * string job = 4 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The job to set.
     * @return This builder for chaining.
     */
    public Builder setJob(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      job_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the Cloud Run job that is associated with a
     * `Rollout`. Format is
     * `projects/{project}/locations/{location}/jobs/{job_name}`.
     * </pre>
     *
     * <code>
     * string job = 4 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearJob() {
      job_ = getDefaultInstance().getJob();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the Cloud Run job that is associated with a
     * `Rollout`. Format is
     * `projects/{project}/locations/{location}/jobs/{job_name}`.
     * </pre>
     *
     * <code>
     * string job = 4 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for job to set.
     * @return This builder for chaining.
     */
    public Builder setJobBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      job_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.deploy.v1.CloudRunMetadata)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.deploy.v1.CloudRunMetadata)
  private static final com.google.cloud.deploy.v1.CloudRunMetadata DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.deploy.v1.CloudRunMetadata();
  }

  public static com.google.cloud.deploy.v1.CloudRunMetadata getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CloudRunMetadata> PARSER =
      new com.google.protobuf.AbstractParser<CloudRunMetadata>() {
        @java.lang.Override
        public CloudRunMetadata parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CloudRunMetadata> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CloudRunMetadata> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.deploy.v1.CloudRunMetadata getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
