/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/deploy/v1/cloud_deploy.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.deploy.v1;

/**
 *
 *
 * <pre>
 * The request object for `CreateDeployPolicy`.
 * </pre>
 *
 * Protobuf type {@code google.cloud.deploy.v1.CreateDeployPolicyRequest}
 */
public final class CreateDeployPolicyRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.deploy.v1.CreateDeployPolicyRequest)
    CreateDeployPolicyRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CreateDeployPolicyRequest.newBuilder() to construct.
  private CreateDeployPolicyRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CreateDeployPolicyRequest() {
    parent_ = "";
    deployPolicyId_ = "";
    requestId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CreateDeployPolicyRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.deploy.v1.CloudDeployProto
        .internal_static_google_cloud_deploy_v1_CreateDeployPolicyRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.deploy.v1.CloudDeployProto
        .internal_static_google_cloud_deploy_v1_CreateDeployPolicyRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.deploy.v1.CreateDeployPolicyRequest.class,
            com.google.cloud.deploy.v1.CreateDeployPolicyRequest.Builder.class);
  }

  private int bitField0_;
  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";
  /**
   *
   *
   * <pre>
   * Required. The parent collection in which the `DeployPolicy` must be
   * created. The format is `projects/{project_id}/locations/{location_name}`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The parent collection in which the `DeployPolicy` must be
   * created. The format is `projects/{project_id}/locations/{location_name}`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DEPLOY_POLICY_ID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object deployPolicyId_ = "";
  /**
   *
   *
   * <pre>
   * Required. ID of the `DeployPolicy`.
   * </pre>
   *
   * <code>string deploy_policy_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The deployPolicyId.
   */
  @java.lang.Override
  public java.lang.String getDeployPolicyId() {
    java.lang.Object ref = deployPolicyId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      deployPolicyId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. ID of the `DeployPolicy`.
   * </pre>
   *
   * <code>string deploy_policy_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for deployPolicyId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDeployPolicyIdBytes() {
    java.lang.Object ref = deployPolicyId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      deployPolicyId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DEPLOY_POLICY_FIELD_NUMBER = 3;
  private com.google.cloud.deploy.v1.DeployPolicy deployPolicy_;
  /**
   *
   *
   * <pre>
   * Required. The `DeployPolicy` to create.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.DeployPolicy deploy_policy = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the deployPolicy field is set.
   */
  @java.lang.Override
  public boolean hasDeployPolicy() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Required. The `DeployPolicy` to create.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.DeployPolicy deploy_policy = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The deployPolicy.
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.DeployPolicy getDeployPolicy() {
    return deployPolicy_ == null
        ? com.google.cloud.deploy.v1.DeployPolicy.getDefaultInstance()
        : deployPolicy_;
  }
  /**
   *
   *
   * <pre>
   * Required. The `DeployPolicy` to create.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.DeployPolicy deploy_policy = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.DeployPolicyOrBuilder getDeployPolicyOrBuilder() {
    return deployPolicy_ == null
        ? com.google.cloud.deploy.v1.DeployPolicy.getDefaultInstance()
        : deployPolicy_;
  }

  public static final int REQUEST_ID_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object requestId_ = "";
  /**
   *
   *
   * <pre>
   * Optional. A request ID to identify requests. Specify a unique request ID
   * so that if you must retry your request, the server knows to ignore the
   * request if it has already been completed. The server guarantees that for
   * at least 60 minutes after the first request.
   *
   * For example, consider a situation where you make an initial request and the
   * request times out. If you make the request again with the same request ID,
   * the server can check if original operation with the same request ID was
   * received, and if so, will ignore the second request. This prevents clients
   * from accidentally creating duplicate commitments.
   *
   * The request ID must be a valid UUID with the exception that zero UUID is
   * not supported (00000000-0000-0000-0000-000000000000).
   * </pre>
   *
   * <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The requestId.
   */
  @java.lang.Override
  public java.lang.String getRequestId() {
    java.lang.Object ref = requestId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      requestId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. A request ID to identify requests. Specify a unique request ID
   * so that if you must retry your request, the server knows to ignore the
   * request if it has already been completed. The server guarantees that for
   * at least 60 minutes after the first request.
   *
   * For example, consider a situation where you make an initial request and the
   * request times out. If you make the request again with the same request ID,
   * the server can check if original operation with the same request ID was
   * received, and if so, will ignore the second request. This prevents clients
   * from accidentally creating duplicate commitments.
   *
   * The request ID must be a valid UUID with the exception that zero UUID is
   * not supported (00000000-0000-0000-0000-000000000000).
   * </pre>
   *
   * <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for requestId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRequestIdBytes() {
    java.lang.Object ref = requestId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      requestId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VALIDATE_ONLY_FIELD_NUMBER = 5;
  private boolean validateOnly_ = false;
  /**
   *
   *
   * <pre>
   * Optional. If set to true, the request is validated and the user is provided
   * with an expected result, but no actual change is made.
   * </pre>
   *
   * <code>bool validate_only = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The validateOnly.
   */
  @java.lang.Override
  public boolean getValidateOnly() {
    return validateOnly_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(deployPolicyId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, deployPolicyId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getDeployPolicy());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requestId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, requestId_);
    }
    if (validateOnly_ != false) {
      output.writeBool(5, validateOnly_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(deployPolicyId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, deployPolicyId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getDeployPolicy());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requestId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, requestId_);
    }
    if (validateOnly_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(5, validateOnly_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.deploy.v1.CreateDeployPolicyRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.deploy.v1.CreateDeployPolicyRequest other =
        (com.google.cloud.deploy.v1.CreateDeployPolicyRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (!getDeployPolicyId().equals(other.getDeployPolicyId())) return false;
    if (hasDeployPolicy() != other.hasDeployPolicy()) return false;
    if (hasDeployPolicy()) {
      if (!getDeployPolicy().equals(other.getDeployPolicy())) return false;
    }
    if (!getRequestId().equals(other.getRequestId())) return false;
    if (getValidateOnly() != other.getValidateOnly()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    hash = (37 * hash) + DEPLOY_POLICY_ID_FIELD_NUMBER;
    hash = (53 * hash) + getDeployPolicyId().hashCode();
    if (hasDeployPolicy()) {
      hash = (37 * hash) + DEPLOY_POLICY_FIELD_NUMBER;
      hash = (53 * hash) + getDeployPolicy().hashCode();
    }
    hash = (37 * hash) + REQUEST_ID_FIELD_NUMBER;
    hash = (53 * hash) + getRequestId().hashCode();
    hash = (37 * hash) + VALIDATE_ONLY_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getValidateOnly());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.deploy.v1.CreateDeployPolicyRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.CreateDeployPolicyRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.CreateDeployPolicyRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.CreateDeployPolicyRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.CreateDeployPolicyRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.CreateDeployPolicyRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.CreateDeployPolicyRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.CreateDeployPolicyRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.CreateDeployPolicyRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.CreateDeployPolicyRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.CreateDeployPolicyRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.CreateDeployPolicyRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.deploy.v1.CreateDeployPolicyRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The request object for `CreateDeployPolicy`.
   * </pre>
   *
   * Protobuf type {@code google.cloud.deploy.v1.CreateDeployPolicyRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.deploy.v1.CreateDeployPolicyRequest)
      com.google.cloud.deploy.v1.CreateDeployPolicyRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_CreateDeployPolicyRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_CreateDeployPolicyRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.deploy.v1.CreateDeployPolicyRequest.class,
              com.google.cloud.deploy.v1.CreateDeployPolicyRequest.Builder.class);
    }

    // Construct using com.google.cloud.deploy.v1.CreateDeployPolicyRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getDeployPolicyFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      parent_ = "";
      deployPolicyId_ = "";
      deployPolicy_ = null;
      if (deployPolicyBuilder_ != null) {
        deployPolicyBuilder_.dispose();
        deployPolicyBuilder_ = null;
      }
      requestId_ = "";
      validateOnly_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_CreateDeployPolicyRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.CreateDeployPolicyRequest getDefaultInstanceForType() {
      return com.google.cloud.deploy.v1.CreateDeployPolicyRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.CreateDeployPolicyRequest build() {
      com.google.cloud.deploy.v1.CreateDeployPolicyRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.CreateDeployPolicyRequest buildPartial() {
      com.google.cloud.deploy.v1.CreateDeployPolicyRequest result =
          new com.google.cloud.deploy.v1.CreateDeployPolicyRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.deploy.v1.CreateDeployPolicyRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.parent_ = parent_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.deployPolicyId_ = deployPolicyId_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.deployPolicy_ =
            deployPolicyBuilder_ == null ? deployPolicy_ : deployPolicyBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.requestId_ = requestId_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.validateOnly_ = validateOnly_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.deploy.v1.CreateDeployPolicyRequest) {
        return mergeFrom((com.google.cloud.deploy.v1.CreateDeployPolicyRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.deploy.v1.CreateDeployPolicyRequest other) {
      if (other == com.google.cloud.deploy.v1.CreateDeployPolicyRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDeployPolicyId().isEmpty()) {
        deployPolicyId_ = other.deployPolicyId_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasDeployPolicy()) {
        mergeDeployPolicy(other.getDeployPolicy());
      }
      if (!other.getRequestId().isEmpty()) {
        requestId_ = other.requestId_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.getValidateOnly() != false) {
        setValidateOnly(other.getValidateOnly());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                deployPolicyId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getDeployPolicyFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                requestId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 40:
              {
                validateOnly_ = input.readBool();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. The parent collection in which the `DeployPolicy` must be
     * created. The format is `projects/{project_id}/locations/{location_name}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The parent collection in which the `DeployPolicy` must be
     * created. The format is `projects/{project_id}/locations/{location_name}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The parent collection in which the `DeployPolicy` must be
     * created. The format is `projects/{project_id}/locations/{location_name}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The parent collection in which the `DeployPolicy` must be
     * created. The format is `projects/{project_id}/locations/{location_name}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The parent collection in which the `DeployPolicy` must be
     * created. The format is `projects/{project_id}/locations/{location_name}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object deployPolicyId_ = "";
    /**
     *
     *
     * <pre>
     * Required. ID of the `DeployPolicy`.
     * </pre>
     *
     * <code>string deploy_policy_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The deployPolicyId.
     */
    public java.lang.String getDeployPolicyId() {
      java.lang.Object ref = deployPolicyId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        deployPolicyId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. ID of the `DeployPolicy`.
     * </pre>
     *
     * <code>string deploy_policy_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for deployPolicyId.
     */
    public com.google.protobuf.ByteString getDeployPolicyIdBytes() {
      java.lang.Object ref = deployPolicyId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        deployPolicyId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. ID of the `DeployPolicy`.
     * </pre>
     *
     * <code>string deploy_policy_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The deployPolicyId to set.
     * @return This builder for chaining.
     */
    public Builder setDeployPolicyId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      deployPolicyId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. ID of the `DeployPolicy`.
     * </pre>
     *
     * <code>string deploy_policy_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDeployPolicyId() {
      deployPolicyId_ = getDefaultInstance().getDeployPolicyId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. ID of the `DeployPolicy`.
     * </pre>
     *
     * <code>string deploy_policy_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for deployPolicyId to set.
     * @return This builder for chaining.
     */
    public Builder setDeployPolicyIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      deployPolicyId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.cloud.deploy.v1.DeployPolicy deployPolicy_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.DeployPolicy,
            com.google.cloud.deploy.v1.DeployPolicy.Builder,
            com.google.cloud.deploy.v1.DeployPolicyOrBuilder>
        deployPolicyBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The `DeployPolicy` to create.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.DeployPolicy deploy_policy = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the deployPolicy field is set.
     */
    public boolean hasDeployPolicy() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. The `DeployPolicy` to create.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.DeployPolicy deploy_policy = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The deployPolicy.
     */
    public com.google.cloud.deploy.v1.DeployPolicy getDeployPolicy() {
      if (deployPolicyBuilder_ == null) {
        return deployPolicy_ == null
            ? com.google.cloud.deploy.v1.DeployPolicy.getDefaultInstance()
            : deployPolicy_;
      } else {
        return deployPolicyBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The `DeployPolicy` to create.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.DeployPolicy deploy_policy = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setDeployPolicy(com.google.cloud.deploy.v1.DeployPolicy value) {
      if (deployPolicyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        deployPolicy_ = value;
      } else {
        deployPolicyBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The `DeployPolicy` to create.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.DeployPolicy deploy_policy = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setDeployPolicy(
        com.google.cloud.deploy.v1.DeployPolicy.Builder builderForValue) {
      if (deployPolicyBuilder_ == null) {
        deployPolicy_ = builderForValue.build();
      } else {
        deployPolicyBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The `DeployPolicy` to create.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.DeployPolicy deploy_policy = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeDeployPolicy(com.google.cloud.deploy.v1.DeployPolicy value) {
      if (deployPolicyBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && deployPolicy_ != null
            && deployPolicy_ != com.google.cloud.deploy.v1.DeployPolicy.getDefaultInstance()) {
          getDeployPolicyBuilder().mergeFrom(value);
        } else {
          deployPolicy_ = value;
        }
      } else {
        deployPolicyBuilder_.mergeFrom(value);
      }
      if (deployPolicy_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The `DeployPolicy` to create.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.DeployPolicy deploy_policy = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearDeployPolicy() {
      bitField0_ = (bitField0_ & ~0x00000004);
      deployPolicy_ = null;
      if (deployPolicyBuilder_ != null) {
        deployPolicyBuilder_.dispose();
        deployPolicyBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The `DeployPolicy` to create.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.DeployPolicy deploy_policy = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.deploy.v1.DeployPolicy.Builder getDeployPolicyBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getDeployPolicyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The `DeployPolicy` to create.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.DeployPolicy deploy_policy = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.deploy.v1.DeployPolicyOrBuilder getDeployPolicyOrBuilder() {
      if (deployPolicyBuilder_ != null) {
        return deployPolicyBuilder_.getMessageOrBuilder();
      } else {
        return deployPolicy_ == null
            ? com.google.cloud.deploy.v1.DeployPolicy.getDefaultInstance()
            : deployPolicy_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The `DeployPolicy` to create.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.DeployPolicy deploy_policy = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.DeployPolicy,
            com.google.cloud.deploy.v1.DeployPolicy.Builder,
            com.google.cloud.deploy.v1.DeployPolicyOrBuilder>
        getDeployPolicyFieldBuilder() {
      if (deployPolicyBuilder_ == null) {
        deployPolicyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.deploy.v1.DeployPolicy,
                com.google.cloud.deploy.v1.DeployPolicy.Builder,
                com.google.cloud.deploy.v1.DeployPolicyOrBuilder>(
                getDeployPolicy(), getParentForChildren(), isClean());
        deployPolicy_ = null;
      }
      return deployPolicyBuilder_;
    }

    private java.lang.Object requestId_ = "";
    /**
     *
     *
     * <pre>
     * Optional. A request ID to identify requests. Specify a unique request ID
     * so that if you must retry your request, the server knows to ignore the
     * request if it has already been completed. The server guarantees that for
     * at least 60 minutes after the first request.
     *
     * For example, consider a situation where you make an initial request and the
     * request times out. If you make the request again with the same request ID,
     * the server can check if original operation with the same request ID was
     * received, and if so, will ignore the second request. This prevents clients
     * from accidentally creating duplicate commitments.
     *
     * The request ID must be a valid UUID with the exception that zero UUID is
     * not supported (00000000-0000-0000-0000-000000000000).
     * </pre>
     *
     * <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The requestId.
     */
    public java.lang.String getRequestId() {
      java.lang.Object ref = requestId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        requestId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A request ID to identify requests. Specify a unique request ID
     * so that if you must retry your request, the server knows to ignore the
     * request if it has already been completed. The server guarantees that for
     * at least 60 minutes after the first request.
     *
     * For example, consider a situation where you make an initial request and the
     * request times out. If you make the request again with the same request ID,
     * the server can check if original operation with the same request ID was
     * received, and if so, will ignore the second request. This prevents clients
     * from accidentally creating duplicate commitments.
     *
     * The request ID must be a valid UUID with the exception that zero UUID is
     * not supported (00000000-0000-0000-0000-000000000000).
     * </pre>
     *
     * <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for requestId.
     */
    public com.google.protobuf.ByteString getRequestIdBytes() {
      java.lang.Object ref = requestId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        requestId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A request ID to identify requests. Specify a unique request ID
     * so that if you must retry your request, the server knows to ignore the
     * request if it has already been completed. The server guarantees that for
     * at least 60 minutes after the first request.
     *
     * For example, consider a situation where you make an initial request and the
     * request times out. If you make the request again with the same request ID,
     * the server can check if original operation with the same request ID was
     * received, and if so, will ignore the second request. This prevents clients
     * from accidentally creating duplicate commitments.
     *
     * The request ID must be a valid UUID with the exception that zero UUID is
     * not supported (00000000-0000-0000-0000-000000000000).
     * </pre>
     *
     * <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The requestId to set.
     * @return This builder for chaining.
     */
    public Builder setRequestId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      requestId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A request ID to identify requests. Specify a unique request ID
     * so that if you must retry your request, the server knows to ignore the
     * request if it has already been completed. The server guarantees that for
     * at least 60 minutes after the first request.
     *
     * For example, consider a situation where you make an initial request and the
     * request times out. If you make the request again with the same request ID,
     * the server can check if original operation with the same request ID was
     * received, and if so, will ignore the second request. This prevents clients
     * from accidentally creating duplicate commitments.
     *
     * The request ID must be a valid UUID with the exception that zero UUID is
     * not supported (00000000-0000-0000-0000-000000000000).
     * </pre>
     *
     * <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRequestId() {
      requestId_ = getDefaultInstance().getRequestId();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A request ID to identify requests. Specify a unique request ID
     * so that if you must retry your request, the server knows to ignore the
     * request if it has already been completed. The server guarantees that for
     * at least 60 minutes after the first request.
     *
     * For example, consider a situation where you make an initial request and the
     * request times out. If you make the request again with the same request ID,
     * the server can check if original operation with the same request ID was
     * received, and if so, will ignore the second request. This prevents clients
     * from accidentally creating duplicate commitments.
     *
     * The request ID must be a valid UUID with the exception that zero UUID is
     * not supported (00000000-0000-0000-0000-000000000000).
     * </pre>
     *
     * <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for requestId to set.
     * @return This builder for chaining.
     */
    public Builder setRequestIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      requestId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private boolean validateOnly_;
    /**
     *
     *
     * <pre>
     * Optional. If set to true, the request is validated and the user is provided
     * with an expected result, but no actual change is made.
     * </pre>
     *
     * <code>bool validate_only = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The validateOnly.
     */
    @java.lang.Override
    public boolean getValidateOnly() {
      return validateOnly_;
    }
    /**
     *
     *
     * <pre>
     * Optional. If set to true, the request is validated and the user is provided
     * with an expected result, but no actual change is made.
     * </pre>
     *
     * <code>bool validate_only = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The validateOnly to set.
     * @return This builder for chaining.
     */
    public Builder setValidateOnly(boolean value) {

      validateOnly_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If set to true, the request is validated and the user is provided
     * with an expected result, but no actual change is made.
     * </pre>
     *
     * <code>bool validate_only = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearValidateOnly() {
      bitField0_ = (bitField0_ & ~0x00000010);
      validateOnly_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.deploy.v1.CreateDeployPolicyRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.deploy.v1.CreateDeployPolicyRequest)
  private static final com.google.cloud.deploy.v1.CreateDeployPolicyRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.deploy.v1.CreateDeployPolicyRequest();
  }

  public static com.google.cloud.deploy.v1.CreateDeployPolicyRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CreateDeployPolicyRequest> PARSER =
      new com.google.protobuf.AbstractParser<CreateDeployPolicyRequest>() {
        @java.lang.Override
        public CreateDeployPolicyRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CreateDeployPolicyRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CreateDeployPolicyRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.deploy.v1.CreateDeployPolicyRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
