/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/deploy/v1/cloud_deploy.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.deploy.v1;

/**
 *
 *
 * <pre>
 * CustomCanaryDeployment represents the custom canary deployment
 * configuration.
 * </pre>
 *
 * Protobuf type {@code google.cloud.deploy.v1.CustomCanaryDeployment}
 */
public final class CustomCanaryDeployment extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.deploy.v1.CustomCanaryDeployment)
    CustomCanaryDeploymentOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CustomCanaryDeployment.newBuilder() to construct.
  private CustomCanaryDeployment(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CustomCanaryDeployment() {
    phaseConfigs_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CustomCanaryDeployment();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.deploy.v1.CloudDeployProto
        .internal_static_google_cloud_deploy_v1_CustomCanaryDeployment_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.deploy.v1.CloudDeployProto
        .internal_static_google_cloud_deploy_v1_CustomCanaryDeployment_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.deploy.v1.CustomCanaryDeployment.class,
            com.google.cloud.deploy.v1.CustomCanaryDeployment.Builder.class);
  }

  public interface PhaseConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The ID to assign to the `Rollout` phase.
     * This value must consist of lower-case letters, numbers, and hyphens,
     * start with a letter and end with a letter or a number, and have a max
     * length of 63 characters. In other words, it must match the following
     * regex: `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
     * </pre>
     *
     * <code>string phase_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The phaseId.
     */
    java.lang.String getPhaseId();
    /**
     *
     *
     * <pre>
     * Required. The ID to assign to the `Rollout` phase.
     * This value must consist of lower-case letters, numbers, and hyphens,
     * start with a letter and end with a letter or a number, and have a max
     * length of 63 characters. In other words, it must match the following
     * regex: `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
     * </pre>
     *
     * <code>string phase_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for phaseId.
     */
    com.google.protobuf.ByteString getPhaseIdBytes();

    /**
     *
     *
     * <pre>
     * Required. Percentage deployment for the phase.
     * </pre>
     *
     * <code>int32 percentage = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The percentage.
     */
    int getPercentage();

    /**
     *
     *
     * <pre>
     * Skaffold profiles to use when rendering the manifest for this phase.
     * These are in addition to the profiles list specified in the
     * `DeliveryPipeline` stage.
     * </pre>
     *
     * <code>repeated string profiles = 3;</code>
     *
     * @return A list containing the profiles.
     */
    java.util.List<java.lang.String> getProfilesList();
    /**
     *
     *
     * <pre>
     * Skaffold profiles to use when rendering the manifest for this phase.
     * These are in addition to the profiles list specified in the
     * `DeliveryPipeline` stage.
     * </pre>
     *
     * <code>repeated string profiles = 3;</code>
     *
     * @return The count of profiles.
     */
    int getProfilesCount();
    /**
     *
     *
     * <pre>
     * Skaffold profiles to use when rendering the manifest for this phase.
     * These are in addition to the profiles list specified in the
     * `DeliveryPipeline` stage.
     * </pre>
     *
     * <code>repeated string profiles = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The profiles at the given index.
     */
    java.lang.String getProfiles(int index);
    /**
     *
     *
     * <pre>
     * Skaffold profiles to use when rendering the manifest for this phase.
     * These are in addition to the profiles list specified in the
     * `DeliveryPipeline` stage.
     * </pre>
     *
     * <code>repeated string profiles = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the profiles at the given index.
     */
    com.google.protobuf.ByteString getProfilesBytes(int index);

    /**
     *
     *
     * <pre>
     * Whether to run verify tests after the deployment.
     * </pre>
     *
     * <code>bool verify = 4;</code>
     *
     * @return The verify.
     */
    boolean getVerify();

    /**
     *
     *
     * <pre>
     * Optional. Configuration for the predeploy job of this phase. If this is
     * not configured, there will be no predeploy job for this phase.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Predeploy predeploy = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the predeploy field is set.
     */
    boolean hasPredeploy();
    /**
     *
     *
     * <pre>
     * Optional. Configuration for the predeploy job of this phase. If this is
     * not configured, there will be no predeploy job for this phase.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Predeploy predeploy = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The predeploy.
     */
    com.google.cloud.deploy.v1.Predeploy getPredeploy();
    /**
     *
     *
     * <pre>
     * Optional. Configuration for the predeploy job of this phase. If this is
     * not configured, there will be no predeploy job for this phase.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Predeploy predeploy = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.deploy.v1.PredeployOrBuilder getPredeployOrBuilder();

    /**
     *
     *
     * <pre>
     * Optional. Configuration for the postdeploy job of this phase. If this is
     * not configured, there will be no postdeploy job for this phase.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Postdeploy postdeploy = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the postdeploy field is set.
     */
    boolean hasPostdeploy();
    /**
     *
     *
     * <pre>
     * Optional. Configuration for the postdeploy job of this phase. If this is
     * not configured, there will be no postdeploy job for this phase.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Postdeploy postdeploy = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The postdeploy.
     */
    com.google.cloud.deploy.v1.Postdeploy getPostdeploy();
    /**
     *
     *
     * <pre>
     * Optional. Configuration for the postdeploy job of this phase. If this is
     * not configured, there will be no postdeploy job for this phase.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Postdeploy postdeploy = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.deploy.v1.PostdeployOrBuilder getPostdeployOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * PhaseConfig represents the configuration for a phase in the custom
   * canary deployment.
   * </pre>
   *
   * Protobuf type {@code google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig}
   */
  public static final class PhaseConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig)
      PhaseConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use PhaseConfig.newBuilder() to construct.
    private PhaseConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private PhaseConfig() {
      phaseId_ = "";
      profiles_ = com.google.protobuf.LazyStringArrayList.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new PhaseConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_CustomCanaryDeployment_PhaseConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_CustomCanaryDeployment_PhaseConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig.class,
              com.google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig.Builder.class);
    }

    private int bitField0_;
    public static final int PHASE_ID_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object phaseId_ = "";
    /**
     *
     *
     * <pre>
     * Required. The ID to assign to the `Rollout` phase.
     * This value must consist of lower-case letters, numbers, and hyphens,
     * start with a letter and end with a letter or a number, and have a max
     * length of 63 characters. In other words, it must match the following
     * regex: `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
     * </pre>
     *
     * <code>string phase_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The phaseId.
     */
    @java.lang.Override
    public java.lang.String getPhaseId() {
      java.lang.Object ref = phaseId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        phaseId_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The ID to assign to the `Rollout` phase.
     * This value must consist of lower-case letters, numbers, and hyphens,
     * start with a letter and end with a letter or a number, and have a max
     * length of 63 characters. In other words, it must match the following
     * regex: `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
     * </pre>
     *
     * <code>string phase_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for phaseId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPhaseIdBytes() {
      java.lang.Object ref = phaseId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        phaseId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PERCENTAGE_FIELD_NUMBER = 2;
    private int percentage_ = 0;
    /**
     *
     *
     * <pre>
     * Required. Percentage deployment for the phase.
     * </pre>
     *
     * <code>int32 percentage = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The percentage.
     */
    @java.lang.Override
    public int getPercentage() {
      return percentage_;
    }

    public static final int PROFILES_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList profiles_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * Skaffold profiles to use when rendering the manifest for this phase.
     * These are in addition to the profiles list specified in the
     * `DeliveryPipeline` stage.
     * </pre>
     *
     * <code>repeated string profiles = 3;</code>
     *
     * @return A list containing the profiles.
     */
    public com.google.protobuf.ProtocolStringList getProfilesList() {
      return profiles_;
    }
    /**
     *
     *
     * <pre>
     * Skaffold profiles to use when rendering the manifest for this phase.
     * These are in addition to the profiles list specified in the
     * `DeliveryPipeline` stage.
     * </pre>
     *
     * <code>repeated string profiles = 3;</code>
     *
     * @return The count of profiles.
     */
    public int getProfilesCount() {
      return profiles_.size();
    }
    /**
     *
     *
     * <pre>
     * Skaffold profiles to use when rendering the manifest for this phase.
     * These are in addition to the profiles list specified in the
     * `DeliveryPipeline` stage.
     * </pre>
     *
     * <code>repeated string profiles = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The profiles at the given index.
     */
    public java.lang.String getProfiles(int index) {
      return profiles_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Skaffold profiles to use when rendering the manifest for this phase.
     * These are in addition to the profiles list specified in the
     * `DeliveryPipeline` stage.
     * </pre>
     *
     * <code>repeated string profiles = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the profiles at the given index.
     */
    public com.google.protobuf.ByteString getProfilesBytes(int index) {
      return profiles_.getByteString(index);
    }

    public static final int VERIFY_FIELD_NUMBER = 4;
    private boolean verify_ = false;
    /**
     *
     *
     * <pre>
     * Whether to run verify tests after the deployment.
     * </pre>
     *
     * <code>bool verify = 4;</code>
     *
     * @return The verify.
     */
    @java.lang.Override
    public boolean getVerify() {
      return verify_;
    }

    public static final int PREDEPLOY_FIELD_NUMBER = 5;
    private com.google.cloud.deploy.v1.Predeploy predeploy_;
    /**
     *
     *
     * <pre>
     * Optional. Configuration for the predeploy job of this phase. If this is
     * not configured, there will be no predeploy job for this phase.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Predeploy predeploy = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the predeploy field is set.
     */
    @java.lang.Override
    public boolean hasPredeploy() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration for the predeploy job of this phase. If this is
     * not configured, there will be no predeploy job for this phase.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Predeploy predeploy = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The predeploy.
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.Predeploy getPredeploy() {
      return predeploy_ == null
          ? com.google.cloud.deploy.v1.Predeploy.getDefaultInstance()
          : predeploy_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration for the predeploy job of this phase. If this is
     * not configured, there will be no predeploy job for this phase.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Predeploy predeploy = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.PredeployOrBuilder getPredeployOrBuilder() {
      return predeploy_ == null
          ? com.google.cloud.deploy.v1.Predeploy.getDefaultInstance()
          : predeploy_;
    }

    public static final int POSTDEPLOY_FIELD_NUMBER = 6;
    private com.google.cloud.deploy.v1.Postdeploy postdeploy_;
    /**
     *
     *
     * <pre>
     * Optional. Configuration for the postdeploy job of this phase. If this is
     * not configured, there will be no postdeploy job for this phase.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Postdeploy postdeploy = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the postdeploy field is set.
     */
    @java.lang.Override
    public boolean hasPostdeploy() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration for the postdeploy job of this phase. If this is
     * not configured, there will be no postdeploy job for this phase.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Postdeploy postdeploy = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The postdeploy.
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.Postdeploy getPostdeploy() {
      return postdeploy_ == null
          ? com.google.cloud.deploy.v1.Postdeploy.getDefaultInstance()
          : postdeploy_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration for the postdeploy job of this phase. If this is
     * not configured, there will be no postdeploy job for this phase.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Postdeploy postdeploy = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.PostdeployOrBuilder getPostdeployOrBuilder() {
      return postdeploy_ == null
          ? com.google.cloud.deploy.v1.Postdeploy.getDefaultInstance()
          : postdeploy_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(phaseId_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, phaseId_);
      }
      if (percentage_ != 0) {
        output.writeInt32(2, percentage_);
      }
      for (int i = 0; i < profiles_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, profiles_.getRaw(i));
      }
      if (verify_ != false) {
        output.writeBool(4, verify_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(5, getPredeploy());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(6, getPostdeploy());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(phaseId_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, phaseId_);
      }
      if (percentage_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, percentage_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < profiles_.size(); i++) {
          dataSize += computeStringSizeNoTag(profiles_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getProfilesList().size();
      }
      if (verify_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, verify_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getPredeploy());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getPostdeploy());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig other =
          (com.google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig) obj;

      if (!getPhaseId().equals(other.getPhaseId())) return false;
      if (getPercentage() != other.getPercentage()) return false;
      if (!getProfilesList().equals(other.getProfilesList())) return false;
      if (getVerify() != other.getVerify()) return false;
      if (hasPredeploy() != other.hasPredeploy()) return false;
      if (hasPredeploy()) {
        if (!getPredeploy().equals(other.getPredeploy())) return false;
      }
      if (hasPostdeploy() != other.hasPostdeploy()) return false;
      if (hasPostdeploy()) {
        if (!getPostdeploy().equals(other.getPostdeploy())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + PHASE_ID_FIELD_NUMBER;
      hash = (53 * hash) + getPhaseId().hashCode();
      hash = (37 * hash) + PERCENTAGE_FIELD_NUMBER;
      hash = (53 * hash) + getPercentage();
      if (getProfilesCount() > 0) {
        hash = (37 * hash) + PROFILES_FIELD_NUMBER;
        hash = (53 * hash) + getProfilesList().hashCode();
      }
      hash = (37 * hash) + VERIFY_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getVerify());
      if (hasPredeploy()) {
        hash = (37 * hash) + PREDEPLOY_FIELD_NUMBER;
        hash = (53 * hash) + getPredeploy().hashCode();
      }
      if (hasPostdeploy()) {
        hash = (37 * hash) + POSTDEPLOY_FIELD_NUMBER;
        hash = (53 * hash) + getPostdeploy().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * PhaseConfig represents the configuration for a phase in the custom
     * canary deployment.
     * </pre>
     *
     * Protobuf type {@code google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig)
        com.google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.deploy.v1.CloudDeployProto
            .internal_static_google_cloud_deploy_v1_CustomCanaryDeployment_PhaseConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.deploy.v1.CloudDeployProto
            .internal_static_google_cloud_deploy_v1_CustomCanaryDeployment_PhaseConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig.class,
                com.google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig.Builder.class);
      }

      // Construct using com.google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getPredeployFieldBuilder();
          getPostdeployFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        phaseId_ = "";
        percentage_ = 0;
        profiles_ = com.google.protobuf.LazyStringArrayList.emptyList();
        verify_ = false;
        predeploy_ = null;
        if (predeployBuilder_ != null) {
          predeployBuilder_.dispose();
          predeployBuilder_ = null;
        }
        postdeploy_ = null;
        if (postdeployBuilder_ != null) {
          postdeployBuilder_.dispose();
          postdeployBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.deploy.v1.CloudDeployProto
            .internal_static_google_cloud_deploy_v1_CustomCanaryDeployment_PhaseConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig
          getDefaultInstanceForType() {
        return com.google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig build() {
        com.google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig buildPartial() {
        com.google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig result =
            new com.google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.phaseId_ = phaseId_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.percentage_ = percentage_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          profiles_.makeImmutable();
          result.profiles_ = profiles_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.verify_ = verify_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.predeploy_ = predeployBuilder_ == null ? predeploy_ : predeployBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.postdeploy_ =
              postdeployBuilder_ == null ? postdeploy_ : postdeployBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig) {
          return mergeFrom((com.google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig other) {
        if (other
            == com.google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig.getDefaultInstance())
          return this;
        if (!other.getPhaseId().isEmpty()) {
          phaseId_ = other.phaseId_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.getPercentage() != 0) {
          setPercentage(other.getPercentage());
        }
        if (!other.profiles_.isEmpty()) {
          if (profiles_.isEmpty()) {
            profiles_ = other.profiles_;
            bitField0_ |= 0x00000004;
          } else {
            ensureProfilesIsMutable();
            profiles_.addAll(other.profiles_);
          }
          onChanged();
        }
        if (other.getVerify() != false) {
          setVerify(other.getVerify());
        }
        if (other.hasPredeploy()) {
          mergePredeploy(other.getPredeploy());
        }
        if (other.hasPostdeploy()) {
          mergePostdeploy(other.getPostdeploy());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  phaseId_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 16:
                {
                  percentage_ = input.readInt32();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 26:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureProfilesIsMutable();
                  profiles_.add(s);
                  break;
                } // case 26
              case 32:
                {
                  verify_ = input.readBool();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 32
              case 42:
                {
                  input.readMessage(getPredeployFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000010;
                  break;
                } // case 42
              case 50:
                {
                  input.readMessage(getPostdeployFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000020;
                  break;
                } // case 50
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object phaseId_ = "";
      /**
       *
       *
       * <pre>
       * Required. The ID to assign to the `Rollout` phase.
       * This value must consist of lower-case letters, numbers, and hyphens,
       * start with a letter and end with a letter or a number, and have a max
       * length of 63 characters. In other words, it must match the following
       * regex: `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
       * </pre>
       *
       * <code>string phase_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The phaseId.
       */
      public java.lang.String getPhaseId() {
        java.lang.Object ref = phaseId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          phaseId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The ID to assign to the `Rollout` phase.
       * This value must consist of lower-case letters, numbers, and hyphens,
       * start with a letter and end with a letter or a number, and have a max
       * length of 63 characters. In other words, it must match the following
       * regex: `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
       * </pre>
       *
       * <code>string phase_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for phaseId.
       */
      public com.google.protobuf.ByteString getPhaseIdBytes() {
        java.lang.Object ref = phaseId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          phaseId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The ID to assign to the `Rollout` phase.
       * This value must consist of lower-case letters, numbers, and hyphens,
       * start with a letter and end with a letter or a number, and have a max
       * length of 63 characters. In other words, it must match the following
       * regex: `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
       * </pre>
       *
       * <code>string phase_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The phaseId to set.
       * @return This builder for chaining.
       */
      public Builder setPhaseId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        phaseId_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The ID to assign to the `Rollout` phase.
       * This value must consist of lower-case letters, numbers, and hyphens,
       * start with a letter and end with a letter or a number, and have a max
       * length of 63 characters. In other words, it must match the following
       * regex: `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
       * </pre>
       *
       * <code>string phase_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPhaseId() {
        phaseId_ = getDefaultInstance().getPhaseId();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The ID to assign to the `Rollout` phase.
       * This value must consist of lower-case letters, numbers, and hyphens,
       * start with a letter and end with a letter or a number, and have a max
       * length of 63 characters. In other words, it must match the following
       * regex: `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
       * </pre>
       *
       * <code>string phase_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for phaseId to set.
       * @return This builder for chaining.
       */
      public Builder setPhaseIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        phaseId_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private int percentage_;
      /**
       *
       *
       * <pre>
       * Required. Percentage deployment for the phase.
       * </pre>
       *
       * <code>int32 percentage = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The percentage.
       */
      @java.lang.Override
      public int getPercentage() {
        return percentage_;
      }
      /**
       *
       *
       * <pre>
       * Required. Percentage deployment for the phase.
       * </pre>
       *
       * <code>int32 percentage = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The percentage to set.
       * @return This builder for chaining.
       */
      public Builder setPercentage(int value) {

        percentage_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Percentage deployment for the phase.
       * </pre>
       *
       * <code>int32 percentage = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPercentage() {
        bitField0_ = (bitField0_ & ~0x00000002);
        percentage_ = 0;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList profiles_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureProfilesIsMutable() {
        if (!profiles_.isModifiable()) {
          profiles_ = new com.google.protobuf.LazyStringArrayList(profiles_);
        }
        bitField0_ |= 0x00000004;
      }
      /**
       *
       *
       * <pre>
       * Skaffold profiles to use when rendering the manifest for this phase.
       * These are in addition to the profiles list specified in the
       * `DeliveryPipeline` stage.
       * </pre>
       *
       * <code>repeated string profiles = 3;</code>
       *
       * @return A list containing the profiles.
       */
      public com.google.protobuf.ProtocolStringList getProfilesList() {
        profiles_.makeImmutable();
        return profiles_;
      }
      /**
       *
       *
       * <pre>
       * Skaffold profiles to use when rendering the manifest for this phase.
       * These are in addition to the profiles list specified in the
       * `DeliveryPipeline` stage.
       * </pre>
       *
       * <code>repeated string profiles = 3;</code>
       *
       * @return The count of profiles.
       */
      public int getProfilesCount() {
        return profiles_.size();
      }
      /**
       *
       *
       * <pre>
       * Skaffold profiles to use when rendering the manifest for this phase.
       * These are in addition to the profiles list specified in the
       * `DeliveryPipeline` stage.
       * </pre>
       *
       * <code>repeated string profiles = 3;</code>
       *
       * @param index The index of the element to return.
       * @return The profiles at the given index.
       */
      public java.lang.String getProfiles(int index) {
        return profiles_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Skaffold profiles to use when rendering the manifest for this phase.
       * These are in addition to the profiles list specified in the
       * `DeliveryPipeline` stage.
       * </pre>
       *
       * <code>repeated string profiles = 3;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the profiles at the given index.
       */
      public com.google.protobuf.ByteString getProfilesBytes(int index) {
        return profiles_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * Skaffold profiles to use when rendering the manifest for this phase.
       * These are in addition to the profiles list specified in the
       * `DeliveryPipeline` stage.
       * </pre>
       *
       * <code>repeated string profiles = 3;</code>
       *
       * @param index The index to set the value at.
       * @param value The profiles to set.
       * @return This builder for chaining.
       */
      public Builder setProfiles(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureProfilesIsMutable();
        profiles_.set(index, value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Skaffold profiles to use when rendering the manifest for this phase.
       * These are in addition to the profiles list specified in the
       * `DeliveryPipeline` stage.
       * </pre>
       *
       * <code>repeated string profiles = 3;</code>
       *
       * @param value The profiles to add.
       * @return This builder for chaining.
       */
      public Builder addProfiles(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureProfilesIsMutable();
        profiles_.add(value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Skaffold profiles to use when rendering the manifest for this phase.
       * These are in addition to the profiles list specified in the
       * `DeliveryPipeline` stage.
       * </pre>
       *
       * <code>repeated string profiles = 3;</code>
       *
       * @param values The profiles to add.
       * @return This builder for chaining.
       */
      public Builder addAllProfiles(java.lang.Iterable<java.lang.String> values) {
        ensureProfilesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, profiles_);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Skaffold profiles to use when rendering the manifest for this phase.
       * These are in addition to the profiles list specified in the
       * `DeliveryPipeline` stage.
       * </pre>
       *
       * <code>repeated string profiles = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearProfiles() {
        profiles_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Skaffold profiles to use when rendering the manifest for this phase.
       * These are in addition to the profiles list specified in the
       * `DeliveryPipeline` stage.
       * </pre>
       *
       * <code>repeated string profiles = 3;</code>
       *
       * @param value The bytes of the profiles to add.
       * @return This builder for chaining.
       */
      public Builder addProfilesBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureProfilesIsMutable();
        profiles_.add(value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private boolean verify_;
      /**
       *
       *
       * <pre>
       * Whether to run verify tests after the deployment.
       * </pre>
       *
       * <code>bool verify = 4;</code>
       *
       * @return The verify.
       */
      @java.lang.Override
      public boolean getVerify() {
        return verify_;
      }
      /**
       *
       *
       * <pre>
       * Whether to run verify tests after the deployment.
       * </pre>
       *
       * <code>bool verify = 4;</code>
       *
       * @param value The verify to set.
       * @return This builder for chaining.
       */
      public Builder setVerify(boolean value) {

        verify_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Whether to run verify tests after the deployment.
       * </pre>
       *
       * <code>bool verify = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearVerify() {
        bitField0_ = (bitField0_ & ~0x00000008);
        verify_ = false;
        onChanged();
        return this;
      }

      private com.google.cloud.deploy.v1.Predeploy predeploy_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.deploy.v1.Predeploy,
              com.google.cloud.deploy.v1.Predeploy.Builder,
              com.google.cloud.deploy.v1.PredeployOrBuilder>
          predeployBuilder_;
      /**
       *
       *
       * <pre>
       * Optional. Configuration for the predeploy job of this phase. If this is
       * not configured, there will be no predeploy job for this phase.
       * </pre>
       *
       * <code>
       * .google.cloud.deploy.v1.Predeploy predeploy = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the predeploy field is set.
       */
      public boolean hasPredeploy() {
        return ((bitField0_ & 0x00000010) != 0);
      }
      /**
       *
       *
       * <pre>
       * Optional. Configuration for the predeploy job of this phase. If this is
       * not configured, there will be no predeploy job for this phase.
       * </pre>
       *
       * <code>
       * .google.cloud.deploy.v1.Predeploy predeploy = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The predeploy.
       */
      public com.google.cloud.deploy.v1.Predeploy getPredeploy() {
        if (predeployBuilder_ == null) {
          return predeploy_ == null
              ? com.google.cloud.deploy.v1.Predeploy.getDefaultInstance()
              : predeploy_;
        } else {
          return predeployBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Configuration for the predeploy job of this phase. If this is
       * not configured, there will be no predeploy job for this phase.
       * </pre>
       *
       * <code>
       * .google.cloud.deploy.v1.Predeploy predeploy = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setPredeploy(com.google.cloud.deploy.v1.Predeploy value) {
        if (predeployBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          predeploy_ = value;
        } else {
          predeployBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Configuration for the predeploy job of this phase. If this is
       * not configured, there will be no predeploy job for this phase.
       * </pre>
       *
       * <code>
       * .google.cloud.deploy.v1.Predeploy predeploy = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setPredeploy(com.google.cloud.deploy.v1.Predeploy.Builder builderForValue) {
        if (predeployBuilder_ == null) {
          predeploy_ = builderForValue.build();
        } else {
          predeployBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Configuration for the predeploy job of this phase. If this is
       * not configured, there will be no predeploy job for this phase.
       * </pre>
       *
       * <code>
       * .google.cloud.deploy.v1.Predeploy predeploy = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergePredeploy(com.google.cloud.deploy.v1.Predeploy value) {
        if (predeployBuilder_ == null) {
          if (((bitField0_ & 0x00000010) != 0)
              && predeploy_ != null
              && predeploy_ != com.google.cloud.deploy.v1.Predeploy.getDefaultInstance()) {
            getPredeployBuilder().mergeFrom(value);
          } else {
            predeploy_ = value;
          }
        } else {
          predeployBuilder_.mergeFrom(value);
        }
        if (predeploy_ != null) {
          bitField0_ |= 0x00000010;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Configuration for the predeploy job of this phase. If this is
       * not configured, there will be no predeploy job for this phase.
       * </pre>
       *
       * <code>
       * .google.cloud.deploy.v1.Predeploy predeploy = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearPredeploy() {
        bitField0_ = (bitField0_ & ~0x00000010);
        predeploy_ = null;
        if (predeployBuilder_ != null) {
          predeployBuilder_.dispose();
          predeployBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Configuration for the predeploy job of this phase. If this is
       * not configured, there will be no predeploy job for this phase.
       * </pre>
       *
       * <code>
       * .google.cloud.deploy.v1.Predeploy predeploy = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.deploy.v1.Predeploy.Builder getPredeployBuilder() {
        bitField0_ |= 0x00000010;
        onChanged();
        return getPredeployFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Optional. Configuration for the predeploy job of this phase. If this is
       * not configured, there will be no predeploy job for this phase.
       * </pre>
       *
       * <code>
       * .google.cloud.deploy.v1.Predeploy predeploy = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.deploy.v1.PredeployOrBuilder getPredeployOrBuilder() {
        if (predeployBuilder_ != null) {
          return predeployBuilder_.getMessageOrBuilder();
        } else {
          return predeploy_ == null
              ? com.google.cloud.deploy.v1.Predeploy.getDefaultInstance()
              : predeploy_;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Configuration for the predeploy job of this phase. If this is
       * not configured, there will be no predeploy job for this phase.
       * </pre>
       *
       * <code>
       * .google.cloud.deploy.v1.Predeploy predeploy = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.deploy.v1.Predeploy,
              com.google.cloud.deploy.v1.Predeploy.Builder,
              com.google.cloud.deploy.v1.PredeployOrBuilder>
          getPredeployFieldBuilder() {
        if (predeployBuilder_ == null) {
          predeployBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.deploy.v1.Predeploy,
                  com.google.cloud.deploy.v1.Predeploy.Builder,
                  com.google.cloud.deploy.v1.PredeployOrBuilder>(
                  getPredeploy(), getParentForChildren(), isClean());
          predeploy_ = null;
        }
        return predeployBuilder_;
      }

      private com.google.cloud.deploy.v1.Postdeploy postdeploy_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.deploy.v1.Postdeploy,
              com.google.cloud.deploy.v1.Postdeploy.Builder,
              com.google.cloud.deploy.v1.PostdeployOrBuilder>
          postdeployBuilder_;
      /**
       *
       *
       * <pre>
       * Optional. Configuration for the postdeploy job of this phase. If this is
       * not configured, there will be no postdeploy job for this phase.
       * </pre>
       *
       * <code>
       * .google.cloud.deploy.v1.Postdeploy postdeploy = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the postdeploy field is set.
       */
      public boolean hasPostdeploy() {
        return ((bitField0_ & 0x00000020) != 0);
      }
      /**
       *
       *
       * <pre>
       * Optional. Configuration for the postdeploy job of this phase. If this is
       * not configured, there will be no postdeploy job for this phase.
       * </pre>
       *
       * <code>
       * .google.cloud.deploy.v1.Postdeploy postdeploy = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The postdeploy.
       */
      public com.google.cloud.deploy.v1.Postdeploy getPostdeploy() {
        if (postdeployBuilder_ == null) {
          return postdeploy_ == null
              ? com.google.cloud.deploy.v1.Postdeploy.getDefaultInstance()
              : postdeploy_;
        } else {
          return postdeployBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Configuration for the postdeploy job of this phase. If this is
       * not configured, there will be no postdeploy job for this phase.
       * </pre>
       *
       * <code>
       * .google.cloud.deploy.v1.Postdeploy postdeploy = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setPostdeploy(com.google.cloud.deploy.v1.Postdeploy value) {
        if (postdeployBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          postdeploy_ = value;
        } else {
          postdeployBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Configuration for the postdeploy job of this phase. If this is
       * not configured, there will be no postdeploy job for this phase.
       * </pre>
       *
       * <code>
       * .google.cloud.deploy.v1.Postdeploy postdeploy = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setPostdeploy(com.google.cloud.deploy.v1.Postdeploy.Builder builderForValue) {
        if (postdeployBuilder_ == null) {
          postdeploy_ = builderForValue.build();
        } else {
          postdeployBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Configuration for the postdeploy job of this phase. If this is
       * not configured, there will be no postdeploy job for this phase.
       * </pre>
       *
       * <code>
       * .google.cloud.deploy.v1.Postdeploy postdeploy = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergePostdeploy(com.google.cloud.deploy.v1.Postdeploy value) {
        if (postdeployBuilder_ == null) {
          if (((bitField0_ & 0x00000020) != 0)
              && postdeploy_ != null
              && postdeploy_ != com.google.cloud.deploy.v1.Postdeploy.getDefaultInstance()) {
            getPostdeployBuilder().mergeFrom(value);
          } else {
            postdeploy_ = value;
          }
        } else {
          postdeployBuilder_.mergeFrom(value);
        }
        if (postdeploy_ != null) {
          bitField0_ |= 0x00000020;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Configuration for the postdeploy job of this phase. If this is
       * not configured, there will be no postdeploy job for this phase.
       * </pre>
       *
       * <code>
       * .google.cloud.deploy.v1.Postdeploy postdeploy = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearPostdeploy() {
        bitField0_ = (bitField0_ & ~0x00000020);
        postdeploy_ = null;
        if (postdeployBuilder_ != null) {
          postdeployBuilder_.dispose();
          postdeployBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Configuration for the postdeploy job of this phase. If this is
       * not configured, there will be no postdeploy job for this phase.
       * </pre>
       *
       * <code>
       * .google.cloud.deploy.v1.Postdeploy postdeploy = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.deploy.v1.Postdeploy.Builder getPostdeployBuilder() {
        bitField0_ |= 0x00000020;
        onChanged();
        return getPostdeployFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Optional. Configuration for the postdeploy job of this phase. If this is
       * not configured, there will be no postdeploy job for this phase.
       * </pre>
       *
       * <code>
       * .google.cloud.deploy.v1.Postdeploy postdeploy = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.deploy.v1.PostdeployOrBuilder getPostdeployOrBuilder() {
        if (postdeployBuilder_ != null) {
          return postdeployBuilder_.getMessageOrBuilder();
        } else {
          return postdeploy_ == null
              ? com.google.cloud.deploy.v1.Postdeploy.getDefaultInstance()
              : postdeploy_;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Configuration for the postdeploy job of this phase. If this is
       * not configured, there will be no postdeploy job for this phase.
       * </pre>
       *
       * <code>
       * .google.cloud.deploy.v1.Postdeploy postdeploy = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.deploy.v1.Postdeploy,
              com.google.cloud.deploy.v1.Postdeploy.Builder,
              com.google.cloud.deploy.v1.PostdeployOrBuilder>
          getPostdeployFieldBuilder() {
        if (postdeployBuilder_ == null) {
          postdeployBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.deploy.v1.Postdeploy,
                  com.google.cloud.deploy.v1.Postdeploy.Builder,
                  com.google.cloud.deploy.v1.PostdeployOrBuilder>(
                  getPostdeploy(), getParentForChildren(), isClean());
          postdeploy_ = null;
        }
        return postdeployBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig)
    private static final com.google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig();
    }

    public static com.google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<PhaseConfig> PARSER =
        new com.google.protobuf.AbstractParser<PhaseConfig>() {
          @java.lang.Override
          public PhaseConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<PhaseConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<PhaseConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int PHASE_CONFIGS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig>
      phaseConfigs_;
  /**
   *
   *
   * <pre>
   * Required. Configuration for each phase in the canary deployment in the
   * order executed.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig phase_configs = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig>
      getPhaseConfigsList() {
    return phaseConfigs_;
  }
  /**
   *
   *
   * <pre>
   * Required. Configuration for each phase in the canary deployment in the
   * order executed.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig phase_configs = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfigOrBuilder>
      getPhaseConfigsOrBuilderList() {
    return phaseConfigs_;
  }
  /**
   *
   *
   * <pre>
   * Required. Configuration for each phase in the canary deployment in the
   * order executed.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig phase_configs = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public int getPhaseConfigsCount() {
    return phaseConfigs_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. Configuration for each phase in the canary deployment in the
   * order executed.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig phase_configs = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig getPhaseConfigs(int index) {
    return phaseConfigs_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Required. Configuration for each phase in the canary deployment in the
   * order executed.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig phase_configs = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfigOrBuilder
      getPhaseConfigsOrBuilder(int index) {
    return phaseConfigs_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < phaseConfigs_.size(); i++) {
      output.writeMessage(1, phaseConfigs_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < phaseConfigs_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, phaseConfigs_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.deploy.v1.CustomCanaryDeployment)) {
      return super.equals(obj);
    }
    com.google.cloud.deploy.v1.CustomCanaryDeployment other =
        (com.google.cloud.deploy.v1.CustomCanaryDeployment) obj;

    if (!getPhaseConfigsList().equals(other.getPhaseConfigsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getPhaseConfigsCount() > 0) {
      hash = (37 * hash) + PHASE_CONFIGS_FIELD_NUMBER;
      hash = (53 * hash) + getPhaseConfigsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.deploy.v1.CustomCanaryDeployment parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.CustomCanaryDeployment parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.CustomCanaryDeployment parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.CustomCanaryDeployment parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.CustomCanaryDeployment parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.CustomCanaryDeployment parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.CustomCanaryDeployment parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.CustomCanaryDeployment parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.CustomCanaryDeployment parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.CustomCanaryDeployment parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.CustomCanaryDeployment parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.CustomCanaryDeployment parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.deploy.v1.CustomCanaryDeployment prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * CustomCanaryDeployment represents the custom canary deployment
   * configuration.
   * </pre>
   *
   * Protobuf type {@code google.cloud.deploy.v1.CustomCanaryDeployment}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.deploy.v1.CustomCanaryDeployment)
      com.google.cloud.deploy.v1.CustomCanaryDeploymentOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_CustomCanaryDeployment_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_CustomCanaryDeployment_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.deploy.v1.CustomCanaryDeployment.class,
              com.google.cloud.deploy.v1.CustomCanaryDeployment.Builder.class);
    }

    // Construct using com.google.cloud.deploy.v1.CustomCanaryDeployment.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (phaseConfigsBuilder_ == null) {
        phaseConfigs_ = java.util.Collections.emptyList();
      } else {
        phaseConfigs_ = null;
        phaseConfigsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_CustomCanaryDeployment_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.CustomCanaryDeployment getDefaultInstanceForType() {
      return com.google.cloud.deploy.v1.CustomCanaryDeployment.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.CustomCanaryDeployment build() {
      com.google.cloud.deploy.v1.CustomCanaryDeployment result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.CustomCanaryDeployment buildPartial() {
      com.google.cloud.deploy.v1.CustomCanaryDeployment result =
          new com.google.cloud.deploy.v1.CustomCanaryDeployment(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.deploy.v1.CustomCanaryDeployment result) {
      if (phaseConfigsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          phaseConfigs_ = java.util.Collections.unmodifiableList(phaseConfigs_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.phaseConfigs_ = phaseConfigs_;
      } else {
        result.phaseConfigs_ = phaseConfigsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.deploy.v1.CustomCanaryDeployment result) {
      int from_bitField0_ = bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.deploy.v1.CustomCanaryDeployment) {
        return mergeFrom((com.google.cloud.deploy.v1.CustomCanaryDeployment) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.deploy.v1.CustomCanaryDeployment other) {
      if (other == com.google.cloud.deploy.v1.CustomCanaryDeployment.getDefaultInstance())
        return this;
      if (phaseConfigsBuilder_ == null) {
        if (!other.phaseConfigs_.isEmpty()) {
          if (phaseConfigs_.isEmpty()) {
            phaseConfigs_ = other.phaseConfigs_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensurePhaseConfigsIsMutable();
            phaseConfigs_.addAll(other.phaseConfigs_);
          }
          onChanged();
        }
      } else {
        if (!other.phaseConfigs_.isEmpty()) {
          if (phaseConfigsBuilder_.isEmpty()) {
            phaseConfigsBuilder_.dispose();
            phaseConfigsBuilder_ = null;
            phaseConfigs_ = other.phaseConfigs_;
            bitField0_ = (bitField0_ & ~0x00000001);
            phaseConfigsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getPhaseConfigsFieldBuilder()
                    : null;
          } else {
            phaseConfigsBuilder_.addAllMessages(other.phaseConfigs_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig m =
                    input.readMessage(
                        com.google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig.parser(),
                        extensionRegistry);
                if (phaseConfigsBuilder_ == null) {
                  ensurePhaseConfigsIsMutable();
                  phaseConfigs_.add(m);
                } else {
                  phaseConfigsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig>
        phaseConfigs_ = java.util.Collections.emptyList();

    private void ensurePhaseConfigsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        phaseConfigs_ =
            new java.util.ArrayList<com.google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig>(
                phaseConfigs_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig,
            com.google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig.Builder,
            com.google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfigOrBuilder>
        phaseConfigsBuilder_;

    /**
     *
     *
     * <pre>
     * Required. Configuration for each phase in the canary deployment in the
     * order executed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig phase_configs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig>
        getPhaseConfigsList() {
      if (phaseConfigsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(phaseConfigs_);
      } else {
        return phaseConfigsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Configuration for each phase in the canary deployment in the
     * order executed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig phase_configs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public int getPhaseConfigsCount() {
      if (phaseConfigsBuilder_ == null) {
        return phaseConfigs_.size();
      } else {
        return phaseConfigsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Configuration for each phase in the canary deployment in the
     * order executed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig phase_configs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig getPhaseConfigs(
        int index) {
      if (phaseConfigsBuilder_ == null) {
        return phaseConfigs_.get(index);
      } else {
        return phaseConfigsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Configuration for each phase in the canary deployment in the
     * order executed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig phase_configs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setPhaseConfigs(
        int index, com.google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig value) {
      if (phaseConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePhaseConfigsIsMutable();
        phaseConfigs_.set(index, value);
        onChanged();
      } else {
        phaseConfigsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Configuration for each phase in the canary deployment in the
     * order executed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig phase_configs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setPhaseConfigs(
        int index,
        com.google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig.Builder builderForValue) {
      if (phaseConfigsBuilder_ == null) {
        ensurePhaseConfigsIsMutable();
        phaseConfigs_.set(index, builderForValue.build());
        onChanged();
      } else {
        phaseConfigsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Configuration for each phase in the canary deployment in the
     * order executed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig phase_configs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addPhaseConfigs(
        com.google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig value) {
      if (phaseConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePhaseConfigsIsMutable();
        phaseConfigs_.add(value);
        onChanged();
      } else {
        phaseConfigsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Configuration for each phase in the canary deployment in the
     * order executed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig phase_configs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addPhaseConfigs(
        int index, com.google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig value) {
      if (phaseConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePhaseConfigsIsMutable();
        phaseConfigs_.add(index, value);
        onChanged();
      } else {
        phaseConfigsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Configuration for each phase in the canary deployment in the
     * order executed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig phase_configs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addPhaseConfigs(
        com.google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig.Builder builderForValue) {
      if (phaseConfigsBuilder_ == null) {
        ensurePhaseConfigsIsMutable();
        phaseConfigs_.add(builderForValue.build());
        onChanged();
      } else {
        phaseConfigsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Configuration for each phase in the canary deployment in the
     * order executed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig phase_configs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addPhaseConfigs(
        int index,
        com.google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig.Builder builderForValue) {
      if (phaseConfigsBuilder_ == null) {
        ensurePhaseConfigsIsMutable();
        phaseConfigs_.add(index, builderForValue.build());
        onChanged();
      } else {
        phaseConfigsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Configuration for each phase in the canary deployment in the
     * order executed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig phase_configs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addAllPhaseConfigs(
        java.lang.Iterable<? extends com.google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig>
            values) {
      if (phaseConfigsBuilder_ == null) {
        ensurePhaseConfigsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, phaseConfigs_);
        onChanged();
      } else {
        phaseConfigsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Configuration for each phase in the canary deployment in the
     * order executed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig phase_configs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearPhaseConfigs() {
      if (phaseConfigsBuilder_ == null) {
        phaseConfigs_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        phaseConfigsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Configuration for each phase in the canary deployment in the
     * order executed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig phase_configs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder removePhaseConfigs(int index) {
      if (phaseConfigsBuilder_ == null) {
        ensurePhaseConfigsIsMutable();
        phaseConfigs_.remove(index);
        onChanged();
      } else {
        phaseConfigsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Configuration for each phase in the canary deployment in the
     * order executed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig phase_configs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig.Builder
        getPhaseConfigsBuilder(int index) {
      return getPhaseConfigsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Required. Configuration for each phase in the canary deployment in the
     * order executed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig phase_configs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfigOrBuilder
        getPhaseConfigsOrBuilder(int index) {
      if (phaseConfigsBuilder_ == null) {
        return phaseConfigs_.get(index);
      } else {
        return phaseConfigsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Configuration for each phase in the canary deployment in the
     * order executed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig phase_configs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfigOrBuilder>
        getPhaseConfigsOrBuilderList() {
      if (phaseConfigsBuilder_ != null) {
        return phaseConfigsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(phaseConfigs_);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Configuration for each phase in the canary deployment in the
     * order executed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig phase_configs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig.Builder
        addPhaseConfigsBuilder() {
      return getPhaseConfigsFieldBuilder()
          .addBuilder(
              com.google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. Configuration for each phase in the canary deployment in the
     * order executed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig phase_configs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig.Builder
        addPhaseConfigsBuilder(int index) {
      return getPhaseConfigsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. Configuration for each phase in the canary deployment in the
     * order executed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig phase_configs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig.Builder>
        getPhaseConfigsBuilderList() {
      return getPhaseConfigsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig,
            com.google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig.Builder,
            com.google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfigOrBuilder>
        getPhaseConfigsFieldBuilder() {
      if (phaseConfigsBuilder_ == null) {
        phaseConfigsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig,
                com.google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfig.Builder,
                com.google.cloud.deploy.v1.CustomCanaryDeployment.PhaseConfigOrBuilder>(
                phaseConfigs_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        phaseConfigs_ = null;
      }
      return phaseConfigsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.deploy.v1.CustomCanaryDeployment)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.deploy.v1.CustomCanaryDeployment)
  private static final com.google.cloud.deploy.v1.CustomCanaryDeployment DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.deploy.v1.CustomCanaryDeployment();
  }

  public static com.google.cloud.deploy.v1.CustomCanaryDeployment getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CustomCanaryDeployment> PARSER =
      new com.google.protobuf.AbstractParser<CustomCanaryDeployment>() {
        @java.lang.Override
        public CustomCanaryDeployment parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CustomCanaryDeployment> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CustomCanaryDeployment> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.deploy.v1.CustomCanaryDeployment getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
