/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/deploy/v1/cloud_deploy.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.deploy.v1;

/**
 *
 *
 * <pre>
 * CustomTargetSkaffoldActions represents the `CustomTargetType` configuration
 * using Skaffold custom actions.
 * </pre>
 *
 * Protobuf type {@code google.cloud.deploy.v1.CustomTargetSkaffoldActions}
 */
public final class CustomTargetSkaffoldActions extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.deploy.v1.CustomTargetSkaffoldActions)
    CustomTargetSkaffoldActionsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CustomTargetSkaffoldActions.newBuilder() to construct.
  private CustomTargetSkaffoldActions(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CustomTargetSkaffoldActions() {
    renderAction_ = "";
    deployAction_ = "";
    includeSkaffoldModules_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CustomTargetSkaffoldActions();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.deploy.v1.CloudDeployProto
        .internal_static_google_cloud_deploy_v1_CustomTargetSkaffoldActions_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.deploy.v1.CloudDeployProto
        .internal_static_google_cloud_deploy_v1_CustomTargetSkaffoldActions_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.deploy.v1.CustomTargetSkaffoldActions.class,
            com.google.cloud.deploy.v1.CustomTargetSkaffoldActions.Builder.class);
  }

  public static final int RENDER_ACTION_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object renderAction_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The Skaffold custom action responsible for render operations. If
   * not provided then Cloud Deploy will perform the render operations via
   * `skaffold render`.
   * </pre>
   *
   * <code>string render_action = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The renderAction.
   */
  @java.lang.Override
  public java.lang.String getRenderAction() {
    java.lang.Object ref = renderAction_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      renderAction_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The Skaffold custom action responsible for render operations. If
   * not provided then Cloud Deploy will perform the render operations via
   * `skaffold render`.
   * </pre>
   *
   * <code>string render_action = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for renderAction.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRenderActionBytes() {
    java.lang.Object ref = renderAction_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      renderAction_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DEPLOY_ACTION_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object deployAction_ = "";
  /**
   *
   *
   * <pre>
   * Required. The Skaffold custom action responsible for deploy operations.
   * </pre>
   *
   * <code>string deploy_action = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The deployAction.
   */
  @java.lang.Override
  public java.lang.String getDeployAction() {
    java.lang.Object ref = deployAction_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      deployAction_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The Skaffold custom action responsible for deploy operations.
   * </pre>
   *
   * <code>string deploy_action = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for deployAction.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDeployActionBytes() {
    java.lang.Object ref = deployAction_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      deployAction_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INCLUDE_SKAFFOLD_MODULES_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.deploy.v1.SkaffoldModules> includeSkaffoldModules_;
  /**
   *
   *
   * <pre>
   * Optional. List of Skaffold modules Cloud Deploy will include in the
   * Skaffold Config as required before performing diagnose.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.SkaffoldModules include_skaffold_modules = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.deploy.v1.SkaffoldModules>
      getIncludeSkaffoldModulesList() {
    return includeSkaffoldModules_;
  }
  /**
   *
   *
   * <pre>
   * Optional. List of Skaffold modules Cloud Deploy will include in the
   * Skaffold Config as required before performing diagnose.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.SkaffoldModules include_skaffold_modules = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.deploy.v1.SkaffoldModulesOrBuilder>
      getIncludeSkaffoldModulesOrBuilderList() {
    return includeSkaffoldModules_;
  }
  /**
   *
   *
   * <pre>
   * Optional. List of Skaffold modules Cloud Deploy will include in the
   * Skaffold Config as required before performing diagnose.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.SkaffoldModules include_skaffold_modules = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getIncludeSkaffoldModulesCount() {
    return includeSkaffoldModules_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. List of Skaffold modules Cloud Deploy will include in the
   * Skaffold Config as required before performing diagnose.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.SkaffoldModules include_skaffold_modules = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.SkaffoldModules getIncludeSkaffoldModules(int index) {
    return includeSkaffoldModules_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. List of Skaffold modules Cloud Deploy will include in the
   * Skaffold Config as required before performing diagnose.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.SkaffoldModules include_skaffold_modules = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.SkaffoldModulesOrBuilder getIncludeSkaffoldModulesOrBuilder(
      int index) {
    return includeSkaffoldModules_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(renderAction_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, renderAction_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(deployAction_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, deployAction_);
    }
    for (int i = 0; i < includeSkaffoldModules_.size(); i++) {
      output.writeMessage(3, includeSkaffoldModules_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(renderAction_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, renderAction_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(deployAction_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, deployAction_);
    }
    for (int i = 0; i < includeSkaffoldModules_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, includeSkaffoldModules_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.deploy.v1.CustomTargetSkaffoldActions)) {
      return super.equals(obj);
    }
    com.google.cloud.deploy.v1.CustomTargetSkaffoldActions other =
        (com.google.cloud.deploy.v1.CustomTargetSkaffoldActions) obj;

    if (!getRenderAction().equals(other.getRenderAction())) return false;
    if (!getDeployAction().equals(other.getDeployAction())) return false;
    if (!getIncludeSkaffoldModulesList().equals(other.getIncludeSkaffoldModulesList()))
      return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + RENDER_ACTION_FIELD_NUMBER;
    hash = (53 * hash) + getRenderAction().hashCode();
    hash = (37 * hash) + DEPLOY_ACTION_FIELD_NUMBER;
    hash = (53 * hash) + getDeployAction().hashCode();
    if (getIncludeSkaffoldModulesCount() > 0) {
      hash = (37 * hash) + INCLUDE_SKAFFOLD_MODULES_FIELD_NUMBER;
      hash = (53 * hash) + getIncludeSkaffoldModulesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.deploy.v1.CustomTargetSkaffoldActions parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.CustomTargetSkaffoldActions parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.CustomTargetSkaffoldActions parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.CustomTargetSkaffoldActions parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.CustomTargetSkaffoldActions parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.CustomTargetSkaffoldActions parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.CustomTargetSkaffoldActions parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.CustomTargetSkaffoldActions parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.CustomTargetSkaffoldActions parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.CustomTargetSkaffoldActions parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.CustomTargetSkaffoldActions parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.CustomTargetSkaffoldActions parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.deploy.v1.CustomTargetSkaffoldActions prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * CustomTargetSkaffoldActions represents the `CustomTargetType` configuration
   * using Skaffold custom actions.
   * </pre>
   *
   * Protobuf type {@code google.cloud.deploy.v1.CustomTargetSkaffoldActions}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.deploy.v1.CustomTargetSkaffoldActions)
      com.google.cloud.deploy.v1.CustomTargetSkaffoldActionsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_CustomTargetSkaffoldActions_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_CustomTargetSkaffoldActions_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.deploy.v1.CustomTargetSkaffoldActions.class,
              com.google.cloud.deploy.v1.CustomTargetSkaffoldActions.Builder.class);
    }

    // Construct using com.google.cloud.deploy.v1.CustomTargetSkaffoldActions.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      renderAction_ = "";
      deployAction_ = "";
      if (includeSkaffoldModulesBuilder_ == null) {
        includeSkaffoldModules_ = java.util.Collections.emptyList();
      } else {
        includeSkaffoldModules_ = null;
        includeSkaffoldModulesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_CustomTargetSkaffoldActions_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.CustomTargetSkaffoldActions getDefaultInstanceForType() {
      return com.google.cloud.deploy.v1.CustomTargetSkaffoldActions.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.CustomTargetSkaffoldActions build() {
      com.google.cloud.deploy.v1.CustomTargetSkaffoldActions result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.CustomTargetSkaffoldActions buildPartial() {
      com.google.cloud.deploy.v1.CustomTargetSkaffoldActions result =
          new com.google.cloud.deploy.v1.CustomTargetSkaffoldActions(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.deploy.v1.CustomTargetSkaffoldActions result) {
      if (includeSkaffoldModulesBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          includeSkaffoldModules_ = java.util.Collections.unmodifiableList(includeSkaffoldModules_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.includeSkaffoldModules_ = includeSkaffoldModules_;
      } else {
        result.includeSkaffoldModules_ = includeSkaffoldModulesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.deploy.v1.CustomTargetSkaffoldActions result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.renderAction_ = renderAction_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.deployAction_ = deployAction_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.deploy.v1.CustomTargetSkaffoldActions) {
        return mergeFrom((com.google.cloud.deploy.v1.CustomTargetSkaffoldActions) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.deploy.v1.CustomTargetSkaffoldActions other) {
      if (other == com.google.cloud.deploy.v1.CustomTargetSkaffoldActions.getDefaultInstance())
        return this;
      if (!other.getRenderAction().isEmpty()) {
        renderAction_ = other.renderAction_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDeployAction().isEmpty()) {
        deployAction_ = other.deployAction_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (includeSkaffoldModulesBuilder_ == null) {
        if (!other.includeSkaffoldModules_.isEmpty()) {
          if (includeSkaffoldModules_.isEmpty()) {
            includeSkaffoldModules_ = other.includeSkaffoldModules_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureIncludeSkaffoldModulesIsMutable();
            includeSkaffoldModules_.addAll(other.includeSkaffoldModules_);
          }
          onChanged();
        }
      } else {
        if (!other.includeSkaffoldModules_.isEmpty()) {
          if (includeSkaffoldModulesBuilder_.isEmpty()) {
            includeSkaffoldModulesBuilder_.dispose();
            includeSkaffoldModulesBuilder_ = null;
            includeSkaffoldModules_ = other.includeSkaffoldModules_;
            bitField0_ = (bitField0_ & ~0x00000004);
            includeSkaffoldModulesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getIncludeSkaffoldModulesFieldBuilder()
                    : null;
          } else {
            includeSkaffoldModulesBuilder_.addAllMessages(other.includeSkaffoldModules_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                renderAction_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                deployAction_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                com.google.cloud.deploy.v1.SkaffoldModules m =
                    input.readMessage(
                        com.google.cloud.deploy.v1.SkaffoldModules.parser(), extensionRegistry);
                if (includeSkaffoldModulesBuilder_ == null) {
                  ensureIncludeSkaffoldModulesIsMutable();
                  includeSkaffoldModules_.add(m);
                } else {
                  includeSkaffoldModulesBuilder_.addMessage(m);
                }
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object renderAction_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The Skaffold custom action responsible for render operations. If
     * not provided then Cloud Deploy will perform the render operations via
     * `skaffold render`.
     * </pre>
     *
     * <code>string render_action = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The renderAction.
     */
    public java.lang.String getRenderAction() {
      java.lang.Object ref = renderAction_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        renderAction_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The Skaffold custom action responsible for render operations. If
     * not provided then Cloud Deploy will perform the render operations via
     * `skaffold render`.
     * </pre>
     *
     * <code>string render_action = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for renderAction.
     */
    public com.google.protobuf.ByteString getRenderActionBytes() {
      java.lang.Object ref = renderAction_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        renderAction_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The Skaffold custom action responsible for render operations. If
     * not provided then Cloud Deploy will perform the render operations via
     * `skaffold render`.
     * </pre>
     *
     * <code>string render_action = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The renderAction to set.
     * @return This builder for chaining.
     */
    public Builder setRenderAction(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      renderAction_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Skaffold custom action responsible for render operations. If
     * not provided then Cloud Deploy will perform the render operations via
     * `skaffold render`.
     * </pre>
     *
     * <code>string render_action = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRenderAction() {
      renderAction_ = getDefaultInstance().getRenderAction();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Skaffold custom action responsible for render operations. If
     * not provided then Cloud Deploy will perform the render operations via
     * `skaffold render`.
     * </pre>
     *
     * <code>string render_action = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for renderAction to set.
     * @return This builder for chaining.
     */
    public Builder setRenderActionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      renderAction_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object deployAction_ = "";
    /**
     *
     *
     * <pre>
     * Required. The Skaffold custom action responsible for deploy operations.
     * </pre>
     *
     * <code>string deploy_action = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The deployAction.
     */
    public java.lang.String getDeployAction() {
      java.lang.Object ref = deployAction_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        deployAction_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The Skaffold custom action responsible for deploy operations.
     * </pre>
     *
     * <code>string deploy_action = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for deployAction.
     */
    public com.google.protobuf.ByteString getDeployActionBytes() {
      java.lang.Object ref = deployAction_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        deployAction_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The Skaffold custom action responsible for deploy operations.
     * </pre>
     *
     * <code>string deploy_action = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The deployAction to set.
     * @return This builder for chaining.
     */
    public Builder setDeployAction(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      deployAction_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Skaffold custom action responsible for deploy operations.
     * </pre>
     *
     * <code>string deploy_action = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDeployAction() {
      deployAction_ = getDefaultInstance().getDeployAction();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Skaffold custom action responsible for deploy operations.
     * </pre>
     *
     * <code>string deploy_action = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for deployAction to set.
     * @return This builder for chaining.
     */
    public Builder setDeployActionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      deployAction_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.deploy.v1.SkaffoldModules> includeSkaffoldModules_ =
        java.util.Collections.emptyList();

    private void ensureIncludeSkaffoldModulesIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        includeSkaffoldModules_ =
            new java.util.ArrayList<com.google.cloud.deploy.v1.SkaffoldModules>(
                includeSkaffoldModules_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.deploy.v1.SkaffoldModules,
            com.google.cloud.deploy.v1.SkaffoldModules.Builder,
            com.google.cloud.deploy.v1.SkaffoldModulesOrBuilder>
        includeSkaffoldModulesBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. List of Skaffold modules Cloud Deploy will include in the
     * Skaffold Config as required before performing diagnose.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.SkaffoldModules include_skaffold_modules = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.deploy.v1.SkaffoldModules>
        getIncludeSkaffoldModulesList() {
      if (includeSkaffoldModulesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(includeSkaffoldModules_);
      } else {
        return includeSkaffoldModulesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. List of Skaffold modules Cloud Deploy will include in the
     * Skaffold Config as required before performing diagnose.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.SkaffoldModules include_skaffold_modules = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getIncludeSkaffoldModulesCount() {
      if (includeSkaffoldModulesBuilder_ == null) {
        return includeSkaffoldModules_.size();
      } else {
        return includeSkaffoldModulesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. List of Skaffold modules Cloud Deploy will include in the
     * Skaffold Config as required before performing diagnose.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.SkaffoldModules include_skaffold_modules = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.deploy.v1.SkaffoldModules getIncludeSkaffoldModules(int index) {
      if (includeSkaffoldModulesBuilder_ == null) {
        return includeSkaffoldModules_.get(index);
      } else {
        return includeSkaffoldModulesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. List of Skaffold modules Cloud Deploy will include in the
     * Skaffold Config as required before performing diagnose.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.SkaffoldModules include_skaffold_modules = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setIncludeSkaffoldModules(
        int index, com.google.cloud.deploy.v1.SkaffoldModules value) {
      if (includeSkaffoldModulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureIncludeSkaffoldModulesIsMutable();
        includeSkaffoldModules_.set(index, value);
        onChanged();
      } else {
        includeSkaffoldModulesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of Skaffold modules Cloud Deploy will include in the
     * Skaffold Config as required before performing diagnose.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.SkaffoldModules include_skaffold_modules = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setIncludeSkaffoldModules(
        int index, com.google.cloud.deploy.v1.SkaffoldModules.Builder builderForValue) {
      if (includeSkaffoldModulesBuilder_ == null) {
        ensureIncludeSkaffoldModulesIsMutable();
        includeSkaffoldModules_.set(index, builderForValue.build());
        onChanged();
      } else {
        includeSkaffoldModulesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of Skaffold modules Cloud Deploy will include in the
     * Skaffold Config as required before performing diagnose.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.SkaffoldModules include_skaffold_modules = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addIncludeSkaffoldModules(com.google.cloud.deploy.v1.SkaffoldModules value) {
      if (includeSkaffoldModulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureIncludeSkaffoldModulesIsMutable();
        includeSkaffoldModules_.add(value);
        onChanged();
      } else {
        includeSkaffoldModulesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of Skaffold modules Cloud Deploy will include in the
     * Skaffold Config as required before performing diagnose.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.SkaffoldModules include_skaffold_modules = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addIncludeSkaffoldModules(
        int index, com.google.cloud.deploy.v1.SkaffoldModules value) {
      if (includeSkaffoldModulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureIncludeSkaffoldModulesIsMutable();
        includeSkaffoldModules_.add(index, value);
        onChanged();
      } else {
        includeSkaffoldModulesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of Skaffold modules Cloud Deploy will include in the
     * Skaffold Config as required before performing diagnose.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.SkaffoldModules include_skaffold_modules = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addIncludeSkaffoldModules(
        com.google.cloud.deploy.v1.SkaffoldModules.Builder builderForValue) {
      if (includeSkaffoldModulesBuilder_ == null) {
        ensureIncludeSkaffoldModulesIsMutable();
        includeSkaffoldModules_.add(builderForValue.build());
        onChanged();
      } else {
        includeSkaffoldModulesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of Skaffold modules Cloud Deploy will include in the
     * Skaffold Config as required before performing diagnose.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.SkaffoldModules include_skaffold_modules = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addIncludeSkaffoldModules(
        int index, com.google.cloud.deploy.v1.SkaffoldModules.Builder builderForValue) {
      if (includeSkaffoldModulesBuilder_ == null) {
        ensureIncludeSkaffoldModulesIsMutable();
        includeSkaffoldModules_.add(index, builderForValue.build());
        onChanged();
      } else {
        includeSkaffoldModulesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of Skaffold modules Cloud Deploy will include in the
     * Skaffold Config as required before performing diagnose.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.SkaffoldModules include_skaffold_modules = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllIncludeSkaffoldModules(
        java.lang.Iterable<? extends com.google.cloud.deploy.v1.SkaffoldModules> values) {
      if (includeSkaffoldModulesBuilder_ == null) {
        ensureIncludeSkaffoldModulesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, includeSkaffoldModules_);
        onChanged();
      } else {
        includeSkaffoldModulesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of Skaffold modules Cloud Deploy will include in the
     * Skaffold Config as required before performing diagnose.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.SkaffoldModules include_skaffold_modules = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearIncludeSkaffoldModules() {
      if (includeSkaffoldModulesBuilder_ == null) {
        includeSkaffoldModules_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        includeSkaffoldModulesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of Skaffold modules Cloud Deploy will include in the
     * Skaffold Config as required before performing diagnose.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.SkaffoldModules include_skaffold_modules = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeIncludeSkaffoldModules(int index) {
      if (includeSkaffoldModulesBuilder_ == null) {
        ensureIncludeSkaffoldModulesIsMutable();
        includeSkaffoldModules_.remove(index);
        onChanged();
      } else {
        includeSkaffoldModulesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of Skaffold modules Cloud Deploy will include in the
     * Skaffold Config as required before performing diagnose.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.SkaffoldModules include_skaffold_modules = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.deploy.v1.SkaffoldModules.Builder getIncludeSkaffoldModulesBuilder(
        int index) {
      return getIncludeSkaffoldModulesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. List of Skaffold modules Cloud Deploy will include in the
     * Skaffold Config as required before performing diagnose.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.SkaffoldModules include_skaffold_modules = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.deploy.v1.SkaffoldModulesOrBuilder getIncludeSkaffoldModulesOrBuilder(
        int index) {
      if (includeSkaffoldModulesBuilder_ == null) {
        return includeSkaffoldModules_.get(index);
      } else {
        return includeSkaffoldModulesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. List of Skaffold modules Cloud Deploy will include in the
     * Skaffold Config as required before performing diagnose.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.SkaffoldModules include_skaffold_modules = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.deploy.v1.SkaffoldModulesOrBuilder>
        getIncludeSkaffoldModulesOrBuilderList() {
      if (includeSkaffoldModulesBuilder_ != null) {
        return includeSkaffoldModulesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(includeSkaffoldModules_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. List of Skaffold modules Cloud Deploy will include in the
     * Skaffold Config as required before performing diagnose.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.SkaffoldModules include_skaffold_modules = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.deploy.v1.SkaffoldModules.Builder addIncludeSkaffoldModulesBuilder() {
      return getIncludeSkaffoldModulesFieldBuilder()
          .addBuilder(com.google.cloud.deploy.v1.SkaffoldModules.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. List of Skaffold modules Cloud Deploy will include in the
     * Skaffold Config as required before performing diagnose.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.SkaffoldModules include_skaffold_modules = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.deploy.v1.SkaffoldModules.Builder addIncludeSkaffoldModulesBuilder(
        int index) {
      return getIncludeSkaffoldModulesFieldBuilder()
          .addBuilder(index, com.google.cloud.deploy.v1.SkaffoldModules.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. List of Skaffold modules Cloud Deploy will include in the
     * Skaffold Config as required before performing diagnose.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.SkaffoldModules include_skaffold_modules = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.deploy.v1.SkaffoldModules.Builder>
        getIncludeSkaffoldModulesBuilderList() {
      return getIncludeSkaffoldModulesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.deploy.v1.SkaffoldModules,
            com.google.cloud.deploy.v1.SkaffoldModules.Builder,
            com.google.cloud.deploy.v1.SkaffoldModulesOrBuilder>
        getIncludeSkaffoldModulesFieldBuilder() {
      if (includeSkaffoldModulesBuilder_ == null) {
        includeSkaffoldModulesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.deploy.v1.SkaffoldModules,
                com.google.cloud.deploy.v1.SkaffoldModules.Builder,
                com.google.cloud.deploy.v1.SkaffoldModulesOrBuilder>(
                includeSkaffoldModules_,
                ((bitField0_ & 0x00000004) != 0),
                getParentForChildren(),
                isClean());
        includeSkaffoldModules_ = null;
      }
      return includeSkaffoldModulesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.deploy.v1.CustomTargetSkaffoldActions)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.deploy.v1.CustomTargetSkaffoldActions)
  private static final com.google.cloud.deploy.v1.CustomTargetSkaffoldActions DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.deploy.v1.CustomTargetSkaffoldActions();
  }

  public static com.google.cloud.deploy.v1.CustomTargetSkaffoldActions getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CustomTargetSkaffoldActions> PARSER =
      new com.google.protobuf.AbstractParser<CustomTargetSkaffoldActions>() {
        @java.lang.Override
        public CustomTargetSkaffoldActions parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CustomTargetSkaffoldActions> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CustomTargetSkaffoldActions> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.deploy.v1.CustomTargetSkaffoldActions getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
