/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/deploy/v1/cloud_deploy.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.deploy.v1;

/**
 *
 *
 * <pre>
 * A `DeployPolicy` resource in the Cloud Deploy API.
 *
 * A `DeployPolicy` inhibits manual or automation-driven actions within a
 * Delivery Pipeline or Target.
 * </pre>
 *
 * Protobuf type {@code google.cloud.deploy.v1.DeployPolicy}
 */
public final class DeployPolicy extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.deploy.v1.DeployPolicy)
    DeployPolicyOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use DeployPolicy.newBuilder() to construct.
  private DeployPolicy(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DeployPolicy() {
    name_ = "";
    uid_ = "";
    description_ = "";
    selectors_ = java.util.Collections.emptyList();
    rules_ = java.util.Collections.emptyList();
    etag_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DeployPolicy();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.deploy.v1.CloudDeployProto
        .internal_static_google_cloud_deploy_v1_DeployPolicy_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 4:
        return internalGetAnnotations();
      case 5:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.deploy.v1.CloudDeployProto
        .internal_static_google_cloud_deploy_v1_DeployPolicy_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.deploy.v1.DeployPolicy.class,
            com.google.cloud.deploy.v1.DeployPolicy.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * What invoked the action. Filters enforcing the policy depending on what
   * invoked the action.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.deploy.v1.DeployPolicy.Invoker}
   */
  public enum Invoker implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified.
     * </pre>
     *
     * <code>INVOKER_UNSPECIFIED = 0;</code>
     */
    INVOKER_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The action is user-driven. For example, creating a rollout manually via a
     * gcloud create command.
     * </pre>
     *
     * <code>USER = 1;</code>
     */
    USER(1),
    /**
     *
     *
     * <pre>
     * Automated action by Cloud Deploy.
     * </pre>
     *
     * <code>DEPLOY_AUTOMATION = 2;</code>
     */
    DEPLOY_AUTOMATION(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified.
     * </pre>
     *
     * <code>INVOKER_UNSPECIFIED = 0;</code>
     */
    public static final int INVOKER_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The action is user-driven. For example, creating a rollout manually via a
     * gcloud create command.
     * </pre>
     *
     * <code>USER = 1;</code>
     */
    public static final int USER_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Automated action by Cloud Deploy.
     * </pre>
     *
     * <code>DEPLOY_AUTOMATION = 2;</code>
     */
    public static final int DEPLOY_AUTOMATION_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Invoker valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Invoker forNumber(int value) {
      switch (value) {
        case 0:
          return INVOKER_UNSPECIFIED;
        case 1:
          return USER;
        case 2:
          return DEPLOY_AUTOMATION;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Invoker> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Invoker> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Invoker>() {
          public Invoker findValueByNumber(int number) {
            return Invoker.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.deploy.v1.DeployPolicy.getDescriptor().getEnumTypes().get(0);
    }

    private static final Invoker[] VALUES = values();

    public static Invoker valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Invoker(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.deploy.v1.DeployPolicy.Invoker)
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Name of the `DeployPolicy`. Format is
   * `projects/{project}/locations/{location}/deployPolicies/{deployPolicy}`.
   * The `deployPolicy` component must match `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Name of the `DeployPolicy`. Format is
   * `projects/{project}/locations/{location}/deployPolicies/{deployPolicy}`.
   * The `deployPolicy` component must match `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int UID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object uid_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Unique identifier of the `DeployPolicy`.
   * </pre>
   *
   * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The uid.
   */
  @java.lang.Override
  public java.lang.String getUid() {
    java.lang.Object ref = uid_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      uid_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Unique identifier of the `DeployPolicy`.
   * </pre>
   *
   * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for uid.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUidBytes() {
    java.lang.Object ref = uid_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      uid_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * Description of the `DeployPolicy`. Max length is 255 characters.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Description of the `DeployPolicy`. Max length is 255 characters.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ANNOTATIONS_FIELD_NUMBER = 4;

  private static final class AnnotationsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.deploy.v1.CloudDeployProto
                .internal_static_google_cloud_deploy_v1_DeployPolicy_AnnotationsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> annotations_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetAnnotations() {
    if (annotations_ == null) {
      return com.google.protobuf.MapField.emptyMapField(AnnotationsDefaultEntryHolder.defaultEntry);
    }
    return annotations_;
  }

  public int getAnnotationsCount() {
    return internalGetAnnotations().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * User annotations. These attributes can only be set and used by the
   * user, and not by Cloud Deploy. Annotations must meet the following
   * constraints:
   *
   * * Annotations are key/value pairs.
   * * Valid annotation keys have two segments: an optional prefix and name,
   * separated by a slash (`/`).
   * * The name segment is required and must be 63 characters or less,
   * beginning and ending with an alphanumeric character (`[a-z0-9A-Z]`) with
   * dashes (`-`), underscores (`_`), dots (`.`), and alphanumerics between.
   * * The prefix is optional. If specified, the prefix must be a DNS subdomain:
   * a series of DNS labels separated by dots(`.`), not longer than 253
   * characters in total, followed by a slash (`/`).
   *
   * See
   * https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations/#syntax-and-character-set
   * for more details.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 4;</code>
   */
  @java.lang.Override
  public boolean containsAnnotations(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetAnnotations().getMap().containsKey(key);
  }
  /** Use {@link #getAnnotationsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getAnnotations() {
    return getAnnotationsMap();
  }
  /**
   *
   *
   * <pre>
   * User annotations. These attributes can only be set and used by the
   * user, and not by Cloud Deploy. Annotations must meet the following
   * constraints:
   *
   * * Annotations are key/value pairs.
   * * Valid annotation keys have two segments: an optional prefix and name,
   * separated by a slash (`/`).
   * * The name segment is required and must be 63 characters or less,
   * beginning and ending with an alphanumeric character (`[a-z0-9A-Z]`) with
   * dashes (`-`), underscores (`_`), dots (`.`), and alphanumerics between.
   * * The prefix is optional. If specified, the prefix must be a DNS subdomain:
   * a series of DNS labels separated by dots(`.`), not longer than 253
   * characters in total, followed by a slash (`/`).
   *
   * See
   * https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations/#syntax-and-character-set
   * for more details.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 4;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getAnnotationsMap() {
    return internalGetAnnotations().getMap();
  }
  /**
   *
   *
   * <pre>
   * User annotations. These attributes can only be set and used by the
   * user, and not by Cloud Deploy. Annotations must meet the following
   * constraints:
   *
   * * Annotations are key/value pairs.
   * * Valid annotation keys have two segments: an optional prefix and name,
   * separated by a slash (`/`).
   * * The name segment is required and must be 63 characters or less,
   * beginning and ending with an alphanumeric character (`[a-z0-9A-Z]`) with
   * dashes (`-`), underscores (`_`), dots (`.`), and alphanumerics between.
   * * The prefix is optional. If specified, the prefix must be a DNS subdomain:
   * a series of DNS labels separated by dots(`.`), not longer than 253
   * characters in total, followed by a slash (`/`).
   *
   * See
   * https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations/#syntax-and-character-set
   * for more details.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 4;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getAnnotationsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * User annotations. These attributes can only be set and used by the
   * user, and not by Cloud Deploy. Annotations must meet the following
   * constraints:
   *
   * * Annotations are key/value pairs.
   * * Valid annotation keys have two segments: an optional prefix and name,
   * separated by a slash (`/`).
   * * The name segment is required and must be 63 characters or less,
   * beginning and ending with an alphanumeric character (`[a-z0-9A-Z]`) with
   * dashes (`-`), underscores (`_`), dots (`.`), and alphanumerics between.
   * * The prefix is optional. If specified, the prefix must be a DNS subdomain:
   * a series of DNS labels separated by dots(`.`), not longer than 253
   * characters in total, followed by a slash (`/`).
   *
   * See
   * https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations/#syntax-and-character-set
   * for more details.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 4;</code>
   */
  @java.lang.Override
  public java.lang.String getAnnotationsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int LABELS_FIELD_NUMBER = 5;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.deploy.v1.CloudDeployProto
                .internal_static_google_cloud_deploy_v1_DeployPolicy_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Labels are attributes that can be set and used by both the
   * user and by Cloud Deploy. Labels must meet the following constraints:
   *
   * * Keys and values can contain only lowercase letters, numeric characters,
   * underscores, and dashes.
   * * All characters must use UTF-8 encoding, and international characters are
   * allowed.
   * * Keys must start with a lowercase letter or international character.
   * * Each resource is limited to a maximum of 64 labels.
   *
   * Both keys and values are additionally constrained to be &lt;= 128 bytes.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Labels are attributes that can be set and used by both the
   * user and by Cloud Deploy. Labels must meet the following constraints:
   *
   * * Keys and values can contain only lowercase letters, numeric characters,
   * underscores, and dashes.
   * * All characters must use UTF-8 encoding, and international characters are
   * allowed.
   * * Keys must start with a lowercase letter or international character.
   * * Each resource is limited to a maximum of 64 labels.
   *
   * Both keys and values are additionally constrained to be &lt;= 128 bytes.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Labels are attributes that can be set and used by both the
   * user and by Cloud Deploy. Labels must meet the following constraints:
   *
   * * Keys and values can contain only lowercase letters, numeric characters,
   * underscores, and dashes.
   * * All characters must use UTF-8 encoding, and international characters are
   * allowed.
   * * Keys must start with a lowercase letter or international character.
   * * Each resource is limited to a maximum of 64 labels.
   *
   * Both keys and values are additionally constrained to be &lt;= 128 bytes.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Labels are attributes that can be set and used by both the
   * user and by Cloud Deploy. Labels must meet the following constraints:
   *
   * * Keys and values can contain only lowercase letters, numeric characters,
   * underscores, and dashes.
   * * All characters must use UTF-8 encoding, and international characters are
   * allowed.
   * * Keys must start with a lowercase letter or international character.
   * * Each resource is limited to a maximum of 64 labels.
   *
   * Both keys and values are additionally constrained to be &lt;= 128 bytes.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 6;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Time at which the deploy policy was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Time at which the deploy policy was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time at which the deploy policy was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 7;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. Most recent time at which the deploy policy was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Most recent time at which the deploy policy was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Most recent time at which the deploy policy was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int SUSPENDED_FIELD_NUMBER = 8;
  private boolean suspended_ = false;
  /**
   *
   *
   * <pre>
   * When suspended, the policy will not prevent actions from occurring, even
   * if the action violates the policy.
   * </pre>
   *
   * <code>bool suspended = 8;</code>
   *
   * @return The suspended.
   */
  @java.lang.Override
  public boolean getSuspended() {
    return suspended_;
  }

  public static final int SELECTORS_FIELD_NUMBER = 12;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.deploy.v1.DeployPolicyResourceSelector> selectors_;
  /**
   *
   *
   * <pre>
   * Required. Selected resources to which the policy will be applied. At least
   * one selector is required. If one selector matches the resource the policy
   * applies. For example, if there are two selectors and the action being
   * attempted matches one of them, the policy will apply to that action.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.DeployPolicyResourceSelector selectors = 12 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.deploy.v1.DeployPolicyResourceSelector>
      getSelectorsList() {
    return selectors_;
  }
  /**
   *
   *
   * <pre>
   * Required. Selected resources to which the policy will be applied. At least
   * one selector is required. If one selector matches the resource the policy
   * applies. For example, if there are two selectors and the action being
   * attempted matches one of them, the policy will apply to that action.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.DeployPolicyResourceSelector selectors = 12 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.deploy.v1.DeployPolicyResourceSelectorOrBuilder>
      getSelectorsOrBuilderList() {
    return selectors_;
  }
  /**
   *
   *
   * <pre>
   * Required. Selected resources to which the policy will be applied. At least
   * one selector is required. If one selector matches the resource the policy
   * applies. For example, if there are two selectors and the action being
   * attempted matches one of them, the policy will apply to that action.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.DeployPolicyResourceSelector selectors = 12 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public int getSelectorsCount() {
    return selectors_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. Selected resources to which the policy will be applied. At least
   * one selector is required. If one selector matches the resource the policy
   * applies. For example, if there are two selectors and the action being
   * attempted matches one of them, the policy will apply to that action.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.DeployPolicyResourceSelector selectors = 12 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.DeployPolicyResourceSelector getSelectors(int index) {
    return selectors_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Required. Selected resources to which the policy will be applied. At least
   * one selector is required. If one selector matches the resource the policy
   * applies. For example, if there are two selectors and the action being
   * attempted matches one of them, the policy will apply to that action.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.DeployPolicyResourceSelector selectors = 12 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.DeployPolicyResourceSelectorOrBuilder getSelectorsOrBuilder(
      int index) {
    return selectors_.get(index);
  }

  public static final int RULES_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.deploy.v1.PolicyRule> rules_;
  /**
   *
   *
   * <pre>
   * Required. Rules to apply. At least one rule must be present.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.PolicyRule rules = 10 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.deploy.v1.PolicyRule> getRulesList() {
    return rules_;
  }
  /**
   *
   *
   * <pre>
   * Required. Rules to apply. At least one rule must be present.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.PolicyRule rules = 10 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.deploy.v1.PolicyRuleOrBuilder>
      getRulesOrBuilderList() {
    return rules_;
  }
  /**
   *
   *
   * <pre>
   * Required. Rules to apply. At least one rule must be present.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.PolicyRule rules = 10 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public int getRulesCount() {
    return rules_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. Rules to apply. At least one rule must be present.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.PolicyRule rules = 10 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.PolicyRule getRules(int index) {
    return rules_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Required. Rules to apply. At least one rule must be present.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.PolicyRule rules = 10 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.PolicyRuleOrBuilder getRulesOrBuilder(int index) {
    return rules_.get(index);
  }

  public static final int ETAG_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private volatile java.lang.Object etag_ = "";
  /**
   *
   *
   * <pre>
   * The weak etag of the `Automation` resource.
   * This checksum is computed by the server based on the value of other
   * fields, and may be sent on update and delete requests to ensure the
   * client has an up-to-date value before proceeding.
   * </pre>
   *
   * <code>string etag = 11;</code>
   *
   * @return The etag.
   */
  @java.lang.Override
  public java.lang.String getEtag() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      etag_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The weak etag of the `Automation` resource.
   * This checksum is computed by the server based on the value of other
   * fields, and may be sent on update and delete requests to ensure the
   * client has an up-to-date value before proceeding.
   * </pre>
   *
   * <code>string etag = 11;</code>
   *
   * @return The bytes for etag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEtagBytes() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      etag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uid_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, uid_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, description_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetAnnotations(), AnnotationsDefaultEntryHolder.defaultEntry, 4);
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 5);
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(6, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(7, getUpdateTime());
    }
    if (suspended_ != false) {
      output.writeBool(8, suspended_);
    }
    for (int i = 0; i < rules_.size(); i++) {
      output.writeMessage(10, rules_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, etag_);
    }
    for (int i = 0; i < selectors_.size(); i++) {
      output.writeMessage(12, selectors_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uid_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, uid_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, description_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetAnnotations().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> annotations__ =
          AnnotationsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, annotations__);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, labels__);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getUpdateTime());
    }
    if (suspended_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(8, suspended_);
    }
    for (int i = 0; i < rules_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, rules_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, etag_);
    }
    for (int i = 0; i < selectors_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, selectors_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.deploy.v1.DeployPolicy)) {
      return super.equals(obj);
    }
    com.google.cloud.deploy.v1.DeployPolicy other = (com.google.cloud.deploy.v1.DeployPolicy) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getUid().equals(other.getUid())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (!internalGetAnnotations().equals(other.internalGetAnnotations())) return false;
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (getSuspended() != other.getSuspended()) return false;
    if (!getSelectorsList().equals(other.getSelectorsList())) return false;
    if (!getRulesList().equals(other.getRulesList())) return false;
    if (!getEtag().equals(other.getEtag())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + UID_FIELD_NUMBER;
    hash = (53 * hash) + getUid().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    if (!internalGetAnnotations().getMap().isEmpty()) {
      hash = (37 * hash) + ANNOTATIONS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetAnnotations().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    hash = (37 * hash) + SUSPENDED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSuspended());
    if (getSelectorsCount() > 0) {
      hash = (37 * hash) + SELECTORS_FIELD_NUMBER;
      hash = (53 * hash) + getSelectorsList().hashCode();
    }
    if (getRulesCount() > 0) {
      hash = (37 * hash) + RULES_FIELD_NUMBER;
      hash = (53 * hash) + getRulesList().hashCode();
    }
    hash = (37 * hash) + ETAG_FIELD_NUMBER;
    hash = (53 * hash) + getEtag().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.deploy.v1.DeployPolicy parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.DeployPolicy parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.DeployPolicy parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.DeployPolicy parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.DeployPolicy parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.DeployPolicy parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.DeployPolicy parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.DeployPolicy parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.DeployPolicy parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.DeployPolicy parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.DeployPolicy parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.DeployPolicy parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.deploy.v1.DeployPolicy prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A `DeployPolicy` resource in the Cloud Deploy API.
   *
   * A `DeployPolicy` inhibits manual or automation-driven actions within a
   * Delivery Pipeline or Target.
   * </pre>
   *
   * Protobuf type {@code google.cloud.deploy.v1.DeployPolicy}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.deploy.v1.DeployPolicy)
      com.google.cloud.deploy.v1.DeployPolicyOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_DeployPolicy_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 4:
          return internalGetAnnotations();
        case 5:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 4:
          return internalGetMutableAnnotations();
        case 5:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_DeployPolicy_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.deploy.v1.DeployPolicy.class,
              com.google.cloud.deploy.v1.DeployPolicy.Builder.class);
    }

    // Construct using com.google.cloud.deploy.v1.DeployPolicy.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreateTimeFieldBuilder();
        getUpdateTimeFieldBuilder();
        getSelectorsFieldBuilder();
        getRulesFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      uid_ = "";
      description_ = "";
      internalGetMutableAnnotations().clear();
      internalGetMutableLabels().clear();
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      suspended_ = false;
      if (selectorsBuilder_ == null) {
        selectors_ = java.util.Collections.emptyList();
      } else {
        selectors_ = null;
        selectorsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000100);
      if (rulesBuilder_ == null) {
        rules_ = java.util.Collections.emptyList();
      } else {
        rules_ = null;
        rulesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000200);
      etag_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_DeployPolicy_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.DeployPolicy getDefaultInstanceForType() {
      return com.google.cloud.deploy.v1.DeployPolicy.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.DeployPolicy build() {
      com.google.cloud.deploy.v1.DeployPolicy result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.DeployPolicy buildPartial() {
      com.google.cloud.deploy.v1.DeployPolicy result =
          new com.google.cloud.deploy.v1.DeployPolicy(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.deploy.v1.DeployPolicy result) {
      if (selectorsBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)) {
          selectors_ = java.util.Collections.unmodifiableList(selectors_);
          bitField0_ = (bitField0_ & ~0x00000100);
        }
        result.selectors_ = selectors_;
      } else {
        result.selectors_ = selectorsBuilder_.build();
      }
      if (rulesBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)) {
          rules_ = java.util.Collections.unmodifiableList(rules_);
          bitField0_ = (bitField0_ & ~0x00000200);
        }
        result.rules_ = rules_;
      } else {
        result.rules_ = rulesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.deploy.v1.DeployPolicy result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.uid_ = uid_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.annotations_ = internalGetAnnotations();
        result.annotations_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.suspended_ = suspended_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.etag_ = etag_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.deploy.v1.DeployPolicy) {
        return mergeFrom((com.google.cloud.deploy.v1.DeployPolicy) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.deploy.v1.DeployPolicy other) {
      if (other == com.google.cloud.deploy.v1.DeployPolicy.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getUid().isEmpty()) {
        uid_ = other.uid_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      internalGetMutableAnnotations().mergeFrom(other.internalGetAnnotations());
      bitField0_ |= 0x00000008;
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000010;
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (other.getSuspended() != false) {
        setSuspended(other.getSuspended());
      }
      if (selectorsBuilder_ == null) {
        if (!other.selectors_.isEmpty()) {
          if (selectors_.isEmpty()) {
            selectors_ = other.selectors_;
            bitField0_ = (bitField0_ & ~0x00000100);
          } else {
            ensureSelectorsIsMutable();
            selectors_.addAll(other.selectors_);
          }
          onChanged();
        }
      } else {
        if (!other.selectors_.isEmpty()) {
          if (selectorsBuilder_.isEmpty()) {
            selectorsBuilder_.dispose();
            selectorsBuilder_ = null;
            selectors_ = other.selectors_;
            bitField0_ = (bitField0_ & ~0x00000100);
            selectorsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getSelectorsFieldBuilder()
                    : null;
          } else {
            selectorsBuilder_.addAllMessages(other.selectors_);
          }
        }
      }
      if (rulesBuilder_ == null) {
        if (!other.rules_.isEmpty()) {
          if (rules_.isEmpty()) {
            rules_ = other.rules_;
            bitField0_ = (bitField0_ & ~0x00000200);
          } else {
            ensureRulesIsMutable();
            rules_.addAll(other.rules_);
          }
          onChanged();
        }
      } else {
        if (!other.rules_.isEmpty()) {
          if (rulesBuilder_.isEmpty()) {
            rulesBuilder_.dispose();
            rulesBuilder_ = null;
            rules_ = other.rules_;
            bitField0_ = (bitField0_ & ~0x00000200);
            rulesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getRulesFieldBuilder()
                    : null;
          } else {
            rulesBuilder_.addAllMessages(other.rules_);
          }
        }
      }
      if (!other.getEtag().isEmpty()) {
        etag_ = other.etag_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                uid_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> annotations__ =
                    input.readMessage(
                        AnnotationsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableAnnotations()
                    .getMutableMap()
                    .put(annotations__.getKey(), annotations__.getValue());
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 64:
              {
                suspended_ = input.readBool();
                bitField0_ |= 0x00000080;
                break;
              } // case 64
            case 82:
              {
                com.google.cloud.deploy.v1.PolicyRule m =
                    input.readMessage(
                        com.google.cloud.deploy.v1.PolicyRule.parser(), extensionRegistry);
                if (rulesBuilder_ == null) {
                  ensureRulesIsMutable();
                  rules_.add(m);
                } else {
                  rulesBuilder_.addMessage(m);
                }
                break;
              } // case 82
            case 90:
              {
                etag_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case 90
            case 98:
              {
                com.google.cloud.deploy.v1.DeployPolicyResourceSelector m =
                    input.readMessage(
                        com.google.cloud.deploy.v1.DeployPolicyResourceSelector.parser(),
                        extensionRegistry);
                if (selectorsBuilder_ == null) {
                  ensureSelectorsIsMutable();
                  selectors_.add(m);
                } else {
                  selectorsBuilder_.addMessage(m);
                }
                break;
              } // case 98
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Name of the `DeployPolicy`. Format is
     * `projects/{project}/locations/{location}/deployPolicies/{deployPolicy}`.
     * The `deployPolicy` component must match `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the `DeployPolicy`. Format is
     * `projects/{project}/locations/{location}/deployPolicies/{deployPolicy}`.
     * The `deployPolicy` component must match `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the `DeployPolicy`. Format is
     * `projects/{project}/locations/{location}/deployPolicies/{deployPolicy}`.
     * The `deployPolicy` component must match `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the `DeployPolicy`. Format is
     * `projects/{project}/locations/{location}/deployPolicies/{deployPolicy}`.
     * The `deployPolicy` component must match `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the `DeployPolicy`. Format is
     * `projects/{project}/locations/{location}/deployPolicies/{deployPolicy}`.
     * The `deployPolicy` component must match `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object uid_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier of the `DeployPolicy`.
     * </pre>
     *
     * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The uid.
     */
    public java.lang.String getUid() {
      java.lang.Object ref = uid_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uid_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier of the `DeployPolicy`.
     * </pre>
     *
     * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for uid.
     */
    public com.google.protobuf.ByteString getUidBytes() {
      java.lang.Object ref = uid_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        uid_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier of the `DeployPolicy`.
     * </pre>
     *
     * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The uid to set.
     * @return This builder for chaining.
     */
    public Builder setUid(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      uid_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier of the `DeployPolicy`.
     * </pre>
     *
     * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUid() {
      uid_ = getDefaultInstance().getUid();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier of the `DeployPolicy`.
     * </pre>
     *
     * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for uid to set.
     * @return This builder for chaining.
     */
    public Builder setUidBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      uid_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Description of the `DeployPolicy`. Max length is 255 characters.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Description of the `DeployPolicy`. Max length is 255 characters.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Description of the `DeployPolicy`. Max length is 255 characters.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Description of the `DeployPolicy`. Max length is 255 characters.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Description of the `DeployPolicy`. Max length is 255 characters.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> annotations_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetAnnotations() {
      if (annotations_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            AnnotationsDefaultEntryHolder.defaultEntry);
      }
      return annotations_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableAnnotations() {
      if (annotations_ == null) {
        annotations_ =
            com.google.protobuf.MapField.newMapField(AnnotationsDefaultEntryHolder.defaultEntry);
      }
      if (!annotations_.isMutable()) {
        annotations_ = annotations_.copy();
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return annotations_;
    }

    public int getAnnotationsCount() {
      return internalGetAnnotations().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * User annotations. These attributes can only be set and used by the
     * user, and not by Cloud Deploy. Annotations must meet the following
     * constraints:
     *
     * * Annotations are key/value pairs.
     * * Valid annotation keys have two segments: an optional prefix and name,
     * separated by a slash (`/`).
     * * The name segment is required and must be 63 characters or less,
     * beginning and ending with an alphanumeric character (`[a-z0-9A-Z]`) with
     * dashes (`-`), underscores (`_`), dots (`.`), and alphanumerics between.
     * * The prefix is optional. If specified, the prefix must be a DNS subdomain:
     * a series of DNS labels separated by dots(`.`), not longer than 253
     * characters in total, followed by a slash (`/`).
     *
     * See
     * https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations/#syntax-and-character-set
     * for more details.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 4;</code>
     */
    @java.lang.Override
    public boolean containsAnnotations(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetAnnotations().getMap().containsKey(key);
    }
    /** Use {@link #getAnnotationsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getAnnotations() {
      return getAnnotationsMap();
    }
    /**
     *
     *
     * <pre>
     * User annotations. These attributes can only be set and used by the
     * user, and not by Cloud Deploy. Annotations must meet the following
     * constraints:
     *
     * * Annotations are key/value pairs.
     * * Valid annotation keys have two segments: an optional prefix and name,
     * separated by a slash (`/`).
     * * The name segment is required and must be 63 characters or less,
     * beginning and ending with an alphanumeric character (`[a-z0-9A-Z]`) with
     * dashes (`-`), underscores (`_`), dots (`.`), and alphanumerics between.
     * * The prefix is optional. If specified, the prefix must be a DNS subdomain:
     * a series of DNS labels separated by dots(`.`), not longer than 253
     * characters in total, followed by a slash (`/`).
     *
     * See
     * https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations/#syntax-and-character-set
     * for more details.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 4;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getAnnotationsMap() {
      return internalGetAnnotations().getMap();
    }
    /**
     *
     *
     * <pre>
     * User annotations. These attributes can only be set and used by the
     * user, and not by Cloud Deploy. Annotations must meet the following
     * constraints:
     *
     * * Annotations are key/value pairs.
     * * Valid annotation keys have two segments: an optional prefix and name,
     * separated by a slash (`/`).
     * * The name segment is required and must be 63 characters or less,
     * beginning and ending with an alphanumeric character (`[a-z0-9A-Z]`) with
     * dashes (`-`), underscores (`_`), dots (`.`), and alphanumerics between.
     * * The prefix is optional. If specified, the prefix must be a DNS subdomain:
     * a series of DNS labels separated by dots(`.`), not longer than 253
     * characters in total, followed by a slash (`/`).
     *
     * See
     * https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations/#syntax-and-character-set
     * for more details.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 4;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getAnnotationsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * User annotations. These attributes can only be set and used by the
     * user, and not by Cloud Deploy. Annotations must meet the following
     * constraints:
     *
     * * Annotations are key/value pairs.
     * * Valid annotation keys have two segments: an optional prefix and name,
     * separated by a slash (`/`).
     * * The name segment is required and must be 63 characters or less,
     * beginning and ending with an alphanumeric character (`[a-z0-9A-Z]`) with
     * dashes (`-`), underscores (`_`), dots (`.`), and alphanumerics between.
     * * The prefix is optional. If specified, the prefix must be a DNS subdomain:
     * a series of DNS labels separated by dots(`.`), not longer than 253
     * characters in total, followed by a slash (`/`).
     *
     * See
     * https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations/#syntax-and-character-set
     * for more details.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 4;</code>
     */
    @java.lang.Override
    public java.lang.String getAnnotationsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearAnnotations() {
      bitField0_ = (bitField0_ & ~0x00000008);
      internalGetMutableAnnotations().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User annotations. These attributes can only be set and used by the
     * user, and not by Cloud Deploy. Annotations must meet the following
     * constraints:
     *
     * * Annotations are key/value pairs.
     * * Valid annotation keys have two segments: an optional prefix and name,
     * separated by a slash (`/`).
     * * The name segment is required and must be 63 characters or less,
     * beginning and ending with an alphanumeric character (`[a-z0-9A-Z]`) with
     * dashes (`-`), underscores (`_`), dots (`.`), and alphanumerics between.
     * * The prefix is optional. If specified, the prefix must be a DNS subdomain:
     * a series of DNS labels separated by dots(`.`), not longer than 253
     * characters in total, followed by a slash (`/`).
     *
     * See
     * https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations/#syntax-and-character-set
     * for more details.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 4;</code>
     */
    public Builder removeAnnotations(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableAnnotations().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableAnnotations() {
      bitField0_ |= 0x00000008;
      return internalGetMutableAnnotations().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * User annotations. These attributes can only be set and used by the
     * user, and not by Cloud Deploy. Annotations must meet the following
     * constraints:
     *
     * * Annotations are key/value pairs.
     * * Valid annotation keys have two segments: an optional prefix and name,
     * separated by a slash (`/`).
     * * The name segment is required and must be 63 characters or less,
     * beginning and ending with an alphanumeric character (`[a-z0-9A-Z]`) with
     * dashes (`-`), underscores (`_`), dots (`.`), and alphanumerics between.
     * * The prefix is optional. If specified, the prefix must be a DNS subdomain:
     * a series of DNS labels separated by dots(`.`), not longer than 253
     * characters in total, followed by a slash (`/`).
     *
     * See
     * https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations/#syntax-and-character-set
     * for more details.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 4;</code>
     */
    public Builder putAnnotations(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableAnnotations().getMutableMap().put(key, value);
      bitField0_ |= 0x00000008;
      return this;
    }
    /**
     *
     *
     * <pre>
     * User annotations. These attributes can only be set and used by the
     * user, and not by Cloud Deploy. Annotations must meet the following
     * constraints:
     *
     * * Annotations are key/value pairs.
     * * Valid annotation keys have two segments: an optional prefix and name,
     * separated by a slash (`/`).
     * * The name segment is required and must be 63 characters or less,
     * beginning and ending with an alphanumeric character (`[a-z0-9A-Z]`) with
     * dashes (`-`), underscores (`_`), dots (`.`), and alphanumerics between.
     * * The prefix is optional. If specified, the prefix must be a DNS subdomain:
     * a series of DNS labels separated by dots(`.`), not longer than 253
     * characters in total, followed by a slash (`/`).
     *
     * See
     * https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations/#syntax-and-character-set
     * for more details.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 4;</code>
     */
    public Builder putAllAnnotations(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableAnnotations().getMutableMap().putAll(values);
      bitField0_ |= 0x00000008;
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Labels are attributes that can be set and used by both the
     * user and by Cloud Deploy. Labels must meet the following constraints:
     *
     * * Keys and values can contain only lowercase letters, numeric characters,
     * underscores, and dashes.
     * * All characters must use UTF-8 encoding, and international characters are
     * allowed.
     * * Keys must start with a lowercase letter or international character.
     * * Each resource is limited to a maximum of 64 labels.
     *
     * Both keys and values are additionally constrained to be &lt;= 128 bytes.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Labels are attributes that can be set and used by both the
     * user and by Cloud Deploy. Labels must meet the following constraints:
     *
     * * Keys and values can contain only lowercase letters, numeric characters,
     * underscores, and dashes.
     * * All characters must use UTF-8 encoding, and international characters are
     * allowed.
     * * Keys must start with a lowercase letter or international character.
     * * Each resource is limited to a maximum of 64 labels.
     *
     * Both keys and values are additionally constrained to be &lt;= 128 bytes.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Labels are attributes that can be set and used by both the
     * user and by Cloud Deploy. Labels must meet the following constraints:
     *
     * * Keys and values can contain only lowercase letters, numeric characters,
     * underscores, and dashes.
     * * All characters must use UTF-8 encoding, and international characters are
     * allowed.
     * * Keys must start with a lowercase letter or international character.
     * * Each resource is limited to a maximum of 64 labels.
     *
     * Both keys and values are additionally constrained to be &lt;= 128 bytes.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Labels are attributes that can be set and used by both the
     * user and by Cloud Deploy. Labels must meet the following constraints:
     *
     * * Keys and values can contain only lowercase letters, numeric characters,
     * underscores, and dashes.
     * * All characters must use UTF-8 encoding, and international characters are
     * allowed.
     * * Keys must start with a lowercase letter or international character.
     * * Each resource is limited to a maximum of 64 labels.
     *
     * Both keys and values are additionally constrained to be &lt;= 128 bytes.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000010);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels are attributes that can be set and used by both the
     * user and by Cloud Deploy. Labels must meet the following constraints:
     *
     * * Keys and values can contain only lowercase letters, numeric characters,
     * underscores, and dashes.
     * * All characters must use UTF-8 encoding, and international characters are
     * allowed.
     * * Keys must start with a lowercase letter or international character.
     * * Each resource is limited to a maximum of 64 labels.
     *
     * Both keys and values are additionally constrained to be &lt;= 128 bytes.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000010;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Labels are attributes that can be set and used by both the
     * user and by Cloud Deploy. Labels must meet the following constraints:
     *
     * * Keys and values can contain only lowercase letters, numeric characters,
     * underscores, and dashes.
     * * All characters must use UTF-8 encoding, and international characters are
     * allowed.
     * * Keys must start with a lowercase letter or international character.
     * * Each resource is limited to a maximum of 64 labels.
     *
     * Both keys and values are additionally constrained to be &lt;= 128 bytes.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000010;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels are attributes that can be set and used by both the
     * user and by Cloud Deploy. Labels must meet the following constraints:
     *
     * * Keys and values can contain only lowercase letters, numeric characters,
     * underscores, and dashes.
     * * All characters must use UTF-8 encoding, and international characters are
     * allowed.
     * * Keys must start with a lowercase letter or international character.
     * * Each resource is limited to a maximum of 64 labels.
     *
     * Both keys and values are additionally constrained to be &lt;= 128 bytes.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000010;
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Time at which the deploy policy was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the deploy policy was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the deploy policy was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the deploy policy was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the deploy policy was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the deploy policy was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000020);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the deploy policy was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the deploy policy was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the deploy policy was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Most recent time at which the deploy policy was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Most recent time at which the deploy policy was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Most recent time at which the deploy policy was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Most recent time at which the deploy policy was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Most recent time at which the deploy policy was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Most recent time at which the deploy policy was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000040);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Most recent time at which the deploy policy was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Most recent time at which the deploy policy was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Most recent time at which the deploy policy was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private boolean suspended_;
    /**
     *
     *
     * <pre>
     * When suspended, the policy will not prevent actions from occurring, even
     * if the action violates the policy.
     * </pre>
     *
     * <code>bool suspended = 8;</code>
     *
     * @return The suspended.
     */
    @java.lang.Override
    public boolean getSuspended() {
      return suspended_;
    }
    /**
     *
     *
     * <pre>
     * When suspended, the policy will not prevent actions from occurring, even
     * if the action violates the policy.
     * </pre>
     *
     * <code>bool suspended = 8;</code>
     *
     * @param value The suspended to set.
     * @return This builder for chaining.
     */
    public Builder setSuspended(boolean value) {

      suspended_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * When suspended, the policy will not prevent actions from occurring, even
     * if the action violates the policy.
     * </pre>
     *
     * <code>bool suspended = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSuspended() {
      bitField0_ = (bitField0_ & ~0x00000080);
      suspended_ = false;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.deploy.v1.DeployPolicyResourceSelector> selectors_ =
        java.util.Collections.emptyList();

    private void ensureSelectorsIsMutable() {
      if (!((bitField0_ & 0x00000100) != 0)) {
        selectors_ =
            new java.util.ArrayList<com.google.cloud.deploy.v1.DeployPolicyResourceSelector>(
                selectors_);
        bitField0_ |= 0x00000100;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.deploy.v1.DeployPolicyResourceSelector,
            com.google.cloud.deploy.v1.DeployPolicyResourceSelector.Builder,
            com.google.cloud.deploy.v1.DeployPolicyResourceSelectorOrBuilder>
        selectorsBuilder_;

    /**
     *
     *
     * <pre>
     * Required. Selected resources to which the policy will be applied. At least
     * one selector is required. If one selector matches the resource the policy
     * applies. For example, if there are two selectors and the action being
     * attempted matches one of them, the policy will apply to that action.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.DeployPolicyResourceSelector selectors = 12 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.deploy.v1.DeployPolicyResourceSelector>
        getSelectorsList() {
      if (selectorsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(selectors_);
      } else {
        return selectorsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Selected resources to which the policy will be applied. At least
     * one selector is required. If one selector matches the resource the policy
     * applies. For example, if there are two selectors and the action being
     * attempted matches one of them, the policy will apply to that action.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.DeployPolicyResourceSelector selectors = 12 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public int getSelectorsCount() {
      if (selectorsBuilder_ == null) {
        return selectors_.size();
      } else {
        return selectorsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Selected resources to which the policy will be applied. At least
     * one selector is required. If one selector matches the resource the policy
     * applies. For example, if there are two selectors and the action being
     * attempted matches one of them, the policy will apply to that action.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.DeployPolicyResourceSelector selectors = 12 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.deploy.v1.DeployPolicyResourceSelector getSelectors(int index) {
      if (selectorsBuilder_ == null) {
        return selectors_.get(index);
      } else {
        return selectorsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Selected resources to which the policy will be applied. At least
     * one selector is required. If one selector matches the resource the policy
     * applies. For example, if there are two selectors and the action being
     * attempted matches one of them, the policy will apply to that action.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.DeployPolicyResourceSelector selectors = 12 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setSelectors(
        int index, com.google.cloud.deploy.v1.DeployPolicyResourceSelector value) {
      if (selectorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSelectorsIsMutable();
        selectors_.set(index, value);
        onChanged();
      } else {
        selectorsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Selected resources to which the policy will be applied. At least
     * one selector is required. If one selector matches the resource the policy
     * applies. For example, if there are two selectors and the action being
     * attempted matches one of them, the policy will apply to that action.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.DeployPolicyResourceSelector selectors = 12 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setSelectors(
        int index,
        com.google.cloud.deploy.v1.DeployPolicyResourceSelector.Builder builderForValue) {
      if (selectorsBuilder_ == null) {
        ensureSelectorsIsMutable();
        selectors_.set(index, builderForValue.build());
        onChanged();
      } else {
        selectorsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Selected resources to which the policy will be applied. At least
     * one selector is required. If one selector matches the resource the policy
     * applies. For example, if there are two selectors and the action being
     * attempted matches one of them, the policy will apply to that action.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.DeployPolicyResourceSelector selectors = 12 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addSelectors(com.google.cloud.deploy.v1.DeployPolicyResourceSelector value) {
      if (selectorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSelectorsIsMutable();
        selectors_.add(value);
        onChanged();
      } else {
        selectorsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Selected resources to which the policy will be applied. At least
     * one selector is required. If one selector matches the resource the policy
     * applies. For example, if there are two selectors and the action being
     * attempted matches one of them, the policy will apply to that action.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.DeployPolicyResourceSelector selectors = 12 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addSelectors(
        int index, com.google.cloud.deploy.v1.DeployPolicyResourceSelector value) {
      if (selectorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSelectorsIsMutable();
        selectors_.add(index, value);
        onChanged();
      } else {
        selectorsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Selected resources to which the policy will be applied. At least
     * one selector is required. If one selector matches the resource the policy
     * applies. For example, if there are two selectors and the action being
     * attempted matches one of them, the policy will apply to that action.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.DeployPolicyResourceSelector selectors = 12 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addSelectors(
        com.google.cloud.deploy.v1.DeployPolicyResourceSelector.Builder builderForValue) {
      if (selectorsBuilder_ == null) {
        ensureSelectorsIsMutable();
        selectors_.add(builderForValue.build());
        onChanged();
      } else {
        selectorsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Selected resources to which the policy will be applied. At least
     * one selector is required. If one selector matches the resource the policy
     * applies. For example, if there are two selectors and the action being
     * attempted matches one of them, the policy will apply to that action.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.DeployPolicyResourceSelector selectors = 12 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addSelectors(
        int index,
        com.google.cloud.deploy.v1.DeployPolicyResourceSelector.Builder builderForValue) {
      if (selectorsBuilder_ == null) {
        ensureSelectorsIsMutable();
        selectors_.add(index, builderForValue.build());
        onChanged();
      } else {
        selectorsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Selected resources to which the policy will be applied. At least
     * one selector is required. If one selector matches the resource the policy
     * applies. For example, if there are two selectors and the action being
     * attempted matches one of them, the policy will apply to that action.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.DeployPolicyResourceSelector selectors = 12 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addAllSelectors(
        java.lang.Iterable<? extends com.google.cloud.deploy.v1.DeployPolicyResourceSelector>
            values) {
      if (selectorsBuilder_ == null) {
        ensureSelectorsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, selectors_);
        onChanged();
      } else {
        selectorsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Selected resources to which the policy will be applied. At least
     * one selector is required. If one selector matches the resource the policy
     * applies. For example, if there are two selectors and the action being
     * attempted matches one of them, the policy will apply to that action.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.DeployPolicyResourceSelector selectors = 12 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearSelectors() {
      if (selectorsBuilder_ == null) {
        selectors_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000100);
        onChanged();
      } else {
        selectorsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Selected resources to which the policy will be applied. At least
     * one selector is required. If one selector matches the resource the policy
     * applies. For example, if there are two selectors and the action being
     * attempted matches one of them, the policy will apply to that action.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.DeployPolicyResourceSelector selectors = 12 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder removeSelectors(int index) {
      if (selectorsBuilder_ == null) {
        ensureSelectorsIsMutable();
        selectors_.remove(index);
        onChanged();
      } else {
        selectorsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Selected resources to which the policy will be applied. At least
     * one selector is required. If one selector matches the resource the policy
     * applies. For example, if there are two selectors and the action being
     * attempted matches one of them, the policy will apply to that action.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.DeployPolicyResourceSelector selectors = 12 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.deploy.v1.DeployPolicyResourceSelector.Builder getSelectorsBuilder(
        int index) {
      return getSelectorsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Required. Selected resources to which the policy will be applied. At least
     * one selector is required. If one selector matches the resource the policy
     * applies. For example, if there are two selectors and the action being
     * attempted matches one of them, the policy will apply to that action.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.DeployPolicyResourceSelector selectors = 12 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.deploy.v1.DeployPolicyResourceSelectorOrBuilder getSelectorsOrBuilder(
        int index) {
      if (selectorsBuilder_ == null) {
        return selectors_.get(index);
      } else {
        return selectorsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Selected resources to which the policy will be applied. At least
     * one selector is required. If one selector matches the resource the policy
     * applies. For example, if there are two selectors and the action being
     * attempted matches one of them, the policy will apply to that action.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.DeployPolicyResourceSelector selectors = 12 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.deploy.v1.DeployPolicyResourceSelectorOrBuilder>
        getSelectorsOrBuilderList() {
      if (selectorsBuilder_ != null) {
        return selectorsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(selectors_);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Selected resources to which the policy will be applied. At least
     * one selector is required. If one selector matches the resource the policy
     * applies. For example, if there are two selectors and the action being
     * attempted matches one of them, the policy will apply to that action.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.DeployPolicyResourceSelector selectors = 12 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.deploy.v1.DeployPolicyResourceSelector.Builder addSelectorsBuilder() {
      return getSelectorsFieldBuilder()
          .addBuilder(com.google.cloud.deploy.v1.DeployPolicyResourceSelector.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. Selected resources to which the policy will be applied. At least
     * one selector is required. If one selector matches the resource the policy
     * applies. For example, if there are two selectors and the action being
     * attempted matches one of them, the policy will apply to that action.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.DeployPolicyResourceSelector selectors = 12 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.deploy.v1.DeployPolicyResourceSelector.Builder addSelectorsBuilder(
        int index) {
      return getSelectorsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.deploy.v1.DeployPolicyResourceSelector.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. Selected resources to which the policy will be applied. At least
     * one selector is required. If one selector matches the resource the policy
     * applies. For example, if there are two selectors and the action being
     * attempted matches one of them, the policy will apply to that action.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.DeployPolicyResourceSelector selectors = 12 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.deploy.v1.DeployPolicyResourceSelector.Builder>
        getSelectorsBuilderList() {
      return getSelectorsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.deploy.v1.DeployPolicyResourceSelector,
            com.google.cloud.deploy.v1.DeployPolicyResourceSelector.Builder,
            com.google.cloud.deploy.v1.DeployPolicyResourceSelectorOrBuilder>
        getSelectorsFieldBuilder() {
      if (selectorsBuilder_ == null) {
        selectorsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.deploy.v1.DeployPolicyResourceSelector,
                com.google.cloud.deploy.v1.DeployPolicyResourceSelector.Builder,
                com.google.cloud.deploy.v1.DeployPolicyResourceSelectorOrBuilder>(
                selectors_, ((bitField0_ & 0x00000100) != 0), getParentForChildren(), isClean());
        selectors_ = null;
      }
      return selectorsBuilder_;
    }

    private java.util.List<com.google.cloud.deploy.v1.PolicyRule> rules_ =
        java.util.Collections.emptyList();

    private void ensureRulesIsMutable() {
      if (!((bitField0_ & 0x00000200) != 0)) {
        rules_ = new java.util.ArrayList<com.google.cloud.deploy.v1.PolicyRule>(rules_);
        bitField0_ |= 0x00000200;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.deploy.v1.PolicyRule,
            com.google.cloud.deploy.v1.PolicyRule.Builder,
            com.google.cloud.deploy.v1.PolicyRuleOrBuilder>
        rulesBuilder_;

    /**
     *
     *
     * <pre>
     * Required. Rules to apply. At least one rule must be present.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.PolicyRule rules = 10 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.deploy.v1.PolicyRule> getRulesList() {
      if (rulesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(rules_);
      } else {
        return rulesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Rules to apply. At least one rule must be present.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.PolicyRule rules = 10 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public int getRulesCount() {
      if (rulesBuilder_ == null) {
        return rules_.size();
      } else {
        return rulesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Rules to apply. At least one rule must be present.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.PolicyRule rules = 10 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.deploy.v1.PolicyRule getRules(int index) {
      if (rulesBuilder_ == null) {
        return rules_.get(index);
      } else {
        return rulesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Rules to apply. At least one rule must be present.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.PolicyRule rules = 10 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setRules(int index, com.google.cloud.deploy.v1.PolicyRule value) {
      if (rulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRulesIsMutable();
        rules_.set(index, value);
        onChanged();
      } else {
        rulesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Rules to apply. At least one rule must be present.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.PolicyRule rules = 10 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setRules(
        int index, com.google.cloud.deploy.v1.PolicyRule.Builder builderForValue) {
      if (rulesBuilder_ == null) {
        ensureRulesIsMutable();
        rules_.set(index, builderForValue.build());
        onChanged();
      } else {
        rulesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Rules to apply. At least one rule must be present.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.PolicyRule rules = 10 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addRules(com.google.cloud.deploy.v1.PolicyRule value) {
      if (rulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRulesIsMutable();
        rules_.add(value);
        onChanged();
      } else {
        rulesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Rules to apply. At least one rule must be present.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.PolicyRule rules = 10 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addRules(int index, com.google.cloud.deploy.v1.PolicyRule value) {
      if (rulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRulesIsMutable();
        rules_.add(index, value);
        onChanged();
      } else {
        rulesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Rules to apply. At least one rule must be present.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.PolicyRule rules = 10 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addRules(com.google.cloud.deploy.v1.PolicyRule.Builder builderForValue) {
      if (rulesBuilder_ == null) {
        ensureRulesIsMutable();
        rules_.add(builderForValue.build());
        onChanged();
      } else {
        rulesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Rules to apply. At least one rule must be present.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.PolicyRule rules = 10 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addRules(
        int index, com.google.cloud.deploy.v1.PolicyRule.Builder builderForValue) {
      if (rulesBuilder_ == null) {
        ensureRulesIsMutable();
        rules_.add(index, builderForValue.build());
        onChanged();
      } else {
        rulesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Rules to apply. At least one rule must be present.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.PolicyRule rules = 10 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addAllRules(
        java.lang.Iterable<? extends com.google.cloud.deploy.v1.PolicyRule> values) {
      if (rulesBuilder_ == null) {
        ensureRulesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, rules_);
        onChanged();
      } else {
        rulesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Rules to apply. At least one rule must be present.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.PolicyRule rules = 10 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearRules() {
      if (rulesBuilder_ == null) {
        rules_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000200);
        onChanged();
      } else {
        rulesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Rules to apply. At least one rule must be present.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.PolicyRule rules = 10 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder removeRules(int index) {
      if (rulesBuilder_ == null) {
        ensureRulesIsMutable();
        rules_.remove(index);
        onChanged();
      } else {
        rulesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Rules to apply. At least one rule must be present.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.PolicyRule rules = 10 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.deploy.v1.PolicyRule.Builder getRulesBuilder(int index) {
      return getRulesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Required. Rules to apply. At least one rule must be present.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.PolicyRule rules = 10 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.deploy.v1.PolicyRuleOrBuilder getRulesOrBuilder(int index) {
      if (rulesBuilder_ == null) {
        return rules_.get(index);
      } else {
        return rulesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Rules to apply. At least one rule must be present.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.PolicyRule rules = 10 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.deploy.v1.PolicyRuleOrBuilder>
        getRulesOrBuilderList() {
      if (rulesBuilder_ != null) {
        return rulesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(rules_);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Rules to apply. At least one rule must be present.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.PolicyRule rules = 10 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.deploy.v1.PolicyRule.Builder addRulesBuilder() {
      return getRulesFieldBuilder()
          .addBuilder(com.google.cloud.deploy.v1.PolicyRule.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. Rules to apply. At least one rule must be present.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.PolicyRule rules = 10 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.deploy.v1.PolicyRule.Builder addRulesBuilder(int index) {
      return getRulesFieldBuilder()
          .addBuilder(index, com.google.cloud.deploy.v1.PolicyRule.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. Rules to apply. At least one rule must be present.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.PolicyRule rules = 10 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.deploy.v1.PolicyRule.Builder> getRulesBuilderList() {
      return getRulesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.deploy.v1.PolicyRule,
            com.google.cloud.deploy.v1.PolicyRule.Builder,
            com.google.cloud.deploy.v1.PolicyRuleOrBuilder>
        getRulesFieldBuilder() {
      if (rulesBuilder_ == null) {
        rulesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.deploy.v1.PolicyRule,
                com.google.cloud.deploy.v1.PolicyRule.Builder,
                com.google.cloud.deploy.v1.PolicyRuleOrBuilder>(
                rules_, ((bitField0_ & 0x00000200) != 0), getParentForChildren(), isClean());
        rules_ = null;
      }
      return rulesBuilder_;
    }

    private java.lang.Object etag_ = "";
    /**
     *
     *
     * <pre>
     * The weak etag of the `Automation` resource.
     * This checksum is computed by the server based on the value of other
     * fields, and may be sent on update and delete requests to ensure the
     * client has an up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 11;</code>
     *
     * @return The etag.
     */
    public java.lang.String getEtag() {
      java.lang.Object ref = etag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        etag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The weak etag of the `Automation` resource.
     * This checksum is computed by the server based on the value of other
     * fields, and may be sent on update and delete requests to ensure the
     * client has an up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 11;</code>
     *
     * @return The bytes for etag.
     */
    public com.google.protobuf.ByteString getEtagBytes() {
      java.lang.Object ref = etag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        etag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The weak etag of the `Automation` resource.
     * This checksum is computed by the server based on the value of other
     * fields, and may be sent on update and delete requests to ensure the
     * client has an up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 11;</code>
     *
     * @param value The etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      etag_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The weak etag of the `Automation` resource.
     * This checksum is computed by the server based on the value of other
     * fields, and may be sent on update and delete requests to ensure the
     * client has an up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEtag() {
      etag_ = getDefaultInstance().getEtag();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The weak etag of the `Automation` resource.
     * This checksum is computed by the server based on the value of other
     * fields, and may be sent on update and delete requests to ensure the
     * client has an up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 11;</code>
     *
     * @param value The bytes for etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      etag_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.deploy.v1.DeployPolicy)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.deploy.v1.DeployPolicy)
  private static final com.google.cloud.deploy.v1.DeployPolicy DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.deploy.v1.DeployPolicy();
  }

  public static com.google.cloud.deploy.v1.DeployPolicy getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DeployPolicy> PARSER =
      new com.google.protobuf.AbstractParser<DeployPolicy>() {
        @java.lang.Override
        public DeployPolicy parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<DeployPolicy> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DeployPolicy> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.deploy.v1.DeployPolicy getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
