/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/deploy/v1/deploypolicy_evaluation_payload.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.deploy.v1;

/**
 *
 *
 * <pre>
 * Payload proto for "clouddeploy.googleapis.com/deploypolicy_evaluation"
 * Platform Log event that describes the deploy policy evaluation event.
 * </pre>
 *
 * Protobuf type {@code google.cloud.deploy.v1.DeployPolicyEvaluationEvent}
 */
public final class DeployPolicyEvaluationEvent extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.deploy.v1.DeployPolicyEvaluationEvent)
    DeployPolicyEvaluationEventOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use DeployPolicyEvaluationEvent.newBuilder() to construct.
  private DeployPolicyEvaluationEvent(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DeployPolicyEvaluationEvent() {
    message_ = "";
    ruleType_ = "";
    rule_ = "";
    pipelineUid_ = "";
    deliveryPipeline_ = "";
    targetUid_ = "";
    target_ = "";
    invoker_ = 0;
    deployPolicy_ = "";
    deployPolicyUid_ = "";
    verdict_ = 0;
    overrides_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DeployPolicyEvaluationEvent();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.deploy.v1.DeployPolicyEvaluationPayloadProto
        .internal_static_google_cloud_deploy_v1_DeployPolicyEvaluationEvent_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.deploy.v1.DeployPolicyEvaluationPayloadProto
        .internal_static_google_cloud_deploy_v1_DeployPolicyEvaluationEvent_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.deploy.v1.DeployPolicyEvaluationEvent.class,
            com.google.cloud.deploy.v1.DeployPolicyEvaluationEvent.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The policy verdict of the request.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.deploy.v1.DeployPolicyEvaluationEvent.PolicyVerdict}
   */
  public enum PolicyVerdict implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * This should never happen.
     * </pre>
     *
     * <code>POLICY_VERDICT_UNSPECIFIED = 0;</code>
     */
    POLICY_VERDICT_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Allowed by policy. This enum value is not currently used but may be used
     * in the future. Currently logs are only generated when a request is denied
     * by policy.
     * </pre>
     *
     * <code>ALLOWED_BY_POLICY = 1;</code>
     */
    ALLOWED_BY_POLICY(1),
    /**
     *
     *
     * <pre>
     * Denied by policy.
     * </pre>
     *
     * <code>DENIED_BY_POLICY = 2;</code>
     */
    DENIED_BY_POLICY(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * This should never happen.
     * </pre>
     *
     * <code>POLICY_VERDICT_UNSPECIFIED = 0;</code>
     */
    public static final int POLICY_VERDICT_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Allowed by policy. This enum value is not currently used but may be used
     * in the future. Currently logs are only generated when a request is denied
     * by policy.
     * </pre>
     *
     * <code>ALLOWED_BY_POLICY = 1;</code>
     */
    public static final int ALLOWED_BY_POLICY_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Denied by policy.
     * </pre>
     *
     * <code>DENIED_BY_POLICY = 2;</code>
     */
    public static final int DENIED_BY_POLICY_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static PolicyVerdict valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static PolicyVerdict forNumber(int value) {
      switch (value) {
        case 0:
          return POLICY_VERDICT_UNSPECIFIED;
        case 1:
          return ALLOWED_BY_POLICY;
        case 2:
          return DENIED_BY_POLICY;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<PolicyVerdict> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<PolicyVerdict> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<PolicyVerdict>() {
          public PolicyVerdict findValueByNumber(int number) {
            return PolicyVerdict.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.deploy.v1.DeployPolicyEvaluationEvent.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final PolicyVerdict[] VALUES = values();

    public static PolicyVerdict valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private PolicyVerdict(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.deploy.v1.DeployPolicyEvaluationEvent.PolicyVerdict)
  }

  /**
   *
   *
   * <pre>
   * Things that could have overridden the policy verdict. When overrides are
   * used, the request will be allowed even if it is DENIED_BY_POLICY.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.deploy.v1.DeployPolicyEvaluationEvent.PolicyVerdictOverride}
   */
  public enum PolicyVerdictOverride implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * This should never happen.
     * </pre>
     *
     * <code>POLICY_VERDICT_OVERRIDE_UNSPECIFIED = 0;</code>
     */
    POLICY_VERDICT_OVERRIDE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The policy was overridden.
     * </pre>
     *
     * <code>POLICY_OVERRIDDEN = 1;</code>
     */
    POLICY_OVERRIDDEN(1),
    /**
     *
     *
     * <pre>
     * The policy was suspended.
     * </pre>
     *
     * <code>POLICY_SUSPENDED = 2;</code>
     */
    POLICY_SUSPENDED(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * This should never happen.
     * </pre>
     *
     * <code>POLICY_VERDICT_OVERRIDE_UNSPECIFIED = 0;</code>
     */
    public static final int POLICY_VERDICT_OVERRIDE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The policy was overridden.
     * </pre>
     *
     * <code>POLICY_OVERRIDDEN = 1;</code>
     */
    public static final int POLICY_OVERRIDDEN_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The policy was suspended.
     * </pre>
     *
     * <code>POLICY_SUSPENDED = 2;</code>
     */
    public static final int POLICY_SUSPENDED_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static PolicyVerdictOverride valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static PolicyVerdictOverride forNumber(int value) {
      switch (value) {
        case 0:
          return POLICY_VERDICT_OVERRIDE_UNSPECIFIED;
        case 1:
          return POLICY_OVERRIDDEN;
        case 2:
          return POLICY_SUSPENDED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<PolicyVerdictOverride>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<PolicyVerdictOverride>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<PolicyVerdictOverride>() {
              public PolicyVerdictOverride findValueByNumber(int number) {
                return PolicyVerdictOverride.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.deploy.v1.DeployPolicyEvaluationEvent.getDescriptor()
          .getEnumTypes()
          .get(1);
    }

    private static final PolicyVerdictOverride[] VALUES = values();

    public static PolicyVerdictOverride valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private PolicyVerdictOverride(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.deploy.v1.DeployPolicyEvaluationEvent.PolicyVerdictOverride)
  }

  public static final int MESSAGE_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object message_ = "";
  /**
   *
   *
   * <pre>
   * Debug message for when a deploy policy event occurs.
   * </pre>
   *
   * <code>string message = 1;</code>
   *
   * @return The message.
   */
  @java.lang.Override
  public java.lang.String getMessage() {
    java.lang.Object ref = message_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      message_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Debug message for when a deploy policy event occurs.
   * </pre>
   *
   * <code>string message = 1;</code>
   *
   * @return The bytes for message.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMessageBytes() {
    java.lang.Object ref = message_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      message_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RULE_TYPE_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object ruleType_ = "";
  /**
   *
   *
   * <pre>
   * Rule type (e.g. Restrict Rollouts).
   * </pre>
   *
   * <code>string rule_type = 2;</code>
   *
   * @return The ruleType.
   */
  @java.lang.Override
  public java.lang.String getRuleType() {
    java.lang.Object ref = ruleType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      ruleType_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Rule type (e.g. Restrict Rollouts).
   * </pre>
   *
   * <code>string rule_type = 2;</code>
   *
   * @return The bytes for ruleType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRuleTypeBytes() {
    java.lang.Object ref = ruleType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      ruleType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RULE_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object rule_ = "";
  /**
   *
   *
   * <pre>
   * Rule id.
   * </pre>
   *
   * <code>string rule = 3;</code>
   *
   * @return The rule.
   */
  @java.lang.Override
  public java.lang.String getRule() {
    java.lang.Object ref = rule_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      rule_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Rule id.
   * </pre>
   *
   * <code>string rule = 3;</code>
   *
   * @return The bytes for rule.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRuleBytes() {
    java.lang.Object ref = rule_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      rule_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PIPELINE_UID_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object pipelineUid_ = "";
  /**
   *
   *
   * <pre>
   * Unique identifier of the `Delivery Pipeline`.
   * </pre>
   *
   * <code>string pipeline_uid = 4;</code>
   *
   * @return The pipelineUid.
   */
  @java.lang.Override
  public java.lang.String getPipelineUid() {
    java.lang.Object ref = pipelineUid_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      pipelineUid_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Unique identifier of the `Delivery Pipeline`.
   * </pre>
   *
   * <code>string pipeline_uid = 4;</code>
   *
   * @return The bytes for pipelineUid.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPipelineUidBytes() {
    java.lang.Object ref = pipelineUid_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      pipelineUid_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DELIVERY_PIPELINE_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object deliveryPipeline_ = "";
  /**
   *
   *
   * <pre>
   * The name of the `Delivery Pipeline`.
   * </pre>
   *
   * <code>string delivery_pipeline = 5;</code>
   *
   * @return The deliveryPipeline.
   */
  @java.lang.Override
  public java.lang.String getDeliveryPipeline() {
    java.lang.Object ref = deliveryPipeline_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      deliveryPipeline_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of the `Delivery Pipeline`.
   * </pre>
   *
   * <code>string delivery_pipeline = 5;</code>
   *
   * @return The bytes for deliveryPipeline.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDeliveryPipelineBytes() {
    java.lang.Object ref = deliveryPipeline_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      deliveryPipeline_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TARGET_UID_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object targetUid_ = "";
  /**
   *
   *
   * <pre>
   * Unique identifier of the `Target`. This is an optional field, as a `Target`
   * may not always be applicable to a policy.
   * </pre>
   *
   * <code>string target_uid = 6;</code>
   *
   * @return The targetUid.
   */
  @java.lang.Override
  public java.lang.String getTargetUid() {
    java.lang.Object ref = targetUid_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      targetUid_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Unique identifier of the `Target`. This is an optional field, as a `Target`
   * may not always be applicable to a policy.
   * </pre>
   *
   * <code>string target_uid = 6;</code>
   *
   * @return The bytes for targetUid.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTargetUidBytes() {
    java.lang.Object ref = targetUid_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      targetUid_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TARGET_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object target_ = "";
  /**
   *
   *
   * <pre>
   * The name of the `Target`. This is an optional field, as a `Target` may not
   * always be applicable to a policy.
   * </pre>
   *
   * <code>string target = 7;</code>
   *
   * @return The target.
   */
  @java.lang.Override
  public java.lang.String getTarget() {
    java.lang.Object ref = target_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      target_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of the `Target`. This is an optional field, as a `Target` may not
   * always be applicable to a policy.
   * </pre>
   *
   * <code>string target = 7;</code>
   *
   * @return The bytes for target.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTargetBytes() {
    java.lang.Object ref = target_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      target_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INVOKER_FIELD_NUMBER = 8;
  private int invoker_ = 0;
  /**
   *
   *
   * <pre>
   * What invoked the action (e.g. a user or automation).
   * </pre>
   *
   * <code>.google.cloud.deploy.v1.DeployPolicy.Invoker invoker = 8;</code>
   *
   * @return The enum numeric value on the wire for invoker.
   */
  @java.lang.Override
  public int getInvokerValue() {
    return invoker_;
  }
  /**
   *
   *
   * <pre>
   * What invoked the action (e.g. a user or automation).
   * </pre>
   *
   * <code>.google.cloud.deploy.v1.DeployPolicy.Invoker invoker = 8;</code>
   *
   * @return The invoker.
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.DeployPolicy.Invoker getInvoker() {
    com.google.cloud.deploy.v1.DeployPolicy.Invoker result =
        com.google.cloud.deploy.v1.DeployPolicy.Invoker.forNumber(invoker_);
    return result == null ? com.google.cloud.deploy.v1.DeployPolicy.Invoker.UNRECOGNIZED : result;
  }

  public static final int DEPLOY_POLICY_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private volatile java.lang.Object deployPolicy_ = "";
  /**
   *
   *
   * <pre>
   * The name of the `DeployPolicy`.
   * </pre>
   *
   * <code>string deploy_policy = 9;</code>
   *
   * @return The deployPolicy.
   */
  @java.lang.Override
  public java.lang.String getDeployPolicy() {
    java.lang.Object ref = deployPolicy_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      deployPolicy_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of the `DeployPolicy`.
   * </pre>
   *
   * <code>string deploy_policy = 9;</code>
   *
   * @return The bytes for deployPolicy.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDeployPolicyBytes() {
    java.lang.Object ref = deployPolicy_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      deployPolicy_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DEPLOY_POLICY_UID_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private volatile java.lang.Object deployPolicyUid_ = "";
  /**
   *
   *
   * <pre>
   * Unique identifier of the `DeployPolicy`.
   * </pre>
   *
   * <code>string deploy_policy_uid = 10;</code>
   *
   * @return The deployPolicyUid.
   */
  @java.lang.Override
  public java.lang.String getDeployPolicyUid() {
    java.lang.Object ref = deployPolicyUid_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      deployPolicyUid_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Unique identifier of the `DeployPolicy`.
   * </pre>
   *
   * <code>string deploy_policy_uid = 10;</code>
   *
   * @return The bytes for deployPolicyUid.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDeployPolicyUidBytes() {
    java.lang.Object ref = deployPolicyUid_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      deployPolicyUid_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ALLOWED_FIELD_NUMBER = 11;
  private boolean allowed_ = false;
  /**
   *
   *
   * <pre>
   * Whether the request is allowed. Allowed is set as true if:
   * (1) the request complies with the policy; or
   * (2) the request doesn't comply with the policy but the policy was
   * overridden; or
   * (3) the request doesn't comply with the policy but the policy was suspended
   * </pre>
   *
   * <code>bool allowed = 11;</code>
   *
   * @return The allowed.
   */
  @java.lang.Override
  public boolean getAllowed() {
    return allowed_;
  }

  public static final int VERDICT_FIELD_NUMBER = 12;
  private int verdict_ = 0;
  /**
   *
   *
   * <pre>
   * The policy verdict of the request.
   * </pre>
   *
   * <code>.google.cloud.deploy.v1.DeployPolicyEvaluationEvent.PolicyVerdict verdict = 12;</code>
   *
   * @return The enum numeric value on the wire for verdict.
   */
  @java.lang.Override
  public int getVerdictValue() {
    return verdict_;
  }
  /**
   *
   *
   * <pre>
   * The policy verdict of the request.
   * </pre>
   *
   * <code>.google.cloud.deploy.v1.DeployPolicyEvaluationEvent.PolicyVerdict verdict = 12;</code>
   *
   * @return The verdict.
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.DeployPolicyEvaluationEvent.PolicyVerdict getVerdict() {
    com.google.cloud.deploy.v1.DeployPolicyEvaluationEvent.PolicyVerdict result =
        com.google.cloud.deploy.v1.DeployPolicyEvaluationEvent.PolicyVerdict.forNumber(verdict_);
    return result == null
        ? com.google.cloud.deploy.v1.DeployPolicyEvaluationEvent.PolicyVerdict.UNRECOGNIZED
        : result;
  }

  public static final int OVERRIDES_FIELD_NUMBER = 13;

  @SuppressWarnings("serial")
  private java.util.List<java.lang.Integer> overrides_;

  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer,
          com.google.cloud.deploy.v1.DeployPolicyEvaluationEvent.PolicyVerdictOverride>
      overrides_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer,
              com.google.cloud.deploy.v1.DeployPolicyEvaluationEvent.PolicyVerdictOverride>() {
            public com.google.cloud.deploy.v1.DeployPolicyEvaluationEvent.PolicyVerdictOverride
                convert(java.lang.Integer from) {
              com.google.cloud.deploy.v1.DeployPolicyEvaluationEvent.PolicyVerdictOverride result =
                  com.google.cloud.deploy.v1.DeployPolicyEvaluationEvent.PolicyVerdictOverride
                      .forNumber(from);
              return result == null
                  ? com.google.cloud.deploy.v1.DeployPolicyEvaluationEvent.PolicyVerdictOverride
                      .UNRECOGNIZED
                  : result;
            }
          };
  /**
   *
   *
   * <pre>
   * Things that could have overridden the policy verdict. Overrides together
   * with verdict decide whether the request is allowed.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.DeployPolicyEvaluationEvent.PolicyVerdictOverride overrides = 13;
   * </code>
   *
   * @return A list containing the overrides.
   */
  @java.lang.Override
  public java.util.List<
          com.google.cloud.deploy.v1.DeployPolicyEvaluationEvent.PolicyVerdictOverride>
      getOverridesList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer,
        com.google.cloud.deploy.v1.DeployPolicyEvaluationEvent.PolicyVerdictOverride>(
        overrides_, overrides_converter_);
  }
  /**
   *
   *
   * <pre>
   * Things that could have overridden the policy verdict. Overrides together
   * with verdict decide whether the request is allowed.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.DeployPolicyEvaluationEvent.PolicyVerdictOverride overrides = 13;
   * </code>
   *
   * @return The count of overrides.
   */
  @java.lang.Override
  public int getOverridesCount() {
    return overrides_.size();
  }
  /**
   *
   *
   * <pre>
   * Things that could have overridden the policy verdict. Overrides together
   * with verdict decide whether the request is allowed.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.DeployPolicyEvaluationEvent.PolicyVerdictOverride overrides = 13;
   * </code>
   *
   * @param index The index of the element to return.
   * @return The overrides at the given index.
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.DeployPolicyEvaluationEvent.PolicyVerdictOverride getOverrides(
      int index) {
    return overrides_converter_.convert(overrides_.get(index));
  }
  /**
   *
   *
   * <pre>
   * Things that could have overridden the policy verdict. Overrides together
   * with verdict decide whether the request is allowed.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.DeployPolicyEvaluationEvent.PolicyVerdictOverride overrides = 13;
   * </code>
   *
   * @return A list containing the enum numeric values on the wire for overrides.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getOverridesValueList() {
    return overrides_;
  }
  /**
   *
   *
   * <pre>
   * Things that could have overridden the policy verdict. Overrides together
   * with verdict decide whether the request is allowed.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.DeployPolicyEvaluationEvent.PolicyVerdictOverride overrides = 13;
   * </code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of overrides at the given index.
   */
  @java.lang.Override
  public int getOverridesValue(int index) {
    return overrides_.get(index);
  }

  private int overridesMemoizedSerializedSize;

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(message_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, message_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(ruleType_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, ruleType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(rule_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, rule_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pipelineUid_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, pipelineUid_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(deliveryPipeline_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, deliveryPipeline_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(targetUid_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, targetUid_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(target_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, target_);
    }
    if (invoker_
        != com.google.cloud.deploy.v1.DeployPolicy.Invoker.INVOKER_UNSPECIFIED.getNumber()) {
      output.writeEnum(8, invoker_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(deployPolicy_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, deployPolicy_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(deployPolicyUid_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, deployPolicyUid_);
    }
    if (allowed_ != false) {
      output.writeBool(11, allowed_);
    }
    if (verdict_
        != com.google.cloud.deploy.v1.DeployPolicyEvaluationEvent.PolicyVerdict
            .POLICY_VERDICT_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(12, verdict_);
    }
    if (getOverridesList().size() > 0) {
      output.writeUInt32NoTag(106);
      output.writeUInt32NoTag(overridesMemoizedSerializedSize);
    }
    for (int i = 0; i < overrides_.size(); i++) {
      output.writeEnumNoTag(overrides_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(message_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, message_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(ruleType_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, ruleType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(rule_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, rule_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pipelineUid_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, pipelineUid_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(deliveryPipeline_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, deliveryPipeline_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(targetUid_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, targetUid_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(target_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, target_);
    }
    if (invoker_
        != com.google.cloud.deploy.v1.DeployPolicy.Invoker.INVOKER_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(8, invoker_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(deployPolicy_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, deployPolicy_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(deployPolicyUid_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, deployPolicyUid_);
    }
    if (allowed_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(11, allowed_);
    }
    if (verdict_
        != com.google.cloud.deploy.v1.DeployPolicyEvaluationEvent.PolicyVerdict
            .POLICY_VERDICT_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(12, verdict_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < overrides_.size(); i++) {
        dataSize += com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(overrides_.get(i));
      }
      size += dataSize;
      if (!getOverridesList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      overridesMemoizedSerializedSize = dataSize;
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.deploy.v1.DeployPolicyEvaluationEvent)) {
      return super.equals(obj);
    }
    com.google.cloud.deploy.v1.DeployPolicyEvaluationEvent other =
        (com.google.cloud.deploy.v1.DeployPolicyEvaluationEvent) obj;

    if (!getMessage().equals(other.getMessage())) return false;
    if (!getRuleType().equals(other.getRuleType())) return false;
    if (!getRule().equals(other.getRule())) return false;
    if (!getPipelineUid().equals(other.getPipelineUid())) return false;
    if (!getDeliveryPipeline().equals(other.getDeliveryPipeline())) return false;
    if (!getTargetUid().equals(other.getTargetUid())) return false;
    if (!getTarget().equals(other.getTarget())) return false;
    if (invoker_ != other.invoker_) return false;
    if (!getDeployPolicy().equals(other.getDeployPolicy())) return false;
    if (!getDeployPolicyUid().equals(other.getDeployPolicyUid())) return false;
    if (getAllowed() != other.getAllowed()) return false;
    if (verdict_ != other.verdict_) return false;
    if (!overrides_.equals(other.overrides_)) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + MESSAGE_FIELD_NUMBER;
    hash = (53 * hash) + getMessage().hashCode();
    hash = (37 * hash) + RULE_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getRuleType().hashCode();
    hash = (37 * hash) + RULE_FIELD_NUMBER;
    hash = (53 * hash) + getRule().hashCode();
    hash = (37 * hash) + PIPELINE_UID_FIELD_NUMBER;
    hash = (53 * hash) + getPipelineUid().hashCode();
    hash = (37 * hash) + DELIVERY_PIPELINE_FIELD_NUMBER;
    hash = (53 * hash) + getDeliveryPipeline().hashCode();
    hash = (37 * hash) + TARGET_UID_FIELD_NUMBER;
    hash = (53 * hash) + getTargetUid().hashCode();
    hash = (37 * hash) + TARGET_FIELD_NUMBER;
    hash = (53 * hash) + getTarget().hashCode();
    hash = (37 * hash) + INVOKER_FIELD_NUMBER;
    hash = (53 * hash) + invoker_;
    hash = (37 * hash) + DEPLOY_POLICY_FIELD_NUMBER;
    hash = (53 * hash) + getDeployPolicy().hashCode();
    hash = (37 * hash) + DEPLOY_POLICY_UID_FIELD_NUMBER;
    hash = (53 * hash) + getDeployPolicyUid().hashCode();
    hash = (37 * hash) + ALLOWED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAllowed());
    hash = (37 * hash) + VERDICT_FIELD_NUMBER;
    hash = (53 * hash) + verdict_;
    if (getOverridesCount() > 0) {
      hash = (37 * hash) + OVERRIDES_FIELD_NUMBER;
      hash = (53 * hash) + overrides_.hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.deploy.v1.DeployPolicyEvaluationEvent parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.DeployPolicyEvaluationEvent parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.DeployPolicyEvaluationEvent parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.DeployPolicyEvaluationEvent parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.DeployPolicyEvaluationEvent parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.DeployPolicyEvaluationEvent parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.DeployPolicyEvaluationEvent parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.DeployPolicyEvaluationEvent parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.DeployPolicyEvaluationEvent parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.DeployPolicyEvaluationEvent parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.DeployPolicyEvaluationEvent parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.DeployPolicyEvaluationEvent parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.deploy.v1.DeployPolicyEvaluationEvent prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Payload proto for "clouddeploy.googleapis.com/deploypolicy_evaluation"
   * Platform Log event that describes the deploy policy evaluation event.
   * </pre>
   *
   * Protobuf type {@code google.cloud.deploy.v1.DeployPolicyEvaluationEvent}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.deploy.v1.DeployPolicyEvaluationEvent)
      com.google.cloud.deploy.v1.DeployPolicyEvaluationEventOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.deploy.v1.DeployPolicyEvaluationPayloadProto
          .internal_static_google_cloud_deploy_v1_DeployPolicyEvaluationEvent_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.deploy.v1.DeployPolicyEvaluationPayloadProto
          .internal_static_google_cloud_deploy_v1_DeployPolicyEvaluationEvent_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.deploy.v1.DeployPolicyEvaluationEvent.class,
              com.google.cloud.deploy.v1.DeployPolicyEvaluationEvent.Builder.class);
    }

    // Construct using com.google.cloud.deploy.v1.DeployPolicyEvaluationEvent.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      message_ = "";
      ruleType_ = "";
      rule_ = "";
      pipelineUid_ = "";
      deliveryPipeline_ = "";
      targetUid_ = "";
      target_ = "";
      invoker_ = 0;
      deployPolicy_ = "";
      deployPolicyUid_ = "";
      allowed_ = false;
      verdict_ = 0;
      overrides_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00001000);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.deploy.v1.DeployPolicyEvaluationPayloadProto
          .internal_static_google_cloud_deploy_v1_DeployPolicyEvaluationEvent_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.DeployPolicyEvaluationEvent getDefaultInstanceForType() {
      return com.google.cloud.deploy.v1.DeployPolicyEvaluationEvent.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.DeployPolicyEvaluationEvent build() {
      com.google.cloud.deploy.v1.DeployPolicyEvaluationEvent result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.DeployPolicyEvaluationEvent buildPartial() {
      com.google.cloud.deploy.v1.DeployPolicyEvaluationEvent result =
          new com.google.cloud.deploy.v1.DeployPolicyEvaluationEvent(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.deploy.v1.DeployPolicyEvaluationEvent result) {
      if (((bitField0_ & 0x00001000) != 0)) {
        overrides_ = java.util.Collections.unmodifiableList(overrides_);
        bitField0_ = (bitField0_ & ~0x00001000);
      }
      result.overrides_ = overrides_;
    }

    private void buildPartial0(com.google.cloud.deploy.v1.DeployPolicyEvaluationEvent result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.message_ = message_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.ruleType_ = ruleType_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.rule_ = rule_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.pipelineUid_ = pipelineUid_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.deliveryPipeline_ = deliveryPipeline_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.targetUid_ = targetUid_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.target_ = target_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.invoker_ = invoker_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.deployPolicy_ = deployPolicy_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.deployPolicyUid_ = deployPolicyUid_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.allowed_ = allowed_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.verdict_ = verdict_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.deploy.v1.DeployPolicyEvaluationEvent) {
        return mergeFrom((com.google.cloud.deploy.v1.DeployPolicyEvaluationEvent) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.deploy.v1.DeployPolicyEvaluationEvent other) {
      if (other == com.google.cloud.deploy.v1.DeployPolicyEvaluationEvent.getDefaultInstance())
        return this;
      if (!other.getMessage().isEmpty()) {
        message_ = other.message_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getRuleType().isEmpty()) {
        ruleType_ = other.ruleType_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getRule().isEmpty()) {
        rule_ = other.rule_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getPipelineUid().isEmpty()) {
        pipelineUid_ = other.pipelineUid_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getDeliveryPipeline().isEmpty()) {
        deliveryPipeline_ = other.deliveryPipeline_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.getTargetUid().isEmpty()) {
        targetUid_ = other.targetUid_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (!other.getTarget().isEmpty()) {
        target_ = other.target_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (other.invoker_ != 0) {
        setInvokerValue(other.getInvokerValue());
      }
      if (!other.getDeployPolicy().isEmpty()) {
        deployPolicy_ = other.deployPolicy_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (!other.getDeployPolicyUid().isEmpty()) {
        deployPolicyUid_ = other.deployPolicyUid_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (other.getAllowed() != false) {
        setAllowed(other.getAllowed());
      }
      if (other.verdict_ != 0) {
        setVerdictValue(other.getVerdictValue());
      }
      if (!other.overrides_.isEmpty()) {
        if (overrides_.isEmpty()) {
          overrides_ = other.overrides_;
          bitField0_ = (bitField0_ & ~0x00001000);
        } else {
          ensureOverridesIsMutable();
          overrides_.addAll(other.overrides_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                message_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                ruleType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                rule_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                pipelineUid_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                deliveryPipeline_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                targetUid_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                target_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 64:
              {
                invoker_ = input.readEnum();
                bitField0_ |= 0x00000080;
                break;
              } // case 64
            case 74:
              {
                deployPolicy_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 74
            case 82:
              {
                deployPolicyUid_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 82
            case 88:
              {
                allowed_ = input.readBool();
                bitField0_ |= 0x00000400;
                break;
              } // case 88
            case 96:
              {
                verdict_ = input.readEnum();
                bitField0_ |= 0x00000800;
                break;
              } // case 96
            case 104:
              {
                int tmpRaw = input.readEnum();
                ensureOverridesIsMutable();
                overrides_.add(tmpRaw);
                break;
              } // case 104
            case 106:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensureOverridesIsMutable();
                  overrides_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 106
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object message_ = "";
    /**
     *
     *
     * <pre>
     * Debug message for when a deploy policy event occurs.
     * </pre>
     *
     * <code>string message = 1;</code>
     *
     * @return The message.
     */
    public java.lang.String getMessage() {
      java.lang.Object ref = message_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        message_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Debug message for when a deploy policy event occurs.
     * </pre>
     *
     * <code>string message = 1;</code>
     *
     * @return The bytes for message.
     */
    public com.google.protobuf.ByteString getMessageBytes() {
      java.lang.Object ref = message_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        message_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Debug message for when a deploy policy event occurs.
     * </pre>
     *
     * <code>string message = 1;</code>
     *
     * @param value The message to set.
     * @return This builder for chaining.
     */
    public Builder setMessage(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      message_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Debug message for when a deploy policy event occurs.
     * </pre>
     *
     * <code>string message = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMessage() {
      message_ = getDefaultInstance().getMessage();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Debug message for when a deploy policy event occurs.
     * </pre>
     *
     * <code>string message = 1;</code>
     *
     * @param value The bytes for message to set.
     * @return This builder for chaining.
     */
    public Builder setMessageBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      message_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object ruleType_ = "";
    /**
     *
     *
     * <pre>
     * Rule type (e.g. Restrict Rollouts).
     * </pre>
     *
     * <code>string rule_type = 2;</code>
     *
     * @return The ruleType.
     */
    public java.lang.String getRuleType() {
      java.lang.Object ref = ruleType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        ruleType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Rule type (e.g. Restrict Rollouts).
     * </pre>
     *
     * <code>string rule_type = 2;</code>
     *
     * @return The bytes for ruleType.
     */
    public com.google.protobuf.ByteString getRuleTypeBytes() {
      java.lang.Object ref = ruleType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        ruleType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Rule type (e.g. Restrict Rollouts).
     * </pre>
     *
     * <code>string rule_type = 2;</code>
     *
     * @param value The ruleType to set.
     * @return This builder for chaining.
     */
    public Builder setRuleType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ruleType_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Rule type (e.g. Restrict Rollouts).
     * </pre>
     *
     * <code>string rule_type = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRuleType() {
      ruleType_ = getDefaultInstance().getRuleType();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Rule type (e.g. Restrict Rollouts).
     * </pre>
     *
     * <code>string rule_type = 2;</code>
     *
     * @param value The bytes for ruleType to set.
     * @return This builder for chaining.
     */
    public Builder setRuleTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ruleType_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object rule_ = "";
    /**
     *
     *
     * <pre>
     * Rule id.
     * </pre>
     *
     * <code>string rule = 3;</code>
     *
     * @return The rule.
     */
    public java.lang.String getRule() {
      java.lang.Object ref = rule_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        rule_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Rule id.
     * </pre>
     *
     * <code>string rule = 3;</code>
     *
     * @return The bytes for rule.
     */
    public com.google.protobuf.ByteString getRuleBytes() {
      java.lang.Object ref = rule_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        rule_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Rule id.
     * </pre>
     *
     * <code>string rule = 3;</code>
     *
     * @param value The rule to set.
     * @return This builder for chaining.
     */
    public Builder setRule(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      rule_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Rule id.
     * </pre>
     *
     * <code>string rule = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRule() {
      rule_ = getDefaultInstance().getRule();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Rule id.
     * </pre>
     *
     * <code>string rule = 3;</code>
     *
     * @param value The bytes for rule to set.
     * @return This builder for chaining.
     */
    public Builder setRuleBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      rule_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object pipelineUid_ = "";
    /**
     *
     *
     * <pre>
     * Unique identifier of the `Delivery Pipeline`.
     * </pre>
     *
     * <code>string pipeline_uid = 4;</code>
     *
     * @return The pipelineUid.
     */
    public java.lang.String getPipelineUid() {
      java.lang.Object ref = pipelineUid_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pipelineUid_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Unique identifier of the `Delivery Pipeline`.
     * </pre>
     *
     * <code>string pipeline_uid = 4;</code>
     *
     * @return The bytes for pipelineUid.
     */
    public com.google.protobuf.ByteString getPipelineUidBytes() {
      java.lang.Object ref = pipelineUid_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pipelineUid_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Unique identifier of the `Delivery Pipeline`.
     * </pre>
     *
     * <code>string pipeline_uid = 4;</code>
     *
     * @param value The pipelineUid to set.
     * @return This builder for chaining.
     */
    public Builder setPipelineUid(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      pipelineUid_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Unique identifier of the `Delivery Pipeline`.
     * </pre>
     *
     * <code>string pipeline_uid = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPipelineUid() {
      pipelineUid_ = getDefaultInstance().getPipelineUid();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Unique identifier of the `Delivery Pipeline`.
     * </pre>
     *
     * <code>string pipeline_uid = 4;</code>
     *
     * @param value The bytes for pipelineUid to set.
     * @return This builder for chaining.
     */
    public Builder setPipelineUidBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      pipelineUid_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object deliveryPipeline_ = "";
    /**
     *
     *
     * <pre>
     * The name of the `Delivery Pipeline`.
     * </pre>
     *
     * <code>string delivery_pipeline = 5;</code>
     *
     * @return The deliveryPipeline.
     */
    public java.lang.String getDeliveryPipeline() {
      java.lang.Object ref = deliveryPipeline_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        deliveryPipeline_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the `Delivery Pipeline`.
     * </pre>
     *
     * <code>string delivery_pipeline = 5;</code>
     *
     * @return The bytes for deliveryPipeline.
     */
    public com.google.protobuf.ByteString getDeliveryPipelineBytes() {
      java.lang.Object ref = deliveryPipeline_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        deliveryPipeline_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the `Delivery Pipeline`.
     * </pre>
     *
     * <code>string delivery_pipeline = 5;</code>
     *
     * @param value The deliveryPipeline to set.
     * @return This builder for chaining.
     */
    public Builder setDeliveryPipeline(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      deliveryPipeline_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the `Delivery Pipeline`.
     * </pre>
     *
     * <code>string delivery_pipeline = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDeliveryPipeline() {
      deliveryPipeline_ = getDefaultInstance().getDeliveryPipeline();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the `Delivery Pipeline`.
     * </pre>
     *
     * <code>string delivery_pipeline = 5;</code>
     *
     * @param value The bytes for deliveryPipeline to set.
     * @return This builder for chaining.
     */
    public Builder setDeliveryPipelineBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      deliveryPipeline_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object targetUid_ = "";
    /**
     *
     *
     * <pre>
     * Unique identifier of the `Target`. This is an optional field, as a `Target`
     * may not always be applicable to a policy.
     * </pre>
     *
     * <code>string target_uid = 6;</code>
     *
     * @return The targetUid.
     */
    public java.lang.String getTargetUid() {
      java.lang.Object ref = targetUid_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        targetUid_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Unique identifier of the `Target`. This is an optional field, as a `Target`
     * may not always be applicable to a policy.
     * </pre>
     *
     * <code>string target_uid = 6;</code>
     *
     * @return The bytes for targetUid.
     */
    public com.google.protobuf.ByteString getTargetUidBytes() {
      java.lang.Object ref = targetUid_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        targetUid_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Unique identifier of the `Target`. This is an optional field, as a `Target`
     * may not always be applicable to a policy.
     * </pre>
     *
     * <code>string target_uid = 6;</code>
     *
     * @param value The targetUid to set.
     * @return This builder for chaining.
     */
    public Builder setTargetUid(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      targetUid_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Unique identifier of the `Target`. This is an optional field, as a `Target`
     * may not always be applicable to a policy.
     * </pre>
     *
     * <code>string target_uid = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTargetUid() {
      targetUid_ = getDefaultInstance().getTargetUid();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Unique identifier of the `Target`. This is an optional field, as a `Target`
     * may not always be applicable to a policy.
     * </pre>
     *
     * <code>string target_uid = 6;</code>
     *
     * @param value The bytes for targetUid to set.
     * @return This builder for chaining.
     */
    public Builder setTargetUidBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      targetUid_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object target_ = "";
    /**
     *
     *
     * <pre>
     * The name of the `Target`. This is an optional field, as a `Target` may not
     * always be applicable to a policy.
     * </pre>
     *
     * <code>string target = 7;</code>
     *
     * @return The target.
     */
    public java.lang.String getTarget() {
      java.lang.Object ref = target_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        target_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the `Target`. This is an optional field, as a `Target` may not
     * always be applicable to a policy.
     * </pre>
     *
     * <code>string target = 7;</code>
     *
     * @return The bytes for target.
     */
    public com.google.protobuf.ByteString getTargetBytes() {
      java.lang.Object ref = target_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        target_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the `Target`. This is an optional field, as a `Target` may not
     * always be applicable to a policy.
     * </pre>
     *
     * <code>string target = 7;</code>
     *
     * @param value The target to set.
     * @return This builder for chaining.
     */
    public Builder setTarget(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      target_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the `Target`. This is an optional field, as a `Target` may not
     * always be applicable to a policy.
     * </pre>
     *
     * <code>string target = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTarget() {
      target_ = getDefaultInstance().getTarget();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the `Target`. This is an optional field, as a `Target` may not
     * always be applicable to a policy.
     * </pre>
     *
     * <code>string target = 7;</code>
     *
     * @param value The bytes for target to set.
     * @return This builder for chaining.
     */
    public Builder setTargetBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      target_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private int invoker_ = 0;
    /**
     *
     *
     * <pre>
     * What invoked the action (e.g. a user or automation).
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.DeployPolicy.Invoker invoker = 8;</code>
     *
     * @return The enum numeric value on the wire for invoker.
     */
    @java.lang.Override
    public int getInvokerValue() {
      return invoker_;
    }
    /**
     *
     *
     * <pre>
     * What invoked the action (e.g. a user or automation).
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.DeployPolicy.Invoker invoker = 8;</code>
     *
     * @param value The enum numeric value on the wire for invoker to set.
     * @return This builder for chaining.
     */
    public Builder setInvokerValue(int value) {
      invoker_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * What invoked the action (e.g. a user or automation).
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.DeployPolicy.Invoker invoker = 8;</code>
     *
     * @return The invoker.
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.DeployPolicy.Invoker getInvoker() {
      com.google.cloud.deploy.v1.DeployPolicy.Invoker result =
          com.google.cloud.deploy.v1.DeployPolicy.Invoker.forNumber(invoker_);
      return result == null ? com.google.cloud.deploy.v1.DeployPolicy.Invoker.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * What invoked the action (e.g. a user or automation).
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.DeployPolicy.Invoker invoker = 8;</code>
     *
     * @param value The invoker to set.
     * @return This builder for chaining.
     */
    public Builder setInvoker(com.google.cloud.deploy.v1.DeployPolicy.Invoker value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000080;
      invoker_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * What invoked the action (e.g. a user or automation).
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.DeployPolicy.Invoker invoker = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInvoker() {
      bitField0_ = (bitField0_ & ~0x00000080);
      invoker_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object deployPolicy_ = "";
    /**
     *
     *
     * <pre>
     * The name of the `DeployPolicy`.
     * </pre>
     *
     * <code>string deploy_policy = 9;</code>
     *
     * @return The deployPolicy.
     */
    public java.lang.String getDeployPolicy() {
      java.lang.Object ref = deployPolicy_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        deployPolicy_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the `DeployPolicy`.
     * </pre>
     *
     * <code>string deploy_policy = 9;</code>
     *
     * @return The bytes for deployPolicy.
     */
    public com.google.protobuf.ByteString getDeployPolicyBytes() {
      java.lang.Object ref = deployPolicy_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        deployPolicy_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the `DeployPolicy`.
     * </pre>
     *
     * <code>string deploy_policy = 9;</code>
     *
     * @param value The deployPolicy to set.
     * @return This builder for chaining.
     */
    public Builder setDeployPolicy(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      deployPolicy_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the `DeployPolicy`.
     * </pre>
     *
     * <code>string deploy_policy = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDeployPolicy() {
      deployPolicy_ = getDefaultInstance().getDeployPolicy();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the `DeployPolicy`.
     * </pre>
     *
     * <code>string deploy_policy = 9;</code>
     *
     * @param value The bytes for deployPolicy to set.
     * @return This builder for chaining.
     */
    public Builder setDeployPolicyBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      deployPolicy_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private java.lang.Object deployPolicyUid_ = "";
    /**
     *
     *
     * <pre>
     * Unique identifier of the `DeployPolicy`.
     * </pre>
     *
     * <code>string deploy_policy_uid = 10;</code>
     *
     * @return The deployPolicyUid.
     */
    public java.lang.String getDeployPolicyUid() {
      java.lang.Object ref = deployPolicyUid_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        deployPolicyUid_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Unique identifier of the `DeployPolicy`.
     * </pre>
     *
     * <code>string deploy_policy_uid = 10;</code>
     *
     * @return The bytes for deployPolicyUid.
     */
    public com.google.protobuf.ByteString getDeployPolicyUidBytes() {
      java.lang.Object ref = deployPolicyUid_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        deployPolicyUid_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Unique identifier of the `DeployPolicy`.
     * </pre>
     *
     * <code>string deploy_policy_uid = 10;</code>
     *
     * @param value The deployPolicyUid to set.
     * @return This builder for chaining.
     */
    public Builder setDeployPolicyUid(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      deployPolicyUid_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Unique identifier of the `DeployPolicy`.
     * </pre>
     *
     * <code>string deploy_policy_uid = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDeployPolicyUid() {
      deployPolicyUid_ = getDefaultInstance().getDeployPolicyUid();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Unique identifier of the `DeployPolicy`.
     * </pre>
     *
     * <code>string deploy_policy_uid = 10;</code>
     *
     * @param value The bytes for deployPolicyUid to set.
     * @return This builder for chaining.
     */
    public Builder setDeployPolicyUidBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      deployPolicyUid_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private boolean allowed_;
    /**
     *
     *
     * <pre>
     * Whether the request is allowed. Allowed is set as true if:
     * (1) the request complies with the policy; or
     * (2) the request doesn't comply with the policy but the policy was
     * overridden; or
     * (3) the request doesn't comply with the policy but the policy was suspended
     * </pre>
     *
     * <code>bool allowed = 11;</code>
     *
     * @return The allowed.
     */
    @java.lang.Override
    public boolean getAllowed() {
      return allowed_;
    }
    /**
     *
     *
     * <pre>
     * Whether the request is allowed. Allowed is set as true if:
     * (1) the request complies with the policy; or
     * (2) the request doesn't comply with the policy but the policy was
     * overridden; or
     * (3) the request doesn't comply with the policy but the policy was suspended
     * </pre>
     *
     * <code>bool allowed = 11;</code>
     *
     * @param value The allowed to set.
     * @return This builder for chaining.
     */
    public Builder setAllowed(boolean value) {

      allowed_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether the request is allowed. Allowed is set as true if:
     * (1) the request complies with the policy; or
     * (2) the request doesn't comply with the policy but the policy was
     * overridden; or
     * (3) the request doesn't comply with the policy but the policy was suspended
     * </pre>
     *
     * <code>bool allowed = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAllowed() {
      bitField0_ = (bitField0_ & ~0x00000400);
      allowed_ = false;
      onChanged();
      return this;
    }

    private int verdict_ = 0;
    /**
     *
     *
     * <pre>
     * The policy verdict of the request.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.DeployPolicyEvaluationEvent.PolicyVerdict verdict = 12;</code>
     *
     * @return The enum numeric value on the wire for verdict.
     */
    @java.lang.Override
    public int getVerdictValue() {
      return verdict_;
    }
    /**
     *
     *
     * <pre>
     * The policy verdict of the request.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.DeployPolicyEvaluationEvent.PolicyVerdict verdict = 12;</code>
     *
     * @param value The enum numeric value on the wire for verdict to set.
     * @return This builder for chaining.
     */
    public Builder setVerdictValue(int value) {
      verdict_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The policy verdict of the request.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.DeployPolicyEvaluationEvent.PolicyVerdict verdict = 12;</code>
     *
     * @return The verdict.
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.DeployPolicyEvaluationEvent.PolicyVerdict getVerdict() {
      com.google.cloud.deploy.v1.DeployPolicyEvaluationEvent.PolicyVerdict result =
          com.google.cloud.deploy.v1.DeployPolicyEvaluationEvent.PolicyVerdict.forNumber(verdict_);
      return result == null
          ? com.google.cloud.deploy.v1.DeployPolicyEvaluationEvent.PolicyVerdict.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The policy verdict of the request.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.DeployPolicyEvaluationEvent.PolicyVerdict verdict = 12;</code>
     *
     * @param value The verdict to set.
     * @return This builder for chaining.
     */
    public Builder setVerdict(
        com.google.cloud.deploy.v1.DeployPolicyEvaluationEvent.PolicyVerdict value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000800;
      verdict_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The policy verdict of the request.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.DeployPolicyEvaluationEvent.PolicyVerdict verdict = 12;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVerdict() {
      bitField0_ = (bitField0_ & ~0x00000800);
      verdict_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<java.lang.Integer> overrides_ = java.util.Collections.emptyList();

    private void ensureOverridesIsMutable() {
      if (!((bitField0_ & 0x00001000) != 0)) {
        overrides_ = new java.util.ArrayList<java.lang.Integer>(overrides_);
        bitField0_ |= 0x00001000;
      }
    }
    /**
     *
     *
     * <pre>
     * Things that could have overridden the policy verdict. Overrides together
     * with verdict decide whether the request is allowed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.DeployPolicyEvaluationEvent.PolicyVerdictOverride overrides = 13;
     * </code>
     *
     * @return A list containing the overrides.
     */
    public java.util.List<
            com.google.cloud.deploy.v1.DeployPolicyEvaluationEvent.PolicyVerdictOverride>
        getOverridesList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer,
          com.google.cloud.deploy.v1.DeployPolicyEvaluationEvent.PolicyVerdictOverride>(
          overrides_, overrides_converter_);
    }
    /**
     *
     *
     * <pre>
     * Things that could have overridden the policy verdict. Overrides together
     * with verdict decide whether the request is allowed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.DeployPolicyEvaluationEvent.PolicyVerdictOverride overrides = 13;
     * </code>
     *
     * @return The count of overrides.
     */
    public int getOverridesCount() {
      return overrides_.size();
    }
    /**
     *
     *
     * <pre>
     * Things that could have overridden the policy verdict. Overrides together
     * with verdict decide whether the request is allowed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.DeployPolicyEvaluationEvent.PolicyVerdictOverride overrides = 13;
     * </code>
     *
     * @param index The index of the element to return.
     * @return The overrides at the given index.
     */
    public com.google.cloud.deploy.v1.DeployPolicyEvaluationEvent.PolicyVerdictOverride
        getOverrides(int index) {
      return overrides_converter_.convert(overrides_.get(index));
    }
    /**
     *
     *
     * <pre>
     * Things that could have overridden the policy verdict. Overrides together
     * with verdict decide whether the request is allowed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.DeployPolicyEvaluationEvent.PolicyVerdictOverride overrides = 13;
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The overrides to set.
     * @return This builder for chaining.
     */
    public Builder setOverrides(
        int index,
        com.google.cloud.deploy.v1.DeployPolicyEvaluationEvent.PolicyVerdictOverride value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureOverridesIsMutable();
      overrides_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Things that could have overridden the policy verdict. Overrides together
     * with verdict decide whether the request is allowed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.DeployPolicyEvaluationEvent.PolicyVerdictOverride overrides = 13;
     * </code>
     *
     * @param value The overrides to add.
     * @return This builder for chaining.
     */
    public Builder addOverrides(
        com.google.cloud.deploy.v1.DeployPolicyEvaluationEvent.PolicyVerdictOverride value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureOverridesIsMutable();
      overrides_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Things that could have overridden the policy verdict. Overrides together
     * with verdict decide whether the request is allowed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.DeployPolicyEvaluationEvent.PolicyVerdictOverride overrides = 13;
     * </code>
     *
     * @param values The overrides to add.
     * @return This builder for chaining.
     */
    public Builder addAllOverrides(
        java.lang.Iterable<
                ? extends
                    com.google.cloud.deploy.v1.DeployPolicyEvaluationEvent.PolicyVerdictOverride>
            values) {
      ensureOverridesIsMutable();
      for (com.google.cloud.deploy.v1.DeployPolicyEvaluationEvent.PolicyVerdictOverride value :
          values) {
        overrides_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Things that could have overridden the policy verdict. Overrides together
     * with verdict decide whether the request is allowed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.DeployPolicyEvaluationEvent.PolicyVerdictOverride overrides = 13;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOverrides() {
      overrides_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00001000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Things that could have overridden the policy verdict. Overrides together
     * with verdict decide whether the request is allowed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.DeployPolicyEvaluationEvent.PolicyVerdictOverride overrides = 13;
     * </code>
     *
     * @return A list containing the enum numeric values on the wire for overrides.
     */
    public java.util.List<java.lang.Integer> getOverridesValueList() {
      return java.util.Collections.unmodifiableList(overrides_);
    }
    /**
     *
     *
     * <pre>
     * Things that could have overridden the policy verdict. Overrides together
     * with verdict decide whether the request is allowed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.DeployPolicyEvaluationEvent.PolicyVerdictOverride overrides = 13;
     * </code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of overrides at the given index.
     */
    public int getOverridesValue(int index) {
      return overrides_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Things that could have overridden the policy verdict. Overrides together
     * with verdict decide whether the request is allowed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.DeployPolicyEvaluationEvent.PolicyVerdictOverride overrides = 13;
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for overrides to set.
     * @return This builder for chaining.
     */
    public Builder setOverridesValue(int index, int value) {
      ensureOverridesIsMutable();
      overrides_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Things that could have overridden the policy verdict. Overrides together
     * with verdict decide whether the request is allowed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.DeployPolicyEvaluationEvent.PolicyVerdictOverride overrides = 13;
     * </code>
     *
     * @param value The enum numeric value on the wire for overrides to add.
     * @return This builder for chaining.
     */
    public Builder addOverridesValue(int value) {
      ensureOverridesIsMutable();
      overrides_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Things that could have overridden the policy verdict. Overrides together
     * with verdict decide whether the request is allowed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.DeployPolicyEvaluationEvent.PolicyVerdictOverride overrides = 13;
     * </code>
     *
     * @param values The enum numeric values on the wire for overrides to add.
     * @return This builder for chaining.
     */
    public Builder addAllOverridesValue(java.lang.Iterable<java.lang.Integer> values) {
      ensureOverridesIsMutable();
      for (int value : values) {
        overrides_.add(value);
      }
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.deploy.v1.DeployPolicyEvaluationEvent)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.deploy.v1.DeployPolicyEvaluationEvent)
  private static final com.google.cloud.deploy.v1.DeployPolicyEvaluationEvent DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.deploy.v1.DeployPolicyEvaluationEvent();
  }

  public static com.google.cloud.deploy.v1.DeployPolicyEvaluationEvent getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DeployPolicyEvaluationEvent> PARSER =
      new com.google.protobuf.AbstractParser<DeployPolicyEvaluationEvent>() {
        @java.lang.Override
        public DeployPolicyEvaluationEvent parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<DeployPolicyEvaluationEvent> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DeployPolicyEvaluationEvent> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.deploy.v1.DeployPolicyEvaluationEvent getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
