/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/deploy/v1/cloud_deploy.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.deploy.v1;

public interface DeployPolicyOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.deploy.v1.DeployPolicy)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Output only. Name of the `DeployPolicy`. Format is
   * `projects/{project}/locations/{location}/deployPolicies/{deployPolicy}`.
   * The `deployPolicy` component must match `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  java.lang.String getName();
  /**
   *
   *
   * <pre>
   * Output only. Name of the `DeployPolicy`. Format is
   * `projects/{project}/locations/{location}/deployPolicies/{deployPolicy}`.
   * The `deployPolicy` component must match `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * Output only. Unique identifier of the `DeployPolicy`.
   * </pre>
   *
   * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The uid.
   */
  java.lang.String getUid();
  /**
   *
   *
   * <pre>
   * Output only. Unique identifier of the `DeployPolicy`.
   * </pre>
   *
   * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for uid.
   */
  com.google.protobuf.ByteString getUidBytes();

  /**
   *
   *
   * <pre>
   * Description of the `DeployPolicy`. Max length is 255 characters.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The description.
   */
  java.lang.String getDescription();
  /**
   *
   *
   * <pre>
   * Description of the `DeployPolicy`. Max length is 255 characters.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The bytes for description.
   */
  com.google.protobuf.ByteString getDescriptionBytes();

  /**
   *
   *
   * <pre>
   * User annotations. These attributes can only be set and used by the
   * user, and not by Cloud Deploy. Annotations must meet the following
   * constraints:
   *
   * * Annotations are key/value pairs.
   * * Valid annotation keys have two segments: an optional prefix and name,
   * separated by a slash (`/`).
   * * The name segment is required and must be 63 characters or less,
   * beginning and ending with an alphanumeric character (`[a-z0-9A-Z]`) with
   * dashes (`-`), underscores (`_`), dots (`.`), and alphanumerics between.
   * * The prefix is optional. If specified, the prefix must be a DNS subdomain:
   * a series of DNS labels separated by dots(`.`), not longer than 253
   * characters in total, followed by a slash (`/`).
   *
   * See
   * https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations/#syntax-and-character-set
   * for more details.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 4;</code>
   */
  int getAnnotationsCount();
  /**
   *
   *
   * <pre>
   * User annotations. These attributes can only be set and used by the
   * user, and not by Cloud Deploy. Annotations must meet the following
   * constraints:
   *
   * * Annotations are key/value pairs.
   * * Valid annotation keys have two segments: an optional prefix and name,
   * separated by a slash (`/`).
   * * The name segment is required and must be 63 characters or less,
   * beginning and ending with an alphanumeric character (`[a-z0-9A-Z]`) with
   * dashes (`-`), underscores (`_`), dots (`.`), and alphanumerics between.
   * * The prefix is optional. If specified, the prefix must be a DNS subdomain:
   * a series of DNS labels separated by dots(`.`), not longer than 253
   * characters in total, followed by a slash (`/`).
   *
   * See
   * https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations/#syntax-and-character-set
   * for more details.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 4;</code>
   */
  boolean containsAnnotations(java.lang.String key);
  /** Use {@link #getAnnotationsMap()} instead. */
  @java.lang.Deprecated
  java.util.Map<java.lang.String, java.lang.String> getAnnotations();
  /**
   *
   *
   * <pre>
   * User annotations. These attributes can only be set and used by the
   * user, and not by Cloud Deploy. Annotations must meet the following
   * constraints:
   *
   * * Annotations are key/value pairs.
   * * Valid annotation keys have two segments: an optional prefix and name,
   * separated by a slash (`/`).
   * * The name segment is required and must be 63 characters or less,
   * beginning and ending with an alphanumeric character (`[a-z0-9A-Z]`) with
   * dashes (`-`), underscores (`_`), dots (`.`), and alphanumerics between.
   * * The prefix is optional. If specified, the prefix must be a DNS subdomain:
   * a series of DNS labels separated by dots(`.`), not longer than 253
   * characters in total, followed by a slash (`/`).
   *
   * See
   * https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations/#syntax-and-character-set
   * for more details.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 4;</code>
   */
  java.util.Map<java.lang.String, java.lang.String> getAnnotationsMap();
  /**
   *
   *
   * <pre>
   * User annotations. These attributes can only be set and used by the
   * user, and not by Cloud Deploy. Annotations must meet the following
   * constraints:
   *
   * * Annotations are key/value pairs.
   * * Valid annotation keys have two segments: an optional prefix and name,
   * separated by a slash (`/`).
   * * The name segment is required and must be 63 characters or less,
   * beginning and ending with an alphanumeric character (`[a-z0-9A-Z]`) with
   * dashes (`-`), underscores (`_`), dots (`.`), and alphanumerics between.
   * * The prefix is optional. If specified, the prefix must be a DNS subdomain:
   * a series of DNS labels separated by dots(`.`), not longer than 253
   * characters in total, followed by a slash (`/`).
   *
   * See
   * https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations/#syntax-and-character-set
   * for more details.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 4;</code>
   */
  /* nullable */
  java.lang.String getAnnotationsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue);
  /**
   *
   *
   * <pre>
   * User annotations. These attributes can only be set and used by the
   * user, and not by Cloud Deploy. Annotations must meet the following
   * constraints:
   *
   * * Annotations are key/value pairs.
   * * Valid annotation keys have two segments: an optional prefix and name,
   * separated by a slash (`/`).
   * * The name segment is required and must be 63 characters or less,
   * beginning and ending with an alphanumeric character (`[a-z0-9A-Z]`) with
   * dashes (`-`), underscores (`_`), dots (`.`), and alphanumerics between.
   * * The prefix is optional. If specified, the prefix must be a DNS subdomain:
   * a series of DNS labels separated by dots(`.`), not longer than 253
   * characters in total, followed by a slash (`/`).
   *
   * See
   * https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations/#syntax-and-character-set
   * for more details.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 4;</code>
   */
  java.lang.String getAnnotationsOrThrow(java.lang.String key);

  /**
   *
   *
   * <pre>
   * Labels are attributes that can be set and used by both the
   * user and by Cloud Deploy. Labels must meet the following constraints:
   *
   * * Keys and values can contain only lowercase letters, numeric characters,
   * underscores, and dashes.
   * * All characters must use UTF-8 encoding, and international characters are
   * allowed.
   * * Keys must start with a lowercase letter or international character.
   * * Each resource is limited to a maximum of 64 labels.
   *
   * Both keys and values are additionally constrained to be &lt;= 128 bytes.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5;</code>
   */
  int getLabelsCount();
  /**
   *
   *
   * <pre>
   * Labels are attributes that can be set and used by both the
   * user and by Cloud Deploy. Labels must meet the following constraints:
   *
   * * Keys and values can contain only lowercase letters, numeric characters,
   * underscores, and dashes.
   * * All characters must use UTF-8 encoding, and international characters are
   * allowed.
   * * Keys must start with a lowercase letter or international character.
   * * Each resource is limited to a maximum of 64 labels.
   *
   * Both keys and values are additionally constrained to be &lt;= 128 bytes.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5;</code>
   */
  boolean containsLabels(java.lang.String key);
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Deprecated
  java.util.Map<java.lang.String, java.lang.String> getLabels();
  /**
   *
   *
   * <pre>
   * Labels are attributes that can be set and used by both the
   * user and by Cloud Deploy. Labels must meet the following constraints:
   *
   * * Keys and values can contain only lowercase letters, numeric characters,
   * underscores, and dashes.
   * * All characters must use UTF-8 encoding, and international characters are
   * allowed.
   * * Keys must start with a lowercase letter or international character.
   * * Each resource is limited to a maximum of 64 labels.
   *
   * Both keys and values are additionally constrained to be &lt;= 128 bytes.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5;</code>
   */
  java.util.Map<java.lang.String, java.lang.String> getLabelsMap();
  /**
   *
   *
   * <pre>
   * Labels are attributes that can be set and used by both the
   * user and by Cloud Deploy. Labels must meet the following constraints:
   *
   * * Keys and values can contain only lowercase letters, numeric characters,
   * underscores, and dashes.
   * * All characters must use UTF-8 encoding, and international characters are
   * allowed.
   * * Keys must start with a lowercase letter or international character.
   * * Each resource is limited to a maximum of 64 labels.
   *
   * Both keys and values are additionally constrained to be &lt;= 128 bytes.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5;</code>
   */
  /* nullable */
  java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue);
  /**
   *
   *
   * <pre>
   * Labels are attributes that can be set and used by both the
   * user and by Cloud Deploy. Labels must meet the following constraints:
   *
   * * Keys and values can contain only lowercase letters, numeric characters,
   * underscores, and dashes.
   * * All characters must use UTF-8 encoding, and international characters are
   * allowed.
   * * Keys must start with a lowercase letter or international character.
   * * Each resource is limited to a maximum of 64 labels.
   *
   * Both keys and values are additionally constrained to be &lt;= 128 bytes.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5;</code>
   */
  java.lang.String getLabelsOrThrow(java.lang.String key);

  /**
   *
   *
   * <pre>
   * Output only. Time at which the deploy policy was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  boolean hasCreateTime();
  /**
   *
   *
   * <pre>
   * Output only. Time at which the deploy policy was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  com.google.protobuf.Timestamp getCreateTime();
  /**
   *
   *
   * <pre>
   * Output only. Time at which the deploy policy was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. Most recent time at which the deploy policy was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  boolean hasUpdateTime();
  /**
   *
   *
   * <pre>
   * Output only. Most recent time at which the deploy policy was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  com.google.protobuf.Timestamp getUpdateTime();
  /**
   *
   *
   * <pre>
   * Output only. Most recent time at which the deploy policy was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * When suspended, the policy will not prevent actions from occurring, even
   * if the action violates the policy.
   * </pre>
   *
   * <code>bool suspended = 8;</code>
   *
   * @return The suspended.
   */
  boolean getSuspended();

  /**
   *
   *
   * <pre>
   * Required. Selected resources to which the policy will be applied. At least
   * one selector is required. If one selector matches the resource the policy
   * applies. For example, if there are two selectors and the action being
   * attempted matches one of them, the policy will apply to that action.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.DeployPolicyResourceSelector selectors = 12 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  java.util.List<com.google.cloud.deploy.v1.DeployPolicyResourceSelector> getSelectorsList();
  /**
   *
   *
   * <pre>
   * Required. Selected resources to which the policy will be applied. At least
   * one selector is required. If one selector matches the resource the policy
   * applies. For example, if there are two selectors and the action being
   * attempted matches one of them, the policy will apply to that action.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.DeployPolicyResourceSelector selectors = 12 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  com.google.cloud.deploy.v1.DeployPolicyResourceSelector getSelectors(int index);
  /**
   *
   *
   * <pre>
   * Required. Selected resources to which the policy will be applied. At least
   * one selector is required. If one selector matches the resource the policy
   * applies. For example, if there are two selectors and the action being
   * attempted matches one of them, the policy will apply to that action.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.DeployPolicyResourceSelector selectors = 12 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  int getSelectorsCount();
  /**
   *
   *
   * <pre>
   * Required. Selected resources to which the policy will be applied. At least
   * one selector is required. If one selector matches the resource the policy
   * applies. For example, if there are two selectors and the action being
   * attempted matches one of them, the policy will apply to that action.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.DeployPolicyResourceSelector selectors = 12 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  java.util.List<? extends com.google.cloud.deploy.v1.DeployPolicyResourceSelectorOrBuilder>
      getSelectorsOrBuilderList();
  /**
   *
   *
   * <pre>
   * Required. Selected resources to which the policy will be applied. At least
   * one selector is required. If one selector matches the resource the policy
   * applies. For example, if there are two selectors and the action being
   * attempted matches one of them, the policy will apply to that action.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.DeployPolicyResourceSelector selectors = 12 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  com.google.cloud.deploy.v1.DeployPolicyResourceSelectorOrBuilder getSelectorsOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * Required. Rules to apply. At least one rule must be present.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.PolicyRule rules = 10 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  java.util.List<com.google.cloud.deploy.v1.PolicyRule> getRulesList();
  /**
   *
   *
   * <pre>
   * Required. Rules to apply. At least one rule must be present.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.PolicyRule rules = 10 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  com.google.cloud.deploy.v1.PolicyRule getRules(int index);
  /**
   *
   *
   * <pre>
   * Required. Rules to apply. At least one rule must be present.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.PolicyRule rules = 10 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  int getRulesCount();
  /**
   *
   *
   * <pre>
   * Required. Rules to apply. At least one rule must be present.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.PolicyRule rules = 10 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  java.util.List<? extends com.google.cloud.deploy.v1.PolicyRuleOrBuilder> getRulesOrBuilderList();
  /**
   *
   *
   * <pre>
   * Required. Rules to apply. At least one rule must be present.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.PolicyRule rules = 10 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  com.google.cloud.deploy.v1.PolicyRuleOrBuilder getRulesOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * The weak etag of the `Automation` resource.
   * This checksum is computed by the server based on the value of other
   * fields, and may be sent on update and delete requests to ensure the
   * client has an up-to-date value before proceeding.
   * </pre>
   *
   * <code>string etag = 11;</code>
   *
   * @return The etag.
   */
  java.lang.String getEtag();
  /**
   *
   *
   * <pre>
   * The weak etag of the `Automation` resource.
   * This checksum is computed by the server based on the value of other
   * fields, and may be sent on update and delete requests to ensure the
   * client has an up-to-date value before proceeding.
   * </pre>
   *
   * <code>string etag = 11;</code>
   *
   * @return The bytes for etag.
   */
  com.google.protobuf.ByteString getEtagBytes();
}
