/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/deploy/v1/cloud_deploy.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.deploy.v1;

/**
 *
 *
 * <pre>
 * Configuration of the environment to use when calling Skaffold.
 * </pre>
 *
 * Protobuf type {@code google.cloud.deploy.v1.ExecutionConfig}
 */
public final class ExecutionConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.deploy.v1.ExecutionConfig)
    ExecutionConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ExecutionConfig.newBuilder() to construct.
  private ExecutionConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ExecutionConfig() {
    usages_ = java.util.Collections.emptyList();
    workerPool_ = "";
    serviceAccount_ = "";
    artifactStorage_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ExecutionConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.deploy.v1.CloudDeployProto
        .internal_static_google_cloud_deploy_v1_ExecutionConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.deploy.v1.CloudDeployProto
        .internal_static_google_cloud_deploy_v1_ExecutionConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.deploy.v1.ExecutionConfig.class,
            com.google.cloud.deploy.v1.ExecutionConfig.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Possible usages of this configuration.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.deploy.v1.ExecutionConfig.ExecutionEnvironmentUsage}
   */
  public enum ExecutionEnvironmentUsage implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default value. This value is unused.
     * </pre>
     *
     * <code>EXECUTION_ENVIRONMENT_USAGE_UNSPECIFIED = 0;</code>
     */
    EXECUTION_ENVIRONMENT_USAGE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Use for rendering.
     * </pre>
     *
     * <code>RENDER = 1;</code>
     */
    RENDER(1),
    /**
     *
     *
     * <pre>
     * Use for deploying and deployment hooks.
     * </pre>
     *
     * <code>DEPLOY = 2;</code>
     */
    DEPLOY(2),
    /**
     *
     *
     * <pre>
     * Use for deployment verification.
     * </pre>
     *
     * <code>VERIFY = 3;</code>
     */
    VERIFY(3),
    /**
     *
     *
     * <pre>
     * Use for predeploy job execution.
     * </pre>
     *
     * <code>PREDEPLOY = 4;</code>
     */
    PREDEPLOY(4),
    /**
     *
     *
     * <pre>
     * Use for postdeploy job execution.
     * </pre>
     *
     * <code>POSTDEPLOY = 5;</code>
     */
    POSTDEPLOY(5),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default value. This value is unused.
     * </pre>
     *
     * <code>EXECUTION_ENVIRONMENT_USAGE_UNSPECIFIED = 0;</code>
     */
    public static final int EXECUTION_ENVIRONMENT_USAGE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Use for rendering.
     * </pre>
     *
     * <code>RENDER = 1;</code>
     */
    public static final int RENDER_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Use for deploying and deployment hooks.
     * </pre>
     *
     * <code>DEPLOY = 2;</code>
     */
    public static final int DEPLOY_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Use for deployment verification.
     * </pre>
     *
     * <code>VERIFY = 3;</code>
     */
    public static final int VERIFY_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Use for predeploy job execution.
     * </pre>
     *
     * <code>PREDEPLOY = 4;</code>
     */
    public static final int PREDEPLOY_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Use for postdeploy job execution.
     * </pre>
     *
     * <code>POSTDEPLOY = 5;</code>
     */
    public static final int POSTDEPLOY_VALUE = 5;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ExecutionEnvironmentUsage valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ExecutionEnvironmentUsage forNumber(int value) {
      switch (value) {
        case 0:
          return EXECUTION_ENVIRONMENT_USAGE_UNSPECIFIED;
        case 1:
          return RENDER;
        case 2:
          return DEPLOY;
        case 3:
          return VERIFY;
        case 4:
          return PREDEPLOY;
        case 5:
          return POSTDEPLOY;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ExecutionEnvironmentUsage>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ExecutionEnvironmentUsage>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<ExecutionEnvironmentUsage>() {
              public ExecutionEnvironmentUsage findValueByNumber(int number) {
                return ExecutionEnvironmentUsage.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.deploy.v1.ExecutionConfig.getDescriptor().getEnumTypes().get(0);
    }

    private static final ExecutionEnvironmentUsage[] VALUES = values();

    public static ExecutionEnvironmentUsage valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ExecutionEnvironmentUsage(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.deploy.v1.ExecutionConfig.ExecutionEnvironmentUsage)
  }

  private int bitField0_;
  private int executionEnvironmentCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object executionEnvironment_;

  public enum ExecutionEnvironmentCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    DEFAULT_POOL(2),
    PRIVATE_POOL(3),
    EXECUTIONENVIRONMENT_NOT_SET(0);
    private final int value;

    private ExecutionEnvironmentCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ExecutionEnvironmentCase valueOf(int value) {
      return forNumber(value);
    }

    public static ExecutionEnvironmentCase forNumber(int value) {
      switch (value) {
        case 2:
          return DEFAULT_POOL;
        case 3:
          return PRIVATE_POOL;
        case 0:
          return EXECUTIONENVIRONMENT_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ExecutionEnvironmentCase getExecutionEnvironmentCase() {
    return ExecutionEnvironmentCase.forNumber(executionEnvironmentCase_);
  }

  public static final int USAGES_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<java.lang.Integer> usages_;

  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.cloud.deploy.v1.ExecutionConfig.ExecutionEnvironmentUsage>
      usages_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer,
              com.google.cloud.deploy.v1.ExecutionConfig.ExecutionEnvironmentUsage>() {
            public com.google.cloud.deploy.v1.ExecutionConfig.ExecutionEnvironmentUsage convert(
                java.lang.Integer from) {
              com.google.cloud.deploy.v1.ExecutionConfig.ExecutionEnvironmentUsage result =
                  com.google.cloud.deploy.v1.ExecutionConfig.ExecutionEnvironmentUsage.forNumber(
                      from);
              return result == null
                  ? com.google.cloud.deploy.v1.ExecutionConfig.ExecutionEnvironmentUsage
                      .UNRECOGNIZED
                  : result;
            }
          };
  /**
   *
   *
   * <pre>
   * Required. Usages when this configuration should be applied.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.ExecutionConfig.ExecutionEnvironmentUsage usages = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return A list containing the usages.
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.deploy.v1.ExecutionConfig.ExecutionEnvironmentUsage>
      getUsagesList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.cloud.deploy.v1.ExecutionConfig.ExecutionEnvironmentUsage>(
        usages_, usages_converter_);
  }
  /**
   *
   *
   * <pre>
   * Required. Usages when this configuration should be applied.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.ExecutionConfig.ExecutionEnvironmentUsage usages = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The count of usages.
   */
  @java.lang.Override
  public int getUsagesCount() {
    return usages_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. Usages when this configuration should be applied.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.ExecutionConfig.ExecutionEnvironmentUsage usages = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The usages at the given index.
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.ExecutionConfig.ExecutionEnvironmentUsage getUsages(int index) {
    return usages_converter_.convert(usages_.get(index));
  }
  /**
   *
   *
   * <pre>
   * Required. Usages when this configuration should be applied.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.ExecutionConfig.ExecutionEnvironmentUsage usages = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return A list containing the enum numeric values on the wire for usages.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getUsagesValueList() {
    return usages_;
  }
  /**
   *
   *
   * <pre>
   * Required. Usages when this configuration should be applied.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.ExecutionConfig.ExecutionEnvironmentUsage usages = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of usages at the given index.
   */
  @java.lang.Override
  public int getUsagesValue(int index) {
    return usages_.get(index);
  }

  private int usagesMemoizedSerializedSize;

  public static final int DEFAULT_POOL_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Optional. Use default Cloud Build pool.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.DefaultPool default_pool = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the defaultPool field is set.
   */
  @java.lang.Override
  public boolean hasDefaultPool() {
    return executionEnvironmentCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Optional. Use default Cloud Build pool.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.DefaultPool default_pool = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The defaultPool.
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.DefaultPool getDefaultPool() {
    if (executionEnvironmentCase_ == 2) {
      return (com.google.cloud.deploy.v1.DefaultPool) executionEnvironment_;
    }
    return com.google.cloud.deploy.v1.DefaultPool.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. Use default Cloud Build pool.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.DefaultPool default_pool = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.DefaultPoolOrBuilder getDefaultPoolOrBuilder() {
    if (executionEnvironmentCase_ == 2) {
      return (com.google.cloud.deploy.v1.DefaultPool) executionEnvironment_;
    }
    return com.google.cloud.deploy.v1.DefaultPool.getDefaultInstance();
  }

  public static final int PRIVATE_POOL_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Optional. Use private Cloud Build pool.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.PrivatePool private_pool = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the privatePool field is set.
   */
  @java.lang.Override
  public boolean hasPrivatePool() {
    return executionEnvironmentCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Optional. Use private Cloud Build pool.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.PrivatePool private_pool = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The privatePool.
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.PrivatePool getPrivatePool() {
    if (executionEnvironmentCase_ == 3) {
      return (com.google.cloud.deploy.v1.PrivatePool) executionEnvironment_;
    }
    return com.google.cloud.deploy.v1.PrivatePool.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. Use private Cloud Build pool.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.PrivatePool private_pool = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.PrivatePoolOrBuilder getPrivatePoolOrBuilder() {
    if (executionEnvironmentCase_ == 3) {
      return (com.google.cloud.deploy.v1.PrivatePool) executionEnvironment_;
    }
    return com.google.cloud.deploy.v1.PrivatePool.getDefaultInstance();
  }

  public static final int WORKER_POOL_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object workerPool_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The resource name of the `WorkerPool`, with the format
   * `projects/{project}/locations/{location}/workerPools/{worker_pool}`.
   * If this optional field is unspecified, the default Cloud Build pool will be
   * used.
   * </pre>
   *
   * <code>
   * string worker_pool = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The workerPool.
   */
  @java.lang.Override
  public java.lang.String getWorkerPool() {
    java.lang.Object ref = workerPool_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      workerPool_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The resource name of the `WorkerPool`, with the format
   * `projects/{project}/locations/{location}/workerPools/{worker_pool}`.
   * If this optional field is unspecified, the default Cloud Build pool will be
   * used.
   * </pre>
   *
   * <code>
   * string worker_pool = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for workerPool.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getWorkerPoolBytes() {
    java.lang.Object ref = workerPool_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      workerPool_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SERVICE_ACCOUNT_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object serviceAccount_ = "";
  /**
   *
   *
   * <pre>
   * Optional. Google service account to use for execution. If unspecified,
   * the project execution service account
   * (&lt;PROJECT_NUMBER&gt;-compute&#64;developer.gserviceaccount.com) is used.
   * </pre>
   *
   * <code>string service_account = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The serviceAccount.
   */
  @java.lang.Override
  public java.lang.String getServiceAccount() {
    java.lang.Object ref = serviceAccount_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      serviceAccount_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Google service account to use for execution. If unspecified,
   * the project execution service account
   * (&lt;PROJECT_NUMBER&gt;-compute&#64;developer.gserviceaccount.com) is used.
   * </pre>
   *
   * <code>string service_account = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for serviceAccount.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServiceAccountBytes() {
    java.lang.Object ref = serviceAccount_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      serviceAccount_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ARTIFACT_STORAGE_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object artifactStorage_ = "";
  /**
   *
   *
   * <pre>
   * Optional. Cloud Storage location in which to store execution outputs. This
   * can either be a bucket ("gs://my-bucket") or a path within a bucket
   * ("gs://my-bucket/my-dir").
   * If unspecified, a default bucket located in the same region will be used.
   * </pre>
   *
   * <code>string artifact_storage = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The artifactStorage.
   */
  @java.lang.Override
  public java.lang.String getArtifactStorage() {
    java.lang.Object ref = artifactStorage_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      artifactStorage_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Cloud Storage location in which to store execution outputs. This
   * can either be a bucket ("gs://my-bucket") or a path within a bucket
   * ("gs://my-bucket/my-dir").
   * If unspecified, a default bucket located in the same region will be used.
   * </pre>
   *
   * <code>string artifact_storage = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for artifactStorage.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getArtifactStorageBytes() {
    java.lang.Object ref = artifactStorage_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      artifactStorage_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EXECUTION_TIMEOUT_FIELD_NUMBER = 7;
  private com.google.protobuf.Duration executionTimeout_;
  /**
   *
   *
   * <pre>
   * Optional. Execution timeout for a Cloud Build Execution. This must be
   * between 10m and 24h in seconds format. If unspecified, a default timeout of
   * 1h is used.
   * </pre>
   *
   * <code>
   * .google.protobuf.Duration execution_timeout = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the executionTimeout field is set.
   */
  @java.lang.Override
  public boolean hasExecutionTimeout() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Execution timeout for a Cloud Build Execution. This must be
   * between 10m and 24h in seconds format. If unspecified, a default timeout of
   * 1h is used.
   * </pre>
   *
   * <code>
   * .google.protobuf.Duration execution_timeout = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The executionTimeout.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getExecutionTimeout() {
    return executionTimeout_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : executionTimeout_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Execution timeout for a Cloud Build Execution. This must be
   * between 10m and 24h in seconds format. If unspecified, a default timeout of
   * 1h is used.
   * </pre>
   *
   * <code>
   * .google.protobuf.Duration execution_timeout = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getExecutionTimeoutOrBuilder() {
    return executionTimeout_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : executionTimeout_;
  }

  public static final int VERBOSE_FIELD_NUMBER = 8;
  private boolean verbose_ = false;
  /**
   *
   *
   * <pre>
   * Optional. If true, additional logging will be enabled when running builds
   * in this execution environment.
   * </pre>
   *
   * <code>bool verbose = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The verbose.
   */
  @java.lang.Override
  public boolean getVerbose() {
    return verbose_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (getUsagesList().size() > 0) {
      output.writeUInt32NoTag(10);
      output.writeUInt32NoTag(usagesMemoizedSerializedSize);
    }
    for (int i = 0; i < usages_.size(); i++) {
      output.writeEnumNoTag(usages_.get(i));
    }
    if (executionEnvironmentCase_ == 2) {
      output.writeMessage(2, (com.google.cloud.deploy.v1.DefaultPool) executionEnvironment_);
    }
    if (executionEnvironmentCase_ == 3) {
      output.writeMessage(3, (com.google.cloud.deploy.v1.PrivatePool) executionEnvironment_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(workerPool_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, workerPool_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccount_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, serviceAccount_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(artifactStorage_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, artifactStorage_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(7, getExecutionTimeout());
    }
    if (verbose_ != false) {
      output.writeBool(8, verbose_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    {
      int dataSize = 0;
      for (int i = 0; i < usages_.size(); i++) {
        dataSize += com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(usages_.get(i));
      }
      size += dataSize;
      if (!getUsagesList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      usagesMemoizedSerializedSize = dataSize;
    }
    if (executionEnvironmentCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.cloud.deploy.v1.DefaultPool) executionEnvironment_);
    }
    if (executionEnvironmentCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.cloud.deploy.v1.PrivatePool) executionEnvironment_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(workerPool_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, workerPool_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccount_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, serviceAccount_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(artifactStorage_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, artifactStorage_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getExecutionTimeout());
    }
    if (verbose_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(8, verbose_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.deploy.v1.ExecutionConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.deploy.v1.ExecutionConfig other =
        (com.google.cloud.deploy.v1.ExecutionConfig) obj;

    if (!usages_.equals(other.usages_)) return false;
    if (!getWorkerPool().equals(other.getWorkerPool())) return false;
    if (!getServiceAccount().equals(other.getServiceAccount())) return false;
    if (!getArtifactStorage().equals(other.getArtifactStorage())) return false;
    if (hasExecutionTimeout() != other.hasExecutionTimeout()) return false;
    if (hasExecutionTimeout()) {
      if (!getExecutionTimeout().equals(other.getExecutionTimeout())) return false;
    }
    if (getVerbose() != other.getVerbose()) return false;
    if (!getExecutionEnvironmentCase().equals(other.getExecutionEnvironmentCase())) return false;
    switch (executionEnvironmentCase_) {
      case 2:
        if (!getDefaultPool().equals(other.getDefaultPool())) return false;
        break;
      case 3:
        if (!getPrivatePool().equals(other.getPrivatePool())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getUsagesCount() > 0) {
      hash = (37 * hash) + USAGES_FIELD_NUMBER;
      hash = (53 * hash) + usages_.hashCode();
    }
    hash = (37 * hash) + WORKER_POOL_FIELD_NUMBER;
    hash = (53 * hash) + getWorkerPool().hashCode();
    hash = (37 * hash) + SERVICE_ACCOUNT_FIELD_NUMBER;
    hash = (53 * hash) + getServiceAccount().hashCode();
    hash = (37 * hash) + ARTIFACT_STORAGE_FIELD_NUMBER;
    hash = (53 * hash) + getArtifactStorage().hashCode();
    if (hasExecutionTimeout()) {
      hash = (37 * hash) + EXECUTION_TIMEOUT_FIELD_NUMBER;
      hash = (53 * hash) + getExecutionTimeout().hashCode();
    }
    hash = (37 * hash) + VERBOSE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getVerbose());
    switch (executionEnvironmentCase_) {
      case 2:
        hash = (37 * hash) + DEFAULT_POOL_FIELD_NUMBER;
        hash = (53 * hash) + getDefaultPool().hashCode();
        break;
      case 3:
        hash = (37 * hash) + PRIVATE_POOL_FIELD_NUMBER;
        hash = (53 * hash) + getPrivatePool().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.deploy.v1.ExecutionConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.ExecutionConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.ExecutionConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.ExecutionConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.ExecutionConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.ExecutionConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.ExecutionConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.ExecutionConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.ExecutionConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.ExecutionConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.ExecutionConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.ExecutionConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.deploy.v1.ExecutionConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Configuration of the environment to use when calling Skaffold.
   * </pre>
   *
   * Protobuf type {@code google.cloud.deploy.v1.ExecutionConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.deploy.v1.ExecutionConfig)
      com.google.cloud.deploy.v1.ExecutionConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_ExecutionConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_ExecutionConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.deploy.v1.ExecutionConfig.class,
              com.google.cloud.deploy.v1.ExecutionConfig.Builder.class);
    }

    // Construct using com.google.cloud.deploy.v1.ExecutionConfig.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getExecutionTimeoutFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      usages_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000001);
      if (defaultPoolBuilder_ != null) {
        defaultPoolBuilder_.clear();
      }
      if (privatePoolBuilder_ != null) {
        privatePoolBuilder_.clear();
      }
      workerPool_ = "";
      serviceAccount_ = "";
      artifactStorage_ = "";
      executionTimeout_ = null;
      if (executionTimeoutBuilder_ != null) {
        executionTimeoutBuilder_.dispose();
        executionTimeoutBuilder_ = null;
      }
      verbose_ = false;
      executionEnvironmentCase_ = 0;
      executionEnvironment_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_ExecutionConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.ExecutionConfig getDefaultInstanceForType() {
      return com.google.cloud.deploy.v1.ExecutionConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.ExecutionConfig build() {
      com.google.cloud.deploy.v1.ExecutionConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.ExecutionConfig buildPartial() {
      com.google.cloud.deploy.v1.ExecutionConfig result =
          new com.google.cloud.deploy.v1.ExecutionConfig(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.deploy.v1.ExecutionConfig result) {
      if (((bitField0_ & 0x00000001) != 0)) {
        usages_ = java.util.Collections.unmodifiableList(usages_);
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.usages_ = usages_;
    }

    private void buildPartial0(com.google.cloud.deploy.v1.ExecutionConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.workerPool_ = workerPool_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.serviceAccount_ = serviceAccount_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.artifactStorage_ = artifactStorage_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.executionTimeout_ =
            executionTimeoutBuilder_ == null ? executionTimeout_ : executionTimeoutBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.verbose_ = verbose_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.deploy.v1.ExecutionConfig result) {
      result.executionEnvironmentCase_ = executionEnvironmentCase_;
      result.executionEnvironment_ = this.executionEnvironment_;
      if (executionEnvironmentCase_ == 2 && defaultPoolBuilder_ != null) {
        result.executionEnvironment_ = defaultPoolBuilder_.build();
      }
      if (executionEnvironmentCase_ == 3 && privatePoolBuilder_ != null) {
        result.executionEnvironment_ = privatePoolBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.deploy.v1.ExecutionConfig) {
        return mergeFrom((com.google.cloud.deploy.v1.ExecutionConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.deploy.v1.ExecutionConfig other) {
      if (other == com.google.cloud.deploy.v1.ExecutionConfig.getDefaultInstance()) return this;
      if (!other.usages_.isEmpty()) {
        if (usages_.isEmpty()) {
          usages_ = other.usages_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensureUsagesIsMutable();
          usages_.addAll(other.usages_);
        }
        onChanged();
      }
      if (!other.getWorkerPool().isEmpty()) {
        workerPool_ = other.workerPool_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getServiceAccount().isEmpty()) {
        serviceAccount_ = other.serviceAccount_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.getArtifactStorage().isEmpty()) {
        artifactStorage_ = other.artifactStorage_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.hasExecutionTimeout()) {
        mergeExecutionTimeout(other.getExecutionTimeout());
      }
      if (other.getVerbose() != false) {
        setVerbose(other.getVerbose());
      }
      switch (other.getExecutionEnvironmentCase()) {
        case DEFAULT_POOL:
          {
            mergeDefaultPool(other.getDefaultPool());
            break;
          }
        case PRIVATE_POOL:
          {
            mergePrivatePool(other.getPrivatePool());
            break;
          }
        case EXECUTIONENVIRONMENT_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                int tmpRaw = input.readEnum();
                ensureUsagesIsMutable();
                usages_.add(tmpRaw);
                break;
              } // case 8
            case 10:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensureUsagesIsMutable();
                  usages_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getDefaultPoolFieldBuilder().getBuilder(), extensionRegistry);
                executionEnvironmentCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getPrivatePoolFieldBuilder().getBuilder(), extensionRegistry);
                executionEnvironmentCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                workerPool_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                serviceAccount_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                artifactStorage_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(
                    getExecutionTimeoutFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 64:
              {
                verbose_ = input.readBool();
                bitField0_ |= 0x00000080;
                break;
              } // case 64
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int executionEnvironmentCase_ = 0;
    private java.lang.Object executionEnvironment_;

    public ExecutionEnvironmentCase getExecutionEnvironmentCase() {
      return ExecutionEnvironmentCase.forNumber(executionEnvironmentCase_);
    }

    public Builder clearExecutionEnvironment() {
      executionEnvironmentCase_ = 0;
      executionEnvironment_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.util.List<java.lang.Integer> usages_ = java.util.Collections.emptyList();

    private void ensureUsagesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        usages_ = new java.util.ArrayList<java.lang.Integer>(usages_);
        bitField0_ |= 0x00000001;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Usages when this configuration should be applied.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.ExecutionConfig.ExecutionEnvironmentUsage usages = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return A list containing the usages.
     */
    public java.util.List<com.google.cloud.deploy.v1.ExecutionConfig.ExecutionEnvironmentUsage>
        getUsagesList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.cloud.deploy.v1.ExecutionConfig.ExecutionEnvironmentUsage>(
          usages_, usages_converter_);
    }
    /**
     *
     *
     * <pre>
     * Required. Usages when this configuration should be applied.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.ExecutionConfig.ExecutionEnvironmentUsage usages = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The count of usages.
     */
    public int getUsagesCount() {
      return usages_.size();
    }
    /**
     *
     *
     * <pre>
     * Required. Usages when this configuration should be applied.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.ExecutionConfig.ExecutionEnvironmentUsage usages = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The usages at the given index.
     */
    public com.google.cloud.deploy.v1.ExecutionConfig.ExecutionEnvironmentUsage getUsages(
        int index) {
      return usages_converter_.convert(usages_.get(index));
    }
    /**
     *
     *
     * <pre>
     * Required. Usages when this configuration should be applied.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.ExecutionConfig.ExecutionEnvironmentUsage usages = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The usages to set.
     * @return This builder for chaining.
     */
    public Builder setUsages(
        int index, com.google.cloud.deploy.v1.ExecutionConfig.ExecutionEnvironmentUsage value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureUsagesIsMutable();
      usages_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Usages when this configuration should be applied.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.ExecutionConfig.ExecutionEnvironmentUsage usages = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The usages to add.
     * @return This builder for chaining.
     */
    public Builder addUsages(
        com.google.cloud.deploy.v1.ExecutionConfig.ExecutionEnvironmentUsage value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureUsagesIsMutable();
      usages_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Usages when this configuration should be applied.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.ExecutionConfig.ExecutionEnvironmentUsage usages = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param values The usages to add.
     * @return This builder for chaining.
     */
    public Builder addAllUsages(
        java.lang.Iterable<
                ? extends com.google.cloud.deploy.v1.ExecutionConfig.ExecutionEnvironmentUsage>
            values) {
      ensureUsagesIsMutable();
      for (com.google.cloud.deploy.v1.ExecutionConfig.ExecutionEnvironmentUsage value : values) {
        usages_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Usages when this configuration should be applied.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.ExecutionConfig.ExecutionEnvironmentUsage usages = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUsages() {
      usages_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Usages when this configuration should be applied.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.ExecutionConfig.ExecutionEnvironmentUsage usages = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return A list containing the enum numeric values on the wire for usages.
     */
    public java.util.List<java.lang.Integer> getUsagesValueList() {
      return java.util.Collections.unmodifiableList(usages_);
    }
    /**
     *
     *
     * <pre>
     * Required. Usages when this configuration should be applied.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.ExecutionConfig.ExecutionEnvironmentUsage usages = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of usages at the given index.
     */
    public int getUsagesValue(int index) {
      return usages_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Required. Usages when this configuration should be applied.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.ExecutionConfig.ExecutionEnvironmentUsage usages = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for usages to set.
     * @return This builder for chaining.
     */
    public Builder setUsagesValue(int index, int value) {
      ensureUsagesIsMutable();
      usages_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Usages when this configuration should be applied.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.ExecutionConfig.ExecutionEnvironmentUsage usages = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The enum numeric value on the wire for usages to add.
     * @return This builder for chaining.
     */
    public Builder addUsagesValue(int value) {
      ensureUsagesIsMutable();
      usages_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Usages when this configuration should be applied.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.ExecutionConfig.ExecutionEnvironmentUsage usages = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param values The enum numeric values on the wire for usages to add.
     * @return This builder for chaining.
     */
    public Builder addAllUsagesValue(java.lang.Iterable<java.lang.Integer> values) {
      ensureUsagesIsMutable();
      for (int value : values) {
        usages_.add(value);
      }
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.DefaultPool,
            com.google.cloud.deploy.v1.DefaultPool.Builder,
            com.google.cloud.deploy.v1.DefaultPoolOrBuilder>
        defaultPoolBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Use default Cloud Build pool.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.DefaultPool default_pool = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the defaultPool field is set.
     */
    @java.lang.Override
    public boolean hasDefaultPool() {
      return executionEnvironmentCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Optional. Use default Cloud Build pool.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.DefaultPool default_pool = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The defaultPool.
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.DefaultPool getDefaultPool() {
      if (defaultPoolBuilder_ == null) {
        if (executionEnvironmentCase_ == 2) {
          return (com.google.cloud.deploy.v1.DefaultPool) executionEnvironment_;
        }
        return com.google.cloud.deploy.v1.DefaultPool.getDefaultInstance();
      } else {
        if (executionEnvironmentCase_ == 2) {
          return defaultPoolBuilder_.getMessage();
        }
        return com.google.cloud.deploy.v1.DefaultPool.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Use default Cloud Build pool.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.DefaultPool default_pool = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setDefaultPool(com.google.cloud.deploy.v1.DefaultPool value) {
      if (defaultPoolBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        executionEnvironment_ = value;
        onChanged();
      } else {
        defaultPoolBuilder_.setMessage(value);
      }
      executionEnvironmentCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Use default Cloud Build pool.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.DefaultPool default_pool = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setDefaultPool(com.google.cloud.deploy.v1.DefaultPool.Builder builderForValue) {
      if (defaultPoolBuilder_ == null) {
        executionEnvironment_ = builderForValue.build();
        onChanged();
      } else {
        defaultPoolBuilder_.setMessage(builderForValue.build());
      }
      executionEnvironmentCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Use default Cloud Build pool.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.DefaultPool default_pool = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeDefaultPool(com.google.cloud.deploy.v1.DefaultPool value) {
      if (defaultPoolBuilder_ == null) {
        if (executionEnvironmentCase_ == 2
            && executionEnvironment_
                != com.google.cloud.deploy.v1.DefaultPool.getDefaultInstance()) {
          executionEnvironment_ =
              com.google.cloud.deploy.v1.DefaultPool.newBuilder(
                      (com.google.cloud.deploy.v1.DefaultPool) executionEnvironment_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          executionEnvironment_ = value;
        }
        onChanged();
      } else {
        if (executionEnvironmentCase_ == 2) {
          defaultPoolBuilder_.mergeFrom(value);
        } else {
          defaultPoolBuilder_.setMessage(value);
        }
      }
      executionEnvironmentCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Use default Cloud Build pool.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.DefaultPool default_pool = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearDefaultPool() {
      if (defaultPoolBuilder_ == null) {
        if (executionEnvironmentCase_ == 2) {
          executionEnvironmentCase_ = 0;
          executionEnvironment_ = null;
          onChanged();
        }
      } else {
        if (executionEnvironmentCase_ == 2) {
          executionEnvironmentCase_ = 0;
          executionEnvironment_ = null;
        }
        defaultPoolBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Use default Cloud Build pool.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.DefaultPool default_pool = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.deploy.v1.DefaultPool.Builder getDefaultPoolBuilder() {
      return getDefaultPoolFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Use default Cloud Build pool.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.DefaultPool default_pool = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.DefaultPoolOrBuilder getDefaultPoolOrBuilder() {
      if ((executionEnvironmentCase_ == 2) && (defaultPoolBuilder_ != null)) {
        return defaultPoolBuilder_.getMessageOrBuilder();
      } else {
        if (executionEnvironmentCase_ == 2) {
          return (com.google.cloud.deploy.v1.DefaultPool) executionEnvironment_;
        }
        return com.google.cloud.deploy.v1.DefaultPool.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Use default Cloud Build pool.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.DefaultPool default_pool = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.DefaultPool,
            com.google.cloud.deploy.v1.DefaultPool.Builder,
            com.google.cloud.deploy.v1.DefaultPoolOrBuilder>
        getDefaultPoolFieldBuilder() {
      if (defaultPoolBuilder_ == null) {
        if (!(executionEnvironmentCase_ == 2)) {
          executionEnvironment_ = com.google.cloud.deploy.v1.DefaultPool.getDefaultInstance();
        }
        defaultPoolBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.deploy.v1.DefaultPool,
                com.google.cloud.deploy.v1.DefaultPool.Builder,
                com.google.cloud.deploy.v1.DefaultPoolOrBuilder>(
                (com.google.cloud.deploy.v1.DefaultPool) executionEnvironment_,
                getParentForChildren(),
                isClean());
        executionEnvironment_ = null;
      }
      executionEnvironmentCase_ = 2;
      onChanged();
      return defaultPoolBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.PrivatePool,
            com.google.cloud.deploy.v1.PrivatePool.Builder,
            com.google.cloud.deploy.v1.PrivatePoolOrBuilder>
        privatePoolBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Use private Cloud Build pool.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.PrivatePool private_pool = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the privatePool field is set.
     */
    @java.lang.Override
    public boolean hasPrivatePool() {
      return executionEnvironmentCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Optional. Use private Cloud Build pool.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.PrivatePool private_pool = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The privatePool.
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.PrivatePool getPrivatePool() {
      if (privatePoolBuilder_ == null) {
        if (executionEnvironmentCase_ == 3) {
          return (com.google.cloud.deploy.v1.PrivatePool) executionEnvironment_;
        }
        return com.google.cloud.deploy.v1.PrivatePool.getDefaultInstance();
      } else {
        if (executionEnvironmentCase_ == 3) {
          return privatePoolBuilder_.getMessage();
        }
        return com.google.cloud.deploy.v1.PrivatePool.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Use private Cloud Build pool.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.PrivatePool private_pool = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPrivatePool(com.google.cloud.deploy.v1.PrivatePool value) {
      if (privatePoolBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        executionEnvironment_ = value;
        onChanged();
      } else {
        privatePoolBuilder_.setMessage(value);
      }
      executionEnvironmentCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Use private Cloud Build pool.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.PrivatePool private_pool = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPrivatePool(com.google.cloud.deploy.v1.PrivatePool.Builder builderForValue) {
      if (privatePoolBuilder_ == null) {
        executionEnvironment_ = builderForValue.build();
        onChanged();
      } else {
        privatePoolBuilder_.setMessage(builderForValue.build());
      }
      executionEnvironmentCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Use private Cloud Build pool.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.PrivatePool private_pool = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergePrivatePool(com.google.cloud.deploy.v1.PrivatePool value) {
      if (privatePoolBuilder_ == null) {
        if (executionEnvironmentCase_ == 3
            && executionEnvironment_
                != com.google.cloud.deploy.v1.PrivatePool.getDefaultInstance()) {
          executionEnvironment_ =
              com.google.cloud.deploy.v1.PrivatePool.newBuilder(
                      (com.google.cloud.deploy.v1.PrivatePool) executionEnvironment_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          executionEnvironment_ = value;
        }
        onChanged();
      } else {
        if (executionEnvironmentCase_ == 3) {
          privatePoolBuilder_.mergeFrom(value);
        } else {
          privatePoolBuilder_.setMessage(value);
        }
      }
      executionEnvironmentCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Use private Cloud Build pool.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.PrivatePool private_pool = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearPrivatePool() {
      if (privatePoolBuilder_ == null) {
        if (executionEnvironmentCase_ == 3) {
          executionEnvironmentCase_ = 0;
          executionEnvironment_ = null;
          onChanged();
        }
      } else {
        if (executionEnvironmentCase_ == 3) {
          executionEnvironmentCase_ = 0;
          executionEnvironment_ = null;
        }
        privatePoolBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Use private Cloud Build pool.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.PrivatePool private_pool = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.deploy.v1.PrivatePool.Builder getPrivatePoolBuilder() {
      return getPrivatePoolFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Use private Cloud Build pool.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.PrivatePool private_pool = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.PrivatePoolOrBuilder getPrivatePoolOrBuilder() {
      if ((executionEnvironmentCase_ == 3) && (privatePoolBuilder_ != null)) {
        return privatePoolBuilder_.getMessageOrBuilder();
      } else {
        if (executionEnvironmentCase_ == 3) {
          return (com.google.cloud.deploy.v1.PrivatePool) executionEnvironment_;
        }
        return com.google.cloud.deploy.v1.PrivatePool.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Use private Cloud Build pool.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.PrivatePool private_pool = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.PrivatePool,
            com.google.cloud.deploy.v1.PrivatePool.Builder,
            com.google.cloud.deploy.v1.PrivatePoolOrBuilder>
        getPrivatePoolFieldBuilder() {
      if (privatePoolBuilder_ == null) {
        if (!(executionEnvironmentCase_ == 3)) {
          executionEnvironment_ = com.google.cloud.deploy.v1.PrivatePool.getDefaultInstance();
        }
        privatePoolBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.deploy.v1.PrivatePool,
                com.google.cloud.deploy.v1.PrivatePool.Builder,
                com.google.cloud.deploy.v1.PrivatePoolOrBuilder>(
                (com.google.cloud.deploy.v1.PrivatePool) executionEnvironment_,
                getParentForChildren(),
                isClean());
        executionEnvironment_ = null;
      }
      executionEnvironmentCase_ = 3;
      onChanged();
      return privatePoolBuilder_;
    }

    private java.lang.Object workerPool_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The resource name of the `WorkerPool`, with the format
     * `projects/{project}/locations/{location}/workerPools/{worker_pool}`.
     * If this optional field is unspecified, the default Cloud Build pool will be
     * used.
     * </pre>
     *
     * <code>
     * string worker_pool = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The workerPool.
     */
    public java.lang.String getWorkerPool() {
      java.lang.Object ref = workerPool_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        workerPool_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The resource name of the `WorkerPool`, with the format
     * `projects/{project}/locations/{location}/workerPools/{worker_pool}`.
     * If this optional field is unspecified, the default Cloud Build pool will be
     * used.
     * </pre>
     *
     * <code>
     * string worker_pool = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for workerPool.
     */
    public com.google.protobuf.ByteString getWorkerPoolBytes() {
      java.lang.Object ref = workerPool_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        workerPool_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The resource name of the `WorkerPool`, with the format
     * `projects/{project}/locations/{location}/workerPools/{worker_pool}`.
     * If this optional field is unspecified, the default Cloud Build pool will be
     * used.
     * </pre>
     *
     * <code>
     * string worker_pool = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The workerPool to set.
     * @return This builder for chaining.
     */
    public Builder setWorkerPool(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      workerPool_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The resource name of the `WorkerPool`, with the format
     * `projects/{project}/locations/{location}/workerPools/{worker_pool}`.
     * If this optional field is unspecified, the default Cloud Build pool will be
     * used.
     * </pre>
     *
     * <code>
     * string worker_pool = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearWorkerPool() {
      workerPool_ = getDefaultInstance().getWorkerPool();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The resource name of the `WorkerPool`, with the format
     * `projects/{project}/locations/{location}/workerPools/{worker_pool}`.
     * If this optional field is unspecified, the default Cloud Build pool will be
     * used.
     * </pre>
     *
     * <code>
     * string worker_pool = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for workerPool to set.
     * @return This builder for chaining.
     */
    public Builder setWorkerPoolBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      workerPool_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object serviceAccount_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Google service account to use for execution. If unspecified,
     * the project execution service account
     * (&lt;PROJECT_NUMBER&gt;-compute&#64;developer.gserviceaccount.com) is used.
     * </pre>
     *
     * <code>string service_account = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The serviceAccount.
     */
    public java.lang.String getServiceAccount() {
      java.lang.Object ref = serviceAccount_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceAccount_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Google service account to use for execution. If unspecified,
     * the project execution service account
     * (&lt;PROJECT_NUMBER&gt;-compute&#64;developer.gserviceaccount.com) is used.
     * </pre>
     *
     * <code>string service_account = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for serviceAccount.
     */
    public com.google.protobuf.ByteString getServiceAccountBytes() {
      java.lang.Object ref = serviceAccount_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceAccount_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Google service account to use for execution. If unspecified,
     * the project execution service account
     * (&lt;PROJECT_NUMBER&gt;-compute&#64;developer.gserviceaccount.com) is used.
     * </pre>
     *
     * <code>string service_account = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The serviceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccount(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      serviceAccount_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Google service account to use for execution. If unspecified,
     * the project execution service account
     * (&lt;PROJECT_NUMBER&gt;-compute&#64;developer.gserviceaccount.com) is used.
     * </pre>
     *
     * <code>string service_account = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServiceAccount() {
      serviceAccount_ = getDefaultInstance().getServiceAccount();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Google service account to use for execution. If unspecified,
     * the project execution service account
     * (&lt;PROJECT_NUMBER&gt;-compute&#64;developer.gserviceaccount.com) is used.
     * </pre>
     *
     * <code>string service_account = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for serviceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccountBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      serviceAccount_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object artifactStorage_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Cloud Storage location in which to store execution outputs. This
     * can either be a bucket ("gs://my-bucket") or a path within a bucket
     * ("gs://my-bucket/my-dir").
     * If unspecified, a default bucket located in the same region will be used.
     * </pre>
     *
     * <code>string artifact_storage = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The artifactStorage.
     */
    public java.lang.String getArtifactStorage() {
      java.lang.Object ref = artifactStorage_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        artifactStorage_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Cloud Storage location in which to store execution outputs. This
     * can either be a bucket ("gs://my-bucket") or a path within a bucket
     * ("gs://my-bucket/my-dir").
     * If unspecified, a default bucket located in the same region will be used.
     * </pre>
     *
     * <code>string artifact_storage = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for artifactStorage.
     */
    public com.google.protobuf.ByteString getArtifactStorageBytes() {
      java.lang.Object ref = artifactStorage_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        artifactStorage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Cloud Storage location in which to store execution outputs. This
     * can either be a bucket ("gs://my-bucket") or a path within a bucket
     * ("gs://my-bucket/my-dir").
     * If unspecified, a default bucket located in the same region will be used.
     * </pre>
     *
     * <code>string artifact_storage = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The artifactStorage to set.
     * @return This builder for chaining.
     */
    public Builder setArtifactStorage(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      artifactStorage_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Cloud Storage location in which to store execution outputs. This
     * can either be a bucket ("gs://my-bucket") or a path within a bucket
     * ("gs://my-bucket/my-dir").
     * If unspecified, a default bucket located in the same region will be used.
     * </pre>
     *
     * <code>string artifact_storage = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearArtifactStorage() {
      artifactStorage_ = getDefaultInstance().getArtifactStorage();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Cloud Storage location in which to store execution outputs. This
     * can either be a bucket ("gs://my-bucket") or a path within a bucket
     * ("gs://my-bucket/my-dir").
     * If unspecified, a default bucket located in the same region will be used.
     * </pre>
     *
     * <code>string artifact_storage = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for artifactStorage to set.
     * @return This builder for chaining.
     */
    public Builder setArtifactStorageBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      artifactStorage_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private com.google.protobuf.Duration executionTimeout_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        executionTimeoutBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Execution timeout for a Cloud Build Execution. This must be
     * between 10m and 24h in seconds format. If unspecified, a default timeout of
     * 1h is used.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration execution_timeout = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the executionTimeout field is set.
     */
    public boolean hasExecutionTimeout() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Execution timeout for a Cloud Build Execution. This must be
     * between 10m and 24h in seconds format. If unspecified, a default timeout of
     * 1h is used.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration execution_timeout = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The executionTimeout.
     */
    public com.google.protobuf.Duration getExecutionTimeout() {
      if (executionTimeoutBuilder_ == null) {
        return executionTimeout_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : executionTimeout_;
      } else {
        return executionTimeoutBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Execution timeout for a Cloud Build Execution. This must be
     * between 10m and 24h in seconds format. If unspecified, a default timeout of
     * 1h is used.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration execution_timeout = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setExecutionTimeout(com.google.protobuf.Duration value) {
      if (executionTimeoutBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        executionTimeout_ = value;
      } else {
        executionTimeoutBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Execution timeout for a Cloud Build Execution. This must be
     * between 10m and 24h in seconds format. If unspecified, a default timeout of
     * 1h is used.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration execution_timeout = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setExecutionTimeout(com.google.protobuf.Duration.Builder builderForValue) {
      if (executionTimeoutBuilder_ == null) {
        executionTimeout_ = builderForValue.build();
      } else {
        executionTimeoutBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Execution timeout for a Cloud Build Execution. This must be
     * between 10m and 24h in seconds format. If unspecified, a default timeout of
     * 1h is used.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration execution_timeout = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeExecutionTimeout(com.google.protobuf.Duration value) {
      if (executionTimeoutBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && executionTimeout_ != null
            && executionTimeout_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getExecutionTimeoutBuilder().mergeFrom(value);
        } else {
          executionTimeout_ = value;
        }
      } else {
        executionTimeoutBuilder_.mergeFrom(value);
      }
      if (executionTimeout_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Execution timeout for a Cloud Build Execution. This must be
     * between 10m and 24h in seconds format. If unspecified, a default timeout of
     * 1h is used.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration execution_timeout = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearExecutionTimeout() {
      bitField0_ = (bitField0_ & ~0x00000040);
      executionTimeout_ = null;
      if (executionTimeoutBuilder_ != null) {
        executionTimeoutBuilder_.dispose();
        executionTimeoutBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Execution timeout for a Cloud Build Execution. This must be
     * between 10m and 24h in seconds format. If unspecified, a default timeout of
     * 1h is used.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration execution_timeout = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Duration.Builder getExecutionTimeoutBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getExecutionTimeoutFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Execution timeout for a Cloud Build Execution. This must be
     * between 10m and 24h in seconds format. If unspecified, a default timeout of
     * 1h is used.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration execution_timeout = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.DurationOrBuilder getExecutionTimeoutOrBuilder() {
      if (executionTimeoutBuilder_ != null) {
        return executionTimeoutBuilder_.getMessageOrBuilder();
      } else {
        return executionTimeout_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : executionTimeout_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Execution timeout for a Cloud Build Execution. This must be
     * between 10m and 24h in seconds format. If unspecified, a default timeout of
     * 1h is used.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration execution_timeout = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getExecutionTimeoutFieldBuilder() {
      if (executionTimeoutBuilder_ == null) {
        executionTimeoutBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getExecutionTimeout(), getParentForChildren(), isClean());
        executionTimeout_ = null;
      }
      return executionTimeoutBuilder_;
    }

    private boolean verbose_;
    /**
     *
     *
     * <pre>
     * Optional. If true, additional logging will be enabled when running builds
     * in this execution environment.
     * </pre>
     *
     * <code>bool verbose = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The verbose.
     */
    @java.lang.Override
    public boolean getVerbose() {
      return verbose_;
    }
    /**
     *
     *
     * <pre>
     * Optional. If true, additional logging will be enabled when running builds
     * in this execution environment.
     * </pre>
     *
     * <code>bool verbose = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The verbose to set.
     * @return This builder for chaining.
     */
    public Builder setVerbose(boolean value) {

      verbose_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If true, additional logging will be enabled when running builds
     * in this execution environment.
     * </pre>
     *
     * <code>bool verbose = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVerbose() {
      bitField0_ = (bitField0_ & ~0x00000080);
      verbose_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.deploy.v1.ExecutionConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.deploy.v1.ExecutionConfig)
  private static final com.google.cloud.deploy.v1.ExecutionConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.deploy.v1.ExecutionConfig();
  }

  public static com.google.cloud.deploy.v1.ExecutionConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ExecutionConfig> PARSER =
      new com.google.protobuf.AbstractParser<ExecutionConfig>() {
        @java.lang.Override
        public ExecutionConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ExecutionConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ExecutionConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.deploy.v1.ExecutionConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
