/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/deploy/v1/cloud_deploy.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.deploy.v1;

public interface GkeClusterOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.deploy.v1.GkeCluster)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Optional. Information specifying a GKE Cluster. Format is
   * `projects/{project_id}/locations/{location_id}/clusters/{cluster_id}`.
   * </pre>
   *
   * <code>
   * string cluster = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The cluster.
   */
  java.lang.String getCluster();
  /**
   *
   *
   * <pre>
   * Optional. Information specifying a GKE Cluster. Format is
   * `projects/{project_id}/locations/{location_id}/clusters/{cluster_id}`.
   * </pre>
   *
   * <code>
   * string cluster = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for cluster.
   */
  com.google.protobuf.ByteString getClusterBytes();

  /**
   *
   *
   * <pre>
   * Optional. If true, `cluster` is accessed using the private IP address of
   * the control plane endpoint. Otherwise, the default IP address of the
   * control plane endpoint is used. The default IP address is the private IP
   * address for clusters with private control-plane endpoints and the public IP
   * address otherwise.
   *
   * Only specify this option when `cluster` is a [private GKE
   * cluster](https://cloud.google.com/kubernetes-engine/docs/concepts/private-cluster-concept).
   * Note that `internal_ip` and `dns_endpoint` cannot both be set to true.
   * </pre>
   *
   * <code>bool internal_ip = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The internalIp.
   */
  boolean getInternalIp();

  /**
   *
   *
   * <pre>
   * Optional. If set, used to configure a
   * [proxy](https://kubernetes.io/docs/concepts/configuration/organize-cluster-access-kubeconfig/#proxy)
   * to the Kubernetes server.
   * </pre>
   *
   * <code>string proxy_url = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The proxyUrl.
   */
  java.lang.String getProxyUrl();
  /**
   *
   *
   * <pre>
   * Optional. If set, used to configure a
   * [proxy](https://kubernetes.io/docs/concepts/configuration/organize-cluster-access-kubeconfig/#proxy)
   * to the Kubernetes server.
   * </pre>
   *
   * <code>string proxy_url = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for proxyUrl.
   */
  com.google.protobuf.ByteString getProxyUrlBytes();

  /**
   *
   *
   * <pre>
   * Optional. If set, the cluster will be accessed using the DNS endpoint. Note
   * that `dns_endpoint` and `internal_ip` cannot both be set to true.
   * </pre>
   *
   * <code>bool dns_endpoint = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The dnsEndpoint.
   */
  boolean getDnsEndpoint();
}
