/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/deploy/v1/cloud_deploy.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.deploy.v1;

/**
 *
 *
 * <pre>
 * A `JobRun` resource in the Cloud Deploy API.
 *
 * A `JobRun` contains information of a single `Rollout` job evaluation.
 * </pre>
 *
 * Protobuf type {@code google.cloud.deploy.v1.JobRun}
 */
public final class JobRun extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.deploy.v1.JobRun)
    JobRunOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use JobRun.newBuilder() to construct.
  private JobRun(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private JobRun() {
    name_ = "";
    uid_ = "";
    phaseId_ = "";
    jobId_ = "";
    state_ = 0;
    etag_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new JobRun();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.deploy.v1.CloudDeployProto
        .internal_static_google_cloud_deploy_v1_JobRun_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.deploy.v1.CloudDeployProto
        .internal_static_google_cloud_deploy_v1_JobRun_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.deploy.v1.JobRun.class,
            com.google.cloud.deploy.v1.JobRun.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Valid states of a `JobRun`.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.deploy.v1.JobRun.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The `JobRun` has an unspecified state.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The `JobRun` is in progress.
     * </pre>
     *
     * <code>IN_PROGRESS = 1;</code>
     */
    IN_PROGRESS(1),
    /**
     *
     *
     * <pre>
     * The `JobRun` has succeeded.
     * </pre>
     *
     * <code>SUCCEEDED = 2;</code>
     */
    SUCCEEDED(2),
    /**
     *
     *
     * <pre>
     * The `JobRun` has failed.
     * </pre>
     *
     * <code>FAILED = 3;</code>
     */
    FAILED(3),
    /**
     *
     *
     * <pre>
     * The `JobRun` is terminating.
     * </pre>
     *
     * <code>TERMINATING = 4;</code>
     */
    TERMINATING(4),
    /**
     *
     *
     * <pre>
     * The `JobRun` was terminated.
     * </pre>
     *
     * <code>TERMINATED = 5;</code>
     */
    TERMINATED(5),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The `JobRun` has an unspecified state.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The `JobRun` is in progress.
     * </pre>
     *
     * <code>IN_PROGRESS = 1;</code>
     */
    public static final int IN_PROGRESS_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The `JobRun` has succeeded.
     * </pre>
     *
     * <code>SUCCEEDED = 2;</code>
     */
    public static final int SUCCEEDED_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The `JobRun` has failed.
     * </pre>
     *
     * <code>FAILED = 3;</code>
     */
    public static final int FAILED_VALUE = 3;
    /**
     *
     *
     * <pre>
     * The `JobRun` is terminating.
     * </pre>
     *
     * <code>TERMINATING = 4;</code>
     */
    public static final int TERMINATING_VALUE = 4;
    /**
     *
     *
     * <pre>
     * The `JobRun` was terminated.
     * </pre>
     *
     * <code>TERMINATED = 5;</code>
     */
    public static final int TERMINATED_VALUE = 5;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return IN_PROGRESS;
        case 2:
          return SUCCEEDED;
        case 3:
          return FAILED;
        case 4:
          return TERMINATING;
        case 5:
          return TERMINATED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.deploy.v1.JobRun.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.deploy.v1.JobRun.State)
  }

  private int bitField0_;
  private int jobRunCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object jobRun_;

  public enum JobRunCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    DEPLOY_JOB_RUN(9),
    VERIFY_JOB_RUN(10),
    PREDEPLOY_JOB_RUN(14),
    POSTDEPLOY_JOB_RUN(15),
    CREATE_CHILD_ROLLOUT_JOB_RUN(12),
    ADVANCE_CHILD_ROLLOUT_JOB_RUN(13),
    JOBRUN_NOT_SET(0);
    private final int value;

    private JobRunCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static JobRunCase valueOf(int value) {
      return forNumber(value);
    }

    public static JobRunCase forNumber(int value) {
      switch (value) {
        case 9:
          return DEPLOY_JOB_RUN;
        case 10:
          return VERIFY_JOB_RUN;
        case 14:
          return PREDEPLOY_JOB_RUN;
        case 15:
          return POSTDEPLOY_JOB_RUN;
        case 12:
          return CREATE_CHILD_ROLLOUT_JOB_RUN;
        case 13:
          return ADVANCE_CHILD_ROLLOUT_JOB_RUN;
        case 0:
          return JOBRUN_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public JobRunCase getJobRunCase() {
    return JobRunCase.forNumber(jobRunCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Optional. Name of the `JobRun`. Format is
   * `projects/{project}/locations/{location}/deliveryPipelines/{deliveryPipeline}/releases/{releases}/rollouts/{rollouts}/jobRuns/{uuid}`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Name of the `JobRun`. Format is
   * `projects/{project}/locations/{location}/deliveryPipelines/{deliveryPipeline}/releases/{releases}/rollouts/{rollouts}/jobRuns/{uuid}`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int UID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object uid_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Unique identifier of the `JobRun`.
   * </pre>
   *
   * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The uid.
   */
  @java.lang.Override
  public java.lang.String getUid() {
    java.lang.Object ref = uid_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      uid_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Unique identifier of the `JobRun`.
   * </pre>
   *
   * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for uid.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUidBytes() {
    java.lang.Object ref = uid_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      uid_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PHASE_ID_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object phaseId_ = "";
  /**
   *
   *
   * <pre>
   * Output only. ID of the `Rollout` phase this `JobRun` belongs in.
   * </pre>
   *
   * <code>string phase_id = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The phaseId.
   */
  @java.lang.Override
  public java.lang.String getPhaseId() {
    java.lang.Object ref = phaseId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      phaseId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. ID of the `Rollout` phase this `JobRun` belongs in.
   * </pre>
   *
   * <code>string phase_id = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for phaseId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPhaseIdBytes() {
    java.lang.Object ref = phaseId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      phaseId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int JOB_ID_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object jobId_ = "";
  /**
   *
   *
   * <pre>
   * Output only. ID of the `Rollout` job this `JobRun` corresponds to.
   * </pre>
   *
   * <code>string job_id = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The jobId.
   */
  @java.lang.Override
  public java.lang.String getJobId() {
    java.lang.Object ref = jobId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      jobId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. ID of the `Rollout` job this `JobRun` corresponds to.
   * </pre>
   *
   * <code>string job_id = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for jobId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getJobIdBytes() {
    java.lang.Object ref = jobId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      jobId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Time at which the `JobRun` was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Time at which the `JobRun` was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time at which the `JobRun` was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int START_TIME_FIELD_NUMBER = 6;
  private com.google.protobuf.Timestamp startTime_;
  /**
   *
   *
   * <pre>
   * Output only. Time at which the `JobRun` was started.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the startTime field is set.
   */
  @java.lang.Override
  public boolean hasStartTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Time at which the `JobRun` was started.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The startTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getStartTime() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time at which the `JobRun` was started.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }

  public static final int END_TIME_FIELD_NUMBER = 7;
  private com.google.protobuf.Timestamp endTime_;
  /**
   *
   *
   * <pre>
   * Output only. Time at which the `JobRun` ended.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the endTime field is set.
   */
  @java.lang.Override
  public boolean hasEndTime() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Time at which the `JobRun` ended.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The endTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getEndTime() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time at which the `JobRun` ended.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }

  public static final int STATE_FIELD_NUMBER = 8;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The current state of the `JobRun`.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.JobRun.State state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The current state of the `JobRun`.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.JobRun.State state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.JobRun.State getState() {
    com.google.cloud.deploy.v1.JobRun.State result =
        com.google.cloud.deploy.v1.JobRun.State.forNumber(state_);
    return result == null ? com.google.cloud.deploy.v1.JobRun.State.UNRECOGNIZED : result;
  }

  public static final int DEPLOY_JOB_RUN_FIELD_NUMBER = 9;
  /**
   *
   *
   * <pre>
   * Output only. Information specific to a deploy `JobRun`.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.DeployJobRun deploy_job_run = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the deployJobRun field is set.
   */
  @java.lang.Override
  public boolean hasDeployJobRun() {
    return jobRunCase_ == 9;
  }
  /**
   *
   *
   * <pre>
   * Output only. Information specific to a deploy `JobRun`.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.DeployJobRun deploy_job_run = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The deployJobRun.
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.DeployJobRun getDeployJobRun() {
    if (jobRunCase_ == 9) {
      return (com.google.cloud.deploy.v1.DeployJobRun) jobRun_;
    }
    return com.google.cloud.deploy.v1.DeployJobRun.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Output only. Information specific to a deploy `JobRun`.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.DeployJobRun deploy_job_run = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.DeployJobRunOrBuilder getDeployJobRunOrBuilder() {
    if (jobRunCase_ == 9) {
      return (com.google.cloud.deploy.v1.DeployJobRun) jobRun_;
    }
    return com.google.cloud.deploy.v1.DeployJobRun.getDefaultInstance();
  }

  public static final int VERIFY_JOB_RUN_FIELD_NUMBER = 10;
  /**
   *
   *
   * <pre>
   * Output only. Information specific to a verify `JobRun`.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.VerifyJobRun verify_job_run = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the verifyJobRun field is set.
   */
  @java.lang.Override
  public boolean hasVerifyJobRun() {
    return jobRunCase_ == 10;
  }
  /**
   *
   *
   * <pre>
   * Output only. Information specific to a verify `JobRun`.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.VerifyJobRun verify_job_run = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The verifyJobRun.
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.VerifyJobRun getVerifyJobRun() {
    if (jobRunCase_ == 10) {
      return (com.google.cloud.deploy.v1.VerifyJobRun) jobRun_;
    }
    return com.google.cloud.deploy.v1.VerifyJobRun.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Output only. Information specific to a verify `JobRun`.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.VerifyJobRun verify_job_run = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.VerifyJobRunOrBuilder getVerifyJobRunOrBuilder() {
    if (jobRunCase_ == 10) {
      return (com.google.cloud.deploy.v1.VerifyJobRun) jobRun_;
    }
    return com.google.cloud.deploy.v1.VerifyJobRun.getDefaultInstance();
  }

  public static final int PREDEPLOY_JOB_RUN_FIELD_NUMBER = 14;
  /**
   *
   *
   * <pre>
   * Output only. Information specific to a predeploy `JobRun`.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.PredeployJobRun predeploy_job_run = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the predeployJobRun field is set.
   */
  @java.lang.Override
  public boolean hasPredeployJobRun() {
    return jobRunCase_ == 14;
  }
  /**
   *
   *
   * <pre>
   * Output only. Information specific to a predeploy `JobRun`.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.PredeployJobRun predeploy_job_run = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The predeployJobRun.
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.PredeployJobRun getPredeployJobRun() {
    if (jobRunCase_ == 14) {
      return (com.google.cloud.deploy.v1.PredeployJobRun) jobRun_;
    }
    return com.google.cloud.deploy.v1.PredeployJobRun.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Output only. Information specific to a predeploy `JobRun`.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.PredeployJobRun predeploy_job_run = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.PredeployJobRunOrBuilder getPredeployJobRunOrBuilder() {
    if (jobRunCase_ == 14) {
      return (com.google.cloud.deploy.v1.PredeployJobRun) jobRun_;
    }
    return com.google.cloud.deploy.v1.PredeployJobRun.getDefaultInstance();
  }

  public static final int POSTDEPLOY_JOB_RUN_FIELD_NUMBER = 15;
  /**
   *
   *
   * <pre>
   * Output only. Information specific to a postdeploy `JobRun`.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.PostdeployJobRun postdeploy_job_run = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the postdeployJobRun field is set.
   */
  @java.lang.Override
  public boolean hasPostdeployJobRun() {
    return jobRunCase_ == 15;
  }
  /**
   *
   *
   * <pre>
   * Output only. Information specific to a postdeploy `JobRun`.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.PostdeployJobRun postdeploy_job_run = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The postdeployJobRun.
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.PostdeployJobRun getPostdeployJobRun() {
    if (jobRunCase_ == 15) {
      return (com.google.cloud.deploy.v1.PostdeployJobRun) jobRun_;
    }
    return com.google.cloud.deploy.v1.PostdeployJobRun.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Output only. Information specific to a postdeploy `JobRun`.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.PostdeployJobRun postdeploy_job_run = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.PostdeployJobRunOrBuilder getPostdeployJobRunOrBuilder() {
    if (jobRunCase_ == 15) {
      return (com.google.cloud.deploy.v1.PostdeployJobRun) jobRun_;
    }
    return com.google.cloud.deploy.v1.PostdeployJobRun.getDefaultInstance();
  }

  public static final int CREATE_CHILD_ROLLOUT_JOB_RUN_FIELD_NUMBER = 12;
  /**
   *
   *
   * <pre>
   * Output only. Information specific to a createChildRollout `JobRun`.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.CreateChildRolloutJobRun create_child_rollout_job_run = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createChildRolloutJobRun field is set.
   */
  @java.lang.Override
  public boolean hasCreateChildRolloutJobRun() {
    return jobRunCase_ == 12;
  }
  /**
   *
   *
   * <pre>
   * Output only. Information specific to a createChildRollout `JobRun`.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.CreateChildRolloutJobRun create_child_rollout_job_run = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createChildRolloutJobRun.
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.CreateChildRolloutJobRun getCreateChildRolloutJobRun() {
    if (jobRunCase_ == 12) {
      return (com.google.cloud.deploy.v1.CreateChildRolloutJobRun) jobRun_;
    }
    return com.google.cloud.deploy.v1.CreateChildRolloutJobRun.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Output only. Information specific to a createChildRollout `JobRun`.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.CreateChildRolloutJobRun create_child_rollout_job_run = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.CreateChildRolloutJobRunOrBuilder
      getCreateChildRolloutJobRunOrBuilder() {
    if (jobRunCase_ == 12) {
      return (com.google.cloud.deploy.v1.CreateChildRolloutJobRun) jobRun_;
    }
    return com.google.cloud.deploy.v1.CreateChildRolloutJobRun.getDefaultInstance();
  }

  public static final int ADVANCE_CHILD_ROLLOUT_JOB_RUN_FIELD_NUMBER = 13;
  /**
   *
   *
   * <pre>
   * Output only. Information specific to an advanceChildRollout `JobRun`
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.AdvanceChildRolloutJobRun advance_child_rollout_job_run = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the advanceChildRolloutJobRun field is set.
   */
  @java.lang.Override
  public boolean hasAdvanceChildRolloutJobRun() {
    return jobRunCase_ == 13;
  }
  /**
   *
   *
   * <pre>
   * Output only. Information specific to an advanceChildRollout `JobRun`
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.AdvanceChildRolloutJobRun advance_child_rollout_job_run = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The advanceChildRolloutJobRun.
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.AdvanceChildRolloutJobRun getAdvanceChildRolloutJobRun() {
    if (jobRunCase_ == 13) {
      return (com.google.cloud.deploy.v1.AdvanceChildRolloutJobRun) jobRun_;
    }
    return com.google.cloud.deploy.v1.AdvanceChildRolloutJobRun.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Output only. Information specific to an advanceChildRollout `JobRun`
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.AdvanceChildRolloutJobRun advance_child_rollout_job_run = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.AdvanceChildRolloutJobRunOrBuilder
      getAdvanceChildRolloutJobRunOrBuilder() {
    if (jobRunCase_ == 13) {
      return (com.google.cloud.deploy.v1.AdvanceChildRolloutJobRun) jobRun_;
    }
    return com.google.cloud.deploy.v1.AdvanceChildRolloutJobRun.getDefaultInstance();
  }

  public static final int ETAG_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private volatile java.lang.Object etag_ = "";
  /**
   *
   *
   * <pre>
   * Output only. This checksum is computed by the server based on the value of
   * other fields, and may be sent on update and delete requests to ensure the
   * client has an up-to-date value before proceeding.
   * </pre>
   *
   * <code>string etag = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The etag.
   */
  @java.lang.Override
  public java.lang.String getEtag() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      etag_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. This checksum is computed by the server based on the value of
   * other fields, and may be sent on update and delete requests to ensure the
   * client has an up-to-date value before proceeding.
   * </pre>
   *
   * <code>string etag = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for etag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEtagBytes() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      etag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uid_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, uid_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(phaseId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, phaseId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(jobId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, jobId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(5, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(6, getStartTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(7, getEndTime());
    }
    if (state_ != com.google.cloud.deploy.v1.JobRun.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(8, state_);
    }
    if (jobRunCase_ == 9) {
      output.writeMessage(9, (com.google.cloud.deploy.v1.DeployJobRun) jobRun_);
    }
    if (jobRunCase_ == 10) {
      output.writeMessage(10, (com.google.cloud.deploy.v1.VerifyJobRun) jobRun_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, etag_);
    }
    if (jobRunCase_ == 12) {
      output.writeMessage(12, (com.google.cloud.deploy.v1.CreateChildRolloutJobRun) jobRun_);
    }
    if (jobRunCase_ == 13) {
      output.writeMessage(13, (com.google.cloud.deploy.v1.AdvanceChildRolloutJobRun) jobRun_);
    }
    if (jobRunCase_ == 14) {
      output.writeMessage(14, (com.google.cloud.deploy.v1.PredeployJobRun) jobRun_);
    }
    if (jobRunCase_ == 15) {
      output.writeMessage(15, (com.google.cloud.deploy.v1.PostdeployJobRun) jobRun_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uid_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, uid_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(phaseId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, phaseId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(jobId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, jobId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getStartTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getEndTime());
    }
    if (state_ != com.google.cloud.deploy.v1.JobRun.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(8, state_);
    }
    if (jobRunCase_ == 9) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              9, (com.google.cloud.deploy.v1.DeployJobRun) jobRun_);
    }
    if (jobRunCase_ == 10) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              10, (com.google.cloud.deploy.v1.VerifyJobRun) jobRun_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, etag_);
    }
    if (jobRunCase_ == 12) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              12, (com.google.cloud.deploy.v1.CreateChildRolloutJobRun) jobRun_);
    }
    if (jobRunCase_ == 13) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              13, (com.google.cloud.deploy.v1.AdvanceChildRolloutJobRun) jobRun_);
    }
    if (jobRunCase_ == 14) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              14, (com.google.cloud.deploy.v1.PredeployJobRun) jobRun_);
    }
    if (jobRunCase_ == 15) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              15, (com.google.cloud.deploy.v1.PostdeployJobRun) jobRun_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.deploy.v1.JobRun)) {
      return super.equals(obj);
    }
    com.google.cloud.deploy.v1.JobRun other = (com.google.cloud.deploy.v1.JobRun) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getUid().equals(other.getUid())) return false;
    if (!getPhaseId().equals(other.getPhaseId())) return false;
    if (!getJobId().equals(other.getJobId())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasStartTime() != other.hasStartTime()) return false;
    if (hasStartTime()) {
      if (!getStartTime().equals(other.getStartTime())) return false;
    }
    if (hasEndTime() != other.hasEndTime()) return false;
    if (hasEndTime()) {
      if (!getEndTime().equals(other.getEndTime())) return false;
    }
    if (state_ != other.state_) return false;
    if (!getEtag().equals(other.getEtag())) return false;
    if (!getJobRunCase().equals(other.getJobRunCase())) return false;
    switch (jobRunCase_) {
      case 9:
        if (!getDeployJobRun().equals(other.getDeployJobRun())) return false;
        break;
      case 10:
        if (!getVerifyJobRun().equals(other.getVerifyJobRun())) return false;
        break;
      case 14:
        if (!getPredeployJobRun().equals(other.getPredeployJobRun())) return false;
        break;
      case 15:
        if (!getPostdeployJobRun().equals(other.getPostdeployJobRun())) return false;
        break;
      case 12:
        if (!getCreateChildRolloutJobRun().equals(other.getCreateChildRolloutJobRun()))
          return false;
        break;
      case 13:
        if (!getAdvanceChildRolloutJobRun().equals(other.getAdvanceChildRolloutJobRun()))
          return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + UID_FIELD_NUMBER;
    hash = (53 * hash) + getUid().hashCode();
    hash = (37 * hash) + PHASE_ID_FIELD_NUMBER;
    hash = (53 * hash) + getPhaseId().hashCode();
    hash = (37 * hash) + JOB_ID_FIELD_NUMBER;
    hash = (53 * hash) + getJobId().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasStartTime()) {
      hash = (37 * hash) + START_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getStartTime().hashCode();
    }
    if (hasEndTime()) {
      hash = (37 * hash) + END_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getEndTime().hashCode();
    }
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (37 * hash) + ETAG_FIELD_NUMBER;
    hash = (53 * hash) + getEtag().hashCode();
    switch (jobRunCase_) {
      case 9:
        hash = (37 * hash) + DEPLOY_JOB_RUN_FIELD_NUMBER;
        hash = (53 * hash) + getDeployJobRun().hashCode();
        break;
      case 10:
        hash = (37 * hash) + VERIFY_JOB_RUN_FIELD_NUMBER;
        hash = (53 * hash) + getVerifyJobRun().hashCode();
        break;
      case 14:
        hash = (37 * hash) + PREDEPLOY_JOB_RUN_FIELD_NUMBER;
        hash = (53 * hash) + getPredeployJobRun().hashCode();
        break;
      case 15:
        hash = (37 * hash) + POSTDEPLOY_JOB_RUN_FIELD_NUMBER;
        hash = (53 * hash) + getPostdeployJobRun().hashCode();
        break;
      case 12:
        hash = (37 * hash) + CREATE_CHILD_ROLLOUT_JOB_RUN_FIELD_NUMBER;
        hash = (53 * hash) + getCreateChildRolloutJobRun().hashCode();
        break;
      case 13:
        hash = (37 * hash) + ADVANCE_CHILD_ROLLOUT_JOB_RUN_FIELD_NUMBER;
        hash = (53 * hash) + getAdvanceChildRolloutJobRun().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.deploy.v1.JobRun parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.JobRun parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.JobRun parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.JobRun parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.JobRun parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.JobRun parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.JobRun parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.JobRun parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.JobRun parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.JobRun parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.JobRun parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.JobRun parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.deploy.v1.JobRun prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A `JobRun` resource in the Cloud Deploy API.
   *
   * A `JobRun` contains information of a single `Rollout` job evaluation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.deploy.v1.JobRun}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.deploy.v1.JobRun)
      com.google.cloud.deploy.v1.JobRunOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_JobRun_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_JobRun_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.deploy.v1.JobRun.class,
              com.google.cloud.deploy.v1.JobRun.Builder.class);
    }

    // Construct using com.google.cloud.deploy.v1.JobRun.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreateTimeFieldBuilder();
        getStartTimeFieldBuilder();
        getEndTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      uid_ = "";
      phaseId_ = "";
      jobId_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      state_ = 0;
      if (deployJobRunBuilder_ != null) {
        deployJobRunBuilder_.clear();
      }
      if (verifyJobRunBuilder_ != null) {
        verifyJobRunBuilder_.clear();
      }
      if (predeployJobRunBuilder_ != null) {
        predeployJobRunBuilder_.clear();
      }
      if (postdeployJobRunBuilder_ != null) {
        postdeployJobRunBuilder_.clear();
      }
      if (createChildRolloutJobRunBuilder_ != null) {
        createChildRolloutJobRunBuilder_.clear();
      }
      if (advanceChildRolloutJobRunBuilder_ != null) {
        advanceChildRolloutJobRunBuilder_.clear();
      }
      etag_ = "";
      jobRunCase_ = 0;
      jobRun_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_JobRun_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.JobRun getDefaultInstanceForType() {
      return com.google.cloud.deploy.v1.JobRun.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.JobRun build() {
      com.google.cloud.deploy.v1.JobRun result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.JobRun buildPartial() {
      com.google.cloud.deploy.v1.JobRun result = new com.google.cloud.deploy.v1.JobRun(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.deploy.v1.JobRun result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.uid_ = uid_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.phaseId_ = phaseId_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.jobId_ = jobId_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.startTime_ = startTimeBuilder_ == null ? startTime_ : startTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.endTime_ = endTimeBuilder_ == null ? endTime_ : endTimeBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.etag_ = etag_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.deploy.v1.JobRun result) {
      result.jobRunCase_ = jobRunCase_;
      result.jobRun_ = this.jobRun_;
      if (jobRunCase_ == 9 && deployJobRunBuilder_ != null) {
        result.jobRun_ = deployJobRunBuilder_.build();
      }
      if (jobRunCase_ == 10 && verifyJobRunBuilder_ != null) {
        result.jobRun_ = verifyJobRunBuilder_.build();
      }
      if (jobRunCase_ == 14 && predeployJobRunBuilder_ != null) {
        result.jobRun_ = predeployJobRunBuilder_.build();
      }
      if (jobRunCase_ == 15 && postdeployJobRunBuilder_ != null) {
        result.jobRun_ = postdeployJobRunBuilder_.build();
      }
      if (jobRunCase_ == 12 && createChildRolloutJobRunBuilder_ != null) {
        result.jobRun_ = createChildRolloutJobRunBuilder_.build();
      }
      if (jobRunCase_ == 13 && advanceChildRolloutJobRunBuilder_ != null) {
        result.jobRun_ = advanceChildRolloutJobRunBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.deploy.v1.JobRun) {
        return mergeFrom((com.google.cloud.deploy.v1.JobRun) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.deploy.v1.JobRun other) {
      if (other == com.google.cloud.deploy.v1.JobRun.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getUid().isEmpty()) {
        uid_ = other.uid_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getPhaseId().isEmpty()) {
        phaseId_ = other.phaseId_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getJobId().isEmpty()) {
        jobId_ = other.jobId_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasStartTime()) {
        mergeStartTime(other.getStartTime());
      }
      if (other.hasEndTime()) {
        mergeEndTime(other.getEndTime());
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (!other.getEtag().isEmpty()) {
        etag_ = other.etag_;
        bitField0_ |= 0x00004000;
        onChanged();
      }
      switch (other.getJobRunCase()) {
        case DEPLOY_JOB_RUN:
          {
            mergeDeployJobRun(other.getDeployJobRun());
            break;
          }
        case VERIFY_JOB_RUN:
          {
            mergeVerifyJobRun(other.getVerifyJobRun());
            break;
          }
        case PREDEPLOY_JOB_RUN:
          {
            mergePredeployJobRun(other.getPredeployJobRun());
            break;
          }
        case POSTDEPLOY_JOB_RUN:
          {
            mergePostdeployJobRun(other.getPostdeployJobRun());
            break;
          }
        case CREATE_CHILD_ROLLOUT_JOB_RUN:
          {
            mergeCreateChildRolloutJobRun(other.getCreateChildRolloutJobRun());
            break;
          }
        case ADVANCE_CHILD_ROLLOUT_JOB_RUN:
          {
            mergeAdvanceChildRolloutJobRun(other.getAdvanceChildRolloutJobRun());
            break;
          }
        case JOBRUN_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                uid_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                phaseId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                jobId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getStartTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getEndTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 64:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000080;
                break;
              } // case 64
            case 74:
              {
                input.readMessage(getDeployJobRunFieldBuilder().getBuilder(), extensionRegistry);
                jobRunCase_ = 9;
                break;
              } // case 74
            case 82:
              {
                input.readMessage(getVerifyJobRunFieldBuilder().getBuilder(), extensionRegistry);
                jobRunCase_ = 10;
                break;
              } // case 82
            case 90:
              {
                etag_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00004000;
                break;
              } // case 90
            case 98:
              {
                input.readMessage(
                    getCreateChildRolloutJobRunFieldBuilder().getBuilder(), extensionRegistry);
                jobRunCase_ = 12;
                break;
              } // case 98
            case 106:
              {
                input.readMessage(
                    getAdvanceChildRolloutJobRunFieldBuilder().getBuilder(), extensionRegistry);
                jobRunCase_ = 13;
                break;
              } // case 106
            case 114:
              {
                input.readMessage(getPredeployJobRunFieldBuilder().getBuilder(), extensionRegistry);
                jobRunCase_ = 14;
                break;
              } // case 114
            case 122:
              {
                input.readMessage(
                    getPostdeployJobRunFieldBuilder().getBuilder(), extensionRegistry);
                jobRunCase_ = 15;
                break;
              } // case 122
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int jobRunCase_ = 0;
    private java.lang.Object jobRun_;

    public JobRunCase getJobRunCase() {
      return JobRunCase.forNumber(jobRunCase_);
    }

    public Builder clearJobRun() {
      jobRunCase_ = 0;
      jobRun_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Name of the `JobRun`. Format is
     * `projects/{project}/locations/{location}/deliveryPipelines/{deliveryPipeline}/releases/{releases}/rollouts/{rollouts}/jobRuns/{uuid}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Name of the `JobRun`. Format is
     * `projects/{project}/locations/{location}/deliveryPipelines/{deliveryPipeline}/releases/{releases}/rollouts/{rollouts}/jobRuns/{uuid}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Name of the `JobRun`. Format is
     * `projects/{project}/locations/{location}/deliveryPipelines/{deliveryPipeline}/releases/{releases}/rollouts/{rollouts}/jobRuns/{uuid}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Name of the `JobRun`. Format is
     * `projects/{project}/locations/{location}/deliveryPipelines/{deliveryPipeline}/releases/{releases}/rollouts/{rollouts}/jobRuns/{uuid}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Name of the `JobRun`. Format is
     * `projects/{project}/locations/{location}/deliveryPipelines/{deliveryPipeline}/releases/{releases}/rollouts/{rollouts}/jobRuns/{uuid}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object uid_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier of the `JobRun`.
     * </pre>
     *
     * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The uid.
     */
    public java.lang.String getUid() {
      java.lang.Object ref = uid_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uid_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier of the `JobRun`.
     * </pre>
     *
     * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for uid.
     */
    public com.google.protobuf.ByteString getUidBytes() {
      java.lang.Object ref = uid_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        uid_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier of the `JobRun`.
     * </pre>
     *
     * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The uid to set.
     * @return This builder for chaining.
     */
    public Builder setUid(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      uid_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier of the `JobRun`.
     * </pre>
     *
     * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUid() {
      uid_ = getDefaultInstance().getUid();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier of the `JobRun`.
     * </pre>
     *
     * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for uid to set.
     * @return This builder for chaining.
     */
    public Builder setUidBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      uid_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object phaseId_ = "";
    /**
     *
     *
     * <pre>
     * Output only. ID of the `Rollout` phase this `JobRun` belongs in.
     * </pre>
     *
     * <code>string phase_id = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The phaseId.
     */
    public java.lang.String getPhaseId() {
      java.lang.Object ref = phaseId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        phaseId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. ID of the `Rollout` phase this `JobRun` belongs in.
     * </pre>
     *
     * <code>string phase_id = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for phaseId.
     */
    public com.google.protobuf.ByteString getPhaseIdBytes() {
      java.lang.Object ref = phaseId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        phaseId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. ID of the `Rollout` phase this `JobRun` belongs in.
     * </pre>
     *
     * <code>string phase_id = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The phaseId to set.
     * @return This builder for chaining.
     */
    public Builder setPhaseId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      phaseId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. ID of the `Rollout` phase this `JobRun` belongs in.
     * </pre>
     *
     * <code>string phase_id = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPhaseId() {
      phaseId_ = getDefaultInstance().getPhaseId();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. ID of the `Rollout` phase this `JobRun` belongs in.
     * </pre>
     *
     * <code>string phase_id = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for phaseId to set.
     * @return This builder for chaining.
     */
    public Builder setPhaseIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      phaseId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object jobId_ = "";
    /**
     *
     *
     * <pre>
     * Output only. ID of the `Rollout` job this `JobRun` corresponds to.
     * </pre>
     *
     * <code>string job_id = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The jobId.
     */
    public java.lang.String getJobId() {
      java.lang.Object ref = jobId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        jobId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. ID of the `Rollout` job this `JobRun` corresponds to.
     * </pre>
     *
     * <code>string job_id = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for jobId.
     */
    public com.google.protobuf.ByteString getJobIdBytes() {
      java.lang.Object ref = jobId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        jobId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. ID of the `Rollout` job this `JobRun` corresponds to.
     * </pre>
     *
     * <code>string job_id = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The jobId to set.
     * @return This builder for chaining.
     */
    public Builder setJobId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      jobId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. ID of the `Rollout` job this `JobRun` corresponds to.
     * </pre>
     *
     * <code>string job_id = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearJobId() {
      jobId_ = getDefaultInstance().getJobId();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. ID of the `Rollout` job this `JobRun` corresponds to.
     * </pre>
     *
     * <code>string job_id = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for jobId to set.
     * @return This builder for chaining.
     */
    public Builder setJobIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      jobId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `JobRun` was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `JobRun` was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `JobRun` was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `JobRun` was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `JobRun` was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `JobRun` was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000010);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `JobRun` was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `JobRun` was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `JobRun` was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp startTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        startTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `JobRun` was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the startTime field is set.
     */
    public boolean hasStartTime() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `JobRun` was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The startTime.
     */
    public com.google.protobuf.Timestamp getStartTime() {
      if (startTimeBuilder_ == null) {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      } else {
        return startTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `JobRun` was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        startTime_ = value;
      } else {
        startTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `JobRun` was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (startTimeBuilder_ == null) {
        startTime_ = builderForValue.build();
      } else {
        startTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `JobRun` was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && startTime_ != null
            && startTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getStartTimeBuilder().mergeFrom(value);
        } else {
          startTime_ = value;
        }
      } else {
        startTimeBuilder_.mergeFrom(value);
      }
      if (startTime_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `JobRun` was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearStartTime() {
      bitField0_ = (bitField0_ & ~0x00000020);
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `JobRun` was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getStartTimeBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getStartTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `JobRun` was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
      if (startTimeBuilder_ != null) {
        return startTimeBuilder_.getMessageOrBuilder();
      } else {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `JobRun` was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getStartTimeFieldBuilder() {
      if (startTimeBuilder_ == null) {
        startTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getStartTime(), getParentForChildren(), isClean());
        startTime_ = null;
      }
      return startTimeBuilder_;
    }

    private com.google.protobuf.Timestamp endTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        endTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `JobRun` ended.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the endTime field is set.
     */
    public boolean hasEndTime() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `JobRun` ended.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The endTime.
     */
    public com.google.protobuf.Timestamp getEndTime() {
      if (endTimeBuilder_ == null) {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      } else {
        return endTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `JobRun` ended.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        endTime_ = value;
      } else {
        endTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `JobRun` ended.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (endTimeBuilder_ == null) {
        endTime_ = builderForValue.build();
      } else {
        endTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `JobRun` ended.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && endTime_ != null
            && endTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getEndTimeBuilder().mergeFrom(value);
        } else {
          endTime_ = value;
        }
      } else {
        endTimeBuilder_.mergeFrom(value);
      }
      if (endTime_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `JobRun` ended.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearEndTime() {
      bitField0_ = (bitField0_ & ~0x00000040);
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `JobRun` ended.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getEndTimeBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getEndTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `JobRun` ended.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
      if (endTimeBuilder_ != null) {
        return endTimeBuilder_.getMessageOrBuilder();
      } else {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `JobRun` ended.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getEndTimeFieldBuilder() {
      if (endTimeBuilder_ == null) {
        endTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getEndTime(), getParentForChildren(), isClean());
        endTime_ = null;
      }
      return endTimeBuilder_;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The current state of the `JobRun`.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.JobRun.State state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of the `JobRun`.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.JobRun.State state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of the `JobRun`.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.JobRun.State state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.JobRun.State getState() {
      com.google.cloud.deploy.v1.JobRun.State result =
          com.google.cloud.deploy.v1.JobRun.State.forNumber(state_);
      return result == null ? com.google.cloud.deploy.v1.JobRun.State.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of the `JobRun`.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.JobRun.State state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.deploy.v1.JobRun.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000080;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of the `JobRun`.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.JobRun.State state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000080);
      state_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.DeployJobRun,
            com.google.cloud.deploy.v1.DeployJobRun.Builder,
            com.google.cloud.deploy.v1.DeployJobRunOrBuilder>
        deployJobRunBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Information specific to a deploy `JobRun`.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.DeployJobRun deploy_job_run = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the deployJobRun field is set.
     */
    @java.lang.Override
    public boolean hasDeployJobRun() {
      return jobRunCase_ == 9;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information specific to a deploy `JobRun`.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.DeployJobRun deploy_job_run = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The deployJobRun.
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.DeployJobRun getDeployJobRun() {
      if (deployJobRunBuilder_ == null) {
        if (jobRunCase_ == 9) {
          return (com.google.cloud.deploy.v1.DeployJobRun) jobRun_;
        }
        return com.google.cloud.deploy.v1.DeployJobRun.getDefaultInstance();
      } else {
        if (jobRunCase_ == 9) {
          return deployJobRunBuilder_.getMessage();
        }
        return com.google.cloud.deploy.v1.DeployJobRun.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Information specific to a deploy `JobRun`.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.DeployJobRun deploy_job_run = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDeployJobRun(com.google.cloud.deploy.v1.DeployJobRun value) {
      if (deployJobRunBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        jobRun_ = value;
        onChanged();
      } else {
        deployJobRunBuilder_.setMessage(value);
      }
      jobRunCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information specific to a deploy `JobRun`.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.DeployJobRun deploy_job_run = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDeployJobRun(
        com.google.cloud.deploy.v1.DeployJobRun.Builder builderForValue) {
      if (deployJobRunBuilder_ == null) {
        jobRun_ = builderForValue.build();
        onChanged();
      } else {
        deployJobRunBuilder_.setMessage(builderForValue.build());
      }
      jobRunCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information specific to a deploy `JobRun`.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.DeployJobRun deploy_job_run = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeDeployJobRun(com.google.cloud.deploy.v1.DeployJobRun value) {
      if (deployJobRunBuilder_ == null) {
        if (jobRunCase_ == 9
            && jobRun_ != com.google.cloud.deploy.v1.DeployJobRun.getDefaultInstance()) {
          jobRun_ =
              com.google.cloud.deploy.v1.DeployJobRun.newBuilder(
                      (com.google.cloud.deploy.v1.DeployJobRun) jobRun_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          jobRun_ = value;
        }
        onChanged();
      } else {
        if (jobRunCase_ == 9) {
          deployJobRunBuilder_.mergeFrom(value);
        } else {
          deployJobRunBuilder_.setMessage(value);
        }
      }
      jobRunCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information specific to a deploy `JobRun`.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.DeployJobRun deploy_job_run = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearDeployJobRun() {
      if (deployJobRunBuilder_ == null) {
        if (jobRunCase_ == 9) {
          jobRunCase_ = 0;
          jobRun_ = null;
          onChanged();
        }
      } else {
        if (jobRunCase_ == 9) {
          jobRunCase_ = 0;
          jobRun_ = null;
        }
        deployJobRunBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information specific to a deploy `JobRun`.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.DeployJobRun deploy_job_run = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.deploy.v1.DeployJobRun.Builder getDeployJobRunBuilder() {
      return getDeployJobRunFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Information specific to a deploy `JobRun`.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.DeployJobRun deploy_job_run = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.DeployJobRunOrBuilder getDeployJobRunOrBuilder() {
      if ((jobRunCase_ == 9) && (deployJobRunBuilder_ != null)) {
        return deployJobRunBuilder_.getMessageOrBuilder();
      } else {
        if (jobRunCase_ == 9) {
          return (com.google.cloud.deploy.v1.DeployJobRun) jobRun_;
        }
        return com.google.cloud.deploy.v1.DeployJobRun.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Information specific to a deploy `JobRun`.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.DeployJobRun deploy_job_run = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.DeployJobRun,
            com.google.cloud.deploy.v1.DeployJobRun.Builder,
            com.google.cloud.deploy.v1.DeployJobRunOrBuilder>
        getDeployJobRunFieldBuilder() {
      if (deployJobRunBuilder_ == null) {
        if (!(jobRunCase_ == 9)) {
          jobRun_ = com.google.cloud.deploy.v1.DeployJobRun.getDefaultInstance();
        }
        deployJobRunBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.deploy.v1.DeployJobRun,
                com.google.cloud.deploy.v1.DeployJobRun.Builder,
                com.google.cloud.deploy.v1.DeployJobRunOrBuilder>(
                (com.google.cloud.deploy.v1.DeployJobRun) jobRun_,
                getParentForChildren(),
                isClean());
        jobRun_ = null;
      }
      jobRunCase_ = 9;
      onChanged();
      return deployJobRunBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.VerifyJobRun,
            com.google.cloud.deploy.v1.VerifyJobRun.Builder,
            com.google.cloud.deploy.v1.VerifyJobRunOrBuilder>
        verifyJobRunBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Information specific to a verify `JobRun`.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.VerifyJobRun verify_job_run = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the verifyJobRun field is set.
     */
    @java.lang.Override
    public boolean hasVerifyJobRun() {
      return jobRunCase_ == 10;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information specific to a verify `JobRun`.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.VerifyJobRun verify_job_run = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The verifyJobRun.
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.VerifyJobRun getVerifyJobRun() {
      if (verifyJobRunBuilder_ == null) {
        if (jobRunCase_ == 10) {
          return (com.google.cloud.deploy.v1.VerifyJobRun) jobRun_;
        }
        return com.google.cloud.deploy.v1.VerifyJobRun.getDefaultInstance();
      } else {
        if (jobRunCase_ == 10) {
          return verifyJobRunBuilder_.getMessage();
        }
        return com.google.cloud.deploy.v1.VerifyJobRun.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Information specific to a verify `JobRun`.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.VerifyJobRun verify_job_run = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setVerifyJobRun(com.google.cloud.deploy.v1.VerifyJobRun value) {
      if (verifyJobRunBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        jobRun_ = value;
        onChanged();
      } else {
        verifyJobRunBuilder_.setMessage(value);
      }
      jobRunCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information specific to a verify `JobRun`.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.VerifyJobRun verify_job_run = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setVerifyJobRun(
        com.google.cloud.deploy.v1.VerifyJobRun.Builder builderForValue) {
      if (verifyJobRunBuilder_ == null) {
        jobRun_ = builderForValue.build();
        onChanged();
      } else {
        verifyJobRunBuilder_.setMessage(builderForValue.build());
      }
      jobRunCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information specific to a verify `JobRun`.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.VerifyJobRun verify_job_run = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeVerifyJobRun(com.google.cloud.deploy.v1.VerifyJobRun value) {
      if (verifyJobRunBuilder_ == null) {
        if (jobRunCase_ == 10
            && jobRun_ != com.google.cloud.deploy.v1.VerifyJobRun.getDefaultInstance()) {
          jobRun_ =
              com.google.cloud.deploy.v1.VerifyJobRun.newBuilder(
                      (com.google.cloud.deploy.v1.VerifyJobRun) jobRun_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          jobRun_ = value;
        }
        onChanged();
      } else {
        if (jobRunCase_ == 10) {
          verifyJobRunBuilder_.mergeFrom(value);
        } else {
          verifyJobRunBuilder_.setMessage(value);
        }
      }
      jobRunCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information specific to a verify `JobRun`.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.VerifyJobRun verify_job_run = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearVerifyJobRun() {
      if (verifyJobRunBuilder_ == null) {
        if (jobRunCase_ == 10) {
          jobRunCase_ = 0;
          jobRun_ = null;
          onChanged();
        }
      } else {
        if (jobRunCase_ == 10) {
          jobRunCase_ = 0;
          jobRun_ = null;
        }
        verifyJobRunBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information specific to a verify `JobRun`.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.VerifyJobRun verify_job_run = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.deploy.v1.VerifyJobRun.Builder getVerifyJobRunBuilder() {
      return getVerifyJobRunFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Information specific to a verify `JobRun`.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.VerifyJobRun verify_job_run = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.VerifyJobRunOrBuilder getVerifyJobRunOrBuilder() {
      if ((jobRunCase_ == 10) && (verifyJobRunBuilder_ != null)) {
        return verifyJobRunBuilder_.getMessageOrBuilder();
      } else {
        if (jobRunCase_ == 10) {
          return (com.google.cloud.deploy.v1.VerifyJobRun) jobRun_;
        }
        return com.google.cloud.deploy.v1.VerifyJobRun.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Information specific to a verify `JobRun`.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.VerifyJobRun verify_job_run = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.VerifyJobRun,
            com.google.cloud.deploy.v1.VerifyJobRun.Builder,
            com.google.cloud.deploy.v1.VerifyJobRunOrBuilder>
        getVerifyJobRunFieldBuilder() {
      if (verifyJobRunBuilder_ == null) {
        if (!(jobRunCase_ == 10)) {
          jobRun_ = com.google.cloud.deploy.v1.VerifyJobRun.getDefaultInstance();
        }
        verifyJobRunBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.deploy.v1.VerifyJobRun,
                com.google.cloud.deploy.v1.VerifyJobRun.Builder,
                com.google.cloud.deploy.v1.VerifyJobRunOrBuilder>(
                (com.google.cloud.deploy.v1.VerifyJobRun) jobRun_,
                getParentForChildren(),
                isClean());
        jobRun_ = null;
      }
      jobRunCase_ = 10;
      onChanged();
      return verifyJobRunBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.PredeployJobRun,
            com.google.cloud.deploy.v1.PredeployJobRun.Builder,
            com.google.cloud.deploy.v1.PredeployJobRunOrBuilder>
        predeployJobRunBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Information specific to a predeploy `JobRun`.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.PredeployJobRun predeploy_job_run = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the predeployJobRun field is set.
     */
    @java.lang.Override
    public boolean hasPredeployJobRun() {
      return jobRunCase_ == 14;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information specific to a predeploy `JobRun`.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.PredeployJobRun predeploy_job_run = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The predeployJobRun.
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.PredeployJobRun getPredeployJobRun() {
      if (predeployJobRunBuilder_ == null) {
        if (jobRunCase_ == 14) {
          return (com.google.cloud.deploy.v1.PredeployJobRun) jobRun_;
        }
        return com.google.cloud.deploy.v1.PredeployJobRun.getDefaultInstance();
      } else {
        if (jobRunCase_ == 14) {
          return predeployJobRunBuilder_.getMessage();
        }
        return com.google.cloud.deploy.v1.PredeployJobRun.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Information specific to a predeploy `JobRun`.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.PredeployJobRun predeploy_job_run = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setPredeployJobRun(com.google.cloud.deploy.v1.PredeployJobRun value) {
      if (predeployJobRunBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        jobRun_ = value;
        onChanged();
      } else {
        predeployJobRunBuilder_.setMessage(value);
      }
      jobRunCase_ = 14;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information specific to a predeploy `JobRun`.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.PredeployJobRun predeploy_job_run = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setPredeployJobRun(
        com.google.cloud.deploy.v1.PredeployJobRun.Builder builderForValue) {
      if (predeployJobRunBuilder_ == null) {
        jobRun_ = builderForValue.build();
        onChanged();
      } else {
        predeployJobRunBuilder_.setMessage(builderForValue.build());
      }
      jobRunCase_ = 14;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information specific to a predeploy `JobRun`.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.PredeployJobRun predeploy_job_run = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergePredeployJobRun(com.google.cloud.deploy.v1.PredeployJobRun value) {
      if (predeployJobRunBuilder_ == null) {
        if (jobRunCase_ == 14
            && jobRun_ != com.google.cloud.deploy.v1.PredeployJobRun.getDefaultInstance()) {
          jobRun_ =
              com.google.cloud.deploy.v1.PredeployJobRun.newBuilder(
                      (com.google.cloud.deploy.v1.PredeployJobRun) jobRun_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          jobRun_ = value;
        }
        onChanged();
      } else {
        if (jobRunCase_ == 14) {
          predeployJobRunBuilder_.mergeFrom(value);
        } else {
          predeployJobRunBuilder_.setMessage(value);
        }
      }
      jobRunCase_ = 14;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information specific to a predeploy `JobRun`.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.PredeployJobRun predeploy_job_run = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearPredeployJobRun() {
      if (predeployJobRunBuilder_ == null) {
        if (jobRunCase_ == 14) {
          jobRunCase_ = 0;
          jobRun_ = null;
          onChanged();
        }
      } else {
        if (jobRunCase_ == 14) {
          jobRunCase_ = 0;
          jobRun_ = null;
        }
        predeployJobRunBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information specific to a predeploy `JobRun`.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.PredeployJobRun predeploy_job_run = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.deploy.v1.PredeployJobRun.Builder getPredeployJobRunBuilder() {
      return getPredeployJobRunFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Information specific to a predeploy `JobRun`.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.PredeployJobRun predeploy_job_run = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.PredeployJobRunOrBuilder getPredeployJobRunOrBuilder() {
      if ((jobRunCase_ == 14) && (predeployJobRunBuilder_ != null)) {
        return predeployJobRunBuilder_.getMessageOrBuilder();
      } else {
        if (jobRunCase_ == 14) {
          return (com.google.cloud.deploy.v1.PredeployJobRun) jobRun_;
        }
        return com.google.cloud.deploy.v1.PredeployJobRun.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Information specific to a predeploy `JobRun`.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.PredeployJobRun predeploy_job_run = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.PredeployJobRun,
            com.google.cloud.deploy.v1.PredeployJobRun.Builder,
            com.google.cloud.deploy.v1.PredeployJobRunOrBuilder>
        getPredeployJobRunFieldBuilder() {
      if (predeployJobRunBuilder_ == null) {
        if (!(jobRunCase_ == 14)) {
          jobRun_ = com.google.cloud.deploy.v1.PredeployJobRun.getDefaultInstance();
        }
        predeployJobRunBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.deploy.v1.PredeployJobRun,
                com.google.cloud.deploy.v1.PredeployJobRun.Builder,
                com.google.cloud.deploy.v1.PredeployJobRunOrBuilder>(
                (com.google.cloud.deploy.v1.PredeployJobRun) jobRun_,
                getParentForChildren(),
                isClean());
        jobRun_ = null;
      }
      jobRunCase_ = 14;
      onChanged();
      return predeployJobRunBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.PostdeployJobRun,
            com.google.cloud.deploy.v1.PostdeployJobRun.Builder,
            com.google.cloud.deploy.v1.PostdeployJobRunOrBuilder>
        postdeployJobRunBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Information specific to a postdeploy `JobRun`.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.PostdeployJobRun postdeploy_job_run = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the postdeployJobRun field is set.
     */
    @java.lang.Override
    public boolean hasPostdeployJobRun() {
      return jobRunCase_ == 15;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information specific to a postdeploy `JobRun`.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.PostdeployJobRun postdeploy_job_run = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The postdeployJobRun.
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.PostdeployJobRun getPostdeployJobRun() {
      if (postdeployJobRunBuilder_ == null) {
        if (jobRunCase_ == 15) {
          return (com.google.cloud.deploy.v1.PostdeployJobRun) jobRun_;
        }
        return com.google.cloud.deploy.v1.PostdeployJobRun.getDefaultInstance();
      } else {
        if (jobRunCase_ == 15) {
          return postdeployJobRunBuilder_.getMessage();
        }
        return com.google.cloud.deploy.v1.PostdeployJobRun.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Information specific to a postdeploy `JobRun`.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.PostdeployJobRun postdeploy_job_run = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setPostdeployJobRun(com.google.cloud.deploy.v1.PostdeployJobRun value) {
      if (postdeployJobRunBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        jobRun_ = value;
        onChanged();
      } else {
        postdeployJobRunBuilder_.setMessage(value);
      }
      jobRunCase_ = 15;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information specific to a postdeploy `JobRun`.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.PostdeployJobRun postdeploy_job_run = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setPostdeployJobRun(
        com.google.cloud.deploy.v1.PostdeployJobRun.Builder builderForValue) {
      if (postdeployJobRunBuilder_ == null) {
        jobRun_ = builderForValue.build();
        onChanged();
      } else {
        postdeployJobRunBuilder_.setMessage(builderForValue.build());
      }
      jobRunCase_ = 15;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information specific to a postdeploy `JobRun`.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.PostdeployJobRun postdeploy_job_run = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergePostdeployJobRun(com.google.cloud.deploy.v1.PostdeployJobRun value) {
      if (postdeployJobRunBuilder_ == null) {
        if (jobRunCase_ == 15
            && jobRun_ != com.google.cloud.deploy.v1.PostdeployJobRun.getDefaultInstance()) {
          jobRun_ =
              com.google.cloud.deploy.v1.PostdeployJobRun.newBuilder(
                      (com.google.cloud.deploy.v1.PostdeployJobRun) jobRun_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          jobRun_ = value;
        }
        onChanged();
      } else {
        if (jobRunCase_ == 15) {
          postdeployJobRunBuilder_.mergeFrom(value);
        } else {
          postdeployJobRunBuilder_.setMessage(value);
        }
      }
      jobRunCase_ = 15;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information specific to a postdeploy `JobRun`.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.PostdeployJobRun postdeploy_job_run = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearPostdeployJobRun() {
      if (postdeployJobRunBuilder_ == null) {
        if (jobRunCase_ == 15) {
          jobRunCase_ = 0;
          jobRun_ = null;
          onChanged();
        }
      } else {
        if (jobRunCase_ == 15) {
          jobRunCase_ = 0;
          jobRun_ = null;
        }
        postdeployJobRunBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information specific to a postdeploy `JobRun`.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.PostdeployJobRun postdeploy_job_run = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.deploy.v1.PostdeployJobRun.Builder getPostdeployJobRunBuilder() {
      return getPostdeployJobRunFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Information specific to a postdeploy `JobRun`.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.PostdeployJobRun postdeploy_job_run = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.PostdeployJobRunOrBuilder getPostdeployJobRunOrBuilder() {
      if ((jobRunCase_ == 15) && (postdeployJobRunBuilder_ != null)) {
        return postdeployJobRunBuilder_.getMessageOrBuilder();
      } else {
        if (jobRunCase_ == 15) {
          return (com.google.cloud.deploy.v1.PostdeployJobRun) jobRun_;
        }
        return com.google.cloud.deploy.v1.PostdeployJobRun.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Information specific to a postdeploy `JobRun`.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.PostdeployJobRun postdeploy_job_run = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.PostdeployJobRun,
            com.google.cloud.deploy.v1.PostdeployJobRun.Builder,
            com.google.cloud.deploy.v1.PostdeployJobRunOrBuilder>
        getPostdeployJobRunFieldBuilder() {
      if (postdeployJobRunBuilder_ == null) {
        if (!(jobRunCase_ == 15)) {
          jobRun_ = com.google.cloud.deploy.v1.PostdeployJobRun.getDefaultInstance();
        }
        postdeployJobRunBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.deploy.v1.PostdeployJobRun,
                com.google.cloud.deploy.v1.PostdeployJobRun.Builder,
                com.google.cloud.deploy.v1.PostdeployJobRunOrBuilder>(
                (com.google.cloud.deploy.v1.PostdeployJobRun) jobRun_,
                getParentForChildren(),
                isClean());
        jobRun_ = null;
      }
      jobRunCase_ = 15;
      onChanged();
      return postdeployJobRunBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.CreateChildRolloutJobRun,
            com.google.cloud.deploy.v1.CreateChildRolloutJobRun.Builder,
            com.google.cloud.deploy.v1.CreateChildRolloutJobRunOrBuilder>
        createChildRolloutJobRunBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Information specific to a createChildRollout `JobRun`.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.CreateChildRolloutJobRun create_child_rollout_job_run = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createChildRolloutJobRun field is set.
     */
    @java.lang.Override
    public boolean hasCreateChildRolloutJobRun() {
      return jobRunCase_ == 12;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information specific to a createChildRollout `JobRun`.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.CreateChildRolloutJobRun create_child_rollout_job_run = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createChildRolloutJobRun.
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.CreateChildRolloutJobRun getCreateChildRolloutJobRun() {
      if (createChildRolloutJobRunBuilder_ == null) {
        if (jobRunCase_ == 12) {
          return (com.google.cloud.deploy.v1.CreateChildRolloutJobRun) jobRun_;
        }
        return com.google.cloud.deploy.v1.CreateChildRolloutJobRun.getDefaultInstance();
      } else {
        if (jobRunCase_ == 12) {
          return createChildRolloutJobRunBuilder_.getMessage();
        }
        return com.google.cloud.deploy.v1.CreateChildRolloutJobRun.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Information specific to a createChildRollout `JobRun`.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.CreateChildRolloutJobRun create_child_rollout_job_run = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateChildRolloutJobRun(
        com.google.cloud.deploy.v1.CreateChildRolloutJobRun value) {
      if (createChildRolloutJobRunBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        jobRun_ = value;
        onChanged();
      } else {
        createChildRolloutJobRunBuilder_.setMessage(value);
      }
      jobRunCase_ = 12;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information specific to a createChildRollout `JobRun`.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.CreateChildRolloutJobRun create_child_rollout_job_run = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateChildRolloutJobRun(
        com.google.cloud.deploy.v1.CreateChildRolloutJobRun.Builder builderForValue) {
      if (createChildRolloutJobRunBuilder_ == null) {
        jobRun_ = builderForValue.build();
        onChanged();
      } else {
        createChildRolloutJobRunBuilder_.setMessage(builderForValue.build());
      }
      jobRunCase_ = 12;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information specific to a createChildRollout `JobRun`.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.CreateChildRolloutJobRun create_child_rollout_job_run = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateChildRolloutJobRun(
        com.google.cloud.deploy.v1.CreateChildRolloutJobRun value) {
      if (createChildRolloutJobRunBuilder_ == null) {
        if (jobRunCase_ == 12
            && jobRun_
                != com.google.cloud.deploy.v1.CreateChildRolloutJobRun.getDefaultInstance()) {
          jobRun_ =
              com.google.cloud.deploy.v1.CreateChildRolloutJobRun.newBuilder(
                      (com.google.cloud.deploy.v1.CreateChildRolloutJobRun) jobRun_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          jobRun_ = value;
        }
        onChanged();
      } else {
        if (jobRunCase_ == 12) {
          createChildRolloutJobRunBuilder_.mergeFrom(value);
        } else {
          createChildRolloutJobRunBuilder_.setMessage(value);
        }
      }
      jobRunCase_ = 12;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information specific to a createChildRollout `JobRun`.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.CreateChildRolloutJobRun create_child_rollout_job_run = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateChildRolloutJobRun() {
      if (createChildRolloutJobRunBuilder_ == null) {
        if (jobRunCase_ == 12) {
          jobRunCase_ = 0;
          jobRun_ = null;
          onChanged();
        }
      } else {
        if (jobRunCase_ == 12) {
          jobRunCase_ = 0;
          jobRun_ = null;
        }
        createChildRolloutJobRunBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information specific to a createChildRollout `JobRun`.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.CreateChildRolloutJobRun create_child_rollout_job_run = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.deploy.v1.CreateChildRolloutJobRun.Builder
        getCreateChildRolloutJobRunBuilder() {
      return getCreateChildRolloutJobRunFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Information specific to a createChildRollout `JobRun`.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.CreateChildRolloutJobRun create_child_rollout_job_run = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.CreateChildRolloutJobRunOrBuilder
        getCreateChildRolloutJobRunOrBuilder() {
      if ((jobRunCase_ == 12) && (createChildRolloutJobRunBuilder_ != null)) {
        return createChildRolloutJobRunBuilder_.getMessageOrBuilder();
      } else {
        if (jobRunCase_ == 12) {
          return (com.google.cloud.deploy.v1.CreateChildRolloutJobRun) jobRun_;
        }
        return com.google.cloud.deploy.v1.CreateChildRolloutJobRun.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Information specific to a createChildRollout `JobRun`.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.CreateChildRolloutJobRun create_child_rollout_job_run = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.CreateChildRolloutJobRun,
            com.google.cloud.deploy.v1.CreateChildRolloutJobRun.Builder,
            com.google.cloud.deploy.v1.CreateChildRolloutJobRunOrBuilder>
        getCreateChildRolloutJobRunFieldBuilder() {
      if (createChildRolloutJobRunBuilder_ == null) {
        if (!(jobRunCase_ == 12)) {
          jobRun_ = com.google.cloud.deploy.v1.CreateChildRolloutJobRun.getDefaultInstance();
        }
        createChildRolloutJobRunBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.deploy.v1.CreateChildRolloutJobRun,
                com.google.cloud.deploy.v1.CreateChildRolloutJobRun.Builder,
                com.google.cloud.deploy.v1.CreateChildRolloutJobRunOrBuilder>(
                (com.google.cloud.deploy.v1.CreateChildRolloutJobRun) jobRun_,
                getParentForChildren(),
                isClean());
        jobRun_ = null;
      }
      jobRunCase_ = 12;
      onChanged();
      return createChildRolloutJobRunBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.AdvanceChildRolloutJobRun,
            com.google.cloud.deploy.v1.AdvanceChildRolloutJobRun.Builder,
            com.google.cloud.deploy.v1.AdvanceChildRolloutJobRunOrBuilder>
        advanceChildRolloutJobRunBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Information specific to an advanceChildRollout `JobRun`
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AdvanceChildRolloutJobRun advance_child_rollout_job_run = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the advanceChildRolloutJobRun field is set.
     */
    @java.lang.Override
    public boolean hasAdvanceChildRolloutJobRun() {
      return jobRunCase_ == 13;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information specific to an advanceChildRollout `JobRun`
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AdvanceChildRolloutJobRun advance_child_rollout_job_run = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The advanceChildRolloutJobRun.
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.AdvanceChildRolloutJobRun getAdvanceChildRolloutJobRun() {
      if (advanceChildRolloutJobRunBuilder_ == null) {
        if (jobRunCase_ == 13) {
          return (com.google.cloud.deploy.v1.AdvanceChildRolloutJobRun) jobRun_;
        }
        return com.google.cloud.deploy.v1.AdvanceChildRolloutJobRun.getDefaultInstance();
      } else {
        if (jobRunCase_ == 13) {
          return advanceChildRolloutJobRunBuilder_.getMessage();
        }
        return com.google.cloud.deploy.v1.AdvanceChildRolloutJobRun.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Information specific to an advanceChildRollout `JobRun`
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AdvanceChildRolloutJobRun advance_child_rollout_job_run = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setAdvanceChildRolloutJobRun(
        com.google.cloud.deploy.v1.AdvanceChildRolloutJobRun value) {
      if (advanceChildRolloutJobRunBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        jobRun_ = value;
        onChanged();
      } else {
        advanceChildRolloutJobRunBuilder_.setMessage(value);
      }
      jobRunCase_ = 13;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information specific to an advanceChildRollout `JobRun`
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AdvanceChildRolloutJobRun advance_child_rollout_job_run = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setAdvanceChildRolloutJobRun(
        com.google.cloud.deploy.v1.AdvanceChildRolloutJobRun.Builder builderForValue) {
      if (advanceChildRolloutJobRunBuilder_ == null) {
        jobRun_ = builderForValue.build();
        onChanged();
      } else {
        advanceChildRolloutJobRunBuilder_.setMessage(builderForValue.build());
      }
      jobRunCase_ = 13;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information specific to an advanceChildRollout `JobRun`
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AdvanceChildRolloutJobRun advance_child_rollout_job_run = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeAdvanceChildRolloutJobRun(
        com.google.cloud.deploy.v1.AdvanceChildRolloutJobRun value) {
      if (advanceChildRolloutJobRunBuilder_ == null) {
        if (jobRunCase_ == 13
            && jobRun_
                != com.google.cloud.deploy.v1.AdvanceChildRolloutJobRun.getDefaultInstance()) {
          jobRun_ =
              com.google.cloud.deploy.v1.AdvanceChildRolloutJobRun.newBuilder(
                      (com.google.cloud.deploy.v1.AdvanceChildRolloutJobRun) jobRun_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          jobRun_ = value;
        }
        onChanged();
      } else {
        if (jobRunCase_ == 13) {
          advanceChildRolloutJobRunBuilder_.mergeFrom(value);
        } else {
          advanceChildRolloutJobRunBuilder_.setMessage(value);
        }
      }
      jobRunCase_ = 13;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information specific to an advanceChildRollout `JobRun`
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AdvanceChildRolloutJobRun advance_child_rollout_job_run = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearAdvanceChildRolloutJobRun() {
      if (advanceChildRolloutJobRunBuilder_ == null) {
        if (jobRunCase_ == 13) {
          jobRunCase_ = 0;
          jobRun_ = null;
          onChanged();
        }
      } else {
        if (jobRunCase_ == 13) {
          jobRunCase_ = 0;
          jobRun_ = null;
        }
        advanceChildRolloutJobRunBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information specific to an advanceChildRollout `JobRun`
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AdvanceChildRolloutJobRun advance_child_rollout_job_run = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.deploy.v1.AdvanceChildRolloutJobRun.Builder
        getAdvanceChildRolloutJobRunBuilder() {
      return getAdvanceChildRolloutJobRunFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Information specific to an advanceChildRollout `JobRun`
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AdvanceChildRolloutJobRun advance_child_rollout_job_run = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.AdvanceChildRolloutJobRunOrBuilder
        getAdvanceChildRolloutJobRunOrBuilder() {
      if ((jobRunCase_ == 13) && (advanceChildRolloutJobRunBuilder_ != null)) {
        return advanceChildRolloutJobRunBuilder_.getMessageOrBuilder();
      } else {
        if (jobRunCase_ == 13) {
          return (com.google.cloud.deploy.v1.AdvanceChildRolloutJobRun) jobRun_;
        }
        return com.google.cloud.deploy.v1.AdvanceChildRolloutJobRun.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Information specific to an advanceChildRollout `JobRun`
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AdvanceChildRolloutJobRun advance_child_rollout_job_run = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.AdvanceChildRolloutJobRun,
            com.google.cloud.deploy.v1.AdvanceChildRolloutJobRun.Builder,
            com.google.cloud.deploy.v1.AdvanceChildRolloutJobRunOrBuilder>
        getAdvanceChildRolloutJobRunFieldBuilder() {
      if (advanceChildRolloutJobRunBuilder_ == null) {
        if (!(jobRunCase_ == 13)) {
          jobRun_ = com.google.cloud.deploy.v1.AdvanceChildRolloutJobRun.getDefaultInstance();
        }
        advanceChildRolloutJobRunBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.deploy.v1.AdvanceChildRolloutJobRun,
                com.google.cloud.deploy.v1.AdvanceChildRolloutJobRun.Builder,
                com.google.cloud.deploy.v1.AdvanceChildRolloutJobRunOrBuilder>(
                (com.google.cloud.deploy.v1.AdvanceChildRolloutJobRun) jobRun_,
                getParentForChildren(),
                isClean());
        jobRun_ = null;
      }
      jobRunCase_ = 13;
      onChanged();
      return advanceChildRolloutJobRunBuilder_;
    }

    private java.lang.Object etag_ = "";
    /**
     *
     *
     * <pre>
     * Output only. This checksum is computed by the server based on the value of
     * other fields, and may be sent on update and delete requests to ensure the
     * client has an up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The etag.
     */
    public java.lang.String getEtag() {
      java.lang.Object ref = etag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        etag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. This checksum is computed by the server based on the value of
     * other fields, and may be sent on update and delete requests to ensure the
     * client has an up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for etag.
     */
    public com.google.protobuf.ByteString getEtagBytes() {
      java.lang.Object ref = etag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        etag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. This checksum is computed by the server based on the value of
     * other fields, and may be sent on update and delete requests to ensure the
     * client has an up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      etag_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. This checksum is computed by the server based on the value of
     * other fields, and may be sent on update and delete requests to ensure the
     * client has an up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEtag() {
      etag_ = getDefaultInstance().getEtag();
      bitField0_ = (bitField0_ & ~0x00004000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. This checksum is computed by the server based on the value of
     * other fields, and may be sent on update and delete requests to ensure the
     * client has an up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      etag_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.deploy.v1.JobRun)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.deploy.v1.JobRun)
  private static final com.google.cloud.deploy.v1.JobRun DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.deploy.v1.JobRun();
  }

  public static com.google.cloud.deploy.v1.JobRun getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<JobRun> PARSER =
      new com.google.protobuf.AbstractParser<JobRun>() {
        @java.lang.Override
        public JobRun parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<JobRun> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<JobRun> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.deploy.v1.JobRun getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
