/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/deploy/v1/cloud_deploy.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.deploy.v1;

/**
 *
 *
 * <pre>
 * Phase represents a collection of jobs that are logically grouped together
 * for a `Rollout`.
 * </pre>
 *
 * Protobuf type {@code google.cloud.deploy.v1.Phase}
 */
public final class Phase extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.deploy.v1.Phase)
    PhaseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Phase.newBuilder() to construct.
  private Phase(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Phase() {
    id_ = "";
    state_ = 0;
    skipMessage_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Phase();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.deploy.v1.CloudDeployProto
        .internal_static_google_cloud_deploy_v1_Phase_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.deploy.v1.CloudDeployProto
        .internal_static_google_cloud_deploy_v1_Phase_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.deploy.v1.Phase.class, com.google.cloud.deploy.v1.Phase.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Valid states of a Phase.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.deploy.v1.Phase.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The Phase has an unspecified state.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The Phase is waiting for an earlier Phase(s) to complete.
     * </pre>
     *
     * <code>PENDING = 1;</code>
     */
    PENDING(1),
    /**
     *
     *
     * <pre>
     * The Phase is in progress.
     * </pre>
     *
     * <code>IN_PROGRESS = 2;</code>
     */
    IN_PROGRESS(2),
    /**
     *
     *
     * <pre>
     * The Phase has succeeded.
     * </pre>
     *
     * <code>SUCCEEDED = 3;</code>
     */
    SUCCEEDED(3),
    /**
     *
     *
     * <pre>
     * The Phase has failed.
     * </pre>
     *
     * <code>FAILED = 4;</code>
     */
    FAILED(4),
    /**
     *
     *
     * <pre>
     * The Phase was aborted.
     * </pre>
     *
     * <code>ABORTED = 5;</code>
     */
    ABORTED(5),
    /**
     *
     *
     * <pre>
     * The Phase was skipped.
     * </pre>
     *
     * <code>SKIPPED = 6;</code>
     */
    SKIPPED(6),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The Phase has an unspecified state.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The Phase is waiting for an earlier Phase(s) to complete.
     * </pre>
     *
     * <code>PENDING = 1;</code>
     */
    public static final int PENDING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The Phase is in progress.
     * </pre>
     *
     * <code>IN_PROGRESS = 2;</code>
     */
    public static final int IN_PROGRESS_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The Phase has succeeded.
     * </pre>
     *
     * <code>SUCCEEDED = 3;</code>
     */
    public static final int SUCCEEDED_VALUE = 3;
    /**
     *
     *
     * <pre>
     * The Phase has failed.
     * </pre>
     *
     * <code>FAILED = 4;</code>
     */
    public static final int FAILED_VALUE = 4;
    /**
     *
     *
     * <pre>
     * The Phase was aborted.
     * </pre>
     *
     * <code>ABORTED = 5;</code>
     */
    public static final int ABORTED_VALUE = 5;
    /**
     *
     *
     * <pre>
     * The Phase was skipped.
     * </pre>
     *
     * <code>SKIPPED = 6;</code>
     */
    public static final int SKIPPED_VALUE = 6;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return PENDING;
        case 2:
          return IN_PROGRESS;
        case 3:
          return SUCCEEDED;
        case 4:
          return FAILED;
        case 5:
          return ABORTED;
        case 6:
          return SKIPPED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.deploy.v1.Phase.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.deploy.v1.Phase.State)
  }

  private int jobsCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object jobs_;

  public enum JobsCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    DEPLOYMENT_JOBS(4),
    CHILD_ROLLOUT_JOBS(5),
    JOBS_NOT_SET(0);
    private final int value;

    private JobsCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static JobsCase valueOf(int value) {
      return forNumber(value);
    }

    public static JobsCase forNumber(int value) {
      switch (value) {
        case 4:
          return DEPLOYMENT_JOBS;
        case 5:
          return CHILD_ROLLOUT_JOBS;
        case 0:
          return JOBS_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public JobsCase getJobsCase() {
    return JobsCase.forNumber(jobsCase_);
  }

  public static final int ID_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object id_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The ID of the Phase.
   * </pre>
   *
   * <code>string id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public java.lang.String getId() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      id_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The ID of the Phase.
   * </pre>
   *
   * <code>string id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for id.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIdBytes() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      id_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATE_FIELD_NUMBER = 3;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. Current state of the Phase.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.Phase.State state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Current state of the Phase.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.Phase.State state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.Phase.State getState() {
    com.google.cloud.deploy.v1.Phase.State result =
        com.google.cloud.deploy.v1.Phase.State.forNumber(state_);
    return result == null ? com.google.cloud.deploy.v1.Phase.State.UNRECOGNIZED : result;
  }

  public static final int SKIP_MESSAGE_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object skipMessage_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Additional information on why the Phase was skipped, if
   * available.
   * </pre>
   *
   * <code>string skip_message = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The skipMessage.
   */
  @java.lang.Override
  public java.lang.String getSkipMessage() {
    java.lang.Object ref = skipMessage_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      skipMessage_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Additional information on why the Phase was skipped, if
   * available.
   * </pre>
   *
   * <code>string skip_message = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for skipMessage.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSkipMessageBytes() {
    java.lang.Object ref = skipMessage_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      skipMessage_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DEPLOYMENT_JOBS_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Output only. Deployment job composition.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.DeploymentJobs deployment_jobs = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the deploymentJobs field is set.
   */
  @java.lang.Override
  public boolean hasDeploymentJobs() {
    return jobsCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Output only. Deployment job composition.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.DeploymentJobs deployment_jobs = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The deploymentJobs.
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.DeploymentJobs getDeploymentJobs() {
    if (jobsCase_ == 4) {
      return (com.google.cloud.deploy.v1.DeploymentJobs) jobs_;
    }
    return com.google.cloud.deploy.v1.DeploymentJobs.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Output only. Deployment job composition.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.DeploymentJobs deployment_jobs = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.DeploymentJobsOrBuilder getDeploymentJobsOrBuilder() {
    if (jobsCase_ == 4) {
      return (com.google.cloud.deploy.v1.DeploymentJobs) jobs_;
    }
    return com.google.cloud.deploy.v1.DeploymentJobs.getDefaultInstance();
  }

  public static final int CHILD_ROLLOUT_JOBS_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * Output only. ChildRollout job composition.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.ChildRolloutJobs child_rollout_jobs = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the childRolloutJobs field is set.
   */
  @java.lang.Override
  public boolean hasChildRolloutJobs() {
    return jobsCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * Output only. ChildRollout job composition.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.ChildRolloutJobs child_rollout_jobs = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The childRolloutJobs.
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.ChildRolloutJobs getChildRolloutJobs() {
    if (jobsCase_ == 5) {
      return (com.google.cloud.deploy.v1.ChildRolloutJobs) jobs_;
    }
    return com.google.cloud.deploy.v1.ChildRolloutJobs.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Output only. ChildRollout job composition.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.ChildRolloutJobs child_rollout_jobs = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.ChildRolloutJobsOrBuilder getChildRolloutJobsOrBuilder() {
    if (jobsCase_ == 5) {
      return (com.google.cloud.deploy.v1.ChildRolloutJobs) jobs_;
    }
    return com.google.cloud.deploy.v1.ChildRolloutJobs.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, id_);
    }
    if (state_ != com.google.cloud.deploy.v1.Phase.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(3, state_);
    }
    if (jobsCase_ == 4) {
      output.writeMessage(4, (com.google.cloud.deploy.v1.DeploymentJobs) jobs_);
    }
    if (jobsCase_ == 5) {
      output.writeMessage(5, (com.google.cloud.deploy.v1.ChildRolloutJobs) jobs_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(skipMessage_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, skipMessage_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, id_);
    }
    if (state_ != com.google.cloud.deploy.v1.Phase.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, state_);
    }
    if (jobsCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.cloud.deploy.v1.DeploymentJobs) jobs_);
    }
    if (jobsCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.cloud.deploy.v1.ChildRolloutJobs) jobs_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(skipMessage_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, skipMessage_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.deploy.v1.Phase)) {
      return super.equals(obj);
    }
    com.google.cloud.deploy.v1.Phase other = (com.google.cloud.deploy.v1.Phase) obj;

    if (!getId().equals(other.getId())) return false;
    if (state_ != other.state_) return false;
    if (!getSkipMessage().equals(other.getSkipMessage())) return false;
    if (!getJobsCase().equals(other.getJobsCase())) return false;
    switch (jobsCase_) {
      case 4:
        if (!getDeploymentJobs().equals(other.getDeploymentJobs())) return false;
        break;
      case 5:
        if (!getChildRolloutJobs().equals(other.getChildRolloutJobs())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ID_FIELD_NUMBER;
    hash = (53 * hash) + getId().hashCode();
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (37 * hash) + SKIP_MESSAGE_FIELD_NUMBER;
    hash = (53 * hash) + getSkipMessage().hashCode();
    switch (jobsCase_) {
      case 4:
        hash = (37 * hash) + DEPLOYMENT_JOBS_FIELD_NUMBER;
        hash = (53 * hash) + getDeploymentJobs().hashCode();
        break;
      case 5:
        hash = (37 * hash) + CHILD_ROLLOUT_JOBS_FIELD_NUMBER;
        hash = (53 * hash) + getChildRolloutJobs().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.deploy.v1.Phase parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.Phase parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.Phase parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.Phase parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.Phase parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.Phase parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.Phase parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.Phase parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.Phase parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.Phase parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.Phase parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.Phase parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.deploy.v1.Phase prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Phase represents a collection of jobs that are logically grouped together
   * for a `Rollout`.
   * </pre>
   *
   * Protobuf type {@code google.cloud.deploy.v1.Phase}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.deploy.v1.Phase)
      com.google.cloud.deploy.v1.PhaseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_Phase_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_Phase_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.deploy.v1.Phase.class,
              com.google.cloud.deploy.v1.Phase.Builder.class);
    }

    // Construct using com.google.cloud.deploy.v1.Phase.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      id_ = "";
      state_ = 0;
      skipMessage_ = "";
      if (deploymentJobsBuilder_ != null) {
        deploymentJobsBuilder_.clear();
      }
      if (childRolloutJobsBuilder_ != null) {
        childRolloutJobsBuilder_.clear();
      }
      jobsCase_ = 0;
      jobs_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_Phase_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.Phase getDefaultInstanceForType() {
      return com.google.cloud.deploy.v1.Phase.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.Phase build() {
      com.google.cloud.deploy.v1.Phase result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.Phase buildPartial() {
      com.google.cloud.deploy.v1.Phase result = new com.google.cloud.deploy.v1.Phase(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.deploy.v1.Phase result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.id_ = id_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.skipMessage_ = skipMessage_;
      }
    }

    private void buildPartialOneofs(com.google.cloud.deploy.v1.Phase result) {
      result.jobsCase_ = jobsCase_;
      result.jobs_ = this.jobs_;
      if (jobsCase_ == 4 && deploymentJobsBuilder_ != null) {
        result.jobs_ = deploymentJobsBuilder_.build();
      }
      if (jobsCase_ == 5 && childRolloutJobsBuilder_ != null) {
        result.jobs_ = childRolloutJobsBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.deploy.v1.Phase) {
        return mergeFrom((com.google.cloud.deploy.v1.Phase) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.deploy.v1.Phase other) {
      if (other == com.google.cloud.deploy.v1.Phase.getDefaultInstance()) return this;
      if (!other.getId().isEmpty()) {
        id_ = other.id_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (!other.getSkipMessage().isEmpty()) {
        skipMessage_ = other.skipMessage_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      switch (other.getJobsCase()) {
        case DEPLOYMENT_JOBS:
          {
            mergeDeploymentJobs(other.getDeploymentJobs());
            break;
          }
        case CHILD_ROLLOUT_JOBS:
          {
            mergeChildRolloutJobs(other.getChildRolloutJobs());
            break;
          }
        case JOBS_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                id_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 24:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 24
            case 34:
              {
                input.readMessage(getDeploymentJobsFieldBuilder().getBuilder(), extensionRegistry);
                jobsCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(
                    getChildRolloutJobsFieldBuilder().getBuilder(), extensionRegistry);
                jobsCase_ = 5;
                break;
              } // case 42
            case 50:
              {
                skipMessage_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int jobsCase_ = 0;
    private java.lang.Object jobs_;

    public JobsCase getJobsCase() {
      return JobsCase.forNumber(jobsCase_);
    }

    public Builder clearJobs() {
      jobsCase_ = 0;
      jobs_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object id_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The ID of the Phase.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The id.
     */
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The ID of the Phase.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for id.
     */
    public com.google.protobuf.ByteString getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The ID of the Phase.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      id_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The ID of the Phase.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {
      id_ = getDefaultInstance().getId();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The ID of the Phase.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for id to set.
     * @return This builder for chaining.
     */
    public Builder setIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      id_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. Current state of the Phase.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Phase.State state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Current state of the Phase.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Phase.State state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Current state of the Phase.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Phase.State state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.Phase.State getState() {
      com.google.cloud.deploy.v1.Phase.State result =
          com.google.cloud.deploy.v1.Phase.State.forNumber(state_);
      return result == null ? com.google.cloud.deploy.v1.Phase.State.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. Current state of the Phase.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Phase.State state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.deploy.v1.Phase.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Current state of the Phase.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Phase.State state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000002);
      state_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object skipMessage_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Additional information on why the Phase was skipped, if
     * available.
     * </pre>
     *
     * <code>string skip_message = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The skipMessage.
     */
    public java.lang.String getSkipMessage() {
      java.lang.Object ref = skipMessage_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        skipMessage_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information on why the Phase was skipped, if
     * available.
     * </pre>
     *
     * <code>string skip_message = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for skipMessage.
     */
    public com.google.protobuf.ByteString getSkipMessageBytes() {
      java.lang.Object ref = skipMessage_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        skipMessage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information on why the Phase was skipped, if
     * available.
     * </pre>
     *
     * <code>string skip_message = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The skipMessage to set.
     * @return This builder for chaining.
     */
    public Builder setSkipMessage(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      skipMessage_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information on why the Phase was skipped, if
     * available.
     * </pre>
     *
     * <code>string skip_message = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSkipMessage() {
      skipMessage_ = getDefaultInstance().getSkipMessage();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information on why the Phase was skipped, if
     * available.
     * </pre>
     *
     * <code>string skip_message = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for skipMessage to set.
     * @return This builder for chaining.
     */
    public Builder setSkipMessageBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      skipMessage_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.DeploymentJobs,
            com.google.cloud.deploy.v1.DeploymentJobs.Builder,
            com.google.cloud.deploy.v1.DeploymentJobsOrBuilder>
        deploymentJobsBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Deployment job composition.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.DeploymentJobs deployment_jobs = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the deploymentJobs field is set.
     */
    @java.lang.Override
    public boolean hasDeploymentJobs() {
      return jobsCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Output only. Deployment job composition.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.DeploymentJobs deployment_jobs = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The deploymentJobs.
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.DeploymentJobs getDeploymentJobs() {
      if (deploymentJobsBuilder_ == null) {
        if (jobsCase_ == 4) {
          return (com.google.cloud.deploy.v1.DeploymentJobs) jobs_;
        }
        return com.google.cloud.deploy.v1.DeploymentJobs.getDefaultInstance();
      } else {
        if (jobsCase_ == 4) {
          return deploymentJobsBuilder_.getMessage();
        }
        return com.google.cloud.deploy.v1.DeploymentJobs.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Deployment job composition.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.DeploymentJobs deployment_jobs = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDeploymentJobs(com.google.cloud.deploy.v1.DeploymentJobs value) {
      if (deploymentJobsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        jobs_ = value;
        onChanged();
      } else {
        deploymentJobsBuilder_.setMessage(value);
      }
      jobsCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Deployment job composition.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.DeploymentJobs deployment_jobs = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDeploymentJobs(
        com.google.cloud.deploy.v1.DeploymentJobs.Builder builderForValue) {
      if (deploymentJobsBuilder_ == null) {
        jobs_ = builderForValue.build();
        onChanged();
      } else {
        deploymentJobsBuilder_.setMessage(builderForValue.build());
      }
      jobsCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Deployment job composition.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.DeploymentJobs deployment_jobs = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeDeploymentJobs(com.google.cloud.deploy.v1.DeploymentJobs value) {
      if (deploymentJobsBuilder_ == null) {
        if (jobsCase_ == 4
            && jobs_ != com.google.cloud.deploy.v1.DeploymentJobs.getDefaultInstance()) {
          jobs_ =
              com.google.cloud.deploy.v1.DeploymentJobs.newBuilder(
                      (com.google.cloud.deploy.v1.DeploymentJobs) jobs_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          jobs_ = value;
        }
        onChanged();
      } else {
        if (jobsCase_ == 4) {
          deploymentJobsBuilder_.mergeFrom(value);
        } else {
          deploymentJobsBuilder_.setMessage(value);
        }
      }
      jobsCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Deployment job composition.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.DeploymentJobs deployment_jobs = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearDeploymentJobs() {
      if (deploymentJobsBuilder_ == null) {
        if (jobsCase_ == 4) {
          jobsCase_ = 0;
          jobs_ = null;
          onChanged();
        }
      } else {
        if (jobsCase_ == 4) {
          jobsCase_ = 0;
          jobs_ = null;
        }
        deploymentJobsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Deployment job composition.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.DeploymentJobs deployment_jobs = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.deploy.v1.DeploymentJobs.Builder getDeploymentJobsBuilder() {
      return getDeploymentJobsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Deployment job composition.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.DeploymentJobs deployment_jobs = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.DeploymentJobsOrBuilder getDeploymentJobsOrBuilder() {
      if ((jobsCase_ == 4) && (deploymentJobsBuilder_ != null)) {
        return deploymentJobsBuilder_.getMessageOrBuilder();
      } else {
        if (jobsCase_ == 4) {
          return (com.google.cloud.deploy.v1.DeploymentJobs) jobs_;
        }
        return com.google.cloud.deploy.v1.DeploymentJobs.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Deployment job composition.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.DeploymentJobs deployment_jobs = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.DeploymentJobs,
            com.google.cloud.deploy.v1.DeploymentJobs.Builder,
            com.google.cloud.deploy.v1.DeploymentJobsOrBuilder>
        getDeploymentJobsFieldBuilder() {
      if (deploymentJobsBuilder_ == null) {
        if (!(jobsCase_ == 4)) {
          jobs_ = com.google.cloud.deploy.v1.DeploymentJobs.getDefaultInstance();
        }
        deploymentJobsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.deploy.v1.DeploymentJobs,
                com.google.cloud.deploy.v1.DeploymentJobs.Builder,
                com.google.cloud.deploy.v1.DeploymentJobsOrBuilder>(
                (com.google.cloud.deploy.v1.DeploymentJobs) jobs_,
                getParentForChildren(),
                isClean());
        jobs_ = null;
      }
      jobsCase_ = 4;
      onChanged();
      return deploymentJobsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.ChildRolloutJobs,
            com.google.cloud.deploy.v1.ChildRolloutJobs.Builder,
            com.google.cloud.deploy.v1.ChildRolloutJobsOrBuilder>
        childRolloutJobsBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. ChildRollout job composition.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.ChildRolloutJobs child_rollout_jobs = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the childRolloutJobs field is set.
     */
    @java.lang.Override
    public boolean hasChildRolloutJobs() {
      return jobsCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * Output only. ChildRollout job composition.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.ChildRolloutJobs child_rollout_jobs = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The childRolloutJobs.
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.ChildRolloutJobs getChildRolloutJobs() {
      if (childRolloutJobsBuilder_ == null) {
        if (jobsCase_ == 5) {
          return (com.google.cloud.deploy.v1.ChildRolloutJobs) jobs_;
        }
        return com.google.cloud.deploy.v1.ChildRolloutJobs.getDefaultInstance();
      } else {
        if (jobsCase_ == 5) {
          return childRolloutJobsBuilder_.getMessage();
        }
        return com.google.cloud.deploy.v1.ChildRolloutJobs.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. ChildRollout job composition.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.ChildRolloutJobs child_rollout_jobs = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setChildRolloutJobs(com.google.cloud.deploy.v1.ChildRolloutJobs value) {
      if (childRolloutJobsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        jobs_ = value;
        onChanged();
      } else {
        childRolloutJobsBuilder_.setMessage(value);
      }
      jobsCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. ChildRollout job composition.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.ChildRolloutJobs child_rollout_jobs = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setChildRolloutJobs(
        com.google.cloud.deploy.v1.ChildRolloutJobs.Builder builderForValue) {
      if (childRolloutJobsBuilder_ == null) {
        jobs_ = builderForValue.build();
        onChanged();
      } else {
        childRolloutJobsBuilder_.setMessage(builderForValue.build());
      }
      jobsCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. ChildRollout job composition.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.ChildRolloutJobs child_rollout_jobs = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeChildRolloutJobs(com.google.cloud.deploy.v1.ChildRolloutJobs value) {
      if (childRolloutJobsBuilder_ == null) {
        if (jobsCase_ == 5
            && jobs_ != com.google.cloud.deploy.v1.ChildRolloutJobs.getDefaultInstance()) {
          jobs_ =
              com.google.cloud.deploy.v1.ChildRolloutJobs.newBuilder(
                      (com.google.cloud.deploy.v1.ChildRolloutJobs) jobs_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          jobs_ = value;
        }
        onChanged();
      } else {
        if (jobsCase_ == 5) {
          childRolloutJobsBuilder_.mergeFrom(value);
        } else {
          childRolloutJobsBuilder_.setMessage(value);
        }
      }
      jobsCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. ChildRollout job composition.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.ChildRolloutJobs child_rollout_jobs = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearChildRolloutJobs() {
      if (childRolloutJobsBuilder_ == null) {
        if (jobsCase_ == 5) {
          jobsCase_ = 0;
          jobs_ = null;
          onChanged();
        }
      } else {
        if (jobsCase_ == 5) {
          jobsCase_ = 0;
          jobs_ = null;
        }
        childRolloutJobsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. ChildRollout job composition.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.ChildRolloutJobs child_rollout_jobs = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.deploy.v1.ChildRolloutJobs.Builder getChildRolloutJobsBuilder() {
      return getChildRolloutJobsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. ChildRollout job composition.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.ChildRolloutJobs child_rollout_jobs = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.ChildRolloutJobsOrBuilder getChildRolloutJobsOrBuilder() {
      if ((jobsCase_ == 5) && (childRolloutJobsBuilder_ != null)) {
        return childRolloutJobsBuilder_.getMessageOrBuilder();
      } else {
        if (jobsCase_ == 5) {
          return (com.google.cloud.deploy.v1.ChildRolloutJobs) jobs_;
        }
        return com.google.cloud.deploy.v1.ChildRolloutJobs.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. ChildRollout job composition.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.ChildRolloutJobs child_rollout_jobs = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.ChildRolloutJobs,
            com.google.cloud.deploy.v1.ChildRolloutJobs.Builder,
            com.google.cloud.deploy.v1.ChildRolloutJobsOrBuilder>
        getChildRolloutJobsFieldBuilder() {
      if (childRolloutJobsBuilder_ == null) {
        if (!(jobsCase_ == 5)) {
          jobs_ = com.google.cloud.deploy.v1.ChildRolloutJobs.getDefaultInstance();
        }
        childRolloutJobsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.deploy.v1.ChildRolloutJobs,
                com.google.cloud.deploy.v1.ChildRolloutJobs.Builder,
                com.google.cloud.deploy.v1.ChildRolloutJobsOrBuilder>(
                (com.google.cloud.deploy.v1.ChildRolloutJobs) jobs_,
                getParentForChildren(),
                isClean());
        jobs_ = null;
      }
      jobsCase_ = 5;
      onChanged();
      return childRolloutJobsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.deploy.v1.Phase)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.deploy.v1.Phase)
  private static final com.google.cloud.deploy.v1.Phase DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.deploy.v1.Phase();
  }

  public static com.google.cloud.deploy.v1.Phase getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Phase> PARSER =
      new com.google.protobuf.AbstractParser<Phase>() {
        @java.lang.Override
        public Phase parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Phase> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Phase> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.deploy.v1.Phase getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
