/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/deploy/v1/cloud_deploy.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.deploy.v1;

/**
 *
 *
 * <pre>
 * The request object for `RollbackTarget`.
 * </pre>
 *
 * Protobuf type {@code google.cloud.deploy.v1.RollbackTargetRequest}
 */
public final class RollbackTargetRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.deploy.v1.RollbackTargetRequest)
    RollbackTargetRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RollbackTargetRequest.newBuilder() to construct.
  private RollbackTargetRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RollbackTargetRequest() {
    name_ = "";
    targetId_ = "";
    rolloutId_ = "";
    releaseId_ = "";
    rolloutToRollBack_ = "";
    overrideDeployPolicy_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RollbackTargetRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.deploy.v1.CloudDeployProto
        .internal_static_google_cloud_deploy_v1_RollbackTargetRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.deploy.v1.CloudDeployProto
        .internal_static_google_cloud_deploy_v1_RollbackTargetRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.deploy.v1.RollbackTargetRequest.class,
            com.google.cloud.deploy.v1.RollbackTargetRequest.Builder.class);
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Required. The `DeliveryPipeline` for which the rollback `Rollout` must be
   * created. The format is
   * `projects/{project_id}/locations/{location_name}/deliveryPipelines/{pipeline_name}`.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The `DeliveryPipeline` for which the rollback `Rollout` must be
   * created. The format is
   * `projects/{project_id}/locations/{location_name}/deliveryPipelines/{pipeline_name}`.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TARGET_ID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object targetId_ = "";
  /**
   *
   *
   * <pre>
   * Required. ID of the `Target` that is being rolled back.
   * </pre>
   *
   * <code>string target_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The targetId.
   */
  @java.lang.Override
  public java.lang.String getTargetId() {
    java.lang.Object ref = targetId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      targetId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. ID of the `Target` that is being rolled back.
   * </pre>
   *
   * <code>string target_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for targetId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTargetIdBytes() {
    java.lang.Object ref = targetId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      targetId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ROLLOUT_ID_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object rolloutId_ = "";
  /**
   *
   *
   * <pre>
   * Required. ID of the rollback `Rollout` to create.
   * </pre>
   *
   * <code>string rollout_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The rolloutId.
   */
  @java.lang.Override
  public java.lang.String getRolloutId() {
    java.lang.Object ref = rolloutId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      rolloutId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. ID of the rollback `Rollout` to create.
   * </pre>
   *
   * <code>string rollout_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for rolloutId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRolloutIdBytes() {
    java.lang.Object ref = rolloutId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      rolloutId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RELEASE_ID_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object releaseId_ = "";
  /**
   *
   *
   * <pre>
   * Optional. ID of the `Release` to roll back to. If this isn't specified, the
   * previous successful `Rollout` to the specified target will be used to
   * determine the `Release`.
   * </pre>
   *
   * <code>string release_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The releaseId.
   */
  @java.lang.Override
  public java.lang.String getReleaseId() {
    java.lang.Object ref = releaseId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      releaseId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. ID of the `Release` to roll back to. If this isn't specified, the
   * previous successful `Rollout` to the specified target will be used to
   * determine the `Release`.
   * </pre>
   *
   * <code>string release_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for releaseId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getReleaseIdBytes() {
    java.lang.Object ref = releaseId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      releaseId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ROLLOUT_TO_ROLL_BACK_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object rolloutToRollBack_ = "";
  /**
   *
   *
   * <pre>
   * Optional. If provided, this must be the latest `Rollout` that is on the
   * `Target`.
   * </pre>
   *
   * <code>string rollout_to_roll_back = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The rolloutToRollBack.
   */
  @java.lang.Override
  public java.lang.String getRolloutToRollBack() {
    java.lang.Object ref = rolloutToRollBack_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      rolloutToRollBack_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. If provided, this must be the latest `Rollout` that is on the
   * `Target`.
   * </pre>
   *
   * <code>string rollout_to_roll_back = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for rolloutToRollBack.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRolloutToRollBackBytes() {
    java.lang.Object ref = rolloutToRollBack_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      rolloutToRollBack_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ROLLBACK_CONFIG_FIELD_NUMBER = 6;
  private com.google.cloud.deploy.v1.RollbackTargetConfig rollbackConfig_;
  /**
   *
   *
   * <pre>
   * Optional. Configs for the rollback `Rollout`.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.RollbackTargetConfig rollback_config = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the rollbackConfig field is set.
   */
  @java.lang.Override
  public boolean hasRollbackConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Configs for the rollback `Rollout`.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.RollbackTargetConfig rollback_config = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The rollbackConfig.
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.RollbackTargetConfig getRollbackConfig() {
    return rollbackConfig_ == null
        ? com.google.cloud.deploy.v1.RollbackTargetConfig.getDefaultInstance()
        : rollbackConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Configs for the rollback `Rollout`.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.RollbackTargetConfig rollback_config = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.RollbackTargetConfigOrBuilder getRollbackConfigOrBuilder() {
    return rollbackConfig_ == null
        ? com.google.cloud.deploy.v1.RollbackTargetConfig.getDefaultInstance()
        : rollbackConfig_;
  }

  public static final int VALIDATE_ONLY_FIELD_NUMBER = 7;
  private boolean validateOnly_ = false;
  /**
   *
   *
   * <pre>
   * Optional. If set to true, the request is validated and the user is provided
   * with a `RollbackTargetResponse`.
   * </pre>
   *
   * <code>bool validate_only = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The validateOnly.
   */
  @java.lang.Override
  public boolean getValidateOnly() {
    return validateOnly_;
  }

  public static final int OVERRIDE_DEPLOY_POLICY_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList overrideDeployPolicy_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Optional. Deploy policies to override. Format is
   * `projects/{project}/locations/{location}/deployPolicies/{deploy_policy}`.
   * </pre>
   *
   * <code>
   * repeated string override_deploy_policy = 9 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return A list containing the overrideDeployPolicy.
   */
  public com.google.protobuf.ProtocolStringList getOverrideDeployPolicyList() {
    return overrideDeployPolicy_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Deploy policies to override. Format is
   * `projects/{project}/locations/{location}/deployPolicies/{deploy_policy}`.
   * </pre>
   *
   * <code>
   * repeated string override_deploy_policy = 9 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The count of overrideDeployPolicy.
   */
  public int getOverrideDeployPolicyCount() {
    return overrideDeployPolicy_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Deploy policies to override. Format is
   * `projects/{project}/locations/{location}/deployPolicies/{deploy_policy}`.
   * </pre>
   *
   * <code>
   * repeated string override_deploy_policy = 9 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @param index The index of the element to return.
   * @return The overrideDeployPolicy at the given index.
   */
  public java.lang.String getOverrideDeployPolicy(int index) {
    return overrideDeployPolicy_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. Deploy policies to override. Format is
   * `projects/{project}/locations/{location}/deployPolicies/{deploy_policy}`.
   * </pre>
   *
   * <code>
   * repeated string override_deploy_policy = 9 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the overrideDeployPolicy at the given index.
   */
  public com.google.protobuf.ByteString getOverrideDeployPolicyBytes(int index) {
    return overrideDeployPolicy_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(targetId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, targetId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(rolloutId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, rolloutId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(releaseId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, releaseId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(rolloutToRollBack_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, rolloutToRollBack_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(6, getRollbackConfig());
    }
    if (validateOnly_ != false) {
      output.writeBool(7, validateOnly_);
    }
    for (int i = 0; i < overrideDeployPolicy_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 9, overrideDeployPolicy_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(targetId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, targetId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(rolloutId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, rolloutId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(releaseId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, releaseId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(rolloutToRollBack_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, rolloutToRollBack_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getRollbackConfig());
    }
    if (validateOnly_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(7, validateOnly_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < overrideDeployPolicy_.size(); i++) {
        dataSize += computeStringSizeNoTag(overrideDeployPolicy_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getOverrideDeployPolicyList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.deploy.v1.RollbackTargetRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.deploy.v1.RollbackTargetRequest other =
        (com.google.cloud.deploy.v1.RollbackTargetRequest) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getTargetId().equals(other.getTargetId())) return false;
    if (!getRolloutId().equals(other.getRolloutId())) return false;
    if (!getReleaseId().equals(other.getReleaseId())) return false;
    if (!getRolloutToRollBack().equals(other.getRolloutToRollBack())) return false;
    if (hasRollbackConfig() != other.hasRollbackConfig()) return false;
    if (hasRollbackConfig()) {
      if (!getRollbackConfig().equals(other.getRollbackConfig())) return false;
    }
    if (getValidateOnly() != other.getValidateOnly()) return false;
    if (!getOverrideDeployPolicyList().equals(other.getOverrideDeployPolicyList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + TARGET_ID_FIELD_NUMBER;
    hash = (53 * hash) + getTargetId().hashCode();
    hash = (37 * hash) + ROLLOUT_ID_FIELD_NUMBER;
    hash = (53 * hash) + getRolloutId().hashCode();
    hash = (37 * hash) + RELEASE_ID_FIELD_NUMBER;
    hash = (53 * hash) + getReleaseId().hashCode();
    hash = (37 * hash) + ROLLOUT_TO_ROLL_BACK_FIELD_NUMBER;
    hash = (53 * hash) + getRolloutToRollBack().hashCode();
    if (hasRollbackConfig()) {
      hash = (37 * hash) + ROLLBACK_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getRollbackConfig().hashCode();
    }
    hash = (37 * hash) + VALIDATE_ONLY_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getValidateOnly());
    if (getOverrideDeployPolicyCount() > 0) {
      hash = (37 * hash) + OVERRIDE_DEPLOY_POLICY_FIELD_NUMBER;
      hash = (53 * hash) + getOverrideDeployPolicyList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.deploy.v1.RollbackTargetRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.RollbackTargetRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.RollbackTargetRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.RollbackTargetRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.RollbackTargetRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.RollbackTargetRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.RollbackTargetRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.RollbackTargetRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.RollbackTargetRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.RollbackTargetRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.RollbackTargetRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.RollbackTargetRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.deploy.v1.RollbackTargetRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The request object for `RollbackTarget`.
   * </pre>
   *
   * Protobuf type {@code google.cloud.deploy.v1.RollbackTargetRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.deploy.v1.RollbackTargetRequest)
      com.google.cloud.deploy.v1.RollbackTargetRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_RollbackTargetRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_RollbackTargetRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.deploy.v1.RollbackTargetRequest.class,
              com.google.cloud.deploy.v1.RollbackTargetRequest.Builder.class);
    }

    // Construct using com.google.cloud.deploy.v1.RollbackTargetRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getRollbackConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      targetId_ = "";
      rolloutId_ = "";
      releaseId_ = "";
      rolloutToRollBack_ = "";
      rollbackConfig_ = null;
      if (rollbackConfigBuilder_ != null) {
        rollbackConfigBuilder_.dispose();
        rollbackConfigBuilder_ = null;
      }
      validateOnly_ = false;
      overrideDeployPolicy_ = com.google.protobuf.LazyStringArrayList.emptyList();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_RollbackTargetRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.RollbackTargetRequest getDefaultInstanceForType() {
      return com.google.cloud.deploy.v1.RollbackTargetRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.RollbackTargetRequest build() {
      com.google.cloud.deploy.v1.RollbackTargetRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.RollbackTargetRequest buildPartial() {
      com.google.cloud.deploy.v1.RollbackTargetRequest result =
          new com.google.cloud.deploy.v1.RollbackTargetRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.deploy.v1.RollbackTargetRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.targetId_ = targetId_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.rolloutId_ = rolloutId_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.releaseId_ = releaseId_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.rolloutToRollBack_ = rolloutToRollBack_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.rollbackConfig_ =
            rollbackConfigBuilder_ == null ? rollbackConfig_ : rollbackConfigBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.validateOnly_ = validateOnly_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        overrideDeployPolicy_.makeImmutable();
        result.overrideDeployPolicy_ = overrideDeployPolicy_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.deploy.v1.RollbackTargetRequest) {
        return mergeFrom((com.google.cloud.deploy.v1.RollbackTargetRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.deploy.v1.RollbackTargetRequest other) {
      if (other == com.google.cloud.deploy.v1.RollbackTargetRequest.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getTargetId().isEmpty()) {
        targetId_ = other.targetId_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getRolloutId().isEmpty()) {
        rolloutId_ = other.rolloutId_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getReleaseId().isEmpty()) {
        releaseId_ = other.releaseId_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getRolloutToRollBack().isEmpty()) {
        rolloutToRollBack_ = other.rolloutToRollBack_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.hasRollbackConfig()) {
        mergeRollbackConfig(other.getRollbackConfig());
      }
      if (other.getValidateOnly() != false) {
        setValidateOnly(other.getValidateOnly());
      }
      if (!other.overrideDeployPolicy_.isEmpty()) {
        if (overrideDeployPolicy_.isEmpty()) {
          overrideDeployPolicy_ = other.overrideDeployPolicy_;
          bitField0_ |= 0x00000080;
        } else {
          ensureOverrideDeployPolicyIsMutable();
          overrideDeployPolicy_.addAll(other.overrideDeployPolicy_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                targetId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                rolloutId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                releaseId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                rolloutToRollBack_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getRollbackConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 56:
              {
                validateOnly_ = input.readBool();
                bitField0_ |= 0x00000040;
                break;
              } // case 56
            case 74:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureOverrideDeployPolicyIsMutable();
                overrideDeployPolicy_.add(s);
                break;
              } // case 74
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. The `DeliveryPipeline` for which the rollback `Rollout` must be
     * created. The format is
     * `projects/{project_id}/locations/{location_name}/deliveryPipelines/{pipeline_name}`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The `DeliveryPipeline` for which the rollback `Rollout` must be
     * created. The format is
     * `projects/{project_id}/locations/{location_name}/deliveryPipelines/{pipeline_name}`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The `DeliveryPipeline` for which the rollback `Rollout` must be
     * created. The format is
     * `projects/{project_id}/locations/{location_name}/deliveryPipelines/{pipeline_name}`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The `DeliveryPipeline` for which the rollback `Rollout` must be
     * created. The format is
     * `projects/{project_id}/locations/{location_name}/deliveryPipelines/{pipeline_name}`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The `DeliveryPipeline` for which the rollback `Rollout` must be
     * created. The format is
     * `projects/{project_id}/locations/{location_name}/deliveryPipelines/{pipeline_name}`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object targetId_ = "";
    /**
     *
     *
     * <pre>
     * Required. ID of the `Target` that is being rolled back.
     * </pre>
     *
     * <code>string target_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The targetId.
     */
    public java.lang.String getTargetId() {
      java.lang.Object ref = targetId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        targetId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. ID of the `Target` that is being rolled back.
     * </pre>
     *
     * <code>string target_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for targetId.
     */
    public com.google.protobuf.ByteString getTargetIdBytes() {
      java.lang.Object ref = targetId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        targetId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. ID of the `Target` that is being rolled back.
     * </pre>
     *
     * <code>string target_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The targetId to set.
     * @return This builder for chaining.
     */
    public Builder setTargetId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      targetId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. ID of the `Target` that is being rolled back.
     * </pre>
     *
     * <code>string target_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTargetId() {
      targetId_ = getDefaultInstance().getTargetId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. ID of the `Target` that is being rolled back.
     * </pre>
     *
     * <code>string target_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for targetId to set.
     * @return This builder for chaining.
     */
    public Builder setTargetIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      targetId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object rolloutId_ = "";
    /**
     *
     *
     * <pre>
     * Required. ID of the rollback `Rollout` to create.
     * </pre>
     *
     * <code>string rollout_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The rolloutId.
     */
    public java.lang.String getRolloutId() {
      java.lang.Object ref = rolloutId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        rolloutId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. ID of the rollback `Rollout` to create.
     * </pre>
     *
     * <code>string rollout_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for rolloutId.
     */
    public com.google.protobuf.ByteString getRolloutIdBytes() {
      java.lang.Object ref = rolloutId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        rolloutId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. ID of the rollback `Rollout` to create.
     * </pre>
     *
     * <code>string rollout_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The rolloutId to set.
     * @return This builder for chaining.
     */
    public Builder setRolloutId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      rolloutId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. ID of the rollback `Rollout` to create.
     * </pre>
     *
     * <code>string rollout_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRolloutId() {
      rolloutId_ = getDefaultInstance().getRolloutId();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. ID of the rollback `Rollout` to create.
     * </pre>
     *
     * <code>string rollout_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for rolloutId to set.
     * @return This builder for chaining.
     */
    public Builder setRolloutIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      rolloutId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object releaseId_ = "";
    /**
     *
     *
     * <pre>
     * Optional. ID of the `Release` to roll back to. If this isn't specified, the
     * previous successful `Rollout` to the specified target will be used to
     * determine the `Release`.
     * </pre>
     *
     * <code>string release_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The releaseId.
     */
    public java.lang.String getReleaseId() {
      java.lang.Object ref = releaseId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        releaseId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. ID of the `Release` to roll back to. If this isn't specified, the
     * previous successful `Rollout` to the specified target will be used to
     * determine the `Release`.
     * </pre>
     *
     * <code>string release_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for releaseId.
     */
    public com.google.protobuf.ByteString getReleaseIdBytes() {
      java.lang.Object ref = releaseId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        releaseId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. ID of the `Release` to roll back to. If this isn't specified, the
     * previous successful `Rollout` to the specified target will be used to
     * determine the `Release`.
     * </pre>
     *
     * <code>string release_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The releaseId to set.
     * @return This builder for chaining.
     */
    public Builder setReleaseId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      releaseId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. ID of the `Release` to roll back to. If this isn't specified, the
     * previous successful `Rollout` to the specified target will be used to
     * determine the `Release`.
     * </pre>
     *
     * <code>string release_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReleaseId() {
      releaseId_ = getDefaultInstance().getReleaseId();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. ID of the `Release` to roll back to. If this isn't specified, the
     * previous successful `Rollout` to the specified target will be used to
     * determine the `Release`.
     * </pre>
     *
     * <code>string release_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for releaseId to set.
     * @return This builder for chaining.
     */
    public Builder setReleaseIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      releaseId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object rolloutToRollBack_ = "";
    /**
     *
     *
     * <pre>
     * Optional. If provided, this must be the latest `Rollout` that is on the
     * `Target`.
     * </pre>
     *
     * <code>string rollout_to_roll_back = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The rolloutToRollBack.
     */
    public java.lang.String getRolloutToRollBack() {
      java.lang.Object ref = rolloutToRollBack_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        rolloutToRollBack_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. If provided, this must be the latest `Rollout` that is on the
     * `Target`.
     * </pre>
     *
     * <code>string rollout_to_roll_back = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for rolloutToRollBack.
     */
    public com.google.protobuf.ByteString getRolloutToRollBackBytes() {
      java.lang.Object ref = rolloutToRollBack_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        rolloutToRollBack_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. If provided, this must be the latest `Rollout` that is on the
     * `Target`.
     * </pre>
     *
     * <code>string rollout_to_roll_back = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The rolloutToRollBack to set.
     * @return This builder for chaining.
     */
    public Builder setRolloutToRollBack(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      rolloutToRollBack_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If provided, this must be the latest `Rollout` that is on the
     * `Target`.
     * </pre>
     *
     * <code>string rollout_to_roll_back = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRolloutToRollBack() {
      rolloutToRollBack_ = getDefaultInstance().getRolloutToRollBack();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If provided, this must be the latest `Rollout` that is on the
     * `Target`.
     * </pre>
     *
     * <code>string rollout_to_roll_back = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for rolloutToRollBack to set.
     * @return This builder for chaining.
     */
    public Builder setRolloutToRollBackBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      rolloutToRollBack_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private com.google.cloud.deploy.v1.RollbackTargetConfig rollbackConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.RollbackTargetConfig,
            com.google.cloud.deploy.v1.RollbackTargetConfig.Builder,
            com.google.cloud.deploy.v1.RollbackTargetConfigOrBuilder>
        rollbackConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Configs for the rollback `Rollout`.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.RollbackTargetConfig rollback_config = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the rollbackConfig field is set.
     */
    public boolean hasRollbackConfig() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Configs for the rollback `Rollout`.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.RollbackTargetConfig rollback_config = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The rollbackConfig.
     */
    public com.google.cloud.deploy.v1.RollbackTargetConfig getRollbackConfig() {
      if (rollbackConfigBuilder_ == null) {
        return rollbackConfig_ == null
            ? com.google.cloud.deploy.v1.RollbackTargetConfig.getDefaultInstance()
            : rollbackConfig_;
      } else {
        return rollbackConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Configs for the rollback `Rollout`.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.RollbackTargetConfig rollback_config = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRollbackConfig(com.google.cloud.deploy.v1.RollbackTargetConfig value) {
      if (rollbackConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        rollbackConfig_ = value;
      } else {
        rollbackConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Configs for the rollback `Rollout`.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.RollbackTargetConfig rollback_config = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRollbackConfig(
        com.google.cloud.deploy.v1.RollbackTargetConfig.Builder builderForValue) {
      if (rollbackConfigBuilder_ == null) {
        rollbackConfig_ = builderForValue.build();
      } else {
        rollbackConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Configs for the rollback `Rollout`.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.RollbackTargetConfig rollback_config = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeRollbackConfig(com.google.cloud.deploy.v1.RollbackTargetConfig value) {
      if (rollbackConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && rollbackConfig_ != null
            && rollbackConfig_
                != com.google.cloud.deploy.v1.RollbackTargetConfig.getDefaultInstance()) {
          getRollbackConfigBuilder().mergeFrom(value);
        } else {
          rollbackConfig_ = value;
        }
      } else {
        rollbackConfigBuilder_.mergeFrom(value);
      }
      if (rollbackConfig_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Configs for the rollback `Rollout`.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.RollbackTargetConfig rollback_config = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearRollbackConfig() {
      bitField0_ = (bitField0_ & ~0x00000020);
      rollbackConfig_ = null;
      if (rollbackConfigBuilder_ != null) {
        rollbackConfigBuilder_.dispose();
        rollbackConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Configs for the rollback `Rollout`.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.RollbackTargetConfig rollback_config = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.deploy.v1.RollbackTargetConfig.Builder getRollbackConfigBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getRollbackConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Configs for the rollback `Rollout`.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.RollbackTargetConfig rollback_config = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.deploy.v1.RollbackTargetConfigOrBuilder getRollbackConfigOrBuilder() {
      if (rollbackConfigBuilder_ != null) {
        return rollbackConfigBuilder_.getMessageOrBuilder();
      } else {
        return rollbackConfig_ == null
            ? com.google.cloud.deploy.v1.RollbackTargetConfig.getDefaultInstance()
            : rollbackConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Configs for the rollback `Rollout`.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.RollbackTargetConfig rollback_config = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.RollbackTargetConfig,
            com.google.cloud.deploy.v1.RollbackTargetConfig.Builder,
            com.google.cloud.deploy.v1.RollbackTargetConfigOrBuilder>
        getRollbackConfigFieldBuilder() {
      if (rollbackConfigBuilder_ == null) {
        rollbackConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.deploy.v1.RollbackTargetConfig,
                com.google.cloud.deploy.v1.RollbackTargetConfig.Builder,
                com.google.cloud.deploy.v1.RollbackTargetConfigOrBuilder>(
                getRollbackConfig(), getParentForChildren(), isClean());
        rollbackConfig_ = null;
      }
      return rollbackConfigBuilder_;
    }

    private boolean validateOnly_;
    /**
     *
     *
     * <pre>
     * Optional. If set to true, the request is validated and the user is provided
     * with a `RollbackTargetResponse`.
     * </pre>
     *
     * <code>bool validate_only = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The validateOnly.
     */
    @java.lang.Override
    public boolean getValidateOnly() {
      return validateOnly_;
    }
    /**
     *
     *
     * <pre>
     * Optional. If set to true, the request is validated and the user is provided
     * with a `RollbackTargetResponse`.
     * </pre>
     *
     * <code>bool validate_only = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The validateOnly to set.
     * @return This builder for chaining.
     */
    public Builder setValidateOnly(boolean value) {

      validateOnly_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If set to true, the request is validated and the user is provided
     * with a `RollbackTargetResponse`.
     * </pre>
     *
     * <code>bool validate_only = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearValidateOnly() {
      bitField0_ = (bitField0_ & ~0x00000040);
      validateOnly_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList overrideDeployPolicy_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureOverrideDeployPolicyIsMutable() {
      if (!overrideDeployPolicy_.isModifiable()) {
        overrideDeployPolicy_ = new com.google.protobuf.LazyStringArrayList(overrideDeployPolicy_);
      }
      bitField0_ |= 0x00000080;
    }
    /**
     *
     *
     * <pre>
     * Optional. Deploy policies to override. Format is
     * `projects/{project}/locations/{location}/deployPolicies/{deploy_policy}`.
     * </pre>
     *
     * <code>
     * repeated string override_deploy_policy = 9 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return A list containing the overrideDeployPolicy.
     */
    public com.google.protobuf.ProtocolStringList getOverrideDeployPolicyList() {
      overrideDeployPolicy_.makeImmutable();
      return overrideDeployPolicy_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Deploy policies to override. Format is
     * `projects/{project}/locations/{location}/deployPolicies/{deploy_policy}`.
     * </pre>
     *
     * <code>
     * repeated string override_deploy_policy = 9 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The count of overrideDeployPolicy.
     */
    public int getOverrideDeployPolicyCount() {
      return overrideDeployPolicy_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Deploy policies to override. Format is
     * `projects/{project}/locations/{location}/deployPolicies/{deploy_policy}`.
     * </pre>
     *
     * <code>
     * repeated string override_deploy_policy = 9 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param index The index of the element to return.
     * @return The overrideDeployPolicy at the given index.
     */
    public java.lang.String getOverrideDeployPolicy(int index) {
      return overrideDeployPolicy_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Deploy policies to override. Format is
     * `projects/{project}/locations/{location}/deployPolicies/{deploy_policy}`.
     * </pre>
     *
     * <code>
     * repeated string override_deploy_policy = 9 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the overrideDeployPolicy at the given index.
     */
    public com.google.protobuf.ByteString getOverrideDeployPolicyBytes(int index) {
      return overrideDeployPolicy_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Deploy policies to override. Format is
     * `projects/{project}/locations/{location}/deployPolicies/{deploy_policy}`.
     * </pre>
     *
     * <code>
     * repeated string override_deploy_policy = 9 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The overrideDeployPolicy to set.
     * @return This builder for chaining.
     */
    public Builder setOverrideDeployPolicy(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureOverrideDeployPolicyIsMutable();
      overrideDeployPolicy_.set(index, value);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Deploy policies to override. Format is
     * `projects/{project}/locations/{location}/deployPolicies/{deploy_policy}`.
     * </pre>
     *
     * <code>
     * repeated string override_deploy_policy = 9 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The overrideDeployPolicy to add.
     * @return This builder for chaining.
     */
    public Builder addOverrideDeployPolicy(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureOverrideDeployPolicyIsMutable();
      overrideDeployPolicy_.add(value);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Deploy policies to override. Format is
     * `projects/{project}/locations/{location}/deployPolicies/{deploy_policy}`.
     * </pre>
     *
     * <code>
     * repeated string override_deploy_policy = 9 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param values The overrideDeployPolicy to add.
     * @return This builder for chaining.
     */
    public Builder addAllOverrideDeployPolicy(java.lang.Iterable<java.lang.String> values) {
      ensureOverrideDeployPolicyIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, overrideDeployPolicy_);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Deploy policies to override. Format is
     * `projects/{project}/locations/{location}/deployPolicies/{deploy_policy}`.
     * </pre>
     *
     * <code>
     * repeated string override_deploy_policy = 9 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOverrideDeployPolicy() {
      overrideDeployPolicy_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000080);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Deploy policies to override. Format is
     * `projects/{project}/locations/{location}/deployPolicies/{deploy_policy}`.
     * </pre>
     *
     * <code>
     * repeated string override_deploy_policy = 9 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes of the overrideDeployPolicy to add.
     * @return This builder for chaining.
     */
    public Builder addOverrideDeployPolicyBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureOverrideDeployPolicyIsMutable();
      overrideDeployPolicy_.add(value);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.deploy.v1.RollbackTargetRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.deploy.v1.RollbackTargetRequest)
  private static final com.google.cloud.deploy.v1.RollbackTargetRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.deploy.v1.RollbackTargetRequest();
  }

  public static com.google.cloud.deploy.v1.RollbackTargetRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RollbackTargetRequest> PARSER =
      new com.google.protobuf.AbstractParser<RollbackTargetRequest>() {
        @java.lang.Override
        public RollbackTargetRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RollbackTargetRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RollbackTargetRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.deploy.v1.RollbackTargetRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
