/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/deploy/v1/cloud_deploy.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.deploy.v1;

/**
 *
 *
 * <pre>
 * Rollout restrictions.
 * </pre>
 *
 * Protobuf type {@code google.cloud.deploy.v1.RolloutRestriction}
 */
public final class RolloutRestriction extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.deploy.v1.RolloutRestriction)
    RolloutRestrictionOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RolloutRestriction.newBuilder() to construct.
  private RolloutRestriction(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RolloutRestriction() {
    id_ = "";
    invokers_ = java.util.Collections.emptyList();
    actions_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RolloutRestriction();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.deploy.v1.CloudDeployProto
        .internal_static_google_cloud_deploy_v1_RolloutRestriction_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.deploy.v1.CloudDeployProto
        .internal_static_google_cloud_deploy_v1_RolloutRestriction_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.deploy.v1.RolloutRestriction.class,
            com.google.cloud.deploy.v1.RolloutRestriction.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Rollout actions to be restricted as part of the policy.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.deploy.v1.RolloutRestriction.RolloutActions}
   */
  public enum RolloutActions implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified.
     * </pre>
     *
     * <code>ROLLOUT_ACTIONS_UNSPECIFIED = 0;</code>
     */
    ROLLOUT_ACTIONS_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Advance the rollout to the next phase.
     * </pre>
     *
     * <code>ADVANCE = 1;</code>
     */
    ADVANCE(1),
    /**
     *
     *
     * <pre>
     * Approve the rollout.
     * </pre>
     *
     * <code>APPROVE = 2;</code>
     */
    APPROVE(2),
    /**
     *
     *
     * <pre>
     * Cancel the rollout.
     * </pre>
     *
     * <code>CANCEL = 3;</code>
     */
    CANCEL(3),
    /**
     *
     *
     * <pre>
     * Create a rollout.
     * </pre>
     *
     * <code>CREATE = 4;</code>
     */
    CREATE(4),
    /**
     *
     *
     * <pre>
     * Ignore a job result on the rollout.
     * </pre>
     *
     * <code>IGNORE_JOB = 5;</code>
     */
    IGNORE_JOB(5),
    /**
     *
     *
     * <pre>
     * Retry a job for a rollout.
     * </pre>
     *
     * <code>RETRY_JOB = 6;</code>
     */
    RETRY_JOB(6),
    /**
     *
     *
     * <pre>
     * Rollback a rollout.
     * </pre>
     *
     * <code>ROLLBACK = 7;</code>
     */
    ROLLBACK(7),
    /**
     *
     *
     * <pre>
     * Terminate a jobrun.
     * </pre>
     *
     * <code>TERMINATE_JOBRUN = 8;</code>
     */
    TERMINATE_JOBRUN(8),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified.
     * </pre>
     *
     * <code>ROLLOUT_ACTIONS_UNSPECIFIED = 0;</code>
     */
    public static final int ROLLOUT_ACTIONS_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Advance the rollout to the next phase.
     * </pre>
     *
     * <code>ADVANCE = 1;</code>
     */
    public static final int ADVANCE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Approve the rollout.
     * </pre>
     *
     * <code>APPROVE = 2;</code>
     */
    public static final int APPROVE_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Cancel the rollout.
     * </pre>
     *
     * <code>CANCEL = 3;</code>
     */
    public static final int CANCEL_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Create a rollout.
     * </pre>
     *
     * <code>CREATE = 4;</code>
     */
    public static final int CREATE_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Ignore a job result on the rollout.
     * </pre>
     *
     * <code>IGNORE_JOB = 5;</code>
     */
    public static final int IGNORE_JOB_VALUE = 5;
    /**
     *
     *
     * <pre>
     * Retry a job for a rollout.
     * </pre>
     *
     * <code>RETRY_JOB = 6;</code>
     */
    public static final int RETRY_JOB_VALUE = 6;
    /**
     *
     *
     * <pre>
     * Rollback a rollout.
     * </pre>
     *
     * <code>ROLLBACK = 7;</code>
     */
    public static final int ROLLBACK_VALUE = 7;
    /**
     *
     *
     * <pre>
     * Terminate a jobrun.
     * </pre>
     *
     * <code>TERMINATE_JOBRUN = 8;</code>
     */
    public static final int TERMINATE_JOBRUN_VALUE = 8;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static RolloutActions valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static RolloutActions forNumber(int value) {
      switch (value) {
        case 0:
          return ROLLOUT_ACTIONS_UNSPECIFIED;
        case 1:
          return ADVANCE;
        case 2:
          return APPROVE;
        case 3:
          return CANCEL;
        case 4:
          return CREATE;
        case 5:
          return IGNORE_JOB;
        case 6:
          return RETRY_JOB;
        case 7:
          return ROLLBACK;
        case 8:
          return TERMINATE_JOBRUN;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<RolloutActions> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<RolloutActions> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<RolloutActions>() {
          public RolloutActions findValueByNumber(int number) {
            return RolloutActions.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.deploy.v1.RolloutRestriction.getDescriptor().getEnumTypes().get(0);
    }

    private static final RolloutActions[] VALUES = values();

    public static RolloutActions valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private RolloutActions(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.deploy.v1.RolloutRestriction.RolloutActions)
  }

  private int bitField0_;
  public static final int ID_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object id_ = "";
  /**
   *
   *
   * <pre>
   * Required. Restriction rule ID. Required and must be unique within a
   * DeployPolicy. The format is `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`.
   * </pre>
   *
   * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public java.lang.String getId() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      id_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Restriction rule ID. Required and must be unique within a
   * DeployPolicy. The format is `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`.
   * </pre>
   *
   * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for id.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIdBytes() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      id_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INVOKERS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<java.lang.Integer> invokers_;

  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.cloud.deploy.v1.DeployPolicy.Invoker>
      invokers_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, com.google.cloud.deploy.v1.DeployPolicy.Invoker>() {
            public com.google.cloud.deploy.v1.DeployPolicy.Invoker convert(java.lang.Integer from) {
              com.google.cloud.deploy.v1.DeployPolicy.Invoker result =
                  com.google.cloud.deploy.v1.DeployPolicy.Invoker.forNumber(from);
              return result == null
                  ? com.google.cloud.deploy.v1.DeployPolicy.Invoker.UNRECOGNIZED
                  : result;
            }
          };
  /**
   *
   *
   * <pre>
   * Optional. What invoked the action. If left empty, all invoker types will be
   * restricted.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.DeployPolicy.Invoker invokers = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return A list containing the invokers.
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.deploy.v1.DeployPolicy.Invoker> getInvokersList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.cloud.deploy.v1.DeployPolicy.Invoker>(
        invokers_, invokers_converter_);
  }
  /**
   *
   *
   * <pre>
   * Optional. What invoked the action. If left empty, all invoker types will be
   * restricted.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.DeployPolicy.Invoker invokers = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The count of invokers.
   */
  @java.lang.Override
  public int getInvokersCount() {
    return invokers_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. What invoked the action. If left empty, all invoker types will be
   * restricted.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.DeployPolicy.Invoker invokers = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The invokers at the given index.
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.DeployPolicy.Invoker getInvokers(int index) {
    return invokers_converter_.convert(invokers_.get(index));
  }
  /**
   *
   *
   * <pre>
   * Optional. What invoked the action. If left empty, all invoker types will be
   * restricted.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.DeployPolicy.Invoker invokers = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return A list containing the enum numeric values on the wire for invokers.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getInvokersValueList() {
    return invokers_;
  }
  /**
   *
   *
   * <pre>
   * Optional. What invoked the action. If left empty, all invoker types will be
   * restricted.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.DeployPolicy.Invoker invokers = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of invokers at the given index.
   */
  @java.lang.Override
  public int getInvokersValue(int index) {
    return invokers_.get(index);
  }

  private int invokersMemoizedSerializedSize;

  public static final int ACTIONS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<java.lang.Integer> actions_;

  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.cloud.deploy.v1.RolloutRestriction.RolloutActions>
      actions_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, com.google.cloud.deploy.v1.RolloutRestriction.RolloutActions>() {
            public com.google.cloud.deploy.v1.RolloutRestriction.RolloutActions convert(
                java.lang.Integer from) {
              com.google.cloud.deploy.v1.RolloutRestriction.RolloutActions result =
                  com.google.cloud.deploy.v1.RolloutRestriction.RolloutActions.forNumber(from);
              return result == null
                  ? com.google.cloud.deploy.v1.RolloutRestriction.RolloutActions.UNRECOGNIZED
                  : result;
            }
          };
  /**
   *
   *
   * <pre>
   * Optional. Rollout actions to be restricted as part of the policy. If left
   * empty, all actions will be restricted.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.RolloutRestriction.RolloutActions actions = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return A list containing the actions.
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.deploy.v1.RolloutRestriction.RolloutActions>
      getActionsList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.cloud.deploy.v1.RolloutRestriction.RolloutActions>(
        actions_, actions_converter_);
  }
  /**
   *
   *
   * <pre>
   * Optional. Rollout actions to be restricted as part of the policy. If left
   * empty, all actions will be restricted.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.RolloutRestriction.RolloutActions actions = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The count of actions.
   */
  @java.lang.Override
  public int getActionsCount() {
    return actions_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Rollout actions to be restricted as part of the policy. If left
   * empty, all actions will be restricted.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.RolloutRestriction.RolloutActions actions = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The actions at the given index.
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.RolloutRestriction.RolloutActions getActions(int index) {
    return actions_converter_.convert(actions_.get(index));
  }
  /**
   *
   *
   * <pre>
   * Optional. Rollout actions to be restricted as part of the policy. If left
   * empty, all actions will be restricted.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.RolloutRestriction.RolloutActions actions = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return A list containing the enum numeric values on the wire for actions.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getActionsValueList() {
    return actions_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Rollout actions to be restricted as part of the policy. If left
   * empty, all actions will be restricted.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.RolloutRestriction.RolloutActions actions = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of actions at the given index.
   */
  @java.lang.Override
  public int getActionsValue(int index) {
    return actions_.get(index);
  }

  private int actionsMemoizedSerializedSize;

  public static final int TIME_WINDOWS_FIELD_NUMBER = 4;
  private com.google.cloud.deploy.v1.TimeWindows timeWindows_;
  /**
   *
   *
   * <pre>
   * Required. Time window within which actions are restricted.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.TimeWindows time_windows = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the timeWindows field is set.
   */
  @java.lang.Override
  public boolean hasTimeWindows() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Required. Time window within which actions are restricted.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.TimeWindows time_windows = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The timeWindows.
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.TimeWindows getTimeWindows() {
    return timeWindows_ == null
        ? com.google.cloud.deploy.v1.TimeWindows.getDefaultInstance()
        : timeWindows_;
  }
  /**
   *
   *
   * <pre>
   * Required. Time window within which actions are restricted.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.TimeWindows time_windows = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.TimeWindowsOrBuilder getTimeWindowsOrBuilder() {
    return timeWindows_ == null
        ? com.google.cloud.deploy.v1.TimeWindows.getDefaultInstance()
        : timeWindows_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, id_);
    }
    if (getInvokersList().size() > 0) {
      output.writeUInt32NoTag(18);
      output.writeUInt32NoTag(invokersMemoizedSerializedSize);
    }
    for (int i = 0; i < invokers_.size(); i++) {
      output.writeEnumNoTag(invokers_.get(i));
    }
    if (getActionsList().size() > 0) {
      output.writeUInt32NoTag(26);
      output.writeUInt32NoTag(actionsMemoizedSerializedSize);
    }
    for (int i = 0; i < actions_.size(); i++) {
      output.writeEnumNoTag(actions_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(4, getTimeWindows());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, id_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < invokers_.size(); i++) {
        dataSize += com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(invokers_.get(i));
      }
      size += dataSize;
      if (!getInvokersList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      invokersMemoizedSerializedSize = dataSize;
    }
    {
      int dataSize = 0;
      for (int i = 0; i < actions_.size(); i++) {
        dataSize += com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(actions_.get(i));
      }
      size += dataSize;
      if (!getActionsList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      actionsMemoizedSerializedSize = dataSize;
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getTimeWindows());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.deploy.v1.RolloutRestriction)) {
      return super.equals(obj);
    }
    com.google.cloud.deploy.v1.RolloutRestriction other =
        (com.google.cloud.deploy.v1.RolloutRestriction) obj;

    if (!getId().equals(other.getId())) return false;
    if (!invokers_.equals(other.invokers_)) return false;
    if (!actions_.equals(other.actions_)) return false;
    if (hasTimeWindows() != other.hasTimeWindows()) return false;
    if (hasTimeWindows()) {
      if (!getTimeWindows().equals(other.getTimeWindows())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ID_FIELD_NUMBER;
    hash = (53 * hash) + getId().hashCode();
    if (getInvokersCount() > 0) {
      hash = (37 * hash) + INVOKERS_FIELD_NUMBER;
      hash = (53 * hash) + invokers_.hashCode();
    }
    if (getActionsCount() > 0) {
      hash = (37 * hash) + ACTIONS_FIELD_NUMBER;
      hash = (53 * hash) + actions_.hashCode();
    }
    if (hasTimeWindows()) {
      hash = (37 * hash) + TIME_WINDOWS_FIELD_NUMBER;
      hash = (53 * hash) + getTimeWindows().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.deploy.v1.RolloutRestriction parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.RolloutRestriction parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.RolloutRestriction parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.RolloutRestriction parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.RolloutRestriction parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.RolloutRestriction parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.RolloutRestriction parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.RolloutRestriction parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.RolloutRestriction parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.RolloutRestriction parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.RolloutRestriction parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.RolloutRestriction parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.deploy.v1.RolloutRestriction prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Rollout restrictions.
   * </pre>
   *
   * Protobuf type {@code google.cloud.deploy.v1.RolloutRestriction}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.deploy.v1.RolloutRestriction)
      com.google.cloud.deploy.v1.RolloutRestrictionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_RolloutRestriction_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_RolloutRestriction_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.deploy.v1.RolloutRestriction.class,
              com.google.cloud.deploy.v1.RolloutRestriction.Builder.class);
    }

    // Construct using com.google.cloud.deploy.v1.RolloutRestriction.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getTimeWindowsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      id_ = "";
      invokers_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      actions_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      timeWindows_ = null;
      if (timeWindowsBuilder_ != null) {
        timeWindowsBuilder_.dispose();
        timeWindowsBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_RolloutRestriction_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.RolloutRestriction getDefaultInstanceForType() {
      return com.google.cloud.deploy.v1.RolloutRestriction.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.RolloutRestriction build() {
      com.google.cloud.deploy.v1.RolloutRestriction result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.RolloutRestriction buildPartial() {
      com.google.cloud.deploy.v1.RolloutRestriction result =
          new com.google.cloud.deploy.v1.RolloutRestriction(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.deploy.v1.RolloutRestriction result) {
      if (((bitField0_ & 0x00000002) != 0)) {
        invokers_ = java.util.Collections.unmodifiableList(invokers_);
        bitField0_ = (bitField0_ & ~0x00000002);
      }
      result.invokers_ = invokers_;
      if (((bitField0_ & 0x00000004) != 0)) {
        actions_ = java.util.Collections.unmodifiableList(actions_);
        bitField0_ = (bitField0_ & ~0x00000004);
      }
      result.actions_ = actions_;
    }

    private void buildPartial0(com.google.cloud.deploy.v1.RolloutRestriction result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.id_ = id_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.timeWindows_ =
            timeWindowsBuilder_ == null ? timeWindows_ : timeWindowsBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.deploy.v1.RolloutRestriction) {
        return mergeFrom((com.google.cloud.deploy.v1.RolloutRestriction) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.deploy.v1.RolloutRestriction other) {
      if (other == com.google.cloud.deploy.v1.RolloutRestriction.getDefaultInstance()) return this;
      if (!other.getId().isEmpty()) {
        id_ = other.id_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.invokers_.isEmpty()) {
        if (invokers_.isEmpty()) {
          invokers_ = other.invokers_;
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          ensureInvokersIsMutable();
          invokers_.addAll(other.invokers_);
        }
        onChanged();
      }
      if (!other.actions_.isEmpty()) {
        if (actions_.isEmpty()) {
          actions_ = other.actions_;
          bitField0_ = (bitField0_ & ~0x00000004);
        } else {
          ensureActionsIsMutable();
          actions_.addAll(other.actions_);
        }
        onChanged();
      }
      if (other.hasTimeWindows()) {
        mergeTimeWindows(other.getTimeWindows());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                id_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                int tmpRaw = input.readEnum();
                ensureInvokersIsMutable();
                invokers_.add(tmpRaw);
                break;
              } // case 16
            case 18:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensureInvokersIsMutable();
                  invokers_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 18
            case 24:
              {
                int tmpRaw = input.readEnum();
                ensureActionsIsMutable();
                actions_.add(tmpRaw);
                break;
              } // case 24
            case 26:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensureActionsIsMutable();
                  actions_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getTimeWindowsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object id_ = "";
    /**
     *
     *
     * <pre>
     * Required. Restriction rule ID. Required and must be unique within a
     * DeployPolicy. The format is `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The id.
     */
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Restriction rule ID. Required and must be unique within a
     * DeployPolicy. The format is `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for id.
     */
    public com.google.protobuf.ByteString getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Restriction rule ID. Required and must be unique within a
     * DeployPolicy. The format is `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      id_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Restriction rule ID. Required and must be unique within a
     * DeployPolicy. The format is `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {
      id_ = getDefaultInstance().getId();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Restriction rule ID. Required and must be unique within a
     * DeployPolicy. The format is `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for id to set.
     * @return This builder for chaining.
     */
    public Builder setIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      id_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.util.List<java.lang.Integer> invokers_ = java.util.Collections.emptyList();

    private void ensureInvokersIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        invokers_ = new java.util.ArrayList<java.lang.Integer>(invokers_);
        bitField0_ |= 0x00000002;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. What invoked the action. If left empty, all invoker types will be
     * restricted.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.DeployPolicy.Invoker invokers = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return A list containing the invokers.
     */
    public java.util.List<com.google.cloud.deploy.v1.DeployPolicy.Invoker> getInvokersList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.cloud.deploy.v1.DeployPolicy.Invoker>(
          invokers_, invokers_converter_);
    }
    /**
     *
     *
     * <pre>
     * Optional. What invoked the action. If left empty, all invoker types will be
     * restricted.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.DeployPolicy.Invoker invokers = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The count of invokers.
     */
    public int getInvokersCount() {
      return invokers_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. What invoked the action. If left empty, all invoker types will be
     * restricted.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.DeployPolicy.Invoker invokers = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The invokers at the given index.
     */
    public com.google.cloud.deploy.v1.DeployPolicy.Invoker getInvokers(int index) {
      return invokers_converter_.convert(invokers_.get(index));
    }
    /**
     *
     *
     * <pre>
     * Optional. What invoked the action. If left empty, all invoker types will be
     * restricted.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.DeployPolicy.Invoker invokers = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The invokers to set.
     * @return This builder for chaining.
     */
    public Builder setInvokers(int index, com.google.cloud.deploy.v1.DeployPolicy.Invoker value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureInvokersIsMutable();
      invokers_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. What invoked the action. If left empty, all invoker types will be
     * restricted.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.DeployPolicy.Invoker invokers = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The invokers to add.
     * @return This builder for chaining.
     */
    public Builder addInvokers(com.google.cloud.deploy.v1.DeployPolicy.Invoker value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureInvokersIsMutable();
      invokers_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. What invoked the action. If left empty, all invoker types will be
     * restricted.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.DeployPolicy.Invoker invokers = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param values The invokers to add.
     * @return This builder for chaining.
     */
    public Builder addAllInvokers(
        java.lang.Iterable<? extends com.google.cloud.deploy.v1.DeployPolicy.Invoker> values) {
      ensureInvokersIsMutable();
      for (com.google.cloud.deploy.v1.DeployPolicy.Invoker value : values) {
        invokers_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. What invoked the action. If left empty, all invoker types will be
     * restricted.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.DeployPolicy.Invoker invokers = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInvokers() {
      invokers_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. What invoked the action. If left empty, all invoker types will be
     * restricted.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.DeployPolicy.Invoker invokers = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return A list containing the enum numeric values on the wire for invokers.
     */
    public java.util.List<java.lang.Integer> getInvokersValueList() {
      return java.util.Collections.unmodifiableList(invokers_);
    }
    /**
     *
     *
     * <pre>
     * Optional. What invoked the action. If left empty, all invoker types will be
     * restricted.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.DeployPolicy.Invoker invokers = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of invokers at the given index.
     */
    public int getInvokersValue(int index) {
      return invokers_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. What invoked the action. If left empty, all invoker types will be
     * restricted.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.DeployPolicy.Invoker invokers = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for invokers to set.
     * @return This builder for chaining.
     */
    public Builder setInvokersValue(int index, int value) {
      ensureInvokersIsMutable();
      invokers_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. What invoked the action. If left empty, all invoker types will be
     * restricted.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.DeployPolicy.Invoker invokers = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for invokers to add.
     * @return This builder for chaining.
     */
    public Builder addInvokersValue(int value) {
      ensureInvokersIsMutable();
      invokers_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. What invoked the action. If left empty, all invoker types will be
     * restricted.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.DeployPolicy.Invoker invokers = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param values The enum numeric values on the wire for invokers to add.
     * @return This builder for chaining.
     */
    public Builder addAllInvokersValue(java.lang.Iterable<java.lang.Integer> values) {
      ensureInvokersIsMutable();
      for (int value : values) {
        invokers_.add(value);
      }
      onChanged();
      return this;
    }

    private java.util.List<java.lang.Integer> actions_ = java.util.Collections.emptyList();

    private void ensureActionsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        actions_ = new java.util.ArrayList<java.lang.Integer>(actions_);
        bitField0_ |= 0x00000004;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Rollout actions to be restricted as part of the policy. If left
     * empty, all actions will be restricted.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.RolloutRestriction.RolloutActions actions = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return A list containing the actions.
     */
    public java.util.List<com.google.cloud.deploy.v1.RolloutRestriction.RolloutActions>
        getActionsList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.cloud.deploy.v1.RolloutRestriction.RolloutActions>(
          actions_, actions_converter_);
    }
    /**
     *
     *
     * <pre>
     * Optional. Rollout actions to be restricted as part of the policy. If left
     * empty, all actions will be restricted.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.RolloutRestriction.RolloutActions actions = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The count of actions.
     */
    public int getActionsCount() {
      return actions_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Rollout actions to be restricted as part of the policy. If left
     * empty, all actions will be restricted.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.RolloutRestriction.RolloutActions actions = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The actions at the given index.
     */
    public com.google.cloud.deploy.v1.RolloutRestriction.RolloutActions getActions(int index) {
      return actions_converter_.convert(actions_.get(index));
    }
    /**
     *
     *
     * <pre>
     * Optional. Rollout actions to be restricted as part of the policy. If left
     * empty, all actions will be restricted.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.RolloutRestriction.RolloutActions actions = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The actions to set.
     * @return This builder for chaining.
     */
    public Builder setActions(
        int index, com.google.cloud.deploy.v1.RolloutRestriction.RolloutActions value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureActionsIsMutable();
      actions_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rollout actions to be restricted as part of the policy. If left
     * empty, all actions will be restricted.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.RolloutRestriction.RolloutActions actions = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The actions to add.
     * @return This builder for chaining.
     */
    public Builder addActions(com.google.cloud.deploy.v1.RolloutRestriction.RolloutActions value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureActionsIsMutable();
      actions_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rollout actions to be restricted as part of the policy. If left
     * empty, all actions will be restricted.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.RolloutRestriction.RolloutActions actions = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param values The actions to add.
     * @return This builder for chaining.
     */
    public Builder addAllActions(
        java.lang.Iterable<? extends com.google.cloud.deploy.v1.RolloutRestriction.RolloutActions>
            values) {
      ensureActionsIsMutable();
      for (com.google.cloud.deploy.v1.RolloutRestriction.RolloutActions value : values) {
        actions_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rollout actions to be restricted as part of the policy. If left
     * empty, all actions will be restricted.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.RolloutRestriction.RolloutActions actions = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearActions() {
      actions_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rollout actions to be restricted as part of the policy. If left
     * empty, all actions will be restricted.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.RolloutRestriction.RolloutActions actions = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return A list containing the enum numeric values on the wire for actions.
     */
    public java.util.List<java.lang.Integer> getActionsValueList() {
      return java.util.Collections.unmodifiableList(actions_);
    }
    /**
     *
     *
     * <pre>
     * Optional. Rollout actions to be restricted as part of the policy. If left
     * empty, all actions will be restricted.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.RolloutRestriction.RolloutActions actions = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of actions at the given index.
     */
    public int getActionsValue(int index) {
      return actions_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Rollout actions to be restricted as part of the policy. If left
     * empty, all actions will be restricted.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.RolloutRestriction.RolloutActions actions = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for actions to set.
     * @return This builder for chaining.
     */
    public Builder setActionsValue(int index, int value) {
      ensureActionsIsMutable();
      actions_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rollout actions to be restricted as part of the policy. If left
     * empty, all actions will be restricted.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.RolloutRestriction.RolloutActions actions = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for actions to add.
     * @return This builder for chaining.
     */
    public Builder addActionsValue(int value) {
      ensureActionsIsMutable();
      actions_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rollout actions to be restricted as part of the policy. If left
     * empty, all actions will be restricted.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.RolloutRestriction.RolloutActions actions = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param values The enum numeric values on the wire for actions to add.
     * @return This builder for chaining.
     */
    public Builder addAllActionsValue(java.lang.Iterable<java.lang.Integer> values) {
      ensureActionsIsMutable();
      for (int value : values) {
        actions_.add(value);
      }
      onChanged();
      return this;
    }

    private com.google.cloud.deploy.v1.TimeWindows timeWindows_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.TimeWindows,
            com.google.cloud.deploy.v1.TimeWindows.Builder,
            com.google.cloud.deploy.v1.TimeWindowsOrBuilder>
        timeWindowsBuilder_;
    /**
     *
     *
     * <pre>
     * Required. Time window within which actions are restricted.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.TimeWindows time_windows = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the timeWindows field is set.
     */
    public boolean hasTimeWindows() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. Time window within which actions are restricted.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.TimeWindows time_windows = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The timeWindows.
     */
    public com.google.cloud.deploy.v1.TimeWindows getTimeWindows() {
      if (timeWindowsBuilder_ == null) {
        return timeWindows_ == null
            ? com.google.cloud.deploy.v1.TimeWindows.getDefaultInstance()
            : timeWindows_;
      } else {
        return timeWindowsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Time window within which actions are restricted.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.TimeWindows time_windows = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setTimeWindows(com.google.cloud.deploy.v1.TimeWindows value) {
      if (timeWindowsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        timeWindows_ = value;
      } else {
        timeWindowsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Time window within which actions are restricted.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.TimeWindows time_windows = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setTimeWindows(com.google.cloud.deploy.v1.TimeWindows.Builder builderForValue) {
      if (timeWindowsBuilder_ == null) {
        timeWindows_ = builderForValue.build();
      } else {
        timeWindowsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Time window within which actions are restricted.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.TimeWindows time_windows = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeTimeWindows(com.google.cloud.deploy.v1.TimeWindows value) {
      if (timeWindowsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && timeWindows_ != null
            && timeWindows_ != com.google.cloud.deploy.v1.TimeWindows.getDefaultInstance()) {
          getTimeWindowsBuilder().mergeFrom(value);
        } else {
          timeWindows_ = value;
        }
      } else {
        timeWindowsBuilder_.mergeFrom(value);
      }
      if (timeWindows_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Time window within which actions are restricted.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.TimeWindows time_windows = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearTimeWindows() {
      bitField0_ = (bitField0_ & ~0x00000008);
      timeWindows_ = null;
      if (timeWindowsBuilder_ != null) {
        timeWindowsBuilder_.dispose();
        timeWindowsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Time window within which actions are restricted.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.TimeWindows time_windows = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.deploy.v1.TimeWindows.Builder getTimeWindowsBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getTimeWindowsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. Time window within which actions are restricted.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.TimeWindows time_windows = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.deploy.v1.TimeWindowsOrBuilder getTimeWindowsOrBuilder() {
      if (timeWindowsBuilder_ != null) {
        return timeWindowsBuilder_.getMessageOrBuilder();
      } else {
        return timeWindows_ == null
            ? com.google.cloud.deploy.v1.TimeWindows.getDefaultInstance()
            : timeWindows_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Time window within which actions are restricted.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.TimeWindows time_windows = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.TimeWindows,
            com.google.cloud.deploy.v1.TimeWindows.Builder,
            com.google.cloud.deploy.v1.TimeWindowsOrBuilder>
        getTimeWindowsFieldBuilder() {
      if (timeWindowsBuilder_ == null) {
        timeWindowsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.deploy.v1.TimeWindows,
                com.google.cloud.deploy.v1.TimeWindows.Builder,
                com.google.cloud.deploy.v1.TimeWindowsOrBuilder>(
                getTimeWindows(), getParentForChildren(), isClean());
        timeWindows_ = null;
      }
      return timeWindowsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.deploy.v1.RolloutRestriction)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.deploy.v1.RolloutRestriction)
  private static final com.google.cloud.deploy.v1.RolloutRestriction DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.deploy.v1.RolloutRestriction();
  }

  public static com.google.cloud.deploy.v1.RolloutRestriction getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RolloutRestriction> PARSER =
      new com.google.protobuf.AbstractParser<RolloutRestriction>() {
        @java.lang.Override
        public RolloutRestriction parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RolloutRestriction> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RolloutRestriction> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.deploy.v1.RolloutRestriction getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
