/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/deploy/v1/rollout_update_payload.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.deploy.v1;

/**
 *
 *
 * <pre>
 * Payload proto for "clouddeploy.googleapis.com/rollout_update"
 * Platform Log event that describes the rollout update event.
 * </pre>
 *
 * Protobuf type {@code google.cloud.deploy.v1.RolloutUpdateEvent}
 */
public final class RolloutUpdateEvent extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.deploy.v1.RolloutUpdateEvent)
    RolloutUpdateEventOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RolloutUpdateEvent.newBuilder() to construct.
  private RolloutUpdateEvent(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RolloutUpdateEvent() {
    message_ = "";
    pipelineUid_ = "";
    releaseUid_ = "";
    release_ = "";
    rollout_ = "";
    targetId_ = "";
    type_ = 0;
    rolloutUpdateType_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RolloutUpdateEvent();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.deploy.v1.RolloutUpdatePayloadProto
        .internal_static_google_cloud_deploy_v1_RolloutUpdateEvent_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.deploy.v1.RolloutUpdatePayloadProto
        .internal_static_google_cloud_deploy_v1_RolloutUpdateEvent_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.deploy.v1.RolloutUpdateEvent.class,
            com.google.cloud.deploy.v1.RolloutUpdateEvent.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * RolloutUpdateType indicates the type of the rollout update.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.deploy.v1.RolloutUpdateEvent.RolloutUpdateType}
   */
  public enum RolloutUpdateType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Rollout update type unspecified.
     * </pre>
     *
     * <code>ROLLOUT_UPDATE_TYPE_UNSPECIFIED = 0;</code>
     */
    ROLLOUT_UPDATE_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * rollout state updated to pending.
     * </pre>
     *
     * <code>PENDING = 1;</code>
     */
    PENDING(1),
    /**
     *
     *
     * <pre>
     * Rollout state updated to pending release.
     * </pre>
     *
     * <code>PENDING_RELEASE = 2;</code>
     */
    PENDING_RELEASE(2),
    /**
     *
     *
     * <pre>
     * Rollout state updated to in progress.
     * </pre>
     *
     * <code>IN_PROGRESS = 3;</code>
     */
    IN_PROGRESS(3),
    /**
     *
     *
     * <pre>
     * Rollout state updated to cancelling.
     * </pre>
     *
     * <code>CANCELLING = 4;</code>
     */
    CANCELLING(4),
    /**
     *
     *
     * <pre>
     * Rollout state updated to cancelled.
     * </pre>
     *
     * <code>CANCELLED = 5;</code>
     */
    CANCELLED(5),
    /**
     *
     *
     * <pre>
     * Rollout state updated to halted.
     * </pre>
     *
     * <code>HALTED = 6;</code>
     */
    HALTED(6),
    /**
     *
     *
     * <pre>
     * Rollout state updated to succeeded.
     * </pre>
     *
     * <code>SUCCEEDED = 7;</code>
     */
    SUCCEEDED(7),
    /**
     *
     *
     * <pre>
     * Rollout state updated to failed.
     * </pre>
     *
     * <code>FAILED = 8;</code>
     */
    FAILED(8),
    /**
     *
     *
     * <pre>
     * Rollout requires approval.
     * </pre>
     *
     * <code>APPROVAL_REQUIRED = 9;</code>
     */
    APPROVAL_REQUIRED(9),
    /**
     *
     *
     * <pre>
     * Rollout has been approved.
     * </pre>
     *
     * <code>APPROVED = 10;</code>
     */
    APPROVED(10),
    /**
     *
     *
     * <pre>
     * Rollout has been rejected.
     * </pre>
     *
     * <code>REJECTED = 11;</code>
     */
    REJECTED(11),
    /**
     *
     *
     * <pre>
     * Rollout requires advance to the next phase.
     * </pre>
     *
     * <code>ADVANCE_REQUIRED = 12;</code>
     */
    ADVANCE_REQUIRED(12),
    /**
     *
     *
     * <pre>
     * Rollout has been advanced.
     * </pre>
     *
     * <code>ADVANCED = 13;</code>
     */
    ADVANCED(13),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Rollout update type unspecified.
     * </pre>
     *
     * <code>ROLLOUT_UPDATE_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int ROLLOUT_UPDATE_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * rollout state updated to pending.
     * </pre>
     *
     * <code>PENDING = 1;</code>
     */
    public static final int PENDING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Rollout state updated to pending release.
     * </pre>
     *
     * <code>PENDING_RELEASE = 2;</code>
     */
    public static final int PENDING_RELEASE_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Rollout state updated to in progress.
     * </pre>
     *
     * <code>IN_PROGRESS = 3;</code>
     */
    public static final int IN_PROGRESS_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Rollout state updated to cancelling.
     * </pre>
     *
     * <code>CANCELLING = 4;</code>
     */
    public static final int CANCELLING_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Rollout state updated to cancelled.
     * </pre>
     *
     * <code>CANCELLED = 5;</code>
     */
    public static final int CANCELLED_VALUE = 5;
    /**
     *
     *
     * <pre>
     * Rollout state updated to halted.
     * </pre>
     *
     * <code>HALTED = 6;</code>
     */
    public static final int HALTED_VALUE = 6;
    /**
     *
     *
     * <pre>
     * Rollout state updated to succeeded.
     * </pre>
     *
     * <code>SUCCEEDED = 7;</code>
     */
    public static final int SUCCEEDED_VALUE = 7;
    /**
     *
     *
     * <pre>
     * Rollout state updated to failed.
     * </pre>
     *
     * <code>FAILED = 8;</code>
     */
    public static final int FAILED_VALUE = 8;
    /**
     *
     *
     * <pre>
     * Rollout requires approval.
     * </pre>
     *
     * <code>APPROVAL_REQUIRED = 9;</code>
     */
    public static final int APPROVAL_REQUIRED_VALUE = 9;
    /**
     *
     *
     * <pre>
     * Rollout has been approved.
     * </pre>
     *
     * <code>APPROVED = 10;</code>
     */
    public static final int APPROVED_VALUE = 10;
    /**
     *
     *
     * <pre>
     * Rollout has been rejected.
     * </pre>
     *
     * <code>REJECTED = 11;</code>
     */
    public static final int REJECTED_VALUE = 11;
    /**
     *
     *
     * <pre>
     * Rollout requires advance to the next phase.
     * </pre>
     *
     * <code>ADVANCE_REQUIRED = 12;</code>
     */
    public static final int ADVANCE_REQUIRED_VALUE = 12;
    /**
     *
     *
     * <pre>
     * Rollout has been advanced.
     * </pre>
     *
     * <code>ADVANCED = 13;</code>
     */
    public static final int ADVANCED_VALUE = 13;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static RolloutUpdateType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static RolloutUpdateType forNumber(int value) {
      switch (value) {
        case 0:
          return ROLLOUT_UPDATE_TYPE_UNSPECIFIED;
        case 1:
          return PENDING;
        case 2:
          return PENDING_RELEASE;
        case 3:
          return IN_PROGRESS;
        case 4:
          return CANCELLING;
        case 5:
          return CANCELLED;
        case 6:
          return HALTED;
        case 7:
          return SUCCEEDED;
        case 8:
          return FAILED;
        case 9:
          return APPROVAL_REQUIRED;
        case 10:
          return APPROVED;
        case 11:
          return REJECTED;
        case 12:
          return ADVANCE_REQUIRED;
        case 13:
          return ADVANCED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<RolloutUpdateType>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<RolloutUpdateType>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<RolloutUpdateType>() {
              public RolloutUpdateType findValueByNumber(int number) {
                return RolloutUpdateType.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.deploy.v1.RolloutUpdateEvent.getDescriptor().getEnumTypes().get(0);
    }

    private static final RolloutUpdateType[] VALUES = values();

    public static RolloutUpdateType valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private RolloutUpdateType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.deploy.v1.RolloutUpdateEvent.RolloutUpdateType)
  }

  public static final int MESSAGE_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object message_ = "";
  /**
   *
   *
   * <pre>
   * Debug message for when a rollout update event occurs.
   * </pre>
   *
   * <code>string message = 6;</code>
   *
   * @return The message.
   */
  @java.lang.Override
  public java.lang.String getMessage() {
    java.lang.Object ref = message_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      message_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Debug message for when a rollout update event occurs.
   * </pre>
   *
   * <code>string message = 6;</code>
   *
   * @return The bytes for message.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMessageBytes() {
    java.lang.Object ref = message_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      message_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PIPELINE_UID_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object pipelineUid_ = "";
  /**
   *
   *
   * <pre>
   * Unique identifier of the pipeline.
   * </pre>
   *
   * <code>string pipeline_uid = 1;</code>
   *
   * @return The pipelineUid.
   */
  @java.lang.Override
  public java.lang.String getPipelineUid() {
    java.lang.Object ref = pipelineUid_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      pipelineUid_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Unique identifier of the pipeline.
   * </pre>
   *
   * <code>string pipeline_uid = 1;</code>
   *
   * @return The bytes for pipelineUid.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPipelineUidBytes() {
    java.lang.Object ref = pipelineUid_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      pipelineUid_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RELEASE_UID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object releaseUid_ = "";
  /**
   *
   *
   * <pre>
   * Unique identifier of the release.
   * </pre>
   *
   * <code>string release_uid = 2;</code>
   *
   * @return The releaseUid.
   */
  @java.lang.Override
  public java.lang.String getReleaseUid() {
    java.lang.Object ref = releaseUid_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      releaseUid_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Unique identifier of the release.
   * </pre>
   *
   * <code>string release_uid = 2;</code>
   *
   * @return The bytes for releaseUid.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getReleaseUidBytes() {
    java.lang.Object ref = releaseUid_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      releaseUid_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RELEASE_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object release_ = "";
  /**
   *
   *
   * <pre>
   * The name of the `Release`.
   * </pre>
   *
   * <code>string release = 8;</code>
   *
   * @return The release.
   */
  @java.lang.Override
  public java.lang.String getRelease() {
    java.lang.Object ref = release_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      release_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of the `Release`.
   * </pre>
   *
   * <code>string release = 8;</code>
   *
   * @return The bytes for release.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getReleaseBytes() {
    java.lang.Object ref = release_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      release_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ROLLOUT_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object rollout_ = "";
  /**
   *
   *
   * <pre>
   * The name of the rollout.
   * rollout_uid is not in this log message because we write some of these log
   * messages at rollout creation time, before we've generated the uid.
   * </pre>
   *
   * <code>string rollout = 3;</code>
   *
   * @return The rollout.
   */
  @java.lang.Override
  public java.lang.String getRollout() {
    java.lang.Object ref = rollout_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      rollout_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of the rollout.
   * rollout_uid is not in this log message because we write some of these log
   * messages at rollout creation time, before we've generated the uid.
   * </pre>
   *
   * <code>string rollout = 3;</code>
   *
   * @return The bytes for rollout.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRolloutBytes() {
    java.lang.Object ref = rollout_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      rollout_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TARGET_ID_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object targetId_ = "";
  /**
   *
   *
   * <pre>
   * ID of the target.
   * </pre>
   *
   * <code>string target_id = 4;</code>
   *
   * @return The targetId.
   */
  @java.lang.Override
  public java.lang.String getTargetId() {
    java.lang.Object ref = targetId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      targetId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * ID of the target.
   * </pre>
   *
   * <code>string target_id = 4;</code>
   *
   * @return The bytes for targetId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTargetIdBytes() {
    java.lang.Object ref = targetId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      targetId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TYPE_FIELD_NUMBER = 7;
  private int type_ = 0;
  /**
   *
   *
   * <pre>
   * Type of this notification, e.g. for a rollout update event.
   * </pre>
   *
   * <code>.google.cloud.deploy.v1.Type type = 7;</code>
   *
   * @return The enum numeric value on the wire for type.
   */
  @java.lang.Override
  public int getTypeValue() {
    return type_;
  }
  /**
   *
   *
   * <pre>
   * Type of this notification, e.g. for a rollout update event.
   * </pre>
   *
   * <code>.google.cloud.deploy.v1.Type type = 7;</code>
   *
   * @return The type.
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.Type getType() {
    com.google.cloud.deploy.v1.Type result = com.google.cloud.deploy.v1.Type.forNumber(type_);
    return result == null ? com.google.cloud.deploy.v1.Type.UNRECOGNIZED : result;
  }

  public static final int ROLLOUT_UPDATE_TYPE_FIELD_NUMBER = 5;
  private int rolloutUpdateType_ = 0;
  /**
   *
   *
   * <pre>
   * The type of the rollout update.
   * </pre>
   *
   * <code>.google.cloud.deploy.v1.RolloutUpdateEvent.RolloutUpdateType rollout_update_type = 5;
   * </code>
   *
   * @return The enum numeric value on the wire for rolloutUpdateType.
   */
  @java.lang.Override
  public int getRolloutUpdateTypeValue() {
    return rolloutUpdateType_;
  }
  /**
   *
   *
   * <pre>
   * The type of the rollout update.
   * </pre>
   *
   * <code>.google.cloud.deploy.v1.RolloutUpdateEvent.RolloutUpdateType rollout_update_type = 5;
   * </code>
   *
   * @return The rolloutUpdateType.
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.RolloutUpdateEvent.RolloutUpdateType getRolloutUpdateType() {
    com.google.cloud.deploy.v1.RolloutUpdateEvent.RolloutUpdateType result =
        com.google.cloud.deploy.v1.RolloutUpdateEvent.RolloutUpdateType.forNumber(
            rolloutUpdateType_);
    return result == null
        ? com.google.cloud.deploy.v1.RolloutUpdateEvent.RolloutUpdateType.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pipelineUid_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, pipelineUid_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(releaseUid_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, releaseUid_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(rollout_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, rollout_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(targetId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, targetId_);
    }
    if (rolloutUpdateType_
        != com.google.cloud.deploy.v1.RolloutUpdateEvent.RolloutUpdateType
            .ROLLOUT_UPDATE_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(5, rolloutUpdateType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(message_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, message_);
    }
    if (type_ != com.google.cloud.deploy.v1.Type.TYPE_UNSPECIFIED.getNumber()) {
      output.writeEnum(7, type_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(release_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, release_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pipelineUid_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, pipelineUid_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(releaseUid_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, releaseUid_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(rollout_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, rollout_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(targetId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, targetId_);
    }
    if (rolloutUpdateType_
        != com.google.cloud.deploy.v1.RolloutUpdateEvent.RolloutUpdateType
            .ROLLOUT_UPDATE_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, rolloutUpdateType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(message_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, message_);
    }
    if (type_ != com.google.cloud.deploy.v1.Type.TYPE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(7, type_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(release_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, release_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.deploy.v1.RolloutUpdateEvent)) {
      return super.equals(obj);
    }
    com.google.cloud.deploy.v1.RolloutUpdateEvent other =
        (com.google.cloud.deploy.v1.RolloutUpdateEvent) obj;

    if (!getMessage().equals(other.getMessage())) return false;
    if (!getPipelineUid().equals(other.getPipelineUid())) return false;
    if (!getReleaseUid().equals(other.getReleaseUid())) return false;
    if (!getRelease().equals(other.getRelease())) return false;
    if (!getRollout().equals(other.getRollout())) return false;
    if (!getTargetId().equals(other.getTargetId())) return false;
    if (type_ != other.type_) return false;
    if (rolloutUpdateType_ != other.rolloutUpdateType_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + MESSAGE_FIELD_NUMBER;
    hash = (53 * hash) + getMessage().hashCode();
    hash = (37 * hash) + PIPELINE_UID_FIELD_NUMBER;
    hash = (53 * hash) + getPipelineUid().hashCode();
    hash = (37 * hash) + RELEASE_UID_FIELD_NUMBER;
    hash = (53 * hash) + getReleaseUid().hashCode();
    hash = (37 * hash) + RELEASE_FIELD_NUMBER;
    hash = (53 * hash) + getRelease().hashCode();
    hash = (37 * hash) + ROLLOUT_FIELD_NUMBER;
    hash = (53 * hash) + getRollout().hashCode();
    hash = (37 * hash) + TARGET_ID_FIELD_NUMBER;
    hash = (53 * hash) + getTargetId().hashCode();
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + type_;
    hash = (37 * hash) + ROLLOUT_UPDATE_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + rolloutUpdateType_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.deploy.v1.RolloutUpdateEvent parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.RolloutUpdateEvent parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.RolloutUpdateEvent parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.RolloutUpdateEvent parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.RolloutUpdateEvent parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.RolloutUpdateEvent parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.RolloutUpdateEvent parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.RolloutUpdateEvent parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.RolloutUpdateEvent parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.RolloutUpdateEvent parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.RolloutUpdateEvent parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.RolloutUpdateEvent parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.deploy.v1.RolloutUpdateEvent prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Payload proto for "clouddeploy.googleapis.com/rollout_update"
   * Platform Log event that describes the rollout update event.
   * </pre>
   *
   * Protobuf type {@code google.cloud.deploy.v1.RolloutUpdateEvent}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.deploy.v1.RolloutUpdateEvent)
      com.google.cloud.deploy.v1.RolloutUpdateEventOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.deploy.v1.RolloutUpdatePayloadProto
          .internal_static_google_cloud_deploy_v1_RolloutUpdateEvent_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.deploy.v1.RolloutUpdatePayloadProto
          .internal_static_google_cloud_deploy_v1_RolloutUpdateEvent_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.deploy.v1.RolloutUpdateEvent.class,
              com.google.cloud.deploy.v1.RolloutUpdateEvent.Builder.class);
    }

    // Construct using com.google.cloud.deploy.v1.RolloutUpdateEvent.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      message_ = "";
      pipelineUid_ = "";
      releaseUid_ = "";
      release_ = "";
      rollout_ = "";
      targetId_ = "";
      type_ = 0;
      rolloutUpdateType_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.deploy.v1.RolloutUpdatePayloadProto
          .internal_static_google_cloud_deploy_v1_RolloutUpdateEvent_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.RolloutUpdateEvent getDefaultInstanceForType() {
      return com.google.cloud.deploy.v1.RolloutUpdateEvent.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.RolloutUpdateEvent build() {
      com.google.cloud.deploy.v1.RolloutUpdateEvent result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.RolloutUpdateEvent buildPartial() {
      com.google.cloud.deploy.v1.RolloutUpdateEvent result =
          new com.google.cloud.deploy.v1.RolloutUpdateEvent(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.deploy.v1.RolloutUpdateEvent result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.message_ = message_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.pipelineUid_ = pipelineUid_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.releaseUid_ = releaseUid_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.release_ = release_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.rollout_ = rollout_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.targetId_ = targetId_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.type_ = type_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.rolloutUpdateType_ = rolloutUpdateType_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.deploy.v1.RolloutUpdateEvent) {
        return mergeFrom((com.google.cloud.deploy.v1.RolloutUpdateEvent) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.deploy.v1.RolloutUpdateEvent other) {
      if (other == com.google.cloud.deploy.v1.RolloutUpdateEvent.getDefaultInstance()) return this;
      if (!other.getMessage().isEmpty()) {
        message_ = other.message_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getPipelineUid().isEmpty()) {
        pipelineUid_ = other.pipelineUid_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getReleaseUid().isEmpty()) {
        releaseUid_ = other.releaseUid_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getRelease().isEmpty()) {
        release_ = other.release_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getRollout().isEmpty()) {
        rollout_ = other.rollout_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.getTargetId().isEmpty()) {
        targetId_ = other.targetId_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.type_ != 0) {
        setTypeValue(other.getTypeValue());
      }
      if (other.rolloutUpdateType_ != 0) {
        setRolloutUpdateTypeValue(other.getRolloutUpdateTypeValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                pipelineUid_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 10
            case 18:
              {
                releaseUid_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 18
            case 26:
              {
                rollout_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 26
            case 34:
              {
                targetId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 34
            case 40:
              {
                rolloutUpdateType_ = input.readEnum();
                bitField0_ |= 0x00000080;
                break;
              } // case 40
            case 50:
              {
                message_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 50
            case 56:
              {
                type_ = input.readEnum();
                bitField0_ |= 0x00000040;
                break;
              } // case 56
            case 66:
              {
                release_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object message_ = "";
    /**
     *
     *
     * <pre>
     * Debug message for when a rollout update event occurs.
     * </pre>
     *
     * <code>string message = 6;</code>
     *
     * @return The message.
     */
    public java.lang.String getMessage() {
      java.lang.Object ref = message_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        message_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Debug message for when a rollout update event occurs.
     * </pre>
     *
     * <code>string message = 6;</code>
     *
     * @return The bytes for message.
     */
    public com.google.protobuf.ByteString getMessageBytes() {
      java.lang.Object ref = message_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        message_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Debug message for when a rollout update event occurs.
     * </pre>
     *
     * <code>string message = 6;</code>
     *
     * @param value The message to set.
     * @return This builder for chaining.
     */
    public Builder setMessage(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      message_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Debug message for when a rollout update event occurs.
     * </pre>
     *
     * <code>string message = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMessage() {
      message_ = getDefaultInstance().getMessage();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Debug message for when a rollout update event occurs.
     * </pre>
     *
     * <code>string message = 6;</code>
     *
     * @param value The bytes for message to set.
     * @return This builder for chaining.
     */
    public Builder setMessageBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      message_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object pipelineUid_ = "";
    /**
     *
     *
     * <pre>
     * Unique identifier of the pipeline.
     * </pre>
     *
     * <code>string pipeline_uid = 1;</code>
     *
     * @return The pipelineUid.
     */
    public java.lang.String getPipelineUid() {
      java.lang.Object ref = pipelineUid_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pipelineUid_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Unique identifier of the pipeline.
     * </pre>
     *
     * <code>string pipeline_uid = 1;</code>
     *
     * @return The bytes for pipelineUid.
     */
    public com.google.protobuf.ByteString getPipelineUidBytes() {
      java.lang.Object ref = pipelineUid_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pipelineUid_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Unique identifier of the pipeline.
     * </pre>
     *
     * <code>string pipeline_uid = 1;</code>
     *
     * @param value The pipelineUid to set.
     * @return This builder for chaining.
     */
    public Builder setPipelineUid(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      pipelineUid_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Unique identifier of the pipeline.
     * </pre>
     *
     * <code>string pipeline_uid = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPipelineUid() {
      pipelineUid_ = getDefaultInstance().getPipelineUid();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Unique identifier of the pipeline.
     * </pre>
     *
     * <code>string pipeline_uid = 1;</code>
     *
     * @param value The bytes for pipelineUid to set.
     * @return This builder for chaining.
     */
    public Builder setPipelineUidBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      pipelineUid_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object releaseUid_ = "";
    /**
     *
     *
     * <pre>
     * Unique identifier of the release.
     * </pre>
     *
     * <code>string release_uid = 2;</code>
     *
     * @return The releaseUid.
     */
    public java.lang.String getReleaseUid() {
      java.lang.Object ref = releaseUid_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        releaseUid_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Unique identifier of the release.
     * </pre>
     *
     * <code>string release_uid = 2;</code>
     *
     * @return The bytes for releaseUid.
     */
    public com.google.protobuf.ByteString getReleaseUidBytes() {
      java.lang.Object ref = releaseUid_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        releaseUid_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Unique identifier of the release.
     * </pre>
     *
     * <code>string release_uid = 2;</code>
     *
     * @param value The releaseUid to set.
     * @return This builder for chaining.
     */
    public Builder setReleaseUid(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      releaseUid_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Unique identifier of the release.
     * </pre>
     *
     * <code>string release_uid = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReleaseUid() {
      releaseUid_ = getDefaultInstance().getReleaseUid();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Unique identifier of the release.
     * </pre>
     *
     * <code>string release_uid = 2;</code>
     *
     * @param value The bytes for releaseUid to set.
     * @return This builder for chaining.
     */
    public Builder setReleaseUidBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      releaseUid_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object release_ = "";
    /**
     *
     *
     * <pre>
     * The name of the `Release`.
     * </pre>
     *
     * <code>string release = 8;</code>
     *
     * @return The release.
     */
    public java.lang.String getRelease() {
      java.lang.Object ref = release_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        release_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the `Release`.
     * </pre>
     *
     * <code>string release = 8;</code>
     *
     * @return The bytes for release.
     */
    public com.google.protobuf.ByteString getReleaseBytes() {
      java.lang.Object ref = release_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        release_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the `Release`.
     * </pre>
     *
     * <code>string release = 8;</code>
     *
     * @param value The release to set.
     * @return This builder for chaining.
     */
    public Builder setRelease(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      release_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the `Release`.
     * </pre>
     *
     * <code>string release = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRelease() {
      release_ = getDefaultInstance().getRelease();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the `Release`.
     * </pre>
     *
     * <code>string release = 8;</code>
     *
     * @param value The bytes for release to set.
     * @return This builder for chaining.
     */
    public Builder setReleaseBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      release_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object rollout_ = "";
    /**
     *
     *
     * <pre>
     * The name of the rollout.
     * rollout_uid is not in this log message because we write some of these log
     * messages at rollout creation time, before we've generated the uid.
     * </pre>
     *
     * <code>string rollout = 3;</code>
     *
     * @return The rollout.
     */
    public java.lang.String getRollout() {
      java.lang.Object ref = rollout_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        rollout_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the rollout.
     * rollout_uid is not in this log message because we write some of these log
     * messages at rollout creation time, before we've generated the uid.
     * </pre>
     *
     * <code>string rollout = 3;</code>
     *
     * @return The bytes for rollout.
     */
    public com.google.protobuf.ByteString getRolloutBytes() {
      java.lang.Object ref = rollout_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        rollout_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the rollout.
     * rollout_uid is not in this log message because we write some of these log
     * messages at rollout creation time, before we've generated the uid.
     * </pre>
     *
     * <code>string rollout = 3;</code>
     *
     * @param value The rollout to set.
     * @return This builder for chaining.
     */
    public Builder setRollout(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      rollout_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the rollout.
     * rollout_uid is not in this log message because we write some of these log
     * messages at rollout creation time, before we've generated the uid.
     * </pre>
     *
     * <code>string rollout = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRollout() {
      rollout_ = getDefaultInstance().getRollout();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the rollout.
     * rollout_uid is not in this log message because we write some of these log
     * messages at rollout creation time, before we've generated the uid.
     * </pre>
     *
     * <code>string rollout = 3;</code>
     *
     * @param value The bytes for rollout to set.
     * @return This builder for chaining.
     */
    public Builder setRolloutBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      rollout_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object targetId_ = "";
    /**
     *
     *
     * <pre>
     * ID of the target.
     * </pre>
     *
     * <code>string target_id = 4;</code>
     *
     * @return The targetId.
     */
    public java.lang.String getTargetId() {
      java.lang.Object ref = targetId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        targetId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * ID of the target.
     * </pre>
     *
     * <code>string target_id = 4;</code>
     *
     * @return The bytes for targetId.
     */
    public com.google.protobuf.ByteString getTargetIdBytes() {
      java.lang.Object ref = targetId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        targetId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * ID of the target.
     * </pre>
     *
     * <code>string target_id = 4;</code>
     *
     * @param value The targetId to set.
     * @return This builder for chaining.
     */
    public Builder setTargetId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      targetId_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * ID of the target.
     * </pre>
     *
     * <code>string target_id = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTargetId() {
      targetId_ = getDefaultInstance().getTargetId();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * ID of the target.
     * </pre>
     *
     * <code>string target_id = 4;</code>
     *
     * @param value The bytes for targetId to set.
     * @return This builder for chaining.
     */
    public Builder setTargetIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      targetId_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private int type_ = 0;
    /**
     *
     *
     * <pre>
     * Type of this notification, e.g. for a rollout update event.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.Type type = 7;</code>
     *
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override
    public int getTypeValue() {
      return type_;
    }
    /**
     *
     *
     * <pre>
     * Type of this notification, e.g. for a rollout update event.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.Type type = 7;</code>
     *
     * @param value The enum numeric value on the wire for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeValue(int value) {
      type_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type of this notification, e.g. for a rollout update event.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.Type type = 7;</code>
     *
     * @return The type.
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.Type getType() {
      com.google.cloud.deploy.v1.Type result = com.google.cloud.deploy.v1.Type.forNumber(type_);
      return result == null ? com.google.cloud.deploy.v1.Type.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Type of this notification, e.g. for a rollout update event.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.Type type = 7;</code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(com.google.cloud.deploy.v1.Type value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000040;
      type_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type of this notification, e.g. for a rollout update event.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.Type type = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {
      bitField0_ = (bitField0_ & ~0x00000040);
      type_ = 0;
      onChanged();
      return this;
    }

    private int rolloutUpdateType_ = 0;
    /**
     *
     *
     * <pre>
     * The type of the rollout update.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.RolloutUpdateEvent.RolloutUpdateType rollout_update_type = 5;
     * </code>
     *
     * @return The enum numeric value on the wire for rolloutUpdateType.
     */
    @java.lang.Override
    public int getRolloutUpdateTypeValue() {
      return rolloutUpdateType_;
    }
    /**
     *
     *
     * <pre>
     * The type of the rollout update.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.RolloutUpdateEvent.RolloutUpdateType rollout_update_type = 5;
     * </code>
     *
     * @param value The enum numeric value on the wire for rolloutUpdateType to set.
     * @return This builder for chaining.
     */
    public Builder setRolloutUpdateTypeValue(int value) {
      rolloutUpdateType_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of the rollout update.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.RolloutUpdateEvent.RolloutUpdateType rollout_update_type = 5;
     * </code>
     *
     * @return The rolloutUpdateType.
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.RolloutUpdateEvent.RolloutUpdateType getRolloutUpdateType() {
      com.google.cloud.deploy.v1.RolloutUpdateEvent.RolloutUpdateType result =
          com.google.cloud.deploy.v1.RolloutUpdateEvent.RolloutUpdateType.forNumber(
              rolloutUpdateType_);
      return result == null
          ? com.google.cloud.deploy.v1.RolloutUpdateEvent.RolloutUpdateType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The type of the rollout update.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.RolloutUpdateEvent.RolloutUpdateType rollout_update_type = 5;
     * </code>
     *
     * @param value The rolloutUpdateType to set.
     * @return This builder for chaining.
     */
    public Builder setRolloutUpdateType(
        com.google.cloud.deploy.v1.RolloutUpdateEvent.RolloutUpdateType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000080;
      rolloutUpdateType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of the rollout update.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.RolloutUpdateEvent.RolloutUpdateType rollout_update_type = 5;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRolloutUpdateType() {
      bitField0_ = (bitField0_ & ~0x00000080);
      rolloutUpdateType_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.deploy.v1.RolloutUpdateEvent)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.deploy.v1.RolloutUpdateEvent)
  private static final com.google.cloud.deploy.v1.RolloutUpdateEvent DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.deploy.v1.RolloutUpdateEvent();
  }

  public static com.google.cloud.deploy.v1.RolloutUpdateEvent getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RolloutUpdateEvent> PARSER =
      new com.google.protobuf.AbstractParser<RolloutUpdateEvent>() {
        @java.lang.Override
        public RolloutUpdateEvent parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RolloutUpdateEvent> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RolloutUpdateEvent> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.deploy.v1.RolloutUpdateEvent getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
