/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/deploy/v1/cloud_deploy.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.deploy.v1;

/**
 *
 *
 * <pre>
 * A `Target` resource in the Cloud Deploy API.
 *
 * A `Target` defines a location to which a Skaffold configuration
 * can be deployed.
 * </pre>
 *
 * Protobuf type {@code google.cloud.deploy.v1.Target}
 */
public final class Target extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.deploy.v1.Target)
    TargetOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Target.newBuilder() to construct.
  private Target(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Target() {
    name_ = "";
    targetId_ = "";
    uid_ = "";
    description_ = "";
    etag_ = "";
    executionConfigs_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Target();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.deploy.v1.CloudDeployProto
        .internal_static_google_cloud_deploy_v1_Target_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 5:
        return internalGetAnnotations();
      case 6:
        return internalGetLabels();
      case 23:
        return internalGetAssociatedEntities();
      case 20:
        return internalGetDeployParameters();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.deploy.v1.CloudDeployProto
        .internal_static_google_cloud_deploy_v1_Target_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.deploy.v1.Target.class,
            com.google.cloud.deploy.v1.Target.Builder.class);
  }

  private int bitField0_;
  private int deploymentTargetCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object deploymentTarget_;

  public enum DeploymentTargetCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    GKE(15),
    ANTHOS_CLUSTER(17),
    RUN(18),
    MULTI_TARGET(19),
    CUSTOM_TARGET(21),
    DEPLOYMENTTARGET_NOT_SET(0);
    private final int value;

    private DeploymentTargetCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DeploymentTargetCase valueOf(int value) {
      return forNumber(value);
    }

    public static DeploymentTargetCase forNumber(int value) {
      switch (value) {
        case 15:
          return GKE;
        case 17:
          return ANTHOS_CLUSTER;
        case 18:
          return RUN;
        case 19:
          return MULTI_TARGET;
        case 21:
          return CUSTOM_TARGET;
        case 0:
          return DEPLOYMENTTARGET_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public DeploymentTargetCase getDeploymentTargetCase() {
    return DeploymentTargetCase.forNumber(deploymentTargetCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Optional. Name of the `Target`. Format is
   * `projects/{project}/locations/{location}/targets/{target}`.
   * The `target` component must match `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Name of the `Target`. Format is
   * `projects/{project}/locations/{location}/targets/{target}`.
   * The `target` component must match `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TARGET_ID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object targetId_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Resource id of the `Target`.
   * </pre>
   *
   * <code>string target_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The targetId.
   */
  @java.lang.Override
  public java.lang.String getTargetId() {
    java.lang.Object ref = targetId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      targetId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Resource id of the `Target`.
   * </pre>
   *
   * <code>string target_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for targetId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTargetIdBytes() {
    java.lang.Object ref = targetId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      targetId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int UID_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object uid_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Unique identifier of the `Target`.
   * </pre>
   *
   * <code>string uid = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The uid.
   */
  @java.lang.Override
  public java.lang.String getUid() {
    java.lang.Object ref = uid_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      uid_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Unique identifier of the `Target`.
   * </pre>
   *
   * <code>string uid = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for uid.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUidBytes() {
    java.lang.Object ref = uid_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      uid_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * Optional. Description of the `Target`. Max length is 255 characters.
   * </pre>
   *
   * <code>string description = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Description of the `Target`. Max length is 255 characters.
   * </pre>
   *
   * <code>string description = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ANNOTATIONS_FIELD_NUMBER = 5;

  private static final class AnnotationsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.deploy.v1.CloudDeployProto
                .internal_static_google_cloud_deploy_v1_Target_AnnotationsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> annotations_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetAnnotations() {
    if (annotations_ == null) {
      return com.google.protobuf.MapField.emptyMapField(AnnotationsDefaultEntryHolder.defaultEntry);
    }
    return annotations_;
  }

  public int getAnnotationsCount() {
    return internalGetAnnotations().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Optional. User annotations. These attributes can only be set and used by
   * the user, and not by Cloud Deploy. See
   * https://google.aip.dev/128#annotations for more details such as format and
   * size limitations.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public boolean containsAnnotations(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetAnnotations().getMap().containsKey(key);
  }
  /** Use {@link #getAnnotationsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getAnnotations() {
    return getAnnotationsMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. User annotations. These attributes can only be set and used by
   * the user, and not by Cloud Deploy. See
   * https://google.aip.dev/128#annotations for more details such as format and
   * size limitations.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getAnnotationsMap() {
    return internalGetAnnotations().getMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. User annotations. These attributes can only be set and used by
   * the user, and not by Cloud Deploy. See
   * https://google.aip.dev/128#annotations for more details such as format and
   * size limitations.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getAnnotationsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Optional. User annotations. These attributes can only be set and used by
   * the user, and not by Cloud Deploy. See
   * https://google.aip.dev/128#annotations for more details such as format and
   * size limitations.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.lang.String getAnnotationsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int LABELS_FIELD_NUMBER = 6;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.deploy.v1.CloudDeployProto
                .internal_static_google_cloud_deploy_v1_Target_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Labels are attributes that can be set and used by both the
   * user and by Cloud Deploy. Labels must meet the following constraints:
   *
   * * Keys and values can contain only lowercase letters, numeric characters,
   * underscores, and dashes.
   * * All characters must use UTF-8 encoding, and international characters are
   * allowed.
   * * Keys must start with a lowercase letter or international character.
   * * Each resource is limited to a maximum of 64 labels.
   *
   * Both keys and values are additionally constrained to be &lt;= 128 bytes.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. Labels are attributes that can be set and used by both the
   * user and by Cloud Deploy. Labels must meet the following constraints:
   *
   * * Keys and values can contain only lowercase letters, numeric characters,
   * underscores, and dashes.
   * * All characters must use UTF-8 encoding, and international characters are
   * allowed.
   * * Keys must start with a lowercase letter or international character.
   * * Each resource is limited to a maximum of 64 labels.
   *
   * Both keys and values are additionally constrained to be &lt;= 128 bytes.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. Labels are attributes that can be set and used by both the
   * user and by Cloud Deploy. Labels must meet the following constraints:
   *
   * * Keys and values can contain only lowercase letters, numeric characters,
   * underscores, and dashes.
   * * All characters must use UTF-8 encoding, and international characters are
   * allowed.
   * * Keys must start with a lowercase letter or international character.
   * * Each resource is limited to a maximum of 64 labels.
   *
   * Both keys and values are additionally constrained to be &lt;= 128 bytes.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Optional. Labels are attributes that can be set and used by both the
   * user and by Cloud Deploy. Labels must meet the following constraints:
   *
   * * Keys and values can contain only lowercase letters, numeric characters,
   * underscores, and dashes.
   * * All characters must use UTF-8 encoding, and international characters are
   * allowed.
   * * Keys must start with a lowercase letter or international character.
   * * Each resource is limited to a maximum of 64 labels.
   *
   * Both keys and values are additionally constrained to be &lt;= 128 bytes.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int REQUIRE_APPROVAL_FIELD_NUMBER = 13;
  private boolean requireApproval_ = false;
  /**
   *
   *
   * <pre>
   * Optional. Whether or not the `Target` requires approval.
   * </pre>
   *
   * <code>bool require_approval = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The requireApproval.
   */
  @java.lang.Override
  public boolean getRequireApproval() {
    return requireApproval_;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 8;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Time at which the `Target` was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Time at which the `Target` was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time at which the `Target` was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 9;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. Most recent time at which the `Target` was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Most recent time at which the `Target` was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Most recent time at which the `Target` was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int GKE_FIELD_NUMBER = 15;
  /**
   *
   *
   * <pre>
   * Optional. Information specifying a GKE Cluster.
   * </pre>
   *
   * <code>.google.cloud.deploy.v1.GkeCluster gke = 15 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the gke field is set.
   */
  @java.lang.Override
  public boolean hasGke() {
    return deploymentTargetCase_ == 15;
  }
  /**
   *
   *
   * <pre>
   * Optional. Information specifying a GKE Cluster.
   * </pre>
   *
   * <code>.google.cloud.deploy.v1.GkeCluster gke = 15 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The gke.
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.GkeCluster getGke() {
    if (deploymentTargetCase_ == 15) {
      return (com.google.cloud.deploy.v1.GkeCluster) deploymentTarget_;
    }
    return com.google.cloud.deploy.v1.GkeCluster.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. Information specifying a GKE Cluster.
   * </pre>
   *
   * <code>.google.cloud.deploy.v1.GkeCluster gke = 15 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.GkeClusterOrBuilder getGkeOrBuilder() {
    if (deploymentTargetCase_ == 15) {
      return (com.google.cloud.deploy.v1.GkeCluster) deploymentTarget_;
    }
    return com.google.cloud.deploy.v1.GkeCluster.getDefaultInstance();
  }

  public static final int ANTHOS_CLUSTER_FIELD_NUMBER = 17;
  /**
   *
   *
   * <pre>
   * Optional. Information specifying an Anthos Cluster.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.AnthosCluster anthos_cluster = 17 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the anthosCluster field is set.
   */
  @java.lang.Override
  public boolean hasAnthosCluster() {
    return deploymentTargetCase_ == 17;
  }
  /**
   *
   *
   * <pre>
   * Optional. Information specifying an Anthos Cluster.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.AnthosCluster anthos_cluster = 17 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The anthosCluster.
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.AnthosCluster getAnthosCluster() {
    if (deploymentTargetCase_ == 17) {
      return (com.google.cloud.deploy.v1.AnthosCluster) deploymentTarget_;
    }
    return com.google.cloud.deploy.v1.AnthosCluster.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. Information specifying an Anthos Cluster.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.AnthosCluster anthos_cluster = 17 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.AnthosClusterOrBuilder getAnthosClusterOrBuilder() {
    if (deploymentTargetCase_ == 17) {
      return (com.google.cloud.deploy.v1.AnthosCluster) deploymentTarget_;
    }
    return com.google.cloud.deploy.v1.AnthosCluster.getDefaultInstance();
  }

  public static final int RUN_FIELD_NUMBER = 18;
  /**
   *
   *
   * <pre>
   * Optional. Information specifying a Cloud Run deployment target.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.CloudRunLocation run = 18 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the run field is set.
   */
  @java.lang.Override
  public boolean hasRun() {
    return deploymentTargetCase_ == 18;
  }
  /**
   *
   *
   * <pre>
   * Optional. Information specifying a Cloud Run deployment target.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.CloudRunLocation run = 18 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The run.
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.CloudRunLocation getRun() {
    if (deploymentTargetCase_ == 18) {
      return (com.google.cloud.deploy.v1.CloudRunLocation) deploymentTarget_;
    }
    return com.google.cloud.deploy.v1.CloudRunLocation.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. Information specifying a Cloud Run deployment target.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.CloudRunLocation run = 18 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.CloudRunLocationOrBuilder getRunOrBuilder() {
    if (deploymentTargetCase_ == 18) {
      return (com.google.cloud.deploy.v1.CloudRunLocation) deploymentTarget_;
    }
    return com.google.cloud.deploy.v1.CloudRunLocation.getDefaultInstance();
  }

  public static final int MULTI_TARGET_FIELD_NUMBER = 19;
  /**
   *
   *
   * <pre>
   * Optional. Information specifying a multiTarget.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.MultiTarget multi_target = 19 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the multiTarget field is set.
   */
  @java.lang.Override
  public boolean hasMultiTarget() {
    return deploymentTargetCase_ == 19;
  }
  /**
   *
   *
   * <pre>
   * Optional. Information specifying a multiTarget.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.MultiTarget multi_target = 19 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The multiTarget.
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.MultiTarget getMultiTarget() {
    if (deploymentTargetCase_ == 19) {
      return (com.google.cloud.deploy.v1.MultiTarget) deploymentTarget_;
    }
    return com.google.cloud.deploy.v1.MultiTarget.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. Information specifying a multiTarget.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.MultiTarget multi_target = 19 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.MultiTargetOrBuilder getMultiTargetOrBuilder() {
    if (deploymentTargetCase_ == 19) {
      return (com.google.cloud.deploy.v1.MultiTarget) deploymentTarget_;
    }
    return com.google.cloud.deploy.v1.MultiTarget.getDefaultInstance();
  }

  public static final int CUSTOM_TARGET_FIELD_NUMBER = 21;
  /**
   *
   *
   * <pre>
   * Optional. Information specifying a Custom Target.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.CustomTarget custom_target = 21 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the customTarget field is set.
   */
  @java.lang.Override
  public boolean hasCustomTarget() {
    return deploymentTargetCase_ == 21;
  }
  /**
   *
   *
   * <pre>
   * Optional. Information specifying a Custom Target.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.CustomTarget custom_target = 21 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The customTarget.
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.CustomTarget getCustomTarget() {
    if (deploymentTargetCase_ == 21) {
      return (com.google.cloud.deploy.v1.CustomTarget) deploymentTarget_;
    }
    return com.google.cloud.deploy.v1.CustomTarget.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. Information specifying a Custom Target.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.CustomTarget custom_target = 21 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.CustomTargetOrBuilder getCustomTargetOrBuilder() {
    if (deploymentTargetCase_ == 21) {
      return (com.google.cloud.deploy.v1.CustomTarget) deploymentTarget_;
    }
    return com.google.cloud.deploy.v1.CustomTarget.getDefaultInstance();
  }

  public static final int ASSOCIATED_ENTITIES_FIELD_NUMBER = 23;

  private static final class AssociatedEntitiesDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
            java.lang.String, com.google.cloud.deploy.v1.AssociatedEntities>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String, com.google.cloud.deploy.v1.AssociatedEntities>
                    newDefaultInstance(
                        com.google.cloud.deploy.v1.CloudDeployProto
                            .internal_static_google_cloud_deploy_v1_Target_AssociatedEntitiesEntry_descriptor,
                        com.google.protobuf.WireFormat.FieldType.STRING,
                        "",
                        com.google.protobuf.WireFormat.FieldType.MESSAGE,
                        com.google.cloud.deploy.v1.AssociatedEntities.getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.deploy.v1.AssociatedEntities>
      associatedEntities_;

  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.deploy.v1.AssociatedEntities>
      internalGetAssociatedEntities() {
    if (associatedEntities_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          AssociatedEntitiesDefaultEntryHolder.defaultEntry);
    }
    return associatedEntities_;
  }

  public int getAssociatedEntitiesCount() {
    return internalGetAssociatedEntities().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Map of entity IDs to their associated entities. Associated
   * entities allows specifying places other than the deployment target for
   * specific features. For example, the Gateway API canary can be configured to
   * deploy the HTTPRoute to a different cluster(s) than the deployment cluster
   * using associated entities. An entity ID must consist of lower-case letters,
   * numbers, and hyphens, start with a letter and end with a letter or a
   * number, and have a max length of 63 characters. In other words, it must
   * match the following regex: `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.deploy.v1.AssociatedEntities&gt; associated_entities = 23 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public boolean containsAssociatedEntities(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetAssociatedEntities().getMap().containsKey(key);
  }
  /** Use {@link #getAssociatedEntitiesMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, com.google.cloud.deploy.v1.AssociatedEntities>
      getAssociatedEntities() {
    return getAssociatedEntitiesMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. Map of entity IDs to their associated entities. Associated
   * entities allows specifying places other than the deployment target for
   * specific features. For example, the Gateway API canary can be configured to
   * deploy the HTTPRoute to a different cluster(s) than the deployment cluster
   * using associated entities. An entity ID must consist of lower-case letters,
   * numbers, and hyphens, start with a letter and end with a letter or a
   * number, and have a max length of 63 characters. In other words, it must
   * match the following regex: `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.deploy.v1.AssociatedEntities&gt; associated_entities = 23 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, com.google.cloud.deploy.v1.AssociatedEntities>
      getAssociatedEntitiesMap() {
    return internalGetAssociatedEntities().getMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. Map of entity IDs to their associated entities. Associated
   * entities allows specifying places other than the deployment target for
   * specific features. For example, the Gateway API canary can be configured to
   * deploy the HTTPRoute to a different cluster(s) than the deployment cluster
   * using associated entities. An entity ID must consist of lower-case letters,
   * numbers, and hyphens, start with a letter and end with a letter or a
   * number, and have a max length of 63 characters. In other words, it must
   * match the following regex: `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.deploy.v1.AssociatedEntities&gt; associated_entities = 23 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public /* nullable */ com.google.cloud.deploy.v1.AssociatedEntities
      getAssociatedEntitiesOrDefault(
          java.lang.String key,
          /* nullable */
          com.google.cloud.deploy.v1.AssociatedEntities defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.deploy.v1.AssociatedEntities> map =
        internalGetAssociatedEntities().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Optional. Map of entity IDs to their associated entities. Associated
   * entities allows specifying places other than the deployment target for
   * specific features. For example, the Gateway API canary can be configured to
   * deploy the HTTPRoute to a different cluster(s) than the deployment cluster
   * using associated entities. An entity ID must consist of lower-case letters,
   * numbers, and hyphens, start with a letter and end with a letter or a
   * number, and have a max length of 63 characters. In other words, it must
   * match the following regex: `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.deploy.v1.AssociatedEntities&gt; associated_entities = 23 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.AssociatedEntities getAssociatedEntitiesOrThrow(
      java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.deploy.v1.AssociatedEntities> map =
        internalGetAssociatedEntities().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int ETAG_FIELD_NUMBER = 12;

  @SuppressWarnings("serial")
  private volatile java.lang.Object etag_ = "";
  /**
   *
   *
   * <pre>
   * Optional. This checksum is computed by the server based on the value of
   * other fields, and may be sent on update and delete requests to ensure the
   * client has an up-to-date value before proceeding.
   * </pre>
   *
   * <code>string etag = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The etag.
   */
  @java.lang.Override
  public java.lang.String getEtag() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      etag_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. This checksum is computed by the server based on the value of
   * other fields, and may be sent on update and delete requests to ensure the
   * client has an up-to-date value before proceeding.
   * </pre>
   *
   * <code>string etag = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for etag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEtagBytes() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      etag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EXECUTION_CONFIGS_FIELD_NUMBER = 16;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.deploy.v1.ExecutionConfig> executionConfigs_;
  /**
   *
   *
   * <pre>
   * Configurations for all execution that relates to this `Target`.
   * Each `ExecutionEnvironmentUsage` value may only be used in a single
   * configuration; using the same value multiple times is an error.
   * When one or more configurations are specified, they must include the
   * `RENDER` and `DEPLOY` `ExecutionEnvironmentUsage` values.
   * When no configurations are specified, execution will use the default
   * specified in `DefaultPool`.
   * </pre>
   *
   * <code>repeated .google.cloud.deploy.v1.ExecutionConfig execution_configs = 16;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.deploy.v1.ExecutionConfig> getExecutionConfigsList() {
    return executionConfigs_;
  }
  /**
   *
   *
   * <pre>
   * Configurations for all execution that relates to this `Target`.
   * Each `ExecutionEnvironmentUsage` value may only be used in a single
   * configuration; using the same value multiple times is an error.
   * When one or more configurations are specified, they must include the
   * `RENDER` and `DEPLOY` `ExecutionEnvironmentUsage` values.
   * When no configurations are specified, execution will use the default
   * specified in `DefaultPool`.
   * </pre>
   *
   * <code>repeated .google.cloud.deploy.v1.ExecutionConfig execution_configs = 16;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.deploy.v1.ExecutionConfigOrBuilder>
      getExecutionConfigsOrBuilderList() {
    return executionConfigs_;
  }
  /**
   *
   *
   * <pre>
   * Configurations for all execution that relates to this `Target`.
   * Each `ExecutionEnvironmentUsage` value may only be used in a single
   * configuration; using the same value multiple times is an error.
   * When one or more configurations are specified, they must include the
   * `RENDER` and `DEPLOY` `ExecutionEnvironmentUsage` values.
   * When no configurations are specified, execution will use the default
   * specified in `DefaultPool`.
   * </pre>
   *
   * <code>repeated .google.cloud.deploy.v1.ExecutionConfig execution_configs = 16;</code>
   */
  @java.lang.Override
  public int getExecutionConfigsCount() {
    return executionConfigs_.size();
  }
  /**
   *
   *
   * <pre>
   * Configurations for all execution that relates to this `Target`.
   * Each `ExecutionEnvironmentUsage` value may only be used in a single
   * configuration; using the same value multiple times is an error.
   * When one or more configurations are specified, they must include the
   * `RENDER` and `DEPLOY` `ExecutionEnvironmentUsage` values.
   * When no configurations are specified, execution will use the default
   * specified in `DefaultPool`.
   * </pre>
   *
   * <code>repeated .google.cloud.deploy.v1.ExecutionConfig execution_configs = 16;</code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.ExecutionConfig getExecutionConfigs(int index) {
    return executionConfigs_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Configurations for all execution that relates to this `Target`.
   * Each `ExecutionEnvironmentUsage` value may only be used in a single
   * configuration; using the same value multiple times is an error.
   * When one or more configurations are specified, they must include the
   * `RENDER` and `DEPLOY` `ExecutionEnvironmentUsage` values.
   * When no configurations are specified, execution will use the default
   * specified in `DefaultPool`.
   * </pre>
   *
   * <code>repeated .google.cloud.deploy.v1.ExecutionConfig execution_configs = 16;</code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.ExecutionConfigOrBuilder getExecutionConfigsOrBuilder(
      int index) {
    return executionConfigs_.get(index);
  }

  public static final int DEPLOY_PARAMETERS_FIELD_NUMBER = 20;

  private static final class DeployParametersDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.deploy.v1.CloudDeployProto
                .internal_static_google_cloud_deploy_v1_Target_DeployParametersEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> deployParameters_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetDeployParameters() {
    if (deployParameters_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          DeployParametersDefaultEntryHolder.defaultEntry);
    }
    return deployParameters_;
  }

  public int getDeployParametersCount() {
    return internalGetDeployParameters().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Optional. The deploy parameters to use for this target.
   * </pre>
   *
   * <code>
   * map&lt;string, string&gt; deploy_parameters = 20 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public boolean containsDeployParameters(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetDeployParameters().getMap().containsKey(key);
  }
  /** Use {@link #getDeployParametersMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getDeployParameters() {
    return getDeployParametersMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. The deploy parameters to use for this target.
   * </pre>
   *
   * <code>
   * map&lt;string, string&gt; deploy_parameters = 20 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getDeployParametersMap() {
    return internalGetDeployParameters().getMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. The deploy parameters to use for this target.
   * </pre>
   *
   * <code>
   * map&lt;string, string&gt; deploy_parameters = 20 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getDeployParametersOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetDeployParameters().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Optional. The deploy parameters to use for this target.
   * </pre>
   *
   * <code>
   * map&lt;string, string&gt; deploy_parameters = 20 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.lang.String getDeployParametersOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetDeployParameters().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(targetId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, targetId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uid_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, uid_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, description_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetAnnotations(), AnnotationsDefaultEntryHolder.defaultEntry, 5);
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 6);
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(8, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(9, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 12, etag_);
    }
    if (requireApproval_ != false) {
      output.writeBool(13, requireApproval_);
    }
    if (deploymentTargetCase_ == 15) {
      output.writeMessage(15, (com.google.cloud.deploy.v1.GkeCluster) deploymentTarget_);
    }
    for (int i = 0; i < executionConfigs_.size(); i++) {
      output.writeMessage(16, executionConfigs_.get(i));
    }
    if (deploymentTargetCase_ == 17) {
      output.writeMessage(17, (com.google.cloud.deploy.v1.AnthosCluster) deploymentTarget_);
    }
    if (deploymentTargetCase_ == 18) {
      output.writeMessage(18, (com.google.cloud.deploy.v1.CloudRunLocation) deploymentTarget_);
    }
    if (deploymentTargetCase_ == 19) {
      output.writeMessage(19, (com.google.cloud.deploy.v1.MultiTarget) deploymentTarget_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetDeployParameters(), DeployParametersDefaultEntryHolder.defaultEntry, 20);
    if (deploymentTargetCase_ == 21) {
      output.writeMessage(21, (com.google.cloud.deploy.v1.CustomTarget) deploymentTarget_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output,
        internalGetAssociatedEntities(),
        AssociatedEntitiesDefaultEntryHolder.defaultEntry,
        23);
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(targetId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, targetId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uid_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, uid_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, description_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetAnnotations().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> annotations__ =
          AnnotationsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, annotations__);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, labels__);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(12, etag_);
    }
    if (requireApproval_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(13, requireApproval_);
    }
    if (deploymentTargetCase_ == 15) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              15, (com.google.cloud.deploy.v1.GkeCluster) deploymentTarget_);
    }
    for (int i = 0; i < executionConfigs_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(16, executionConfigs_.get(i));
    }
    if (deploymentTargetCase_ == 17) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              17, (com.google.cloud.deploy.v1.AnthosCluster) deploymentTarget_);
    }
    if (deploymentTargetCase_ == 18) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              18, (com.google.cloud.deploy.v1.CloudRunLocation) deploymentTarget_);
    }
    if (deploymentTargetCase_ == 19) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              19, (com.google.cloud.deploy.v1.MultiTarget) deploymentTarget_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetDeployParameters().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> deployParameters__ =
          DeployParametersDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(20, deployParameters__);
    }
    if (deploymentTargetCase_ == 21) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              21, (com.google.cloud.deploy.v1.CustomTarget) deploymentTarget_);
    }
    for (java.util.Map.Entry<java.lang.String, com.google.cloud.deploy.v1.AssociatedEntities>
        entry : internalGetAssociatedEntities().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, com.google.cloud.deploy.v1.AssociatedEntities>
          associatedEntities__ =
              AssociatedEntitiesDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(23, associatedEntities__);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.deploy.v1.Target)) {
      return super.equals(obj);
    }
    com.google.cloud.deploy.v1.Target other = (com.google.cloud.deploy.v1.Target) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getTargetId().equals(other.getTargetId())) return false;
    if (!getUid().equals(other.getUid())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (!internalGetAnnotations().equals(other.internalGetAnnotations())) return false;
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (getRequireApproval() != other.getRequireApproval()) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!internalGetAssociatedEntities().equals(other.internalGetAssociatedEntities()))
      return false;
    if (!getEtag().equals(other.getEtag())) return false;
    if (!getExecutionConfigsList().equals(other.getExecutionConfigsList())) return false;
    if (!internalGetDeployParameters().equals(other.internalGetDeployParameters())) return false;
    if (!getDeploymentTargetCase().equals(other.getDeploymentTargetCase())) return false;
    switch (deploymentTargetCase_) {
      case 15:
        if (!getGke().equals(other.getGke())) return false;
        break;
      case 17:
        if (!getAnthosCluster().equals(other.getAnthosCluster())) return false;
        break;
      case 18:
        if (!getRun().equals(other.getRun())) return false;
        break;
      case 19:
        if (!getMultiTarget().equals(other.getMultiTarget())) return false;
        break;
      case 21:
        if (!getCustomTarget().equals(other.getCustomTarget())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + TARGET_ID_FIELD_NUMBER;
    hash = (53 * hash) + getTargetId().hashCode();
    hash = (37 * hash) + UID_FIELD_NUMBER;
    hash = (53 * hash) + getUid().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    if (!internalGetAnnotations().getMap().isEmpty()) {
      hash = (37 * hash) + ANNOTATIONS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetAnnotations().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    hash = (37 * hash) + REQUIRE_APPROVAL_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getRequireApproval());
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (!internalGetAssociatedEntities().getMap().isEmpty()) {
      hash = (37 * hash) + ASSOCIATED_ENTITIES_FIELD_NUMBER;
      hash = (53 * hash) + internalGetAssociatedEntities().hashCode();
    }
    hash = (37 * hash) + ETAG_FIELD_NUMBER;
    hash = (53 * hash) + getEtag().hashCode();
    if (getExecutionConfigsCount() > 0) {
      hash = (37 * hash) + EXECUTION_CONFIGS_FIELD_NUMBER;
      hash = (53 * hash) + getExecutionConfigsList().hashCode();
    }
    if (!internalGetDeployParameters().getMap().isEmpty()) {
      hash = (37 * hash) + DEPLOY_PARAMETERS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetDeployParameters().hashCode();
    }
    switch (deploymentTargetCase_) {
      case 15:
        hash = (37 * hash) + GKE_FIELD_NUMBER;
        hash = (53 * hash) + getGke().hashCode();
        break;
      case 17:
        hash = (37 * hash) + ANTHOS_CLUSTER_FIELD_NUMBER;
        hash = (53 * hash) + getAnthosCluster().hashCode();
        break;
      case 18:
        hash = (37 * hash) + RUN_FIELD_NUMBER;
        hash = (53 * hash) + getRun().hashCode();
        break;
      case 19:
        hash = (37 * hash) + MULTI_TARGET_FIELD_NUMBER;
        hash = (53 * hash) + getMultiTarget().hashCode();
        break;
      case 21:
        hash = (37 * hash) + CUSTOM_TARGET_FIELD_NUMBER;
        hash = (53 * hash) + getCustomTarget().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.deploy.v1.Target parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.Target parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.Target parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.Target parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.Target parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.Target parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.Target parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.Target parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.Target parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.Target parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.Target parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.Target parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.deploy.v1.Target prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A `Target` resource in the Cloud Deploy API.
   *
   * A `Target` defines a location to which a Skaffold configuration
   * can be deployed.
   * </pre>
   *
   * Protobuf type {@code google.cloud.deploy.v1.Target}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.deploy.v1.Target)
      com.google.cloud.deploy.v1.TargetOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_Target_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 5:
          return internalGetAnnotations();
        case 6:
          return internalGetLabels();
        case 23:
          return internalGetAssociatedEntities();
        case 20:
          return internalGetDeployParameters();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 5:
          return internalGetMutableAnnotations();
        case 6:
          return internalGetMutableLabels();
        case 23:
          return internalGetMutableAssociatedEntities();
        case 20:
          return internalGetMutableDeployParameters();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_Target_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.deploy.v1.Target.class,
              com.google.cloud.deploy.v1.Target.Builder.class);
    }

    // Construct using com.google.cloud.deploy.v1.Target.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreateTimeFieldBuilder();
        getUpdateTimeFieldBuilder();
        getExecutionConfigsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      targetId_ = "";
      uid_ = "";
      description_ = "";
      internalGetMutableAnnotations().clear();
      internalGetMutableLabels().clear();
      requireApproval_ = false;
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      if (gkeBuilder_ != null) {
        gkeBuilder_.clear();
      }
      if (anthosClusterBuilder_ != null) {
        anthosClusterBuilder_.clear();
      }
      if (runBuilder_ != null) {
        runBuilder_.clear();
      }
      if (multiTargetBuilder_ != null) {
        multiTargetBuilder_.clear();
      }
      if (customTargetBuilder_ != null) {
        customTargetBuilder_.clear();
      }
      internalGetMutableAssociatedEntities().clear();
      etag_ = "";
      if (executionConfigsBuilder_ == null) {
        executionConfigs_ = java.util.Collections.emptyList();
      } else {
        executionConfigs_ = null;
        executionConfigsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00010000);
      internalGetMutableDeployParameters().clear();
      deploymentTargetCase_ = 0;
      deploymentTarget_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_Target_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.Target getDefaultInstanceForType() {
      return com.google.cloud.deploy.v1.Target.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.Target build() {
      com.google.cloud.deploy.v1.Target result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.Target buildPartial() {
      com.google.cloud.deploy.v1.Target result = new com.google.cloud.deploy.v1.Target(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.deploy.v1.Target result) {
      if (executionConfigsBuilder_ == null) {
        if (((bitField0_ & 0x00010000) != 0)) {
          executionConfigs_ = java.util.Collections.unmodifiableList(executionConfigs_);
          bitField0_ = (bitField0_ & ~0x00010000);
        }
        result.executionConfigs_ = executionConfigs_;
      } else {
        result.executionConfigs_ = executionConfigsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.deploy.v1.Target result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.targetId_ = targetId_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.uid_ = uid_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.annotations_ = internalGetAnnotations();
        result.annotations_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.requireApproval_ = requireApproval_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.associatedEntities_ =
            internalGetAssociatedEntities()
                .build(AssociatedEntitiesDefaultEntryHolder.defaultEntry);
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.etag_ = etag_;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.deployParameters_ = internalGetDeployParameters();
        result.deployParameters_.makeImmutable();
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.deploy.v1.Target result) {
      result.deploymentTargetCase_ = deploymentTargetCase_;
      result.deploymentTarget_ = this.deploymentTarget_;
      if (deploymentTargetCase_ == 15 && gkeBuilder_ != null) {
        result.deploymentTarget_ = gkeBuilder_.build();
      }
      if (deploymentTargetCase_ == 17 && anthosClusterBuilder_ != null) {
        result.deploymentTarget_ = anthosClusterBuilder_.build();
      }
      if (deploymentTargetCase_ == 18 && runBuilder_ != null) {
        result.deploymentTarget_ = runBuilder_.build();
      }
      if (deploymentTargetCase_ == 19 && multiTargetBuilder_ != null) {
        result.deploymentTarget_ = multiTargetBuilder_.build();
      }
      if (deploymentTargetCase_ == 21 && customTargetBuilder_ != null) {
        result.deploymentTarget_ = customTargetBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.deploy.v1.Target) {
        return mergeFrom((com.google.cloud.deploy.v1.Target) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.deploy.v1.Target other) {
      if (other == com.google.cloud.deploy.v1.Target.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getTargetId().isEmpty()) {
        targetId_ = other.targetId_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getUid().isEmpty()) {
        uid_ = other.uid_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      internalGetMutableAnnotations().mergeFrom(other.internalGetAnnotations());
      bitField0_ |= 0x00000010;
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000020;
      if (other.getRequireApproval() != false) {
        setRequireApproval(other.getRequireApproval());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      internalGetMutableAssociatedEntities().mergeFrom(other.internalGetAssociatedEntities());
      bitField0_ |= 0x00004000;
      if (!other.getEtag().isEmpty()) {
        etag_ = other.etag_;
        bitField0_ |= 0x00008000;
        onChanged();
      }
      if (executionConfigsBuilder_ == null) {
        if (!other.executionConfigs_.isEmpty()) {
          if (executionConfigs_.isEmpty()) {
            executionConfigs_ = other.executionConfigs_;
            bitField0_ = (bitField0_ & ~0x00010000);
          } else {
            ensureExecutionConfigsIsMutable();
            executionConfigs_.addAll(other.executionConfigs_);
          }
          onChanged();
        }
      } else {
        if (!other.executionConfigs_.isEmpty()) {
          if (executionConfigsBuilder_.isEmpty()) {
            executionConfigsBuilder_.dispose();
            executionConfigsBuilder_ = null;
            executionConfigs_ = other.executionConfigs_;
            bitField0_ = (bitField0_ & ~0x00010000);
            executionConfigsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getExecutionConfigsFieldBuilder()
                    : null;
          } else {
            executionConfigsBuilder_.addAllMessages(other.executionConfigs_);
          }
        }
      }
      internalGetMutableDeployParameters().mergeFrom(other.internalGetDeployParameters());
      bitField0_ |= 0x00020000;
      switch (other.getDeploymentTargetCase()) {
        case GKE:
          {
            mergeGke(other.getGke());
            break;
          }
        case ANTHOS_CLUSTER:
          {
            mergeAnthosCluster(other.getAnthosCluster());
            break;
          }
        case RUN:
          {
            mergeRun(other.getRun());
            break;
          }
        case MULTI_TARGET:
          {
            mergeMultiTarget(other.getMultiTarget());
            break;
          }
        case CUSTOM_TARGET:
          {
            mergeCustomTarget(other.getCustomTarget());
            break;
          }
        case DEPLOYMENTTARGET_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                targetId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                uid_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> annotations__ =
                    input.readMessage(
                        AnnotationsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableAnnotations()
                    .getMutableMap()
                    .put(annotations__.getKey(), annotations__.getValue());
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 66:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 74
            case 98:
              {
                etag_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00008000;
                break;
              } // case 98
            case 104:
              {
                requireApproval_ = input.readBool();
                bitField0_ |= 0x00000040;
                break;
              } // case 104
            case 122:
              {
                input.readMessage(getGkeFieldBuilder().getBuilder(), extensionRegistry);
                deploymentTargetCase_ = 15;
                break;
              } // case 122
            case 130:
              {
                com.google.cloud.deploy.v1.ExecutionConfig m =
                    input.readMessage(
                        com.google.cloud.deploy.v1.ExecutionConfig.parser(), extensionRegistry);
                if (executionConfigsBuilder_ == null) {
                  ensureExecutionConfigsIsMutable();
                  executionConfigs_.add(m);
                } else {
                  executionConfigsBuilder_.addMessage(m);
                }
                break;
              } // case 130
            case 138:
              {
                input.readMessage(getAnthosClusterFieldBuilder().getBuilder(), extensionRegistry);
                deploymentTargetCase_ = 17;
                break;
              } // case 138
            case 146:
              {
                input.readMessage(getRunFieldBuilder().getBuilder(), extensionRegistry);
                deploymentTargetCase_ = 18;
                break;
              } // case 146
            case 154:
              {
                input.readMessage(getMultiTargetFieldBuilder().getBuilder(), extensionRegistry);
                deploymentTargetCase_ = 19;
                break;
              } // case 154
            case 162:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String>
                    deployParameters__ =
                        input.readMessage(
                            DeployParametersDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableDeployParameters()
                    .getMutableMap()
                    .put(deployParameters__.getKey(), deployParameters__.getValue());
                bitField0_ |= 0x00020000;
                break;
              } // case 162
            case 170:
              {
                input.readMessage(getCustomTargetFieldBuilder().getBuilder(), extensionRegistry);
                deploymentTargetCase_ = 21;
                break;
              } // case 170
            case 186:
              {
                com.google.protobuf.MapEntry<
                        java.lang.String, com.google.cloud.deploy.v1.AssociatedEntities>
                    associatedEntities__ =
                        input.readMessage(
                            AssociatedEntitiesDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableAssociatedEntities()
                    .ensureBuilderMap()
                    .put(associatedEntities__.getKey(), associatedEntities__.getValue());
                bitField0_ |= 0x00004000;
                break;
              } // case 186
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int deploymentTargetCase_ = 0;
    private java.lang.Object deploymentTarget_;

    public DeploymentTargetCase getDeploymentTargetCase() {
      return DeploymentTargetCase.forNumber(deploymentTargetCase_);
    }

    public Builder clearDeploymentTarget() {
      deploymentTargetCase_ = 0;
      deploymentTarget_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Name of the `Target`. Format is
     * `projects/{project}/locations/{location}/targets/{target}`.
     * The `target` component must match `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Name of the `Target`. Format is
     * `projects/{project}/locations/{location}/targets/{target}`.
     * The `target` component must match `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Name of the `Target`. Format is
     * `projects/{project}/locations/{location}/targets/{target}`.
     * The `target` component must match `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Name of the `Target`. Format is
     * `projects/{project}/locations/{location}/targets/{target}`.
     * The `target` component must match `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Name of the `Target`. Format is
     * `projects/{project}/locations/{location}/targets/{target}`.
     * The `target` component must match `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object targetId_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Resource id of the `Target`.
     * </pre>
     *
     * <code>string target_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The targetId.
     */
    public java.lang.String getTargetId() {
      java.lang.Object ref = targetId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        targetId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource id of the `Target`.
     * </pre>
     *
     * <code>string target_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for targetId.
     */
    public com.google.protobuf.ByteString getTargetIdBytes() {
      java.lang.Object ref = targetId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        targetId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource id of the `Target`.
     * </pre>
     *
     * <code>string target_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The targetId to set.
     * @return This builder for chaining.
     */
    public Builder setTargetId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      targetId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource id of the `Target`.
     * </pre>
     *
     * <code>string target_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTargetId() {
      targetId_ = getDefaultInstance().getTargetId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource id of the `Target`.
     * </pre>
     *
     * <code>string target_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for targetId to set.
     * @return This builder for chaining.
     */
    public Builder setTargetIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      targetId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object uid_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier of the `Target`.
     * </pre>
     *
     * <code>string uid = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The uid.
     */
    public java.lang.String getUid() {
      java.lang.Object ref = uid_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uid_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier of the `Target`.
     * </pre>
     *
     * <code>string uid = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for uid.
     */
    public com.google.protobuf.ByteString getUidBytes() {
      java.lang.Object ref = uid_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        uid_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier of the `Target`.
     * </pre>
     *
     * <code>string uid = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The uid to set.
     * @return This builder for chaining.
     */
    public Builder setUid(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      uid_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier of the `Target`.
     * </pre>
     *
     * <code>string uid = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUid() {
      uid_ = getDefaultInstance().getUid();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier of the `Target`.
     * </pre>
     *
     * <code>string uid = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for uid to set.
     * @return This builder for chaining.
     */
    public Builder setUidBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      uid_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Description of the `Target`. Max length is 255 characters.
     * </pre>
     *
     * <code>string description = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Description of the `Target`. Max length is 255 characters.
     * </pre>
     *
     * <code>string description = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Description of the `Target`. Max length is 255 characters.
     * </pre>
     *
     * <code>string description = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Description of the `Target`. Max length is 255 characters.
     * </pre>
     *
     * <code>string description = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Description of the `Target`. Max length is 255 characters.
     * </pre>
     *
     * <code>string description = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> annotations_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetAnnotations() {
      if (annotations_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            AnnotationsDefaultEntryHolder.defaultEntry);
      }
      return annotations_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableAnnotations() {
      if (annotations_ == null) {
        annotations_ =
            com.google.protobuf.MapField.newMapField(AnnotationsDefaultEntryHolder.defaultEntry);
      }
      if (!annotations_.isMutable()) {
        annotations_ = annotations_.copy();
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return annotations_;
    }

    public int getAnnotationsCount() {
      return internalGetAnnotations().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional. User annotations. These attributes can only be set and used by
     * the user, and not by Cloud Deploy. See
     * https://google.aip.dev/128#annotations for more details such as format and
     * size limitations.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public boolean containsAnnotations(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetAnnotations().getMap().containsKey(key);
    }
    /** Use {@link #getAnnotationsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getAnnotations() {
      return getAnnotationsMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. User annotations. These attributes can only be set and used by
     * the user, and not by Cloud Deploy. See
     * https://google.aip.dev/128#annotations for more details such as format and
     * size limitations.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getAnnotationsMap() {
      return internalGetAnnotations().getMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. User annotations. These attributes can only be set and used by
     * the user, and not by Cloud Deploy. See
     * https://google.aip.dev/128#annotations for more details such as format and
     * size limitations.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getAnnotationsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional. User annotations. These attributes can only be set and used by
     * the user, and not by Cloud Deploy. See
     * https://google.aip.dev/128#annotations for more details such as format and
     * size limitations.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.lang.String getAnnotationsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearAnnotations() {
      bitField0_ = (bitField0_ & ~0x00000010);
      internalGetMutableAnnotations().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. User annotations. These attributes can only be set and used by
     * the user, and not by Cloud Deploy. See
     * https://google.aip.dev/128#annotations for more details such as format and
     * size limitations.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeAnnotations(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableAnnotations().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableAnnotations() {
      bitField0_ |= 0x00000010;
      return internalGetMutableAnnotations().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. User annotations. These attributes can only be set and used by
     * the user, and not by Cloud Deploy. See
     * https://google.aip.dev/128#annotations for more details such as format and
     * size limitations.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putAnnotations(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableAnnotations().getMutableMap().put(key, value);
      bitField0_ |= 0x00000010;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. User annotations. These attributes can only be set and used by
     * the user, and not by Cloud Deploy. See
     * https://google.aip.dev/128#annotations for more details such as format and
     * size limitations.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putAllAnnotations(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableAnnotations().getMutableMap().putAll(values);
      bitField0_ |= 0x00000010;
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Labels are attributes that can be set and used by both the
     * user and by Cloud Deploy. Labels must meet the following constraints:
     *
     * * Keys and values can contain only lowercase letters, numeric characters,
     * underscores, and dashes.
     * * All characters must use UTF-8 encoding, and international characters are
     * allowed.
     * * Keys must start with a lowercase letter or international character.
     * * Each resource is limited to a maximum of 64 labels.
     *
     * Both keys and values are additionally constrained to be &lt;= 128 bytes.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Labels are attributes that can be set and used by both the
     * user and by Cloud Deploy. Labels must meet the following constraints:
     *
     * * Keys and values can contain only lowercase letters, numeric characters,
     * underscores, and dashes.
     * * All characters must use UTF-8 encoding, and international characters are
     * allowed.
     * * Keys must start with a lowercase letter or international character.
     * * Each resource is limited to a maximum of 64 labels.
     *
     * Both keys and values are additionally constrained to be &lt;= 128 bytes.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Labels are attributes that can be set and used by both the
     * user and by Cloud Deploy. Labels must meet the following constraints:
     *
     * * Keys and values can contain only lowercase letters, numeric characters,
     * underscores, and dashes.
     * * All characters must use UTF-8 encoding, and international characters are
     * allowed.
     * * Keys must start with a lowercase letter or international character.
     * * Each resource is limited to a maximum of 64 labels.
     *
     * Both keys and values are additionally constrained to be &lt;= 128 bytes.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional. Labels are attributes that can be set and used by both the
     * user and by Cloud Deploy. Labels must meet the following constraints:
     *
     * * Keys and values can contain only lowercase letters, numeric characters,
     * underscores, and dashes.
     * * All characters must use UTF-8 encoding, and international characters are
     * allowed.
     * * Keys must start with a lowercase letter or international character.
     * * Each resource is limited to a maximum of 64 labels.
     *
     * Both keys and values are additionally constrained to be &lt;= 128 bytes.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000020);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Labels are attributes that can be set and used by both the
     * user and by Cloud Deploy. Labels must meet the following constraints:
     *
     * * Keys and values can contain only lowercase letters, numeric characters,
     * underscores, and dashes.
     * * All characters must use UTF-8 encoding, and international characters are
     * allowed.
     * * Keys must start with a lowercase letter or international character.
     * * Each resource is limited to a maximum of 64 labels.
     *
     * Both keys and values are additionally constrained to be &lt;= 128 bytes.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000020;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Labels are attributes that can be set and used by both the
     * user and by Cloud Deploy. Labels must meet the following constraints:
     *
     * * Keys and values can contain only lowercase letters, numeric characters,
     * underscores, and dashes.
     * * All characters must use UTF-8 encoding, and international characters are
     * allowed.
     * * Keys must start with a lowercase letter or international character.
     * * Each resource is limited to a maximum of 64 labels.
     *
     * Both keys and values are additionally constrained to be &lt;= 128 bytes.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000020;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Labels are attributes that can be set and used by both the
     * user and by Cloud Deploy. Labels must meet the following constraints:
     *
     * * Keys and values can contain only lowercase letters, numeric characters,
     * underscores, and dashes.
     * * All characters must use UTF-8 encoding, and international characters are
     * allowed.
     * * Keys must start with a lowercase letter or international character.
     * * Each resource is limited to a maximum of 64 labels.
     *
     * Both keys and values are additionally constrained to be &lt;= 128 bytes.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000020;
      return this;
    }

    private boolean requireApproval_;
    /**
     *
     *
     * <pre>
     * Optional. Whether or not the `Target` requires approval.
     * </pre>
     *
     * <code>bool require_approval = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The requireApproval.
     */
    @java.lang.Override
    public boolean getRequireApproval() {
      return requireApproval_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Whether or not the `Target` requires approval.
     * </pre>
     *
     * <code>bool require_approval = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The requireApproval to set.
     * @return This builder for chaining.
     */
    public Builder setRequireApproval(boolean value) {

      requireApproval_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Whether or not the `Target` requires approval.
     * </pre>
     *
     * <code>bool require_approval = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRequireApproval() {
      bitField0_ = (bitField0_ & ~0x00000040);
      requireApproval_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `Target` was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `Target` was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `Target` was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `Target` was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `Target` was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `Target` was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000080);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `Target` was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `Target` was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `Target` was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Most recent time at which the `Target` was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Most recent time at which the `Target` was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Most recent time at which the `Target` was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Most recent time at which the `Target` was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Most recent time at which the `Target` was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Most recent time at which the `Target` was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000100);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Most recent time at which the `Target` was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Most recent time at which the `Target` was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Most recent time at which the `Target` was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.GkeCluster,
            com.google.cloud.deploy.v1.GkeCluster.Builder,
            com.google.cloud.deploy.v1.GkeClusterOrBuilder>
        gkeBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Information specifying a GKE Cluster.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.GkeCluster gke = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the gke field is set.
     */
    @java.lang.Override
    public boolean hasGke() {
      return deploymentTargetCase_ == 15;
    }
    /**
     *
     *
     * <pre>
     * Optional. Information specifying a GKE Cluster.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.GkeCluster gke = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The gke.
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.GkeCluster getGke() {
      if (gkeBuilder_ == null) {
        if (deploymentTargetCase_ == 15) {
          return (com.google.cloud.deploy.v1.GkeCluster) deploymentTarget_;
        }
        return com.google.cloud.deploy.v1.GkeCluster.getDefaultInstance();
      } else {
        if (deploymentTargetCase_ == 15) {
          return gkeBuilder_.getMessage();
        }
        return com.google.cloud.deploy.v1.GkeCluster.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Information specifying a GKE Cluster.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.GkeCluster gke = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setGke(com.google.cloud.deploy.v1.GkeCluster value) {
      if (gkeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        deploymentTarget_ = value;
        onChanged();
      } else {
        gkeBuilder_.setMessage(value);
      }
      deploymentTargetCase_ = 15;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Information specifying a GKE Cluster.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.GkeCluster gke = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setGke(com.google.cloud.deploy.v1.GkeCluster.Builder builderForValue) {
      if (gkeBuilder_ == null) {
        deploymentTarget_ = builderForValue.build();
        onChanged();
      } else {
        gkeBuilder_.setMessage(builderForValue.build());
      }
      deploymentTargetCase_ = 15;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Information specifying a GKE Cluster.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.GkeCluster gke = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeGke(com.google.cloud.deploy.v1.GkeCluster value) {
      if (gkeBuilder_ == null) {
        if (deploymentTargetCase_ == 15
            && deploymentTarget_ != com.google.cloud.deploy.v1.GkeCluster.getDefaultInstance()) {
          deploymentTarget_ =
              com.google.cloud.deploy.v1.GkeCluster.newBuilder(
                      (com.google.cloud.deploy.v1.GkeCluster) deploymentTarget_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          deploymentTarget_ = value;
        }
        onChanged();
      } else {
        if (deploymentTargetCase_ == 15) {
          gkeBuilder_.mergeFrom(value);
        } else {
          gkeBuilder_.setMessage(value);
        }
      }
      deploymentTargetCase_ = 15;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Information specifying a GKE Cluster.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.GkeCluster gke = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearGke() {
      if (gkeBuilder_ == null) {
        if (deploymentTargetCase_ == 15) {
          deploymentTargetCase_ = 0;
          deploymentTarget_ = null;
          onChanged();
        }
      } else {
        if (deploymentTargetCase_ == 15) {
          deploymentTargetCase_ = 0;
          deploymentTarget_ = null;
        }
        gkeBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Information specifying a GKE Cluster.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.GkeCluster gke = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.deploy.v1.GkeCluster.Builder getGkeBuilder() {
      return getGkeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Information specifying a GKE Cluster.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.GkeCluster gke = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.GkeClusterOrBuilder getGkeOrBuilder() {
      if ((deploymentTargetCase_ == 15) && (gkeBuilder_ != null)) {
        return gkeBuilder_.getMessageOrBuilder();
      } else {
        if (deploymentTargetCase_ == 15) {
          return (com.google.cloud.deploy.v1.GkeCluster) deploymentTarget_;
        }
        return com.google.cloud.deploy.v1.GkeCluster.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Information specifying a GKE Cluster.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.GkeCluster gke = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.GkeCluster,
            com.google.cloud.deploy.v1.GkeCluster.Builder,
            com.google.cloud.deploy.v1.GkeClusterOrBuilder>
        getGkeFieldBuilder() {
      if (gkeBuilder_ == null) {
        if (!(deploymentTargetCase_ == 15)) {
          deploymentTarget_ = com.google.cloud.deploy.v1.GkeCluster.getDefaultInstance();
        }
        gkeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.deploy.v1.GkeCluster,
                com.google.cloud.deploy.v1.GkeCluster.Builder,
                com.google.cloud.deploy.v1.GkeClusterOrBuilder>(
                (com.google.cloud.deploy.v1.GkeCluster) deploymentTarget_,
                getParentForChildren(),
                isClean());
        deploymentTarget_ = null;
      }
      deploymentTargetCase_ = 15;
      onChanged();
      return gkeBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.AnthosCluster,
            com.google.cloud.deploy.v1.AnthosCluster.Builder,
            com.google.cloud.deploy.v1.AnthosClusterOrBuilder>
        anthosClusterBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Information specifying an Anthos Cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AnthosCluster anthos_cluster = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the anthosCluster field is set.
     */
    @java.lang.Override
    public boolean hasAnthosCluster() {
      return deploymentTargetCase_ == 17;
    }
    /**
     *
     *
     * <pre>
     * Optional. Information specifying an Anthos Cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AnthosCluster anthos_cluster = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The anthosCluster.
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.AnthosCluster getAnthosCluster() {
      if (anthosClusterBuilder_ == null) {
        if (deploymentTargetCase_ == 17) {
          return (com.google.cloud.deploy.v1.AnthosCluster) deploymentTarget_;
        }
        return com.google.cloud.deploy.v1.AnthosCluster.getDefaultInstance();
      } else {
        if (deploymentTargetCase_ == 17) {
          return anthosClusterBuilder_.getMessage();
        }
        return com.google.cloud.deploy.v1.AnthosCluster.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Information specifying an Anthos Cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AnthosCluster anthos_cluster = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAnthosCluster(com.google.cloud.deploy.v1.AnthosCluster value) {
      if (anthosClusterBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        deploymentTarget_ = value;
        onChanged();
      } else {
        anthosClusterBuilder_.setMessage(value);
      }
      deploymentTargetCase_ = 17;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Information specifying an Anthos Cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AnthosCluster anthos_cluster = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAnthosCluster(
        com.google.cloud.deploy.v1.AnthosCluster.Builder builderForValue) {
      if (anthosClusterBuilder_ == null) {
        deploymentTarget_ = builderForValue.build();
        onChanged();
      } else {
        anthosClusterBuilder_.setMessage(builderForValue.build());
      }
      deploymentTargetCase_ = 17;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Information specifying an Anthos Cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AnthosCluster anthos_cluster = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeAnthosCluster(com.google.cloud.deploy.v1.AnthosCluster value) {
      if (anthosClusterBuilder_ == null) {
        if (deploymentTargetCase_ == 17
            && deploymentTarget_ != com.google.cloud.deploy.v1.AnthosCluster.getDefaultInstance()) {
          deploymentTarget_ =
              com.google.cloud.deploy.v1.AnthosCluster.newBuilder(
                      (com.google.cloud.deploy.v1.AnthosCluster) deploymentTarget_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          deploymentTarget_ = value;
        }
        onChanged();
      } else {
        if (deploymentTargetCase_ == 17) {
          anthosClusterBuilder_.mergeFrom(value);
        } else {
          anthosClusterBuilder_.setMessage(value);
        }
      }
      deploymentTargetCase_ = 17;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Information specifying an Anthos Cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AnthosCluster anthos_cluster = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearAnthosCluster() {
      if (anthosClusterBuilder_ == null) {
        if (deploymentTargetCase_ == 17) {
          deploymentTargetCase_ = 0;
          deploymentTarget_ = null;
          onChanged();
        }
      } else {
        if (deploymentTargetCase_ == 17) {
          deploymentTargetCase_ = 0;
          deploymentTarget_ = null;
        }
        anthosClusterBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Information specifying an Anthos Cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AnthosCluster anthos_cluster = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.deploy.v1.AnthosCluster.Builder getAnthosClusterBuilder() {
      return getAnthosClusterFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Information specifying an Anthos Cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AnthosCluster anthos_cluster = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.AnthosClusterOrBuilder getAnthosClusterOrBuilder() {
      if ((deploymentTargetCase_ == 17) && (anthosClusterBuilder_ != null)) {
        return anthosClusterBuilder_.getMessageOrBuilder();
      } else {
        if (deploymentTargetCase_ == 17) {
          return (com.google.cloud.deploy.v1.AnthosCluster) deploymentTarget_;
        }
        return com.google.cloud.deploy.v1.AnthosCluster.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Information specifying an Anthos Cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AnthosCluster anthos_cluster = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.AnthosCluster,
            com.google.cloud.deploy.v1.AnthosCluster.Builder,
            com.google.cloud.deploy.v1.AnthosClusterOrBuilder>
        getAnthosClusterFieldBuilder() {
      if (anthosClusterBuilder_ == null) {
        if (!(deploymentTargetCase_ == 17)) {
          deploymentTarget_ = com.google.cloud.deploy.v1.AnthosCluster.getDefaultInstance();
        }
        anthosClusterBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.deploy.v1.AnthosCluster,
                com.google.cloud.deploy.v1.AnthosCluster.Builder,
                com.google.cloud.deploy.v1.AnthosClusterOrBuilder>(
                (com.google.cloud.deploy.v1.AnthosCluster) deploymentTarget_,
                getParentForChildren(),
                isClean());
        deploymentTarget_ = null;
      }
      deploymentTargetCase_ = 17;
      onChanged();
      return anthosClusterBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.CloudRunLocation,
            com.google.cloud.deploy.v1.CloudRunLocation.Builder,
            com.google.cloud.deploy.v1.CloudRunLocationOrBuilder>
        runBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Information specifying a Cloud Run deployment target.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.CloudRunLocation run = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the run field is set.
     */
    @java.lang.Override
    public boolean hasRun() {
      return deploymentTargetCase_ == 18;
    }
    /**
     *
     *
     * <pre>
     * Optional. Information specifying a Cloud Run deployment target.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.CloudRunLocation run = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The run.
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.CloudRunLocation getRun() {
      if (runBuilder_ == null) {
        if (deploymentTargetCase_ == 18) {
          return (com.google.cloud.deploy.v1.CloudRunLocation) deploymentTarget_;
        }
        return com.google.cloud.deploy.v1.CloudRunLocation.getDefaultInstance();
      } else {
        if (deploymentTargetCase_ == 18) {
          return runBuilder_.getMessage();
        }
        return com.google.cloud.deploy.v1.CloudRunLocation.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Information specifying a Cloud Run deployment target.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.CloudRunLocation run = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRun(com.google.cloud.deploy.v1.CloudRunLocation value) {
      if (runBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        deploymentTarget_ = value;
        onChanged();
      } else {
        runBuilder_.setMessage(value);
      }
      deploymentTargetCase_ = 18;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Information specifying a Cloud Run deployment target.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.CloudRunLocation run = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRun(com.google.cloud.deploy.v1.CloudRunLocation.Builder builderForValue) {
      if (runBuilder_ == null) {
        deploymentTarget_ = builderForValue.build();
        onChanged();
      } else {
        runBuilder_.setMessage(builderForValue.build());
      }
      deploymentTargetCase_ = 18;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Information specifying a Cloud Run deployment target.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.CloudRunLocation run = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeRun(com.google.cloud.deploy.v1.CloudRunLocation value) {
      if (runBuilder_ == null) {
        if (deploymentTargetCase_ == 18
            && deploymentTarget_
                != com.google.cloud.deploy.v1.CloudRunLocation.getDefaultInstance()) {
          deploymentTarget_ =
              com.google.cloud.deploy.v1.CloudRunLocation.newBuilder(
                      (com.google.cloud.deploy.v1.CloudRunLocation) deploymentTarget_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          deploymentTarget_ = value;
        }
        onChanged();
      } else {
        if (deploymentTargetCase_ == 18) {
          runBuilder_.mergeFrom(value);
        } else {
          runBuilder_.setMessage(value);
        }
      }
      deploymentTargetCase_ = 18;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Information specifying a Cloud Run deployment target.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.CloudRunLocation run = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearRun() {
      if (runBuilder_ == null) {
        if (deploymentTargetCase_ == 18) {
          deploymentTargetCase_ = 0;
          deploymentTarget_ = null;
          onChanged();
        }
      } else {
        if (deploymentTargetCase_ == 18) {
          deploymentTargetCase_ = 0;
          deploymentTarget_ = null;
        }
        runBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Information specifying a Cloud Run deployment target.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.CloudRunLocation run = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.deploy.v1.CloudRunLocation.Builder getRunBuilder() {
      return getRunFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Information specifying a Cloud Run deployment target.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.CloudRunLocation run = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.CloudRunLocationOrBuilder getRunOrBuilder() {
      if ((deploymentTargetCase_ == 18) && (runBuilder_ != null)) {
        return runBuilder_.getMessageOrBuilder();
      } else {
        if (deploymentTargetCase_ == 18) {
          return (com.google.cloud.deploy.v1.CloudRunLocation) deploymentTarget_;
        }
        return com.google.cloud.deploy.v1.CloudRunLocation.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Information specifying a Cloud Run deployment target.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.CloudRunLocation run = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.CloudRunLocation,
            com.google.cloud.deploy.v1.CloudRunLocation.Builder,
            com.google.cloud.deploy.v1.CloudRunLocationOrBuilder>
        getRunFieldBuilder() {
      if (runBuilder_ == null) {
        if (!(deploymentTargetCase_ == 18)) {
          deploymentTarget_ = com.google.cloud.deploy.v1.CloudRunLocation.getDefaultInstance();
        }
        runBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.deploy.v1.CloudRunLocation,
                com.google.cloud.deploy.v1.CloudRunLocation.Builder,
                com.google.cloud.deploy.v1.CloudRunLocationOrBuilder>(
                (com.google.cloud.deploy.v1.CloudRunLocation) deploymentTarget_,
                getParentForChildren(),
                isClean());
        deploymentTarget_ = null;
      }
      deploymentTargetCase_ = 18;
      onChanged();
      return runBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.MultiTarget,
            com.google.cloud.deploy.v1.MultiTarget.Builder,
            com.google.cloud.deploy.v1.MultiTargetOrBuilder>
        multiTargetBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Information specifying a multiTarget.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.MultiTarget multi_target = 19 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the multiTarget field is set.
     */
    @java.lang.Override
    public boolean hasMultiTarget() {
      return deploymentTargetCase_ == 19;
    }
    /**
     *
     *
     * <pre>
     * Optional. Information specifying a multiTarget.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.MultiTarget multi_target = 19 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The multiTarget.
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.MultiTarget getMultiTarget() {
      if (multiTargetBuilder_ == null) {
        if (deploymentTargetCase_ == 19) {
          return (com.google.cloud.deploy.v1.MultiTarget) deploymentTarget_;
        }
        return com.google.cloud.deploy.v1.MultiTarget.getDefaultInstance();
      } else {
        if (deploymentTargetCase_ == 19) {
          return multiTargetBuilder_.getMessage();
        }
        return com.google.cloud.deploy.v1.MultiTarget.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Information specifying a multiTarget.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.MultiTarget multi_target = 19 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setMultiTarget(com.google.cloud.deploy.v1.MultiTarget value) {
      if (multiTargetBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        deploymentTarget_ = value;
        onChanged();
      } else {
        multiTargetBuilder_.setMessage(value);
      }
      deploymentTargetCase_ = 19;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Information specifying a multiTarget.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.MultiTarget multi_target = 19 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setMultiTarget(com.google.cloud.deploy.v1.MultiTarget.Builder builderForValue) {
      if (multiTargetBuilder_ == null) {
        deploymentTarget_ = builderForValue.build();
        onChanged();
      } else {
        multiTargetBuilder_.setMessage(builderForValue.build());
      }
      deploymentTargetCase_ = 19;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Information specifying a multiTarget.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.MultiTarget multi_target = 19 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeMultiTarget(com.google.cloud.deploy.v1.MultiTarget value) {
      if (multiTargetBuilder_ == null) {
        if (deploymentTargetCase_ == 19
            && deploymentTarget_ != com.google.cloud.deploy.v1.MultiTarget.getDefaultInstance()) {
          deploymentTarget_ =
              com.google.cloud.deploy.v1.MultiTarget.newBuilder(
                      (com.google.cloud.deploy.v1.MultiTarget) deploymentTarget_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          deploymentTarget_ = value;
        }
        onChanged();
      } else {
        if (deploymentTargetCase_ == 19) {
          multiTargetBuilder_.mergeFrom(value);
        } else {
          multiTargetBuilder_.setMessage(value);
        }
      }
      deploymentTargetCase_ = 19;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Information specifying a multiTarget.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.MultiTarget multi_target = 19 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearMultiTarget() {
      if (multiTargetBuilder_ == null) {
        if (deploymentTargetCase_ == 19) {
          deploymentTargetCase_ = 0;
          deploymentTarget_ = null;
          onChanged();
        }
      } else {
        if (deploymentTargetCase_ == 19) {
          deploymentTargetCase_ = 0;
          deploymentTarget_ = null;
        }
        multiTargetBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Information specifying a multiTarget.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.MultiTarget multi_target = 19 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.deploy.v1.MultiTarget.Builder getMultiTargetBuilder() {
      return getMultiTargetFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Information specifying a multiTarget.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.MultiTarget multi_target = 19 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.MultiTargetOrBuilder getMultiTargetOrBuilder() {
      if ((deploymentTargetCase_ == 19) && (multiTargetBuilder_ != null)) {
        return multiTargetBuilder_.getMessageOrBuilder();
      } else {
        if (deploymentTargetCase_ == 19) {
          return (com.google.cloud.deploy.v1.MultiTarget) deploymentTarget_;
        }
        return com.google.cloud.deploy.v1.MultiTarget.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Information specifying a multiTarget.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.MultiTarget multi_target = 19 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.MultiTarget,
            com.google.cloud.deploy.v1.MultiTarget.Builder,
            com.google.cloud.deploy.v1.MultiTargetOrBuilder>
        getMultiTargetFieldBuilder() {
      if (multiTargetBuilder_ == null) {
        if (!(deploymentTargetCase_ == 19)) {
          deploymentTarget_ = com.google.cloud.deploy.v1.MultiTarget.getDefaultInstance();
        }
        multiTargetBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.deploy.v1.MultiTarget,
                com.google.cloud.deploy.v1.MultiTarget.Builder,
                com.google.cloud.deploy.v1.MultiTargetOrBuilder>(
                (com.google.cloud.deploy.v1.MultiTarget) deploymentTarget_,
                getParentForChildren(),
                isClean());
        deploymentTarget_ = null;
      }
      deploymentTargetCase_ = 19;
      onChanged();
      return multiTargetBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.CustomTarget,
            com.google.cloud.deploy.v1.CustomTarget.Builder,
            com.google.cloud.deploy.v1.CustomTargetOrBuilder>
        customTargetBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Information specifying a Custom Target.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.CustomTarget custom_target = 21 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the customTarget field is set.
     */
    @java.lang.Override
    public boolean hasCustomTarget() {
      return deploymentTargetCase_ == 21;
    }
    /**
     *
     *
     * <pre>
     * Optional. Information specifying a Custom Target.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.CustomTarget custom_target = 21 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The customTarget.
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.CustomTarget getCustomTarget() {
      if (customTargetBuilder_ == null) {
        if (deploymentTargetCase_ == 21) {
          return (com.google.cloud.deploy.v1.CustomTarget) deploymentTarget_;
        }
        return com.google.cloud.deploy.v1.CustomTarget.getDefaultInstance();
      } else {
        if (deploymentTargetCase_ == 21) {
          return customTargetBuilder_.getMessage();
        }
        return com.google.cloud.deploy.v1.CustomTarget.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Information specifying a Custom Target.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.CustomTarget custom_target = 21 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setCustomTarget(com.google.cloud.deploy.v1.CustomTarget value) {
      if (customTargetBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        deploymentTarget_ = value;
        onChanged();
      } else {
        customTargetBuilder_.setMessage(value);
      }
      deploymentTargetCase_ = 21;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Information specifying a Custom Target.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.CustomTarget custom_target = 21 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setCustomTarget(
        com.google.cloud.deploy.v1.CustomTarget.Builder builderForValue) {
      if (customTargetBuilder_ == null) {
        deploymentTarget_ = builderForValue.build();
        onChanged();
      } else {
        customTargetBuilder_.setMessage(builderForValue.build());
      }
      deploymentTargetCase_ = 21;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Information specifying a Custom Target.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.CustomTarget custom_target = 21 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeCustomTarget(com.google.cloud.deploy.v1.CustomTarget value) {
      if (customTargetBuilder_ == null) {
        if (deploymentTargetCase_ == 21
            && deploymentTarget_ != com.google.cloud.deploy.v1.CustomTarget.getDefaultInstance()) {
          deploymentTarget_ =
              com.google.cloud.deploy.v1.CustomTarget.newBuilder(
                      (com.google.cloud.deploy.v1.CustomTarget) deploymentTarget_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          deploymentTarget_ = value;
        }
        onChanged();
      } else {
        if (deploymentTargetCase_ == 21) {
          customTargetBuilder_.mergeFrom(value);
        } else {
          customTargetBuilder_.setMessage(value);
        }
      }
      deploymentTargetCase_ = 21;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Information specifying a Custom Target.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.CustomTarget custom_target = 21 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearCustomTarget() {
      if (customTargetBuilder_ == null) {
        if (deploymentTargetCase_ == 21) {
          deploymentTargetCase_ = 0;
          deploymentTarget_ = null;
          onChanged();
        }
      } else {
        if (deploymentTargetCase_ == 21) {
          deploymentTargetCase_ = 0;
          deploymentTarget_ = null;
        }
        customTargetBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Information specifying a Custom Target.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.CustomTarget custom_target = 21 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.deploy.v1.CustomTarget.Builder getCustomTargetBuilder() {
      return getCustomTargetFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Information specifying a Custom Target.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.CustomTarget custom_target = 21 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.CustomTargetOrBuilder getCustomTargetOrBuilder() {
      if ((deploymentTargetCase_ == 21) && (customTargetBuilder_ != null)) {
        return customTargetBuilder_.getMessageOrBuilder();
      } else {
        if (deploymentTargetCase_ == 21) {
          return (com.google.cloud.deploy.v1.CustomTarget) deploymentTarget_;
        }
        return com.google.cloud.deploy.v1.CustomTarget.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Information specifying a Custom Target.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.CustomTarget custom_target = 21 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.CustomTarget,
            com.google.cloud.deploy.v1.CustomTarget.Builder,
            com.google.cloud.deploy.v1.CustomTargetOrBuilder>
        getCustomTargetFieldBuilder() {
      if (customTargetBuilder_ == null) {
        if (!(deploymentTargetCase_ == 21)) {
          deploymentTarget_ = com.google.cloud.deploy.v1.CustomTarget.getDefaultInstance();
        }
        customTargetBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.deploy.v1.CustomTarget,
                com.google.cloud.deploy.v1.CustomTarget.Builder,
                com.google.cloud.deploy.v1.CustomTargetOrBuilder>(
                (com.google.cloud.deploy.v1.CustomTarget) deploymentTarget_,
                getParentForChildren(),
                isClean());
        deploymentTarget_ = null;
      }
      deploymentTargetCase_ = 21;
      onChanged();
      return customTargetBuilder_;
    }

    private static final class AssociatedEntitiesConverter
        implements com.google.protobuf.MapFieldBuilder.Converter<
            java.lang.String,
            com.google.cloud.deploy.v1.AssociatedEntitiesOrBuilder,
            com.google.cloud.deploy.v1.AssociatedEntities> {
      @java.lang.Override
      public com.google.cloud.deploy.v1.AssociatedEntities build(
          com.google.cloud.deploy.v1.AssociatedEntitiesOrBuilder val) {
        if (val instanceof com.google.cloud.deploy.v1.AssociatedEntities) {
          return (com.google.cloud.deploy.v1.AssociatedEntities) val;
        }
        return ((com.google.cloud.deploy.v1.AssociatedEntities.Builder) val).build();
      }

      @java.lang.Override
      public com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.deploy.v1.AssociatedEntities>
          defaultEntry() {
        return AssociatedEntitiesDefaultEntryHolder.defaultEntry;
      }
    };

    private static final AssociatedEntitiesConverter associatedEntitiesConverter =
        new AssociatedEntitiesConverter();

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.deploy.v1.AssociatedEntitiesOrBuilder,
            com.google.cloud.deploy.v1.AssociatedEntities,
            com.google.cloud.deploy.v1.AssociatedEntities.Builder>
        associatedEntities_;

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.deploy.v1.AssociatedEntitiesOrBuilder,
            com.google.cloud.deploy.v1.AssociatedEntities,
            com.google.cloud.deploy.v1.AssociatedEntities.Builder>
        internalGetAssociatedEntities() {
      if (associatedEntities_ == null) {
        return new com.google.protobuf.MapFieldBuilder<>(associatedEntitiesConverter);
      }
      return associatedEntities_;
    }

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.deploy.v1.AssociatedEntitiesOrBuilder,
            com.google.cloud.deploy.v1.AssociatedEntities,
            com.google.cloud.deploy.v1.AssociatedEntities.Builder>
        internalGetMutableAssociatedEntities() {
      if (associatedEntities_ == null) {
        associatedEntities_ =
            new com.google.protobuf.MapFieldBuilder<>(associatedEntitiesConverter);
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return associatedEntities_;
    }

    public int getAssociatedEntitiesCount() {
      return internalGetAssociatedEntities().ensureBuilderMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Map of entity IDs to their associated entities. Associated
     * entities allows specifying places other than the deployment target for
     * specific features. For example, the Gateway API canary can be configured to
     * deploy the HTTPRoute to a different cluster(s) than the deployment cluster
     * using associated entities. An entity ID must consist of lower-case letters,
     * numbers, and hyphens, start with a letter and end with a letter or a
     * number, and have a max length of 63 characters. In other words, it must
     * match the following regex: `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.deploy.v1.AssociatedEntities&gt; associated_entities = 23 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public boolean containsAssociatedEntities(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetAssociatedEntities().ensureBuilderMap().containsKey(key);
    }
    /** Use {@link #getAssociatedEntitiesMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.deploy.v1.AssociatedEntities>
        getAssociatedEntities() {
      return getAssociatedEntitiesMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Map of entity IDs to their associated entities. Associated
     * entities allows specifying places other than the deployment target for
     * specific features. For example, the Gateway API canary can be configured to
     * deploy the HTTPRoute to a different cluster(s) than the deployment cluster
     * using associated entities. An entity ID must consist of lower-case letters,
     * numbers, and hyphens, start with a letter and end with a letter or a
     * number, and have a max length of 63 characters. In other words, it must
     * match the following regex: `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.deploy.v1.AssociatedEntities&gt; associated_entities = 23 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, com.google.cloud.deploy.v1.AssociatedEntities>
        getAssociatedEntitiesMap() {
      return internalGetAssociatedEntities().getImmutableMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Map of entity IDs to their associated entities. Associated
     * entities allows specifying places other than the deployment target for
     * specific features. For example, the Gateway API canary can be configured to
     * deploy the HTTPRoute to a different cluster(s) than the deployment cluster
     * using associated entities. An entity ID must consist of lower-case letters,
     * numbers, and hyphens, start with a letter and end with a letter or a
     * number, and have a max length of 63 characters. In other words, it must
     * match the following regex: `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.deploy.v1.AssociatedEntities&gt; associated_entities = 23 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ com.google.cloud.deploy.v1.AssociatedEntities
        getAssociatedEntitiesOrDefault(
            java.lang.String key,
            /* nullable */
            com.google.cloud.deploy.v1.AssociatedEntities defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.deploy.v1.AssociatedEntitiesOrBuilder> map =
          internalGetMutableAssociatedEntities().ensureBuilderMap();
      return map.containsKey(key) ? associatedEntitiesConverter.build(map.get(key)) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional. Map of entity IDs to their associated entities. Associated
     * entities allows specifying places other than the deployment target for
     * specific features. For example, the Gateway API canary can be configured to
     * deploy the HTTPRoute to a different cluster(s) than the deployment cluster
     * using associated entities. An entity ID must consist of lower-case letters,
     * numbers, and hyphens, start with a letter and end with a letter or a
     * number, and have a max length of 63 characters. In other words, it must
     * match the following regex: `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.deploy.v1.AssociatedEntities&gt; associated_entities = 23 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.AssociatedEntities getAssociatedEntitiesOrThrow(
        java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.deploy.v1.AssociatedEntitiesOrBuilder> map =
          internalGetMutableAssociatedEntities().ensureBuilderMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return associatedEntitiesConverter.build(map.get(key));
    }

    public Builder clearAssociatedEntities() {
      bitField0_ = (bitField0_ & ~0x00004000);
      internalGetMutableAssociatedEntities().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Map of entity IDs to their associated entities. Associated
     * entities allows specifying places other than the deployment target for
     * specific features. For example, the Gateway API canary can be configured to
     * deploy the HTTPRoute to a different cluster(s) than the deployment cluster
     * using associated entities. An entity ID must consist of lower-case letters,
     * numbers, and hyphens, start with a letter and end with a letter or a
     * number, and have a max length of 63 characters. In other words, it must
     * match the following regex: `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.deploy.v1.AssociatedEntities&gt; associated_entities = 23 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeAssociatedEntities(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableAssociatedEntities().ensureBuilderMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.deploy.v1.AssociatedEntities>
        getMutableAssociatedEntities() {
      bitField0_ |= 0x00004000;
      return internalGetMutableAssociatedEntities().ensureMessageMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Map of entity IDs to their associated entities. Associated
     * entities allows specifying places other than the deployment target for
     * specific features. For example, the Gateway API canary can be configured to
     * deploy the HTTPRoute to a different cluster(s) than the deployment cluster
     * using associated entities. An entity ID must consist of lower-case letters,
     * numbers, and hyphens, start with a letter and end with a letter or a
     * number, and have a max length of 63 characters. In other words, it must
     * match the following regex: `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.deploy.v1.AssociatedEntities&gt; associated_entities = 23 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putAssociatedEntities(
        java.lang.String key, com.google.cloud.deploy.v1.AssociatedEntities value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableAssociatedEntities().ensureBuilderMap().put(key, value);
      bitField0_ |= 0x00004000;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Map of entity IDs to their associated entities. Associated
     * entities allows specifying places other than the deployment target for
     * specific features. For example, the Gateway API canary can be configured to
     * deploy the HTTPRoute to a different cluster(s) than the deployment cluster
     * using associated entities. An entity ID must consist of lower-case letters,
     * numbers, and hyphens, start with a letter and end with a letter or a
     * number, and have a max length of 63 characters. In other words, it must
     * match the following regex: `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.deploy.v1.AssociatedEntities&gt; associated_entities = 23 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putAllAssociatedEntities(
        java.util.Map<java.lang.String, com.google.cloud.deploy.v1.AssociatedEntities> values) {
      for (java.util.Map.Entry<java.lang.String, com.google.cloud.deploy.v1.AssociatedEntities> e :
          values.entrySet()) {
        if (e.getKey() == null || e.getValue() == null) {
          throw new NullPointerException();
        }
      }
      internalGetMutableAssociatedEntities().ensureBuilderMap().putAll(values);
      bitField0_ |= 0x00004000;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Map of entity IDs to their associated entities. Associated
     * entities allows specifying places other than the deployment target for
     * specific features. For example, the Gateway API canary can be configured to
     * deploy the HTTPRoute to a different cluster(s) than the deployment cluster
     * using associated entities. An entity ID must consist of lower-case letters,
     * numbers, and hyphens, start with a letter and end with a letter or a
     * number, and have a max length of 63 characters. In other words, it must
     * match the following regex: `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.deploy.v1.AssociatedEntities&gt; associated_entities = 23 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.deploy.v1.AssociatedEntities.Builder
        putAssociatedEntitiesBuilderIfAbsent(java.lang.String key) {
      java.util.Map<java.lang.String, com.google.cloud.deploy.v1.AssociatedEntitiesOrBuilder>
          builderMap = internalGetMutableAssociatedEntities().ensureBuilderMap();
      com.google.cloud.deploy.v1.AssociatedEntitiesOrBuilder entry = builderMap.get(key);
      if (entry == null) {
        entry = com.google.cloud.deploy.v1.AssociatedEntities.newBuilder();
        builderMap.put(key, entry);
      }
      if (entry instanceof com.google.cloud.deploy.v1.AssociatedEntities) {
        entry = ((com.google.cloud.deploy.v1.AssociatedEntities) entry).toBuilder();
        builderMap.put(key, entry);
      }
      return (com.google.cloud.deploy.v1.AssociatedEntities.Builder) entry;
    }

    private java.lang.Object etag_ = "";
    /**
     *
     *
     * <pre>
     * Optional. This checksum is computed by the server based on the value of
     * other fields, and may be sent on update and delete requests to ensure the
     * client has an up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The etag.
     */
    public java.lang.String getEtag() {
      java.lang.Object ref = etag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        etag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. This checksum is computed by the server based on the value of
     * other fields, and may be sent on update and delete requests to ensure the
     * client has an up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for etag.
     */
    public com.google.protobuf.ByteString getEtagBytes() {
      java.lang.Object ref = etag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        etag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. This checksum is computed by the server based on the value of
     * other fields, and may be sent on update and delete requests to ensure the
     * client has an up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      etag_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. This checksum is computed by the server based on the value of
     * other fields, and may be sent on update and delete requests to ensure the
     * client has an up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEtag() {
      etag_ = getDefaultInstance().getEtag();
      bitField0_ = (bitField0_ & ~0x00008000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. This checksum is computed by the server based on the value of
     * other fields, and may be sent on update and delete requests to ensure the
     * client has an up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      etag_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.deploy.v1.ExecutionConfig> executionConfigs_ =
        java.util.Collections.emptyList();

    private void ensureExecutionConfigsIsMutable() {
      if (!((bitField0_ & 0x00010000) != 0)) {
        executionConfigs_ =
            new java.util.ArrayList<com.google.cloud.deploy.v1.ExecutionConfig>(executionConfigs_);
        bitField0_ |= 0x00010000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.deploy.v1.ExecutionConfig,
            com.google.cloud.deploy.v1.ExecutionConfig.Builder,
            com.google.cloud.deploy.v1.ExecutionConfigOrBuilder>
        executionConfigsBuilder_;

    /**
     *
     *
     * <pre>
     * Configurations for all execution that relates to this `Target`.
     * Each `ExecutionEnvironmentUsage` value may only be used in a single
     * configuration; using the same value multiple times is an error.
     * When one or more configurations are specified, they must include the
     * `RENDER` and `DEPLOY` `ExecutionEnvironmentUsage` values.
     * When no configurations are specified, execution will use the default
     * specified in `DefaultPool`.
     * </pre>
     *
     * <code>repeated .google.cloud.deploy.v1.ExecutionConfig execution_configs = 16;</code>
     */
    public java.util.List<com.google.cloud.deploy.v1.ExecutionConfig> getExecutionConfigsList() {
      if (executionConfigsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(executionConfigs_);
      } else {
        return executionConfigsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Configurations for all execution that relates to this `Target`.
     * Each `ExecutionEnvironmentUsage` value may only be used in a single
     * configuration; using the same value multiple times is an error.
     * When one or more configurations are specified, they must include the
     * `RENDER` and `DEPLOY` `ExecutionEnvironmentUsage` values.
     * When no configurations are specified, execution will use the default
     * specified in `DefaultPool`.
     * </pre>
     *
     * <code>repeated .google.cloud.deploy.v1.ExecutionConfig execution_configs = 16;</code>
     */
    public int getExecutionConfigsCount() {
      if (executionConfigsBuilder_ == null) {
        return executionConfigs_.size();
      } else {
        return executionConfigsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Configurations for all execution that relates to this `Target`.
     * Each `ExecutionEnvironmentUsage` value may only be used in a single
     * configuration; using the same value multiple times is an error.
     * When one or more configurations are specified, they must include the
     * `RENDER` and `DEPLOY` `ExecutionEnvironmentUsage` values.
     * When no configurations are specified, execution will use the default
     * specified in `DefaultPool`.
     * </pre>
     *
     * <code>repeated .google.cloud.deploy.v1.ExecutionConfig execution_configs = 16;</code>
     */
    public com.google.cloud.deploy.v1.ExecutionConfig getExecutionConfigs(int index) {
      if (executionConfigsBuilder_ == null) {
        return executionConfigs_.get(index);
      } else {
        return executionConfigsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Configurations for all execution that relates to this `Target`.
     * Each `ExecutionEnvironmentUsage` value may only be used in a single
     * configuration; using the same value multiple times is an error.
     * When one or more configurations are specified, they must include the
     * `RENDER` and `DEPLOY` `ExecutionEnvironmentUsage` values.
     * When no configurations are specified, execution will use the default
     * specified in `DefaultPool`.
     * </pre>
     *
     * <code>repeated .google.cloud.deploy.v1.ExecutionConfig execution_configs = 16;</code>
     */
    public Builder setExecutionConfigs(
        int index, com.google.cloud.deploy.v1.ExecutionConfig value) {
      if (executionConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExecutionConfigsIsMutable();
        executionConfigs_.set(index, value);
        onChanged();
      } else {
        executionConfigsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configurations for all execution that relates to this `Target`.
     * Each `ExecutionEnvironmentUsage` value may only be used in a single
     * configuration; using the same value multiple times is an error.
     * When one or more configurations are specified, they must include the
     * `RENDER` and `DEPLOY` `ExecutionEnvironmentUsage` values.
     * When no configurations are specified, execution will use the default
     * specified in `DefaultPool`.
     * </pre>
     *
     * <code>repeated .google.cloud.deploy.v1.ExecutionConfig execution_configs = 16;</code>
     */
    public Builder setExecutionConfigs(
        int index, com.google.cloud.deploy.v1.ExecutionConfig.Builder builderForValue) {
      if (executionConfigsBuilder_ == null) {
        ensureExecutionConfigsIsMutable();
        executionConfigs_.set(index, builderForValue.build());
        onChanged();
      } else {
        executionConfigsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configurations for all execution that relates to this `Target`.
     * Each `ExecutionEnvironmentUsage` value may only be used in a single
     * configuration; using the same value multiple times is an error.
     * When one or more configurations are specified, they must include the
     * `RENDER` and `DEPLOY` `ExecutionEnvironmentUsage` values.
     * When no configurations are specified, execution will use the default
     * specified in `DefaultPool`.
     * </pre>
     *
     * <code>repeated .google.cloud.deploy.v1.ExecutionConfig execution_configs = 16;</code>
     */
    public Builder addExecutionConfigs(com.google.cloud.deploy.v1.ExecutionConfig value) {
      if (executionConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExecutionConfigsIsMutable();
        executionConfigs_.add(value);
        onChanged();
      } else {
        executionConfigsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configurations for all execution that relates to this `Target`.
     * Each `ExecutionEnvironmentUsage` value may only be used in a single
     * configuration; using the same value multiple times is an error.
     * When one or more configurations are specified, they must include the
     * `RENDER` and `DEPLOY` `ExecutionEnvironmentUsage` values.
     * When no configurations are specified, execution will use the default
     * specified in `DefaultPool`.
     * </pre>
     *
     * <code>repeated .google.cloud.deploy.v1.ExecutionConfig execution_configs = 16;</code>
     */
    public Builder addExecutionConfigs(
        int index, com.google.cloud.deploy.v1.ExecutionConfig value) {
      if (executionConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExecutionConfigsIsMutable();
        executionConfigs_.add(index, value);
        onChanged();
      } else {
        executionConfigsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configurations for all execution that relates to this `Target`.
     * Each `ExecutionEnvironmentUsage` value may only be used in a single
     * configuration; using the same value multiple times is an error.
     * When one or more configurations are specified, they must include the
     * `RENDER` and `DEPLOY` `ExecutionEnvironmentUsage` values.
     * When no configurations are specified, execution will use the default
     * specified in `DefaultPool`.
     * </pre>
     *
     * <code>repeated .google.cloud.deploy.v1.ExecutionConfig execution_configs = 16;</code>
     */
    public Builder addExecutionConfigs(
        com.google.cloud.deploy.v1.ExecutionConfig.Builder builderForValue) {
      if (executionConfigsBuilder_ == null) {
        ensureExecutionConfigsIsMutable();
        executionConfigs_.add(builderForValue.build());
        onChanged();
      } else {
        executionConfigsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configurations for all execution that relates to this `Target`.
     * Each `ExecutionEnvironmentUsage` value may only be used in a single
     * configuration; using the same value multiple times is an error.
     * When one or more configurations are specified, they must include the
     * `RENDER` and `DEPLOY` `ExecutionEnvironmentUsage` values.
     * When no configurations are specified, execution will use the default
     * specified in `DefaultPool`.
     * </pre>
     *
     * <code>repeated .google.cloud.deploy.v1.ExecutionConfig execution_configs = 16;</code>
     */
    public Builder addExecutionConfigs(
        int index, com.google.cloud.deploy.v1.ExecutionConfig.Builder builderForValue) {
      if (executionConfigsBuilder_ == null) {
        ensureExecutionConfigsIsMutable();
        executionConfigs_.add(index, builderForValue.build());
        onChanged();
      } else {
        executionConfigsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configurations for all execution that relates to this `Target`.
     * Each `ExecutionEnvironmentUsage` value may only be used in a single
     * configuration; using the same value multiple times is an error.
     * When one or more configurations are specified, they must include the
     * `RENDER` and `DEPLOY` `ExecutionEnvironmentUsage` values.
     * When no configurations are specified, execution will use the default
     * specified in `DefaultPool`.
     * </pre>
     *
     * <code>repeated .google.cloud.deploy.v1.ExecutionConfig execution_configs = 16;</code>
     */
    public Builder addAllExecutionConfigs(
        java.lang.Iterable<? extends com.google.cloud.deploy.v1.ExecutionConfig> values) {
      if (executionConfigsBuilder_ == null) {
        ensureExecutionConfigsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, executionConfigs_);
        onChanged();
      } else {
        executionConfigsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configurations for all execution that relates to this `Target`.
     * Each `ExecutionEnvironmentUsage` value may only be used in a single
     * configuration; using the same value multiple times is an error.
     * When one or more configurations are specified, they must include the
     * `RENDER` and `DEPLOY` `ExecutionEnvironmentUsage` values.
     * When no configurations are specified, execution will use the default
     * specified in `DefaultPool`.
     * </pre>
     *
     * <code>repeated .google.cloud.deploy.v1.ExecutionConfig execution_configs = 16;</code>
     */
    public Builder clearExecutionConfigs() {
      if (executionConfigsBuilder_ == null) {
        executionConfigs_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00010000);
        onChanged();
      } else {
        executionConfigsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configurations for all execution that relates to this `Target`.
     * Each `ExecutionEnvironmentUsage` value may only be used in a single
     * configuration; using the same value multiple times is an error.
     * When one or more configurations are specified, they must include the
     * `RENDER` and `DEPLOY` `ExecutionEnvironmentUsage` values.
     * When no configurations are specified, execution will use the default
     * specified in `DefaultPool`.
     * </pre>
     *
     * <code>repeated .google.cloud.deploy.v1.ExecutionConfig execution_configs = 16;</code>
     */
    public Builder removeExecutionConfigs(int index) {
      if (executionConfigsBuilder_ == null) {
        ensureExecutionConfigsIsMutable();
        executionConfigs_.remove(index);
        onChanged();
      } else {
        executionConfigsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configurations for all execution that relates to this `Target`.
     * Each `ExecutionEnvironmentUsage` value may only be used in a single
     * configuration; using the same value multiple times is an error.
     * When one or more configurations are specified, they must include the
     * `RENDER` and `DEPLOY` `ExecutionEnvironmentUsage` values.
     * When no configurations are specified, execution will use the default
     * specified in `DefaultPool`.
     * </pre>
     *
     * <code>repeated .google.cloud.deploy.v1.ExecutionConfig execution_configs = 16;</code>
     */
    public com.google.cloud.deploy.v1.ExecutionConfig.Builder getExecutionConfigsBuilder(
        int index) {
      return getExecutionConfigsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Configurations for all execution that relates to this `Target`.
     * Each `ExecutionEnvironmentUsage` value may only be used in a single
     * configuration; using the same value multiple times is an error.
     * When one or more configurations are specified, they must include the
     * `RENDER` and `DEPLOY` `ExecutionEnvironmentUsage` values.
     * When no configurations are specified, execution will use the default
     * specified in `DefaultPool`.
     * </pre>
     *
     * <code>repeated .google.cloud.deploy.v1.ExecutionConfig execution_configs = 16;</code>
     */
    public com.google.cloud.deploy.v1.ExecutionConfigOrBuilder getExecutionConfigsOrBuilder(
        int index) {
      if (executionConfigsBuilder_ == null) {
        return executionConfigs_.get(index);
      } else {
        return executionConfigsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Configurations for all execution that relates to this `Target`.
     * Each `ExecutionEnvironmentUsage` value may only be used in a single
     * configuration; using the same value multiple times is an error.
     * When one or more configurations are specified, they must include the
     * `RENDER` and `DEPLOY` `ExecutionEnvironmentUsage` values.
     * When no configurations are specified, execution will use the default
     * specified in `DefaultPool`.
     * </pre>
     *
     * <code>repeated .google.cloud.deploy.v1.ExecutionConfig execution_configs = 16;</code>
     */
    public java.util.List<? extends com.google.cloud.deploy.v1.ExecutionConfigOrBuilder>
        getExecutionConfigsOrBuilderList() {
      if (executionConfigsBuilder_ != null) {
        return executionConfigsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(executionConfigs_);
      }
    }
    /**
     *
     *
     * <pre>
     * Configurations for all execution that relates to this `Target`.
     * Each `ExecutionEnvironmentUsage` value may only be used in a single
     * configuration; using the same value multiple times is an error.
     * When one or more configurations are specified, they must include the
     * `RENDER` and `DEPLOY` `ExecutionEnvironmentUsage` values.
     * When no configurations are specified, execution will use the default
     * specified in `DefaultPool`.
     * </pre>
     *
     * <code>repeated .google.cloud.deploy.v1.ExecutionConfig execution_configs = 16;</code>
     */
    public com.google.cloud.deploy.v1.ExecutionConfig.Builder addExecutionConfigsBuilder() {
      return getExecutionConfigsFieldBuilder()
          .addBuilder(com.google.cloud.deploy.v1.ExecutionConfig.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Configurations for all execution that relates to this `Target`.
     * Each `ExecutionEnvironmentUsage` value may only be used in a single
     * configuration; using the same value multiple times is an error.
     * When one or more configurations are specified, they must include the
     * `RENDER` and `DEPLOY` `ExecutionEnvironmentUsage` values.
     * When no configurations are specified, execution will use the default
     * specified in `DefaultPool`.
     * </pre>
     *
     * <code>repeated .google.cloud.deploy.v1.ExecutionConfig execution_configs = 16;</code>
     */
    public com.google.cloud.deploy.v1.ExecutionConfig.Builder addExecutionConfigsBuilder(
        int index) {
      return getExecutionConfigsFieldBuilder()
          .addBuilder(index, com.google.cloud.deploy.v1.ExecutionConfig.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Configurations for all execution that relates to this `Target`.
     * Each `ExecutionEnvironmentUsage` value may only be used in a single
     * configuration; using the same value multiple times is an error.
     * When one or more configurations are specified, they must include the
     * `RENDER` and `DEPLOY` `ExecutionEnvironmentUsage` values.
     * When no configurations are specified, execution will use the default
     * specified in `DefaultPool`.
     * </pre>
     *
     * <code>repeated .google.cloud.deploy.v1.ExecutionConfig execution_configs = 16;</code>
     */
    public java.util.List<com.google.cloud.deploy.v1.ExecutionConfig.Builder>
        getExecutionConfigsBuilderList() {
      return getExecutionConfigsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.deploy.v1.ExecutionConfig,
            com.google.cloud.deploy.v1.ExecutionConfig.Builder,
            com.google.cloud.deploy.v1.ExecutionConfigOrBuilder>
        getExecutionConfigsFieldBuilder() {
      if (executionConfigsBuilder_ == null) {
        executionConfigsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.deploy.v1.ExecutionConfig,
                com.google.cloud.deploy.v1.ExecutionConfig.Builder,
                com.google.cloud.deploy.v1.ExecutionConfigOrBuilder>(
                executionConfigs_,
                ((bitField0_ & 0x00010000) != 0),
                getParentForChildren(),
                isClean());
        executionConfigs_ = null;
      }
      return executionConfigsBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> deployParameters_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetDeployParameters() {
      if (deployParameters_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            DeployParametersDefaultEntryHolder.defaultEntry);
      }
      return deployParameters_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableDeployParameters() {
      if (deployParameters_ == null) {
        deployParameters_ =
            com.google.protobuf.MapField.newMapField(
                DeployParametersDefaultEntryHolder.defaultEntry);
      }
      if (!deployParameters_.isMutable()) {
        deployParameters_ = deployParameters_.copy();
      }
      bitField0_ |= 0x00020000;
      onChanged();
      return deployParameters_;
    }

    public int getDeployParametersCount() {
      return internalGetDeployParameters().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional. The deploy parameters to use for this target.
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; deploy_parameters = 20 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public boolean containsDeployParameters(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetDeployParameters().getMap().containsKey(key);
    }
    /** Use {@link #getDeployParametersMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getDeployParameters() {
      return getDeployParametersMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. The deploy parameters to use for this target.
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; deploy_parameters = 20 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getDeployParametersMap() {
      return internalGetDeployParameters().getMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. The deploy parameters to use for this target.
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; deploy_parameters = 20 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getDeployParametersOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map =
          internalGetDeployParameters().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional. The deploy parameters to use for this target.
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; deploy_parameters = 20 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.lang.String getDeployParametersOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map =
          internalGetDeployParameters().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearDeployParameters() {
      bitField0_ = (bitField0_ & ~0x00020000);
      internalGetMutableDeployParameters().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The deploy parameters to use for this target.
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; deploy_parameters = 20 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeDeployParameters(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableDeployParameters().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableDeployParameters() {
      bitField0_ |= 0x00020000;
      return internalGetMutableDeployParameters().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. The deploy parameters to use for this target.
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; deploy_parameters = 20 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putDeployParameters(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableDeployParameters().getMutableMap().put(key, value);
      bitField0_ |= 0x00020000;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The deploy parameters to use for this target.
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; deploy_parameters = 20 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putAllDeployParameters(
        java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableDeployParameters().getMutableMap().putAll(values);
      bitField0_ |= 0x00020000;
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.deploy.v1.Target)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.deploy.v1.Target)
  private static final com.google.cloud.deploy.v1.Target DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.deploy.v1.Target();
  }

  public static com.google.cloud.deploy.v1.Target getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Target> PARSER =
      new com.google.protobuf.AbstractParser<Target>() {
        @java.lang.Override
        public Target parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Target> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Target> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.deploy.v1.Target getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
