/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/deploy/v1/cloud_deploy.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.deploy.v1;

/**
 *
 *
 * <pre>
 * Time windows within which actions are restricted. See the
 * [documentation](https://cloud.google.com/deploy/docs/deploy-policy#dates_times)
 * for more information on how to configure dates/times.
 * </pre>
 *
 * Protobuf type {@code google.cloud.deploy.v1.TimeWindows}
 */
public final class TimeWindows extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.deploy.v1.TimeWindows)
    TimeWindowsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use TimeWindows.newBuilder() to construct.
  private TimeWindows(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TimeWindows() {
    timeZone_ = "";
    oneTimeWindows_ = java.util.Collections.emptyList();
    weeklyWindows_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TimeWindows();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.deploy.v1.CloudDeployProto
        .internal_static_google_cloud_deploy_v1_TimeWindows_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.deploy.v1.CloudDeployProto
        .internal_static_google_cloud_deploy_v1_TimeWindows_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.deploy.v1.TimeWindows.class,
            com.google.cloud.deploy.v1.TimeWindows.Builder.class);
  }

  public static final int TIME_ZONE_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object timeZone_ = "";
  /**
   *
   *
   * <pre>
   * Required. The time zone in IANA format [IANA Time Zone
   * Database](https://www.iana.org/time-zones) (e.g. America/New_York).
   * </pre>
   *
   * <code>string time_zone = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The timeZone.
   */
  @java.lang.Override
  public java.lang.String getTimeZone() {
    java.lang.Object ref = timeZone_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      timeZone_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The time zone in IANA format [IANA Time Zone
   * Database](https://www.iana.org/time-zones) (e.g. America/New_York).
   * </pre>
   *
   * <code>string time_zone = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for timeZone.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTimeZoneBytes() {
    java.lang.Object ref = timeZone_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      timeZone_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ONE_TIME_WINDOWS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.deploy.v1.OneTimeWindow> oneTimeWindows_;
  /**
   *
   *
   * <pre>
   * Optional. One-time windows within which actions are restricted.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.OneTimeWindow one_time_windows = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.deploy.v1.OneTimeWindow> getOneTimeWindowsList() {
    return oneTimeWindows_;
  }
  /**
   *
   *
   * <pre>
   * Optional. One-time windows within which actions are restricted.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.OneTimeWindow one_time_windows = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.deploy.v1.OneTimeWindowOrBuilder>
      getOneTimeWindowsOrBuilderList() {
    return oneTimeWindows_;
  }
  /**
   *
   *
   * <pre>
   * Optional. One-time windows within which actions are restricted.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.OneTimeWindow one_time_windows = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getOneTimeWindowsCount() {
    return oneTimeWindows_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. One-time windows within which actions are restricted.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.OneTimeWindow one_time_windows = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.OneTimeWindow getOneTimeWindows(int index) {
    return oneTimeWindows_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. One-time windows within which actions are restricted.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.OneTimeWindow one_time_windows = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.OneTimeWindowOrBuilder getOneTimeWindowsOrBuilder(int index) {
    return oneTimeWindows_.get(index);
  }

  public static final int WEEKLY_WINDOWS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.deploy.v1.WeeklyWindow> weeklyWindows_;
  /**
   *
   *
   * <pre>
   * Optional. Recurring weekly windows within which actions are restricted.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.WeeklyWindow weekly_windows = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.deploy.v1.WeeklyWindow> getWeeklyWindowsList() {
    return weeklyWindows_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Recurring weekly windows within which actions are restricted.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.WeeklyWindow weekly_windows = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.deploy.v1.WeeklyWindowOrBuilder>
      getWeeklyWindowsOrBuilderList() {
    return weeklyWindows_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Recurring weekly windows within which actions are restricted.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.WeeklyWindow weekly_windows = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getWeeklyWindowsCount() {
    return weeklyWindows_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Recurring weekly windows within which actions are restricted.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.WeeklyWindow weekly_windows = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.WeeklyWindow getWeeklyWindows(int index) {
    return weeklyWindows_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. Recurring weekly windows within which actions are restricted.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.WeeklyWindow weekly_windows = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.WeeklyWindowOrBuilder getWeeklyWindowsOrBuilder(int index) {
    return weeklyWindows_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(timeZone_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, timeZone_);
    }
    for (int i = 0; i < oneTimeWindows_.size(); i++) {
      output.writeMessage(2, oneTimeWindows_.get(i));
    }
    for (int i = 0; i < weeklyWindows_.size(); i++) {
      output.writeMessage(3, weeklyWindows_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(timeZone_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, timeZone_);
    }
    for (int i = 0; i < oneTimeWindows_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, oneTimeWindows_.get(i));
    }
    for (int i = 0; i < weeklyWindows_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, weeklyWindows_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.deploy.v1.TimeWindows)) {
      return super.equals(obj);
    }
    com.google.cloud.deploy.v1.TimeWindows other = (com.google.cloud.deploy.v1.TimeWindows) obj;

    if (!getTimeZone().equals(other.getTimeZone())) return false;
    if (!getOneTimeWindowsList().equals(other.getOneTimeWindowsList())) return false;
    if (!getWeeklyWindowsList().equals(other.getWeeklyWindowsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TIME_ZONE_FIELD_NUMBER;
    hash = (53 * hash) + getTimeZone().hashCode();
    if (getOneTimeWindowsCount() > 0) {
      hash = (37 * hash) + ONE_TIME_WINDOWS_FIELD_NUMBER;
      hash = (53 * hash) + getOneTimeWindowsList().hashCode();
    }
    if (getWeeklyWindowsCount() > 0) {
      hash = (37 * hash) + WEEKLY_WINDOWS_FIELD_NUMBER;
      hash = (53 * hash) + getWeeklyWindowsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.deploy.v1.TimeWindows parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.TimeWindows parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.TimeWindows parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.TimeWindows parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.TimeWindows parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.TimeWindows parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.TimeWindows parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.TimeWindows parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.TimeWindows parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.TimeWindows parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.TimeWindows parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.TimeWindows parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.deploy.v1.TimeWindows prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Time windows within which actions are restricted. See the
   * [documentation](https://cloud.google.com/deploy/docs/deploy-policy#dates_times)
   * for more information on how to configure dates/times.
   * </pre>
   *
   * Protobuf type {@code google.cloud.deploy.v1.TimeWindows}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.deploy.v1.TimeWindows)
      com.google.cloud.deploy.v1.TimeWindowsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_TimeWindows_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_TimeWindows_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.deploy.v1.TimeWindows.class,
              com.google.cloud.deploy.v1.TimeWindows.Builder.class);
    }

    // Construct using com.google.cloud.deploy.v1.TimeWindows.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      timeZone_ = "";
      if (oneTimeWindowsBuilder_ == null) {
        oneTimeWindows_ = java.util.Collections.emptyList();
      } else {
        oneTimeWindows_ = null;
        oneTimeWindowsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      if (weeklyWindowsBuilder_ == null) {
        weeklyWindows_ = java.util.Collections.emptyList();
      } else {
        weeklyWindows_ = null;
        weeklyWindowsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_TimeWindows_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.TimeWindows getDefaultInstanceForType() {
      return com.google.cloud.deploy.v1.TimeWindows.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.TimeWindows build() {
      com.google.cloud.deploy.v1.TimeWindows result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.TimeWindows buildPartial() {
      com.google.cloud.deploy.v1.TimeWindows result =
          new com.google.cloud.deploy.v1.TimeWindows(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.deploy.v1.TimeWindows result) {
      if (oneTimeWindowsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          oneTimeWindows_ = java.util.Collections.unmodifiableList(oneTimeWindows_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.oneTimeWindows_ = oneTimeWindows_;
      } else {
        result.oneTimeWindows_ = oneTimeWindowsBuilder_.build();
      }
      if (weeklyWindowsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          weeklyWindows_ = java.util.Collections.unmodifiableList(weeklyWindows_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.weeklyWindows_ = weeklyWindows_;
      } else {
        result.weeklyWindows_ = weeklyWindowsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.deploy.v1.TimeWindows result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.timeZone_ = timeZone_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.deploy.v1.TimeWindows) {
        return mergeFrom((com.google.cloud.deploy.v1.TimeWindows) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.deploy.v1.TimeWindows other) {
      if (other == com.google.cloud.deploy.v1.TimeWindows.getDefaultInstance()) return this;
      if (!other.getTimeZone().isEmpty()) {
        timeZone_ = other.timeZone_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (oneTimeWindowsBuilder_ == null) {
        if (!other.oneTimeWindows_.isEmpty()) {
          if (oneTimeWindows_.isEmpty()) {
            oneTimeWindows_ = other.oneTimeWindows_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureOneTimeWindowsIsMutable();
            oneTimeWindows_.addAll(other.oneTimeWindows_);
          }
          onChanged();
        }
      } else {
        if (!other.oneTimeWindows_.isEmpty()) {
          if (oneTimeWindowsBuilder_.isEmpty()) {
            oneTimeWindowsBuilder_.dispose();
            oneTimeWindowsBuilder_ = null;
            oneTimeWindows_ = other.oneTimeWindows_;
            bitField0_ = (bitField0_ & ~0x00000002);
            oneTimeWindowsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getOneTimeWindowsFieldBuilder()
                    : null;
          } else {
            oneTimeWindowsBuilder_.addAllMessages(other.oneTimeWindows_);
          }
        }
      }
      if (weeklyWindowsBuilder_ == null) {
        if (!other.weeklyWindows_.isEmpty()) {
          if (weeklyWindows_.isEmpty()) {
            weeklyWindows_ = other.weeklyWindows_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureWeeklyWindowsIsMutable();
            weeklyWindows_.addAll(other.weeklyWindows_);
          }
          onChanged();
        }
      } else {
        if (!other.weeklyWindows_.isEmpty()) {
          if (weeklyWindowsBuilder_.isEmpty()) {
            weeklyWindowsBuilder_.dispose();
            weeklyWindowsBuilder_ = null;
            weeklyWindows_ = other.weeklyWindows_;
            bitField0_ = (bitField0_ & ~0x00000004);
            weeklyWindowsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getWeeklyWindowsFieldBuilder()
                    : null;
          } else {
            weeklyWindowsBuilder_.addAllMessages(other.weeklyWindows_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                timeZone_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.cloud.deploy.v1.OneTimeWindow m =
                    input.readMessage(
                        com.google.cloud.deploy.v1.OneTimeWindow.parser(), extensionRegistry);
                if (oneTimeWindowsBuilder_ == null) {
                  ensureOneTimeWindowsIsMutable();
                  oneTimeWindows_.add(m);
                } else {
                  oneTimeWindowsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 26:
              {
                com.google.cloud.deploy.v1.WeeklyWindow m =
                    input.readMessage(
                        com.google.cloud.deploy.v1.WeeklyWindow.parser(), extensionRegistry);
                if (weeklyWindowsBuilder_ == null) {
                  ensureWeeklyWindowsIsMutable();
                  weeklyWindows_.add(m);
                } else {
                  weeklyWindowsBuilder_.addMessage(m);
                }
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object timeZone_ = "";
    /**
     *
     *
     * <pre>
     * Required. The time zone in IANA format [IANA Time Zone
     * Database](https://www.iana.org/time-zones) (e.g. America/New_York).
     * </pre>
     *
     * <code>string time_zone = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The timeZone.
     */
    public java.lang.String getTimeZone() {
      java.lang.Object ref = timeZone_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        timeZone_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The time zone in IANA format [IANA Time Zone
     * Database](https://www.iana.org/time-zones) (e.g. America/New_York).
     * </pre>
     *
     * <code>string time_zone = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for timeZone.
     */
    public com.google.protobuf.ByteString getTimeZoneBytes() {
      java.lang.Object ref = timeZone_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        timeZone_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The time zone in IANA format [IANA Time Zone
     * Database](https://www.iana.org/time-zones) (e.g. America/New_York).
     * </pre>
     *
     * <code>string time_zone = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The timeZone to set.
     * @return This builder for chaining.
     */
    public Builder setTimeZone(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      timeZone_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The time zone in IANA format [IANA Time Zone
     * Database](https://www.iana.org/time-zones) (e.g. America/New_York).
     * </pre>
     *
     * <code>string time_zone = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTimeZone() {
      timeZone_ = getDefaultInstance().getTimeZone();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The time zone in IANA format [IANA Time Zone
     * Database](https://www.iana.org/time-zones) (e.g. America/New_York).
     * </pre>
     *
     * <code>string time_zone = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for timeZone to set.
     * @return This builder for chaining.
     */
    public Builder setTimeZoneBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      timeZone_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.deploy.v1.OneTimeWindow> oneTimeWindows_ =
        java.util.Collections.emptyList();

    private void ensureOneTimeWindowsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        oneTimeWindows_ =
            new java.util.ArrayList<com.google.cloud.deploy.v1.OneTimeWindow>(oneTimeWindows_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.deploy.v1.OneTimeWindow,
            com.google.cloud.deploy.v1.OneTimeWindow.Builder,
            com.google.cloud.deploy.v1.OneTimeWindowOrBuilder>
        oneTimeWindowsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. One-time windows within which actions are restricted.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.OneTimeWindow one_time_windows = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.deploy.v1.OneTimeWindow> getOneTimeWindowsList() {
      if (oneTimeWindowsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(oneTimeWindows_);
      } else {
        return oneTimeWindowsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. One-time windows within which actions are restricted.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.OneTimeWindow one_time_windows = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getOneTimeWindowsCount() {
      if (oneTimeWindowsBuilder_ == null) {
        return oneTimeWindows_.size();
      } else {
        return oneTimeWindowsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. One-time windows within which actions are restricted.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.OneTimeWindow one_time_windows = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.deploy.v1.OneTimeWindow getOneTimeWindows(int index) {
      if (oneTimeWindowsBuilder_ == null) {
        return oneTimeWindows_.get(index);
      } else {
        return oneTimeWindowsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. One-time windows within which actions are restricted.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.OneTimeWindow one_time_windows = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setOneTimeWindows(int index, com.google.cloud.deploy.v1.OneTimeWindow value) {
      if (oneTimeWindowsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureOneTimeWindowsIsMutable();
        oneTimeWindows_.set(index, value);
        onChanged();
      } else {
        oneTimeWindowsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. One-time windows within which actions are restricted.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.OneTimeWindow one_time_windows = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setOneTimeWindows(
        int index, com.google.cloud.deploy.v1.OneTimeWindow.Builder builderForValue) {
      if (oneTimeWindowsBuilder_ == null) {
        ensureOneTimeWindowsIsMutable();
        oneTimeWindows_.set(index, builderForValue.build());
        onChanged();
      } else {
        oneTimeWindowsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. One-time windows within which actions are restricted.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.OneTimeWindow one_time_windows = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addOneTimeWindows(com.google.cloud.deploy.v1.OneTimeWindow value) {
      if (oneTimeWindowsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureOneTimeWindowsIsMutable();
        oneTimeWindows_.add(value);
        onChanged();
      } else {
        oneTimeWindowsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. One-time windows within which actions are restricted.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.OneTimeWindow one_time_windows = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addOneTimeWindows(int index, com.google.cloud.deploy.v1.OneTimeWindow value) {
      if (oneTimeWindowsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureOneTimeWindowsIsMutable();
        oneTimeWindows_.add(index, value);
        onChanged();
      } else {
        oneTimeWindowsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. One-time windows within which actions are restricted.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.OneTimeWindow one_time_windows = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addOneTimeWindows(
        com.google.cloud.deploy.v1.OneTimeWindow.Builder builderForValue) {
      if (oneTimeWindowsBuilder_ == null) {
        ensureOneTimeWindowsIsMutable();
        oneTimeWindows_.add(builderForValue.build());
        onChanged();
      } else {
        oneTimeWindowsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. One-time windows within which actions are restricted.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.OneTimeWindow one_time_windows = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addOneTimeWindows(
        int index, com.google.cloud.deploy.v1.OneTimeWindow.Builder builderForValue) {
      if (oneTimeWindowsBuilder_ == null) {
        ensureOneTimeWindowsIsMutable();
        oneTimeWindows_.add(index, builderForValue.build());
        onChanged();
      } else {
        oneTimeWindowsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. One-time windows within which actions are restricted.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.OneTimeWindow one_time_windows = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllOneTimeWindows(
        java.lang.Iterable<? extends com.google.cloud.deploy.v1.OneTimeWindow> values) {
      if (oneTimeWindowsBuilder_ == null) {
        ensureOneTimeWindowsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, oneTimeWindows_);
        onChanged();
      } else {
        oneTimeWindowsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. One-time windows within which actions are restricted.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.OneTimeWindow one_time_windows = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearOneTimeWindows() {
      if (oneTimeWindowsBuilder_ == null) {
        oneTimeWindows_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        oneTimeWindowsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. One-time windows within which actions are restricted.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.OneTimeWindow one_time_windows = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeOneTimeWindows(int index) {
      if (oneTimeWindowsBuilder_ == null) {
        ensureOneTimeWindowsIsMutable();
        oneTimeWindows_.remove(index);
        onChanged();
      } else {
        oneTimeWindowsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. One-time windows within which actions are restricted.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.OneTimeWindow one_time_windows = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.deploy.v1.OneTimeWindow.Builder getOneTimeWindowsBuilder(int index) {
      return getOneTimeWindowsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. One-time windows within which actions are restricted.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.OneTimeWindow one_time_windows = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.deploy.v1.OneTimeWindowOrBuilder getOneTimeWindowsOrBuilder(int index) {
      if (oneTimeWindowsBuilder_ == null) {
        return oneTimeWindows_.get(index);
      } else {
        return oneTimeWindowsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. One-time windows within which actions are restricted.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.OneTimeWindow one_time_windows = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.deploy.v1.OneTimeWindowOrBuilder>
        getOneTimeWindowsOrBuilderList() {
      if (oneTimeWindowsBuilder_ != null) {
        return oneTimeWindowsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(oneTimeWindows_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. One-time windows within which actions are restricted.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.OneTimeWindow one_time_windows = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.deploy.v1.OneTimeWindow.Builder addOneTimeWindowsBuilder() {
      return getOneTimeWindowsFieldBuilder()
          .addBuilder(com.google.cloud.deploy.v1.OneTimeWindow.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. One-time windows within which actions are restricted.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.OneTimeWindow one_time_windows = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.deploy.v1.OneTimeWindow.Builder addOneTimeWindowsBuilder(int index) {
      return getOneTimeWindowsFieldBuilder()
          .addBuilder(index, com.google.cloud.deploy.v1.OneTimeWindow.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. One-time windows within which actions are restricted.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.OneTimeWindow one_time_windows = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.deploy.v1.OneTimeWindow.Builder>
        getOneTimeWindowsBuilderList() {
      return getOneTimeWindowsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.deploy.v1.OneTimeWindow,
            com.google.cloud.deploy.v1.OneTimeWindow.Builder,
            com.google.cloud.deploy.v1.OneTimeWindowOrBuilder>
        getOneTimeWindowsFieldBuilder() {
      if (oneTimeWindowsBuilder_ == null) {
        oneTimeWindowsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.deploy.v1.OneTimeWindow,
                com.google.cloud.deploy.v1.OneTimeWindow.Builder,
                com.google.cloud.deploy.v1.OneTimeWindowOrBuilder>(
                oneTimeWindows_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        oneTimeWindows_ = null;
      }
      return oneTimeWindowsBuilder_;
    }

    private java.util.List<com.google.cloud.deploy.v1.WeeklyWindow> weeklyWindows_ =
        java.util.Collections.emptyList();

    private void ensureWeeklyWindowsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        weeklyWindows_ =
            new java.util.ArrayList<com.google.cloud.deploy.v1.WeeklyWindow>(weeklyWindows_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.deploy.v1.WeeklyWindow,
            com.google.cloud.deploy.v1.WeeklyWindow.Builder,
            com.google.cloud.deploy.v1.WeeklyWindowOrBuilder>
        weeklyWindowsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Recurring weekly windows within which actions are restricted.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.WeeklyWindow weekly_windows = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.deploy.v1.WeeklyWindow> getWeeklyWindowsList() {
      if (weeklyWindowsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(weeklyWindows_);
      } else {
        return weeklyWindowsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Recurring weekly windows within which actions are restricted.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.WeeklyWindow weekly_windows = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getWeeklyWindowsCount() {
      if (weeklyWindowsBuilder_ == null) {
        return weeklyWindows_.size();
      } else {
        return weeklyWindowsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Recurring weekly windows within which actions are restricted.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.WeeklyWindow weekly_windows = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.deploy.v1.WeeklyWindow getWeeklyWindows(int index) {
      if (weeklyWindowsBuilder_ == null) {
        return weeklyWindows_.get(index);
      } else {
        return weeklyWindowsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Recurring weekly windows within which actions are restricted.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.WeeklyWindow weekly_windows = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setWeeklyWindows(int index, com.google.cloud.deploy.v1.WeeklyWindow value) {
      if (weeklyWindowsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureWeeklyWindowsIsMutable();
        weeklyWindows_.set(index, value);
        onChanged();
      } else {
        weeklyWindowsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Recurring weekly windows within which actions are restricted.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.WeeklyWindow weekly_windows = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setWeeklyWindows(
        int index, com.google.cloud.deploy.v1.WeeklyWindow.Builder builderForValue) {
      if (weeklyWindowsBuilder_ == null) {
        ensureWeeklyWindowsIsMutable();
        weeklyWindows_.set(index, builderForValue.build());
        onChanged();
      } else {
        weeklyWindowsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Recurring weekly windows within which actions are restricted.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.WeeklyWindow weekly_windows = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addWeeklyWindows(com.google.cloud.deploy.v1.WeeklyWindow value) {
      if (weeklyWindowsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureWeeklyWindowsIsMutable();
        weeklyWindows_.add(value);
        onChanged();
      } else {
        weeklyWindowsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Recurring weekly windows within which actions are restricted.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.WeeklyWindow weekly_windows = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addWeeklyWindows(int index, com.google.cloud.deploy.v1.WeeklyWindow value) {
      if (weeklyWindowsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureWeeklyWindowsIsMutable();
        weeklyWindows_.add(index, value);
        onChanged();
      } else {
        weeklyWindowsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Recurring weekly windows within which actions are restricted.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.WeeklyWindow weekly_windows = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addWeeklyWindows(
        com.google.cloud.deploy.v1.WeeklyWindow.Builder builderForValue) {
      if (weeklyWindowsBuilder_ == null) {
        ensureWeeklyWindowsIsMutable();
        weeklyWindows_.add(builderForValue.build());
        onChanged();
      } else {
        weeklyWindowsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Recurring weekly windows within which actions are restricted.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.WeeklyWindow weekly_windows = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addWeeklyWindows(
        int index, com.google.cloud.deploy.v1.WeeklyWindow.Builder builderForValue) {
      if (weeklyWindowsBuilder_ == null) {
        ensureWeeklyWindowsIsMutable();
        weeklyWindows_.add(index, builderForValue.build());
        onChanged();
      } else {
        weeklyWindowsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Recurring weekly windows within which actions are restricted.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.WeeklyWindow weekly_windows = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllWeeklyWindows(
        java.lang.Iterable<? extends com.google.cloud.deploy.v1.WeeklyWindow> values) {
      if (weeklyWindowsBuilder_ == null) {
        ensureWeeklyWindowsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, weeklyWindows_);
        onChanged();
      } else {
        weeklyWindowsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Recurring weekly windows within which actions are restricted.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.WeeklyWindow weekly_windows = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearWeeklyWindows() {
      if (weeklyWindowsBuilder_ == null) {
        weeklyWindows_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        weeklyWindowsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Recurring weekly windows within which actions are restricted.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.WeeklyWindow weekly_windows = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeWeeklyWindows(int index) {
      if (weeklyWindowsBuilder_ == null) {
        ensureWeeklyWindowsIsMutable();
        weeklyWindows_.remove(index);
        onChanged();
      } else {
        weeklyWindowsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Recurring weekly windows within which actions are restricted.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.WeeklyWindow weekly_windows = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.deploy.v1.WeeklyWindow.Builder getWeeklyWindowsBuilder(int index) {
      return getWeeklyWindowsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Recurring weekly windows within which actions are restricted.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.WeeklyWindow weekly_windows = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.deploy.v1.WeeklyWindowOrBuilder getWeeklyWindowsOrBuilder(int index) {
      if (weeklyWindowsBuilder_ == null) {
        return weeklyWindows_.get(index);
      } else {
        return weeklyWindowsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Recurring weekly windows within which actions are restricted.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.WeeklyWindow weekly_windows = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.deploy.v1.WeeklyWindowOrBuilder>
        getWeeklyWindowsOrBuilderList() {
      if (weeklyWindowsBuilder_ != null) {
        return weeklyWindowsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(weeklyWindows_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Recurring weekly windows within which actions are restricted.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.WeeklyWindow weekly_windows = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.deploy.v1.WeeklyWindow.Builder addWeeklyWindowsBuilder() {
      return getWeeklyWindowsFieldBuilder()
          .addBuilder(com.google.cloud.deploy.v1.WeeklyWindow.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. Recurring weekly windows within which actions are restricted.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.WeeklyWindow weekly_windows = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.deploy.v1.WeeklyWindow.Builder addWeeklyWindowsBuilder(int index) {
      return getWeeklyWindowsFieldBuilder()
          .addBuilder(index, com.google.cloud.deploy.v1.WeeklyWindow.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. Recurring weekly windows within which actions are restricted.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.WeeklyWindow weekly_windows = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.deploy.v1.WeeklyWindow.Builder>
        getWeeklyWindowsBuilderList() {
      return getWeeklyWindowsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.deploy.v1.WeeklyWindow,
            com.google.cloud.deploy.v1.WeeklyWindow.Builder,
            com.google.cloud.deploy.v1.WeeklyWindowOrBuilder>
        getWeeklyWindowsFieldBuilder() {
      if (weeklyWindowsBuilder_ == null) {
        weeklyWindowsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.deploy.v1.WeeklyWindow,
                com.google.cloud.deploy.v1.WeeklyWindow.Builder,
                com.google.cloud.deploy.v1.WeeklyWindowOrBuilder>(
                weeklyWindows_,
                ((bitField0_ & 0x00000004) != 0),
                getParentForChildren(),
                isClean());
        weeklyWindows_ = null;
      }
      return weeklyWindowsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.deploy.v1.TimeWindows)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.deploy.v1.TimeWindows)
  private static final com.google.cloud.deploy.v1.TimeWindows DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.deploy.v1.TimeWindows();
  }

  public static com.google.cloud.deploy.v1.TimeWindows getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TimeWindows> PARSER =
      new com.google.protobuf.AbstractParser<TimeWindows>() {
        @java.lang.Override
        public TimeWindows parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<TimeWindows> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TimeWindows> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.deploy.v1.TimeWindows getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
