/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/deploy/v1/cloud_deploy.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.deploy.v1;

/**
 *
 *
 * <pre>
 * The `TimedPromoteReleaseRule` will automatically promote a release from the
 * current target(s) to the specified target(s) on a configured schedule.
 * </pre>
 *
 * Protobuf type {@code google.cloud.deploy.v1.TimedPromoteReleaseRule}
 */
public final class TimedPromoteReleaseRule extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.deploy.v1.TimedPromoteReleaseRule)
    TimedPromoteReleaseRuleOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use TimedPromoteReleaseRule.newBuilder() to construct.
  private TimedPromoteReleaseRule(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TimedPromoteReleaseRule() {
    id_ = "";
    destinationTargetId_ = "";
    schedule_ = "";
    timeZone_ = "";
    destinationPhase_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TimedPromoteReleaseRule();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.deploy.v1.CloudDeployProto
        .internal_static_google_cloud_deploy_v1_TimedPromoteReleaseRule_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.deploy.v1.CloudDeployProto
        .internal_static_google_cloud_deploy_v1_TimedPromoteReleaseRule_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.deploy.v1.TimedPromoteReleaseRule.class,
            com.google.cloud.deploy.v1.TimedPromoteReleaseRule.Builder.class);
  }

  private int bitField0_;
  public static final int ID_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object id_ = "";
  /**
   *
   *
   * <pre>
   * Required. ID of the rule. This ID must be unique in the `Automation`
   * resource to which this rule belongs. The format is
   * `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`.
   * </pre>
   *
   * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public java.lang.String getId() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      id_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. ID of the rule. This ID must be unique in the `Automation`
   * resource to which this rule belongs. The format is
   * `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`.
   * </pre>
   *
   * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for id.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIdBytes() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      id_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESTINATION_TARGET_ID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object destinationTargetId_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The ID of the stage in the pipeline to which this `Release` is
   * deploying. If unspecified, default it to the next stage in the promotion
   * flow. The value of this field could be one of the following:
   *
   * * The last segment of a target name
   * * "&#64;next", the next target in the promotion sequence
   * </pre>
   *
   * <code>string destination_target_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The destinationTargetId.
   */
  @java.lang.Override
  public java.lang.String getDestinationTargetId() {
    java.lang.Object ref = destinationTargetId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      destinationTargetId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The ID of the stage in the pipeline to which this `Release` is
   * deploying. If unspecified, default it to the next stage in the promotion
   * flow. The value of this field could be one of the following:
   *
   * * The last segment of a target name
   * * "&#64;next", the next target in the promotion sequence
   * </pre>
   *
   * <code>string destination_target_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for destinationTargetId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDestinationTargetIdBytes() {
    java.lang.Object ref = destinationTargetId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      destinationTargetId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SCHEDULE_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object schedule_ = "";
  /**
   *
   *
   * <pre>
   * Required. Schedule in crontab format. e.g. "0 9 * * 1" for every Monday at
   * 9am.
   * </pre>
   *
   * <code>string schedule = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The schedule.
   */
  @java.lang.Override
  public java.lang.String getSchedule() {
    java.lang.Object ref = schedule_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      schedule_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Schedule in crontab format. e.g. "0 9 * * 1" for every Monday at
   * 9am.
   * </pre>
   *
   * <code>string schedule = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for schedule.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getScheduleBytes() {
    java.lang.Object ref = schedule_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      schedule_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TIME_ZONE_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object timeZone_ = "";
  /**
   *
   *
   * <pre>
   * Required. The time zone in IANA format [IANA Time Zone
   * Database](https://www.iana.org/time-zones) (e.g. America/New_York).
   * </pre>
   *
   * <code>string time_zone = 4 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The timeZone.
   */
  @java.lang.Override
  public java.lang.String getTimeZone() {
    java.lang.Object ref = timeZone_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      timeZone_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The time zone in IANA format [IANA Time Zone
   * Database](https://www.iana.org/time-zones) (e.g. America/New_York).
   * </pre>
   *
   * <code>string time_zone = 4 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for timeZone.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTimeZoneBytes() {
    java.lang.Object ref = timeZone_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      timeZone_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONDITION_FIELD_NUMBER = 5;
  private com.google.cloud.deploy.v1.AutomationRuleCondition condition_;
  /**
   *
   *
   * <pre>
   * Output only. Information around the state of the Automation rule.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.AutomationRuleCondition condition = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the condition field is set.
   */
  @java.lang.Override
  public boolean hasCondition() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Information around the state of the Automation rule.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.AutomationRuleCondition condition = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The condition.
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.AutomationRuleCondition getCondition() {
    return condition_ == null
        ? com.google.cloud.deploy.v1.AutomationRuleCondition.getDefaultInstance()
        : condition_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Information around the state of the Automation rule.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.AutomationRuleCondition condition = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.AutomationRuleConditionOrBuilder getConditionOrBuilder() {
    return condition_ == null
        ? com.google.cloud.deploy.v1.AutomationRuleCondition.getDefaultInstance()
        : condition_;
  }

  public static final int DESTINATION_PHASE_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object destinationPhase_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The starting phase of the rollout created by this rule. Default
   * to the first phase.
   * </pre>
   *
   * <code>string destination_phase = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The destinationPhase.
   */
  @java.lang.Override
  public java.lang.String getDestinationPhase() {
    java.lang.Object ref = destinationPhase_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      destinationPhase_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The starting phase of the rollout created by this rule. Default
   * to the first phase.
   * </pre>
   *
   * <code>string destination_phase = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for destinationPhase.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDestinationPhaseBytes() {
    java.lang.Object ref = destinationPhase_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      destinationPhase_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, id_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(destinationTargetId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, destinationTargetId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(schedule_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, schedule_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(timeZone_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, timeZone_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(5, getCondition());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(destinationPhase_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, destinationPhase_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, id_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(destinationTargetId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, destinationTargetId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(schedule_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, schedule_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(timeZone_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, timeZone_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getCondition());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(destinationPhase_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, destinationPhase_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.deploy.v1.TimedPromoteReleaseRule)) {
      return super.equals(obj);
    }
    com.google.cloud.deploy.v1.TimedPromoteReleaseRule other =
        (com.google.cloud.deploy.v1.TimedPromoteReleaseRule) obj;

    if (!getId().equals(other.getId())) return false;
    if (!getDestinationTargetId().equals(other.getDestinationTargetId())) return false;
    if (!getSchedule().equals(other.getSchedule())) return false;
    if (!getTimeZone().equals(other.getTimeZone())) return false;
    if (hasCondition() != other.hasCondition()) return false;
    if (hasCondition()) {
      if (!getCondition().equals(other.getCondition())) return false;
    }
    if (!getDestinationPhase().equals(other.getDestinationPhase())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ID_FIELD_NUMBER;
    hash = (53 * hash) + getId().hashCode();
    hash = (37 * hash) + DESTINATION_TARGET_ID_FIELD_NUMBER;
    hash = (53 * hash) + getDestinationTargetId().hashCode();
    hash = (37 * hash) + SCHEDULE_FIELD_NUMBER;
    hash = (53 * hash) + getSchedule().hashCode();
    hash = (37 * hash) + TIME_ZONE_FIELD_NUMBER;
    hash = (53 * hash) + getTimeZone().hashCode();
    if (hasCondition()) {
      hash = (37 * hash) + CONDITION_FIELD_NUMBER;
      hash = (53 * hash) + getCondition().hashCode();
    }
    hash = (37 * hash) + DESTINATION_PHASE_FIELD_NUMBER;
    hash = (53 * hash) + getDestinationPhase().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.deploy.v1.TimedPromoteReleaseRule parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.TimedPromoteReleaseRule parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.TimedPromoteReleaseRule parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.TimedPromoteReleaseRule parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.TimedPromoteReleaseRule parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.TimedPromoteReleaseRule parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.TimedPromoteReleaseRule parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.TimedPromoteReleaseRule parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.TimedPromoteReleaseRule parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.TimedPromoteReleaseRule parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.TimedPromoteReleaseRule parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.TimedPromoteReleaseRule parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.deploy.v1.TimedPromoteReleaseRule prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The `TimedPromoteReleaseRule` will automatically promote a release from the
   * current target(s) to the specified target(s) on a configured schedule.
   * </pre>
   *
   * Protobuf type {@code google.cloud.deploy.v1.TimedPromoteReleaseRule}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.deploy.v1.TimedPromoteReleaseRule)
      com.google.cloud.deploy.v1.TimedPromoteReleaseRuleOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_TimedPromoteReleaseRule_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_TimedPromoteReleaseRule_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.deploy.v1.TimedPromoteReleaseRule.class,
              com.google.cloud.deploy.v1.TimedPromoteReleaseRule.Builder.class);
    }

    // Construct using com.google.cloud.deploy.v1.TimedPromoteReleaseRule.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getConditionFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      id_ = "";
      destinationTargetId_ = "";
      schedule_ = "";
      timeZone_ = "";
      condition_ = null;
      if (conditionBuilder_ != null) {
        conditionBuilder_.dispose();
        conditionBuilder_ = null;
      }
      destinationPhase_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_TimedPromoteReleaseRule_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.TimedPromoteReleaseRule getDefaultInstanceForType() {
      return com.google.cloud.deploy.v1.TimedPromoteReleaseRule.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.TimedPromoteReleaseRule build() {
      com.google.cloud.deploy.v1.TimedPromoteReleaseRule result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.TimedPromoteReleaseRule buildPartial() {
      com.google.cloud.deploy.v1.TimedPromoteReleaseRule result =
          new com.google.cloud.deploy.v1.TimedPromoteReleaseRule(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.deploy.v1.TimedPromoteReleaseRule result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.id_ = id_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.destinationTargetId_ = destinationTargetId_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.schedule_ = schedule_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.timeZone_ = timeZone_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.condition_ = conditionBuilder_ == null ? condition_ : conditionBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.destinationPhase_ = destinationPhase_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.deploy.v1.TimedPromoteReleaseRule) {
        return mergeFrom((com.google.cloud.deploy.v1.TimedPromoteReleaseRule) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.deploy.v1.TimedPromoteReleaseRule other) {
      if (other == com.google.cloud.deploy.v1.TimedPromoteReleaseRule.getDefaultInstance())
        return this;
      if (!other.getId().isEmpty()) {
        id_ = other.id_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDestinationTargetId().isEmpty()) {
        destinationTargetId_ = other.destinationTargetId_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getSchedule().isEmpty()) {
        schedule_ = other.schedule_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getTimeZone().isEmpty()) {
        timeZone_ = other.timeZone_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasCondition()) {
        mergeCondition(other.getCondition());
      }
      if (!other.getDestinationPhase().isEmpty()) {
        destinationPhase_ = other.destinationPhase_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                id_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                destinationTargetId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                schedule_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                timeZone_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getConditionFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                destinationPhase_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object id_ = "";
    /**
     *
     *
     * <pre>
     * Required. ID of the rule. This ID must be unique in the `Automation`
     * resource to which this rule belongs. The format is
     * `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The id.
     */
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. ID of the rule. This ID must be unique in the `Automation`
     * resource to which this rule belongs. The format is
     * `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for id.
     */
    public com.google.protobuf.ByteString getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. ID of the rule. This ID must be unique in the `Automation`
     * resource to which this rule belongs. The format is
     * `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      id_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. ID of the rule. This ID must be unique in the `Automation`
     * resource to which this rule belongs. The format is
     * `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {
      id_ = getDefaultInstance().getId();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. ID of the rule. This ID must be unique in the `Automation`
     * resource to which this rule belongs. The format is
     * `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for id to set.
     * @return This builder for chaining.
     */
    public Builder setIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      id_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object destinationTargetId_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The ID of the stage in the pipeline to which this `Release` is
     * deploying. If unspecified, default it to the next stage in the promotion
     * flow. The value of this field could be one of the following:
     *
     * * The last segment of a target name
     * * "&#64;next", the next target in the promotion sequence
     * </pre>
     *
     * <code>string destination_target_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The destinationTargetId.
     */
    public java.lang.String getDestinationTargetId() {
      java.lang.Object ref = destinationTargetId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        destinationTargetId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The ID of the stage in the pipeline to which this `Release` is
     * deploying. If unspecified, default it to the next stage in the promotion
     * flow. The value of this field could be one of the following:
     *
     * * The last segment of a target name
     * * "&#64;next", the next target in the promotion sequence
     * </pre>
     *
     * <code>string destination_target_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for destinationTargetId.
     */
    public com.google.protobuf.ByteString getDestinationTargetIdBytes() {
      java.lang.Object ref = destinationTargetId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        destinationTargetId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The ID of the stage in the pipeline to which this `Release` is
     * deploying. If unspecified, default it to the next stage in the promotion
     * flow. The value of this field could be one of the following:
     *
     * * The last segment of a target name
     * * "&#64;next", the next target in the promotion sequence
     * </pre>
     *
     * <code>string destination_target_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The destinationTargetId to set.
     * @return This builder for chaining.
     */
    public Builder setDestinationTargetId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      destinationTargetId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The ID of the stage in the pipeline to which this `Release` is
     * deploying. If unspecified, default it to the next stage in the promotion
     * flow. The value of this field could be one of the following:
     *
     * * The last segment of a target name
     * * "&#64;next", the next target in the promotion sequence
     * </pre>
     *
     * <code>string destination_target_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDestinationTargetId() {
      destinationTargetId_ = getDefaultInstance().getDestinationTargetId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The ID of the stage in the pipeline to which this `Release` is
     * deploying. If unspecified, default it to the next stage in the promotion
     * flow. The value of this field could be one of the following:
     *
     * * The last segment of a target name
     * * "&#64;next", the next target in the promotion sequence
     * </pre>
     *
     * <code>string destination_target_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for destinationTargetId to set.
     * @return This builder for chaining.
     */
    public Builder setDestinationTargetIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      destinationTargetId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object schedule_ = "";
    /**
     *
     *
     * <pre>
     * Required. Schedule in crontab format. e.g. "0 9 * * 1" for every Monday at
     * 9am.
     * </pre>
     *
     * <code>string schedule = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The schedule.
     */
    public java.lang.String getSchedule() {
      java.lang.Object ref = schedule_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        schedule_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Schedule in crontab format. e.g. "0 9 * * 1" for every Monday at
     * 9am.
     * </pre>
     *
     * <code>string schedule = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for schedule.
     */
    public com.google.protobuf.ByteString getScheduleBytes() {
      java.lang.Object ref = schedule_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        schedule_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Schedule in crontab format. e.g. "0 9 * * 1" for every Monday at
     * 9am.
     * </pre>
     *
     * <code>string schedule = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The schedule to set.
     * @return This builder for chaining.
     */
    public Builder setSchedule(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      schedule_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Schedule in crontab format. e.g. "0 9 * * 1" for every Monday at
     * 9am.
     * </pre>
     *
     * <code>string schedule = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSchedule() {
      schedule_ = getDefaultInstance().getSchedule();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Schedule in crontab format. e.g. "0 9 * * 1" for every Monday at
     * 9am.
     * </pre>
     *
     * <code>string schedule = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for schedule to set.
     * @return This builder for chaining.
     */
    public Builder setScheduleBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      schedule_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object timeZone_ = "";
    /**
     *
     *
     * <pre>
     * Required. The time zone in IANA format [IANA Time Zone
     * Database](https://www.iana.org/time-zones) (e.g. America/New_York).
     * </pre>
     *
     * <code>string time_zone = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The timeZone.
     */
    public java.lang.String getTimeZone() {
      java.lang.Object ref = timeZone_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        timeZone_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The time zone in IANA format [IANA Time Zone
     * Database](https://www.iana.org/time-zones) (e.g. America/New_York).
     * </pre>
     *
     * <code>string time_zone = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for timeZone.
     */
    public com.google.protobuf.ByteString getTimeZoneBytes() {
      java.lang.Object ref = timeZone_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        timeZone_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The time zone in IANA format [IANA Time Zone
     * Database](https://www.iana.org/time-zones) (e.g. America/New_York).
     * </pre>
     *
     * <code>string time_zone = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The timeZone to set.
     * @return This builder for chaining.
     */
    public Builder setTimeZone(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      timeZone_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The time zone in IANA format [IANA Time Zone
     * Database](https://www.iana.org/time-zones) (e.g. America/New_York).
     * </pre>
     *
     * <code>string time_zone = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTimeZone() {
      timeZone_ = getDefaultInstance().getTimeZone();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The time zone in IANA format [IANA Time Zone
     * Database](https://www.iana.org/time-zones) (e.g. America/New_York).
     * </pre>
     *
     * <code>string time_zone = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for timeZone to set.
     * @return This builder for chaining.
     */
    public Builder setTimeZoneBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      timeZone_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.cloud.deploy.v1.AutomationRuleCondition condition_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.AutomationRuleCondition,
            com.google.cloud.deploy.v1.AutomationRuleCondition.Builder,
            com.google.cloud.deploy.v1.AutomationRuleConditionOrBuilder>
        conditionBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Information around the state of the Automation rule.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AutomationRuleCondition condition = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the condition field is set.
     */
    public boolean hasCondition() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Information around the state of the Automation rule.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AutomationRuleCondition condition = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The condition.
     */
    public com.google.cloud.deploy.v1.AutomationRuleCondition getCondition() {
      if (conditionBuilder_ == null) {
        return condition_ == null
            ? com.google.cloud.deploy.v1.AutomationRuleCondition.getDefaultInstance()
            : condition_;
      } else {
        return conditionBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Information around the state of the Automation rule.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AutomationRuleCondition condition = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCondition(com.google.cloud.deploy.v1.AutomationRuleCondition value) {
      if (conditionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        condition_ = value;
      } else {
        conditionBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information around the state of the Automation rule.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AutomationRuleCondition condition = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCondition(
        com.google.cloud.deploy.v1.AutomationRuleCondition.Builder builderForValue) {
      if (conditionBuilder_ == null) {
        condition_ = builderForValue.build();
      } else {
        conditionBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information around the state of the Automation rule.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AutomationRuleCondition condition = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCondition(com.google.cloud.deploy.v1.AutomationRuleCondition value) {
      if (conditionBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && condition_ != null
            && condition_
                != com.google.cloud.deploy.v1.AutomationRuleCondition.getDefaultInstance()) {
          getConditionBuilder().mergeFrom(value);
        } else {
          condition_ = value;
        }
      } else {
        conditionBuilder_.mergeFrom(value);
      }
      if (condition_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information around the state of the Automation rule.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AutomationRuleCondition condition = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCondition() {
      bitField0_ = (bitField0_ & ~0x00000010);
      condition_ = null;
      if (conditionBuilder_ != null) {
        conditionBuilder_.dispose();
        conditionBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information around the state of the Automation rule.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AutomationRuleCondition condition = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.deploy.v1.AutomationRuleCondition.Builder getConditionBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getConditionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Information around the state of the Automation rule.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AutomationRuleCondition condition = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.deploy.v1.AutomationRuleConditionOrBuilder getConditionOrBuilder() {
      if (conditionBuilder_ != null) {
        return conditionBuilder_.getMessageOrBuilder();
      } else {
        return condition_ == null
            ? com.google.cloud.deploy.v1.AutomationRuleCondition.getDefaultInstance()
            : condition_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Information around the state of the Automation rule.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AutomationRuleCondition condition = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.AutomationRuleCondition,
            com.google.cloud.deploy.v1.AutomationRuleCondition.Builder,
            com.google.cloud.deploy.v1.AutomationRuleConditionOrBuilder>
        getConditionFieldBuilder() {
      if (conditionBuilder_ == null) {
        conditionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.deploy.v1.AutomationRuleCondition,
                com.google.cloud.deploy.v1.AutomationRuleCondition.Builder,
                com.google.cloud.deploy.v1.AutomationRuleConditionOrBuilder>(
                getCondition(), getParentForChildren(), isClean());
        condition_ = null;
      }
      return conditionBuilder_;
    }

    private java.lang.Object destinationPhase_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The starting phase of the rollout created by this rule. Default
     * to the first phase.
     * </pre>
     *
     * <code>string destination_phase = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The destinationPhase.
     */
    public java.lang.String getDestinationPhase() {
      java.lang.Object ref = destinationPhase_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        destinationPhase_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The starting phase of the rollout created by this rule. Default
     * to the first phase.
     * </pre>
     *
     * <code>string destination_phase = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for destinationPhase.
     */
    public com.google.protobuf.ByteString getDestinationPhaseBytes() {
      java.lang.Object ref = destinationPhase_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        destinationPhase_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The starting phase of the rollout created by this rule. Default
     * to the first phase.
     * </pre>
     *
     * <code>string destination_phase = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The destinationPhase to set.
     * @return This builder for chaining.
     */
    public Builder setDestinationPhase(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      destinationPhase_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The starting phase of the rollout created by this rule. Default
     * to the first phase.
     * </pre>
     *
     * <code>string destination_phase = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDestinationPhase() {
      destinationPhase_ = getDefaultInstance().getDestinationPhase();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The starting phase of the rollout created by this rule. Default
     * to the first phase.
     * </pre>
     *
     * <code>string destination_phase = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for destinationPhase to set.
     * @return This builder for chaining.
     */
    public Builder setDestinationPhaseBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      destinationPhase_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.deploy.v1.TimedPromoteReleaseRule)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.deploy.v1.TimedPromoteReleaseRule)
  private static final com.google.cloud.deploy.v1.TimedPromoteReleaseRule DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.deploy.v1.TimedPromoteReleaseRule();
  }

  public static com.google.cloud.deploy.v1.TimedPromoteReleaseRule getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TimedPromoteReleaseRule> PARSER =
      new com.google.protobuf.AbstractParser<TimedPromoteReleaseRule>() {
        @java.lang.Override
        public TimedPromoteReleaseRule parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<TimedPromoteReleaseRule> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TimedPromoteReleaseRule> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.deploy.v1.TimedPromoteReleaseRule getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
