/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/deploy/v1/cloud_deploy.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.deploy.v1;

/**
 *
 *
 * <pre>
 * Weekly windows. For example, blocking actions every Saturday and Sunday.
 * Another example would be blocking actions every weekday from 5pm to midnight.
 * </pre>
 *
 * Protobuf type {@code google.cloud.deploy.v1.WeeklyWindow}
 */
public final class WeeklyWindow extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.deploy.v1.WeeklyWindow)
    WeeklyWindowOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use WeeklyWindow.newBuilder() to construct.
  private WeeklyWindow(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private WeeklyWindow() {
    daysOfWeek_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new WeeklyWindow();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.deploy.v1.CloudDeployProto
        .internal_static_google_cloud_deploy_v1_WeeklyWindow_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.deploy.v1.CloudDeployProto
        .internal_static_google_cloud_deploy_v1_WeeklyWindow_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.deploy.v1.WeeklyWindow.class,
            com.google.cloud.deploy.v1.WeeklyWindow.Builder.class);
  }

  private int bitField0_;
  public static final int DAYS_OF_WEEK_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<java.lang.Integer> daysOfWeek_;

  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.type.DayOfWeek>
      daysOfWeek_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, com.google.type.DayOfWeek>() {
            public com.google.type.DayOfWeek convert(java.lang.Integer from) {
              com.google.type.DayOfWeek result = com.google.type.DayOfWeek.forNumber(from);
              return result == null ? com.google.type.DayOfWeek.UNRECOGNIZED : result;
            }
          };
  /**
   *
   *
   * <pre>
   * Optional. Days of week. If left empty, all days of the week will be
   * included.
   * </pre>
   *
   * <code>
   * repeated .google.type.DayOfWeek days_of_week = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return A list containing the daysOfWeek.
   */
  @java.lang.Override
  public java.util.List<com.google.type.DayOfWeek> getDaysOfWeekList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.type.DayOfWeek>(daysOfWeek_, daysOfWeek_converter_);
  }
  /**
   *
   *
   * <pre>
   * Optional. Days of week. If left empty, all days of the week will be
   * included.
   * </pre>
   *
   * <code>
   * repeated .google.type.DayOfWeek days_of_week = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The count of daysOfWeek.
   */
  @java.lang.Override
  public int getDaysOfWeekCount() {
    return daysOfWeek_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Days of week. If left empty, all days of the week will be
   * included.
   * </pre>
   *
   * <code>
   * repeated .google.type.DayOfWeek days_of_week = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The daysOfWeek at the given index.
   */
  @java.lang.Override
  public com.google.type.DayOfWeek getDaysOfWeek(int index) {
    return daysOfWeek_converter_.convert(daysOfWeek_.get(index));
  }
  /**
   *
   *
   * <pre>
   * Optional. Days of week. If left empty, all days of the week will be
   * included.
   * </pre>
   *
   * <code>
   * repeated .google.type.DayOfWeek days_of_week = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return A list containing the enum numeric values on the wire for daysOfWeek.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getDaysOfWeekValueList() {
    return daysOfWeek_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Days of week. If left empty, all days of the week will be
   * included.
   * </pre>
   *
   * <code>
   * repeated .google.type.DayOfWeek days_of_week = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of daysOfWeek at the given index.
   */
  @java.lang.Override
  public int getDaysOfWeekValue(int index) {
    return daysOfWeek_.get(index);
  }

  private int daysOfWeekMemoizedSerializedSize;

  public static final int START_TIME_FIELD_NUMBER = 2;
  private com.google.type.TimeOfDay startTime_;
  /**
   *
   *
   * <pre>
   * Optional. Start time (inclusive). Use 00:00 for the beginning of the day.
   * If you specify start_time you must also specify end_time. If left empty,
   * this will block for the entire day for the days specified in days_of_week.
   * </pre>
   *
   * <code>.google.type.TimeOfDay start_time = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return Whether the startTime field is set.
   */
  @java.lang.Override
  public boolean hasStartTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Start time (inclusive). Use 00:00 for the beginning of the day.
   * If you specify start_time you must also specify end_time. If left empty,
   * this will block for the entire day for the days specified in days_of_week.
   * </pre>
   *
   * <code>.google.type.TimeOfDay start_time = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The startTime.
   */
  @java.lang.Override
  public com.google.type.TimeOfDay getStartTime() {
    return startTime_ == null ? com.google.type.TimeOfDay.getDefaultInstance() : startTime_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Start time (inclusive). Use 00:00 for the beginning of the day.
   * If you specify start_time you must also specify end_time. If left empty,
   * this will block for the entire day for the days specified in days_of_week.
   * </pre>
   *
   * <code>.google.type.TimeOfDay start_time = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public com.google.type.TimeOfDayOrBuilder getStartTimeOrBuilder() {
    return startTime_ == null ? com.google.type.TimeOfDay.getDefaultInstance() : startTime_;
  }

  public static final int END_TIME_FIELD_NUMBER = 3;
  private com.google.type.TimeOfDay endTime_;
  /**
   *
   *
   * <pre>
   * Optional. End time (exclusive). Use 24:00 to indicate midnight. If you
   * specify end_time you must also specify start_time. If left empty, this will
   * block for the entire day for the days specified in days_of_week.
   * </pre>
   *
   * <code>.google.type.TimeOfDay end_time = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return Whether the endTime field is set.
   */
  @java.lang.Override
  public boolean hasEndTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. End time (exclusive). Use 24:00 to indicate midnight. If you
   * specify end_time you must also specify start_time. If left empty, this will
   * block for the entire day for the days specified in days_of_week.
   * </pre>
   *
   * <code>.google.type.TimeOfDay end_time = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The endTime.
   */
  @java.lang.Override
  public com.google.type.TimeOfDay getEndTime() {
    return endTime_ == null ? com.google.type.TimeOfDay.getDefaultInstance() : endTime_;
  }
  /**
   *
   *
   * <pre>
   * Optional. End time (exclusive). Use 24:00 to indicate midnight. If you
   * specify end_time you must also specify start_time. If left empty, this will
   * block for the entire day for the days specified in days_of_week.
   * </pre>
   *
   * <code>.google.type.TimeOfDay end_time = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public com.google.type.TimeOfDayOrBuilder getEndTimeOrBuilder() {
    return endTime_ == null ? com.google.type.TimeOfDay.getDefaultInstance() : endTime_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (getDaysOfWeekList().size() > 0) {
      output.writeUInt32NoTag(10);
      output.writeUInt32NoTag(daysOfWeekMemoizedSerializedSize);
    }
    for (int i = 0; i < daysOfWeek_.size(); i++) {
      output.writeEnumNoTag(daysOfWeek_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getStartTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(3, getEndTime());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    {
      int dataSize = 0;
      for (int i = 0; i < daysOfWeek_.size(); i++) {
        dataSize += com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(daysOfWeek_.get(i));
      }
      size += dataSize;
      if (!getDaysOfWeekList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      daysOfWeekMemoizedSerializedSize = dataSize;
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getStartTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getEndTime());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.deploy.v1.WeeklyWindow)) {
      return super.equals(obj);
    }
    com.google.cloud.deploy.v1.WeeklyWindow other = (com.google.cloud.deploy.v1.WeeklyWindow) obj;

    if (!daysOfWeek_.equals(other.daysOfWeek_)) return false;
    if (hasStartTime() != other.hasStartTime()) return false;
    if (hasStartTime()) {
      if (!getStartTime().equals(other.getStartTime())) return false;
    }
    if (hasEndTime() != other.hasEndTime()) return false;
    if (hasEndTime()) {
      if (!getEndTime().equals(other.getEndTime())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getDaysOfWeekCount() > 0) {
      hash = (37 * hash) + DAYS_OF_WEEK_FIELD_NUMBER;
      hash = (53 * hash) + daysOfWeek_.hashCode();
    }
    if (hasStartTime()) {
      hash = (37 * hash) + START_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getStartTime().hashCode();
    }
    if (hasEndTime()) {
      hash = (37 * hash) + END_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getEndTime().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.deploy.v1.WeeklyWindow parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.WeeklyWindow parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.WeeklyWindow parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.WeeklyWindow parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.WeeklyWindow parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.WeeklyWindow parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.WeeklyWindow parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.WeeklyWindow parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.WeeklyWindow parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.WeeklyWindow parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.WeeklyWindow parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.WeeklyWindow parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.deploy.v1.WeeklyWindow prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Weekly windows. For example, blocking actions every Saturday and Sunday.
   * Another example would be blocking actions every weekday from 5pm to midnight.
   * </pre>
   *
   * Protobuf type {@code google.cloud.deploy.v1.WeeklyWindow}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.deploy.v1.WeeklyWindow)
      com.google.cloud.deploy.v1.WeeklyWindowOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_WeeklyWindow_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_WeeklyWindow_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.deploy.v1.WeeklyWindow.class,
              com.google.cloud.deploy.v1.WeeklyWindow.Builder.class);
    }

    // Construct using com.google.cloud.deploy.v1.WeeklyWindow.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getStartTimeFieldBuilder();
        getEndTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      daysOfWeek_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000001);
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_WeeklyWindow_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.WeeklyWindow getDefaultInstanceForType() {
      return com.google.cloud.deploy.v1.WeeklyWindow.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.WeeklyWindow build() {
      com.google.cloud.deploy.v1.WeeklyWindow result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.WeeklyWindow buildPartial() {
      com.google.cloud.deploy.v1.WeeklyWindow result =
          new com.google.cloud.deploy.v1.WeeklyWindow(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.deploy.v1.WeeklyWindow result) {
      if (((bitField0_ & 0x00000001) != 0)) {
        daysOfWeek_ = java.util.Collections.unmodifiableList(daysOfWeek_);
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.daysOfWeek_ = daysOfWeek_;
    }

    private void buildPartial0(com.google.cloud.deploy.v1.WeeklyWindow result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.startTime_ = startTimeBuilder_ == null ? startTime_ : startTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.endTime_ = endTimeBuilder_ == null ? endTime_ : endTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.deploy.v1.WeeklyWindow) {
        return mergeFrom((com.google.cloud.deploy.v1.WeeklyWindow) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.deploy.v1.WeeklyWindow other) {
      if (other == com.google.cloud.deploy.v1.WeeklyWindow.getDefaultInstance()) return this;
      if (!other.daysOfWeek_.isEmpty()) {
        if (daysOfWeek_.isEmpty()) {
          daysOfWeek_ = other.daysOfWeek_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensureDaysOfWeekIsMutable();
          daysOfWeek_.addAll(other.daysOfWeek_);
        }
        onChanged();
      }
      if (other.hasStartTime()) {
        mergeStartTime(other.getStartTime());
      }
      if (other.hasEndTime()) {
        mergeEndTime(other.getEndTime());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                int tmpRaw = input.readEnum();
                ensureDaysOfWeekIsMutable();
                daysOfWeek_.add(tmpRaw);
                break;
              } // case 8
            case 10:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensureDaysOfWeekIsMutable();
                  daysOfWeek_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getStartTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getEndTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<java.lang.Integer> daysOfWeek_ = java.util.Collections.emptyList();

    private void ensureDaysOfWeekIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        daysOfWeek_ = new java.util.ArrayList<java.lang.Integer>(daysOfWeek_);
        bitField0_ |= 0x00000001;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Days of week. If left empty, all days of the week will be
     * included.
     * </pre>
     *
     * <code>
     * repeated .google.type.DayOfWeek days_of_week = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return A list containing the daysOfWeek.
     */
    public java.util.List<com.google.type.DayOfWeek> getDaysOfWeekList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.type.DayOfWeek>(daysOfWeek_, daysOfWeek_converter_);
    }
    /**
     *
     *
     * <pre>
     * Optional. Days of week. If left empty, all days of the week will be
     * included.
     * </pre>
     *
     * <code>
     * repeated .google.type.DayOfWeek days_of_week = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The count of daysOfWeek.
     */
    public int getDaysOfWeekCount() {
      return daysOfWeek_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Days of week. If left empty, all days of the week will be
     * included.
     * </pre>
     *
     * <code>
     * repeated .google.type.DayOfWeek days_of_week = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The daysOfWeek at the given index.
     */
    public com.google.type.DayOfWeek getDaysOfWeek(int index) {
      return daysOfWeek_converter_.convert(daysOfWeek_.get(index));
    }
    /**
     *
     *
     * <pre>
     * Optional. Days of week. If left empty, all days of the week will be
     * included.
     * </pre>
     *
     * <code>
     * repeated .google.type.DayOfWeek days_of_week = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The daysOfWeek to set.
     * @return This builder for chaining.
     */
    public Builder setDaysOfWeek(int index, com.google.type.DayOfWeek value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureDaysOfWeekIsMutable();
      daysOfWeek_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Days of week. If left empty, all days of the week will be
     * included.
     * </pre>
     *
     * <code>
     * repeated .google.type.DayOfWeek days_of_week = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The daysOfWeek to add.
     * @return This builder for chaining.
     */
    public Builder addDaysOfWeek(com.google.type.DayOfWeek value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureDaysOfWeekIsMutable();
      daysOfWeek_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Days of week. If left empty, all days of the week will be
     * included.
     * </pre>
     *
     * <code>
     * repeated .google.type.DayOfWeek days_of_week = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param values The daysOfWeek to add.
     * @return This builder for chaining.
     */
    public Builder addAllDaysOfWeek(
        java.lang.Iterable<? extends com.google.type.DayOfWeek> values) {
      ensureDaysOfWeekIsMutable();
      for (com.google.type.DayOfWeek value : values) {
        daysOfWeek_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Days of week. If left empty, all days of the week will be
     * included.
     * </pre>
     *
     * <code>
     * repeated .google.type.DayOfWeek days_of_week = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDaysOfWeek() {
      daysOfWeek_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Days of week. If left empty, all days of the week will be
     * included.
     * </pre>
     *
     * <code>
     * repeated .google.type.DayOfWeek days_of_week = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return A list containing the enum numeric values on the wire for daysOfWeek.
     */
    public java.util.List<java.lang.Integer> getDaysOfWeekValueList() {
      return java.util.Collections.unmodifiableList(daysOfWeek_);
    }
    /**
     *
     *
     * <pre>
     * Optional. Days of week. If left empty, all days of the week will be
     * included.
     * </pre>
     *
     * <code>
     * repeated .google.type.DayOfWeek days_of_week = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of daysOfWeek at the given index.
     */
    public int getDaysOfWeekValue(int index) {
      return daysOfWeek_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Days of week. If left empty, all days of the week will be
     * included.
     * </pre>
     *
     * <code>
     * repeated .google.type.DayOfWeek days_of_week = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for daysOfWeek to set.
     * @return This builder for chaining.
     */
    public Builder setDaysOfWeekValue(int index, int value) {
      ensureDaysOfWeekIsMutable();
      daysOfWeek_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Days of week. If left empty, all days of the week will be
     * included.
     * </pre>
     *
     * <code>
     * repeated .google.type.DayOfWeek days_of_week = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for daysOfWeek to add.
     * @return This builder for chaining.
     */
    public Builder addDaysOfWeekValue(int value) {
      ensureDaysOfWeekIsMutable();
      daysOfWeek_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Days of week. If left empty, all days of the week will be
     * included.
     * </pre>
     *
     * <code>
     * repeated .google.type.DayOfWeek days_of_week = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param values The enum numeric values on the wire for daysOfWeek to add.
     * @return This builder for chaining.
     */
    public Builder addAllDaysOfWeekValue(java.lang.Iterable<java.lang.Integer> values) {
      ensureDaysOfWeekIsMutable();
      for (int value : values) {
        daysOfWeek_.add(value);
      }
      onChanged();
      return this;
    }

    private com.google.type.TimeOfDay startTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.TimeOfDay,
            com.google.type.TimeOfDay.Builder,
            com.google.type.TimeOfDayOrBuilder>
        startTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Start time (inclusive). Use 00:00 for the beginning of the day.
     * If you specify start_time you must also specify end_time. If left empty,
     * this will block for the entire day for the days specified in days_of_week.
     * </pre>
     *
     * <code>.google.type.TimeOfDay start_time = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return Whether the startTime field is set.
     */
    public boolean hasStartTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Start time (inclusive). Use 00:00 for the beginning of the day.
     * If you specify start_time you must also specify end_time. If left empty,
     * this will block for the entire day for the days specified in days_of_week.
     * </pre>
     *
     * <code>.google.type.TimeOfDay start_time = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The startTime.
     */
    public com.google.type.TimeOfDay getStartTime() {
      if (startTimeBuilder_ == null) {
        return startTime_ == null ? com.google.type.TimeOfDay.getDefaultInstance() : startTime_;
      } else {
        return startTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Start time (inclusive). Use 00:00 for the beginning of the day.
     * If you specify start_time you must also specify end_time. If left empty,
     * this will block for the entire day for the days specified in days_of_week.
     * </pre>
     *
     * <code>.google.type.TimeOfDay start_time = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder setStartTime(com.google.type.TimeOfDay value) {
      if (startTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        startTime_ = value;
      } else {
        startTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Start time (inclusive). Use 00:00 for the beginning of the day.
     * If you specify start_time you must also specify end_time. If left empty,
     * this will block for the entire day for the days specified in days_of_week.
     * </pre>
     *
     * <code>.google.type.TimeOfDay start_time = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder setStartTime(com.google.type.TimeOfDay.Builder builderForValue) {
      if (startTimeBuilder_ == null) {
        startTime_ = builderForValue.build();
      } else {
        startTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Start time (inclusive). Use 00:00 for the beginning of the day.
     * If you specify start_time you must also specify end_time. If left empty,
     * this will block for the entire day for the days specified in days_of_week.
     * </pre>
     *
     * <code>.google.type.TimeOfDay start_time = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder mergeStartTime(com.google.type.TimeOfDay value) {
      if (startTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && startTime_ != null
            && startTime_ != com.google.type.TimeOfDay.getDefaultInstance()) {
          getStartTimeBuilder().mergeFrom(value);
        } else {
          startTime_ = value;
        }
      } else {
        startTimeBuilder_.mergeFrom(value);
      }
      if (startTime_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Start time (inclusive). Use 00:00 for the beginning of the day.
     * If you specify start_time you must also specify end_time. If left empty,
     * this will block for the entire day for the days specified in days_of_week.
     * </pre>
     *
     * <code>.google.type.TimeOfDay start_time = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder clearStartTime() {
      bitField0_ = (bitField0_ & ~0x00000002);
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Start time (inclusive). Use 00:00 for the beginning of the day.
     * If you specify start_time you must also specify end_time. If left empty,
     * this will block for the entire day for the days specified in days_of_week.
     * </pre>
     *
     * <code>.google.type.TimeOfDay start_time = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public com.google.type.TimeOfDay.Builder getStartTimeBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getStartTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Start time (inclusive). Use 00:00 for the beginning of the day.
     * If you specify start_time you must also specify end_time. If left empty,
     * this will block for the entire day for the days specified in days_of_week.
     * </pre>
     *
     * <code>.google.type.TimeOfDay start_time = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public com.google.type.TimeOfDayOrBuilder getStartTimeOrBuilder() {
      if (startTimeBuilder_ != null) {
        return startTimeBuilder_.getMessageOrBuilder();
      } else {
        return startTime_ == null ? com.google.type.TimeOfDay.getDefaultInstance() : startTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Start time (inclusive). Use 00:00 for the beginning of the day.
     * If you specify start_time you must also specify end_time. If left empty,
     * this will block for the entire day for the days specified in days_of_week.
     * </pre>
     *
     * <code>.google.type.TimeOfDay start_time = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.TimeOfDay,
            com.google.type.TimeOfDay.Builder,
            com.google.type.TimeOfDayOrBuilder>
        getStartTimeFieldBuilder() {
      if (startTimeBuilder_ == null) {
        startTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.type.TimeOfDay,
                com.google.type.TimeOfDay.Builder,
                com.google.type.TimeOfDayOrBuilder>(
                getStartTime(), getParentForChildren(), isClean());
        startTime_ = null;
      }
      return startTimeBuilder_;
    }

    private com.google.type.TimeOfDay endTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.TimeOfDay,
            com.google.type.TimeOfDay.Builder,
            com.google.type.TimeOfDayOrBuilder>
        endTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. End time (exclusive). Use 24:00 to indicate midnight. If you
     * specify end_time you must also specify start_time. If left empty, this will
     * block for the entire day for the days specified in days_of_week.
     * </pre>
     *
     * <code>.google.type.TimeOfDay end_time = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return Whether the endTime field is set.
     */
    public boolean hasEndTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. End time (exclusive). Use 24:00 to indicate midnight. If you
     * specify end_time you must also specify start_time. If left empty, this will
     * block for the entire day for the days specified in days_of_week.
     * </pre>
     *
     * <code>.google.type.TimeOfDay end_time = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The endTime.
     */
    public com.google.type.TimeOfDay getEndTime() {
      if (endTimeBuilder_ == null) {
        return endTime_ == null ? com.google.type.TimeOfDay.getDefaultInstance() : endTime_;
      } else {
        return endTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. End time (exclusive). Use 24:00 to indicate midnight. If you
     * specify end_time you must also specify start_time. If left empty, this will
     * block for the entire day for the days specified in days_of_week.
     * </pre>
     *
     * <code>.google.type.TimeOfDay end_time = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder setEndTime(com.google.type.TimeOfDay value) {
      if (endTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        endTime_ = value;
      } else {
        endTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. End time (exclusive). Use 24:00 to indicate midnight. If you
     * specify end_time you must also specify start_time. If left empty, this will
     * block for the entire day for the days specified in days_of_week.
     * </pre>
     *
     * <code>.google.type.TimeOfDay end_time = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder setEndTime(com.google.type.TimeOfDay.Builder builderForValue) {
      if (endTimeBuilder_ == null) {
        endTime_ = builderForValue.build();
      } else {
        endTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. End time (exclusive). Use 24:00 to indicate midnight. If you
     * specify end_time you must also specify start_time. If left empty, this will
     * block for the entire day for the days specified in days_of_week.
     * </pre>
     *
     * <code>.google.type.TimeOfDay end_time = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder mergeEndTime(com.google.type.TimeOfDay value) {
      if (endTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && endTime_ != null
            && endTime_ != com.google.type.TimeOfDay.getDefaultInstance()) {
          getEndTimeBuilder().mergeFrom(value);
        } else {
          endTime_ = value;
        }
      } else {
        endTimeBuilder_.mergeFrom(value);
      }
      if (endTime_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. End time (exclusive). Use 24:00 to indicate midnight. If you
     * specify end_time you must also specify start_time. If left empty, this will
     * block for the entire day for the days specified in days_of_week.
     * </pre>
     *
     * <code>.google.type.TimeOfDay end_time = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder clearEndTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. End time (exclusive). Use 24:00 to indicate midnight. If you
     * specify end_time you must also specify start_time. If left empty, this will
     * block for the entire day for the days specified in days_of_week.
     * </pre>
     *
     * <code>.google.type.TimeOfDay end_time = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public com.google.type.TimeOfDay.Builder getEndTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getEndTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. End time (exclusive). Use 24:00 to indicate midnight. If you
     * specify end_time you must also specify start_time. If left empty, this will
     * block for the entire day for the days specified in days_of_week.
     * </pre>
     *
     * <code>.google.type.TimeOfDay end_time = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public com.google.type.TimeOfDayOrBuilder getEndTimeOrBuilder() {
      if (endTimeBuilder_ != null) {
        return endTimeBuilder_.getMessageOrBuilder();
      } else {
        return endTime_ == null ? com.google.type.TimeOfDay.getDefaultInstance() : endTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. End time (exclusive). Use 24:00 to indicate midnight. If you
     * specify end_time you must also specify start_time. If left empty, this will
     * block for the entire day for the days specified in days_of_week.
     * </pre>
     *
     * <code>.google.type.TimeOfDay end_time = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.TimeOfDay,
            com.google.type.TimeOfDay.Builder,
            com.google.type.TimeOfDayOrBuilder>
        getEndTimeFieldBuilder() {
      if (endTimeBuilder_ == null) {
        endTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.type.TimeOfDay,
                com.google.type.TimeOfDay.Builder,
                com.google.type.TimeOfDayOrBuilder>(
                getEndTime(), getParentForChildren(), isClean());
        endTime_ = null;
      }
      return endTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.deploy.v1.WeeklyWindow)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.deploy.v1.WeeklyWindow)
  private static final com.google.cloud.deploy.v1.WeeklyWindow DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.deploy.v1.WeeklyWindow();
  }

  public static com.google.cloud.deploy.v1.WeeklyWindow getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<WeeklyWindow> PARSER =
      new com.google.protobuf.AbstractParser<WeeklyWindow>() {
        @java.lang.Override
        public WeeklyWindow parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<WeeklyWindow> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<WeeklyWindow> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.deploy.v1.WeeklyWindow getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
