/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.deploy.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AutomationName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_DELIVERY_PIPELINE_AUTOMATION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/deliveryPipelines/{delivery_pipeline}/automations/{automation}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String deliveryPipeline;
    private final String automation;

    @Deprecated
    protected AutomationName() {
        this.project = null;
        this.location = null;
        this.deliveryPipeline = null;
        this.automation = null;
    }

    private AutomationName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.deliveryPipeline = (String)Preconditions.checkNotNull((Object)builder.getDeliveryPipeline());
        this.automation = (String)Preconditions.checkNotNull((Object)builder.getAutomation());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDeliveryPipeline() {
        return this.deliveryPipeline;
    }

    public String getAutomation() {
        return this.automation;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AutomationName of(String project, String location, String deliveryPipeline, String automation) {
        return AutomationName.newBuilder().setProject(project).setLocation(location).setDeliveryPipeline(deliveryPipeline).setAutomation(automation).build();
    }

    public static String format(String project, String location, String deliveryPipeline, String automation) {
        return AutomationName.newBuilder().setProject(project).setLocation(location).setDeliveryPipeline(deliveryPipeline).setAutomation(automation).build().toString();
    }

    public static AutomationName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_DELIVERY_PIPELINE_AUTOMATION.validatedMatch(formattedString, "AutomationName.parse: formattedString not in valid format");
        return AutomationName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("delivery_pipeline"), (String)matchMap.get("automation"));
    }

    public static List<AutomationName> parseList(List<String> formattedStrings) {
        ArrayList<AutomationName> list = new ArrayList<AutomationName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AutomationName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AutomationName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AutomationName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_DELIVERY_PIPELINE_AUTOMATION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AutomationName automationName = this;
            synchronized (automationName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.deliveryPipeline != null) {
                        fieldMapBuilder.put((Object)"delivery_pipeline", (Object)this.deliveryPipeline);
                    }
                    if (this.automation != null) {
                        fieldMapBuilder.put((Object)"automation", (Object)this.automation);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_DELIVERY_PIPELINE_AUTOMATION.instantiate(new String[]{"project", this.project, "location", this.location, "delivery_pipeline", this.deliveryPipeline, "automation", this.automation});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            AutomationName that = (AutomationName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.deliveryPipeline, that.deliveryPipeline) && Objects.equals(this.automation, that.automation);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.deliveryPipeline);
        h *= 1000003;
        return h ^= Objects.hashCode(this.automation);
    }

    public static class Builder {
        private String project;
        private String location;
        private String deliveryPipeline;
        private String automation;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getDeliveryPipeline() {
            return this.deliveryPipeline;
        }

        public String getAutomation() {
            return this.automation;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setDeliveryPipeline(String deliveryPipeline) {
            this.deliveryPipeline = deliveryPipeline;
            return this;
        }

        public Builder setAutomation(String automation) {
            this.automation = automation;
            return this;
        }

        private Builder(AutomationName automationName) {
            this.project = automationName.project;
            this.location = automationName.location;
            this.deliveryPipeline = automationName.deliveryPipeline;
            this.automation = automationName.automation;
        }

        public AutomationName build() {
            return new AutomationName(this);
        }
    }
}

