/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.cx.v3beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class FlowName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_AGENT_FLOW = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/agents/{agent}/flows/{flow}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String agent;
    private final String flow;

    @Deprecated
    protected FlowName() {
        this.project = null;
        this.location = null;
        this.agent = null;
        this.flow = null;
    }

    private FlowName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.agent = (String)Preconditions.checkNotNull((Object)builder.getAgent());
        this.flow = (String)Preconditions.checkNotNull((Object)builder.getFlow());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getAgent() {
        return this.agent;
    }

    public String getFlow() {
        return this.flow;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static FlowName of(String project, String location, String agent, String flow) {
        return FlowName.newBuilder().setProject(project).setLocation(location).setAgent(agent).setFlow(flow).build();
    }

    public static String format(String project, String location, String agent, String flow) {
        return FlowName.newBuilder().setProject(project).setLocation(location).setAgent(agent).setFlow(flow).build().toString();
    }

    public static FlowName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_AGENT_FLOW.validatedMatch(formattedString, "FlowName.parse: formattedString not in valid format");
        return FlowName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("agent"), (String)matchMap.get("flow"));
    }

    public static List<FlowName> parseList(List<String> formattedStrings) {
        ArrayList<FlowName> list = new ArrayList<FlowName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(FlowName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<FlowName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (FlowName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_AGENT_FLOW.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            FlowName flowName = this;
            synchronized (flowName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.agent != null) {
                        fieldMapBuilder.put((Object)"agent", (Object)this.agent);
                    }
                    if (this.flow != null) {
                        fieldMapBuilder.put((Object)"flow", (Object)this.flow);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_AGENT_FLOW.instantiate(new String[]{"project", this.project, "location", this.location, "agent", this.agent, "flow", this.flow});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            FlowName that = (FlowName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.agent, that.agent) && Objects.equals(this.flow, that.flow);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.agent);
        h *= 1000003;
        return h ^= Objects.hashCode(this.flow);
    }

    public static class Builder {
        private String project;
        private String location;
        private String agent;
        private String flow;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getAgent() {
            return this.agent;
        }

        public String getFlow() {
            return this.flow;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setAgent(String agent) {
            this.agent = agent;
            return this;
        }

        public Builder setFlow(String flow) {
            this.flow = flow;
            return this;
        }

        private Builder(FlowName flowName) {
            this.project = flowName.project;
            this.location = flowName.location;
            this.agent = flowName.agent;
            this.flow = flowName.flow;
        }

        public FlowName build() {
            return new FlowName(this);
        }
    }
}

