/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.cx.v3beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SecuritySettingsName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_SECURITY_SETTINGS = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/securitySettings/{security_settings}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String securitySettings;

    @Deprecated
    protected SecuritySettingsName() {
        this.project = null;
        this.location = null;
        this.securitySettings = null;
    }

    private SecuritySettingsName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.securitySettings = (String)Preconditions.checkNotNull((Object)builder.getSecuritySettings());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getSecuritySettings() {
        return this.securitySettings;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static SecuritySettingsName of(String project, String location, String securitySettings) {
        return SecuritySettingsName.newBuilder().setProject(project).setLocation(location).setSecuritySettings(securitySettings).build();
    }

    public static String format(String project, String location, String securitySettings) {
        return SecuritySettingsName.newBuilder().setProject(project).setLocation(location).setSecuritySettings(securitySettings).build().toString();
    }

    public static SecuritySettingsName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_SECURITY_SETTINGS.validatedMatch(formattedString, "SecuritySettingsName.parse: formattedString not in valid format");
        return SecuritySettingsName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("security_settings"));
    }

    public static List<SecuritySettingsName> parseList(List<String> formattedStrings) {
        ArrayList<SecuritySettingsName> list = new ArrayList<SecuritySettingsName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SecuritySettingsName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SecuritySettingsName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SecuritySettingsName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_SECURITY_SETTINGS.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SecuritySettingsName securitySettingsName = this;
            synchronized (securitySettingsName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.securitySettings != null) {
                        fieldMapBuilder.put((Object)"security_settings", (Object)this.securitySettings);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_SECURITY_SETTINGS.instantiate(new String[]{"project", this.project, "location", this.location, "security_settings", this.securitySettings});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            SecuritySettingsName that = (SecuritySettingsName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.securitySettings, that.securitySettings);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.securitySettings);
    }

    public static class Builder {
        private String project;
        private String location;
        private String securitySettings;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getSecuritySettings() {
            return this.securitySettings;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setSecuritySettings(String securitySettings) {
            this.securitySettings = securitySettings;
            return this;
        }

        private Builder(SecuritySettingsName securitySettingsName) {
            this.project = securitySettingsName.project;
            this.location = securitySettingsName.location;
            this.securitySettings = securitySettingsName.securitySettings;
        }

        public SecuritySettingsName build() {
            return new SecuritySettingsName(this);
        }
    }
}

