/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.cx.v3beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TransitionRouteGroupName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_AGENT_FLOW_TRANSITION_ROUTE_GROUP = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/agents/{agent}/flows/{flow}/transitionRouteGroups/{transition_route_group}");
    private static final PathTemplate PROJECT_LOCATION_AGENT_TRANSITION_ROUTE_GROUP = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/agents/{agent}/transitionRouteGroups/{transition_route_group}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String location;
    private final String agent;
    private final String flow;
    private final String transitionRouteGroup;

    @Deprecated
    protected TransitionRouteGroupName() {
        this.project = null;
        this.location = null;
        this.agent = null;
        this.flow = null;
        this.transitionRouteGroup = null;
    }

    private TransitionRouteGroupName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.agent = (String)Preconditions.checkNotNull((Object)builder.getAgent());
        this.flow = (String)Preconditions.checkNotNull((Object)builder.getFlow());
        this.transitionRouteGroup = (String)Preconditions.checkNotNull((Object)builder.getTransitionRouteGroup());
        this.pathTemplate = PROJECT_LOCATION_AGENT_FLOW_TRANSITION_ROUTE_GROUP;
    }

    private TransitionRouteGroupName(ProjectLocationAgentTransitionRouteGroupBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.agent = (String)Preconditions.checkNotNull((Object)builder.getAgent());
        this.transitionRouteGroup = (String)Preconditions.checkNotNull((Object)builder.getTransitionRouteGroup());
        this.flow = null;
        this.pathTemplate = PROJECT_LOCATION_AGENT_TRANSITION_ROUTE_GROUP;
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getAgent() {
        return this.agent;
    }

    public String getFlow() {
        return this.flow;
    }

    public String getTransitionRouteGroup() {
        return this.transitionRouteGroup;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newProjectLocationAgentFlowTransitionRouteGroupBuilder() {
        return new Builder();
    }

    public static ProjectLocationAgentTransitionRouteGroupBuilder newProjectLocationAgentTransitionRouteGroupBuilder() {
        return new ProjectLocationAgentTransitionRouteGroupBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static TransitionRouteGroupName of(String project, String location, String agent, String flow, String transitionRouteGroup) {
        return TransitionRouteGroupName.newBuilder().setProject(project).setLocation(location).setAgent(agent).setFlow(flow).setTransitionRouteGroup(transitionRouteGroup).build();
    }

    public static TransitionRouteGroupName ofProjectLocationAgentFlowTransitionRouteGroupName(String project, String location, String agent, String flow, String transitionRouteGroup) {
        return TransitionRouteGroupName.newBuilder().setProject(project).setLocation(location).setAgent(agent).setFlow(flow).setTransitionRouteGroup(transitionRouteGroup).build();
    }

    public static TransitionRouteGroupName ofProjectLocationAgentTransitionRouteGroupName(String project, String location, String agent, String transitionRouteGroup) {
        return TransitionRouteGroupName.newProjectLocationAgentTransitionRouteGroupBuilder().setProject(project).setLocation(location).setAgent(agent).setTransitionRouteGroup(transitionRouteGroup).build();
    }

    public static String format(String project, String location, String agent, String flow, String transitionRouteGroup) {
        return TransitionRouteGroupName.newBuilder().setProject(project).setLocation(location).setAgent(agent).setFlow(flow).setTransitionRouteGroup(transitionRouteGroup).build().toString();
    }

    public static String formatProjectLocationAgentFlowTransitionRouteGroupName(String project, String location, String agent, String flow, String transitionRouteGroup) {
        return TransitionRouteGroupName.newBuilder().setProject(project).setLocation(location).setAgent(agent).setFlow(flow).setTransitionRouteGroup(transitionRouteGroup).build().toString();
    }

    public static String formatProjectLocationAgentTransitionRouteGroupName(String project, String location, String agent, String transitionRouteGroup) {
        return TransitionRouteGroupName.newProjectLocationAgentTransitionRouteGroupBuilder().setProject(project).setLocation(location).setAgent(agent).setTransitionRouteGroup(transitionRouteGroup).build().toString();
    }

    public static TransitionRouteGroupName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_LOCATION_AGENT_FLOW_TRANSITION_ROUTE_GROUP.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_AGENT_FLOW_TRANSITION_ROUTE_GROUP.match(formattedString);
            return TransitionRouteGroupName.ofProjectLocationAgentFlowTransitionRouteGroupName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("agent"), (String)matchMap.get("flow"), (String)matchMap.get("transition_route_group"));
        }
        if (PROJECT_LOCATION_AGENT_TRANSITION_ROUTE_GROUP.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_AGENT_TRANSITION_ROUTE_GROUP.match(formattedString);
            return TransitionRouteGroupName.ofProjectLocationAgentTransitionRouteGroupName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("agent"), (String)matchMap.get("transition_route_group"));
        }
        throw new ValidationException("TransitionRouteGroupName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<TransitionRouteGroupName> parseList(List<String> formattedStrings) {
        ArrayList<TransitionRouteGroupName> list = new ArrayList<TransitionRouteGroupName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(TransitionRouteGroupName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<TransitionRouteGroupName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (TransitionRouteGroupName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_AGENT_FLOW_TRANSITION_ROUTE_GROUP.matches(formattedString) || PROJECT_LOCATION_AGENT_TRANSITION_ROUTE_GROUP.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            TransitionRouteGroupName transitionRouteGroupName = this;
            synchronized (transitionRouteGroupName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.agent != null) {
                        fieldMapBuilder.put((Object)"agent", (Object)this.agent);
                    }
                    if (this.flow != null) {
                        fieldMapBuilder.put((Object)"flow", (Object)this.flow);
                    }
                    if (this.transitionRouteGroup != null) {
                        fieldMapBuilder.put((Object)"transition_route_group", (Object)this.transitionRouteGroup);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            TransitionRouteGroupName that = (TransitionRouteGroupName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.agent, that.agent) && Objects.equals(this.flow, that.flow) && Objects.equals(this.transitionRouteGroup, that.transitionRouteGroup);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.agent);
        h *= 1000003;
        h ^= Objects.hashCode(this.flow);
        h *= 1000003;
        return h ^= Objects.hashCode(this.transitionRouteGroup);
    }

    public static class ProjectLocationAgentTransitionRouteGroupBuilder {
        private String project;
        private String location;
        private String agent;
        private String transitionRouteGroup;

        protected ProjectLocationAgentTransitionRouteGroupBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getAgent() {
            return this.agent;
        }

        public String getTransitionRouteGroup() {
            return this.transitionRouteGroup;
        }

        public ProjectLocationAgentTransitionRouteGroupBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationAgentTransitionRouteGroupBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationAgentTransitionRouteGroupBuilder setAgent(String agent) {
            this.agent = agent;
            return this;
        }

        public ProjectLocationAgentTransitionRouteGroupBuilder setTransitionRouteGroup(String transitionRouteGroup) {
            this.transitionRouteGroup = transitionRouteGroup;
            return this;
        }

        public TransitionRouteGroupName build() {
            return new TransitionRouteGroupName(this);
        }
    }

    public static class Builder {
        private String project;
        private String location;
        private String agent;
        private String flow;
        private String transitionRouteGroup;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getAgent() {
            return this.agent;
        }

        public String getFlow() {
            return this.flow;
        }

        public String getTransitionRouteGroup() {
            return this.transitionRouteGroup;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setAgent(String agent) {
            this.agent = agent;
            return this;
        }

        public Builder setFlow(String flow) {
            this.flow = flow;
            return this;
        }

        public Builder setTransitionRouteGroup(String transitionRouteGroup) {
            this.transitionRouteGroup = transitionRouteGroup;
            return this;
        }

        private Builder(TransitionRouteGroupName transitionRouteGroupName) {
            Preconditions.checkArgument((boolean)Objects.equals(transitionRouteGroupName.pathTemplate, PROJECT_LOCATION_AGENT_FLOW_TRANSITION_ROUTE_GROUP), (Object)"toBuilder is only supported when TransitionRouteGroupName has the pattern of projects/{project}/locations/{location}/agents/{agent}/flows/{flow}/transitionRouteGroups/{transition_route_group}");
            this.project = transitionRouteGroupName.project;
            this.location = transitionRouteGroupName.location;
            this.agent = transitionRouteGroupName.agent;
            this.flow = transitionRouteGroupName.flow;
            this.transitionRouteGroup = transitionRouteGroupName.transitionRouteGroup;
        }

        public TransitionRouteGroupName build() {
            return new TransitionRouteGroupName(this);
        }
    }
}

