/*
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/v2/agent.proto

package com.google.cloud.dialogflow.v2;

/**
 *
 *
 * <pre>
 * Represents a conversational agent.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.v2.Agent}
 */
public final class Agent extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2.Agent)
    AgentOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Agent.newBuilder() to construct.
  private Agent(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Agent() {
    parent_ = "";
    displayName_ = "";
    defaultLanguageCode_ = "";
    supportedLanguageCodes_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    timeZone_ = "";
    description_ = "";
    avatarUri_ = "";
    matchMode_ = 0;
    apiVersion_ = 0;
    tier_ = 0;
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private Agent(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              parent_ = s;
              break;
            }
          case 18:
            {
              java.lang.String s = input.readStringRequireUtf8();

              displayName_ = s;
              break;
            }
          case 26:
            {
              java.lang.String s = input.readStringRequireUtf8();

              defaultLanguageCode_ = s;
              break;
            }
          case 34:
            {
              java.lang.String s = input.readStringRequireUtf8();
              if (!((mutable_bitField0_ & 0x00000008) != 0)) {
                supportedLanguageCodes_ = new com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000008;
              }
              supportedLanguageCodes_.add(s);
              break;
            }
          case 42:
            {
              java.lang.String s = input.readStringRequireUtf8();

              timeZone_ = s;
              break;
            }
          case 50:
            {
              java.lang.String s = input.readStringRequireUtf8();

              description_ = s;
              break;
            }
          case 58:
            {
              java.lang.String s = input.readStringRequireUtf8();

              avatarUri_ = s;
              break;
            }
          case 64:
            {
              enableLogging_ = input.readBool();
              break;
            }
          case 72:
            {
              int rawValue = input.readEnum();

              matchMode_ = rawValue;
              break;
            }
          case 85:
            {
              classificationThreshold_ = input.readFloat();
              break;
            }
          case 112:
            {
              int rawValue = input.readEnum();

              apiVersion_ = rawValue;
              break;
            }
          case 120:
            {
              int rawValue = input.readEnum();

              tier_ = rawValue;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000008) != 0)) {
        supportedLanguageCodes_ = supportedLanguageCodes_.getUnmodifiableView();
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.v2.AgentProto
        .internal_static_google_cloud_dialogflow_v2_Agent_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.v2.AgentProto
        .internal_static_google_cloud_dialogflow_v2_Agent_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.v2.Agent.class,
            com.google.cloud.dialogflow.v2.Agent.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Match mode determines how intents are detected from user queries.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.dialogflow.v2.Agent.MatchMode}
   */
  public enum MatchMode implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not specified.
     * </pre>
     *
     * <code>MATCH_MODE_UNSPECIFIED = 0;</code>
     */
    MATCH_MODE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Best for agents with a small number of examples in intents and/or wide
     * use of templates syntax and composite entities.
     * </pre>
     *
     * <code>MATCH_MODE_HYBRID = 1;</code>
     */
    MATCH_MODE_HYBRID(1),
    /**
     *
     *
     * <pre>
     * Can be used for agents with a large number of examples in intents,
     * especially the ones using &#64;sys.any or very large developer entities.
     * </pre>
     *
     * <code>MATCH_MODE_ML_ONLY = 2;</code>
     */
    MATCH_MODE_ML_ONLY(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not specified.
     * </pre>
     *
     * <code>MATCH_MODE_UNSPECIFIED = 0;</code>
     */
    public static final int MATCH_MODE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Best for agents with a small number of examples in intents and/or wide
     * use of templates syntax and composite entities.
     * </pre>
     *
     * <code>MATCH_MODE_HYBRID = 1;</code>
     */
    public static final int MATCH_MODE_HYBRID_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Can be used for agents with a large number of examples in intents,
     * especially the ones using &#64;sys.any or very large developer entities.
     * </pre>
     *
     * <code>MATCH_MODE_ML_ONLY = 2;</code>
     */
    public static final int MATCH_MODE_ML_ONLY_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /** @deprecated Use {@link #forNumber(int)} instead. */
    @java.lang.Deprecated
    public static MatchMode valueOf(int value) {
      return forNumber(value);
    }

    public static MatchMode forNumber(int value) {
      switch (value) {
        case 0:
          return MATCH_MODE_UNSPECIFIED;
        case 1:
          return MATCH_MODE_HYBRID;
        case 2:
          return MATCH_MODE_ML_ONLY;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<MatchMode> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<MatchMode> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<MatchMode>() {
          public MatchMode findValueByNumber(int number) {
            return MatchMode.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2.Agent.getDescriptor().getEnumTypes().get(0);
    }

    private static final MatchMode[] VALUES = values();

    public static MatchMode valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private MatchMode(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.dialogflow.v2.Agent.MatchMode)
  }

  /**
   *
   *
   * <pre>
   * API version for the agent.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.dialogflow.v2.Agent.ApiVersion}
   */
  public enum ApiVersion implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not specified.
     * </pre>
     *
     * <code>API_VERSION_UNSPECIFIED = 0;</code>
     */
    API_VERSION_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Legacy V1 API.
     * </pre>
     *
     * <code>API_VERSION_V1 = 1;</code>
     */
    API_VERSION_V1(1),
    /**
     *
     *
     * <pre>
     * V2 API.
     * </pre>
     *
     * <code>API_VERSION_V2 = 2;</code>
     */
    API_VERSION_V2(2),
    /**
     *
     *
     * <pre>
     * V2beta1 API.
     * </pre>
     *
     * <code>API_VERSION_V2_BETA_1 = 3;</code>
     */
    API_VERSION_V2_BETA_1(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not specified.
     * </pre>
     *
     * <code>API_VERSION_UNSPECIFIED = 0;</code>
     */
    public static final int API_VERSION_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Legacy V1 API.
     * </pre>
     *
     * <code>API_VERSION_V1 = 1;</code>
     */
    public static final int API_VERSION_V1_VALUE = 1;
    /**
     *
     *
     * <pre>
     * V2 API.
     * </pre>
     *
     * <code>API_VERSION_V2 = 2;</code>
     */
    public static final int API_VERSION_V2_VALUE = 2;
    /**
     *
     *
     * <pre>
     * V2beta1 API.
     * </pre>
     *
     * <code>API_VERSION_V2_BETA_1 = 3;</code>
     */
    public static final int API_VERSION_V2_BETA_1_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /** @deprecated Use {@link #forNumber(int)} instead. */
    @java.lang.Deprecated
    public static ApiVersion valueOf(int value) {
      return forNumber(value);
    }

    public static ApiVersion forNumber(int value) {
      switch (value) {
        case 0:
          return API_VERSION_UNSPECIFIED;
        case 1:
          return API_VERSION_V1;
        case 2:
          return API_VERSION_V2;
        case 3:
          return API_VERSION_V2_BETA_1;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ApiVersion> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ApiVersion> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<ApiVersion>() {
          public ApiVersion findValueByNumber(int number) {
            return ApiVersion.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2.Agent.getDescriptor().getEnumTypes().get(1);
    }

    private static final ApiVersion[] VALUES = values();

    public static ApiVersion valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ApiVersion(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.dialogflow.v2.Agent.ApiVersion)
  }

  /**
   *
   *
   * <pre>
   * Represents the agent tier.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.dialogflow.v2.Agent.Tier}
   */
  public enum Tier implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not specified. This value should never be used.
     * </pre>
     *
     * <code>TIER_UNSPECIFIED = 0;</code>
     */
    TIER_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Standard tier.
     * </pre>
     *
     * <code>TIER_STANDARD = 1;</code>
     */
    TIER_STANDARD(1),
    /**
     *
     *
     * <pre>
     * Enterprise tier (Essentials).
     * </pre>
     *
     * <code>TIER_ENTERPRISE = 2;</code>
     */
    TIER_ENTERPRISE(2),
    /**
     *
     *
     * <pre>
     * Enterprise tier (Plus).
     * </pre>
     *
     * <code>TIER_ENTERPRISE_PLUS = 3;</code>
     */
    TIER_ENTERPRISE_PLUS(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not specified. This value should never be used.
     * </pre>
     *
     * <code>TIER_UNSPECIFIED = 0;</code>
     */
    public static final int TIER_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Standard tier.
     * </pre>
     *
     * <code>TIER_STANDARD = 1;</code>
     */
    public static final int TIER_STANDARD_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Enterprise tier (Essentials).
     * </pre>
     *
     * <code>TIER_ENTERPRISE = 2;</code>
     */
    public static final int TIER_ENTERPRISE_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Enterprise tier (Plus).
     * </pre>
     *
     * <code>TIER_ENTERPRISE_PLUS = 3;</code>
     */
    public static final int TIER_ENTERPRISE_PLUS_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /** @deprecated Use {@link #forNumber(int)} instead. */
    @java.lang.Deprecated
    public static Tier valueOf(int value) {
      return forNumber(value);
    }

    public static Tier forNumber(int value) {
      switch (value) {
        case 0:
          return TIER_UNSPECIFIED;
        case 1:
          return TIER_STANDARD;
        case 2:
          return TIER_ENTERPRISE;
        case 3:
          return TIER_ENTERPRISE_PLUS;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Tier> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Tier> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Tier>() {
          public Tier findValueByNumber(int number) {
            return Tier.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2.Agent.getDescriptor().getEnumTypes().get(2);
    }

    private static final Tier[] VALUES = values();

    public static Tier valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Tier(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.dialogflow.v2.Agent.Tier)
  }

  private int bitField0_;
  public static final int PARENT_FIELD_NUMBER = 1;
  private volatile java.lang.Object parent_;
  /**
   *
   *
   * <pre>
   * Required. The project of this agent.
   * Format: `projects/&lt;Project ID&gt;`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   */
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The project of this agent.
   * Format: `projects/&lt;Project ID&gt;`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   */
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;
  private volatile java.lang.Object displayName_;
  /**
   *
   *
   * <pre>
   * Required. The name of this agent.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   */
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The name of this agent.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   */
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DEFAULT_LANGUAGE_CODE_FIELD_NUMBER = 3;
  private volatile java.lang.Object defaultLanguageCode_;
  /**
   *
   *
   * <pre>
   * Required. The default language of the agent as a language tag. See
   * [Language
   * Support](https://cloud.google.com/dialogflow/docs/reference/language)
   * for a list of the currently supported language codes. This field cannot be
   * set by the `Update` method.
   * </pre>
   *
   * <code>string default_language_code = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   */
  public java.lang.String getDefaultLanguageCode() {
    java.lang.Object ref = defaultLanguageCode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      defaultLanguageCode_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The default language of the agent as a language tag. See
   * [Language
   * Support](https://cloud.google.com/dialogflow/docs/reference/language)
   * for a list of the currently supported language codes. This field cannot be
   * set by the `Update` method.
   * </pre>
   *
   * <code>string default_language_code = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   */
  public com.google.protobuf.ByteString getDefaultLanguageCodeBytes() {
    java.lang.Object ref = defaultLanguageCode_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      defaultLanguageCode_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SUPPORTED_LANGUAGE_CODES_FIELD_NUMBER = 4;
  private com.google.protobuf.LazyStringList supportedLanguageCodes_;
  /**
   *
   *
   * <pre>
   * Optional. The list of all languages supported by this agent (except for the
   * `default_language_code`).
   * </pre>
   *
   * <code>repeated string supported_language_codes = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  public com.google.protobuf.ProtocolStringList getSupportedLanguageCodesList() {
    return supportedLanguageCodes_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The list of all languages supported by this agent (except for the
   * `default_language_code`).
   * </pre>
   *
   * <code>repeated string supported_language_codes = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  public int getSupportedLanguageCodesCount() {
    return supportedLanguageCodes_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. The list of all languages supported by this agent (except for the
   * `default_language_code`).
   * </pre>
   *
   * <code>repeated string supported_language_codes = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  public java.lang.String getSupportedLanguageCodes(int index) {
    return supportedLanguageCodes_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. The list of all languages supported by this agent (except for the
   * `default_language_code`).
   * </pre>
   *
   * <code>repeated string supported_language_codes = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  public com.google.protobuf.ByteString getSupportedLanguageCodesBytes(int index) {
    return supportedLanguageCodes_.getByteString(index);
  }

  public static final int TIME_ZONE_FIELD_NUMBER = 5;
  private volatile java.lang.Object timeZone_;
  /**
   *
   *
   * <pre>
   * Required. The time zone of this agent from the
   * [time zone database](https://www.iana.org/time-zones), e.g.,
   * America/New_York, Europe/Paris.
   * </pre>
   *
   * <code>string time_zone = 5 [(.google.api.field_behavior) = REQUIRED];</code>
   */
  public java.lang.String getTimeZone() {
    java.lang.Object ref = timeZone_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      timeZone_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The time zone of this agent from the
   * [time zone database](https://www.iana.org/time-zones), e.g.,
   * America/New_York, Europe/Paris.
   * </pre>
   *
   * <code>string time_zone = 5 [(.google.api.field_behavior) = REQUIRED];</code>
   */
  public com.google.protobuf.ByteString getTimeZoneBytes() {
    java.lang.Object ref = timeZone_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      timeZone_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 6;
  private volatile java.lang.Object description_;
  /**
   *
   *
   * <pre>
   * Optional. The description of this agent.
   * The maximum length is 500 characters. If exceeded, the request is rejected.
   * </pre>
   *
   * <code>string description = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The description of this agent.
   * The maximum length is 500 characters. If exceeded, the request is rejected.
   * </pre>
   *
   * <code>string description = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int AVATAR_URI_FIELD_NUMBER = 7;
  private volatile java.lang.Object avatarUri_;
  /**
   *
   *
   * <pre>
   * Optional. The URI of the agent's avatar.
   * Avatars are used throughout the Dialogflow console and in the self-hosted
   * [Web
   * Demo](https://cloud.google.com/dialogflow/docs/integrations/web-demo)
   * integration.
   * </pre>
   *
   * <code>string avatar_uri = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  public java.lang.String getAvatarUri() {
    java.lang.Object ref = avatarUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      avatarUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The URI of the agent's avatar.
   * Avatars are used throughout the Dialogflow console and in the self-hosted
   * [Web
   * Demo](https://cloud.google.com/dialogflow/docs/integrations/web-demo)
   * integration.
   * </pre>
   *
   * <code>string avatar_uri = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  public com.google.protobuf.ByteString getAvatarUriBytes() {
    java.lang.Object ref = avatarUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      avatarUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ENABLE_LOGGING_FIELD_NUMBER = 8;
  private boolean enableLogging_;
  /**
   *
   *
   * <pre>
   * Optional. Determines whether this agent should log conversation queries.
   * </pre>
   *
   * <code>bool enable_logging = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  public boolean getEnableLogging() {
    return enableLogging_;
  }

  public static final int MATCH_MODE_FIELD_NUMBER = 9;
  private int matchMode_;
  /**
   *
   *
   * <pre>
   * Optional. Determines how intents are detected from user queries.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2.Agent.MatchMode match_mode = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  public int getMatchModeValue() {
    return matchMode_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Determines how intents are detected from user queries.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2.Agent.MatchMode match_mode = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  public com.google.cloud.dialogflow.v2.Agent.MatchMode getMatchMode() {
    @SuppressWarnings("deprecation")
    com.google.cloud.dialogflow.v2.Agent.MatchMode result =
        com.google.cloud.dialogflow.v2.Agent.MatchMode.valueOf(matchMode_);
    return result == null ? com.google.cloud.dialogflow.v2.Agent.MatchMode.UNRECOGNIZED : result;
  }

  public static final int CLASSIFICATION_THRESHOLD_FIELD_NUMBER = 10;
  private float classificationThreshold_;
  /**
   *
   *
   * <pre>
   * Optional. To filter out false positive results and still get variety in
   * matched natural language inputs for your agent, you can tune the machine
   * learning classification threshold. If the returned score value is less than
   * the threshold value, then a fallback intent will be triggered or, if there
   * are no fallback intents defined, no intent will be triggered. The score
   * values range from 0.0 (completely uncertain) to 1.0 (completely certain).
   * If set to 0.0, the default of 0.3 is used.
   * </pre>
   *
   * <code>float classification_threshold = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  public float getClassificationThreshold() {
    return classificationThreshold_;
  }

  public static final int API_VERSION_FIELD_NUMBER = 14;
  private int apiVersion_;
  /**
   *
   *
   * <pre>
   * Optional. API version displayed in Dialogflow console. If not specified,
   * V2 API is assumed. Clients are free to query different service endpoints
   * for different API versions. However, bots connectors and webhook calls will
   * follow the specified API version.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2.Agent.ApiVersion api_version = 14 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  public int getApiVersionValue() {
    return apiVersion_;
  }
  /**
   *
   *
   * <pre>
   * Optional. API version displayed in Dialogflow console. If not specified,
   * V2 API is assumed. Clients are free to query different service endpoints
   * for different API versions. However, bots connectors and webhook calls will
   * follow the specified API version.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2.Agent.ApiVersion api_version = 14 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  public com.google.cloud.dialogflow.v2.Agent.ApiVersion getApiVersion() {
    @SuppressWarnings("deprecation")
    com.google.cloud.dialogflow.v2.Agent.ApiVersion result =
        com.google.cloud.dialogflow.v2.Agent.ApiVersion.valueOf(apiVersion_);
    return result == null ? com.google.cloud.dialogflow.v2.Agent.ApiVersion.UNRECOGNIZED : result;
  }

  public static final int TIER_FIELD_NUMBER = 15;
  private int tier_;
  /**
   *
   *
   * <pre>
   * Optional. The agent tier. If not specified, TIER_STANDARD is assumed.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2.Agent.Tier tier = 15 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  public int getTierValue() {
    return tier_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The agent tier. If not specified, TIER_STANDARD is assumed.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2.Agent.Tier tier = 15 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  public com.google.cloud.dialogflow.v2.Agent.Tier getTier() {
    @SuppressWarnings("deprecation")
    com.google.cloud.dialogflow.v2.Agent.Tier result =
        com.google.cloud.dialogflow.v2.Agent.Tier.valueOf(tier_);
    return result == null ? com.google.cloud.dialogflow.v2.Agent.Tier.UNRECOGNIZED : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!getParentBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (!getDisplayNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (!getDefaultLanguageCodeBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, defaultLanguageCode_);
    }
    for (int i = 0; i < supportedLanguageCodes_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 4, supportedLanguageCodes_.getRaw(i));
    }
    if (!getTimeZoneBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, timeZone_);
    }
    if (!getDescriptionBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, description_);
    }
    if (!getAvatarUriBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, avatarUri_);
    }
    if (enableLogging_ != false) {
      output.writeBool(8, enableLogging_);
    }
    if (matchMode_
        != com.google.cloud.dialogflow.v2.Agent.MatchMode.MATCH_MODE_UNSPECIFIED.getNumber()) {
      output.writeEnum(9, matchMode_);
    }
    if (classificationThreshold_ != 0F) {
      output.writeFloat(10, classificationThreshold_);
    }
    if (apiVersion_
        != com.google.cloud.dialogflow.v2.Agent.ApiVersion.API_VERSION_UNSPECIFIED.getNumber()) {
      output.writeEnum(14, apiVersion_);
    }
    if (tier_ != com.google.cloud.dialogflow.v2.Agent.Tier.TIER_UNSPECIFIED.getNumber()) {
      output.writeEnum(15, tier_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getParentBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (!getDisplayNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (!getDefaultLanguageCodeBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, defaultLanguageCode_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < supportedLanguageCodes_.size(); i++) {
        dataSize += computeStringSizeNoTag(supportedLanguageCodes_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getSupportedLanguageCodesList().size();
    }
    if (!getTimeZoneBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, timeZone_);
    }
    if (!getDescriptionBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, description_);
    }
    if (!getAvatarUriBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, avatarUri_);
    }
    if (enableLogging_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(8, enableLogging_);
    }
    if (matchMode_
        != com.google.cloud.dialogflow.v2.Agent.MatchMode.MATCH_MODE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(9, matchMode_);
    }
    if (classificationThreshold_ != 0F) {
      size += com.google.protobuf.CodedOutputStream.computeFloatSize(10, classificationThreshold_);
    }
    if (apiVersion_
        != com.google.cloud.dialogflow.v2.Agent.ApiVersion.API_VERSION_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(14, apiVersion_);
    }
    if (tier_ != com.google.cloud.dialogflow.v2.Agent.Tier.TIER_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(15, tier_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.v2.Agent)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.v2.Agent other = (com.google.cloud.dialogflow.v2.Agent) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getDefaultLanguageCode().equals(other.getDefaultLanguageCode())) return false;
    if (!getSupportedLanguageCodesList().equals(other.getSupportedLanguageCodesList()))
      return false;
    if (!getTimeZone().equals(other.getTimeZone())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (!getAvatarUri().equals(other.getAvatarUri())) return false;
    if (getEnableLogging() != other.getEnableLogging()) return false;
    if (matchMode_ != other.matchMode_) return false;
    if (java.lang.Float.floatToIntBits(getClassificationThreshold())
        != java.lang.Float.floatToIntBits(other.getClassificationThreshold())) return false;
    if (apiVersion_ != other.apiVersion_) return false;
    if (tier_ != other.tier_) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + DEFAULT_LANGUAGE_CODE_FIELD_NUMBER;
    hash = (53 * hash) + getDefaultLanguageCode().hashCode();
    if (getSupportedLanguageCodesCount() > 0) {
      hash = (37 * hash) + SUPPORTED_LANGUAGE_CODES_FIELD_NUMBER;
      hash = (53 * hash) + getSupportedLanguageCodesList().hashCode();
    }
    hash = (37 * hash) + TIME_ZONE_FIELD_NUMBER;
    hash = (53 * hash) + getTimeZone().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + AVATAR_URI_FIELD_NUMBER;
    hash = (53 * hash) + getAvatarUri().hashCode();
    hash = (37 * hash) + ENABLE_LOGGING_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableLogging());
    hash = (37 * hash) + MATCH_MODE_FIELD_NUMBER;
    hash = (53 * hash) + matchMode_;
    hash = (37 * hash) + CLASSIFICATION_THRESHOLD_FIELD_NUMBER;
    hash = (53 * hash) + java.lang.Float.floatToIntBits(getClassificationThreshold());
    hash = (37 * hash) + API_VERSION_FIELD_NUMBER;
    hash = (53 * hash) + apiVersion_;
    hash = (37 * hash) + TIER_FIELD_NUMBER;
    hash = (53 * hash) + tier_;
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.v2.Agent parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2.Agent parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.Agent parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2.Agent parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.Agent parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2.Agent parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.Agent parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2.Agent parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.Agent parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2.Agent parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.Agent parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2.Agent parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dialogflow.v2.Agent prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents a conversational agent.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2.Agent}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2.Agent)
      com.google.cloud.dialogflow.v2.AgentOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2.AgentProto
          .internal_static_google_cloud_dialogflow_v2_Agent_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2.AgentProto
          .internal_static_google_cloud_dialogflow_v2_Agent_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2.Agent.class,
              com.google.cloud.dialogflow.v2.Agent.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.v2.Agent.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      parent_ = "";

      displayName_ = "";

      defaultLanguageCode_ = "";

      supportedLanguageCodes_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000008);
      timeZone_ = "";

      description_ = "";

      avatarUri_ = "";

      enableLogging_ = false;

      matchMode_ = 0;

      classificationThreshold_ = 0F;

      apiVersion_ = 0;

      tier_ = 0;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.v2.AgentProto
          .internal_static_google_cloud_dialogflow_v2_Agent_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.Agent getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.v2.Agent.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.Agent build() {
      com.google.cloud.dialogflow.v2.Agent result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.Agent buildPartial() {
      com.google.cloud.dialogflow.v2.Agent result = new com.google.cloud.dialogflow.v2.Agent(this);
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      result.parent_ = parent_;
      result.displayName_ = displayName_;
      result.defaultLanguageCode_ = defaultLanguageCode_;
      if (((bitField0_ & 0x00000008) != 0)) {
        supportedLanguageCodes_ = supportedLanguageCodes_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000008);
      }
      result.supportedLanguageCodes_ = supportedLanguageCodes_;
      result.timeZone_ = timeZone_;
      result.description_ = description_;
      result.avatarUri_ = avatarUri_;
      result.enableLogging_ = enableLogging_;
      result.matchMode_ = matchMode_;
      result.classificationThreshold_ = classificationThreshold_;
      result.apiVersion_ = apiVersion_;
      result.tier_ = tier_;
      result.bitField0_ = to_bitField0_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.v2.Agent) {
        return mergeFrom((com.google.cloud.dialogflow.v2.Agent) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.v2.Agent other) {
      if (other == com.google.cloud.dialogflow.v2.Agent.getDefaultInstance()) return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        onChanged();
      }
      if (!other.getDefaultLanguageCode().isEmpty()) {
        defaultLanguageCode_ = other.defaultLanguageCode_;
        onChanged();
      }
      if (!other.supportedLanguageCodes_.isEmpty()) {
        if (supportedLanguageCodes_.isEmpty()) {
          supportedLanguageCodes_ = other.supportedLanguageCodes_;
          bitField0_ = (bitField0_ & ~0x00000008);
        } else {
          ensureSupportedLanguageCodesIsMutable();
          supportedLanguageCodes_.addAll(other.supportedLanguageCodes_);
        }
        onChanged();
      }
      if (!other.getTimeZone().isEmpty()) {
        timeZone_ = other.timeZone_;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        onChanged();
      }
      if (!other.getAvatarUri().isEmpty()) {
        avatarUri_ = other.avatarUri_;
        onChanged();
      }
      if (other.getEnableLogging() != false) {
        setEnableLogging(other.getEnableLogging());
      }
      if (other.matchMode_ != 0) {
        setMatchModeValue(other.getMatchModeValue());
      }
      if (other.getClassificationThreshold() != 0F) {
        setClassificationThreshold(other.getClassificationThreshold());
      }
      if (other.apiVersion_ != 0) {
        setApiVersionValue(other.getApiVersionValue());
      }
      if (other.tier_ != 0) {
        setTierValue(other.getTierValue());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.dialogflow.v2.Agent parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.cloud.dialogflow.v2.Agent) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. The project of this agent.
     * Format: `projects/&lt;Project ID&gt;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The project of this agent.
     * Format: `projects/&lt;Project ID&gt;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The project of this agent.
     * Format: `projects/&lt;Project ID&gt;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      parent_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The project of this agent.
     * Format: `projects/&lt;Project ID&gt;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     */
    public Builder clearParent() {

      parent_ = getDefaultInstance().getParent();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The project of this agent.
     * Format: `projects/&lt;Project ID&gt;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      parent_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Required. The name of this agent.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of this agent.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of this agent.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      displayName_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of this agent.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public Builder clearDisplayName() {

      displayName_ = getDefaultInstance().getDisplayName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of this agent.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      displayName_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object defaultLanguageCode_ = "";
    /**
     *
     *
     * <pre>
     * Required. The default language of the agent as a language tag. See
     * [Language
     * Support](https://cloud.google.com/dialogflow/docs/reference/language)
     * for a list of the currently supported language codes. This field cannot be
     * set by the `Update` method.
     * </pre>
     *
     * <code>string default_language_code = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public java.lang.String getDefaultLanguageCode() {
      java.lang.Object ref = defaultLanguageCode_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        defaultLanguageCode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The default language of the agent as a language tag. See
     * [Language
     * Support](https://cloud.google.com/dialogflow/docs/reference/language)
     * for a list of the currently supported language codes. This field cannot be
     * set by the `Update` method.
     * </pre>
     *
     * <code>string default_language_code = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public com.google.protobuf.ByteString getDefaultLanguageCodeBytes() {
      java.lang.Object ref = defaultLanguageCode_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        defaultLanguageCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The default language of the agent as a language tag. See
     * [Language
     * Support](https://cloud.google.com/dialogflow/docs/reference/language)
     * for a list of the currently supported language codes. This field cannot be
     * set by the `Update` method.
     * </pre>
     *
     * <code>string default_language_code = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public Builder setDefaultLanguageCode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      defaultLanguageCode_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The default language of the agent as a language tag. See
     * [Language
     * Support](https://cloud.google.com/dialogflow/docs/reference/language)
     * for a list of the currently supported language codes. This field cannot be
     * set by the `Update` method.
     * </pre>
     *
     * <code>string default_language_code = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public Builder clearDefaultLanguageCode() {

      defaultLanguageCode_ = getDefaultInstance().getDefaultLanguageCode();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The default language of the agent as a language tag. See
     * [Language
     * Support](https://cloud.google.com/dialogflow/docs/reference/language)
     * for a list of the currently supported language codes. This field cannot be
     * set by the `Update` method.
     * </pre>
     *
     * <code>string default_language_code = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public Builder setDefaultLanguageCodeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      defaultLanguageCode_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList supportedLanguageCodes_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureSupportedLanguageCodesIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        supportedLanguageCodes_ =
            new com.google.protobuf.LazyStringArrayList(supportedLanguageCodes_);
        bitField0_ |= 0x00000008;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The list of all languages supported by this agent (except for the
     * `default_language_code`).
     * </pre>
     *
     * <code>repeated string supported_language_codes = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.ProtocolStringList getSupportedLanguageCodesList() {
      return supportedLanguageCodes_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * Optional. The list of all languages supported by this agent (except for the
     * `default_language_code`).
     * </pre>
     *
     * <code>repeated string supported_language_codes = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getSupportedLanguageCodesCount() {
      return supportedLanguageCodes_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. The list of all languages supported by this agent (except for the
     * `default_language_code`).
     * </pre>
     *
     * <code>repeated string supported_language_codes = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.lang.String getSupportedLanguageCodes(int index) {
      return supportedLanguageCodes_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. The list of all languages supported by this agent (except for the
     * `default_language_code`).
     * </pre>
     *
     * <code>repeated string supported_language_codes = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.ByteString getSupportedLanguageCodesBytes(int index) {
      return supportedLanguageCodes_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. The list of all languages supported by this agent (except for the
     * `default_language_code`).
     * </pre>
     *
     * <code>repeated string supported_language_codes = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSupportedLanguageCodes(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSupportedLanguageCodesIsMutable();
      supportedLanguageCodes_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The list of all languages supported by this agent (except for the
     * `default_language_code`).
     * </pre>
     *
     * <code>repeated string supported_language_codes = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addSupportedLanguageCodes(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSupportedLanguageCodesIsMutable();
      supportedLanguageCodes_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The list of all languages supported by this agent (except for the
     * `default_language_code`).
     * </pre>
     *
     * <code>repeated string supported_language_codes = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllSupportedLanguageCodes(java.lang.Iterable<java.lang.String> values) {
      ensureSupportedLanguageCodesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, supportedLanguageCodes_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The list of all languages supported by this agent (except for the
     * `default_language_code`).
     * </pre>
     *
     * <code>repeated string supported_language_codes = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearSupportedLanguageCodes() {
      supportedLanguageCodes_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The list of all languages supported by this agent (except for the
     * `default_language_code`).
     * </pre>
     *
     * <code>repeated string supported_language_codes = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addSupportedLanguageCodesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureSupportedLanguageCodesIsMutable();
      supportedLanguageCodes_.add(value);
      onChanged();
      return this;
    }

    private java.lang.Object timeZone_ = "";
    /**
     *
     *
     * <pre>
     * Required. The time zone of this agent from the
     * [time zone database](https://www.iana.org/time-zones), e.g.,
     * America/New_York, Europe/Paris.
     * </pre>
     *
     * <code>string time_zone = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public java.lang.String getTimeZone() {
      java.lang.Object ref = timeZone_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        timeZone_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The time zone of this agent from the
     * [time zone database](https://www.iana.org/time-zones), e.g.,
     * America/New_York, Europe/Paris.
     * </pre>
     *
     * <code>string time_zone = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public com.google.protobuf.ByteString getTimeZoneBytes() {
      java.lang.Object ref = timeZone_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        timeZone_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The time zone of this agent from the
     * [time zone database](https://www.iana.org/time-zones), e.g.,
     * America/New_York, Europe/Paris.
     * </pre>
     *
     * <code>string time_zone = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public Builder setTimeZone(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      timeZone_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The time zone of this agent from the
     * [time zone database](https://www.iana.org/time-zones), e.g.,
     * America/New_York, Europe/Paris.
     * </pre>
     *
     * <code>string time_zone = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public Builder clearTimeZone() {

      timeZone_ = getDefaultInstance().getTimeZone();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The time zone of this agent from the
     * [time zone database](https://www.iana.org/time-zones), e.g.,
     * America/New_York, Europe/Paris.
     * </pre>
     *
     * <code>string time_zone = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public Builder setTimeZoneBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      timeZone_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The description of this agent.
     * The maximum length is 500 characters. If exceeded, the request is rejected.
     * </pre>
     *
     * <code>string description = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The description of this agent.
     * The maximum length is 500 characters. If exceeded, the request is rejected.
     * </pre>
     *
     * <code>string description = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The description of this agent.
     * The maximum length is 500 characters. If exceeded, the request is rejected.
     * </pre>
     *
     * <code>string description = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      description_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The description of this agent.
     * The maximum length is 500 characters. If exceeded, the request is rejected.
     * </pre>
     *
     * <code>string description = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder clearDescription() {

      description_ = getDefaultInstance().getDescription();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The description of this agent.
     * The maximum length is 500 characters. If exceeded, the request is rejected.
     * </pre>
     *
     * <code>string description = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      description_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object avatarUri_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The URI of the agent's avatar.
     * Avatars are used throughout the Dialogflow console and in the self-hosted
     * [Web
     * Demo](https://cloud.google.com/dialogflow/docs/integrations/web-demo)
     * integration.
     * </pre>
     *
     * <code>string avatar_uri = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public java.lang.String getAvatarUri() {
      java.lang.Object ref = avatarUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        avatarUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The URI of the agent's avatar.
     * Avatars are used throughout the Dialogflow console and in the self-hosted
     * [Web
     * Demo](https://cloud.google.com/dialogflow/docs/integrations/web-demo)
     * integration.
     * </pre>
     *
     * <code>string avatar_uri = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public com.google.protobuf.ByteString getAvatarUriBytes() {
      java.lang.Object ref = avatarUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        avatarUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The URI of the agent's avatar.
     * Avatars are used throughout the Dialogflow console and in the self-hosted
     * [Web
     * Demo](https://cloud.google.com/dialogflow/docs/integrations/web-demo)
     * integration.
     * </pre>
     *
     * <code>string avatar_uri = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder setAvatarUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      avatarUri_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The URI of the agent's avatar.
     * Avatars are used throughout the Dialogflow console and in the self-hosted
     * [Web
     * Demo](https://cloud.google.com/dialogflow/docs/integrations/web-demo)
     * integration.
     * </pre>
     *
     * <code>string avatar_uri = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder clearAvatarUri() {

      avatarUri_ = getDefaultInstance().getAvatarUri();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The URI of the agent's avatar.
     * Avatars are used throughout the Dialogflow console and in the self-hosted
     * [Web
     * Demo](https://cloud.google.com/dialogflow/docs/integrations/web-demo)
     * integration.
     * </pre>
     *
     * <code>string avatar_uri = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder setAvatarUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      avatarUri_ = value;
      onChanged();
      return this;
    }

    private boolean enableLogging_;
    /**
     *
     *
     * <pre>
     * Optional. Determines whether this agent should log conversation queries.
     * </pre>
     *
     * <code>bool enable_logging = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public boolean getEnableLogging() {
      return enableLogging_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Determines whether this agent should log conversation queries.
     * </pre>
     *
     * <code>bool enable_logging = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder setEnableLogging(boolean value) {

      enableLogging_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Determines whether this agent should log conversation queries.
     * </pre>
     *
     * <code>bool enable_logging = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder clearEnableLogging() {

      enableLogging_ = false;
      onChanged();
      return this;
    }

    private int matchMode_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. Determines how intents are detected from user queries.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.Agent.MatchMode match_mode = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getMatchModeValue() {
      return matchMode_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Determines how intents are detected from user queries.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.Agent.MatchMode match_mode = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setMatchModeValue(int value) {
      matchMode_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Determines how intents are detected from user queries.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.Agent.MatchMode match_mode = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.v2.Agent.MatchMode getMatchMode() {
      @SuppressWarnings("deprecation")
      com.google.cloud.dialogflow.v2.Agent.MatchMode result =
          com.google.cloud.dialogflow.v2.Agent.MatchMode.valueOf(matchMode_);
      return result == null ? com.google.cloud.dialogflow.v2.Agent.MatchMode.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Optional. Determines how intents are detected from user queries.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.Agent.MatchMode match_mode = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setMatchMode(com.google.cloud.dialogflow.v2.Agent.MatchMode value) {
      if (value == null) {
        throw new NullPointerException();
      }

      matchMode_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Determines how intents are detected from user queries.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.Agent.MatchMode match_mode = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearMatchMode() {

      matchMode_ = 0;
      onChanged();
      return this;
    }

    private float classificationThreshold_;
    /**
     *
     *
     * <pre>
     * Optional. To filter out false positive results and still get variety in
     * matched natural language inputs for your agent, you can tune the machine
     * learning classification threshold. If the returned score value is less than
     * the threshold value, then a fallback intent will be triggered or, if there
     * are no fallback intents defined, no intent will be triggered. The score
     * values range from 0.0 (completely uncertain) to 1.0 (completely certain).
     * If set to 0.0, the default of 0.3 is used.
     * </pre>
     *
     * <code>float classification_threshold = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public float getClassificationThreshold() {
      return classificationThreshold_;
    }
    /**
     *
     *
     * <pre>
     * Optional. To filter out false positive results and still get variety in
     * matched natural language inputs for your agent, you can tune the machine
     * learning classification threshold. If the returned score value is less than
     * the threshold value, then a fallback intent will be triggered or, if there
     * are no fallback intents defined, no intent will be triggered. The score
     * values range from 0.0 (completely uncertain) to 1.0 (completely certain).
     * If set to 0.0, the default of 0.3 is used.
     * </pre>
     *
     * <code>float classification_threshold = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder setClassificationThreshold(float value) {

      classificationThreshold_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. To filter out false positive results and still get variety in
     * matched natural language inputs for your agent, you can tune the machine
     * learning classification threshold. If the returned score value is less than
     * the threshold value, then a fallback intent will be triggered or, if there
     * are no fallback intents defined, no intent will be triggered. The score
     * values range from 0.0 (completely uncertain) to 1.0 (completely certain).
     * If set to 0.0, the default of 0.3 is used.
     * </pre>
     *
     * <code>float classification_threshold = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder clearClassificationThreshold() {

      classificationThreshold_ = 0F;
      onChanged();
      return this;
    }

    private int apiVersion_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. API version displayed in Dialogflow console. If not specified,
     * V2 API is assumed. Clients are free to query different service endpoints
     * for different API versions. However, bots connectors and webhook calls will
     * follow the specified API version.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.Agent.ApiVersion api_version = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getApiVersionValue() {
      return apiVersion_;
    }
    /**
     *
     *
     * <pre>
     * Optional. API version displayed in Dialogflow console. If not specified,
     * V2 API is assumed. Clients are free to query different service endpoints
     * for different API versions. However, bots connectors and webhook calls will
     * follow the specified API version.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.Agent.ApiVersion api_version = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setApiVersionValue(int value) {
      apiVersion_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. API version displayed in Dialogflow console. If not specified,
     * V2 API is assumed. Clients are free to query different service endpoints
     * for different API versions. However, bots connectors and webhook calls will
     * follow the specified API version.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.Agent.ApiVersion api_version = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.v2.Agent.ApiVersion getApiVersion() {
      @SuppressWarnings("deprecation")
      com.google.cloud.dialogflow.v2.Agent.ApiVersion result =
          com.google.cloud.dialogflow.v2.Agent.ApiVersion.valueOf(apiVersion_);
      return result == null ? com.google.cloud.dialogflow.v2.Agent.ApiVersion.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Optional. API version displayed in Dialogflow console. If not specified,
     * V2 API is assumed. Clients are free to query different service endpoints
     * for different API versions. However, bots connectors and webhook calls will
     * follow the specified API version.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.Agent.ApiVersion api_version = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setApiVersion(com.google.cloud.dialogflow.v2.Agent.ApiVersion value) {
      if (value == null) {
        throw new NullPointerException();
      }

      apiVersion_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. API version displayed in Dialogflow console. If not specified,
     * V2 API is assumed. Clients are free to query different service endpoints
     * for different API versions. However, bots connectors and webhook calls will
     * follow the specified API version.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.Agent.ApiVersion api_version = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearApiVersion() {

      apiVersion_ = 0;
      onChanged();
      return this;
    }

    private int tier_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. The agent tier. If not specified, TIER_STANDARD is assumed.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.Agent.Tier tier = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getTierValue() {
      return tier_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The agent tier. If not specified, TIER_STANDARD is assumed.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.Agent.Tier tier = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setTierValue(int value) {
      tier_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The agent tier. If not specified, TIER_STANDARD is assumed.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.Agent.Tier tier = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.v2.Agent.Tier getTier() {
      @SuppressWarnings("deprecation")
      com.google.cloud.dialogflow.v2.Agent.Tier result =
          com.google.cloud.dialogflow.v2.Agent.Tier.valueOf(tier_);
      return result == null ? com.google.cloud.dialogflow.v2.Agent.Tier.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Optional. The agent tier. If not specified, TIER_STANDARD is assumed.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.Agent.Tier tier = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setTier(com.google.cloud.dialogflow.v2.Agent.Tier value) {
      if (value == null) {
        throw new NullPointerException();
      }

      tier_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The agent tier. If not specified, TIER_STANDARD is assumed.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.Agent.Tier tier = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearTier() {

      tier_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2.Agent)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2.Agent)
  private static final com.google.cloud.dialogflow.v2.Agent DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2.Agent();
  }

  public static com.google.cloud.dialogflow.v2.Agent getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Agent> PARSER =
      new com.google.protobuf.AbstractParser<Agent>() {
        @java.lang.Override
        public Agent parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new Agent(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<Agent> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Agent> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.v2.Agent getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
