/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/v2/validation_result.proto

package com.google.cloud.dialogflow.v2;

/**
 *
 *
 * <pre>
 * Represents a single validation error.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.v2.ValidationError}
 */
public final class ValidationError extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2.ValidationError)
    ValidationErrorOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ValidationError.newBuilder() to construct.
  private ValidationError(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ValidationError() {
    severity_ = 0;
    entries_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    errorMessage_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ValidationError();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private ValidationError(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 8:
            {
              int rawValue = input.readEnum();

              severity_ = rawValue;
              break;
            }
          case 26:
            {
              java.lang.String s = input.readStringRequireUtf8();
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                entries_ = new com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000001;
              }
              entries_.add(s);
              break;
            }
          case 34:
            {
              java.lang.String s = input.readStringRequireUtf8();

              errorMessage_ = s;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        entries_ = entries_.getUnmodifiableView();
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.v2.ValidationResultProto
        .internal_static_google_cloud_dialogflow_v2_ValidationError_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.v2.ValidationResultProto
        .internal_static_google_cloud_dialogflow_v2_ValidationError_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.v2.ValidationError.class,
            com.google.cloud.dialogflow.v2.ValidationError.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Represents a level of severity.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.dialogflow.v2.ValidationError.Severity}
   */
  public enum Severity implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not specified. This value should never be used.
     * </pre>
     *
     * <code>SEVERITY_UNSPECIFIED = 0;</code>
     */
    SEVERITY_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The agent doesn't follow Dialogflow best practicies.
     * </pre>
     *
     * <code>INFO = 1;</code>
     */
    INFO(1),
    /**
     *
     *
     * <pre>
     * The agent may not behave as expected.
     * </pre>
     *
     * <code>WARNING = 2;</code>
     */
    WARNING(2),
    /**
     *
     *
     * <pre>
     * The agent may experience partial failures.
     * </pre>
     *
     * <code>ERROR = 3;</code>
     */
    ERROR(3),
    /**
     *
     *
     * <pre>
     * The agent may completely fail.
     * </pre>
     *
     * <code>CRITICAL = 4;</code>
     */
    CRITICAL(4),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not specified. This value should never be used.
     * </pre>
     *
     * <code>SEVERITY_UNSPECIFIED = 0;</code>
     */
    public static final int SEVERITY_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The agent doesn't follow Dialogflow best practicies.
     * </pre>
     *
     * <code>INFO = 1;</code>
     */
    public static final int INFO_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The agent may not behave as expected.
     * </pre>
     *
     * <code>WARNING = 2;</code>
     */
    public static final int WARNING_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The agent may experience partial failures.
     * </pre>
     *
     * <code>ERROR = 3;</code>
     */
    public static final int ERROR_VALUE = 3;
    /**
     *
     *
     * <pre>
     * The agent may completely fail.
     * </pre>
     *
     * <code>CRITICAL = 4;</code>
     */
    public static final int CRITICAL_VALUE = 4;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Severity valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Severity forNumber(int value) {
      switch (value) {
        case 0:
          return SEVERITY_UNSPECIFIED;
        case 1:
          return INFO;
        case 2:
          return WARNING;
        case 3:
          return ERROR;
        case 4:
          return CRITICAL;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Severity> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Severity> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Severity>() {
          public Severity findValueByNumber(int number) {
            return Severity.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2.ValidationError.getDescriptor().getEnumTypes().get(0);
    }

    private static final Severity[] VALUES = values();

    public static Severity valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Severity(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.dialogflow.v2.ValidationError.Severity)
  }

  public static final int SEVERITY_FIELD_NUMBER = 1;
  private int severity_;
  /**
   *
   *
   * <pre>
   * The severity of the error.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2.ValidationError.Severity severity = 1;</code>
   *
   * @return The enum numeric value on the wire for severity.
   */
  public int getSeverityValue() {
    return severity_;
  }
  /**
   *
   *
   * <pre>
   * The severity of the error.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2.ValidationError.Severity severity = 1;</code>
   *
   * @return The severity.
   */
  public com.google.cloud.dialogflow.v2.ValidationError.Severity getSeverity() {
    @SuppressWarnings("deprecation")
    com.google.cloud.dialogflow.v2.ValidationError.Severity result =
        com.google.cloud.dialogflow.v2.ValidationError.Severity.valueOf(severity_);
    return result == null
        ? com.google.cloud.dialogflow.v2.ValidationError.Severity.UNRECOGNIZED
        : result;
  }

  public static final int ENTRIES_FIELD_NUMBER = 3;
  private com.google.protobuf.LazyStringList entries_;
  /**
   *
   *
   * <pre>
   * The names of the entries that the error is associated with.
   * Format:
   * - "projects/&lt;Project ID&gt;/agent", if the error is associated with the entire
   * agent.
   * - "projects/&lt;Project ID&gt;/agent/intents/&lt;Intent ID&gt;", if the error is
   * associated with certain intents.
   * - "projects/&lt;Project
   * ID&gt;/agent/intents/&lt;Intent Id&gt;/trainingPhrases/&lt;Training Phrase ID&gt;", if the
   * error is associated with certain intent training phrases.
   * - "projects/&lt;Project ID&gt;/agent/intents/&lt;Intent Id&gt;/parameters/&lt;Parameter
   * ID&gt;", if the error is associated with certain intent parameters.
   * - "projects/&lt;Project ID&gt;/agent/entities/&lt;Entity ID&gt;", if the error is
   * associated with certain entities.
   * </pre>
   *
   * <code>repeated string entries = 3;</code>
   *
   * @return A list containing the entries.
   */
  public com.google.protobuf.ProtocolStringList getEntriesList() {
    return entries_;
  }
  /**
   *
   *
   * <pre>
   * The names of the entries that the error is associated with.
   * Format:
   * - "projects/&lt;Project ID&gt;/agent", if the error is associated with the entire
   * agent.
   * - "projects/&lt;Project ID&gt;/agent/intents/&lt;Intent ID&gt;", if the error is
   * associated with certain intents.
   * - "projects/&lt;Project
   * ID&gt;/agent/intents/&lt;Intent Id&gt;/trainingPhrases/&lt;Training Phrase ID&gt;", if the
   * error is associated with certain intent training phrases.
   * - "projects/&lt;Project ID&gt;/agent/intents/&lt;Intent Id&gt;/parameters/&lt;Parameter
   * ID&gt;", if the error is associated with certain intent parameters.
   * - "projects/&lt;Project ID&gt;/agent/entities/&lt;Entity ID&gt;", if the error is
   * associated with certain entities.
   * </pre>
   *
   * <code>repeated string entries = 3;</code>
   *
   * @return The count of entries.
   */
  public int getEntriesCount() {
    return entries_.size();
  }
  /**
   *
   *
   * <pre>
   * The names of the entries that the error is associated with.
   * Format:
   * - "projects/&lt;Project ID&gt;/agent", if the error is associated with the entire
   * agent.
   * - "projects/&lt;Project ID&gt;/agent/intents/&lt;Intent ID&gt;", if the error is
   * associated with certain intents.
   * - "projects/&lt;Project
   * ID&gt;/agent/intents/&lt;Intent Id&gt;/trainingPhrases/&lt;Training Phrase ID&gt;", if the
   * error is associated with certain intent training phrases.
   * - "projects/&lt;Project ID&gt;/agent/intents/&lt;Intent Id&gt;/parameters/&lt;Parameter
   * ID&gt;", if the error is associated with certain intent parameters.
   * - "projects/&lt;Project ID&gt;/agent/entities/&lt;Entity ID&gt;", if the error is
   * associated with certain entities.
   * </pre>
   *
   * <code>repeated string entries = 3;</code>
   *
   * @param index The index of the element to return.
   * @return The entries at the given index.
   */
  public java.lang.String getEntries(int index) {
    return entries_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The names of the entries that the error is associated with.
   * Format:
   * - "projects/&lt;Project ID&gt;/agent", if the error is associated with the entire
   * agent.
   * - "projects/&lt;Project ID&gt;/agent/intents/&lt;Intent ID&gt;", if the error is
   * associated with certain intents.
   * - "projects/&lt;Project
   * ID&gt;/agent/intents/&lt;Intent Id&gt;/trainingPhrases/&lt;Training Phrase ID&gt;", if the
   * error is associated with certain intent training phrases.
   * - "projects/&lt;Project ID&gt;/agent/intents/&lt;Intent Id&gt;/parameters/&lt;Parameter
   * ID&gt;", if the error is associated with certain intent parameters.
   * - "projects/&lt;Project ID&gt;/agent/entities/&lt;Entity ID&gt;", if the error is
   * associated with certain entities.
   * </pre>
   *
   * <code>repeated string entries = 3;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the entries at the given index.
   */
  public com.google.protobuf.ByteString getEntriesBytes(int index) {
    return entries_.getByteString(index);
  }

  public static final int ERROR_MESSAGE_FIELD_NUMBER = 4;
  private volatile java.lang.Object errorMessage_;
  /**
   *
   *
   * <pre>
   * The detailed error messsage.
   * </pre>
   *
   * <code>string error_message = 4;</code>
   *
   * @return The errorMessage.
   */
  public java.lang.String getErrorMessage() {
    java.lang.Object ref = errorMessage_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      errorMessage_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The detailed error messsage.
   * </pre>
   *
   * <code>string error_message = 4;</code>
   *
   * @return The bytes for errorMessage.
   */
  public com.google.protobuf.ByteString getErrorMessageBytes() {
    java.lang.Object ref = errorMessage_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      errorMessage_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (severity_
        != com.google.cloud.dialogflow.v2.ValidationError.Severity.SEVERITY_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(1, severity_);
    }
    for (int i = 0; i < entries_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, entries_.getRaw(i));
    }
    if (!getErrorMessageBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, errorMessage_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (severity_
        != com.google.cloud.dialogflow.v2.ValidationError.Severity.SEVERITY_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, severity_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < entries_.size(); i++) {
        dataSize += computeStringSizeNoTag(entries_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getEntriesList().size();
    }
    if (!getErrorMessageBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, errorMessage_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.v2.ValidationError)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.v2.ValidationError other =
        (com.google.cloud.dialogflow.v2.ValidationError) obj;

    if (severity_ != other.severity_) return false;
    if (!getEntriesList().equals(other.getEntriesList())) return false;
    if (!getErrorMessage().equals(other.getErrorMessage())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SEVERITY_FIELD_NUMBER;
    hash = (53 * hash) + severity_;
    if (getEntriesCount() > 0) {
      hash = (37 * hash) + ENTRIES_FIELD_NUMBER;
      hash = (53 * hash) + getEntriesList().hashCode();
    }
    hash = (37 * hash) + ERROR_MESSAGE_FIELD_NUMBER;
    hash = (53 * hash) + getErrorMessage().hashCode();
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.v2.ValidationError parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2.ValidationError parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.ValidationError parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2.ValidationError parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.ValidationError parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2.ValidationError parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.ValidationError parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2.ValidationError parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.ValidationError parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2.ValidationError parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.ValidationError parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2.ValidationError parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dialogflow.v2.ValidationError prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents a single validation error.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2.ValidationError}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2.ValidationError)
      com.google.cloud.dialogflow.v2.ValidationErrorOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2.ValidationResultProto
          .internal_static_google_cloud_dialogflow_v2_ValidationError_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2.ValidationResultProto
          .internal_static_google_cloud_dialogflow_v2_ValidationError_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2.ValidationError.class,
              com.google.cloud.dialogflow.v2.ValidationError.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.v2.ValidationError.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      severity_ = 0;

      entries_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      errorMessage_ = "";

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.v2.ValidationResultProto
          .internal_static_google_cloud_dialogflow_v2_ValidationError_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.ValidationError getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.v2.ValidationError.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.ValidationError build() {
      com.google.cloud.dialogflow.v2.ValidationError result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.ValidationError buildPartial() {
      com.google.cloud.dialogflow.v2.ValidationError result =
          new com.google.cloud.dialogflow.v2.ValidationError(this);
      int from_bitField0_ = bitField0_;
      result.severity_ = severity_;
      if (((bitField0_ & 0x00000001) != 0)) {
        entries_ = entries_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.entries_ = entries_;
      result.errorMessage_ = errorMessage_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.v2.ValidationError) {
        return mergeFrom((com.google.cloud.dialogflow.v2.ValidationError) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.v2.ValidationError other) {
      if (other == com.google.cloud.dialogflow.v2.ValidationError.getDefaultInstance()) return this;
      if (other.severity_ != 0) {
        setSeverityValue(other.getSeverityValue());
      }
      if (!other.entries_.isEmpty()) {
        if (entries_.isEmpty()) {
          entries_ = other.entries_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensureEntriesIsMutable();
          entries_.addAll(other.entries_);
        }
        onChanged();
      }
      if (!other.getErrorMessage().isEmpty()) {
        errorMessage_ = other.errorMessage_;
        onChanged();
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.dialogflow.v2.ValidationError parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.cloud.dialogflow.v2.ValidationError) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private int severity_ = 0;
    /**
     *
     *
     * <pre>
     * The severity of the error.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.ValidationError.Severity severity = 1;</code>
     *
     * @return The enum numeric value on the wire for severity.
     */
    public int getSeverityValue() {
      return severity_;
    }
    /**
     *
     *
     * <pre>
     * The severity of the error.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.ValidationError.Severity severity = 1;</code>
     *
     * @param value The enum numeric value on the wire for severity to set.
     * @return This builder for chaining.
     */
    public Builder setSeverityValue(int value) {
      severity_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The severity of the error.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.ValidationError.Severity severity = 1;</code>
     *
     * @return The severity.
     */
    public com.google.cloud.dialogflow.v2.ValidationError.Severity getSeverity() {
      @SuppressWarnings("deprecation")
      com.google.cloud.dialogflow.v2.ValidationError.Severity result =
          com.google.cloud.dialogflow.v2.ValidationError.Severity.valueOf(severity_);
      return result == null
          ? com.google.cloud.dialogflow.v2.ValidationError.Severity.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The severity of the error.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.ValidationError.Severity severity = 1;</code>
     *
     * @param value The severity to set.
     * @return This builder for chaining.
     */
    public Builder setSeverity(com.google.cloud.dialogflow.v2.ValidationError.Severity value) {
      if (value == null) {
        throw new NullPointerException();
      }

      severity_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The severity of the error.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.ValidationError.Severity severity = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSeverity() {

      severity_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList entries_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureEntriesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        entries_ = new com.google.protobuf.LazyStringArrayList(entries_);
        bitField0_ |= 0x00000001;
      }
    }
    /**
     *
     *
     * <pre>
     * The names of the entries that the error is associated with.
     * Format:
     * - "projects/&lt;Project ID&gt;/agent", if the error is associated with the entire
     * agent.
     * - "projects/&lt;Project ID&gt;/agent/intents/&lt;Intent ID&gt;", if the error is
     * associated with certain intents.
     * - "projects/&lt;Project
     * ID&gt;/agent/intents/&lt;Intent Id&gt;/trainingPhrases/&lt;Training Phrase ID&gt;", if the
     * error is associated with certain intent training phrases.
     * - "projects/&lt;Project ID&gt;/agent/intents/&lt;Intent Id&gt;/parameters/&lt;Parameter
     * ID&gt;", if the error is associated with certain intent parameters.
     * - "projects/&lt;Project ID&gt;/agent/entities/&lt;Entity ID&gt;", if the error is
     * associated with certain entities.
     * </pre>
     *
     * <code>repeated string entries = 3;</code>
     *
     * @return A list containing the entries.
     */
    public com.google.protobuf.ProtocolStringList getEntriesList() {
      return entries_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * The names of the entries that the error is associated with.
     * Format:
     * - "projects/&lt;Project ID&gt;/agent", if the error is associated with the entire
     * agent.
     * - "projects/&lt;Project ID&gt;/agent/intents/&lt;Intent ID&gt;", if the error is
     * associated with certain intents.
     * - "projects/&lt;Project
     * ID&gt;/agent/intents/&lt;Intent Id&gt;/trainingPhrases/&lt;Training Phrase ID&gt;", if the
     * error is associated with certain intent training phrases.
     * - "projects/&lt;Project ID&gt;/agent/intents/&lt;Intent Id&gt;/parameters/&lt;Parameter
     * ID&gt;", if the error is associated with certain intent parameters.
     * - "projects/&lt;Project ID&gt;/agent/entities/&lt;Entity ID&gt;", if the error is
     * associated with certain entities.
     * </pre>
     *
     * <code>repeated string entries = 3;</code>
     *
     * @return The count of entries.
     */
    public int getEntriesCount() {
      return entries_.size();
    }
    /**
     *
     *
     * <pre>
     * The names of the entries that the error is associated with.
     * Format:
     * - "projects/&lt;Project ID&gt;/agent", if the error is associated with the entire
     * agent.
     * - "projects/&lt;Project ID&gt;/agent/intents/&lt;Intent ID&gt;", if the error is
     * associated with certain intents.
     * - "projects/&lt;Project
     * ID&gt;/agent/intents/&lt;Intent Id&gt;/trainingPhrases/&lt;Training Phrase ID&gt;", if the
     * error is associated with certain intent training phrases.
     * - "projects/&lt;Project ID&gt;/agent/intents/&lt;Intent Id&gt;/parameters/&lt;Parameter
     * ID&gt;", if the error is associated with certain intent parameters.
     * - "projects/&lt;Project ID&gt;/agent/entities/&lt;Entity ID&gt;", if the error is
     * associated with certain entities.
     * </pre>
     *
     * <code>repeated string entries = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The entries at the given index.
     */
    public java.lang.String getEntries(int index) {
      return entries_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The names of the entries that the error is associated with.
     * Format:
     * - "projects/&lt;Project ID&gt;/agent", if the error is associated with the entire
     * agent.
     * - "projects/&lt;Project ID&gt;/agent/intents/&lt;Intent ID&gt;", if the error is
     * associated with certain intents.
     * - "projects/&lt;Project
     * ID&gt;/agent/intents/&lt;Intent Id&gt;/trainingPhrases/&lt;Training Phrase ID&gt;", if the
     * error is associated with certain intent training phrases.
     * - "projects/&lt;Project ID&gt;/agent/intents/&lt;Intent Id&gt;/parameters/&lt;Parameter
     * ID&gt;", if the error is associated with certain intent parameters.
     * - "projects/&lt;Project ID&gt;/agent/entities/&lt;Entity ID&gt;", if the error is
     * associated with certain entities.
     * </pre>
     *
     * <code>repeated string entries = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the entries at the given index.
     */
    public com.google.protobuf.ByteString getEntriesBytes(int index) {
      return entries_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * The names of the entries that the error is associated with.
     * Format:
     * - "projects/&lt;Project ID&gt;/agent", if the error is associated with the entire
     * agent.
     * - "projects/&lt;Project ID&gt;/agent/intents/&lt;Intent ID&gt;", if the error is
     * associated with certain intents.
     * - "projects/&lt;Project
     * ID&gt;/agent/intents/&lt;Intent Id&gt;/trainingPhrases/&lt;Training Phrase ID&gt;", if the
     * error is associated with certain intent training phrases.
     * - "projects/&lt;Project ID&gt;/agent/intents/&lt;Intent Id&gt;/parameters/&lt;Parameter
     * ID&gt;", if the error is associated with certain intent parameters.
     * - "projects/&lt;Project ID&gt;/agent/entities/&lt;Entity ID&gt;", if the error is
     * associated with certain entities.
     * </pre>
     *
     * <code>repeated string entries = 3;</code>
     *
     * @param index The index to set the value at.
     * @param value The entries to set.
     * @return This builder for chaining.
     */
    public Builder setEntries(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureEntriesIsMutable();
      entries_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The names of the entries that the error is associated with.
     * Format:
     * - "projects/&lt;Project ID&gt;/agent", if the error is associated with the entire
     * agent.
     * - "projects/&lt;Project ID&gt;/agent/intents/&lt;Intent ID&gt;", if the error is
     * associated with certain intents.
     * - "projects/&lt;Project
     * ID&gt;/agent/intents/&lt;Intent Id&gt;/trainingPhrases/&lt;Training Phrase ID&gt;", if the
     * error is associated with certain intent training phrases.
     * - "projects/&lt;Project ID&gt;/agent/intents/&lt;Intent Id&gt;/parameters/&lt;Parameter
     * ID&gt;", if the error is associated with certain intent parameters.
     * - "projects/&lt;Project ID&gt;/agent/entities/&lt;Entity ID&gt;", if the error is
     * associated with certain entities.
     * </pre>
     *
     * <code>repeated string entries = 3;</code>
     *
     * @param value The entries to add.
     * @return This builder for chaining.
     */
    public Builder addEntries(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureEntriesIsMutable();
      entries_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The names of the entries that the error is associated with.
     * Format:
     * - "projects/&lt;Project ID&gt;/agent", if the error is associated with the entire
     * agent.
     * - "projects/&lt;Project ID&gt;/agent/intents/&lt;Intent ID&gt;", if the error is
     * associated with certain intents.
     * - "projects/&lt;Project
     * ID&gt;/agent/intents/&lt;Intent Id&gt;/trainingPhrases/&lt;Training Phrase ID&gt;", if the
     * error is associated with certain intent training phrases.
     * - "projects/&lt;Project ID&gt;/agent/intents/&lt;Intent Id&gt;/parameters/&lt;Parameter
     * ID&gt;", if the error is associated with certain intent parameters.
     * - "projects/&lt;Project ID&gt;/agent/entities/&lt;Entity ID&gt;", if the error is
     * associated with certain entities.
     * </pre>
     *
     * <code>repeated string entries = 3;</code>
     *
     * @param values The entries to add.
     * @return This builder for chaining.
     */
    public Builder addAllEntries(java.lang.Iterable<java.lang.String> values) {
      ensureEntriesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, entries_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The names of the entries that the error is associated with.
     * Format:
     * - "projects/&lt;Project ID&gt;/agent", if the error is associated with the entire
     * agent.
     * - "projects/&lt;Project ID&gt;/agent/intents/&lt;Intent ID&gt;", if the error is
     * associated with certain intents.
     * - "projects/&lt;Project
     * ID&gt;/agent/intents/&lt;Intent Id&gt;/trainingPhrases/&lt;Training Phrase ID&gt;", if the
     * error is associated with certain intent training phrases.
     * - "projects/&lt;Project ID&gt;/agent/intents/&lt;Intent Id&gt;/parameters/&lt;Parameter
     * ID&gt;", if the error is associated with certain intent parameters.
     * - "projects/&lt;Project ID&gt;/agent/entities/&lt;Entity ID&gt;", if the error is
     * associated with certain entities.
     * </pre>
     *
     * <code>repeated string entries = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEntries() {
      entries_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The names of the entries that the error is associated with.
     * Format:
     * - "projects/&lt;Project ID&gt;/agent", if the error is associated with the entire
     * agent.
     * - "projects/&lt;Project ID&gt;/agent/intents/&lt;Intent ID&gt;", if the error is
     * associated with certain intents.
     * - "projects/&lt;Project
     * ID&gt;/agent/intents/&lt;Intent Id&gt;/trainingPhrases/&lt;Training Phrase ID&gt;", if the
     * error is associated with certain intent training phrases.
     * - "projects/&lt;Project ID&gt;/agent/intents/&lt;Intent Id&gt;/parameters/&lt;Parameter
     * ID&gt;", if the error is associated with certain intent parameters.
     * - "projects/&lt;Project ID&gt;/agent/entities/&lt;Entity ID&gt;", if the error is
     * associated with certain entities.
     * </pre>
     *
     * <code>repeated string entries = 3;</code>
     *
     * @param value The bytes of the entries to add.
     * @return This builder for chaining.
     */
    public Builder addEntriesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureEntriesIsMutable();
      entries_.add(value);
      onChanged();
      return this;
    }

    private java.lang.Object errorMessage_ = "";
    /**
     *
     *
     * <pre>
     * The detailed error messsage.
     * </pre>
     *
     * <code>string error_message = 4;</code>
     *
     * @return The errorMessage.
     */
    public java.lang.String getErrorMessage() {
      java.lang.Object ref = errorMessage_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        errorMessage_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The detailed error messsage.
     * </pre>
     *
     * <code>string error_message = 4;</code>
     *
     * @return The bytes for errorMessage.
     */
    public com.google.protobuf.ByteString getErrorMessageBytes() {
      java.lang.Object ref = errorMessage_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        errorMessage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The detailed error messsage.
     * </pre>
     *
     * <code>string error_message = 4;</code>
     *
     * @param value The errorMessage to set.
     * @return This builder for chaining.
     */
    public Builder setErrorMessage(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      errorMessage_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The detailed error messsage.
     * </pre>
     *
     * <code>string error_message = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearErrorMessage() {

      errorMessage_ = getDefaultInstance().getErrorMessage();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The detailed error messsage.
     * </pre>
     *
     * <code>string error_message = 4;</code>
     *
     * @param value The bytes for errorMessage to set.
     * @return This builder for chaining.
     */
    public Builder setErrorMessageBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      errorMessage_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2.ValidationError)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2.ValidationError)
  private static final com.google.cloud.dialogflow.v2.ValidationError DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2.ValidationError();
  }

  public static com.google.cloud.dialogflow.v2.ValidationError getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ValidationError> PARSER =
      new com.google.protobuf.AbstractParser<ValidationError>() {
        @java.lang.Override
        public ValidationError parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new ValidationError(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<ValidationError> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ValidationError> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.v2.ValidationError getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
