/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/v2/intent.proto

package com.google.cloud.dialogflow.v2;

/**
 *
 *
 * <pre>
 * Represents an intent.
 * Intents convert a number of user expressions or patterns into an action. An
 * action is an extraction of a user command or sentence semantics.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.v2.Intent}
 */
public final class Intent extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2.Intent)
    IntentOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Intent.newBuilder() to construct.
  private Intent(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Intent() {
    name_ = "";
    displayName_ = "";
    webhookState_ = 0;
    inputContextNames_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    events_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    trainingPhrases_ = java.util.Collections.emptyList();
    action_ = "";
    outputContexts_ = java.util.Collections.emptyList();
    parameters_ = java.util.Collections.emptyList();
    messages_ = java.util.Collections.emptyList();
    defaultResponsePlatforms_ = java.util.Collections.emptyList();
    rootFollowupIntentName_ = "";
    parentFollowupIntentName_ = "";
    followupIntentInfo_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Intent();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private Intent(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
          case 18:
            {
              java.lang.String s = input.readStringRequireUtf8();

              displayName_ = s;
              break;
            }
          case 24:
            {
              priority_ = input.readInt32();
              break;
            }
          case 32:
            {
              isFallback_ = input.readBool();
              break;
            }
          case 48:
            {
              int rawValue = input.readEnum();

              webhookState_ = rawValue;
              break;
            }
          case 58:
            {
              java.lang.String s = input.readStringRequireUtf8();
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                inputContextNames_ = new com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000001;
              }
              inputContextNames_.add(s);
              break;
            }
          case 66:
            {
              java.lang.String s = input.readStringRequireUtf8();
              if (!((mutable_bitField0_ & 0x00000002) != 0)) {
                events_ = new com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000002;
              }
              events_.add(s);
              break;
            }
          case 74:
            {
              if (!((mutable_bitField0_ & 0x00000004) != 0)) {
                trainingPhrases_ =
                    new java.util.ArrayList<com.google.cloud.dialogflow.v2.Intent.TrainingPhrase>();
                mutable_bitField0_ |= 0x00000004;
              }
              trainingPhrases_.add(
                  input.readMessage(
                      com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.parser(),
                      extensionRegistry));
              break;
            }
          case 82:
            {
              java.lang.String s = input.readStringRequireUtf8();

              action_ = s;
              break;
            }
          case 90:
            {
              if (!((mutable_bitField0_ & 0x00000008) != 0)) {
                outputContexts_ = new java.util.ArrayList<com.google.cloud.dialogflow.v2.Context>();
                mutable_bitField0_ |= 0x00000008;
              }
              outputContexts_.add(
                  input.readMessage(
                      com.google.cloud.dialogflow.v2.Context.parser(), extensionRegistry));
              break;
            }
          case 96:
            {
              resetContexts_ = input.readBool();
              break;
            }
          case 106:
            {
              if (!((mutable_bitField0_ & 0x00000010) != 0)) {
                parameters_ =
                    new java.util.ArrayList<com.google.cloud.dialogflow.v2.Intent.Parameter>();
                mutable_bitField0_ |= 0x00000010;
              }
              parameters_.add(
                  input.readMessage(
                      com.google.cloud.dialogflow.v2.Intent.Parameter.parser(), extensionRegistry));
              break;
            }
          case 114:
            {
              if (!((mutable_bitField0_ & 0x00000020) != 0)) {
                messages_ =
                    new java.util.ArrayList<com.google.cloud.dialogflow.v2.Intent.Message>();
                mutable_bitField0_ |= 0x00000020;
              }
              messages_.add(
                  input.readMessage(
                      com.google.cloud.dialogflow.v2.Intent.Message.parser(), extensionRegistry));
              break;
            }
          case 120:
            {
              int rawValue = input.readEnum();
              if (!((mutable_bitField0_ & 0x00000040) != 0)) {
                defaultResponsePlatforms_ = new java.util.ArrayList<java.lang.Integer>();
                mutable_bitField0_ |= 0x00000040;
              }
              defaultResponsePlatforms_.add(rawValue);
              break;
            }
          case 122:
            {
              int length = input.readRawVarint32();
              int oldLimit = input.pushLimit(length);
              while (input.getBytesUntilLimit() > 0) {
                int rawValue = input.readEnum();
                if (!((mutable_bitField0_ & 0x00000040) != 0)) {
                  defaultResponsePlatforms_ = new java.util.ArrayList<java.lang.Integer>();
                  mutable_bitField0_ |= 0x00000040;
                }
                defaultResponsePlatforms_.add(rawValue);
              }
              input.popLimit(oldLimit);
              break;
            }
          case 130:
            {
              java.lang.String s = input.readStringRequireUtf8();

              rootFollowupIntentName_ = s;
              break;
            }
          case 138:
            {
              java.lang.String s = input.readStringRequireUtf8();

              parentFollowupIntentName_ = s;
              break;
            }
          case 146:
            {
              if (!((mutable_bitField0_ & 0x00000080) != 0)) {
                followupIntentInfo_ =
                    new java.util.ArrayList<
                        com.google.cloud.dialogflow.v2.Intent.FollowupIntentInfo>();
                mutable_bitField0_ |= 0x00000080;
              }
              followupIntentInfo_.add(
                  input.readMessage(
                      com.google.cloud.dialogflow.v2.Intent.FollowupIntentInfo.parser(),
                      extensionRegistry));
              break;
            }
          case 152:
            {
              mlDisabled_ = input.readBool();
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        inputContextNames_ = inputContextNames_.getUnmodifiableView();
      }
      if (((mutable_bitField0_ & 0x00000002) != 0)) {
        events_ = events_.getUnmodifiableView();
      }
      if (((mutable_bitField0_ & 0x00000004) != 0)) {
        trainingPhrases_ = java.util.Collections.unmodifiableList(trainingPhrases_);
      }
      if (((mutable_bitField0_ & 0x00000008) != 0)) {
        outputContexts_ = java.util.Collections.unmodifiableList(outputContexts_);
      }
      if (((mutable_bitField0_ & 0x00000010) != 0)) {
        parameters_ = java.util.Collections.unmodifiableList(parameters_);
      }
      if (((mutable_bitField0_ & 0x00000020) != 0)) {
        messages_ = java.util.Collections.unmodifiableList(messages_);
      }
      if (((mutable_bitField0_ & 0x00000040) != 0)) {
        defaultResponsePlatforms_ =
            java.util.Collections.unmodifiableList(defaultResponsePlatforms_);
      }
      if (((mutable_bitField0_ & 0x00000080) != 0)) {
        followupIntentInfo_ = java.util.Collections.unmodifiableList(followupIntentInfo_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.v2.IntentProto
        .internal_static_google_cloud_dialogflow_v2_Intent_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.v2.IntentProto
        .internal_static_google_cloud_dialogflow_v2_Intent_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.v2.Intent.class,
            com.google.cloud.dialogflow.v2.Intent.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Represents the different states that webhooks can be in.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.dialogflow.v2.Intent.WebhookState}
   */
  public enum WebhookState implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Webhook is disabled in the agent and in the intent.
     * </pre>
     *
     * <code>WEBHOOK_STATE_UNSPECIFIED = 0;</code>
     */
    WEBHOOK_STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Webhook is enabled in the agent and in the intent.
     * </pre>
     *
     * <code>WEBHOOK_STATE_ENABLED = 1;</code>
     */
    WEBHOOK_STATE_ENABLED(1),
    /**
     *
     *
     * <pre>
     * Webhook is enabled in the agent and in the intent. Also, each slot
     * filling prompt is forwarded to the webhook.
     * </pre>
     *
     * <code>WEBHOOK_STATE_ENABLED_FOR_SLOT_FILLING = 2;</code>
     */
    WEBHOOK_STATE_ENABLED_FOR_SLOT_FILLING(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Webhook is disabled in the agent and in the intent.
     * </pre>
     *
     * <code>WEBHOOK_STATE_UNSPECIFIED = 0;</code>
     */
    public static final int WEBHOOK_STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Webhook is enabled in the agent and in the intent.
     * </pre>
     *
     * <code>WEBHOOK_STATE_ENABLED = 1;</code>
     */
    public static final int WEBHOOK_STATE_ENABLED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Webhook is enabled in the agent and in the intent. Also, each slot
     * filling prompt is forwarded to the webhook.
     * </pre>
     *
     * <code>WEBHOOK_STATE_ENABLED_FOR_SLOT_FILLING = 2;</code>
     */
    public static final int WEBHOOK_STATE_ENABLED_FOR_SLOT_FILLING_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static WebhookState valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static WebhookState forNumber(int value) {
      switch (value) {
        case 0:
          return WEBHOOK_STATE_UNSPECIFIED;
        case 1:
          return WEBHOOK_STATE_ENABLED;
        case 2:
          return WEBHOOK_STATE_ENABLED_FOR_SLOT_FILLING;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<WebhookState> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<WebhookState> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<WebhookState>() {
          public WebhookState findValueByNumber(int number) {
            return WebhookState.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2.Intent.getDescriptor().getEnumTypes().get(0);
    }

    private static final WebhookState[] VALUES = values();

    public static WebhookState valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private WebhookState(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.dialogflow.v2.Intent.WebhookState)
  }

  public interface TrainingPhraseOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.v2.Intent.TrainingPhrase)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. The unique identifier of this training phrase.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    java.lang.String getName();
    /**
     *
     *
     * <pre>
     * Output only. The unique identifier of this training phrase.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString getNameBytes();

    /**
     *
     *
     * <pre>
     * Required. The type of the training phrase.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.Intent.TrainingPhrase.Type type = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for type.
     */
    int getTypeValue();
    /**
     *
     *
     * <pre>
     * Required. The type of the training phrase.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.Intent.TrainingPhrase.Type type = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The type.
     */
    com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Type getType();

    /**
     *
     *
     * <pre>
     * Required. The ordered list of training phrase parts.
     * The parts are concatenated in order to form the training phrase.
     * Note: The API does not automatically annotate training phrases like the
     * Dialogflow Console does.
     * Note: Do not forget to include whitespace at part boundaries,
     * so the training phrase is well formatted when the parts are concatenated.
     * If the training phrase does not need to be annotated with parameters,
     * you just need a single part with only the [Part.text][google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part.text] field set.
     * If you want to annotate the training phrase, you must create multiple
     * parts, where the fields of each part are populated in one of two ways:
     * -   `Part.text` is set to a part of the phrase that has no parameters.
     * -   `Part.text` is set to a part of the phrase that you want to annotate,
     *     and the `entity_type`, `alias`, and `user_defined` fields are all
     *     set.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part parts = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    java.util.List<com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part> getPartsList();
    /**
     *
     *
     * <pre>
     * Required. The ordered list of training phrase parts.
     * The parts are concatenated in order to form the training phrase.
     * Note: The API does not automatically annotate training phrases like the
     * Dialogflow Console does.
     * Note: Do not forget to include whitespace at part boundaries,
     * so the training phrase is well formatted when the parts are concatenated.
     * If the training phrase does not need to be annotated with parameters,
     * you just need a single part with only the [Part.text][google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part.text] field set.
     * If you want to annotate the training phrase, you must create multiple
     * parts, where the fields of each part are populated in one of two ways:
     * -   `Part.text` is set to a part of the phrase that has no parameters.
     * -   `Part.text` is set to a part of the phrase that you want to annotate,
     *     and the `entity_type`, `alias`, and `user_defined` fields are all
     *     set.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part parts = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part getParts(int index);
    /**
     *
     *
     * <pre>
     * Required. The ordered list of training phrase parts.
     * The parts are concatenated in order to form the training phrase.
     * Note: The API does not automatically annotate training phrases like the
     * Dialogflow Console does.
     * Note: Do not forget to include whitespace at part boundaries,
     * so the training phrase is well formatted when the parts are concatenated.
     * If the training phrase does not need to be annotated with parameters,
     * you just need a single part with only the [Part.text][google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part.text] field set.
     * If you want to annotate the training phrase, you must create multiple
     * parts, where the fields of each part are populated in one of two ways:
     * -   `Part.text` is set to a part of the phrase that has no parameters.
     * -   `Part.text` is set to a part of the phrase that you want to annotate,
     *     and the `entity_type`, `alias`, and `user_defined` fields are all
     *     set.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part parts = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    int getPartsCount();
    /**
     *
     *
     * <pre>
     * Required. The ordered list of training phrase parts.
     * The parts are concatenated in order to form the training phrase.
     * Note: The API does not automatically annotate training phrases like the
     * Dialogflow Console does.
     * Note: Do not forget to include whitespace at part boundaries,
     * so the training phrase is well formatted when the parts are concatenated.
     * If the training phrase does not need to be annotated with parameters,
     * you just need a single part with only the [Part.text][google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part.text] field set.
     * If you want to annotate the training phrase, you must create multiple
     * parts, where the fields of each part are populated in one of two ways:
     * -   `Part.text` is set to a part of the phrase that has no parameters.
     * -   `Part.text` is set to a part of the phrase that you want to annotate,
     *     and the `entity_type`, `alias`, and `user_defined` fields are all
     *     set.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part parts = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    java.util.List<? extends com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.PartOrBuilder>
        getPartsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Required. The ordered list of training phrase parts.
     * The parts are concatenated in order to form the training phrase.
     * Note: The API does not automatically annotate training phrases like the
     * Dialogflow Console does.
     * Note: Do not forget to include whitespace at part boundaries,
     * so the training phrase is well formatted when the parts are concatenated.
     * If the training phrase does not need to be annotated with parameters,
     * you just need a single part with only the [Part.text][google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part.text] field set.
     * If you want to annotate the training phrase, you must create multiple
     * parts, where the fields of each part are populated in one of two ways:
     * -   `Part.text` is set to a part of the phrase that has no parameters.
     * -   `Part.text` is set to a part of the phrase that you want to annotate,
     *     and the `entity_type`, `alias`, and `user_defined` fields are all
     *     set.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part parts = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.PartOrBuilder getPartsOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * Optional. Indicates how many times this example was added to
     * the intent. Each time a developer adds an existing sample by editing an
     * intent or training, this counter is increased.
     * </pre>
     *
     * <code>int32 times_added_count = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The timesAddedCount.
     */
    int getTimesAddedCount();
  }
  /**
   *
   *
   * <pre>
   * Represents an example that the agent is trained on.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2.Intent.TrainingPhrase}
   */
  public static final class TrainingPhrase extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2.Intent.TrainingPhrase)
      TrainingPhraseOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use TrainingPhrase.newBuilder() to construct.
    private TrainingPhrase(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private TrainingPhrase() {
      name_ = "";
      type_ = 0;
      parts_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new TrainingPhrase();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private TrainingPhrase(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();

                name_ = s;
                break;
              }
            case 16:
              {
                int rawValue = input.readEnum();

                type_ = rawValue;
                break;
              }
            case 26:
              {
                if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                  parts_ =
                      new java.util.ArrayList<
                          com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part>();
                  mutable_bitField0_ |= 0x00000001;
                }
                parts_.add(
                    input.readMessage(
                        com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part.parser(),
                        extensionRegistry));
                break;
              }
            case 32:
              {
                timesAddedCount_ = input.readInt32();
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000001) != 0)) {
          parts_ = java.util.Collections.unmodifiableList(parts_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2.IntentProto
          .internal_static_google_cloud_dialogflow_v2_Intent_TrainingPhrase_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2.IntentProto
          .internal_static_google_cloud_dialogflow_v2_Intent_TrainingPhrase_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.class,
              com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * Represents different types of training phrases.
     * </pre>
     *
     * Protobuf enum {@code google.cloud.dialogflow.v2.Intent.TrainingPhrase.Type}
     */
    public enum Type implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Not specified. This value should never be used.
       * </pre>
       *
       * <code>TYPE_UNSPECIFIED = 0;</code>
       */
      TYPE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Examples do not contain &#64;-prefixed entity type names, but example parts
       * can be annotated with entity types.
       * </pre>
       *
       * <code>EXAMPLE = 1;</code>
       */
      EXAMPLE(1),
      /**
       *
       *
       * <pre>
       * Templates are not annotated with entity types, but they can contain
       * &#64;-prefixed entity type names as substrings.
       * Template mode has been deprecated. Example mode is the only supported
       * way to create new training phrases. If you have existing training
       * phrases that you've created in template mode, those will continue to
       * work.
       * </pre>
       *
       * <code>TEMPLATE = 2 [deprecated = true];</code>
       */
      @java.lang.Deprecated
      TEMPLATE(2),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Not specified. This value should never be used.
       * </pre>
       *
       * <code>TYPE_UNSPECIFIED = 0;</code>
       */
      public static final int TYPE_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Examples do not contain &#64;-prefixed entity type names, but example parts
       * can be annotated with entity types.
       * </pre>
       *
       * <code>EXAMPLE = 1;</code>
       */
      public static final int EXAMPLE_VALUE = 1;
      /**
       *
       *
       * <pre>
       * Templates are not annotated with entity types, but they can contain
       * &#64;-prefixed entity type names as substrings.
       * Template mode has been deprecated. Example mode is the only supported
       * way to create new training phrases. If you have existing training
       * phrases that you've created in template mode, those will continue to
       * work.
       * </pre>
       *
       * <code>TEMPLATE = 2 [deprecated = true];</code>
       */
      @java.lang.Deprecated public static final int TEMPLATE_VALUE = 2;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static Type valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static Type forNumber(int value) {
        switch (value) {
          case 0:
            return TYPE_UNSPECIFIED;
          case 1:
            return EXAMPLE;
          case 2:
            return TEMPLATE;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Type> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<Type> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<Type>() {
            public Type findValueByNumber(int number) {
              return Type.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final Type[] VALUES = values();

      public static Type valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private Type(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.dialogflow.v2.Intent.TrainingPhrase.Type)
    }

    public interface PartOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Required. The text for this part.
       * </pre>
       *
       * <code>string text = 1;</code>
       *
       * @return The text.
       */
      java.lang.String getText();
      /**
       *
       *
       * <pre>
       * Required. The text for this part.
       * </pre>
       *
       * <code>string text = 1;</code>
       *
       * @return The bytes for text.
       */
      com.google.protobuf.ByteString getTextBytes();

      /**
       *
       *
       * <pre>
       * Optional. The entity type name prefixed with `&#64;`.
       * This field is required for annotated parts of the training phrase.
       * </pre>
       *
       * <code>string entity_type = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The entityType.
       */
      java.lang.String getEntityType();
      /**
       *
       *
       * <pre>
       * Optional. The entity type name prefixed with `&#64;`.
       * This field is required for annotated parts of the training phrase.
       * </pre>
       *
       * <code>string entity_type = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for entityType.
       */
      com.google.protobuf.ByteString getEntityTypeBytes();

      /**
       *
       *
       * <pre>
       * Optional. The parameter name for the value extracted from the
       * annotated part of the example.
       * This field is required for annotated parts of the training phrase.
       * </pre>
       *
       * <code>string alias = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The alias.
       */
      java.lang.String getAlias();
      /**
       *
       *
       * <pre>
       * Optional. The parameter name for the value extracted from the
       * annotated part of the example.
       * This field is required for annotated parts of the training phrase.
       * </pre>
       *
       * <code>string alias = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for alias.
       */
      com.google.protobuf.ByteString getAliasBytes();

      /**
       *
       *
       * <pre>
       * Optional. Indicates whether the text was manually annotated.
       * This field is set to true when the Dialogflow Console is used to
       * manually annotate the part. When creating an annotated part with the
       * API, you must set this to true.
       * </pre>
       *
       * <code>bool user_defined = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The userDefined.
       */
      boolean getUserDefined();
    }
    /**
     *
     *
     * <pre>
     * Represents a part of a training phrase.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part}
     */
    public static final class Part extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part)
        PartOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use Part.newBuilder() to construct.
      private Part(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Part() {
        text_ = "";
        entityType_ = "";
        alias_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Part();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
      }

      private Part(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();

                  text_ = s;
                  break;
                }
              case 18:
                {
                  java.lang.String s = input.readStringRequireUtf8();

                  entityType_ = s;
                  break;
                }
              case 26:
                {
                  java.lang.String s = input.readStringRequireUtf8();

                  alias_ = s;
                  break;
                }
              case 32:
                {
                  userDefined_ = input.readBool();
                  break;
                }
              default:
                {
                  if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                    done = true;
                  }
                  break;
                }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(this);
        } finally {
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.v2.IntentProto
            .internal_static_google_cloud_dialogflow_v2_Intent_TrainingPhrase_Part_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.v2.IntentProto
            .internal_static_google_cloud_dialogflow_v2_Intent_TrainingPhrase_Part_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part.class,
                com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part.Builder.class);
      }

      public static final int TEXT_FIELD_NUMBER = 1;
      private volatile java.lang.Object text_;
      /**
       *
       *
       * <pre>
       * Required. The text for this part.
       * </pre>
       *
       * <code>string text = 1;</code>
       *
       * @return The text.
       */
      @java.lang.Override
      public java.lang.String getText() {
        java.lang.Object ref = text_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          text_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The text for this part.
       * </pre>
       *
       * <code>string text = 1;</code>
       *
       * @return The bytes for text.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getTextBytes() {
        java.lang.Object ref = text_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          text_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int ENTITY_TYPE_FIELD_NUMBER = 2;
      private volatile java.lang.Object entityType_;
      /**
       *
       *
       * <pre>
       * Optional. The entity type name prefixed with `&#64;`.
       * This field is required for annotated parts of the training phrase.
       * </pre>
       *
       * <code>string entity_type = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The entityType.
       */
      @java.lang.Override
      public java.lang.String getEntityType() {
        java.lang.Object ref = entityType_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          entityType_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The entity type name prefixed with `&#64;`.
       * This field is required for annotated parts of the training phrase.
       * </pre>
       *
       * <code>string entity_type = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for entityType.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getEntityTypeBytes() {
        java.lang.Object ref = entityType_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          entityType_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int ALIAS_FIELD_NUMBER = 3;
      private volatile java.lang.Object alias_;
      /**
       *
       *
       * <pre>
       * Optional. The parameter name for the value extracted from the
       * annotated part of the example.
       * This field is required for annotated parts of the training phrase.
       * </pre>
       *
       * <code>string alias = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The alias.
       */
      @java.lang.Override
      public java.lang.String getAlias() {
        java.lang.Object ref = alias_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          alias_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The parameter name for the value extracted from the
       * annotated part of the example.
       * This field is required for annotated parts of the training phrase.
       * </pre>
       *
       * <code>string alias = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for alias.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getAliasBytes() {
        java.lang.Object ref = alias_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          alias_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int USER_DEFINED_FIELD_NUMBER = 4;
      private boolean userDefined_;
      /**
       *
       *
       * <pre>
       * Optional. Indicates whether the text was manually annotated.
       * This field is set to true when the Dialogflow Console is used to
       * manually annotate the part. When creating an annotated part with the
       * API, you must set this to true.
       * </pre>
       *
       * <code>bool user_defined = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The userDefined.
       */
      @java.lang.Override
      public boolean getUserDefined() {
        return userDefined_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!getTextBytes().isEmpty()) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, text_);
        }
        if (!getEntityTypeBytes().isEmpty()) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 2, entityType_);
        }
        if (!getAliasBytes().isEmpty()) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 3, alias_);
        }
        if (userDefined_ != false) {
          output.writeBool(4, userDefined_);
        }
        unknownFields.writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!getTextBytes().isEmpty()) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, text_);
        }
        if (!getEntityTypeBytes().isEmpty()) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, entityType_);
        }
        if (!getAliasBytes().isEmpty()) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, alias_);
        }
        if (userDefined_ != false) {
          size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, userDefined_);
        }
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part)) {
          return super.equals(obj);
        }
        com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part other =
            (com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part) obj;

        if (!getText().equals(other.getText())) return false;
        if (!getEntityType().equals(other.getEntityType())) return false;
        if (!getAlias().equals(other.getAlias())) return false;
        if (getUserDefined() != other.getUserDefined()) return false;
        if (!unknownFields.equals(other.unknownFields)) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + TEXT_FIELD_NUMBER;
        hash = (53 * hash) + getText().hashCode();
        hash = (37 * hash) + ENTITY_TYPE_FIELD_NUMBER;
        hash = (53 * hash) + getEntityType().hashCode();
        hash = (37 * hash) + ALIAS_FIELD_NUMBER;
        hash = (53 * hash) + getAlias().hashCode();
        hash = (37 * hash) + USER_DEFINED_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getUserDefined());
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part parseDelimitedFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Represents a part of a training phrase.
       * </pre>
       *
       * Protobuf type {@code google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part)
          com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.PartOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.dialogflow.v2.IntentProto
              .internal_static_google_cloud_dialogflow_v2_Intent_TrainingPhrase_Part_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.dialogflow.v2.IntentProto
              .internal_static_google_cloud_dialogflow_v2_Intent_TrainingPhrase_Part_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part.class,
                  com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part.Builder.class);
        }

        // Construct using com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          text_ = "";

          entityType_ = "";

          alias_ = "";

          userDefined_ = false;

          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.dialogflow.v2.IntentProto
              .internal_static_google_cloud_dialogflow_v2_Intent_TrainingPhrase_Part_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part
            getDefaultInstanceForType() {
          return com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part build() {
          com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part buildPartial() {
          com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part result =
              new com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part(this);
          result.text_ = text_;
          result.entityType_ = entityType_;
          result.alias_ = alias_;
          result.userDefined_ = userDefined_;
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part) {
            return mergeFrom((com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part other) {
          if (other
              == com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part.getDefaultInstance())
            return this;
          if (!other.getText().isEmpty()) {
            text_ = other.text_;
            onChanged();
          }
          if (!other.getEntityType().isEmpty()) {
            entityType_ = other.entityType_;
            onChanged();
          }
          if (!other.getAlias().isEmpty()) {
            alias_ = other.alias_;
            onChanged();
          }
          if (other.getUserDefined() != false) {
            setUserDefined(other.getUserDefined());
          }
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage =
                (com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part)
                    e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }

        private java.lang.Object text_ = "";
        /**
         *
         *
         * <pre>
         * Required. The text for this part.
         * </pre>
         *
         * <code>string text = 1;</code>
         *
         * @return The text.
         */
        public java.lang.String getText() {
          java.lang.Object ref = text_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            text_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The text for this part.
         * </pre>
         *
         * <code>string text = 1;</code>
         *
         * @return The bytes for text.
         */
        public com.google.protobuf.ByteString getTextBytes() {
          java.lang.Object ref = text_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            text_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The text for this part.
         * </pre>
         *
         * <code>string text = 1;</code>
         *
         * @param value The text to set.
         * @return This builder for chaining.
         */
        public Builder setText(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }

          text_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The text for this part.
         * </pre>
         *
         * <code>string text = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearText() {

          text_ = getDefaultInstance().getText();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The text for this part.
         * </pre>
         *
         * <code>string text = 1;</code>
         *
         * @param value The bytes for text to set.
         * @return This builder for chaining.
         */
        public Builder setTextBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);

          text_ = value;
          onChanged();
          return this;
        }

        private java.lang.Object entityType_ = "";
        /**
         *
         *
         * <pre>
         * Optional. The entity type name prefixed with `&#64;`.
         * This field is required for annotated parts of the training phrase.
         * </pre>
         *
         * <code>string entity_type = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The entityType.
         */
        public java.lang.String getEntityType() {
          java.lang.Object ref = entityType_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            entityType_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The entity type name prefixed with `&#64;`.
         * This field is required for annotated parts of the training phrase.
         * </pre>
         *
         * <code>string entity_type = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The bytes for entityType.
         */
        public com.google.protobuf.ByteString getEntityTypeBytes() {
          java.lang.Object ref = entityType_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            entityType_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The entity type name prefixed with `&#64;`.
         * This field is required for annotated parts of the training phrase.
         * </pre>
         *
         * <code>string entity_type = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The entityType to set.
         * @return This builder for chaining.
         */
        public Builder setEntityType(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }

          entityType_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The entity type name prefixed with `&#64;`.
         * This field is required for annotated parts of the training phrase.
         * </pre>
         *
         * <code>string entity_type = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearEntityType() {

          entityType_ = getDefaultInstance().getEntityType();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The entity type name prefixed with `&#64;`.
         * This field is required for annotated parts of the training phrase.
         * </pre>
         *
         * <code>string entity_type = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The bytes for entityType to set.
         * @return This builder for chaining.
         */
        public Builder setEntityTypeBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);

          entityType_ = value;
          onChanged();
          return this;
        }

        private java.lang.Object alias_ = "";
        /**
         *
         *
         * <pre>
         * Optional. The parameter name for the value extracted from the
         * annotated part of the example.
         * This field is required for annotated parts of the training phrase.
         * </pre>
         *
         * <code>string alias = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The alias.
         */
        public java.lang.String getAlias() {
          java.lang.Object ref = alias_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            alias_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The parameter name for the value extracted from the
         * annotated part of the example.
         * This field is required for annotated parts of the training phrase.
         * </pre>
         *
         * <code>string alias = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The bytes for alias.
         */
        public com.google.protobuf.ByteString getAliasBytes() {
          java.lang.Object ref = alias_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            alias_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The parameter name for the value extracted from the
         * annotated part of the example.
         * This field is required for annotated parts of the training phrase.
         * </pre>
         *
         * <code>string alias = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The alias to set.
         * @return This builder for chaining.
         */
        public Builder setAlias(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }

          alias_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The parameter name for the value extracted from the
         * annotated part of the example.
         * This field is required for annotated parts of the training phrase.
         * </pre>
         *
         * <code>string alias = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearAlias() {

          alias_ = getDefaultInstance().getAlias();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The parameter name for the value extracted from the
         * annotated part of the example.
         * This field is required for annotated parts of the training phrase.
         * </pre>
         *
         * <code>string alias = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The bytes for alias to set.
         * @return This builder for chaining.
         */
        public Builder setAliasBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);

          alias_ = value;
          onChanged();
          return this;
        }

        private boolean userDefined_;
        /**
         *
         *
         * <pre>
         * Optional. Indicates whether the text was manually annotated.
         * This field is set to true when the Dialogflow Console is used to
         * manually annotate the part. When creating an annotated part with the
         * API, you must set this to true.
         * </pre>
         *
         * <code>bool user_defined = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The userDefined.
         */
        @java.lang.Override
        public boolean getUserDefined() {
          return userDefined_;
        }
        /**
         *
         *
         * <pre>
         * Optional. Indicates whether the text was manually annotated.
         * This field is set to true when the Dialogflow Console is used to
         * manually annotate the part. When creating an annotated part with the
         * API, you must set this to true.
         * </pre>
         *
         * <code>bool user_defined = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The userDefined to set.
         * @return This builder for chaining.
         */
        public Builder setUserDefined(boolean value) {

          userDefined_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. Indicates whether the text was manually annotated.
         * This field is set to true when the Dialogflow Console is used to
         * manually annotate the part. When creating an annotated part with the
         * API, you must set this to true.
         * </pre>
         *
         * <code>bool user_defined = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearUserDefined() {

          userDefined_ = false;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part)
      private static final com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part();
      }

      public static com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Part> PARSER =
          new com.google.protobuf.AbstractParser<Part>() {
            @java.lang.Override
            public Part parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              return new Part(input, extensionRegistry);
            }
          };

      public static com.google.protobuf.Parser<Part> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Part> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public static final int NAME_FIELD_NUMBER = 1;
    private volatile java.lang.Object name_;
    /**
     *
     *
     * <pre>
     * Output only. The unique identifier of this training phrase.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The unique identifier of this training phrase.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int TYPE_FIELD_NUMBER = 2;
    private int type_;
    /**
     *
     *
     * <pre>
     * Required. The type of the training phrase.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.Intent.TrainingPhrase.Type type = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override
    public int getTypeValue() {
      return type_;
    }
    /**
     *
     *
     * <pre>
     * Required. The type of the training phrase.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.Intent.TrainingPhrase.Type type = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The type.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Type getType() {
      @SuppressWarnings("deprecation")
      com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Type result =
          com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Type.valueOf(type_);
      return result == null
          ? com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Type.UNRECOGNIZED
          : result;
    }

    public static final int PARTS_FIELD_NUMBER = 3;
    private java.util.List<com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part> parts_;
    /**
     *
     *
     * <pre>
     * Required. The ordered list of training phrase parts.
     * The parts are concatenated in order to form the training phrase.
     * Note: The API does not automatically annotate training phrases like the
     * Dialogflow Console does.
     * Note: Do not forget to include whitespace at part boundaries,
     * so the training phrase is well formatted when the parts are concatenated.
     * If the training phrase does not need to be annotated with parameters,
     * you just need a single part with only the [Part.text][google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part.text] field set.
     * If you want to annotate the training phrase, you must create multiple
     * parts, where the fields of each part are populated in one of two ways:
     * -   `Part.text` is set to a part of the phrase that has no parameters.
     * -   `Part.text` is set to a part of the phrase that you want to annotate,
     *     and the `entity_type`, `alias`, and `user_defined` fields are all
     *     set.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part parts = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part>
        getPartsList() {
      return parts_;
    }
    /**
     *
     *
     * <pre>
     * Required. The ordered list of training phrase parts.
     * The parts are concatenated in order to form the training phrase.
     * Note: The API does not automatically annotate training phrases like the
     * Dialogflow Console does.
     * Note: Do not forget to include whitespace at part boundaries,
     * so the training phrase is well formatted when the parts are concatenated.
     * If the training phrase does not need to be annotated with parameters,
     * you just need a single part with only the [Part.text][google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part.text] field set.
     * If you want to annotate the training phrase, you must create multiple
     * parts, where the fields of each part are populated in one of two ways:
     * -   `Part.text` is set to a part of the phrase that has no parameters.
     * -   `Part.text` is set to a part of the phrase that you want to annotate,
     *     and the `entity_type`, `alias`, and `user_defined` fields are all
     *     set.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part parts = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.PartOrBuilder>
        getPartsOrBuilderList() {
      return parts_;
    }
    /**
     *
     *
     * <pre>
     * Required. The ordered list of training phrase parts.
     * The parts are concatenated in order to form the training phrase.
     * Note: The API does not automatically annotate training phrases like the
     * Dialogflow Console does.
     * Note: Do not forget to include whitespace at part boundaries,
     * so the training phrase is well formatted when the parts are concatenated.
     * If the training phrase does not need to be annotated with parameters,
     * you just need a single part with only the [Part.text][google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part.text] field set.
     * If you want to annotate the training phrase, you must create multiple
     * parts, where the fields of each part are populated in one of two ways:
     * -   `Part.text` is set to a part of the phrase that has no parameters.
     * -   `Part.text` is set to a part of the phrase that you want to annotate,
     *     and the `entity_type`, `alias`, and `user_defined` fields are all
     *     set.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part parts = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public int getPartsCount() {
      return parts_.size();
    }
    /**
     *
     *
     * <pre>
     * Required. The ordered list of training phrase parts.
     * The parts are concatenated in order to form the training phrase.
     * Note: The API does not automatically annotate training phrases like the
     * Dialogflow Console does.
     * Note: Do not forget to include whitespace at part boundaries,
     * so the training phrase is well formatted when the parts are concatenated.
     * If the training phrase does not need to be annotated with parameters,
     * you just need a single part with only the [Part.text][google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part.text] field set.
     * If you want to annotate the training phrase, you must create multiple
     * parts, where the fields of each part are populated in one of two ways:
     * -   `Part.text` is set to a part of the phrase that has no parameters.
     * -   `Part.text` is set to a part of the phrase that you want to annotate,
     *     and the `entity_type`, `alias`, and `user_defined` fields are all
     *     set.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part parts = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part getParts(int index) {
      return parts_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Required. The ordered list of training phrase parts.
     * The parts are concatenated in order to form the training phrase.
     * Note: The API does not automatically annotate training phrases like the
     * Dialogflow Console does.
     * Note: Do not forget to include whitespace at part boundaries,
     * so the training phrase is well formatted when the parts are concatenated.
     * If the training phrase does not need to be annotated with parameters,
     * you just need a single part with only the [Part.text][google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part.text] field set.
     * If you want to annotate the training phrase, you must create multiple
     * parts, where the fields of each part are populated in one of two ways:
     * -   `Part.text` is set to a part of the phrase that has no parameters.
     * -   `Part.text` is set to a part of the phrase that you want to annotate,
     *     and the `entity_type`, `alias`, and `user_defined` fields are all
     *     set.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part parts = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.PartOrBuilder getPartsOrBuilder(
        int index) {
      return parts_.get(index);
    }

    public static final int TIMES_ADDED_COUNT_FIELD_NUMBER = 4;
    private int timesAddedCount_;
    /**
     *
     *
     * <pre>
     * Optional. Indicates how many times this example was added to
     * the intent. Each time a developer adds an existing sample by editing an
     * intent or training, this counter is increased.
     * </pre>
     *
     * <code>int32 times_added_count = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The timesAddedCount.
     */
    @java.lang.Override
    public int getTimesAddedCount() {
      return timesAddedCount_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!getNameBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
      }
      if (type_
          != com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Type.TYPE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(2, type_);
      }
      for (int i = 0; i < parts_.size(); i++) {
        output.writeMessage(3, parts_.get(i));
      }
      if (timesAddedCount_ != 0) {
        output.writeInt32(4, timesAddedCount_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getNameBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
      }
      if (type_
          != com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Type.TYPE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, type_);
      }
      for (int i = 0; i < parts_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, parts_.get(i));
      }
      if (timesAddedCount_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, timesAddedCount_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dialogflow.v2.Intent.TrainingPhrase)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.v2.Intent.TrainingPhrase other =
          (com.google.cloud.dialogflow.v2.Intent.TrainingPhrase) obj;

      if (!getName().equals(other.getName())) return false;
      if (type_ != other.type_) return false;
      if (!getPartsList().equals(other.getPartsList())) return false;
      if (getTimesAddedCount() != other.getTimesAddedCount()) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      hash = (37 * hash) + TYPE_FIELD_NUMBER;
      hash = (53 * hash) + type_;
      if (getPartsCount() > 0) {
        hash = (37 * hash) + PARTS_FIELD_NUMBER;
        hash = (53 * hash) + getPartsList().hashCode();
      }
      hash = (37 * hash) + TIMES_ADDED_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getTimesAddedCount();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.v2.Intent.TrainingPhrase parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.v2.Intent.TrainingPhrase parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2.Intent.TrainingPhrase parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.v2.Intent.TrainingPhrase parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2.Intent.TrainingPhrase parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.v2.Intent.TrainingPhrase parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2.Intent.TrainingPhrase parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.v2.Intent.TrainingPhrase parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2.Intent.TrainingPhrase parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.v2.Intent.TrainingPhrase parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2.Intent.TrainingPhrase parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.v2.Intent.TrainingPhrase parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.v2.Intent.TrainingPhrase prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Represents an example that the agent is trained on.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.v2.Intent.TrainingPhrase}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2.Intent.TrainingPhrase)
        com.google.cloud.dialogflow.v2.Intent.TrainingPhraseOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.v2.IntentProto
            .internal_static_google_cloud_dialogflow_v2_Intent_TrainingPhrase_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.v2.IntentProto
            .internal_static_google_cloud_dialogflow_v2_Intent_TrainingPhrase_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.class,
                com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Builder.class);
      }

      // Construct using com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getPartsFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        name_ = "";

        type_ = 0;

        if (partsBuilder_ == null) {
          parts_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          partsBuilder_.clear();
        }
        timesAddedCount_ = 0;

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.v2.IntentProto
            .internal_static_google_cloud_dialogflow_v2_Intent_TrainingPhrase_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2.Intent.TrainingPhrase getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2.Intent.TrainingPhrase build() {
        com.google.cloud.dialogflow.v2.Intent.TrainingPhrase result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2.Intent.TrainingPhrase buildPartial() {
        com.google.cloud.dialogflow.v2.Intent.TrainingPhrase result =
            new com.google.cloud.dialogflow.v2.Intent.TrainingPhrase(this);
        int from_bitField0_ = bitField0_;
        result.name_ = name_;
        result.type_ = type_;
        if (partsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            parts_ = java.util.Collections.unmodifiableList(parts_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.parts_ = parts_;
        } else {
          result.parts_ = partsBuilder_.build();
        }
        result.timesAddedCount_ = timesAddedCount_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dialogflow.v2.Intent.TrainingPhrase) {
          return mergeFrom((com.google.cloud.dialogflow.v2.Intent.TrainingPhrase) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.dialogflow.v2.Intent.TrainingPhrase other) {
        if (other == com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.getDefaultInstance())
          return this;
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          onChanged();
        }
        if (other.type_ != 0) {
          setTypeValue(other.getTypeValue());
        }
        if (partsBuilder_ == null) {
          if (!other.parts_.isEmpty()) {
            if (parts_.isEmpty()) {
              parts_ = other.parts_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensurePartsIsMutable();
              parts_.addAll(other.parts_);
            }
            onChanged();
          }
        } else {
          if (!other.parts_.isEmpty()) {
            if (partsBuilder_.isEmpty()) {
              partsBuilder_.dispose();
              partsBuilder_ = null;
              parts_ = other.parts_;
              bitField0_ = (bitField0_ & ~0x00000001);
              partsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getPartsFieldBuilder()
                      : null;
            } else {
              partsBuilder_.addAllMessages(other.parts_);
            }
          }
        }
        if (other.getTimesAddedCount() != 0) {
          setTimesAddedCount(other.getTimesAddedCount());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.dialogflow.v2.Intent.TrainingPhrase parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.dialogflow.v2.Intent.TrainingPhrase) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private java.lang.Object name_ = "";
      /**
       *
       *
       * <pre>
       * Output only. The unique identifier of this training phrase.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The unique identifier of this training phrase.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The unique identifier of this training phrase.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        name_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The unique identifier of this training phrase.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearName() {

        name_ = getDefaultInstance().getName();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The unique identifier of this training phrase.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        name_ = value;
        onChanged();
        return this;
      }

      private int type_ = 0;
      /**
       *
       *
       * <pre>
       * Required. The type of the training phrase.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2.Intent.TrainingPhrase.Type type = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The enum numeric value on the wire for type.
       */
      @java.lang.Override
      public int getTypeValue() {
        return type_;
      }
      /**
       *
       *
       * <pre>
       * Required. The type of the training phrase.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2.Intent.TrainingPhrase.Type type = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @param value The enum numeric value on the wire for type to set.
       * @return This builder for chaining.
       */
      public Builder setTypeValue(int value) {

        type_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The type of the training phrase.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2.Intent.TrainingPhrase.Type type = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The type.
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Type getType() {
        @SuppressWarnings("deprecation")
        com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Type result =
            com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Type.valueOf(type_);
        return result == null
            ? com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Type.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Required. The type of the training phrase.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2.Intent.TrainingPhrase.Type type = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @param value The type to set.
       * @return This builder for chaining.
       */
      public Builder setType(com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Type value) {
        if (value == null) {
          throw new NullPointerException();
        }

        type_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The type of the training phrase.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2.Intent.TrainingPhrase.Type type = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearType() {

        type_ = 0;
        onChanged();
        return this;
      }

      private java.util.List<com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part> parts_ =
          java.util.Collections.emptyList();

      private void ensurePartsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          parts_ =
              new java.util.ArrayList<com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part>(
                  parts_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part,
              com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part.Builder,
              com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.PartOrBuilder>
          partsBuilder_;

      /**
       *
       *
       * <pre>
       * Required. The ordered list of training phrase parts.
       * The parts are concatenated in order to form the training phrase.
       * Note: The API does not automatically annotate training phrases like the
       * Dialogflow Console does.
       * Note: Do not forget to include whitespace at part boundaries,
       * so the training phrase is well formatted when the parts are concatenated.
       * If the training phrase does not need to be annotated with parameters,
       * you just need a single part with only the [Part.text][google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part.text] field set.
       * If you want to annotate the training phrase, you must create multiple
       * parts, where the fields of each part are populated in one of two ways:
       * -   `Part.text` is set to a part of the phrase that has no parameters.
       * -   `Part.text` is set to a part of the phrase that you want to annotate,
       *     and the `entity_type`, `alias`, and `user_defined` fields are all
       *     set.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part parts = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public java.util.List<com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part>
          getPartsList() {
        if (partsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(parts_);
        } else {
          return partsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The ordered list of training phrase parts.
       * The parts are concatenated in order to form the training phrase.
       * Note: The API does not automatically annotate training phrases like the
       * Dialogflow Console does.
       * Note: Do not forget to include whitespace at part boundaries,
       * so the training phrase is well formatted when the parts are concatenated.
       * If the training phrase does not need to be annotated with parameters,
       * you just need a single part with only the [Part.text][google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part.text] field set.
       * If you want to annotate the training phrase, you must create multiple
       * parts, where the fields of each part are populated in one of two ways:
       * -   `Part.text` is set to a part of the phrase that has no parameters.
       * -   `Part.text` is set to a part of the phrase that you want to annotate,
       *     and the `entity_type`, `alias`, and `user_defined` fields are all
       *     set.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part parts = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public int getPartsCount() {
        if (partsBuilder_ == null) {
          return parts_.size();
        } else {
          return partsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The ordered list of training phrase parts.
       * The parts are concatenated in order to form the training phrase.
       * Note: The API does not automatically annotate training phrases like the
       * Dialogflow Console does.
       * Note: Do not forget to include whitespace at part boundaries,
       * so the training phrase is well formatted when the parts are concatenated.
       * If the training phrase does not need to be annotated with parameters,
       * you just need a single part with only the [Part.text][google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part.text] field set.
       * If you want to annotate the training phrase, you must create multiple
       * parts, where the fields of each part are populated in one of two ways:
       * -   `Part.text` is set to a part of the phrase that has no parameters.
       * -   `Part.text` is set to a part of the phrase that you want to annotate,
       *     and the `entity_type`, `alias`, and `user_defined` fields are all
       *     set.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part parts = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part getParts(int index) {
        if (partsBuilder_ == null) {
          return parts_.get(index);
        } else {
          return partsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The ordered list of training phrase parts.
       * The parts are concatenated in order to form the training phrase.
       * Note: The API does not automatically annotate training phrases like the
       * Dialogflow Console does.
       * Note: Do not forget to include whitespace at part boundaries,
       * so the training phrase is well formatted when the parts are concatenated.
       * If the training phrase does not need to be annotated with parameters,
       * you just need a single part with only the [Part.text][google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part.text] field set.
       * If you want to annotate the training phrase, you must create multiple
       * parts, where the fields of each part are populated in one of two ways:
       * -   `Part.text` is set to a part of the phrase that has no parameters.
       * -   `Part.text` is set to a part of the phrase that you want to annotate,
       *     and the `entity_type`, `alias`, and `user_defined` fields are all
       *     set.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part parts = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setParts(
          int index, com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part value) {
        if (partsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePartsIsMutable();
          parts_.set(index, value);
          onChanged();
        } else {
          partsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The ordered list of training phrase parts.
       * The parts are concatenated in order to form the training phrase.
       * Note: The API does not automatically annotate training phrases like the
       * Dialogflow Console does.
       * Note: Do not forget to include whitespace at part boundaries,
       * so the training phrase is well formatted when the parts are concatenated.
       * If the training phrase does not need to be annotated with parameters,
       * you just need a single part with only the [Part.text][google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part.text] field set.
       * If you want to annotate the training phrase, you must create multiple
       * parts, where the fields of each part are populated in one of two ways:
       * -   `Part.text` is set to a part of the phrase that has no parameters.
       * -   `Part.text` is set to a part of the phrase that you want to annotate,
       *     and the `entity_type`, `alias`, and `user_defined` fields are all
       *     set.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part parts = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setParts(
          int index,
          com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part.Builder builderForValue) {
        if (partsBuilder_ == null) {
          ensurePartsIsMutable();
          parts_.set(index, builderForValue.build());
          onChanged();
        } else {
          partsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The ordered list of training phrase parts.
       * The parts are concatenated in order to form the training phrase.
       * Note: The API does not automatically annotate training phrases like the
       * Dialogflow Console does.
       * Note: Do not forget to include whitespace at part boundaries,
       * so the training phrase is well formatted when the parts are concatenated.
       * If the training phrase does not need to be annotated with parameters,
       * you just need a single part with only the [Part.text][google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part.text] field set.
       * If you want to annotate the training phrase, you must create multiple
       * parts, where the fields of each part are populated in one of two ways:
       * -   `Part.text` is set to a part of the phrase that has no parameters.
       * -   `Part.text` is set to a part of the phrase that you want to annotate,
       *     and the `entity_type`, `alias`, and `user_defined` fields are all
       *     set.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part parts = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addParts(com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part value) {
        if (partsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePartsIsMutable();
          parts_.add(value);
          onChanged();
        } else {
          partsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The ordered list of training phrase parts.
       * The parts are concatenated in order to form the training phrase.
       * Note: The API does not automatically annotate training phrases like the
       * Dialogflow Console does.
       * Note: Do not forget to include whitespace at part boundaries,
       * so the training phrase is well formatted when the parts are concatenated.
       * If the training phrase does not need to be annotated with parameters,
       * you just need a single part with only the [Part.text][google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part.text] field set.
       * If you want to annotate the training phrase, you must create multiple
       * parts, where the fields of each part are populated in one of two ways:
       * -   `Part.text` is set to a part of the phrase that has no parameters.
       * -   `Part.text` is set to a part of the phrase that you want to annotate,
       *     and the `entity_type`, `alias`, and `user_defined` fields are all
       *     set.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part parts = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addParts(
          int index, com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part value) {
        if (partsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePartsIsMutable();
          parts_.add(index, value);
          onChanged();
        } else {
          partsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The ordered list of training phrase parts.
       * The parts are concatenated in order to form the training phrase.
       * Note: The API does not automatically annotate training phrases like the
       * Dialogflow Console does.
       * Note: Do not forget to include whitespace at part boundaries,
       * so the training phrase is well formatted when the parts are concatenated.
       * If the training phrase does not need to be annotated with parameters,
       * you just need a single part with only the [Part.text][google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part.text] field set.
       * If you want to annotate the training phrase, you must create multiple
       * parts, where the fields of each part are populated in one of two ways:
       * -   `Part.text` is set to a part of the phrase that has no parameters.
       * -   `Part.text` is set to a part of the phrase that you want to annotate,
       *     and the `entity_type`, `alias`, and `user_defined` fields are all
       *     set.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part parts = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addParts(
          com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part.Builder builderForValue) {
        if (partsBuilder_ == null) {
          ensurePartsIsMutable();
          parts_.add(builderForValue.build());
          onChanged();
        } else {
          partsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The ordered list of training phrase parts.
       * The parts are concatenated in order to form the training phrase.
       * Note: The API does not automatically annotate training phrases like the
       * Dialogflow Console does.
       * Note: Do not forget to include whitespace at part boundaries,
       * so the training phrase is well formatted when the parts are concatenated.
       * If the training phrase does not need to be annotated with parameters,
       * you just need a single part with only the [Part.text][google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part.text] field set.
       * If you want to annotate the training phrase, you must create multiple
       * parts, where the fields of each part are populated in one of two ways:
       * -   `Part.text` is set to a part of the phrase that has no parameters.
       * -   `Part.text` is set to a part of the phrase that you want to annotate,
       *     and the `entity_type`, `alias`, and `user_defined` fields are all
       *     set.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part parts = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addParts(
          int index,
          com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part.Builder builderForValue) {
        if (partsBuilder_ == null) {
          ensurePartsIsMutable();
          parts_.add(index, builderForValue.build());
          onChanged();
        } else {
          partsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The ordered list of training phrase parts.
       * The parts are concatenated in order to form the training phrase.
       * Note: The API does not automatically annotate training phrases like the
       * Dialogflow Console does.
       * Note: Do not forget to include whitespace at part boundaries,
       * so the training phrase is well formatted when the parts are concatenated.
       * If the training phrase does not need to be annotated with parameters,
       * you just need a single part with only the [Part.text][google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part.text] field set.
       * If you want to annotate the training phrase, you must create multiple
       * parts, where the fields of each part are populated in one of two ways:
       * -   `Part.text` is set to a part of the phrase that has no parameters.
       * -   `Part.text` is set to a part of the phrase that you want to annotate,
       *     and the `entity_type`, `alias`, and `user_defined` fields are all
       *     set.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part parts = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addAllParts(
          java.lang.Iterable<? extends com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part>
              values) {
        if (partsBuilder_ == null) {
          ensurePartsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, parts_);
          onChanged();
        } else {
          partsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The ordered list of training phrase parts.
       * The parts are concatenated in order to form the training phrase.
       * Note: The API does not automatically annotate training phrases like the
       * Dialogflow Console does.
       * Note: Do not forget to include whitespace at part boundaries,
       * so the training phrase is well formatted when the parts are concatenated.
       * If the training phrase does not need to be annotated with parameters,
       * you just need a single part with only the [Part.text][google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part.text] field set.
       * If you want to annotate the training phrase, you must create multiple
       * parts, where the fields of each part are populated in one of two ways:
       * -   `Part.text` is set to a part of the phrase that has no parameters.
       * -   `Part.text` is set to a part of the phrase that you want to annotate,
       *     and the `entity_type`, `alias`, and `user_defined` fields are all
       *     set.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part parts = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearParts() {
        if (partsBuilder_ == null) {
          parts_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          partsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The ordered list of training phrase parts.
       * The parts are concatenated in order to form the training phrase.
       * Note: The API does not automatically annotate training phrases like the
       * Dialogflow Console does.
       * Note: Do not forget to include whitespace at part boundaries,
       * so the training phrase is well formatted when the parts are concatenated.
       * If the training phrase does not need to be annotated with parameters,
       * you just need a single part with only the [Part.text][google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part.text] field set.
       * If you want to annotate the training phrase, you must create multiple
       * parts, where the fields of each part are populated in one of two ways:
       * -   `Part.text` is set to a part of the phrase that has no parameters.
       * -   `Part.text` is set to a part of the phrase that you want to annotate,
       *     and the `entity_type`, `alias`, and `user_defined` fields are all
       *     set.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part parts = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder removeParts(int index) {
        if (partsBuilder_ == null) {
          ensurePartsIsMutable();
          parts_.remove(index);
          onChanged();
        } else {
          partsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The ordered list of training phrase parts.
       * The parts are concatenated in order to form the training phrase.
       * Note: The API does not automatically annotate training phrases like the
       * Dialogflow Console does.
       * Note: Do not forget to include whitespace at part boundaries,
       * so the training phrase is well formatted when the parts are concatenated.
       * If the training phrase does not need to be annotated with parameters,
       * you just need a single part with only the [Part.text][google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part.text] field set.
       * If you want to annotate the training phrase, you must create multiple
       * parts, where the fields of each part are populated in one of two ways:
       * -   `Part.text` is set to a part of the phrase that has no parameters.
       * -   `Part.text` is set to a part of the phrase that you want to annotate,
       *     and the `entity_type`, `alias`, and `user_defined` fields are all
       *     set.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part parts = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part.Builder getPartsBuilder(
          int index) {
        return getPartsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Required. The ordered list of training phrase parts.
       * The parts are concatenated in order to form the training phrase.
       * Note: The API does not automatically annotate training phrases like the
       * Dialogflow Console does.
       * Note: Do not forget to include whitespace at part boundaries,
       * so the training phrase is well formatted when the parts are concatenated.
       * If the training phrase does not need to be annotated with parameters,
       * you just need a single part with only the [Part.text][google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part.text] field set.
       * If you want to annotate the training phrase, you must create multiple
       * parts, where the fields of each part are populated in one of two ways:
       * -   `Part.text` is set to a part of the phrase that has no parameters.
       * -   `Part.text` is set to a part of the phrase that you want to annotate,
       *     and the `entity_type`, `alias`, and `user_defined` fields are all
       *     set.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part parts = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.PartOrBuilder getPartsOrBuilder(
          int index) {
        if (partsBuilder_ == null) {
          return parts_.get(index);
        } else {
          return partsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The ordered list of training phrase parts.
       * The parts are concatenated in order to form the training phrase.
       * Note: The API does not automatically annotate training phrases like the
       * Dialogflow Console does.
       * Note: Do not forget to include whitespace at part boundaries,
       * so the training phrase is well formatted when the parts are concatenated.
       * If the training phrase does not need to be annotated with parameters,
       * you just need a single part with only the [Part.text][google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part.text] field set.
       * If you want to annotate the training phrase, you must create multiple
       * parts, where the fields of each part are populated in one of two ways:
       * -   `Part.text` is set to a part of the phrase that has no parameters.
       * -   `Part.text` is set to a part of the phrase that you want to annotate,
       *     and the `entity_type`, `alias`, and `user_defined` fields are all
       *     set.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part parts = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public java.util.List<
              ? extends com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.PartOrBuilder>
          getPartsOrBuilderList() {
        if (partsBuilder_ != null) {
          return partsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(parts_);
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The ordered list of training phrase parts.
       * The parts are concatenated in order to form the training phrase.
       * Note: The API does not automatically annotate training phrases like the
       * Dialogflow Console does.
       * Note: Do not forget to include whitespace at part boundaries,
       * so the training phrase is well formatted when the parts are concatenated.
       * If the training phrase does not need to be annotated with parameters,
       * you just need a single part with only the [Part.text][google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part.text] field set.
       * If you want to annotate the training phrase, you must create multiple
       * parts, where the fields of each part are populated in one of two ways:
       * -   `Part.text` is set to a part of the phrase that has no parameters.
       * -   `Part.text` is set to a part of the phrase that you want to annotate,
       *     and the `entity_type`, `alias`, and `user_defined` fields are all
       *     set.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part parts = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part.Builder addPartsBuilder() {
        return getPartsFieldBuilder()
            .addBuilder(
                com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Required. The ordered list of training phrase parts.
       * The parts are concatenated in order to form the training phrase.
       * Note: The API does not automatically annotate training phrases like the
       * Dialogflow Console does.
       * Note: Do not forget to include whitespace at part boundaries,
       * so the training phrase is well formatted when the parts are concatenated.
       * If the training phrase does not need to be annotated with parameters,
       * you just need a single part with only the [Part.text][google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part.text] field set.
       * If you want to annotate the training phrase, you must create multiple
       * parts, where the fields of each part are populated in one of two ways:
       * -   `Part.text` is set to a part of the phrase that has no parameters.
       * -   `Part.text` is set to a part of the phrase that you want to annotate,
       *     and the `entity_type`, `alias`, and `user_defined` fields are all
       *     set.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part parts = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part.Builder addPartsBuilder(
          int index) {
        return getPartsFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Required. The ordered list of training phrase parts.
       * The parts are concatenated in order to form the training phrase.
       * Note: The API does not automatically annotate training phrases like the
       * Dialogflow Console does.
       * Note: Do not forget to include whitespace at part boundaries,
       * so the training phrase is well formatted when the parts are concatenated.
       * If the training phrase does not need to be annotated with parameters,
       * you just need a single part with only the [Part.text][google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part.text] field set.
       * If you want to annotate the training phrase, you must create multiple
       * parts, where the fields of each part are populated in one of two ways:
       * -   `Part.text` is set to a part of the phrase that has no parameters.
       * -   `Part.text` is set to a part of the phrase that you want to annotate,
       *     and the `entity_type`, `alias`, and `user_defined` fields are all
       *     set.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part parts = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public java.util.List<com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part.Builder>
          getPartsBuilderList() {
        return getPartsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part,
              com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part.Builder,
              com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.PartOrBuilder>
          getPartsFieldBuilder() {
        if (partsBuilder_ == null) {
          partsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part,
                  com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part.Builder,
                  com.google.cloud.dialogflow.v2.Intent.TrainingPhrase.PartOrBuilder>(
                  parts_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
          parts_ = null;
        }
        return partsBuilder_;
      }

      private int timesAddedCount_;
      /**
       *
       *
       * <pre>
       * Optional. Indicates how many times this example was added to
       * the intent. Each time a developer adds an existing sample by editing an
       * intent or training, this counter is increased.
       * </pre>
       *
       * <code>int32 times_added_count = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The timesAddedCount.
       */
      @java.lang.Override
      public int getTimesAddedCount() {
        return timesAddedCount_;
      }
      /**
       *
       *
       * <pre>
       * Optional. Indicates how many times this example was added to
       * the intent. Each time a developer adds an existing sample by editing an
       * intent or training, this counter is increased.
       * </pre>
       *
       * <code>int32 times_added_count = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The timesAddedCount to set.
       * @return This builder for chaining.
       */
      public Builder setTimesAddedCount(int value) {

        timesAddedCount_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Indicates how many times this example was added to
       * the intent. Each time a developer adds an existing sample by editing an
       * intent or training, this counter is increased.
       * </pre>
       *
       * <code>int32 times_added_count = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTimesAddedCount() {

        timesAddedCount_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2.Intent.TrainingPhrase)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2.Intent.TrainingPhrase)
    private static final com.google.cloud.dialogflow.v2.Intent.TrainingPhrase DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2.Intent.TrainingPhrase();
    }

    public static com.google.cloud.dialogflow.v2.Intent.TrainingPhrase getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<TrainingPhrase> PARSER =
        new com.google.protobuf.AbstractParser<TrainingPhrase>() {
          @java.lang.Override
          public TrainingPhrase parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new TrainingPhrase(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<TrainingPhrase> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<TrainingPhrase> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.Intent.TrainingPhrase getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ParameterOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.v2.Intent.Parameter)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The unique identifier of this parameter.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    java.lang.String getName();
    /**
     *
     *
     * <pre>
     * The unique identifier of this parameter.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString getNameBytes();

    /**
     *
     *
     * <pre>
     * Required. The name of the parameter.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The displayName.
     */
    java.lang.String getDisplayName();
    /**
     *
     *
     * <pre>
     * Required. The name of the parameter.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The bytes for displayName.
     */
    com.google.protobuf.ByteString getDisplayNameBytes();

    /**
     *
     *
     * <pre>
     * Optional. The definition of the parameter value. It can be:
     * - a constant string,
     * - a parameter value defined as `$parameter_name`,
     * - an original parameter value defined as `$parameter_name.original`,
     * - a parameter value from some context defined as
     *   `#context_name.parameter_name`.
     * </pre>
     *
     * <code>string value = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The value.
     */
    java.lang.String getValue();
    /**
     *
     *
     * <pre>
     * Optional. The definition of the parameter value. It can be:
     * - a constant string,
     * - a parameter value defined as `$parameter_name`,
     * - an original parameter value defined as `$parameter_name.original`,
     * - a parameter value from some context defined as
     *   `#context_name.parameter_name`.
     * </pre>
     *
     * <code>string value = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for value.
     */
    com.google.protobuf.ByteString getValueBytes();

    /**
     *
     *
     * <pre>
     * Optional. The default value to use when the `value` yields an empty
     * result.
     * Default values can be extracted from contexts by using the following
     * syntax: `#context_name.parameter_name`.
     * </pre>
     *
     * <code>string default_value = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The defaultValue.
     */
    java.lang.String getDefaultValue();
    /**
     *
     *
     * <pre>
     * Optional. The default value to use when the `value` yields an empty
     * result.
     * Default values can be extracted from contexts by using the following
     * syntax: `#context_name.parameter_name`.
     * </pre>
     *
     * <code>string default_value = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for defaultValue.
     */
    com.google.protobuf.ByteString getDefaultValueBytes();

    /**
     *
     *
     * <pre>
     * Optional. The name of the entity type, prefixed with `&#64;`, that
     * describes values of the parameter. If the parameter is
     * required, this must be provided.
     * </pre>
     *
     * <code>string entity_type_display_name = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The entityTypeDisplayName.
     */
    java.lang.String getEntityTypeDisplayName();
    /**
     *
     *
     * <pre>
     * Optional. The name of the entity type, prefixed with `&#64;`, that
     * describes values of the parameter. If the parameter is
     * required, this must be provided.
     * </pre>
     *
     * <code>string entity_type_display_name = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for entityTypeDisplayName.
     */
    com.google.protobuf.ByteString getEntityTypeDisplayNameBytes();

    /**
     *
     *
     * <pre>
     * Optional. Indicates whether the parameter is required. That is,
     * whether the intent cannot be completed without collecting the parameter
     * value.
     * </pre>
     *
     * <code>bool mandatory = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The mandatory.
     */
    boolean getMandatory();

    /**
     *
     *
     * <pre>
     * Optional. The collection of prompts that the agent can present to the
     * user in order to collect a value for the parameter.
     * </pre>
     *
     * <code>repeated string prompts = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the prompts.
     */
    java.util.List<java.lang.String> getPromptsList();
    /**
     *
     *
     * <pre>
     * Optional. The collection of prompts that the agent can present to the
     * user in order to collect a value for the parameter.
     * </pre>
     *
     * <code>repeated string prompts = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of prompts.
     */
    int getPromptsCount();
    /**
     *
     *
     * <pre>
     * Optional. The collection of prompts that the agent can present to the
     * user in order to collect a value for the parameter.
     * </pre>
     *
     * <code>repeated string prompts = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The prompts at the given index.
     */
    java.lang.String getPrompts(int index);
    /**
     *
     *
     * <pre>
     * Optional. The collection of prompts that the agent can present to the
     * user in order to collect a value for the parameter.
     * </pre>
     *
     * <code>repeated string prompts = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the prompts at the given index.
     */
    com.google.protobuf.ByteString getPromptsBytes(int index);

    /**
     *
     *
     * <pre>
     * Optional. Indicates whether the parameter represents a list of values.
     * </pre>
     *
     * <code>bool is_list = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The isList.
     */
    boolean getIsList();
  }
  /**
   *
   *
   * <pre>
   * Represents intent parameters.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2.Intent.Parameter}
   */
  public static final class Parameter extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2.Intent.Parameter)
      ParameterOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Parameter.newBuilder() to construct.
    private Parameter(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Parameter() {
      name_ = "";
      displayName_ = "";
      value_ = "";
      defaultValue_ = "";
      entityTypeDisplayName_ = "";
      prompts_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Parameter();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private Parameter(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();

                name_ = s;
                break;
              }
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();

                displayName_ = s;
                break;
              }
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();

                value_ = s;
                break;
              }
            case 34:
              {
                java.lang.String s = input.readStringRequireUtf8();

                defaultValue_ = s;
                break;
              }
            case 42:
              {
                java.lang.String s = input.readStringRequireUtf8();

                entityTypeDisplayName_ = s;
                break;
              }
            case 48:
              {
                mandatory_ = input.readBool();
                break;
              }
            case 58:
              {
                java.lang.String s = input.readStringRequireUtf8();
                if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                  prompts_ = new com.google.protobuf.LazyStringArrayList();
                  mutable_bitField0_ |= 0x00000001;
                }
                prompts_.add(s);
                break;
              }
            case 64:
              {
                isList_ = input.readBool();
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000001) != 0)) {
          prompts_ = prompts_.getUnmodifiableView();
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2.IntentProto
          .internal_static_google_cloud_dialogflow_v2_Intent_Parameter_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2.IntentProto
          .internal_static_google_cloud_dialogflow_v2_Intent_Parameter_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2.Intent.Parameter.class,
              com.google.cloud.dialogflow.v2.Intent.Parameter.Builder.class);
    }

    public static final int NAME_FIELD_NUMBER = 1;
    private volatile java.lang.Object name_;
    /**
     *
     *
     * <pre>
     * The unique identifier of this parameter.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of this parameter.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DISPLAY_NAME_FIELD_NUMBER = 2;
    private volatile java.lang.Object displayName_;
    /**
     *
     *
     * <pre>
     * Required. The name of the parameter.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The displayName.
     */
    @java.lang.Override
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the parameter.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The bytes for displayName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int VALUE_FIELD_NUMBER = 3;
    private volatile java.lang.Object value_;
    /**
     *
     *
     * <pre>
     * Optional. The definition of the parameter value. It can be:
     * - a constant string,
     * - a parameter value defined as `$parameter_name`,
     * - an original parameter value defined as `$parameter_name.original`,
     * - a parameter value from some context defined as
     *   `#context_name.parameter_name`.
     * </pre>
     *
     * <code>string value = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The value.
     */
    @java.lang.Override
    public java.lang.String getValue() {
      java.lang.Object ref = value_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        value_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The definition of the parameter value. It can be:
     * - a constant string,
     * - a parameter value defined as `$parameter_name`,
     * - an original parameter value defined as `$parameter_name.original`,
     * - a parameter value from some context defined as
     *   `#context_name.parameter_name`.
     * </pre>
     *
     * <code>string value = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for value.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getValueBytes() {
      java.lang.Object ref = value_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        value_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DEFAULT_VALUE_FIELD_NUMBER = 4;
    private volatile java.lang.Object defaultValue_;
    /**
     *
     *
     * <pre>
     * Optional. The default value to use when the `value` yields an empty
     * result.
     * Default values can be extracted from contexts by using the following
     * syntax: `#context_name.parameter_name`.
     * </pre>
     *
     * <code>string default_value = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The defaultValue.
     */
    @java.lang.Override
    public java.lang.String getDefaultValue() {
      java.lang.Object ref = defaultValue_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        defaultValue_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The default value to use when the `value` yields an empty
     * result.
     * Default values can be extracted from contexts by using the following
     * syntax: `#context_name.parameter_name`.
     * </pre>
     *
     * <code>string default_value = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for defaultValue.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDefaultValueBytes() {
      java.lang.Object ref = defaultValue_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        defaultValue_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ENTITY_TYPE_DISPLAY_NAME_FIELD_NUMBER = 5;
    private volatile java.lang.Object entityTypeDisplayName_;
    /**
     *
     *
     * <pre>
     * Optional. The name of the entity type, prefixed with `&#64;`, that
     * describes values of the parameter. If the parameter is
     * required, this must be provided.
     * </pre>
     *
     * <code>string entity_type_display_name = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The entityTypeDisplayName.
     */
    @java.lang.Override
    public java.lang.String getEntityTypeDisplayName() {
      java.lang.Object ref = entityTypeDisplayName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        entityTypeDisplayName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of the entity type, prefixed with `&#64;`, that
     * describes values of the parameter. If the parameter is
     * required, this must be provided.
     * </pre>
     *
     * <code>string entity_type_display_name = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for entityTypeDisplayName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getEntityTypeDisplayNameBytes() {
      java.lang.Object ref = entityTypeDisplayName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        entityTypeDisplayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int MANDATORY_FIELD_NUMBER = 6;
    private boolean mandatory_;
    /**
     *
     *
     * <pre>
     * Optional. Indicates whether the parameter is required. That is,
     * whether the intent cannot be completed without collecting the parameter
     * value.
     * </pre>
     *
     * <code>bool mandatory = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The mandatory.
     */
    @java.lang.Override
    public boolean getMandatory() {
      return mandatory_;
    }

    public static final int PROMPTS_FIELD_NUMBER = 7;
    private com.google.protobuf.LazyStringList prompts_;
    /**
     *
     *
     * <pre>
     * Optional. The collection of prompts that the agent can present to the
     * user in order to collect a value for the parameter.
     * </pre>
     *
     * <code>repeated string prompts = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the prompts.
     */
    public com.google.protobuf.ProtocolStringList getPromptsList() {
      return prompts_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The collection of prompts that the agent can present to the
     * user in order to collect a value for the parameter.
     * </pre>
     *
     * <code>repeated string prompts = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of prompts.
     */
    public int getPromptsCount() {
      return prompts_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. The collection of prompts that the agent can present to the
     * user in order to collect a value for the parameter.
     * </pre>
     *
     * <code>repeated string prompts = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The prompts at the given index.
     */
    public java.lang.String getPrompts(int index) {
      return prompts_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. The collection of prompts that the agent can present to the
     * user in order to collect a value for the parameter.
     * </pre>
     *
     * <code>repeated string prompts = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the prompts at the given index.
     */
    public com.google.protobuf.ByteString getPromptsBytes(int index) {
      return prompts_.getByteString(index);
    }

    public static final int IS_LIST_FIELD_NUMBER = 8;
    private boolean isList_;
    /**
     *
     *
     * <pre>
     * Optional. Indicates whether the parameter represents a list of values.
     * </pre>
     *
     * <code>bool is_list = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The isList.
     */
    @java.lang.Override
    public boolean getIsList() {
      return isList_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!getNameBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
      }
      if (!getDisplayNameBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
      }
      if (!getValueBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, value_);
      }
      if (!getDefaultValueBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, defaultValue_);
      }
      if (!getEntityTypeDisplayNameBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, entityTypeDisplayName_);
      }
      if (mandatory_ != false) {
        output.writeBool(6, mandatory_);
      }
      for (int i = 0; i < prompts_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 7, prompts_.getRaw(i));
      }
      if (isList_ != false) {
        output.writeBool(8, isList_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getNameBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
      }
      if (!getDisplayNameBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
      }
      if (!getValueBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, value_);
      }
      if (!getDefaultValueBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, defaultValue_);
      }
      if (!getEntityTypeDisplayNameBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, entityTypeDisplayName_);
      }
      if (mandatory_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(6, mandatory_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < prompts_.size(); i++) {
          dataSize += computeStringSizeNoTag(prompts_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getPromptsList().size();
      }
      if (isList_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(8, isList_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dialogflow.v2.Intent.Parameter)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.v2.Intent.Parameter other =
          (com.google.cloud.dialogflow.v2.Intent.Parameter) obj;

      if (!getName().equals(other.getName())) return false;
      if (!getDisplayName().equals(other.getDisplayName())) return false;
      if (!getValue().equals(other.getValue())) return false;
      if (!getDefaultValue().equals(other.getDefaultValue())) return false;
      if (!getEntityTypeDisplayName().equals(other.getEntityTypeDisplayName())) return false;
      if (getMandatory() != other.getMandatory()) return false;
      if (!getPromptsList().equals(other.getPromptsList())) return false;
      if (getIsList() != other.getIsList()) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getDisplayName().hashCode();
      hash = (37 * hash) + VALUE_FIELD_NUMBER;
      hash = (53 * hash) + getValue().hashCode();
      hash = (37 * hash) + DEFAULT_VALUE_FIELD_NUMBER;
      hash = (53 * hash) + getDefaultValue().hashCode();
      hash = (37 * hash) + ENTITY_TYPE_DISPLAY_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getEntityTypeDisplayName().hashCode();
      hash = (37 * hash) + MANDATORY_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getMandatory());
      if (getPromptsCount() > 0) {
        hash = (37 * hash) + PROMPTS_FIELD_NUMBER;
        hash = (53 * hash) + getPromptsList().hashCode();
      }
      hash = (37 * hash) + IS_LIST_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIsList());
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.v2.Intent.Parameter parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.v2.Intent.Parameter parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2.Intent.Parameter parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.v2.Intent.Parameter parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2.Intent.Parameter parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.v2.Intent.Parameter parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2.Intent.Parameter parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.v2.Intent.Parameter parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2.Intent.Parameter parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.v2.Intent.Parameter parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2.Intent.Parameter parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.v2.Intent.Parameter parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.cloud.dialogflow.v2.Intent.Parameter prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Represents intent parameters.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.v2.Intent.Parameter}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2.Intent.Parameter)
        com.google.cloud.dialogflow.v2.Intent.ParameterOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.v2.IntentProto
            .internal_static_google_cloud_dialogflow_v2_Intent_Parameter_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.v2.IntentProto
            .internal_static_google_cloud_dialogflow_v2_Intent_Parameter_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.v2.Intent.Parameter.class,
                com.google.cloud.dialogflow.v2.Intent.Parameter.Builder.class);
      }

      // Construct using com.google.cloud.dialogflow.v2.Intent.Parameter.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        name_ = "";

        displayName_ = "";

        value_ = "";

        defaultValue_ = "";

        entityTypeDisplayName_ = "";

        mandatory_ = false;

        prompts_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000001);
        isList_ = false;

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.v2.IntentProto
            .internal_static_google_cloud_dialogflow_v2_Intent_Parameter_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2.Intent.Parameter getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.v2.Intent.Parameter.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2.Intent.Parameter build() {
        com.google.cloud.dialogflow.v2.Intent.Parameter result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2.Intent.Parameter buildPartial() {
        com.google.cloud.dialogflow.v2.Intent.Parameter result =
            new com.google.cloud.dialogflow.v2.Intent.Parameter(this);
        int from_bitField0_ = bitField0_;
        result.name_ = name_;
        result.displayName_ = displayName_;
        result.value_ = value_;
        result.defaultValue_ = defaultValue_;
        result.entityTypeDisplayName_ = entityTypeDisplayName_;
        result.mandatory_ = mandatory_;
        if (((bitField0_ & 0x00000001) != 0)) {
          prompts_ = prompts_.getUnmodifiableView();
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.prompts_ = prompts_;
        result.isList_ = isList_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dialogflow.v2.Intent.Parameter) {
          return mergeFrom((com.google.cloud.dialogflow.v2.Intent.Parameter) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.dialogflow.v2.Intent.Parameter other) {
        if (other == com.google.cloud.dialogflow.v2.Intent.Parameter.getDefaultInstance())
          return this;
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          onChanged();
        }
        if (!other.getDisplayName().isEmpty()) {
          displayName_ = other.displayName_;
          onChanged();
        }
        if (!other.getValue().isEmpty()) {
          value_ = other.value_;
          onChanged();
        }
        if (!other.getDefaultValue().isEmpty()) {
          defaultValue_ = other.defaultValue_;
          onChanged();
        }
        if (!other.getEntityTypeDisplayName().isEmpty()) {
          entityTypeDisplayName_ = other.entityTypeDisplayName_;
          onChanged();
        }
        if (other.getMandatory() != false) {
          setMandatory(other.getMandatory());
        }
        if (!other.prompts_.isEmpty()) {
          if (prompts_.isEmpty()) {
            prompts_ = other.prompts_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensurePromptsIsMutable();
            prompts_.addAll(other.prompts_);
          }
          onChanged();
        }
        if (other.getIsList() != false) {
          setIsList(other.getIsList());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.dialogflow.v2.Intent.Parameter parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.dialogflow.v2.Intent.Parameter) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private java.lang.Object name_ = "";
      /**
       *
       *
       * <pre>
       * The unique identifier of this parameter.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The unique identifier of this parameter.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The unique identifier of this parameter.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        name_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The unique identifier of this parameter.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearName() {

        name_ = getDefaultInstance().getName();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The unique identifier of this parameter.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        name_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object displayName_ = "";
      /**
       *
       *
       * <pre>
       * Required. The name of the parameter.
       * </pre>
       *
       * <code>string display_name = 2;</code>
       *
       * @return The displayName.
       */
      public java.lang.String getDisplayName() {
        java.lang.Object ref = displayName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          displayName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The name of the parameter.
       * </pre>
       *
       * <code>string display_name = 2;</code>
       *
       * @return The bytes for displayName.
       */
      public com.google.protobuf.ByteString getDisplayNameBytes() {
        java.lang.Object ref = displayName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          displayName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The name of the parameter.
       * </pre>
       *
       * <code>string display_name = 2;</code>
       *
       * @param value The displayName to set.
       * @return This builder for chaining.
       */
      public Builder setDisplayName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        displayName_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The name of the parameter.
       * </pre>
       *
       * <code>string display_name = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDisplayName() {

        displayName_ = getDefaultInstance().getDisplayName();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The name of the parameter.
       * </pre>
       *
       * <code>string display_name = 2;</code>
       *
       * @param value The bytes for displayName to set.
       * @return This builder for chaining.
       */
      public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        displayName_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object value_ = "";
      /**
       *
       *
       * <pre>
       * Optional. The definition of the parameter value. It can be:
       * - a constant string,
       * - a parameter value defined as `$parameter_name`,
       * - an original parameter value defined as `$parameter_name.original`,
       * - a parameter value from some context defined as
       *   `#context_name.parameter_name`.
       * </pre>
       *
       * <code>string value = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The value.
       */
      public java.lang.String getValue() {
        java.lang.Object ref = value_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          value_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The definition of the parameter value. It can be:
       * - a constant string,
       * - a parameter value defined as `$parameter_name`,
       * - an original parameter value defined as `$parameter_name.original`,
       * - a parameter value from some context defined as
       *   `#context_name.parameter_name`.
       * </pre>
       *
       * <code>string value = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for value.
       */
      public com.google.protobuf.ByteString getValueBytes() {
        java.lang.Object ref = value_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          value_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The definition of the parameter value. It can be:
       * - a constant string,
       * - a parameter value defined as `$parameter_name`,
       * - an original parameter value defined as `$parameter_name.original`,
       * - a parameter value from some context defined as
       *   `#context_name.parameter_name`.
       * </pre>
       *
       * <code>string value = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The value to set.
       * @return This builder for chaining.
       */
      public Builder setValue(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        value_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The definition of the parameter value. It can be:
       * - a constant string,
       * - a parameter value defined as `$parameter_name`,
       * - an original parameter value defined as `$parameter_name.original`,
       * - a parameter value from some context defined as
       *   `#context_name.parameter_name`.
       * </pre>
       *
       * <code>string value = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearValue() {

        value_ = getDefaultInstance().getValue();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The definition of the parameter value. It can be:
       * - a constant string,
       * - a parameter value defined as `$parameter_name`,
       * - an original parameter value defined as `$parameter_name.original`,
       * - a parameter value from some context defined as
       *   `#context_name.parameter_name`.
       * </pre>
       *
       * <code>string value = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for value to set.
       * @return This builder for chaining.
       */
      public Builder setValueBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        value_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object defaultValue_ = "";
      /**
       *
       *
       * <pre>
       * Optional. The default value to use when the `value` yields an empty
       * result.
       * Default values can be extracted from contexts by using the following
       * syntax: `#context_name.parameter_name`.
       * </pre>
       *
       * <code>string default_value = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The defaultValue.
       */
      public java.lang.String getDefaultValue() {
        java.lang.Object ref = defaultValue_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          defaultValue_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The default value to use when the `value` yields an empty
       * result.
       * Default values can be extracted from contexts by using the following
       * syntax: `#context_name.parameter_name`.
       * </pre>
       *
       * <code>string default_value = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for defaultValue.
       */
      public com.google.protobuf.ByteString getDefaultValueBytes() {
        java.lang.Object ref = defaultValue_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          defaultValue_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The default value to use when the `value` yields an empty
       * result.
       * Default values can be extracted from contexts by using the following
       * syntax: `#context_name.parameter_name`.
       * </pre>
       *
       * <code>string default_value = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The defaultValue to set.
       * @return This builder for chaining.
       */
      public Builder setDefaultValue(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        defaultValue_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The default value to use when the `value` yields an empty
       * result.
       * Default values can be extracted from contexts by using the following
       * syntax: `#context_name.parameter_name`.
       * </pre>
       *
       * <code>string default_value = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDefaultValue() {

        defaultValue_ = getDefaultInstance().getDefaultValue();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The default value to use when the `value` yields an empty
       * result.
       * Default values can be extracted from contexts by using the following
       * syntax: `#context_name.parameter_name`.
       * </pre>
       *
       * <code>string default_value = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for defaultValue to set.
       * @return This builder for chaining.
       */
      public Builder setDefaultValueBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        defaultValue_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object entityTypeDisplayName_ = "";
      /**
       *
       *
       * <pre>
       * Optional. The name of the entity type, prefixed with `&#64;`, that
       * describes values of the parameter. If the parameter is
       * required, this must be provided.
       * </pre>
       *
       * <code>string entity_type_display_name = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The entityTypeDisplayName.
       */
      public java.lang.String getEntityTypeDisplayName() {
        java.lang.Object ref = entityTypeDisplayName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          entityTypeDisplayName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The name of the entity type, prefixed with `&#64;`, that
       * describes values of the parameter. If the parameter is
       * required, this must be provided.
       * </pre>
       *
       * <code>string entity_type_display_name = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for entityTypeDisplayName.
       */
      public com.google.protobuf.ByteString getEntityTypeDisplayNameBytes() {
        java.lang.Object ref = entityTypeDisplayName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          entityTypeDisplayName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The name of the entity type, prefixed with `&#64;`, that
       * describes values of the parameter. If the parameter is
       * required, this must be provided.
       * </pre>
       *
       * <code>string entity_type_display_name = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The entityTypeDisplayName to set.
       * @return This builder for chaining.
       */
      public Builder setEntityTypeDisplayName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        entityTypeDisplayName_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The name of the entity type, prefixed with `&#64;`, that
       * describes values of the parameter. If the parameter is
       * required, this must be provided.
       * </pre>
       *
       * <code>string entity_type_display_name = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEntityTypeDisplayName() {

        entityTypeDisplayName_ = getDefaultInstance().getEntityTypeDisplayName();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The name of the entity type, prefixed with `&#64;`, that
       * describes values of the parameter. If the parameter is
       * required, this must be provided.
       * </pre>
       *
       * <code>string entity_type_display_name = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for entityTypeDisplayName to set.
       * @return This builder for chaining.
       */
      public Builder setEntityTypeDisplayNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        entityTypeDisplayName_ = value;
        onChanged();
        return this;
      }

      private boolean mandatory_;
      /**
       *
       *
       * <pre>
       * Optional. Indicates whether the parameter is required. That is,
       * whether the intent cannot be completed without collecting the parameter
       * value.
       * </pre>
       *
       * <code>bool mandatory = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The mandatory.
       */
      @java.lang.Override
      public boolean getMandatory() {
        return mandatory_;
      }
      /**
       *
       *
       * <pre>
       * Optional. Indicates whether the parameter is required. That is,
       * whether the intent cannot be completed without collecting the parameter
       * value.
       * </pre>
       *
       * <code>bool mandatory = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The mandatory to set.
       * @return This builder for chaining.
       */
      public Builder setMandatory(boolean value) {

        mandatory_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Indicates whether the parameter is required. That is,
       * whether the intent cannot be completed without collecting the parameter
       * value.
       * </pre>
       *
       * <code>bool mandatory = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMandatory() {

        mandatory_ = false;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringList prompts_ =
          com.google.protobuf.LazyStringArrayList.EMPTY;

      private void ensurePromptsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          prompts_ = new com.google.protobuf.LazyStringArrayList(prompts_);
          bitField0_ |= 0x00000001;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The collection of prompts that the agent can present to the
       * user in order to collect a value for the parameter.
       * </pre>
       *
       * <code>repeated string prompts = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return A list containing the prompts.
       */
      public com.google.protobuf.ProtocolStringList getPromptsList() {
        return prompts_.getUnmodifiableView();
      }
      /**
       *
       *
       * <pre>
       * Optional. The collection of prompts that the agent can present to the
       * user in order to collect a value for the parameter.
       * </pre>
       *
       * <code>repeated string prompts = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The count of prompts.
       */
      public int getPromptsCount() {
        return prompts_.size();
      }
      /**
       *
       *
       * <pre>
       * Optional. The collection of prompts that the agent can present to the
       * user in order to collect a value for the parameter.
       * </pre>
       *
       * <code>repeated string prompts = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the element to return.
       * @return The prompts at the given index.
       */
      public java.lang.String getPrompts(int index) {
        return prompts_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Optional. The collection of prompts that the agent can present to the
       * user in order to collect a value for the parameter.
       * </pre>
       *
       * <code>repeated string prompts = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the prompts at the given index.
       */
      public com.google.protobuf.ByteString getPromptsBytes(int index) {
        return prompts_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * Optional. The collection of prompts that the agent can present to the
       * user in order to collect a value for the parameter.
       * </pre>
       *
       * <code>repeated string prompts = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index to set the value at.
       * @param value The prompts to set.
       * @return This builder for chaining.
       */
      public Builder setPrompts(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePromptsIsMutable();
        prompts_.set(index, value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The collection of prompts that the agent can present to the
       * user in order to collect a value for the parameter.
       * </pre>
       *
       * <code>repeated string prompts = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The prompts to add.
       * @return This builder for chaining.
       */
      public Builder addPrompts(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePromptsIsMutable();
        prompts_.add(value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The collection of prompts that the agent can present to the
       * user in order to collect a value for the parameter.
       * </pre>
       *
       * <code>repeated string prompts = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param values The prompts to add.
       * @return This builder for chaining.
       */
      public Builder addAllPrompts(java.lang.Iterable<java.lang.String> values) {
        ensurePromptsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, prompts_);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The collection of prompts that the agent can present to the
       * user in order to collect a value for the parameter.
       * </pre>
       *
       * <code>repeated string prompts = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPrompts() {
        prompts_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The collection of prompts that the agent can present to the
       * user in order to collect a value for the parameter.
       * </pre>
       *
       * <code>repeated string prompts = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes of the prompts to add.
       * @return This builder for chaining.
       */
      public Builder addPromptsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensurePromptsIsMutable();
        prompts_.add(value);
        onChanged();
        return this;
      }

      private boolean isList_;
      /**
       *
       *
       * <pre>
       * Optional. Indicates whether the parameter represents a list of values.
       * </pre>
       *
       * <code>bool is_list = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The isList.
       */
      @java.lang.Override
      public boolean getIsList() {
        return isList_;
      }
      /**
       *
       *
       * <pre>
       * Optional. Indicates whether the parameter represents a list of values.
       * </pre>
       *
       * <code>bool is_list = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The isList to set.
       * @return This builder for chaining.
       */
      public Builder setIsList(boolean value) {

        isList_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Indicates whether the parameter represents a list of values.
       * </pre>
       *
       * <code>bool is_list = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearIsList() {

        isList_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2.Intent.Parameter)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2.Intent.Parameter)
    private static final com.google.cloud.dialogflow.v2.Intent.Parameter DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2.Intent.Parameter();
    }

    public static com.google.cloud.dialogflow.v2.Intent.Parameter getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Parameter> PARSER =
        new com.google.protobuf.AbstractParser<Parameter>() {
          @java.lang.Override
          public Parameter parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new Parameter(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<Parameter> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Parameter> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.Intent.Parameter getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface MessageOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.v2.Intent.Message)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The text response.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.Intent.Message.Text text = 1;</code>
     *
     * @return Whether the text field is set.
     */
    boolean hasText();
    /**
     *
     *
     * <pre>
     * The text response.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.Intent.Message.Text text = 1;</code>
     *
     * @return The text.
     */
    com.google.cloud.dialogflow.v2.Intent.Message.Text getText();
    /**
     *
     *
     * <pre>
     * The text response.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.Intent.Message.Text text = 1;</code>
     */
    com.google.cloud.dialogflow.v2.Intent.Message.TextOrBuilder getTextOrBuilder();

    /**
     *
     *
     * <pre>
     * The image response.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.Intent.Message.Image image = 2;</code>
     *
     * @return Whether the image field is set.
     */
    boolean hasImage();
    /**
     *
     *
     * <pre>
     * The image response.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.Intent.Message.Image image = 2;</code>
     *
     * @return The image.
     */
    com.google.cloud.dialogflow.v2.Intent.Message.Image getImage();
    /**
     *
     *
     * <pre>
     * The image response.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.Intent.Message.Image image = 2;</code>
     */
    com.google.cloud.dialogflow.v2.Intent.Message.ImageOrBuilder getImageOrBuilder();

    /**
     *
     *
     * <pre>
     * The quick replies response.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.Intent.Message.QuickReplies quick_replies = 3;</code>
     *
     * @return Whether the quickReplies field is set.
     */
    boolean hasQuickReplies();
    /**
     *
     *
     * <pre>
     * The quick replies response.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.Intent.Message.QuickReplies quick_replies = 3;</code>
     *
     * @return The quickReplies.
     */
    com.google.cloud.dialogflow.v2.Intent.Message.QuickReplies getQuickReplies();
    /**
     *
     *
     * <pre>
     * The quick replies response.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.Intent.Message.QuickReplies quick_replies = 3;</code>
     */
    com.google.cloud.dialogflow.v2.Intent.Message.QuickRepliesOrBuilder getQuickRepliesOrBuilder();

    /**
     *
     *
     * <pre>
     * The card response.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.Intent.Message.Card card = 4;</code>
     *
     * @return Whether the card field is set.
     */
    boolean hasCard();
    /**
     *
     *
     * <pre>
     * The card response.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.Intent.Message.Card card = 4;</code>
     *
     * @return The card.
     */
    com.google.cloud.dialogflow.v2.Intent.Message.Card getCard();
    /**
     *
     *
     * <pre>
     * The card response.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.Intent.Message.Card card = 4;</code>
     */
    com.google.cloud.dialogflow.v2.Intent.Message.CardOrBuilder getCardOrBuilder();

    /**
     *
     *
     * <pre>
     * A custom platform-specific response.
     * </pre>
     *
     * <code>.google.protobuf.Struct payload = 5;</code>
     *
     * @return Whether the payload field is set.
     */
    boolean hasPayload();
    /**
     *
     *
     * <pre>
     * A custom platform-specific response.
     * </pre>
     *
     * <code>.google.protobuf.Struct payload = 5;</code>
     *
     * @return The payload.
     */
    com.google.protobuf.Struct getPayload();
    /**
     *
     *
     * <pre>
     * A custom platform-specific response.
     * </pre>
     *
     * <code>.google.protobuf.Struct payload = 5;</code>
     */
    com.google.protobuf.StructOrBuilder getPayloadOrBuilder();

    /**
     *
     *
     * <pre>
     * The voice and text-only responses for Actions on Google.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.Intent.Message.SimpleResponses simple_responses = 7;</code>
     *
     * @return Whether the simpleResponses field is set.
     */
    boolean hasSimpleResponses();
    /**
     *
     *
     * <pre>
     * The voice and text-only responses for Actions on Google.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.Intent.Message.SimpleResponses simple_responses = 7;</code>
     *
     * @return The simpleResponses.
     */
    com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponses getSimpleResponses();
    /**
     *
     *
     * <pre>
     * The voice and text-only responses for Actions on Google.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.Intent.Message.SimpleResponses simple_responses = 7;</code>
     */
    com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponsesOrBuilder
        getSimpleResponsesOrBuilder();

    /**
     *
     *
     * <pre>
     * The basic card response for Actions on Google.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.Intent.Message.BasicCard basic_card = 8;</code>
     *
     * @return Whether the basicCard field is set.
     */
    boolean hasBasicCard();
    /**
     *
     *
     * <pre>
     * The basic card response for Actions on Google.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.Intent.Message.BasicCard basic_card = 8;</code>
     *
     * @return The basicCard.
     */
    com.google.cloud.dialogflow.v2.Intent.Message.BasicCard getBasicCard();
    /**
     *
     *
     * <pre>
     * The basic card response for Actions on Google.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.Intent.Message.BasicCard basic_card = 8;</code>
     */
    com.google.cloud.dialogflow.v2.Intent.Message.BasicCardOrBuilder getBasicCardOrBuilder();

    /**
     *
     *
     * <pre>
     * The suggestion chips for Actions on Google.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.Intent.Message.Suggestions suggestions = 9;</code>
     *
     * @return Whether the suggestions field is set.
     */
    boolean hasSuggestions();
    /**
     *
     *
     * <pre>
     * The suggestion chips for Actions on Google.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.Intent.Message.Suggestions suggestions = 9;</code>
     *
     * @return The suggestions.
     */
    com.google.cloud.dialogflow.v2.Intent.Message.Suggestions getSuggestions();
    /**
     *
     *
     * <pre>
     * The suggestion chips for Actions on Google.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.Intent.Message.Suggestions suggestions = 9;</code>
     */
    com.google.cloud.dialogflow.v2.Intent.Message.SuggestionsOrBuilder getSuggestionsOrBuilder();

    /**
     *
     *
     * <pre>
     * The link out suggestion chip for Actions on Google.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.Intent.Message.LinkOutSuggestion link_out_suggestion = 10;
     * </code>
     *
     * @return Whether the linkOutSuggestion field is set.
     */
    boolean hasLinkOutSuggestion();
    /**
     *
     *
     * <pre>
     * The link out suggestion chip for Actions on Google.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.Intent.Message.LinkOutSuggestion link_out_suggestion = 10;
     * </code>
     *
     * @return The linkOutSuggestion.
     */
    com.google.cloud.dialogflow.v2.Intent.Message.LinkOutSuggestion getLinkOutSuggestion();
    /**
     *
     *
     * <pre>
     * The link out suggestion chip for Actions on Google.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.Intent.Message.LinkOutSuggestion link_out_suggestion = 10;
     * </code>
     */
    com.google.cloud.dialogflow.v2.Intent.Message.LinkOutSuggestionOrBuilder
        getLinkOutSuggestionOrBuilder();

    /**
     *
     *
     * <pre>
     * The list card response for Actions on Google.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.Intent.Message.ListSelect list_select = 11;</code>
     *
     * @return Whether the listSelect field is set.
     */
    boolean hasListSelect();
    /**
     *
     *
     * <pre>
     * The list card response for Actions on Google.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.Intent.Message.ListSelect list_select = 11;</code>
     *
     * @return The listSelect.
     */
    com.google.cloud.dialogflow.v2.Intent.Message.ListSelect getListSelect();
    /**
     *
     *
     * <pre>
     * The list card response for Actions on Google.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.Intent.Message.ListSelect list_select = 11;</code>
     */
    com.google.cloud.dialogflow.v2.Intent.Message.ListSelectOrBuilder getListSelectOrBuilder();

    /**
     *
     *
     * <pre>
     * The carousel card response for Actions on Google.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect carousel_select = 12;</code>
     *
     * @return Whether the carouselSelect field is set.
     */
    boolean hasCarouselSelect();
    /**
     *
     *
     * <pre>
     * The carousel card response for Actions on Google.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect carousel_select = 12;</code>
     *
     * @return The carouselSelect.
     */
    com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect getCarouselSelect();
    /**
     *
     *
     * <pre>
     * The carousel card response for Actions on Google.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect carousel_select = 12;</code>
     */
    com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelectOrBuilder
        getCarouselSelectOrBuilder();

    /**
     *
     *
     * <pre>
     * Browse carousel card for Actions on Google.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.Intent.Message.BrowseCarouselCard browse_carousel_card = 22;
     * </code>
     *
     * @return Whether the browseCarouselCard field is set.
     */
    boolean hasBrowseCarouselCard();
    /**
     *
     *
     * <pre>
     * Browse carousel card for Actions on Google.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.Intent.Message.BrowseCarouselCard browse_carousel_card = 22;
     * </code>
     *
     * @return The browseCarouselCard.
     */
    com.google.cloud.dialogflow.v2.Intent.Message.BrowseCarouselCard getBrowseCarouselCard();
    /**
     *
     *
     * <pre>
     * Browse carousel card for Actions on Google.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.Intent.Message.BrowseCarouselCard browse_carousel_card = 22;
     * </code>
     */
    com.google.cloud.dialogflow.v2.Intent.Message.BrowseCarouselCardOrBuilder
        getBrowseCarouselCardOrBuilder();

    /**
     *
     *
     * <pre>
     * Table card for Actions on Google.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.Intent.Message.TableCard table_card = 23;</code>
     *
     * @return Whether the tableCard field is set.
     */
    boolean hasTableCard();
    /**
     *
     *
     * <pre>
     * Table card for Actions on Google.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.Intent.Message.TableCard table_card = 23;</code>
     *
     * @return The tableCard.
     */
    com.google.cloud.dialogflow.v2.Intent.Message.TableCard getTableCard();
    /**
     *
     *
     * <pre>
     * Table card for Actions on Google.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.Intent.Message.TableCard table_card = 23;</code>
     */
    com.google.cloud.dialogflow.v2.Intent.Message.TableCardOrBuilder getTableCardOrBuilder();

    /**
     *
     *
     * <pre>
     * The media content card for Actions on Google.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.Intent.Message.MediaContent media_content = 24;</code>
     *
     * @return Whether the mediaContent field is set.
     */
    boolean hasMediaContent();
    /**
     *
     *
     * <pre>
     * The media content card for Actions on Google.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.Intent.Message.MediaContent media_content = 24;</code>
     *
     * @return The mediaContent.
     */
    com.google.cloud.dialogflow.v2.Intent.Message.MediaContent getMediaContent();
    /**
     *
     *
     * <pre>
     * The media content card for Actions on Google.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.Intent.Message.MediaContent media_content = 24;</code>
     */
    com.google.cloud.dialogflow.v2.Intent.Message.MediaContentOrBuilder getMediaContentOrBuilder();

    /**
     *
     *
     * <pre>
     * Optional. The platform that this message is intended for.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.Intent.Message.Platform platform = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for platform.
     */
    int getPlatformValue();
    /**
     *
     *
     * <pre>
     * Optional. The platform that this message is intended for.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.Intent.Message.Platform platform = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The platform.
     */
    com.google.cloud.dialogflow.v2.Intent.Message.Platform getPlatform();

    public com.google.cloud.dialogflow.v2.Intent.Message.MessageCase getMessageCase();
  }
  /**
   *
   *
   * <pre>
   * A rich response message.
   * Corresponds to the intent `Response` field in the Dialogflow console.
   * For more information, see
   * [Rich response
   * messages](https://cloud.google.com/dialogflow/docs/intents-rich-messages).
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2.Intent.Message}
   */
  public static final class Message extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2.Intent.Message)
      MessageOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Message.newBuilder() to construct.
    private Message(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Message() {
      platform_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Message();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private Message(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.dialogflow.v2.Intent.Message.Text.Builder subBuilder = null;
                if (messageCase_ == 1) {
                  subBuilder =
                      ((com.google.cloud.dialogflow.v2.Intent.Message.Text) message_).toBuilder();
                }
                message_ =
                    input.readMessage(
                        com.google.cloud.dialogflow.v2.Intent.Message.Text.parser(),
                        extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(
                      (com.google.cloud.dialogflow.v2.Intent.Message.Text) message_);
                  message_ = subBuilder.buildPartial();
                }
                messageCase_ = 1;
                break;
              }
            case 18:
              {
                com.google.cloud.dialogflow.v2.Intent.Message.Image.Builder subBuilder = null;
                if (messageCase_ == 2) {
                  subBuilder =
                      ((com.google.cloud.dialogflow.v2.Intent.Message.Image) message_).toBuilder();
                }
                message_ =
                    input.readMessage(
                        com.google.cloud.dialogflow.v2.Intent.Message.Image.parser(),
                        extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(
                      (com.google.cloud.dialogflow.v2.Intent.Message.Image) message_);
                  message_ = subBuilder.buildPartial();
                }
                messageCase_ = 2;
                break;
              }
            case 26:
              {
                com.google.cloud.dialogflow.v2.Intent.Message.QuickReplies.Builder subBuilder =
                    null;
                if (messageCase_ == 3) {
                  subBuilder =
                      ((com.google.cloud.dialogflow.v2.Intent.Message.QuickReplies) message_)
                          .toBuilder();
                }
                message_ =
                    input.readMessage(
                        com.google.cloud.dialogflow.v2.Intent.Message.QuickReplies.parser(),
                        extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(
                      (com.google.cloud.dialogflow.v2.Intent.Message.QuickReplies) message_);
                  message_ = subBuilder.buildPartial();
                }
                messageCase_ = 3;
                break;
              }
            case 34:
              {
                com.google.cloud.dialogflow.v2.Intent.Message.Card.Builder subBuilder = null;
                if (messageCase_ == 4) {
                  subBuilder =
                      ((com.google.cloud.dialogflow.v2.Intent.Message.Card) message_).toBuilder();
                }
                message_ =
                    input.readMessage(
                        com.google.cloud.dialogflow.v2.Intent.Message.Card.parser(),
                        extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(
                      (com.google.cloud.dialogflow.v2.Intent.Message.Card) message_);
                  message_ = subBuilder.buildPartial();
                }
                messageCase_ = 4;
                break;
              }
            case 42:
              {
                com.google.protobuf.Struct.Builder subBuilder = null;
                if (messageCase_ == 5) {
                  subBuilder = ((com.google.protobuf.Struct) message_).toBuilder();
                }
                message_ =
                    input.readMessage(com.google.protobuf.Struct.parser(), extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom((com.google.protobuf.Struct) message_);
                  message_ = subBuilder.buildPartial();
                }
                messageCase_ = 5;
                break;
              }
            case 48:
              {
                int rawValue = input.readEnum();

                platform_ = rawValue;
                break;
              }
            case 58:
              {
                com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponses.Builder subBuilder =
                    null;
                if (messageCase_ == 7) {
                  subBuilder =
                      ((com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponses) message_)
                          .toBuilder();
                }
                message_ =
                    input.readMessage(
                        com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponses.parser(),
                        extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(
                      (com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponses) message_);
                  message_ = subBuilder.buildPartial();
                }
                messageCase_ = 7;
                break;
              }
            case 66:
              {
                com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Builder subBuilder = null;
                if (messageCase_ == 8) {
                  subBuilder =
                      ((com.google.cloud.dialogflow.v2.Intent.Message.BasicCard) message_)
                          .toBuilder();
                }
                message_ =
                    input.readMessage(
                        com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.parser(),
                        extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(
                      (com.google.cloud.dialogflow.v2.Intent.Message.BasicCard) message_);
                  message_ = subBuilder.buildPartial();
                }
                messageCase_ = 8;
                break;
              }
            case 74:
              {
                com.google.cloud.dialogflow.v2.Intent.Message.Suggestions.Builder subBuilder = null;
                if (messageCase_ == 9) {
                  subBuilder =
                      ((com.google.cloud.dialogflow.v2.Intent.Message.Suggestions) message_)
                          .toBuilder();
                }
                message_ =
                    input.readMessage(
                        com.google.cloud.dialogflow.v2.Intent.Message.Suggestions.parser(),
                        extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(
                      (com.google.cloud.dialogflow.v2.Intent.Message.Suggestions) message_);
                  message_ = subBuilder.buildPartial();
                }
                messageCase_ = 9;
                break;
              }
            case 82:
              {
                com.google.cloud.dialogflow.v2.Intent.Message.LinkOutSuggestion.Builder subBuilder =
                    null;
                if (messageCase_ == 10) {
                  subBuilder =
                      ((com.google.cloud.dialogflow.v2.Intent.Message.LinkOutSuggestion) message_)
                          .toBuilder();
                }
                message_ =
                    input.readMessage(
                        com.google.cloud.dialogflow.v2.Intent.Message.LinkOutSuggestion.parser(),
                        extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(
                      (com.google.cloud.dialogflow.v2.Intent.Message.LinkOutSuggestion) message_);
                  message_ = subBuilder.buildPartial();
                }
                messageCase_ = 10;
                break;
              }
            case 90:
              {
                com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.Builder subBuilder = null;
                if (messageCase_ == 11) {
                  subBuilder =
                      ((com.google.cloud.dialogflow.v2.Intent.Message.ListSelect) message_)
                          .toBuilder();
                }
                message_ =
                    input.readMessage(
                        com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.parser(),
                        extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(
                      (com.google.cloud.dialogflow.v2.Intent.Message.ListSelect) message_);
                  message_ = subBuilder.buildPartial();
                }
                messageCase_ = 11;
                break;
              }
            case 98:
              {
                com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Builder subBuilder =
                    null;
                if (messageCase_ == 12) {
                  subBuilder =
                      ((com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect) message_)
                          .toBuilder();
                }
                message_ =
                    input.readMessage(
                        com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.parser(),
                        extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(
                      (com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect) message_);
                  message_ = subBuilder.buildPartial();
                }
                messageCase_ = 12;
                break;
              }
            case 178:
              {
                com.google.cloud.dialogflow.v2.Intent.Message.BrowseCarouselCard.Builder
                    subBuilder = null;
                if (messageCase_ == 22) {
                  subBuilder =
                      ((com.google.cloud.dialogflow.v2.Intent.Message.BrowseCarouselCard) message_)
                          .toBuilder();
                }
                message_ =
                    input.readMessage(
                        com.google.cloud.dialogflow.v2.Intent.Message.BrowseCarouselCard.parser(),
                        extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(
                      (com.google.cloud.dialogflow.v2.Intent.Message.BrowseCarouselCard) message_);
                  message_ = subBuilder.buildPartial();
                }
                messageCase_ = 22;
                break;
              }
            case 186:
              {
                com.google.cloud.dialogflow.v2.Intent.Message.TableCard.Builder subBuilder = null;
                if (messageCase_ == 23) {
                  subBuilder =
                      ((com.google.cloud.dialogflow.v2.Intent.Message.TableCard) message_)
                          .toBuilder();
                }
                message_ =
                    input.readMessage(
                        com.google.cloud.dialogflow.v2.Intent.Message.TableCard.parser(),
                        extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(
                      (com.google.cloud.dialogflow.v2.Intent.Message.TableCard) message_);
                  message_ = subBuilder.buildPartial();
                }
                messageCase_ = 23;
                break;
              }
            case 194:
              {
                com.google.cloud.dialogflow.v2.Intent.Message.MediaContent.Builder subBuilder =
                    null;
                if (messageCase_ == 24) {
                  subBuilder =
                      ((com.google.cloud.dialogflow.v2.Intent.Message.MediaContent) message_)
                          .toBuilder();
                }
                message_ =
                    input.readMessage(
                        com.google.cloud.dialogflow.v2.Intent.Message.MediaContent.parser(),
                        extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(
                      (com.google.cloud.dialogflow.v2.Intent.Message.MediaContent) message_);
                  message_ = subBuilder.buildPartial();
                }
                messageCase_ = 24;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2.IntentProto
          .internal_static_google_cloud_dialogflow_v2_Intent_Message_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2.IntentProto
          .internal_static_google_cloud_dialogflow_v2_Intent_Message_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2.Intent.Message.class,
              com.google.cloud.dialogflow.v2.Intent.Message.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * The rich response message integration platform. See
     * [Integrations](https://cloud.google.com/dialogflow/docs/integrations).
     * </pre>
     *
     * Protobuf enum {@code google.cloud.dialogflow.v2.Intent.Message.Platform}
     */
    public enum Platform implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Default platform.
       * </pre>
       *
       * <code>PLATFORM_UNSPECIFIED = 0;</code>
       */
      PLATFORM_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Facebook.
       * </pre>
       *
       * <code>FACEBOOK = 1;</code>
       */
      FACEBOOK(1),
      /**
       *
       *
       * <pre>
       * Slack.
       * </pre>
       *
       * <code>SLACK = 2;</code>
       */
      SLACK(2),
      /**
       *
       *
       * <pre>
       * Telegram.
       * </pre>
       *
       * <code>TELEGRAM = 3;</code>
       */
      TELEGRAM(3),
      /**
       *
       *
       * <pre>
       * Kik.
       * </pre>
       *
       * <code>KIK = 4;</code>
       */
      KIK(4),
      /**
       *
       *
       * <pre>
       * Skype.
       * </pre>
       *
       * <code>SKYPE = 5;</code>
       */
      SKYPE(5),
      /**
       *
       *
       * <pre>
       * Line.
       * </pre>
       *
       * <code>LINE = 6;</code>
       */
      LINE(6),
      /**
       *
       *
       * <pre>
       * Viber.
       * </pre>
       *
       * <code>VIBER = 7;</code>
       */
      VIBER(7),
      /**
       *
       *
       * <pre>
       * Google Assistant
       * See [Dialogflow webhook
       * format](https://developers.google.com/assistant/actions/build/json/dialogflow-webhook-json)
       * </pre>
       *
       * <code>ACTIONS_ON_GOOGLE = 8;</code>
       */
      ACTIONS_ON_GOOGLE(8),
      /**
       *
       *
       * <pre>
       * Google Hangouts.
       * </pre>
       *
       * <code>GOOGLE_HANGOUTS = 11;</code>
       */
      GOOGLE_HANGOUTS(11),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Default platform.
       * </pre>
       *
       * <code>PLATFORM_UNSPECIFIED = 0;</code>
       */
      public static final int PLATFORM_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Facebook.
       * </pre>
       *
       * <code>FACEBOOK = 1;</code>
       */
      public static final int FACEBOOK_VALUE = 1;
      /**
       *
       *
       * <pre>
       * Slack.
       * </pre>
       *
       * <code>SLACK = 2;</code>
       */
      public static final int SLACK_VALUE = 2;
      /**
       *
       *
       * <pre>
       * Telegram.
       * </pre>
       *
       * <code>TELEGRAM = 3;</code>
       */
      public static final int TELEGRAM_VALUE = 3;
      /**
       *
       *
       * <pre>
       * Kik.
       * </pre>
       *
       * <code>KIK = 4;</code>
       */
      public static final int KIK_VALUE = 4;
      /**
       *
       *
       * <pre>
       * Skype.
       * </pre>
       *
       * <code>SKYPE = 5;</code>
       */
      public static final int SKYPE_VALUE = 5;
      /**
       *
       *
       * <pre>
       * Line.
       * </pre>
       *
       * <code>LINE = 6;</code>
       */
      public static final int LINE_VALUE = 6;
      /**
       *
       *
       * <pre>
       * Viber.
       * </pre>
       *
       * <code>VIBER = 7;</code>
       */
      public static final int VIBER_VALUE = 7;
      /**
       *
       *
       * <pre>
       * Google Assistant
       * See [Dialogflow webhook
       * format](https://developers.google.com/assistant/actions/build/json/dialogflow-webhook-json)
       * </pre>
       *
       * <code>ACTIONS_ON_GOOGLE = 8;</code>
       */
      public static final int ACTIONS_ON_GOOGLE_VALUE = 8;
      /**
       *
       *
       * <pre>
       * Google Hangouts.
       * </pre>
       *
       * <code>GOOGLE_HANGOUTS = 11;</code>
       */
      public static final int GOOGLE_HANGOUTS_VALUE = 11;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static Platform valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static Platform forNumber(int value) {
        switch (value) {
          case 0:
            return PLATFORM_UNSPECIFIED;
          case 1:
            return FACEBOOK;
          case 2:
            return SLACK;
          case 3:
            return TELEGRAM;
          case 4:
            return KIK;
          case 5:
            return SKYPE;
          case 6:
            return LINE;
          case 7:
            return VIBER;
          case 8:
            return ACTIONS_ON_GOOGLE;
          case 11:
            return GOOGLE_HANGOUTS;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Platform> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<Platform> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<Platform>() {
            public Platform findValueByNumber(int number) {
              return Platform.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.dialogflow.v2.Intent.Message.getDescriptor().getEnumTypes().get(0);
      }

      private static final Platform[] VALUES = values();

      public static Platform valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private Platform(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.dialogflow.v2.Intent.Message.Platform)
    }

    public interface TextOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.v2.Intent.Message.Text)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Optional. The collection of the agent's responses.
       * </pre>
       *
       * <code>repeated string text = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return A list containing the text.
       */
      java.util.List<java.lang.String> getTextList();
      /**
       *
       *
       * <pre>
       * Optional. The collection of the agent's responses.
       * </pre>
       *
       * <code>repeated string text = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The count of text.
       */
      int getTextCount();
      /**
       *
       *
       * <pre>
       * Optional. The collection of the agent's responses.
       * </pre>
       *
       * <code>repeated string text = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the element to return.
       * @return The text at the given index.
       */
      java.lang.String getText(int index);
      /**
       *
       *
       * <pre>
       * Optional. The collection of the agent's responses.
       * </pre>
       *
       * <code>repeated string text = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the text at the given index.
       */
      com.google.protobuf.ByteString getTextBytes(int index);
    }
    /**
     *
     *
     * <pre>
     * The text response message.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.v2.Intent.Message.Text}
     */
    public static final class Text extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2.Intent.Message.Text)
        TextOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use Text.newBuilder() to construct.
      private Text(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Text() {
        text_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Text();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
      }

      private Text(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        int mutable_bitField0_ = 0;
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                    text_ = new com.google.protobuf.LazyStringArrayList();
                    mutable_bitField0_ |= 0x00000001;
                  }
                  text_.add(s);
                  break;
                }
              default:
                {
                  if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                    done = true;
                  }
                  break;
                }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(this);
        } finally {
          if (((mutable_bitField0_ & 0x00000001) != 0)) {
            text_ = text_.getUnmodifiableView();
          }
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.v2.IntentProto
            .internal_static_google_cloud_dialogflow_v2_Intent_Message_Text_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.v2.IntentProto
            .internal_static_google_cloud_dialogflow_v2_Intent_Message_Text_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.v2.Intent.Message.Text.class,
                com.google.cloud.dialogflow.v2.Intent.Message.Text.Builder.class);
      }

      public static final int TEXT_FIELD_NUMBER = 1;
      private com.google.protobuf.LazyStringList text_;
      /**
       *
       *
       * <pre>
       * Optional. The collection of the agent's responses.
       * </pre>
       *
       * <code>repeated string text = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return A list containing the text.
       */
      public com.google.protobuf.ProtocolStringList getTextList() {
        return text_;
      }
      /**
       *
       *
       * <pre>
       * Optional. The collection of the agent's responses.
       * </pre>
       *
       * <code>repeated string text = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The count of text.
       */
      public int getTextCount() {
        return text_.size();
      }
      /**
       *
       *
       * <pre>
       * Optional. The collection of the agent's responses.
       * </pre>
       *
       * <code>repeated string text = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the element to return.
       * @return The text at the given index.
       */
      public java.lang.String getText(int index) {
        return text_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Optional. The collection of the agent's responses.
       * </pre>
       *
       * <code>repeated string text = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the text at the given index.
       */
      public com.google.protobuf.ByteString getTextBytes(int index) {
        return text_.getByteString(index);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        for (int i = 0; i < text_.size(); i++) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, text_.getRaw(i));
        }
        unknownFields.writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        {
          int dataSize = 0;
          for (int i = 0; i < text_.size(); i++) {
            dataSize += computeStringSizeNoTag(text_.getRaw(i));
          }
          size += dataSize;
          size += 1 * getTextList().size();
        }
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.cloud.dialogflow.v2.Intent.Message.Text)) {
          return super.equals(obj);
        }
        com.google.cloud.dialogflow.v2.Intent.Message.Text other =
            (com.google.cloud.dialogflow.v2.Intent.Message.Text) obj;

        if (!getTextList().equals(other.getTextList())) return false;
        if (!unknownFields.equals(other.unknownFields)) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (getTextCount() > 0) {
          hash = (37 * hash) + TEXT_FIELD_NUMBER;
          hash = (53 * hash) + getTextList().hashCode();
        }
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.Text parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.Text parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.Text parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.Text parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.Text parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.Text parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.Text parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.Text parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.Text parseDelimitedFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.Text parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.Text parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.Text parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.dialogflow.v2.Intent.Message.Text prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * The text response message.
       * </pre>
       *
       * Protobuf type {@code google.cloud.dialogflow.v2.Intent.Message.Text}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2.Intent.Message.Text)
          com.google.cloud.dialogflow.v2.Intent.Message.TextOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.dialogflow.v2.IntentProto
              .internal_static_google_cloud_dialogflow_v2_Intent_Message_Text_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.dialogflow.v2.IntentProto
              .internal_static_google_cloud_dialogflow_v2_Intent_Message_Text_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.dialogflow.v2.Intent.Message.Text.class,
                  com.google.cloud.dialogflow.v2.Intent.Message.Text.Builder.class);
        }

        // Construct using com.google.cloud.dialogflow.v2.Intent.Message.Text.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          text_ = com.google.protobuf.LazyStringArrayList.EMPTY;
          bitField0_ = (bitField0_ & ~0x00000001);
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.dialogflow.v2.IntentProto
              .internal_static_google_cloud_dialogflow_v2_Intent_Message_Text_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.v2.Intent.Message.Text getDefaultInstanceForType() {
          return com.google.cloud.dialogflow.v2.Intent.Message.Text.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.v2.Intent.Message.Text build() {
          com.google.cloud.dialogflow.v2.Intent.Message.Text result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.v2.Intent.Message.Text buildPartial() {
          com.google.cloud.dialogflow.v2.Intent.Message.Text result =
              new com.google.cloud.dialogflow.v2.Intent.Message.Text(this);
          int from_bitField0_ = bitField0_;
          if (((bitField0_ & 0x00000001) != 0)) {
            text_ = text_.getUnmodifiableView();
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.text_ = text_;
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.cloud.dialogflow.v2.Intent.Message.Text) {
            return mergeFrom((com.google.cloud.dialogflow.v2.Intent.Message.Text) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.google.cloud.dialogflow.v2.Intent.Message.Text other) {
          if (other == com.google.cloud.dialogflow.v2.Intent.Message.Text.getDefaultInstance())
            return this;
          if (!other.text_.isEmpty()) {
            if (text_.isEmpty()) {
              text_ = other.text_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureTextIsMutable();
              text_.addAll(other.text_);
            }
            onChanged();
          }
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          com.google.cloud.dialogflow.v2.Intent.Message.Text parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage =
                (com.google.cloud.dialogflow.v2.Intent.Message.Text) e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }

        private int bitField0_;

        private com.google.protobuf.LazyStringList text_ =
            com.google.protobuf.LazyStringArrayList.EMPTY;

        private void ensureTextIsMutable() {
          if (!((bitField0_ & 0x00000001) != 0)) {
            text_ = new com.google.protobuf.LazyStringArrayList(text_);
            bitField0_ |= 0x00000001;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The collection of the agent's responses.
         * </pre>
         *
         * <code>repeated string text = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return A list containing the text.
         */
        public com.google.protobuf.ProtocolStringList getTextList() {
          return text_.getUnmodifiableView();
        }
        /**
         *
         *
         * <pre>
         * Optional. The collection of the agent's responses.
         * </pre>
         *
         * <code>repeated string text = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The count of text.
         */
        public int getTextCount() {
          return text_.size();
        }
        /**
         *
         *
         * <pre>
         * Optional. The collection of the agent's responses.
         * </pre>
         *
         * <code>repeated string text = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param index The index of the element to return.
         * @return The text at the given index.
         */
        public java.lang.String getText(int index) {
          return text_.get(index);
        }
        /**
         *
         *
         * <pre>
         * Optional. The collection of the agent's responses.
         * </pre>
         *
         * <code>repeated string text = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the text at the given index.
         */
        public com.google.protobuf.ByteString getTextBytes(int index) {
          return text_.getByteString(index);
        }
        /**
         *
         *
         * <pre>
         * Optional. The collection of the agent's responses.
         * </pre>
         *
         * <code>repeated string text = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param index The index to set the value at.
         * @param value The text to set.
         * @return This builder for chaining.
         */
        public Builder setText(int index, java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureTextIsMutable();
          text_.set(index, value);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The collection of the agent's responses.
         * </pre>
         *
         * <code>repeated string text = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The text to add.
         * @return This builder for chaining.
         */
        public Builder addText(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureTextIsMutable();
          text_.add(value);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The collection of the agent's responses.
         * </pre>
         *
         * <code>repeated string text = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param values The text to add.
         * @return This builder for chaining.
         */
        public Builder addAllText(java.lang.Iterable<java.lang.String> values) {
          ensureTextIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, text_);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The collection of the agent's responses.
         * </pre>
         *
         * <code>repeated string text = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearText() {
          text_ = com.google.protobuf.LazyStringArrayList.EMPTY;
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The collection of the agent's responses.
         * </pre>
         *
         * <code>repeated string text = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The bytes of the text to add.
         * @return This builder for chaining.
         */
        public Builder addTextBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          ensureTextIsMutable();
          text_.add(value);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2.Intent.Message.Text)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2.Intent.Message.Text)
      private static final com.google.cloud.dialogflow.v2.Intent.Message.Text DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2.Intent.Message.Text();
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.Text getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Text> PARSER =
          new com.google.protobuf.AbstractParser<Text>() {
            @java.lang.Override
            public Text parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              return new Text(input, extensionRegistry);
            }
          };

      public static com.google.protobuf.Parser<Text> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Text> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2.Intent.Message.Text getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface ImageOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.v2.Intent.Message.Image)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Optional. The public URI to an image file.
       * </pre>
       *
       * <code>string image_uri = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The imageUri.
       */
      java.lang.String getImageUri();
      /**
       *
       *
       * <pre>
       * Optional. The public URI to an image file.
       * </pre>
       *
       * <code>string image_uri = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for imageUri.
       */
      com.google.protobuf.ByteString getImageUriBytes();

      /**
       *
       *
       * <pre>
       * Optional. A text description of the image to be used for accessibility,
       * e.g., screen readers.
       * </pre>
       *
       * <code>string accessibility_text = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The accessibilityText.
       */
      java.lang.String getAccessibilityText();
      /**
       *
       *
       * <pre>
       * Optional. A text description of the image to be used for accessibility,
       * e.g., screen readers.
       * </pre>
       *
       * <code>string accessibility_text = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for accessibilityText.
       */
      com.google.protobuf.ByteString getAccessibilityTextBytes();
    }
    /**
     *
     *
     * <pre>
     * The image response message.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.v2.Intent.Message.Image}
     */
    public static final class Image extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2.Intent.Message.Image)
        ImageOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use Image.newBuilder() to construct.
      private Image(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Image() {
        imageUri_ = "";
        accessibilityText_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Image();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
      }

      private Image(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();

                  imageUri_ = s;
                  break;
                }
              case 18:
                {
                  java.lang.String s = input.readStringRequireUtf8();

                  accessibilityText_ = s;
                  break;
                }
              default:
                {
                  if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                    done = true;
                  }
                  break;
                }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(this);
        } finally {
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.v2.IntentProto
            .internal_static_google_cloud_dialogflow_v2_Intent_Message_Image_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.v2.IntentProto
            .internal_static_google_cloud_dialogflow_v2_Intent_Message_Image_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.v2.Intent.Message.Image.class,
                com.google.cloud.dialogflow.v2.Intent.Message.Image.Builder.class);
      }

      public static final int IMAGE_URI_FIELD_NUMBER = 1;
      private volatile java.lang.Object imageUri_;
      /**
       *
       *
       * <pre>
       * Optional. The public URI to an image file.
       * </pre>
       *
       * <code>string image_uri = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The imageUri.
       */
      @java.lang.Override
      public java.lang.String getImageUri() {
        java.lang.Object ref = imageUri_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          imageUri_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The public URI to an image file.
       * </pre>
       *
       * <code>string image_uri = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for imageUri.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getImageUriBytes() {
        java.lang.Object ref = imageUri_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          imageUri_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int ACCESSIBILITY_TEXT_FIELD_NUMBER = 2;
      private volatile java.lang.Object accessibilityText_;
      /**
       *
       *
       * <pre>
       * Optional. A text description of the image to be used for accessibility,
       * e.g., screen readers.
       * </pre>
       *
       * <code>string accessibility_text = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The accessibilityText.
       */
      @java.lang.Override
      public java.lang.String getAccessibilityText() {
        java.lang.Object ref = accessibilityText_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          accessibilityText_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. A text description of the image to be used for accessibility,
       * e.g., screen readers.
       * </pre>
       *
       * <code>string accessibility_text = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for accessibilityText.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getAccessibilityTextBytes() {
        java.lang.Object ref = accessibilityText_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          accessibilityText_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!getImageUriBytes().isEmpty()) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, imageUri_);
        }
        if (!getAccessibilityTextBytes().isEmpty()) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 2, accessibilityText_);
        }
        unknownFields.writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!getImageUriBytes().isEmpty()) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, imageUri_);
        }
        if (!getAccessibilityTextBytes().isEmpty()) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, accessibilityText_);
        }
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.cloud.dialogflow.v2.Intent.Message.Image)) {
          return super.equals(obj);
        }
        com.google.cloud.dialogflow.v2.Intent.Message.Image other =
            (com.google.cloud.dialogflow.v2.Intent.Message.Image) obj;

        if (!getImageUri().equals(other.getImageUri())) return false;
        if (!getAccessibilityText().equals(other.getAccessibilityText())) return false;
        if (!unknownFields.equals(other.unknownFields)) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + IMAGE_URI_FIELD_NUMBER;
        hash = (53 * hash) + getImageUri().hashCode();
        hash = (37 * hash) + ACCESSIBILITY_TEXT_FIELD_NUMBER;
        hash = (53 * hash) + getAccessibilityText().hashCode();
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.Image parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.Image parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.Image parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.Image parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.Image parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.Image parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.Image parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.Image parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.Image parseDelimitedFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.Image parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.Image parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.Image parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.dialogflow.v2.Intent.Message.Image prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * The image response message.
       * </pre>
       *
       * Protobuf type {@code google.cloud.dialogflow.v2.Intent.Message.Image}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2.Intent.Message.Image)
          com.google.cloud.dialogflow.v2.Intent.Message.ImageOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.dialogflow.v2.IntentProto
              .internal_static_google_cloud_dialogflow_v2_Intent_Message_Image_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.dialogflow.v2.IntentProto
              .internal_static_google_cloud_dialogflow_v2_Intent_Message_Image_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.dialogflow.v2.Intent.Message.Image.class,
                  com.google.cloud.dialogflow.v2.Intent.Message.Image.Builder.class);
        }

        // Construct using com.google.cloud.dialogflow.v2.Intent.Message.Image.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          imageUri_ = "";

          accessibilityText_ = "";

          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.dialogflow.v2.IntentProto
              .internal_static_google_cloud_dialogflow_v2_Intent_Message_Image_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.v2.Intent.Message.Image getDefaultInstanceForType() {
          return com.google.cloud.dialogflow.v2.Intent.Message.Image.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.v2.Intent.Message.Image build() {
          com.google.cloud.dialogflow.v2.Intent.Message.Image result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.v2.Intent.Message.Image buildPartial() {
          com.google.cloud.dialogflow.v2.Intent.Message.Image result =
              new com.google.cloud.dialogflow.v2.Intent.Message.Image(this);
          result.imageUri_ = imageUri_;
          result.accessibilityText_ = accessibilityText_;
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.cloud.dialogflow.v2.Intent.Message.Image) {
            return mergeFrom((com.google.cloud.dialogflow.v2.Intent.Message.Image) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.google.cloud.dialogflow.v2.Intent.Message.Image other) {
          if (other == com.google.cloud.dialogflow.v2.Intent.Message.Image.getDefaultInstance())
            return this;
          if (!other.getImageUri().isEmpty()) {
            imageUri_ = other.imageUri_;
            onChanged();
          }
          if (!other.getAccessibilityText().isEmpty()) {
            accessibilityText_ = other.accessibilityText_;
            onChanged();
          }
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          com.google.cloud.dialogflow.v2.Intent.Message.Image parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage =
                (com.google.cloud.dialogflow.v2.Intent.Message.Image) e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }

        private java.lang.Object imageUri_ = "";
        /**
         *
         *
         * <pre>
         * Optional. The public URI to an image file.
         * </pre>
         *
         * <code>string image_uri = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The imageUri.
         */
        public java.lang.String getImageUri() {
          java.lang.Object ref = imageUri_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            imageUri_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The public URI to an image file.
         * </pre>
         *
         * <code>string image_uri = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The bytes for imageUri.
         */
        public com.google.protobuf.ByteString getImageUriBytes() {
          java.lang.Object ref = imageUri_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            imageUri_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The public URI to an image file.
         * </pre>
         *
         * <code>string image_uri = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The imageUri to set.
         * @return This builder for chaining.
         */
        public Builder setImageUri(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }

          imageUri_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The public URI to an image file.
         * </pre>
         *
         * <code>string image_uri = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearImageUri() {

          imageUri_ = getDefaultInstance().getImageUri();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The public URI to an image file.
         * </pre>
         *
         * <code>string image_uri = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The bytes for imageUri to set.
         * @return This builder for chaining.
         */
        public Builder setImageUriBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);

          imageUri_ = value;
          onChanged();
          return this;
        }

        private java.lang.Object accessibilityText_ = "";
        /**
         *
         *
         * <pre>
         * Optional. A text description of the image to be used for accessibility,
         * e.g., screen readers.
         * </pre>
         *
         * <code>string accessibility_text = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The accessibilityText.
         */
        public java.lang.String getAccessibilityText() {
          java.lang.Object ref = accessibilityText_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            accessibilityText_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. A text description of the image to be used for accessibility,
         * e.g., screen readers.
         * </pre>
         *
         * <code>string accessibility_text = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The bytes for accessibilityText.
         */
        public com.google.protobuf.ByteString getAccessibilityTextBytes() {
          java.lang.Object ref = accessibilityText_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            accessibilityText_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. A text description of the image to be used for accessibility,
         * e.g., screen readers.
         * </pre>
         *
         * <code>string accessibility_text = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The accessibilityText to set.
         * @return This builder for chaining.
         */
        public Builder setAccessibilityText(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }

          accessibilityText_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. A text description of the image to be used for accessibility,
         * e.g., screen readers.
         * </pre>
         *
         * <code>string accessibility_text = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearAccessibilityText() {

          accessibilityText_ = getDefaultInstance().getAccessibilityText();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. A text description of the image to be used for accessibility,
         * e.g., screen readers.
         * </pre>
         *
         * <code>string accessibility_text = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The bytes for accessibilityText to set.
         * @return This builder for chaining.
         */
        public Builder setAccessibilityTextBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);

          accessibilityText_ = value;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2.Intent.Message.Image)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2.Intent.Message.Image)
      private static final com.google.cloud.dialogflow.v2.Intent.Message.Image DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2.Intent.Message.Image();
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.Image getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Image> PARSER =
          new com.google.protobuf.AbstractParser<Image>() {
            @java.lang.Override
            public Image parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              return new Image(input, extensionRegistry);
            }
          };

      public static com.google.protobuf.Parser<Image> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Image> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2.Intent.Message.Image getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface QuickRepliesOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.v2.Intent.Message.QuickReplies)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Optional. The title of the collection of quick replies.
       * </pre>
       *
       * <code>string title = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The title.
       */
      java.lang.String getTitle();
      /**
       *
       *
       * <pre>
       * Optional. The title of the collection of quick replies.
       * </pre>
       *
       * <code>string title = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for title.
       */
      com.google.protobuf.ByteString getTitleBytes();

      /**
       *
       *
       * <pre>
       * Optional. The collection of quick replies.
       * </pre>
       *
       * <code>repeated string quick_replies = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return A list containing the quickReplies.
       */
      java.util.List<java.lang.String> getQuickRepliesList();
      /**
       *
       *
       * <pre>
       * Optional. The collection of quick replies.
       * </pre>
       *
       * <code>repeated string quick_replies = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The count of quickReplies.
       */
      int getQuickRepliesCount();
      /**
       *
       *
       * <pre>
       * Optional. The collection of quick replies.
       * </pre>
       *
       * <code>repeated string quick_replies = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the element to return.
       * @return The quickReplies at the given index.
       */
      java.lang.String getQuickReplies(int index);
      /**
       *
       *
       * <pre>
       * Optional. The collection of quick replies.
       * </pre>
       *
       * <code>repeated string quick_replies = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the quickReplies at the given index.
       */
      com.google.protobuf.ByteString getQuickRepliesBytes(int index);
    }
    /**
     *
     *
     * <pre>
     * The quick replies response message.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.v2.Intent.Message.QuickReplies}
     */
    public static final class QuickReplies extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2.Intent.Message.QuickReplies)
        QuickRepliesOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use QuickReplies.newBuilder() to construct.
      private QuickReplies(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private QuickReplies() {
        title_ = "";
        quickReplies_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new QuickReplies();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
      }

      private QuickReplies(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        int mutable_bitField0_ = 0;
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();

                  title_ = s;
                  break;
                }
              case 18:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                    quickReplies_ = new com.google.protobuf.LazyStringArrayList();
                    mutable_bitField0_ |= 0x00000001;
                  }
                  quickReplies_.add(s);
                  break;
                }
              default:
                {
                  if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                    done = true;
                  }
                  break;
                }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(this);
        } finally {
          if (((mutable_bitField0_ & 0x00000001) != 0)) {
            quickReplies_ = quickReplies_.getUnmodifiableView();
          }
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.v2.IntentProto
            .internal_static_google_cloud_dialogflow_v2_Intent_Message_QuickReplies_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.v2.IntentProto
            .internal_static_google_cloud_dialogflow_v2_Intent_Message_QuickReplies_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.v2.Intent.Message.QuickReplies.class,
                com.google.cloud.dialogflow.v2.Intent.Message.QuickReplies.Builder.class);
      }

      public static final int TITLE_FIELD_NUMBER = 1;
      private volatile java.lang.Object title_;
      /**
       *
       *
       * <pre>
       * Optional. The title of the collection of quick replies.
       * </pre>
       *
       * <code>string title = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The title.
       */
      @java.lang.Override
      public java.lang.String getTitle() {
        java.lang.Object ref = title_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          title_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The title of the collection of quick replies.
       * </pre>
       *
       * <code>string title = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for title.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getTitleBytes() {
        java.lang.Object ref = title_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          title_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int QUICK_REPLIES_FIELD_NUMBER = 2;
      private com.google.protobuf.LazyStringList quickReplies_;
      /**
       *
       *
       * <pre>
       * Optional. The collection of quick replies.
       * </pre>
       *
       * <code>repeated string quick_replies = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return A list containing the quickReplies.
       */
      public com.google.protobuf.ProtocolStringList getQuickRepliesList() {
        return quickReplies_;
      }
      /**
       *
       *
       * <pre>
       * Optional. The collection of quick replies.
       * </pre>
       *
       * <code>repeated string quick_replies = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The count of quickReplies.
       */
      public int getQuickRepliesCount() {
        return quickReplies_.size();
      }
      /**
       *
       *
       * <pre>
       * Optional. The collection of quick replies.
       * </pre>
       *
       * <code>repeated string quick_replies = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the element to return.
       * @return The quickReplies at the given index.
       */
      public java.lang.String getQuickReplies(int index) {
        return quickReplies_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Optional. The collection of quick replies.
       * </pre>
       *
       * <code>repeated string quick_replies = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the quickReplies at the given index.
       */
      public com.google.protobuf.ByteString getQuickRepliesBytes(int index) {
        return quickReplies_.getByteString(index);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!getTitleBytes().isEmpty()) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, title_);
        }
        for (int i = 0; i < quickReplies_.size(); i++) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 2, quickReplies_.getRaw(i));
        }
        unknownFields.writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!getTitleBytes().isEmpty()) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, title_);
        }
        {
          int dataSize = 0;
          for (int i = 0; i < quickReplies_.size(); i++) {
            dataSize += computeStringSizeNoTag(quickReplies_.getRaw(i));
          }
          size += dataSize;
          size += 1 * getQuickRepliesList().size();
        }
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.cloud.dialogflow.v2.Intent.Message.QuickReplies)) {
          return super.equals(obj);
        }
        com.google.cloud.dialogflow.v2.Intent.Message.QuickReplies other =
            (com.google.cloud.dialogflow.v2.Intent.Message.QuickReplies) obj;

        if (!getTitle().equals(other.getTitle())) return false;
        if (!getQuickRepliesList().equals(other.getQuickRepliesList())) return false;
        if (!unknownFields.equals(other.unknownFields)) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + TITLE_FIELD_NUMBER;
        hash = (53 * hash) + getTitle().hashCode();
        if (getQuickRepliesCount() > 0) {
          hash = (37 * hash) + QUICK_REPLIES_FIELD_NUMBER;
          hash = (53 * hash) + getQuickRepliesList().hashCode();
        }
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.QuickReplies parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.QuickReplies parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.QuickReplies parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.QuickReplies parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.QuickReplies parseFrom(
          byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.QuickReplies parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.QuickReplies parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.QuickReplies parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.QuickReplies parseDelimitedFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.QuickReplies parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.QuickReplies parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.QuickReplies parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.dialogflow.v2.Intent.Message.QuickReplies prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * The quick replies response message.
       * </pre>
       *
       * Protobuf type {@code google.cloud.dialogflow.v2.Intent.Message.QuickReplies}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2.Intent.Message.QuickReplies)
          com.google.cloud.dialogflow.v2.Intent.Message.QuickRepliesOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.dialogflow.v2.IntentProto
              .internal_static_google_cloud_dialogflow_v2_Intent_Message_QuickReplies_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.dialogflow.v2.IntentProto
              .internal_static_google_cloud_dialogflow_v2_Intent_Message_QuickReplies_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.dialogflow.v2.Intent.Message.QuickReplies.class,
                  com.google.cloud.dialogflow.v2.Intent.Message.QuickReplies.Builder.class);
        }

        // Construct using com.google.cloud.dialogflow.v2.Intent.Message.QuickReplies.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          title_ = "";

          quickReplies_ = com.google.protobuf.LazyStringArrayList.EMPTY;
          bitField0_ = (bitField0_ & ~0x00000001);
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.dialogflow.v2.IntentProto
              .internal_static_google_cloud_dialogflow_v2_Intent_Message_QuickReplies_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.v2.Intent.Message.QuickReplies
            getDefaultInstanceForType() {
          return com.google.cloud.dialogflow.v2.Intent.Message.QuickReplies.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.v2.Intent.Message.QuickReplies build() {
          com.google.cloud.dialogflow.v2.Intent.Message.QuickReplies result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.v2.Intent.Message.QuickReplies buildPartial() {
          com.google.cloud.dialogflow.v2.Intent.Message.QuickReplies result =
              new com.google.cloud.dialogflow.v2.Intent.Message.QuickReplies(this);
          int from_bitField0_ = bitField0_;
          result.title_ = title_;
          if (((bitField0_ & 0x00000001) != 0)) {
            quickReplies_ = quickReplies_.getUnmodifiableView();
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.quickReplies_ = quickReplies_;
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.cloud.dialogflow.v2.Intent.Message.QuickReplies) {
            return mergeFrom((com.google.cloud.dialogflow.v2.Intent.Message.QuickReplies) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.google.cloud.dialogflow.v2.Intent.Message.QuickReplies other) {
          if (other
              == com.google.cloud.dialogflow.v2.Intent.Message.QuickReplies.getDefaultInstance())
            return this;
          if (!other.getTitle().isEmpty()) {
            title_ = other.title_;
            onChanged();
          }
          if (!other.quickReplies_.isEmpty()) {
            if (quickReplies_.isEmpty()) {
              quickReplies_ = other.quickReplies_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureQuickRepliesIsMutable();
              quickReplies_.addAll(other.quickReplies_);
            }
            onChanged();
          }
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          com.google.cloud.dialogflow.v2.Intent.Message.QuickReplies parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage =
                (com.google.cloud.dialogflow.v2.Intent.Message.QuickReplies)
                    e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }

        private int bitField0_;

        private java.lang.Object title_ = "";
        /**
         *
         *
         * <pre>
         * Optional. The title of the collection of quick replies.
         * </pre>
         *
         * <code>string title = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The title.
         */
        public java.lang.String getTitle() {
          java.lang.Object ref = title_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            title_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The title of the collection of quick replies.
         * </pre>
         *
         * <code>string title = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The bytes for title.
         */
        public com.google.protobuf.ByteString getTitleBytes() {
          java.lang.Object ref = title_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            title_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The title of the collection of quick replies.
         * </pre>
         *
         * <code>string title = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The title to set.
         * @return This builder for chaining.
         */
        public Builder setTitle(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }

          title_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The title of the collection of quick replies.
         * </pre>
         *
         * <code>string title = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearTitle() {

          title_ = getDefaultInstance().getTitle();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The title of the collection of quick replies.
         * </pre>
         *
         * <code>string title = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The bytes for title to set.
         * @return This builder for chaining.
         */
        public Builder setTitleBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);

          title_ = value;
          onChanged();
          return this;
        }

        private com.google.protobuf.LazyStringList quickReplies_ =
            com.google.protobuf.LazyStringArrayList.EMPTY;

        private void ensureQuickRepliesIsMutable() {
          if (!((bitField0_ & 0x00000001) != 0)) {
            quickReplies_ = new com.google.protobuf.LazyStringArrayList(quickReplies_);
            bitField0_ |= 0x00000001;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The collection of quick replies.
         * </pre>
         *
         * <code>repeated string quick_replies = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return A list containing the quickReplies.
         */
        public com.google.protobuf.ProtocolStringList getQuickRepliesList() {
          return quickReplies_.getUnmodifiableView();
        }
        /**
         *
         *
         * <pre>
         * Optional. The collection of quick replies.
         * </pre>
         *
         * <code>repeated string quick_replies = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The count of quickReplies.
         */
        public int getQuickRepliesCount() {
          return quickReplies_.size();
        }
        /**
         *
         *
         * <pre>
         * Optional. The collection of quick replies.
         * </pre>
         *
         * <code>repeated string quick_replies = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param index The index of the element to return.
         * @return The quickReplies at the given index.
         */
        public java.lang.String getQuickReplies(int index) {
          return quickReplies_.get(index);
        }
        /**
         *
         *
         * <pre>
         * Optional. The collection of quick replies.
         * </pre>
         *
         * <code>repeated string quick_replies = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the quickReplies at the given index.
         */
        public com.google.protobuf.ByteString getQuickRepliesBytes(int index) {
          return quickReplies_.getByteString(index);
        }
        /**
         *
         *
         * <pre>
         * Optional. The collection of quick replies.
         * </pre>
         *
         * <code>repeated string quick_replies = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param index The index to set the value at.
         * @param value The quickReplies to set.
         * @return This builder for chaining.
         */
        public Builder setQuickReplies(int index, java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureQuickRepliesIsMutable();
          quickReplies_.set(index, value);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The collection of quick replies.
         * </pre>
         *
         * <code>repeated string quick_replies = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The quickReplies to add.
         * @return This builder for chaining.
         */
        public Builder addQuickReplies(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureQuickRepliesIsMutable();
          quickReplies_.add(value);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The collection of quick replies.
         * </pre>
         *
         * <code>repeated string quick_replies = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param values The quickReplies to add.
         * @return This builder for chaining.
         */
        public Builder addAllQuickReplies(java.lang.Iterable<java.lang.String> values) {
          ensureQuickRepliesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, quickReplies_);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The collection of quick replies.
         * </pre>
         *
         * <code>repeated string quick_replies = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearQuickReplies() {
          quickReplies_ = com.google.protobuf.LazyStringArrayList.EMPTY;
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The collection of quick replies.
         * </pre>
         *
         * <code>repeated string quick_replies = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The bytes of the quickReplies to add.
         * @return This builder for chaining.
         */
        public Builder addQuickRepliesBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          ensureQuickRepliesIsMutable();
          quickReplies_.add(value);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2.Intent.Message.QuickReplies)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2.Intent.Message.QuickReplies)
      private static final com.google.cloud.dialogflow.v2.Intent.Message.QuickReplies
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2.Intent.Message.QuickReplies();
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.QuickReplies
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<QuickReplies> PARSER =
          new com.google.protobuf.AbstractParser<QuickReplies>() {
            @java.lang.Override
            public QuickReplies parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              return new QuickReplies(input, extensionRegistry);
            }
          };

      public static com.google.protobuf.Parser<QuickReplies> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<QuickReplies> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2.Intent.Message.QuickReplies
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface CardOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.v2.Intent.Message.Card)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Optional. The title of the card.
       * </pre>
       *
       * <code>string title = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The title.
       */
      java.lang.String getTitle();
      /**
       *
       *
       * <pre>
       * Optional. The title of the card.
       * </pre>
       *
       * <code>string title = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for title.
       */
      com.google.protobuf.ByteString getTitleBytes();

      /**
       *
       *
       * <pre>
       * Optional. The subtitle of the card.
       * </pre>
       *
       * <code>string subtitle = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The subtitle.
       */
      java.lang.String getSubtitle();
      /**
       *
       *
       * <pre>
       * Optional. The subtitle of the card.
       * </pre>
       *
       * <code>string subtitle = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for subtitle.
       */
      com.google.protobuf.ByteString getSubtitleBytes();

      /**
       *
       *
       * <pre>
       * Optional. The public URI to an image file for the card.
       * </pre>
       *
       * <code>string image_uri = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The imageUri.
       */
      java.lang.String getImageUri();
      /**
       *
       *
       * <pre>
       * Optional. The public URI to an image file for the card.
       * </pre>
       *
       * <code>string image_uri = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for imageUri.
       */
      com.google.protobuf.ByteString getImageUriBytes();

      /**
       *
       *
       * <pre>
       * Optional. The collection of card buttons.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.Message.Card.Button buttons = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      java.util.List<com.google.cloud.dialogflow.v2.Intent.Message.Card.Button> getButtonsList();
      /**
       *
       *
       * <pre>
       * Optional. The collection of card buttons.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.Message.Card.Button buttons = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      com.google.cloud.dialogflow.v2.Intent.Message.Card.Button getButtons(int index);
      /**
       *
       *
       * <pre>
       * Optional. The collection of card buttons.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.Message.Card.Button buttons = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      int getButtonsCount();
      /**
       *
       *
       * <pre>
       * Optional. The collection of card buttons.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.Message.Card.Button buttons = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      java.util.List<? extends com.google.cloud.dialogflow.v2.Intent.Message.Card.ButtonOrBuilder>
          getButtonsOrBuilderList();
      /**
       *
       *
       * <pre>
       * Optional. The collection of card buttons.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.Message.Card.Button buttons = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      com.google.cloud.dialogflow.v2.Intent.Message.Card.ButtonOrBuilder getButtonsOrBuilder(
          int index);
    }
    /**
     *
     *
     * <pre>
     * The card response message.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.v2.Intent.Message.Card}
     */
    public static final class Card extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2.Intent.Message.Card)
        CardOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use Card.newBuilder() to construct.
      private Card(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Card() {
        title_ = "";
        subtitle_ = "";
        imageUri_ = "";
        buttons_ = java.util.Collections.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Card();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
      }

      private Card(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        int mutable_bitField0_ = 0;
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();

                  title_ = s;
                  break;
                }
              case 18:
                {
                  java.lang.String s = input.readStringRequireUtf8();

                  subtitle_ = s;
                  break;
                }
              case 26:
                {
                  java.lang.String s = input.readStringRequireUtf8();

                  imageUri_ = s;
                  break;
                }
              case 34:
                {
                  if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                    buttons_ =
                        new java.util.ArrayList<
                            com.google.cloud.dialogflow.v2.Intent.Message.Card.Button>();
                    mutable_bitField0_ |= 0x00000001;
                  }
                  buttons_.add(
                      input.readMessage(
                          com.google.cloud.dialogflow.v2.Intent.Message.Card.Button.parser(),
                          extensionRegistry));
                  break;
                }
              default:
                {
                  if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                    done = true;
                  }
                  break;
                }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(this);
        } finally {
          if (((mutable_bitField0_ & 0x00000001) != 0)) {
            buttons_ = java.util.Collections.unmodifiableList(buttons_);
          }
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.v2.IntentProto
            .internal_static_google_cloud_dialogflow_v2_Intent_Message_Card_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.v2.IntentProto
            .internal_static_google_cloud_dialogflow_v2_Intent_Message_Card_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.v2.Intent.Message.Card.class,
                com.google.cloud.dialogflow.v2.Intent.Message.Card.Builder.class);
      }

      public interface ButtonOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.v2.Intent.Message.Card.Button)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * Optional. The text to show on the button.
         * </pre>
         *
         * <code>string text = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The text.
         */
        java.lang.String getText();
        /**
         *
         *
         * <pre>
         * Optional. The text to show on the button.
         * </pre>
         *
         * <code>string text = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The bytes for text.
         */
        com.google.protobuf.ByteString getTextBytes();

        /**
         *
         *
         * <pre>
         * Optional. The text to send back to the Dialogflow API or a URI to
         * open.
         * </pre>
         *
         * <code>string postback = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The postback.
         */
        java.lang.String getPostback();
        /**
         *
         *
         * <pre>
         * Optional. The text to send back to the Dialogflow API or a URI to
         * open.
         * </pre>
         *
         * <code>string postback = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The bytes for postback.
         */
        com.google.protobuf.ByteString getPostbackBytes();
      }
      /**
       *
       *
       * <pre>
       * Contains information about a button.
       * </pre>
       *
       * Protobuf type {@code google.cloud.dialogflow.v2.Intent.Message.Card.Button}
       */
      public static final class Button extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2.Intent.Message.Card.Button)
          ButtonOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use Button.newBuilder() to construct.
        private Button(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private Button() {
          text_ = "";
          postback_ = "";
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new Button();
        }

        @java.lang.Override
        public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
          return this.unknownFields;
        }

        private Button(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          this();
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          com.google.protobuf.UnknownFieldSet.Builder unknownFields =
              com.google.protobuf.UnknownFieldSet.newBuilder();
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    java.lang.String s = input.readStringRequireUtf8();

                    text_ = s;
                    break;
                  }
                case 18:
                  {
                    java.lang.String s = input.readStringRequireUtf8();

                    postback_ = s;
                    break;
                  }
                default:
                  {
                    if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                      done = true;
                    }
                    break;
                  }
              }
            }
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(this);
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(this);
          } finally {
            this.unknownFields = unknownFields.build();
            makeExtensionsImmutable();
          }
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.dialogflow.v2.IntentProto
              .internal_static_google_cloud_dialogflow_v2_Intent_Message_Card_Button_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.dialogflow.v2.IntentProto
              .internal_static_google_cloud_dialogflow_v2_Intent_Message_Card_Button_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.dialogflow.v2.Intent.Message.Card.Button.class,
                  com.google.cloud.dialogflow.v2.Intent.Message.Card.Button.Builder.class);
        }

        public static final int TEXT_FIELD_NUMBER = 1;
        private volatile java.lang.Object text_;
        /**
         *
         *
         * <pre>
         * Optional. The text to show on the button.
         * </pre>
         *
         * <code>string text = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The text.
         */
        @java.lang.Override
        public java.lang.String getText() {
          java.lang.Object ref = text_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            text_ = s;
            return s;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The text to show on the button.
         * </pre>
         *
         * <code>string text = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The bytes for text.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getTextBytes() {
          java.lang.Object ref = text_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            text_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        public static final int POSTBACK_FIELD_NUMBER = 2;
        private volatile java.lang.Object postback_;
        /**
         *
         *
         * <pre>
         * Optional. The text to send back to the Dialogflow API or a URI to
         * open.
         * </pre>
         *
         * <code>string postback = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The postback.
         */
        @java.lang.Override
        public java.lang.String getPostback() {
          java.lang.Object ref = postback_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            postback_ = s;
            return s;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The text to send back to the Dialogflow API or a URI to
         * open.
         * </pre>
         *
         * <code>string postback = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The bytes for postback.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getPostbackBytes() {
          java.lang.Object ref = postback_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            postback_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          if (!getTextBytes().isEmpty()) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 1, text_);
          }
          if (!getPostbackBytes().isEmpty()) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 2, postback_);
          }
          unknownFields.writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (!getTextBytes().isEmpty()) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, text_);
          }
          if (!getPostbackBytes().isEmpty()) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, postback_);
          }
          size += unknownFields.getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj instanceof com.google.cloud.dialogflow.v2.Intent.Message.Card.Button)) {
            return super.equals(obj);
          }
          com.google.cloud.dialogflow.v2.Intent.Message.Card.Button other =
              (com.google.cloud.dialogflow.v2.Intent.Message.Card.Button) obj;

          if (!getText().equals(other.getText())) return false;
          if (!getPostback().equals(other.getPostback())) return false;
          if (!unknownFields.equals(other.unknownFields)) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          hash = (37 * hash) + TEXT_FIELD_NUMBER;
          hash = (53 * hash) + getText().hashCode();
          hash = (37 * hash) + POSTBACK_FIELD_NUMBER;
          hash = (53 * hash) + getPostback().hashCode();
          hash = (29 * hash) + unknownFields.hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.cloud.dialogflow.v2.Intent.Message.Card.Button parseFrom(
            java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.dialogflow.v2.Intent.Message.Card.Button parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.dialogflow.v2.Intent.Message.Card.Button parseFrom(
            com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.dialogflow.v2.Intent.Message.Card.Button parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.dialogflow.v2.Intent.Message.Card.Button parseFrom(
            byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.dialogflow.v2.Intent.Message.Card.Button parseFrom(
            byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.dialogflow.v2.Intent.Message.Card.Button parseFrom(
            java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.dialogflow.v2.Intent.Message.Card.Button parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.dialogflow.v2.Intent.Message.Card.Button parseDelimitedFrom(
            java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.cloud.dialogflow.v2.Intent.Message.Card.Button parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.dialogflow.v2.Intent.Message.Card.Button parseFrom(
            com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.dialogflow.v2.Intent.Message.Card.Button parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.cloud.dialogflow.v2.Intent.Message.Card.Button prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * Contains information about a button.
         * </pre>
         *
         * Protobuf type {@code google.cloud.dialogflow.v2.Intent.Message.Card.Button}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2.Intent.Message.Card.Button)
            com.google.cloud.dialogflow.v2.Intent.Message.Card.ButtonOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.dialogflow.v2.IntentProto
                .internal_static_google_cloud_dialogflow_v2_Intent_Message_Card_Button_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.dialogflow.v2.IntentProto
                .internal_static_google_cloud_dialogflow_v2_Intent_Message_Card_Button_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.dialogflow.v2.Intent.Message.Card.Button.class,
                    com.google.cloud.dialogflow.v2.Intent.Message.Card.Button.Builder.class);
          }

          // Construct using com.google.cloud.dialogflow.v2.Intent.Message.Card.Button.newBuilder()
          private Builder() {
            maybeForceBuilderInitialization();
          }

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            maybeForceBuilderInitialization();
          }

          private void maybeForceBuilderInitialization() {
            if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            text_ = "";

            postback_ = "";

            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.cloud.dialogflow.v2.IntentProto
                .internal_static_google_cloud_dialogflow_v2_Intent_Message_Card_Button_descriptor;
          }

          @java.lang.Override
          public com.google.cloud.dialogflow.v2.Intent.Message.Card.Button
              getDefaultInstanceForType() {
            return com.google.cloud.dialogflow.v2.Intent.Message.Card.Button.getDefaultInstance();
          }

          @java.lang.Override
          public com.google.cloud.dialogflow.v2.Intent.Message.Card.Button build() {
            com.google.cloud.dialogflow.v2.Intent.Message.Card.Button result = buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.cloud.dialogflow.v2.Intent.Message.Card.Button buildPartial() {
            com.google.cloud.dialogflow.v2.Intent.Message.Card.Button result =
                new com.google.cloud.dialogflow.v2.Intent.Message.Card.Button(this);
            result.text_ = text_;
            result.postback_ = postback_;
            onBuilt();
            return result;
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other instanceof com.google.cloud.dialogflow.v2.Intent.Message.Card.Button) {
              return mergeFrom((com.google.cloud.dialogflow.v2.Intent.Message.Card.Button) other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.cloud.dialogflow.v2.Intent.Message.Card.Button other) {
            if (other
                == com.google.cloud.dialogflow.v2.Intent.Message.Card.Button.getDefaultInstance())
              return this;
            if (!other.getText().isEmpty()) {
              text_ = other.text_;
              onChanged();
            }
            if (!other.getPostback().isEmpty()) {
              postback_ = other.postback_;
              onChanged();
            }
            this.mergeUnknownFields(other.unknownFields);
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            com.google.cloud.dialogflow.v2.Intent.Message.Card.Button parsedMessage = null;
            try {
              parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              parsedMessage =
                  (com.google.cloud.dialogflow.v2.Intent.Message.Card.Button)
                      e.getUnfinishedMessage();
              throw e.unwrapIOException();
            } finally {
              if (parsedMessage != null) {
                mergeFrom(parsedMessage);
              }
            }
            return this;
          }

          private java.lang.Object text_ = "";
          /**
           *
           *
           * <pre>
           * Optional. The text to show on the button.
           * </pre>
           *
           * <code>string text = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
           *
           * @return The text.
           */
          public java.lang.String getText() {
            java.lang.Object ref = text_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              text_ = s;
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Optional. The text to show on the button.
           * </pre>
           *
           * <code>string text = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
           *
           * @return The bytes for text.
           */
          public com.google.protobuf.ByteString getTextBytes() {
            java.lang.Object ref = text_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              text_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Optional. The text to show on the button.
           * </pre>
           *
           * <code>string text = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
           *
           * @param value The text to set.
           * @return This builder for chaining.
           */
          public Builder setText(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }

            text_ = value;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Optional. The text to show on the button.
           * </pre>
           *
           * <code>string text = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearText() {

            text_ = getDefaultInstance().getText();
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Optional. The text to show on the button.
           * </pre>
           *
           * <code>string text = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
           *
           * @param value The bytes for text to set.
           * @return This builder for chaining.
           */
          public Builder setTextBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);

            text_ = value;
            onChanged();
            return this;
          }

          private java.lang.Object postback_ = "";
          /**
           *
           *
           * <pre>
           * Optional. The text to send back to the Dialogflow API or a URI to
           * open.
           * </pre>
           *
           * <code>string postback = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
           *
           * @return The postback.
           */
          public java.lang.String getPostback() {
            java.lang.Object ref = postback_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              postback_ = s;
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Optional. The text to send back to the Dialogflow API or a URI to
           * open.
           * </pre>
           *
           * <code>string postback = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
           *
           * @return The bytes for postback.
           */
          public com.google.protobuf.ByteString getPostbackBytes() {
            java.lang.Object ref = postback_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              postback_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Optional. The text to send back to the Dialogflow API or a URI to
           * open.
           * </pre>
           *
           * <code>string postback = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
           *
           * @param value The postback to set.
           * @return This builder for chaining.
           */
          public Builder setPostback(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }

            postback_ = value;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Optional. The text to send back to the Dialogflow API or a URI to
           * open.
           * </pre>
           *
           * <code>string postback = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearPostback() {

            postback_ = getDefaultInstance().getPostback();
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Optional. The text to send back to the Dialogflow API or a URI to
           * open.
           * </pre>
           *
           * <code>string postback = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
           *
           * @param value The bytes for postback to set.
           * @return This builder for chaining.
           */
          public Builder setPostbackBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);

            postback_ = value;
            onChanged();
            return this;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2.Intent.Message.Card.Button)
        }

        // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2.Intent.Message.Card.Button)
        private static final com.google.cloud.dialogflow.v2.Intent.Message.Card.Button
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2.Intent.Message.Card.Button();
        }

        public static com.google.cloud.dialogflow.v2.Intent.Message.Card.Button
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<Button> PARSER =
            new com.google.protobuf.AbstractParser<Button>() {
              @java.lang.Override
              public Button parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                return new Button(input, extensionRegistry);
              }
            };

        public static com.google.protobuf.Parser<Button> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<Button> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.v2.Intent.Message.Card.Button
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      public static final int TITLE_FIELD_NUMBER = 1;
      private volatile java.lang.Object title_;
      /**
       *
       *
       * <pre>
       * Optional. The title of the card.
       * </pre>
       *
       * <code>string title = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The title.
       */
      @java.lang.Override
      public java.lang.String getTitle() {
        java.lang.Object ref = title_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          title_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The title of the card.
       * </pre>
       *
       * <code>string title = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for title.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getTitleBytes() {
        java.lang.Object ref = title_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          title_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int SUBTITLE_FIELD_NUMBER = 2;
      private volatile java.lang.Object subtitle_;
      /**
       *
       *
       * <pre>
       * Optional. The subtitle of the card.
       * </pre>
       *
       * <code>string subtitle = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The subtitle.
       */
      @java.lang.Override
      public java.lang.String getSubtitle() {
        java.lang.Object ref = subtitle_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          subtitle_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The subtitle of the card.
       * </pre>
       *
       * <code>string subtitle = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for subtitle.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getSubtitleBytes() {
        java.lang.Object ref = subtitle_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          subtitle_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int IMAGE_URI_FIELD_NUMBER = 3;
      private volatile java.lang.Object imageUri_;
      /**
       *
       *
       * <pre>
       * Optional. The public URI to an image file for the card.
       * </pre>
       *
       * <code>string image_uri = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The imageUri.
       */
      @java.lang.Override
      public java.lang.String getImageUri() {
        java.lang.Object ref = imageUri_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          imageUri_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The public URI to an image file for the card.
       * </pre>
       *
       * <code>string image_uri = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for imageUri.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getImageUriBytes() {
        java.lang.Object ref = imageUri_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          imageUri_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int BUTTONS_FIELD_NUMBER = 4;
      private java.util.List<com.google.cloud.dialogflow.v2.Intent.Message.Card.Button> buttons_;
      /**
       *
       *
       * <pre>
       * Optional. The collection of card buttons.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.Message.Card.Button buttons = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public java.util.List<com.google.cloud.dialogflow.v2.Intent.Message.Card.Button>
          getButtonsList() {
        return buttons_;
      }
      /**
       *
       *
       * <pre>
       * Optional. The collection of card buttons.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.Message.Card.Button buttons = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              ? extends com.google.cloud.dialogflow.v2.Intent.Message.Card.ButtonOrBuilder>
          getButtonsOrBuilderList() {
        return buttons_;
      }
      /**
       *
       *
       * <pre>
       * Optional. The collection of card buttons.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.Message.Card.Button buttons = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public int getButtonsCount() {
        return buttons_.size();
      }
      /**
       *
       *
       * <pre>
       * Optional. The collection of card buttons.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.Message.Card.Button buttons = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.v2.Intent.Message.Card.Button getButtons(int index) {
        return buttons_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Optional. The collection of card buttons.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.Message.Card.Button buttons = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.v2.Intent.Message.Card.ButtonOrBuilder getButtonsOrBuilder(
          int index) {
        return buttons_.get(index);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!getTitleBytes().isEmpty()) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, title_);
        }
        if (!getSubtitleBytes().isEmpty()) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 2, subtitle_);
        }
        if (!getImageUriBytes().isEmpty()) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 3, imageUri_);
        }
        for (int i = 0; i < buttons_.size(); i++) {
          output.writeMessage(4, buttons_.get(i));
        }
        unknownFields.writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!getTitleBytes().isEmpty()) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, title_);
        }
        if (!getSubtitleBytes().isEmpty()) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, subtitle_);
        }
        if (!getImageUriBytes().isEmpty()) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, imageUri_);
        }
        for (int i = 0; i < buttons_.size(); i++) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, buttons_.get(i));
        }
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.cloud.dialogflow.v2.Intent.Message.Card)) {
          return super.equals(obj);
        }
        com.google.cloud.dialogflow.v2.Intent.Message.Card other =
            (com.google.cloud.dialogflow.v2.Intent.Message.Card) obj;

        if (!getTitle().equals(other.getTitle())) return false;
        if (!getSubtitle().equals(other.getSubtitle())) return false;
        if (!getImageUri().equals(other.getImageUri())) return false;
        if (!getButtonsList().equals(other.getButtonsList())) return false;
        if (!unknownFields.equals(other.unknownFields)) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + TITLE_FIELD_NUMBER;
        hash = (53 * hash) + getTitle().hashCode();
        hash = (37 * hash) + SUBTITLE_FIELD_NUMBER;
        hash = (53 * hash) + getSubtitle().hashCode();
        hash = (37 * hash) + IMAGE_URI_FIELD_NUMBER;
        hash = (53 * hash) + getImageUri().hashCode();
        if (getButtonsCount() > 0) {
          hash = (37 * hash) + BUTTONS_FIELD_NUMBER;
          hash = (53 * hash) + getButtonsList().hashCode();
        }
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.Card parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.Card parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.Card parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.Card parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.Card parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.Card parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.Card parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.Card parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.Card parseDelimitedFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.Card parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.Card parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.Card parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.dialogflow.v2.Intent.Message.Card prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * The card response message.
       * </pre>
       *
       * Protobuf type {@code google.cloud.dialogflow.v2.Intent.Message.Card}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2.Intent.Message.Card)
          com.google.cloud.dialogflow.v2.Intent.Message.CardOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.dialogflow.v2.IntentProto
              .internal_static_google_cloud_dialogflow_v2_Intent_Message_Card_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.dialogflow.v2.IntentProto
              .internal_static_google_cloud_dialogflow_v2_Intent_Message_Card_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.dialogflow.v2.Intent.Message.Card.class,
                  com.google.cloud.dialogflow.v2.Intent.Message.Card.Builder.class);
        }

        // Construct using com.google.cloud.dialogflow.v2.Intent.Message.Card.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
            getButtonsFieldBuilder();
          }
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          title_ = "";

          subtitle_ = "";

          imageUri_ = "";

          if (buttonsBuilder_ == null) {
            buttons_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            buttonsBuilder_.clear();
          }
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.dialogflow.v2.IntentProto
              .internal_static_google_cloud_dialogflow_v2_Intent_Message_Card_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.v2.Intent.Message.Card getDefaultInstanceForType() {
          return com.google.cloud.dialogflow.v2.Intent.Message.Card.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.v2.Intent.Message.Card build() {
          com.google.cloud.dialogflow.v2.Intent.Message.Card result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.v2.Intent.Message.Card buildPartial() {
          com.google.cloud.dialogflow.v2.Intent.Message.Card result =
              new com.google.cloud.dialogflow.v2.Intent.Message.Card(this);
          int from_bitField0_ = bitField0_;
          result.title_ = title_;
          result.subtitle_ = subtitle_;
          result.imageUri_ = imageUri_;
          if (buttonsBuilder_ == null) {
            if (((bitField0_ & 0x00000001) != 0)) {
              buttons_ = java.util.Collections.unmodifiableList(buttons_);
              bitField0_ = (bitField0_ & ~0x00000001);
            }
            result.buttons_ = buttons_;
          } else {
            result.buttons_ = buttonsBuilder_.build();
          }
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.cloud.dialogflow.v2.Intent.Message.Card) {
            return mergeFrom((com.google.cloud.dialogflow.v2.Intent.Message.Card) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.google.cloud.dialogflow.v2.Intent.Message.Card other) {
          if (other == com.google.cloud.dialogflow.v2.Intent.Message.Card.getDefaultInstance())
            return this;
          if (!other.getTitle().isEmpty()) {
            title_ = other.title_;
            onChanged();
          }
          if (!other.getSubtitle().isEmpty()) {
            subtitle_ = other.subtitle_;
            onChanged();
          }
          if (!other.getImageUri().isEmpty()) {
            imageUri_ = other.imageUri_;
            onChanged();
          }
          if (buttonsBuilder_ == null) {
            if (!other.buttons_.isEmpty()) {
              if (buttons_.isEmpty()) {
                buttons_ = other.buttons_;
                bitField0_ = (bitField0_ & ~0x00000001);
              } else {
                ensureButtonsIsMutable();
                buttons_.addAll(other.buttons_);
              }
              onChanged();
            }
          } else {
            if (!other.buttons_.isEmpty()) {
              if (buttonsBuilder_.isEmpty()) {
                buttonsBuilder_.dispose();
                buttonsBuilder_ = null;
                buttons_ = other.buttons_;
                bitField0_ = (bitField0_ & ~0x00000001);
                buttonsBuilder_ =
                    com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                        ? getButtonsFieldBuilder()
                        : null;
              } else {
                buttonsBuilder_.addAllMessages(other.buttons_);
              }
            }
          }
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          com.google.cloud.dialogflow.v2.Intent.Message.Card parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage =
                (com.google.cloud.dialogflow.v2.Intent.Message.Card) e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }

        private int bitField0_;

        private java.lang.Object title_ = "";
        /**
         *
         *
         * <pre>
         * Optional. The title of the card.
         * </pre>
         *
         * <code>string title = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The title.
         */
        public java.lang.String getTitle() {
          java.lang.Object ref = title_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            title_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The title of the card.
         * </pre>
         *
         * <code>string title = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The bytes for title.
         */
        public com.google.protobuf.ByteString getTitleBytes() {
          java.lang.Object ref = title_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            title_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The title of the card.
         * </pre>
         *
         * <code>string title = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The title to set.
         * @return This builder for chaining.
         */
        public Builder setTitle(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }

          title_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The title of the card.
         * </pre>
         *
         * <code>string title = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearTitle() {

          title_ = getDefaultInstance().getTitle();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The title of the card.
         * </pre>
         *
         * <code>string title = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The bytes for title to set.
         * @return This builder for chaining.
         */
        public Builder setTitleBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);

          title_ = value;
          onChanged();
          return this;
        }

        private java.lang.Object subtitle_ = "";
        /**
         *
         *
         * <pre>
         * Optional. The subtitle of the card.
         * </pre>
         *
         * <code>string subtitle = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The subtitle.
         */
        public java.lang.String getSubtitle() {
          java.lang.Object ref = subtitle_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            subtitle_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The subtitle of the card.
         * </pre>
         *
         * <code>string subtitle = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The bytes for subtitle.
         */
        public com.google.protobuf.ByteString getSubtitleBytes() {
          java.lang.Object ref = subtitle_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            subtitle_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The subtitle of the card.
         * </pre>
         *
         * <code>string subtitle = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The subtitle to set.
         * @return This builder for chaining.
         */
        public Builder setSubtitle(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }

          subtitle_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The subtitle of the card.
         * </pre>
         *
         * <code>string subtitle = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearSubtitle() {

          subtitle_ = getDefaultInstance().getSubtitle();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The subtitle of the card.
         * </pre>
         *
         * <code>string subtitle = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The bytes for subtitle to set.
         * @return This builder for chaining.
         */
        public Builder setSubtitleBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);

          subtitle_ = value;
          onChanged();
          return this;
        }

        private java.lang.Object imageUri_ = "";
        /**
         *
         *
         * <pre>
         * Optional. The public URI to an image file for the card.
         * </pre>
         *
         * <code>string image_uri = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The imageUri.
         */
        public java.lang.String getImageUri() {
          java.lang.Object ref = imageUri_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            imageUri_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The public URI to an image file for the card.
         * </pre>
         *
         * <code>string image_uri = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The bytes for imageUri.
         */
        public com.google.protobuf.ByteString getImageUriBytes() {
          java.lang.Object ref = imageUri_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            imageUri_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The public URI to an image file for the card.
         * </pre>
         *
         * <code>string image_uri = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The imageUri to set.
         * @return This builder for chaining.
         */
        public Builder setImageUri(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }

          imageUri_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The public URI to an image file for the card.
         * </pre>
         *
         * <code>string image_uri = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearImageUri() {

          imageUri_ = getDefaultInstance().getImageUri();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The public URI to an image file for the card.
         * </pre>
         *
         * <code>string image_uri = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The bytes for imageUri to set.
         * @return This builder for chaining.
         */
        public Builder setImageUriBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);

          imageUri_ = value;
          onChanged();
          return this;
        }

        private java.util.List<com.google.cloud.dialogflow.v2.Intent.Message.Card.Button> buttons_ =
            java.util.Collections.emptyList();

        private void ensureButtonsIsMutable() {
          if (!((bitField0_ & 0x00000001) != 0)) {
            buttons_ =
                new java.util.ArrayList<com.google.cloud.dialogflow.v2.Intent.Message.Card.Button>(
                    buttons_);
            bitField0_ |= 0x00000001;
          }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.v2.Intent.Message.Card.Button,
                com.google.cloud.dialogflow.v2.Intent.Message.Card.Button.Builder,
                com.google.cloud.dialogflow.v2.Intent.Message.Card.ButtonOrBuilder>
            buttonsBuilder_;

        /**
         *
         *
         * <pre>
         * Optional. The collection of card buttons.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.Card.Button buttons = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public java.util.List<com.google.cloud.dialogflow.v2.Intent.Message.Card.Button>
            getButtonsList() {
          if (buttonsBuilder_ == null) {
            return java.util.Collections.unmodifiableList(buttons_);
          } else {
            return buttonsBuilder_.getMessageList();
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The collection of card buttons.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.Card.Button buttons = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public int getButtonsCount() {
          if (buttonsBuilder_ == null) {
            return buttons_.size();
          } else {
            return buttonsBuilder_.getCount();
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The collection of card buttons.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.Card.Button buttons = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.cloud.dialogflow.v2.Intent.Message.Card.Button getButtons(int index) {
          if (buttonsBuilder_ == null) {
            return buttons_.get(index);
          } else {
            return buttonsBuilder_.getMessage(index);
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The collection of card buttons.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.Card.Button buttons = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder setButtons(
            int index, com.google.cloud.dialogflow.v2.Intent.Message.Card.Button value) {
          if (buttonsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureButtonsIsMutable();
            buttons_.set(index, value);
            onChanged();
          } else {
            buttonsBuilder_.setMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The collection of card buttons.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.Card.Button buttons = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder setButtons(
            int index,
            com.google.cloud.dialogflow.v2.Intent.Message.Card.Button.Builder builderForValue) {
          if (buttonsBuilder_ == null) {
            ensureButtonsIsMutable();
            buttons_.set(index, builderForValue.build());
            onChanged();
          } else {
            buttonsBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The collection of card buttons.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.Card.Button buttons = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder addButtons(com.google.cloud.dialogflow.v2.Intent.Message.Card.Button value) {
          if (buttonsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureButtonsIsMutable();
            buttons_.add(value);
            onChanged();
          } else {
            buttonsBuilder_.addMessage(value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The collection of card buttons.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.Card.Button buttons = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder addButtons(
            int index, com.google.cloud.dialogflow.v2.Intent.Message.Card.Button value) {
          if (buttonsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureButtonsIsMutable();
            buttons_.add(index, value);
            onChanged();
          } else {
            buttonsBuilder_.addMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The collection of card buttons.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.Card.Button buttons = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder addButtons(
            com.google.cloud.dialogflow.v2.Intent.Message.Card.Button.Builder builderForValue) {
          if (buttonsBuilder_ == null) {
            ensureButtonsIsMutable();
            buttons_.add(builderForValue.build());
            onChanged();
          } else {
            buttonsBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The collection of card buttons.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.Card.Button buttons = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder addButtons(
            int index,
            com.google.cloud.dialogflow.v2.Intent.Message.Card.Button.Builder builderForValue) {
          if (buttonsBuilder_ == null) {
            ensureButtonsIsMutable();
            buttons_.add(index, builderForValue.build());
            onChanged();
          } else {
            buttonsBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The collection of card buttons.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.Card.Button buttons = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder addAllButtons(
            java.lang.Iterable<? extends com.google.cloud.dialogflow.v2.Intent.Message.Card.Button>
                values) {
          if (buttonsBuilder_ == null) {
            ensureButtonsIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, buttons_);
            onChanged();
          } else {
            buttonsBuilder_.addAllMessages(values);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The collection of card buttons.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.Card.Button buttons = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder clearButtons() {
          if (buttonsBuilder_ == null) {
            buttons_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000001);
            onChanged();
          } else {
            buttonsBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The collection of card buttons.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.Card.Button buttons = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder removeButtons(int index) {
          if (buttonsBuilder_ == null) {
            ensureButtonsIsMutable();
            buttons_.remove(index);
            onChanged();
          } else {
            buttonsBuilder_.remove(index);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The collection of card buttons.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.Card.Button buttons = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.cloud.dialogflow.v2.Intent.Message.Card.Button.Builder getButtonsBuilder(
            int index) {
          return getButtonsFieldBuilder().getBuilder(index);
        }
        /**
         *
         *
         * <pre>
         * Optional. The collection of card buttons.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.Card.Button buttons = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.cloud.dialogflow.v2.Intent.Message.Card.ButtonOrBuilder
            getButtonsOrBuilder(int index) {
          if (buttonsBuilder_ == null) {
            return buttons_.get(index);
          } else {
            return buttonsBuilder_.getMessageOrBuilder(index);
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The collection of card buttons.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.Card.Button buttons = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public java.util.List<
                ? extends com.google.cloud.dialogflow.v2.Intent.Message.Card.ButtonOrBuilder>
            getButtonsOrBuilderList() {
          if (buttonsBuilder_ != null) {
            return buttonsBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(buttons_);
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The collection of card buttons.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.Card.Button buttons = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.cloud.dialogflow.v2.Intent.Message.Card.Button.Builder
            addButtonsBuilder() {
          return getButtonsFieldBuilder()
              .addBuilder(
                  com.google.cloud.dialogflow.v2.Intent.Message.Card.Button.getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * Optional. The collection of card buttons.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.Card.Button buttons = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.cloud.dialogflow.v2.Intent.Message.Card.Button.Builder addButtonsBuilder(
            int index) {
          return getButtonsFieldBuilder()
              .addBuilder(
                  index,
                  com.google.cloud.dialogflow.v2.Intent.Message.Card.Button.getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * Optional. The collection of card buttons.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.Card.Button buttons = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public java.util.List<com.google.cloud.dialogflow.v2.Intent.Message.Card.Button.Builder>
            getButtonsBuilderList() {
          return getButtonsFieldBuilder().getBuilderList();
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.v2.Intent.Message.Card.Button,
                com.google.cloud.dialogflow.v2.Intent.Message.Card.Button.Builder,
                com.google.cloud.dialogflow.v2.Intent.Message.Card.ButtonOrBuilder>
            getButtonsFieldBuilder() {
          if (buttonsBuilder_ == null) {
            buttonsBuilder_ =
                new com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.cloud.dialogflow.v2.Intent.Message.Card.Button,
                    com.google.cloud.dialogflow.v2.Intent.Message.Card.Button.Builder,
                    com.google.cloud.dialogflow.v2.Intent.Message.Card.ButtonOrBuilder>(
                    buttons_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
            buttons_ = null;
          }
          return buttonsBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2.Intent.Message.Card)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2.Intent.Message.Card)
      private static final com.google.cloud.dialogflow.v2.Intent.Message.Card DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2.Intent.Message.Card();
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.Card getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Card> PARSER =
          new com.google.protobuf.AbstractParser<Card>() {
            @java.lang.Override
            public Card parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              return new Card(input, extensionRegistry);
            }
          };

      public static com.google.protobuf.Parser<Card> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Card> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2.Intent.Message.Card getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface SimpleResponseOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.v2.Intent.Message.SimpleResponse)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * One of text_to_speech or ssml must be provided. The plain text of the
       * speech output. Mutually exclusive with ssml.
       * </pre>
       *
       * <code>string text_to_speech = 1;</code>
       *
       * @return The textToSpeech.
       */
      java.lang.String getTextToSpeech();
      /**
       *
       *
       * <pre>
       * One of text_to_speech or ssml must be provided. The plain text of the
       * speech output. Mutually exclusive with ssml.
       * </pre>
       *
       * <code>string text_to_speech = 1;</code>
       *
       * @return The bytes for textToSpeech.
       */
      com.google.protobuf.ByteString getTextToSpeechBytes();

      /**
       *
       *
       * <pre>
       * One of text_to_speech or ssml must be provided. Structured spoken
       * response to the user in the SSML format. Mutually exclusive with
       * text_to_speech.
       * </pre>
       *
       * <code>string ssml = 2;</code>
       *
       * @return The ssml.
       */
      java.lang.String getSsml();
      /**
       *
       *
       * <pre>
       * One of text_to_speech or ssml must be provided. Structured spoken
       * response to the user in the SSML format. Mutually exclusive with
       * text_to_speech.
       * </pre>
       *
       * <code>string ssml = 2;</code>
       *
       * @return The bytes for ssml.
       */
      com.google.protobuf.ByteString getSsmlBytes();

      /**
       *
       *
       * <pre>
       * Optional. The text to display.
       * </pre>
       *
       * <code>string display_text = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The displayText.
       */
      java.lang.String getDisplayText();
      /**
       *
       *
       * <pre>
       * Optional. The text to display.
       * </pre>
       *
       * <code>string display_text = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for displayText.
       */
      com.google.protobuf.ByteString getDisplayTextBytes();
    }
    /**
     *
     *
     * <pre>
     * The simple response message containing speech or text.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.v2.Intent.Message.SimpleResponse}
     */
    public static final class SimpleResponse extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2.Intent.Message.SimpleResponse)
        SimpleResponseOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use SimpleResponse.newBuilder() to construct.
      private SimpleResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private SimpleResponse() {
        textToSpeech_ = "";
        ssml_ = "";
        displayText_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new SimpleResponse();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
      }

      private SimpleResponse(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();

                  textToSpeech_ = s;
                  break;
                }
              case 18:
                {
                  java.lang.String s = input.readStringRequireUtf8();

                  ssml_ = s;
                  break;
                }
              case 26:
                {
                  java.lang.String s = input.readStringRequireUtf8();

                  displayText_ = s;
                  break;
                }
              default:
                {
                  if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                    done = true;
                  }
                  break;
                }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(this);
        } finally {
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.v2.IntentProto
            .internal_static_google_cloud_dialogflow_v2_Intent_Message_SimpleResponse_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.v2.IntentProto
            .internal_static_google_cloud_dialogflow_v2_Intent_Message_SimpleResponse_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponse.class,
                com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponse.Builder.class);
      }

      public static final int TEXT_TO_SPEECH_FIELD_NUMBER = 1;
      private volatile java.lang.Object textToSpeech_;
      /**
       *
       *
       * <pre>
       * One of text_to_speech or ssml must be provided. The plain text of the
       * speech output. Mutually exclusive with ssml.
       * </pre>
       *
       * <code>string text_to_speech = 1;</code>
       *
       * @return The textToSpeech.
       */
      @java.lang.Override
      public java.lang.String getTextToSpeech() {
        java.lang.Object ref = textToSpeech_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          textToSpeech_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * One of text_to_speech or ssml must be provided. The plain text of the
       * speech output. Mutually exclusive with ssml.
       * </pre>
       *
       * <code>string text_to_speech = 1;</code>
       *
       * @return The bytes for textToSpeech.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getTextToSpeechBytes() {
        java.lang.Object ref = textToSpeech_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          textToSpeech_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int SSML_FIELD_NUMBER = 2;
      private volatile java.lang.Object ssml_;
      /**
       *
       *
       * <pre>
       * One of text_to_speech or ssml must be provided. Structured spoken
       * response to the user in the SSML format. Mutually exclusive with
       * text_to_speech.
       * </pre>
       *
       * <code>string ssml = 2;</code>
       *
       * @return The ssml.
       */
      @java.lang.Override
      public java.lang.String getSsml() {
        java.lang.Object ref = ssml_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          ssml_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * One of text_to_speech or ssml must be provided. Structured spoken
       * response to the user in the SSML format. Mutually exclusive with
       * text_to_speech.
       * </pre>
       *
       * <code>string ssml = 2;</code>
       *
       * @return The bytes for ssml.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getSsmlBytes() {
        java.lang.Object ref = ssml_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          ssml_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int DISPLAY_TEXT_FIELD_NUMBER = 3;
      private volatile java.lang.Object displayText_;
      /**
       *
       *
       * <pre>
       * Optional. The text to display.
       * </pre>
       *
       * <code>string display_text = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The displayText.
       */
      @java.lang.Override
      public java.lang.String getDisplayText() {
        java.lang.Object ref = displayText_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          displayText_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The text to display.
       * </pre>
       *
       * <code>string display_text = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for displayText.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getDisplayTextBytes() {
        java.lang.Object ref = displayText_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          displayText_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!getTextToSpeechBytes().isEmpty()) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, textToSpeech_);
        }
        if (!getSsmlBytes().isEmpty()) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 2, ssml_);
        }
        if (!getDisplayTextBytes().isEmpty()) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 3, displayText_);
        }
        unknownFields.writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!getTextToSpeechBytes().isEmpty()) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, textToSpeech_);
        }
        if (!getSsmlBytes().isEmpty()) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, ssml_);
        }
        if (!getDisplayTextBytes().isEmpty()) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, displayText_);
        }
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponse)) {
          return super.equals(obj);
        }
        com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponse other =
            (com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponse) obj;

        if (!getTextToSpeech().equals(other.getTextToSpeech())) return false;
        if (!getSsml().equals(other.getSsml())) return false;
        if (!getDisplayText().equals(other.getDisplayText())) return false;
        if (!unknownFields.equals(other.unknownFields)) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + TEXT_TO_SPEECH_FIELD_NUMBER;
        hash = (53 * hash) + getTextToSpeech().hashCode();
        hash = (37 * hash) + SSML_FIELD_NUMBER;
        hash = (53 * hash) + getSsml().hashCode();
        hash = (37 * hash) + DISPLAY_TEXT_FIELD_NUMBER;
        hash = (53 * hash) + getDisplayText().hashCode();
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponse parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponse parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponse parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponse parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponse parseFrom(
          byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponse parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponse parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponse parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponse parseDelimitedFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponse parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponse parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponse parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponse prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * The simple response message containing speech or text.
       * </pre>
       *
       * Protobuf type {@code google.cloud.dialogflow.v2.Intent.Message.SimpleResponse}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2.Intent.Message.SimpleResponse)
          com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponseOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.dialogflow.v2.IntentProto
              .internal_static_google_cloud_dialogflow_v2_Intent_Message_SimpleResponse_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.dialogflow.v2.IntentProto
              .internal_static_google_cloud_dialogflow_v2_Intent_Message_SimpleResponse_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponse.class,
                  com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponse.Builder.class);
        }

        // Construct using com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponse.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          textToSpeech_ = "";

          ssml_ = "";

          displayText_ = "";

          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.dialogflow.v2.IntentProto
              .internal_static_google_cloud_dialogflow_v2_Intent_Message_SimpleResponse_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponse
            getDefaultInstanceForType() {
          return com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponse.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponse build() {
          com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponse result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponse buildPartial() {
          com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponse result =
              new com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponse(this);
          result.textToSpeech_ = textToSpeech_;
          result.ssml_ = ssml_;
          result.displayText_ = displayText_;
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponse) {
            return mergeFrom((com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponse) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponse other) {
          if (other
              == com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponse.getDefaultInstance())
            return this;
          if (!other.getTextToSpeech().isEmpty()) {
            textToSpeech_ = other.textToSpeech_;
            onChanged();
          }
          if (!other.getSsml().isEmpty()) {
            ssml_ = other.ssml_;
            onChanged();
          }
          if (!other.getDisplayText().isEmpty()) {
            displayText_ = other.displayText_;
            onChanged();
          }
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponse parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage =
                (com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponse)
                    e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }

        private java.lang.Object textToSpeech_ = "";
        /**
         *
         *
         * <pre>
         * One of text_to_speech or ssml must be provided. The plain text of the
         * speech output. Mutually exclusive with ssml.
         * </pre>
         *
         * <code>string text_to_speech = 1;</code>
         *
         * @return The textToSpeech.
         */
        public java.lang.String getTextToSpeech() {
          java.lang.Object ref = textToSpeech_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            textToSpeech_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * One of text_to_speech or ssml must be provided. The plain text of the
         * speech output. Mutually exclusive with ssml.
         * </pre>
         *
         * <code>string text_to_speech = 1;</code>
         *
         * @return The bytes for textToSpeech.
         */
        public com.google.protobuf.ByteString getTextToSpeechBytes() {
          java.lang.Object ref = textToSpeech_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            textToSpeech_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * One of text_to_speech or ssml must be provided. The plain text of the
         * speech output. Mutually exclusive with ssml.
         * </pre>
         *
         * <code>string text_to_speech = 1;</code>
         *
         * @param value The textToSpeech to set.
         * @return This builder for chaining.
         */
        public Builder setTextToSpeech(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }

          textToSpeech_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * One of text_to_speech or ssml must be provided. The plain text of the
         * speech output. Mutually exclusive with ssml.
         * </pre>
         *
         * <code>string text_to_speech = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearTextToSpeech() {

          textToSpeech_ = getDefaultInstance().getTextToSpeech();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * One of text_to_speech or ssml must be provided. The plain text of the
         * speech output. Mutually exclusive with ssml.
         * </pre>
         *
         * <code>string text_to_speech = 1;</code>
         *
         * @param value The bytes for textToSpeech to set.
         * @return This builder for chaining.
         */
        public Builder setTextToSpeechBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);

          textToSpeech_ = value;
          onChanged();
          return this;
        }

        private java.lang.Object ssml_ = "";
        /**
         *
         *
         * <pre>
         * One of text_to_speech or ssml must be provided. Structured spoken
         * response to the user in the SSML format. Mutually exclusive with
         * text_to_speech.
         * </pre>
         *
         * <code>string ssml = 2;</code>
         *
         * @return The ssml.
         */
        public java.lang.String getSsml() {
          java.lang.Object ref = ssml_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            ssml_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * One of text_to_speech or ssml must be provided. Structured spoken
         * response to the user in the SSML format. Mutually exclusive with
         * text_to_speech.
         * </pre>
         *
         * <code>string ssml = 2;</code>
         *
         * @return The bytes for ssml.
         */
        public com.google.protobuf.ByteString getSsmlBytes() {
          java.lang.Object ref = ssml_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            ssml_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * One of text_to_speech or ssml must be provided. Structured spoken
         * response to the user in the SSML format. Mutually exclusive with
         * text_to_speech.
         * </pre>
         *
         * <code>string ssml = 2;</code>
         *
         * @param value The ssml to set.
         * @return This builder for chaining.
         */
        public Builder setSsml(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }

          ssml_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * One of text_to_speech or ssml must be provided. Structured spoken
         * response to the user in the SSML format. Mutually exclusive with
         * text_to_speech.
         * </pre>
         *
         * <code>string ssml = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearSsml() {

          ssml_ = getDefaultInstance().getSsml();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * One of text_to_speech or ssml must be provided. Structured spoken
         * response to the user in the SSML format. Mutually exclusive with
         * text_to_speech.
         * </pre>
         *
         * <code>string ssml = 2;</code>
         *
         * @param value The bytes for ssml to set.
         * @return This builder for chaining.
         */
        public Builder setSsmlBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);

          ssml_ = value;
          onChanged();
          return this;
        }

        private java.lang.Object displayText_ = "";
        /**
         *
         *
         * <pre>
         * Optional. The text to display.
         * </pre>
         *
         * <code>string display_text = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The displayText.
         */
        public java.lang.String getDisplayText() {
          java.lang.Object ref = displayText_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            displayText_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The text to display.
         * </pre>
         *
         * <code>string display_text = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The bytes for displayText.
         */
        public com.google.protobuf.ByteString getDisplayTextBytes() {
          java.lang.Object ref = displayText_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            displayText_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The text to display.
         * </pre>
         *
         * <code>string display_text = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The displayText to set.
         * @return This builder for chaining.
         */
        public Builder setDisplayText(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }

          displayText_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The text to display.
         * </pre>
         *
         * <code>string display_text = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearDisplayText() {

          displayText_ = getDefaultInstance().getDisplayText();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The text to display.
         * </pre>
         *
         * <code>string display_text = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The bytes for displayText to set.
         * @return This builder for chaining.
         */
        public Builder setDisplayTextBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);

          displayText_ = value;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2.Intent.Message.SimpleResponse)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2.Intent.Message.SimpleResponse)
      private static final com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponse
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponse();
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponse
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<SimpleResponse> PARSER =
          new com.google.protobuf.AbstractParser<SimpleResponse>() {
            @java.lang.Override
            public SimpleResponse parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              return new SimpleResponse(input, extensionRegistry);
            }
          };

      public static com.google.protobuf.Parser<SimpleResponse> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<SimpleResponse> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponse
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface SimpleResponsesOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.v2.Intent.Message.SimpleResponses)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Required. The list of simple responses.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.Message.SimpleResponse simple_responses = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      java.util.List<com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponse>
          getSimpleResponsesList();
      /**
       *
       *
       * <pre>
       * Required. The list of simple responses.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.Message.SimpleResponse simple_responses = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponse getSimpleResponses(int index);
      /**
       *
       *
       * <pre>
       * Required. The list of simple responses.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.Message.SimpleResponse simple_responses = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      int getSimpleResponsesCount();
      /**
       *
       *
       * <pre>
       * Required. The list of simple responses.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.Message.SimpleResponse simple_responses = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      java.util.List<
              ? extends com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponseOrBuilder>
          getSimpleResponsesOrBuilderList();
      /**
       *
       *
       * <pre>
       * Required. The list of simple responses.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.Message.SimpleResponse simple_responses = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponseOrBuilder
          getSimpleResponsesOrBuilder(int index);
    }
    /**
     *
     *
     * <pre>
     * The collection of simple response candidates.
     * This message in `QueryResult.fulfillment_messages` and
     * `WebhookResponse.fulfillment_messages` should contain only one
     * `SimpleResponse`.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.v2.Intent.Message.SimpleResponses}
     */
    public static final class SimpleResponses extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2.Intent.Message.SimpleResponses)
        SimpleResponsesOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use SimpleResponses.newBuilder() to construct.
      private SimpleResponses(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private SimpleResponses() {
        simpleResponses_ = java.util.Collections.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new SimpleResponses();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
      }

      private SimpleResponses(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        int mutable_bitField0_ = 0;
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                    simpleResponses_ =
                        new java.util.ArrayList<
                            com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponse>();
                    mutable_bitField0_ |= 0x00000001;
                  }
                  simpleResponses_.add(
                      input.readMessage(
                          com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponse.parser(),
                          extensionRegistry));
                  break;
                }
              default:
                {
                  if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                    done = true;
                  }
                  break;
                }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(this);
        } finally {
          if (((mutable_bitField0_ & 0x00000001) != 0)) {
            simpleResponses_ = java.util.Collections.unmodifiableList(simpleResponses_);
          }
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.v2.IntentProto
            .internal_static_google_cloud_dialogflow_v2_Intent_Message_SimpleResponses_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.v2.IntentProto
            .internal_static_google_cloud_dialogflow_v2_Intent_Message_SimpleResponses_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponses.class,
                com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponses.Builder.class);
      }

      public static final int SIMPLE_RESPONSES_FIELD_NUMBER = 1;
      private java.util.List<com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponse>
          simpleResponses_;
      /**
       *
       *
       * <pre>
       * Required. The list of simple responses.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.Message.SimpleResponse simple_responses = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      @java.lang.Override
      public java.util.List<com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponse>
          getSimpleResponsesList() {
        return simpleResponses_;
      }
      /**
       *
       *
       * <pre>
       * Required. The list of simple responses.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.Message.SimpleResponse simple_responses = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              ? extends com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponseOrBuilder>
          getSimpleResponsesOrBuilderList() {
        return simpleResponses_;
      }
      /**
       *
       *
       * <pre>
       * Required. The list of simple responses.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.Message.SimpleResponse simple_responses = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      @java.lang.Override
      public int getSimpleResponsesCount() {
        return simpleResponses_.size();
      }
      /**
       *
       *
       * <pre>
       * Required. The list of simple responses.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.Message.SimpleResponse simple_responses = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponse getSimpleResponses(
          int index) {
        return simpleResponses_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Required. The list of simple responses.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.Message.SimpleResponse simple_responses = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponseOrBuilder
          getSimpleResponsesOrBuilder(int index) {
        return simpleResponses_.get(index);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        for (int i = 0; i < simpleResponses_.size(); i++) {
          output.writeMessage(1, simpleResponses_.get(i));
        }
        unknownFields.writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        for (int i = 0; i < simpleResponses_.size(); i++) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(1, simpleResponses_.get(i));
        }
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponses)) {
          return super.equals(obj);
        }
        com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponses other =
            (com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponses) obj;

        if (!getSimpleResponsesList().equals(other.getSimpleResponsesList())) return false;
        if (!unknownFields.equals(other.unknownFields)) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (getSimpleResponsesCount() > 0) {
          hash = (37 * hash) + SIMPLE_RESPONSES_FIELD_NUMBER;
          hash = (53 * hash) + getSimpleResponsesList().hashCode();
        }
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponses parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponses parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponses parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponses parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponses parseFrom(
          byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponses parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponses parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponses parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponses
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponses
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponses parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponses parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponses prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * The collection of simple response candidates.
       * This message in `QueryResult.fulfillment_messages` and
       * `WebhookResponse.fulfillment_messages` should contain only one
       * `SimpleResponse`.
       * </pre>
       *
       * Protobuf type {@code google.cloud.dialogflow.v2.Intent.Message.SimpleResponses}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2.Intent.Message.SimpleResponses)
          com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponsesOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.dialogflow.v2.IntentProto
              .internal_static_google_cloud_dialogflow_v2_Intent_Message_SimpleResponses_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.dialogflow.v2.IntentProto
              .internal_static_google_cloud_dialogflow_v2_Intent_Message_SimpleResponses_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponses.class,
                  com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponses.Builder.class);
        }

        // Construct using
        // com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponses.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
            getSimpleResponsesFieldBuilder();
          }
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          if (simpleResponsesBuilder_ == null) {
            simpleResponses_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            simpleResponsesBuilder_.clear();
          }
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.dialogflow.v2.IntentProto
              .internal_static_google_cloud_dialogflow_v2_Intent_Message_SimpleResponses_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponses
            getDefaultInstanceForType() {
          return com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponses.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponses build() {
          com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponses result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponses buildPartial() {
          com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponses result =
              new com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponses(this);
          int from_bitField0_ = bitField0_;
          if (simpleResponsesBuilder_ == null) {
            if (((bitField0_ & 0x00000001) != 0)) {
              simpleResponses_ = java.util.Collections.unmodifiableList(simpleResponses_);
              bitField0_ = (bitField0_ & ~0x00000001);
            }
            result.simpleResponses_ = simpleResponses_;
          } else {
            result.simpleResponses_ = simpleResponsesBuilder_.build();
          }
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponses) {
            return mergeFrom((com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponses) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponses other) {
          if (other
              == com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponses.getDefaultInstance())
            return this;
          if (simpleResponsesBuilder_ == null) {
            if (!other.simpleResponses_.isEmpty()) {
              if (simpleResponses_.isEmpty()) {
                simpleResponses_ = other.simpleResponses_;
                bitField0_ = (bitField0_ & ~0x00000001);
              } else {
                ensureSimpleResponsesIsMutable();
                simpleResponses_.addAll(other.simpleResponses_);
              }
              onChanged();
            }
          } else {
            if (!other.simpleResponses_.isEmpty()) {
              if (simpleResponsesBuilder_.isEmpty()) {
                simpleResponsesBuilder_.dispose();
                simpleResponsesBuilder_ = null;
                simpleResponses_ = other.simpleResponses_;
                bitField0_ = (bitField0_ & ~0x00000001);
                simpleResponsesBuilder_ =
                    com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                        ? getSimpleResponsesFieldBuilder()
                        : null;
              } else {
                simpleResponsesBuilder_.addAllMessages(other.simpleResponses_);
              }
            }
          }
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponses parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage =
                (com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponses)
                    e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }

        private int bitField0_;

        private java.util.List<com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponse>
            simpleResponses_ = java.util.Collections.emptyList();

        private void ensureSimpleResponsesIsMutable() {
          if (!((bitField0_ & 0x00000001) != 0)) {
            simpleResponses_ =
                new java.util.ArrayList<
                    com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponse>(simpleResponses_);
            bitField0_ |= 0x00000001;
          }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponse,
                com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponse.Builder,
                com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponseOrBuilder>
            simpleResponsesBuilder_;

        /**
         *
         *
         * <pre>
         * Required. The list of simple responses.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.SimpleResponse simple_responses = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public java.util.List<com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponse>
            getSimpleResponsesList() {
          if (simpleResponsesBuilder_ == null) {
            return java.util.Collections.unmodifiableList(simpleResponses_);
          } else {
            return simpleResponsesBuilder_.getMessageList();
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The list of simple responses.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.SimpleResponse simple_responses = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public int getSimpleResponsesCount() {
          if (simpleResponsesBuilder_ == null) {
            return simpleResponses_.size();
          } else {
            return simpleResponsesBuilder_.getCount();
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The list of simple responses.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.SimpleResponse simple_responses = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponse getSimpleResponses(
            int index) {
          if (simpleResponsesBuilder_ == null) {
            return simpleResponses_.get(index);
          } else {
            return simpleResponsesBuilder_.getMessage(index);
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The list of simple responses.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.SimpleResponse simple_responses = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder setSimpleResponses(
            int index, com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponse value) {
          if (simpleResponsesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureSimpleResponsesIsMutable();
            simpleResponses_.set(index, value);
            onChanged();
          } else {
            simpleResponsesBuilder_.setMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The list of simple responses.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.SimpleResponse simple_responses = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder setSimpleResponses(
            int index,
            com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponse.Builder builderForValue) {
          if (simpleResponsesBuilder_ == null) {
            ensureSimpleResponsesIsMutable();
            simpleResponses_.set(index, builderForValue.build());
            onChanged();
          } else {
            simpleResponsesBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The list of simple responses.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.SimpleResponse simple_responses = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder addSimpleResponses(
            com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponse value) {
          if (simpleResponsesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureSimpleResponsesIsMutable();
            simpleResponses_.add(value);
            onChanged();
          } else {
            simpleResponsesBuilder_.addMessage(value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The list of simple responses.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.SimpleResponse simple_responses = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder addSimpleResponses(
            int index, com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponse value) {
          if (simpleResponsesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureSimpleResponsesIsMutable();
            simpleResponses_.add(index, value);
            onChanged();
          } else {
            simpleResponsesBuilder_.addMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The list of simple responses.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.SimpleResponse simple_responses = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder addSimpleResponses(
            com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponse.Builder builderForValue) {
          if (simpleResponsesBuilder_ == null) {
            ensureSimpleResponsesIsMutable();
            simpleResponses_.add(builderForValue.build());
            onChanged();
          } else {
            simpleResponsesBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The list of simple responses.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.SimpleResponse simple_responses = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder addSimpleResponses(
            int index,
            com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponse.Builder builderForValue) {
          if (simpleResponsesBuilder_ == null) {
            ensureSimpleResponsesIsMutable();
            simpleResponses_.add(index, builderForValue.build());
            onChanged();
          } else {
            simpleResponsesBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The list of simple responses.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.SimpleResponse simple_responses = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder addAllSimpleResponses(
            java.lang.Iterable<
                    ? extends com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponse>
                values) {
          if (simpleResponsesBuilder_ == null) {
            ensureSimpleResponsesIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, simpleResponses_);
            onChanged();
          } else {
            simpleResponsesBuilder_.addAllMessages(values);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The list of simple responses.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.SimpleResponse simple_responses = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder clearSimpleResponses() {
          if (simpleResponsesBuilder_ == null) {
            simpleResponses_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000001);
            onChanged();
          } else {
            simpleResponsesBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The list of simple responses.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.SimpleResponse simple_responses = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder removeSimpleResponses(int index) {
          if (simpleResponsesBuilder_ == null) {
            ensureSimpleResponsesIsMutable();
            simpleResponses_.remove(index);
            onChanged();
          } else {
            simpleResponsesBuilder_.remove(index);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The list of simple responses.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.SimpleResponse simple_responses = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponse.Builder
            getSimpleResponsesBuilder(int index) {
          return getSimpleResponsesFieldBuilder().getBuilder(index);
        }
        /**
         *
         *
         * <pre>
         * Required. The list of simple responses.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.SimpleResponse simple_responses = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponseOrBuilder
            getSimpleResponsesOrBuilder(int index) {
          if (simpleResponsesBuilder_ == null) {
            return simpleResponses_.get(index);
          } else {
            return simpleResponsesBuilder_.getMessageOrBuilder(index);
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The list of simple responses.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.SimpleResponse simple_responses = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public java.util.List<
                ? extends com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponseOrBuilder>
            getSimpleResponsesOrBuilderList() {
          if (simpleResponsesBuilder_ != null) {
            return simpleResponsesBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(simpleResponses_);
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The list of simple responses.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.SimpleResponse simple_responses = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponse.Builder
            addSimpleResponsesBuilder() {
          return getSimpleResponsesFieldBuilder()
              .addBuilder(
                  com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponse
                      .getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * Required. The list of simple responses.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.SimpleResponse simple_responses = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponse.Builder
            addSimpleResponsesBuilder(int index) {
          return getSimpleResponsesFieldBuilder()
              .addBuilder(
                  index,
                  com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponse
                      .getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * Required. The list of simple responses.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.SimpleResponse simple_responses = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public java.util.List<com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponse.Builder>
            getSimpleResponsesBuilderList() {
          return getSimpleResponsesFieldBuilder().getBuilderList();
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponse,
                com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponse.Builder,
                com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponseOrBuilder>
            getSimpleResponsesFieldBuilder() {
          if (simpleResponsesBuilder_ == null) {
            simpleResponsesBuilder_ =
                new com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponse,
                    com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponse.Builder,
                    com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponseOrBuilder>(
                    simpleResponses_,
                    ((bitField0_ & 0x00000001) != 0),
                    getParentForChildren(),
                    isClean());
            simpleResponses_ = null;
          }
          return simpleResponsesBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2.Intent.Message.SimpleResponses)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2.Intent.Message.SimpleResponses)
      private static final com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponses
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponses();
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponses
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<SimpleResponses> PARSER =
          new com.google.protobuf.AbstractParser<SimpleResponses>() {
            @java.lang.Override
            public SimpleResponses parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              return new SimpleResponses(input, extensionRegistry);
            }
          };

      public static com.google.protobuf.Parser<SimpleResponses> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<SimpleResponses> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2.Intent.Message.SimpleResponses
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface BasicCardOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.v2.Intent.Message.BasicCard)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Optional. The title of the card.
       * </pre>
       *
       * <code>string title = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The title.
       */
      java.lang.String getTitle();
      /**
       *
       *
       * <pre>
       * Optional. The title of the card.
       * </pre>
       *
       * <code>string title = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for title.
       */
      com.google.protobuf.ByteString getTitleBytes();

      /**
       *
       *
       * <pre>
       * Optional. The subtitle of the card.
       * </pre>
       *
       * <code>string subtitle = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The subtitle.
       */
      java.lang.String getSubtitle();
      /**
       *
       *
       * <pre>
       * Optional. The subtitle of the card.
       * </pre>
       *
       * <code>string subtitle = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for subtitle.
       */
      com.google.protobuf.ByteString getSubtitleBytes();

      /**
       *
       *
       * <pre>
       * Required, unless image is present. The body text of the card.
       * </pre>
       *
       * <code>string formatted_text = 3;</code>
       *
       * @return The formattedText.
       */
      java.lang.String getFormattedText();
      /**
       *
       *
       * <pre>
       * Required, unless image is present. The body text of the card.
       * </pre>
       *
       * <code>string formatted_text = 3;</code>
       *
       * @return The bytes for formattedText.
       */
      com.google.protobuf.ByteString getFormattedTextBytes();

      /**
       *
       *
       * <pre>
       * Optional. The image for the card.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2.Intent.Message.Image image = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the image field is set.
       */
      boolean hasImage();
      /**
       *
       *
       * <pre>
       * Optional. The image for the card.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2.Intent.Message.Image image = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The image.
       */
      com.google.cloud.dialogflow.v2.Intent.Message.Image getImage();
      /**
       *
       *
       * <pre>
       * Optional. The image for the card.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2.Intent.Message.Image image = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      com.google.cloud.dialogflow.v2.Intent.Message.ImageOrBuilder getImageOrBuilder();

      /**
       *
       *
       * <pre>
       * Optional. The collection of card buttons.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button buttons = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      java.util.List<com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button>
          getButtonsList();
      /**
       *
       *
       * <pre>
       * Optional. The collection of card buttons.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button buttons = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button getButtons(int index);
      /**
       *
       *
       * <pre>
       * Optional. The collection of card buttons.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button buttons = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      int getButtonsCount();
      /**
       *
       *
       * <pre>
       * Optional. The collection of card buttons.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button buttons = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      java.util.List<
              ? extends com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.ButtonOrBuilder>
          getButtonsOrBuilderList();
      /**
       *
       *
       * <pre>
       * Optional. The collection of card buttons.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button buttons = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.ButtonOrBuilder getButtonsOrBuilder(
          int index);
    }
    /**
     *
     *
     * <pre>
     * The basic card message. Useful for displaying information.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.v2.Intent.Message.BasicCard}
     */
    public static final class BasicCard extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2.Intent.Message.BasicCard)
        BasicCardOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use BasicCard.newBuilder() to construct.
      private BasicCard(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private BasicCard() {
        title_ = "";
        subtitle_ = "";
        formattedText_ = "";
        buttons_ = java.util.Collections.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new BasicCard();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
      }

      private BasicCard(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        int mutable_bitField0_ = 0;
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();

                  title_ = s;
                  break;
                }
              case 18:
                {
                  java.lang.String s = input.readStringRequireUtf8();

                  subtitle_ = s;
                  break;
                }
              case 26:
                {
                  java.lang.String s = input.readStringRequireUtf8();

                  formattedText_ = s;
                  break;
                }
              case 34:
                {
                  com.google.cloud.dialogflow.v2.Intent.Message.Image.Builder subBuilder = null;
                  if (image_ != null) {
                    subBuilder = image_.toBuilder();
                  }
                  image_ =
                      input.readMessage(
                          com.google.cloud.dialogflow.v2.Intent.Message.Image.parser(),
                          extensionRegistry);
                  if (subBuilder != null) {
                    subBuilder.mergeFrom(image_);
                    image_ = subBuilder.buildPartial();
                  }

                  break;
                }
              case 42:
                {
                  if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                    buttons_ =
                        new java.util.ArrayList<
                            com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button>();
                    mutable_bitField0_ |= 0x00000001;
                  }
                  buttons_.add(
                      input.readMessage(
                          com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.parser(),
                          extensionRegistry));
                  break;
                }
              default:
                {
                  if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                    done = true;
                  }
                  break;
                }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(this);
        } finally {
          if (((mutable_bitField0_ & 0x00000001) != 0)) {
            buttons_ = java.util.Collections.unmodifiableList(buttons_);
          }
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.v2.IntentProto
            .internal_static_google_cloud_dialogflow_v2_Intent_Message_BasicCard_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.v2.IntentProto
            .internal_static_google_cloud_dialogflow_v2_Intent_Message_BasicCard_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.class,
                com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Builder.class);
      }

      public interface ButtonOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * Required. The title of the button.
         * </pre>
         *
         * <code>string title = 1;</code>
         *
         * @return The title.
         */
        java.lang.String getTitle();
        /**
         *
         *
         * <pre>
         * Required. The title of the button.
         * </pre>
         *
         * <code>string title = 1;</code>
         *
         * @return The bytes for title.
         */
        com.google.protobuf.ByteString getTitleBytes();

        /**
         *
         *
         * <pre>
         * Required. Action to take when a user taps on the button.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction open_uri_action = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return Whether the openUriAction field is set.
         */
        boolean hasOpenUriAction();
        /**
         *
         *
         * <pre>
         * Required. Action to take when a user taps on the button.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction open_uri_action = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return The openUriAction.
         */
        com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction
            getOpenUriAction();
        /**
         *
         *
         * <pre>
         * Required. Action to take when a user taps on the button.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction open_uri_action = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriActionOrBuilder
            getOpenUriActionOrBuilder();
      }
      /**
       *
       *
       * <pre>
       * The button object that appears at the bottom of a card.
       * </pre>
       *
       * Protobuf type {@code google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button}
       */
      public static final class Button extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button)
          ButtonOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use Button.newBuilder() to construct.
        private Button(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private Button() {
          title_ = "";
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new Button();
        }

        @java.lang.Override
        public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
          return this.unknownFields;
        }

        private Button(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          this();
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          com.google.protobuf.UnknownFieldSet.Builder unknownFields =
              com.google.protobuf.UnknownFieldSet.newBuilder();
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    java.lang.String s = input.readStringRequireUtf8();

                    title_ = s;
                    break;
                  }
                case 18:
                  {
                    com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction
                            .Builder
                        subBuilder = null;
                    if (openUriAction_ != null) {
                      subBuilder = openUriAction_.toBuilder();
                    }
                    openUriAction_ =
                        input.readMessage(
                            com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button
                                .OpenUriAction.parser(),
                            extensionRegistry);
                    if (subBuilder != null) {
                      subBuilder.mergeFrom(openUriAction_);
                      openUriAction_ = subBuilder.buildPartial();
                    }

                    break;
                  }
                default:
                  {
                    if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                      done = true;
                    }
                    break;
                  }
              }
            }
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(this);
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(this);
          } finally {
            this.unknownFields = unknownFields.build();
            makeExtensionsImmutable();
          }
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.dialogflow.v2.IntentProto
              .internal_static_google_cloud_dialogflow_v2_Intent_Message_BasicCard_Button_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.dialogflow.v2.IntentProto
              .internal_static_google_cloud_dialogflow_v2_Intent_Message_BasicCard_Button_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.class,
                  com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.Builder.class);
        }

        public interface OpenUriActionOrBuilder
            extends
            // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction)
            com.google.protobuf.MessageOrBuilder {

          /**
           *
           *
           * <pre>
           * Required. The HTTP or HTTPS scheme URI.
           * </pre>
           *
           * <code>string uri = 1;</code>
           *
           * @return The uri.
           */
          java.lang.String getUri();
          /**
           *
           *
           * <pre>
           * Required. The HTTP or HTTPS scheme URI.
           * </pre>
           *
           * <code>string uri = 1;</code>
           *
           * @return The bytes for uri.
           */
          com.google.protobuf.ByteString getUriBytes();
        }
        /**
         *
         *
         * <pre>
         * Opens the given URI.
         * </pre>
         *
         * Protobuf type {@code
         * google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction}
         */
        public static final class OpenUriAction extends com.google.protobuf.GeneratedMessageV3
            implements
            // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction)
            OpenUriActionOrBuilder {
          private static final long serialVersionUID = 0L;
          // Use OpenUriAction.newBuilder() to construct.
          private OpenUriAction(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
            super(builder);
          }

          private OpenUriAction() {
            uri_ = "";
          }

          @java.lang.Override
          @SuppressWarnings({"unused"})
          protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
            return new OpenUriAction();
          }

          @java.lang.Override
          public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
            return this.unknownFields;
          }

          private OpenUriAction(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            this();
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            com.google.protobuf.UnknownFieldSet.Builder unknownFields =
                com.google.protobuf.UnknownFieldSet.newBuilder();
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 10:
                    {
                      java.lang.String s = input.readStringRequireUtf8();

                      uri_ = s;
                      break;
                    }
                  default:
                    {
                      if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                        done = true;
                      }
                      break;
                    }
                }
              }
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(this);
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(this);
            } finally {
              this.unknownFields = unknownFields.build();
              makeExtensionsImmutable();
            }
          }

          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.dialogflow.v2.IntentProto
                .internal_static_google_cloud_dialogflow_v2_Intent_Message_BasicCard_Button_OpenUriAction_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.dialogflow.v2.IntentProto
                .internal_static_google_cloud_dialogflow_v2_Intent_Message_BasicCard_Button_OpenUriAction_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction
                        .class,
                    com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction
                        .Builder.class);
          }

          public static final int URI_FIELD_NUMBER = 1;
          private volatile java.lang.Object uri_;
          /**
           *
           *
           * <pre>
           * Required. The HTTP or HTTPS scheme URI.
           * </pre>
           *
           * <code>string uri = 1;</code>
           *
           * @return The uri.
           */
          @java.lang.Override
          public java.lang.String getUri() {
            java.lang.Object ref = uri_;
            if (ref instanceof java.lang.String) {
              return (java.lang.String) ref;
            } else {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              uri_ = s;
              return s;
            }
          }
          /**
           *
           *
           * <pre>
           * Required. The HTTP or HTTPS scheme URI.
           * </pre>
           *
           * <code>string uri = 1;</code>
           *
           * @return The bytes for uri.
           */
          @java.lang.Override
          public com.google.protobuf.ByteString getUriBytes() {
            java.lang.Object ref = uri_;
            if (ref instanceof java.lang.String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              uri_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }

          private byte memoizedIsInitialized = -1;

          @java.lang.Override
          public final boolean isInitialized() {
            byte isInitialized = memoizedIsInitialized;
            if (isInitialized == 1) return true;
            if (isInitialized == 0) return false;

            memoizedIsInitialized = 1;
            return true;
          }

          @java.lang.Override
          public void writeTo(com.google.protobuf.CodedOutputStream output)
              throws java.io.IOException {
            if (!getUriBytes().isEmpty()) {
              com.google.protobuf.GeneratedMessageV3.writeString(output, 1, uri_);
            }
            unknownFields.writeTo(output);
          }

          @java.lang.Override
          public int getSerializedSize() {
            int size = memoizedSize;
            if (size != -1) return size;

            size = 0;
            if (!getUriBytes().isEmpty()) {
              size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, uri_);
            }
            size += unknownFields.getSerializedSize();
            memoizedSize = size;
            return size;
          }

          @java.lang.Override
          public boolean equals(final java.lang.Object obj) {
            if (obj == this) {
              return true;
            }
            if (!(obj
                instanceof
                com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction)) {
              return super.equals(obj);
            }
            com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction other =
                (com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction) obj;

            if (!getUri().equals(other.getUri())) return false;
            if (!unknownFields.equals(other.unknownFields)) return false;
            return true;
          }

          @java.lang.Override
          public int hashCode() {
            if (memoizedHashCode != 0) {
              return memoizedHashCode;
            }
            int hash = 41;
            hash = (19 * hash) + getDescriptor().hashCode();
            hash = (37 * hash) + URI_FIELD_NUMBER;
            hash = (53 * hash) + getUri().hashCode();
            hash = (29 * hash) + unknownFields.hashCode();
            memoizedHashCode = hash;
            return hash;
          }

          public static com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction
              parseFrom(java.nio.ByteBuffer data)
                  throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
          }

          public static com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction
              parseFrom(
                  java.nio.ByteBuffer data,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
          }

          public static com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction
              parseFrom(com.google.protobuf.ByteString data)
                  throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
          }

          public static com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction
              parseFrom(
                  com.google.protobuf.ByteString data,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
          }

          public static com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction
              parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
          }

          public static com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction
              parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
          }

          public static com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction
              parseFrom(java.io.InputStream input) throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
          }

          public static com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction
              parseFrom(
                  java.io.InputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
                PARSER, input, extensionRegistry);
          }

          public static com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction
              parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
                PARSER, input);
          }

          public static com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction
              parseDelimitedFrom(
                  java.io.InputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
                PARSER, input, extensionRegistry);
          }

          public static com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction
              parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
          }

          public static com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction
              parseFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
                PARSER, input, extensionRegistry);
          }

          @java.lang.Override
          public Builder newBuilderForType() {
            return newBuilder();
          }

          public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
          }

          public static Builder newBuilder(
              com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction
                  prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
          }

          @java.lang.Override
          public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
          }

          @java.lang.Override
          protected Builder newBuilderForType(
              com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
          }
          /**
           *
           *
           * <pre>
           * Opens the given URI.
           * </pre>
           *
           * Protobuf type {@code
           * google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction}
           */
          public static final class Builder
              extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
              implements
              // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction)
              com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button
                  .OpenUriActionOrBuilder {
            public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
              return com.google.cloud.dialogflow.v2.IntentProto
                  .internal_static_google_cloud_dialogflow_v2_Intent_Message_BasicCard_Button_OpenUriAction_descriptor;
            }

            @java.lang.Override
            protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
                internalGetFieldAccessorTable() {
              return com.google.cloud.dialogflow.v2.IntentProto
                  .internal_static_google_cloud_dialogflow_v2_Intent_Message_BasicCard_Button_OpenUriAction_fieldAccessorTable
                  .ensureFieldAccessorsInitialized(
                      com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction
                          .class,
                      com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction
                          .Builder.class);
            }

            // Construct using
            // com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction.newBuilder()
            private Builder() {
              maybeForceBuilderInitialization();
            }

            private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
              super(parent);
              maybeForceBuilderInitialization();
            }

            private void maybeForceBuilderInitialization() {
              if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
            }

            @java.lang.Override
            public Builder clear() {
              super.clear();
              uri_ = "";

              return this;
            }

            @java.lang.Override
            public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
              return com.google.cloud.dialogflow.v2.IntentProto
                  .internal_static_google_cloud_dialogflow_v2_Intent_Message_BasicCard_Button_OpenUriAction_descriptor;
            }

            @java.lang.Override
            public com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction
                getDefaultInstanceForType() {
              return com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction
                  .getDefaultInstance();
            }

            @java.lang.Override
            public com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction
                build() {
              com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction result =
                  buildPartial();
              if (!result.isInitialized()) {
                throw newUninitializedMessageException(result);
              }
              return result;
            }

            @java.lang.Override
            public com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction
                buildPartial() {
              com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction result =
                  new com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction(
                      this);
              result.uri_ = uri_;
              onBuilt();
              return result;
            }

            @java.lang.Override
            public Builder clone() {
              return super.clone();
            }

            @java.lang.Override
            public Builder setField(
                com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
              return super.setField(field, value);
            }

            @java.lang.Override
            public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
              return super.clearField(field);
            }

            @java.lang.Override
            public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
              return super.clearOneof(oneof);
            }

            @java.lang.Override
            public Builder setRepeatedField(
                com.google.protobuf.Descriptors.FieldDescriptor field,
                int index,
                java.lang.Object value) {
              return super.setRepeatedField(field, index, value);
            }

            @java.lang.Override
            public Builder addRepeatedField(
                com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
              return super.addRepeatedField(field, value);
            }

            @java.lang.Override
            public Builder mergeFrom(com.google.protobuf.Message other) {
              if (other
                  instanceof
                  com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction) {
                return mergeFrom(
                    (com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction)
                        other);
              } else {
                super.mergeFrom(other);
                return this;
              }
            }

            public Builder mergeFrom(
                com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction
                    other) {
              if (other
                  == com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction
                      .getDefaultInstance()) return this;
              if (!other.getUri().isEmpty()) {
                uri_ = other.uri_;
                onChanged();
              }
              this.mergeUnknownFields(other.unknownFields);
              onChanged();
              return this;
            }

            @java.lang.Override
            public final boolean isInitialized() {
              return true;
            }

            @java.lang.Override
            public Builder mergeFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
              com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction
                  parsedMessage = null;
              try {
                parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                parsedMessage =
                    (com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction)
                        e.getUnfinishedMessage();
                throw e.unwrapIOException();
              } finally {
                if (parsedMessage != null) {
                  mergeFrom(parsedMessage);
                }
              }
              return this;
            }

            private java.lang.Object uri_ = "";
            /**
             *
             *
             * <pre>
             * Required. The HTTP or HTTPS scheme URI.
             * </pre>
             *
             * <code>string uri = 1;</code>
             *
             * @return The uri.
             */
            public java.lang.String getUri() {
              java.lang.Object ref = uri_;
              if (!(ref instanceof java.lang.String)) {
                com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
                java.lang.String s = bs.toStringUtf8();
                uri_ = s;
                return s;
              } else {
                return (java.lang.String) ref;
              }
            }
            /**
             *
             *
             * <pre>
             * Required. The HTTP or HTTPS scheme URI.
             * </pre>
             *
             * <code>string uri = 1;</code>
             *
             * @return The bytes for uri.
             */
            public com.google.protobuf.ByteString getUriBytes() {
              java.lang.Object ref = uri_;
              if (ref instanceof String) {
                com.google.protobuf.ByteString b =
                    com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
                uri_ = b;
                return b;
              } else {
                return (com.google.protobuf.ByteString) ref;
              }
            }
            /**
             *
             *
             * <pre>
             * Required. The HTTP or HTTPS scheme URI.
             * </pre>
             *
             * <code>string uri = 1;</code>
             *
             * @param value The uri to set.
             * @return This builder for chaining.
             */
            public Builder setUri(java.lang.String value) {
              if (value == null) {
                throw new NullPointerException();
              }

              uri_ = value;
              onChanged();
              return this;
            }
            /**
             *
             *
             * <pre>
             * Required. The HTTP or HTTPS scheme URI.
             * </pre>
             *
             * <code>string uri = 1;</code>
             *
             * @return This builder for chaining.
             */
            public Builder clearUri() {

              uri_ = getDefaultInstance().getUri();
              onChanged();
              return this;
            }
            /**
             *
             *
             * <pre>
             * Required. The HTTP or HTTPS scheme URI.
             * </pre>
             *
             * <code>string uri = 1;</code>
             *
             * @param value The bytes for uri to set.
             * @return This builder for chaining.
             */
            public Builder setUriBytes(com.google.protobuf.ByteString value) {
              if (value == null) {
                throw new NullPointerException();
              }
              checkByteStringIsUtf8(value);

              uri_ = value;
              onChanged();
              return this;
            }

            @java.lang.Override
            public final Builder setUnknownFields(
                final com.google.protobuf.UnknownFieldSet unknownFields) {
              return super.setUnknownFields(unknownFields);
            }

            @java.lang.Override
            public final Builder mergeUnknownFields(
                final com.google.protobuf.UnknownFieldSet unknownFields) {
              return super.mergeUnknownFields(unknownFields);
            }

            // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction)
          }

          // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction)
          private static final com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button
                  .OpenUriAction
              DEFAULT_INSTANCE;

          static {
            DEFAULT_INSTANCE =
                new com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction();
          }

          public static com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction
              getDefaultInstance() {
            return DEFAULT_INSTANCE;
          }

          private static final com.google.protobuf.Parser<OpenUriAction> PARSER =
              new com.google.protobuf.AbstractParser<OpenUriAction>() {
                @java.lang.Override
                public OpenUriAction parsePartialFrom(
                    com.google.protobuf.CodedInputStream input,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws com.google.protobuf.InvalidProtocolBufferException {
                  return new OpenUriAction(input, extensionRegistry);
                }
              };

          public static com.google.protobuf.Parser<OpenUriAction> parser() {
            return PARSER;
          }

          @java.lang.Override
          public com.google.protobuf.Parser<OpenUriAction> getParserForType() {
            return PARSER;
          }

          @java.lang.Override
          public com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction
              getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
          }
        }

        public static final int TITLE_FIELD_NUMBER = 1;
        private volatile java.lang.Object title_;
        /**
         *
         *
         * <pre>
         * Required. The title of the button.
         * </pre>
         *
         * <code>string title = 1;</code>
         *
         * @return The title.
         */
        @java.lang.Override
        public java.lang.String getTitle() {
          java.lang.Object ref = title_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            title_ = s;
            return s;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The title of the button.
         * </pre>
         *
         * <code>string title = 1;</code>
         *
         * @return The bytes for title.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getTitleBytes() {
          java.lang.Object ref = title_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            title_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        public static final int OPEN_URI_ACTION_FIELD_NUMBER = 2;
        private com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction
            openUriAction_;
        /**
         *
         *
         * <pre>
         * Required. Action to take when a user taps on the button.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction open_uri_action = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return Whether the openUriAction field is set.
         */
        @java.lang.Override
        public boolean hasOpenUriAction() {
          return openUriAction_ != null;
        }
        /**
         *
         *
         * <pre>
         * Required. Action to take when a user taps on the button.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction open_uri_action = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return The openUriAction.
         */
        @java.lang.Override
        public com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction
            getOpenUriAction() {
          return openUriAction_ == null
              ? com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction
                  .getDefaultInstance()
              : openUriAction_;
        }
        /**
         *
         *
         * <pre>
         * Required. Action to take when a user taps on the button.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction open_uri_action = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        @java.lang.Override
        public com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriActionOrBuilder
            getOpenUriActionOrBuilder() {
          return getOpenUriAction();
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          if (!getTitleBytes().isEmpty()) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 1, title_);
          }
          if (openUriAction_ != null) {
            output.writeMessage(2, getOpenUriAction());
          }
          unknownFields.writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (!getTitleBytes().isEmpty()) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, title_);
          }
          if (openUriAction_ != null) {
            size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getOpenUriAction());
          }
          size += unknownFields.getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj instanceof com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button)) {
            return super.equals(obj);
          }
          com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button other =
              (com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button) obj;

          if (!getTitle().equals(other.getTitle())) return false;
          if (hasOpenUriAction() != other.hasOpenUriAction()) return false;
          if (hasOpenUriAction()) {
            if (!getOpenUriAction().equals(other.getOpenUriAction())) return false;
          }
          if (!unknownFields.equals(other.unknownFields)) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          hash = (37 * hash) + TITLE_FIELD_NUMBER;
          hash = (53 * hash) + getTitle().hashCode();
          if (hasOpenUriAction()) {
            hash = (37 * hash) + OPEN_URI_ACTION_FIELD_NUMBER;
            hash = (53 * hash) + getOpenUriAction().hashCode();
          }
          hash = (29 * hash) + unknownFields.hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button parseFrom(
            java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button parseFrom(
            com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button parseFrom(
            byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button parseFrom(
            byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button parseFrom(
            java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button parseFrom(
            com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * The button object that appears at the bottom of a card.
         * </pre>
         *
         * Protobuf type {@code google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button)
            com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.ButtonOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.dialogflow.v2.IntentProto
                .internal_static_google_cloud_dialogflow_v2_Intent_Message_BasicCard_Button_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.dialogflow.v2.IntentProto
                .internal_static_google_cloud_dialogflow_v2_Intent_Message_BasicCard_Button_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.class,
                    com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.Builder.class);
          }

          // Construct using
          // com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.newBuilder()
          private Builder() {
            maybeForceBuilderInitialization();
          }

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            maybeForceBuilderInitialization();
          }

          private void maybeForceBuilderInitialization() {
            if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            title_ = "";

            if (openUriActionBuilder_ == null) {
              openUriAction_ = null;
            } else {
              openUriAction_ = null;
              openUriActionBuilder_ = null;
            }
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.cloud.dialogflow.v2.IntentProto
                .internal_static_google_cloud_dialogflow_v2_Intent_Message_BasicCard_Button_descriptor;
          }

          @java.lang.Override
          public com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button
              getDefaultInstanceForType() {
            return com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button
                .getDefaultInstance();
          }

          @java.lang.Override
          public com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button build() {
            com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button result = buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button buildPartial() {
            com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button result =
                new com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button(this);
            result.title_ = title_;
            if (openUriActionBuilder_ == null) {
              result.openUriAction_ = openUriAction_;
            } else {
              result.openUriAction_ = openUriActionBuilder_.build();
            }
            onBuilt();
            return result;
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other instanceof com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button) {
              return mergeFrom(
                  (com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button) other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button other) {
            if (other
                == com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button
                    .getDefaultInstance()) return this;
            if (!other.getTitle().isEmpty()) {
              title_ = other.title_;
              onChanged();
            }
            if (other.hasOpenUriAction()) {
              mergeOpenUriAction(other.getOpenUriAction());
            }
            this.mergeUnknownFields(other.unknownFields);
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button parsedMessage = null;
            try {
              parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              parsedMessage =
                  (com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button)
                      e.getUnfinishedMessage();
              throw e.unwrapIOException();
            } finally {
              if (parsedMessage != null) {
                mergeFrom(parsedMessage);
              }
            }
            return this;
          }

          private java.lang.Object title_ = "";
          /**
           *
           *
           * <pre>
           * Required. The title of the button.
           * </pre>
           *
           * <code>string title = 1;</code>
           *
           * @return The title.
           */
          public java.lang.String getTitle() {
            java.lang.Object ref = title_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              title_ = s;
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Required. The title of the button.
           * </pre>
           *
           * <code>string title = 1;</code>
           *
           * @return The bytes for title.
           */
          public com.google.protobuf.ByteString getTitleBytes() {
            java.lang.Object ref = title_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              title_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Required. The title of the button.
           * </pre>
           *
           * <code>string title = 1;</code>
           *
           * @param value The title to set.
           * @return This builder for chaining.
           */
          public Builder setTitle(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }

            title_ = value;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. The title of the button.
           * </pre>
           *
           * <code>string title = 1;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearTitle() {

            title_ = getDefaultInstance().getTitle();
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. The title of the button.
           * </pre>
           *
           * <code>string title = 1;</code>
           *
           * @param value The bytes for title to set.
           * @return This builder for chaining.
           */
          public Builder setTitleBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);

            title_ = value;
            onChanged();
            return this;
          }

          private com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction
              openUriAction_;
          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction,
                  com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction
                      .Builder,
                  com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button
                      .OpenUriActionOrBuilder>
              openUriActionBuilder_;
          /**
           *
           *
           * <pre>
           * Required. Action to take when a user taps on the button.
           * </pre>
           *
           * <code>
           * .google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction open_uri_action = 2 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           *
           * @return Whether the openUriAction field is set.
           */
          public boolean hasOpenUriAction() {
            return openUriActionBuilder_ != null || openUriAction_ != null;
          }
          /**
           *
           *
           * <pre>
           * Required. Action to take when a user taps on the button.
           * </pre>
           *
           * <code>
           * .google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction open_uri_action = 2 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           *
           * @return The openUriAction.
           */
          public com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction
              getOpenUriAction() {
            if (openUriActionBuilder_ == null) {
              return openUriAction_ == null
                  ? com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction
                      .getDefaultInstance()
                  : openUriAction_;
            } else {
              return openUriActionBuilder_.getMessage();
            }
          }
          /**
           *
           *
           * <pre>
           * Required. Action to take when a user taps on the button.
           * </pre>
           *
           * <code>
           * .google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction open_uri_action = 2 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           */
          public Builder setOpenUriAction(
              com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction value) {
            if (openUriActionBuilder_ == null) {
              if (value == null) {
                throw new NullPointerException();
              }
              openUriAction_ = value;
              onChanged();
            } else {
              openUriActionBuilder_.setMessage(value);
            }

            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. Action to take when a user taps on the button.
           * </pre>
           *
           * <code>
           * .google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction open_uri_action = 2 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           */
          public Builder setOpenUriAction(
              com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction.Builder
                  builderForValue) {
            if (openUriActionBuilder_ == null) {
              openUriAction_ = builderForValue.build();
              onChanged();
            } else {
              openUriActionBuilder_.setMessage(builderForValue.build());
            }

            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. Action to take when a user taps on the button.
           * </pre>
           *
           * <code>
           * .google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction open_uri_action = 2 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           */
          public Builder mergeOpenUriAction(
              com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction value) {
            if (openUriActionBuilder_ == null) {
              if (openUriAction_ != null) {
                openUriAction_ =
                    com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction
                        .newBuilder(openUriAction_)
                        .mergeFrom(value)
                        .buildPartial();
              } else {
                openUriAction_ = value;
              }
              onChanged();
            } else {
              openUriActionBuilder_.mergeFrom(value);
            }

            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. Action to take when a user taps on the button.
           * </pre>
           *
           * <code>
           * .google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction open_uri_action = 2 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           */
          public Builder clearOpenUriAction() {
            if (openUriActionBuilder_ == null) {
              openUriAction_ = null;
              onChanged();
            } else {
              openUriAction_ = null;
              openUriActionBuilder_ = null;
            }

            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. Action to take when a user taps on the button.
           * </pre>
           *
           * <code>
           * .google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction open_uri_action = 2 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           */
          public com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction
                  .Builder
              getOpenUriActionBuilder() {

            onChanged();
            return getOpenUriActionFieldBuilder().getBuilder();
          }
          /**
           *
           *
           * <pre>
           * Required. Action to take when a user taps on the button.
           * </pre>
           *
           * <code>
           * .google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction open_uri_action = 2 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           */
          public com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button
                  .OpenUriActionOrBuilder
              getOpenUriActionOrBuilder() {
            if (openUriActionBuilder_ != null) {
              return openUriActionBuilder_.getMessageOrBuilder();
            } else {
              return openUriAction_ == null
                  ? com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction
                      .getDefaultInstance()
                  : openUriAction_;
            }
          }
          /**
           *
           *
           * <pre>
           * Required. Action to take when a user taps on the button.
           * </pre>
           *
           * <code>
           * .google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction open_uri_action = 2 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           */
          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction,
                  com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction
                      .Builder,
                  com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button
                      .OpenUriActionOrBuilder>
              getOpenUriActionFieldBuilder() {
            if (openUriActionBuilder_ == null) {
              openUriActionBuilder_ =
                  new com.google.protobuf.SingleFieldBuilderV3<
                      com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction,
                      com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction
                          .Builder,
                      com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button
                          .OpenUriActionOrBuilder>(
                      getOpenUriAction(), getParentForChildren(), isClean());
              openUriAction_ = null;
            }
            return openUriActionBuilder_;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button)
        }

        // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button)
        private static final com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button();
        }

        public static com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<Button> PARSER =
            new com.google.protobuf.AbstractParser<Button>() {
              @java.lang.Override
              public Button parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                return new Button(input, extensionRegistry);
              }
            };

        public static com.google.protobuf.Parser<Button> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<Button> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      public static final int TITLE_FIELD_NUMBER = 1;
      private volatile java.lang.Object title_;
      /**
       *
       *
       * <pre>
       * Optional. The title of the card.
       * </pre>
       *
       * <code>string title = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The title.
       */
      @java.lang.Override
      public java.lang.String getTitle() {
        java.lang.Object ref = title_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          title_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The title of the card.
       * </pre>
       *
       * <code>string title = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for title.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getTitleBytes() {
        java.lang.Object ref = title_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          title_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int SUBTITLE_FIELD_NUMBER = 2;
      private volatile java.lang.Object subtitle_;
      /**
       *
       *
       * <pre>
       * Optional. The subtitle of the card.
       * </pre>
       *
       * <code>string subtitle = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The subtitle.
       */
      @java.lang.Override
      public java.lang.String getSubtitle() {
        java.lang.Object ref = subtitle_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          subtitle_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The subtitle of the card.
       * </pre>
       *
       * <code>string subtitle = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for subtitle.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getSubtitleBytes() {
        java.lang.Object ref = subtitle_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          subtitle_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int FORMATTED_TEXT_FIELD_NUMBER = 3;
      private volatile java.lang.Object formattedText_;
      /**
       *
       *
       * <pre>
       * Required, unless image is present. The body text of the card.
       * </pre>
       *
       * <code>string formatted_text = 3;</code>
       *
       * @return The formattedText.
       */
      @java.lang.Override
      public java.lang.String getFormattedText() {
        java.lang.Object ref = formattedText_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          formattedText_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Required, unless image is present. The body text of the card.
       * </pre>
       *
       * <code>string formatted_text = 3;</code>
       *
       * @return The bytes for formattedText.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getFormattedTextBytes() {
        java.lang.Object ref = formattedText_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          formattedText_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int IMAGE_FIELD_NUMBER = 4;
      private com.google.cloud.dialogflow.v2.Intent.Message.Image image_;
      /**
       *
       *
       * <pre>
       * Optional. The image for the card.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2.Intent.Message.Image image = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the image field is set.
       */
      @java.lang.Override
      public boolean hasImage() {
        return image_ != null;
      }
      /**
       *
       *
       * <pre>
       * Optional. The image for the card.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2.Intent.Message.Image image = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The image.
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.v2.Intent.Message.Image getImage() {
        return image_ == null
            ? com.google.cloud.dialogflow.v2.Intent.Message.Image.getDefaultInstance()
            : image_;
      }
      /**
       *
       *
       * <pre>
       * Optional. The image for the card.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2.Intent.Message.Image image = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.v2.Intent.Message.ImageOrBuilder getImageOrBuilder() {
        return getImage();
      }

      public static final int BUTTONS_FIELD_NUMBER = 5;
      private java.util.List<com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button>
          buttons_;
      /**
       *
       *
       * <pre>
       * Optional. The collection of card buttons.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button buttons = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public java.util.List<com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button>
          getButtonsList() {
        return buttons_;
      }
      /**
       *
       *
       * <pre>
       * Optional. The collection of card buttons.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button buttons = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              ? extends com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.ButtonOrBuilder>
          getButtonsOrBuilderList() {
        return buttons_;
      }
      /**
       *
       *
       * <pre>
       * Optional. The collection of card buttons.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button buttons = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public int getButtonsCount() {
        return buttons_.size();
      }
      /**
       *
       *
       * <pre>
       * Optional. The collection of card buttons.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button buttons = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button getButtons(int index) {
        return buttons_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Optional. The collection of card buttons.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button buttons = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.ButtonOrBuilder
          getButtonsOrBuilder(int index) {
        return buttons_.get(index);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!getTitleBytes().isEmpty()) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, title_);
        }
        if (!getSubtitleBytes().isEmpty()) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 2, subtitle_);
        }
        if (!getFormattedTextBytes().isEmpty()) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 3, formattedText_);
        }
        if (image_ != null) {
          output.writeMessage(4, getImage());
        }
        for (int i = 0; i < buttons_.size(); i++) {
          output.writeMessage(5, buttons_.get(i));
        }
        unknownFields.writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!getTitleBytes().isEmpty()) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, title_);
        }
        if (!getSubtitleBytes().isEmpty()) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, subtitle_);
        }
        if (!getFormattedTextBytes().isEmpty()) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, formattedText_);
        }
        if (image_ != null) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getImage());
        }
        for (int i = 0; i < buttons_.size(); i++) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, buttons_.get(i));
        }
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.cloud.dialogflow.v2.Intent.Message.BasicCard)) {
          return super.equals(obj);
        }
        com.google.cloud.dialogflow.v2.Intent.Message.BasicCard other =
            (com.google.cloud.dialogflow.v2.Intent.Message.BasicCard) obj;

        if (!getTitle().equals(other.getTitle())) return false;
        if (!getSubtitle().equals(other.getSubtitle())) return false;
        if (!getFormattedText().equals(other.getFormattedText())) return false;
        if (hasImage() != other.hasImage()) return false;
        if (hasImage()) {
          if (!getImage().equals(other.getImage())) return false;
        }
        if (!getButtonsList().equals(other.getButtonsList())) return false;
        if (!unknownFields.equals(other.unknownFields)) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + TITLE_FIELD_NUMBER;
        hash = (53 * hash) + getTitle().hashCode();
        hash = (37 * hash) + SUBTITLE_FIELD_NUMBER;
        hash = (53 * hash) + getSubtitle().hashCode();
        hash = (37 * hash) + FORMATTED_TEXT_FIELD_NUMBER;
        hash = (53 * hash) + getFormattedText().hashCode();
        if (hasImage()) {
          hash = (37 * hash) + IMAGE_FIELD_NUMBER;
          hash = (53 * hash) + getImage().hashCode();
        }
        if (getButtonsCount() > 0) {
          hash = (37 * hash) + BUTTONS_FIELD_NUMBER;
          hash = (53 * hash) + getButtonsList().hashCode();
        }
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.BasicCard parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.BasicCard parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.BasicCard parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.BasicCard parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.BasicCard parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.BasicCard parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.BasicCard parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.BasicCard parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.BasicCard parseDelimitedFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.BasicCard parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.BasicCard parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.BasicCard parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.dialogflow.v2.Intent.Message.BasicCard prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * The basic card message. Useful for displaying information.
       * </pre>
       *
       * Protobuf type {@code google.cloud.dialogflow.v2.Intent.Message.BasicCard}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2.Intent.Message.BasicCard)
          com.google.cloud.dialogflow.v2.Intent.Message.BasicCardOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.dialogflow.v2.IntentProto
              .internal_static_google_cloud_dialogflow_v2_Intent_Message_BasicCard_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.dialogflow.v2.IntentProto
              .internal_static_google_cloud_dialogflow_v2_Intent_Message_BasicCard_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.class,
                  com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Builder.class);
        }

        // Construct using com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
            getButtonsFieldBuilder();
          }
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          title_ = "";

          subtitle_ = "";

          formattedText_ = "";

          if (imageBuilder_ == null) {
            image_ = null;
          } else {
            image_ = null;
            imageBuilder_ = null;
          }
          if (buttonsBuilder_ == null) {
            buttons_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            buttonsBuilder_.clear();
          }
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.dialogflow.v2.IntentProto
              .internal_static_google_cloud_dialogflow_v2_Intent_Message_BasicCard_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.v2.Intent.Message.BasicCard getDefaultInstanceForType() {
          return com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.v2.Intent.Message.BasicCard build() {
          com.google.cloud.dialogflow.v2.Intent.Message.BasicCard result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.v2.Intent.Message.BasicCard buildPartial() {
          com.google.cloud.dialogflow.v2.Intent.Message.BasicCard result =
              new com.google.cloud.dialogflow.v2.Intent.Message.BasicCard(this);
          int from_bitField0_ = bitField0_;
          result.title_ = title_;
          result.subtitle_ = subtitle_;
          result.formattedText_ = formattedText_;
          if (imageBuilder_ == null) {
            result.image_ = image_;
          } else {
            result.image_ = imageBuilder_.build();
          }
          if (buttonsBuilder_ == null) {
            if (((bitField0_ & 0x00000001) != 0)) {
              buttons_ = java.util.Collections.unmodifiableList(buttons_);
              bitField0_ = (bitField0_ & ~0x00000001);
            }
            result.buttons_ = buttons_;
          } else {
            result.buttons_ = buttonsBuilder_.build();
          }
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.cloud.dialogflow.v2.Intent.Message.BasicCard) {
            return mergeFrom((com.google.cloud.dialogflow.v2.Intent.Message.BasicCard) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.google.cloud.dialogflow.v2.Intent.Message.BasicCard other) {
          if (other == com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.getDefaultInstance())
            return this;
          if (!other.getTitle().isEmpty()) {
            title_ = other.title_;
            onChanged();
          }
          if (!other.getSubtitle().isEmpty()) {
            subtitle_ = other.subtitle_;
            onChanged();
          }
          if (!other.getFormattedText().isEmpty()) {
            formattedText_ = other.formattedText_;
            onChanged();
          }
          if (other.hasImage()) {
            mergeImage(other.getImage());
          }
          if (buttonsBuilder_ == null) {
            if (!other.buttons_.isEmpty()) {
              if (buttons_.isEmpty()) {
                buttons_ = other.buttons_;
                bitField0_ = (bitField0_ & ~0x00000001);
              } else {
                ensureButtonsIsMutable();
                buttons_.addAll(other.buttons_);
              }
              onChanged();
            }
          } else {
            if (!other.buttons_.isEmpty()) {
              if (buttonsBuilder_.isEmpty()) {
                buttonsBuilder_.dispose();
                buttonsBuilder_ = null;
                buttons_ = other.buttons_;
                bitField0_ = (bitField0_ & ~0x00000001);
                buttonsBuilder_ =
                    com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                        ? getButtonsFieldBuilder()
                        : null;
              } else {
                buttonsBuilder_.addAllMessages(other.buttons_);
              }
            }
          }
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          com.google.cloud.dialogflow.v2.Intent.Message.BasicCard parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage =
                (com.google.cloud.dialogflow.v2.Intent.Message.BasicCard) e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }

        private int bitField0_;

        private java.lang.Object title_ = "";
        /**
         *
         *
         * <pre>
         * Optional. The title of the card.
         * </pre>
         *
         * <code>string title = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The title.
         */
        public java.lang.String getTitle() {
          java.lang.Object ref = title_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            title_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The title of the card.
         * </pre>
         *
         * <code>string title = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The bytes for title.
         */
        public com.google.protobuf.ByteString getTitleBytes() {
          java.lang.Object ref = title_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            title_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The title of the card.
         * </pre>
         *
         * <code>string title = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The title to set.
         * @return This builder for chaining.
         */
        public Builder setTitle(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }

          title_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The title of the card.
         * </pre>
         *
         * <code>string title = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearTitle() {

          title_ = getDefaultInstance().getTitle();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The title of the card.
         * </pre>
         *
         * <code>string title = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The bytes for title to set.
         * @return This builder for chaining.
         */
        public Builder setTitleBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);

          title_ = value;
          onChanged();
          return this;
        }

        private java.lang.Object subtitle_ = "";
        /**
         *
         *
         * <pre>
         * Optional. The subtitle of the card.
         * </pre>
         *
         * <code>string subtitle = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The subtitle.
         */
        public java.lang.String getSubtitle() {
          java.lang.Object ref = subtitle_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            subtitle_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The subtitle of the card.
         * </pre>
         *
         * <code>string subtitle = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The bytes for subtitle.
         */
        public com.google.protobuf.ByteString getSubtitleBytes() {
          java.lang.Object ref = subtitle_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            subtitle_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The subtitle of the card.
         * </pre>
         *
         * <code>string subtitle = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The subtitle to set.
         * @return This builder for chaining.
         */
        public Builder setSubtitle(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }

          subtitle_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The subtitle of the card.
         * </pre>
         *
         * <code>string subtitle = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearSubtitle() {

          subtitle_ = getDefaultInstance().getSubtitle();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The subtitle of the card.
         * </pre>
         *
         * <code>string subtitle = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The bytes for subtitle to set.
         * @return This builder for chaining.
         */
        public Builder setSubtitleBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);

          subtitle_ = value;
          onChanged();
          return this;
        }

        private java.lang.Object formattedText_ = "";
        /**
         *
         *
         * <pre>
         * Required, unless image is present. The body text of the card.
         * </pre>
         *
         * <code>string formatted_text = 3;</code>
         *
         * @return The formattedText.
         */
        public java.lang.String getFormattedText() {
          java.lang.Object ref = formattedText_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            formattedText_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required, unless image is present. The body text of the card.
         * </pre>
         *
         * <code>string formatted_text = 3;</code>
         *
         * @return The bytes for formattedText.
         */
        public com.google.protobuf.ByteString getFormattedTextBytes() {
          java.lang.Object ref = formattedText_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            formattedText_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required, unless image is present. The body text of the card.
         * </pre>
         *
         * <code>string formatted_text = 3;</code>
         *
         * @param value The formattedText to set.
         * @return This builder for chaining.
         */
        public Builder setFormattedText(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }

          formattedText_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required, unless image is present. The body text of the card.
         * </pre>
         *
         * <code>string formatted_text = 3;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearFormattedText() {

          formattedText_ = getDefaultInstance().getFormattedText();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required, unless image is present. The body text of the card.
         * </pre>
         *
         * <code>string formatted_text = 3;</code>
         *
         * @param value The bytes for formattedText to set.
         * @return This builder for chaining.
         */
        public Builder setFormattedTextBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);

          formattedText_ = value;
          onChanged();
          return this;
        }

        private com.google.cloud.dialogflow.v2.Intent.Message.Image image_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2.Intent.Message.Image,
                com.google.cloud.dialogflow.v2.Intent.Message.Image.Builder,
                com.google.cloud.dialogflow.v2.Intent.Message.ImageOrBuilder>
            imageBuilder_;
        /**
         *
         *
         * <pre>
         * Optional. The image for the card.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.v2.Intent.Message.Image image = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return Whether the image field is set.
         */
        public boolean hasImage() {
          return imageBuilder_ != null || image_ != null;
        }
        /**
         *
         *
         * <pre>
         * Optional. The image for the card.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.v2.Intent.Message.Image image = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The image.
         */
        public com.google.cloud.dialogflow.v2.Intent.Message.Image getImage() {
          if (imageBuilder_ == null) {
            return image_ == null
                ? com.google.cloud.dialogflow.v2.Intent.Message.Image.getDefaultInstance()
                : image_;
          } else {
            return imageBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The image for the card.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.v2.Intent.Message.Image image = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder setImage(com.google.cloud.dialogflow.v2.Intent.Message.Image value) {
          if (imageBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            image_ = value;
            onChanged();
          } else {
            imageBuilder_.setMessage(value);
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The image for the card.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.v2.Intent.Message.Image image = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder setImage(
            com.google.cloud.dialogflow.v2.Intent.Message.Image.Builder builderForValue) {
          if (imageBuilder_ == null) {
            image_ = builderForValue.build();
            onChanged();
          } else {
            imageBuilder_.setMessage(builderForValue.build());
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The image for the card.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.v2.Intent.Message.Image image = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder mergeImage(com.google.cloud.dialogflow.v2.Intent.Message.Image value) {
          if (imageBuilder_ == null) {
            if (image_ != null) {
              image_ =
                  com.google.cloud.dialogflow.v2.Intent.Message.Image.newBuilder(image_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              image_ = value;
            }
            onChanged();
          } else {
            imageBuilder_.mergeFrom(value);
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The image for the card.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.v2.Intent.Message.Image image = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder clearImage() {
          if (imageBuilder_ == null) {
            image_ = null;
            onChanged();
          } else {
            image_ = null;
            imageBuilder_ = null;
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The image for the card.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.v2.Intent.Message.Image image = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.cloud.dialogflow.v2.Intent.Message.Image.Builder getImageBuilder() {

          onChanged();
          return getImageFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * Optional. The image for the card.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.v2.Intent.Message.Image image = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.cloud.dialogflow.v2.Intent.Message.ImageOrBuilder getImageOrBuilder() {
          if (imageBuilder_ != null) {
            return imageBuilder_.getMessageOrBuilder();
          } else {
            return image_ == null
                ? com.google.cloud.dialogflow.v2.Intent.Message.Image.getDefaultInstance()
                : image_;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The image for the card.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.v2.Intent.Message.Image image = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2.Intent.Message.Image,
                com.google.cloud.dialogflow.v2.Intent.Message.Image.Builder,
                com.google.cloud.dialogflow.v2.Intent.Message.ImageOrBuilder>
            getImageFieldBuilder() {
          if (imageBuilder_ == null) {
            imageBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.dialogflow.v2.Intent.Message.Image,
                    com.google.cloud.dialogflow.v2.Intent.Message.Image.Builder,
                    com.google.cloud.dialogflow.v2.Intent.Message.ImageOrBuilder>(
                    getImage(), getParentForChildren(), isClean());
            image_ = null;
          }
          return imageBuilder_;
        }

        private java.util.List<com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button>
            buttons_ = java.util.Collections.emptyList();

        private void ensureButtonsIsMutable() {
          if (!((bitField0_ & 0x00000001) != 0)) {
            buttons_ =
                new java.util.ArrayList<
                    com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button>(buttons_);
            bitField0_ |= 0x00000001;
          }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button,
                com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.Builder,
                com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.ButtonOrBuilder>
            buttonsBuilder_;

        /**
         *
         *
         * <pre>
         * Optional. The collection of card buttons.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button buttons = 5 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public java.util.List<com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button>
            getButtonsList() {
          if (buttonsBuilder_ == null) {
            return java.util.Collections.unmodifiableList(buttons_);
          } else {
            return buttonsBuilder_.getMessageList();
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The collection of card buttons.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button buttons = 5 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public int getButtonsCount() {
          if (buttonsBuilder_ == null) {
            return buttons_.size();
          } else {
            return buttonsBuilder_.getCount();
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The collection of card buttons.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button buttons = 5 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button getButtons(
            int index) {
          if (buttonsBuilder_ == null) {
            return buttons_.get(index);
          } else {
            return buttonsBuilder_.getMessage(index);
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The collection of card buttons.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button buttons = 5 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder setButtons(
            int index, com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button value) {
          if (buttonsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureButtonsIsMutable();
            buttons_.set(index, value);
            onChanged();
          } else {
            buttonsBuilder_.setMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The collection of card buttons.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button buttons = 5 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder setButtons(
            int index,
            com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.Builder
                builderForValue) {
          if (buttonsBuilder_ == null) {
            ensureButtonsIsMutable();
            buttons_.set(index, builderForValue.build());
            onChanged();
          } else {
            buttonsBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The collection of card buttons.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button buttons = 5 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder addButtons(
            com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button value) {
          if (buttonsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureButtonsIsMutable();
            buttons_.add(value);
            onChanged();
          } else {
            buttonsBuilder_.addMessage(value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The collection of card buttons.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button buttons = 5 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder addButtons(
            int index, com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button value) {
          if (buttonsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureButtonsIsMutable();
            buttons_.add(index, value);
            onChanged();
          } else {
            buttonsBuilder_.addMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The collection of card buttons.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button buttons = 5 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder addButtons(
            com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.Builder
                builderForValue) {
          if (buttonsBuilder_ == null) {
            ensureButtonsIsMutable();
            buttons_.add(builderForValue.build());
            onChanged();
          } else {
            buttonsBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The collection of card buttons.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button buttons = 5 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder addButtons(
            int index,
            com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.Builder
                builderForValue) {
          if (buttonsBuilder_ == null) {
            ensureButtonsIsMutable();
            buttons_.add(index, builderForValue.build());
            onChanged();
          } else {
            buttonsBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The collection of card buttons.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button buttons = 5 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder addAllButtons(
            java.lang.Iterable<
                    ? extends com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button>
                values) {
          if (buttonsBuilder_ == null) {
            ensureButtonsIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, buttons_);
            onChanged();
          } else {
            buttonsBuilder_.addAllMessages(values);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The collection of card buttons.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button buttons = 5 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder clearButtons() {
          if (buttonsBuilder_ == null) {
            buttons_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000001);
            onChanged();
          } else {
            buttonsBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The collection of card buttons.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button buttons = 5 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder removeButtons(int index) {
          if (buttonsBuilder_ == null) {
            ensureButtonsIsMutable();
            buttons_.remove(index);
            onChanged();
          } else {
            buttonsBuilder_.remove(index);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The collection of card buttons.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button buttons = 5 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.Builder
            getButtonsBuilder(int index) {
          return getButtonsFieldBuilder().getBuilder(index);
        }
        /**
         *
         *
         * <pre>
         * Optional. The collection of card buttons.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button buttons = 5 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.ButtonOrBuilder
            getButtonsOrBuilder(int index) {
          if (buttonsBuilder_ == null) {
            return buttons_.get(index);
          } else {
            return buttonsBuilder_.getMessageOrBuilder(index);
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The collection of card buttons.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button buttons = 5 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public java.util.List<
                ? extends com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.ButtonOrBuilder>
            getButtonsOrBuilderList() {
          if (buttonsBuilder_ != null) {
            return buttonsBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(buttons_);
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The collection of card buttons.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button buttons = 5 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.Builder
            addButtonsBuilder() {
          return getButtonsFieldBuilder()
              .addBuilder(
                  com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button
                      .getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * Optional. The collection of card buttons.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button buttons = 5 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.Builder
            addButtonsBuilder(int index) {
          return getButtonsFieldBuilder()
              .addBuilder(
                  index,
                  com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button
                      .getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * Optional. The collection of card buttons.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button buttons = 5 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public java.util.List<
                com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.Builder>
            getButtonsBuilderList() {
          return getButtonsFieldBuilder().getBuilderList();
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button,
                com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.Builder,
                com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.ButtonOrBuilder>
            getButtonsFieldBuilder() {
          if (buttonsBuilder_ == null) {
            buttonsBuilder_ =
                new com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button,
                    com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.Builder,
                    com.google.cloud.dialogflow.v2.Intent.Message.BasicCard.ButtonOrBuilder>(
                    buttons_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
            buttons_ = null;
          }
          return buttonsBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2.Intent.Message.BasicCard)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2.Intent.Message.BasicCard)
      private static final com.google.cloud.dialogflow.v2.Intent.Message.BasicCard DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2.Intent.Message.BasicCard();
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.BasicCard getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<BasicCard> PARSER =
          new com.google.protobuf.AbstractParser<BasicCard>() {
            @java.lang.Override
            public BasicCard parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              return new BasicCard(input, extensionRegistry);
            }
          };

      public static com.google.protobuf.Parser<BasicCard> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<BasicCard> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2.Intent.Message.BasicCard getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface SuggestionOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.v2.Intent.Message.Suggestion)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Required. The text shown the in the suggestion chip.
       * </pre>
       *
       * <code>string title = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The title.
       */
      java.lang.String getTitle();
      /**
       *
       *
       * <pre>
       * Required. The text shown the in the suggestion chip.
       * </pre>
       *
       * <code>string title = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for title.
       */
      com.google.protobuf.ByteString getTitleBytes();
    }
    /**
     *
     *
     * <pre>
     * The suggestion chip message that the user can tap to quickly post a reply
     * to the conversation.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.v2.Intent.Message.Suggestion}
     */
    public static final class Suggestion extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2.Intent.Message.Suggestion)
        SuggestionOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use Suggestion.newBuilder() to construct.
      private Suggestion(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Suggestion() {
        title_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Suggestion();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
      }

      private Suggestion(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();

                  title_ = s;
                  break;
                }
              default:
                {
                  if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                    done = true;
                  }
                  break;
                }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(this);
        } finally {
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.v2.IntentProto
            .internal_static_google_cloud_dialogflow_v2_Intent_Message_Suggestion_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.v2.IntentProto
            .internal_static_google_cloud_dialogflow_v2_Intent_Message_Suggestion_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.v2.Intent.Message.Suggestion.class,
                com.google.cloud.dialogflow.v2.Intent.Message.Suggestion.Builder.class);
      }

      public static final int TITLE_FIELD_NUMBER = 1;
      private volatile java.lang.Object title_;
      /**
       *
       *
       * <pre>
       * Required. The text shown the in the suggestion chip.
       * </pre>
       *
       * <code>string title = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The title.
       */
      @java.lang.Override
      public java.lang.String getTitle() {
        java.lang.Object ref = title_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          title_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The text shown the in the suggestion chip.
       * </pre>
       *
       * <code>string title = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for title.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getTitleBytes() {
        java.lang.Object ref = title_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          title_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!getTitleBytes().isEmpty()) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, title_);
        }
        unknownFields.writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!getTitleBytes().isEmpty()) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, title_);
        }
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.cloud.dialogflow.v2.Intent.Message.Suggestion)) {
          return super.equals(obj);
        }
        com.google.cloud.dialogflow.v2.Intent.Message.Suggestion other =
            (com.google.cloud.dialogflow.v2.Intent.Message.Suggestion) obj;

        if (!getTitle().equals(other.getTitle())) return false;
        if (!unknownFields.equals(other.unknownFields)) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + TITLE_FIELD_NUMBER;
        hash = (53 * hash) + getTitle().hashCode();
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.Suggestion parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.Suggestion parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.Suggestion parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.Suggestion parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.Suggestion parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.Suggestion parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.Suggestion parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.Suggestion parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.Suggestion parseDelimitedFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.Suggestion parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.Suggestion parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.Suggestion parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.dialogflow.v2.Intent.Message.Suggestion prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * The suggestion chip message that the user can tap to quickly post a reply
       * to the conversation.
       * </pre>
       *
       * Protobuf type {@code google.cloud.dialogflow.v2.Intent.Message.Suggestion}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2.Intent.Message.Suggestion)
          com.google.cloud.dialogflow.v2.Intent.Message.SuggestionOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.dialogflow.v2.IntentProto
              .internal_static_google_cloud_dialogflow_v2_Intent_Message_Suggestion_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.dialogflow.v2.IntentProto
              .internal_static_google_cloud_dialogflow_v2_Intent_Message_Suggestion_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.dialogflow.v2.Intent.Message.Suggestion.class,
                  com.google.cloud.dialogflow.v2.Intent.Message.Suggestion.Builder.class);
        }

        // Construct using com.google.cloud.dialogflow.v2.Intent.Message.Suggestion.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          title_ = "";

          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.dialogflow.v2.IntentProto
              .internal_static_google_cloud_dialogflow_v2_Intent_Message_Suggestion_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.v2.Intent.Message.Suggestion
            getDefaultInstanceForType() {
          return com.google.cloud.dialogflow.v2.Intent.Message.Suggestion.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.v2.Intent.Message.Suggestion build() {
          com.google.cloud.dialogflow.v2.Intent.Message.Suggestion result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.v2.Intent.Message.Suggestion buildPartial() {
          com.google.cloud.dialogflow.v2.Intent.Message.Suggestion result =
              new com.google.cloud.dialogflow.v2.Intent.Message.Suggestion(this);
          result.title_ = title_;
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.cloud.dialogflow.v2.Intent.Message.Suggestion) {
            return mergeFrom((com.google.cloud.dialogflow.v2.Intent.Message.Suggestion) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.google.cloud.dialogflow.v2.Intent.Message.Suggestion other) {
          if (other
              == com.google.cloud.dialogflow.v2.Intent.Message.Suggestion.getDefaultInstance())
            return this;
          if (!other.getTitle().isEmpty()) {
            title_ = other.title_;
            onChanged();
          }
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          com.google.cloud.dialogflow.v2.Intent.Message.Suggestion parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage =
                (com.google.cloud.dialogflow.v2.Intent.Message.Suggestion) e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }

        private java.lang.Object title_ = "";
        /**
         *
         *
         * <pre>
         * Required. The text shown the in the suggestion chip.
         * </pre>
         *
         * <code>string title = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The title.
         */
        public java.lang.String getTitle() {
          java.lang.Object ref = title_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            title_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The text shown the in the suggestion chip.
         * </pre>
         *
         * <code>string title = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for title.
         */
        public com.google.protobuf.ByteString getTitleBytes() {
          java.lang.Object ref = title_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            title_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The text shown the in the suggestion chip.
         * </pre>
         *
         * <code>string title = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The title to set.
         * @return This builder for chaining.
         */
        public Builder setTitle(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }

          title_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The text shown the in the suggestion chip.
         * </pre>
         *
         * <code>string title = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearTitle() {

          title_ = getDefaultInstance().getTitle();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The text shown the in the suggestion chip.
         * </pre>
         *
         * <code>string title = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The bytes for title to set.
         * @return This builder for chaining.
         */
        public Builder setTitleBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);

          title_ = value;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2.Intent.Message.Suggestion)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2.Intent.Message.Suggestion)
      private static final com.google.cloud.dialogflow.v2.Intent.Message.Suggestion
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2.Intent.Message.Suggestion();
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.Suggestion getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Suggestion> PARSER =
          new com.google.protobuf.AbstractParser<Suggestion>() {
            @java.lang.Override
            public Suggestion parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              return new Suggestion(input, extensionRegistry);
            }
          };

      public static com.google.protobuf.Parser<Suggestion> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Suggestion> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2.Intent.Message.Suggestion getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface SuggestionsOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.v2.Intent.Message.Suggestions)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Required. The list of suggested replies.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.Message.Suggestion suggestions = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      java.util.List<com.google.cloud.dialogflow.v2.Intent.Message.Suggestion> getSuggestionsList();
      /**
       *
       *
       * <pre>
       * Required. The list of suggested replies.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.Message.Suggestion suggestions = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      com.google.cloud.dialogflow.v2.Intent.Message.Suggestion getSuggestions(int index);
      /**
       *
       *
       * <pre>
       * Required. The list of suggested replies.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.Message.Suggestion suggestions = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      int getSuggestionsCount();
      /**
       *
       *
       * <pre>
       * Required. The list of suggested replies.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.Message.Suggestion suggestions = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      java.util.List<? extends com.google.cloud.dialogflow.v2.Intent.Message.SuggestionOrBuilder>
          getSuggestionsOrBuilderList();
      /**
       *
       *
       * <pre>
       * Required. The list of suggested replies.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.Message.Suggestion suggestions = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      com.google.cloud.dialogflow.v2.Intent.Message.SuggestionOrBuilder getSuggestionsOrBuilder(
          int index);
    }
    /**
     *
     *
     * <pre>
     * The collection of suggestions.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.v2.Intent.Message.Suggestions}
     */
    public static final class Suggestions extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2.Intent.Message.Suggestions)
        SuggestionsOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use Suggestions.newBuilder() to construct.
      private Suggestions(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Suggestions() {
        suggestions_ = java.util.Collections.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Suggestions();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
      }

      private Suggestions(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        int mutable_bitField0_ = 0;
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                    suggestions_ =
                        new java.util.ArrayList<
                            com.google.cloud.dialogflow.v2.Intent.Message.Suggestion>();
                    mutable_bitField0_ |= 0x00000001;
                  }
                  suggestions_.add(
                      input.readMessage(
                          com.google.cloud.dialogflow.v2.Intent.Message.Suggestion.parser(),
                          extensionRegistry));
                  break;
                }
              default:
                {
                  if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                    done = true;
                  }
                  break;
                }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(this);
        } finally {
          if (((mutable_bitField0_ & 0x00000001) != 0)) {
            suggestions_ = java.util.Collections.unmodifiableList(suggestions_);
          }
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.v2.IntentProto
            .internal_static_google_cloud_dialogflow_v2_Intent_Message_Suggestions_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.v2.IntentProto
            .internal_static_google_cloud_dialogflow_v2_Intent_Message_Suggestions_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.v2.Intent.Message.Suggestions.class,
                com.google.cloud.dialogflow.v2.Intent.Message.Suggestions.Builder.class);
      }

      public static final int SUGGESTIONS_FIELD_NUMBER = 1;
      private java.util.List<com.google.cloud.dialogflow.v2.Intent.Message.Suggestion> suggestions_;
      /**
       *
       *
       * <pre>
       * Required. The list of suggested replies.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.Message.Suggestion suggestions = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      @java.lang.Override
      public java.util.List<com.google.cloud.dialogflow.v2.Intent.Message.Suggestion>
          getSuggestionsList() {
        return suggestions_;
      }
      /**
       *
       *
       * <pre>
       * Required. The list of suggested replies.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.Message.Suggestion suggestions = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              ? extends com.google.cloud.dialogflow.v2.Intent.Message.SuggestionOrBuilder>
          getSuggestionsOrBuilderList() {
        return suggestions_;
      }
      /**
       *
       *
       * <pre>
       * Required. The list of suggested replies.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.Message.Suggestion suggestions = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      @java.lang.Override
      public int getSuggestionsCount() {
        return suggestions_.size();
      }
      /**
       *
       *
       * <pre>
       * Required. The list of suggested replies.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.Message.Suggestion suggestions = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.v2.Intent.Message.Suggestion getSuggestions(int index) {
        return suggestions_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Required. The list of suggested replies.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.Message.Suggestion suggestions = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.v2.Intent.Message.SuggestionOrBuilder
          getSuggestionsOrBuilder(int index) {
        return suggestions_.get(index);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        for (int i = 0; i < suggestions_.size(); i++) {
          output.writeMessage(1, suggestions_.get(i));
        }
        unknownFields.writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        for (int i = 0; i < suggestions_.size(); i++) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, suggestions_.get(i));
        }
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.cloud.dialogflow.v2.Intent.Message.Suggestions)) {
          return super.equals(obj);
        }
        com.google.cloud.dialogflow.v2.Intent.Message.Suggestions other =
            (com.google.cloud.dialogflow.v2.Intent.Message.Suggestions) obj;

        if (!getSuggestionsList().equals(other.getSuggestionsList())) return false;
        if (!unknownFields.equals(other.unknownFields)) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (getSuggestionsCount() > 0) {
          hash = (37 * hash) + SUGGESTIONS_FIELD_NUMBER;
          hash = (53 * hash) + getSuggestionsList().hashCode();
        }
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.Suggestions parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.Suggestions parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.Suggestions parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.Suggestions parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.Suggestions parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.Suggestions parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.Suggestions parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.Suggestions parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.Suggestions parseDelimitedFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.Suggestions parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.Suggestions parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.Suggestions parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.dialogflow.v2.Intent.Message.Suggestions prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * The collection of suggestions.
       * </pre>
       *
       * Protobuf type {@code google.cloud.dialogflow.v2.Intent.Message.Suggestions}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2.Intent.Message.Suggestions)
          com.google.cloud.dialogflow.v2.Intent.Message.SuggestionsOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.dialogflow.v2.IntentProto
              .internal_static_google_cloud_dialogflow_v2_Intent_Message_Suggestions_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.dialogflow.v2.IntentProto
              .internal_static_google_cloud_dialogflow_v2_Intent_Message_Suggestions_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.dialogflow.v2.Intent.Message.Suggestions.class,
                  com.google.cloud.dialogflow.v2.Intent.Message.Suggestions.Builder.class);
        }

        // Construct using com.google.cloud.dialogflow.v2.Intent.Message.Suggestions.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
            getSuggestionsFieldBuilder();
          }
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          if (suggestionsBuilder_ == null) {
            suggestions_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            suggestionsBuilder_.clear();
          }
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.dialogflow.v2.IntentProto
              .internal_static_google_cloud_dialogflow_v2_Intent_Message_Suggestions_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.v2.Intent.Message.Suggestions
            getDefaultInstanceForType() {
          return com.google.cloud.dialogflow.v2.Intent.Message.Suggestions.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.v2.Intent.Message.Suggestions build() {
          com.google.cloud.dialogflow.v2.Intent.Message.Suggestions result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.v2.Intent.Message.Suggestions buildPartial() {
          com.google.cloud.dialogflow.v2.Intent.Message.Suggestions result =
              new com.google.cloud.dialogflow.v2.Intent.Message.Suggestions(this);
          int from_bitField0_ = bitField0_;
          if (suggestionsBuilder_ == null) {
            if (((bitField0_ & 0x00000001) != 0)) {
              suggestions_ = java.util.Collections.unmodifiableList(suggestions_);
              bitField0_ = (bitField0_ & ~0x00000001);
            }
            result.suggestions_ = suggestions_;
          } else {
            result.suggestions_ = suggestionsBuilder_.build();
          }
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.cloud.dialogflow.v2.Intent.Message.Suggestions) {
            return mergeFrom((com.google.cloud.dialogflow.v2.Intent.Message.Suggestions) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.google.cloud.dialogflow.v2.Intent.Message.Suggestions other) {
          if (other
              == com.google.cloud.dialogflow.v2.Intent.Message.Suggestions.getDefaultInstance())
            return this;
          if (suggestionsBuilder_ == null) {
            if (!other.suggestions_.isEmpty()) {
              if (suggestions_.isEmpty()) {
                suggestions_ = other.suggestions_;
                bitField0_ = (bitField0_ & ~0x00000001);
              } else {
                ensureSuggestionsIsMutable();
                suggestions_.addAll(other.suggestions_);
              }
              onChanged();
            }
          } else {
            if (!other.suggestions_.isEmpty()) {
              if (suggestionsBuilder_.isEmpty()) {
                suggestionsBuilder_.dispose();
                suggestionsBuilder_ = null;
                suggestions_ = other.suggestions_;
                bitField0_ = (bitField0_ & ~0x00000001);
                suggestionsBuilder_ =
                    com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                        ? getSuggestionsFieldBuilder()
                        : null;
              } else {
                suggestionsBuilder_.addAllMessages(other.suggestions_);
              }
            }
          }
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          com.google.cloud.dialogflow.v2.Intent.Message.Suggestions parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage =
                (com.google.cloud.dialogflow.v2.Intent.Message.Suggestions)
                    e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }

        private int bitField0_;

        private java.util.List<com.google.cloud.dialogflow.v2.Intent.Message.Suggestion>
            suggestions_ = java.util.Collections.emptyList();

        private void ensureSuggestionsIsMutable() {
          if (!((bitField0_ & 0x00000001) != 0)) {
            suggestions_ =
                new java.util.ArrayList<com.google.cloud.dialogflow.v2.Intent.Message.Suggestion>(
                    suggestions_);
            bitField0_ |= 0x00000001;
          }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.v2.Intent.Message.Suggestion,
                com.google.cloud.dialogflow.v2.Intent.Message.Suggestion.Builder,
                com.google.cloud.dialogflow.v2.Intent.Message.SuggestionOrBuilder>
            suggestionsBuilder_;

        /**
         *
         *
         * <pre>
         * Required. The list of suggested replies.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.Suggestion suggestions = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public java.util.List<com.google.cloud.dialogflow.v2.Intent.Message.Suggestion>
            getSuggestionsList() {
          if (suggestionsBuilder_ == null) {
            return java.util.Collections.unmodifiableList(suggestions_);
          } else {
            return suggestionsBuilder_.getMessageList();
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The list of suggested replies.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.Suggestion suggestions = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public int getSuggestionsCount() {
          if (suggestionsBuilder_ == null) {
            return suggestions_.size();
          } else {
            return suggestionsBuilder_.getCount();
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The list of suggested replies.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.Suggestion suggestions = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public com.google.cloud.dialogflow.v2.Intent.Message.Suggestion getSuggestions(int index) {
          if (suggestionsBuilder_ == null) {
            return suggestions_.get(index);
          } else {
            return suggestionsBuilder_.getMessage(index);
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The list of suggested replies.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.Suggestion suggestions = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder setSuggestions(
            int index, com.google.cloud.dialogflow.v2.Intent.Message.Suggestion value) {
          if (suggestionsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureSuggestionsIsMutable();
            suggestions_.set(index, value);
            onChanged();
          } else {
            suggestionsBuilder_.setMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The list of suggested replies.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.Suggestion suggestions = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder setSuggestions(
            int index,
            com.google.cloud.dialogflow.v2.Intent.Message.Suggestion.Builder builderForValue) {
          if (suggestionsBuilder_ == null) {
            ensureSuggestionsIsMutable();
            suggestions_.set(index, builderForValue.build());
            onChanged();
          } else {
            suggestionsBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The list of suggested replies.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.Suggestion suggestions = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder addSuggestions(
            com.google.cloud.dialogflow.v2.Intent.Message.Suggestion value) {
          if (suggestionsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureSuggestionsIsMutable();
            suggestions_.add(value);
            onChanged();
          } else {
            suggestionsBuilder_.addMessage(value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The list of suggested replies.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.Suggestion suggestions = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder addSuggestions(
            int index, com.google.cloud.dialogflow.v2.Intent.Message.Suggestion value) {
          if (suggestionsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureSuggestionsIsMutable();
            suggestions_.add(index, value);
            onChanged();
          } else {
            suggestionsBuilder_.addMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The list of suggested replies.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.Suggestion suggestions = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder addSuggestions(
            com.google.cloud.dialogflow.v2.Intent.Message.Suggestion.Builder builderForValue) {
          if (suggestionsBuilder_ == null) {
            ensureSuggestionsIsMutable();
            suggestions_.add(builderForValue.build());
            onChanged();
          } else {
            suggestionsBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The list of suggested replies.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.Suggestion suggestions = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder addSuggestions(
            int index,
            com.google.cloud.dialogflow.v2.Intent.Message.Suggestion.Builder builderForValue) {
          if (suggestionsBuilder_ == null) {
            ensureSuggestionsIsMutable();
            suggestions_.add(index, builderForValue.build());
            onChanged();
          } else {
            suggestionsBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The list of suggested replies.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.Suggestion suggestions = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder addAllSuggestions(
            java.lang.Iterable<? extends com.google.cloud.dialogflow.v2.Intent.Message.Suggestion>
                values) {
          if (suggestionsBuilder_ == null) {
            ensureSuggestionsIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, suggestions_);
            onChanged();
          } else {
            suggestionsBuilder_.addAllMessages(values);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The list of suggested replies.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.Suggestion suggestions = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder clearSuggestions() {
          if (suggestionsBuilder_ == null) {
            suggestions_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000001);
            onChanged();
          } else {
            suggestionsBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The list of suggested replies.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.Suggestion suggestions = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder removeSuggestions(int index) {
          if (suggestionsBuilder_ == null) {
            ensureSuggestionsIsMutable();
            suggestions_.remove(index);
            onChanged();
          } else {
            suggestionsBuilder_.remove(index);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The list of suggested replies.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.Suggestion suggestions = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public com.google.cloud.dialogflow.v2.Intent.Message.Suggestion.Builder
            getSuggestionsBuilder(int index) {
          return getSuggestionsFieldBuilder().getBuilder(index);
        }
        /**
         *
         *
         * <pre>
         * Required. The list of suggested replies.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.Suggestion suggestions = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public com.google.cloud.dialogflow.v2.Intent.Message.SuggestionOrBuilder
            getSuggestionsOrBuilder(int index) {
          if (suggestionsBuilder_ == null) {
            return suggestions_.get(index);
          } else {
            return suggestionsBuilder_.getMessageOrBuilder(index);
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The list of suggested replies.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.Suggestion suggestions = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public java.util.List<
                ? extends com.google.cloud.dialogflow.v2.Intent.Message.SuggestionOrBuilder>
            getSuggestionsOrBuilderList() {
          if (suggestionsBuilder_ != null) {
            return suggestionsBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(suggestions_);
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The list of suggested replies.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.Suggestion suggestions = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public com.google.cloud.dialogflow.v2.Intent.Message.Suggestion.Builder
            addSuggestionsBuilder() {
          return getSuggestionsFieldBuilder()
              .addBuilder(
                  com.google.cloud.dialogflow.v2.Intent.Message.Suggestion.getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * Required. The list of suggested replies.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.Suggestion suggestions = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public com.google.cloud.dialogflow.v2.Intent.Message.Suggestion.Builder
            addSuggestionsBuilder(int index) {
          return getSuggestionsFieldBuilder()
              .addBuilder(
                  index,
                  com.google.cloud.dialogflow.v2.Intent.Message.Suggestion.getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * Required. The list of suggested replies.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.Suggestion suggestions = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public java.util.List<com.google.cloud.dialogflow.v2.Intent.Message.Suggestion.Builder>
            getSuggestionsBuilderList() {
          return getSuggestionsFieldBuilder().getBuilderList();
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.v2.Intent.Message.Suggestion,
                com.google.cloud.dialogflow.v2.Intent.Message.Suggestion.Builder,
                com.google.cloud.dialogflow.v2.Intent.Message.SuggestionOrBuilder>
            getSuggestionsFieldBuilder() {
          if (suggestionsBuilder_ == null) {
            suggestionsBuilder_ =
                new com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.cloud.dialogflow.v2.Intent.Message.Suggestion,
                    com.google.cloud.dialogflow.v2.Intent.Message.Suggestion.Builder,
                    com.google.cloud.dialogflow.v2.Intent.Message.SuggestionOrBuilder>(
                    suggestions_,
                    ((bitField0_ & 0x00000001) != 0),
                    getParentForChildren(),
                    isClean());
            suggestions_ = null;
          }
          return suggestionsBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2.Intent.Message.Suggestions)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2.Intent.Message.Suggestions)
      private static final com.google.cloud.dialogflow.v2.Intent.Message.Suggestions
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2.Intent.Message.Suggestions();
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.Suggestions getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Suggestions> PARSER =
          new com.google.protobuf.AbstractParser<Suggestions>() {
            @java.lang.Override
            public Suggestions parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              return new Suggestions(input, extensionRegistry);
            }
          };

      public static com.google.protobuf.Parser<Suggestions> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Suggestions> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2.Intent.Message.Suggestions getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface LinkOutSuggestionOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.v2.Intent.Message.LinkOutSuggestion)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Required. The name of the app or site this chip is linking to.
       * </pre>
       *
       * <code>string destination_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The destinationName.
       */
      java.lang.String getDestinationName();
      /**
       *
       *
       * <pre>
       * Required. The name of the app or site this chip is linking to.
       * </pre>
       *
       * <code>string destination_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for destinationName.
       */
      com.google.protobuf.ByteString getDestinationNameBytes();

      /**
       *
       *
       * <pre>
       * Required. The URI of the app or site to open when the user taps the
       * suggestion chip.
       * </pre>
       *
       * <code>string uri = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The uri.
       */
      java.lang.String getUri();
      /**
       *
       *
       * <pre>
       * Required. The URI of the app or site to open when the user taps the
       * suggestion chip.
       * </pre>
       *
       * <code>string uri = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for uri.
       */
      com.google.protobuf.ByteString getUriBytes();
    }
    /**
     *
     *
     * <pre>
     * The suggestion chip message that allows the user to jump out to the app
     * or website associated with this agent.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.v2.Intent.Message.LinkOutSuggestion}
     */
    public static final class LinkOutSuggestion extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2.Intent.Message.LinkOutSuggestion)
        LinkOutSuggestionOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use LinkOutSuggestion.newBuilder() to construct.
      private LinkOutSuggestion(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private LinkOutSuggestion() {
        destinationName_ = "";
        uri_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new LinkOutSuggestion();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
      }

      private LinkOutSuggestion(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();

                  destinationName_ = s;
                  break;
                }
              case 18:
                {
                  java.lang.String s = input.readStringRequireUtf8();

                  uri_ = s;
                  break;
                }
              default:
                {
                  if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                    done = true;
                  }
                  break;
                }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(this);
        } finally {
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.v2.IntentProto
            .internal_static_google_cloud_dialogflow_v2_Intent_Message_LinkOutSuggestion_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.v2.IntentProto
            .internal_static_google_cloud_dialogflow_v2_Intent_Message_LinkOutSuggestion_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.v2.Intent.Message.LinkOutSuggestion.class,
                com.google.cloud.dialogflow.v2.Intent.Message.LinkOutSuggestion.Builder.class);
      }

      public static final int DESTINATION_NAME_FIELD_NUMBER = 1;
      private volatile java.lang.Object destinationName_;
      /**
       *
       *
       * <pre>
       * Required. The name of the app or site this chip is linking to.
       * </pre>
       *
       * <code>string destination_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The destinationName.
       */
      @java.lang.Override
      public java.lang.String getDestinationName() {
        java.lang.Object ref = destinationName_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          destinationName_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The name of the app or site this chip is linking to.
       * </pre>
       *
       * <code>string destination_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for destinationName.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getDestinationNameBytes() {
        java.lang.Object ref = destinationName_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          destinationName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int URI_FIELD_NUMBER = 2;
      private volatile java.lang.Object uri_;
      /**
       *
       *
       * <pre>
       * Required. The URI of the app or site to open when the user taps the
       * suggestion chip.
       * </pre>
       *
       * <code>string uri = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The uri.
       */
      @java.lang.Override
      public java.lang.String getUri() {
        java.lang.Object ref = uri_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          uri_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The URI of the app or site to open when the user taps the
       * suggestion chip.
       * </pre>
       *
       * <code>string uri = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for uri.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getUriBytes() {
        java.lang.Object ref = uri_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          uri_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!getDestinationNameBytes().isEmpty()) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, destinationName_);
        }
        if (!getUriBytes().isEmpty()) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 2, uri_);
        }
        unknownFields.writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!getDestinationNameBytes().isEmpty()) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, destinationName_);
        }
        if (!getUriBytes().isEmpty()) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, uri_);
        }
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.cloud.dialogflow.v2.Intent.Message.LinkOutSuggestion)) {
          return super.equals(obj);
        }
        com.google.cloud.dialogflow.v2.Intent.Message.LinkOutSuggestion other =
            (com.google.cloud.dialogflow.v2.Intent.Message.LinkOutSuggestion) obj;

        if (!getDestinationName().equals(other.getDestinationName())) return false;
        if (!getUri().equals(other.getUri())) return false;
        if (!unknownFields.equals(other.unknownFields)) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + DESTINATION_NAME_FIELD_NUMBER;
        hash = (53 * hash) + getDestinationName().hashCode();
        hash = (37 * hash) + URI_FIELD_NUMBER;
        hash = (53 * hash) + getUri().hashCode();
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.LinkOutSuggestion parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.LinkOutSuggestion parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.LinkOutSuggestion parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.LinkOutSuggestion parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.LinkOutSuggestion parseFrom(
          byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.LinkOutSuggestion parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.LinkOutSuggestion parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.LinkOutSuggestion parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.LinkOutSuggestion
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.LinkOutSuggestion
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.LinkOutSuggestion parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.LinkOutSuggestion parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.dialogflow.v2.Intent.Message.LinkOutSuggestion prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * The suggestion chip message that allows the user to jump out to the app
       * or website associated with this agent.
       * </pre>
       *
       * Protobuf type {@code google.cloud.dialogflow.v2.Intent.Message.LinkOutSuggestion}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2.Intent.Message.LinkOutSuggestion)
          com.google.cloud.dialogflow.v2.Intent.Message.LinkOutSuggestionOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.dialogflow.v2.IntentProto
              .internal_static_google_cloud_dialogflow_v2_Intent_Message_LinkOutSuggestion_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.dialogflow.v2.IntentProto
              .internal_static_google_cloud_dialogflow_v2_Intent_Message_LinkOutSuggestion_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.dialogflow.v2.Intent.Message.LinkOutSuggestion.class,
                  com.google.cloud.dialogflow.v2.Intent.Message.LinkOutSuggestion.Builder.class);
        }

        // Construct using
        // com.google.cloud.dialogflow.v2.Intent.Message.LinkOutSuggestion.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          destinationName_ = "";

          uri_ = "";

          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.dialogflow.v2.IntentProto
              .internal_static_google_cloud_dialogflow_v2_Intent_Message_LinkOutSuggestion_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.v2.Intent.Message.LinkOutSuggestion
            getDefaultInstanceForType() {
          return com.google.cloud.dialogflow.v2.Intent.Message.LinkOutSuggestion
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.v2.Intent.Message.LinkOutSuggestion build() {
          com.google.cloud.dialogflow.v2.Intent.Message.LinkOutSuggestion result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.v2.Intent.Message.LinkOutSuggestion buildPartial() {
          com.google.cloud.dialogflow.v2.Intent.Message.LinkOutSuggestion result =
              new com.google.cloud.dialogflow.v2.Intent.Message.LinkOutSuggestion(this);
          result.destinationName_ = destinationName_;
          result.uri_ = uri_;
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.cloud.dialogflow.v2.Intent.Message.LinkOutSuggestion) {
            return mergeFrom(
                (com.google.cloud.dialogflow.v2.Intent.Message.LinkOutSuggestion) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.dialogflow.v2.Intent.Message.LinkOutSuggestion other) {
          if (other
              == com.google.cloud.dialogflow.v2.Intent.Message.LinkOutSuggestion
                  .getDefaultInstance()) return this;
          if (!other.getDestinationName().isEmpty()) {
            destinationName_ = other.destinationName_;
            onChanged();
          }
          if (!other.getUri().isEmpty()) {
            uri_ = other.uri_;
            onChanged();
          }
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          com.google.cloud.dialogflow.v2.Intent.Message.LinkOutSuggestion parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage =
                (com.google.cloud.dialogflow.v2.Intent.Message.LinkOutSuggestion)
                    e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }

        private java.lang.Object destinationName_ = "";
        /**
         *
         *
         * <pre>
         * Required. The name of the app or site this chip is linking to.
         * </pre>
         *
         * <code>string destination_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The destinationName.
         */
        public java.lang.String getDestinationName() {
          java.lang.Object ref = destinationName_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            destinationName_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The name of the app or site this chip is linking to.
         * </pre>
         *
         * <code>string destination_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for destinationName.
         */
        public com.google.protobuf.ByteString getDestinationNameBytes() {
          java.lang.Object ref = destinationName_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            destinationName_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The name of the app or site this chip is linking to.
         * </pre>
         *
         * <code>string destination_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The destinationName to set.
         * @return This builder for chaining.
         */
        public Builder setDestinationName(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }

          destinationName_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The name of the app or site this chip is linking to.
         * </pre>
         *
         * <code>string destination_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearDestinationName() {

          destinationName_ = getDefaultInstance().getDestinationName();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The name of the app or site this chip is linking to.
         * </pre>
         *
         * <code>string destination_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The bytes for destinationName to set.
         * @return This builder for chaining.
         */
        public Builder setDestinationNameBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);

          destinationName_ = value;
          onChanged();
          return this;
        }

        private java.lang.Object uri_ = "";
        /**
         *
         *
         * <pre>
         * Required. The URI of the app or site to open when the user taps the
         * suggestion chip.
         * </pre>
         *
         * <code>string uri = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The uri.
         */
        public java.lang.String getUri() {
          java.lang.Object ref = uri_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            uri_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The URI of the app or site to open when the user taps the
         * suggestion chip.
         * </pre>
         *
         * <code>string uri = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for uri.
         */
        public com.google.protobuf.ByteString getUriBytes() {
          java.lang.Object ref = uri_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            uri_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The URI of the app or site to open when the user taps the
         * suggestion chip.
         * </pre>
         *
         * <code>string uri = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The uri to set.
         * @return This builder for chaining.
         */
        public Builder setUri(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }

          uri_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The URI of the app or site to open when the user taps the
         * suggestion chip.
         * </pre>
         *
         * <code>string uri = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearUri() {

          uri_ = getDefaultInstance().getUri();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The URI of the app or site to open when the user taps the
         * suggestion chip.
         * </pre>
         *
         * <code>string uri = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The bytes for uri to set.
         * @return This builder for chaining.
         */
        public Builder setUriBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);

          uri_ = value;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2.Intent.Message.LinkOutSuggestion)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2.Intent.Message.LinkOutSuggestion)
      private static final com.google.cloud.dialogflow.v2.Intent.Message.LinkOutSuggestion
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2.Intent.Message.LinkOutSuggestion();
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.LinkOutSuggestion
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<LinkOutSuggestion> PARSER =
          new com.google.protobuf.AbstractParser<LinkOutSuggestion>() {
            @java.lang.Override
            public LinkOutSuggestion parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              return new LinkOutSuggestion(input, extensionRegistry);
            }
          };

      public static com.google.protobuf.Parser<LinkOutSuggestion> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<LinkOutSuggestion> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2.Intent.Message.LinkOutSuggestion
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface ListSelectOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.v2.Intent.Message.ListSelect)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Optional. The overall title of the list.
       * </pre>
       *
       * <code>string title = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The title.
       */
      java.lang.String getTitle();
      /**
       *
       *
       * <pre>
       * Optional. The overall title of the list.
       * </pre>
       *
       * <code>string title = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for title.
       */
      com.google.protobuf.ByteString getTitleBytes();

      /**
       *
       *
       * <pre>
       * Required. List items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item items = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      java.util.List<com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item> getItemsList();
      /**
       *
       *
       * <pre>
       * Required. List items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item items = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item getItems(int index);
      /**
       *
       *
       * <pre>
       * Required. List items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item items = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      int getItemsCount();
      /**
       *
       *
       * <pre>
       * Required. List items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item items = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      java.util.List<
              ? extends com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.ItemOrBuilder>
          getItemsOrBuilderList();
      /**
       *
       *
       * <pre>
       * Required. List items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item items = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.ItemOrBuilder getItemsOrBuilder(
          int index);

      /**
       *
       *
       * <pre>
       * Optional. Subtitle of the list.
       * </pre>
       *
       * <code>string subtitle = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The subtitle.
       */
      java.lang.String getSubtitle();
      /**
       *
       *
       * <pre>
       * Optional. Subtitle of the list.
       * </pre>
       *
       * <code>string subtitle = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for subtitle.
       */
      com.google.protobuf.ByteString getSubtitleBytes();
    }
    /**
     *
     *
     * <pre>
     * The card for presenting a list of options to select from.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.v2.Intent.Message.ListSelect}
     */
    public static final class ListSelect extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2.Intent.Message.ListSelect)
        ListSelectOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use ListSelect.newBuilder() to construct.
      private ListSelect(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private ListSelect() {
        title_ = "";
        items_ = java.util.Collections.emptyList();
        subtitle_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new ListSelect();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
      }

      private ListSelect(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        int mutable_bitField0_ = 0;
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();

                  title_ = s;
                  break;
                }
              case 18:
                {
                  if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                    items_ =
                        new java.util.ArrayList<
                            com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item>();
                    mutable_bitField0_ |= 0x00000001;
                  }
                  items_.add(
                      input.readMessage(
                          com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item.parser(),
                          extensionRegistry));
                  break;
                }
              case 26:
                {
                  java.lang.String s = input.readStringRequireUtf8();

                  subtitle_ = s;
                  break;
                }
              default:
                {
                  if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                    done = true;
                  }
                  break;
                }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(this);
        } finally {
          if (((mutable_bitField0_ & 0x00000001) != 0)) {
            items_ = java.util.Collections.unmodifiableList(items_);
          }
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.v2.IntentProto
            .internal_static_google_cloud_dialogflow_v2_Intent_Message_ListSelect_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.v2.IntentProto
            .internal_static_google_cloud_dialogflow_v2_Intent_Message_ListSelect_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.class,
                com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.Builder.class);
      }

      public interface ItemOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * Required. Additional information about this option.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo info = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return Whether the info field is set.
         */
        boolean hasInfo();
        /**
         *
         *
         * <pre>
         * Required. Additional information about this option.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo info = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return The info.
         */
        com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo getInfo();
        /**
         *
         *
         * <pre>
         * Required. Additional information about this option.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo info = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfoOrBuilder getInfoOrBuilder();

        /**
         *
         *
         * <pre>
         * Required. The title of the list item.
         * </pre>
         *
         * <code>string title = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The title.
         */
        java.lang.String getTitle();
        /**
         *
         *
         * <pre>
         * Required. The title of the list item.
         * </pre>
         *
         * <code>string title = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for title.
         */
        com.google.protobuf.ByteString getTitleBytes();

        /**
         *
         *
         * <pre>
         * Optional. The main text describing the item.
         * </pre>
         *
         * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The description.
         */
        java.lang.String getDescription();
        /**
         *
         *
         * <pre>
         * Optional. The main text describing the item.
         * </pre>
         *
         * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The bytes for description.
         */
        com.google.protobuf.ByteString getDescriptionBytes();

        /**
         *
         *
         * <pre>
         * Optional. The image to display.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.v2.Intent.Message.Image image = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return Whether the image field is set.
         */
        boolean hasImage();
        /**
         *
         *
         * <pre>
         * Optional. The image to display.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.v2.Intent.Message.Image image = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The image.
         */
        com.google.cloud.dialogflow.v2.Intent.Message.Image getImage();
        /**
         *
         *
         * <pre>
         * Optional. The image to display.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.v2.Intent.Message.Image image = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        com.google.cloud.dialogflow.v2.Intent.Message.ImageOrBuilder getImageOrBuilder();
      }
      /**
       *
       *
       * <pre>
       * An item in the list.
       * </pre>
       *
       * Protobuf type {@code google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item}
       */
      public static final class Item extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item)
          ItemOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use Item.newBuilder() to construct.
        private Item(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private Item() {
          title_ = "";
          description_ = "";
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new Item();
        }

        @java.lang.Override
        public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
          return this.unknownFields;
        }

        private Item(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          this();
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          com.google.protobuf.UnknownFieldSet.Builder unknownFields =
              com.google.protobuf.UnknownFieldSet.newBuilder();
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo.Builder
                        subBuilder = null;
                    if (info_ != null) {
                      subBuilder = info_.toBuilder();
                    }
                    info_ =
                        input.readMessage(
                            com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo.parser(),
                            extensionRegistry);
                    if (subBuilder != null) {
                      subBuilder.mergeFrom(info_);
                      info_ = subBuilder.buildPartial();
                    }

                    break;
                  }
                case 18:
                  {
                    java.lang.String s = input.readStringRequireUtf8();

                    title_ = s;
                    break;
                  }
                case 26:
                  {
                    java.lang.String s = input.readStringRequireUtf8();

                    description_ = s;
                    break;
                  }
                case 34:
                  {
                    com.google.cloud.dialogflow.v2.Intent.Message.Image.Builder subBuilder = null;
                    if (image_ != null) {
                      subBuilder = image_.toBuilder();
                    }
                    image_ =
                        input.readMessage(
                            com.google.cloud.dialogflow.v2.Intent.Message.Image.parser(),
                            extensionRegistry);
                    if (subBuilder != null) {
                      subBuilder.mergeFrom(image_);
                      image_ = subBuilder.buildPartial();
                    }

                    break;
                  }
                default:
                  {
                    if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                      done = true;
                    }
                    break;
                  }
              }
            }
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(this);
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(this);
          } finally {
            this.unknownFields = unknownFields.build();
            makeExtensionsImmutable();
          }
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.dialogflow.v2.IntentProto
              .internal_static_google_cloud_dialogflow_v2_Intent_Message_ListSelect_Item_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.dialogflow.v2.IntentProto
              .internal_static_google_cloud_dialogflow_v2_Intent_Message_ListSelect_Item_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item.class,
                  com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item.Builder.class);
        }

        public static final int INFO_FIELD_NUMBER = 1;
        private com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo info_;
        /**
         *
         *
         * <pre>
         * Required. Additional information about this option.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo info = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return Whether the info field is set.
         */
        @java.lang.Override
        public boolean hasInfo() {
          return info_ != null;
        }
        /**
         *
         *
         * <pre>
         * Required. Additional information about this option.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo info = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return The info.
         */
        @java.lang.Override
        public com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo getInfo() {
          return info_ == null
              ? com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo.getDefaultInstance()
              : info_;
        }
        /**
         *
         *
         * <pre>
         * Required. Additional information about this option.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo info = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        @java.lang.Override
        public com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfoOrBuilder
            getInfoOrBuilder() {
          return getInfo();
        }

        public static final int TITLE_FIELD_NUMBER = 2;
        private volatile java.lang.Object title_;
        /**
         *
         *
         * <pre>
         * Required. The title of the list item.
         * </pre>
         *
         * <code>string title = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The title.
         */
        @java.lang.Override
        public java.lang.String getTitle() {
          java.lang.Object ref = title_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            title_ = s;
            return s;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The title of the list item.
         * </pre>
         *
         * <code>string title = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for title.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getTitleBytes() {
          java.lang.Object ref = title_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            title_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        public static final int DESCRIPTION_FIELD_NUMBER = 3;
        private volatile java.lang.Object description_;
        /**
         *
         *
         * <pre>
         * Optional. The main text describing the item.
         * </pre>
         *
         * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The description.
         */
        @java.lang.Override
        public java.lang.String getDescription() {
          java.lang.Object ref = description_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            description_ = s;
            return s;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The main text describing the item.
         * </pre>
         *
         * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The bytes for description.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getDescriptionBytes() {
          java.lang.Object ref = description_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            description_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        public static final int IMAGE_FIELD_NUMBER = 4;
        private com.google.cloud.dialogflow.v2.Intent.Message.Image image_;
        /**
         *
         *
         * <pre>
         * Optional. The image to display.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.v2.Intent.Message.Image image = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return Whether the image field is set.
         */
        @java.lang.Override
        public boolean hasImage() {
          return image_ != null;
        }
        /**
         *
         *
         * <pre>
         * Optional. The image to display.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.v2.Intent.Message.Image image = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The image.
         */
        @java.lang.Override
        public com.google.cloud.dialogflow.v2.Intent.Message.Image getImage() {
          return image_ == null
              ? com.google.cloud.dialogflow.v2.Intent.Message.Image.getDefaultInstance()
              : image_;
        }
        /**
         *
         *
         * <pre>
         * Optional. The image to display.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.v2.Intent.Message.Image image = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        @java.lang.Override
        public com.google.cloud.dialogflow.v2.Intent.Message.ImageOrBuilder getImageOrBuilder() {
          return getImage();
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          if (info_ != null) {
            output.writeMessage(1, getInfo());
          }
          if (!getTitleBytes().isEmpty()) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 2, title_);
          }
          if (!getDescriptionBytes().isEmpty()) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 3, description_);
          }
          if (image_ != null) {
            output.writeMessage(4, getImage());
          }
          unknownFields.writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (info_ != null) {
            size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getInfo());
          }
          if (!getTitleBytes().isEmpty()) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, title_);
          }
          if (!getDescriptionBytes().isEmpty()) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, description_);
          }
          if (image_ != null) {
            size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getImage());
          }
          size += unknownFields.getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj instanceof com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item)) {
            return super.equals(obj);
          }
          com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item other =
              (com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item) obj;

          if (hasInfo() != other.hasInfo()) return false;
          if (hasInfo()) {
            if (!getInfo().equals(other.getInfo())) return false;
          }
          if (!getTitle().equals(other.getTitle())) return false;
          if (!getDescription().equals(other.getDescription())) return false;
          if (hasImage() != other.hasImage()) return false;
          if (hasImage()) {
            if (!getImage().equals(other.getImage())) return false;
          }
          if (!unknownFields.equals(other.unknownFields)) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          if (hasInfo()) {
            hash = (37 * hash) + INFO_FIELD_NUMBER;
            hash = (53 * hash) + getInfo().hashCode();
          }
          hash = (37 * hash) + TITLE_FIELD_NUMBER;
          hash = (53 * hash) + getTitle().hashCode();
          hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
          hash = (53 * hash) + getDescription().hashCode();
          if (hasImage()) {
            hash = (37 * hash) + IMAGE_FIELD_NUMBER;
            hash = (53 * hash) + getImage().hashCode();
          }
          hash = (29 * hash) + unknownFields.hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item parseFrom(
            java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item parseFrom(
            com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item parseFrom(
            byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item parseFrom(
            byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item parseFrom(
            java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item parseFrom(
            com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * An item in the list.
         * </pre>
         *
         * Protobuf type {@code google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item)
            com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.ItemOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.dialogflow.v2.IntentProto
                .internal_static_google_cloud_dialogflow_v2_Intent_Message_ListSelect_Item_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.dialogflow.v2.IntentProto
                .internal_static_google_cloud_dialogflow_v2_Intent_Message_ListSelect_Item_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item.class,
                    com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item.Builder.class);
          }

          // Construct using
          // com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item.newBuilder()
          private Builder() {
            maybeForceBuilderInitialization();
          }

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            maybeForceBuilderInitialization();
          }

          private void maybeForceBuilderInitialization() {
            if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            if (infoBuilder_ == null) {
              info_ = null;
            } else {
              info_ = null;
              infoBuilder_ = null;
            }
            title_ = "";

            description_ = "";

            if (imageBuilder_ == null) {
              image_ = null;
            } else {
              image_ = null;
              imageBuilder_ = null;
            }
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.cloud.dialogflow.v2.IntentProto
                .internal_static_google_cloud_dialogflow_v2_Intent_Message_ListSelect_Item_descriptor;
          }

          @java.lang.Override
          public com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item
              getDefaultInstanceForType() {
            return com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item
                .getDefaultInstance();
          }

          @java.lang.Override
          public com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item build() {
            com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item result = buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item buildPartial() {
            com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item result =
                new com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item(this);
            if (infoBuilder_ == null) {
              result.info_ = info_;
            } else {
              result.info_ = infoBuilder_.build();
            }
            result.title_ = title_;
            result.description_ = description_;
            if (imageBuilder_ == null) {
              result.image_ = image_;
            } else {
              result.image_ = imageBuilder_.build();
            }
            onBuilt();
            return result;
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other instanceof com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item) {
              return mergeFrom(
                  (com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item) other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item other) {
            if (other
                == com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item
                    .getDefaultInstance()) return this;
            if (other.hasInfo()) {
              mergeInfo(other.getInfo());
            }
            if (!other.getTitle().isEmpty()) {
              title_ = other.title_;
              onChanged();
            }
            if (!other.getDescription().isEmpty()) {
              description_ = other.description_;
              onChanged();
            }
            if (other.hasImage()) {
              mergeImage(other.getImage());
            }
            this.mergeUnknownFields(other.unknownFields);
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item parsedMessage = null;
            try {
              parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              parsedMessage =
                  (com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item)
                      e.getUnfinishedMessage();
              throw e.unwrapIOException();
            } finally {
              if (parsedMessage != null) {
                mergeFrom(parsedMessage);
              }
            }
            return this;
          }

          private com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo info_;
          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo,
                  com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo.Builder,
                  com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfoOrBuilder>
              infoBuilder_;
          /**
           *
           *
           * <pre>
           * Required. Additional information about this option.
           * </pre>
           *
           * <code>
           * .google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo info = 1 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           *
           * @return Whether the info field is set.
           */
          public boolean hasInfo() {
            return infoBuilder_ != null || info_ != null;
          }
          /**
           *
           *
           * <pre>
           * Required. Additional information about this option.
           * </pre>
           *
           * <code>
           * .google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo info = 1 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           *
           * @return The info.
           */
          public com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo getInfo() {
            if (infoBuilder_ == null) {
              return info_ == null
                  ? com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo
                      .getDefaultInstance()
                  : info_;
            } else {
              return infoBuilder_.getMessage();
            }
          }
          /**
           *
           *
           * <pre>
           * Required. Additional information about this option.
           * </pre>
           *
           * <code>
           * .google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo info = 1 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           */
          public Builder setInfo(
              com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo value) {
            if (infoBuilder_ == null) {
              if (value == null) {
                throw new NullPointerException();
              }
              info_ = value;
              onChanged();
            } else {
              infoBuilder_.setMessage(value);
            }

            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. Additional information about this option.
           * </pre>
           *
           * <code>
           * .google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo info = 1 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           */
          public Builder setInfo(
              com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo.Builder
                  builderForValue) {
            if (infoBuilder_ == null) {
              info_ = builderForValue.build();
              onChanged();
            } else {
              infoBuilder_.setMessage(builderForValue.build());
            }

            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. Additional information about this option.
           * </pre>
           *
           * <code>
           * .google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo info = 1 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           */
          public Builder mergeInfo(
              com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo value) {
            if (infoBuilder_ == null) {
              if (info_ != null) {
                info_ =
                    com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo.newBuilder(info_)
                        .mergeFrom(value)
                        .buildPartial();
              } else {
                info_ = value;
              }
              onChanged();
            } else {
              infoBuilder_.mergeFrom(value);
            }

            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. Additional information about this option.
           * </pre>
           *
           * <code>
           * .google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo info = 1 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           */
          public Builder clearInfo() {
            if (infoBuilder_ == null) {
              info_ = null;
              onChanged();
            } else {
              info_ = null;
              infoBuilder_ = null;
            }

            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. Additional information about this option.
           * </pre>
           *
           * <code>
           * .google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo info = 1 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           */
          public com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo.Builder
              getInfoBuilder() {

            onChanged();
            return getInfoFieldBuilder().getBuilder();
          }
          /**
           *
           *
           * <pre>
           * Required. Additional information about this option.
           * </pre>
           *
           * <code>
           * .google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo info = 1 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           */
          public com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfoOrBuilder
              getInfoOrBuilder() {
            if (infoBuilder_ != null) {
              return infoBuilder_.getMessageOrBuilder();
            } else {
              return info_ == null
                  ? com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo
                      .getDefaultInstance()
                  : info_;
            }
          }
          /**
           *
           *
           * <pre>
           * Required. Additional information about this option.
           * </pre>
           *
           * <code>
           * .google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo info = 1 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           */
          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo,
                  com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo.Builder,
                  com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfoOrBuilder>
              getInfoFieldBuilder() {
            if (infoBuilder_ == null) {
              infoBuilder_ =
                  new com.google.protobuf.SingleFieldBuilderV3<
                      com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo,
                      com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo.Builder,
                      com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfoOrBuilder>(
                      getInfo(), getParentForChildren(), isClean());
              info_ = null;
            }
            return infoBuilder_;
          }

          private java.lang.Object title_ = "";
          /**
           *
           *
           * <pre>
           * Required. The title of the list item.
           * </pre>
           *
           * <code>string title = 2 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return The title.
           */
          public java.lang.String getTitle() {
            java.lang.Object ref = title_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              title_ = s;
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Required. The title of the list item.
           * </pre>
           *
           * <code>string title = 2 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return The bytes for title.
           */
          public com.google.protobuf.ByteString getTitleBytes() {
            java.lang.Object ref = title_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              title_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Required. The title of the list item.
           * </pre>
           *
           * <code>string title = 2 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param value The title to set.
           * @return This builder for chaining.
           */
          public Builder setTitle(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }

            title_ = value;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. The title of the list item.
           * </pre>
           *
           * <code>string title = 2 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearTitle() {

            title_ = getDefaultInstance().getTitle();
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. The title of the list item.
           * </pre>
           *
           * <code>string title = 2 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param value The bytes for title to set.
           * @return This builder for chaining.
           */
          public Builder setTitleBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);

            title_ = value;
            onChanged();
            return this;
          }

          private java.lang.Object description_ = "";
          /**
           *
           *
           * <pre>
           * Optional. The main text describing the item.
           * </pre>
           *
           * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
           *
           * @return The description.
           */
          public java.lang.String getDescription() {
            java.lang.Object ref = description_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              description_ = s;
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Optional. The main text describing the item.
           * </pre>
           *
           * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
           *
           * @return The bytes for description.
           */
          public com.google.protobuf.ByteString getDescriptionBytes() {
            java.lang.Object ref = description_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              description_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Optional. The main text describing the item.
           * </pre>
           *
           * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
           *
           * @param value The description to set.
           * @return This builder for chaining.
           */
          public Builder setDescription(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }

            description_ = value;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Optional. The main text describing the item.
           * </pre>
           *
           * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearDescription() {

            description_ = getDefaultInstance().getDescription();
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Optional. The main text describing the item.
           * </pre>
           *
           * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
           *
           * @param value The bytes for description to set.
           * @return This builder for chaining.
           */
          public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);

            description_ = value;
            onChanged();
            return this;
          }

          private com.google.cloud.dialogflow.v2.Intent.Message.Image image_;
          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.dialogflow.v2.Intent.Message.Image,
                  com.google.cloud.dialogflow.v2.Intent.Message.Image.Builder,
                  com.google.cloud.dialogflow.v2.Intent.Message.ImageOrBuilder>
              imageBuilder_;
          /**
           *
           *
           * <pre>
           * Optional. The image to display.
           * </pre>
           *
           * <code>
           * .google.cloud.dialogflow.v2.Intent.Message.Image image = 4 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           *
           * @return Whether the image field is set.
           */
          public boolean hasImage() {
            return imageBuilder_ != null || image_ != null;
          }
          /**
           *
           *
           * <pre>
           * Optional. The image to display.
           * </pre>
           *
           * <code>
           * .google.cloud.dialogflow.v2.Intent.Message.Image image = 4 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           *
           * @return The image.
           */
          public com.google.cloud.dialogflow.v2.Intent.Message.Image getImage() {
            if (imageBuilder_ == null) {
              return image_ == null
                  ? com.google.cloud.dialogflow.v2.Intent.Message.Image.getDefaultInstance()
                  : image_;
            } else {
              return imageBuilder_.getMessage();
            }
          }
          /**
           *
           *
           * <pre>
           * Optional. The image to display.
           * </pre>
           *
           * <code>
           * .google.cloud.dialogflow.v2.Intent.Message.Image image = 4 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           */
          public Builder setImage(com.google.cloud.dialogflow.v2.Intent.Message.Image value) {
            if (imageBuilder_ == null) {
              if (value == null) {
                throw new NullPointerException();
              }
              image_ = value;
              onChanged();
            } else {
              imageBuilder_.setMessage(value);
            }

            return this;
          }
          /**
           *
           *
           * <pre>
           * Optional. The image to display.
           * </pre>
           *
           * <code>
           * .google.cloud.dialogflow.v2.Intent.Message.Image image = 4 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           */
          public Builder setImage(
              com.google.cloud.dialogflow.v2.Intent.Message.Image.Builder builderForValue) {
            if (imageBuilder_ == null) {
              image_ = builderForValue.build();
              onChanged();
            } else {
              imageBuilder_.setMessage(builderForValue.build());
            }

            return this;
          }
          /**
           *
           *
           * <pre>
           * Optional. The image to display.
           * </pre>
           *
           * <code>
           * .google.cloud.dialogflow.v2.Intent.Message.Image image = 4 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           */
          public Builder mergeImage(com.google.cloud.dialogflow.v2.Intent.Message.Image value) {
            if (imageBuilder_ == null) {
              if (image_ != null) {
                image_ =
                    com.google.cloud.dialogflow.v2.Intent.Message.Image.newBuilder(image_)
                        .mergeFrom(value)
                        .buildPartial();
              } else {
                image_ = value;
              }
              onChanged();
            } else {
              imageBuilder_.mergeFrom(value);
            }

            return this;
          }
          /**
           *
           *
           * <pre>
           * Optional. The image to display.
           * </pre>
           *
           * <code>
           * .google.cloud.dialogflow.v2.Intent.Message.Image image = 4 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           */
          public Builder clearImage() {
            if (imageBuilder_ == null) {
              image_ = null;
              onChanged();
            } else {
              image_ = null;
              imageBuilder_ = null;
            }

            return this;
          }
          /**
           *
           *
           * <pre>
           * Optional. The image to display.
           * </pre>
           *
           * <code>
           * .google.cloud.dialogflow.v2.Intent.Message.Image image = 4 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           */
          public com.google.cloud.dialogflow.v2.Intent.Message.Image.Builder getImageBuilder() {

            onChanged();
            return getImageFieldBuilder().getBuilder();
          }
          /**
           *
           *
           * <pre>
           * Optional. The image to display.
           * </pre>
           *
           * <code>
           * .google.cloud.dialogflow.v2.Intent.Message.Image image = 4 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           */
          public com.google.cloud.dialogflow.v2.Intent.Message.ImageOrBuilder getImageOrBuilder() {
            if (imageBuilder_ != null) {
              return imageBuilder_.getMessageOrBuilder();
            } else {
              return image_ == null
                  ? com.google.cloud.dialogflow.v2.Intent.Message.Image.getDefaultInstance()
                  : image_;
            }
          }
          /**
           *
           *
           * <pre>
           * Optional. The image to display.
           * </pre>
           *
           * <code>
           * .google.cloud.dialogflow.v2.Intent.Message.Image image = 4 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           */
          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.dialogflow.v2.Intent.Message.Image,
                  com.google.cloud.dialogflow.v2.Intent.Message.Image.Builder,
                  com.google.cloud.dialogflow.v2.Intent.Message.ImageOrBuilder>
              getImageFieldBuilder() {
            if (imageBuilder_ == null) {
              imageBuilder_ =
                  new com.google.protobuf.SingleFieldBuilderV3<
                      com.google.cloud.dialogflow.v2.Intent.Message.Image,
                      com.google.cloud.dialogflow.v2.Intent.Message.Image.Builder,
                      com.google.cloud.dialogflow.v2.Intent.Message.ImageOrBuilder>(
                      getImage(), getParentForChildren(), isClean());
              image_ = null;
            }
            return imageBuilder_;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item)
        }

        // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item)
        private static final com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item();
        }

        public static com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<Item> PARSER =
            new com.google.protobuf.AbstractParser<Item>() {
              @java.lang.Override
              public Item parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                return new Item(input, extensionRegistry);
              }
            };

        public static com.google.protobuf.Parser<Item> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<Item> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      public static final int TITLE_FIELD_NUMBER = 1;
      private volatile java.lang.Object title_;
      /**
       *
       *
       * <pre>
       * Optional. The overall title of the list.
       * </pre>
       *
       * <code>string title = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The title.
       */
      @java.lang.Override
      public java.lang.String getTitle() {
        java.lang.Object ref = title_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          title_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The overall title of the list.
       * </pre>
       *
       * <code>string title = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for title.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getTitleBytes() {
        java.lang.Object ref = title_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          title_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int ITEMS_FIELD_NUMBER = 2;
      private java.util.List<com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item> items_;
      /**
       *
       *
       * <pre>
       * Required. List items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item items = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      @java.lang.Override
      public java.util.List<com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item>
          getItemsList() {
        return items_;
      }
      /**
       *
       *
       * <pre>
       * Required. List items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item items = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              ? extends com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.ItemOrBuilder>
          getItemsOrBuilderList() {
        return items_;
      }
      /**
       *
       *
       * <pre>
       * Required. List items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item items = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      @java.lang.Override
      public int getItemsCount() {
        return items_.size();
      }
      /**
       *
       *
       * <pre>
       * Required. List items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item items = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item getItems(int index) {
        return items_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Required. List items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item items = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.ItemOrBuilder
          getItemsOrBuilder(int index) {
        return items_.get(index);
      }

      public static final int SUBTITLE_FIELD_NUMBER = 3;
      private volatile java.lang.Object subtitle_;
      /**
       *
       *
       * <pre>
       * Optional. Subtitle of the list.
       * </pre>
       *
       * <code>string subtitle = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The subtitle.
       */
      @java.lang.Override
      public java.lang.String getSubtitle() {
        java.lang.Object ref = subtitle_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          subtitle_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Subtitle of the list.
       * </pre>
       *
       * <code>string subtitle = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for subtitle.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getSubtitleBytes() {
        java.lang.Object ref = subtitle_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          subtitle_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!getTitleBytes().isEmpty()) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, title_);
        }
        for (int i = 0; i < items_.size(); i++) {
          output.writeMessage(2, items_.get(i));
        }
        if (!getSubtitleBytes().isEmpty()) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 3, subtitle_);
        }
        unknownFields.writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!getTitleBytes().isEmpty()) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, title_);
        }
        for (int i = 0; i < items_.size(); i++) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, items_.get(i));
        }
        if (!getSubtitleBytes().isEmpty()) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, subtitle_);
        }
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.cloud.dialogflow.v2.Intent.Message.ListSelect)) {
          return super.equals(obj);
        }
        com.google.cloud.dialogflow.v2.Intent.Message.ListSelect other =
            (com.google.cloud.dialogflow.v2.Intent.Message.ListSelect) obj;

        if (!getTitle().equals(other.getTitle())) return false;
        if (!getItemsList().equals(other.getItemsList())) return false;
        if (!getSubtitle().equals(other.getSubtitle())) return false;
        if (!unknownFields.equals(other.unknownFields)) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + TITLE_FIELD_NUMBER;
        hash = (53 * hash) + getTitle().hashCode();
        if (getItemsCount() > 0) {
          hash = (37 * hash) + ITEMS_FIELD_NUMBER;
          hash = (53 * hash) + getItemsList().hashCode();
        }
        hash = (37 * hash) + SUBTITLE_FIELD_NUMBER;
        hash = (53 * hash) + getSubtitle().hashCode();
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.ListSelect parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.ListSelect parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.ListSelect parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.ListSelect parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.ListSelect parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.ListSelect parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.ListSelect parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.ListSelect parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.ListSelect parseDelimitedFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.ListSelect parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.ListSelect parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.ListSelect parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.dialogflow.v2.Intent.Message.ListSelect prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * The card for presenting a list of options to select from.
       * </pre>
       *
       * Protobuf type {@code google.cloud.dialogflow.v2.Intent.Message.ListSelect}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2.Intent.Message.ListSelect)
          com.google.cloud.dialogflow.v2.Intent.Message.ListSelectOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.dialogflow.v2.IntentProto
              .internal_static_google_cloud_dialogflow_v2_Intent_Message_ListSelect_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.dialogflow.v2.IntentProto
              .internal_static_google_cloud_dialogflow_v2_Intent_Message_ListSelect_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.class,
                  com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.Builder.class);
        }

        // Construct using com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
            getItemsFieldBuilder();
          }
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          title_ = "";

          if (itemsBuilder_ == null) {
            items_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            itemsBuilder_.clear();
          }
          subtitle_ = "";

          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.dialogflow.v2.IntentProto
              .internal_static_google_cloud_dialogflow_v2_Intent_Message_ListSelect_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.v2.Intent.Message.ListSelect
            getDefaultInstanceForType() {
          return com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.v2.Intent.Message.ListSelect build() {
          com.google.cloud.dialogflow.v2.Intent.Message.ListSelect result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.v2.Intent.Message.ListSelect buildPartial() {
          com.google.cloud.dialogflow.v2.Intent.Message.ListSelect result =
              new com.google.cloud.dialogflow.v2.Intent.Message.ListSelect(this);
          int from_bitField0_ = bitField0_;
          result.title_ = title_;
          if (itemsBuilder_ == null) {
            if (((bitField0_ & 0x00000001) != 0)) {
              items_ = java.util.Collections.unmodifiableList(items_);
              bitField0_ = (bitField0_ & ~0x00000001);
            }
            result.items_ = items_;
          } else {
            result.items_ = itemsBuilder_.build();
          }
          result.subtitle_ = subtitle_;
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.cloud.dialogflow.v2.Intent.Message.ListSelect) {
            return mergeFrom((com.google.cloud.dialogflow.v2.Intent.Message.ListSelect) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.google.cloud.dialogflow.v2.Intent.Message.ListSelect other) {
          if (other
              == com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.getDefaultInstance())
            return this;
          if (!other.getTitle().isEmpty()) {
            title_ = other.title_;
            onChanged();
          }
          if (itemsBuilder_ == null) {
            if (!other.items_.isEmpty()) {
              if (items_.isEmpty()) {
                items_ = other.items_;
                bitField0_ = (bitField0_ & ~0x00000001);
              } else {
                ensureItemsIsMutable();
                items_.addAll(other.items_);
              }
              onChanged();
            }
          } else {
            if (!other.items_.isEmpty()) {
              if (itemsBuilder_.isEmpty()) {
                itemsBuilder_.dispose();
                itemsBuilder_ = null;
                items_ = other.items_;
                bitField0_ = (bitField0_ & ~0x00000001);
                itemsBuilder_ =
                    com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                        ? getItemsFieldBuilder()
                        : null;
              } else {
                itemsBuilder_.addAllMessages(other.items_);
              }
            }
          }
          if (!other.getSubtitle().isEmpty()) {
            subtitle_ = other.subtitle_;
            onChanged();
          }
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          com.google.cloud.dialogflow.v2.Intent.Message.ListSelect parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage =
                (com.google.cloud.dialogflow.v2.Intent.Message.ListSelect) e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }

        private int bitField0_;

        private java.lang.Object title_ = "";
        /**
         *
         *
         * <pre>
         * Optional. The overall title of the list.
         * </pre>
         *
         * <code>string title = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The title.
         */
        public java.lang.String getTitle() {
          java.lang.Object ref = title_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            title_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The overall title of the list.
         * </pre>
         *
         * <code>string title = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The bytes for title.
         */
        public com.google.protobuf.ByteString getTitleBytes() {
          java.lang.Object ref = title_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            title_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The overall title of the list.
         * </pre>
         *
         * <code>string title = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The title to set.
         * @return This builder for chaining.
         */
        public Builder setTitle(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }

          title_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The overall title of the list.
         * </pre>
         *
         * <code>string title = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearTitle() {

          title_ = getDefaultInstance().getTitle();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The overall title of the list.
         * </pre>
         *
         * <code>string title = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The bytes for title to set.
         * @return This builder for chaining.
         */
        public Builder setTitleBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);

          title_ = value;
          onChanged();
          return this;
        }

        private java.util.List<com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item>
            items_ = java.util.Collections.emptyList();

        private void ensureItemsIsMutable() {
          if (!((bitField0_ & 0x00000001) != 0)) {
            items_ =
                new java.util.ArrayList<
                    com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item>(items_);
            bitField0_ |= 0x00000001;
          }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item,
                com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item.Builder,
                com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.ItemOrBuilder>
            itemsBuilder_;

        /**
         *
         *
         * <pre>
         * Required. List items.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item items = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public java.util.List<com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item>
            getItemsList() {
          if (itemsBuilder_ == null) {
            return java.util.Collections.unmodifiableList(items_);
          } else {
            return itemsBuilder_.getMessageList();
          }
        }
        /**
         *
         *
         * <pre>
         * Required. List items.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item items = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public int getItemsCount() {
          if (itemsBuilder_ == null) {
            return items_.size();
          } else {
            return itemsBuilder_.getCount();
          }
        }
        /**
         *
         *
         * <pre>
         * Required. List items.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item items = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item getItems(int index) {
          if (itemsBuilder_ == null) {
            return items_.get(index);
          } else {
            return itemsBuilder_.getMessage(index);
          }
        }
        /**
         *
         *
         * <pre>
         * Required. List items.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item items = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder setItems(
            int index, com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item value) {
          if (itemsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureItemsIsMutable();
            items_.set(index, value);
            onChanged();
          } else {
            itemsBuilder_.setMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. List items.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item items = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder setItems(
            int index,
            com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item.Builder builderForValue) {
          if (itemsBuilder_ == null) {
            ensureItemsIsMutable();
            items_.set(index, builderForValue.build());
            onChanged();
          } else {
            itemsBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. List items.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item items = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder addItems(
            com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item value) {
          if (itemsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureItemsIsMutable();
            items_.add(value);
            onChanged();
          } else {
            itemsBuilder_.addMessage(value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. List items.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item items = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder addItems(
            int index, com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item value) {
          if (itemsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureItemsIsMutable();
            items_.add(index, value);
            onChanged();
          } else {
            itemsBuilder_.addMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. List items.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item items = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder addItems(
            com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item.Builder builderForValue) {
          if (itemsBuilder_ == null) {
            ensureItemsIsMutable();
            items_.add(builderForValue.build());
            onChanged();
          } else {
            itemsBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. List items.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item items = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder addItems(
            int index,
            com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item.Builder builderForValue) {
          if (itemsBuilder_ == null) {
            ensureItemsIsMutable();
            items_.add(index, builderForValue.build());
            onChanged();
          } else {
            itemsBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. List items.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item items = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder addAllItems(
            java.lang.Iterable<
                    ? extends com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item>
                values) {
          if (itemsBuilder_ == null) {
            ensureItemsIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, items_);
            onChanged();
          } else {
            itemsBuilder_.addAllMessages(values);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. List items.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item items = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder clearItems() {
          if (itemsBuilder_ == null) {
            items_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000001);
            onChanged();
          } else {
            itemsBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. List items.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item items = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder removeItems(int index) {
          if (itemsBuilder_ == null) {
            ensureItemsIsMutable();
            items_.remove(index);
            onChanged();
          } else {
            itemsBuilder_.remove(index);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. List items.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item items = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item.Builder
            getItemsBuilder(int index) {
          return getItemsFieldBuilder().getBuilder(index);
        }
        /**
         *
         *
         * <pre>
         * Required. List items.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item items = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.ItemOrBuilder
            getItemsOrBuilder(int index) {
          if (itemsBuilder_ == null) {
            return items_.get(index);
          } else {
            return itemsBuilder_.getMessageOrBuilder(index);
          }
        }
        /**
         *
         *
         * <pre>
         * Required. List items.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item items = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public java.util.List<
                ? extends com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.ItemOrBuilder>
            getItemsOrBuilderList() {
          if (itemsBuilder_ != null) {
            return itemsBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(items_);
          }
        }
        /**
         *
         *
         * <pre>
         * Required. List items.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item items = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item.Builder
            addItemsBuilder() {
          return getItemsFieldBuilder()
              .addBuilder(
                  com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item
                      .getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * Required. List items.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item items = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item.Builder
            addItemsBuilder(int index) {
          return getItemsFieldBuilder()
              .addBuilder(
                  index,
                  com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item
                      .getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * Required. List items.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item items = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public java.util.List<com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item.Builder>
            getItemsBuilderList() {
          return getItemsFieldBuilder().getBuilderList();
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item,
                com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item.Builder,
                com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.ItemOrBuilder>
            getItemsFieldBuilder() {
          if (itemsBuilder_ == null) {
            itemsBuilder_ =
                new com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item,
                    com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item.Builder,
                    com.google.cloud.dialogflow.v2.Intent.Message.ListSelect.ItemOrBuilder>(
                    items_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
            items_ = null;
          }
          return itemsBuilder_;
        }

        private java.lang.Object subtitle_ = "";
        /**
         *
         *
         * <pre>
         * Optional. Subtitle of the list.
         * </pre>
         *
         * <code>string subtitle = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The subtitle.
         */
        public java.lang.String getSubtitle() {
          java.lang.Object ref = subtitle_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            subtitle_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. Subtitle of the list.
         * </pre>
         *
         * <code>string subtitle = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The bytes for subtitle.
         */
        public com.google.protobuf.ByteString getSubtitleBytes() {
          java.lang.Object ref = subtitle_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            subtitle_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. Subtitle of the list.
         * </pre>
         *
         * <code>string subtitle = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The subtitle to set.
         * @return This builder for chaining.
         */
        public Builder setSubtitle(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }

          subtitle_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. Subtitle of the list.
         * </pre>
         *
         * <code>string subtitle = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearSubtitle() {

          subtitle_ = getDefaultInstance().getSubtitle();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. Subtitle of the list.
         * </pre>
         *
         * <code>string subtitle = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The bytes for subtitle to set.
         * @return This builder for chaining.
         */
        public Builder setSubtitleBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);

          subtitle_ = value;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2.Intent.Message.ListSelect)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2.Intent.Message.ListSelect)
      private static final com.google.cloud.dialogflow.v2.Intent.Message.ListSelect
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2.Intent.Message.ListSelect();
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.ListSelect getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<ListSelect> PARSER =
          new com.google.protobuf.AbstractParser<ListSelect>() {
            @java.lang.Override
            public ListSelect parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              return new ListSelect(input, extensionRegistry);
            }
          };

      public static com.google.protobuf.Parser<ListSelect> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<ListSelect> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2.Intent.Message.ListSelect getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface CarouselSelectOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.v2.Intent.Message.CarouselSelect)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Required. Carousel items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item items = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      java.util.List<com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item>
          getItemsList();
      /**
       *
       *
       * <pre>
       * Required. Carousel items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item items = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item getItems(int index);
      /**
       *
       *
       * <pre>
       * Required. Carousel items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item items = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      int getItemsCount();
      /**
       *
       *
       * <pre>
       * Required. Carousel items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item items = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      java.util.List<
              ? extends com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.ItemOrBuilder>
          getItemsOrBuilderList();
      /**
       *
       *
       * <pre>
       * Required. Carousel items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item items = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.ItemOrBuilder getItemsOrBuilder(
          int index);
    }
    /**
     *
     *
     * <pre>
     * The card for presenting a carousel of options to select from.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.v2.Intent.Message.CarouselSelect}
     */
    public static final class CarouselSelect extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2.Intent.Message.CarouselSelect)
        CarouselSelectOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use CarouselSelect.newBuilder() to construct.
      private CarouselSelect(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private CarouselSelect() {
        items_ = java.util.Collections.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new CarouselSelect();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
      }

      private CarouselSelect(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        int mutable_bitField0_ = 0;
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                    items_ =
                        new java.util.ArrayList<
                            com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item>();
                    mutable_bitField0_ |= 0x00000001;
                  }
                  items_.add(
                      input.readMessage(
                          com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item
                              .parser(),
                          extensionRegistry));
                  break;
                }
              default:
                {
                  if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                    done = true;
                  }
                  break;
                }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(this);
        } finally {
          if (((mutable_bitField0_ & 0x00000001) != 0)) {
            items_ = java.util.Collections.unmodifiableList(items_);
          }
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.v2.IntentProto
            .internal_static_google_cloud_dialogflow_v2_Intent_Message_CarouselSelect_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.v2.IntentProto
            .internal_static_google_cloud_dialogflow_v2_Intent_Message_CarouselSelect_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.class,
                com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Builder.class);
      }

      public interface ItemOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * Required. Additional info about the option item.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo info = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return Whether the info field is set.
         */
        boolean hasInfo();
        /**
         *
         *
         * <pre>
         * Required. Additional info about the option item.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo info = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return The info.
         */
        com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo getInfo();
        /**
         *
         *
         * <pre>
         * Required. Additional info about the option item.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo info = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfoOrBuilder getInfoOrBuilder();

        /**
         *
         *
         * <pre>
         * Required. Title of the carousel item.
         * </pre>
         *
         * <code>string title = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The title.
         */
        java.lang.String getTitle();
        /**
         *
         *
         * <pre>
         * Required. Title of the carousel item.
         * </pre>
         *
         * <code>string title = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for title.
         */
        com.google.protobuf.ByteString getTitleBytes();

        /**
         *
         *
         * <pre>
         * Optional. The body text of the card.
         * </pre>
         *
         * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The description.
         */
        java.lang.String getDescription();
        /**
         *
         *
         * <pre>
         * Optional. The body text of the card.
         * </pre>
         *
         * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The bytes for description.
         */
        com.google.protobuf.ByteString getDescriptionBytes();

        /**
         *
         *
         * <pre>
         * Optional. The image to display.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.v2.Intent.Message.Image image = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return Whether the image field is set.
         */
        boolean hasImage();
        /**
         *
         *
         * <pre>
         * Optional. The image to display.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.v2.Intent.Message.Image image = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The image.
         */
        com.google.cloud.dialogflow.v2.Intent.Message.Image getImage();
        /**
         *
         *
         * <pre>
         * Optional. The image to display.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.v2.Intent.Message.Image image = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        com.google.cloud.dialogflow.v2.Intent.Message.ImageOrBuilder getImageOrBuilder();
      }
      /**
       *
       *
       * <pre>
       * An item in the carousel.
       * </pre>
       *
       * Protobuf type {@code google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item}
       */
      public static final class Item extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item)
          ItemOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use Item.newBuilder() to construct.
        private Item(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private Item() {
          title_ = "";
          description_ = "";
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new Item();
        }

        @java.lang.Override
        public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
          return this.unknownFields;
        }

        private Item(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          this();
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          com.google.protobuf.UnknownFieldSet.Builder unknownFields =
              com.google.protobuf.UnknownFieldSet.newBuilder();
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo.Builder
                        subBuilder = null;
                    if (info_ != null) {
                      subBuilder = info_.toBuilder();
                    }
                    info_ =
                        input.readMessage(
                            com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo.parser(),
                            extensionRegistry);
                    if (subBuilder != null) {
                      subBuilder.mergeFrom(info_);
                      info_ = subBuilder.buildPartial();
                    }

                    break;
                  }
                case 18:
                  {
                    java.lang.String s = input.readStringRequireUtf8();

                    title_ = s;
                    break;
                  }
                case 26:
                  {
                    java.lang.String s = input.readStringRequireUtf8();

                    description_ = s;
                    break;
                  }
                case 34:
                  {
                    com.google.cloud.dialogflow.v2.Intent.Message.Image.Builder subBuilder = null;
                    if (image_ != null) {
                      subBuilder = image_.toBuilder();
                    }
                    image_ =
                        input.readMessage(
                            com.google.cloud.dialogflow.v2.Intent.Message.Image.parser(),
                            extensionRegistry);
                    if (subBuilder != null) {
                      subBuilder.mergeFrom(image_);
                      image_ = subBuilder.buildPartial();
                    }

                    break;
                  }
                default:
                  {
                    if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                      done = true;
                    }
                    break;
                  }
              }
            }
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(this);
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(this);
          } finally {
            this.unknownFields = unknownFields.build();
            makeExtensionsImmutable();
          }
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.dialogflow.v2.IntentProto
              .internal_static_google_cloud_dialogflow_v2_Intent_Message_CarouselSelect_Item_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.dialogflow.v2.IntentProto
              .internal_static_google_cloud_dialogflow_v2_Intent_Message_CarouselSelect_Item_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item.class,
                  com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item.Builder.class);
        }

        public static final int INFO_FIELD_NUMBER = 1;
        private com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo info_;
        /**
         *
         *
         * <pre>
         * Required. Additional info about the option item.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo info = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return Whether the info field is set.
         */
        @java.lang.Override
        public boolean hasInfo() {
          return info_ != null;
        }
        /**
         *
         *
         * <pre>
         * Required. Additional info about the option item.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo info = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return The info.
         */
        @java.lang.Override
        public com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo getInfo() {
          return info_ == null
              ? com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo.getDefaultInstance()
              : info_;
        }
        /**
         *
         *
         * <pre>
         * Required. Additional info about the option item.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo info = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        @java.lang.Override
        public com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfoOrBuilder
            getInfoOrBuilder() {
          return getInfo();
        }

        public static final int TITLE_FIELD_NUMBER = 2;
        private volatile java.lang.Object title_;
        /**
         *
         *
         * <pre>
         * Required. Title of the carousel item.
         * </pre>
         *
         * <code>string title = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The title.
         */
        @java.lang.Override
        public java.lang.String getTitle() {
          java.lang.Object ref = title_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            title_ = s;
            return s;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. Title of the carousel item.
         * </pre>
         *
         * <code>string title = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for title.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getTitleBytes() {
          java.lang.Object ref = title_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            title_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        public static final int DESCRIPTION_FIELD_NUMBER = 3;
        private volatile java.lang.Object description_;
        /**
         *
         *
         * <pre>
         * Optional. The body text of the card.
         * </pre>
         *
         * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The description.
         */
        @java.lang.Override
        public java.lang.String getDescription() {
          java.lang.Object ref = description_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            description_ = s;
            return s;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The body text of the card.
         * </pre>
         *
         * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The bytes for description.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getDescriptionBytes() {
          java.lang.Object ref = description_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            description_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        public static final int IMAGE_FIELD_NUMBER = 4;
        private com.google.cloud.dialogflow.v2.Intent.Message.Image image_;
        /**
         *
         *
         * <pre>
         * Optional. The image to display.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.v2.Intent.Message.Image image = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return Whether the image field is set.
         */
        @java.lang.Override
        public boolean hasImage() {
          return image_ != null;
        }
        /**
         *
         *
         * <pre>
         * Optional. The image to display.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.v2.Intent.Message.Image image = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The image.
         */
        @java.lang.Override
        public com.google.cloud.dialogflow.v2.Intent.Message.Image getImage() {
          return image_ == null
              ? com.google.cloud.dialogflow.v2.Intent.Message.Image.getDefaultInstance()
              : image_;
        }
        /**
         *
         *
         * <pre>
         * Optional. The image to display.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.v2.Intent.Message.Image image = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        @java.lang.Override
        public com.google.cloud.dialogflow.v2.Intent.Message.ImageOrBuilder getImageOrBuilder() {
          return getImage();
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          if (info_ != null) {
            output.writeMessage(1, getInfo());
          }
          if (!getTitleBytes().isEmpty()) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 2, title_);
          }
          if (!getDescriptionBytes().isEmpty()) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 3, description_);
          }
          if (image_ != null) {
            output.writeMessage(4, getImage());
          }
          unknownFields.writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (info_ != null) {
            size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getInfo());
          }
          if (!getTitleBytes().isEmpty()) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, title_);
          }
          if (!getDescriptionBytes().isEmpty()) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, description_);
          }
          if (image_ != null) {
            size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getImage());
          }
          size += unknownFields.getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj instanceof com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item)) {
            return super.equals(obj);
          }
          com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item other =
              (com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item) obj;

          if (hasInfo() != other.hasInfo()) return false;
          if (hasInfo()) {
            if (!getInfo().equals(other.getInfo())) return false;
          }
          if (!getTitle().equals(other.getTitle())) return false;
          if (!getDescription().equals(other.getDescription())) return false;
          if (hasImage() != other.hasImage()) return false;
          if (hasImage()) {
            if (!getImage().equals(other.getImage())) return false;
          }
          if (!unknownFields.equals(other.unknownFields)) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          if (hasInfo()) {
            hash = (37 * hash) + INFO_FIELD_NUMBER;
            hash = (53 * hash) + getInfo().hashCode();
          }
          hash = (37 * hash) + TITLE_FIELD_NUMBER;
          hash = (53 * hash) + getTitle().hashCode();
          hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
          hash = (53 * hash) + getDescription().hashCode();
          if (hasImage()) {
            hash = (37 * hash) + IMAGE_FIELD_NUMBER;
            hash = (53 * hash) + getImage().hashCode();
          }
          hash = (29 * hash) + unknownFields.hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item parseFrom(
            java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item parseFrom(
            com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item parseFrom(
            byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item parseFrom(
            byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item parseFrom(
            java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item parseFrom(
            com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * An item in the carousel.
         * </pre>
         *
         * Protobuf type {@code google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item)
            com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.ItemOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.dialogflow.v2.IntentProto
                .internal_static_google_cloud_dialogflow_v2_Intent_Message_CarouselSelect_Item_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.dialogflow.v2.IntentProto
                .internal_static_google_cloud_dialogflow_v2_Intent_Message_CarouselSelect_Item_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item.class,
                    com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item.Builder
                        .class);
          }

          // Construct using
          // com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item.newBuilder()
          private Builder() {
            maybeForceBuilderInitialization();
          }

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            maybeForceBuilderInitialization();
          }

          private void maybeForceBuilderInitialization() {
            if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            if (infoBuilder_ == null) {
              info_ = null;
            } else {
              info_ = null;
              infoBuilder_ = null;
            }
            title_ = "";

            description_ = "";

            if (imageBuilder_ == null) {
              image_ = null;
            } else {
              image_ = null;
              imageBuilder_ = null;
            }
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.cloud.dialogflow.v2.IntentProto
                .internal_static_google_cloud_dialogflow_v2_Intent_Message_CarouselSelect_Item_descriptor;
          }

          @java.lang.Override
          public com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item
              getDefaultInstanceForType() {
            return com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item
                .getDefaultInstance();
          }

          @java.lang.Override
          public com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item build() {
            com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item result =
                buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item buildPartial() {
            com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item result =
                new com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item(this);
            if (infoBuilder_ == null) {
              result.info_ = info_;
            } else {
              result.info_ = infoBuilder_.build();
            }
            result.title_ = title_;
            result.description_ = description_;
            if (imageBuilder_ == null) {
              result.image_ = image_;
            } else {
              result.image_ = imageBuilder_.build();
            }
            onBuilt();
            return result;
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other
                instanceof com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item) {
              return mergeFrom(
                  (com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item) other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item other) {
            if (other
                == com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item
                    .getDefaultInstance()) return this;
            if (other.hasInfo()) {
              mergeInfo(other.getInfo());
            }
            if (!other.getTitle().isEmpty()) {
              title_ = other.title_;
              onChanged();
            }
            if (!other.getDescription().isEmpty()) {
              description_ = other.description_;
              onChanged();
            }
            if (other.hasImage()) {
              mergeImage(other.getImage());
            }
            this.mergeUnknownFields(other.unknownFields);
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item parsedMessage = null;
            try {
              parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              parsedMessage =
                  (com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item)
                      e.getUnfinishedMessage();
              throw e.unwrapIOException();
            } finally {
              if (parsedMessage != null) {
                mergeFrom(parsedMessage);
              }
            }
            return this;
          }

          private com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo info_;
          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo,
                  com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo.Builder,
                  com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfoOrBuilder>
              infoBuilder_;
          /**
           *
           *
           * <pre>
           * Required. Additional info about the option item.
           * </pre>
           *
           * <code>
           * .google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo info = 1 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           *
           * @return Whether the info field is set.
           */
          public boolean hasInfo() {
            return infoBuilder_ != null || info_ != null;
          }
          /**
           *
           *
           * <pre>
           * Required. Additional info about the option item.
           * </pre>
           *
           * <code>
           * .google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo info = 1 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           *
           * @return The info.
           */
          public com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo getInfo() {
            if (infoBuilder_ == null) {
              return info_ == null
                  ? com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo
                      .getDefaultInstance()
                  : info_;
            } else {
              return infoBuilder_.getMessage();
            }
          }
          /**
           *
           *
           * <pre>
           * Required. Additional info about the option item.
           * </pre>
           *
           * <code>
           * .google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo info = 1 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           */
          public Builder setInfo(
              com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo value) {
            if (infoBuilder_ == null) {
              if (value == null) {
                throw new NullPointerException();
              }
              info_ = value;
              onChanged();
            } else {
              infoBuilder_.setMessage(value);
            }

            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. Additional info about the option item.
           * </pre>
           *
           * <code>
           * .google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo info = 1 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           */
          public Builder setInfo(
              com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo.Builder
                  builderForValue) {
            if (infoBuilder_ == null) {
              info_ = builderForValue.build();
              onChanged();
            } else {
              infoBuilder_.setMessage(builderForValue.build());
            }

            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. Additional info about the option item.
           * </pre>
           *
           * <code>
           * .google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo info = 1 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           */
          public Builder mergeInfo(
              com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo value) {
            if (infoBuilder_ == null) {
              if (info_ != null) {
                info_ =
                    com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo.newBuilder(info_)
                        .mergeFrom(value)
                        .buildPartial();
              } else {
                info_ = value;
              }
              onChanged();
            } else {
              infoBuilder_.mergeFrom(value);
            }

            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. Additional info about the option item.
           * </pre>
           *
           * <code>
           * .google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo info = 1 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           */
          public Builder clearInfo() {
            if (infoBuilder_ == null) {
              info_ = null;
              onChanged();
            } else {
              info_ = null;
              infoBuilder_ = null;
            }

            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. Additional info about the option item.
           * </pre>
           *
           * <code>
           * .google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo info = 1 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           */
          public com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo.Builder
              getInfoBuilder() {

            onChanged();
            return getInfoFieldBuilder().getBuilder();
          }
          /**
           *
           *
           * <pre>
           * Required. Additional info about the option item.
           * </pre>
           *
           * <code>
           * .google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo info = 1 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           */
          public com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfoOrBuilder
              getInfoOrBuilder() {
            if (infoBuilder_ != null) {
              return infoBuilder_.getMessageOrBuilder();
            } else {
              return info_ == null
                  ? com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo
                      .getDefaultInstance()
                  : info_;
            }
          }
          /**
           *
           *
           * <pre>
           * Required. Additional info about the option item.
           * </pre>
           *
           * <code>
           * .google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo info = 1 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           */
          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo,
                  com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo.Builder,
                  com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfoOrBuilder>
              getInfoFieldBuilder() {
            if (infoBuilder_ == null) {
              infoBuilder_ =
                  new com.google.protobuf.SingleFieldBuilderV3<
                      com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo,
                      com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo.Builder,
                      com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfoOrBuilder>(
                      getInfo(), getParentForChildren(), isClean());
              info_ = null;
            }
            return infoBuilder_;
          }

          private java.lang.Object title_ = "";
          /**
           *
           *
           * <pre>
           * Required. Title of the carousel item.
           * </pre>
           *
           * <code>string title = 2 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return The title.
           */
          public java.lang.String getTitle() {
            java.lang.Object ref = title_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              title_ = s;
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Required. Title of the carousel item.
           * </pre>
           *
           * <code>string title = 2 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return The bytes for title.
           */
          public com.google.protobuf.ByteString getTitleBytes() {
            java.lang.Object ref = title_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              title_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Required. Title of the carousel item.
           * </pre>
           *
           * <code>string title = 2 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param value The title to set.
           * @return This builder for chaining.
           */
          public Builder setTitle(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }

            title_ = value;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. Title of the carousel item.
           * </pre>
           *
           * <code>string title = 2 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearTitle() {

            title_ = getDefaultInstance().getTitle();
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. Title of the carousel item.
           * </pre>
           *
           * <code>string title = 2 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param value The bytes for title to set.
           * @return This builder for chaining.
           */
          public Builder setTitleBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);

            title_ = value;
            onChanged();
            return this;
          }

          private java.lang.Object description_ = "";
          /**
           *
           *
           * <pre>
           * Optional. The body text of the card.
           * </pre>
           *
           * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
           *
           * @return The description.
           */
          public java.lang.String getDescription() {
            java.lang.Object ref = description_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              description_ = s;
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Optional. The body text of the card.
           * </pre>
           *
           * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
           *
           * @return The bytes for description.
           */
          public com.google.protobuf.ByteString getDescriptionBytes() {
            java.lang.Object ref = description_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              description_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Optional. The body text of the card.
           * </pre>
           *
           * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
           *
           * @param value The description to set.
           * @return This builder for chaining.
           */
          public Builder setDescription(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }

            description_ = value;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Optional. The body text of the card.
           * </pre>
           *
           * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearDescription() {

            description_ = getDefaultInstance().getDescription();
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Optional. The body text of the card.
           * </pre>
           *
           * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
           *
           * @param value The bytes for description to set.
           * @return This builder for chaining.
           */
          public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);

            description_ = value;
            onChanged();
            return this;
          }

          private com.google.cloud.dialogflow.v2.Intent.Message.Image image_;
          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.dialogflow.v2.Intent.Message.Image,
                  com.google.cloud.dialogflow.v2.Intent.Message.Image.Builder,
                  com.google.cloud.dialogflow.v2.Intent.Message.ImageOrBuilder>
              imageBuilder_;
          /**
           *
           *
           * <pre>
           * Optional. The image to display.
           * </pre>
           *
           * <code>
           * .google.cloud.dialogflow.v2.Intent.Message.Image image = 4 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           *
           * @return Whether the image field is set.
           */
          public boolean hasImage() {
            return imageBuilder_ != null || image_ != null;
          }
          /**
           *
           *
           * <pre>
           * Optional. The image to display.
           * </pre>
           *
           * <code>
           * .google.cloud.dialogflow.v2.Intent.Message.Image image = 4 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           *
           * @return The image.
           */
          public com.google.cloud.dialogflow.v2.Intent.Message.Image getImage() {
            if (imageBuilder_ == null) {
              return image_ == null
                  ? com.google.cloud.dialogflow.v2.Intent.Message.Image.getDefaultInstance()
                  : image_;
            } else {
              return imageBuilder_.getMessage();
            }
          }
          /**
           *
           *
           * <pre>
           * Optional. The image to display.
           * </pre>
           *
           * <code>
           * .google.cloud.dialogflow.v2.Intent.Message.Image image = 4 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           */
          public Builder setImage(com.google.cloud.dialogflow.v2.Intent.Message.Image value) {
            if (imageBuilder_ == null) {
              if (value == null) {
                throw new NullPointerException();
              }
              image_ = value;
              onChanged();
            } else {
              imageBuilder_.setMessage(value);
            }

            return this;
          }
          /**
           *
           *
           * <pre>
           * Optional. The image to display.
           * </pre>
           *
           * <code>
           * .google.cloud.dialogflow.v2.Intent.Message.Image image = 4 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           */
          public Builder setImage(
              com.google.cloud.dialogflow.v2.Intent.Message.Image.Builder builderForValue) {
            if (imageBuilder_ == null) {
              image_ = builderForValue.build();
              onChanged();
            } else {
              imageBuilder_.setMessage(builderForValue.build());
            }

            return this;
          }
          /**
           *
           *
           * <pre>
           * Optional. The image to display.
           * </pre>
           *
           * <code>
           * .google.cloud.dialogflow.v2.Intent.Message.Image image = 4 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           */
          public Builder mergeImage(com.google.cloud.dialogflow.v2.Intent.Message.Image value) {
            if (imageBuilder_ == null) {
              if (image_ != null) {
                image_ =
                    com.google.cloud.dialogflow.v2.Intent.Message.Image.newBuilder(image_)
                        .mergeFrom(value)
                        .buildPartial();
              } else {
                image_ = value;
              }
              onChanged();
            } else {
              imageBuilder_.mergeFrom(value);
            }

            return this;
          }
          /**
           *
           *
           * <pre>
           * Optional. The image to display.
           * </pre>
           *
           * <code>
           * .google.cloud.dialogflow.v2.Intent.Message.Image image = 4 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           */
          public Builder clearImage() {
            if (imageBuilder_ == null) {
              image_ = null;
              onChanged();
            } else {
              image_ = null;
              imageBuilder_ = null;
            }

            return this;
          }
          /**
           *
           *
           * <pre>
           * Optional. The image to display.
           * </pre>
           *
           * <code>
           * .google.cloud.dialogflow.v2.Intent.Message.Image image = 4 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           */
          public com.google.cloud.dialogflow.v2.Intent.Message.Image.Builder getImageBuilder() {

            onChanged();
            return getImageFieldBuilder().getBuilder();
          }
          /**
           *
           *
           * <pre>
           * Optional. The image to display.
           * </pre>
           *
           * <code>
           * .google.cloud.dialogflow.v2.Intent.Message.Image image = 4 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           */
          public com.google.cloud.dialogflow.v2.Intent.Message.ImageOrBuilder getImageOrBuilder() {
            if (imageBuilder_ != null) {
              return imageBuilder_.getMessageOrBuilder();
            } else {
              return image_ == null
                  ? com.google.cloud.dialogflow.v2.Intent.Message.Image.getDefaultInstance()
                  : image_;
            }
          }
          /**
           *
           *
           * <pre>
           * Optional. The image to display.
           * </pre>
           *
           * <code>
           * .google.cloud.dialogflow.v2.Intent.Message.Image image = 4 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           */
          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.dialogflow.v2.Intent.Message.Image,
                  com.google.cloud.dialogflow.v2.Intent.Message.Image.Builder,
                  com.google.cloud.dialogflow.v2.Intent.Message.ImageOrBuilder>
              getImageFieldBuilder() {
            if (imageBuilder_ == null) {
              imageBuilder_ =
                  new com.google.protobuf.SingleFieldBuilderV3<
                      com.google.cloud.dialogflow.v2.Intent.Message.Image,
                      com.google.cloud.dialogflow.v2.Intent.Message.Image.Builder,
                      com.google.cloud.dialogflow.v2.Intent.Message.ImageOrBuilder>(
                      getImage(), getParentForChildren(), isClean());
              image_ = null;
            }
            return imageBuilder_;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item)
        }

        // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item)
        private static final com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE =
              new com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item();
        }

        public static com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<Item> PARSER =
            new com.google.protobuf.AbstractParser<Item>() {
              @java.lang.Override
              public Item parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                return new Item(input, extensionRegistry);
              }
            };

        public static com.google.protobuf.Parser<Item> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<Item> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      public static final int ITEMS_FIELD_NUMBER = 1;
      private java.util.List<com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item>
          items_;
      /**
       *
       *
       * <pre>
       * Required. Carousel items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item items = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      @java.lang.Override
      public java.util.List<com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item>
          getItemsList() {
        return items_;
      }
      /**
       *
       *
       * <pre>
       * Required. Carousel items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item items = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              ? extends com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.ItemOrBuilder>
          getItemsOrBuilderList() {
        return items_;
      }
      /**
       *
       *
       * <pre>
       * Required. Carousel items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item items = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      @java.lang.Override
      public int getItemsCount() {
        return items_.size();
      }
      /**
       *
       *
       * <pre>
       * Required. Carousel items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item items = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item getItems(int index) {
        return items_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Required. Carousel items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item items = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.ItemOrBuilder
          getItemsOrBuilder(int index) {
        return items_.get(index);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        for (int i = 0; i < items_.size(); i++) {
          output.writeMessage(1, items_.get(i));
        }
        unknownFields.writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        for (int i = 0; i < items_.size(); i++) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, items_.get(i));
        }
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect)) {
          return super.equals(obj);
        }
        com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect other =
            (com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect) obj;

        if (!getItemsList().equals(other.getItemsList())) return false;
        if (!unknownFields.equals(other.unknownFields)) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (getItemsCount() > 0) {
          hash = (37 * hash) + ITEMS_FIELD_NUMBER;
          hash = (53 * hash) + getItemsList().hashCode();
        }
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect parseFrom(
          byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect parseDelimitedFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * The card for presenting a carousel of options to select from.
       * </pre>
       *
       * Protobuf type {@code google.cloud.dialogflow.v2.Intent.Message.CarouselSelect}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2.Intent.Message.CarouselSelect)
          com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelectOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.dialogflow.v2.IntentProto
              .internal_static_google_cloud_dialogflow_v2_Intent_Message_CarouselSelect_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.dialogflow.v2.IntentProto
              .internal_static_google_cloud_dialogflow_v2_Intent_Message_CarouselSelect_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.class,
                  com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Builder.class);
        }

        // Construct using com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
            getItemsFieldBuilder();
          }
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          if (itemsBuilder_ == null) {
            items_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            itemsBuilder_.clear();
          }
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.dialogflow.v2.IntentProto
              .internal_static_google_cloud_dialogflow_v2_Intent_Message_CarouselSelect_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect
            getDefaultInstanceForType() {
          return com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect build() {
          com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect buildPartial() {
          com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect result =
              new com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect(this);
          int from_bitField0_ = bitField0_;
          if (itemsBuilder_ == null) {
            if (((bitField0_ & 0x00000001) != 0)) {
              items_ = java.util.Collections.unmodifiableList(items_);
              bitField0_ = (bitField0_ & ~0x00000001);
            }
            result.items_ = items_;
          } else {
            result.items_ = itemsBuilder_.build();
          }
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect) {
            return mergeFrom((com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect other) {
          if (other
              == com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.getDefaultInstance())
            return this;
          if (itemsBuilder_ == null) {
            if (!other.items_.isEmpty()) {
              if (items_.isEmpty()) {
                items_ = other.items_;
                bitField0_ = (bitField0_ & ~0x00000001);
              } else {
                ensureItemsIsMutable();
                items_.addAll(other.items_);
              }
              onChanged();
            }
          } else {
            if (!other.items_.isEmpty()) {
              if (itemsBuilder_.isEmpty()) {
                itemsBuilder_.dispose();
                itemsBuilder_ = null;
                items_ = other.items_;
                bitField0_ = (bitField0_ & ~0x00000001);
                itemsBuilder_ =
                    com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                        ? getItemsFieldBuilder()
                        : null;
              } else {
                itemsBuilder_.addAllMessages(other.items_);
              }
            }
          }
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage =
                (com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect)
                    e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }

        private int bitField0_;

        private java.util.List<com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item>
            items_ = java.util.Collections.emptyList();

        private void ensureItemsIsMutable() {
          if (!((bitField0_ & 0x00000001) != 0)) {
            items_ =
                new java.util.ArrayList<
                    com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item>(items_);
            bitField0_ |= 0x00000001;
          }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item,
                com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item.Builder,
                com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.ItemOrBuilder>
            itemsBuilder_;

        /**
         *
         *
         * <pre>
         * Required. Carousel items.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item items = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public java.util.List<com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item>
            getItemsList() {
          if (itemsBuilder_ == null) {
            return java.util.Collections.unmodifiableList(items_);
          } else {
            return itemsBuilder_.getMessageList();
          }
        }
        /**
         *
         *
         * <pre>
         * Required. Carousel items.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item items = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public int getItemsCount() {
          if (itemsBuilder_ == null) {
            return items_.size();
          } else {
            return itemsBuilder_.getCount();
          }
        }
        /**
         *
         *
         * <pre>
         * Required. Carousel items.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item items = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item getItems(
            int index) {
          if (itemsBuilder_ == null) {
            return items_.get(index);
          } else {
            return itemsBuilder_.getMessage(index);
          }
        }
        /**
         *
         *
         * <pre>
         * Required. Carousel items.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item items = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder setItems(
            int index, com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item value) {
          if (itemsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureItemsIsMutable();
            items_.set(index, value);
            onChanged();
          } else {
            itemsBuilder_.setMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Carousel items.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item items = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder setItems(
            int index,
            com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item.Builder
                builderForValue) {
          if (itemsBuilder_ == null) {
            ensureItemsIsMutable();
            items_.set(index, builderForValue.build());
            onChanged();
          } else {
            itemsBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Carousel items.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item items = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder addItems(
            com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item value) {
          if (itemsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureItemsIsMutable();
            items_.add(value);
            onChanged();
          } else {
            itemsBuilder_.addMessage(value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Carousel items.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item items = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder addItems(
            int index, com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item value) {
          if (itemsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureItemsIsMutable();
            items_.add(index, value);
            onChanged();
          } else {
            itemsBuilder_.addMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Carousel items.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item items = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder addItems(
            com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item.Builder
                builderForValue) {
          if (itemsBuilder_ == null) {
            ensureItemsIsMutable();
            items_.add(builderForValue.build());
            onChanged();
          } else {
            itemsBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Carousel items.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item items = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder addItems(
            int index,
            com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item.Builder
                builderForValue) {
          if (itemsBuilder_ == null) {
            ensureItemsIsMutable();
            items_.add(index, builderForValue.build());
            onChanged();
          } else {
            itemsBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Carousel items.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item items = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder addAllItems(
            java.lang.Iterable<
                    ? extends com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item>
                values) {
          if (itemsBuilder_ == null) {
            ensureItemsIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, items_);
            onChanged();
          } else {
            itemsBuilder_.addAllMessages(values);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Carousel items.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item items = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder clearItems() {
          if (itemsBuilder_ == null) {
            items_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000001);
            onChanged();
          } else {
            itemsBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Carousel items.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item items = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder removeItems(int index) {
          if (itemsBuilder_ == null) {
            ensureItemsIsMutable();
            items_.remove(index);
            onChanged();
          } else {
            itemsBuilder_.remove(index);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Carousel items.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item items = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item.Builder
            getItemsBuilder(int index) {
          return getItemsFieldBuilder().getBuilder(index);
        }
        /**
         *
         *
         * <pre>
         * Required. Carousel items.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item items = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.ItemOrBuilder
            getItemsOrBuilder(int index) {
          if (itemsBuilder_ == null) {
            return items_.get(index);
          } else {
            return itemsBuilder_.getMessageOrBuilder(index);
          }
        }
        /**
         *
         *
         * <pre>
         * Required. Carousel items.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item items = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public java.util.List<
                ? extends
                    com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.ItemOrBuilder>
            getItemsOrBuilderList() {
          if (itemsBuilder_ != null) {
            return itemsBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(items_);
          }
        }
        /**
         *
         *
         * <pre>
         * Required. Carousel items.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item items = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item.Builder
            addItemsBuilder() {
          return getItemsFieldBuilder()
              .addBuilder(
                  com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item
                      .getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * Required. Carousel items.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item items = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item.Builder
            addItemsBuilder(int index) {
          return getItemsFieldBuilder()
              .addBuilder(
                  index,
                  com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item
                      .getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * Required. Carousel items.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item items = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public java.util.List<
                com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item.Builder>
            getItemsBuilderList() {
          return getItemsFieldBuilder().getBuilderList();
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item,
                com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item.Builder,
                com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.ItemOrBuilder>
            getItemsFieldBuilder() {
          if (itemsBuilder_ == null) {
            itemsBuilder_ =
                new com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item,
                    com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item.Builder,
                    com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.ItemOrBuilder>(
                    items_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
            items_ = null;
          }
          return itemsBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2.Intent.Message.CarouselSelect)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2.Intent.Message.CarouselSelect)
      private static final com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect();
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<CarouselSelect> PARSER =
          new com.google.protobuf.AbstractParser<CarouselSelect>() {
            @java.lang.Override
            public CarouselSelect parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              return new CarouselSelect(input, extensionRegistry);
            }
          };

      public static com.google.protobuf.Parser<CarouselSelect> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<CarouselSelect> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2.Intent.Message.CarouselSelect
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface SelectItemInfoOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Required. A unique key that will be sent back to the agent if this
       * response is given.
       * </pre>
       *
       * <code>string key = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The key.
       */
      java.lang.String getKey();
      /**
       *
       *
       * <pre>
       * Required. A unique key that will be sent back to the agent if this
       * response is given.
       * </pre>
       *
       * <code>string key = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for key.
       */
      com.google.protobuf.ByteString getKeyBytes();

      /**
       *
       *
       * <pre>
       * Optional. A list of synonyms that can also be used to trigger this
       * item in dialog.
       * </pre>
       *
       * <code>repeated string synonyms = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return A list containing the synonyms.
       */
      java.util.List<java.lang.String> getSynonymsList();
      /**
       *
       *
       * <pre>
       * Optional. A list of synonyms that can also be used to trigger this
       * item in dialog.
       * </pre>
       *
       * <code>repeated string synonyms = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The count of synonyms.
       */
      int getSynonymsCount();
      /**
       *
       *
       * <pre>
       * Optional. A list of synonyms that can also be used to trigger this
       * item in dialog.
       * </pre>
       *
       * <code>repeated string synonyms = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the element to return.
       * @return The synonyms at the given index.
       */
      java.lang.String getSynonyms(int index);
      /**
       *
       *
       * <pre>
       * Optional. A list of synonyms that can also be used to trigger this
       * item in dialog.
       * </pre>
       *
       * <code>repeated string synonyms = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the synonyms at the given index.
       */
      com.google.protobuf.ByteString getSynonymsBytes(int index);
    }
    /**
     *
     *
     * <pre>
     * Additional info about the select item for when it is triggered in a
     * dialog.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo}
     */
    public static final class SelectItemInfo extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo)
        SelectItemInfoOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use SelectItemInfo.newBuilder() to construct.
      private SelectItemInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private SelectItemInfo() {
        key_ = "";
        synonyms_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new SelectItemInfo();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
      }

      private SelectItemInfo(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        int mutable_bitField0_ = 0;
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();

                  key_ = s;
                  break;
                }
              case 18:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                    synonyms_ = new com.google.protobuf.LazyStringArrayList();
                    mutable_bitField0_ |= 0x00000001;
                  }
                  synonyms_.add(s);
                  break;
                }
              default:
                {
                  if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                    done = true;
                  }
                  break;
                }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(this);
        } finally {
          if (((mutable_bitField0_ & 0x00000001) != 0)) {
            synonyms_ = synonyms_.getUnmodifiableView();
          }
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.v2.IntentProto
            .internal_static_google_cloud_dialogflow_v2_Intent_Message_SelectItemInfo_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.v2.IntentProto
            .internal_static_google_cloud_dialogflow_v2_Intent_Message_SelectItemInfo_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo.class,
                com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo.Builder.class);
      }

      public static final int KEY_FIELD_NUMBER = 1;
      private volatile java.lang.Object key_;
      /**
       *
       *
       * <pre>
       * Required. A unique key that will be sent back to the agent if this
       * response is given.
       * </pre>
       *
       * <code>string key = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The key.
       */
      @java.lang.Override
      public java.lang.String getKey() {
        java.lang.Object ref = key_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          key_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. A unique key that will be sent back to the agent if this
       * response is given.
       * </pre>
       *
       * <code>string key = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for key.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getKeyBytes() {
        java.lang.Object ref = key_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          key_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int SYNONYMS_FIELD_NUMBER = 2;
      private com.google.protobuf.LazyStringList synonyms_;
      /**
       *
       *
       * <pre>
       * Optional. A list of synonyms that can also be used to trigger this
       * item in dialog.
       * </pre>
       *
       * <code>repeated string synonyms = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return A list containing the synonyms.
       */
      public com.google.protobuf.ProtocolStringList getSynonymsList() {
        return synonyms_;
      }
      /**
       *
       *
       * <pre>
       * Optional. A list of synonyms that can also be used to trigger this
       * item in dialog.
       * </pre>
       *
       * <code>repeated string synonyms = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The count of synonyms.
       */
      public int getSynonymsCount() {
        return synonyms_.size();
      }
      /**
       *
       *
       * <pre>
       * Optional. A list of synonyms that can also be used to trigger this
       * item in dialog.
       * </pre>
       *
       * <code>repeated string synonyms = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the element to return.
       * @return The synonyms at the given index.
       */
      public java.lang.String getSynonyms(int index) {
        return synonyms_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Optional. A list of synonyms that can also be used to trigger this
       * item in dialog.
       * </pre>
       *
       * <code>repeated string synonyms = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the synonyms at the given index.
       */
      public com.google.protobuf.ByteString getSynonymsBytes(int index) {
        return synonyms_.getByteString(index);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!getKeyBytes().isEmpty()) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, key_);
        }
        for (int i = 0; i < synonyms_.size(); i++) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 2, synonyms_.getRaw(i));
        }
        unknownFields.writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!getKeyBytes().isEmpty()) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, key_);
        }
        {
          int dataSize = 0;
          for (int i = 0; i < synonyms_.size(); i++) {
            dataSize += computeStringSizeNoTag(synonyms_.getRaw(i));
          }
          size += dataSize;
          size += 1 * getSynonymsList().size();
        }
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo)) {
          return super.equals(obj);
        }
        com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo other =
            (com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo) obj;

        if (!getKey().equals(other.getKey())) return false;
        if (!getSynonymsList().equals(other.getSynonymsList())) return false;
        if (!unknownFields.equals(other.unknownFields)) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + KEY_FIELD_NUMBER;
        hash = (53 * hash) + getKey().hashCode();
        if (getSynonymsCount() > 0) {
          hash = (37 * hash) + SYNONYMS_FIELD_NUMBER;
          hash = (53 * hash) + getSynonymsList().hashCode();
        }
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo parseFrom(
          byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo parseDelimitedFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Additional info about the select item for when it is triggered in a
       * dialog.
       * </pre>
       *
       * Protobuf type {@code google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo)
          com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfoOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.dialogflow.v2.IntentProto
              .internal_static_google_cloud_dialogflow_v2_Intent_Message_SelectItemInfo_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.dialogflow.v2.IntentProto
              .internal_static_google_cloud_dialogflow_v2_Intent_Message_SelectItemInfo_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo.class,
                  com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo.Builder.class);
        }

        // Construct using com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          key_ = "";

          synonyms_ = com.google.protobuf.LazyStringArrayList.EMPTY;
          bitField0_ = (bitField0_ & ~0x00000001);
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.dialogflow.v2.IntentProto
              .internal_static_google_cloud_dialogflow_v2_Intent_Message_SelectItemInfo_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo
            getDefaultInstanceForType() {
          return com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo build() {
          com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo buildPartial() {
          com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo result =
              new com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo(this);
          int from_bitField0_ = bitField0_;
          result.key_ = key_;
          if (((bitField0_ & 0x00000001) != 0)) {
            synonyms_ = synonyms_.getUnmodifiableView();
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.synonyms_ = synonyms_;
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo) {
            return mergeFrom((com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo other) {
          if (other
              == com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo.getDefaultInstance())
            return this;
          if (!other.getKey().isEmpty()) {
            key_ = other.key_;
            onChanged();
          }
          if (!other.synonyms_.isEmpty()) {
            if (synonyms_.isEmpty()) {
              synonyms_ = other.synonyms_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureSynonymsIsMutable();
              synonyms_.addAll(other.synonyms_);
            }
            onChanged();
          }
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage =
                (com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo)
                    e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }

        private int bitField0_;

        private java.lang.Object key_ = "";
        /**
         *
         *
         * <pre>
         * Required. A unique key that will be sent back to the agent if this
         * response is given.
         * </pre>
         *
         * <code>string key = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The key.
         */
        public java.lang.String getKey() {
          java.lang.Object ref = key_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            key_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. A unique key that will be sent back to the agent if this
         * response is given.
         * </pre>
         *
         * <code>string key = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for key.
         */
        public com.google.protobuf.ByteString getKeyBytes() {
          java.lang.Object ref = key_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            key_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. A unique key that will be sent back to the agent if this
         * response is given.
         * </pre>
         *
         * <code>string key = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The key to set.
         * @return This builder for chaining.
         */
        public Builder setKey(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }

          key_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. A unique key that will be sent back to the agent if this
         * response is given.
         * </pre>
         *
         * <code>string key = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearKey() {

          key_ = getDefaultInstance().getKey();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. A unique key that will be sent back to the agent if this
         * response is given.
         * </pre>
         *
         * <code>string key = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The bytes for key to set.
         * @return This builder for chaining.
         */
        public Builder setKeyBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);

          key_ = value;
          onChanged();
          return this;
        }

        private com.google.protobuf.LazyStringList synonyms_ =
            com.google.protobuf.LazyStringArrayList.EMPTY;

        private void ensureSynonymsIsMutable() {
          if (!((bitField0_ & 0x00000001) != 0)) {
            synonyms_ = new com.google.protobuf.LazyStringArrayList(synonyms_);
            bitField0_ |= 0x00000001;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. A list of synonyms that can also be used to trigger this
         * item in dialog.
         * </pre>
         *
         * <code>repeated string synonyms = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return A list containing the synonyms.
         */
        public com.google.protobuf.ProtocolStringList getSynonymsList() {
          return synonyms_.getUnmodifiableView();
        }
        /**
         *
         *
         * <pre>
         * Optional. A list of synonyms that can also be used to trigger this
         * item in dialog.
         * </pre>
         *
         * <code>repeated string synonyms = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The count of synonyms.
         */
        public int getSynonymsCount() {
          return synonyms_.size();
        }
        /**
         *
         *
         * <pre>
         * Optional. A list of synonyms that can also be used to trigger this
         * item in dialog.
         * </pre>
         *
         * <code>repeated string synonyms = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param index The index of the element to return.
         * @return The synonyms at the given index.
         */
        public java.lang.String getSynonyms(int index) {
          return synonyms_.get(index);
        }
        /**
         *
         *
         * <pre>
         * Optional. A list of synonyms that can also be used to trigger this
         * item in dialog.
         * </pre>
         *
         * <code>repeated string synonyms = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the synonyms at the given index.
         */
        public com.google.protobuf.ByteString getSynonymsBytes(int index) {
          return synonyms_.getByteString(index);
        }
        /**
         *
         *
         * <pre>
         * Optional. A list of synonyms that can also be used to trigger this
         * item in dialog.
         * </pre>
         *
         * <code>repeated string synonyms = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param index The index to set the value at.
         * @param value The synonyms to set.
         * @return This builder for chaining.
         */
        public Builder setSynonyms(int index, java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureSynonymsIsMutable();
          synonyms_.set(index, value);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. A list of synonyms that can also be used to trigger this
         * item in dialog.
         * </pre>
         *
         * <code>repeated string synonyms = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The synonyms to add.
         * @return This builder for chaining.
         */
        public Builder addSynonyms(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureSynonymsIsMutable();
          synonyms_.add(value);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. A list of synonyms that can also be used to trigger this
         * item in dialog.
         * </pre>
         *
         * <code>repeated string synonyms = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param values The synonyms to add.
         * @return This builder for chaining.
         */
        public Builder addAllSynonyms(java.lang.Iterable<java.lang.String> values) {
          ensureSynonymsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, synonyms_);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. A list of synonyms that can also be used to trigger this
         * item in dialog.
         * </pre>
         *
         * <code>repeated string synonyms = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearSynonyms() {
          synonyms_ = com.google.protobuf.LazyStringArrayList.EMPTY;
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. A list of synonyms that can also be used to trigger this
         * item in dialog.
         * </pre>
         *
         * <code>repeated string synonyms = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The bytes of the synonyms to add.
         * @return This builder for chaining.
         */
        public Builder addSynonymsBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          ensureSynonymsIsMutable();
          synonyms_.add(value);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo)
      private static final com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo();
      }

      public static com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<SelectItemInfo> PARSER =
          new com.google.protobuf.AbstractParser<SelectItemInfo>() {
            @java.lang.Override
            public SelectItemInfo parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              return new SelectItemInfo(input, extensionRegistry);
            }
          };

      public static com.google.protobuf.Parser<SelectItemInfo> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<SelectItemInfo> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface MediaContentOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.v2.Intent.Message.MediaContent)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Optional. What type of media is the content (ie "audio").
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2.Intent.Message.MediaContent.ResponseMediaType media_type = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The enum numeric value on the wire for mediaType.
       */
      int getMediaTypeValue();
      /**
       *
       *
       * <pre>
       * Optional. What type of media is the content (ie "audio").
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2.Intent.Message.MediaContent.ResponseMediaType media_type = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The mediaType.
       */
      com.google.cloud.dialogflow.v2.Intent.Message.MediaContent.ResponseMediaType getMediaType();

      /**
       *
       *
       * <pre>
       * Required. List of media objects.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.Message.MediaContent.ResponseMediaObject media_objects = 2;
       * </code>
       */
      java.util.List<com.google.cloud.dialogflow.v2.Intent.Message.MediaContent.ResponseMediaObject>
          getMediaObjectsList();
      /**
       *
       *
       * <pre>
       * Required. List of media objects.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.Message.MediaContent.ResponseMediaObject media_objects = 2;
       * </code>
       */
      com.google.cloud.dialogflow.v2.Intent.Message.MediaContent.ResponseMediaObject
          getMediaObjects(int index);
      /**
       *
       *
       * <pre>
       * Required. List of media objects.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.Message.MediaContent.ResponseMediaObject media_objects = 2;
       * </code>
       */
      int getMediaObjectsCount();
      /**
       *
       *
       * <pre>
       * Required. List of media objects.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.Message.MediaContent.ResponseMediaObject media_objects = 2;
       * </code>
       */
      java.util.List<
              ? extends
                  com.google.cloud.dialogflow.v2.Intent.Message.MediaContent
                      .ResponseMediaObjectOrBuilder>
          getMediaObjectsOrBuilderList();
      /**
       *
       *
       * <pre>
       * Required. List of media objects.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Intent.Message.MediaContent.ResponseMediaObject media_objects = 2;
       * </code>
       */
      com.google.cloud.dialogflow.v2.Intent.Message.MediaContent.ResponseMediaObjectOrBuilder
          getMediaObjectsOrBuilder(int index);
    }
    /**
     *
     *
     * <pre>
     * The media content card for Actions on Google.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.v2.Intent.Message.MediaContent}
     */
    public static final class MediaContent extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2.Intent.Message.MediaContent)
        MediaContentOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use MediaContent.newBuilder() to construct.
      private MediaContent(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private MediaContent() {
        mediaType_ = 0;
        mediaObjects_ = java.util.Collections.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new MediaContent();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
      }

      private MediaContent(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        int mutable_bitField0_ = 0;
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  int rawValue = input.readEnum();

                  mediaType_ = rawValue;
                  break;
                }
              case 18:
                {
                  if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                    mediaObjects_ =
                        new java.util.ArrayList<
                            com.google.cloud.dialogflow.v2.Intent.Message.MediaContent
                                .ResponseMediaObject>();
                    mutable_bitField0_ |= 0x00000001;
                  }
                  mediaObjects_.add(
                      input.readMessage(
                          com.google.cloud.dialogflow.v2.Intent.Message.MediaContent
                              .ResponseMediaObject.parser(),
                          extensionRegistry));
                  break;
                }
              default:
                {
                  if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                    done = true;
                  }
                  break;
                }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(this);
        } finally {
          if (((mutable_bitField0_ & 0x00000001) != 0)) {
            mediaObjects_ = java.util.Collections.unmodifiableList(mediaObjects_);
          }
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.v2.IntentProto
            .internal_static_google_cloud_dialogflow_v2_Intent_Message_MediaContent_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.v2.IntentProto
            .internal_static_google_cloud_dialogflow_v2_Intent_Message_MediaContent_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.v2.Intent.Message.MediaContent.class,
                com.google.cloud.dialogflow.v2.Intent.Message.MediaContent.Builder.class);
      }

      /**
       *
       *
       * <pre>
       * Format of response media type.
       * </pre>
       *
       * Protobuf enum {@code
       * google.cloud.dialogflow.v2.Intent.Message.MediaContent.ResponseMediaType}
       */
      public enum ResponseMediaType implements com.google.protobuf.ProtocolMessageEnum {
        /**
         *
         *
         * <pre>
         * Unspecified.
         * </pre>
         *
         * <code>RESPONSE_MEDIA_TYPE_UNSPECIFIED = 0;</code>
         */
        RESPONSE_MEDIA_TYPE_UNSPECIFIED(0),
        /**
         *
         *
         * <pre>
         * Response media type is audio.
         * </pre>
         *
         * <code>AUDIO = 1;</code>
         */
        AUDIO(1),
        UNRECOGNIZED(-1),
        ;

        /**
         *
         *
         * <pre>
         * Unspecified.
         * </pre>
         *
         * <code>RESPONSE_MEDIA_TYPE_UNSPECIFIED = 0;</code>
         */
        public static final int RESPONSE_MEDIA_TYPE_UNSPECIFIED_VALUE = 0;
        /**
         *
         *
         * <pre>
         * Response media type is audio.
         * </pre>
         *
         * <code>AUDIO = 1;</code>
         */
        public static final int AUDIO_VALUE = 1;

        public final int getNumber() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalArgumentException(
                "Can't get the number of an unknown enum value.");
          }
          return value;
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static ResponseMediaType valueOf(int value) {
          return forNumber(value);
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         */
        public static ResponseMediaType forNumber(int value) {
          switch (value) {
            case 0:
              return RESPONSE_MEDIA_TYPE_UNSPECIFIED;
            case 1:
              return AUDIO;
            default:
              return null;
          }
        }

        public static com.google.protobuf.Internal.EnumLiteMap<ResponseMediaType>
            internalGetValueMap() {
          return internalValueMap;
        }

        private static final com.google.protobuf.Internal.EnumLiteMap<ResponseMediaType>
            internalValueMap =
                new com.google.protobuf.Internal.EnumLiteMap<ResponseMediaType>() {
                  public ResponseMediaType findValueByNumber(int number) {
                    return ResponseMediaType.forNumber(number);
                  }
                };

        public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalStateException(
                "Can't get the descriptor of an unrecognized enum value.");
          }
          return getDescriptor().getValues().get(ordinal());
        }

        public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
          return getDescriptor();
        }

        public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
          return com.google.cloud.dialogflow.v2.Intent.Message.MediaContent.getDescriptor()
              .getEnumTypes()
              .get(0);
        }

        private static final ResponseMediaType[] VALUES = values();

        public static ResponseMediaType valueOf(
            com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
          if (desc.getType() != getDescriptor()) {
            throw new java.lang.IllegalArgumentException(
                "EnumValueDescriptor is not for this type.");
          }
          if (desc.getIndex() == -1) {
            return UNRECOGNIZED;
          }
          return VALUES[desc.getIndex()];
        }

        private final int value;

        private ResponseMediaType(int value) {
          this.value = value;
        }

        // @@protoc_insertion_point(enum_scope:google.cloud.dialogflow.v2.Intent.Message.MediaContent.ResponseMediaType)
      }

      public interface ResponseMediaObjectOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.v2.Intent.Message.MediaContent.ResponseMediaObject)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * Required. Name of media card.
         * </pre>
         *
         * <code>string name = 1;</code>
         *
         * @return The name.
         */
        java.lang.String getName();
        /**
         *
         *
         * <pre>
         * Required. Name of media card.
         * </pre>
         *
         * <code>string name = 1;</code>
         *
         * @return The bytes for name.
         */
        com.google.protobuf.ByteString getNameBytes();

        /**
         *
         *
         * <pre>
         * Optional. Description of media card.
         * </pre>
         *
         * <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The description.
         */
        java.lang.String getDescription();
        /**
         *
         *
         * <pre>
         * Optional. Description of media card.
         * </pre>
         *
         * <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The bytes for description.
         */
        com.google.protobuf.ByteString getDescriptionBytes();

        /**
         *
         *
         * <pre>
         * Optional. Image to display above media content.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.v2.Intent.Message.Image large_image = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return Whether the largeImage field is set.
         */
        boolean hasLargeImage();
        /**
         *
         *
         * <pre>
         * Optional. Image to display above media content.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.v2.Intent.Message.Image large_image = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The largeImage.
         */
        com.google.cloud.dialogflow.v2.Intent.Message.Image getLargeImage();
        /**
         *
         *
         * <pre>
         * Optional. Image to display above media content.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.v2.Intent.Message.Image large_image = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        com.google.cloud.dialogflow.v2.Intent.Message.ImageOrBuilder getLargeImageOrBuilder();

        /**
         *
         *
         * <pre>
         * Optional. Icon to display above media content.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.v2.Intent.Message.Image icon = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return Whether the icon field is set.
         */
        boolean hasIcon();
        /**
         *
         *
         * <pre>
         * Optional. Icon to display above media content.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.v2.Intent.Message.Image icon = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The icon.
         */
        com.google.cloud.dialogflow.v2.Intent.Message.Image getIcon();
        /**
         *
         *
         * <pre>
         * Optional. Icon to display above media content.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.v2.Intent.Message.Image icon = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        com.google.cloud.dialogflow.v2.Intent.Message.ImageOrBuilder getIconOrBuilder();

        /**
         *
         *
         * <pre>
         * Required. Url where the media is stored.
         * </pre>
         *
         * <code>string content_url = 5;</code>
         *
         * @return The contentUrl.
         */
        java.lang.String getContentUrl();
        /**
         *
         *
         * <pre>
         * Required. Url where the media is stored.
         * </pre>
         *
         * <code>string content_url = 5;</code>
         *
         * @return The bytes for contentUrl.
         */
        com.google.protobuf.ByteString getContentUrlBytes();

        public com.google.cloud.dialogflow.v2.Intent.Message.MediaContent.ResponseMediaObject
                .ImageCase
            getImageCase();
      }
      /**
       *
       *
       * <pre>
       * Response media object for media content card.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.dialogflow.v2.Intent.Message.MediaContent.ResponseMediaObject}
       */
      public static final class ResponseMediaObject extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2.Intent.Message.MediaContent.ResponseMediaObject)
          ResponseMediaObjectOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use ResponseMediaObject.newBuilder() to construct.
        private ResponseMediaObject(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private ResponseMediaObject() {
          name_ = "";
          description_ = "";
          contentUrl_ = "";
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new ResponseMediaObject();
        }

        @java.lang.Override
        public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
          return this.unknownFields;
        }

        private ResponseMediaObject(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          this();
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          com.google.protobuf.UnknownFieldSet.Builder unknownFields =
              com.google.protobuf.UnknownFieldSet.newBuilder();
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    java.lang.String s = input.readStringRequireUtf8();

                    name_ = s;
                    break;
                  }
                case 18:
                  {
                    java.lang.String s = input.readStringRequireUtf8();

                    description_ = s;
                    break;
                  }
                case 26:
                  {
                    com.google.cloud.dialogflow.v2.Intent.Message.Image.Builder subBuilder = null;
                    if (imageCase_ == 3) {
                      subBuilder =
                          ((com.google.cloud.dialogflow.v2.Intent.Message.Image) image_)
                              .toBuilder();
                    }
                    image_ =
                        input.readMessage(
                            com.google.cloud.dialogflow.v2.Intent.Message.Image.parser(),
                            extensionRegistry);
                    if (subBuilder != null) {
                      subBuilder.mergeFrom(
                          (com.google.cloud.dialogflow.v2.Intent.Message.Image) image_);
                      image_ = subBuilder.buildPartial();
                    }
                    imageCase_ = 3;
                    break;
                  }
                case 34:
                  {
                    com.google.cloud.dialogflow.v2.Intent.Message.Image.Builder subBuilder = null;
                    if (imageCase_ == 4) {
                      subBuilder =
                          ((com.google.cloud.dialogflow.v2.Intent.Message.Image) image_)
                              .toBuilder();
                    }
                    image_ =
                        input.readMessage(
                            com.google.cloud.dialogflow.v2.Intent.Message.Image.parser(),
                            extensionRegistry);
                    if (subBuilder != null) {
                      subBuilder.mergeFrom(
                          (com.google.cloud.dialogflow.v2.Intent.Message.Image) image_);
                      image_ = subBuilder.buildPartial();
                    }
                    imageCase_ = 4;
                    break;
                  }
                case 42:
                  {
                    java.lang.String s = input.readStringRequireUtf8();

                    contentUrl_ = s;
                    break;
                  }
                default:
                  {
                    if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                      done = true;
                    }
                    break;
                  }
              }
            }
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(this);
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(this);
          } finally {
            this.unknownFields = unknownFields.build();
            makeExtensionsImmutable();
          }
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.dialogflow.v2.IntentProto
              .internal_static_google_cloud_dialogflow_v2_Intent_Message_MediaContent_ResponseMediaObject_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.dialogflow.v2.IntentProto
              .internal_static_google_cloud_dialogflow_v2_Intent_Message_MediaContent_ResponseMediaObject_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.dialogflow.v2.Intent.Message.MediaContent.ResponseMediaObject
                      .class,
                  com.google.cloud.dialogflow.v2.Intent.Message.MediaContent.ResponseMediaObject
                      .Builder.class);
        }

        private int imageCase_ = 0;
        private java.lang.Object image_;

        public enum ImageCase
            implements
                com.google.protobuf.Internal.EnumLite,
                com.google.protobuf.AbstractMessage.InternalOneOfEnum {
          LARGE_IMAGE(3),
          ICON(4),
          IMAGE_NOT_SET(0);
          private final int value;

          private ImageCase(int value) {
            this.value = value;
          }
          /**
           * @param value The number of the enum to look for.
           * @return The enum associated with the given number.
           * @deprecated Use {@link #forNumber(int)} instead.
           */
          @java.lang.Deprecated
          public static ImageCase valueOf(int value) {
            return forNumber(value);
          }

          public static ImageCase forNumber(int value) {
            switch (value) {
              case 3:
                return LARGE_IMAGE;
              case 4:
                return ICON;
              case 0:
                return IMAGE_NOT_SET;
              default:
                return null;
            }
          }

          public int getNumber() {
            return this.value;
          }
        };

        public ImageCase getImageCase() {
          return ImageCase.forNumber(imageCase_);
        }

        public static final int NAME_FIELD_NUMBER = 1;
        private volatile java.lang.Object name_;
        /**
         *
         *
         * <pre>
         * Required. Name of media card.
         * </pre>
         *
         * <code>string name = 1;</code>
         *
         * @return The name.
         */
        @java.lang.Override
        public java.lang.String getName() {
          java.lang.Object ref = name_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            name_ = s;
            return s;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. Name of media card.
         * </pre>
         *
         * <code>string name = 1;</code>
         *
         * @return The bytes for name.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getNameBytes() {
          java.lang.Object ref = name_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            name_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        public static final int DESCRIPTION_FIELD_NUMBER = 2;
        private volatile java.lang.Object description_;
        /**
         *
         *
         * <pre>
         * Optional. Description of media card.
         * </pre>
         *
         * <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The description.
         */
        @java.lang.Override
        public java.lang.String getDescription() {
          java.lang.Object ref = description_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            description_ = s;
            return s;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. Description of media card.
         * </pre>
         *
         * <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The bytes for description.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getDescriptionBytes() {
          java.lang.Object ref = description_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            description_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        public static final int LARGE_IMAGE_FIELD_NUMBER = 3;
        /**
         *
         *
         * <pre>
         * Optional. Image to display above media content.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.v2.Intent.Message.Image large_image = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return Whether the largeImage field is set.
         */
        @java.lang.Override
        public boolean hasLargeImage() {
          return imageCase_ == 3;
        }
        /**
         *
         *
         * <pre>
         * Optional. Image to display above media content.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.v2.Intent.Message.Image large_image = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The largeImage.
         */
        @java.lang.Override
        public com.google.cloud.dialogflow.v2.Intent.Message.Image getLargeImage() {
          if (imageCase_ == 3) {
            return (com.google.cloud.dialogflow.v2.Intent.Message.Image) image_;
          }
          return com.google.cloud.dialogflow.v2.Intent.Message.Image.getDefaultInstance();
        }
        /**
         *
         *
         * <pre>
         * Optional. Image to display above media content.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.v2.Intent.Message.Image large_image = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        @java.lang.Override
        public com.google.cloud.dialogflow.v2.Intent.Message.ImageOrBuilder
            getLargeImageOrBuilder() {
          if (imageCase_ == 3) {
            return (com.google.cloud.dialogflow.v2.Intent.Message.Image) image_;
          }
          return com.google.cloud.dialogflow.v2.Intent.Message.Image.getDefaultInstance();
        }

        public static final int ICON_FIELD_NUMBER = 4;
        /**
         *
         *
         * <pre>
         * Optional. Icon to display above media content.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.v2.Intent.Message.Image icon = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return Whether the icon field is set.
         */
        @java.lang.Override
        public boolean hasIcon() {
          return imageCase_ == 4;
        }
        /**
         *
         *
         * <pre>
         * Optional. Icon to display above media content.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.v2.Intent.Message.Image icon = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The icon.
         */
        @java.lang.Override
        public com.google.cloud.dialogflow.v2.Intent.Message.Image getIcon() {
          if (imageCase_ == 4) {
            return (com.google.cloud.dialogflow.v2.Intent.Message.Image) image_;
          }
          return com.google.cloud.dialogflow.v2.Intent.Message.Image.getDefaultInstance();
        }
        /**
         *
         *
         * <pre>
         * Optional. Icon to display above media content.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.v2.Intent.Message.Image icon = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        @java.lang.Override
        public com.google.cloud.dialogflow.v2.Intent.Message.ImageOrBuilder getIconOrBuilder() {
          if (imageCase_ == 4) {
            return (com.google.cloud.dialogflow.v2.Intent.Message.Image) image_;
          }
          return com.google.cloud.dialogflow.v2.Intent.Message.Image.getDefaultInstance();
        }

        public static final int CONTENT_URL_FIELD_NUMBER = 5;
        private volatile java.lang.Object contentUrl_;
        /**
         *
         *
         * <pre>
         * Required. Url where the media is stored.
         * </pre>
         *
         * <code>string content_url = 5;</code>
         *
         * @return The contentUrl.
         */
        @java.lang.Override
        public java.lang.String getContentUrl() {
          java.lang.Object ref = contentUrl_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            contentUrl_ = s;
            return s;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. Url where the media is stored.
         * </pre>
         *
         * <code>string content_url = 5;</code>
         *
         * @return The bytes for contentUrl.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getContentUrlBytes() {
          java.lang.Object ref = contentUrl_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            contentUrl_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          if (!getNameBytes().isEmpty()) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
          }
          if (!getDescriptionBytes().isEmpty()) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 2, description_);
          }
          if (imageCase_ == 3) {
            output.writeMessage(3, (com.google.cloud.dialogflow.v2.Intent.Message.Image) image_);
          }
          if (imageCase_ == 4) {
            output.writeMessage(4, (com.google.cloud.dialogflow.v2.Intent.Message.Image) image_);
          }
          if (!getContentUrlBytes().isEmpty()) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 5, contentUrl_);
          }
          unknownFields.writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (!getNameBytes().isEmpty()) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
          }
          if (!getDescriptionBytes().isEmpty()) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, description_);
          }
          if (imageCase_ == 3) {
            size +=
                com.google.protobuf.CodedOutputStream.computeMessageSize(
                    3, (com.google.cloud.dialogflow.v2.Intent.Message.Image) image_);
          }
          if (imageCase_ == 4) {
            size +=
                com.google.protobuf.CodedOutputStream.computeMessageSize(
                    4, (com.google.cloud.dialogflow.v2.Intent.Message.Image) image_);
          }
          if (!getContentUrlBytes().isEmpty()) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, contentUrl_);
          }
          size += unknownFields.getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj
              instanceof
              com.google.cloud.dialogflow.v2.Intent.Message.MediaContent.ResponseMediaObject)) {
            return super.equals(obj);
          }
          com.google.cloud.dialogflow.v2.Intent.Message.MediaContent.ResponseMediaObject other =
              (com.google.cloud.dialogflow.v2.Intent.Message.MediaContent.ResponseMediaObject) obj;

          if (!getName().equals(other.getName())) return false;
          if (!getDescription().equals(other.getDescription())) return false;
          if (!getContentUrl().equals(other.getContentUrl())) return false;
          if (!getImageCase().equals(other.getImageCase())) return false;
          switch (imageCase_) {
            case 3:
              if (!getLargeImage().equals(other.getLargeImage())) return false;
              break;
            case 4:
              if (!getIcon().equals(other.getIcon())) return false;
              break;
            case 0:
            default:
          }
          if (!unknownFields.equals(other.unknownFields)) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          hash = (37 * hash) + NAME_FIELD_NUMBER;
          hash = (53 * hash) + getName().hashCode();
          hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
          hash = (53 * hash) + getDescription().hashCode();
          hash = (37 * hash) + CONTENT_URL_FIELD_NUMBER;
          hash = (53 * hash) + getContentUrl().hashCode();
          switch (imageCase_) {
            case 3:
              hash = (37 * hash) + LARGE_IMAGE_FIELD_NUMBER;
              hash = (53 * hash) + getLargeImage().hashCode();
              break;
            case 4:
              hash = (37 * hash) + ICON_FIELD_NUMBER;
              hash = (53 * hash) + getIcon().hashCode();
              break;
            case 0:
            default:
          }
          hash = (29 * hash) + unknownFields.hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.cloud.dialogflow.v2.Intent.Message.MediaContent.ResponseMediaObject
            parseFrom(java.nio.ByteBuffer data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.dialogflow.v2.Intent.Message.MediaContent.ResponseMediaObject
            parseFrom(
                java.nio.ByteBuffer data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.dialogflow.v2.Intent.Message.MediaContent.ResponseMediaObject
            parseFrom(com.google.protobuf.ByteString data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.dialogflow.v2.Intent.Message.MediaContent.ResponseMediaObject
            parseFrom(
                com.google.protobuf.ByteString data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.dialogflow.v2.Intent.Message.MediaContent.ResponseMediaObject
            parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.dialogflow.v2.Intent.Message.MediaContent.ResponseMediaObject
            parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.dialogflow.v2.Intent.Message.MediaContent.ResponseMediaObject
            parseFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.dialogflow.v2.Intent.Message.MediaContent.ResponseMediaObject
            parseFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.dialogflow.v2.Intent.Message.MediaContent.ResponseMediaObject
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.cloud.dialogflow.v2.Intent.Message.MediaContent.ResponseMediaObject
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMes