/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class EntityTypeName
implements ResourceName {
    private static final PathTemplate PROJECT_ENTITY_TYPE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/agent/entityTypes/{entity_type}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String entityType;

    @Deprecated
    protected EntityTypeName() {
        this.project = null;
        this.entityType = null;
    }

    private EntityTypeName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.entityType = (String)Preconditions.checkNotNull((Object)builder.getEntityType());
    }

    public String getProject() {
        return this.project;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static EntityTypeName of(String project, String entityType) {
        return EntityTypeName.newBuilder().setProject(project).setEntityType(entityType).build();
    }

    public static String format(String project, String entityType) {
        return EntityTypeName.newBuilder().setProject(project).setEntityType(entityType).build().toString();
    }

    public static EntityTypeName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_ENTITY_TYPE.validatedMatch(formattedString, "EntityTypeName.parse: formattedString not in valid format");
        return EntityTypeName.of((String)matchMap.get("project"), (String)matchMap.get("entity_type"));
    }

    public static List<EntityTypeName> parseList(List<String> formattedStrings) {
        ArrayList<EntityTypeName> list = new ArrayList<EntityTypeName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(EntityTypeName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<EntityTypeName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (EntityTypeName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_ENTITY_TYPE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            EntityTypeName entityTypeName = this;
            synchronized (entityTypeName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.entityType != null) {
                        fieldMapBuilder.put((Object)"entity_type", (Object)this.entityType);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_ENTITY_TYPE.instantiate(new String[]{"project", this.project, "entity_type", this.entityType});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            EntityTypeName that = (EntityTypeName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.entityType, that.entityType);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        return h ^= Objects.hashCode(this.entityType);
    }

    public static class Builder {
        private String project;
        private String entityType;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getEntityType() {
            return this.entityType;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setEntityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        private Builder(EntityTypeName entityTypeName) {
            this.project = entityTypeName.project;
            this.entityType = entityTypeName.entityType;
        }

        public EntityTypeName build() {
            return new EntityTypeName(this);
        }
    }
}

