/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/v2/answer_record.proto

package com.google.cloud.dialogflow.v2;

/**
 *
 *
 * <pre>
 * Detail feedback of Agent Assist result.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.v2.AgentAssistantFeedback}
 */
public final class AgentAssistantFeedback extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2.AgentAssistantFeedback)
    AgentAssistantFeedbackOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AgentAssistantFeedback.newBuilder() to construct.
  private AgentAssistantFeedback(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AgentAssistantFeedback() {
    answerRelevance_ = 0;
    documentCorrectness_ = 0;
    documentEfficiency_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AgentAssistantFeedback();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private AgentAssistantFeedback(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 8:
            {
              int rawValue = input.readEnum();

              answerRelevance_ = rawValue;
              break;
            }
          case 16:
            {
              int rawValue = input.readEnum();

              documentCorrectness_ = rawValue;
              break;
            }
          case 24:
            {
              int rawValue = input.readEnum();

              documentEfficiency_ = rawValue;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.v2.AnswerRecordsProto
        .internal_static_google_cloud_dialogflow_v2_AgentAssistantFeedback_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.v2.AnswerRecordsProto
        .internal_static_google_cloud_dialogflow_v2_AgentAssistantFeedback_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.v2.AgentAssistantFeedback.class,
            com.google.cloud.dialogflow.v2.AgentAssistantFeedback.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Relevance of an answer.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.dialogflow.v2.AgentAssistantFeedback.AnswerRelevance}
   */
  public enum AnswerRelevance implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Answer relevance unspecified.
     * </pre>
     *
     * <code>ANSWER_RELEVANCE_UNSPECIFIED = 0;</code>
     */
    ANSWER_RELEVANCE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Answer is irrelevant to query.
     * </pre>
     *
     * <code>IRRELEVANT = 1;</code>
     */
    IRRELEVANT(1),
    /**
     *
     *
     * <pre>
     * Answer is relevant to query.
     * </pre>
     *
     * <code>RELEVANT = 2;</code>
     */
    RELEVANT(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Answer relevance unspecified.
     * </pre>
     *
     * <code>ANSWER_RELEVANCE_UNSPECIFIED = 0;</code>
     */
    public static final int ANSWER_RELEVANCE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Answer is irrelevant to query.
     * </pre>
     *
     * <code>IRRELEVANT = 1;</code>
     */
    public static final int IRRELEVANT_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Answer is relevant to query.
     * </pre>
     *
     * <code>RELEVANT = 2;</code>
     */
    public static final int RELEVANT_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static AnswerRelevance valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static AnswerRelevance forNumber(int value) {
      switch (value) {
        case 0:
          return ANSWER_RELEVANCE_UNSPECIFIED;
        case 1:
          return IRRELEVANT;
        case 2:
          return RELEVANT;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<AnswerRelevance> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<AnswerRelevance>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<AnswerRelevance>() {
              public AnswerRelevance findValueByNumber(int number) {
                return AnswerRelevance.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2.AgentAssistantFeedback.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final AnswerRelevance[] VALUES = values();

    public static AnswerRelevance valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private AnswerRelevance(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.dialogflow.v2.AgentAssistantFeedback.AnswerRelevance)
  }

  /**
   *
   *
   * <pre>
   * Correctness of document.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.dialogflow.v2.AgentAssistantFeedback.DocumentCorrectness}
   */
  public enum DocumentCorrectness implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Document correctness unspecified.
     * </pre>
     *
     * <code>DOCUMENT_CORRECTNESS_UNSPECIFIED = 0;</code>
     */
    DOCUMENT_CORRECTNESS_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Information in document is incorrect.
     * </pre>
     *
     * <code>INCORRECT = 1;</code>
     */
    INCORRECT(1),
    /**
     *
     *
     * <pre>
     * Information in document is correct.
     * </pre>
     *
     * <code>CORRECT = 2;</code>
     */
    CORRECT(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Document correctness unspecified.
     * </pre>
     *
     * <code>DOCUMENT_CORRECTNESS_UNSPECIFIED = 0;</code>
     */
    public static final int DOCUMENT_CORRECTNESS_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Information in document is incorrect.
     * </pre>
     *
     * <code>INCORRECT = 1;</code>
     */
    public static final int INCORRECT_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Information in document is correct.
     * </pre>
     *
     * <code>CORRECT = 2;</code>
     */
    public static final int CORRECT_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DocumentCorrectness valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static DocumentCorrectness forNumber(int value) {
      switch (value) {
        case 0:
          return DOCUMENT_CORRECTNESS_UNSPECIFIED;
        case 1:
          return INCORRECT;
        case 2:
          return CORRECT;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<DocumentCorrectness>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<DocumentCorrectness>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<DocumentCorrectness>() {
              public DocumentCorrectness findValueByNumber(int number) {
                return DocumentCorrectness.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2.AgentAssistantFeedback.getDescriptor()
          .getEnumTypes()
          .get(1);
    }

    private static final DocumentCorrectness[] VALUES = values();

    public static DocumentCorrectness valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private DocumentCorrectness(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.dialogflow.v2.AgentAssistantFeedback.DocumentCorrectness)
  }

  /**
   *
   *
   * <pre>
   * Efficiency of document.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.dialogflow.v2.AgentAssistantFeedback.DocumentEfficiency}
   */
  public enum DocumentEfficiency implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Document efficiency unspecified.
     * </pre>
     *
     * <code>DOCUMENT_EFFICIENCY_UNSPECIFIED = 0;</code>
     */
    DOCUMENT_EFFICIENCY_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Document is inefficient.
     * </pre>
     *
     * <code>INEFFICIENT = 1;</code>
     */
    INEFFICIENT(1),
    /**
     *
     *
     * <pre>
     * Document is efficient.
     * </pre>
     *
     * <code>EFFICIENT = 2;</code>
     */
    EFFICIENT(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Document efficiency unspecified.
     * </pre>
     *
     * <code>DOCUMENT_EFFICIENCY_UNSPECIFIED = 0;</code>
     */
    public static final int DOCUMENT_EFFICIENCY_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Document is inefficient.
     * </pre>
     *
     * <code>INEFFICIENT = 1;</code>
     */
    public static final int INEFFICIENT_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Document is efficient.
     * </pre>
     *
     * <code>EFFICIENT = 2;</code>
     */
    public static final int EFFICIENT_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DocumentEfficiency valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static DocumentEfficiency forNumber(int value) {
      switch (value) {
        case 0:
          return DOCUMENT_EFFICIENCY_UNSPECIFIED;
        case 1:
          return INEFFICIENT;
        case 2:
          return EFFICIENT;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<DocumentEfficiency>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<DocumentEfficiency>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<DocumentEfficiency>() {
              public DocumentEfficiency findValueByNumber(int number) {
                return DocumentEfficiency.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2.AgentAssistantFeedback.getDescriptor()
          .getEnumTypes()
          .get(2);
    }

    private static final DocumentEfficiency[] VALUES = values();

    public static DocumentEfficiency valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private DocumentEfficiency(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.dialogflow.v2.AgentAssistantFeedback.DocumentEfficiency)
  }

  public static final int ANSWER_RELEVANCE_FIELD_NUMBER = 1;
  private int answerRelevance_;
  /**
   *
   *
   * <pre>
   * Optional. Whether or not the suggested answer is relevant.
   * For example:
   * * Query: "Can I change my mailing address?"
   * * Suggested document says: "Items must be returned/exchanged within 60
   *   days of the purchase date."
   * * [answer_relevance][google.cloud.dialogflow.v2.AgentAssistantFeedback.answer_relevance]: [AnswerRelevance.IRRELEVANT][google.cloud.dialogflow.v2.AgentAssistantFeedback.AnswerRelevance.IRRELEVANT]
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2.AgentAssistantFeedback.AnswerRelevance answer_relevance = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for answerRelevance.
   */
  @java.lang.Override
  public int getAnswerRelevanceValue() {
    return answerRelevance_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Whether or not the suggested answer is relevant.
   * For example:
   * * Query: "Can I change my mailing address?"
   * * Suggested document says: "Items must be returned/exchanged within 60
   *   days of the purchase date."
   * * [answer_relevance][google.cloud.dialogflow.v2.AgentAssistantFeedback.answer_relevance]: [AnswerRelevance.IRRELEVANT][google.cloud.dialogflow.v2.AgentAssistantFeedback.AnswerRelevance.IRRELEVANT]
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2.AgentAssistantFeedback.AnswerRelevance answer_relevance = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The answerRelevance.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.AgentAssistantFeedback.AnswerRelevance
      getAnswerRelevance() {
    @SuppressWarnings("deprecation")
    com.google.cloud.dialogflow.v2.AgentAssistantFeedback.AnswerRelevance result =
        com.google.cloud.dialogflow.v2.AgentAssistantFeedback.AnswerRelevance.valueOf(
            answerRelevance_);
    return result == null
        ? com.google.cloud.dialogflow.v2.AgentAssistantFeedback.AnswerRelevance.UNRECOGNIZED
        : result;
  }

  public static final int DOCUMENT_CORRECTNESS_FIELD_NUMBER = 2;
  private int documentCorrectness_;
  /**
   *
   *
   * <pre>
   * Optional. Whether or not the information in the document is correct.
   * For example:
   * * Query: "Can I return the package in 2 days once received?"
   * * Suggested document says: "Items must be returned/exchanged within 60
   *   days of the purchase date."
   * * Ground truth: "No return or exchange is allowed."
   * * [document_correctness]: INCORRECT
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2.AgentAssistantFeedback.DocumentCorrectness document_correctness = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for documentCorrectness.
   */
  @java.lang.Override
  public int getDocumentCorrectnessValue() {
    return documentCorrectness_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Whether or not the information in the document is correct.
   * For example:
   * * Query: "Can I return the package in 2 days once received?"
   * * Suggested document says: "Items must be returned/exchanged within 60
   *   days of the purchase date."
   * * Ground truth: "No return or exchange is allowed."
   * * [document_correctness]: INCORRECT
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2.AgentAssistantFeedback.DocumentCorrectness document_correctness = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The documentCorrectness.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.AgentAssistantFeedback.DocumentCorrectness
      getDocumentCorrectness() {
    @SuppressWarnings("deprecation")
    com.google.cloud.dialogflow.v2.AgentAssistantFeedback.DocumentCorrectness result =
        com.google.cloud.dialogflow.v2.AgentAssistantFeedback.DocumentCorrectness.valueOf(
            documentCorrectness_);
    return result == null
        ? com.google.cloud.dialogflow.v2.AgentAssistantFeedback.DocumentCorrectness.UNRECOGNIZED
        : result;
  }

  public static final int DOCUMENT_EFFICIENCY_FIELD_NUMBER = 3;
  private int documentEfficiency_;
  /**
   *
   *
   * <pre>
   * Optional. Whether or not the suggested document is efficient. For example,
   * if the document is poorly written, hard to understand, hard to use or
   * too long to find useful information,
   * [document_efficiency][google.cloud.dialogflow.v2.AgentAssistantFeedback.document_efficiency]
   * is
   * [DocumentEfficiency.INEFFICIENT][google.cloud.dialogflow.v2.AgentAssistantFeedback.DocumentEfficiency.INEFFICIENT].
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2.AgentAssistantFeedback.DocumentEfficiency document_efficiency = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for documentEfficiency.
   */
  @java.lang.Override
  public int getDocumentEfficiencyValue() {
    return documentEfficiency_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Whether or not the suggested document is efficient. For example,
   * if the document is poorly written, hard to understand, hard to use or
   * too long to find useful information,
   * [document_efficiency][google.cloud.dialogflow.v2.AgentAssistantFeedback.document_efficiency]
   * is
   * [DocumentEfficiency.INEFFICIENT][google.cloud.dialogflow.v2.AgentAssistantFeedback.DocumentEfficiency.INEFFICIENT].
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2.AgentAssistantFeedback.DocumentEfficiency document_efficiency = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The documentEfficiency.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.AgentAssistantFeedback.DocumentEfficiency
      getDocumentEfficiency() {
    @SuppressWarnings("deprecation")
    com.google.cloud.dialogflow.v2.AgentAssistantFeedback.DocumentEfficiency result =
        com.google.cloud.dialogflow.v2.AgentAssistantFeedback.DocumentEfficiency.valueOf(
            documentEfficiency_);
    return result == null
        ? com.google.cloud.dialogflow.v2.AgentAssistantFeedback.DocumentEfficiency.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (answerRelevance_
        != com.google.cloud.dialogflow.v2.AgentAssistantFeedback.AnswerRelevance
            .ANSWER_RELEVANCE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(1, answerRelevance_);
    }
    if (documentCorrectness_
        != com.google.cloud.dialogflow.v2.AgentAssistantFeedback.DocumentCorrectness
            .DOCUMENT_CORRECTNESS_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(2, documentCorrectness_);
    }
    if (documentEfficiency_
        != com.google.cloud.dialogflow.v2.AgentAssistantFeedback.DocumentEfficiency
            .DOCUMENT_EFFICIENCY_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(3, documentEfficiency_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (answerRelevance_
        != com.google.cloud.dialogflow.v2.AgentAssistantFeedback.AnswerRelevance
            .ANSWER_RELEVANCE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, answerRelevance_);
    }
    if (documentCorrectness_
        != com.google.cloud.dialogflow.v2.AgentAssistantFeedback.DocumentCorrectness
            .DOCUMENT_CORRECTNESS_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, documentCorrectness_);
    }
    if (documentEfficiency_
        != com.google.cloud.dialogflow.v2.AgentAssistantFeedback.DocumentEfficiency
            .DOCUMENT_EFFICIENCY_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, documentEfficiency_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.v2.AgentAssistantFeedback)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.v2.AgentAssistantFeedback other =
        (com.google.cloud.dialogflow.v2.AgentAssistantFeedback) obj;

    if (answerRelevance_ != other.answerRelevance_) return false;
    if (documentCorrectness_ != other.documentCorrectness_) return false;
    if (documentEfficiency_ != other.documentEfficiency_) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ANSWER_RELEVANCE_FIELD_NUMBER;
    hash = (53 * hash) + answerRelevance_;
    hash = (37 * hash) + DOCUMENT_CORRECTNESS_FIELD_NUMBER;
    hash = (53 * hash) + documentCorrectness_;
    hash = (37 * hash) + DOCUMENT_EFFICIENCY_FIELD_NUMBER;
    hash = (53 * hash) + documentEfficiency_;
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.v2.AgentAssistantFeedback parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2.AgentAssistantFeedback parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.AgentAssistantFeedback parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2.AgentAssistantFeedback parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.AgentAssistantFeedback parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2.AgentAssistantFeedback parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.AgentAssistantFeedback parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2.AgentAssistantFeedback parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.AgentAssistantFeedback parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2.AgentAssistantFeedback parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.AgentAssistantFeedback parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2.AgentAssistantFeedback parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.dialogflow.v2.AgentAssistantFeedback prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Detail feedback of Agent Assist result.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2.AgentAssistantFeedback}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2.AgentAssistantFeedback)
      com.google.cloud.dialogflow.v2.AgentAssistantFeedbackOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2.AnswerRecordsProto
          .internal_static_google_cloud_dialogflow_v2_AgentAssistantFeedback_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2.AnswerRecordsProto
          .internal_static_google_cloud_dialogflow_v2_AgentAssistantFeedback_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2.AgentAssistantFeedback.class,
              com.google.cloud.dialogflow.v2.AgentAssistantFeedback.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.v2.AgentAssistantFeedback.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      answerRelevance_ = 0;

      documentCorrectness_ = 0;

      documentEfficiency_ = 0;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.v2.AnswerRecordsProto
          .internal_static_google_cloud_dialogflow_v2_AgentAssistantFeedback_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.AgentAssistantFeedback getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.v2.AgentAssistantFeedback.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.AgentAssistantFeedback build() {
      com.google.cloud.dialogflow.v2.AgentAssistantFeedback result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.AgentAssistantFeedback buildPartial() {
      com.google.cloud.dialogflow.v2.AgentAssistantFeedback result =
          new com.google.cloud.dialogflow.v2.AgentAssistantFeedback(this);
      result.answerRelevance_ = answerRelevance_;
      result.documentCorrectness_ = documentCorrectness_;
      result.documentEfficiency_ = documentEfficiency_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.v2.AgentAssistantFeedback) {
        return mergeFrom((com.google.cloud.dialogflow.v2.AgentAssistantFeedback) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.v2.AgentAssistantFeedback other) {
      if (other == com.google.cloud.dialogflow.v2.AgentAssistantFeedback.getDefaultInstance())
        return this;
      if (other.answerRelevance_ != 0) {
        setAnswerRelevanceValue(other.getAnswerRelevanceValue());
      }
      if (other.documentCorrectness_ != 0) {
        setDocumentCorrectnessValue(other.getDocumentCorrectnessValue());
      }
      if (other.documentEfficiency_ != 0) {
        setDocumentEfficiencyValue(other.getDocumentEfficiencyValue());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.dialogflow.v2.AgentAssistantFeedback parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.dialogflow.v2.AgentAssistantFeedback) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int answerRelevance_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. Whether or not the suggested answer is relevant.
     * For example:
     * * Query: "Can I change my mailing address?"
     * * Suggested document says: "Items must be returned/exchanged within 60
     *   days of the purchase date."
     * * [answer_relevance][google.cloud.dialogflow.v2.AgentAssistantFeedback.answer_relevance]: [AnswerRelevance.IRRELEVANT][google.cloud.dialogflow.v2.AgentAssistantFeedback.AnswerRelevance.IRRELEVANT]
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.AgentAssistantFeedback.AnswerRelevance answer_relevance = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for answerRelevance.
     */
    @java.lang.Override
    public int getAnswerRelevanceValue() {
      return answerRelevance_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Whether or not the suggested answer is relevant.
     * For example:
     * * Query: "Can I change my mailing address?"
     * * Suggested document says: "Items must be returned/exchanged within 60
     *   days of the purchase date."
     * * [answer_relevance][google.cloud.dialogflow.v2.AgentAssistantFeedback.answer_relevance]: [AnswerRelevance.IRRELEVANT][google.cloud.dialogflow.v2.AgentAssistantFeedback.AnswerRelevance.IRRELEVANT]
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.AgentAssistantFeedback.AnswerRelevance answer_relevance = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for answerRelevance to set.
     * @return This builder for chaining.
     */
    public Builder setAnswerRelevanceValue(int value) {

      answerRelevance_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Whether or not the suggested answer is relevant.
     * For example:
     * * Query: "Can I change my mailing address?"
     * * Suggested document says: "Items must be returned/exchanged within 60
     *   days of the purchase date."
     * * [answer_relevance][google.cloud.dialogflow.v2.AgentAssistantFeedback.answer_relevance]: [AnswerRelevance.IRRELEVANT][google.cloud.dialogflow.v2.AgentAssistantFeedback.AnswerRelevance.IRRELEVANT]
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.AgentAssistantFeedback.AnswerRelevance answer_relevance = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The answerRelevance.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2.AgentAssistantFeedback.AnswerRelevance
        getAnswerRelevance() {
      @SuppressWarnings("deprecation")
      com.google.cloud.dialogflow.v2.AgentAssistantFeedback.AnswerRelevance result =
          com.google.cloud.dialogflow.v2.AgentAssistantFeedback.AnswerRelevance.valueOf(
              answerRelevance_);
      return result == null
          ? com.google.cloud.dialogflow.v2.AgentAssistantFeedback.AnswerRelevance.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Optional. Whether or not the suggested answer is relevant.
     * For example:
     * * Query: "Can I change my mailing address?"
     * * Suggested document says: "Items must be returned/exchanged within 60
     *   days of the purchase date."
     * * [answer_relevance][google.cloud.dialogflow.v2.AgentAssistantFeedback.answer_relevance]: [AnswerRelevance.IRRELEVANT][google.cloud.dialogflow.v2.AgentAssistantFeedback.AnswerRelevance.IRRELEVANT]
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.AgentAssistantFeedback.AnswerRelevance answer_relevance = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The answerRelevance to set.
     * @return This builder for chaining.
     */
    public Builder setAnswerRelevance(
        com.google.cloud.dialogflow.v2.AgentAssistantFeedback.AnswerRelevance value) {
      if (value == null) {
        throw new NullPointerException();
      }

      answerRelevance_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Whether or not the suggested answer is relevant.
     * For example:
     * * Query: "Can I change my mailing address?"
     * * Suggested document says: "Items must be returned/exchanged within 60
     *   days of the purchase date."
     * * [answer_relevance][google.cloud.dialogflow.v2.AgentAssistantFeedback.answer_relevance]: [AnswerRelevance.IRRELEVANT][google.cloud.dialogflow.v2.AgentAssistantFeedback.AnswerRelevance.IRRELEVANT]
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.AgentAssistantFeedback.AnswerRelevance answer_relevance = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAnswerRelevance() {

      answerRelevance_ = 0;
      onChanged();
      return this;
    }

    private int documentCorrectness_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. Whether or not the information in the document is correct.
     * For example:
     * * Query: "Can I return the package in 2 days once received?"
     * * Suggested document says: "Items must be returned/exchanged within 60
     *   days of the purchase date."
     * * Ground truth: "No return or exchange is allowed."
     * * [document_correctness]: INCORRECT
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.AgentAssistantFeedback.DocumentCorrectness document_correctness = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for documentCorrectness.
     */
    @java.lang.Override
    public int getDocumentCorrectnessValue() {
      return documentCorrectness_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Whether or not the information in the document is correct.
     * For example:
     * * Query: "Can I return the package in 2 days once received?"
     * * Suggested document says: "Items must be returned/exchanged within 60
     *   days of the purchase date."
     * * Ground truth: "No return or exchange is allowed."
     * * [document_correctness]: INCORRECT
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.AgentAssistantFeedback.DocumentCorrectness document_correctness = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for documentCorrectness to set.
     * @return This builder for chaining.
     */
    public Builder setDocumentCorrectnessValue(int value) {

      documentCorrectness_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Whether or not the information in the document is correct.
     * For example:
     * * Query: "Can I return the package in 2 days once received?"
     * * Suggested document says: "Items must be returned/exchanged within 60
     *   days of the purchase date."
     * * Ground truth: "No return or exchange is allowed."
     * * [document_correctness]: INCORRECT
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.AgentAssistantFeedback.DocumentCorrectness document_correctness = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The documentCorrectness.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2.AgentAssistantFeedback.DocumentCorrectness
        getDocumentCorrectness() {
      @SuppressWarnings("deprecation")
      com.google.cloud.dialogflow.v2.AgentAssistantFeedback.DocumentCorrectness result =
          com.google.cloud.dialogflow.v2.AgentAssistantFeedback.DocumentCorrectness.valueOf(
              documentCorrectness_);
      return result == null
          ? com.google.cloud.dialogflow.v2.AgentAssistantFeedback.DocumentCorrectness.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Optional. Whether or not the information in the document is correct.
     * For example:
     * * Query: "Can I return the package in 2 days once received?"
     * * Suggested document says: "Items must be returned/exchanged within 60
     *   days of the purchase date."
     * * Ground truth: "No return or exchange is allowed."
     * * [document_correctness]: INCORRECT
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.AgentAssistantFeedback.DocumentCorrectness document_correctness = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The documentCorrectness to set.
     * @return This builder for chaining.
     */
    public Builder setDocumentCorrectness(
        com.google.cloud.dialogflow.v2.AgentAssistantFeedback.DocumentCorrectness value) {
      if (value == null) {
        throw new NullPointerException();
      }

      documentCorrectness_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Whether or not the information in the document is correct.
     * For example:
     * * Query: "Can I return the package in 2 days once received?"
     * * Suggested document says: "Items must be returned/exchanged within 60
     *   days of the purchase date."
     * * Ground truth: "No return or exchange is allowed."
     * * [document_correctness]: INCORRECT
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.AgentAssistantFeedback.DocumentCorrectness document_correctness = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDocumentCorrectness() {

      documentCorrectness_ = 0;
      onChanged();
      return this;
    }

    private int documentEfficiency_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. Whether or not the suggested document is efficient. For example,
     * if the document is poorly written, hard to understand, hard to use or
     * too long to find useful information,
     * [document_efficiency][google.cloud.dialogflow.v2.AgentAssistantFeedback.document_efficiency]
     * is
     * [DocumentEfficiency.INEFFICIENT][google.cloud.dialogflow.v2.AgentAssistantFeedback.DocumentEfficiency.INEFFICIENT].
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.AgentAssistantFeedback.DocumentEfficiency document_efficiency = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for documentEfficiency.
     */
    @java.lang.Override
    public int getDocumentEfficiencyValue() {
      return documentEfficiency_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Whether or not the suggested document is efficient. For example,
     * if the document is poorly written, hard to understand, hard to use or
     * too long to find useful information,
     * [document_efficiency][google.cloud.dialogflow.v2.AgentAssistantFeedback.document_efficiency]
     * is
     * [DocumentEfficiency.INEFFICIENT][google.cloud.dialogflow.v2.AgentAssistantFeedback.DocumentEfficiency.INEFFICIENT].
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.AgentAssistantFeedback.DocumentEfficiency document_efficiency = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for documentEfficiency to set.
     * @return This builder for chaining.
     */
    public Builder setDocumentEfficiencyValue(int value) {

      documentEfficiency_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Whether or not the suggested document is efficient. For example,
     * if the document is poorly written, hard to understand, hard to use or
     * too long to find useful information,
     * [document_efficiency][google.cloud.dialogflow.v2.AgentAssistantFeedback.document_efficiency]
     * is
     * [DocumentEfficiency.INEFFICIENT][google.cloud.dialogflow.v2.AgentAssistantFeedback.DocumentEfficiency.INEFFICIENT].
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.AgentAssistantFeedback.DocumentEfficiency document_efficiency = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The documentEfficiency.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2.AgentAssistantFeedback.DocumentEfficiency
        getDocumentEfficiency() {
      @SuppressWarnings("deprecation")
      com.google.cloud.dialogflow.v2.AgentAssistantFeedback.DocumentEfficiency result =
          com.google.cloud.dialogflow.v2.AgentAssistantFeedback.DocumentEfficiency.valueOf(
              documentEfficiency_);
      return result == null
          ? com.google.cloud.dialogflow.v2.AgentAssistantFeedback.DocumentEfficiency.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Optional. Whether or not the suggested document is efficient. For example,
     * if the document is poorly written, hard to understand, hard to use or
     * too long to find useful information,
     * [document_efficiency][google.cloud.dialogflow.v2.AgentAssistantFeedback.document_efficiency]
     * is
     * [DocumentEfficiency.INEFFICIENT][google.cloud.dialogflow.v2.AgentAssistantFeedback.DocumentEfficiency.INEFFICIENT].
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.AgentAssistantFeedback.DocumentEfficiency document_efficiency = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The documentEfficiency to set.
     * @return This builder for chaining.
     */
    public Builder setDocumentEfficiency(
        com.google.cloud.dialogflow.v2.AgentAssistantFeedback.DocumentEfficiency value) {
      if (value == null) {
        throw new NullPointerException();
      }

      documentEfficiency_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Whether or not the suggested document is efficient. For example,
     * if the document is poorly written, hard to understand, hard to use or
     * too long to find useful information,
     * [document_efficiency][google.cloud.dialogflow.v2.AgentAssistantFeedback.document_efficiency]
     * is
     * [DocumentEfficiency.INEFFICIENT][google.cloud.dialogflow.v2.AgentAssistantFeedback.DocumentEfficiency.INEFFICIENT].
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.AgentAssistantFeedback.DocumentEfficiency document_efficiency = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDocumentEfficiency() {

      documentEfficiency_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2.AgentAssistantFeedback)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2.AgentAssistantFeedback)
  private static final com.google.cloud.dialogflow.v2.AgentAssistantFeedback DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2.AgentAssistantFeedback();
  }

  public static com.google.cloud.dialogflow.v2.AgentAssistantFeedback getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AgentAssistantFeedback> PARSER =
      new com.google.protobuf.AbstractParser<AgentAssistantFeedback>() {
        @java.lang.Override
        public AgentAssistantFeedback parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new AgentAssistantFeedback(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<AgentAssistantFeedback> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AgentAssistantFeedback> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.v2.AgentAssistantFeedback getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
