/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/v2/conversation_profile.proto

package com.google.cloud.dialogflow.v2;

/**
 *
 *
 * <pre>
 * Defines the services to connect to incoming Dialogflow conversations.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.v2.ConversationProfile}
 */
public final class ConversationProfile extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2.ConversationProfile)
    ConversationProfileOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ConversationProfile.newBuilder() to construct.
  private ConversationProfile(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ConversationProfile() {
    name_ = "";
    displayName_ = "";
    languageCode_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ConversationProfile();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private ConversationProfile(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
          case 18:
            {
              java.lang.String s = input.readStringRequireUtf8();

              displayName_ = s;
              break;
            }
          case 26:
            {
              com.google.cloud.dialogflow.v2.AutomatedAgentConfig.Builder subBuilder = null;
              if (automatedAgentConfig_ != null) {
                subBuilder = automatedAgentConfig_.toBuilder();
              }
              automatedAgentConfig_ =
                  input.readMessage(
                      com.google.cloud.dialogflow.v2.AutomatedAgentConfig.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(automatedAgentConfig_);
                automatedAgentConfig_ = subBuilder.buildPartial();
              }

              break;
            }
          case 34:
            {
              com.google.cloud.dialogflow.v2.HumanAgentAssistantConfig.Builder subBuilder = null;
              if (humanAgentAssistantConfig_ != null) {
                subBuilder = humanAgentAssistantConfig_.toBuilder();
              }
              humanAgentAssistantConfig_ =
                  input.readMessage(
                      com.google.cloud.dialogflow.v2.HumanAgentAssistantConfig.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(humanAgentAssistantConfig_);
                humanAgentAssistantConfig_ = subBuilder.buildPartial();
              }

              break;
            }
          case 42:
            {
              com.google.cloud.dialogflow.v2.HumanAgentHandoffConfig.Builder subBuilder = null;
              if (humanAgentHandoffConfig_ != null) {
                subBuilder = humanAgentHandoffConfig_.toBuilder();
              }
              humanAgentHandoffConfig_ =
                  input.readMessage(
                      com.google.cloud.dialogflow.v2.HumanAgentHandoffConfig.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(humanAgentHandoffConfig_);
                humanAgentHandoffConfig_ = subBuilder.buildPartial();
              }

              break;
            }
          case 50:
            {
              com.google.cloud.dialogflow.v2.NotificationConfig.Builder subBuilder = null;
              if (notificationConfig_ != null) {
                subBuilder = notificationConfig_.toBuilder();
              }
              notificationConfig_ =
                  input.readMessage(
                      com.google.cloud.dialogflow.v2.NotificationConfig.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(notificationConfig_);
                notificationConfig_ = subBuilder.buildPartial();
              }

              break;
            }
          case 58:
            {
              com.google.cloud.dialogflow.v2.LoggingConfig.Builder subBuilder = null;
              if (loggingConfig_ != null) {
                subBuilder = loggingConfig_.toBuilder();
              }
              loggingConfig_ =
                  input.readMessage(
                      com.google.cloud.dialogflow.v2.LoggingConfig.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(loggingConfig_);
                loggingConfig_ = subBuilder.buildPartial();
              }

              break;
            }
          case 66:
            {
              com.google.cloud.dialogflow.v2.NotificationConfig.Builder subBuilder = null;
              if (newMessageEventNotificationConfig_ != null) {
                subBuilder = newMessageEventNotificationConfig_.toBuilder();
              }
              newMessageEventNotificationConfig_ =
                  input.readMessage(
                      com.google.cloud.dialogflow.v2.NotificationConfig.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(newMessageEventNotificationConfig_);
                newMessageEventNotificationConfig_ = subBuilder.buildPartial();
              }

              break;
            }
          case 74:
            {
              com.google.cloud.dialogflow.v2.SpeechToTextConfig.Builder subBuilder = null;
              if (sttConfig_ != null) {
                subBuilder = sttConfig_.toBuilder();
              }
              sttConfig_ =
                  input.readMessage(
                      com.google.cloud.dialogflow.v2.SpeechToTextConfig.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(sttConfig_);
                sttConfig_ = subBuilder.buildPartial();
              }

              break;
            }
          case 82:
            {
              java.lang.String s = input.readStringRequireUtf8();

              languageCode_ = s;
              break;
            }
          case 90:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (createTime_ != null) {
                subBuilder = createTime_.toBuilder();
              }
              createTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(createTime_);
                createTime_ = subBuilder.buildPartial();
              }

              break;
            }
          case 98:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (updateTime_ != null) {
                subBuilder = updateTime_.toBuilder();
              }
              updateTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(updateTime_);
                updateTime_ = subBuilder.buildPartial();
              }

              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.v2.ConversationProfileProto
        .internal_static_google_cloud_dialogflow_v2_ConversationProfile_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.v2.ConversationProfileProto
        .internal_static_google_cloud_dialogflow_v2_ConversationProfile_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.v2.ConversationProfile.class,
            com.google.cloud.dialogflow.v2.ConversationProfile.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * The unique identifier of this conversation profile.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
   * ID&gt;/conversationProfiles/&lt;Conversation Profile ID&gt;`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The unique identifier of this conversation profile.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
   * ID&gt;/conversationProfiles/&lt;Conversation Profile ID&gt;`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;
  private volatile java.lang.Object displayName_;
  /**
   *
   *
   * <pre>
   * Required. Human readable name for this profile. Max length 1024 bytes.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Human readable name for this profile. Max length 1024 bytes.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 11;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Create time of the conversation profile.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Create time of the conversation profile.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Create time of the conversation profile.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return getCreateTime();
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 12;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. Update time of the conversation profile.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Update time of the conversation profile.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Update time of the conversation profile.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return getUpdateTime();
  }

  public static final int AUTOMATED_AGENT_CONFIG_FIELD_NUMBER = 3;
  private com.google.cloud.dialogflow.v2.AutomatedAgentConfig automatedAgentConfig_;
  /**
   *
   *
   * <pre>
   * Configuration for an automated agent to use with this profile.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2.AutomatedAgentConfig automated_agent_config = 3;</code>
   *
   * @return Whether the automatedAgentConfig field is set.
   */
  @java.lang.Override
  public boolean hasAutomatedAgentConfig() {
    return automatedAgentConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Configuration for an automated agent to use with this profile.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2.AutomatedAgentConfig automated_agent_config = 3;</code>
   *
   * @return The automatedAgentConfig.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.AutomatedAgentConfig getAutomatedAgentConfig() {
    return automatedAgentConfig_ == null
        ? com.google.cloud.dialogflow.v2.AutomatedAgentConfig.getDefaultInstance()
        : automatedAgentConfig_;
  }
  /**
   *
   *
   * <pre>
   * Configuration for an automated agent to use with this profile.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2.AutomatedAgentConfig automated_agent_config = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.AutomatedAgentConfigOrBuilder
      getAutomatedAgentConfigOrBuilder() {
    return getAutomatedAgentConfig();
  }

  public static final int HUMAN_AGENT_ASSISTANT_CONFIG_FIELD_NUMBER = 4;
  private com.google.cloud.dialogflow.v2.HumanAgentAssistantConfig humanAgentAssistantConfig_;
  /**
   *
   *
   * <pre>
   * Configuration for agent assistance to use with this profile.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2.HumanAgentAssistantConfig human_agent_assistant_config = 4;
   * </code>
   *
   * @return Whether the humanAgentAssistantConfig field is set.
   */
  @java.lang.Override
  public boolean hasHumanAgentAssistantConfig() {
    return humanAgentAssistantConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Configuration for agent assistance to use with this profile.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2.HumanAgentAssistantConfig human_agent_assistant_config = 4;
   * </code>
   *
   * @return The humanAgentAssistantConfig.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.HumanAgentAssistantConfig getHumanAgentAssistantConfig() {
    return humanAgentAssistantConfig_ == null
        ? com.google.cloud.dialogflow.v2.HumanAgentAssistantConfig.getDefaultInstance()
        : humanAgentAssistantConfig_;
  }
  /**
   *
   *
   * <pre>
   * Configuration for agent assistance to use with this profile.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2.HumanAgentAssistantConfig human_agent_assistant_config = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.HumanAgentAssistantConfigOrBuilder
      getHumanAgentAssistantConfigOrBuilder() {
    return getHumanAgentAssistantConfig();
  }

  public static final int HUMAN_AGENT_HANDOFF_CONFIG_FIELD_NUMBER = 5;
  private com.google.cloud.dialogflow.v2.HumanAgentHandoffConfig humanAgentHandoffConfig_;
  /**
   *
   *
   * <pre>
   * Configuration for connecting to a live agent.
   * Currently, this feature is not general available, please contact Google
   * to get access.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2.HumanAgentHandoffConfig human_agent_handoff_config = 5;
   * </code>
   *
   * @return Whether the humanAgentHandoffConfig field is set.
   */
  @java.lang.Override
  public boolean hasHumanAgentHandoffConfig() {
    return humanAgentHandoffConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Configuration for connecting to a live agent.
   * Currently, this feature is not general available, please contact Google
   * to get access.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2.HumanAgentHandoffConfig human_agent_handoff_config = 5;
   * </code>
   *
   * @return The humanAgentHandoffConfig.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.HumanAgentHandoffConfig getHumanAgentHandoffConfig() {
    return humanAgentHandoffConfig_ == null
        ? com.google.cloud.dialogflow.v2.HumanAgentHandoffConfig.getDefaultInstance()
        : humanAgentHandoffConfig_;
  }
  /**
   *
   *
   * <pre>
   * Configuration for connecting to a live agent.
   * Currently, this feature is not general available, please contact Google
   * to get access.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2.HumanAgentHandoffConfig human_agent_handoff_config = 5;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.HumanAgentHandoffConfigOrBuilder
      getHumanAgentHandoffConfigOrBuilder() {
    return getHumanAgentHandoffConfig();
  }

  public static final int NOTIFICATION_CONFIG_FIELD_NUMBER = 6;
  private com.google.cloud.dialogflow.v2.NotificationConfig notificationConfig_;
  /**
   *
   *
   * <pre>
   * Configuration for publishing conversation lifecycle events.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2.NotificationConfig notification_config = 6;</code>
   *
   * @return Whether the notificationConfig field is set.
   */
  @java.lang.Override
  public boolean hasNotificationConfig() {
    return notificationConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Configuration for publishing conversation lifecycle events.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2.NotificationConfig notification_config = 6;</code>
   *
   * @return The notificationConfig.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.NotificationConfig getNotificationConfig() {
    return notificationConfig_ == null
        ? com.google.cloud.dialogflow.v2.NotificationConfig.getDefaultInstance()
        : notificationConfig_;
  }
  /**
   *
   *
   * <pre>
   * Configuration for publishing conversation lifecycle events.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2.NotificationConfig notification_config = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.NotificationConfigOrBuilder
      getNotificationConfigOrBuilder() {
    return getNotificationConfig();
  }

  public static final int LOGGING_CONFIG_FIELD_NUMBER = 7;
  private com.google.cloud.dialogflow.v2.LoggingConfig loggingConfig_;
  /**
   *
   *
   * <pre>
   * Configuration for logging conversation lifecycle events.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2.LoggingConfig logging_config = 7;</code>
   *
   * @return Whether the loggingConfig field is set.
   */
  @java.lang.Override
  public boolean hasLoggingConfig() {
    return loggingConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Configuration for logging conversation lifecycle events.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2.LoggingConfig logging_config = 7;</code>
   *
   * @return The loggingConfig.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.LoggingConfig getLoggingConfig() {
    return loggingConfig_ == null
        ? com.google.cloud.dialogflow.v2.LoggingConfig.getDefaultInstance()
        : loggingConfig_;
  }
  /**
   *
   *
   * <pre>
   * Configuration for logging conversation lifecycle events.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2.LoggingConfig logging_config = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.LoggingConfigOrBuilder getLoggingConfigOrBuilder() {
    return getLoggingConfig();
  }

  public static final int NEW_MESSAGE_EVENT_NOTIFICATION_CONFIG_FIELD_NUMBER = 8;
  private com.google.cloud.dialogflow.v2.NotificationConfig newMessageEventNotificationConfig_;
  /**
   *
   *
   * <pre>
   * Configuration for publishing new message events. Event will be sent in
   * format of [ConversationEvent][google.cloud.dialogflow.v2.ConversationEvent]
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2.NotificationConfig new_message_event_notification_config = 8;
   * </code>
   *
   * @return Whether the newMessageEventNotificationConfig field is set.
   */
  @java.lang.Override
  public boolean hasNewMessageEventNotificationConfig() {
    return newMessageEventNotificationConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Configuration for publishing new message events. Event will be sent in
   * format of [ConversationEvent][google.cloud.dialogflow.v2.ConversationEvent]
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2.NotificationConfig new_message_event_notification_config = 8;
   * </code>
   *
   * @return The newMessageEventNotificationConfig.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.NotificationConfig getNewMessageEventNotificationConfig() {
    return newMessageEventNotificationConfig_ == null
        ? com.google.cloud.dialogflow.v2.NotificationConfig.getDefaultInstance()
        : newMessageEventNotificationConfig_;
  }
  /**
   *
   *
   * <pre>
   * Configuration for publishing new message events. Event will be sent in
   * format of [ConversationEvent][google.cloud.dialogflow.v2.ConversationEvent]
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2.NotificationConfig new_message_event_notification_config = 8;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.NotificationConfigOrBuilder
      getNewMessageEventNotificationConfigOrBuilder() {
    return getNewMessageEventNotificationConfig();
  }

  public static final int STT_CONFIG_FIELD_NUMBER = 9;
  private com.google.cloud.dialogflow.v2.SpeechToTextConfig sttConfig_;
  /**
   *
   *
   * <pre>
   * Settings for speech transcription.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2.SpeechToTextConfig stt_config = 9;</code>
   *
   * @return Whether the sttConfig field is set.
   */
  @java.lang.Override
  public boolean hasSttConfig() {
    return sttConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Settings for speech transcription.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2.SpeechToTextConfig stt_config = 9;</code>
   *
   * @return The sttConfig.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.SpeechToTextConfig getSttConfig() {
    return sttConfig_ == null
        ? com.google.cloud.dialogflow.v2.SpeechToTextConfig.getDefaultInstance()
        : sttConfig_;
  }
  /**
   *
   *
   * <pre>
   * Settings for speech transcription.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2.SpeechToTextConfig stt_config = 9;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.SpeechToTextConfigOrBuilder getSttConfigOrBuilder() {
    return getSttConfig();
  }

  public static final int LANGUAGE_CODE_FIELD_NUMBER = 10;
  private volatile java.lang.Object languageCode_;
  /**
   *
   *
   * <pre>
   * Language which represents the conversationProfile.
   * If unspecified, the default language code en-us applies. Users need to
   * create a ConversationProfile for each language they want to support.
   * </pre>
   *
   * <code>string language_code = 10;</code>
   *
   * @return The languageCode.
   */
  @java.lang.Override
  public java.lang.String getLanguageCode() {
    java.lang.Object ref = languageCode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      languageCode_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Language which represents the conversationProfile.
   * If unspecified, the default language code en-us applies. Users need to
   * create a ConversationProfile for each language they want to support.
   * </pre>
   *
   * <code>string language_code = 10;</code>
   *
   * @return The bytes for languageCode.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLanguageCodeBytes() {
    java.lang.Object ref = languageCode_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      languageCode_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!getNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!getDisplayNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (automatedAgentConfig_ != null) {
      output.writeMessage(3, getAutomatedAgentConfig());
    }
    if (humanAgentAssistantConfig_ != null) {
      output.writeMessage(4, getHumanAgentAssistantConfig());
    }
    if (humanAgentHandoffConfig_ != null) {
      output.writeMessage(5, getHumanAgentHandoffConfig());
    }
    if (notificationConfig_ != null) {
      output.writeMessage(6, getNotificationConfig());
    }
    if (loggingConfig_ != null) {
      output.writeMessage(7, getLoggingConfig());
    }
    if (newMessageEventNotificationConfig_ != null) {
      output.writeMessage(8, getNewMessageEventNotificationConfig());
    }
    if (sttConfig_ != null) {
      output.writeMessage(9, getSttConfig());
    }
    if (!getLanguageCodeBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, languageCode_);
    }
    if (createTime_ != null) {
      output.writeMessage(11, getCreateTime());
    }
    if (updateTime_ != null) {
      output.writeMessage(12, getUpdateTime());
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!getDisplayNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (automatedAgentConfig_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(3, getAutomatedAgentConfig());
    }
    if (humanAgentAssistantConfig_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, getHumanAgentAssistantConfig());
    }
    if (humanAgentHandoffConfig_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(5, getHumanAgentHandoffConfig());
    }
    if (notificationConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getNotificationConfig());
    }
    if (loggingConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getLoggingConfig());
    }
    if (newMessageEventNotificationConfig_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              8, getNewMessageEventNotificationConfig());
    }
    if (sttConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getSttConfig());
    }
    if (!getLanguageCodeBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, languageCode_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getCreateTime());
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, getUpdateTime());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.v2.ConversationProfile)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.v2.ConversationProfile other =
        (com.google.cloud.dialogflow.v2.ConversationProfile) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (hasAutomatedAgentConfig() != other.hasAutomatedAgentConfig()) return false;
    if (hasAutomatedAgentConfig()) {
      if (!getAutomatedAgentConfig().equals(other.getAutomatedAgentConfig())) return false;
    }
    if (hasHumanAgentAssistantConfig() != other.hasHumanAgentAssistantConfig()) return false;
    if (hasHumanAgentAssistantConfig()) {
      if (!getHumanAgentAssistantConfig().equals(other.getHumanAgentAssistantConfig()))
        return false;
    }
    if (hasHumanAgentHandoffConfig() != other.hasHumanAgentHandoffConfig()) return false;
    if (hasHumanAgentHandoffConfig()) {
      if (!getHumanAgentHandoffConfig().equals(other.getHumanAgentHandoffConfig())) return false;
    }
    if (hasNotificationConfig() != other.hasNotificationConfig()) return false;
    if (hasNotificationConfig()) {
      if (!getNotificationConfig().equals(other.getNotificationConfig())) return false;
    }
    if (hasLoggingConfig() != other.hasLoggingConfig()) return false;
    if (hasLoggingConfig()) {
      if (!getLoggingConfig().equals(other.getLoggingConfig())) return false;
    }
    if (hasNewMessageEventNotificationConfig() != other.hasNewMessageEventNotificationConfig())
      return false;
    if (hasNewMessageEventNotificationConfig()) {
      if (!getNewMessageEventNotificationConfig()
          .equals(other.getNewMessageEventNotificationConfig())) return false;
    }
    if (hasSttConfig() != other.hasSttConfig()) return false;
    if (hasSttConfig()) {
      if (!getSttConfig().equals(other.getSttConfig())) return false;
    }
    if (!getLanguageCode().equals(other.getLanguageCode())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (hasAutomatedAgentConfig()) {
      hash = (37 * hash) + AUTOMATED_AGENT_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getAutomatedAgentConfig().hashCode();
    }
    if (hasHumanAgentAssistantConfig()) {
      hash = (37 * hash) + HUMAN_AGENT_ASSISTANT_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getHumanAgentAssistantConfig().hashCode();
    }
    if (hasHumanAgentHandoffConfig()) {
      hash = (37 * hash) + HUMAN_AGENT_HANDOFF_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getHumanAgentHandoffConfig().hashCode();
    }
    if (hasNotificationConfig()) {
      hash = (37 * hash) + NOTIFICATION_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getNotificationConfig().hashCode();
    }
    if (hasLoggingConfig()) {
      hash = (37 * hash) + LOGGING_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getLoggingConfig().hashCode();
    }
    if (hasNewMessageEventNotificationConfig()) {
      hash = (37 * hash) + NEW_MESSAGE_EVENT_NOTIFICATION_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getNewMessageEventNotificationConfig().hashCode();
    }
    if (hasSttConfig()) {
      hash = (37 * hash) + STT_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getSttConfig().hashCode();
    }
    hash = (37 * hash) + LANGUAGE_CODE_FIELD_NUMBER;
    hash = (53 * hash) + getLanguageCode().hashCode();
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.v2.ConversationProfile parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2.ConversationProfile parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.ConversationProfile parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2.ConversationProfile parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.ConversationProfile parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2.ConversationProfile parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.ConversationProfile parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2.ConversationProfile parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.ConversationProfile parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2.ConversationProfile parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.ConversationProfile parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2.ConversationProfile parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dialogflow.v2.ConversationProfile prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Defines the services to connect to incoming Dialogflow conversations.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2.ConversationProfile}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2.ConversationProfile)
      com.google.cloud.dialogflow.v2.ConversationProfileOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2.ConversationProfileProto
          .internal_static_google_cloud_dialogflow_v2_ConversationProfile_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2.ConversationProfileProto
          .internal_static_google_cloud_dialogflow_v2_ConversationProfile_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2.ConversationProfile.class,
              com.google.cloud.dialogflow.v2.ConversationProfile.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.v2.ConversationProfile.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      displayName_ = "";

      if (createTimeBuilder_ == null) {
        createTime_ = null;
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }
      if (updateTimeBuilder_ == null) {
        updateTime_ = null;
      } else {
        updateTime_ = null;
        updateTimeBuilder_ = null;
      }
      if (automatedAgentConfigBuilder_ == null) {
        automatedAgentConfig_ = null;
      } else {
        automatedAgentConfig_ = null;
        automatedAgentConfigBuilder_ = null;
      }
      if (humanAgentAssistantConfigBuilder_ == null) {
        humanAgentAssistantConfig_ = null;
      } else {
        humanAgentAssistantConfig_ = null;
        humanAgentAssistantConfigBuilder_ = null;
      }
      if (humanAgentHandoffConfigBuilder_ == null) {
        humanAgentHandoffConfig_ = null;
      } else {
        humanAgentHandoffConfig_ = null;
        humanAgentHandoffConfigBuilder_ = null;
      }
      if (notificationConfigBuilder_ == null) {
        notificationConfig_ = null;
      } else {
        notificationConfig_ = null;
        notificationConfigBuilder_ = null;
      }
      if (loggingConfigBuilder_ == null) {
        loggingConfig_ = null;
      } else {
        loggingConfig_ = null;
        loggingConfigBuilder_ = null;
      }
      if (newMessageEventNotificationConfigBuilder_ == null) {
        newMessageEventNotificationConfig_ = null;
      } else {
        newMessageEventNotificationConfig_ = null;
        newMessageEventNotificationConfigBuilder_ = null;
      }
      if (sttConfigBuilder_ == null) {
        sttConfig_ = null;
      } else {
        sttConfig_ = null;
        sttConfigBuilder_ = null;
      }
      languageCode_ = "";

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.v2.ConversationProfileProto
          .internal_static_google_cloud_dialogflow_v2_ConversationProfile_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.ConversationProfile getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.v2.ConversationProfile.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.ConversationProfile build() {
      com.google.cloud.dialogflow.v2.ConversationProfile result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.ConversationProfile buildPartial() {
      com.google.cloud.dialogflow.v2.ConversationProfile result =
          new com.google.cloud.dialogflow.v2.ConversationProfile(this);
      result.name_ = name_;
      result.displayName_ = displayName_;
      if (createTimeBuilder_ == null) {
        result.createTime_ = createTime_;
      } else {
        result.createTime_ = createTimeBuilder_.build();
      }
      if (updateTimeBuilder_ == null) {
        result.updateTime_ = updateTime_;
      } else {
        result.updateTime_ = updateTimeBuilder_.build();
      }
      if (automatedAgentConfigBuilder_ == null) {
        result.automatedAgentConfig_ = automatedAgentConfig_;
      } else {
        result.automatedAgentConfig_ = automatedAgentConfigBuilder_.build();
      }
      if (humanAgentAssistantConfigBuilder_ == null) {
        result.humanAgentAssistantConfig_ = humanAgentAssistantConfig_;
      } else {
        result.humanAgentAssistantConfig_ = humanAgentAssistantConfigBuilder_.build();
      }
      if (humanAgentHandoffConfigBuilder_ == null) {
        result.humanAgentHandoffConfig_ = humanAgentHandoffConfig_;
      } else {
        result.humanAgentHandoffConfig_ = humanAgentHandoffConfigBuilder_.build();
      }
      if (notificationConfigBuilder_ == null) {
        result.notificationConfig_ = notificationConfig_;
      } else {
        result.notificationConfig_ = notificationConfigBuilder_.build();
      }
      if (loggingConfigBuilder_ == null) {
        result.loggingConfig_ = loggingConfig_;
      } else {
        result.loggingConfig_ = loggingConfigBuilder_.build();
      }
      if (newMessageEventNotificationConfigBuilder_ == null) {
        result.newMessageEventNotificationConfig_ = newMessageEventNotificationConfig_;
      } else {
        result.newMessageEventNotificationConfig_ =
            newMessageEventNotificationConfigBuilder_.build();
      }
      if (sttConfigBuilder_ == null) {
        result.sttConfig_ = sttConfig_;
      } else {
        result.sttConfig_ = sttConfigBuilder_.build();
      }
      result.languageCode_ = languageCode_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.v2.ConversationProfile) {
        return mergeFrom((com.google.cloud.dialogflow.v2.ConversationProfile) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.v2.ConversationProfile other) {
      if (other == com.google.cloud.dialogflow.v2.ConversationProfile.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (other.hasAutomatedAgentConfig()) {
        mergeAutomatedAgentConfig(other.getAutomatedAgentConfig());
      }
      if (other.hasHumanAgentAssistantConfig()) {
        mergeHumanAgentAssistantConfig(other.getHumanAgentAssistantConfig());
      }
      if (other.hasHumanAgentHandoffConfig()) {
        mergeHumanAgentHandoffConfig(other.getHumanAgentHandoffConfig());
      }
      if (other.hasNotificationConfig()) {
        mergeNotificationConfig(other.getNotificationConfig());
      }
      if (other.hasLoggingConfig()) {
        mergeLoggingConfig(other.getLoggingConfig());
      }
      if (other.hasNewMessageEventNotificationConfig()) {
        mergeNewMessageEventNotificationConfig(other.getNewMessageEventNotificationConfig());
      }
      if (other.hasSttConfig()) {
        mergeSttConfig(other.getSttConfig());
      }
      if (!other.getLanguageCode().isEmpty()) {
        languageCode_ = other.languageCode_;
        onChanged();
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.dialogflow.v2.ConversationProfile parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.dialogflow.v2.ConversationProfile) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The unique identifier of this conversation profile.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/conversationProfiles/&lt;Conversation Profile ID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of this conversation profile.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/conversationProfiles/&lt;Conversation Profile ID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of this conversation profile.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/conversationProfiles/&lt;Conversation Profile ID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of this conversation profile.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/conversationProfiles/&lt;Conversation Profile ID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of this conversation profile.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/conversationProfiles/&lt;Conversation Profile ID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Required. Human readable name for this profile. Max length 1024 bytes.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Human readable name for this profile. Max length 1024 bytes.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Human readable name for this profile. Max length 1024 bytes.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      displayName_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Human readable name for this profile. Max length 1024 bytes.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {

      displayName_ = getDefaultInstance().getDisplayName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Human readable name for this profile. Max length 1024 bytes.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      displayName_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Create time of the conversation profile.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return createTimeBuilder_ != null || createTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Create time of the conversation profile.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Create time of the conversation profile.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
        onChanged();
      } else {
        createTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Create time of the conversation profile.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
        onChanged();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Create time of the conversation profile.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (createTime_ != null) {
          createTime_ =
              com.google.protobuf.Timestamp.newBuilder(createTime_).mergeFrom(value).buildPartial();
        } else {
          createTime_ = value;
        }
        onChanged();
      } else {
        createTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Create time of the conversation profile.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      if (createTimeBuilder_ == null) {
        createTime_ = null;
        onChanged();
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Create time of the conversation profile.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {

      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Create time of the conversation profile.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Create time of the conversation profile.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Update time of the conversation profile.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return updateTimeBuilder_ != null || updateTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Update time of the conversation profile.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Update time of the conversation profile.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
        onChanged();
      } else {
        updateTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Update time of the conversation profile.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
        onChanged();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Update time of the conversation profile.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (updateTime_ != null) {
          updateTime_ =
              com.google.protobuf.Timestamp.newBuilder(updateTime_).mergeFrom(value).buildPartial();
        } else {
          updateTime_ = value;
        }
        onChanged();
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Update time of the conversation profile.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      if (updateTimeBuilder_ == null) {
        updateTime_ = null;
        onChanged();
      } else {
        updateTime_ = null;
        updateTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Update time of the conversation profile.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {

      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Update time of the conversation profile.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Update time of the conversation profile.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.cloud.dialogflow.v2.AutomatedAgentConfig automatedAgentConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2.AutomatedAgentConfig,
            com.google.cloud.dialogflow.v2.AutomatedAgentConfig.Builder,
            com.google.cloud.dialogflow.v2.AutomatedAgentConfigOrBuilder>
        automatedAgentConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for an automated agent to use with this profile.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.AutomatedAgentConfig automated_agent_config = 3;</code>
     *
     * @return Whether the automatedAgentConfig field is set.
     */
    public boolean hasAutomatedAgentConfig() {
      return automatedAgentConfigBuilder_ != null || automatedAgentConfig_ != null;
    }
    /**
     *
     *
     * <pre>
     * Configuration for an automated agent to use with this profile.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.AutomatedAgentConfig automated_agent_config = 3;</code>
     *
     * @return The automatedAgentConfig.
     */
    public com.google.cloud.dialogflow.v2.AutomatedAgentConfig getAutomatedAgentConfig() {
      if (automatedAgentConfigBuilder_ == null) {
        return automatedAgentConfig_ == null
            ? com.google.cloud.dialogflow.v2.AutomatedAgentConfig.getDefaultInstance()
            : automatedAgentConfig_;
      } else {
        return automatedAgentConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for an automated agent to use with this profile.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.AutomatedAgentConfig automated_agent_config = 3;</code>
     */
    public Builder setAutomatedAgentConfig(
        com.google.cloud.dialogflow.v2.AutomatedAgentConfig value) {
      if (automatedAgentConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        automatedAgentConfig_ = value;
        onChanged();
      } else {
        automatedAgentConfigBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for an automated agent to use with this profile.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.AutomatedAgentConfig automated_agent_config = 3;</code>
     */
    public Builder setAutomatedAgentConfig(
        com.google.cloud.dialogflow.v2.AutomatedAgentConfig.Builder builderForValue) {
      if (automatedAgentConfigBuilder_ == null) {
        automatedAgentConfig_ = builderForValue.build();
        onChanged();
      } else {
        automatedAgentConfigBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for an automated agent to use with this profile.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.AutomatedAgentConfig automated_agent_config = 3;</code>
     */
    public Builder mergeAutomatedAgentConfig(
        com.google.cloud.dialogflow.v2.AutomatedAgentConfig value) {
      if (automatedAgentConfigBuilder_ == null) {
        if (automatedAgentConfig_ != null) {
          automatedAgentConfig_ =
              com.google.cloud.dialogflow.v2.AutomatedAgentConfig.newBuilder(automatedAgentConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          automatedAgentConfig_ = value;
        }
        onChanged();
      } else {
        automatedAgentConfigBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for an automated agent to use with this profile.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.AutomatedAgentConfig automated_agent_config = 3;</code>
     */
    public Builder clearAutomatedAgentConfig() {
      if (automatedAgentConfigBuilder_ == null) {
        automatedAgentConfig_ = null;
        onChanged();
      } else {
        automatedAgentConfig_ = null;
        automatedAgentConfigBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for an automated agent to use with this profile.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.AutomatedAgentConfig automated_agent_config = 3;</code>
     */
    public com.google.cloud.dialogflow.v2.AutomatedAgentConfig.Builder
        getAutomatedAgentConfigBuilder() {

      onChanged();
      return getAutomatedAgentConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for an automated agent to use with this profile.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.AutomatedAgentConfig automated_agent_config = 3;</code>
     */
    public com.google.cloud.dialogflow.v2.AutomatedAgentConfigOrBuilder
        getAutomatedAgentConfigOrBuilder() {
      if (automatedAgentConfigBuilder_ != null) {
        return automatedAgentConfigBuilder_.getMessageOrBuilder();
      } else {
        return automatedAgentConfig_ == null
            ? com.google.cloud.dialogflow.v2.AutomatedAgentConfig.getDefaultInstance()
            : automatedAgentConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for an automated agent to use with this profile.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.AutomatedAgentConfig automated_agent_config = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2.AutomatedAgentConfig,
            com.google.cloud.dialogflow.v2.AutomatedAgentConfig.Builder,
            com.google.cloud.dialogflow.v2.AutomatedAgentConfigOrBuilder>
        getAutomatedAgentConfigFieldBuilder() {
      if (automatedAgentConfigBuilder_ == null) {
        automatedAgentConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2.AutomatedAgentConfig,
                com.google.cloud.dialogflow.v2.AutomatedAgentConfig.Builder,
                com.google.cloud.dialogflow.v2.AutomatedAgentConfigOrBuilder>(
                getAutomatedAgentConfig(), getParentForChildren(), isClean());
        automatedAgentConfig_ = null;
      }
      return automatedAgentConfigBuilder_;
    }

    private com.google.cloud.dialogflow.v2.HumanAgentAssistantConfig humanAgentAssistantConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2.HumanAgentAssistantConfig,
            com.google.cloud.dialogflow.v2.HumanAgentAssistantConfig.Builder,
            com.google.cloud.dialogflow.v2.HumanAgentAssistantConfigOrBuilder>
        humanAgentAssistantConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for agent assistance to use with this profile.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.HumanAgentAssistantConfig human_agent_assistant_config = 4;
     * </code>
     *
     * @return Whether the humanAgentAssistantConfig field is set.
     */
    public boolean hasHumanAgentAssistantConfig() {
      return humanAgentAssistantConfigBuilder_ != null || humanAgentAssistantConfig_ != null;
    }
    /**
     *
     *
     * <pre>
     * Configuration for agent assistance to use with this profile.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.HumanAgentAssistantConfig human_agent_assistant_config = 4;
     * </code>
     *
     * @return The humanAgentAssistantConfig.
     */
    public com.google.cloud.dialogflow.v2.HumanAgentAssistantConfig getHumanAgentAssistantConfig() {
      if (humanAgentAssistantConfigBuilder_ == null) {
        return humanAgentAssistantConfig_ == null
            ? com.google.cloud.dialogflow.v2.HumanAgentAssistantConfig.getDefaultInstance()
            : humanAgentAssistantConfig_;
      } else {
        return humanAgentAssistantConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for agent assistance to use with this profile.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.HumanAgentAssistantConfig human_agent_assistant_config = 4;
     * </code>
     */
    public Builder setHumanAgentAssistantConfig(
        com.google.cloud.dialogflow.v2.HumanAgentAssistantConfig value) {
      if (humanAgentAssistantConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        humanAgentAssistantConfig_ = value;
        onChanged();
      } else {
        humanAgentAssistantConfigBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for agent assistance to use with this profile.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.HumanAgentAssistantConfig human_agent_assistant_config = 4;
     * </code>
     */
    public Builder setHumanAgentAssistantConfig(
        com.google.cloud.dialogflow.v2.HumanAgentAssistantConfig.Builder builderForValue) {
      if (humanAgentAssistantConfigBuilder_ == null) {
        humanAgentAssistantConfig_ = builderForValue.build();
        onChanged();
      } else {
        humanAgentAssistantConfigBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for agent assistance to use with this profile.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.HumanAgentAssistantConfig human_agent_assistant_config = 4;
     * </code>
     */
    public Builder mergeHumanAgentAssistantConfig(
        com.google.cloud.dialogflow.v2.HumanAgentAssistantConfig value) {
      if (humanAgentAssistantConfigBuilder_ == null) {
        if (humanAgentAssistantConfig_ != null) {
          humanAgentAssistantConfig_ =
              com.google.cloud.dialogflow.v2.HumanAgentAssistantConfig.newBuilder(
                      humanAgentAssistantConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          humanAgentAssistantConfig_ = value;
        }
        onChanged();
      } else {
        humanAgentAssistantConfigBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for agent assistance to use with this profile.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.HumanAgentAssistantConfig human_agent_assistant_config = 4;
     * </code>
     */
    public Builder clearHumanAgentAssistantConfig() {
      if (humanAgentAssistantConfigBuilder_ == null) {
        humanAgentAssistantConfig_ = null;
        onChanged();
      } else {
        humanAgentAssistantConfig_ = null;
        humanAgentAssistantConfigBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for agent assistance to use with this profile.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.HumanAgentAssistantConfig human_agent_assistant_config = 4;
     * </code>
     */
    public com.google.cloud.dialogflow.v2.HumanAgentAssistantConfig.Builder
        getHumanAgentAssistantConfigBuilder() {

      onChanged();
      return getHumanAgentAssistantConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for agent assistance to use with this profile.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.HumanAgentAssistantConfig human_agent_assistant_config = 4;
     * </code>
     */
    public com.google.cloud.dialogflow.v2.HumanAgentAssistantConfigOrBuilder
        getHumanAgentAssistantConfigOrBuilder() {
      if (humanAgentAssistantConfigBuilder_ != null) {
        return humanAgentAssistantConfigBuilder_.getMessageOrBuilder();
      } else {
        return humanAgentAssistantConfig_ == null
            ? com.google.cloud.dialogflow.v2.HumanAgentAssistantConfig.getDefaultInstance()
            : humanAgentAssistantConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for agent assistance to use with this profile.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.HumanAgentAssistantConfig human_agent_assistant_config = 4;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2.HumanAgentAssistantConfig,
            com.google.cloud.dialogflow.v2.HumanAgentAssistantConfig.Builder,
            com.google.cloud.dialogflow.v2.HumanAgentAssistantConfigOrBuilder>
        getHumanAgentAssistantConfigFieldBuilder() {
      if (humanAgentAssistantConfigBuilder_ == null) {
        humanAgentAssistantConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2.HumanAgentAssistantConfig,
                com.google.cloud.dialogflow.v2.HumanAgentAssistantConfig.Builder,
                com.google.cloud.dialogflow.v2.HumanAgentAssistantConfigOrBuilder>(
                getHumanAgentAssistantConfig(), getParentForChildren(), isClean());
        humanAgentAssistantConfig_ = null;
      }
      return humanAgentAssistantConfigBuilder_;
    }

    private com.google.cloud.dialogflow.v2.HumanAgentHandoffConfig humanAgentHandoffConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2.HumanAgentHandoffConfig,
            com.google.cloud.dialogflow.v2.HumanAgentHandoffConfig.Builder,
            com.google.cloud.dialogflow.v2.HumanAgentHandoffConfigOrBuilder>
        humanAgentHandoffConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for connecting to a live agent.
     * Currently, this feature is not general available, please contact Google
     * to get access.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.HumanAgentHandoffConfig human_agent_handoff_config = 5;
     * </code>
     *
     * @return Whether the humanAgentHandoffConfig field is set.
     */
    public boolean hasHumanAgentHandoffConfig() {
      return humanAgentHandoffConfigBuilder_ != null || humanAgentHandoffConfig_ != null;
    }
    /**
     *
     *
     * <pre>
     * Configuration for connecting to a live agent.
     * Currently, this feature is not general available, please contact Google
     * to get access.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.HumanAgentHandoffConfig human_agent_handoff_config = 5;
     * </code>
     *
     * @return The humanAgentHandoffConfig.
     */
    public com.google.cloud.dialogflow.v2.HumanAgentHandoffConfig getHumanAgentHandoffConfig() {
      if (humanAgentHandoffConfigBuilder_ == null) {
        return humanAgentHandoffConfig_ == null
            ? com.google.cloud.dialogflow.v2.HumanAgentHandoffConfig.getDefaultInstance()
            : humanAgentHandoffConfig_;
      } else {
        return humanAgentHandoffConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for connecting to a live agent.
     * Currently, this feature is not general available, please contact Google
     * to get access.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.HumanAgentHandoffConfig human_agent_handoff_config = 5;
     * </code>
     */
    public Builder setHumanAgentHandoffConfig(
        com.google.cloud.dialogflow.v2.HumanAgentHandoffConfig value) {
      if (humanAgentHandoffConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        humanAgentHandoffConfig_ = value;
        onChanged();
      } else {
        humanAgentHandoffConfigBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for connecting to a live agent.
     * Currently, this feature is not general available, please contact Google
     * to get access.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.HumanAgentHandoffConfig human_agent_handoff_config = 5;
     * </code>
     */
    public Builder setHumanAgentHandoffConfig(
        com.google.cloud.dialogflow.v2.HumanAgentHandoffConfig.Builder builderForValue) {
      if (humanAgentHandoffConfigBuilder_ == null) {
        humanAgentHandoffConfig_ = builderForValue.build();
        onChanged();
      } else {
        humanAgentHandoffConfigBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for connecting to a live agent.
     * Currently, this feature is not general available, please contact Google
     * to get access.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.HumanAgentHandoffConfig human_agent_handoff_config = 5;
     * </code>
     */
    public Builder mergeHumanAgentHandoffConfig(
        com.google.cloud.dialogflow.v2.HumanAgentHandoffConfig value) {
      if (humanAgentHandoffConfigBuilder_ == null) {
        if (humanAgentHandoffConfig_ != null) {
          humanAgentHandoffConfig_ =
              com.google.cloud.dialogflow.v2.HumanAgentHandoffConfig.newBuilder(
                      humanAgentHandoffConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          humanAgentHandoffConfig_ = value;
        }
        onChanged();
      } else {
        humanAgentHandoffConfigBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for connecting to a live agent.
     * Currently, this feature is not general available, please contact Google
     * to get access.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.HumanAgentHandoffConfig human_agent_handoff_config = 5;
     * </code>
     */
    public Builder clearHumanAgentHandoffConfig() {
      if (humanAgentHandoffConfigBuilder_ == null) {
        humanAgentHandoffConfig_ = null;
        onChanged();
      } else {
        humanAgentHandoffConfig_ = null;
        humanAgentHandoffConfigBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for connecting to a live agent.
     * Currently, this feature is not general available, please contact Google
     * to get access.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.HumanAgentHandoffConfig human_agent_handoff_config = 5;
     * </code>
     */
    public com.google.cloud.dialogflow.v2.HumanAgentHandoffConfig.Builder
        getHumanAgentHandoffConfigBuilder() {

      onChanged();
      return getHumanAgentHandoffConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for connecting to a live agent.
     * Currently, this feature is not general available, please contact Google
     * to get access.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.HumanAgentHandoffConfig human_agent_handoff_config = 5;
     * </code>
     */
    public com.google.cloud.dialogflow.v2.HumanAgentHandoffConfigOrBuilder
        getHumanAgentHandoffConfigOrBuilder() {
      if (humanAgentHandoffConfigBuilder_ != null) {
        return humanAgentHandoffConfigBuilder_.getMessageOrBuilder();
      } else {
        return humanAgentHandoffConfig_ == null
            ? com.google.cloud.dialogflow.v2.HumanAgentHandoffConfig.getDefaultInstance()
            : humanAgentHandoffConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for connecting to a live agent.
     * Currently, this feature is not general available, please contact Google
     * to get access.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.HumanAgentHandoffConfig human_agent_handoff_config = 5;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2.HumanAgentHandoffConfig,
            com.google.cloud.dialogflow.v2.HumanAgentHandoffConfig.Builder,
            com.google.cloud.dialogflow.v2.HumanAgentHandoffConfigOrBuilder>
        getHumanAgentHandoffConfigFieldBuilder() {
      if (humanAgentHandoffConfigBuilder_ == null) {
        humanAgentHandoffConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2.HumanAgentHandoffConfig,
                com.google.cloud.dialogflow.v2.HumanAgentHandoffConfig.Builder,
                com.google.cloud.dialogflow.v2.HumanAgentHandoffConfigOrBuilder>(
                getHumanAgentHandoffConfig(), getParentForChildren(), isClean());
        humanAgentHandoffConfig_ = null;
      }
      return humanAgentHandoffConfigBuilder_;
    }

    private com.google.cloud.dialogflow.v2.NotificationConfig notificationConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2.NotificationConfig,
            com.google.cloud.dialogflow.v2.NotificationConfig.Builder,
            com.google.cloud.dialogflow.v2.NotificationConfigOrBuilder>
        notificationConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for publishing conversation lifecycle events.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.NotificationConfig notification_config = 6;</code>
     *
     * @return Whether the notificationConfig field is set.
     */
    public boolean hasNotificationConfig() {
      return notificationConfigBuilder_ != null || notificationConfig_ != null;
    }
    /**
     *
     *
     * <pre>
     * Configuration for publishing conversation lifecycle events.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.NotificationConfig notification_config = 6;</code>
     *
     * @return The notificationConfig.
     */
    public com.google.cloud.dialogflow.v2.NotificationConfig getNotificationConfig() {
      if (notificationConfigBuilder_ == null) {
        return notificationConfig_ == null
            ? com.google.cloud.dialogflow.v2.NotificationConfig.getDefaultInstance()
            : notificationConfig_;
      } else {
        return notificationConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for publishing conversation lifecycle events.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.NotificationConfig notification_config = 6;</code>
     */
    public Builder setNotificationConfig(com.google.cloud.dialogflow.v2.NotificationConfig value) {
      if (notificationConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        notificationConfig_ = value;
        onChanged();
      } else {
        notificationConfigBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for publishing conversation lifecycle events.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.NotificationConfig notification_config = 6;</code>
     */
    public Builder setNotificationConfig(
        com.google.cloud.dialogflow.v2.NotificationConfig.Builder builderForValue) {
      if (notificationConfigBuilder_ == null) {
        notificationConfig_ = builderForValue.build();
        onChanged();
      } else {
        notificationConfigBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for publishing conversation lifecycle events.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.NotificationConfig notification_config = 6;</code>
     */
    public Builder mergeNotificationConfig(
        com.google.cloud.dialogflow.v2.NotificationConfig value) {
      if (notificationConfigBuilder_ == null) {
        if (notificationConfig_ != null) {
          notificationConfig_ =
              com.google.cloud.dialogflow.v2.NotificationConfig.newBuilder(notificationConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          notificationConfig_ = value;
        }
        onChanged();
      } else {
        notificationConfigBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for publishing conversation lifecycle events.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.NotificationConfig notification_config = 6;</code>
     */
    public Builder clearNotificationConfig() {
      if (notificationConfigBuilder_ == null) {
        notificationConfig_ = null;
        onChanged();
      } else {
        notificationConfig_ = null;
        notificationConfigBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for publishing conversation lifecycle events.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.NotificationConfig notification_config = 6;</code>
     */
    public com.google.cloud.dialogflow.v2.NotificationConfig.Builder
        getNotificationConfigBuilder() {

      onChanged();
      return getNotificationConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for publishing conversation lifecycle events.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.NotificationConfig notification_config = 6;</code>
     */
    public com.google.cloud.dialogflow.v2.NotificationConfigOrBuilder
        getNotificationConfigOrBuilder() {
      if (notificationConfigBuilder_ != null) {
        return notificationConfigBuilder_.getMessageOrBuilder();
      } else {
        return notificationConfig_ == null
            ? com.google.cloud.dialogflow.v2.NotificationConfig.getDefaultInstance()
            : notificationConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for publishing conversation lifecycle events.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.NotificationConfig notification_config = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2.NotificationConfig,
            com.google.cloud.dialogflow.v2.NotificationConfig.Builder,
            com.google.cloud.dialogflow.v2.NotificationConfigOrBuilder>
        getNotificationConfigFieldBuilder() {
      if (notificationConfigBuilder_ == null) {
        notificationConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2.NotificationConfig,
                com.google.cloud.dialogflow.v2.NotificationConfig.Builder,
                com.google.cloud.dialogflow.v2.NotificationConfigOrBuilder>(
                getNotificationConfig(), getParentForChildren(), isClean());
        notificationConfig_ = null;
      }
      return notificationConfigBuilder_;
    }

    private com.google.cloud.dialogflow.v2.LoggingConfig loggingConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2.LoggingConfig,
            com.google.cloud.dialogflow.v2.LoggingConfig.Builder,
            com.google.cloud.dialogflow.v2.LoggingConfigOrBuilder>
        loggingConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for logging conversation lifecycle events.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.LoggingConfig logging_config = 7;</code>
     *
     * @return Whether the loggingConfig field is set.
     */
    public boolean hasLoggingConfig() {
      return loggingConfigBuilder_ != null || loggingConfig_ != null;
    }
    /**
     *
     *
     * <pre>
     * Configuration for logging conversation lifecycle events.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.LoggingConfig logging_config = 7;</code>
     *
     * @return The loggingConfig.
     */
    public com.google.cloud.dialogflow.v2.LoggingConfig getLoggingConfig() {
      if (loggingConfigBuilder_ == null) {
        return loggingConfig_ == null
            ? com.google.cloud.dialogflow.v2.LoggingConfig.getDefaultInstance()
            : loggingConfig_;
      } else {
        return loggingConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for logging conversation lifecycle events.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.LoggingConfig logging_config = 7;</code>
     */
    public Builder setLoggingConfig(com.google.cloud.dialogflow.v2.LoggingConfig value) {
      if (loggingConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        loggingConfig_ = value;
        onChanged();
      } else {
        loggingConfigBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for logging conversation lifecycle events.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.LoggingConfig logging_config = 7;</code>
     */
    public Builder setLoggingConfig(
        com.google.cloud.dialogflow.v2.LoggingConfig.Builder builderForValue) {
      if (loggingConfigBuilder_ == null) {
        loggingConfig_ = builderForValue.build();
        onChanged();
      } else {
        loggingConfigBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for logging conversation lifecycle events.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.LoggingConfig logging_config = 7;</code>
     */
    public Builder mergeLoggingConfig(com.google.cloud.dialogflow.v2.LoggingConfig value) {
      if (loggingConfigBuilder_ == null) {
        if (loggingConfig_ != null) {
          loggingConfig_ =
              com.google.cloud.dialogflow.v2.LoggingConfig.newBuilder(loggingConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          loggingConfig_ = value;
        }
        onChanged();
      } else {
        loggingConfigBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for logging conversation lifecycle events.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.LoggingConfig logging_config = 7;</code>
     */
    public Builder clearLoggingConfig() {
      if (loggingConfigBuilder_ == null) {
        loggingConfig_ = null;
        onChanged();
      } else {
        loggingConfig_ = null;
        loggingConfigBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for logging conversation lifecycle events.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.LoggingConfig logging_config = 7;</code>
     */
    public com.google.cloud.dialogflow.v2.LoggingConfig.Builder getLoggingConfigBuilder() {

      onChanged();
      return getLoggingConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for logging conversation lifecycle events.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.LoggingConfig logging_config = 7;</code>
     */
    public com.google.cloud.dialogflow.v2.LoggingConfigOrBuilder getLoggingConfigOrBuilder() {
      if (loggingConfigBuilder_ != null) {
        return loggingConfigBuilder_.getMessageOrBuilder();
      } else {
        return loggingConfig_ == null
            ? com.google.cloud.dialogflow.v2.LoggingConfig.getDefaultInstance()
            : loggingConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for logging conversation lifecycle events.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.LoggingConfig logging_config = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2.LoggingConfig,
            com.google.cloud.dialogflow.v2.LoggingConfig.Builder,
            com.google.cloud.dialogflow.v2.LoggingConfigOrBuilder>
        getLoggingConfigFieldBuilder() {
      if (loggingConfigBuilder_ == null) {
        loggingConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2.LoggingConfig,
                com.google.cloud.dialogflow.v2.LoggingConfig.Builder,
                com.google.cloud.dialogflow.v2.LoggingConfigOrBuilder>(
                getLoggingConfig(), getParentForChildren(), isClean());
        loggingConfig_ = null;
      }
      return loggingConfigBuilder_;
    }

    private com.google.cloud.dialogflow.v2.NotificationConfig newMessageEventNotificationConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2.NotificationConfig,
            com.google.cloud.dialogflow.v2.NotificationConfig.Builder,
            com.google.cloud.dialogflow.v2.NotificationConfigOrBuilder>
        newMessageEventNotificationConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for publishing new message events. Event will be sent in
     * format of [ConversationEvent][google.cloud.dialogflow.v2.ConversationEvent]
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.NotificationConfig new_message_event_notification_config = 8;
     * </code>
     *
     * @return Whether the newMessageEventNotificationConfig field is set.
     */
    public boolean hasNewMessageEventNotificationConfig() {
      return newMessageEventNotificationConfigBuilder_ != null
          || newMessageEventNotificationConfig_ != null;
    }
    /**
     *
     *
     * <pre>
     * Configuration for publishing new message events. Event will be sent in
     * format of [ConversationEvent][google.cloud.dialogflow.v2.ConversationEvent]
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.NotificationConfig new_message_event_notification_config = 8;
     * </code>
     *
     * @return The newMessageEventNotificationConfig.
     */
    public com.google.cloud.dialogflow.v2.NotificationConfig
        getNewMessageEventNotificationConfig() {
      if (newMessageEventNotificationConfigBuilder_ == null) {
        return newMessageEventNotificationConfig_ == null
            ? com.google.cloud.dialogflow.v2.NotificationConfig.getDefaultInstance()
            : newMessageEventNotificationConfig_;
      } else {
        return newMessageEventNotificationConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for publishing new message events. Event will be sent in
     * format of [ConversationEvent][google.cloud.dialogflow.v2.ConversationEvent]
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.NotificationConfig new_message_event_notification_config = 8;
     * </code>
     */
    public Builder setNewMessageEventNotificationConfig(
        com.google.cloud.dialogflow.v2.NotificationConfig value) {
      if (newMessageEventNotificationConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        newMessageEventNotificationConfig_ = value;
        onChanged();
      } else {
        newMessageEventNotificationConfigBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for publishing new message events. Event will be sent in
     * format of [ConversationEvent][google.cloud.dialogflow.v2.ConversationEvent]
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.NotificationConfig new_message_event_notification_config = 8;
     * </code>
     */
    public Builder setNewMessageEventNotificationConfig(
        com.google.cloud.dialogflow.v2.NotificationConfig.Builder builderForValue) {
      if (newMessageEventNotificationConfigBuilder_ == null) {
        newMessageEventNotificationConfig_ = builderForValue.build();
        onChanged();
      } else {
        newMessageEventNotificationConfigBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for publishing new message events. Event will be sent in
     * format of [ConversationEvent][google.cloud.dialogflow.v2.ConversationEvent]
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.NotificationConfig new_message_event_notification_config = 8;
     * </code>
     */
    public Builder mergeNewMessageEventNotificationConfig(
        com.google.cloud.dialogflow.v2.NotificationConfig value) {
      if (newMessageEventNotificationConfigBuilder_ == null) {
        if (newMessageEventNotificationConfig_ != null) {
          newMessageEventNotificationConfig_ =
              com.google.cloud.dialogflow.v2.NotificationConfig.newBuilder(
                      newMessageEventNotificationConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          newMessageEventNotificationConfig_ = value;
        }
        onChanged();
      } else {
        newMessageEventNotificationConfigBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for publishing new message events. Event will be sent in
     * format of [ConversationEvent][google.cloud.dialogflow.v2.ConversationEvent]
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.NotificationConfig new_message_event_notification_config = 8;
     * </code>
     */
    public Builder clearNewMessageEventNotificationConfig() {
      if (newMessageEventNotificationConfigBuilder_ == null) {
        newMessageEventNotificationConfig_ = null;
        onChanged();
      } else {
        newMessageEventNotificationConfig_ = null;
        newMessageEventNotificationConfigBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for publishing new message events. Event will be sent in
     * format of [ConversationEvent][google.cloud.dialogflow.v2.ConversationEvent]
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.NotificationConfig new_message_event_notification_config = 8;
     * </code>
     */
    public com.google.cloud.dialogflow.v2.NotificationConfig.Builder
        getNewMessageEventNotificationConfigBuilder() {

      onChanged();
      return getNewMessageEventNotificationConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for publishing new message events. Event will be sent in
     * format of [ConversationEvent][google.cloud.dialogflow.v2.ConversationEvent]
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.NotificationConfig new_message_event_notification_config = 8;
     * </code>
     */
    public com.google.cloud.dialogflow.v2.NotificationConfigOrBuilder
        getNewMessageEventNotificationConfigOrBuilder() {
      if (newMessageEventNotificationConfigBuilder_ != null) {
        return newMessageEventNotificationConfigBuilder_.getMessageOrBuilder();
      } else {
        return newMessageEventNotificationConfig_ == null
            ? com.google.cloud.dialogflow.v2.NotificationConfig.getDefaultInstance()
            : newMessageEventNotificationConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for publishing new message events. Event will be sent in
     * format of [ConversationEvent][google.cloud.dialogflow.v2.ConversationEvent]
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.NotificationConfig new_message_event_notification_config = 8;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2.NotificationConfig,
            com.google.cloud.dialogflow.v2.NotificationConfig.Builder,
            com.google.cloud.dialogflow.v2.NotificationConfigOrBuilder>
        getNewMessageEventNotificationConfigFieldBuilder() {
      if (newMessageEventNotificationConfigBuilder_ == null) {
        newMessageEventNotificationConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2.NotificationConfig,
                com.google.cloud.dialogflow.v2.NotificationConfig.Builder,
                com.google.cloud.dialogflow.v2.NotificationConfigOrBuilder>(
                getNewMessageEventNotificationConfig(), getParentForChildren(), isClean());
        newMessageEventNotificationConfig_ = null;
      }
      return newMessageEventNotificationConfigBuilder_;
    }

    private com.google.cloud.dialogflow.v2.SpeechToTextConfig sttConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2.SpeechToTextConfig,
            com.google.cloud.dialogflow.v2.SpeechToTextConfig.Builder,
            com.google.cloud.dialogflow.v2.SpeechToTextConfigOrBuilder>
        sttConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Settings for speech transcription.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.SpeechToTextConfig stt_config = 9;</code>
     *
     * @return Whether the sttConfig field is set.
     */
    public boolean hasSttConfig() {
      return sttConfigBuilder_ != null || sttConfig_ != null;
    }
    /**
     *
     *
     * <pre>
     * Settings for speech transcription.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.SpeechToTextConfig stt_config = 9;</code>
     *
     * @return The sttConfig.
     */
    public com.google.cloud.dialogflow.v2.SpeechToTextConfig getSttConfig() {
      if (sttConfigBuilder_ == null) {
        return sttConfig_ == null
            ? com.google.cloud.dialogflow.v2.SpeechToTextConfig.getDefaultInstance()
            : sttConfig_;
      } else {
        return sttConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Settings for speech transcription.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.SpeechToTextConfig stt_config = 9;</code>
     */
    public Builder setSttConfig(com.google.cloud.dialogflow.v2.SpeechToTextConfig value) {
      if (sttConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        sttConfig_ = value;
        onChanged();
      } else {
        sttConfigBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for speech transcription.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.SpeechToTextConfig stt_config = 9;</code>
     */
    public Builder setSttConfig(
        com.google.cloud.dialogflow.v2.SpeechToTextConfig.Builder builderForValue) {
      if (sttConfigBuilder_ == null) {
        sttConfig_ = builderForValue.build();
        onChanged();
      } else {
        sttConfigBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for speech transcription.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.SpeechToTextConfig stt_config = 9;</code>
     */
    public Builder mergeSttConfig(com.google.cloud.dialogflow.v2.SpeechToTextConfig value) {
      if (sttConfigBuilder_ == null) {
        if (sttConfig_ != null) {
          sttConfig_ =
              com.google.cloud.dialogflow.v2.SpeechToTextConfig.newBuilder(sttConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          sttConfig_ = value;
        }
        onChanged();
      } else {
        sttConfigBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for speech transcription.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.SpeechToTextConfig stt_config = 9;</code>
     */
    public Builder clearSttConfig() {
      if (sttConfigBuilder_ == null) {
        sttConfig_ = null;
        onChanged();
      } else {
        sttConfig_ = null;
        sttConfigBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for speech transcription.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.SpeechToTextConfig stt_config = 9;</code>
     */
    public com.google.cloud.dialogflow.v2.SpeechToTextConfig.Builder getSttConfigBuilder() {

      onChanged();
      return getSttConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Settings for speech transcription.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.SpeechToTextConfig stt_config = 9;</code>
     */
    public com.google.cloud.dialogflow.v2.SpeechToTextConfigOrBuilder getSttConfigOrBuilder() {
      if (sttConfigBuilder_ != null) {
        return sttConfigBuilder_.getMessageOrBuilder();
      } else {
        return sttConfig_ == null
            ? com.google.cloud.dialogflow.v2.SpeechToTextConfig.getDefaultInstance()
            : sttConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Settings for speech transcription.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.SpeechToTextConfig stt_config = 9;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2.SpeechToTextConfig,
            com.google.cloud.dialogflow.v2.SpeechToTextConfig.Builder,
            com.google.cloud.dialogflow.v2.SpeechToTextConfigOrBuilder>
        getSttConfigFieldBuilder() {
      if (sttConfigBuilder_ == null) {
        sttConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2.SpeechToTextConfig,
                com.google.cloud.dialogflow.v2.SpeechToTextConfig.Builder,
                com.google.cloud.dialogflow.v2.SpeechToTextConfigOrBuilder>(
                getSttConfig(), getParentForChildren(), isClean());
        sttConfig_ = null;
      }
      return sttConfigBuilder_;
    }

    private java.lang.Object languageCode_ = "";
    /**
     *
     *
     * <pre>
     * Language which represents the conversationProfile.
     * If unspecified, the default language code en-us applies. Users need to
     * create a ConversationProfile for each language they want to support.
     * </pre>
     *
     * <code>string language_code = 10;</code>
     *
     * @return The languageCode.
     */
    public java.lang.String getLanguageCode() {
      java.lang.Object ref = languageCode_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        languageCode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Language which represents the conversationProfile.
     * If unspecified, the default language code en-us applies. Users need to
     * create a ConversationProfile for each language they want to support.
     * </pre>
     *
     * <code>string language_code = 10;</code>
     *
     * @return The bytes for languageCode.
     */
    public com.google.protobuf.ByteString getLanguageCodeBytes() {
      java.lang.Object ref = languageCode_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        languageCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Language which represents the conversationProfile.
     * If unspecified, the default language code en-us applies. Users need to
     * create a ConversationProfile for each language they want to support.
     * </pre>
     *
     * <code>string language_code = 10;</code>
     *
     * @param value The languageCode to set.
     * @return This builder for chaining.
     */
    public Builder setLanguageCode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      languageCode_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Language which represents the conversationProfile.
     * If unspecified, the default language code en-us applies. Users need to
     * create a ConversationProfile for each language they want to support.
     * </pre>
     *
     * <code>string language_code = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLanguageCode() {

      languageCode_ = getDefaultInstance().getLanguageCode();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Language which represents the conversationProfile.
     * If unspecified, the default language code en-us applies. Users need to
     * create a ConversationProfile for each language they want to support.
     * </pre>
     *
     * <code>string language_code = 10;</code>
     *
     * @param value The bytes for languageCode to set.
     * @return This builder for chaining.
     */
    public Builder setLanguageCodeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      languageCode_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2.ConversationProfile)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2.ConversationProfile)
  private static final com.google.cloud.dialogflow.v2.ConversationProfile DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2.ConversationProfile();
  }

  public static com.google.cloud.dialogflow.v2.ConversationProfile getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ConversationProfile> PARSER =
      new com.google.protobuf.AbstractParser<ConversationProfile>() {
        @java.lang.Override
        public ConversationProfile parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new ConversationProfile(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<ConversationProfile> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ConversationProfile> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.v2.ConversationProfile getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
