/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/v2/document.proto

package com.google.cloud.dialogflow.v2;

/**
 *
 *
 * <pre>
 * Request message for [Documents.ExportDocument][google.cloud.dialogflow.v2.Documents.ExportDocument].
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.v2.ExportDocumentRequest}
 */
public final class ExportDocumentRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2.ExportDocumentRequest)
    ExportDocumentRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ExportDocumentRequest.newBuilder() to construct.
  private ExportDocumentRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ExportDocumentRequest() {
    name_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ExportDocumentRequest();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.v2.DocumentProto
        .internal_static_google_cloud_dialogflow_v2_ExportDocumentRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.v2.DocumentProto
        .internal_static_google_cloud_dialogflow_v2_ExportDocumentRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.v2.ExportDocumentRequest.class,
            com.google.cloud.dialogflow.v2.ExportDocumentRequest.Builder.class);
  }

  private int destinationCase_ = 0;
  private java.lang.Object destination_;

  public enum DestinationCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    GCS_DESTINATION(2),
    DESTINATION_NOT_SET(0);
    private final int value;

    private DestinationCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DestinationCase valueOf(int value) {
      return forNumber(value);
    }

    public static DestinationCase forNumber(int value) {
      switch (value) {
        case 2:
          return GCS_DESTINATION;
        case 0:
          return DESTINATION_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public DestinationCase getDestinationCase() {
    return DestinationCase.forNumber(destinationCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * Required. The name of the document to export.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
   * ID&gt;/knowledgeBases/&lt;Knowledge Base ID&gt;/documents/&lt;Document ID&gt;`.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The name of the document to export.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
   * ID&gt;/knowledgeBases/&lt;Knowledge Base ID&gt;/documents/&lt;Document ID&gt;`.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int GCS_DESTINATION_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Cloud Storage file path to export the document.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2.GcsDestination gcs_destination = 2;</code>
   *
   * @return Whether the gcsDestination field is set.
   */
  @java.lang.Override
  public boolean hasGcsDestination() {
    return destinationCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Cloud Storage file path to export the document.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2.GcsDestination gcs_destination = 2;</code>
   *
   * @return The gcsDestination.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.GcsDestination getGcsDestination() {
    if (destinationCase_ == 2) {
      return (com.google.cloud.dialogflow.v2.GcsDestination) destination_;
    }
    return com.google.cloud.dialogflow.v2.GcsDestination.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Cloud Storage file path to export the document.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2.GcsDestination gcs_destination = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.GcsDestinationOrBuilder getGcsDestinationOrBuilder() {
    if (destinationCase_ == 2) {
      return (com.google.cloud.dialogflow.v2.GcsDestination) destination_;
    }
    return com.google.cloud.dialogflow.v2.GcsDestination.getDefaultInstance();
  }

  public static final int EXPORT_FULL_CONTENT_FIELD_NUMBER = 3;
  private boolean exportFullContent_;
  /**
   *
   *
   * <pre>
   * When enabled, export the full content of the document including empirical
   * probability.
   * </pre>
   *
   * <code>bool export_full_content = 3;</code>
   *
   * @return The exportFullContent.
   */
  @java.lang.Override
  public boolean getExportFullContent() {
    return exportFullContent_;
  }

  public static final int SMART_MESSAGING_PARTIAL_UPDATE_FIELD_NUMBER = 5;
  private boolean smartMessagingPartialUpdate_;
  /**
   *
   *
   * <pre>
   * When enabled, export the smart messaging allowlist document for partial
   * update.
   * </pre>
   *
   * <code>bool smart_messaging_partial_update = 5;</code>
   *
   * @return The smartMessagingPartialUpdate.
   */
  @java.lang.Override
  public boolean getSmartMessagingPartialUpdate() {
    return smartMessagingPartialUpdate_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (destinationCase_ == 2) {
      output.writeMessage(2, (com.google.cloud.dialogflow.v2.GcsDestination) destination_);
    }
    if (exportFullContent_ != false) {
      output.writeBool(3, exportFullContent_);
    }
    if (smartMessagingPartialUpdate_ != false) {
      output.writeBool(5, smartMessagingPartialUpdate_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (destinationCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.cloud.dialogflow.v2.GcsDestination) destination_);
    }
    if (exportFullContent_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, exportFullContent_);
    }
    if (smartMessagingPartialUpdate_ != false) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(5, smartMessagingPartialUpdate_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.v2.ExportDocumentRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.v2.ExportDocumentRequest other =
        (com.google.cloud.dialogflow.v2.ExportDocumentRequest) obj;

    if (!getName().equals(other.getName())) return false;
    if (getExportFullContent() != other.getExportFullContent()) return false;
    if (getSmartMessagingPartialUpdate() != other.getSmartMessagingPartialUpdate()) return false;
    if (!getDestinationCase().equals(other.getDestinationCase())) return false;
    switch (destinationCase_) {
      case 2:
        if (!getGcsDestination().equals(other.getGcsDestination())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + EXPORT_FULL_CONTENT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getExportFullContent());
    hash = (37 * hash) + SMART_MESSAGING_PARTIAL_UPDATE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSmartMessagingPartialUpdate());
    switch (destinationCase_) {
      case 2:
        hash = (37 * hash) + GCS_DESTINATION_FIELD_NUMBER;
        hash = (53 * hash) + getGcsDestination().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.v2.ExportDocumentRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2.ExportDocumentRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.ExportDocumentRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2.ExportDocumentRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.ExportDocumentRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2.ExportDocumentRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.ExportDocumentRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2.ExportDocumentRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.ExportDocumentRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2.ExportDocumentRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.ExportDocumentRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2.ExportDocumentRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dialogflow.v2.ExportDocumentRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for [Documents.ExportDocument][google.cloud.dialogflow.v2.Documents.ExportDocument].
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2.ExportDocumentRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2.ExportDocumentRequest)
      com.google.cloud.dialogflow.v2.ExportDocumentRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2.DocumentProto
          .internal_static_google_cloud_dialogflow_v2_ExportDocumentRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2.DocumentProto
          .internal_static_google_cloud_dialogflow_v2_ExportDocumentRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2.ExportDocumentRequest.class,
              com.google.cloud.dialogflow.v2.ExportDocumentRequest.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.v2.ExportDocumentRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      if (gcsDestinationBuilder_ != null) {
        gcsDestinationBuilder_.clear();
      }
      exportFullContent_ = false;

      smartMessagingPartialUpdate_ = false;

      destinationCase_ = 0;
      destination_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.v2.DocumentProto
          .internal_static_google_cloud_dialogflow_v2_ExportDocumentRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.ExportDocumentRequest getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.v2.ExportDocumentRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.ExportDocumentRequest build() {
      com.google.cloud.dialogflow.v2.ExportDocumentRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.ExportDocumentRequest buildPartial() {
      com.google.cloud.dialogflow.v2.ExportDocumentRequest result =
          new com.google.cloud.dialogflow.v2.ExportDocumentRequest(this);
      result.name_ = name_;
      if (destinationCase_ == 2) {
        if (gcsDestinationBuilder_ == null) {
          result.destination_ = destination_;
        } else {
          result.destination_ = gcsDestinationBuilder_.build();
        }
      }
      result.exportFullContent_ = exportFullContent_;
      result.smartMessagingPartialUpdate_ = smartMessagingPartialUpdate_;
      result.destinationCase_ = destinationCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.v2.ExportDocumentRequest) {
        return mergeFrom((com.google.cloud.dialogflow.v2.ExportDocumentRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.v2.ExportDocumentRequest other) {
      if (other == com.google.cloud.dialogflow.v2.ExportDocumentRequest.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (other.getExportFullContent() != false) {
        setExportFullContent(other.getExportFullContent());
      }
      if (other.getSmartMessagingPartialUpdate() != false) {
        setSmartMessagingPartialUpdate(other.getSmartMessagingPartialUpdate());
      }
      switch (other.getDestinationCase()) {
        case GCS_DESTINATION:
          {
            mergeGcsDestination(other.getGcsDestination());
            break;
          }
        case DESTINATION_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                input.readMessage(getGcsDestinationFieldBuilder().getBuilder(), extensionRegistry);
                destinationCase_ = 2;
                break;
              } // case 18
            case 24:
              {
                exportFullContent_ = input.readBool();

                break;
              } // case 24
            case 40:
              {
                smartMessagingPartialUpdate_ = input.readBool();

                break;
              } // case 40
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int destinationCase_ = 0;
    private java.lang.Object destination_;

    public DestinationCase getDestinationCase() {
      return DestinationCase.forNumber(destinationCase_);
    }

    public Builder clearDestination() {
      destinationCase_ = 0;
      destination_ = null;
      onChanged();
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. The name of the document to export.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/knowledgeBases/&lt;Knowledge Base ID&gt;/documents/&lt;Document ID&gt;`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the document to export.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/knowledgeBases/&lt;Knowledge Base ID&gt;/documents/&lt;Document ID&gt;`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the document to export.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/knowledgeBases/&lt;Knowledge Base ID&gt;/documents/&lt;Document ID&gt;`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the document to export.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/knowledgeBases/&lt;Knowledge Base ID&gt;/documents/&lt;Document ID&gt;`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the document to export.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/knowledgeBases/&lt;Knowledge Base ID&gt;/documents/&lt;Document ID&gt;`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2.GcsDestination,
            com.google.cloud.dialogflow.v2.GcsDestination.Builder,
            com.google.cloud.dialogflow.v2.GcsDestinationOrBuilder>
        gcsDestinationBuilder_;
    /**
     *
     *
     * <pre>
     * Cloud Storage file path to export the document.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.GcsDestination gcs_destination = 2;</code>
     *
     * @return Whether the gcsDestination field is set.
     */
    @java.lang.Override
    public boolean hasGcsDestination() {
      return destinationCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage file path to export the document.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.GcsDestination gcs_destination = 2;</code>
     *
     * @return The gcsDestination.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2.GcsDestination getGcsDestination() {
      if (gcsDestinationBuilder_ == null) {
        if (destinationCase_ == 2) {
          return (com.google.cloud.dialogflow.v2.GcsDestination) destination_;
        }
        return com.google.cloud.dialogflow.v2.GcsDestination.getDefaultInstance();
      } else {
        if (destinationCase_ == 2) {
          return gcsDestinationBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.v2.GcsDestination.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage file path to export the document.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.GcsDestination gcs_destination = 2;</code>
     */
    public Builder setGcsDestination(com.google.cloud.dialogflow.v2.GcsDestination value) {
      if (gcsDestinationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        destination_ = value;
        onChanged();
      } else {
        gcsDestinationBuilder_.setMessage(value);
      }
      destinationCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage file path to export the document.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.GcsDestination gcs_destination = 2;</code>
     */
    public Builder setGcsDestination(
        com.google.cloud.dialogflow.v2.GcsDestination.Builder builderForValue) {
      if (gcsDestinationBuilder_ == null) {
        destination_ = builderForValue.build();
        onChanged();
      } else {
        gcsDestinationBuilder_.setMessage(builderForValue.build());
      }
      destinationCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage file path to export the document.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.GcsDestination gcs_destination = 2;</code>
     */
    public Builder mergeGcsDestination(com.google.cloud.dialogflow.v2.GcsDestination value) {
      if (gcsDestinationBuilder_ == null) {
        if (destinationCase_ == 2
            && destination_ != com.google.cloud.dialogflow.v2.GcsDestination.getDefaultInstance()) {
          destination_ =
              com.google.cloud.dialogflow.v2.GcsDestination.newBuilder(
                      (com.google.cloud.dialogflow.v2.GcsDestination) destination_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          destination_ = value;
        }
        onChanged();
      } else {
        if (destinationCase_ == 2) {
          gcsDestinationBuilder_.mergeFrom(value);
        } else {
          gcsDestinationBuilder_.setMessage(value);
        }
      }
      destinationCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage file path to export the document.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.GcsDestination gcs_destination = 2;</code>
     */
    public Builder clearGcsDestination() {
      if (gcsDestinationBuilder_ == null) {
        if (destinationCase_ == 2) {
          destinationCase_ = 0;
          destination_ = null;
          onChanged();
        }
      } else {
        if (destinationCase_ == 2) {
          destinationCase_ = 0;
          destination_ = null;
        }
        gcsDestinationBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage file path to export the document.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.GcsDestination gcs_destination = 2;</code>
     */
    public com.google.cloud.dialogflow.v2.GcsDestination.Builder getGcsDestinationBuilder() {
      return getGcsDestinationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage file path to export the document.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.GcsDestination gcs_destination = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2.GcsDestinationOrBuilder getGcsDestinationOrBuilder() {
      if ((destinationCase_ == 2) && (gcsDestinationBuilder_ != null)) {
        return gcsDestinationBuilder_.getMessageOrBuilder();
      } else {
        if (destinationCase_ == 2) {
          return (com.google.cloud.dialogflow.v2.GcsDestination) destination_;
        }
        return com.google.cloud.dialogflow.v2.GcsDestination.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage file path to export the document.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.GcsDestination gcs_destination = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2.GcsDestination,
            com.google.cloud.dialogflow.v2.GcsDestination.Builder,
            com.google.cloud.dialogflow.v2.GcsDestinationOrBuilder>
        getGcsDestinationFieldBuilder() {
      if (gcsDestinationBuilder_ == null) {
        if (!(destinationCase_ == 2)) {
          destination_ = com.google.cloud.dialogflow.v2.GcsDestination.getDefaultInstance();
        }
        gcsDestinationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2.GcsDestination,
                com.google.cloud.dialogflow.v2.GcsDestination.Builder,
                com.google.cloud.dialogflow.v2.GcsDestinationOrBuilder>(
                (com.google.cloud.dialogflow.v2.GcsDestination) destination_,
                getParentForChildren(),
                isClean());
        destination_ = null;
      }
      destinationCase_ = 2;
      onChanged();
      ;
      return gcsDestinationBuilder_;
    }

    private boolean exportFullContent_;
    /**
     *
     *
     * <pre>
     * When enabled, export the full content of the document including empirical
     * probability.
     * </pre>
     *
     * <code>bool export_full_content = 3;</code>
     *
     * @return The exportFullContent.
     */
    @java.lang.Override
    public boolean getExportFullContent() {
      return exportFullContent_;
    }
    /**
     *
     *
     * <pre>
     * When enabled, export the full content of the document including empirical
     * probability.
     * </pre>
     *
     * <code>bool export_full_content = 3;</code>
     *
     * @param value The exportFullContent to set.
     * @return This builder for chaining.
     */
    public Builder setExportFullContent(boolean value) {

      exportFullContent_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * When enabled, export the full content of the document including empirical
     * probability.
     * </pre>
     *
     * <code>bool export_full_content = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExportFullContent() {

      exportFullContent_ = false;
      onChanged();
      return this;
    }

    private boolean smartMessagingPartialUpdate_;
    /**
     *
     *
     * <pre>
     * When enabled, export the smart messaging allowlist document for partial
     * update.
     * </pre>
     *
     * <code>bool smart_messaging_partial_update = 5;</code>
     *
     * @return The smartMessagingPartialUpdate.
     */
    @java.lang.Override
    public boolean getSmartMessagingPartialUpdate() {
      return smartMessagingPartialUpdate_;
    }
    /**
     *
     *
     * <pre>
     * When enabled, export the smart messaging allowlist document for partial
     * update.
     * </pre>
     *
     * <code>bool smart_messaging_partial_update = 5;</code>
     *
     * @param value The smartMessagingPartialUpdate to set.
     * @return This builder for chaining.
     */
    public Builder setSmartMessagingPartialUpdate(boolean value) {

      smartMessagingPartialUpdate_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * When enabled, export the smart messaging allowlist document for partial
     * update.
     * </pre>
     *
     * <code>bool smart_messaging_partial_update = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSmartMessagingPartialUpdate() {

      smartMessagingPartialUpdate_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2.ExportDocumentRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2.ExportDocumentRequest)
  private static final com.google.cloud.dialogflow.v2.ExportDocumentRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2.ExportDocumentRequest();
  }

  public static com.google.cloud.dialogflow.v2.ExportDocumentRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ExportDocumentRequest> PARSER =
      new com.google.protobuf.AbstractParser<ExportDocumentRequest>() {
        @java.lang.Override
        public ExportDocumentRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ExportDocumentRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ExportDocumentRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.v2.ExportDocumentRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
