/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/v2/participant.proto

package com.google.cloud.dialogflow.v2;

/**
 *
 *
 * <pre>
 * The request message for [Participants.AnalyzeContent][google.cloud.dialogflow.v2.Participants.AnalyzeContent].
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.v2.AnalyzeContentRequest}
 */
public final class AnalyzeContentRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2.AnalyzeContentRequest)
    AnalyzeContentRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AnalyzeContentRequest.newBuilder() to construct.
  private AnalyzeContentRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AnalyzeContentRequest() {
    participant_ = "";
    requestId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AnalyzeContentRequest();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private AnalyzeContentRequest(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              participant_ = s;
              break;
            }
          case 42:
            {
              com.google.cloud.dialogflow.v2.OutputAudioConfig.Builder subBuilder = null;
              if (replyAudioConfig_ != null) {
                subBuilder = replyAudioConfig_.toBuilder();
              }
              replyAudioConfig_ =
                  input.readMessage(
                      com.google.cloud.dialogflow.v2.OutputAudioConfig.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(replyAudioConfig_);
                replyAudioConfig_ = subBuilder.buildPartial();
              }

              break;
            }
          case 50:
            {
              com.google.cloud.dialogflow.v2.TextInput.Builder subBuilder = null;
              if (inputCase_ == 6) {
                subBuilder = ((com.google.cloud.dialogflow.v2.TextInput) input_).toBuilder();
              }
              input_ =
                  input.readMessage(
                      com.google.cloud.dialogflow.v2.TextInput.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((com.google.cloud.dialogflow.v2.TextInput) input_);
                input_ = subBuilder.buildPartial();
              }
              inputCase_ = 6;
              break;
            }
          case 66:
            {
              com.google.cloud.dialogflow.v2.EventInput.Builder subBuilder = null;
              if (inputCase_ == 8) {
                subBuilder = ((com.google.cloud.dialogflow.v2.EventInput) input_).toBuilder();
              }
              input_ =
                  input.readMessage(
                      com.google.cloud.dialogflow.v2.EventInput.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((com.google.cloud.dialogflow.v2.EventInput) input_);
                input_ = subBuilder.buildPartial();
              }
              inputCase_ = 8;
              break;
            }
          case 74:
            {
              com.google.cloud.dialogflow.v2.QueryParameters.Builder subBuilder = null;
              if (queryParams_ != null) {
                subBuilder = queryParams_.toBuilder();
              }
              queryParams_ =
                  input.readMessage(
                      com.google.cloud.dialogflow.v2.QueryParameters.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(queryParams_);
                queryParams_ = subBuilder.buildPartial();
              }

              break;
            }
          case 90:
            {
              java.lang.String s = input.readStringRequireUtf8();

              requestId_ = s;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.v2.ParticipantProto
        .internal_static_google_cloud_dialogflow_v2_AnalyzeContentRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.v2.ParticipantProto
        .internal_static_google_cloud_dialogflow_v2_AnalyzeContentRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.v2.AnalyzeContentRequest.class,
            com.google.cloud.dialogflow.v2.AnalyzeContentRequest.Builder.class);
  }

  private int inputCase_ = 0;
  private java.lang.Object input_;

  public enum InputCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    TEXT_INPUT(6),
    EVENT_INPUT(8),
    INPUT_NOT_SET(0);
    private final int value;

    private InputCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static InputCase valueOf(int value) {
      return forNumber(value);
    }

    public static InputCase forNumber(int value) {
      switch (value) {
        case 6:
          return TEXT_INPUT;
        case 8:
          return EVENT_INPUT;
        case 0:
          return INPUT_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public InputCase getInputCase() {
    return InputCase.forNumber(inputCase_);
  }

  public static final int PARTICIPANT_FIELD_NUMBER = 1;
  private volatile java.lang.Object participant_;
  /**
   *
   *
   * <pre>
   * Required. The name of the participant this text comes from.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
   * ID&gt;/conversations/&lt;Conversation ID&gt;/participants/&lt;Participant ID&gt;`.
   * </pre>
   *
   * <code>
   * string participant = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The participant.
   */
  @java.lang.Override
  public java.lang.String getParticipant() {
    java.lang.Object ref = participant_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      participant_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The name of the participant this text comes from.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
   * ID&gt;/conversations/&lt;Conversation ID&gt;/participants/&lt;Participant ID&gt;`.
   * </pre>
   *
   * <code>
   * string participant = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for participant.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParticipantBytes() {
    java.lang.Object ref = participant_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      participant_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TEXT_INPUT_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * The natural language text to be processed.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2.TextInput text_input = 6;</code>
   *
   * @return Whether the textInput field is set.
   */
  @java.lang.Override
  public boolean hasTextInput() {
    return inputCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * The natural language text to be processed.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2.TextInput text_input = 6;</code>
   *
   * @return The textInput.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.TextInput getTextInput() {
    if (inputCase_ == 6) {
      return (com.google.cloud.dialogflow.v2.TextInput) input_;
    }
    return com.google.cloud.dialogflow.v2.TextInput.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The natural language text to be processed.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2.TextInput text_input = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.TextInputOrBuilder getTextInputOrBuilder() {
    if (inputCase_ == 6) {
      return (com.google.cloud.dialogflow.v2.TextInput) input_;
    }
    return com.google.cloud.dialogflow.v2.TextInput.getDefaultInstance();
  }

  public static final int EVENT_INPUT_FIELD_NUMBER = 8;
  /**
   *
   *
   * <pre>
   * An input event to send to Dialogflow.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2.EventInput event_input = 8;</code>
   *
   * @return Whether the eventInput field is set.
   */
  @java.lang.Override
  public boolean hasEventInput() {
    return inputCase_ == 8;
  }
  /**
   *
   *
   * <pre>
   * An input event to send to Dialogflow.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2.EventInput event_input = 8;</code>
   *
   * @return The eventInput.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.EventInput getEventInput() {
    if (inputCase_ == 8) {
      return (com.google.cloud.dialogflow.v2.EventInput) input_;
    }
    return com.google.cloud.dialogflow.v2.EventInput.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * An input event to send to Dialogflow.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2.EventInput event_input = 8;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.EventInputOrBuilder getEventInputOrBuilder() {
    if (inputCase_ == 8) {
      return (com.google.cloud.dialogflow.v2.EventInput) input_;
    }
    return com.google.cloud.dialogflow.v2.EventInput.getDefaultInstance();
  }

  public static final int REPLY_AUDIO_CONFIG_FIELD_NUMBER = 5;
  private com.google.cloud.dialogflow.v2.OutputAudioConfig replyAudioConfig_;
  /**
   *
   *
   * <pre>
   * Speech synthesis configuration.
   * The speech synthesis settings for a virtual agent that may be configured
   * for the associated conversation profile are not used when calling
   * AnalyzeContent. If this configuration is not supplied, speech synthesis
   * is disabled.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2.OutputAudioConfig reply_audio_config = 5;</code>
   *
   * @return Whether the replyAudioConfig field is set.
   */
  @java.lang.Override
  public boolean hasReplyAudioConfig() {
    return replyAudioConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Speech synthesis configuration.
   * The speech synthesis settings for a virtual agent that may be configured
   * for the associated conversation profile are not used when calling
   * AnalyzeContent. If this configuration is not supplied, speech synthesis
   * is disabled.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2.OutputAudioConfig reply_audio_config = 5;</code>
   *
   * @return The replyAudioConfig.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.OutputAudioConfig getReplyAudioConfig() {
    return replyAudioConfig_ == null
        ? com.google.cloud.dialogflow.v2.OutputAudioConfig.getDefaultInstance()
        : replyAudioConfig_;
  }
  /**
   *
   *
   * <pre>
   * Speech synthesis configuration.
   * The speech synthesis settings for a virtual agent that may be configured
   * for the associated conversation profile are not used when calling
   * AnalyzeContent. If this configuration is not supplied, speech synthesis
   * is disabled.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2.OutputAudioConfig reply_audio_config = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.OutputAudioConfigOrBuilder getReplyAudioConfigOrBuilder() {
    return getReplyAudioConfig();
  }

  public static final int QUERY_PARAMS_FIELD_NUMBER = 9;
  private com.google.cloud.dialogflow.v2.QueryParameters queryParams_;
  /**
   *
   *
   * <pre>
   * Parameters for a Dialogflow virtual-agent query.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2.QueryParameters query_params = 9;</code>
   *
   * @return Whether the queryParams field is set.
   */
  @java.lang.Override
  public boolean hasQueryParams() {
    return queryParams_ != null;
  }
  /**
   *
   *
   * <pre>
   * Parameters for a Dialogflow virtual-agent query.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2.QueryParameters query_params = 9;</code>
   *
   * @return The queryParams.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.QueryParameters getQueryParams() {
    return queryParams_ == null
        ? com.google.cloud.dialogflow.v2.QueryParameters.getDefaultInstance()
        : queryParams_;
  }
  /**
   *
   *
   * <pre>
   * Parameters for a Dialogflow virtual-agent query.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2.QueryParameters query_params = 9;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.QueryParametersOrBuilder getQueryParamsOrBuilder() {
    return getQueryParams();
  }

  public static final int REQUEST_ID_FIELD_NUMBER = 11;
  private volatile java.lang.Object requestId_;
  /**
   *
   *
   * <pre>
   * A unique identifier for this request. Restricted to 36 ASCII characters.
   * A random UUID is recommended.
   * This request is only idempotent if a `request_id` is provided.
   * </pre>
   *
   * <code>string request_id = 11;</code>
   *
   * @return The requestId.
   */
  @java.lang.Override
  public java.lang.String getRequestId() {
    java.lang.Object ref = requestId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      requestId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A unique identifier for this request. Restricted to 36 ASCII characters.
   * A random UUID is recommended.
   * This request is only idempotent if a `request_id` is provided.
   * </pre>
   *
   * <code>string request_id = 11;</code>
   *
   * @return The bytes for requestId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRequestIdBytes() {
    java.lang.Object ref = requestId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      requestId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(participant_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, participant_);
    }
    if (replyAudioConfig_ != null) {
      output.writeMessage(5, getReplyAudioConfig());
    }
    if (inputCase_ == 6) {
      output.writeMessage(6, (com.google.cloud.dialogflow.v2.TextInput) input_);
    }
    if (inputCase_ == 8) {
      output.writeMessage(8, (com.google.cloud.dialogflow.v2.EventInput) input_);
    }
    if (queryParams_ != null) {
      output.writeMessage(9, getQueryParams());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requestId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, requestId_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(participant_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, participant_);
    }
    if (replyAudioConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getReplyAudioConfig());
    }
    if (inputCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.cloud.dialogflow.v2.TextInput) input_);
    }
    if (inputCase_ == 8) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              8, (com.google.cloud.dialogflow.v2.EventInput) input_);
    }
    if (queryParams_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getQueryParams());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requestId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, requestId_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.v2.AnalyzeContentRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.v2.AnalyzeContentRequest other =
        (com.google.cloud.dialogflow.v2.AnalyzeContentRequest) obj;

    if (!getParticipant().equals(other.getParticipant())) return false;
    if (hasReplyAudioConfig() != other.hasReplyAudioConfig()) return false;
    if (hasReplyAudioConfig()) {
      if (!getReplyAudioConfig().equals(other.getReplyAudioConfig())) return false;
    }
    if (hasQueryParams() != other.hasQueryParams()) return false;
    if (hasQueryParams()) {
      if (!getQueryParams().equals(other.getQueryParams())) return false;
    }
    if (!getRequestId().equals(other.getRequestId())) return false;
    if (!getInputCase().equals(other.getInputCase())) return false;
    switch (inputCase_) {
      case 6:
        if (!getTextInput().equals(other.getTextInput())) return false;
        break;
      case 8:
        if (!getEventInput().equals(other.getEventInput())) return false;
        break;
      case 0:
      default:
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARTICIPANT_FIELD_NUMBER;
    hash = (53 * hash) + getParticipant().hashCode();
    if (hasReplyAudioConfig()) {
      hash = (37 * hash) + REPLY_AUDIO_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getReplyAudioConfig().hashCode();
    }
    if (hasQueryParams()) {
      hash = (37 * hash) + QUERY_PARAMS_FIELD_NUMBER;
      hash = (53 * hash) + getQueryParams().hashCode();
    }
    hash = (37 * hash) + REQUEST_ID_FIELD_NUMBER;
    hash = (53 * hash) + getRequestId().hashCode();
    switch (inputCase_) {
      case 6:
        hash = (37 * hash) + TEXT_INPUT_FIELD_NUMBER;
        hash = (53 * hash) + getTextInput().hashCode();
        break;
      case 8:
        hash = (37 * hash) + EVENT_INPUT_FIELD_NUMBER;
        hash = (53 * hash) + getEventInput().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.v2.AnalyzeContentRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2.AnalyzeContentRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.AnalyzeContentRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2.AnalyzeContentRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.AnalyzeContentRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2.AnalyzeContentRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.AnalyzeContentRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2.AnalyzeContentRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.AnalyzeContentRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2.AnalyzeContentRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.AnalyzeContentRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2.AnalyzeContentRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dialogflow.v2.AnalyzeContentRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The request message for [Participants.AnalyzeContent][google.cloud.dialogflow.v2.Participants.AnalyzeContent].
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2.AnalyzeContentRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2.AnalyzeContentRequest)
      com.google.cloud.dialogflow.v2.AnalyzeContentRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2.ParticipantProto
          .internal_static_google_cloud_dialogflow_v2_AnalyzeContentRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2.ParticipantProto
          .internal_static_google_cloud_dialogflow_v2_AnalyzeContentRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2.AnalyzeContentRequest.class,
              com.google.cloud.dialogflow.v2.AnalyzeContentRequest.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.v2.AnalyzeContentRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      participant_ = "";

      if (replyAudioConfigBuilder_ == null) {
        replyAudioConfig_ = null;
      } else {
        replyAudioConfig_ = null;
        replyAudioConfigBuilder_ = null;
      }
      if (queryParamsBuilder_ == null) {
        queryParams_ = null;
      } else {
        queryParams_ = null;
        queryParamsBuilder_ = null;
      }
      requestId_ = "";

      inputCase_ = 0;
      input_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.v2.ParticipantProto
          .internal_static_google_cloud_dialogflow_v2_AnalyzeContentRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.AnalyzeContentRequest getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.v2.AnalyzeContentRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.AnalyzeContentRequest build() {
      com.google.cloud.dialogflow.v2.AnalyzeContentRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.AnalyzeContentRequest buildPartial() {
      com.google.cloud.dialogflow.v2.AnalyzeContentRequest result =
          new com.google.cloud.dialogflow.v2.AnalyzeContentRequest(this);
      result.participant_ = participant_;
      if (inputCase_ == 6) {
        if (textInputBuilder_ == null) {
          result.input_ = input_;
        } else {
          result.input_ = textInputBuilder_.build();
        }
      }
      if (inputCase_ == 8) {
        if (eventInputBuilder_ == null) {
          result.input_ = input_;
        } else {
          result.input_ = eventInputBuilder_.build();
        }
      }
      if (replyAudioConfigBuilder_ == null) {
        result.replyAudioConfig_ = replyAudioConfig_;
      } else {
        result.replyAudioConfig_ = replyAudioConfigBuilder_.build();
      }
      if (queryParamsBuilder_ == null) {
        result.queryParams_ = queryParams_;
      } else {
        result.queryParams_ = queryParamsBuilder_.build();
      }
      result.requestId_ = requestId_;
      result.inputCase_ = inputCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.v2.AnalyzeContentRequest) {
        return mergeFrom((com.google.cloud.dialogflow.v2.AnalyzeContentRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.v2.AnalyzeContentRequest other) {
      if (other == com.google.cloud.dialogflow.v2.AnalyzeContentRequest.getDefaultInstance())
        return this;
      if (!other.getParticipant().isEmpty()) {
        participant_ = other.participant_;
        onChanged();
      }
      if (other.hasReplyAudioConfig()) {
        mergeReplyAudioConfig(other.getReplyAudioConfig());
      }
      if (other.hasQueryParams()) {
        mergeQueryParams(other.getQueryParams());
      }
      if (!other.getRequestId().isEmpty()) {
        requestId_ = other.requestId_;
        onChanged();
      }
      switch (other.getInputCase()) {
        case TEXT_INPUT:
          {
            mergeTextInput(other.getTextInput());
            break;
          }
        case EVENT_INPUT:
          {
            mergeEventInput(other.getEventInput());
            break;
          }
        case INPUT_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.dialogflow.v2.AnalyzeContentRequest parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.dialogflow.v2.AnalyzeContentRequest) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int inputCase_ = 0;
    private java.lang.Object input_;

    public InputCase getInputCase() {
      return InputCase.forNumber(inputCase_);
    }

    public Builder clearInput() {
      inputCase_ = 0;
      input_ = null;
      onChanged();
      return this;
    }

    private java.lang.Object participant_ = "";
    /**
     *
     *
     * <pre>
     * Required. The name of the participant this text comes from.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/conversations/&lt;Conversation ID&gt;/participants/&lt;Participant ID&gt;`.
     * </pre>
     *
     * <code>
     * string participant = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The participant.
     */
    public java.lang.String getParticipant() {
      java.lang.Object ref = participant_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        participant_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the participant this text comes from.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/conversations/&lt;Conversation ID&gt;/participants/&lt;Participant ID&gt;`.
     * </pre>
     *
     * <code>
     * string participant = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for participant.
     */
    public com.google.protobuf.ByteString getParticipantBytes() {
      java.lang.Object ref = participant_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        participant_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the participant this text comes from.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/conversations/&lt;Conversation ID&gt;/participants/&lt;Participant ID&gt;`.
     * </pre>
     *
     * <code>
     * string participant = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The participant to set.
     * @return This builder for chaining.
     */
    public Builder setParticipant(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      participant_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the participant this text comes from.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/conversations/&lt;Conversation ID&gt;/participants/&lt;Participant ID&gt;`.
     * </pre>
     *
     * <code>
     * string participant = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParticipant() {

      participant_ = getDefaultInstance().getParticipant();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the participant this text comes from.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/conversations/&lt;Conversation ID&gt;/participants/&lt;Participant ID&gt;`.
     * </pre>
     *
     * <code>
     * string participant = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for participant to set.
     * @return This builder for chaining.
     */
    public Builder setParticipantBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      participant_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2.TextInput,
            com.google.cloud.dialogflow.v2.TextInput.Builder,
            com.google.cloud.dialogflow.v2.TextInputOrBuilder>
        textInputBuilder_;
    /**
     *
     *
     * <pre>
     * The natural language text to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.TextInput text_input = 6;</code>
     *
     * @return Whether the textInput field is set.
     */
    @java.lang.Override
    public boolean hasTextInput() {
      return inputCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * The natural language text to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.TextInput text_input = 6;</code>
     *
     * @return The textInput.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2.TextInput getTextInput() {
      if (textInputBuilder_ == null) {
        if (inputCase_ == 6) {
          return (com.google.cloud.dialogflow.v2.TextInput) input_;
        }
        return com.google.cloud.dialogflow.v2.TextInput.getDefaultInstance();
      } else {
        if (inputCase_ == 6) {
          return textInputBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.v2.TextInput.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The natural language text to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.TextInput text_input = 6;</code>
     */
    public Builder setTextInput(com.google.cloud.dialogflow.v2.TextInput value) {
      if (textInputBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        input_ = value;
        onChanged();
      } else {
        textInputBuilder_.setMessage(value);
      }
      inputCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The natural language text to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.TextInput text_input = 6;</code>
     */
    public Builder setTextInput(com.google.cloud.dialogflow.v2.TextInput.Builder builderForValue) {
      if (textInputBuilder_ == null) {
        input_ = builderForValue.build();
        onChanged();
      } else {
        textInputBuilder_.setMessage(builderForValue.build());
      }
      inputCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The natural language text to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.TextInput text_input = 6;</code>
     */
    public Builder mergeTextInput(com.google.cloud.dialogflow.v2.TextInput value) {
      if (textInputBuilder_ == null) {
        if (inputCase_ == 6
            && input_ != com.google.cloud.dialogflow.v2.TextInput.getDefaultInstance()) {
          input_ =
              com.google.cloud.dialogflow.v2.TextInput.newBuilder(
                      (com.google.cloud.dialogflow.v2.TextInput) input_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          input_ = value;
        }
        onChanged();
      } else {
        if (inputCase_ == 6) {
          textInputBuilder_.mergeFrom(value);
        }
        textInputBuilder_.setMessage(value);
      }
      inputCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The natural language text to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.TextInput text_input = 6;</code>
     */
    public Builder clearTextInput() {
      if (textInputBuilder_ == null) {
        if (inputCase_ == 6) {
          inputCase_ = 0;
          input_ = null;
          onChanged();
        }
      } else {
        if (inputCase_ == 6) {
          inputCase_ = 0;
          input_ = null;
        }
        textInputBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The natural language text to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.TextInput text_input = 6;</code>
     */
    public com.google.cloud.dialogflow.v2.TextInput.Builder getTextInputBuilder() {
      return getTextInputFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The natural language text to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.TextInput text_input = 6;</code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2.TextInputOrBuilder getTextInputOrBuilder() {
      if ((inputCase_ == 6) && (textInputBuilder_ != null)) {
        return textInputBuilder_.getMessageOrBuilder();
      } else {
        if (inputCase_ == 6) {
          return (com.google.cloud.dialogflow.v2.TextInput) input_;
        }
        return com.google.cloud.dialogflow.v2.TextInput.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The natural language text to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.TextInput text_input = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2.TextInput,
            com.google.cloud.dialogflow.v2.TextInput.Builder,
            com.google.cloud.dialogflow.v2.TextInputOrBuilder>
        getTextInputFieldBuilder() {
      if (textInputBuilder_ == null) {
        if (!(inputCase_ == 6)) {
          input_ = com.google.cloud.dialogflow.v2.TextInput.getDefaultInstance();
        }
        textInputBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2.TextInput,
                com.google.cloud.dialogflow.v2.TextInput.Builder,
                com.google.cloud.dialogflow.v2.TextInputOrBuilder>(
                (com.google.cloud.dialogflow.v2.TextInput) input_,
                getParentForChildren(),
                isClean());
        input_ = null;
      }
      inputCase_ = 6;
      onChanged();
      ;
      return textInputBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2.EventInput,
            com.google.cloud.dialogflow.v2.EventInput.Builder,
            com.google.cloud.dialogflow.v2.EventInputOrBuilder>
        eventInputBuilder_;
    /**
     *
     *
     * <pre>
     * An input event to send to Dialogflow.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.EventInput event_input = 8;</code>
     *
     * @return Whether the eventInput field is set.
     */
    @java.lang.Override
    public boolean hasEventInput() {
      return inputCase_ == 8;
    }
    /**
     *
     *
     * <pre>
     * An input event to send to Dialogflow.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.EventInput event_input = 8;</code>
     *
     * @return The eventInput.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2.EventInput getEventInput() {
      if (eventInputBuilder_ == null) {
        if (inputCase_ == 8) {
          return (com.google.cloud.dialogflow.v2.EventInput) input_;
        }
        return com.google.cloud.dialogflow.v2.EventInput.getDefaultInstance();
      } else {
        if (inputCase_ == 8) {
          return eventInputBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.v2.EventInput.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * An input event to send to Dialogflow.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.EventInput event_input = 8;</code>
     */
    public Builder setEventInput(com.google.cloud.dialogflow.v2.EventInput value) {
      if (eventInputBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        input_ = value;
        onChanged();
      } else {
        eventInputBuilder_.setMessage(value);
      }
      inputCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * An input event to send to Dialogflow.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.EventInput event_input = 8;</code>
     */
    public Builder setEventInput(
        com.google.cloud.dialogflow.v2.EventInput.Builder builderForValue) {
      if (eventInputBuilder_ == null) {
        input_ = builderForValue.build();
        onChanged();
      } else {
        eventInputBuilder_.setMessage(builderForValue.build());
      }
      inputCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * An input event to send to Dialogflow.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.EventInput event_input = 8;</code>
     */
    public Builder mergeEventInput(com.google.cloud.dialogflow.v2.EventInput value) {
      if (eventInputBuilder_ == null) {
        if (inputCase_ == 8
            && input_ != com.google.cloud.dialogflow.v2.EventInput.getDefaultInstance()) {
          input_ =
              com.google.cloud.dialogflow.v2.EventInput.newBuilder(
                      (com.google.cloud.dialogflow.v2.EventInput) input_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          input_ = value;
        }
        onChanged();
      } else {
        if (inputCase_ == 8) {
          eventInputBuilder_.mergeFrom(value);
        }
        eventInputBuilder_.setMessage(value);
      }
      inputCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * An input event to send to Dialogflow.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.EventInput event_input = 8;</code>
     */
    public Builder clearEventInput() {
      if (eventInputBuilder_ == null) {
        if (inputCase_ == 8) {
          inputCase_ = 0;
          input_ = null;
          onChanged();
        }
      } else {
        if (inputCase_ == 8) {
          inputCase_ = 0;
          input_ = null;
        }
        eventInputBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An input event to send to Dialogflow.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.EventInput event_input = 8;</code>
     */
    public com.google.cloud.dialogflow.v2.EventInput.Builder getEventInputBuilder() {
      return getEventInputFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * An input event to send to Dialogflow.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.EventInput event_input = 8;</code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2.EventInputOrBuilder getEventInputOrBuilder() {
      if ((inputCase_ == 8) && (eventInputBuilder_ != null)) {
        return eventInputBuilder_.getMessageOrBuilder();
      } else {
        if (inputCase_ == 8) {
          return (com.google.cloud.dialogflow.v2.EventInput) input_;
        }
        return com.google.cloud.dialogflow.v2.EventInput.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * An input event to send to Dialogflow.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.EventInput event_input = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2.EventInput,
            com.google.cloud.dialogflow.v2.EventInput.Builder,
            com.google.cloud.dialogflow.v2.EventInputOrBuilder>
        getEventInputFieldBuilder() {
      if (eventInputBuilder_ == null) {
        if (!(inputCase_ == 8)) {
          input_ = com.google.cloud.dialogflow.v2.EventInput.getDefaultInstance();
        }
        eventInputBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2.EventInput,
                com.google.cloud.dialogflow.v2.EventInput.Builder,
                com.google.cloud.dialogflow.v2.EventInputOrBuilder>(
                (com.google.cloud.dialogflow.v2.EventInput) input_,
                getParentForChildren(),
                isClean());
        input_ = null;
      }
      inputCase_ = 8;
      onChanged();
      ;
      return eventInputBuilder_;
    }

    private com.google.cloud.dialogflow.v2.OutputAudioConfig replyAudioConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2.OutputAudioConfig,
            com.google.cloud.dialogflow.v2.OutputAudioConfig.Builder,
            com.google.cloud.dialogflow.v2.OutputAudioConfigOrBuilder>
        replyAudioConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Speech synthesis configuration.
     * The speech synthesis settings for a virtual agent that may be configured
     * for the associated conversation profile are not used when calling
     * AnalyzeContent. If this configuration is not supplied, speech synthesis
     * is disabled.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.OutputAudioConfig reply_audio_config = 5;</code>
     *
     * @return Whether the replyAudioConfig field is set.
     */
    public boolean hasReplyAudioConfig() {
      return replyAudioConfigBuilder_ != null || replyAudioConfig_ != null;
    }
    /**
     *
     *
     * <pre>
     * Speech synthesis configuration.
     * The speech synthesis settings for a virtual agent that may be configured
     * for the associated conversation profile are not used when calling
     * AnalyzeContent. If this configuration is not supplied, speech synthesis
     * is disabled.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.OutputAudioConfig reply_audio_config = 5;</code>
     *
     * @return The replyAudioConfig.
     */
    public com.google.cloud.dialogflow.v2.OutputAudioConfig getReplyAudioConfig() {
      if (replyAudioConfigBuilder_ == null) {
        return replyAudioConfig_ == null
            ? com.google.cloud.dialogflow.v2.OutputAudioConfig.getDefaultInstance()
            : replyAudioConfig_;
      } else {
        return replyAudioConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Speech synthesis configuration.
     * The speech synthesis settings for a virtual agent that may be configured
     * for the associated conversation profile are not used when calling
     * AnalyzeContent. If this configuration is not supplied, speech synthesis
     * is disabled.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.OutputAudioConfig reply_audio_config = 5;</code>
     */
    public Builder setReplyAudioConfig(com.google.cloud.dialogflow.v2.OutputAudioConfig value) {
      if (replyAudioConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        replyAudioConfig_ = value;
        onChanged();
      } else {
        replyAudioConfigBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Speech synthesis configuration.
     * The speech synthesis settings for a virtual agent that may be configured
     * for the associated conversation profile are not used when calling
     * AnalyzeContent. If this configuration is not supplied, speech synthesis
     * is disabled.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.OutputAudioConfig reply_audio_config = 5;</code>
     */
    public Builder setReplyAudioConfig(
        com.google.cloud.dialogflow.v2.OutputAudioConfig.Builder builderForValue) {
      if (replyAudioConfigBuilder_ == null) {
        replyAudioConfig_ = builderForValue.build();
        onChanged();
      } else {
        replyAudioConfigBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Speech synthesis configuration.
     * The speech synthesis settings for a virtual agent that may be configured
     * for the associated conversation profile are not used when calling
     * AnalyzeContent. If this configuration is not supplied, speech synthesis
     * is disabled.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.OutputAudioConfig reply_audio_config = 5;</code>
     */
    public Builder mergeReplyAudioConfig(com.google.cloud.dialogflow.v2.OutputAudioConfig value) {
      if (replyAudioConfigBuilder_ == null) {
        if (replyAudioConfig_ != null) {
          replyAudioConfig_ =
              com.google.cloud.dialogflow.v2.OutputAudioConfig.newBuilder(replyAudioConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          replyAudioConfig_ = value;
        }
        onChanged();
      } else {
        replyAudioConfigBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Speech synthesis configuration.
     * The speech synthesis settings for a virtual agent that may be configured
     * for the associated conversation profile are not used when calling
     * AnalyzeContent. If this configuration is not supplied, speech synthesis
     * is disabled.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.OutputAudioConfig reply_audio_config = 5;</code>
     */
    public Builder clearReplyAudioConfig() {
      if (replyAudioConfigBuilder_ == null) {
        replyAudioConfig_ = null;
        onChanged();
      } else {
        replyAudioConfig_ = null;
        replyAudioConfigBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Speech synthesis configuration.
     * The speech synthesis settings for a virtual agent that may be configured
     * for the associated conversation profile are not used when calling
     * AnalyzeContent. If this configuration is not supplied, speech synthesis
     * is disabled.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.OutputAudioConfig reply_audio_config = 5;</code>
     */
    public com.google.cloud.dialogflow.v2.OutputAudioConfig.Builder getReplyAudioConfigBuilder() {

      onChanged();
      return getReplyAudioConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Speech synthesis configuration.
     * The speech synthesis settings for a virtual agent that may be configured
     * for the associated conversation profile are not used when calling
     * AnalyzeContent. If this configuration is not supplied, speech synthesis
     * is disabled.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.OutputAudioConfig reply_audio_config = 5;</code>
     */
    public com.google.cloud.dialogflow.v2.OutputAudioConfigOrBuilder
        getReplyAudioConfigOrBuilder() {
      if (replyAudioConfigBuilder_ != null) {
        return replyAudioConfigBuilder_.getMessageOrBuilder();
      } else {
        return replyAudioConfig_ == null
            ? com.google.cloud.dialogflow.v2.OutputAudioConfig.getDefaultInstance()
            : replyAudioConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Speech synthesis configuration.
     * The speech synthesis settings for a virtual agent that may be configured
     * for the associated conversation profile are not used when calling
     * AnalyzeContent. If this configuration is not supplied, speech synthesis
     * is disabled.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.OutputAudioConfig reply_audio_config = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2.OutputAudioConfig,
            com.google.cloud.dialogflow.v2.OutputAudioConfig.Builder,
            com.google.cloud.dialogflow.v2.OutputAudioConfigOrBuilder>
        getReplyAudioConfigFieldBuilder() {
      if (replyAudioConfigBuilder_ == null) {
        replyAudioConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2.OutputAudioConfig,
                com.google.cloud.dialogflow.v2.OutputAudioConfig.Builder,
                com.google.cloud.dialogflow.v2.OutputAudioConfigOrBuilder>(
                getReplyAudioConfig(), getParentForChildren(), isClean());
        replyAudioConfig_ = null;
      }
      return replyAudioConfigBuilder_;
    }

    private com.google.cloud.dialogflow.v2.QueryParameters queryParams_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2.QueryParameters,
            com.google.cloud.dialogflow.v2.QueryParameters.Builder,
            com.google.cloud.dialogflow.v2.QueryParametersOrBuilder>
        queryParamsBuilder_;
    /**
     *
     *
     * <pre>
     * Parameters for a Dialogflow virtual-agent query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.QueryParameters query_params = 9;</code>
     *
     * @return Whether the queryParams field is set.
     */
    public boolean hasQueryParams() {
      return queryParamsBuilder_ != null || queryParams_ != null;
    }
    /**
     *
     *
     * <pre>
     * Parameters for a Dialogflow virtual-agent query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.QueryParameters query_params = 9;</code>
     *
     * @return The queryParams.
     */
    public com.google.cloud.dialogflow.v2.QueryParameters getQueryParams() {
      if (queryParamsBuilder_ == null) {
        return queryParams_ == null
            ? com.google.cloud.dialogflow.v2.QueryParameters.getDefaultInstance()
            : queryParams_;
      } else {
        return queryParamsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Parameters for a Dialogflow virtual-agent query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.QueryParameters query_params = 9;</code>
     */
    public Builder setQueryParams(com.google.cloud.dialogflow.v2.QueryParameters value) {
      if (queryParamsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        queryParams_ = value;
        onChanged();
      } else {
        queryParamsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters for a Dialogflow virtual-agent query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.QueryParameters query_params = 9;</code>
     */
    public Builder setQueryParams(
        com.google.cloud.dialogflow.v2.QueryParameters.Builder builderForValue) {
      if (queryParamsBuilder_ == null) {
        queryParams_ = builderForValue.build();
        onChanged();
      } else {
        queryParamsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters for a Dialogflow virtual-agent query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.QueryParameters query_params = 9;</code>
     */
    public Builder mergeQueryParams(com.google.cloud.dialogflow.v2.QueryParameters value) {
      if (queryParamsBuilder_ == null) {
        if (queryParams_ != null) {
          queryParams_ =
              com.google.cloud.dialogflow.v2.QueryParameters.newBuilder(queryParams_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          queryParams_ = value;
        }
        onChanged();
      } else {
        queryParamsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters for a Dialogflow virtual-agent query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.QueryParameters query_params = 9;</code>
     */
    public Builder clearQueryParams() {
      if (queryParamsBuilder_ == null) {
        queryParams_ = null;
        onChanged();
      } else {
        queryParams_ = null;
        queryParamsBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters for a Dialogflow virtual-agent query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.QueryParameters query_params = 9;</code>
     */
    public com.google.cloud.dialogflow.v2.QueryParameters.Builder getQueryParamsBuilder() {

      onChanged();
      return getQueryParamsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Parameters for a Dialogflow virtual-agent query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.QueryParameters query_params = 9;</code>
     */
    public com.google.cloud.dialogflow.v2.QueryParametersOrBuilder getQueryParamsOrBuilder() {
      if (queryParamsBuilder_ != null) {
        return queryParamsBuilder_.getMessageOrBuilder();
      } else {
        return queryParams_ == null
            ? com.google.cloud.dialogflow.v2.QueryParameters.getDefaultInstance()
            : queryParams_;
      }
    }
    /**
     *
     *
     * <pre>
     * Parameters for a Dialogflow virtual-agent query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.QueryParameters query_params = 9;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2.QueryParameters,
            com.google.cloud.dialogflow.v2.QueryParameters.Builder,
            com.google.cloud.dialogflow.v2.QueryParametersOrBuilder>
        getQueryParamsFieldBuilder() {
      if (queryParamsBuilder_ == null) {
        queryParamsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2.QueryParameters,
                com.google.cloud.dialogflow.v2.QueryParameters.Builder,
                com.google.cloud.dialogflow.v2.QueryParametersOrBuilder>(
                getQueryParams(), getParentForChildren(), isClean());
        queryParams_ = null;
      }
      return queryParamsBuilder_;
    }

    private java.lang.Object requestId_ = "";
    /**
     *
     *
     * <pre>
     * A unique identifier for this request. Restricted to 36 ASCII characters.
     * A random UUID is recommended.
     * This request is only idempotent if a `request_id` is provided.
     * </pre>
     *
     * <code>string request_id = 11;</code>
     *
     * @return The requestId.
     */
    public java.lang.String getRequestId() {
      java.lang.Object ref = requestId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        requestId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A unique identifier for this request. Restricted to 36 ASCII characters.
     * A random UUID is recommended.
     * This request is only idempotent if a `request_id` is provided.
     * </pre>
     *
     * <code>string request_id = 11;</code>
     *
     * @return The bytes for requestId.
     */
    public com.google.protobuf.ByteString getRequestIdBytes() {
      java.lang.Object ref = requestId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        requestId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A unique identifier for this request. Restricted to 36 ASCII characters.
     * A random UUID is recommended.
     * This request is only idempotent if a `request_id` is provided.
     * </pre>
     *
     * <code>string request_id = 11;</code>
     *
     * @param value The requestId to set.
     * @return This builder for chaining.
     */
    public Builder setRequestId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      requestId_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A unique identifier for this request. Restricted to 36 ASCII characters.
     * A random UUID is recommended.
     * This request is only idempotent if a `request_id` is provided.
     * </pre>
     *
     * <code>string request_id = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRequestId() {

      requestId_ = getDefaultInstance().getRequestId();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A unique identifier for this request. Restricted to 36 ASCII characters.
     * A random UUID is recommended.
     * This request is only idempotent if a `request_id` is provided.
     * </pre>
     *
     * <code>string request_id = 11;</code>
     *
     * @param value The bytes for requestId to set.
     * @return This builder for chaining.
     */
    public Builder setRequestIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      requestId_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2.AnalyzeContentRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2.AnalyzeContentRequest)
  private static final com.google.cloud.dialogflow.v2.AnalyzeContentRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2.AnalyzeContentRequest();
  }

  public static com.google.cloud.dialogflow.v2.AnalyzeContentRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AnalyzeContentRequest> PARSER =
      new com.google.protobuf.AbstractParser<AnalyzeContentRequest>() {
        @java.lang.Override
        public AnalyzeContentRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new AnalyzeContentRequest(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<AnalyzeContentRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AnalyzeContentRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.v2.AnalyzeContentRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
