/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/v2/participant.proto

package com.google.cloud.dialogflow.v2;

/**
 *
 *
 * <pre>
 * Represents a message posted into a conversation.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.v2.Message}
 */
public final class Message extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2.Message)
    MessageOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Message.newBuilder() to construct.
  private Message(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Message() {
    name_ = "";
    content_ = "";
    languageCode_ = "";
    participant_ = "";
    participantRole_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Message();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.v2.ParticipantProto
        .internal_static_google_cloud_dialogflow_v2_Message_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.v2.ParticipantProto
        .internal_static_google_cloud_dialogflow_v2_Message_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.v2.Message.class,
            com.google.cloud.dialogflow.v2.Message.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The unique identifier of the message.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
   * ID&gt;/conversations/&lt;Conversation ID&gt;/messages/&lt;Message ID&gt;`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The unique identifier of the message.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
   * ID&gt;/conversations/&lt;Conversation ID&gt;/messages/&lt;Message ID&gt;`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONTENT_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object content_ = "";
  /**
   *
   *
   * <pre>
   * Required. The message content.
   * </pre>
   *
   * <code>string content = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The content.
   */
  @java.lang.Override
  public java.lang.String getContent() {
    java.lang.Object ref = content_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      content_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The message content.
   * </pre>
   *
   * <code>string content = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for content.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getContentBytes() {
    java.lang.Object ref = content_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      content_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LANGUAGE_CODE_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object languageCode_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The message language.
   * This should be a [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt)
   * language tag. Example: "en-US".
   * </pre>
   *
   * <code>string language_code = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The languageCode.
   */
  @java.lang.Override
  public java.lang.String getLanguageCode() {
    java.lang.Object ref = languageCode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      languageCode_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The message language.
   * This should be a [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt)
   * language tag. Example: "en-US".
   * </pre>
   *
   * <code>string language_code = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for languageCode.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLanguageCodeBytes() {
    java.lang.Object ref = languageCode_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      languageCode_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PARTICIPANT_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object participant_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The participant that sends this message.
   * </pre>
   *
   * <code>string participant = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The participant.
   */
  @java.lang.Override
  public java.lang.String getParticipant() {
    java.lang.Object ref = participant_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      participant_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The participant that sends this message.
   * </pre>
   *
   * <code>string participant = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for participant.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParticipantBytes() {
    java.lang.Object ref = participant_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      participant_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PARTICIPANT_ROLE_FIELD_NUMBER = 5;
  private int participantRole_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The role of the participant.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2.Participant.Role participant_role = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for participantRole.
   */
  @java.lang.Override
  public int getParticipantRoleValue() {
    return participantRole_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The role of the participant.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2.Participant.Role participant_role = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The participantRole.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.Participant.Role getParticipantRole() {
    com.google.cloud.dialogflow.v2.Participant.Role result =
        com.google.cloud.dialogflow.v2.Participant.Role.forNumber(participantRole_);
    return result == null ? com.google.cloud.dialogflow.v2.Participant.Role.UNRECOGNIZED : result;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 6;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time when the message was created in Contact Center AI.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time when the message was created in Contact Center AI.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time when the message was created in Contact Center AI.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int SEND_TIME_FIELD_NUMBER = 9;
  private com.google.protobuf.Timestamp sendTime_;
  /**
   *
   *
   * <pre>
   * Optional. The time when the message was sent.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp send_time = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the sendTime field is set.
   */
  @java.lang.Override
  public boolean hasSendTime() {
    return sendTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. The time when the message was sent.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp send_time = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The sendTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getSendTime() {
    return sendTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : sendTime_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The time when the message was sent.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp send_time = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getSendTimeOrBuilder() {
    return sendTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : sendTime_;
  }

  public static final int MESSAGE_ANNOTATION_FIELD_NUMBER = 7;
  private com.google.cloud.dialogflow.v2.MessageAnnotation messageAnnotation_;
  /**
   *
   *
   * <pre>
   * Output only. The annotation for the message.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2.MessageAnnotation message_annotation = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the messageAnnotation field is set.
   */
  @java.lang.Override
  public boolean hasMessageAnnotation() {
    return messageAnnotation_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The annotation for the message.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2.MessageAnnotation message_annotation = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The messageAnnotation.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.MessageAnnotation getMessageAnnotation() {
    return messageAnnotation_ == null
        ? com.google.cloud.dialogflow.v2.MessageAnnotation.getDefaultInstance()
        : messageAnnotation_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The annotation for the message.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2.MessageAnnotation message_annotation = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.MessageAnnotationOrBuilder getMessageAnnotationOrBuilder() {
    return messageAnnotation_ == null
        ? com.google.cloud.dialogflow.v2.MessageAnnotation.getDefaultInstance()
        : messageAnnotation_;
  }

  public static final int SENTIMENT_ANALYSIS_FIELD_NUMBER = 8;
  private com.google.cloud.dialogflow.v2.SentimentAnalysisResult sentimentAnalysis_;
  /**
   *
   *
   * <pre>
   * Output only. The sentiment analysis result for the message.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2.SentimentAnalysisResult sentiment_analysis = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the sentimentAnalysis field is set.
   */
  @java.lang.Override
  public boolean hasSentimentAnalysis() {
    return sentimentAnalysis_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The sentiment analysis result for the message.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2.SentimentAnalysisResult sentiment_analysis = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The sentimentAnalysis.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.SentimentAnalysisResult getSentimentAnalysis() {
    return sentimentAnalysis_ == null
        ? com.google.cloud.dialogflow.v2.SentimentAnalysisResult.getDefaultInstance()
        : sentimentAnalysis_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The sentiment analysis result for the message.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2.SentimentAnalysisResult sentiment_analysis = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.SentimentAnalysisResultOrBuilder
      getSentimentAnalysisOrBuilder() {
    return sentimentAnalysis_ == null
        ? com.google.cloud.dialogflow.v2.SentimentAnalysisResult.getDefaultInstance()
        : sentimentAnalysis_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(content_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, content_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(languageCode_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, languageCode_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(participant_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, participant_);
    }
    if (participantRole_
        != com.google.cloud.dialogflow.v2.Participant.Role.ROLE_UNSPECIFIED.getNumber()) {
      output.writeEnum(5, participantRole_);
    }
    if (createTime_ != null) {
      output.writeMessage(6, getCreateTime());
    }
    if (messageAnnotation_ != null) {
      output.writeMessage(7, getMessageAnnotation());
    }
    if (sentimentAnalysis_ != null) {
      output.writeMessage(8, getSentimentAnalysis());
    }
    if (sendTime_ != null) {
      output.writeMessage(9, getSendTime());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(content_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, content_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(languageCode_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, languageCode_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(participant_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, participant_);
    }
    if (participantRole_
        != com.google.cloud.dialogflow.v2.Participant.Role.ROLE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, participantRole_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getCreateTime());
    }
    if (messageAnnotation_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getMessageAnnotation());
    }
    if (sentimentAnalysis_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getSentimentAnalysis());
    }
    if (sendTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getSendTime());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.v2.Message)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.v2.Message other = (com.google.cloud.dialogflow.v2.Message) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getContent().equals(other.getContent())) return false;
    if (!getLanguageCode().equals(other.getLanguageCode())) return false;
    if (!getParticipant().equals(other.getParticipant())) return false;
    if (participantRole_ != other.participantRole_) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasSendTime() != other.hasSendTime()) return false;
    if (hasSendTime()) {
      if (!getSendTime().equals(other.getSendTime())) return false;
    }
    if (hasMessageAnnotation() != other.hasMessageAnnotation()) return false;
    if (hasMessageAnnotation()) {
      if (!getMessageAnnotation().equals(other.getMessageAnnotation())) return false;
    }
    if (hasSentimentAnalysis() != other.hasSentimentAnalysis()) return false;
    if (hasSentimentAnalysis()) {
      if (!getSentimentAnalysis().equals(other.getSentimentAnalysis())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + CONTENT_FIELD_NUMBER;
    hash = (53 * hash) + getContent().hashCode();
    hash = (37 * hash) + LANGUAGE_CODE_FIELD_NUMBER;
    hash = (53 * hash) + getLanguageCode().hashCode();
    hash = (37 * hash) + PARTICIPANT_FIELD_NUMBER;
    hash = (53 * hash) + getParticipant().hashCode();
    hash = (37 * hash) + PARTICIPANT_ROLE_FIELD_NUMBER;
    hash = (53 * hash) + participantRole_;
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasSendTime()) {
      hash = (37 * hash) + SEND_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getSendTime().hashCode();
    }
    if (hasMessageAnnotation()) {
      hash = (37 * hash) + MESSAGE_ANNOTATION_FIELD_NUMBER;
      hash = (53 * hash) + getMessageAnnotation().hashCode();
    }
    if (hasSentimentAnalysis()) {
      hash = (37 * hash) + SENTIMENT_ANALYSIS_FIELD_NUMBER;
      hash = (53 * hash) + getSentimentAnalysis().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.v2.Message parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2.Message parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.Message parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2.Message parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.Message parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2.Message parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.Message parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2.Message parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.Message parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2.Message parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.Message parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2.Message parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dialogflow.v2.Message prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents a message posted into a conversation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2.Message}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2.Message)
      com.google.cloud.dialogflow.v2.MessageOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2.ParticipantProto
          .internal_static_google_cloud_dialogflow_v2_Message_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2.ParticipantProto
          .internal_static_google_cloud_dialogflow_v2_Message_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2.Message.class,
              com.google.cloud.dialogflow.v2.Message.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.v2.Message.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      content_ = "";
      languageCode_ = "";
      participant_ = "";
      participantRole_ = 0;
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      sendTime_ = null;
      if (sendTimeBuilder_ != null) {
        sendTimeBuilder_.dispose();
        sendTimeBuilder_ = null;
      }
      messageAnnotation_ = null;
      if (messageAnnotationBuilder_ != null) {
        messageAnnotationBuilder_.dispose();
        messageAnnotationBuilder_ = null;
      }
      sentimentAnalysis_ = null;
      if (sentimentAnalysisBuilder_ != null) {
        sentimentAnalysisBuilder_.dispose();
        sentimentAnalysisBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.v2.ParticipantProto
          .internal_static_google_cloud_dialogflow_v2_Message_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.Message getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.v2.Message.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.Message build() {
      com.google.cloud.dialogflow.v2.Message result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.Message buildPartial() {
      com.google.cloud.dialogflow.v2.Message result =
          new com.google.cloud.dialogflow.v2.Message(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.dialogflow.v2.Message result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.content_ = content_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.languageCode_ = languageCode_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.participant_ = participant_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.participantRole_ = participantRole_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.sendTime_ = sendTimeBuilder_ == null ? sendTime_ : sendTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.messageAnnotation_ =
            messageAnnotationBuilder_ == null
                ? messageAnnotation_
                : messageAnnotationBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.sentimentAnalysis_ =
            sentimentAnalysisBuilder_ == null
                ? sentimentAnalysis_
                : sentimentAnalysisBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.v2.Message) {
        return mergeFrom((com.google.cloud.dialogflow.v2.Message) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.v2.Message other) {
      if (other == com.google.cloud.dialogflow.v2.Message.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getContent().isEmpty()) {
        content_ = other.content_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getLanguageCode().isEmpty()) {
        languageCode_ = other.languageCode_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getParticipant().isEmpty()) {
        participant_ = other.participant_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.participantRole_ != 0) {
        setParticipantRoleValue(other.getParticipantRoleValue());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasSendTime()) {
        mergeSendTime(other.getSendTime());
      }
      if (other.hasMessageAnnotation()) {
        mergeMessageAnnotation(other.getMessageAnnotation());
      }
      if (other.hasSentimentAnalysis()) {
        mergeSentimentAnalysis(other.getSentimentAnalysis());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                content_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                languageCode_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                participant_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 40:
              {
                participantRole_ = input.readEnum();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            case 50:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(
                    getMessageAnnotationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(
                    getSentimentAnalysisFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(getSendTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 74
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The unique identifier of the message.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/conversations/&lt;Conversation ID&gt;/messages/&lt;Message ID&gt;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The unique identifier of the message.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/conversations/&lt;Conversation ID&gt;/messages/&lt;Message ID&gt;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The unique identifier of the message.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/conversations/&lt;Conversation ID&gt;/messages/&lt;Message ID&gt;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The unique identifier of the message.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/conversations/&lt;Conversation ID&gt;/messages/&lt;Message ID&gt;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The unique identifier of the message.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/conversations/&lt;Conversation ID&gt;/messages/&lt;Message ID&gt;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object content_ = "";
    /**
     *
     *
     * <pre>
     * Required. The message content.
     * </pre>
     *
     * <code>string content = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The content.
     */
    public java.lang.String getContent() {
      java.lang.Object ref = content_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        content_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The message content.
     * </pre>
     *
     * <code>string content = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for content.
     */
    public com.google.protobuf.ByteString getContentBytes() {
      java.lang.Object ref = content_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        content_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The message content.
     * </pre>
     *
     * <code>string content = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The content to set.
     * @return This builder for chaining.
     */
    public Builder setContent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      content_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The message content.
     * </pre>
     *
     * <code>string content = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearContent() {
      content_ = getDefaultInstance().getContent();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The message content.
     * </pre>
     *
     * <code>string content = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for content to set.
     * @return This builder for chaining.
     */
    public Builder setContentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      content_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object languageCode_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The message language.
     * This should be a [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt)
     * language tag. Example: "en-US".
     * </pre>
     *
     * <code>string language_code = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The languageCode.
     */
    public java.lang.String getLanguageCode() {
      java.lang.Object ref = languageCode_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        languageCode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The message language.
     * This should be a [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt)
     * language tag. Example: "en-US".
     * </pre>
     *
     * <code>string language_code = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for languageCode.
     */
    public com.google.protobuf.ByteString getLanguageCodeBytes() {
      java.lang.Object ref = languageCode_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        languageCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The message language.
     * This should be a [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt)
     * language tag. Example: "en-US".
     * </pre>
     *
     * <code>string language_code = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The languageCode to set.
     * @return This builder for chaining.
     */
    public Builder setLanguageCode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      languageCode_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The message language.
     * This should be a [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt)
     * language tag. Example: "en-US".
     * </pre>
     *
     * <code>string language_code = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLanguageCode() {
      languageCode_ = getDefaultInstance().getLanguageCode();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The message language.
     * This should be a [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt)
     * language tag. Example: "en-US".
     * </pre>
     *
     * <code>string language_code = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for languageCode to set.
     * @return This builder for chaining.
     */
    public Builder setLanguageCodeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      languageCode_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object participant_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The participant that sends this message.
     * </pre>
     *
     * <code>string participant = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The participant.
     */
    public java.lang.String getParticipant() {
      java.lang.Object ref = participant_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        participant_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The participant that sends this message.
     * </pre>
     *
     * <code>string participant = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for participant.
     */
    public com.google.protobuf.ByteString getParticipantBytes() {
      java.lang.Object ref = participant_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        participant_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The participant that sends this message.
     * </pre>
     *
     * <code>string participant = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The participant to set.
     * @return This builder for chaining.
     */
    public Builder setParticipant(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      participant_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The participant that sends this message.
     * </pre>
     *
     * <code>string participant = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParticipant() {
      participant_ = getDefaultInstance().getParticipant();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The participant that sends this message.
     * </pre>
     *
     * <code>string participant = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for participant to set.
     * @return This builder for chaining.
     */
    public Builder setParticipantBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      participant_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private int participantRole_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The role of the participant.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.Participant.Role participant_role = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for participantRole.
     */
    @java.lang.Override
    public int getParticipantRoleValue() {
      return participantRole_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The role of the participant.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.Participant.Role participant_role = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for participantRole to set.
     * @return This builder for chaining.
     */
    public Builder setParticipantRoleValue(int value) {
      participantRole_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The role of the participant.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.Participant.Role participant_role = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The participantRole.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2.Participant.Role getParticipantRole() {
      com.google.cloud.dialogflow.v2.Participant.Role result =
          com.google.cloud.dialogflow.v2.Participant.Role.forNumber(participantRole_);
      return result == null ? com.google.cloud.dialogflow.v2.Participant.Role.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The role of the participant.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.Participant.Role participant_role = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The participantRole to set.
     * @return This builder for chaining.
     */
    public Builder setParticipantRole(com.google.cloud.dialogflow.v2.Participant.Role value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000010;
      participantRole_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The role of the participant.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.Participant.Role participant_role = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParticipantRole() {
      bitField0_ = (bitField0_ & ~0x00000010);
      participantRole_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time when the message was created in Contact Center AI.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the message was created in Contact Center AI.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the message was created in Contact Center AI.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the message was created in Contact Center AI.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the message was created in Contact Center AI.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the message was created in Contact Center AI.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000020);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the message was created in Contact Center AI.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the message was created in Contact Center AI.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the message was created in Contact Center AI.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp sendTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        sendTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The time when the message was sent.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp send_time = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the sendTime field is set.
     */
    public boolean hasSendTime() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The time when the message was sent.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp send_time = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The sendTime.
     */
    public com.google.protobuf.Timestamp getSendTime() {
      if (sendTimeBuilder_ == null) {
        return sendTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : sendTime_;
      } else {
        return sendTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The time when the message was sent.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp send_time = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSendTime(com.google.protobuf.Timestamp value) {
      if (sendTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        sendTime_ = value;
      } else {
        sendTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The time when the message was sent.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp send_time = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSendTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (sendTimeBuilder_ == null) {
        sendTime_ = builderForValue.build();
      } else {
        sendTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The time when the message was sent.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp send_time = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeSendTime(com.google.protobuf.Timestamp value) {
      if (sendTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && sendTime_ != null
            && sendTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getSendTimeBuilder().mergeFrom(value);
        } else {
          sendTime_ = value;
        }
      } else {
        sendTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The time when the message was sent.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp send_time = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearSendTime() {
      bitField0_ = (bitField0_ & ~0x00000040);
      sendTime_ = null;
      if (sendTimeBuilder_ != null) {
        sendTimeBuilder_.dispose();
        sendTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The time when the message was sent.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp send_time = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getSendTimeBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getSendTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The time when the message was sent.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp send_time = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getSendTimeOrBuilder() {
      if (sendTimeBuilder_ != null) {
        return sendTimeBuilder_.getMessageOrBuilder();
      } else {
        return sendTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : sendTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The time when the message was sent.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp send_time = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getSendTimeFieldBuilder() {
      if (sendTimeBuilder_ == null) {
        sendTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getSendTime(), getParentForChildren(), isClean());
        sendTime_ = null;
      }
      return sendTimeBuilder_;
    }

    private com.google.cloud.dialogflow.v2.MessageAnnotation messageAnnotation_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2.MessageAnnotation,
            com.google.cloud.dialogflow.v2.MessageAnnotation.Builder,
            com.google.cloud.dialogflow.v2.MessageAnnotationOrBuilder>
        messageAnnotationBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The annotation for the message.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.MessageAnnotation message_annotation = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the messageAnnotation field is set.
     */
    public boolean hasMessageAnnotation() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The annotation for the message.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.MessageAnnotation message_annotation = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The messageAnnotation.
     */
    public com.google.cloud.dialogflow.v2.MessageAnnotation getMessageAnnotation() {
      if (messageAnnotationBuilder_ == null) {
        return messageAnnotation_ == null
            ? com.google.cloud.dialogflow.v2.MessageAnnotation.getDefaultInstance()
            : messageAnnotation_;
      } else {
        return messageAnnotationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The annotation for the message.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.MessageAnnotation message_annotation = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setMessageAnnotation(com.google.cloud.dialogflow.v2.MessageAnnotation value) {
      if (messageAnnotationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        messageAnnotation_ = value;
      } else {
        messageAnnotationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The annotation for the message.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.MessageAnnotation message_annotation = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setMessageAnnotation(
        com.google.cloud.dialogflow.v2.MessageAnnotation.Builder builderForValue) {
      if (messageAnnotationBuilder_ == null) {
        messageAnnotation_ = builderForValue.build();
      } else {
        messageAnnotationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The annotation for the message.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.MessageAnnotation message_annotation = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeMessageAnnotation(com.google.cloud.dialogflow.v2.MessageAnnotation value) {
      if (messageAnnotationBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && messageAnnotation_ != null
            && messageAnnotation_
                != com.google.cloud.dialogflow.v2.MessageAnnotation.getDefaultInstance()) {
          getMessageAnnotationBuilder().mergeFrom(value);
        } else {
          messageAnnotation_ = value;
        }
      } else {
        messageAnnotationBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The annotation for the message.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.MessageAnnotation message_annotation = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearMessageAnnotation() {
      bitField0_ = (bitField0_ & ~0x00000080);
      messageAnnotation_ = null;
      if (messageAnnotationBuilder_ != null) {
        messageAnnotationBuilder_.dispose();
        messageAnnotationBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The annotation for the message.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.MessageAnnotation message_annotation = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dialogflow.v2.MessageAnnotation.Builder getMessageAnnotationBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getMessageAnnotationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The annotation for the message.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.MessageAnnotation message_annotation = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dialogflow.v2.MessageAnnotationOrBuilder
        getMessageAnnotationOrBuilder() {
      if (messageAnnotationBuilder_ != null) {
        return messageAnnotationBuilder_.getMessageOrBuilder();
      } else {
        return messageAnnotation_ == null
            ? com.google.cloud.dialogflow.v2.MessageAnnotation.getDefaultInstance()
            : messageAnnotation_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The annotation for the message.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.MessageAnnotation message_annotation = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2.MessageAnnotation,
            com.google.cloud.dialogflow.v2.MessageAnnotation.Builder,
            com.google.cloud.dialogflow.v2.MessageAnnotationOrBuilder>
        getMessageAnnotationFieldBuilder() {
      if (messageAnnotationBuilder_ == null) {
        messageAnnotationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2.MessageAnnotation,
                com.google.cloud.dialogflow.v2.MessageAnnotation.Builder,
                com.google.cloud.dialogflow.v2.MessageAnnotationOrBuilder>(
                getMessageAnnotation(), getParentForChildren(), isClean());
        messageAnnotation_ = null;
      }
      return messageAnnotationBuilder_;
    }

    private com.google.cloud.dialogflow.v2.SentimentAnalysisResult sentimentAnalysis_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2.SentimentAnalysisResult,
            com.google.cloud.dialogflow.v2.SentimentAnalysisResult.Builder,
            com.google.cloud.dialogflow.v2.SentimentAnalysisResultOrBuilder>
        sentimentAnalysisBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The sentiment analysis result for the message.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.SentimentAnalysisResult sentiment_analysis = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the sentimentAnalysis field is set.
     */
    public boolean hasSentimentAnalysis() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The sentiment analysis result for the message.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.SentimentAnalysisResult sentiment_analysis = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The sentimentAnalysis.
     */
    public com.google.cloud.dialogflow.v2.SentimentAnalysisResult getSentimentAnalysis() {
      if (sentimentAnalysisBuilder_ == null) {
        return sentimentAnalysis_ == null
            ? com.google.cloud.dialogflow.v2.SentimentAnalysisResult.getDefaultInstance()
            : sentimentAnalysis_;
      } else {
        return sentimentAnalysisBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The sentiment analysis result for the message.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.SentimentAnalysisResult sentiment_analysis = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setSentimentAnalysis(
        com.google.cloud.dialogflow.v2.SentimentAnalysisResult value) {
      if (sentimentAnalysisBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        sentimentAnalysis_ = value;
      } else {
        sentimentAnalysisBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The sentiment analysis result for the message.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.SentimentAnalysisResult sentiment_analysis = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setSentimentAnalysis(
        com.google.cloud.dialogflow.v2.SentimentAnalysisResult.Builder builderForValue) {
      if (sentimentAnalysisBuilder_ == null) {
        sentimentAnalysis_ = builderForValue.build();
      } else {
        sentimentAnalysisBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The sentiment analysis result for the message.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.SentimentAnalysisResult sentiment_analysis = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeSentimentAnalysis(
        com.google.cloud.dialogflow.v2.SentimentAnalysisResult value) {
      if (sentimentAnalysisBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && sentimentAnalysis_ != null
            && sentimentAnalysis_
                != com.google.cloud.dialogflow.v2.SentimentAnalysisResult.getDefaultInstance()) {
          getSentimentAnalysisBuilder().mergeFrom(value);
        } else {
          sentimentAnalysis_ = value;
        }
      } else {
        sentimentAnalysisBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The sentiment analysis result for the message.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.SentimentAnalysisResult sentiment_analysis = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearSentimentAnalysis() {
      bitField0_ = (bitField0_ & ~0x00000100);
      sentimentAnalysis_ = null;
      if (sentimentAnalysisBuilder_ != null) {
        sentimentAnalysisBuilder_.dispose();
        sentimentAnalysisBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The sentiment analysis result for the message.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.SentimentAnalysisResult sentiment_analysis = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dialogflow.v2.SentimentAnalysisResult.Builder
        getSentimentAnalysisBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getSentimentAnalysisFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The sentiment analysis result for the message.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.SentimentAnalysisResult sentiment_analysis = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dialogflow.v2.SentimentAnalysisResultOrBuilder
        getSentimentAnalysisOrBuilder() {
      if (sentimentAnalysisBuilder_ != null) {
        return sentimentAnalysisBuilder_.getMessageOrBuilder();
      } else {
        return sentimentAnalysis_ == null
            ? com.google.cloud.dialogflow.v2.SentimentAnalysisResult.getDefaultInstance()
            : sentimentAnalysis_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The sentiment analysis result for the message.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.SentimentAnalysisResult sentiment_analysis = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2.SentimentAnalysisResult,
            com.google.cloud.dialogflow.v2.SentimentAnalysisResult.Builder,
            com.google.cloud.dialogflow.v2.SentimentAnalysisResultOrBuilder>
        getSentimentAnalysisFieldBuilder() {
      if (sentimentAnalysisBuilder_ == null) {
        sentimentAnalysisBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2.SentimentAnalysisResult,
                com.google.cloud.dialogflow.v2.SentimentAnalysisResult.Builder,
                com.google.cloud.dialogflow.v2.SentimentAnalysisResultOrBuilder>(
                getSentimentAnalysis(), getParentForChildren(), isClean());
        sentimentAnalysis_ = null;
      }
      return sentimentAnalysisBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2.Message)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2.Message)
  private static final com.google.cloud.dialogflow.v2.Message DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2.Message();
  }

  public static com.google.cloud.dialogflow.v2.Message getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Message> PARSER =
      new com.google.protobuf.AbstractParser<Message>() {
        @java.lang.Override
        public Message parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Message> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Message> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.v2.Message getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
