/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/v2/conversation_model.proto

package com.google.cloud.dialogflow.v2;

/**
 *
 *
 * <pre>
 * The evaluation metrics for smart reply model.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.v2.SmartReplyMetrics}
 */
public final class SmartReplyMetrics extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2.SmartReplyMetrics)
    SmartReplyMetricsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SmartReplyMetrics.newBuilder() to construct.
  private SmartReplyMetrics(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SmartReplyMetrics() {
    topNMetrics_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SmartReplyMetrics();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.v2.ConversationModelProto
        .internal_static_google_cloud_dialogflow_v2_SmartReplyMetrics_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.v2.ConversationModelProto
        .internal_static_google_cloud_dialogflow_v2_SmartReplyMetrics_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.v2.SmartReplyMetrics.class,
            com.google.cloud.dialogflow.v2.SmartReplyMetrics.Builder.class);
  }

  public interface TopNMetricsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Number of retrieved smart replies. For example, when `n` is 3, this
     * evaluation contains metrics for when Dialogflow retrieves 3 smart replies
     * with the model.
     * </pre>
     *
     * <code>int32 n = 1;</code>
     *
     * @return The n.
     */
    int getN();

    /**
     *
     *
     * <pre>
     * Defined as `number of queries whose top n smart replies have at least one
     * similar (token match similarity above the defined threshold) reply as the
     * real reply` divided by `number of queries with at least one smart reply`.
     * Value ranges from 0.0 to 1.0 inclusive.
     * </pre>
     *
     * <code>float recall = 2;</code>
     *
     * @return The recall.
     */
    float getRecall();
  }
  /**
   *
   *
   * <pre>
   * Evaluation metrics when retrieving `n` smart replies with the model.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics}
   */
  public static final class TopNMetrics extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics)
      TopNMetricsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use TopNMetrics.newBuilder() to construct.
    private TopNMetrics(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private TopNMetrics() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new TopNMetrics();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2.ConversationModelProto
          .internal_static_google_cloud_dialogflow_v2_SmartReplyMetrics_TopNMetrics_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2.ConversationModelProto
          .internal_static_google_cloud_dialogflow_v2_SmartReplyMetrics_TopNMetrics_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics.class,
              com.google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics.Builder.class);
    }

    public static final int N_FIELD_NUMBER = 1;
    private int n_ = 0;
    /**
     *
     *
     * <pre>
     * Number of retrieved smart replies. For example, when `n` is 3, this
     * evaluation contains metrics for when Dialogflow retrieves 3 smart replies
     * with the model.
     * </pre>
     *
     * <code>int32 n = 1;</code>
     *
     * @return The n.
     */
    @java.lang.Override
    public int getN() {
      return n_;
    }

    public static final int RECALL_FIELD_NUMBER = 2;
    private float recall_ = 0F;
    /**
     *
     *
     * <pre>
     * Defined as `number of queries whose top n smart replies have at least one
     * similar (token match similarity above the defined threshold) reply as the
     * real reply` divided by `number of queries with at least one smart reply`.
     * Value ranges from 0.0 to 1.0 inclusive.
     * </pre>
     *
     * <code>float recall = 2;</code>
     *
     * @return The recall.
     */
    @java.lang.Override
    public float getRecall() {
      return recall_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (n_ != 0) {
        output.writeInt32(1, n_);
      }
      if (java.lang.Float.floatToRawIntBits(recall_) != 0) {
        output.writeFloat(2, recall_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (n_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, n_);
      }
      if (java.lang.Float.floatToRawIntBits(recall_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(2, recall_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics other =
          (com.google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics) obj;

      if (getN() != other.getN()) return false;
      if (java.lang.Float.floatToIntBits(getRecall())
          != java.lang.Float.floatToIntBits(other.getRecall())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + N_FIELD_NUMBER;
      hash = (53 * hash) + getN();
      hash = (37 * hash) + RECALL_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getRecall());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Evaluation metrics when retrieving `n` smart replies with the model.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics)
        com.google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetricsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.v2.ConversationModelProto
            .internal_static_google_cloud_dialogflow_v2_SmartReplyMetrics_TopNMetrics_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.v2.ConversationModelProto
            .internal_static_google_cloud_dialogflow_v2_SmartReplyMetrics_TopNMetrics_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics.class,
                com.google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics.Builder.class);
      }

      // Construct using com.google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        n_ = 0;
        recall_ = 0F;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.v2.ConversationModelProto
            .internal_static_google_cloud_dialogflow_v2_SmartReplyMetrics_TopNMetrics_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics build() {
        com.google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics buildPartial() {
        com.google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics result =
            new com.google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.n_ = n_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.recall_ = recall_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics) {
          return mergeFrom((com.google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics other) {
        if (other
            == com.google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics.getDefaultInstance())
          return this;
        if (other.getN() != 0) {
          setN(other.getN());
        }
        if (other.getRecall() != 0F) {
          setRecall(other.getRecall());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  n_ = input.readInt32();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 21:
                {
                  recall_ = input.readFloat();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 21
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int n_;
      /**
       *
       *
       * <pre>
       * Number of retrieved smart replies. For example, when `n` is 3, this
       * evaluation contains metrics for when Dialogflow retrieves 3 smart replies
       * with the model.
       * </pre>
       *
       * <code>int32 n = 1;</code>
       *
       * @return The n.
       */
      @java.lang.Override
      public int getN() {
        return n_;
      }
      /**
       *
       *
       * <pre>
       * Number of retrieved smart replies. For example, when `n` is 3, this
       * evaluation contains metrics for when Dialogflow retrieves 3 smart replies
       * with the model.
       * </pre>
       *
       * <code>int32 n = 1;</code>
       *
       * @param value The n to set.
       * @return This builder for chaining.
       */
      public Builder setN(int value) {

        n_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Number of retrieved smart replies. For example, when `n` is 3, this
       * evaluation contains metrics for when Dialogflow retrieves 3 smart replies
       * with the model.
       * </pre>
       *
       * <code>int32 n = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearN() {
        bitField0_ = (bitField0_ & ~0x00000001);
        n_ = 0;
        onChanged();
        return this;
      }

      private float recall_;
      /**
       *
       *
       * <pre>
       * Defined as `number of queries whose top n smart replies have at least one
       * similar (token match similarity above the defined threshold) reply as the
       * real reply` divided by `number of queries with at least one smart reply`.
       * Value ranges from 0.0 to 1.0 inclusive.
       * </pre>
       *
       * <code>float recall = 2;</code>
       *
       * @return The recall.
       */
      @java.lang.Override
      public float getRecall() {
        return recall_;
      }
      /**
       *
       *
       * <pre>
       * Defined as `number of queries whose top n smart replies have at least one
       * similar (token match similarity above the defined threshold) reply as the
       * real reply` divided by `number of queries with at least one smart reply`.
       * Value ranges from 0.0 to 1.0 inclusive.
       * </pre>
       *
       * <code>float recall = 2;</code>
       *
       * @param value The recall to set.
       * @return This builder for chaining.
       */
      public Builder setRecall(float value) {

        recall_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Defined as `number of queries whose top n smart replies have at least one
       * similar (token match similarity above the defined threshold) reply as the
       * real reply` divided by `number of queries with at least one smart reply`.
       * Value ranges from 0.0 to 1.0 inclusive.
       * </pre>
       *
       * <code>float recall = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRecall() {
        bitField0_ = (bitField0_ & ~0x00000002);
        recall_ = 0F;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics)
    private static final com.google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics();
    }

    public static com.google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<TopNMetrics> PARSER =
        new com.google.protobuf.AbstractParser<TopNMetrics>() {
          @java.lang.Override
          public TopNMetrics parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<TopNMetrics> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<TopNMetrics> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int ALLOWLIST_COVERAGE_FIELD_NUMBER = 1;
  private float allowlistCoverage_ = 0F;
  /**
   *
   *
   * <pre>
   * Percentage of target participant messages in the evaluation dataset for
   * which similar messages have appeared at least once in the allowlist. Should
   * be [0, 1].
   * </pre>
   *
   * <code>float allowlist_coverage = 1;</code>
   *
   * @return The allowlistCoverage.
   */
  @java.lang.Override
  public float getAllowlistCoverage() {
    return allowlistCoverage_;
  }

  public static final int TOP_N_METRICS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics> topNMetrics_;
  /**
   *
   *
   * <pre>
   * Metrics of top n smart replies, sorted by [TopNMetric.n][].
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics top_n_metrics = 2;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics>
      getTopNMetricsList() {
    return topNMetrics_;
  }
  /**
   *
   *
   * <pre>
   * Metrics of top n smart replies, sorted by [TopNMetric.n][].
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics top_n_metrics = 2;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetricsOrBuilder>
      getTopNMetricsOrBuilderList() {
    return topNMetrics_;
  }
  /**
   *
   *
   * <pre>
   * Metrics of top n smart replies, sorted by [TopNMetric.n][].
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics top_n_metrics = 2;
   * </code>
   */
  @java.lang.Override
  public int getTopNMetricsCount() {
    return topNMetrics_.size();
  }
  /**
   *
   *
   * <pre>
   * Metrics of top n smart replies, sorted by [TopNMetric.n][].
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics top_n_metrics = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics getTopNMetrics(int index) {
    return topNMetrics_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Metrics of top n smart replies, sorted by [TopNMetric.n][].
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics top_n_metrics = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetricsOrBuilder
      getTopNMetricsOrBuilder(int index) {
    return topNMetrics_.get(index);
  }

  public static final int CONVERSATION_COUNT_FIELD_NUMBER = 3;
  private long conversationCount_ = 0L;
  /**
   *
   *
   * <pre>
   * Total number of conversations used to generate this metric.
   * </pre>
   *
   * <code>int64 conversation_count = 3;</code>
   *
   * @return The conversationCount.
   */
  @java.lang.Override
  public long getConversationCount() {
    return conversationCount_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (java.lang.Float.floatToRawIntBits(allowlistCoverage_) != 0) {
      output.writeFloat(1, allowlistCoverage_);
    }
    for (int i = 0; i < topNMetrics_.size(); i++) {
      output.writeMessage(2, topNMetrics_.get(i));
    }
    if (conversationCount_ != 0L) {
      output.writeInt64(3, conversationCount_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (java.lang.Float.floatToRawIntBits(allowlistCoverage_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeFloatSize(1, allowlistCoverage_);
    }
    for (int i = 0; i < topNMetrics_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, topNMetrics_.get(i));
    }
    if (conversationCount_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(3, conversationCount_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.v2.SmartReplyMetrics)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.v2.SmartReplyMetrics other =
        (com.google.cloud.dialogflow.v2.SmartReplyMetrics) obj;

    if (java.lang.Float.floatToIntBits(getAllowlistCoverage())
        != java.lang.Float.floatToIntBits(other.getAllowlistCoverage())) return false;
    if (!getTopNMetricsList().equals(other.getTopNMetricsList())) return false;
    if (getConversationCount() != other.getConversationCount()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ALLOWLIST_COVERAGE_FIELD_NUMBER;
    hash = (53 * hash) + java.lang.Float.floatToIntBits(getAllowlistCoverage());
    if (getTopNMetricsCount() > 0) {
      hash = (37 * hash) + TOP_N_METRICS_FIELD_NUMBER;
      hash = (53 * hash) + getTopNMetricsList().hashCode();
    }
    hash = (37 * hash) + CONVERSATION_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getConversationCount());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.v2.SmartReplyMetrics parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2.SmartReplyMetrics parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.SmartReplyMetrics parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2.SmartReplyMetrics parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.SmartReplyMetrics parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2.SmartReplyMetrics parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.SmartReplyMetrics parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2.SmartReplyMetrics parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.SmartReplyMetrics parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2.SmartReplyMetrics parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.SmartReplyMetrics parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2.SmartReplyMetrics parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dialogflow.v2.SmartReplyMetrics prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The evaluation metrics for smart reply model.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2.SmartReplyMetrics}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2.SmartReplyMetrics)
      com.google.cloud.dialogflow.v2.SmartReplyMetricsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2.ConversationModelProto
          .internal_static_google_cloud_dialogflow_v2_SmartReplyMetrics_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2.ConversationModelProto
          .internal_static_google_cloud_dialogflow_v2_SmartReplyMetrics_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2.SmartReplyMetrics.class,
              com.google.cloud.dialogflow.v2.SmartReplyMetrics.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.v2.SmartReplyMetrics.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      allowlistCoverage_ = 0F;
      if (topNMetricsBuilder_ == null) {
        topNMetrics_ = java.util.Collections.emptyList();
      } else {
        topNMetrics_ = null;
        topNMetricsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      conversationCount_ = 0L;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.v2.ConversationModelProto
          .internal_static_google_cloud_dialogflow_v2_SmartReplyMetrics_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.SmartReplyMetrics getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.v2.SmartReplyMetrics.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.SmartReplyMetrics build() {
      com.google.cloud.dialogflow.v2.SmartReplyMetrics result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.SmartReplyMetrics buildPartial() {
      com.google.cloud.dialogflow.v2.SmartReplyMetrics result =
          new com.google.cloud.dialogflow.v2.SmartReplyMetrics(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.dialogflow.v2.SmartReplyMetrics result) {
      if (topNMetricsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          topNMetrics_ = java.util.Collections.unmodifiableList(topNMetrics_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.topNMetrics_ = topNMetrics_;
      } else {
        result.topNMetrics_ = topNMetricsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.dialogflow.v2.SmartReplyMetrics result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.allowlistCoverage_ = allowlistCoverage_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.conversationCount_ = conversationCount_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.v2.SmartReplyMetrics) {
        return mergeFrom((com.google.cloud.dialogflow.v2.SmartReplyMetrics) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.v2.SmartReplyMetrics other) {
      if (other == com.google.cloud.dialogflow.v2.SmartReplyMetrics.getDefaultInstance())
        return this;
      if (other.getAllowlistCoverage() != 0F) {
        setAllowlistCoverage(other.getAllowlistCoverage());
      }
      if (topNMetricsBuilder_ == null) {
        if (!other.topNMetrics_.isEmpty()) {
          if (topNMetrics_.isEmpty()) {
            topNMetrics_ = other.topNMetrics_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureTopNMetricsIsMutable();
            topNMetrics_.addAll(other.topNMetrics_);
          }
          onChanged();
        }
      } else {
        if (!other.topNMetrics_.isEmpty()) {
          if (topNMetricsBuilder_.isEmpty()) {
            topNMetricsBuilder_.dispose();
            topNMetricsBuilder_ = null;
            topNMetrics_ = other.topNMetrics_;
            bitField0_ = (bitField0_ & ~0x00000002);
            topNMetricsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getTopNMetricsFieldBuilder()
                    : null;
          } else {
            topNMetricsBuilder_.addAllMessages(other.topNMetrics_);
          }
        }
      }
      if (other.getConversationCount() != 0L) {
        setConversationCount(other.getConversationCount());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 13:
              {
                allowlistCoverage_ = input.readFloat();
                bitField0_ |= 0x00000001;
                break;
              } // case 13
            case 18:
              {
                com.google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics m =
                    input.readMessage(
                        com.google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics.parser(),
                        extensionRegistry);
                if (topNMetricsBuilder_ == null) {
                  ensureTopNMetricsIsMutable();
                  topNMetrics_.add(m);
                } else {
                  topNMetricsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 24:
              {
                conversationCount_ = input.readInt64();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private float allowlistCoverage_;
    /**
     *
     *
     * <pre>
     * Percentage of target participant messages in the evaluation dataset for
     * which similar messages have appeared at least once in the allowlist. Should
     * be [0, 1].
     * </pre>
     *
     * <code>float allowlist_coverage = 1;</code>
     *
     * @return The allowlistCoverage.
     */
    @java.lang.Override
    public float getAllowlistCoverage() {
      return allowlistCoverage_;
    }
    /**
     *
     *
     * <pre>
     * Percentage of target participant messages in the evaluation dataset for
     * which similar messages have appeared at least once in the allowlist. Should
     * be [0, 1].
     * </pre>
     *
     * <code>float allowlist_coverage = 1;</code>
     *
     * @param value The allowlistCoverage to set.
     * @return This builder for chaining.
     */
    public Builder setAllowlistCoverage(float value) {

      allowlistCoverage_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Percentage of target participant messages in the evaluation dataset for
     * which similar messages have appeared at least once in the allowlist. Should
     * be [0, 1].
     * </pre>
     *
     * <code>float allowlist_coverage = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAllowlistCoverage() {
      bitField0_ = (bitField0_ & ~0x00000001);
      allowlistCoverage_ = 0F;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics>
        topNMetrics_ = java.util.Collections.emptyList();

    private void ensureTopNMetricsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        topNMetrics_ =
            new java.util.ArrayList<com.google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics>(
                topNMetrics_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics,
            com.google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics.Builder,
            com.google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetricsOrBuilder>
        topNMetricsBuilder_;

    /**
     *
     *
     * <pre>
     * Metrics of top n smart replies, sorted by [TopNMetric.n][].
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics top_n_metrics = 2;
     * </code>
     */
    public java.util.List<com.google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics>
        getTopNMetricsList() {
      if (topNMetricsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(topNMetrics_);
      } else {
        return topNMetricsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Metrics of top n smart replies, sorted by [TopNMetric.n][].
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics top_n_metrics = 2;
     * </code>
     */
    public int getTopNMetricsCount() {
      if (topNMetricsBuilder_ == null) {
        return topNMetrics_.size();
      } else {
        return topNMetricsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Metrics of top n smart replies, sorted by [TopNMetric.n][].
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics top_n_metrics = 2;
     * </code>
     */
    public com.google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics getTopNMetrics(int index) {
      if (topNMetricsBuilder_ == null) {
        return topNMetrics_.get(index);
      } else {
        return topNMetricsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Metrics of top n smart replies, sorted by [TopNMetric.n][].
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics top_n_metrics = 2;
     * </code>
     */
    public Builder setTopNMetrics(
        int index, com.google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics value) {
      if (topNMetricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTopNMetricsIsMutable();
        topNMetrics_.set(index, value);
        onChanged();
      } else {
        topNMetricsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metrics of top n smart replies, sorted by [TopNMetric.n][].
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics top_n_metrics = 2;
     * </code>
     */
    public Builder setTopNMetrics(
        int index,
        com.google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics.Builder builderForValue) {
      if (topNMetricsBuilder_ == null) {
        ensureTopNMetricsIsMutable();
        topNMetrics_.set(index, builderForValue.build());
        onChanged();
      } else {
        topNMetricsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metrics of top n smart replies, sorted by [TopNMetric.n][].
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics top_n_metrics = 2;
     * </code>
     */
    public Builder addTopNMetrics(
        com.google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics value) {
      if (topNMetricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTopNMetricsIsMutable();
        topNMetrics_.add(value);
        onChanged();
      } else {
        topNMetricsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metrics of top n smart replies, sorted by [TopNMetric.n][].
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics top_n_metrics = 2;
     * </code>
     */
    public Builder addTopNMetrics(
        int index, com.google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics value) {
      if (topNMetricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTopNMetricsIsMutable();
        topNMetrics_.add(index, value);
        onChanged();
      } else {
        topNMetricsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metrics of top n smart replies, sorted by [TopNMetric.n][].
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics top_n_metrics = 2;
     * </code>
     */
    public Builder addTopNMetrics(
        com.google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics.Builder builderForValue) {
      if (topNMetricsBuilder_ == null) {
        ensureTopNMetricsIsMutable();
        topNMetrics_.add(builderForValue.build());
        onChanged();
      } else {
        topNMetricsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metrics of top n smart replies, sorted by [TopNMetric.n][].
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics top_n_metrics = 2;
     * </code>
     */
    public Builder addTopNMetrics(
        int index,
        com.google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics.Builder builderForValue) {
      if (topNMetricsBuilder_ == null) {
        ensureTopNMetricsIsMutable();
        topNMetrics_.add(index, builderForValue.build());
        onChanged();
      } else {
        topNMetricsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metrics of top n smart replies, sorted by [TopNMetric.n][].
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics top_n_metrics = 2;
     * </code>
     */
    public Builder addAllTopNMetrics(
        java.lang.Iterable<? extends com.google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics>
            values) {
      if (topNMetricsBuilder_ == null) {
        ensureTopNMetricsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, topNMetrics_);
        onChanged();
      } else {
        topNMetricsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metrics of top n smart replies, sorted by [TopNMetric.n][].
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics top_n_metrics = 2;
     * </code>
     */
    public Builder clearTopNMetrics() {
      if (topNMetricsBuilder_ == null) {
        topNMetrics_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        topNMetricsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metrics of top n smart replies, sorted by [TopNMetric.n][].
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics top_n_metrics = 2;
     * </code>
     */
    public Builder removeTopNMetrics(int index) {
      if (topNMetricsBuilder_ == null) {
        ensureTopNMetricsIsMutable();
        topNMetrics_.remove(index);
        onChanged();
      } else {
        topNMetricsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metrics of top n smart replies, sorted by [TopNMetric.n][].
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics top_n_metrics = 2;
     * </code>
     */
    public com.google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics.Builder
        getTopNMetricsBuilder(int index) {
      return getTopNMetricsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Metrics of top n smart replies, sorted by [TopNMetric.n][].
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics top_n_metrics = 2;
     * </code>
     */
    public com.google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetricsOrBuilder
        getTopNMetricsOrBuilder(int index) {
      if (topNMetricsBuilder_ == null) {
        return topNMetrics_.get(index);
      } else {
        return topNMetricsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Metrics of top n smart replies, sorted by [TopNMetric.n][].
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics top_n_metrics = 2;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetricsOrBuilder>
        getTopNMetricsOrBuilderList() {
      if (topNMetricsBuilder_ != null) {
        return topNMetricsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(topNMetrics_);
      }
    }
    /**
     *
     *
     * <pre>
     * Metrics of top n smart replies, sorted by [TopNMetric.n][].
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics top_n_metrics = 2;
     * </code>
     */
    public com.google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics.Builder
        addTopNMetricsBuilder() {
      return getTopNMetricsFieldBuilder()
          .addBuilder(
              com.google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Metrics of top n smart replies, sorted by [TopNMetric.n][].
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics top_n_metrics = 2;
     * </code>
     */
    public com.google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics.Builder
        addTopNMetricsBuilder(int index) {
      return getTopNMetricsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Metrics of top n smart replies, sorted by [TopNMetric.n][].
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics top_n_metrics = 2;
     * </code>
     */
    public java.util.List<com.google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics.Builder>
        getTopNMetricsBuilderList() {
      return getTopNMetricsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics,
            com.google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics.Builder,
            com.google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetricsOrBuilder>
        getTopNMetricsFieldBuilder() {
      if (topNMetricsBuilder_ == null) {
        topNMetricsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics,
                com.google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetrics.Builder,
                com.google.cloud.dialogflow.v2.SmartReplyMetrics.TopNMetricsOrBuilder>(
                topNMetrics_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        topNMetrics_ = null;
      }
      return topNMetricsBuilder_;
    }

    private long conversationCount_;
    /**
     *
     *
     * <pre>
     * Total number of conversations used to generate this metric.
     * </pre>
     *
     * <code>int64 conversation_count = 3;</code>
     *
     * @return The conversationCount.
     */
    @java.lang.Override
    public long getConversationCount() {
      return conversationCount_;
    }
    /**
     *
     *
     * <pre>
     * Total number of conversations used to generate this metric.
     * </pre>
     *
     * <code>int64 conversation_count = 3;</code>
     *
     * @param value The conversationCount to set.
     * @return This builder for chaining.
     */
    public Builder setConversationCount(long value) {

      conversationCount_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Total number of conversations used to generate this metric.
     * </pre>
     *
     * <code>int64 conversation_count = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearConversationCount() {
      bitField0_ = (bitField0_ & ~0x00000004);
      conversationCount_ = 0L;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2.SmartReplyMetrics)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2.SmartReplyMetrics)
  private static final com.google.cloud.dialogflow.v2.SmartReplyMetrics DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2.SmartReplyMetrics();
  }

  public static com.google.cloud.dialogflow.v2.SmartReplyMetrics getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SmartReplyMetrics> PARSER =
      new com.google.protobuf.AbstractParser<SmartReplyMetrics>() {
        @java.lang.Override
        public SmartReplyMetrics parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SmartReplyMetrics> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SmartReplyMetrics> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.v2.SmartReplyMetrics getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
