/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/v2/session.proto

package com.google.cloud.dialogflow.v2;

/**
 *
 *
 * <pre>
 * Represents the parameters of the conversational query.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.v2.QueryParameters}
 */
public final class QueryParameters extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2.QueryParameters)
    QueryParametersOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use QueryParameters.newBuilder() to construct.
  private QueryParameters(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private QueryParameters() {
    timeZone_ = "";
    contexts_ = java.util.Collections.emptyList();
    sessionEntityTypes_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new QueryParameters();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.v2.SessionProto
        .internal_static_google_cloud_dialogflow_v2_QueryParameters_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 14:
        return internalGetWebhookHeaders();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.v2.SessionProto
        .internal_static_google_cloud_dialogflow_v2_QueryParameters_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.v2.QueryParameters.class,
            com.google.cloud.dialogflow.v2.QueryParameters.Builder.class);
  }

  public static final int TIME_ZONE_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object timeZone_ = "";
  /**
   *
   *
   * <pre>
   * The time zone of this conversational query from the
   * [time zone database](https://www.iana.org/time-zones), e.g.,
   * America/New_York, Europe/Paris. If not provided, the time zone specified in
   * agent settings is used.
   * </pre>
   *
   * <code>string time_zone = 1;</code>
   *
   * @return The timeZone.
   */
  @java.lang.Override
  public java.lang.String getTimeZone() {
    java.lang.Object ref = timeZone_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      timeZone_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The time zone of this conversational query from the
   * [time zone database](https://www.iana.org/time-zones), e.g.,
   * America/New_York, Europe/Paris. If not provided, the time zone specified in
   * agent settings is used.
   * </pre>
   *
   * <code>string time_zone = 1;</code>
   *
   * @return The bytes for timeZone.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTimeZoneBytes() {
    java.lang.Object ref = timeZone_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      timeZone_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int GEO_LOCATION_FIELD_NUMBER = 2;
  private com.google.type.LatLng geoLocation_;
  /**
   *
   *
   * <pre>
   * The geo location of this conversational query.
   * </pre>
   *
   * <code>.google.type.LatLng geo_location = 2;</code>
   *
   * @return Whether the geoLocation field is set.
   */
  @java.lang.Override
  public boolean hasGeoLocation() {
    return geoLocation_ != null;
  }
  /**
   *
   *
   * <pre>
   * The geo location of this conversational query.
   * </pre>
   *
   * <code>.google.type.LatLng geo_location = 2;</code>
   *
   * @return The geoLocation.
   */
  @java.lang.Override
  public com.google.type.LatLng getGeoLocation() {
    return geoLocation_ == null ? com.google.type.LatLng.getDefaultInstance() : geoLocation_;
  }
  /**
   *
   *
   * <pre>
   * The geo location of this conversational query.
   * </pre>
   *
   * <code>.google.type.LatLng geo_location = 2;</code>
   */
  @java.lang.Override
  public com.google.type.LatLngOrBuilder getGeoLocationOrBuilder() {
    return geoLocation_ == null ? com.google.type.LatLng.getDefaultInstance() : geoLocation_;
  }

  public static final int CONTEXTS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.dialogflow.v2.Context> contexts_;
  /**
   *
   *
   * <pre>
   * The collection of contexts to be activated before this query is
   * executed.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2.Context contexts = 3;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dialogflow.v2.Context> getContextsList() {
    return contexts_;
  }
  /**
   *
   *
   * <pre>
   * The collection of contexts to be activated before this query is
   * executed.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2.Context contexts = 3;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.dialogflow.v2.ContextOrBuilder>
      getContextsOrBuilderList() {
    return contexts_;
  }
  /**
   *
   *
   * <pre>
   * The collection of contexts to be activated before this query is
   * executed.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2.Context contexts = 3;</code>
   */
  @java.lang.Override
  public int getContextsCount() {
    return contexts_.size();
  }
  /**
   *
   *
   * <pre>
   * The collection of contexts to be activated before this query is
   * executed.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2.Context contexts = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.Context getContexts(int index) {
    return contexts_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The collection of contexts to be activated before this query is
   * executed.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2.Context contexts = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.ContextOrBuilder getContextsOrBuilder(int index) {
    return contexts_.get(index);
  }

  public static final int RESET_CONTEXTS_FIELD_NUMBER = 4;
  private boolean resetContexts_ = false;
  /**
   *
   *
   * <pre>
   * Specifies whether to delete all contexts in the current session
   * before the new ones are activated.
   * </pre>
   *
   * <code>bool reset_contexts = 4;</code>
   *
   * @return The resetContexts.
   */
  @java.lang.Override
  public boolean getResetContexts() {
    return resetContexts_;
  }

  public static final int SESSION_ENTITY_TYPES_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.dialogflow.v2.SessionEntityType> sessionEntityTypes_;
  /**
   *
   *
   * <pre>
   * Additional session entity types to replace or extend developer
   * entity types with. The entity synonyms apply to all languages and persist
   * for the session of this query.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2.SessionEntityType session_entity_types = 5;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dialogflow.v2.SessionEntityType>
      getSessionEntityTypesList() {
    return sessionEntityTypes_;
  }
  /**
   *
   *
   * <pre>
   * Additional session entity types to replace or extend developer
   * entity types with. The entity synonyms apply to all languages and persist
   * for the session of this query.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2.SessionEntityType session_entity_types = 5;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.dialogflow.v2.SessionEntityTypeOrBuilder>
      getSessionEntityTypesOrBuilderList() {
    return sessionEntityTypes_;
  }
  /**
   *
   *
   * <pre>
   * Additional session entity types to replace or extend developer
   * entity types with. The entity synonyms apply to all languages and persist
   * for the session of this query.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2.SessionEntityType session_entity_types = 5;</code>
   */
  @java.lang.Override
  public int getSessionEntityTypesCount() {
    return sessionEntityTypes_.size();
  }
  /**
   *
   *
   * <pre>
   * Additional session entity types to replace or extend developer
   * entity types with. The entity synonyms apply to all languages and persist
   * for the session of this query.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2.SessionEntityType session_entity_types = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.SessionEntityType getSessionEntityTypes(int index) {
    return sessionEntityTypes_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Additional session entity types to replace or extend developer
   * entity types with. The entity synonyms apply to all languages and persist
   * for the session of this query.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2.SessionEntityType session_entity_types = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.SessionEntityTypeOrBuilder getSessionEntityTypesOrBuilder(
      int index) {
    return sessionEntityTypes_.get(index);
  }

  public static final int PAYLOAD_FIELD_NUMBER = 6;
  private com.google.protobuf.Struct payload_;
  /**
   *
   *
   * <pre>
   * This field can be used to pass custom data to your webhook.
   * Arbitrary JSON objects are supported.
   * If supplied, the value is used to populate the
   * `WebhookRequest.original_detect_intent_request.payload`
   * field sent to your webhook.
   * </pre>
   *
   * <code>.google.protobuf.Struct payload = 6;</code>
   *
   * @return Whether the payload field is set.
   */
  @java.lang.Override
  public boolean hasPayload() {
    return payload_ != null;
  }
  /**
   *
   *
   * <pre>
   * This field can be used to pass custom data to your webhook.
   * Arbitrary JSON objects are supported.
   * If supplied, the value is used to populate the
   * `WebhookRequest.original_detect_intent_request.payload`
   * field sent to your webhook.
   * </pre>
   *
   * <code>.google.protobuf.Struct payload = 6;</code>
   *
   * @return The payload.
   */
  @java.lang.Override
  public com.google.protobuf.Struct getPayload() {
    return payload_ == null ? com.google.protobuf.Struct.getDefaultInstance() : payload_;
  }
  /**
   *
   *
   * <pre>
   * This field can be used to pass custom data to your webhook.
   * Arbitrary JSON objects are supported.
   * If supplied, the value is used to populate the
   * `WebhookRequest.original_detect_intent_request.payload`
   * field sent to your webhook.
   * </pre>
   *
   * <code>.google.protobuf.Struct payload = 6;</code>
   */
  @java.lang.Override
  public com.google.protobuf.StructOrBuilder getPayloadOrBuilder() {
    return payload_ == null ? com.google.protobuf.Struct.getDefaultInstance() : payload_;
  }

  public static final int SENTIMENT_ANALYSIS_REQUEST_CONFIG_FIELD_NUMBER = 10;
  private com.google.cloud.dialogflow.v2.SentimentAnalysisRequestConfig
      sentimentAnalysisRequestConfig_;
  /**
   *
   *
   * <pre>
   * Configures the type of sentiment analysis to perform. If not
   * provided, sentiment analysis is not performed.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2.SentimentAnalysisRequestConfig sentiment_analysis_request_config = 10;
   * </code>
   *
   * @return Whether the sentimentAnalysisRequestConfig field is set.
   */
  @java.lang.Override
  public boolean hasSentimentAnalysisRequestConfig() {
    return sentimentAnalysisRequestConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Configures the type of sentiment analysis to perform. If not
   * provided, sentiment analysis is not performed.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2.SentimentAnalysisRequestConfig sentiment_analysis_request_config = 10;
   * </code>
   *
   * @return The sentimentAnalysisRequestConfig.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.SentimentAnalysisRequestConfig
      getSentimentAnalysisRequestConfig() {
    return sentimentAnalysisRequestConfig_ == null
        ? com.google.cloud.dialogflow.v2.SentimentAnalysisRequestConfig.getDefaultInstance()
        : sentimentAnalysisRequestConfig_;
  }
  /**
   *
   *
   * <pre>
   * Configures the type of sentiment analysis to perform. If not
   * provided, sentiment analysis is not performed.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2.SentimentAnalysisRequestConfig sentiment_analysis_request_config = 10;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.SentimentAnalysisRequestConfigOrBuilder
      getSentimentAnalysisRequestConfigOrBuilder() {
    return sentimentAnalysisRequestConfig_ == null
        ? com.google.cloud.dialogflow.v2.SentimentAnalysisRequestConfig.getDefaultInstance()
        : sentimentAnalysisRequestConfig_;
  }

  public static final int WEBHOOK_HEADERS_FIELD_NUMBER = 14;

  private static final class WebhookHeadersDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.dialogflow.v2.SessionProto
                .internal_static_google_cloud_dialogflow_v2_QueryParameters_WebhookHeadersEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> webhookHeaders_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetWebhookHeaders() {
    if (webhookHeaders_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          WebhookHeadersDefaultEntryHolder.defaultEntry);
    }
    return webhookHeaders_;
  }

  public int getWebhookHeadersCount() {
    return internalGetWebhookHeaders().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * This field can be used to pass HTTP headers for a webhook
   * call. These headers will be sent to webhook along with the headers that
   * have been configured through the Dialogflow web console. The headers
   * defined within this field will overwrite the headers configured through the
   * Dialogflow console if there is a conflict. Header names are
   * case-insensitive. Google's specified headers are not allowed. Including:
   * "Host", "Content-Length", "Connection", "From", "User-Agent",
   * "Accept-Encoding", "If-Modified-Since", "If-None-Match", "X-Forwarded-For",
   * etc.
   * </pre>
   *
   * <code>map&lt;string, string&gt; webhook_headers = 14;</code>
   */
  @java.lang.Override
  public boolean containsWebhookHeaders(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetWebhookHeaders().getMap().containsKey(key);
  }
  /** Use {@link #getWebhookHeadersMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getWebhookHeaders() {
    return getWebhookHeadersMap();
  }
  /**
   *
   *
   * <pre>
   * This field can be used to pass HTTP headers for a webhook
   * call. These headers will be sent to webhook along with the headers that
   * have been configured through the Dialogflow web console. The headers
   * defined within this field will overwrite the headers configured through the
   * Dialogflow console if there is a conflict. Header names are
   * case-insensitive. Google's specified headers are not allowed. Including:
   * "Host", "Content-Length", "Connection", "From", "User-Agent",
   * "Accept-Encoding", "If-Modified-Since", "If-None-Match", "X-Forwarded-For",
   * etc.
   * </pre>
   *
   * <code>map&lt;string, string&gt; webhook_headers = 14;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getWebhookHeadersMap() {
    return internalGetWebhookHeaders().getMap();
  }
  /**
   *
   *
   * <pre>
   * This field can be used to pass HTTP headers for a webhook
   * call. These headers will be sent to webhook along with the headers that
   * have been configured through the Dialogflow web console. The headers
   * defined within this field will overwrite the headers configured through the
   * Dialogflow console if there is a conflict. Header names are
   * case-insensitive. Google's specified headers are not allowed. Including:
   * "Host", "Content-Length", "Connection", "From", "User-Agent",
   * "Accept-Encoding", "If-Modified-Since", "If-None-Match", "X-Forwarded-For",
   * etc.
   * </pre>
   *
   * <code>map&lt;string, string&gt; webhook_headers = 14;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getWebhookHeadersOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetWebhookHeaders().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * This field can be used to pass HTTP headers for a webhook
   * call. These headers will be sent to webhook along with the headers that
   * have been configured through the Dialogflow web console. The headers
   * defined within this field will overwrite the headers configured through the
   * Dialogflow console if there is a conflict. Header names are
   * case-insensitive. Google's specified headers are not allowed. Including:
   * "Host", "Content-Length", "Connection", "From", "User-Agent",
   * "Accept-Encoding", "If-Modified-Since", "If-None-Match", "X-Forwarded-For",
   * etc.
   * </pre>
   *
   * <code>map&lt;string, string&gt; webhook_headers = 14;</code>
   */
  @java.lang.Override
  public java.lang.String getWebhookHeadersOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetWebhookHeaders().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(timeZone_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, timeZone_);
    }
    if (geoLocation_ != null) {
      output.writeMessage(2, getGeoLocation());
    }
    for (int i = 0; i < contexts_.size(); i++) {
      output.writeMessage(3, contexts_.get(i));
    }
    if (resetContexts_ != false) {
      output.writeBool(4, resetContexts_);
    }
    for (int i = 0; i < sessionEntityTypes_.size(); i++) {
      output.writeMessage(5, sessionEntityTypes_.get(i));
    }
    if (payload_ != null) {
      output.writeMessage(6, getPayload());
    }
    if (sentimentAnalysisRequestConfig_ != null) {
      output.writeMessage(10, getSentimentAnalysisRequestConfig());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetWebhookHeaders(), WebhookHeadersDefaultEntryHolder.defaultEntry, 14);
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(timeZone_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, timeZone_);
    }
    if (geoLocation_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getGeoLocation());
    }
    for (int i = 0; i < contexts_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, contexts_.get(i));
    }
    if (resetContexts_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, resetContexts_);
    }
    for (int i = 0; i < sessionEntityTypes_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(5, sessionEntityTypes_.get(i));
    }
    if (payload_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getPayload());
    }
    if (sentimentAnalysisRequestConfig_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              10, getSentimentAnalysisRequestConfig());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetWebhookHeaders().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> webhookHeaders__ =
          WebhookHeadersDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(14, webhookHeaders__);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.v2.QueryParameters)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.v2.QueryParameters other =
        (com.google.cloud.dialogflow.v2.QueryParameters) obj;

    if (!getTimeZone().equals(other.getTimeZone())) return false;
    if (hasGeoLocation() != other.hasGeoLocation()) return false;
    if (hasGeoLocation()) {
      if (!getGeoLocation().equals(other.getGeoLocation())) return false;
    }
    if (!getContextsList().equals(other.getContextsList())) return false;
    if (getResetContexts() != other.getResetContexts()) return false;
    if (!getSessionEntityTypesList().equals(other.getSessionEntityTypesList())) return false;
    if (hasPayload() != other.hasPayload()) return false;
    if (hasPayload()) {
      if (!getPayload().equals(other.getPayload())) return false;
    }
    if (hasSentimentAnalysisRequestConfig() != other.hasSentimentAnalysisRequestConfig())
      return false;
    if (hasSentimentAnalysisRequestConfig()) {
      if (!getSentimentAnalysisRequestConfig().equals(other.getSentimentAnalysisRequestConfig()))
        return false;
    }
    if (!internalGetWebhookHeaders().equals(other.internalGetWebhookHeaders())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TIME_ZONE_FIELD_NUMBER;
    hash = (53 * hash) + getTimeZone().hashCode();
    if (hasGeoLocation()) {
      hash = (37 * hash) + GEO_LOCATION_FIELD_NUMBER;
      hash = (53 * hash) + getGeoLocation().hashCode();
    }
    if (getContextsCount() > 0) {
      hash = (37 * hash) + CONTEXTS_FIELD_NUMBER;
      hash = (53 * hash) + getContextsList().hashCode();
    }
    hash = (37 * hash) + RESET_CONTEXTS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getResetContexts());
    if (getSessionEntityTypesCount() > 0) {
      hash = (37 * hash) + SESSION_ENTITY_TYPES_FIELD_NUMBER;
      hash = (53 * hash) + getSessionEntityTypesList().hashCode();
    }
    if (hasPayload()) {
      hash = (37 * hash) + PAYLOAD_FIELD_NUMBER;
      hash = (53 * hash) + getPayload().hashCode();
    }
    if (hasSentimentAnalysisRequestConfig()) {
      hash = (37 * hash) + SENTIMENT_ANALYSIS_REQUEST_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getSentimentAnalysisRequestConfig().hashCode();
    }
    if (!internalGetWebhookHeaders().getMap().isEmpty()) {
      hash = (37 * hash) + WEBHOOK_HEADERS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetWebhookHeaders().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.v2.QueryParameters parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2.QueryParameters parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.QueryParameters parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2.QueryParameters parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.QueryParameters parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2.QueryParameters parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.QueryParameters parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2.QueryParameters parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.QueryParameters parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2.QueryParameters parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.QueryParameters parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2.QueryParameters parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dialogflow.v2.QueryParameters prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents the parameters of the conversational query.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2.QueryParameters}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2.QueryParameters)
      com.google.cloud.dialogflow.v2.QueryParametersOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2.SessionProto
          .internal_static_google_cloud_dialogflow_v2_QueryParameters_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 14:
          return internalGetWebhookHeaders();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 14:
          return internalGetMutableWebhookHeaders();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2.SessionProto
          .internal_static_google_cloud_dialogflow_v2_QueryParameters_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2.QueryParameters.class,
              com.google.cloud.dialogflow.v2.QueryParameters.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.v2.QueryParameters.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      timeZone_ = "";
      geoLocation_ = null;
      if (geoLocationBuilder_ != null) {
        geoLocationBuilder_.dispose();
        geoLocationBuilder_ = null;
      }
      if (contextsBuilder_ == null) {
        contexts_ = java.util.Collections.emptyList();
      } else {
        contexts_ = null;
        contextsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      resetContexts_ = false;
      if (sessionEntityTypesBuilder_ == null) {
        sessionEntityTypes_ = java.util.Collections.emptyList();
      } else {
        sessionEntityTypes_ = null;
        sessionEntityTypesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000010);
      payload_ = null;
      if (payloadBuilder_ != null) {
        payloadBuilder_.dispose();
        payloadBuilder_ = null;
      }
      sentimentAnalysisRequestConfig_ = null;
      if (sentimentAnalysisRequestConfigBuilder_ != null) {
        sentimentAnalysisRequestConfigBuilder_.dispose();
        sentimentAnalysisRequestConfigBuilder_ = null;
      }
      internalGetMutableWebhookHeaders().clear();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.v2.SessionProto
          .internal_static_google_cloud_dialogflow_v2_QueryParameters_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.QueryParameters getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.v2.QueryParameters.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.QueryParameters build() {
      com.google.cloud.dialogflow.v2.QueryParameters result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.QueryParameters buildPartial() {
      com.google.cloud.dialogflow.v2.QueryParameters result =
          new com.google.cloud.dialogflow.v2.QueryParameters(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.dialogflow.v2.QueryParameters result) {
      if (contextsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          contexts_ = java.util.Collections.unmodifiableList(contexts_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.contexts_ = contexts_;
      } else {
        result.contexts_ = contextsBuilder_.build();
      }
      if (sessionEntityTypesBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)) {
          sessionEntityTypes_ = java.util.Collections.unmodifiableList(sessionEntityTypes_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.sessionEntityTypes_ = sessionEntityTypes_;
      } else {
        result.sessionEntityTypes_ = sessionEntityTypesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.dialogflow.v2.QueryParameters result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.timeZone_ = timeZone_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.geoLocation_ =
            geoLocationBuilder_ == null ? geoLocation_ : geoLocationBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.resetContexts_ = resetContexts_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.payload_ = payloadBuilder_ == null ? payload_ : payloadBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.sentimentAnalysisRequestConfig_ =
            sentimentAnalysisRequestConfigBuilder_ == null
                ? sentimentAnalysisRequestConfig_
                : sentimentAnalysisRequestConfigBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.webhookHeaders_ = internalGetWebhookHeaders();
        result.webhookHeaders_.makeImmutable();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.v2.QueryParameters) {
        return mergeFrom((com.google.cloud.dialogflow.v2.QueryParameters) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.v2.QueryParameters other) {
      if (other == com.google.cloud.dialogflow.v2.QueryParameters.getDefaultInstance()) return this;
      if (!other.getTimeZone().isEmpty()) {
        timeZone_ = other.timeZone_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasGeoLocation()) {
        mergeGeoLocation(other.getGeoLocation());
      }
      if (contextsBuilder_ == null) {
        if (!other.contexts_.isEmpty()) {
          if (contexts_.isEmpty()) {
            contexts_ = other.contexts_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureContextsIsMutable();
            contexts_.addAll(other.contexts_);
          }
          onChanged();
        }
      } else {
        if (!other.contexts_.isEmpty()) {
          if (contextsBuilder_.isEmpty()) {
            contextsBuilder_.dispose();
            contextsBuilder_ = null;
            contexts_ = other.contexts_;
            bitField0_ = (bitField0_ & ~0x00000004);
            contextsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getContextsFieldBuilder()
                    : null;
          } else {
            contextsBuilder_.addAllMessages(other.contexts_);
          }
        }
      }
      if (other.getResetContexts() != false) {
        setResetContexts(other.getResetContexts());
      }
      if (sessionEntityTypesBuilder_ == null) {
        if (!other.sessionEntityTypes_.isEmpty()) {
          if (sessionEntityTypes_.isEmpty()) {
            sessionEntityTypes_ = other.sessionEntityTypes_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureSessionEntityTypesIsMutable();
            sessionEntityTypes_.addAll(other.sessionEntityTypes_);
          }
          onChanged();
        }
      } else {
        if (!other.sessionEntityTypes_.isEmpty()) {
          if (sessionEntityTypesBuilder_.isEmpty()) {
            sessionEntityTypesBuilder_.dispose();
            sessionEntityTypesBuilder_ = null;
            sessionEntityTypes_ = other.sessionEntityTypes_;
            bitField0_ = (bitField0_ & ~0x00000010);
            sessionEntityTypesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getSessionEntityTypesFieldBuilder()
                    : null;
          } else {
            sessionEntityTypesBuilder_.addAllMessages(other.sessionEntityTypes_);
          }
        }
      }
      if (other.hasPayload()) {
        mergePayload(other.getPayload());
      }
      if (other.hasSentimentAnalysisRequestConfig()) {
        mergeSentimentAnalysisRequestConfig(other.getSentimentAnalysisRequestConfig());
      }
      internalGetMutableWebhookHeaders().mergeFrom(other.internalGetWebhookHeaders());
      bitField0_ |= 0x00000080;
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                timeZone_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getGeoLocationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                com.google.cloud.dialogflow.v2.Context m =
                    input.readMessage(
                        com.google.cloud.dialogflow.v2.Context.parser(), extensionRegistry);
                if (contextsBuilder_ == null) {
                  ensureContextsIsMutable();
                  contexts_.add(m);
                } else {
                  contextsBuilder_.addMessage(m);
                }
                break;
              } // case 26
            case 32:
              {
                resetContexts_ = input.readBool();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 42:
              {
                com.google.cloud.dialogflow.v2.SessionEntityType m =
                    input.readMessage(
                        com.google.cloud.dialogflow.v2.SessionEntityType.parser(),
                        extensionRegistry);
                if (sessionEntityTypesBuilder_ == null) {
                  ensureSessionEntityTypesIsMutable();
                  sessionEntityTypes_.add(m);
                } else {
                  sessionEntityTypesBuilder_.addMessage(m);
                }
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getPayloadFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 82:
              {
                input.readMessage(
                    getSentimentAnalysisRequestConfigFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 82
            case 114:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> webhookHeaders__ =
                    input.readMessage(
                        WebhookHeadersDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableWebhookHeaders()
                    .getMutableMap()
                    .put(webhookHeaders__.getKey(), webhookHeaders__.getValue());
                bitField0_ |= 0x00000080;
                break;
              } // case 114
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object timeZone_ = "";
    /**
     *
     *
     * <pre>
     * The time zone of this conversational query from the
     * [time zone database](https://www.iana.org/time-zones), e.g.,
     * America/New_York, Europe/Paris. If not provided, the time zone specified in
     * agent settings is used.
     * </pre>
     *
     * <code>string time_zone = 1;</code>
     *
     * @return The timeZone.
     */
    public java.lang.String getTimeZone() {
      java.lang.Object ref = timeZone_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        timeZone_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The time zone of this conversational query from the
     * [time zone database](https://www.iana.org/time-zones), e.g.,
     * America/New_York, Europe/Paris. If not provided, the time zone specified in
     * agent settings is used.
     * </pre>
     *
     * <code>string time_zone = 1;</code>
     *
     * @return The bytes for timeZone.
     */
    public com.google.protobuf.ByteString getTimeZoneBytes() {
      java.lang.Object ref = timeZone_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        timeZone_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The time zone of this conversational query from the
     * [time zone database](https://www.iana.org/time-zones), e.g.,
     * America/New_York, Europe/Paris. If not provided, the time zone specified in
     * agent settings is used.
     * </pre>
     *
     * <code>string time_zone = 1;</code>
     *
     * @param value The timeZone to set.
     * @return This builder for chaining.
     */
    public Builder setTimeZone(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      timeZone_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time zone of this conversational query from the
     * [time zone database](https://www.iana.org/time-zones), e.g.,
     * America/New_York, Europe/Paris. If not provided, the time zone specified in
     * agent settings is used.
     * </pre>
     *
     * <code>string time_zone = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTimeZone() {
      timeZone_ = getDefaultInstance().getTimeZone();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time zone of this conversational query from the
     * [time zone database](https://www.iana.org/time-zones), e.g.,
     * America/New_York, Europe/Paris. If not provided, the time zone specified in
     * agent settings is used.
     * </pre>
     *
     * <code>string time_zone = 1;</code>
     *
     * @param value The bytes for timeZone to set.
     * @return This builder for chaining.
     */
    public Builder setTimeZoneBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      timeZone_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.type.LatLng geoLocation_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.LatLng, com.google.type.LatLng.Builder, com.google.type.LatLngOrBuilder>
        geoLocationBuilder_;
    /**
     *
     *
     * <pre>
     * The geo location of this conversational query.
     * </pre>
     *
     * <code>.google.type.LatLng geo_location = 2;</code>
     *
     * @return Whether the geoLocation field is set.
     */
    public boolean hasGeoLocation() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The geo location of this conversational query.
     * </pre>
     *
     * <code>.google.type.LatLng geo_location = 2;</code>
     *
     * @return The geoLocation.
     */
    public com.google.type.LatLng getGeoLocation() {
      if (geoLocationBuilder_ == null) {
        return geoLocation_ == null ? com.google.type.LatLng.getDefaultInstance() : geoLocation_;
      } else {
        return geoLocationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The geo location of this conversational query.
     * </pre>
     *
     * <code>.google.type.LatLng geo_location = 2;</code>
     */
    public Builder setGeoLocation(com.google.type.LatLng value) {
      if (geoLocationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        geoLocation_ = value;
      } else {
        geoLocationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The geo location of this conversational query.
     * </pre>
     *
     * <code>.google.type.LatLng geo_location = 2;</code>
     */
    public Builder setGeoLocation(com.google.type.LatLng.Builder builderForValue) {
      if (geoLocationBuilder_ == null) {
        geoLocation_ = builderForValue.build();
      } else {
        geoLocationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The geo location of this conversational query.
     * </pre>
     *
     * <code>.google.type.LatLng geo_location = 2;</code>
     */
    public Builder mergeGeoLocation(com.google.type.LatLng value) {
      if (geoLocationBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && geoLocation_ != null
            && geoLocation_ != com.google.type.LatLng.getDefaultInstance()) {
          getGeoLocationBuilder().mergeFrom(value);
        } else {
          geoLocation_ = value;
        }
      } else {
        geoLocationBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The geo location of this conversational query.
     * </pre>
     *
     * <code>.google.type.LatLng geo_location = 2;</code>
     */
    public Builder clearGeoLocation() {
      bitField0_ = (bitField0_ & ~0x00000002);
      geoLocation_ = null;
      if (geoLocationBuilder_ != null) {
        geoLocationBuilder_.dispose();
        geoLocationBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The geo location of this conversational query.
     * </pre>
     *
     * <code>.google.type.LatLng geo_location = 2;</code>
     */
    public com.google.type.LatLng.Builder getGeoLocationBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getGeoLocationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The geo location of this conversational query.
     * </pre>
     *
     * <code>.google.type.LatLng geo_location = 2;</code>
     */
    public com.google.type.LatLngOrBuilder getGeoLocationOrBuilder() {
      if (geoLocationBuilder_ != null) {
        return geoLocationBuilder_.getMessageOrBuilder();
      } else {
        return geoLocation_ == null ? com.google.type.LatLng.getDefaultInstance() : geoLocation_;
      }
    }
    /**
     *
     *
     * <pre>
     * The geo location of this conversational query.
     * </pre>
     *
     * <code>.google.type.LatLng geo_location = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.LatLng, com.google.type.LatLng.Builder, com.google.type.LatLngOrBuilder>
        getGeoLocationFieldBuilder() {
      if (geoLocationBuilder_ == null) {
        geoLocationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.type.LatLng,
                com.google.type.LatLng.Builder,
                com.google.type.LatLngOrBuilder>(
                getGeoLocation(), getParentForChildren(), isClean());
        geoLocation_ = null;
      }
      return geoLocationBuilder_;
    }

    private java.util.List<com.google.cloud.dialogflow.v2.Context> contexts_ =
        java.util.Collections.emptyList();

    private void ensureContextsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        contexts_ = new java.util.ArrayList<com.google.cloud.dialogflow.v2.Context>(contexts_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.v2.Context,
            com.google.cloud.dialogflow.v2.Context.Builder,
            com.google.cloud.dialogflow.v2.ContextOrBuilder>
        contextsBuilder_;

    /**
     *
     *
     * <pre>
     * The collection of contexts to be activated before this query is
     * executed.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2.Context contexts = 3;</code>
     */
    public java.util.List<com.google.cloud.dialogflow.v2.Context> getContextsList() {
      if (contextsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(contexts_);
      } else {
        return contextsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The collection of contexts to be activated before this query is
     * executed.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2.Context contexts = 3;</code>
     */
    public int getContextsCount() {
      if (contextsBuilder_ == null) {
        return contexts_.size();
      } else {
        return contextsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The collection of contexts to be activated before this query is
     * executed.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2.Context contexts = 3;</code>
     */
    public com.google.cloud.dialogflow.v2.Context getContexts(int index) {
      if (contextsBuilder_ == null) {
        return contexts_.get(index);
      } else {
        return contextsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The collection of contexts to be activated before this query is
     * executed.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2.Context contexts = 3;</code>
     */
    public Builder setContexts(int index, com.google.cloud.dialogflow.v2.Context value) {
      if (contextsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureContextsIsMutable();
        contexts_.set(index, value);
        onChanged();
      } else {
        contextsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The collection of contexts to be activated before this query is
     * executed.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2.Context contexts = 3;</code>
     */
    public Builder setContexts(
        int index, com.google.cloud.dialogflow.v2.Context.Builder builderForValue) {
      if (contextsBuilder_ == null) {
        ensureContextsIsMutable();
        contexts_.set(index, builderForValue.build());
        onChanged();
      } else {
        contextsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The collection of contexts to be activated before this query is
     * executed.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2.Context contexts = 3;</code>
     */
    public Builder addContexts(com.google.cloud.dialogflow.v2.Context value) {
      if (contextsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureContextsIsMutable();
        contexts_.add(value);
        onChanged();
      } else {
        contextsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The collection of contexts to be activated before this query is
     * executed.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2.Context contexts = 3;</code>
     */
    public Builder addContexts(int index, com.google.cloud.dialogflow.v2.Context value) {
      if (contextsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureContextsIsMutable();
        contexts_.add(index, value);
        onChanged();
      } else {
        contextsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The collection of contexts to be activated before this query is
     * executed.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2.Context contexts = 3;</code>
     */
    public Builder addContexts(com.google.cloud.dialogflow.v2.Context.Builder builderForValue) {
      if (contextsBuilder_ == null) {
        ensureContextsIsMutable();
        contexts_.add(builderForValue.build());
        onChanged();
      } else {
        contextsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The collection of contexts to be activated before this query is
     * executed.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2.Context contexts = 3;</code>
     */
    public Builder addContexts(
        int index, com.google.cloud.dialogflow.v2.Context.Builder builderForValue) {
      if (contextsBuilder_ == null) {
        ensureContextsIsMutable();
        contexts_.add(index, builderForValue.build());
        onChanged();
      } else {
        contextsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The collection of contexts to be activated before this query is
     * executed.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2.Context contexts = 3;</code>
     */
    public Builder addAllContexts(
        java.lang.Iterable<? extends com.google.cloud.dialogflow.v2.Context> values) {
      if (contextsBuilder_ == null) {
        ensureContextsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, contexts_);
        onChanged();
      } else {
        contextsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The collection of contexts to be activated before this query is
     * executed.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2.Context contexts = 3;</code>
     */
    public Builder clearContexts() {
      if (contextsBuilder_ == null) {
        contexts_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        contextsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The collection of contexts to be activated before this query is
     * executed.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2.Context contexts = 3;</code>
     */
    public Builder removeContexts(int index) {
      if (contextsBuilder_ == null) {
        ensureContextsIsMutable();
        contexts_.remove(index);
        onChanged();
      } else {
        contextsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The collection of contexts to be activated before this query is
     * executed.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2.Context contexts = 3;</code>
     */
    public com.google.cloud.dialogflow.v2.Context.Builder getContextsBuilder(int index) {
      return getContextsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The collection of contexts to be activated before this query is
     * executed.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2.Context contexts = 3;</code>
     */
    public com.google.cloud.dialogflow.v2.ContextOrBuilder getContextsOrBuilder(int index) {
      if (contextsBuilder_ == null) {
        return contexts_.get(index);
      } else {
        return contextsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The collection of contexts to be activated before this query is
     * executed.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2.Context contexts = 3;</code>
     */
    public java.util.List<? extends com.google.cloud.dialogflow.v2.ContextOrBuilder>
        getContextsOrBuilderList() {
      if (contextsBuilder_ != null) {
        return contextsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(contexts_);
      }
    }
    /**
     *
     *
     * <pre>
     * The collection of contexts to be activated before this query is
     * executed.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2.Context contexts = 3;</code>
     */
    public com.google.cloud.dialogflow.v2.Context.Builder addContextsBuilder() {
      return getContextsFieldBuilder()
          .addBuilder(com.google.cloud.dialogflow.v2.Context.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The collection of contexts to be activated before this query is
     * executed.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2.Context contexts = 3;</code>
     */
    public com.google.cloud.dialogflow.v2.Context.Builder addContextsBuilder(int index) {
      return getContextsFieldBuilder()
          .addBuilder(index, com.google.cloud.dialogflow.v2.Context.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The collection of contexts to be activated before this query is
     * executed.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2.Context contexts = 3;</code>
     */
    public java.util.List<com.google.cloud.dialogflow.v2.Context.Builder> getContextsBuilderList() {
      return getContextsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.v2.Context,
            com.google.cloud.dialogflow.v2.Context.Builder,
            com.google.cloud.dialogflow.v2.ContextOrBuilder>
        getContextsFieldBuilder() {
      if (contextsBuilder_ == null) {
        contextsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.v2.Context,
                com.google.cloud.dialogflow.v2.Context.Builder,
                com.google.cloud.dialogflow.v2.ContextOrBuilder>(
                contexts_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
        contexts_ = null;
      }
      return contextsBuilder_;
    }

    private boolean resetContexts_;
    /**
     *
     *
     * <pre>
     * Specifies whether to delete all contexts in the current session
     * before the new ones are activated.
     * </pre>
     *
     * <code>bool reset_contexts = 4;</code>
     *
     * @return The resetContexts.
     */
    @java.lang.Override
    public boolean getResetContexts() {
      return resetContexts_;
    }
    /**
     *
     *
     * <pre>
     * Specifies whether to delete all contexts in the current session
     * before the new ones are activated.
     * </pre>
     *
     * <code>bool reset_contexts = 4;</code>
     *
     * @param value The resetContexts to set.
     * @return This builder for chaining.
     */
    public Builder setResetContexts(boolean value) {

      resetContexts_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies whether to delete all contexts in the current session
     * before the new ones are activated.
     * </pre>
     *
     * <code>bool reset_contexts = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearResetContexts() {
      bitField0_ = (bitField0_ & ~0x00000008);
      resetContexts_ = false;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.dialogflow.v2.SessionEntityType> sessionEntityTypes_ =
        java.util.Collections.emptyList();

    private void ensureSessionEntityTypesIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        sessionEntityTypes_ =
            new java.util.ArrayList<com.google.cloud.dialogflow.v2.SessionEntityType>(
                sessionEntityTypes_);
        bitField0_ |= 0x00000010;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.v2.SessionEntityType,
            com.google.cloud.dialogflow.v2.SessionEntityType.Builder,
            com.google.cloud.dialogflow.v2.SessionEntityTypeOrBuilder>
        sessionEntityTypesBuilder_;

    /**
     *
     *
     * <pre>
     * Additional session entity types to replace or extend developer
     * entity types with. The entity synonyms apply to all languages and persist
     * for the session of this query.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2.SessionEntityType session_entity_types = 5;</code>
     */
    public java.util.List<com.google.cloud.dialogflow.v2.SessionEntityType>
        getSessionEntityTypesList() {
      if (sessionEntityTypesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(sessionEntityTypes_);
      } else {
        return sessionEntityTypesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Additional session entity types to replace or extend developer
     * entity types with. The entity synonyms apply to all languages and persist
     * for the session of this query.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2.SessionEntityType session_entity_types = 5;</code>
     */
    public int getSessionEntityTypesCount() {
      if (sessionEntityTypesBuilder_ == null) {
        return sessionEntityTypes_.size();
      } else {
        return sessionEntityTypesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Additional session entity types to replace or extend developer
     * entity types with. The entity synonyms apply to all languages and persist
     * for the session of this query.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2.SessionEntityType session_entity_types = 5;</code>
     */
    public com.google.cloud.dialogflow.v2.SessionEntityType getSessionEntityTypes(int index) {
      if (sessionEntityTypesBuilder_ == null) {
        return sessionEntityTypes_.get(index);
      } else {
        return sessionEntityTypesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Additional session entity types to replace or extend developer
     * entity types with. The entity synonyms apply to all languages and persist
     * for the session of this query.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2.SessionEntityType session_entity_types = 5;</code>
     */
    public Builder setSessionEntityTypes(
        int index, com.google.cloud.dialogflow.v2.SessionEntityType value) {
      if (sessionEntityTypesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSessionEntityTypesIsMutable();
        sessionEntityTypes_.set(index, value);
        onChanged();
      } else {
        sessionEntityTypesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional session entity types to replace or extend developer
     * entity types with. The entity synonyms apply to all languages and persist
     * for the session of this query.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2.SessionEntityType session_entity_types = 5;</code>
     */
    public Builder setSessionEntityTypes(
        int index, com.google.cloud.dialogflow.v2.SessionEntityType.Builder builderForValue) {
      if (sessionEntityTypesBuilder_ == null) {
        ensureSessionEntityTypesIsMutable();
        sessionEntityTypes_.set(index, builderForValue.build());
        onChanged();
      } else {
        sessionEntityTypesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional session entity types to replace or extend developer
     * entity types with. The entity synonyms apply to all languages and persist
     * for the session of this query.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2.SessionEntityType session_entity_types = 5;</code>
     */
    public Builder addSessionEntityTypes(com.google.cloud.dialogflow.v2.SessionEntityType value) {
      if (sessionEntityTypesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSessionEntityTypesIsMutable();
        sessionEntityTypes_.add(value);
        onChanged();
      } else {
        sessionEntityTypesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional session entity types to replace or extend developer
     * entity types with. The entity synonyms apply to all languages and persist
     * for the session of this query.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2.SessionEntityType session_entity_types = 5;</code>
     */
    public Builder addSessionEntityTypes(
        int index, com.google.cloud.dialogflow.v2.SessionEntityType value) {
      if (sessionEntityTypesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSessionEntityTypesIsMutable();
        sessionEntityTypes_.add(index, value);
        onChanged();
      } else {
        sessionEntityTypesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional session entity types to replace or extend developer
     * entity types with. The entity synonyms apply to all languages and persist
     * for the session of this query.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2.SessionEntityType session_entity_types = 5;</code>
     */
    public Builder addSessionEntityTypes(
        com.google.cloud.dialogflow.v2.SessionEntityType.Builder builderForValue) {
      if (sessionEntityTypesBuilder_ == null) {
        ensureSessionEntityTypesIsMutable();
        sessionEntityTypes_.add(builderForValue.build());
        onChanged();
      } else {
        sessionEntityTypesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional session entity types to replace or extend developer
     * entity types with. The entity synonyms apply to all languages and persist
     * for the session of this query.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2.SessionEntityType session_entity_types = 5;</code>
     */
    public Builder addSessionEntityTypes(
        int index, com.google.cloud.dialogflow.v2.SessionEntityType.Builder builderForValue) {
      if (sessionEntityTypesBuilder_ == null) {
        ensureSessionEntityTypesIsMutable();
        sessionEntityTypes_.add(index, builderForValue.build());
        onChanged();
      } else {
        sessionEntityTypesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional session entity types to replace or extend developer
     * entity types with. The entity synonyms apply to all languages and persist
     * for the session of this query.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2.SessionEntityType session_entity_types = 5;</code>
     */
    public Builder addAllSessionEntityTypes(
        java.lang.Iterable<? extends com.google.cloud.dialogflow.v2.SessionEntityType> values) {
      if (sessionEntityTypesBuilder_ == null) {
        ensureSessionEntityTypesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, sessionEntityTypes_);
        onChanged();
      } else {
        sessionEntityTypesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional session entity types to replace or extend developer
     * entity types with. The entity synonyms apply to all languages and persist
     * for the session of this query.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2.SessionEntityType session_entity_types = 5;</code>
     */
    public Builder clearSessionEntityTypes() {
      if (sessionEntityTypesBuilder_ == null) {
        sessionEntityTypes_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        sessionEntityTypesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional session entity types to replace or extend developer
     * entity types with. The entity synonyms apply to all languages and persist
     * for the session of this query.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2.SessionEntityType session_entity_types = 5;</code>
     */
    public Builder removeSessionEntityTypes(int index) {
      if (sessionEntityTypesBuilder_ == null) {
        ensureSessionEntityTypesIsMutable();
        sessionEntityTypes_.remove(index);
        onChanged();
      } else {
        sessionEntityTypesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional session entity types to replace or extend developer
     * entity types with. The entity synonyms apply to all languages and persist
     * for the session of this query.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2.SessionEntityType session_entity_types = 5;</code>
     */
    public com.google.cloud.dialogflow.v2.SessionEntityType.Builder getSessionEntityTypesBuilder(
        int index) {
      return getSessionEntityTypesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Additional session entity types to replace or extend developer
     * entity types with. The entity synonyms apply to all languages and persist
     * for the session of this query.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2.SessionEntityType session_entity_types = 5;</code>
     */
    public com.google.cloud.dialogflow.v2.SessionEntityTypeOrBuilder getSessionEntityTypesOrBuilder(
        int index) {
      if (sessionEntityTypesBuilder_ == null) {
        return sessionEntityTypes_.get(index);
      } else {
        return sessionEntityTypesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Additional session entity types to replace or extend developer
     * entity types with. The entity synonyms apply to all languages and persist
     * for the session of this query.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2.SessionEntityType session_entity_types = 5;</code>
     */
    public java.util.List<? extends com.google.cloud.dialogflow.v2.SessionEntityTypeOrBuilder>
        getSessionEntityTypesOrBuilderList() {
      if (sessionEntityTypesBuilder_ != null) {
        return sessionEntityTypesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(sessionEntityTypes_);
      }
    }
    /**
     *
     *
     * <pre>
     * Additional session entity types to replace or extend developer
     * entity types with. The entity synonyms apply to all languages and persist
     * for the session of this query.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2.SessionEntityType session_entity_types = 5;</code>
     */
    public com.google.cloud.dialogflow.v2.SessionEntityType.Builder addSessionEntityTypesBuilder() {
      return getSessionEntityTypesFieldBuilder()
          .addBuilder(com.google.cloud.dialogflow.v2.SessionEntityType.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Additional session entity types to replace or extend developer
     * entity types with. The entity synonyms apply to all languages and persist
     * for the session of this query.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2.SessionEntityType session_entity_types = 5;</code>
     */
    public com.google.cloud.dialogflow.v2.SessionEntityType.Builder addSessionEntityTypesBuilder(
        int index) {
      return getSessionEntityTypesFieldBuilder()
          .addBuilder(index, com.google.cloud.dialogflow.v2.SessionEntityType.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Additional session entity types to replace or extend developer
     * entity types with. The entity synonyms apply to all languages and persist
     * for the session of this query.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2.SessionEntityType session_entity_types = 5;</code>
     */
    public java.util.List<com.google.cloud.dialogflow.v2.SessionEntityType.Builder>
        getSessionEntityTypesBuilderList() {
      return getSessionEntityTypesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.v2.SessionEntityType,
            com.google.cloud.dialogflow.v2.SessionEntityType.Builder,
            com.google.cloud.dialogflow.v2.SessionEntityTypeOrBuilder>
        getSessionEntityTypesFieldBuilder() {
      if (sessionEntityTypesBuilder_ == null) {
        sessionEntityTypesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.v2.SessionEntityType,
                com.google.cloud.dialogflow.v2.SessionEntityType.Builder,
                com.google.cloud.dialogflow.v2.SessionEntityTypeOrBuilder>(
                sessionEntityTypes_,
                ((bitField0_ & 0x00000010) != 0),
                getParentForChildren(),
                isClean());
        sessionEntityTypes_ = null;
      }
      return sessionEntityTypesBuilder_;
    }

    private com.google.protobuf.Struct payload_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        payloadBuilder_;
    /**
     *
     *
     * <pre>
     * This field can be used to pass custom data to your webhook.
     * Arbitrary JSON objects are supported.
     * If supplied, the value is used to populate the
     * `WebhookRequest.original_detect_intent_request.payload`
     * field sent to your webhook.
     * </pre>
     *
     * <code>.google.protobuf.Struct payload = 6;</code>
     *
     * @return Whether the payload field is set.
     */
    public boolean hasPayload() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * This field can be used to pass custom data to your webhook.
     * Arbitrary JSON objects are supported.
     * If supplied, the value is used to populate the
     * `WebhookRequest.original_detect_intent_request.payload`
     * field sent to your webhook.
     * </pre>
     *
     * <code>.google.protobuf.Struct payload = 6;</code>
     *
     * @return The payload.
     */
    public com.google.protobuf.Struct getPayload() {
      if (payloadBuilder_ == null) {
        return payload_ == null ? com.google.protobuf.Struct.getDefaultInstance() : payload_;
      } else {
        return payloadBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * This field can be used to pass custom data to your webhook.
     * Arbitrary JSON objects are supported.
     * If supplied, the value is used to populate the
     * `WebhookRequest.original_detect_intent_request.payload`
     * field sent to your webhook.
     * </pre>
     *
     * <code>.google.protobuf.Struct payload = 6;</code>
     */
    public Builder setPayload(com.google.protobuf.Struct value) {
      if (payloadBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        payload_ = value;
      } else {
        payloadBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field can be used to pass custom data to your webhook.
     * Arbitrary JSON objects are supported.
     * If supplied, the value is used to populate the
     * `WebhookRequest.original_detect_intent_request.payload`
     * field sent to your webhook.
     * </pre>
     *
     * <code>.google.protobuf.Struct payload = 6;</code>
     */
    public Builder setPayload(com.google.protobuf.Struct.Builder builderForValue) {
      if (payloadBuilder_ == null) {
        payload_ = builderForValue.build();
      } else {
        payloadBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field can be used to pass custom data to your webhook.
     * Arbitrary JSON objects are supported.
     * If supplied, the value is used to populate the
     * `WebhookRequest.original_detect_intent_request.payload`
     * field sent to your webhook.
     * </pre>
     *
     * <code>.google.protobuf.Struct payload = 6;</code>
     */
    public Builder mergePayload(com.google.protobuf.Struct value) {
      if (payloadBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && payload_ != null
            && payload_ != com.google.protobuf.Struct.getDefaultInstance()) {
          getPayloadBuilder().mergeFrom(value);
        } else {
          payload_ = value;
        }
      } else {
        payloadBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field can be used to pass custom data to your webhook.
     * Arbitrary JSON objects are supported.
     * If supplied, the value is used to populate the
     * `WebhookRequest.original_detect_intent_request.payload`
     * field sent to your webhook.
     * </pre>
     *
     * <code>.google.protobuf.Struct payload = 6;</code>
     */
    public Builder clearPayload() {
      bitField0_ = (bitField0_ & ~0x00000020);
      payload_ = null;
      if (payloadBuilder_ != null) {
        payloadBuilder_.dispose();
        payloadBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field can be used to pass custom data to your webhook.
     * Arbitrary JSON objects are supported.
     * If supplied, the value is used to populate the
     * `WebhookRequest.original_detect_intent_request.payload`
     * field sent to your webhook.
     * </pre>
     *
     * <code>.google.protobuf.Struct payload = 6;</code>
     */
    public com.google.protobuf.Struct.Builder getPayloadBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getPayloadFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * This field can be used to pass custom data to your webhook.
     * Arbitrary JSON objects are supported.
     * If supplied, the value is used to populate the
     * `WebhookRequest.original_detect_intent_request.payload`
     * field sent to your webhook.
     * </pre>
     *
     * <code>.google.protobuf.Struct payload = 6;</code>
     */
    public com.google.protobuf.StructOrBuilder getPayloadOrBuilder() {
      if (payloadBuilder_ != null) {
        return payloadBuilder_.getMessageOrBuilder();
      } else {
        return payload_ == null ? com.google.protobuf.Struct.getDefaultInstance() : payload_;
      }
    }
    /**
     *
     *
     * <pre>
     * This field can be used to pass custom data to your webhook.
     * Arbitrary JSON objects are supported.
     * If supplied, the value is used to populate the
     * `WebhookRequest.original_detect_intent_request.payload`
     * field sent to your webhook.
     * </pre>
     *
     * <code>.google.protobuf.Struct payload = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        getPayloadFieldBuilder() {
      if (payloadBuilder_ == null) {
        payloadBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Struct,
                com.google.protobuf.Struct.Builder,
                com.google.protobuf.StructOrBuilder>(
                getPayload(), getParentForChildren(), isClean());
        payload_ = null;
      }
      return payloadBuilder_;
    }

    private com.google.cloud.dialogflow.v2.SentimentAnalysisRequestConfig
        sentimentAnalysisRequestConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2.SentimentAnalysisRequestConfig,
            com.google.cloud.dialogflow.v2.SentimentAnalysisRequestConfig.Builder,
            com.google.cloud.dialogflow.v2.SentimentAnalysisRequestConfigOrBuilder>
        sentimentAnalysisRequestConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configures the type of sentiment analysis to perform. If not
     * provided, sentiment analysis is not performed.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.SentimentAnalysisRequestConfig sentiment_analysis_request_config = 10;
     * </code>
     *
     * @return Whether the sentimentAnalysisRequestConfig field is set.
     */
    public boolean hasSentimentAnalysisRequestConfig() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Configures the type of sentiment analysis to perform. If not
     * provided, sentiment analysis is not performed.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.SentimentAnalysisRequestConfig sentiment_analysis_request_config = 10;
     * </code>
     *
     * @return The sentimentAnalysisRequestConfig.
     */
    public com.google.cloud.dialogflow.v2.SentimentAnalysisRequestConfig
        getSentimentAnalysisRequestConfig() {
      if (sentimentAnalysisRequestConfigBuilder_ == null) {
        return sentimentAnalysisRequestConfig_ == null
            ? com.google.cloud.dialogflow.v2.SentimentAnalysisRequestConfig.getDefaultInstance()
            : sentimentAnalysisRequestConfig_;
      } else {
        return sentimentAnalysisRequestConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configures the type of sentiment analysis to perform. If not
     * provided, sentiment analysis is not performed.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.SentimentAnalysisRequestConfig sentiment_analysis_request_config = 10;
     * </code>
     */
    public Builder setSentimentAnalysisRequestConfig(
        com.google.cloud.dialogflow.v2.SentimentAnalysisRequestConfig value) {
      if (sentimentAnalysisRequestConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        sentimentAnalysisRequestConfig_ = value;
      } else {
        sentimentAnalysisRequestConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configures the type of sentiment analysis to perform. If not
     * provided, sentiment analysis is not performed.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.SentimentAnalysisRequestConfig sentiment_analysis_request_config = 10;
     * </code>
     */
    public Builder setSentimentAnalysisRequestConfig(
        com.google.cloud.dialogflow.v2.SentimentAnalysisRequestConfig.Builder builderForValue) {
      if (sentimentAnalysisRequestConfigBuilder_ == null) {
        sentimentAnalysisRequestConfig_ = builderForValue.build();
      } else {
        sentimentAnalysisRequestConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configures the type of sentiment analysis to perform. If not
     * provided, sentiment analysis is not performed.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.SentimentAnalysisRequestConfig sentiment_analysis_request_config = 10;
     * </code>
     */
    public Builder mergeSentimentAnalysisRequestConfig(
        com.google.cloud.dialogflow.v2.SentimentAnalysisRequestConfig value) {
      if (sentimentAnalysisRequestConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && sentimentAnalysisRequestConfig_ != null
            && sentimentAnalysisRequestConfig_
                != com.google.cloud.dialogflow.v2.SentimentAnalysisRequestConfig
                    .getDefaultInstance()) {
          getSentimentAnalysisRequestConfigBuilder().mergeFrom(value);
        } else {
          sentimentAnalysisRequestConfig_ = value;
        }
      } else {
        sentimentAnalysisRequestConfigBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configures the type of sentiment analysis to perform. If not
     * provided, sentiment analysis is not performed.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.SentimentAnalysisRequestConfig sentiment_analysis_request_config = 10;
     * </code>
     */
    public Builder clearSentimentAnalysisRequestConfig() {
      bitField0_ = (bitField0_ & ~0x00000040);
      sentimentAnalysisRequestConfig_ = null;
      if (sentimentAnalysisRequestConfigBuilder_ != null) {
        sentimentAnalysisRequestConfigBuilder_.dispose();
        sentimentAnalysisRequestConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configures the type of sentiment analysis to perform. If not
     * provided, sentiment analysis is not performed.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.SentimentAnalysisRequestConfig sentiment_analysis_request_config = 10;
     * </code>
     */
    public com.google.cloud.dialogflow.v2.SentimentAnalysisRequestConfig.Builder
        getSentimentAnalysisRequestConfigBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getSentimentAnalysisRequestConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configures the type of sentiment analysis to perform. If not
     * provided, sentiment analysis is not performed.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.SentimentAnalysisRequestConfig sentiment_analysis_request_config = 10;
     * </code>
     */
    public com.google.cloud.dialogflow.v2.SentimentAnalysisRequestConfigOrBuilder
        getSentimentAnalysisRequestConfigOrBuilder() {
      if (sentimentAnalysisRequestConfigBuilder_ != null) {
        return sentimentAnalysisRequestConfigBuilder_.getMessageOrBuilder();
      } else {
        return sentimentAnalysisRequestConfig_ == null
            ? com.google.cloud.dialogflow.v2.SentimentAnalysisRequestConfig.getDefaultInstance()
            : sentimentAnalysisRequestConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configures the type of sentiment analysis to perform. If not
     * provided, sentiment analysis is not performed.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.SentimentAnalysisRequestConfig sentiment_analysis_request_config = 10;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2.SentimentAnalysisRequestConfig,
            com.google.cloud.dialogflow.v2.SentimentAnalysisRequestConfig.Builder,
            com.google.cloud.dialogflow.v2.SentimentAnalysisRequestConfigOrBuilder>
        getSentimentAnalysisRequestConfigFieldBuilder() {
      if (sentimentAnalysisRequestConfigBuilder_ == null) {
        sentimentAnalysisRequestConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2.SentimentAnalysisRequestConfig,
                com.google.cloud.dialogflow.v2.SentimentAnalysisRequestConfig.Builder,
                com.google.cloud.dialogflow.v2.SentimentAnalysisRequestConfigOrBuilder>(
                getSentimentAnalysisRequestConfig(), getParentForChildren(), isClean());
        sentimentAnalysisRequestConfig_ = null;
      }
      return sentimentAnalysisRequestConfigBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> webhookHeaders_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetWebhookHeaders() {
      if (webhookHeaders_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            WebhookHeadersDefaultEntryHolder.defaultEntry);
      }
      return webhookHeaders_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableWebhookHeaders() {
      if (webhookHeaders_ == null) {
        webhookHeaders_ =
            com.google.protobuf.MapField.newMapField(WebhookHeadersDefaultEntryHolder.defaultEntry);
      }
      if (!webhookHeaders_.isMutable()) {
        webhookHeaders_ = webhookHeaders_.copy();
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return webhookHeaders_;
    }

    public int getWebhookHeadersCount() {
      return internalGetWebhookHeaders().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * This field can be used to pass HTTP headers for a webhook
     * call. These headers will be sent to webhook along with the headers that
     * have been configured through the Dialogflow web console. The headers
     * defined within this field will overwrite the headers configured through the
     * Dialogflow console if there is a conflict. Header names are
     * case-insensitive. Google's specified headers are not allowed. Including:
     * "Host", "Content-Length", "Connection", "From", "User-Agent",
     * "Accept-Encoding", "If-Modified-Since", "If-None-Match", "X-Forwarded-For",
     * etc.
     * </pre>
     *
     * <code>map&lt;string, string&gt; webhook_headers = 14;</code>
     */
    @java.lang.Override
    public boolean containsWebhookHeaders(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetWebhookHeaders().getMap().containsKey(key);
    }
    /** Use {@link #getWebhookHeadersMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getWebhookHeaders() {
      return getWebhookHeadersMap();
    }
    /**
     *
     *
     * <pre>
     * This field can be used to pass HTTP headers for a webhook
     * call. These headers will be sent to webhook along with the headers that
     * have been configured through the Dialogflow web console. The headers
     * defined within this field will overwrite the headers configured through the
     * Dialogflow console if there is a conflict. Header names are
     * case-insensitive. Google's specified headers are not allowed. Including:
     * "Host", "Content-Length", "Connection", "From", "User-Agent",
     * "Accept-Encoding", "If-Modified-Since", "If-None-Match", "X-Forwarded-For",
     * etc.
     * </pre>
     *
     * <code>map&lt;string, string&gt; webhook_headers = 14;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getWebhookHeadersMap() {
      return internalGetWebhookHeaders().getMap();
    }
    /**
     *
     *
     * <pre>
     * This field can be used to pass HTTP headers for a webhook
     * call. These headers will be sent to webhook along with the headers that
     * have been configured through the Dialogflow web console. The headers
     * defined within this field will overwrite the headers configured through the
     * Dialogflow console if there is a conflict. Header names are
     * case-insensitive. Google's specified headers are not allowed. Including:
     * "Host", "Content-Length", "Connection", "From", "User-Agent",
     * "Accept-Encoding", "If-Modified-Since", "If-None-Match", "X-Forwarded-For",
     * etc.
     * </pre>
     *
     * <code>map&lt;string, string&gt; webhook_headers = 14;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getWebhookHeadersOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetWebhookHeaders().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * This field can be used to pass HTTP headers for a webhook
     * call. These headers will be sent to webhook along with the headers that
     * have been configured through the Dialogflow web console. The headers
     * defined within this field will overwrite the headers configured through the
     * Dialogflow console if there is a conflict. Header names are
     * case-insensitive. Google's specified headers are not allowed. Including:
     * "Host", "Content-Length", "Connection", "From", "User-Agent",
     * "Accept-Encoding", "If-Modified-Since", "If-None-Match", "X-Forwarded-For",
     * etc.
     * </pre>
     *
     * <code>map&lt;string, string&gt; webhook_headers = 14;</code>
     */
    @java.lang.Override
    public java.lang.String getWebhookHeadersOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetWebhookHeaders().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearWebhookHeaders() {
      bitField0_ = (bitField0_ & ~0x00000080);
      internalGetMutableWebhookHeaders().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field can be used to pass HTTP headers for a webhook
     * call. These headers will be sent to webhook along with the headers that
     * have been configured through the Dialogflow web console. The headers
     * defined within this field will overwrite the headers configured through the
     * Dialogflow console if there is a conflict. Header names are
     * case-insensitive. Google's specified headers are not allowed. Including:
     * "Host", "Content-Length", "Connection", "From", "User-Agent",
     * "Accept-Encoding", "If-Modified-Since", "If-None-Match", "X-Forwarded-For",
     * etc.
     * </pre>
     *
     * <code>map&lt;string, string&gt; webhook_headers = 14;</code>
     */
    public Builder removeWebhookHeaders(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableWebhookHeaders().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableWebhookHeaders() {
      bitField0_ |= 0x00000080;
      return internalGetMutableWebhookHeaders().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * This field can be used to pass HTTP headers for a webhook
     * call. These headers will be sent to webhook along with the headers that
     * have been configured through the Dialogflow web console. The headers
     * defined within this field will overwrite the headers configured through the
     * Dialogflow console if there is a conflict. Header names are
     * case-insensitive. Google's specified headers are not allowed. Including:
     * "Host", "Content-Length", "Connection", "From", "User-Agent",
     * "Accept-Encoding", "If-Modified-Since", "If-None-Match", "X-Forwarded-For",
     * etc.
     * </pre>
     *
     * <code>map&lt;string, string&gt; webhook_headers = 14;</code>
     */
    public Builder putWebhookHeaders(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableWebhookHeaders().getMutableMap().put(key, value);
      bitField0_ |= 0x00000080;
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field can be used to pass HTTP headers for a webhook
     * call. These headers will be sent to webhook along with the headers that
     * have been configured through the Dialogflow web console. The headers
     * defined within this field will overwrite the headers configured through the
     * Dialogflow console if there is a conflict. Header names are
     * case-insensitive. Google's specified headers are not allowed. Including:
     * "Host", "Content-Length", "Connection", "From", "User-Agent",
     * "Accept-Encoding", "If-Modified-Since", "If-None-Match", "X-Forwarded-For",
     * etc.
     * </pre>
     *
     * <code>map&lt;string, string&gt; webhook_headers = 14;</code>
     */
    public Builder putAllWebhookHeaders(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableWebhookHeaders().getMutableMap().putAll(values);
      bitField0_ |= 0x00000080;
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2.QueryParameters)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2.QueryParameters)
  private static final com.google.cloud.dialogflow.v2.QueryParameters DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2.QueryParameters();
  }

  public static com.google.cloud.dialogflow.v2.QueryParameters getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<QueryParameters> PARSER =
      new com.google.protobuf.AbstractParser<QueryParameters>() {
        @java.lang.Override
        public QueryParameters parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<QueryParameters> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<QueryParameters> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.v2.QueryParameters getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
