/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ConversationModelName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_CONVERSATION_MODEL = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/conversationModels/{conversation_model}");
    private static final PathTemplate PROJECT_CONVERSATION_MODEL = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/conversationModels/{conversation_model}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String location;
    private final String conversationModel;

    @Deprecated
    protected ConversationModelName() {
        this.project = null;
        this.location = null;
        this.conversationModel = null;
    }

    private ConversationModelName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.conversationModel = (String)Preconditions.checkNotNull((Object)builder.getConversationModel());
        this.pathTemplate = PROJECT_LOCATION_CONVERSATION_MODEL;
    }

    private ConversationModelName(ProjectConversationModelBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.conversationModel = (String)Preconditions.checkNotNull((Object)builder.getConversationModel());
        this.location = null;
        this.pathTemplate = PROJECT_CONVERSATION_MODEL;
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getConversationModel() {
        return this.conversationModel;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static Builder newProjectLocationConversationModelBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static ProjectConversationModelBuilder newProjectConversationModelBuilder() {
        return new ProjectConversationModelBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ConversationModelName of(String project, String location, String conversationModel) {
        return ConversationModelName.newBuilder().setProject(project).setLocation(location).setConversationModel(conversationModel).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static ConversationModelName ofProjectLocationConversationModelName(String project, String location, String conversationModel) {
        return ConversationModelName.newBuilder().setProject(project).setLocation(location).setConversationModel(conversationModel).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static ConversationModelName ofProjectConversationModelName(String project, String conversationModel) {
        return ConversationModelName.newProjectConversationModelBuilder().setProject(project).setConversationModel(conversationModel).build();
    }

    public static String format(String project, String location, String conversationModel) {
        return ConversationModelName.newBuilder().setProject(project).setLocation(location).setConversationModel(conversationModel).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectLocationConversationModelName(String project, String location, String conversationModel) {
        return ConversationModelName.newBuilder().setProject(project).setLocation(location).setConversationModel(conversationModel).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectConversationModelName(String project, String conversationModel) {
        return ConversationModelName.newProjectConversationModelBuilder().setProject(project).setConversationModel(conversationModel).build().toString();
    }

    public static ConversationModelName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_LOCATION_CONVERSATION_MODEL.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_CONVERSATION_MODEL.match(formattedString);
            return ConversationModelName.ofProjectLocationConversationModelName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("conversation_model"));
        }
        if (PROJECT_CONVERSATION_MODEL.matches(formattedString)) {
            Map matchMap = PROJECT_CONVERSATION_MODEL.match(formattedString);
            return ConversationModelName.ofProjectConversationModelName((String)matchMap.get("project"), (String)matchMap.get("conversation_model"));
        }
        throw new ValidationException("ConversationModelName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<ConversationModelName> parseList(List<String> formattedStrings) {
        ArrayList<ConversationModelName> list = new ArrayList<ConversationModelName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ConversationModelName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ConversationModelName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ConversationModelName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_CONVERSATION_MODEL.matches(formattedString) || PROJECT_CONVERSATION_MODEL.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ConversationModelName conversationModelName = this;
            synchronized (conversationModelName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.conversationModel != null) {
                        fieldMapBuilder.put((Object)"conversation_model", (Object)this.conversationModel);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ConversationModelName that = (ConversationModelName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.conversationModel, that.conversationModel);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.conversationModel);
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class ProjectConversationModelBuilder {
        private String project;
        private String conversationModel;

        protected ProjectConversationModelBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getConversationModel() {
            return this.conversationModel;
        }

        public ProjectConversationModelBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectConversationModelBuilder setConversationModel(String conversationModel) {
            this.conversationModel = conversationModel;
            return this;
        }

        public ConversationModelName build() {
            return new ConversationModelName(this);
        }
    }

    public static class Builder {
        private String project;
        private String location;
        private String conversationModel;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getConversationModel() {
            return this.conversationModel;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setConversationModel(String conversationModel) {
            this.conversationModel = conversationModel;
            return this;
        }

        private Builder(ConversationModelName conversationModelName) {
            Preconditions.checkArgument((boolean)Objects.equals(conversationModelName.pathTemplate, PROJECT_LOCATION_CONVERSATION_MODEL), (Object)"toBuilder is only supported when ConversationModelName has the pattern of projects/{project}/locations/{location}/conversationModels/{conversation_model}");
            this.project = conversationModelName.project;
            this.location = conversationModelName.location;
            this.conversationModel = conversationModelName.conversationModel;
        }

        public ConversationModelName build() {
            return new ConversationModelName(this);
        }
    }
}

