/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/v2/conversation.proto

package com.google.cloud.dialogflow.v2;

/**
 *
 *
 * <pre>
 * The request message for
 * [Conversations.GenerateStatelessSummary][google.cloud.dialogflow.v2.Conversations.GenerateStatelessSummary].
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest}
 */
public final class GenerateStatelessSummaryRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest)
    GenerateStatelessSummaryRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use GenerateStatelessSummaryRequest.newBuilder() to construct.
  private GenerateStatelessSummaryRequest(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private GenerateStatelessSummaryRequest() {
    latestMessage_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new GenerateStatelessSummaryRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.v2.ConversationProto
        .internal_static_google_cloud_dialogflow_v2_GenerateStatelessSummaryRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.v2.ConversationProto
        .internal_static_google_cloud_dialogflow_v2_GenerateStatelessSummaryRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.class,
            com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.Builder.class);
  }

  public interface MinimalConversationOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.MinimalConversation)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The messages that the Summary will be generated from. It is
     * expected that this message content is already redacted and does not
     * contain any PII. Required fields: {content, language_code, participant,
     * participant_role} Optional fields: {send_time} If send_time is not
     * provided, then the messages must be provided in chronological order.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.Message messages = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    java.util.List<com.google.cloud.dialogflow.v2.Message> getMessagesList();
    /**
     *
     *
     * <pre>
     * Required. The messages that the Summary will be generated from. It is
     * expected that this message content is already redacted and does not
     * contain any PII. Required fields: {content, language_code, participant,
     * participant_role} Optional fields: {send_time} If send_time is not
     * provided, then the messages must be provided in chronological order.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.Message messages = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.cloud.dialogflow.v2.Message getMessages(int index);
    /**
     *
     *
     * <pre>
     * Required. The messages that the Summary will be generated from. It is
     * expected that this message content is already redacted and does not
     * contain any PII. Required fields: {content, language_code, participant,
     * participant_role} Optional fields: {send_time} If send_time is not
     * provided, then the messages must be provided in chronological order.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.Message messages = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    int getMessagesCount();
    /**
     *
     *
     * <pre>
     * Required. The messages that the Summary will be generated from. It is
     * expected that this message content is already redacted and does not
     * contain any PII. Required fields: {content, language_code, participant,
     * participant_role} Optional fields: {send_time} If send_time is not
     * provided, then the messages must be provided in chronological order.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.Message messages = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    java.util.List<? extends com.google.cloud.dialogflow.v2.MessageOrBuilder>
        getMessagesOrBuilderList();
    /**
     *
     *
     * <pre>
     * Required. The messages that the Summary will be generated from. It is
     * expected that this message content is already redacted and does not
     * contain any PII. Required fields: {content, language_code, participant,
     * participant_role} Optional fields: {send_time} If send_time is not
     * provided, then the messages must be provided in chronological order.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.Message messages = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.cloud.dialogflow.v2.MessageOrBuilder getMessagesOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * Required. The parent resource to charge for the Summary's generation.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;`.
     * </pre>
     *
     * <code>
     * string parent = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    java.lang.String getParent();
    /**
     *
     *
     * <pre>
     * Required. The parent resource to charge for the Summary's generation.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;`.
     * </pre>
     *
     * <code>
     * string parent = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    com.google.protobuf.ByteString getParentBytes();
  }
  /**
   *
   *
   * <pre>
   * The minimum amount of information required to generate a Summary without
   * having a Conversation resource created.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.MinimalConversation}
   */
  public static final class MinimalConversation extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.MinimalConversation)
      MinimalConversationOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use MinimalConversation.newBuilder() to construct.
    private MinimalConversation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private MinimalConversation() {
      messages_ = java.util.Collections.emptyList();
      parent_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new MinimalConversation();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2.ConversationProto
          .internal_static_google_cloud_dialogflow_v2_GenerateStatelessSummaryRequest_MinimalConversation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2.ConversationProto
          .internal_static_google_cloud_dialogflow_v2_GenerateStatelessSummaryRequest_MinimalConversation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.MinimalConversation
                  .class,
              com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.MinimalConversation
                  .Builder.class);
    }

    public static final int MESSAGES_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.dialogflow.v2.Message> messages_;
    /**
     *
     *
     * <pre>
     * Required. The messages that the Summary will be generated from. It is
     * expected that this message content is already redacted and does not
     * contain any PII. Required fields: {content, language_code, participant,
     * participant_role} Optional fields: {send_time} If send_time is not
     * provided, then the messages must be provided in chronological order.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.Message messages = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.dialogflow.v2.Message> getMessagesList() {
      return messages_;
    }
    /**
     *
     *
     * <pre>
     * Required. The messages that the Summary will be generated from. It is
     * expected that this message content is already redacted and does not
     * contain any PII. Required fields: {content, language_code, participant,
     * participant_role} Optional fields: {send_time} If send_time is not
     * provided, then the messages must be provided in chronological order.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.Message messages = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.cloud.dialogflow.v2.MessageOrBuilder>
        getMessagesOrBuilderList() {
      return messages_;
    }
    /**
     *
     *
     * <pre>
     * Required. The messages that the Summary will be generated from. It is
     * expected that this message content is already redacted and does not
     * contain any PII. Required fields: {content, language_code, participant,
     * participant_role} Optional fields: {send_time} If send_time is not
     * provided, then the messages must be provided in chronological order.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.Message messages = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public int getMessagesCount() {
      return messages_.size();
    }
    /**
     *
     *
     * <pre>
     * Required. The messages that the Summary will be generated from. It is
     * expected that this message content is already redacted and does not
     * contain any PII. Required fields: {content, language_code, participant,
     * participant_role} Optional fields: {send_time} If send_time is not
     * provided, then the messages must be provided in chronological order.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.Message messages = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2.Message getMessages(int index) {
      return messages_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Required. The messages that the Summary will be generated from. It is
     * expected that this message content is already redacted and does not
     * contain any PII. Required fields: {content, language_code, participant,
     * participant_role} Optional fields: {send_time} If send_time is not
     * provided, then the messages must be provided in chronological order.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.Message messages = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2.MessageOrBuilder getMessagesOrBuilder(int index) {
      return messages_.get(index);
    }

    public static final int PARENT_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. The parent resource to charge for the Summary's generation.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;`.
     * </pre>
     *
     * <code>
     * string parent = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    @java.lang.Override
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The parent resource to charge for the Summary's generation.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;`.
     * </pre>
     *
     * <code>
     * string parent = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < messages_.size(); i++) {
        output.writeMessage(1, messages_.get(i));
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, parent_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < messages_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, messages_.get(i));
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, parent_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.MinimalConversation)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.MinimalConversation other =
          (com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.MinimalConversation) obj;

      if (!getMessagesList().equals(other.getMessagesList())) return false;
      if (!getParent().equals(other.getParent())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getMessagesCount() > 0) {
        hash = (37 * hash) + MESSAGES_FIELD_NUMBER;
        hash = (53 * hash) + getMessagesList().hashCode();
      }
      hash = (37 * hash) + PARENT_FIELD_NUMBER;
      hash = (53 * hash) + getParent().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.MinimalConversation
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.MinimalConversation
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.MinimalConversation
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.MinimalConversation
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.MinimalConversation
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.MinimalConversation
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.MinimalConversation
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.MinimalConversation
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.MinimalConversation
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.MinimalConversation
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.MinimalConversation
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.MinimalConversation
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.MinimalConversation
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The minimum amount of information required to generate a Summary without
     * having a Conversation resource created.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.MinimalConversation}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.MinimalConversation)
        com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest
            .MinimalConversationOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.v2.ConversationProto
            .internal_static_google_cloud_dialogflow_v2_GenerateStatelessSummaryRequest_MinimalConversation_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.v2.ConversationProto
            .internal_static_google_cloud_dialogflow_v2_GenerateStatelessSummaryRequest_MinimalConversation_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.MinimalConversation
                    .class,
                com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.MinimalConversation
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.MinimalConversation.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (messagesBuilder_ == null) {
          messages_ = java.util.Collections.emptyList();
        } else {
          messages_ = null;
          messagesBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        parent_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.v2.ConversationProto
            .internal_static_google_cloud_dialogflow_v2_GenerateStatelessSummaryRequest_MinimalConversation_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.MinimalConversation
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.MinimalConversation
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.MinimalConversation
          build() {
        com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.MinimalConversation result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.MinimalConversation
          buildPartial() {
        com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.MinimalConversation result =
            new com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.MinimalConversation(
                this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.MinimalConversation
              result) {
        if (messagesBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            messages_ = java.util.Collections.unmodifiableList(messages_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.messages_ = messages_;
        } else {
          result.messages_ = messagesBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.MinimalConversation
              result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.parent_ = parent_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.MinimalConversation) {
          return mergeFrom(
              (com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.MinimalConversation)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.MinimalConversation
              other) {
        if (other
            == com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.MinimalConversation
                .getDefaultInstance()) return this;
        if (messagesBuilder_ == null) {
          if (!other.messages_.isEmpty()) {
            if (messages_.isEmpty()) {
              messages_ = other.messages_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureMessagesIsMutable();
              messages_.addAll(other.messages_);
            }
            onChanged();
          }
        } else {
          if (!other.messages_.isEmpty()) {
            if (messagesBuilder_.isEmpty()) {
              messagesBuilder_.dispose();
              messagesBuilder_ = null;
              messages_ = other.messages_;
              bitField0_ = (bitField0_ & ~0x00000001);
              messagesBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getMessagesFieldBuilder()
                      : null;
            } else {
              messagesBuilder_.addAllMessages(other.messages_);
            }
          }
        }
        if (!other.getParent().isEmpty()) {
          parent_ = other.parent_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.cloud.dialogflow.v2.Message m =
                      input.readMessage(
                          com.google.cloud.dialogflow.v2.Message.parser(), extensionRegistry);
                  if (messagesBuilder_ == null) {
                    ensureMessagesIsMutable();
                    messages_.add(m);
                  } else {
                    messagesBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              case 18:
                {
                  parent_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<com.google.cloud.dialogflow.v2.Message> messages_ =
          java.util.Collections.emptyList();

      private void ensureMessagesIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          messages_ = new java.util.ArrayList<com.google.cloud.dialogflow.v2.Message>(messages_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.dialogflow.v2.Message,
              com.google.cloud.dialogflow.v2.Message.Builder,
              com.google.cloud.dialogflow.v2.MessageOrBuilder>
          messagesBuilder_;

      /**
       *
       *
       * <pre>
       * Required. The messages that the Summary will be generated from. It is
       * expected that this message content is already redacted and does not
       * contain any PII. Required fields: {content, language_code, participant,
       * participant_role} Optional fields: {send_time} If send_time is not
       * provided, then the messages must be provided in chronological order.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Message messages = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public java.util.List<com.google.cloud.dialogflow.v2.Message> getMessagesList() {
        if (messagesBuilder_ == null) {
          return java.util.Collections.unmodifiableList(messages_);
        } else {
          return messagesBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The messages that the Summary will be generated from. It is
       * expected that this message content is already redacted and does not
       * contain any PII. Required fields: {content, language_code, participant,
       * participant_role} Optional fields: {send_time} If send_time is not
       * provided, then the messages must be provided in chronological order.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Message messages = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public int getMessagesCount() {
        if (messagesBuilder_ == null) {
          return messages_.size();
        } else {
          return messagesBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The messages that the Summary will be generated from. It is
       * expected that this message content is already redacted and does not
       * contain any PII. Required fields: {content, language_code, participant,
       * participant_role} Optional fields: {send_time} If send_time is not
       * provided, then the messages must be provided in chronological order.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Message messages = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.dialogflow.v2.Message getMessages(int index) {
        if (messagesBuilder_ == null) {
          return messages_.get(index);
        } else {
          return messagesBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The messages that the Summary will be generated from. It is
       * expected that this message content is already redacted and does not
       * contain any PII. Required fields: {content, language_code, participant,
       * participant_role} Optional fields: {send_time} If send_time is not
       * provided, then the messages must be provided in chronological order.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Message messages = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setMessages(int index, com.google.cloud.dialogflow.v2.Message value) {
        if (messagesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureMessagesIsMutable();
          messages_.set(index, value);
          onChanged();
        } else {
          messagesBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The messages that the Summary will be generated from. It is
       * expected that this message content is already redacted and does not
       * contain any PII. Required fields: {content, language_code, participant,
       * participant_role} Optional fields: {send_time} If send_time is not
       * provided, then the messages must be provided in chronological order.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Message messages = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setMessages(
          int index, com.google.cloud.dialogflow.v2.Message.Builder builderForValue) {
        if (messagesBuilder_ == null) {
          ensureMessagesIsMutable();
          messages_.set(index, builderForValue.build());
          onChanged();
        } else {
          messagesBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The messages that the Summary will be generated from. It is
       * expected that this message content is already redacted and does not
       * contain any PII. Required fields: {content, language_code, participant,
       * participant_role} Optional fields: {send_time} If send_time is not
       * provided, then the messages must be provided in chronological order.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Message messages = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addMessages(com.google.cloud.dialogflow.v2.Message value) {
        if (messagesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureMessagesIsMutable();
          messages_.add(value);
          onChanged();
        } else {
          messagesBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The messages that the Summary will be generated from. It is
       * expected that this message content is already redacted and does not
       * contain any PII. Required fields: {content, language_code, participant,
       * participant_role} Optional fields: {send_time} If send_time is not
       * provided, then the messages must be provided in chronological order.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Message messages = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addMessages(int index, com.google.cloud.dialogflow.v2.Message value) {
        if (messagesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureMessagesIsMutable();
          messages_.add(index, value);
          onChanged();
        } else {
          messagesBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The messages that the Summary will be generated from. It is
       * expected that this message content is already redacted and does not
       * contain any PII. Required fields: {content, language_code, participant,
       * participant_role} Optional fields: {send_time} If send_time is not
       * provided, then the messages must be provided in chronological order.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Message messages = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addMessages(com.google.cloud.dialogflow.v2.Message.Builder builderForValue) {
        if (messagesBuilder_ == null) {
          ensureMessagesIsMutable();
          messages_.add(builderForValue.build());
          onChanged();
        } else {
          messagesBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The messages that the Summary will be generated from. It is
       * expected that this message content is already redacted and does not
       * contain any PII. Required fields: {content, language_code, participant,
       * participant_role} Optional fields: {send_time} If send_time is not
       * provided, then the messages must be provided in chronological order.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Message messages = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addMessages(
          int index, com.google.cloud.dialogflow.v2.Message.Builder builderForValue) {
        if (messagesBuilder_ == null) {
          ensureMessagesIsMutable();
          messages_.add(index, builderForValue.build());
          onChanged();
        } else {
          messagesBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The messages that the Summary will be generated from. It is
       * expected that this message content is already redacted and does not
       * contain any PII. Required fields: {content, language_code, participant,
       * participant_role} Optional fields: {send_time} If send_time is not
       * provided, then the messages must be provided in chronological order.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Message messages = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addAllMessages(
          java.lang.Iterable<? extends com.google.cloud.dialogflow.v2.Message> values) {
        if (messagesBuilder_ == null) {
          ensureMessagesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, messages_);
          onChanged();
        } else {
          messagesBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The messages that the Summary will be generated from. It is
       * expected that this message content is already redacted and does not
       * contain any PII. Required fields: {content, language_code, participant,
       * participant_role} Optional fields: {send_time} If send_time is not
       * provided, then the messages must be provided in chronological order.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Message messages = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearMessages() {
        if (messagesBuilder_ == null) {
          messages_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          messagesBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The messages that the Summary will be generated from. It is
       * expected that this message content is already redacted and does not
       * contain any PII. Required fields: {content, language_code, participant,
       * participant_role} Optional fields: {send_time} If send_time is not
       * provided, then the messages must be provided in chronological order.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Message messages = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder removeMessages(int index) {
        if (messagesBuilder_ == null) {
          ensureMessagesIsMutable();
          messages_.remove(index);
          onChanged();
        } else {
          messagesBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The messages that the Summary will be generated from. It is
       * expected that this message content is already redacted and does not
       * contain any PII. Required fields: {content, language_code, participant,
       * participant_role} Optional fields: {send_time} If send_time is not
       * provided, then the messages must be provided in chronological order.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Message messages = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.dialogflow.v2.Message.Builder getMessagesBuilder(int index) {
        return getMessagesFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Required. The messages that the Summary will be generated from. It is
       * expected that this message content is already redacted and does not
       * contain any PII. Required fields: {content, language_code, participant,
       * participant_role} Optional fields: {send_time} If send_time is not
       * provided, then the messages must be provided in chronological order.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Message messages = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.dialogflow.v2.MessageOrBuilder getMessagesOrBuilder(int index) {
        if (messagesBuilder_ == null) {
          return messages_.get(index);
        } else {
          return messagesBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The messages that the Summary will be generated from. It is
       * expected that this message content is already redacted and does not
       * contain any PII. Required fields: {content, language_code, participant,
       * participant_role} Optional fields: {send_time} If send_time is not
       * provided, then the messages must be provided in chronological order.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Message messages = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public java.util.List<? extends com.google.cloud.dialogflow.v2.MessageOrBuilder>
          getMessagesOrBuilderList() {
        if (messagesBuilder_ != null) {
          return messagesBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(messages_);
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The messages that the Summary will be generated from. It is
       * expected that this message content is already redacted and does not
       * contain any PII. Required fields: {content, language_code, participant,
       * participant_role} Optional fields: {send_time} If send_time is not
       * provided, then the messages must be provided in chronological order.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Message messages = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.dialogflow.v2.Message.Builder addMessagesBuilder() {
        return getMessagesFieldBuilder()
            .addBuilder(com.google.cloud.dialogflow.v2.Message.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Required. The messages that the Summary will be generated from. It is
       * expected that this message content is already redacted and does not
       * contain any PII. Required fields: {content, language_code, participant,
       * participant_role} Optional fields: {send_time} If send_time is not
       * provided, then the messages must be provided in chronological order.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Message messages = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.dialogflow.v2.Message.Builder addMessagesBuilder(int index) {
        return getMessagesFieldBuilder()
            .addBuilder(index, com.google.cloud.dialogflow.v2.Message.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Required. The messages that the Summary will be generated from. It is
       * expected that this message content is already redacted and does not
       * contain any PII. Required fields: {content, language_code, participant,
       * participant_role} Optional fields: {send_time} If send_time is not
       * provided, then the messages must be provided in chronological order.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2.Message messages = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public java.util.List<com.google.cloud.dialogflow.v2.Message.Builder>
          getMessagesBuilderList() {
        return getMessagesFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.dialogflow.v2.Message,
              com.google.cloud.dialogflow.v2.Message.Builder,
              com.google.cloud.dialogflow.v2.MessageOrBuilder>
          getMessagesFieldBuilder() {
        if (messagesBuilder_ == null) {
          messagesBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.dialogflow.v2.Message,
                  com.google.cloud.dialogflow.v2.Message.Builder,
                  com.google.cloud.dialogflow.v2.MessageOrBuilder>(
                  messages_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
          messages_ = null;
        }
        return messagesBuilder_;
      }

      private java.lang.Object parent_ = "";
      /**
       *
       *
       * <pre>
       * Required. The parent resource to charge for the Summary's generation.
       * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;`.
       * </pre>
       *
       * <code>
       * string parent = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The parent.
       */
      public java.lang.String getParent() {
        java.lang.Object ref = parent_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          parent_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The parent resource to charge for the Summary's generation.
       * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;`.
       * </pre>
       *
       * <code>
       * string parent = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for parent.
       */
      public com.google.protobuf.ByteString getParentBytes() {
        java.lang.Object ref = parent_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          parent_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The parent resource to charge for the Summary's generation.
       * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;`.
       * </pre>
       *
       * <code>
       * string parent = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The parent to set.
       * @return This builder for chaining.
       */
      public Builder setParent(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        parent_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The parent resource to charge for the Summary's generation.
       * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;`.
       * </pre>
       *
       * <code>
       * string parent = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearParent() {
        parent_ = getDefaultInstance().getParent();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The parent resource to charge for the Summary's generation.
       * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;`.
       * </pre>
       *
       * <code>
       * string parent = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The bytes for parent to set.
       * @return This builder for chaining.
       */
      public Builder setParentBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        parent_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.MinimalConversation)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.MinimalConversation)
    private static final com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest
            .MinimalConversation
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.MinimalConversation();
    }

    public static com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.MinimalConversation
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<MinimalConversation> PARSER =
        new com.google.protobuf.AbstractParser<MinimalConversation>() {
          @java.lang.Override
          public MinimalConversation parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<MinimalConversation> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<MinimalConversation> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.MinimalConversation
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int STATELESS_CONVERSATION_FIELD_NUMBER = 1;
  private com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.MinimalConversation
      statelessConversation_;
  /**
   *
   *
   * <pre>
   * Required. The conversation to suggest a summary for.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.MinimalConversation stateless_conversation = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the statelessConversation field is set.
   */
  @java.lang.Override
  public boolean hasStatelessConversation() {
    return statelessConversation_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. The conversation to suggest a summary for.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.MinimalConversation stateless_conversation = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The statelessConversation.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.MinimalConversation
      getStatelessConversation() {
    return statelessConversation_ == null
        ? com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.MinimalConversation
            .getDefaultInstance()
        : statelessConversation_;
  }
  /**
   *
   *
   * <pre>
   * Required. The conversation to suggest a summary for.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.MinimalConversation stateless_conversation = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.MinimalConversationOrBuilder
      getStatelessConversationOrBuilder() {
    return statelessConversation_ == null
        ? com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.MinimalConversation
            .getDefaultInstance()
        : statelessConversation_;
  }

  public static final int CONVERSATION_PROFILE_FIELD_NUMBER = 2;
  private com.google.cloud.dialogflow.v2.ConversationProfile conversationProfile_;
  /**
   *
   *
   * <pre>
   * Required. A ConversationProfile containing information required for Summary
   * generation.
   * Required fields: {language_code, security_settings}
   * Optional fields: {agent_assistant_config}
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2.ConversationProfile conversation_profile = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the conversationProfile field is set.
   */
  @java.lang.Override
  public boolean hasConversationProfile() {
    return conversationProfile_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. A ConversationProfile containing information required for Summary
   * generation.
   * Required fields: {language_code, security_settings}
   * Optional fields: {agent_assistant_config}
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2.ConversationProfile conversation_profile = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The conversationProfile.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.ConversationProfile getConversationProfile() {
    return conversationProfile_ == null
        ? com.google.cloud.dialogflow.v2.ConversationProfile.getDefaultInstance()
        : conversationProfile_;
  }
  /**
   *
   *
   * <pre>
   * Required. A ConversationProfile containing information required for Summary
   * generation.
   * Required fields: {language_code, security_settings}
   * Optional fields: {agent_assistant_config}
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2.ConversationProfile conversation_profile = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.ConversationProfileOrBuilder
      getConversationProfileOrBuilder() {
    return conversationProfile_ == null
        ? com.google.cloud.dialogflow.v2.ConversationProfile.getDefaultInstance()
        : conversationProfile_;
  }

  public static final int LATEST_MESSAGE_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object latestMessage_ = "";
  /**
   *
   *
   * <pre>
   * The name of the latest conversation message used as context for
   * generating a Summary. If empty, the latest message of the conversation will
   * be used. The format is specific to the user and the names of the messages
   * provided.
   * </pre>
   *
   * <code>string latest_message = 3 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The latestMessage.
   */
  @java.lang.Override
  public java.lang.String getLatestMessage() {
    java.lang.Object ref = latestMessage_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      latestMessage_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of the latest conversation message used as context for
   * generating a Summary. If empty, the latest message of the conversation will
   * be used. The format is specific to the user and the names of the messages
   * provided.
   * </pre>
   *
   * <code>string latest_message = 3 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for latestMessage.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLatestMessageBytes() {
    java.lang.Object ref = latestMessage_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      latestMessage_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MAX_CONTEXT_SIZE_FIELD_NUMBER = 4;
  private int maxContextSize_ = 0;
  /**
   *
   *
   * <pre>
   * Max number of messages prior to and including
   * [latest_message] to use as context when compiling the
   * suggestion. By default 500 and at most 1000.
   * </pre>
   *
   * <code>int32 max_context_size = 4;</code>
   *
   * @return The maxContextSize.
   */
  @java.lang.Override
  public int getMaxContextSize() {
    return maxContextSize_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (statelessConversation_ != null) {
      output.writeMessage(1, getStatelessConversation());
    }
    if (conversationProfile_ != null) {
      output.writeMessage(2, getConversationProfile());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(latestMessage_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, latestMessage_);
    }
    if (maxContextSize_ != 0) {
      output.writeInt32(4, maxContextSize_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (statelessConversation_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(1, getStatelessConversation());
    }
    if (conversationProfile_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getConversationProfile());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(latestMessage_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, latestMessage_);
    }
    if (maxContextSize_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, maxContextSize_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest other =
        (com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest) obj;

    if (hasStatelessConversation() != other.hasStatelessConversation()) return false;
    if (hasStatelessConversation()) {
      if (!getStatelessConversation().equals(other.getStatelessConversation())) return false;
    }
    if (hasConversationProfile() != other.hasConversationProfile()) return false;
    if (hasConversationProfile()) {
      if (!getConversationProfile().equals(other.getConversationProfile())) return false;
    }
    if (!getLatestMessage().equals(other.getLatestMessage())) return false;
    if (getMaxContextSize() != other.getMaxContextSize()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasStatelessConversation()) {
      hash = (37 * hash) + STATELESS_CONVERSATION_FIELD_NUMBER;
      hash = (53 * hash) + getStatelessConversation().hashCode();
    }
    if (hasConversationProfile()) {
      hash = (37 * hash) + CONVERSATION_PROFILE_FIELD_NUMBER;
      hash = (53 * hash) + getConversationProfile().hashCode();
    }
    hash = (37 * hash) + LATEST_MESSAGE_FIELD_NUMBER;
    hash = (53 * hash) + getLatestMessage().hashCode();
    hash = (37 * hash) + MAX_CONTEXT_SIZE_FIELD_NUMBER;
    hash = (53 * hash) + getMaxContextSize();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The request message for
   * [Conversations.GenerateStatelessSummary][google.cloud.dialogflow.v2.Conversations.GenerateStatelessSummary].
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest)
      com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2.ConversationProto
          .internal_static_google_cloud_dialogflow_v2_GenerateStatelessSummaryRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2.ConversationProto
          .internal_static_google_cloud_dialogflow_v2_GenerateStatelessSummaryRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.class,
              com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      statelessConversation_ = null;
      if (statelessConversationBuilder_ != null) {
        statelessConversationBuilder_.dispose();
        statelessConversationBuilder_ = null;
      }
      conversationProfile_ = null;
      if (conversationProfileBuilder_ != null) {
        conversationProfileBuilder_.dispose();
        conversationProfileBuilder_ = null;
      }
      latestMessage_ = "";
      maxContextSize_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.v2.ConversationProto
          .internal_static_google_cloud_dialogflow_v2_GenerateStatelessSummaryRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest
        getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest build() {
      com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest buildPartial() {
      com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest result =
          new com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.statelessConversation_ =
            statelessConversationBuilder_ == null
                ? statelessConversation_
                : statelessConversationBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.conversationProfile_ =
            conversationProfileBuilder_ == null
                ? conversationProfile_
                : conversationProfileBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.latestMessage_ = latestMessage_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.maxContextSize_ = maxContextSize_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest) {
        return mergeFrom((com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest other) {
      if (other
          == com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.getDefaultInstance())
        return this;
      if (other.hasStatelessConversation()) {
        mergeStatelessConversation(other.getStatelessConversation());
      }
      if (other.hasConversationProfile()) {
        mergeConversationProfile(other.getConversationProfile());
      }
      if (!other.getLatestMessage().isEmpty()) {
        latestMessage_ = other.latestMessage_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.getMaxContextSize() != 0) {
        setMaxContextSize(other.getMaxContextSize());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(
                    getStatelessConversationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(
                    getConversationProfileFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                latestMessage_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 32:
              {
                maxContextSize_ = input.readInt32();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.MinimalConversation
        statelessConversation_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.MinimalConversation,
            com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.MinimalConversation
                .Builder,
            com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest
                .MinimalConversationOrBuilder>
        statelessConversationBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The conversation to suggest a summary for.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.MinimalConversation stateless_conversation = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the statelessConversation field is set.
     */
    public boolean hasStatelessConversation() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. The conversation to suggest a summary for.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.MinimalConversation stateless_conversation = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The statelessConversation.
     */
    public com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.MinimalConversation
        getStatelessConversation() {
      if (statelessConversationBuilder_ == null) {
        return statelessConversation_ == null
            ? com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.MinimalConversation
                .getDefaultInstance()
            : statelessConversation_;
      } else {
        return statelessConversationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The conversation to suggest a summary for.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.MinimalConversation stateless_conversation = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setStatelessConversation(
        com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.MinimalConversation value) {
      if (statelessConversationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        statelessConversation_ = value;
      } else {
        statelessConversationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The conversation to suggest a summary for.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.MinimalConversation stateless_conversation = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setStatelessConversation(
        com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.MinimalConversation.Builder
            builderForValue) {
      if (statelessConversationBuilder_ == null) {
        statelessConversation_ = builderForValue.build();
      } else {
        statelessConversationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The conversation to suggest a summary for.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.MinimalConversation stateless_conversation = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeStatelessConversation(
        com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.MinimalConversation value) {
      if (statelessConversationBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && statelessConversation_ != null
            && statelessConversation_
                != com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest
                    .MinimalConversation.getDefaultInstance()) {
          getStatelessConversationBuilder().mergeFrom(value);
        } else {
          statelessConversation_ = value;
        }
      } else {
        statelessConversationBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The conversation to suggest a summary for.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.MinimalConversation stateless_conversation = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearStatelessConversation() {
      bitField0_ = (bitField0_ & ~0x00000001);
      statelessConversation_ = null;
      if (statelessConversationBuilder_ != null) {
        statelessConversationBuilder_.dispose();
        statelessConversationBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The conversation to suggest a summary for.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.MinimalConversation stateless_conversation = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.MinimalConversation
            .Builder
        getStatelessConversationBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getStatelessConversationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The conversation to suggest a summary for.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.MinimalConversation stateless_conversation = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest
            .MinimalConversationOrBuilder
        getStatelessConversationOrBuilder() {
      if (statelessConversationBuilder_ != null) {
        return statelessConversationBuilder_.getMessageOrBuilder();
      } else {
        return statelessConversation_ == null
            ? com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.MinimalConversation
                .getDefaultInstance()
            : statelessConversation_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The conversation to suggest a summary for.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.MinimalConversation stateless_conversation = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.MinimalConversation,
            com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.MinimalConversation
                .Builder,
            com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest
                .MinimalConversationOrBuilder>
        getStatelessConversationFieldBuilder() {
      if (statelessConversationBuilder_ == null) {
        statelessConversationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.MinimalConversation,
                com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest.MinimalConversation
                    .Builder,
                com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest
                    .MinimalConversationOrBuilder>(
                getStatelessConversation(), getParentForChildren(), isClean());
        statelessConversation_ = null;
      }
      return statelessConversationBuilder_;
    }

    private com.google.cloud.dialogflow.v2.ConversationProfile conversationProfile_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2.ConversationProfile,
            com.google.cloud.dialogflow.v2.ConversationProfile.Builder,
            com.google.cloud.dialogflow.v2.ConversationProfileOrBuilder>
        conversationProfileBuilder_;
    /**
     *
     *
     * <pre>
     * Required. A ConversationProfile containing information required for Summary
     * generation.
     * Required fields: {language_code, security_settings}
     * Optional fields: {agent_assistant_config}
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.ConversationProfile conversation_profile = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the conversationProfile field is set.
     */
    public boolean hasConversationProfile() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. A ConversationProfile containing information required for Summary
     * generation.
     * Required fields: {language_code, security_settings}
     * Optional fields: {agent_assistant_config}
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.ConversationProfile conversation_profile = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The conversationProfile.
     */
    public com.google.cloud.dialogflow.v2.ConversationProfile getConversationProfile() {
      if (conversationProfileBuilder_ == null) {
        return conversationProfile_ == null
            ? com.google.cloud.dialogflow.v2.ConversationProfile.getDefaultInstance()
            : conversationProfile_;
      } else {
        return conversationProfileBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. A ConversationProfile containing information required for Summary
     * generation.
     * Required fields: {language_code, security_settings}
     * Optional fields: {agent_assistant_config}
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.ConversationProfile conversation_profile = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setConversationProfile(
        com.google.cloud.dialogflow.v2.ConversationProfile value) {
      if (conversationProfileBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        conversationProfile_ = value;
      } else {
        conversationProfileBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A ConversationProfile containing information required for Summary
     * generation.
     * Required fields: {language_code, security_settings}
     * Optional fields: {agent_assistant_config}
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.ConversationProfile conversation_profile = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setConversationProfile(
        com.google.cloud.dialogflow.v2.ConversationProfile.Builder builderForValue) {
      if (conversationProfileBuilder_ == null) {
        conversationProfile_ = builderForValue.build();
      } else {
        conversationProfileBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A ConversationProfile containing information required for Summary
     * generation.
     * Required fields: {language_code, security_settings}
     * Optional fields: {agent_assistant_config}
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.ConversationProfile conversation_profile = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeConversationProfile(
        com.google.cloud.dialogflow.v2.ConversationProfile value) {
      if (conversationProfileBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && conversationProfile_ != null
            && conversationProfile_
                != com.google.cloud.dialogflow.v2.ConversationProfile.getDefaultInstance()) {
          getConversationProfileBuilder().mergeFrom(value);
        } else {
          conversationProfile_ = value;
        }
      } else {
        conversationProfileBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A ConversationProfile containing information required for Summary
     * generation.
     * Required fields: {language_code, security_settings}
     * Optional fields: {agent_assistant_config}
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.ConversationProfile conversation_profile = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearConversationProfile() {
      bitField0_ = (bitField0_ & ~0x00000002);
      conversationProfile_ = null;
      if (conversationProfileBuilder_ != null) {
        conversationProfileBuilder_.dispose();
        conversationProfileBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A ConversationProfile containing information required for Summary
     * generation.
     * Required fields: {language_code, security_settings}
     * Optional fields: {agent_assistant_config}
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.ConversationProfile conversation_profile = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.dialogflow.v2.ConversationProfile.Builder
        getConversationProfileBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getConversationProfileFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. A ConversationProfile containing information required for Summary
     * generation.
     * Required fields: {language_code, security_settings}
     * Optional fields: {agent_assistant_config}
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.ConversationProfile conversation_profile = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.dialogflow.v2.ConversationProfileOrBuilder
        getConversationProfileOrBuilder() {
      if (conversationProfileBuilder_ != null) {
        return conversationProfileBuilder_.getMessageOrBuilder();
      } else {
        return conversationProfile_ == null
            ? com.google.cloud.dialogflow.v2.ConversationProfile.getDefaultInstance()
            : conversationProfile_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. A ConversationProfile containing information required for Summary
     * generation.
     * Required fields: {language_code, security_settings}
     * Optional fields: {agent_assistant_config}
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.ConversationProfile conversation_profile = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2.ConversationProfile,
            com.google.cloud.dialogflow.v2.ConversationProfile.Builder,
            com.google.cloud.dialogflow.v2.ConversationProfileOrBuilder>
        getConversationProfileFieldBuilder() {
      if (conversationProfileBuilder_ == null) {
        conversationProfileBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2.ConversationProfile,
                com.google.cloud.dialogflow.v2.ConversationProfile.Builder,
                com.google.cloud.dialogflow.v2.ConversationProfileOrBuilder>(
                getConversationProfile(), getParentForChildren(), isClean());
        conversationProfile_ = null;
      }
      return conversationProfileBuilder_;
    }

    private java.lang.Object latestMessage_ = "";
    /**
     *
     *
     * <pre>
     * The name of the latest conversation message used as context for
     * generating a Summary. If empty, the latest message of the conversation will
     * be used. The format is specific to the user and the names of the messages
     * provided.
     * </pre>
     *
     * <code>string latest_message = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The latestMessage.
     */
    public java.lang.String getLatestMessage() {
      java.lang.Object ref = latestMessage_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        latestMessage_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the latest conversation message used as context for
     * generating a Summary. If empty, the latest message of the conversation will
     * be used. The format is specific to the user and the names of the messages
     * provided.
     * </pre>
     *
     * <code>string latest_message = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for latestMessage.
     */
    public com.google.protobuf.ByteString getLatestMessageBytes() {
      java.lang.Object ref = latestMessage_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        latestMessage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the latest conversation message used as context for
     * generating a Summary. If empty, the latest message of the conversation will
     * be used. The format is specific to the user and the names of the messages
     * provided.
     * </pre>
     *
     * <code>string latest_message = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The latestMessage to set.
     * @return This builder for chaining.
     */
    public Builder setLatestMessage(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      latestMessage_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the latest conversation message used as context for
     * generating a Summary. If empty, the latest message of the conversation will
     * be used. The format is specific to the user and the names of the messages
     * provided.
     * </pre>
     *
     * <code>string latest_message = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLatestMessage() {
      latestMessage_ = getDefaultInstance().getLatestMessage();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the latest conversation message used as context for
     * generating a Summary. If empty, the latest message of the conversation will
     * be used. The format is specific to the user and the names of the messages
     * provided.
     * </pre>
     *
     * <code>string latest_message = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for latestMessage to set.
     * @return This builder for chaining.
     */
    public Builder setLatestMessageBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      latestMessage_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private int maxContextSize_;
    /**
     *
     *
     * <pre>
     * Max number of messages prior to and including
     * [latest_message] to use as context when compiling the
     * suggestion. By default 500 and at most 1000.
     * </pre>
     *
     * <code>int32 max_context_size = 4;</code>
     *
     * @return The maxContextSize.
     */
    @java.lang.Override
    public int getMaxContextSize() {
      return maxContextSize_;
    }
    /**
     *
     *
     * <pre>
     * Max number of messages prior to and including
     * [latest_message] to use as context when compiling the
     * suggestion. By default 500 and at most 1000.
     * </pre>
     *
     * <code>int32 max_context_size = 4;</code>
     *
     * @param value The maxContextSize to set.
     * @return This builder for chaining.
     */
    public Builder setMaxContextSize(int value) {

      maxContextSize_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Max number of messages prior to and including
     * [latest_message] to use as context when compiling the
     * suggestion. By default 500 and at most 1000.
     * </pre>
     *
     * <code>int32 max_context_size = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaxContextSize() {
      bitField0_ = (bitField0_ & ~0x00000008);
      maxContextSize_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest)
  private static final com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest();
  }

  public static com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<GenerateStatelessSummaryRequest> PARSER =
      new com.google.protobuf.AbstractParser<GenerateStatelessSummaryRequest>() {
        @java.lang.Override
        public GenerateStatelessSummaryRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<GenerateStatelessSummaryRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<GenerateStatelessSummaryRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
